"""
Graph Generator Dialogs

"""
__author__ = """Brian Cloteaux (brian.cloteaux@nist.gov)"""
#  Mathematical and Computational Sciences Division
#  National Institute of Standards and Technology,
#  Gaithersburg, MD USA
# 
#  This software was developed at the National Institute of Standards and
#  Technology (NIST) by employees of the Federal Government in the course
#  of their official duties. Pursuant to title 17 Section 105 of the
#  United States Code, this software is not subject to copyright protection
#  and is in the public domain. NIST assumes no responsibility whatsoever for
#  its use by other parties, and makes no guarantees, expressed or implied,
#  about its quality, reliability, or any other characteristic.

import Tkinter
import tkSimpleDialog
import os.path
import networkx as nx

class ErdosRenyiDialog(tkSimpleDialog.Dialog):
    def body(self, master):
        Tkinter.Label(master, text="Number of Nodes:").grid(row=0)
        Tkinter.Label(master, text="Inclusion Probability:").grid(row=1)

        self.e1 = Tkinter.Entry(master)
        self.e2 = Tkinter.Entry(master)

        self.e1.grid(row=0, column=1)
        self.e2.grid(row=1, column=1)
        return self.e1

    def apply(self):
        self.number = int(self.e1.get())
        self.probability = float(self.e2.get())

class WattsStrogatzDialog(tkSimpleDialog.Dialog):
    def body(self, master):
        Tkinter.Label(master, text="Number of Nodes:").grid(row=0)
        Tkinter.Label(master, text="Number Connected Neighbors:").grid(row=1)
        Tkinter.Label(master, text="Rewiring Probability:").grid(row=2)

        self.e1 = Tkinter.Entry(master)
        self.e2 = Tkinter.Entry(master)
        self.e3 = Tkinter.Entry(master)

        self.e1.grid(row=0, column=1)
        self.e2.grid(row=1, column=1)
        self.e3.grid(row=2, column=1)
        return self.e1

    def apply(self):
        self.number = int(self.e1.get())
        self.neighbors = int(self.e2.get())
        self.probability = float(self.e3.get())

class BarabasiAlbertDialog(tkSimpleDialog.Dialog):
    def body(self, master):
        Tkinter.Label(master, text="Number of Nodes:").grid(row=0)
        Tkinter.Label(master, text="Number of Edges:").grid(row=1)

        self.e1 = Tkinter.Entry(master)
        self.e2 = Tkinter.Entry(master)

        self.e1.grid(row=0, column=1)
        self.e2.grid(row=1, column=1)
        return self.e1

    def apply(self):
        self.number = int(self.e1.get())
        self.edges = int(self.e2.get())
