"""
Graph Display

"""
__author__ = """Brian Cloteaux (brian.cloteaux@nist.gov)"""
#  Mathematical and Computational Sciences Division
#  National Institute of Standards and Technology,
#  Gaithersburg, MD USA
# 
#  This software was developed at the National Institute of Standards and
#  Technology (NIST) by employees of the Federal Government in the course
#  of their official duties. Pursuant to title 17 Section 105 of the
#  United States Code, this software is not subject to copyright protection
#  and is in the public domain. NIST assumes no responsibility whatsoever for
#  its use by other parties, and makes no guarantees, expressed or implied,
#  about its quality, reliability, or any other characteristic.

import Tix
import networkx as nx
import degree_sequence

import NMTKModel
import GraphPlot

import matplotlib
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg, NavigationToolbar2TkAgg
from matplotlib.figure import Figure

class GraphDisplay(Tix.Frame):
    def __init__(self, model, parent=None):
        Tix.Frame.__init__(self, parent, width=10, height=10)
        self.pack(fill=Tix.BOTH, expand=Tix.YES)
        self.parent = parent
        self.graphtable = None
        self.graphplot = None
        self.updateGraph(model)

    def updateGraph(self, model):
        if self.graphtable is not None:
            self.graphtable.pack_forget()
            self.graphtable = None
        if self.graphplot is not None:
            self.graphplot.pack_forget()
            self.graphplot = None
        graph = model.getGraph()
        if graph is not None:
            self.graphtable = GraphTable(graph, self)
            self.graphtable.pack(side=Tix.LEFT)
            self.graphplot = GraphPlot.GraphPlot(model, self)
            self.graphplot.pack(side=Tix.LEFT)
            #if (graph.number_of_nodes() <= 1000):
            #    self.graphplot = GraphSpectrumPlot(graph, self)
            #    self.graphplot.pack(side=Tix.LEFT)

class GraphTable(Tix.Frame):
    def __init__(self, graph, parent=None):
        Tix.Frame.__init__(self, parent)
        self.pack(expand=Tix.YES, fill=Tix.BOTH)
        self.gf = Tix.Frame(self) 
        self.gf.pack(side=Tix.TOP, expand=Tix.YES, fill=Tix.BOTH) 
        l = Tix.Label(self.gf, width=4, relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
        l = Tix.Label(self.gf, text='Node', width=5, relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
        l = Tix.Label(self.gf, text='Adjacent', relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)

        self.w = Tix.ScrolledWindow(self, scrollbar='auto')
        self.w.config(width=200, height=500)
        self.w.pack(side=Tix.TOP, expand=Tix.YES, fill=Tix.BOTH)
        win = self.w.window
        self.addRows(win, graph)

    def addRows(self, frame, graph):
        color = 'white'
        rowval = 0
        for node in sorted(graph.nodes()):
            fn = Tix.Frame(frame)
            fn.pack(expand=Tix.YES, fill=Tix.BOTH)
            ln = Tix.Label(fn, text=str(rowval+1), width=4, relief=Tix.RAISED)
            ln.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
            ln = Tix.Label(fn, text=str(node), width=5, relief=Tix.GROOVE, \
                    bg=color)
            ln.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
            adjval = '';
            for adj in sorted(graph.neighbors(node)):
                adjval = adjval + str(adj) + ' '
            ln = Tix.Label(fn, text=adjval, width=100, relief=Tix.GROOVE, \
                    bg=color, anchor=Tix.W)
            ln.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
            rowval = rowval+1
