"""
Affiliation Display

"""
__author__ = """Brian Cloteaux (brian.cloteaux@nist.gov)"""
#  Mathematical and Computational Sciences Division
#  National Institute of Standards and Technology,
#  Gaithersburg, MD USA
# 
#  This software was developed at the National Institute of Standards and
#  Technology (NIST) by employees of the Federal Government in the course
#  of their official duties. Pursuant to title 17 Section 105 of the
#  United States Code, this software is not subject to copyright protection
#  and is in the public domain. NIST assumes no responsibility whatsoever for
#  its use by other parties, and makes no guarantees, expressed or implied,
#  about its quality, reliability, or any other characteristic.


import Tix
import networkx as nx
import degree_sequence

import NMTKModel
import AffiliationPlot

import matplotlib
#matplotlib.use('TkAgg')
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg, NavigationToolbar2TkAgg
from matplotlib.figure import Figure

class AffiliationDisplay(Tix.Frame):
    def __init__(self, model, parent=None):
        Tix.Frame.__init__(self, parent, width=10, height=10)
        self.pack(fill=Tix.BOTH, expand=Tix.YES)
        self.parent = parent
        self.affiltable = None
        self.affilplot = None
        self.updateAffiliation(model)

    def updateAffiliation(self, model):
        if self.affiltable is not None:
            self.affiltable.pack_forget()
            self.affiltable = None
        if self.affilplot is not None:
            self.affilplot.pack_forget()
            self.affilplot = None
        affil = model.getAffiliation()
        if affil is not None:
            self.affiltable = AffiliationTable(affil, self)
            self.affiltable.pack(side=Tix.LEFT)
            self.affilplot = AffiliationPlot.AffiliationPlot(model, self)
            self.affilplot.pack(side=Tix.LEFT)
            #if (graph.number_of_nodes() <= 1000):
            #    self.graphplot = GraphSpectrumPlot(graph, self)
            #    self.graphplot.pack(side=Tix.LEFT)

class AffiliationTable(Tix.Frame):
    def __init__(self, affil, parent=None):
        Tix.Frame.__init__(self, parent)
        self.pack(expand=Tix.YES, fill=Tix.BOTH)
        self.gf = Tix.Frame(self) 
        self.gf.pack(side=Tix.TOP, expand=Tix.YES, fill=Tix.BOTH) 
        l = Tix.Label(self.gf, width=4, relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
        l = Tix.Label(self.gf, text='Node', width=5, relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
        l = Tix.Label(self.gf, text='Affiliations', relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)

        self.w = Tix.ScrolledWindow(self, scrollbar='auto')
        self.w.config(width=200, height=500)
        self.w.pack(side=Tix.TOP, expand=Tix.YES, fill=Tix.BOTH)
        win = self.w.window
        self.addRows(win, affil)

    def addRows(self, frame, affil):
        color = 'white'
        rowval = 0
        for node in affil.nodes():
            if affil.node_type[node] == "Bottom":
                fn = Tix.Frame(frame)
                fn.pack(expand=Tix.YES, fill=Tix.BOTH)
                ln = Tix.Label(fn, text=str(rowval+1), width=4, \
                        relief=Tix.RAISED)
                ln.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
                ln = Tix.Label(fn, text=str(node), width=5, relief=Tix.GROOVE, \
                        bg=color)
                ln.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
                adjval = '';
                for adj in sorted(affil.neighbors(node)):
                    adjval = adjval + str(adj) + ' '
                    ln = Tix.Label(fn, text=adjval, width=100, \
                            relief=Tix.GROOVE, bg=color, anchor=Tix.W)
                ln.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
                rowval = rowval+1
