"""
Degree Sequence Reader

"""
__author__ = """Brian Cloteaux (brian.cloteaux@nist.gov)"""
#  Mathematical and Computational Sciences Division
#  National Institute of Standards and Technology,
#  Gaithersburg, MD USA
# 
#  This software was developed at the National Institute of Standards and
#  Technology (NIST) by employees of the Federal Government in the course
#  of their official duties. Pursuant to title 17 Section 105 of the
#  United States Code, this software is not subject to copyright protection
#  and is in the public domain. NIST assumes no responsibility whatsoever for
#  its use by other parties, and makes no guarantees, expressed or implied,
#  about its quality, reliability, or any other characteristic.

import degree_sequence

def getSequence(filename):
    seq = degree_sequence.degree_sequence()
    file = open(filename)
    for line in file:
        vals = line.split()
        seq.add_deg(int(vals[0]), int(vals[1]))
    return seq

def writeSequence(sequence, filename):
    with open(filename, 'w') as f:
        val = sequence.get_largest_val() + 1
        while val > sequence.get_smallest_val():
            val = sequence.get_next_smaller(val)
            num = sequence.get_num_degs(val)
            s = str(val) + " " + str(num) + "\n"
            f.write(s)
