#include "dmis.h"
#include <stdio.h>   // for printf, etc.

namespace NDTS {

void printDouble(
 double num)
{
  int n;
  int k;
  char buffer[50];

  k = sprintf(buffer, "%f", num);
  for (n = (k-1); ((buffer[n] == '0') && (buffer[n-1] != '.')); n--)
    buffer[n] = 0;
  printf("%s", buffer);
}

/********************************************************************/

dmisCppBase::dmisCppBase(){}

dmisCppBase::~dmisCppBase(){}

/********************************************************************/

dmisStatement::dmisStatement(){}

dmisStatement::~dmisStatement(){}


/********************************************************************/

inputFile::inputFile(){}

inputFile::inputFile(
  dmisFirstStatement * dmisFirstStatementIn,
  std::list<dmisItem *> * dmisItemListIn,
  endfilStm * endfilStmIn)
{
  a_dmisFirstStatement = dmisFirstStatementIn;
  a_dmisItemList = dmisItemListIn;
  a_endfilStm = endfilStmIn;
}

inputFile::~inputFile(){}

void inputFile::printSelf()
{
  a_dmisFirstStatement->printSelf();
  if (a_dmisItemList)
    {
      std::list<dmisItem *>::iterator iter;
      for (iter = a_dmisItemList->begin();
           iter != a_dmisItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endfilStm->printSelf();
}

dmisFirstStatement * inputFile::get_dmisFirstStatement()
{ return a_dmisFirstStatement; }
void inputFile::set_dmisFirstStatement(dmisFirstStatement * dmisFirstStatementIn)
{ a_dmisFirstStatement = dmisFirstStatementIn; }
std::list<dmisItem *> * inputFile::get_dmisItemList()
{ return a_dmisItemList; }
void inputFile::set_dmisItemList(std::list<dmisItem *> * dmisItemListIn)
{ a_dmisItemList = dmisItemListIn; }
endfilStm * inputFile::get_endfilStm()
{ return a_endfilStm; }
void inputFile::set_endfilStm(endfilStm * endfilStmIn)
{ a_endfilStm = endfilStmIn; }

/********************************************************************/

dmisItem::dmisItem(){};

dmisItem::~dmisItem(){}

/********************************************************************/

dmisFirstStatement::dmisFirstStatement(){};

dmisFirstStatement::~dmisFirstStatement(){}

/********************************************************************/

dmisBlock::dmisBlock(){};

dmisBlock::~dmisBlock(){}

/********************************************************************/

calibMasterBlock::calibMasterBlock(){}

calibMasterBlock::calibMasterBlock(
  calibMasterStm * calibMasterStmIn,
  std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
  endmesStm * endmesStmIn)
{
  a_calibMasterStm = calibMasterStmIn;
  a_calibSensBlockItemList = calibSensBlockItemListIn;
  a_endmesStm = endmesStmIn;
}

calibMasterBlock::~calibMasterBlock(){}

void calibMasterBlock::printSelf()
{
  a_calibMasterStm->printSelf();
  if (a_calibSensBlockItemList)
    {
      std::list<calibSensBlockItem *>::iterator iter;
      for (iter = a_calibSensBlockItemList->begin();
           iter != a_calibSensBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endmesStm->printSelf();
}

calibMasterStm * calibMasterBlock::get_calibMasterStm()
{ return a_calibMasterStm; }
void calibMasterBlock::set_calibMasterStm(calibMasterStm * calibMasterStmIn)
{ a_calibMasterStm = calibMasterStmIn; }
std::list<calibSensBlockItem *> * calibMasterBlock::get_calibSensBlockItemList()
{ return a_calibSensBlockItemList; }
void calibMasterBlock::set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn)
{ a_calibSensBlockItemList = calibSensBlockItemListIn; }
endmesStm * calibMasterBlock::get_endmesStm()
{ return a_endmesStm; }
void calibMasterBlock::set_endmesStm(endmesStm * endmesStmIn)
{ a_endmesStm = endmesStmIn; }

/********************************************************************/

calibRtabBlock::calibRtabBlock(){}

calibRtabBlock::calibRtabBlock(
  calibRtabStm * calibRtabStmIn,
  std::list<measBlockItem *> * measBlockItemListIn,
  endmesStm * endmesStmIn)
{
  a_calibRtabStm = calibRtabStmIn;
  a_measBlockItemList = measBlockItemListIn;
  a_endmesStm = endmesStmIn;
}

calibRtabBlock::~calibRtabBlock(){}

void calibRtabBlock::printSelf()
{
  a_calibRtabStm->printSelf();
  if (a_measBlockItemList)
    {
      std::list<measBlockItem *>::iterator iter;
      for (iter = a_measBlockItemList->begin();
           iter != a_measBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endmesStm->printSelf();
}

calibRtabStm * calibRtabBlock::get_calibRtabStm()
{ return a_calibRtabStm; }
void calibRtabBlock::set_calibRtabStm(calibRtabStm * calibRtabStmIn)
{ a_calibRtabStm = calibRtabStmIn; }
std::list<measBlockItem *> * calibRtabBlock::get_measBlockItemList()
{ return a_measBlockItemList; }
void calibRtabBlock::set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn)
{ a_measBlockItemList = measBlockItemListIn; }
endmesStm * calibRtabBlock::get_endmesStm()
{ return a_endmesStm; }
void calibRtabBlock::set_endmesStm(endmesStm * endmesStmIn)
{ a_endmesStm = endmesStmIn; }

/********************************************************************/

calibSensBlock::calibSensBlock(){}

calibSensBlock::calibSensBlock(
  calibSensStm * calibSensStmIn,
  std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
  endmesStm * endmesStmIn)
{
  a_calibSensStm = calibSensStmIn;
  a_calibSensBlockItemList = calibSensBlockItemListIn;
  a_endmesStm = endmesStmIn;
}

calibSensBlock::~calibSensBlock(){}

void calibSensBlock::printSelf()
{
  a_calibSensStm->printSelf();
  if (a_calibSensBlockItemList)
    {
      std::list<calibSensBlockItem *>::iterator iter;
      for (iter = a_calibSensBlockItemList->begin();
           iter != a_calibSensBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endmesStm->printSelf();
}

calibSensStm * calibSensBlock::get_calibSensStm()
{ return a_calibSensStm; }
void calibSensBlock::set_calibSensStm(calibSensStm * calibSensStmIn)
{ a_calibSensStm = calibSensStmIn; }
std::list<calibSensBlockItem *> * calibSensBlock::get_calibSensBlockItemList()
{ return a_calibSensBlockItemList; }
void calibSensBlock::set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn)
{ a_calibSensBlockItemList = calibSensBlockItemListIn; }
endmesStm * calibSensBlock::get_endmesStm()
{ return a_endmesStm; }
void calibSensBlock::set_endmesStm(endmesStm * endmesStmIn)
{ a_endmesStm = endmesStmIn; }

/********************************************************************/

calibSensBlockItem::calibSensBlockItem(){};

calibSensBlockItem::~calibSensBlockItem(){}

/********************************************************************/

calibSensDoBlock::calibSensDoBlock(){}

calibSensDoBlock::calibSensDoBlock(
  doStm * doStmIn,
  std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
  enddoStm * enddoStmIn)
{
  a_doStm = doStmIn;
  a_calibSensBlockItemList = calibSensBlockItemListIn;
  a_enddoStm = enddoStmIn;
}

calibSensDoBlock::~calibSensDoBlock(){}

void calibSensDoBlock::printSelf()
{
  a_doStm->printSelf();
  if (a_calibSensBlockItemList)
    {
      std::list<calibSensBlockItem *>::iterator iter;
      for (iter = a_calibSensBlockItemList->begin();
           iter != a_calibSensBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_enddoStm->printSelf();
}

doStm * calibSensDoBlock::get_doStm()
{ return a_doStm; }
void calibSensDoBlock::set_doStm(doStm * doStmIn)
{ a_doStm = doStmIn; }
std::list<calibSensBlockItem *> * calibSensDoBlock::get_calibSensBlockItemList()
{ return a_calibSensBlockItemList; }
void calibSensDoBlock::set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn)
{ a_calibSensBlockItemList = calibSensBlockItemListIn; }
enddoStm * calibSensDoBlock::get_enddoStm()
{ return a_enddoStm; }
void calibSensDoBlock::set_enddoStm(enddoStm * enddoStmIn)
{ a_enddoStm = enddoStmIn; }

/********************************************************************/

calibSensIfBlock::calibSensIfBlock(){}

calibSensIfBlock::calibSensIfBlock(
  ifStm * ifStmIn,
  std::list<calibSensBlockItem *> * ifListIn,
  elseStm * elseStmIn,
  std::list<calibSensBlockItem *> * elseListIn,
  endifStm * endifStmIn)
{
  a_ifStm = ifStmIn;
  ifList = ifListIn;
  a_elseStm = elseStmIn;
  elseList = elseListIn;
  a_endifStm = endifStmIn;
}

calibSensIfBlock::~calibSensIfBlock(){}

void calibSensIfBlock::printSelf()
{
  a_ifStm->printSelf();
  if (ifList)
    {
      std::list<calibSensBlockItem *>::iterator iter;
      for (iter = ifList->begin();
           iter != ifList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_elseStm)
    {
      a_elseStm->printSelf();
      if (elseList)
        {
          std::list<calibSensBlockItem *>::iterator iter;
          for (iter = elseList->begin();
               iter != elseList->end();
               iter++)
            (*iter)->printSelf();
        }
    }
  a_endifStm->printSelf();
}

ifStm * calibSensIfBlock::get_ifStm()
{ return a_ifStm; }
void calibSensIfBlock::set_ifStm(ifStm * ifStmIn)
{ a_ifStm = ifStmIn; }
std::list<calibSensBlockItem *> * calibSensIfBlock::get_ifList()
{ return ifList; }
void calibSensIfBlock::set_ifList(std::list<calibSensBlockItem *> * ifListIn)
{ ifList = ifListIn; }
elseStm * calibSensIfBlock::get_elseStm()
{ return a_elseStm; }
void calibSensIfBlock::set_elseStm(elseStm * elseStmIn)
{ a_elseStm = elseStmIn; }
std::list<calibSensBlockItem *> * calibSensIfBlock::get_elseList()
{ return elseList; }
void calibSensIfBlock::set_elseList(std::list<calibSensBlockItem *> * elseListIn)
{ elseList = elseListIn; }
endifStm * calibSensIfBlock::get_endifStm()
{ return a_endifStm; }
void calibSensIfBlock::set_endifStm(endifStm * endifStmIn)
{ a_endifStm = endifStmIn; }

/********************************************************************/

calibSensSelectBlock::calibSensSelectBlock(){}

calibSensSelectBlock::calibSensSelectBlock(
  selectStm * selectStmIn,
  std::list<calibSensCaseBlock *> * calibSensCaseBlockListIn,
  calibSensDefaultCaseBlock * calibSensDefaultCaseBlockIn,
  endselStm * endselStmIn)
{
  a_selectStm = selectStmIn;
  a_calibSensCaseBlockList = calibSensCaseBlockListIn;
  a_calibSensDefaultCaseBlock = calibSensDefaultCaseBlockIn;
  a_endselStm = endselStmIn;
}

calibSensSelectBlock::~calibSensSelectBlock(){}

void calibSensSelectBlock::printSelf()
{
  a_selectStm->printSelf();
  if (1)
    {
      std::list<calibSensCaseBlock *>::iterator iter;
      for (iter = a_calibSensCaseBlockList->begin();
           iter != a_calibSensCaseBlockList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_calibSensDefaultCaseBlock)
    {
      a_calibSensDefaultCaseBlock->printSelf();
    }
  a_endselStm->printSelf();
}

selectStm * calibSensSelectBlock::get_selectStm()
{ return a_selectStm; }
void calibSensSelectBlock::set_selectStm(selectStm * selectStmIn)
{ a_selectStm = selectStmIn; }
std::list<calibSensCaseBlock *> * calibSensSelectBlock::get_calibSensCaseBlockList()
{ return a_calibSensCaseBlockList; }
void calibSensSelectBlock::set_calibSensCaseBlockList(std::list<calibSensCaseBlock *> * calibSensCaseBlockListIn)
{ a_calibSensCaseBlockList = calibSensCaseBlockListIn; }
calibSensDefaultCaseBlock * calibSensSelectBlock::get_calibSensDefaultCaseBlock()
{ return a_calibSensDefaultCaseBlock; }
void calibSensSelectBlock::set_calibSensDefaultCaseBlock(calibSensDefaultCaseBlock * calibSensDefaultCaseBlockIn)
{ a_calibSensDefaultCaseBlock = calibSensDefaultCaseBlockIn; }
endselStm * calibSensSelectBlock::get_endselStm()
{ return a_endselStm; }
void calibSensSelectBlock::set_endselStm(endselStm * endselStmIn)
{ a_endselStm = endselStmIn; }

/********************************************************************/

calibSensCaseBlock::calibSensCaseBlock(){}

calibSensCaseBlock::calibSensCaseBlock(
  std::list<caseStm *> * caseListIn,
  std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
  endcasStm * endcasStmIn)
{
  a_caseList = caseListIn;
  a_calibSensBlockItemList = calibSensBlockItemListIn;
  a_endcasStm = endcasStmIn;
}

calibSensCaseBlock::~calibSensCaseBlock(){}

void calibSensCaseBlock::printSelf()
{
  if (1)
    {
      std::list<caseStm *>::iterator iter;
      for (iter = a_caseList->begin();
           iter != a_caseList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_calibSensBlockItemList)
    {
      std::list<calibSensBlockItem *>::iterator iter;
      for (iter = a_calibSensBlockItemList->begin();
           iter != a_calibSensBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endcasStm->printSelf();
}

std::list<caseStm *> * calibSensCaseBlock::get_caseList()
{ return a_caseList; }
void calibSensCaseBlock::set_caseList(std::list<caseStm *> * caseListIn)
{ a_caseList = caseListIn; }
std::list<calibSensBlockItem *> * calibSensCaseBlock::get_calibSensBlockItemList()
{ return a_calibSensBlockItemList; }
void calibSensCaseBlock::set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn)
{ a_calibSensBlockItemList = calibSensBlockItemListIn; }
endcasStm * calibSensCaseBlock::get_endcasStm()
{ return a_endcasStm; }
void calibSensCaseBlock::set_endcasStm(endcasStm * endcasStmIn)
{ a_endcasStm = endcasStmIn; }

/********************************************************************/

calibSensDefaultCaseBlock::calibSensDefaultCaseBlock(){}

calibSensDefaultCaseBlock::calibSensDefaultCaseBlock(
  dftcasStm * dftcasStmIn,
  std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
  endcasStm * endcasStmIn)
{
  a_dftcasStm = dftcasStmIn;
  a_calibSensBlockItemList = calibSensBlockItemListIn;
  a_endcasStm = endcasStmIn;
}

calibSensDefaultCaseBlock::~calibSensDefaultCaseBlock(){}

void calibSensDefaultCaseBlock::printSelf()
{
  a_dftcasStm->printSelf();
  if (a_calibSensBlockItemList)
    {
      std::list<calibSensBlockItem *>::iterator iter;
      for (iter = a_calibSensBlockItemList->begin();
           iter != a_calibSensBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endcasStm->printSelf();
}

dftcasStm * calibSensDefaultCaseBlock::get_dftcasStm()
{ return a_dftcasStm; }
void calibSensDefaultCaseBlock::set_dftcasStm(dftcasStm * dftcasStmIn)
{ a_dftcasStm = dftcasStmIn; }
std::list<calibSensBlockItem *> * calibSensDefaultCaseBlock::get_calibSensBlockItemList()
{ return a_calibSensBlockItemList; }
void calibSensDefaultCaseBlock::set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn)
{ a_calibSensBlockItemList = calibSensBlockItemListIn; }
endcasStm * calibSensDefaultCaseBlock::get_endcasStm()
{ return a_endcasStm; }
void calibSensDefaultCaseBlock::set_endcasStm(endcasStm * endcasStmIn)
{ a_endcasStm = endcasStmIn; }

/********************************************************************/

callBlock::callBlock(){}

callBlock::callBlock(
  callStm * callStmIn,
  std::list<dmisItem *> * dmisItemListIn,
  endmacStm * endmacStmIn)
{
  a_callStm = callStmIn;
  a_dmisItemList = dmisItemListIn;
  a_endmacStm = endmacStmIn;
}

callBlock::~callBlock(){}

void callBlock::printSelf()
{
  a_callStm->printSelf();
}

callStm * callBlock::get_callStm()
{ return a_callStm; }
void callBlock::set_callStm(callStm * callStmIn)
{ a_callStm = callStmIn; }
std::list<dmisItem *> * callBlock::get_dmisItemList()
{ return a_dmisItemList; }
void callBlock::set_dmisItemList(std::list<dmisItem *> * dmisItemListIn)
{ a_dmisItemList = dmisItemListIn; }
endmacStm * callBlock::get_endmacStm()
{ return a_endmacStm; }
void callBlock::set_endmacStm(endmacStm * endmacStmIn)
{ a_endmacStm = endmacStmIn; }

/********************************************************************/

caseBlock::caseBlock(){}

caseBlock::caseBlock(
  std::list<caseStm *> * caseListIn,
  std::list<dmisItem *> * dmisItemListIn,
  endcasStm * endcasStmIn)
{
  a_caseList = caseListIn;
  a_dmisItemList = dmisItemListIn;
  a_endcasStm = endcasStmIn;
}

caseBlock::~caseBlock(){}

void caseBlock::printSelf()
{
  if (1)
    {
      std::list<caseStm *>::iterator iter;
      for (iter = a_caseList->begin();
           iter != a_caseList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_dmisItemList)
    {
      std::list<dmisItem *>::iterator iter;
      for (iter = a_dmisItemList->begin();
           iter != a_dmisItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endcasStm->printSelf();
}

std::list<caseStm *> * caseBlock::get_caseList()
{ return a_caseList; }
void caseBlock::set_caseList(std::list<caseStm *> * caseListIn)
{ a_caseList = caseListIn; }
std::list<dmisItem *> * caseBlock::get_dmisItemList()
{ return a_dmisItemList; }
void caseBlock::set_dmisItemList(std::list<dmisItem *> * dmisItemListIn)
{ a_dmisItemList = dmisItemListIn; }
endcasStm * caseBlock::get_endcasStm()
{ return a_endcasStm; }
void caseBlock::set_endcasStm(endcasStm * endcasStmIn)
{ a_endcasStm = endcasStmIn; }

/********************************************************************/

defaultCaseBlock::defaultCaseBlock(){}

defaultCaseBlock::defaultCaseBlock(
  dftcasStm * dftcasStmIn,
  std::list<dmisItem *> * dmisItemListIn,
  endcasStm * endcasStmIn)
{
  a_dftcasStm = dftcasStmIn;
  a_dmisItemList = dmisItemListIn;
  a_endcasStm = endcasStmIn;
}

defaultCaseBlock::~defaultCaseBlock(){}

void defaultCaseBlock::printSelf()
{
  a_dftcasStm->printSelf();
  if (a_dmisItemList)
    {
      std::list<dmisItem *>::iterator iter;
      for (iter = a_dmisItemList->begin();
           iter != a_dmisItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endcasStm->printSelf();
}

dftcasStm * defaultCaseBlock::get_dftcasStm()
{ return a_dftcasStm; }
void defaultCaseBlock::set_dftcasStm(dftcasStm * dftcasStmIn)
{ a_dftcasStm = dftcasStmIn; }
std::list<dmisItem *> * defaultCaseBlock::get_dmisItemList()
{ return a_dmisItemList; }
void defaultCaseBlock::set_dmisItemList(std::list<dmisItem *> * dmisItemListIn)
{ a_dmisItemList = dmisItemListIn; }
endcasStm * defaultCaseBlock::get_endcasStm()
{ return a_endcasStm; }
void defaultCaseBlock::set_endcasStm(endcasStm * endcasStmIn)
{ a_endcasStm = endcasStmIn; }

/********************************************************************/

dmisOffBlock::dmisOffBlock(){}

dmisOffBlock::dmisOffBlock(
  dmisOffStm * dmisOffStmIn,
  std::list<noParseStm *> * noParseStmListIn,
  dmisOnStm * dmisOnStmIn)
{
  a_dmisOffStm = dmisOffStmIn;
  a_noParseStmList = noParseStmListIn;
  a_dmisOnStm = dmisOnStmIn;
}

dmisOffBlock::~dmisOffBlock(){}

void dmisOffBlock::printSelf()
{
  a_dmisOffStm->printSelf();
  if (a_noParseStmList)
    {
      std::list<noParseStm *>::iterator iter;
      for (iter = a_noParseStmList->begin();
           iter != a_noParseStmList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_dmisOnStm->printSelf();
}

dmisOffStm * dmisOffBlock::get_dmisOffStm()
{ return a_dmisOffStm; }
void dmisOffBlock::set_dmisOffStm(dmisOffStm * dmisOffStmIn)
{ a_dmisOffStm = dmisOffStmIn; }
std::list<noParseStm *> * dmisOffBlock::get_noParseStmList()
{ return a_noParseStmList; }
void dmisOffBlock::set_noParseStmList(std::list<noParseStm *> * noParseStmListIn)
{ a_noParseStmList = noParseStmListIn; }
dmisOnStm * dmisOffBlock::get_dmisOnStm()
{ return a_dmisOnStm; }
void dmisOffBlock::set_dmisOnStm(dmisOnStm * dmisOnStmIn)
{ a_dmisOnStm = dmisOnStmIn; }

/********************************************************************/

doBlock::doBlock(){}

doBlock::doBlock(
  doStm * doStmIn,
  std::list<dmisItem *> * dmisItemListIn,
  enddoStm * enddoStmIn)
{
  a_doStm = doStmIn;
  a_dmisItemList = dmisItemListIn;
  a_enddoStm = enddoStmIn;
}

doBlock::~doBlock(){}

void doBlock::printSelf()
{
  a_doStm->printSelf();
  if (a_dmisItemList)
    {
      std::list<dmisItem *>::iterator iter;
      for (iter = a_dmisItemList->begin();
           iter != a_dmisItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_enddoStm->printSelf();
}

doStm * doBlock::get_doStm()
{ return a_doStm; }
void doBlock::set_doStm(doStm * doStmIn)
{ a_doStm = doStmIn; }
std::list<dmisItem *> * doBlock::get_dmisItemList()
{ return a_dmisItemList; }
void doBlock::set_dmisItemList(std::list<dmisItem *> * dmisItemListIn)
{ a_dmisItemList = dmisItemListIn; }
enddoStm * doBlock::get_enddoStm()
{ return a_enddoStm; }
void doBlock::set_enddoStm(enddoStm * enddoStmIn)
{ a_enddoStm = enddoStmIn; }

/********************************************************************/

gotargBlock::gotargBlock(){}

gotargBlock::gotargBlock(
  gotargStm * gotargStmIn,
  gotoStm * gotoStmIn,
  std::list<gotoStm *> * gotoListIn,
  endgoStm * endgoStmIn)
{
  a_gotargStm = gotargStmIn;
  a_gotoStm = gotoStmIn;
  a_gotoList = gotoListIn;
  a_endgoStm = endgoStmIn;
}

gotargBlock::~gotargBlock(){}

void gotargBlock::printSelf()
{
  a_gotargStm->printSelf();
  a_gotoStm->printSelf();
  if (1)
    {
      std::list<gotoStm *>::iterator iter;
      for (iter = a_gotoList->begin();
           iter != a_gotoList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endgoStm->printSelf();
}

gotargStm * gotargBlock::get_gotargStm()
{ return a_gotargStm; }
void gotargBlock::set_gotargStm(gotargStm * gotargStmIn)
{ a_gotargStm = gotargStmIn; }
gotoStm * gotargBlock::get_gotoStm()
{ return a_gotoStm; }
void gotargBlock::set_gotoStm(gotoStm * gotoStmIn)
{ a_gotoStm = gotoStmIn; }
std::list<gotoStm *> * gotargBlock::get_gotoList()
{ return a_gotoList; }
void gotargBlock::set_gotoList(std::list<gotoStm *> * gotoListIn)
{ a_gotoList = gotoListIn; }
endgoStm * gotargBlock::get_endgoStm()
{ return a_endgoStm; }
void gotargBlock::set_endgoStm(endgoStm * endgoStmIn)
{ a_endgoStm = endgoStmIn; }

/********************************************************************/

ifBlock::ifBlock(){}

ifBlock::ifBlock(
  ifStm * ifStmIn,
  std::list<dmisItem *> * ifListIn,
  elseStm * elseStmIn,
  std::list<dmisItem *> * elseListIn,
  endifStm * endifStmIn)
{
  a_ifStm = ifStmIn;
  ifList = ifListIn;
  a_elseStm = elseStmIn;
  elseList = elseListIn;
  a_endifStm = endifStmIn;
}

ifBlock::~ifBlock(){}

void ifBlock::printSelf()
{
  a_ifStm->printSelf();
  if (ifList)
    {
      std::list<dmisItem *>::iterator iter;
      for (iter = ifList->begin();
           iter != ifList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_elseStm)
    {
      a_elseStm->printSelf();
      if (elseList)
        {
          std::list<dmisItem *>::iterator iter;
          for (iter = elseList->begin();
               iter != elseList->end();
               iter++)
            (*iter)->printSelf();
        }
    }
  a_endifStm->printSelf();
}

ifStm * ifBlock::get_ifStm()
{ return a_ifStm; }
void ifBlock::set_ifStm(ifStm * ifStmIn)
{ a_ifStm = ifStmIn; }
std::list<dmisItem *> * ifBlock::get_ifList()
{ return ifList; }
void ifBlock::set_ifList(std::list<dmisItem *> * ifListIn)
{ ifList = ifListIn; }
elseStm * ifBlock::get_elseStm()
{ return a_elseStm; }
void ifBlock::set_elseStm(elseStm * elseStmIn)
{ a_elseStm = elseStmIn; }
std::list<dmisItem *> * ifBlock::get_elseList()
{ return elseList; }
void ifBlock::set_elseList(std::list<dmisItem *> * elseListIn)
{ elseList = elseListIn; }
endifStm * ifBlock::get_endifStm()
{ return a_endifStm; }
void ifBlock::set_endifStm(endifStm * endifStmIn)
{ a_endifStm = endifStmIn; }

/********************************************************************/

macroBlock::macroBlock(){}

macroBlock::macroBlock(
  macroStm * macroStmIn,
  std::list<noParseStm *> * noParseStmListIn,
  endmacStm * endmacStmIn,
  int macroIsRealIn)
{
  a_macroStm = macroStmIn;
  a_noParseStmList = noParseStmListIn;
  a_endmacStm = endmacStmIn;
  macroIsReal = macroIsRealIn;
}

macroBlock::~macroBlock(){}

void macroBlock::printSelf()
{
  if (macroIsReal)
    {
      a_macroStm->printSelf();
      if (a_noParseStmList)
        {
          std::list<noParseStm *>::iterator iter;
          for (iter = a_noParseStmList->begin();
               iter != a_noParseStmList->end();
               iter++)
            (*iter)->printSelf();
        }
      a_endmacStm->printSelf();
    }
}

macroStm * macroBlock::get_macroStm()
{ return a_macroStm; }
void macroBlock::set_macroStm(macroStm * macroStmIn)
{ a_macroStm = macroStmIn; }
std::list<noParseStm *> * macroBlock::get_noParseStmList()
{ return a_noParseStmList; }
void macroBlock::set_noParseStmList(std::list<noParseStm *> * noParseStmListIn)
{ a_noParseStmList = noParseStmListIn; }
endmacStm * macroBlock::get_endmacStm()
{ return a_endmacStm; }
void macroBlock::set_endmacStm(endmacStm * endmacStmIn)
{ a_endmacStm = endmacStmIn; }

/********************************************************************/

measBlock::measBlock(){};

measBlock::~measBlock(){}

/********************************************************************/

measBlock_measStm::measBlock_measStm(){}

measBlock_measStm::measBlock_measStm(
  measStm * measStmIn,
  std::list<measBlockItem *> * measBlockItemListIn,
  endmesStm * endmesStmIn)
{
  a_measStm = measStmIn;
  a_measBlockItemList = measBlockItemListIn;
  a_endmesStm = endmesStmIn;
}

measBlock_measStm::~measBlock_measStm(){}

void measBlock_measStm::printSelf()
{
  a_measStm->printSelf();
  if (a_measBlockItemList)
    {
      std::list<measBlockItem *>::iterator iter;
      for (iter = a_measBlockItemList->begin();
           iter != a_measBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endmesStm->printSelf();
}

measStm * measBlock_measStm::get_measStm()
{ return a_measStm; }
void measBlock_measStm::set_measStm(measStm * measStmIn)
{ a_measStm = measStmIn; }
std::list<measBlockItem *> * measBlock_measStm::get_measBlockItemList()
{ return a_measBlockItemList; }
void measBlock_measStm::set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn)
{ a_measBlockItemList = measBlockItemListIn; }
endmesStm * measBlock_measStm::get_endmesStm()
{ return a_endmesStm; }
void measBlock_measStm::set_endmesStm(endmesStm * endmesStmIn)
{ a_endmesStm = endmesStmIn; }

/********************************************************************/

measBlock_rmeasStm::measBlock_rmeasStm(){}

measBlock_rmeasStm::measBlock_rmeasStm(
  rmeasStm * rmeasStmIn,
  std::list<measBlockItem *> * measBlockItemListIn,
  endmesStm * endmesStmIn)
{
  a_rmeasStm = rmeasStmIn;
  a_measBlockItemList = measBlockItemListIn;
  a_endmesStm = endmesStmIn;
}

measBlock_rmeasStm::~measBlock_rmeasStm(){}

void measBlock_rmeasStm::printSelf()
{
  a_rmeasStm->printSelf();
  if (a_measBlockItemList)
    {
      std::list<measBlockItem *>::iterator iter;
      for (iter = a_measBlockItemList->begin();
           iter != a_measBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endmesStm->printSelf();
}

rmeasStm * measBlock_rmeasStm::get_rmeasStm()
{ return a_rmeasStm; }
void measBlock_rmeasStm::set_rmeasStm(rmeasStm * rmeasStmIn)
{ a_rmeasStm = rmeasStmIn; }
std::list<measBlockItem *> * measBlock_rmeasStm::get_measBlockItemList()
{ return a_measBlockItemList; }
void measBlock_rmeasStm::set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn)
{ a_measBlockItemList = measBlockItemListIn; }
endmesStm * measBlock_rmeasStm::get_endmesStm()
{ return a_endmesStm; }
void measBlock_rmeasStm::set_endmesStm(endmesStm * endmesStmIn)
{ a_endmesStm = endmesStmIn; }

/********************************************************************/

measBlockItem::measBlockItem(){};

measBlockItem::~measBlockItem(){}

/********************************************************************/

measDoBlock::measDoBlock(){}

measDoBlock::measDoBlock(
  doStm * doStmIn,
  std::list<measBlockItem *> * measBlockItemListIn,
  enddoStm * enddoStmIn)
{
  a_doStm = doStmIn;
  a_measBlockItemList = measBlockItemListIn;
  a_enddoStm = enddoStmIn;
}

measDoBlock::~measDoBlock(){}

void measDoBlock::printSelf()
{
  a_doStm->printSelf();
  if (a_measBlockItemList)
    {
      std::list<measBlockItem *>::iterator iter;
      for (iter = a_measBlockItemList->begin();
           iter != a_measBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_enddoStm->printSelf();
}

doStm * measDoBlock::get_doStm()
{ return a_doStm; }
void measDoBlock::set_doStm(doStm * doStmIn)
{ a_doStm = doStmIn; }
std::list<measBlockItem *> * measDoBlock::get_measBlockItemList()
{ return a_measBlockItemList; }
void measDoBlock::set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn)
{ a_measBlockItemList = measBlockItemListIn; }
enddoStm * measDoBlock::get_enddoStm()
{ return a_enddoStm; }
void measDoBlock::set_enddoStm(enddoStm * enddoStmIn)
{ a_enddoStm = enddoStmIn; }

/********************************************************************/

measIfBlock::measIfBlock(){}

measIfBlock::measIfBlock(
  ifStm * ifStmIn,
  std::list<measBlockItem *> * ifListIn,
  elseStm * elseStmIn,
  std::list<measBlockItem *> * elseListIn,
  endifStm * endifStmIn)
{
  a_ifStm = ifStmIn;
  ifList = ifListIn;
  a_elseStm = elseStmIn;
  elseList = elseListIn;
  a_endifStm = endifStmIn;
}

measIfBlock::~measIfBlock(){}

void measIfBlock::printSelf()
{
  a_ifStm->printSelf();
  if (ifList)
    {
      std::list<measBlockItem *>::iterator iter;
      for (iter = ifList->begin();
           iter != ifList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_elseStm)
    {
      a_elseStm->printSelf();
      if (elseList)
        {
          std::list<measBlockItem *>::iterator iter;
          for (iter = elseList->begin();
               iter != elseList->end();
               iter++)
            (*iter)->printSelf();
        }
    }
  a_endifStm->printSelf();
}

ifStm * measIfBlock::get_ifStm()
{ return a_ifStm; }
void measIfBlock::set_ifStm(ifStm * ifStmIn)
{ a_ifStm = ifStmIn; }
std::list<measBlockItem *> * measIfBlock::get_ifList()
{ return ifList; }
void measIfBlock::set_ifList(std::list<measBlockItem *> * ifListIn)
{ ifList = ifListIn; }
elseStm * measIfBlock::get_elseStm()
{ return a_elseStm; }
void measIfBlock::set_elseStm(elseStm * elseStmIn)
{ a_elseStm = elseStmIn; }
std::list<measBlockItem *> * measIfBlock::get_elseList()
{ return elseList; }
void measIfBlock::set_elseList(std::list<measBlockItem *> * elseListIn)
{ elseList = elseListIn; }
endifStm * measIfBlock::get_endifStm()
{ return a_endifStm; }
void measIfBlock::set_endifStm(endifStm * endifStmIn)
{ a_endifStm = endifStmIn; }

/********************************************************************/

measSelectBlock::measSelectBlock(){}

measSelectBlock::measSelectBlock(
  selectStm * selectStmIn,
  std::list<measCaseBlock *> * measCaseBlockListIn,
  measDefaultCaseBlock * measDefaultCaseBlockIn,
  endselStm * endselStmIn)
{
  a_selectStm = selectStmIn;
  a_measCaseBlockList = measCaseBlockListIn;
  a_measDefaultCaseBlock = measDefaultCaseBlockIn;
  a_endselStm = endselStmIn;
}

measSelectBlock::~measSelectBlock(){}

void measSelectBlock::printSelf()
{
  a_selectStm->printSelf();
  if (1)
    {
      std::list<measCaseBlock *>::iterator iter;
      for (iter = a_measCaseBlockList->begin();
           iter != a_measCaseBlockList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_measDefaultCaseBlock)
    {
      a_measDefaultCaseBlock->printSelf();
    }
  a_endselStm->printSelf();
}

selectStm * measSelectBlock::get_selectStm()
{ return a_selectStm; }
void measSelectBlock::set_selectStm(selectStm * selectStmIn)
{ a_selectStm = selectStmIn; }
std::list<measCaseBlock *> * measSelectBlock::get_measCaseBlockList()
{ return a_measCaseBlockList; }
void measSelectBlock::set_measCaseBlockList(std::list<measCaseBlock *> * measCaseBlockListIn)
{ a_measCaseBlockList = measCaseBlockListIn; }
measDefaultCaseBlock * measSelectBlock::get_measDefaultCaseBlock()
{ return a_measDefaultCaseBlock; }
void measSelectBlock::set_measDefaultCaseBlock(measDefaultCaseBlock * measDefaultCaseBlockIn)
{ a_measDefaultCaseBlock = measDefaultCaseBlockIn; }
endselStm * measSelectBlock::get_endselStm()
{ return a_endselStm; }
void measSelectBlock::set_endselStm(endselStm * endselStmIn)
{ a_endselStm = endselStmIn; }

/********************************************************************/

measCaseBlock::measCaseBlock(){}

measCaseBlock::measCaseBlock(
  caseStm * caseStmIn,
  std::list<measBlockItem *> * measBlockItemListIn,
  endcasStm * endcasStmIn)
{
  a_caseStm = caseStmIn;
  a_measBlockItemList = measBlockItemListIn;
  a_endcasStm = endcasStmIn;
}

measCaseBlock::~measCaseBlock(){}

void measCaseBlock::printSelf()
{
  a_caseStm->printSelf();
  if (a_measBlockItemList)
    {
      std::list<measBlockItem *>::iterator iter;
      for (iter = a_measBlockItemList->begin();
           iter != a_measBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endcasStm->printSelf();
}

caseStm * measCaseBlock::get_caseStm()
{ return a_caseStm; }
void measCaseBlock::set_caseStm(caseStm * caseStmIn)
{ a_caseStm = caseStmIn; }
std::list<measBlockItem *> * measCaseBlock::get_measBlockItemList()
{ return a_measBlockItemList; }
void measCaseBlock::set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn)
{ a_measBlockItemList = measBlockItemListIn; }
endcasStm * measCaseBlock::get_endcasStm()
{ return a_endcasStm; }
void measCaseBlock::set_endcasStm(endcasStm * endcasStmIn)
{ a_endcasStm = endcasStmIn; }

/********************************************************************/

measDefaultCaseBlock::measDefaultCaseBlock(){}

measDefaultCaseBlock::measDefaultCaseBlock(
  dftcasStm * dftcasStmIn,
  std::list<measBlockItem *> * measBlockItemListIn,
  endcasStm * endcasStmIn)
{
  a_dftcasStm = dftcasStmIn;
  a_measBlockItemList = measBlockItemListIn;
  a_endcasStm = endcasStmIn;
}

measDefaultCaseBlock::~measDefaultCaseBlock(){}

void measDefaultCaseBlock::printSelf()
{
  a_dftcasStm->printSelf();
  if (a_measBlockItemList)
    {
      std::list<measBlockItem *>::iterator iter;
      for (iter = a_measBlockItemList->begin();
           iter != a_measBlockItemList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endcasStm->printSelf();
}

dftcasStm * measDefaultCaseBlock::get_dftcasStm()
{ return a_dftcasStm; }
void measDefaultCaseBlock::set_dftcasStm(dftcasStm * dftcasStmIn)
{ a_dftcasStm = dftcasStmIn; }
std::list<measBlockItem *> * measDefaultCaseBlock::get_measBlockItemList()
{ return a_measBlockItemList; }
void measDefaultCaseBlock::set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn)
{ a_measBlockItemList = measBlockItemListIn; }
endcasStm * measDefaultCaseBlock::get_endcasStm()
{ return a_endcasStm; }
void measDefaultCaseBlock::set_endcasStm(endcasStm * endcasStmIn)
{ a_endcasStm = endcasStmIn; }

/********************************************************************/

selectBlock::selectBlock(){}

selectBlock::selectBlock(
  selectStm * selectStmIn,
  std::list<caseBlock *> * caseBlockListIn,
  defaultCaseBlock * defaultCaseBlockIn,
  endselStm * endselStmIn)
{
  a_selectStm = selectStmIn;
  a_caseBlockList = caseBlockListIn;
  a_defaultCaseBlock = defaultCaseBlockIn;
  a_endselStm = endselStmIn;
}

selectBlock::~selectBlock(){}

void selectBlock::printSelf()
{
  a_selectStm->printSelf();
  if (1)
    {
      std::list<caseBlock *>::iterator iter;
      for (iter = a_caseBlockList->begin();
           iter != a_caseBlockList->end();
           iter++)
        (*iter)->printSelf();
    }
  if (a_defaultCaseBlock)
    {
      a_defaultCaseBlock->printSelf();
    }
  a_endselStm->printSelf();
}

selectStm * selectBlock::get_selectStm()
{ return a_selectStm; }
void selectBlock::set_selectStm(selectStm * selectStmIn)
{ a_selectStm = selectStmIn; }
std::list<caseBlock *> * selectBlock::get_caseBlockList()
{ return a_caseBlockList; }
void selectBlock::set_caseBlockList(std::list<caseBlock *> * caseBlockListIn)
{ a_caseBlockList = caseBlockListIn; }
defaultCaseBlock * selectBlock::get_defaultCaseBlock()
{ return a_defaultCaseBlock; }
void selectBlock::set_defaultCaseBlock(defaultCaseBlock * defaultCaseBlockIn)
{ a_defaultCaseBlock = defaultCaseBlockIn; }
endselStm * selectBlock::get_endselStm()
{ return a_endselStm; }
void selectBlock::set_endselStm(endselStm * endselStmIn)
{ a_endselStm = endselStmIn; }

/********************************************************************/

simreqtBlock::simreqtBlock(){}

simreqtBlock::simreqtBlock(
  simreqtStm * simreqtStmIn,
  std::list<evalOrOutput *> * evalOrOutputListIn,
  endsimreqtStm * endsimreqtStmIn)
{
  a_simreqtStm = simreqtStmIn;
  a_evalOrOutputList = evalOrOutputListIn;
  a_endsimreqtStm = endsimreqtStmIn;
}

simreqtBlock::~simreqtBlock(){}

void simreqtBlock::printSelf()
{
  a_simreqtStm->printSelf();
  if (a_evalOrOutputList)
    {
      std::list<evalOrOutput *>::iterator iter;
      for (iter = a_evalOrOutputList->begin();
           iter != a_evalOrOutputList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endsimreqtStm->printSelf();
}

simreqtStm * simreqtBlock::get_simreqtStm()
{ return a_simreqtStm; }
void simreqtBlock::set_simreqtStm(simreqtStm * simreqtStmIn)
{ a_simreqtStm = simreqtStmIn; }
std::list<evalOrOutput *> * simreqtBlock::get_evalOrOutputList()
{ return a_evalOrOutputList; }
void simreqtBlock::set_evalOrOutputList(std::list<evalOrOutput *> * evalOrOutputListIn)
{ a_evalOrOutputList = evalOrOutputListIn; }
endsimreqtStm * simreqtBlock::get_endsimreqtStm()
{ return a_endsimreqtStm; }
void simreqtBlock::set_endsimreqtStm(endsimreqtStm * endsimreqtStmIn)
{ a_endsimreqtStm = endsimreqtStmIn; }

/********************************************************************/

evalOrOutput::evalOrOutput(){};

evalOrOutput::~evalOrOutput(){}

/********************************************************************/

xternBlock::xternBlock(){}

xternBlock::xternBlock(
  xternStm * xternStmIn,
  std::list<extfilStm *> * extfilListIn,
  endxtnStm * endxtnStmIn)
{
  a_xternStm = xternStmIn;
  a_extfilList = extfilListIn;
  a_endxtnStm = endxtnStmIn;
}

xternBlock::~xternBlock(){}

void xternBlock::printSelf()
{
  a_xternStm->printSelf();
  if (a_extfilList)
    {
      std::list<extfilStm *>::iterator iter;
      for (iter = a_extfilList->begin();
           iter != a_extfilList->end();
           iter++)
        (*iter)->printSelf();
    }
  a_endxtnStm->printSelf();
}

xternStm * xternBlock::get_xternStm()
{ return a_xternStm; }
void xternBlock::set_xternStm(xternStm * xternStmIn)
{ a_xternStm = xternStmIn; }
std::list<extfilStm *> * xternBlock::get_extfilList()
{ return a_extfilList; }
void xternBlock::set_extfilList(std::list<extfilStm *> * extfilListIn)
{ a_extfilList = extfilListIn; }
endxtnStm * xternBlock::get_endxtnStm()
{ return a_endxtnStm; }
void xternBlock::set_endxtnStm(endxtnStm * endxtnStmIn)
{ a_endxtnStm = endxtnStmIn; }

/********************************************************************/

dmisFreeStatement::dmisFreeStatement(){};

dmisFreeStatement::~dmisFreeStatement(){}

/********************************************************************/

stringRel::stringRel(){};

stringRel::~stringRel(){}

/********************************************************************/

stringRel_EQ::stringRel_EQ(){}

stringRel_EQ::stringRel_EQ(
  stringVal * leftIn,
  stringVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

stringRel_EQ::~stringRel_EQ(){}

void stringRel_EQ::printSelf()
{
  left->printSelf();
  printf(".EQ.");
  right->printSelf();
}

stringVal * stringRel_EQ::get_left()
{ return left; }
void stringRel_EQ::set_left(stringVal * leftIn)
{ left = leftIn; }
stringVal * stringRel_EQ::get_right()
{ return right; }
void stringRel_EQ::set_right(stringVal * rightIn)
{ right = rightIn; }

/********************************************************************/

stringRel_NE::stringRel_NE(){}

stringRel_NE::stringRel_NE(
  stringVal * leftIn,
  stringVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

stringRel_NE::~stringRel_NE(){}

void stringRel_NE::printSelf()
{
  left->printSelf();
  printf(".NE.");
  right->printSelf();
}

stringVal * stringRel_NE::get_left()
{ return left; }
void stringRel_NE::set_left(stringVal * leftIn)
{ left = leftIn; }
stringVal * stringRel_NE::get_right()
{ return right; }
void stringRel_NE::set_right(stringVal * rightIn)
{ right = rightIn; }

/********************************************************************/

stringRel_LT::stringRel_LT(){}

stringRel_LT::stringRel_LT(
  stringVal * leftIn,
  stringVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

stringRel_LT::~stringRel_LT(){}

void stringRel_LT::printSelf()
{
  left->printSelf();
  printf(".LT.");
  right->printSelf();
}

stringVal * stringRel_LT::get_left()
{ return left; }
void stringRel_LT::set_left(stringVal * leftIn)
{ left = leftIn; }
stringVal * stringRel_LT::get_right()
{ return right; }
void stringRel_LT::set_right(stringVal * rightIn)
{ right = rightIn; }

/********************************************************************/

stringRel_LE::stringRel_LE(){}

stringRel_LE::stringRel_LE(
  stringVal * leftIn,
  stringVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

stringRel_LE::~stringRel_LE(){}

void stringRel_LE::printSelf()
{
  left->printSelf();
  printf(".LE.");
  right->printSelf();
}

stringVal * stringRel_LE::get_left()
{ return left; }
void stringRel_LE::set_left(stringVal * leftIn)
{ left = leftIn; }
stringVal * stringRel_LE::get_right()
{ return right; }
void stringRel_LE::set_right(stringVal * rightIn)
{ right = rightIn; }

/********************************************************************/

stringRel_GT::stringRel_GT(){}

stringRel_GT::stringRel_GT(
  stringVal * leftIn,
  stringVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

stringRel_GT::~stringRel_GT(){}

void stringRel_GT::printSelf()
{
  left->printSelf();
  printf(".GT.");
  right->printSelf();
}

stringVal * stringRel_GT::get_left()
{ return left; }
void stringRel_GT::set_left(stringVal * leftIn)
{ left = leftIn; }
stringVal * stringRel_GT::get_right()
{ return right; }
void stringRel_GT::set_right(stringVal * rightIn)
{ right = rightIn; }

/********************************************************************/

stringRel_GE::stringRel_GE(){}

stringRel_GE::stringRel_GE(
  stringVal * leftIn,
  stringVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

stringRel_GE::~stringRel_GE(){}

void stringRel_GE::printSelf()
{
  left->printSelf();
  printf(".GE.");
  right->printSelf();
}

stringVal * stringRel_GE::get_left()
{ return left; }
void stringRel_GE::set_left(stringVal * leftIn)
{ left = leftIn; }
stringVal * stringRel_GE::get_right()
{ return right; }
void stringRel_GE::set_right(stringVal * rightIn)
{ right = rightIn; }

/********************************************************************/

boolRel::boolRel(){};

boolRel::~boolRel(){}

/********************************************************************/

boolRel_NOT::boolRel_NOT(){}

boolRel_NOT::boolRel_NOT(
  boolVal * boolValIn)
{
  a_boolVal = boolValIn;
}

boolRel_NOT::~boolRel_NOT(){}

void boolRel_NOT::printSelf()
{
  printf(".NOT.");
  a_boolVal->printSelf();
}

boolVal * boolRel_NOT::get_boolVal()
{ return a_boolVal; }
void boolRel_NOT::set_boolVal(boolVal * boolValIn)
{ a_boolVal = boolValIn; }

/********************************************************************/

boolRel_AND::boolRel_AND(){}

boolRel_AND::boolRel_AND(
  boolVal * leftIn,
  boolVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

boolRel_AND::~boolRel_AND(){}

void boolRel_AND::printSelf()
{
  left->printSelf();
  printf(".AND.");
  right->printSelf();
}

boolVal * boolRel_AND::get_left()
{ return left; }
void boolRel_AND::set_left(boolVal * leftIn)
{ left = leftIn; }
boolVal * boolRel_AND::get_right()
{ return right; }
void boolRel_AND::set_right(boolVal * rightIn)
{ right = rightIn; }

/********************************************************************/

boolRel_OR::boolRel_OR(){}

boolRel_OR::boolRel_OR(
  boolVal * leftIn,
  boolVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

boolRel_OR::~boolRel_OR(){}

void boolRel_OR::printSelf()
{
  left->printSelf();
  printf(".OR.");
  right->printSelf();
}

boolVal * boolRel_OR::get_left()
{ return left; }
void boolRel_OR::set_left(boolVal * leftIn)
{ left = leftIn; }
boolVal * boolRel_OR::get_right()
{ return right; }
void boolRel_OR::set_right(boolVal * rightIn)
{ right = rightIn; }

/********************************************************************/

boolRel_EQ::boolRel_EQ(){}

boolRel_EQ::boolRel_EQ(
  boolVal * leftIn,
  boolVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

boolRel_EQ::~boolRel_EQ(){}

void boolRel_EQ::printSelf()
{
  left->printSelf();
  printf(".EQ.");
  right->printSelf();
}

boolVal * boolRel_EQ::get_left()
{ return left; }
void boolRel_EQ::set_left(boolVal * leftIn)
{ left = leftIn; }
boolVal * boolRel_EQ::get_right()
{ return right; }
void boolRel_EQ::set_right(boolVal * rightIn)
{ right = rightIn; }

/********************************************************************/

boolRel_NE::boolRel_NE(){}

boolRel_NE::boolRel_NE(
  boolVal * leftIn,
  boolVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

boolRel_NE::~boolRel_NE(){}

void boolRel_NE::printSelf()
{
  left->printSelf();
  printf(".NE.");
  right->printSelf();
}

boolVal * boolRel_NE::get_left()
{ return left; }
void boolRel_NE::set_left(boolVal * leftIn)
{ left = leftIn; }
boolVal * boolRel_NE::get_right()
{ return right; }
void boolRel_NE::set_right(boolVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRel::intRel(){};

intRel::~intRel(){}

/********************************************************************/

intRel_EQ::intRel_EQ(){}

intRel_EQ::intRel_EQ(
  intVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRel_EQ::~intRel_EQ(){}

void intRel_EQ::printSelf()
{
  left->printSelf();
  printf(".EQ.");
  right->printSelf();
}

intVal * intRel_EQ::get_left()
{ return left; }
void intRel_EQ::set_left(intVal * leftIn)
{ left = leftIn; }
intVal * intRel_EQ::get_right()
{ return right; }
void intRel_EQ::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRel_NE::intRel_NE(){}

intRel_NE::intRel_NE(
  intVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRel_NE::~intRel_NE(){}

void intRel_NE::printSelf()
{
  left->printSelf();
  printf(".NE.");
  right->printSelf();
}

intVal * intRel_NE::get_left()
{ return left; }
void intRel_NE::set_left(intVal * leftIn)
{ left = leftIn; }
intVal * intRel_NE::get_right()
{ return right; }
void intRel_NE::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRel_LT::intRel_LT(){}

intRel_LT::intRel_LT(
  intVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRel_LT::~intRel_LT(){}

void intRel_LT::printSelf()
{
  left->printSelf();
  printf(".LT.");
  right->printSelf();
}

intVal * intRel_LT::get_left()
{ return left; }
void intRel_LT::set_left(intVal * leftIn)
{ left = leftIn; }
intVal * intRel_LT::get_right()
{ return right; }
void intRel_LT::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRel_LE::intRel_LE(){}

intRel_LE::intRel_LE(
  intVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRel_LE::~intRel_LE(){}

void intRel_LE::printSelf()
{
  left->printSelf();
  printf(".LE.");
  right->printSelf();
}

intVal * intRel_LE::get_left()
{ return left; }
void intRel_LE::set_left(intVal * leftIn)
{ left = leftIn; }
intVal * intRel_LE::get_right()
{ return right; }
void intRel_LE::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRel_GT::intRel_GT(){}

intRel_GT::intRel_GT(
  intVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRel_GT::~intRel_GT(){}

void intRel_GT::printSelf()
{
  left->printSelf();
  printf(".GT.");
  right->printSelf();
}

intVal * intRel_GT::get_left()
{ return left; }
void intRel_GT::set_left(intVal * leftIn)
{ left = leftIn; }
intVal * intRel_GT::get_right()
{ return right; }
void intRel_GT::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRel_GE::intRel_GE(){}

intRel_GE::intRel_GE(
  intVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRel_GE::~intRel_GE(){}

void intRel_GE::printSelf()
{
  left->printSelf();
  printf(".GE.");
  right->printSelf();
}

intVal * intRel_GE::get_left()
{ return left; }
void intRel_GE::set_left(intVal * leftIn)
{ left = leftIn; }
intVal * intRel_GE::get_right()
{ return right; }
void intRel_GE::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realRel::realRel(){};

realRel::~realRel(){}

/********************************************************************/

realRealRel::realRealRel(){};

realRealRel::~realRealRel(){}

/********************************************************************/

realRealRel_EQ::realRealRel_EQ(){}

realRealRel_EQ::realRealRel_EQ(
  realVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realRealRel_EQ::~realRealRel_EQ(){}

void realRealRel_EQ::printSelf()
{
  left->printSelf();
  printf(".EQ.");
  right->printSelf();
}

realVal * realRealRel_EQ::get_left()
{ return left; }
void realRealRel_EQ::set_left(realVal * leftIn)
{ left = leftIn; }
realVal * realRealRel_EQ::get_right()
{ return right; }
void realRealRel_EQ::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realRealRel_NE::realRealRel_NE(){}

realRealRel_NE::realRealRel_NE(
  realVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realRealRel_NE::~realRealRel_NE(){}

void realRealRel_NE::printSelf()
{
  left->printSelf();
  printf(".NE.");
  right->printSelf();
}

realVal * realRealRel_NE::get_left()
{ return left; }
void realRealRel_NE::set_left(realVal * leftIn)
{ left = leftIn; }
realVal * realRealRel_NE::get_right()
{ return right; }
void realRealRel_NE::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realRealRel_LT::realRealRel_LT(){}

realRealRel_LT::realRealRel_LT(
  realVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realRealRel_LT::~realRealRel_LT(){}

void realRealRel_LT::printSelf()
{
  left->printSelf();
  printf(".LT.");
  right->printSelf();
}

realVal * realRealRel_LT::get_left()
{ return left; }
void realRealRel_LT::set_left(realVal * leftIn)
{ left = leftIn; }
realVal * realRealRel_LT::get_right()
{ return right; }
void realRealRel_LT::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realRealRel_LE::realRealRel_LE(){}

realRealRel_LE::realRealRel_LE(
  realVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realRealRel_LE::~realRealRel_LE(){}

void realRealRel_LE::printSelf()
{
  left->printSelf();
  printf(".LE.");
  right->printSelf();
}

realVal * realRealRel_LE::get_left()
{ return left; }
void realRealRel_LE::set_left(realVal * leftIn)
{ left = leftIn; }
realVal * realRealRel_LE::get_right()
{ return right; }
void realRealRel_LE::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realRealRel_GT::realRealRel_GT(){}

realRealRel_GT::realRealRel_GT(
  realVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realRealRel_GT::~realRealRel_GT(){}

void realRealRel_GT::printSelf()
{
  left->printSelf();
  printf(".GT.");
  right->printSelf();
}

realVal * realRealRel_GT::get_left()
{ return left; }
void realRealRel_GT::set_left(realVal * leftIn)
{ left = leftIn; }
realVal * realRealRel_GT::get_right()
{ return right; }
void realRealRel_GT::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realRealRel_GE::realRealRel_GE(){}

realRealRel_GE::realRealRel_GE(
  realVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realRealRel_GE::~realRealRel_GE(){}

void realRealRel_GE::printSelf()
{
  left->printSelf();
  printf(".GE.");
  right->printSelf();
}

realVal * realRealRel_GE::get_left()
{ return left; }
void realRealRel_GE::set_left(realVal * leftIn)
{ left = leftIn; }
realVal * realRealRel_GE::get_right()
{ return right; }
void realRealRel_GE::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRealRel::intRealRel(){};

intRealRel::~intRealRel(){}

/********************************************************************/

intRealRel_EQ::intRealRel_EQ(){}

intRealRel_EQ::intRealRel_EQ(
  intVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRealRel_EQ::~intRealRel_EQ(){}

void intRealRel_EQ::printSelf()
{
  left->printSelf();
  printf(".EQ.");
  right->printSelf();
}

intVal * intRealRel_EQ::get_left()
{ return left; }
void intRealRel_EQ::set_left(intVal * leftIn)
{ left = leftIn; }
realVal * intRealRel_EQ::get_right()
{ return right; }
void intRealRel_EQ::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRealRel_NE::intRealRel_NE(){}

intRealRel_NE::intRealRel_NE(
  intVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRealRel_NE::~intRealRel_NE(){}

void intRealRel_NE::printSelf()
{
  left->printSelf();
  printf(".NE.");
  right->printSelf();
}

intVal * intRealRel_NE::get_left()
{ return left; }
void intRealRel_NE::set_left(intVal * leftIn)
{ left = leftIn; }
realVal * intRealRel_NE::get_right()
{ return right; }
void intRealRel_NE::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRealRel_LT::intRealRel_LT(){}

intRealRel_LT::intRealRel_LT(
  intVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRealRel_LT::~intRealRel_LT(){}

void intRealRel_LT::printSelf()
{
  left->printSelf();
  printf(".LT.");
  right->printSelf();
}

intVal * intRealRel_LT::get_left()
{ return left; }
void intRealRel_LT::set_left(intVal * leftIn)
{ left = leftIn; }
realVal * intRealRel_LT::get_right()
{ return right; }
void intRealRel_LT::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRealRel_LE::intRealRel_LE(){}

intRealRel_LE::intRealRel_LE(
  intVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRealRel_LE::~intRealRel_LE(){}

void intRealRel_LE::printSelf()
{
  left->printSelf();
  printf(".LE.");
  right->printSelf();
}

intVal * intRealRel_LE::get_left()
{ return left; }
void intRealRel_LE::set_left(intVal * leftIn)
{ left = leftIn; }
realVal * intRealRel_LE::get_right()
{ return right; }
void intRealRel_LE::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRealRel_GT::intRealRel_GT(){}

intRealRel_GT::intRealRel_GT(
  intVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRealRel_GT::~intRealRel_GT(){}

void intRealRel_GT::printSelf()
{
  left->printSelf();
  printf(".GT.");
  right->printSelf();
}

intVal * intRealRel_GT::get_left()
{ return left; }
void intRealRel_GT::set_left(intVal * leftIn)
{ left = leftIn; }
realVal * intRealRel_GT::get_right()
{ return right; }
void intRealRel_GT::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

intRealRel_GE::intRealRel_GE(){}

intRealRel_GE::intRealRel_GE(
  intVal * leftIn,
  realVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

intRealRel_GE::~intRealRel_GE(){}

void intRealRel_GE::printSelf()
{
  left->printSelf();
  printf(".GE.");
  right->printSelf();
}

intVal * intRealRel_GE::get_left()
{ return left; }
void intRealRel_GE::set_left(intVal * leftIn)
{ left = leftIn; }
realVal * intRealRel_GE::get_right()
{ return right; }
void intRealRel_GE::set_right(realVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realIntRel::realIntRel(){};

realIntRel::~realIntRel(){}

/********************************************************************/

realIntRel_EQ::realIntRel_EQ(){}

realIntRel_EQ::realIntRel_EQ(
  realVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realIntRel_EQ::~realIntRel_EQ(){}

void realIntRel_EQ::printSelf()
{
  left->printSelf();
  printf(".EQ.");
  right->printSelf();
}

realVal * realIntRel_EQ::get_left()
{ return left; }
void realIntRel_EQ::set_left(realVal * leftIn)
{ left = leftIn; }
intVal * realIntRel_EQ::get_right()
{ return right; }
void realIntRel_EQ::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realIntRel_NE::realIntRel_NE(){}

realIntRel_NE::realIntRel_NE(
  realVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realIntRel_NE::~realIntRel_NE(){}

void realIntRel_NE::printSelf()
{
  left->printSelf();
  printf(".NE.");
  right->printSelf();
}

realVal * realIntRel_NE::get_left()
{ return left; }
void realIntRel_NE::set_left(realVal * leftIn)
{ left = leftIn; }
intVal * realIntRel_NE::get_right()
{ return right; }
void realIntRel_NE::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realIntRel_LT::realIntRel_LT(){}

realIntRel_LT::realIntRel_LT(
  realVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realIntRel_LT::~realIntRel_LT(){}

void realIntRel_LT::printSelf()
{
  left->printSelf();
  printf(".LT.");
  right->printSelf();
}

realVal * realIntRel_LT::get_left()
{ return left; }
void realIntRel_LT::set_left(realVal * leftIn)
{ left = leftIn; }
intVal * realIntRel_LT::get_right()
{ return right; }
void realIntRel_LT::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realIntRel_LE::realIntRel_LE(){}

realIntRel_LE::realIntRel_LE(
  realVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realIntRel_LE::~realIntRel_LE(){}

void realIntRel_LE::printSelf()
{
  left->printSelf();
  printf(".LE.");
  right->printSelf();
}

realVal * realIntRel_LE::get_left()
{ return left; }
void realIntRel_LE::set_left(realVal * leftIn)
{ left = leftIn; }
intVal * realIntRel_LE::get_right()
{ return right; }
void realIntRel_LE::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realIntRel_GT::realIntRel_GT(){}

realIntRel_GT::realIntRel_GT(
  realVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realIntRel_GT::~realIntRel_GT(){}

void realIntRel_GT::printSelf()
{
  left->printSelf();
  printf(".GT.");
  right->printSelf();
}

realVal * realIntRel_GT::get_left()
{ return left; }
void realIntRel_GT::set_left(realVal * leftIn)
{ left = leftIn; }
intVal * realIntRel_GT::get_right()
{ return right; }
void realIntRel_GT::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

realIntRel_GE::realIntRel_GE(){}

realIntRel_GE::realIntRel_GE(
  realVal * leftIn,
  intVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

realIntRel_GE::~realIntRel_GE(){}

void realIntRel_GE::printSelf()
{
  left->printSelf();
  printf(".GE.");
  right->printSelf();
}

realVal * realIntRel_GE::get_left()
{ return left; }
void realIntRel_GE::set_left(realVal * leftIn)
{ left = leftIn; }
intVal * realIntRel_GE::get_right()
{ return right; }
void realIntRel_GE::set_right(intVal * rightIn)
{ right = rightIn; }

/********************************************************************/

vectorRel::vectorRel(){};

vectorRel::~vectorRel(){}

/********************************************************************/

vectorRel_EQ::vectorRel_EQ(){}

vectorRel_EQ::vectorRel_EQ(
  vectorVal * leftIn,
  vectorVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

vectorRel_EQ::~vectorRel_EQ(){}

void vectorRel_EQ::printSelf()
{
  left->printSelf();
  printf(".EQ.");
  right->printSelf();
}

vectorVal * vectorRel_EQ::get_left()
{ return left; }
void vectorRel_EQ::set_left(vectorVal * leftIn)
{ left = leftIn; }
vectorVal * vectorRel_EQ::get_right()
{ return right; }
void vectorRel_EQ::set_right(vectorVal * rightIn)
{ right = rightIn; }

/********************************************************************/

vectorRel_NE::vectorRel_NE(){}

vectorRel_NE::vectorRel_NE(
  vectorVal * leftIn,
  vectorVal * rightIn)
{
  left = leftIn;
  right = rightIn;
}

vectorRel_NE::~vectorRel_NE(){}

void vectorRel_NE::printSelf()
{
  left->printSelf();
  printf(".NE.");
  right->printSelf();
}

vectorVal * vectorRel_NE::get_left()
{ return left; }
void vectorRel_NE::set_left(vectorVal * leftIn)
{ left = leftIn; }
vectorVal * vectorRel_NE::get_right()
{ return right; }
void vectorRel_NE::set_right(vectorVal * rightIn)
{ right = rightIn; }

/********************************************************************/

arrayIndex::arrayIndex(){}

arrayIndex::arrayIndex(
  std::list<intVal *> * indexesIn)
{
  indexes = indexesIn;
}

arrayIndex::~arrayIndex(){}

void arrayIndex::printSelf()
{
  printf("[");
  if (indexes->begin() == indexes->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<intVal *>::iterator iter;
      for (iter = indexes->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == indexes->end())
            break;
          printf(",");
        }
    }
  printf("]");
}

std::list<intVal *> * arrayIndex::get_indexes()
{ return indexes; }
void arrayIndex::set_indexes(std::list<intVal *> * indexesIn)
{ indexes = indexesIn; }

/********************************************************************/

longShort::longShort(){};

longShort::~longShort(){}

/********************************************************************/

longShort_LONG::longShort_LONG(){}

longShort_LONG::~longShort_LONG(){}

void longShort_LONG::printSelf()
{
  printf("LONG");
}

/********************************************************************/

longShort_SHORT::longShort_SHORT(){}

longShort_SHORT::~longShort_SHORT(){}

void longShort_SHORT::printSelf()
{
  printf("SHORT");
}

/********************************************************************/

strVar7::strVar7(){}

strVar7::strVar7(
  intVal * widthIn,
  intVal * decimalIn)
{
  width = widthIn;
  decimal = decimalIn;
}

strVar7::~strVar7(){}

void strVar7::printSelf()
{
  printf(",");
  width->printSelf();
  if (decimal)
    {
      printf(":");
      decimal->printSelf();
    }
}

intVal * strVar7::get_width()
{ return width; }
void strVar7::set_width(intVal * widthIn)
{ width = widthIn; }
intVal * strVar7::get_decimal()
{ return decimal; }
void strVar7::set_decimal(intVal * decimalIn)
{ decimal = decimalIn; }

/********************************************************************/

labelNameConst::labelNameConst(){}

labelNameConst::labelNameConst(
  char * stringIn)
{
  a_string = stringIn;
}

labelNameConst::~labelNameConst(){}

void labelNameConst::printSelf()
{
  printf("(");
  printf("%s", a_string);
  printf(")");
}

char * labelNameConst::get_string()
{ return a_string; }
void labelNameConst::set_string(char * stringIn)
{ a_string = stringIn; }

/********************************************************************/

datumLabel::datumLabel(){};

datumLabel::~datumLabel(){}

/********************************************************************/

datumLabel1::datumLabel1(){};

datumLabel1::~datumLabel1(){}

/********************************************************************/

datumLabel2::datumLabel2(){};

datumLabel2::~datumLabel2(){}

/********************************************************************/

featureLabel1::featureLabel1(){};

featureLabel1::~featureLabel1(){}

/********************************************************************/

sensorLabel1::sensorLabel1(){};

sensorLabel1::~sensorLabel1(){}

/********************************************************************/

sensorLabel2::sensorLabel2(){};

sensorLabel2::~sensorLabel2(){}

/********************************************************************/

toleranceLabel::toleranceLabel(){};

toleranceLabel::~toleranceLabel(){}

/********************************************************************/

crLabel::crLabel(){}

crLabel::crLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

crLabel::~crLabel(){}

void crLabel::printSelf()
{
  printf("CR");
  a_labelName->printSelf();
}

labelName * crLabel::get_labelName()
{ return a_labelName; }
void crLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

crLabelConst::crLabelConst(){}

crLabelConst::crLabelConst(
  labelNameConst * labelNameConstIn)
{
  a_labelNameConst = labelNameConstIn;
}

crLabelConst::~crLabelConst(){}

void crLabelConst::printSelf()
{
  printf("CR");
  a_labelNameConst->printSelf();
}

labelNameConst * crLabelConst::get_labelNameConst()
{ return a_labelNameConst; }
void crLabelConst::set_labelNameConst(labelNameConst * labelNameConstIn)
{ a_labelNameConst = labelNameConstIn; }

/********************************************************************/

czLabel::czLabel(){}

czLabel::czLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

czLabel::~czLabel(){}

void czLabel::printSelf()
{
  printf("CZ");
  a_labelName->printSelf();
}

labelName * czLabel::get_labelName()
{ return a_labelName; }
void czLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

dLabel::dLabel(){}

dLabel::dLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

dLabel::~dLabel(){}

void dLabel::printSelf()
{
  printf("D");
  a_labelName->printSelf();
}

labelName * dLabel::get_labelName()
{ return a_labelName; }
void dLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

daLabel::daLabel(){}

daLabel::daLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

daLabel::~daLabel(){}

void daLabel::printSelf()
{
  printf("DA");
  a_labelName->printSelf();
}

labelName * daLabel::get_labelName()
{ return a_labelName; }
void daLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

dattrgLabel::dattrgLabel(){}

dattrgLabel::dattrgLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

dattrgLabel::~dattrgLabel(){}

void dattrgLabel::printSelf()
{
  printf("DATTRG");
  a_labelName->printSelf();
}

labelName * dattrgLabel::get_labelName()
{ return a_labelName; }
void dattrgLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

didLabel::didLabel(){}

didLabel::didLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

didLabel::~didLabel(){}

void didLabel::printSelf()
{
  printf("DID");
  a_labelName->printSelf();
}

labelName * didLabel::get_labelName()
{ return a_labelName; }
void didLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

drLabel::drLabel(){}

drLabel::drLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

drLabel::~drLabel(){}

void drLabel::printSelf()
{
  printf("DR");
  a_labelName->printSelf();
}

labelName * drLabel::get_labelName()
{ return a_labelName; }
void drLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

gsaLabel::gsaLabel(){}

gsaLabel::gsaLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

gsaLabel::~gsaLabel(){}

void gsaLabel::printSelf()
{
  printf("GSA");
  a_labelName->printSelf();
}

labelName * gsaLabel::get_labelName()
{ return a_labelName; }
void gsaLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

mLabel::mLabel(){}

mLabel::mLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

mLabel::~mLabel(){}

void mLabel::printSelf()
{
  printf("M");
  a_labelName->printSelf();
}

labelName * mLabel::get_labelName()
{ return a_labelName; }
void mLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

mLabelConst::mLabelConst(){}

mLabelConst::mLabelConst(
  labelNameConst * labelNameConstIn)
{
  a_labelNameConst = labelNameConstIn;
}

mLabelConst::~mLabelConst(){}

void mLabelConst::printSelf()
{
  printf("M");
  a_labelNameConst->printSelf();
}

labelNameConst * mLabelConst::get_labelNameConst()
{ return a_labelNameConst; }
void mLabelConst::set_labelNameConst(labelNameConst * labelNameConstIn)
{ a_labelNameConst = labelNameConstIn; }

/********************************************************************/

pLabel::pLabel(){}

pLabel::pLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

pLabel::~pLabel(){}

void pLabel::printSelf()
{
  printf("P");
  a_labelName->printSelf();
}

labelName * pLabel::get_labelName()
{ return a_labelName; }
void pLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

rtLabel::rtLabel(){}

rtLabel::rtLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

rtLabel::~rtLabel(){}

void rtLabel::printSelf()
{
  printf("RT");
  a_labelName->printSelf();
}

labelName * rtLabel::get_labelName()
{ return a_labelName; }
void rtLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

sLabel::sLabel(){}

sLabel::sLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

sLabel::~sLabel(){}

void sLabel::printSelf()
{
  printf("S");
  a_labelName->printSelf();
}

labelName * sLabel::get_labelName()
{ return a_labelName; }
void sLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

saLabel::saLabel(){}

saLabel::saLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

saLabel::~saLabel(){}

void saLabel::printSelf()
{
  printf("SA");
  a_labelName->printSelf();
}

labelName * saLabel::get_labelName()
{ return a_labelName; }
void saLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

seLabel::seLabel(){}

seLabel::seLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

seLabel::~seLabel(){}

void seLabel::printSelf()
{
  printf("SE");
  a_labelName->printSelf();
}

labelName * seLabel::get_labelName()
{ return a_labelName; }
void seLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

srLabel::srLabel(){}

srLabel::srLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

srLabel::~srLabel(){}

void srLabel::printSelf()
{
  printf("SR");
  a_labelName->printSelf();
}

labelName * srLabel::get_labelName()
{ return a_labelName; }
void srLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

sraLabel::sraLabel(){}

sraLabel::sraLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

sraLabel::~sraLabel(){}

void sraLabel::printSelf()
{
  printf("SRA");
  a_labelName->printSelf();
}

labelName * sraLabel::get_labelName()
{ return a_labelName; }
void sraLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

stLabel::stLabel(){}

stLabel::stLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

stLabel::~stLabel(){}

void stLabel::printSelf()
{
  printf("ST");
  a_labelName->printSelf();
}

labelName * stLabel::get_labelName()
{ return a_labelName; }
void stLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

thLabel::thLabel(){}

thLabel::thLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

thLabel::~thLabel(){}

void thLabel::printSelf()
{
  printf("TH");
  a_labelName->printSelf();
}

labelName * thLabel::get_labelName()
{ return a_labelName; }
void thLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

uLabel::uLabel(){}

uLabel::uLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

uLabel::~uLabel(){}

void uLabel::printSelf()
{
  printf("U");
  a_labelName->printSelf();
}

labelName * uLabel::get_labelName()
{ return a_labelName; }
void uLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

vLabel::vLabel(){}

vLabel::vLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

vLabel::~vLabel(){}

void vLabel::printSelf()
{
  printf("V");
  a_labelName->printSelf();
}

labelName * vLabel::get_labelName()
{ return a_labelName; }
void vLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

vlLabel::vlLabel(){}

vlLabel::vlLabel(
  labelName * labelNameIn)
{
  a_labelName = labelNameIn;
}

vlLabel::~vlLabel(){}

void vlLabel::printSelf()
{
  printf("VL");
  a_labelName->printSelf();
}

labelName * vlLabel::get_labelName()
{ return a_labelName; }
void vlLabel::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }

/********************************************************************/

jumpLabel::jumpLabel(){};

jumpLabel::~jumpLabel(){}

/********************************************************************/

param::param(){};

param::~param(){}

/********************************************************************/

leftRight::leftRight(){};

leftRight::~leftRight(){}

/********************************************************************/

leftRight_LEFT::leftRight_LEFT(){}

leftRight_LEFT::~leftRight_LEFT(){}

void leftRight_LEFT::printSelf()
{
  printf("LEFT");
}

/********************************************************************/

leftRight_RIGHT::leftRight_RIGHT(){}

leftRight_RIGHT::~leftRight_RIGHT(){}

void leftRight_RIGHT::printSelf()
{
  printf("RIGHT");
}

/********************************************************************/

pointRange::pointRange(){}

pointRange::pointRange(
  intVal * index1In,
  intVal * index2In)
{
  index1 = index1In;
  index2 = index2In;
}

pointRange::~pointRange(){}

void pointRange::printSelf()
{
  printf("[");
  index1->printSelf();
  if (index2)
    {
      printf(",");
      index2->printSelf();
    }
  printf("]");
}

intVal * pointRange::get_index1()
{ return index1; }
void pointRange::set_index1(intVal * index1In)
{ index1 = index1In; }
intVal * pointRange::get_index2()
{ return index2; }
void pointRange::set_index2(intVal * index2In)
{ index2 = index2In; }

/********************************************************************/

indexedFeature::indexedFeature(){}

indexedFeature::indexedFeature(
  featureLabel * featureLabelIn,
  pointRange * pointRangeIn)
{
  a_featureLabel = featureLabelIn;
  a_pointRange = pointRangeIn;
}

indexedFeature::~indexedFeature(){}

void indexedFeature::printSelf()
{
  a_featureLabel->printSelf();
  a_pointRange->printSelf();
}

featureLabel * indexedFeature::get_featureLabel()
{ return a_featureLabel; }
void indexedFeature::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
pointRange * indexedFeature::get_pointRange()
{ return a_pointRange; }
void indexedFeature::set_pointRange(pointRange * pointRangeIn)
{ a_pointRange = pointRangeIn; }

/********************************************************************/

versionTag::versionTag(){}

versionTag::versionTag(
  double doubleIn)
{
  a_double = doubleIn;
}

versionTag::~versionTag(){}

void versionTag::printSelf()
{
  printf("%04.1f", a_double);
}

double versionTag::get_double()
{ return a_double; }
void versionTag::set_double(double doubleIn)
{ a_double = doubleIn; }

/********************************************************************/

angle::angle(){};

angle::~angle(){}

/********************************************************************/

angleDms::angleDms(){}

angleDms::angleDms(
  int degreesIn,
  int minutesIn,
  secondsString * secondsStringIn)
{
  degrees = degreesIn;
  minutes = minutesIn;
  a_secondsString = secondsStringIn;
}

angleDms::~angleDms(){}

void angleDms::printSelf()
{
  printf("%d", degrees);
  printf(":");
  printf("%d", minutes);
  if (a_secondsString)
    {
      printf(":");
      a_secondsString->printSelf();
    }
}

int angleDms::get_degrees()
{ return degrees; }
void angleDms::set_degrees(int degreesIn)
{ degrees = degreesIn; }
int angleDms::get_minutes()
{ return minutes; }
void angleDms::set_minutes(int minutesIn)
{ minutes = minutesIn; }
secondsString * angleDms::get_secondsString()
{ return a_secondsString; }
void angleDms::set_secondsString(secondsString * secondsStringIn)
{ a_secondsString = secondsStringIn; }

/********************************************************************/

noParseStm::noParseStm(){}

noParseStm::noParseStm(
  char * stringIn)
{
  a_string = stringIn;
}

noParseStm::~noParseStm(){}

void noParseStm::printSelf()
{
  printf("%s", a_string);
  printf("%c%c", 13, 10);
}

char * noParseStm::get_string()
{ return a_string; }
void noParseStm::set_string(char * stringIn)
{ a_string = stringIn; }

/********************************************************************/

secondsString::secondsString(){};

secondsString::~secondsString(){}

/********************************************************************/

secondsString_REALSTRING::secondsString_REALSTRING(){}

secondsString_REALSTRING::secondsString_REALSTRING(
  double doubleIn)
{
  a_double = doubleIn;
}

secondsString_REALSTRING::~secondsString_REALSTRING(){}

void secondsString_REALSTRING::printSelf()
{
  printDouble(a_double);
}

double secondsString_REALSTRING::get_double()
{ return a_double; }
void secondsString_REALSTRING::set_double(double doubleIn)
{ a_double = doubleIn; }

/********************************************************************/

secondsString_INTSTRING::secondsString_INTSTRING(){}

secondsString_INTSTRING::secondsString_INTSTRING(
  int intIn)
{
  a_int = intIn;
}

secondsString_INTSTRING::~secondsString_INTSTRING(){}

void secondsString_INTSTRING::printSelf()
{
  printf("%d", a_int);
}

int secondsString_INTSTRING::get_int()
{ return a_int; }
void secondsString_INTSTRING::set_int(int intIn)
{ a_int = intIn; }

/********************************************************************/

vector::vector(){}

vector::vector(
  rentVal * iIn,
  rentVal * jIn,
  rentVal * kIn)
{
  i = iIn;
  j = jIn;
  k = kIn;
}

vector::~vector(){}

void vector::printSelf()
{
  i->printSelf();
  printf(",");
  j->printSelf();
  printf(",");
  k->printSelf();
}

rentVal * vector::get_i()
{ return i; }
void vector::set_i(rentVal * iIn)
{ i = iIn; }
rentVal * vector::get_j()
{ return j; }
void vector::set_j(rentVal * jIn)
{ j = jIn; }
rentVal * vector::get_k()
{ return k; }
void vector::set_k(rentVal * kIn)
{ k = kIn; }

/********************************************************************/

matrix::matrix(){}

matrix::matrix(
  rentVal * a1In,
  rentVal * a2In,
  rentVal * a3In,
  rentVal * b1In,
  rentVal * b2In,
  rentVal * b3In,
  rentVal * c1In,
  rentVal * c2In,
  rentVal * c3In,
  rentVal * d1In,
  rentVal * d2In,
  rentVal * d3In)
{
  a1 = a1In;
  a2 = a2In;
  a3 = a3In;
  b1 = b1In;
  b2 = b2In;
  b3 = b3In;
  c1 = c1In;
  c2 = c2In;
  c3 = c3In;
  d1 = d1In;
  d2 = d2In;
  d3 = d3In;
}

matrix::~matrix(){}

void matrix::printSelf()
{
  a1->printSelf();
  printf(",");
  a2->printSelf();
  printf(",");
  a3->printSelf();
  printf(",");
  b1->printSelf();
  printf(",");
  b2->printSelf();
  printf(",");
  b3->printSelf();
  printf(",");
  c1->printSelf();
  printf(",");
  c2->printSelf();
  printf(",");
  c3->printSelf();
  printf(",");
  d1->printSelf();
  printf(",");
  d2->printSelf();
  printf(",");
  d3->printSelf();
}

rentVal * matrix::get_a1()
{ return a1; }
void matrix::set_a1(rentVal * a1In)
{ a1 = a1In; }
rentVal * matrix::get_a2()
{ return a2; }
void matrix::set_a2(rentVal * a2In)
{ a2 = a2In; }
rentVal * matrix::get_a3()
{ return a3; }
void matrix::set_a3(rentVal * a3In)
{ a3 = a3In; }
rentVal * matrix::get_b1()
{ return b1; }
void matrix::set_b1(rentVal * b1In)
{ b1 = b1In; }
rentVal * matrix::get_b2()
{ return b2; }
void matrix::set_b2(rentVal * b2In)
{ b2 = b2In; }
rentVal * matrix::get_b3()
{ return b3; }
void matrix::set_b3(rentVal * b3In)
{ b3 = b3In; }
rentVal * matrix::get_c1()
{ return c1; }
void matrix::set_c1(rentVal * c1In)
{ c1 = c1In; }
rentVal * matrix::get_c2()
{ return c2; }
void matrix::set_c2(rentVal * c2In)
{ c2 = c2In; }
rentVal * matrix::get_c3()
{ return c3; }
void matrix::set_c3(rentVal * c3In)
{ c3 = c3In; }
rentVal * matrix::get_d1()
{ return d1; }
void matrix::set_d1(rentVal * d1In)
{ d1 = d1In; }
rentVal * matrix::get_d2()
{ return d2; }
void matrix::set_d2(rentVal * d2In)
{ d2 = d2In; }
rentVal * matrix::get_d3()
{ return d3; }
void matrix::set_d3(rentVal * d3In)
{ d3 = d3In; }

/********************************************************************/

rwVar::rwVar(){};

rwVar::~rwVar(){}

/********************************************************************/

rwFormat::rwFormat(){}

rwFormat::rwFormat(
  intVal * widthIn,
  intVal * decimalIn)
{
  width = widthIn;
  decimal = decimalIn;
}

rwFormat::~rwFormat(){}

void rwFormat::printSelf()
{
  printf(":");
  width->printSelf();
  if (decimal)
    {
      printf(":");
      decimal->printSelf();
    }
}

intVal * rwFormat::get_width()
{ return width; }
void rwFormat::set_width(intVal * widthIn)
{ width = widthIn; }
intVal * rwFormat::get_decimal()
{ return decimal; }
void rwFormat::set_decimal(intVal * decimalIn)
{ decimal = decimalIn; }

/********************************************************************/

device::device(){};

device::~device(){}

/********************************************************************/

device_PRINT::device_PRINT(){}

device_PRINT::~device_PRINT(){}

void device_PRINT::printSelf()
{
  printf("PRINT");
}

/********************************************************************/

device_TERM::device_TERM(){}

device_TERM::~device_TERM(){}

void device_TERM::printSelf()
{
  printf("TERM");
}

/********************************************************************/

device_COMM::device_COMM(){}

device_COMM::~device_COMM(){}

void device_COMM::printSelf()
{
  printf("COMM");
}

/********************************************************************/

device_STOR::device_STOR(){}

device_STOR::~device_STOR(){}

void device_STOR::printSelf()
{
  printf("STOR");
}

/********************************************************************/

state::state(){};

state::~state(){}

/********************************************************************/

state_ON::state_ON(){}

state_ON::~state_ON(){}

void state_ON::printSelf()
{
  printf("ON");
}

/********************************************************************/

state_OFF::state_OFF(){}

state_OFF::~state_OFF(){}

void state_OFF::printSelf()
{
  printf("OFF");
}

/********************************************************************/

coordType::coordType(){};

coordType::~coordType(){}

/********************************************************************/

coordType_CART::coordType_CART(){}

coordType_CART::~coordType_CART(){}

void coordType_CART::printSelf()
{
  printf("CART");
}

/********************************************************************/

coordType_POL::coordType_POL(){}

coordType_POL::~coordType_POL(){}

void coordType_POL::printSelf()
{
  printf("POL");
}

/********************************************************************/

impCartPoint::impCartPoint(){}

impCartPoint::impCartPoint(
  rentVal * xIn,
  rentVal * yIn,
  rentVal * zIn)
{
  x = xIn;
  y = yIn;
  z = zIn;
}

impCartPoint::~impCartPoint(){}

void impCartPoint::printSelf()
{
  x->printSelf();
  printf(",");
  y->printSelf();
  printf(",");
  z->printSelf();
}

rentVal * impCartPoint::get_x()
{ return x; }
void impCartPoint::set_x(rentVal * xIn)
{ x = xIn; }
rentVal * impCartPoint::get_y()
{ return y; }
void impCartPoint::set_y(rentVal * yIn)
{ y = yIn; }
rentVal * impCartPoint::get_z()
{ return z; }
void impCartPoint::set_z(rentVal * zIn)
{ z = zIn; }

/********************************************************************/

impPolPoint::impPolPoint(){}

impPolPoint::impPolPoint(
  rentVal * rIn,
  rentVal * aIn,
  rentVal * hIn)
{
  r = rIn;
  a = aIn;
  h = hIn;
}

impPolPoint::~impPolPoint(){}

void impPolPoint::printSelf()
{
  r->printSelf();
  printf(",");
  a->printSelf();
  printf(",");
  h->printSelf();
}

rentVal * impPolPoint::get_r()
{ return r; }
void impPolPoint::set_r(rentVal * rIn)
{ r = rIn; }
rentVal * impPolPoint::get_a()
{ return a; }
void impPolPoint::set_a(rentVal * aIn)
{ a = aIn; }
rentVal * impPolPoint::get_h()
{ return h; }
void impPolPoint::set_h(rentVal * hIn)
{ h = hIn; }

/********************************************************************/

typePoint::typePoint(){};

typePoint::~typePoint(){}

/********************************************************************/

pointVecCart::pointVecCart(){}

pointVecCart::pointVecCart(
  rentVal * xIn,
  rentVal * yIn,
  rentVal * zIn,
  rentVal * iIn,
  rentVal * jIn,
  rentVal * kIn)
{
  x = xIn;
  y = yIn;
  z = zIn;
  i = iIn;
  j = jIn;
  k = kIn;
}

pointVecCart::~pointVecCart(){}

void pointVecCart::printSelf()
{
  x->printSelf();
  printf(",");
  y->printSelf();
  printf(",");
  z->printSelf();
  printf(",");
  i->printSelf();
  printf(",");
  j->printSelf();
  printf(",");
  k->printSelf();
}

rentVal * pointVecCart::get_x()
{ return x; }
void pointVecCart::set_x(rentVal * xIn)
{ x = xIn; }
rentVal * pointVecCart::get_y()
{ return y; }
void pointVecCart::set_y(rentVal * yIn)
{ y = yIn; }
rentVal * pointVecCart::get_z()
{ return z; }
void pointVecCart::set_z(rentVal * zIn)
{ z = zIn; }
rentVal * pointVecCart::get_i()
{ return i; }
void pointVecCart::set_i(rentVal * iIn)
{ i = iIn; }
rentVal * pointVecCart::get_j()
{ return j; }
void pointVecCart::set_j(rentVal * jIn)
{ j = jIn; }
rentVal * pointVecCart::get_k()
{ return k; }
void pointVecCart::set_k(rentVal * kIn)
{ k = kIn; }

/********************************************************************/

pointVecPol::pointVecPol(){}

pointVecPol::pointVecPol(
  rentVal * rIn,
  rentVal * aIn,
  rentVal * hIn,
  rentVal * iIn,
  rentVal * jIn,
  rentVal * kIn)
{
  r = rIn;
  a = aIn;
  h = hIn;
  i = iIn;
  j = jIn;
  k = kIn;
}

pointVecPol::~pointVecPol(){}

void pointVecPol::printSelf()
{
  r->printSelf();
  printf(",");
  a->printSelf();
  printf(",");
  h->printSelf();
  printf(",");
  i->printSelf();
  printf(",");
  j->printSelf();
  printf(",");
  k->printSelf();
}

rentVal * pointVecPol::get_r()
{ return r; }
void pointVecPol::set_r(rentVal * rIn)
{ r = rIn; }
rentVal * pointVecPol::get_a()
{ return a; }
void pointVecPol::set_a(rentVal * aIn)
{ a = aIn; }
rentVal * pointVecPol::get_h()
{ return h; }
void pointVecPol::set_h(rentVal * hIn)
{ h = hIn; }
rentVal * pointVecPol::get_i()
{ return i; }
void pointVecPol::set_i(rentVal * iIn)
{ i = iIn; }
rentVal * pointVecPol::get_j()
{ return j; }
void pointVecPol::set_j(rentVal * jIn)
{ j = jIn; }
rentVal * pointVecPol::get_k()
{ return k; }
void pointVecPol::set_k(rentVal * kIn)
{ k = kIn; }

/********************************************************************/

axis::axis(){};

axis::~axis(){}

/********************************************************************/

axis_XAXIS::axis_XAXIS(){}

axis_XAXIS::~axis_XAXIS(){}

void axis_XAXIS::printSelf()
{
  printf("XAXIS");
}

/********************************************************************/

axis_YAXIS::axis_YAXIS(){}

axis_YAXIS::~axis_YAXIS(){}

void axis_YAXIS::printSelf()
{
  printf("YAXIS");
}

/********************************************************************/

axis_ZAXIS::axis_ZAXIS(){}

axis_ZAXIS::~axis_ZAXIS(){}

void axis_ZAXIS::printSelf()
{
  printf("ZAXIS");
}

/********************************************************************/

orig::orig(){};

orig::~orig(){}

/********************************************************************/

orig_XORIG::orig_XORIG(){}

orig_XORIG::~orig_XORIG(){}

void orig_XORIG::printSelf()
{
  printf("XORIG");
}

/********************************************************************/

orig_YORIG::orig_YORIG(){}

orig_YORIG::~orig_YORIG(){}

void orig_YORIG::printSelf()
{
  printf("YORIG");
}

/********************************************************************/

orig_ZORIG::orig_ZORIG(){}

orig_ZORIG::~orig_ZORIG(){}

void orig_ZORIG::printSelf()
{
  printf("ZORIG");
}

/********************************************************************/

dir::dir(){};

dir::~dir(){}

/********************************************************************/

negDir::negDir(){};

negDir::~negDir(){}

/********************************************************************/

negDir_MINUSXDIR::negDir_MINUSXDIR(){}

negDir_MINUSXDIR::~negDir_MINUSXDIR(){}

void negDir_MINUSXDIR::printSelf()
{
  printf("-XDIR");
}

/********************************************************************/

negDir_MINUSYDIR::negDir_MINUSYDIR(){}

negDir_MINUSYDIR::~negDir_MINUSYDIR(){}

void negDir_MINUSYDIR::printSelf()
{
  printf("-YDIR");
}

/********************************************************************/

negDir_MINUSZDIR::negDir_MINUSZDIR(){}

negDir_MINUSZDIR::~negDir_MINUSZDIR(){}

void negDir_MINUSZDIR::printSelf()
{
  printf("-ZDIR");
}

/********************************************************************/

plan::plan(){};

plan::~plan(){}

/********************************************************************/

plan_XYPLAN::plan_XYPLAN(){}

plan_XYPLAN::~plan_XYPLAN(){}

void plan_XYPLAN::printSelf()
{
  printf("XYPLAN");
}

/********************************************************************/

plan_YZPLAN::plan_YZPLAN(){}

plan_YZPLAN::~plan_YZPLAN(){}

void plan_YZPLAN::printSelf()
{
  printf("YZPLAN");
}

/********************************************************************/

plan_ZXPLAN::plan_ZXPLAN(){}

plan_ZXPLAN::~plan_ZXPLAN(){}

void plan_ZXPLAN::printSelf()
{
  printf("ZXPLAN");
}

/********************************************************************/

matDir::matDir(){};

matDir::~matDir(){}

/********************************************************************/

matDir_INNER::matDir_INNER(){}

matDir_INNER::~matDir_INNER(){}

void matDir_INNER::printSelf()
{
  printf("INNER");
}

/********************************************************************/

matDir_OUTER::matDir_OUTER(){}

matDir_OUTER::~matDir_OUTER(){}

void matDir_OUTER::printSelf()
{
  printf("OUTER");
}

/********************************************************************/

flatRoundOpen::flatRoundOpen(){};

flatRoundOpen::~flatRoundOpen(){}

/********************************************************************/

flatRoundOpen_FLAT::flatRoundOpen_FLAT(){}

flatRoundOpen_FLAT::~flatRoundOpen_FLAT(){}

void flatRoundOpen_FLAT::printSelf()
{
  printf("FLAT");
}

/********************************************************************/

flatRoundOpen_ROUND::flatRoundOpen_ROUND(){}

flatRoundOpen_ROUND::~flatRoundOpen_ROUND(){}

void flatRoundOpen_ROUND::printSelf()
{
  printf("ROUND");
}

/********************************************************************/

flatRoundOpen_OPEN::flatRoundOpen_OPEN(){}

flatRoundOpen_OPEN::~flatRoundOpen_OPEN(){}

void flatRoundOpen_OPEN::printSelf()
{
  printf("OPEN");
}

/********************************************************************/

radiusSpec::radiusSpec(){};

radiusSpec::~radiusSpec(){}

/********************************************************************/

radiusSpec_MAJOR::radiusSpec_MAJOR(){}

radiusSpec_MAJOR::~radiusSpec_MAJOR(){}

void radiusSpec_MAJOR::printSelf()
{
  printf("MAJOR");
}

/********************************************************************/

radiusSpec_MINOR::radiusSpec_MINOR(){}

radiusSpec_MINOR::~radiusSpec_MINOR(){}

void radiusSpec_MINOR::printSelf()
{
  printf("MINOR");
}

/********************************************************************/

stackElement::stackElement(){};

stackElement::~stackElement(){}

/********************************************************************/

stackElement_ALGOR::stackElement_ALGOR(){}

stackElement_ALGOR::~stackElement_ALGOR(){}

void stackElement_ALGOR::printSelf()
{
  printf("ALGOR");
}

/********************************************************************/

stackElement_DME::stackElement_DME(){}

stackElement_DME::~stackElement_DME(){}

void stackElement_DME::printSelf()
{
  printf("DME");
}

/********************************************************************/

stackElement_DATSET::stackElement_DATSET(){}

stackElement_DATSET::~stackElement_DATSET(){}

void stackElement_DATSET::printSelf()
{
  printf("DATSET");
}

/********************************************************************/

stackElement_REPORT::stackElement_REPORT(){}

stackElement_REPORT::~stackElement_REPORT(){}

void stackElement_REPORT::printSelf()
{
  printf("REPORT");
}

/********************************************************************/

rotType::rotType(){};

rotType::~rotType(){}

/********************************************************************/

rotType_ROTTOT::rotType_ROTTOT(){}

rotType_ROTTOT::~rotType_ROTTOT(){}

void rotType_ROTTOT::printSelf()
{
  printf("ROTTOT");
}

/********************************************************************/

rotType_ROTORG::rotType_ROTORG(){}

rotType_ROTORG::~rotType_ROTORG(){}

void rotType_ROTORG::printSelf()
{
  printf("ROTORG");
}

/********************************************************************/

rotType_ROTNUL::rotType_ROTNUL(){}

rotType_ROTNUL::~rotType_ROTNUL(){}

void rotType_ROTNUL::printSelf()
{
  printf("ROTNUL");
}

/********************************************************************/

rotDir::rotDir(){};

rotDir::~rotDir(){}

/********************************************************************/

rotDir_rotOrient::rotDir_rotOrient(){}

rotDir_rotOrient::rotDir_rotOrient(
  rotOrient * rotOrientIn)
{
  a_rotOrient = rotOrientIn;
}

rotDir_rotOrient::~rotDir_rotOrient(){}

void rotDir_rotOrient::printSelf()
{
  a_rotOrient->printSelf();
}

rotOrient * rotDir_rotOrient::get_rotOrient()
{ return a_rotOrient; }
void rotDir_rotOrient::set_rotOrient(rotOrient * rotOrientIn)
{ a_rotOrient = rotOrientIn; }

/********************************************************************/

rotDir_SHORT::rotDir_SHORT(){}

rotDir_SHORT::~rotDir_SHORT(){}

void rotDir_SHORT::printSelf()
{
  printf("SHORT");
}

/********************************************************************/

rotOrient::rotOrient(){};

rotOrient::~rotOrient(){}

/********************************************************************/

rotOrient_CW::rotOrient_CW(){}

rotOrient_CW::~rotOrient_CW(){}

void rotOrient_CW::printSelf()
{
  printf("CW");
}

/********************************************************************/

rotOrient_CCW::rotOrient_CCW(){}

rotOrient_CCW::~rotOrient_CCW(){}

void rotOrient_CCW::printSelf()
{
  printf("CCW");
}

/********************************************************************/

rotAbs::rotAbs(){}

rotAbs::rotAbs(
  rotDir * rotDirIn)
{
  a_rotDir = rotDirIn;
}

rotAbs::~rotAbs(){}

void rotAbs::printSelf()
{
  printf("ABSL");
  printf(",");
  a_rotDir->printSelf();
}

rotDir * rotAbs::get_rotDir()
{ return a_rotDir; }
void rotAbs::set_rotDir(rotDir * rotDirIn)
{ a_rotDir = rotDirIn; }

/********************************************************************/

rotIncr::rotIncr(){}

rotIncr::rotIncr(
  rotOrient * rotOrientIn)
{
  a_rotOrient = rotOrientIn;
}

rotIncr::~rotIncr(){}

void rotIncr::printSelf()
{
  printf("INCR");
  printf(",");
  a_rotOrient->printSelf();
}

rotOrient * rotIncr::get_rotOrient()
{ return a_rotOrient; }
void rotIncr::set_rotOrient(rotOrient * rotOrientIn)
{ a_rotOrient = rotOrientIn; }

/********************************************************************/

aclratMinor::aclratMinor(){};

aclratMinor::~aclratMinor(){}

/********************************************************************/

aclratMeas::aclratMeas(){}

aclratMeas::aclratMeas(
  aclratLinSpec * aclratLinSpecIn)
{
  a_aclratLinSpec = aclratLinSpecIn;
}

aclratMeas::~aclratMeas(){}

void aclratMeas::printSelf()
{
  printf("MESACL");
  printf(",");
  a_aclratLinSpec->printSelf();
}

aclratLinSpec * aclratMeas::get_aclratLinSpec()
{ return a_aclratLinSpec; }
void aclratMeas::set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn)
{ a_aclratLinSpec = aclratLinSpecIn; }

/********************************************************************/

aclratPos::aclratPos(){}

aclratPos::aclratPos(
  aclratLinSpec * aclratLinSpecIn)
{
  a_aclratLinSpec = aclratLinSpecIn;
}

aclratPos::~aclratPos(){}

void aclratPos::printSelf()
{
  printf("POSACL");
  printf(",");
  a_aclratLinSpec->printSelf();
}

aclratLinSpec * aclratPos::get_aclratLinSpec()
{ return a_aclratLinSpec; }
void aclratPos::set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn)
{ a_aclratLinSpec = aclratLinSpecIn; }

/********************************************************************/

aclratRot::aclratRot(){}

aclratRot::aclratRot(
  aclratAngSpec * aclratAngSpecIn)
{
  a_aclratAngSpec = aclratAngSpecIn;
}

aclratRot::~aclratRot(){}

void aclratRot::printSelf()
{
  printf("ROTACL");
  printf(",");
  a_aclratAngSpec->printSelf();
}

aclratAngSpec * aclratRot::get_aclratAngSpec()
{ return a_aclratAngSpec; }
void aclratRot::set_aclratAngSpec(aclratAngSpec * aclratAngSpecIn)
{ a_aclratAngSpec = aclratAngSpecIn; }

/********************************************************************/

aclratScan::aclratScan(){}

aclratScan::aclratScan(
  aclratLinSpec * aclratLinSpecIn)
{
  a_aclratLinSpec = aclratLinSpecIn;
}

aclratScan::~aclratScan(){}

void aclratScan::printSelf()
{
  printf("SCNACL");
  printf(",");
  a_aclratLinSpec->printSelf();
}

aclratLinSpec * aclratScan::get_aclratLinSpec()
{ return a_aclratLinSpec; }
void aclratScan::set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn)
{ a_aclratLinSpec = aclratLinSpecIn; }

/********************************************************************/

aclratHedRot::aclratHedRot(){}

aclratHedRot::aclratHedRot(
  aclratLinSpec * aclratLinSpecIn)
{
  a_aclratLinSpec = aclratLinSpecIn;
}

aclratHedRot::~aclratHedRot(){}

void aclratHedRot::printSelf()
{
  printf("HEDROTACL");
  printf(",");
  a_aclratLinSpec->printSelf();
}

aclratLinSpec * aclratHedRot::get_aclratLinSpec()
{ return a_aclratLinSpec; }
void aclratHedRot::set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn)
{ a_aclratLinSpec = aclratLinSpecIn; }

/********************************************************************/

aclratHedMeas::aclratHedMeas(){}

aclratHedMeas::aclratHedMeas(
  aclratLinSpec * aclratLinSpecIn)
{
  a_aclratLinSpec = aclratLinSpecIn;
}

aclratHedMeas::~aclratHedMeas(){}

void aclratHedMeas::printSelf()
{
  printf("HEDMESACL");
  printf(",");
  a_aclratLinSpec->printSelf();
}

aclratLinSpec * aclratHedMeas::get_aclratLinSpec()
{ return a_aclratLinSpec; }
void aclratHedMeas::set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn)
{ a_aclratLinSpec = aclratLinSpecIn; }

/********************************************************************/

aclratHedScan::aclratHedScan(){}

aclratHedScan::aclratHedScan(
  aclratLinSpec * aclratLinSpecIn)
{
  a_aclratLinSpec = aclratLinSpecIn;
}

aclratHedScan::~aclratHedScan(){}

void aclratHedScan::printSelf()
{
  printf("HEDSCNACL");
  printf(",");
  a_aclratLinSpec->printSelf();
}

aclratLinSpec * aclratHedScan::get_aclratLinSpec()
{ return a_aclratLinSpec; }
void aclratHedScan::set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn)
{ a_aclratLinSpec = aclratLinSpecIn; }

/********************************************************************/

aclratAngSpec::aclratAngSpec(){};

aclratAngSpec::~aclratAngSpec(){}

/********************************************************************/

aclratLinSpec::aclratLinSpec(){};

aclratLinSpec::~aclratLinSpec(){}

/********************************************************************/

aclratLinear::aclratLinear(){};

aclratLinear::~aclratLinear(){}

/********************************************************************/

aclratLinear_MPMM::aclratLinear_MPMM(){}

aclratLinear_MPMM::aclratLinear_MPMM(
  rentVal * accelIn)
{
  accel = accelIn;
}

aclratLinear_MPMM::~aclratLinear_MPMM(){}

void aclratLinear_MPMM::printSelf()
{
  printf("MPMM");
  printf(",");
  accel->printSelf();
}

rentVal * aclratLinear_MPMM::get_accel()
{ return accel; }
void aclratLinear_MPMM::set_accel(rentVal * accelIn)
{ accel = accelIn; }

/********************************************************************/

aclratLinear_MMPSS::aclratLinear_MMPSS(){}

aclratLinear_MMPSS::aclratLinear_MMPSS(
  rentVal * accelIn)
{
  accel = accelIn;
}

aclratLinear_MMPSS::~aclratLinear_MMPSS(){}

void aclratLinear_MMPSS::printSelf()
{
  printf("MMPSS");
  printf(",");
  accel->printSelf();
}

rentVal * aclratLinear_MMPSS::get_accel()
{ return accel; }
void aclratLinear_MMPSS::set_accel(rentVal * accelIn)
{ accel = accelIn; }

/********************************************************************/

aclratLinear_IPMM::aclratLinear_IPMM(){}

aclratLinear_IPMM::aclratLinear_IPMM(
  rentVal * accelIn)
{
  accel = accelIn;
}

aclratLinear_IPMM::~aclratLinear_IPMM(){}

void aclratLinear_IPMM::printSelf()
{
  printf("IPMM");
  printf(",");
  accel->printSelf();
}

rentVal * aclratLinear_IPMM::get_accel()
{ return accel; }
void aclratLinear_IPMM::set_accel(rentVal * accelIn)
{ accel = accelIn; }

/********************************************************************/

aclratLinear_IPSS::aclratLinear_IPSS(){}

aclratLinear_IPSS::aclratLinear_IPSS(
  rentVal * accelIn)
{
  accel = accelIn;
}

aclratLinear_IPSS::~aclratLinear_IPSS(){}

void aclratLinear_IPSS::printSelf()
{
  printf("IPSS");
  printf(",");
  accel->printSelf();
}

rentVal * aclratLinear_IPSS::get_accel()
{ return accel; }
void aclratLinear_IPSS::set_accel(rentVal * accelIn)
{ accel = accelIn; }

/********************************************************************/

aclratAngular::aclratAngular(){}

aclratAngular::aclratAngular(
  rentVal * accelIn)
{
  accel = accelIn;
}

aclratAngular::~aclratAngular(){}

void aclratAngular::printSelf()
{
  printf("RPMM");
  printf(",");
  accel->printSelf();
}

rentVal * aclratAngular::get_accel()
{ return accel; }
void aclratAngular::set_accel(rentVal * accelIn)
{ accel = accelIn; }

/********************************************************************/

aclratDef::aclratDef(){};

aclratDef::~aclratDef(){}

/********************************************************************/

aclratDef_PCENT::aclratDef_PCENT(){}

aclratDef_PCENT::aclratDef_PCENT(
  rentVal * accelIn)
{
  accel = accelIn;
}

aclratDef_PCENT::~aclratDef_PCENT(){}

void aclratDef_PCENT::printSelf()
{
  printf("PCENT");
  printf(",");
  accel->printSelf();
}

rentVal * aclratDef_PCENT::get_accel()
{ return accel; }
void aclratDef_PCENT::set_accel(rentVal * accelIn)
{ accel = accelIn; }

/********************************************************************/

aclratDef_HIGH::aclratDef_HIGH(){}

aclratDef_HIGH::~aclratDef_HIGH(){}

void aclratDef_HIGH::printSelf()
{
  printf("HIGH");
}

/********************************************************************/

aclratDef_LOW::aclratDef_LOW(){}

aclratDef_LOW::~aclratDef_LOW(){}

void aclratDef_LOW::printSelf()
{
  printf("LOW");
}

/********************************************************************/

aclratDef_DEFALT::aclratDef_DEFALT(){}

aclratDef_DEFALT::~aclratDef_DEFALT(){}

void aclratDef_DEFALT::printSelf()
{
  printf("DEFALT");
}

/********************************************************************/

algdefStm::algdefStm(){}

algdefStm::algdefStm(
  vaLabel * vaLabelIn,
  algdefMinor * algdefMinorIn)
{
  a_vaLabel = vaLabelIn;
  a_algdefMinor = algdefMinorIn;
}

algdefStm::~algdefStm(){}

void algdefStm::printSelf()
{
  a_vaLabel->printSelf();
  printf("=");
  printf("ALGDEF");
  printf("/");
  a_algdefMinor->printSelf();
  printf("%c%c", 13, 10);
}

vaLabel * algdefStm::get_vaLabel()
{ return a_vaLabel; }
void algdefStm::set_vaLabel(vaLabel * vaLabelIn)
{ a_vaLabel = vaLabelIn; }
algdefMinor * algdefStm::get_algdefMinor()
{ return a_algdefMinor; }
void algdefStm::set_algdefMinor(algdefMinor * algdefMinorIn)
{ a_algdefMinor = algdefMinorIn; }

/********************************************************************/

algdefMinor::algdefMinor(){};

algdefMinor::~algdefMinor(){}

/********************************************************************/

algdefMinor_CODE::algdefMinor_CODE(){}

algdefMinor_CODE::algdefMinor_CODE(
  intVal * codeIn)
{
  code = codeIn;
}

algdefMinor_CODE::~algdefMinor_CODE(){}

void algdefMinor_CODE::printSelf()
{
  printf("CODE");
  printf(",");
  code->printSelf();
}

intVal * algdefMinor_CODE::get_code()
{ return code; }
void algdefMinor_CODE::set_code(intVal * codeIn)
{ code = codeIn; }

/********************************************************************/

algdefMinor_stringVal::algdefMinor_stringVal(){}

algdefMinor_stringVal::algdefMinor_stringVal(
  stringVal * nameIn,
  std::list<param *> * paramListIn)
{
  name = nameIn;
  a_paramList = paramListIn;
}

algdefMinor_stringVal::~algdefMinor_stringVal(){}

void algdefMinor_stringVal::printSelf()
{
  name->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
}

stringVal * algdefMinor_stringVal::get_name()
{ return name; }
void algdefMinor_stringVal::set_name(stringVal * nameIn)
{ name = nameIn; }
std::list<param *> * algdefMinor_stringVal::get_paramList()
{ return a_paramList; }
void algdefMinor_stringVal::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

assignString::assignString(){}

assignString::assignString(
  stringVar * stringVarIn,
  stringVal * strIn)
{
  a_stringVar = stringVarIn;
  str = strIn;
}

assignString::~assignString(){}

void assignString::printSelf()
{
  a_stringVar->printSelf();
  printf("=");
  printf("ASSIGN");
  printf("/");
  str->printSelf();
}

stringVar * assignString::get_stringVar()
{ return a_stringVar; }
void assignString::set_stringVar(stringVar * stringVarIn)
{ a_stringVar = stringVarIn; }
stringVal * assignString::get_str()
{ return str; }
void assignString::set_str(stringVal * strIn)
{ str = strIn; }

/********************************************************************/

assignBool::assignBool(){}

assignBool::assignBool(
  boolVar * boolVarIn,
  boolVal * valueIn)
{
  a_boolVar = boolVarIn;
  value = valueIn;
}

assignBool::~assignBool(){}

void assignBool::printSelf()
{
  a_boolVar->printSelf();
  printf("=");
  printf("ASSIGN");
  printf("/");
  value->printSelf();
}

boolVar * assignBool::get_boolVar()
{ return a_boolVar; }
void assignBool::set_boolVar(boolVar * boolVarIn)
{ a_boolVar = boolVarIn; }
boolVal * assignBool::get_value()
{ return value; }
void assignBool::set_value(boolVal * valueIn)
{ value = valueIn; }

/********************************************************************/

assignInt::assignInt(){}

assignInt::assignInt(
  intVar * intVarIn,
  rentVal * valueIn)
{
  a_intVar = intVarIn;
  value = valueIn;
}

assignInt::~assignInt(){}

void assignInt::printSelf()
{
  a_intVar->printSelf();
  printf("=");
  printf("ASSIGN");
  printf("/");
  value->printSelf();
}

intVar * assignInt::get_intVar()
{ return a_intVar; }
void assignInt::set_intVar(intVar * intVarIn)
{ a_intVar = intVarIn; }
rentVal * assignInt::get_value()
{ return value; }
void assignInt::set_value(rentVal * valueIn)
{ value = valueIn; }

/********************************************************************/

assignReal::assignReal(){}

assignReal::assignReal(
  realVar * realVarIn,
  rentVal * valueIn)
{
  a_realVar = realVarIn;
  value = valueIn;
}

assignReal::~assignReal(){}

void assignReal::printSelf()
{
  a_realVar->printSelf();
  printf("=");
  printf("ASSIGN");
  printf("/");
  value->printSelf();
}

realVar * assignReal::get_realVar()
{ return a_realVar; }
void assignReal::set_realVar(realVar * realVarIn)
{ a_realVar = realVarIn; }
rentVal * assignReal::get_value()
{ return value; }
void assignReal::set_value(rentVal * valueIn)
{ value = valueIn; }

/********************************************************************/

assignVector::assignVector(){}

assignVector::assignVector(
  vectorVar * vectorVarIn,
  vectorVal * valueIn)
{
  a_vectorVar = vectorVarIn;
  value = valueIn;
}

assignVector::~assignVector(){}

void assignVector::printSelf()
{
  a_vectorVar->printSelf();
  printf("=");
  printf("ASSIGN");
  printf("/");
  value->printSelf();
}

vectorVar * assignVector::get_vectorVar()
{ return a_vectorVar; }
void assignVector::set_vectorVar(vectorVar * vectorVarIn)
{ a_vectorVar = vectorVarIn; }
vectorVal * assignVector::get_value()
{ return value; }
void assignVector::set_value(vectorVal * valueIn)
{ value = valueIn; }

/********************************************************************/

boundStm::boundStm(){}

boundStm::boundStm(
  boundMinor * boundMinorIn)
{
  a_boundMinor = boundMinorIn;
}

boundStm::~boundStm(){}

void boundStm::printSelf()
{
  printf("BOUND");
  printf("/");
  a_boundMinor->printSelf();
  printf("%c%c", 13, 10);
}

boundMinor * boundStm::get_boundMinor()
{ return a_boundMinor; }
void boundStm::set_boundMinor(boundMinor * boundMinorIn)
{ a_boundMinor = boundMinorIn; }

/********************************************************************/

boundMinor::boundMinor(){};

boundMinor::~boundMinor(){}

/********************************************************************/

boundFeat::boundFeat(){}

boundFeat::boundFeat(
  fLabel * fLabelIn,
  std::list<featureLabel *> * featureListIn)
{
  a_fLabel = fLabelIn;
  a_featureList = featureListIn;
}

boundFeat::~boundFeat(){}

void boundFeat::printSelf()
{
  a_fLabel->printSelf();
  printf(",");
  if (a_featureList->begin() == a_featureList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<featureLabel *>::iterator iter;
      for (iter = a_featureList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureList->end())
            break;
          printf(",");
        }
    }
}

fLabel * boundFeat::get_fLabel()
{ return a_fLabel; }
void boundFeat::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
std::list<featureLabel *> * boundFeat::get_featureList()
{ return a_featureList; }
void boundFeat::set_featureList(std::list<featureLabel *> * featureListIn)
{ a_featureList = featureListIn; }

/********************************************************************/

boundTol::boundTol(){}

boundTol::boundTol(
  tLabel * tLabelIn,
  std::list<featureLabel *> * featureListIn)
{
  a_tLabel = tLabelIn;
  a_featureList = featureListIn;
}

boundTol::~boundTol(){}

void boundTol::printSelf()
{
  a_tLabel->printSelf();
  printf(",");
  if (a_featureList->begin() == a_featureList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<featureLabel *>::iterator iter;
      for (iter = a_featureList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureList->end())
            break;
          printf(",");
        }
    }
}

tLabel * boundTol::get_tLabel()
{ return a_tLabel; }
void boundTol::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
std::list<featureLabel *> * boundTol::get_featureList()
{ return a_featureList; }
void boundTol::set_featureList(std::list<featureLabel *> * featureListIn)
{ a_featureList = featureListIn; }

/********************************************************************/

calibSensStm::calibSensStm(){}

calibSensStm::calibSensStm(
  calibSensMinor * calibSensMinorIn)
{
  a_calibSensMinor = calibSensMinorIn;
}

calibSensStm::~calibSensStm(){}

void calibSensStm::printSelf()
{
  printf("CALIB");
  printf("/");
  a_calibSensMinor->printSelf();
  printf("%c%c", 13, 10);
}

calibSensMinor * calibSensStm::get_calibSensMinor()
{ return a_calibSensMinor; }
void calibSensStm::set_calibSensMinor(calibSensMinor * calibSensMinorIn)
{ a_calibSensMinor = calibSensMinorIn; }

/********************************************************************/

calibRtabStm::calibRtabStm(){}

calibRtabStm::calibRtabStm(
  calibRtabMinor * calibRtabMinorIn)
{
  a_calibRtabMinor = calibRtabMinorIn;
}

calibRtabStm::~calibRtabStm(){}

void calibRtabStm::printSelf()
{
  printf("CALIB");
  printf("/");
  a_calibRtabMinor->printSelf();
  printf("%c%c", 13, 10);
}

calibRtabMinor * calibRtabStm::get_calibRtabMinor()
{ return a_calibRtabMinor; }
void calibRtabStm::set_calibRtabMinor(calibRtabMinor * calibRtabMinorIn)
{ a_calibRtabMinor = calibRtabMinorIn; }

/********************************************************************/

calibMasterStm::calibMasterStm(){}

calibMasterStm::calibMasterStm(
  calibMasterMinor * calibMasterMinorIn)
{
  a_calibMasterMinor = calibMasterMinorIn;
}

calibMasterStm::~calibMasterStm(){}

void calibMasterStm::printSelf()
{
  printf("CALIB");
  printf("/");
  a_calibMasterMinor->printSelf();
  printf("%c%c", 13, 10);
}

calibMasterMinor * calibMasterStm::get_calibMasterMinor()
{ return a_calibMasterMinor; }
void calibMasterStm::set_calibMasterMinor(calibMasterMinor * calibMasterMinorIn)
{ a_calibMasterMinor = calibMasterMinorIn; }

/********************************************************************/

calibSensMinor::calibSensMinor(){};

calibSensMinor::~calibSensMinor(){}

/********************************************************************/

calibSensMinorSpec::calibSensMinorSpec(){}

calibSensMinorSpec::calibSensMinorSpec(
  sLabel * sLabelIn,
  calibSensSpec * calibSensSpecIn)
{
  a_sLabel = sLabelIn;
  a_calibSensSpec = calibSensSpecIn;
}

calibSensMinorSpec::~calibSensMinorSpec(){}

void calibSensMinorSpec::printSelf()
{
  printf("SENS");
  printf(",");
  a_sLabel->printSelf();
  printf(",");
  a_calibSensSpec->printSelf();
}

sLabel * calibSensMinorSpec::get_sLabel()
{ return a_sLabel; }
void calibSensMinorSpec::set_sLabel(sLabel * sLabelIn)
{ a_sLabel = sLabelIn; }
calibSensSpec * calibSensMinorSpec::get_calibSensSpec()
{ return a_calibSensSpec; }
void calibSensMinorSpec::set_calibSensSpec(calibSensSpec * calibSensSpecIn)
{ a_calibSensSpec = calibSensSpecIn; }

/********************************************************************/

calibSensMinorRecalib::calibSensMinorRecalib(){}

calibSensMinorRecalib::~calibSensMinorRecalib(){}

void calibSensMinorRecalib::printSelf()
{
  printf("SENS");
  printf(",");
  printf("RECALIB");
}

/********************************************************************/

calibSensSpec::calibSensSpec(){};

calibSensSpec::~calibSensSpec(){}

/********************************************************************/

calibSensSpecInt::calibSensSpecInt(){}

calibSensSpecInt::calibSensSpecInt(
  featureLabel1 * featureLabel1In,
  intVal * numMeasIn)
{
  a_featureLabel1 = featureLabel1In;
  numMeas = numMeasIn;
}

calibSensSpecInt::~calibSensSpecInt(){}

void calibSensSpecInt::printSelf()
{
  a_featureLabel1->printSelf();
  printf(",");
  numMeas->printSelf();
}

featureLabel1 * calibSensSpecInt::get_featureLabel1()
{ return a_featureLabel1; }
void calibSensSpecInt::set_featureLabel1(featureLabel1 * featureLabel1In)
{ a_featureLabel1 = featureLabel1In; }
intVal * calibSensSpecInt::get_numMeas()
{ return numMeas; }
void calibSensSpecInt::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }

/********************************************************************/

calibSensSpecString::calibSensSpecString(){}

calibSensSpecString::calibSensSpecString(
  featureLabel1 * featureLabel1In,
  stringVal * textIn,
  intVal * numMeasIn)
{
  a_featureLabel1 = featureLabel1In;
  text = textIn;
  numMeas = numMeasIn;
}

calibSensSpecString::~calibSensSpecString(){}

void calibSensSpecString::printSelf()
{
  a_featureLabel1->printSelf();
  printf(",");
  text->printSelf();
  if (numMeas)
    {
      printf(",");
      numMeas->printSelf();
    }
}

featureLabel1 * calibSensSpecString::get_featureLabel1()
{ return a_featureLabel1; }
void calibSensSpecString::set_featureLabel1(featureLabel1 * featureLabel1In)
{ a_featureLabel1 = featureLabel1In; }
stringVal * calibSensSpecString::get_text()
{ return text; }
void calibSensSpecString::set_text(stringVal * textIn)
{ text = textIn; }
intVal * calibSensSpecString::get_numMeas()
{ return numMeas; }
void calibSensSpecString::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }

/********************************************************************/

calibRtabMinor::calibRtabMinor(){};

calibRtabMinor::~calibRtabMinor(){}

/********************************************************************/

calibRtabMinorSpec::calibRtabMinorSpec(){}

calibRtabMinorSpec::calibRtabMinorSpec(
  rtLabel * rtLabelIn,
  calibRtabSpec * calibRtabSpecIn)
{
  a_rtLabel = rtLabelIn;
  a_calibRtabSpec = calibRtabSpecIn;
}

calibRtabMinorSpec::~calibRtabMinorSpec(){}

void calibRtabMinorSpec::printSelf()
{
  printf("RTAB");
  printf(",");
  a_rtLabel->printSelf();
  printf(",");
  a_calibRtabSpec->printSelf();
}

rtLabel * calibRtabMinorSpec::get_rtLabel()
{ return a_rtLabel; }
void calibRtabMinorSpec::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
calibRtabSpec * calibRtabMinorSpec::get_calibRtabSpec()
{ return a_calibRtabSpec; }
void calibRtabMinorSpec::set_calibRtabSpec(calibRtabSpec * calibRtabSpecIn)
{ a_calibRtabSpec = calibRtabSpecIn; }

/********************************************************************/

calibRtabMinorRecalib::calibRtabMinorRecalib(){}

calibRtabMinorRecalib::~calibRtabMinorRecalib(){}

void calibRtabMinorRecalib::printSelf()
{
  printf("RTAB");
  printf(",");
  printf("RECALIB");
}

/********************************************************************/

calibRtabSpec::calibRtabSpec(){};

calibRtabSpec::~calibRtabSpec(){}

/********************************************************************/

calibRtabSpec_fLabel::calibRtabSpec_fLabel(){}

calibRtabSpec_fLabel::calibRtabSpec_fLabel(
  fLabel * fLabelIn,
  intVal * numMeasIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
}

calibRtabSpec_fLabel::~calibRtabSpec_fLabel(){}

void calibRtabSpec_fLabel::printSelf()
{
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
}

fLabel * calibRtabSpec_fLabel::get_fLabel()
{ return a_fLabel; }
void calibRtabSpec_fLabel::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * calibRtabSpec_fLabel::get_numMeas()
{ return numMeas; }
void calibRtabSpec_fLabel::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }

/********************************************************************/

calibRtabSpec_faLabel::calibRtabSpec_faLabel(){}

calibRtabSpec_faLabel::calibRtabSpec_faLabel(
  faLabel * feat1In,
  faLabel * feat2In)
{
  feat1 = feat1In;
  feat2 = feat2In;
}

calibRtabSpec_faLabel::~calibRtabSpec_faLabel(){}

void calibRtabSpec_faLabel::printSelf()
{
  feat1->printSelf();
  printf(",");
  feat2->printSelf();
}

faLabel * calibRtabSpec_faLabel::get_feat1()
{ return feat1; }
void calibRtabSpec_faLabel::set_feat1(faLabel * feat1In)
{ feat1 = feat1In; }
faLabel * calibRtabSpec_faLabel::get_feat2()
{ return feat2; }
void calibRtabSpec_faLabel::set_feat2(faLabel * feat2In)
{ feat2 = feat2In; }

/********************************************************************/

calibMasterMinor::calibMasterMinor(){}

calibMasterMinor::calibMasterMinor(
  stringVal * artNameIn)
{
  artName = artNameIn;
}

calibMasterMinor::~calibMasterMinor(){}

void calibMasterMinor::printSelf()
{
  printf("MASTER");
  printf(",");
  artName->printSelf();
}

stringVal * calibMasterMinor::get_artName()
{ return artName; }
void calibMasterMinor::set_artName(stringVal * artNameIn)
{ artName = artNameIn; }

/********************************************************************/

callStm::callStm(){}

callStm::callStm(
  callMinor * callMinorIn)
{
  a_callMinor = callMinorIn;
}

callStm::~callStm(){}

void callStm::printSelf()
{
  printf("CALL");
  printf("/");
  a_callMinor->printSelf();
  printf("%c%c", 13, 10);
}

callMinor * callStm::get_callMinor()
{ return a_callMinor; }
void callStm::set_callMinor(callMinor * callMinorIn)
{ a_callMinor = callMinorIn; }

/********************************************************************/

callMinor::callMinor(){};

callMinor::~callMinor(){}

/********************************************************************/

callMacro::callMacro(){}

callMacro::callMacro(
  bool has_EXTERNIn,
  mLabel * mLabelIn,
  char * stringIn)
{
  has_EXTERN = has_EXTERNIn;
  a_mLabel = mLabelIn;
  a_string = stringIn;
}

callMacro::~callMacro(){}

void callMacro::printSelf()
{
  if (has_EXTERN == true)
    {
      printf("EXTERN");
      printf(",");
      printf("DMIS");
      printf(",");
    }
  a_mLabel->printSelf();
  if (a_string)
    {
      printf(",");
      printf("%s", a_string);
    }
}

bool callMacro::get_has_EXTERN()
{ return has_EXTERN; }
void callMacro::set_has_EXTERN(bool has_EXTERNIn)
{ has_EXTERN = has_EXTERNIn; }
mLabel * callMacro::get_mLabel()
{ return a_mLabel; }
void callMacro::set_mLabel(mLabel * mLabelIn)
{ a_mLabel = mLabelIn; }
char * callMacro::get_string()
{ return a_string; }
void callMacro::set_string(char * stringIn)
{ a_string = stringIn; }

/********************************************************************/

callModule::callModule(){}

callModule::callModule(
  stringVal * modIdIn)
{
  modId = modIdIn;
}

callModule::~callModule(){}

void callModule::printSelf()
{
  printf("EXTERN");
  printf(",");
  printf("DMIS");
  printf(",");
  modId->printSelf();
}

stringVal * callModule::get_modId()
{ return modId; }
void callModule::set_modId(stringVal * modIdIn)
{ modId = modIdIn; }

/********************************************************************/

callRoutine::callRoutine(){}

callRoutine::callRoutine(
  stringVal * routineIn,
  callType * callTypeIn,
  std::list<param *> * paramListIn)
{
  routine = routineIn;
  a_callType = callTypeIn;
  a_paramList = paramListIn;
}

callRoutine::~callRoutine(){}

void callRoutine::printSelf()
{
  printf("EXTERN");
  printf(",");
  printf("DME");
  printf(",");
  routine->printSelf();
  if (a_callType)
    {
      printf(",");
      a_callType->printSelf();
    }
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
}

stringVal * callRoutine::get_routine()
{ return routine; }
void callRoutine::set_routine(stringVal * routineIn)
{ routine = routineIn; }
callType * callRoutine::get_callType()
{ return a_callType; }
void callRoutine::set_callType(callType * callTypeIn)
{ a_callType = callTypeIn; }
std::list<param *> * callRoutine::get_paramList()
{ return a_paramList; }
void callRoutine::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

callProgram::callProgram(){}

callProgram::callProgram(
  stringVal * pathnameIn,
  callType * callTypeIn,
  std::list<param *> * paramListIn)
{
  pathname = pathnameIn;
  a_callType = callTypeIn;
  a_paramList = paramListIn;
}

callProgram::~callProgram(){}

void callProgram::printSelf()
{
  printf("EXTERN");
  printf(",");
  printf("SYS");
  printf(",");
  pathname->printSelf();
  if (a_callType)
    {
      printf(",");
      a_callType->printSelf();
    }
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
}

stringVal * callProgram::get_pathname()
{ return pathname; }
void callProgram::set_pathname(stringVal * pathnameIn)
{ pathname = pathnameIn; }
callType * callProgram::get_callType()
{ return a_callType; }
void callProgram::set_callType(callType * callTypeIn)
{ a_callType = callTypeIn; }
std::list<param *> * callProgram::get_paramList()
{ return a_paramList; }
void callProgram::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

callType::callType(){};

callType::~callType(){}

/********************************************************************/

callType_WAIT::callType_WAIT(){}

callType_WAIT::~callType_WAIT(){}

void callType_WAIT::printSelf()
{
  printf("WAIT");
}

/********************************************************************/

callType_CONT::callType_CONT(){}

callType_CONT::~callType_CONT(){}

void callType_CONT::printSelf()
{
  printf("CONT");
}

/********************************************************************/

callType_ATTACH::callType_ATTACH(){}

callType_ATTACH::~callType_ATTACH(){}

void callType_ATTACH::printSelf()
{
  printf("ATTACH");
}

/********************************************************************/

caseStm::caseStm(){};

caseStm::~caseStm(){}

/********************************************************************/

caseStmInt::caseStmInt(){}

caseStmInt::caseStmInt(
  sign * signIn,
  intConst * intConstIn)
{
  a_sign = signIn;
  a_intConst = intConstIn;
}

caseStmInt::~caseStmInt(){}

void caseStmInt::printSelf()
{
  printf("CASE");
  printf("/");
  if (a_sign)
    {
      a_sign->printSelf();
    }
  a_intConst->printSelf();
  printf("%c%c", 13, 10);
}

sign * caseStmInt::get_sign()
{ return a_sign; }
void caseStmInt::set_sign(sign * signIn)
{ a_sign = signIn; }
intConst * caseStmInt::get_intConst()
{ return a_intConst; }
void caseStmInt::set_intConst(intConst * intConstIn)
{ a_intConst = intConstIn; }

/********************************************************************/

caseStmString::caseStmString(){}

caseStmString::caseStmString(
  stringConst * stringConstIn)
{
  a_stringConst = stringConstIn;
}

caseStmString::~caseStmString(){}

void caseStmString::printSelf()
{
  printf("CASE");
  printf("/");
  a_stringConst->printSelf();
  printf("%c%c", 13, 10);
}

stringConst * caseStmString::get_stringConst()
{ return a_stringConst; }
void caseStmString::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }

/********************************************************************/

sign::sign(){};

sign::~sign(){}

/********************************************************************/

clmpidStm::clmpidStm(){}

clmpidStm::clmpidStm(
  ciLabel * ciLabelIn,
  stringVal * textIn)
{
  a_ciLabel = ciLabelIn;
  text = textIn;
}

clmpidStm::~clmpidStm(){}

void clmpidStm::printSelf()
{
  a_ciLabel->printSelf();
  printf("=");
  printf("CLMPID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

ciLabel * clmpidStm::get_ciLabel()
{ return a_ciLabel; }
void clmpidStm::set_ciLabel(ciLabel * ciLabelIn)
{ a_ciLabel = ciLabelIn; }
stringVal * clmpidStm::get_text()
{ return text; }
void clmpidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

clmpsnStm::clmpsnStm(){}

clmpsnStm::clmpsnStm(
  csLabel * csLabelIn,
  stringVal * textIn)
{
  a_csLabel = csLabelIn;
  text = textIn;
}

clmpsnStm::~clmpsnStm(){}

void clmpsnStm::printSelf()
{
  a_csLabel->printSelf();
  printf("=");
  printf("CLMPSN");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

csLabel * clmpsnStm::get_csLabel()
{ return a_csLabel; }
void clmpsnStm::set_csLabel(csLabel * csLabelIn)
{ a_csLabel = csLabelIn; }
stringVal * clmpsnStm::get_text()
{ return text; }
void clmpsnStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

closeStm::closeStm(){}

closeStm::closeStm(
  closeMinor * closeMinorIn)
{
  a_closeMinor = closeMinorIn;
}

closeStm::~closeStm(){}

void closeStm::printSelf()
{
  printf("CLOSE");
  printf("/");
  a_closeMinor->printSelf();
  printf("%c%c", 13, 10);
}

closeMinor * closeStm::get_closeMinor()
{ return a_closeMinor; }
void closeStm::set_closeMinor(closeMinor * closeMinorIn)
{ a_closeMinor = closeMinorIn; }

/********************************************************************/

closeMinor::closeMinor(){};

closeMinor::~closeMinor(){}

/********************************************************************/

closePlain::closePlain(){}

closePlain::closePlain(
  didLabel * didLabelIn)
{
  a_didLabel = didLabelIn;
}

closePlain::~closePlain(){}

void closePlain::printSelf()
{
  a_didLabel->printSelf();
}

didLabel * closePlain::get_didLabel()
{ return a_didLabel; }
void closePlain::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

closeKeep::closeKeep(){}

closeKeep::closeKeep(
  didLabel * didLabelIn)
{
  a_didLabel = didLabelIn;
}

closeKeep::~closeKeep(){}

void closeKeep::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  printf("KEEP");
}

didLabel * closeKeep::get_didLabel()
{ return a_didLabel; }
void closeKeep::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

closeDelete::closeDelete(){}

closeDelete::closeDelete(
  didLabel * didLabelIn)
{
  a_didLabel = didLabelIn;
}

closeDelete::~closeDelete(){}

void closeDelete::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  printf("DELETE");
}

didLabel * closeDelete::get_didLabel()
{ return a_didLabel; }
void closeDelete::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

closeEnd::closeEnd(){}

closeEnd::closeEnd(
  didLabel * didLabelIn)
{
  a_didLabel = didLabelIn;
}

closeEnd::~closeEnd(){}

void closeEnd::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  printf("END");
}

didLabel * closeEnd::get_didLabel()
{ return a_didLabel; }
void closeEnd::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

cmpntgrpStm::cmpntgrpStm(){}

cmpntgrpStm::cmpntgrpStm(
  sgLabel * sgLabelIn,
  std::list<cmpntgrpSpec *> * cmpntgrpSpecListIn)
{
  a_sgLabel = sgLabelIn;
  a_cmpntgrpSpecList = cmpntgrpSpecListIn;
}

cmpntgrpStm::~cmpntgrpStm(){}

void cmpntgrpStm::printSelf()
{
  a_sgLabel->printSelf();
  printf("=");
  printf("CMPNTGRP");
  printf("/");
  printf("BUILD");
  printf(",");
  if (a_cmpntgrpSpecList->begin() == a_cmpntgrpSpecList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<cmpntgrpSpec *>::iterator iter;
      for (iter = a_cmpntgrpSpecList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_cmpntgrpSpecList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

sgLabel * cmpntgrpStm::get_sgLabel()
{ return a_sgLabel; }
void cmpntgrpStm::set_sgLabel(sgLabel * sgLabelIn)
{ a_sgLabel = sgLabelIn; }
std::list<cmpntgrpSpec *> * cmpntgrpStm::get_cmpntgrpSpecList()
{ return a_cmpntgrpSpecList; }
void cmpntgrpStm::set_cmpntgrpSpecList(std::list<cmpntgrpSpec *> * cmpntgrpSpecListIn)
{ a_cmpntgrpSpecList = cmpntgrpSpecListIn; }

/********************************************************************/

cmpntgrpSpec::cmpntgrpSpec(){};

cmpntgrpSpec::~cmpntgrpSpec(){}

/********************************************************************/

cnfrmrulStm::cnfrmrulStm(){}

cnfrmrulStm::cnfrmrulStm(
  drLabel * drLabelIn,
  cnfrmrulMinor * cnfrmrulMinorIn)
{
  a_drLabel = drLabelIn;
  a_cnfrmrulMinor = cnfrmrulMinorIn;
}

cnfrmrulStm::~cnfrmrulStm(){}

void cnfrmrulStm::printSelf()
{
  a_drLabel->printSelf();
  printf("=");
  printf("CNFRMRUL");
  printf("/");
  a_cnfrmrulMinor->printSelf();
  printf("%c%c", 13, 10);
}

drLabel * cnfrmrulStm::get_drLabel()
{ return a_drLabel; }
void cnfrmrulStm::set_drLabel(drLabel * drLabelIn)
{ a_drLabel = drLabelIn; }
cnfrmrulMinor * cnfrmrulStm::get_cnfrmrulMinor()
{ return a_cnfrmrulMinor; }
void cnfrmrulStm::set_cnfrmrulMinor(cnfrmrulMinor * cnfrmrulMinorIn)
{ a_cnfrmrulMinor = cnfrmrulMinorIn; }

/********************************************************************/

cnfrmrulMinor::cnfrmrulMinor(){};

cnfrmrulMinor::~cnfrmrulMinor(){}

/********************************************************************/

cnfrmrulCode::cnfrmrulCode(){}

cnfrmrulCode::cnfrmrulCode(
  intVal * codeIn)
{
  code = codeIn;
}

cnfrmrulCode::~cnfrmrulCode(){}

void cnfrmrulCode::printSelf()
{
  printf("RULE");
  printf(",");
  code->printSelf();
}

intVal * cnfrmrulCode::get_code()
{ return code; }
void cnfrmrulCode::set_code(intVal * codeIn)
{ code = codeIn; }

/********************************************************************/

cnfrmrulName::cnfrmrulName(){}

cnfrmrulName::cnfrmrulName(
  stringVal * nameIn,
  std::list<param *> * paramListIn)
{
  name = nameIn;
  a_paramList = paramListIn;
}

cnfrmrulName::~cnfrmrulName(){}

void cnfrmrulName::printSelf()
{
  name->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
}

stringVal * cnfrmrulName::get_name()
{ return name; }
void cnfrmrulName::set_name(stringVal * nameIn)
{ name = nameIn; }
std::list<param *> * cnfrmrulName::get_paramList()
{ return a_paramList; }
void cnfrmrulName::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

constStm::constStm(){}

constStm::constStm(
  constMinor * constMinorIn)
{
  a_constMinor = constMinorIn;
}

constStm::~constStm(){}

void constStm::printSelf()
{
  printf("CONST");
  printf("/");
  a_constMinor->printSelf();
  printf("%c%c", 13, 10);
}

constMinor * constStm::get_constMinor()
{ return a_constMinor; }
void constStm::set_constMinor(constMinor * constMinorIn)
{ a_constMinor = constMinorIn; }

/********************************************************************/

constMinor::constMinor(){};

constMinor::~constMinor(){}

/********************************************************************/

constArc::constArc(){};

constArc::~constArc(){}

/********************************************************************/

constArc_bfConst::constArc_bfConst(){}

constArc_bfConst::constArc_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constArc_bfConst::~constArc_bfConst(){}

void constArc_bfConst::printSelf()
{
  printf("ARC");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constArc_bfConst::get_fLabel()
{ return a_fLabel; }
void constArc_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constArc_bfConst::get_bfConst()
{ return a_bfConst; }
void constArc_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constArc_projctConst::constArc_projctConst(){}

constArc_projctConst::constArc_projctConst(
  fLabel * fLabelIn,
  projctConst * projctConstIn)
{
  a_fLabel = fLabelIn;
  a_projctConst = projctConstIn;
}

constArc_projctConst::~constArc_projctConst(){}

void constArc_projctConst::printSelf()
{
  printf("ARC");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_projctConst->printSelf();
}

fLabel * constArc_projctConst::get_fLabel()
{ return a_fLabel; }
void constArc_projctConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
projctConst * constArc_projctConst::get_projctConst()
{ return a_projctConst; }
void constArc_projctConst::set_projctConst(projctConst * projctConstIn)
{ a_projctConst = projctConstIn; }

/********************************************************************/

constArc_trConst::constArc_trConst(){}

constArc_trConst::constArc_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constArc_trConst::~constArc_trConst(){}

void constArc_trConst::printSelf()
{
  printf("ARC");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constArc_trConst::get_fLabel()
{ return a_fLabel; }
void constArc_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constArc_trConst::get_trConst()
{ return a_trConst; }
void constArc_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constCircle::constCircle(){};

constCircle::~constCircle(){}

/********************************************************************/

constCircle_bfConst::constCircle_bfConst(){}

constCircle_bfConst::constCircle_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constCircle_bfConst::~constCircle_bfConst(){}

void constCircle_bfConst::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constCircle_bfConst::get_fLabel()
{ return a_fLabel; }
void constCircle_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constCircle_bfConst::get_bfConst()
{ return a_bfConst; }
void constCircle_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constCircle_coneConst::constCircle_coneConst(){}

constCircle_coneConst::constCircle_coneConst(
  fLabel * fLabelIn,
  coneConst * coneConstIn)
{
  a_fLabel = fLabelIn;
  a_coneConst = coneConstIn;
}

constCircle_coneConst::~constCircle_coneConst(){}

void constCircle_coneConst::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_coneConst->printSelf();
}

fLabel * constCircle_coneConst::get_fLabel()
{ return a_fLabel; }
void constCircle_coneConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
coneConst * constCircle_coneConst::get_coneConst()
{ return a_coneConst; }
void constCircle_coneConst::set_coneConst(coneConst * coneConstIn)
{ a_coneConst = coneConstIn; }

/********************************************************************/

constCircle_intofConst::constCircle_intofConst(){}

constCircle_intofConst::constCircle_intofConst(
  fLabel * fLabelIn,
  intofConst * intofConstIn)
{
  a_fLabel = fLabelIn;
  a_intofConst = intofConstIn;
}

constCircle_intofConst::~constCircle_intofConst(){}

void constCircle_intofConst::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_intofConst->printSelf();
}

fLabel * constCircle_intofConst::get_fLabel()
{ return a_fLabel; }
void constCircle_intofConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intofConst * constCircle_intofConst::get_intofConst()
{ return a_intofConst; }
void constCircle_intofConst::set_intofConst(intofConst * intofConstIn)
{ a_intofConst = intofConstIn; }

/********************************************************************/

constCircle_projctConst::constCircle_projctConst(){}

constCircle_projctConst::constCircle_projctConst(
  fLabel * fLabelIn,
  projctConst * projctConstIn)
{
  a_fLabel = fLabelIn;
  a_projctConst = projctConstIn;
}

constCircle_projctConst::~constCircle_projctConst(){}

void constCircle_projctConst::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_projctConst->printSelf();
}

fLabel * constCircle_projctConst::get_fLabel()
{ return a_fLabel; }
void constCircle_projctConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
projctConst * constCircle_projctConst::get_projctConst()
{ return a_projctConst; }
void constCircle_projctConst::set_projctConst(projctConst * projctConstIn)
{ a_projctConst = projctConstIn; }

/********************************************************************/

constCircle_tantoConst::constCircle_tantoConst(){}

constCircle_tantoConst::constCircle_tantoConst(
  fLabel * fLabelIn,
  tantoConst * tantoConstIn)
{
  a_fLabel = fLabelIn;
  a_tantoConst = tantoConstIn;
}

constCircle_tantoConst::~constCircle_tantoConst(){}

void constCircle_tantoConst::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_tantoConst->printSelf();
}

fLabel * constCircle_tantoConst::get_fLabel()
{ return a_fLabel; }
void constCircle_tantoConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
tantoConst * constCircle_tantoConst::get_tantoConst()
{ return a_tantoConst; }
void constCircle_tantoConst::set_tantoConst(tantoConst * tantoConstIn)
{ a_tantoConst = tantoConstIn; }

/********************************************************************/

constCircle_trConst::constCircle_trConst(){}

constCircle_trConst::constCircle_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constCircle_trConst::~constCircle_trConst(){}

void constCircle_trConst::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constCircle_trConst::get_fLabel()
{ return a_fLabel; }
void constCircle_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constCircle_trConst::get_trConst()
{ return a_trConst; }
void constCircle_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constCircle_retrieve2::constCircle_retrieve2(){}

constCircle_retrieve2::constCircle_retrieve2(
  fLabel * fLabelIn,
  retrieve2 * retrieve2In)
{
  a_fLabel = fLabelIn;
  a_retrieve2 = retrieve2In;
}

constCircle_retrieve2::~constCircle_retrieve2(){}

void constCircle_retrieve2::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_retrieve2->printSelf();
}

fLabel * constCircle_retrieve2::get_fLabel()
{ return a_fLabel; }
void constCircle_retrieve2::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
retrieve2 * constCircle_retrieve2::get_retrieve2()
{ return a_retrieve2; }
void constCircle_retrieve2::set_retrieve2(retrieve2 * retrieve2In)
{ a_retrieve2 = retrieve2In; }

/********************************************************************/

constCompound::constCompound(){}

constCompound::constCompound(
  fLabel * fLabelIn)
{
  a_fLabel = fLabelIn;
}

constCompound::~constCompound(){}

void constCompound::printSelf()
{
  printf("COMPOUND");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  printf("BUILD");
}

fLabel * constCompound::get_fLabel()
{ return a_fLabel; }
void constCompound::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }

/********************************************************************/

constCone::constCone(){};

constCone::~constCone(){}

/********************************************************************/

constCone_bfConst::constCone_bfConst(){}

constCone_bfConst::constCone_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constCone_bfConst::~constCone_bfConst(){}

void constCone_bfConst::printSelf()
{
  printf("CONE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constCone_bfConst::get_fLabel()
{ return a_fLabel; }
void constCone_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constCone_bfConst::get_bfConst()
{ return a_bfConst; }
void constCone_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constCone_trConst::constCone_trConst(){}

constCone_trConst::constCone_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constCone_trConst::~constCone_trConst(){}

void constCone_trConst::printSelf()
{
  printf("CONE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constCone_trConst::get_fLabel()
{ return a_fLabel; }
void constCone_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constCone_trConst::get_trConst()
{ return a_trConst; }
void constCone_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constCparln::constCparln(){};

constCparln::~constCparln(){}

/********************************************************************/

constCparln_bfConst::constCparln_bfConst(){}

constCparln_bfConst::constCparln_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constCparln_bfConst::~constCparln_bfConst(){}

void constCparln_bfConst::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constCparln_bfConst::get_fLabel()
{ return a_fLabel; }
void constCparln_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constCparln_bfConst::get_bfConst()
{ return a_bfConst; }
void constCparln_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constCparln_projctConst::constCparln_projctConst(){}

constCparln_projctConst::constCparln_projctConst(
  fLabel * fLabelIn,
  projctConst * projctConstIn)
{
  a_fLabel = fLabelIn;
  a_projctConst = projctConstIn;
}

constCparln_projctConst::~constCparln_projctConst(){}

void constCparln_projctConst::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_projctConst->printSelf();
}

fLabel * constCparln_projctConst::get_fLabel()
{ return a_fLabel; }
void constCparln_projctConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
projctConst * constCparln_projctConst::get_projctConst()
{ return a_projctConst; }
void constCparln_projctConst::set_projctConst(projctConst * projctConstIn)
{ a_projctConst = projctConstIn; }

/********************************************************************/

constCparln_trConst::constCparln_trConst(){}

constCparln_trConst::constCparln_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constCparln_trConst::~constCparln_trConst(){}

void constCparln_trConst::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constCparln_trConst::get_fLabel()
{ return a_fLabel; }
void constCparln_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constCparln_trConst::get_trConst()
{ return a_trConst; }
void constCparln_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constCparln_retrieve2::constCparln_retrieve2(){}

constCparln_retrieve2::constCparln_retrieve2(
  fLabel * fLabelIn,
  retrieve2 * retrieve2In)
{
  a_fLabel = fLabelIn;
  a_retrieve2 = retrieve2In;
}

constCparln_retrieve2::~constCparln_retrieve2(){}

void constCparln_retrieve2::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_retrieve2->printSelf();
}

fLabel * constCparln_retrieve2::get_fLabel()
{ return a_fLabel; }
void constCparln_retrieve2::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
retrieve2 * constCparln_retrieve2::get_retrieve2()
{ return a_retrieve2; }
void constCparln_retrieve2::set_retrieve2(retrieve2 * retrieve2In)
{ a_retrieve2 = retrieve2In; }

/********************************************************************/

constCylndr::constCylndr(){};

constCylndr::~constCylndr(){}

/********************************************************************/

constCylndr_bfConst::constCylndr_bfConst(){}

constCylndr_bfConst::constCylndr_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constCylndr_bfConst::~constCylndr_bfConst(){}

void constCylndr_bfConst::printSelf()
{
  printf("CYLNDR");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constCylndr_bfConst::get_fLabel()
{ return a_fLabel; }
void constCylndr_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constCylndr_bfConst::get_bfConst()
{ return a_bfConst; }
void constCylndr_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constCylndr_trConst::constCylndr_trConst(){}

constCylndr_trConst::constCylndr_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constCylndr_trConst::~constCylndr_trConst(){}

void constCylndr_trConst::printSelf()
{
  printf("CYLNDR");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constCylndr_trConst::get_fLabel()
{ return a_fLabel; }
void constCylndr_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constCylndr_trConst::get_trConst()
{ return a_trConst; }
void constCylndr_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constCylndr_retrieve1::constCylndr_retrieve1(){}

constCylndr_retrieve1::constCylndr_retrieve1(
  fLabel * fLabelIn,
  retrieve1 * retrieve1In)
{
  a_fLabel = fLabelIn;
  a_retrieve1 = retrieve1In;
}

constCylndr_retrieve1::~constCylndr_retrieve1(){}

void constCylndr_retrieve1::printSelf()
{
  printf("CYLNDR");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_retrieve1->printSelf();
}

fLabel * constCylndr_retrieve1::get_fLabel()
{ return a_fLabel; }
void constCylndr_retrieve1::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
retrieve1 * constCylndr_retrieve1::get_retrieve1()
{ return a_retrieve1; }
void constCylndr_retrieve1::set_retrieve1(retrieve1 * retrieve1In)
{ a_retrieve1 = retrieve1In; }

/********************************************************************/

constEllips::constEllips(){};

constEllips::~constEllips(){}

/********************************************************************/

constEllips_bfConst::constEllips_bfConst(){}

constEllips_bfConst::constEllips_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constEllips_bfConst::~constEllips_bfConst(){}

void constEllips_bfConst::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constEllips_bfConst::get_fLabel()
{ return a_fLabel; }
void constEllips_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constEllips_bfConst::get_bfConst()
{ return a_bfConst; }
void constEllips_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constEllips_intofConst::constEllips_intofConst(){}

constEllips_intofConst::constEllips_intofConst(
  fLabel * fLabelIn,
  intofConst * intofConstIn)
{
  a_fLabel = fLabelIn;
  a_intofConst = intofConstIn;
}

constEllips_intofConst::~constEllips_intofConst(){}

void constEllips_intofConst::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_intofConst->printSelf();
}

fLabel * constEllips_intofConst::get_fLabel()
{ return a_fLabel; }
void constEllips_intofConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intofConst * constEllips_intofConst::get_intofConst()
{ return a_intofConst; }
void constEllips_intofConst::set_intofConst(intofConst * intofConstIn)
{ a_intofConst = intofConstIn; }

/********************************************************************/

constEllips_projctConst::constEllips_projctConst(){}

constEllips_projctConst::constEllips_projctConst(
  fLabel * fLabelIn,
  projctConst * projctConstIn)
{
  a_fLabel = fLabelIn;
  a_projctConst = projctConstIn;
}

constEllips_projctConst::~constEllips_projctConst(){}

void constEllips_projctConst::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_projctConst->printSelf();
}

fLabel * constEllips_projctConst::get_fLabel()
{ return a_fLabel; }
void constEllips_projctConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
projctConst * constEllips_projctConst::get_projctConst()
{ return a_projctConst; }
void constEllips_projctConst::set_projctConst(projctConst * projctConstIn)
{ a_projctConst = projctConstIn; }

/********************************************************************/

constEllips_trConst::constEllips_trConst(){}

constEllips_trConst::constEllips_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constEllips_trConst::~constEllips_trConst(){}

void constEllips_trConst::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constEllips_trConst::get_fLabel()
{ return a_fLabel; }
void constEllips_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constEllips_trConst::get_trConst()
{ return a_trConst; }
void constEllips_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constEdgept::constEdgept(){}

constEdgept::constEdgept(
  fLabel * fLabelIn,
  retrieve4 * retrieve4In)
{
  a_fLabel = fLabelIn;
  a_retrieve4 = retrieve4In;
}

constEdgept::~constEdgept(){}

void constEdgept::printSelf()
{
  printf("EDGEPT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_retrieve4->printSelf();
}

fLabel * constEdgept::get_fLabel()
{ return a_fLabel; }
void constEdgept::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
retrieve4 * constEdgept::get_retrieve4()
{ return a_retrieve4; }
void constEdgept::set_retrieve4(retrieve4 * retrieve4In)
{ a_retrieve4 = retrieve4In; }

/********************************************************************/

constGeom::constGeom(){}

constGeom::constGeom(
  fLabel * fLabelIn,
  nearptConst * nearptConstIn)
{
  a_fLabel = fLabelIn;
  a_nearptConst = nearptConstIn;
}

constGeom::~constGeom(){}

void constGeom::printSelf()
{
  printf("GEOM");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_nearptConst->printSelf();
}

fLabel * constGeom::get_fLabel()
{ return a_fLabel; }
void constGeom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
nearptConst * constGeom::get_nearptConst()
{ return a_nearptConst; }
void constGeom::set_nearptConst(nearptConst * nearptConstIn)
{ a_nearptConst = nearptConstIn; }

/********************************************************************/

constGcurve::constGcurve(){};

constGcurve::~constGcurve(){}

/********************************************************************/

constGcurve_bfConst::constGcurve_bfConst(){}

constGcurve_bfConst::constGcurve_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constGcurve_bfConst::~constGcurve_bfConst(){}

void constGcurve_bfConst::printSelf()
{
  printf("GCURVE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constGcurve_bfConst::get_fLabel()
{ return a_fLabel; }
void constGcurve_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constGcurve_bfConst::get_bfConst()
{ return a_bfConst; }
void constGcurve_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constGcurve_projctConst::constGcurve_projctConst(){}

constGcurve_projctConst::constGcurve_projctConst(
  fLabel * fLabelIn,
  projctConst * projctConstIn)
{
  a_fLabel = fLabelIn;
  a_projctConst = projctConstIn;
}

constGcurve_projctConst::~constGcurve_projctConst(){}

void constGcurve_projctConst::printSelf()
{
  printf("GCURVE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_projctConst->printSelf();
}

fLabel * constGcurve_projctConst::get_fLabel()
{ return a_fLabel; }
void constGcurve_projctConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
projctConst * constGcurve_projctConst::get_projctConst()
{ return a_projctConst; }
void constGcurve_projctConst::set_projctConst(projctConst * projctConstIn)
{ a_projctConst = projctConstIn; }

/********************************************************************/

constGcurve_trConst::constGcurve_trConst(){}

constGcurve_trConst::constGcurve_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constGcurve_trConst::~constGcurve_trConst(){}

void constGcurve_trConst::printSelf()
{
  printf("GCURVE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constGcurve_trConst::get_fLabel()
{ return a_fLabel; }
void constGcurve_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constGcurve_trConst::get_trConst()
{ return a_trConst; }
void constGcurve_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constGsurf::constGsurf(){};

constGsurf::~constGsurf(){}

/********************************************************************/

constGsurf_bfConst::constGsurf_bfConst(){}

constGsurf_bfConst::constGsurf_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constGsurf_bfConst::~constGsurf_bfConst(){}

void constGsurf_bfConst::printSelf()
{
  printf("GSURF");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constGsurf_bfConst::get_fLabel()
{ return a_fLabel; }
void constGsurf_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constGsurf_bfConst::get_bfConst()
{ return a_bfConst; }
void constGsurf_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constGsurf_trConst::constGsurf_trConst(){}

constGsurf_trConst::constGsurf_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constGsurf_trConst::~constGsurf_trConst(){}

void constGsurf_trConst::printSelf()
{
  printf("GSURF");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constGsurf_trConst::get_fLabel()
{ return a_fLabel; }
void constGsurf_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constGsurf_trConst::get_trConst()
{ return a_trConst; }
void constGsurf_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constLine::constLine(){};

constLine::~constLine(){}

/********************************************************************/

constLine_bfConst::constLine_bfConst(){}

constLine_bfConst::constLine_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constLine_bfConst::~constLine_bfConst(){}

void constLine_bfConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constLine_bfConst::get_fLabel()
{ return a_fLabel; }
void constLine_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constLine_bfConst::get_bfConst()
{ return a_bfConst; }
void constLine_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constLine_intofConst::constLine_intofConst(){}

constLine_intofConst::constLine_intofConst(
  fLabel * fLabelIn,
  intofConst * intofConstIn)
{
  a_fLabel = fLabelIn;
  a_intofConst = intofConstIn;
}

constLine_intofConst::~constLine_intofConst(){}

void constLine_intofConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_intofConst->printSelf();
}

fLabel * constLine_intofConst::get_fLabel()
{ return a_fLabel; }
void constLine_intofConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intofConst * constLine_intofConst::get_intofConst()
{ return a_intofConst; }
void constLine_intofConst::set_intofConst(intofConst * intofConstIn)
{ a_intofConst = intofConstIn; }

/********************************************************************/

constLine_midliConst::constLine_midliConst(){}

constLine_midliConst::constLine_midliConst(
  fLabel * fLabelIn,
  midliConst * midliConstIn)
{
  a_fLabel = fLabelIn;
  a_midliConst = midliConstIn;
}

constLine_midliConst::~constLine_midliConst(){}

void constLine_midliConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_midliConst->printSelf();
}

fLabel * constLine_midliConst::get_fLabel()
{ return a_fLabel; }
void constLine_midliConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
midliConst * constLine_midliConst::get_midliConst()
{ return a_midliConst; }
void constLine_midliConst::set_midliConst(midliConst * midliConstIn)
{ a_midliConst = midliConstIn; }

/********************************************************************/

constLine_offsetConst::constLine_offsetConst(){}

constLine_offsetConst::constLine_offsetConst(
  fLabel * fLabelIn,
  offsetConst * offsetConstIn)
{
  a_fLabel = fLabelIn;
  a_offsetConst = offsetConstIn;
}

constLine_offsetConst::~constLine_offsetConst(){}

void constLine_offsetConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_offsetConst->printSelf();
}

fLabel * constLine_offsetConst::get_fLabel()
{ return a_fLabel; }
void constLine_offsetConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
offsetConst * constLine_offsetConst::get_offsetConst()
{ return a_offsetConst; }
void constLine_offsetConst::set_offsetConst(offsetConst * offsetConstIn)
{ a_offsetConst = offsetConstIn; }

/********************************************************************/

constLine_partoConst::constLine_partoConst(){}

constLine_partoConst::constLine_partoConst(
  fLabel * fLabelIn,
  partoConst * partoConstIn)
{
  a_fLabel = fLabelIn;
  a_partoConst = partoConstIn;
}

constLine_partoConst::~constLine_partoConst(){}

void constLine_partoConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_partoConst->printSelf();
}

fLabel * constLine_partoConst::get_fLabel()
{ return a_fLabel; }
void constLine_partoConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
partoConst * constLine_partoConst::get_partoConst()
{ return a_partoConst; }
void constLine_partoConst::set_partoConst(partoConst * partoConstIn)
{ a_partoConst = partoConstIn; }

/********************************************************************/

constLine_perptoConst::constLine_perptoConst(){}

constLine_perptoConst::constLine_perptoConst(
  fLabel * fLabelIn,
  perptoConst * perptoConstIn)
{
  a_fLabel = fLabelIn;
  a_perptoConst = perptoConstIn;
}

constLine_perptoConst::~constLine_perptoConst(){}

void constLine_perptoConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_perptoConst->printSelf();
}

fLabel * constLine_perptoConst::get_fLabel()
{ return a_fLabel; }
void constLine_perptoConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
perptoConst * constLine_perptoConst::get_perptoConst()
{ return a_perptoConst; }
void constLine_perptoConst::set_perptoConst(perptoConst * perptoConstIn)
{ a_perptoConst = perptoConstIn; }

/********************************************************************/

constLine_projliConst::constLine_projliConst(){}

constLine_projliConst::constLine_projliConst(
  fLabel * fLabelIn,
  projliConst * projliConstIn)
{
  a_fLabel = fLabelIn;
  a_projliConst = projliConstIn;
}

constLine_projliConst::~constLine_projliConst(){}

void constLine_projliConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_projliConst->printSelf();
}

fLabel * constLine_projliConst::get_fLabel()
{ return a_fLabel; }
void constLine_projliConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
projliConst * constLine_projliConst::get_projliConst()
{ return a_projliConst; }
void constLine_projliConst::set_projliConst(projliConst * projliConstIn)
{ a_projliConst = projliConstIn; }

/********************************************************************/

constLine_tantoConst::constLine_tantoConst(){}

constLine_tantoConst::constLine_tantoConst(
  fLabel * fLabelIn,
  tantoConst * tantoConstIn)
{
  a_fLabel = fLabelIn;
  a_tantoConst = tantoConstIn;
}

constLine_tantoConst::~constLine_tantoConst(){}

void constLine_tantoConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_tantoConst->printSelf();
}

fLabel * constLine_tantoConst::get_fLabel()
{ return a_fLabel; }
void constLine_tantoConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
tantoConst * constLine_tantoConst::get_tantoConst()
{ return a_tantoConst; }
void constLine_tantoConst::set_tantoConst(tantoConst * tantoConstIn)
{ a_tantoConst = tantoConstIn; }

/********************************************************************/

constLine_trConst::constLine_trConst(){}

constLine_trConst::constLine_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constLine_trConst::~constLine_trConst(){}

void constLine_trConst::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constLine_trConst::get_fLabel()
{ return a_fLabel; }
void constLine_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constLine_trConst::get_trConst()
{ return a_trConst; }
void constLine_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constParpln::constParpln(){}

constParpln::constParpln(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constParpln::~constParpln(){}

void constParpln::printSelf()
{
  printf("PARPLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constParpln::get_fLabel()
{ return a_fLabel; }
void constParpln::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constParpln::get_bfConst()
{ return a_bfConst; }
void constParpln::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constPatern::constPatern(){};

constPatern::~constPatern(){}

/********************************************************************/

constPatern_trConst::constPatern_trConst(){}

constPatern_trConst::constPatern_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constPatern_trConst::~constPatern_trConst(){}

void constPatern_trConst::printSelf()
{
  printf("PATERN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constPatern_trConst::get_fLabel()
{ return a_fLabel; }
void constPatern_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constPatern_trConst::get_trConst()
{ return a_trConst; }
void constPatern_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constPatern_BUILD::constPatern_BUILD(){}

constPatern_BUILD::constPatern_BUILD(
  fLabel * fLabelIn)
{
  a_fLabel = fLabelIn;
}

constPatern_BUILD::~constPatern_BUILD(){}

void constPatern_BUILD::printSelf()
{
  printf("PATERN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  printf("BUILD");
}

fLabel * constPatern_BUILD::get_fLabel()
{ return a_fLabel; }
void constPatern_BUILD::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }

/********************************************************************/

constPlane::constPlane(){};

constPlane::~constPlane(){}

/********************************************************************/

constPlane_bfConst::constPlane_bfConst(){}

constPlane_bfConst::constPlane_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constPlane_bfConst::~constPlane_bfConst(){}

void constPlane_bfConst::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constPlane_bfConst::get_fLabel()
{ return a_fLabel; }
void constPlane_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constPlane_bfConst::get_bfConst()
{ return a_bfConst; }
void constPlane_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constPlane_midplConst::constPlane_midplConst(){}

constPlane_midplConst::constPlane_midplConst(
  fLabel * fLabelIn,
  midplConst * midplConstIn)
{
  a_fLabel = fLabelIn;
  a_midplConst = midplConstIn;
}

constPlane_midplConst::~constPlane_midplConst(){}

void constPlane_midplConst::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_midplConst->printSelf();
}

fLabel * constPlane_midplConst::get_fLabel()
{ return a_fLabel; }
void constPlane_midplConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
midplConst * constPlane_midplConst::get_midplConst()
{ return a_midplConst; }
void constPlane_midplConst::set_midplConst(midplConst * midplConstIn)
{ a_midplConst = midplConstIn; }

/********************************************************************/

constPlane_offsetConst::constPlane_offsetConst(){}

constPlane_offsetConst::constPlane_offsetConst(
  fLabel * fLabelIn,
  offsetConst * offsetConstIn)
{
  a_fLabel = fLabelIn;
  a_offsetConst = offsetConstIn;
}

constPlane_offsetConst::~constPlane_offsetConst(){}

void constPlane_offsetConst::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_offsetConst->printSelf();
}

fLabel * constPlane_offsetConst::get_fLabel()
{ return a_fLabel; }
void constPlane_offsetConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
offsetConst * constPlane_offsetConst::get_offsetConst()
{ return a_offsetConst; }
void constPlane_offsetConst::set_offsetConst(offsetConst * offsetConstIn)
{ a_offsetConst = offsetConstIn; }

/********************************************************************/

constPlane_partoConst::constPlane_partoConst(){}

constPlane_partoConst::constPlane_partoConst(
  fLabel * fLabelIn,
  partoConst * partoConstIn)
{
  a_fLabel = fLabelIn;
  a_partoConst = partoConstIn;
}

constPlane_partoConst::~constPlane_partoConst(){}

void constPlane_partoConst::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_partoConst->printSelf();
}

fLabel * constPlane_partoConst::get_fLabel()
{ return a_fLabel; }
void constPlane_partoConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
partoConst * constPlane_partoConst::get_partoConst()
{ return a_partoConst; }
void constPlane_partoConst::set_partoConst(partoConst * partoConstIn)
{ a_partoConst = partoConstIn; }

/********************************************************************/

constPlane_perptoConst::constPlane_perptoConst(){}

constPlane_perptoConst::constPlane_perptoConst(
  fLabel * fLabelIn,
  perptoConst * perptoConstIn)
{
  a_fLabel = fLabelIn;
  a_perptoConst = perptoConstIn;
}

constPlane_perptoConst::~constPlane_perptoConst(){}

void constPlane_perptoConst::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_perptoConst->printSelf();
}

fLabel * constPlane_perptoConst::get_fLabel()
{ return a_fLabel; }
void constPlane_perptoConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
perptoConst * constPlane_perptoConst::get_perptoConst()
{ return a_perptoConst; }
void constPlane_perptoConst::set_perptoConst(perptoConst * perptoConstIn)
{ a_perptoConst = perptoConstIn; }

/********************************************************************/

constPlane_tantoConstPlane::constPlane_tantoConstPlane(){}

constPlane_tantoConstPlane::constPlane_tantoConstPlane(
  fLabel * fLabelIn,
  tantoConstPlane * tantoConstPlaneIn)
{
  a_fLabel = fLabelIn;
  a_tantoConstPlane = tantoConstPlaneIn;
}

constPlane_tantoConstPlane::~constPlane_tantoConstPlane(){}

void constPlane_tantoConstPlane::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_tantoConstPlane->printSelf();
}

fLabel * constPlane_tantoConstPlane::get_fLabel()
{ return a_fLabel; }
void constPlane_tantoConstPlane::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
tantoConstPlane * constPlane_tantoConstPlane::get_tantoConstPlane()
{ return a_tantoConstPlane; }
void constPlane_tantoConstPlane::set_tantoConstPlane(tantoConstPlane * tantoConstPlaneIn)
{ a_tantoConstPlane = tantoConstPlaneIn; }

/********************************************************************/

constPlane_trConst::constPlane_trConst(){}

constPlane_trConst::constPlane_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constPlane_trConst::~constPlane_trConst(){}

void constPlane_trConst::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constPlane_trConst::get_fLabel()
{ return a_fLabel; }
void constPlane_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constPlane_trConst::get_trConst()
{ return a_trConst; }
void constPlane_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constPoint::constPoint(){};

constPoint::~constPoint(){}

/********************************************************************/

constPoint_cogConst::constPoint_cogConst(){}

constPoint_cogConst::constPoint_cogConst(
  fLabel * fLabelIn,
  cogConst * cogConstIn)
{
  a_fLabel = fLabelIn;
  a_cogConst = cogConstIn;
}

constPoint_cogConst::~constPoint_cogConst(){}

void constPoint_cogConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_cogConst->printSelf();
}

fLabel * constPoint_cogConst::get_fLabel()
{ return a_fLabel; }
void constPoint_cogConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
cogConst * constPoint_cogConst::get_cogConst()
{ return a_cogConst; }
void constPoint_cogConst::set_cogConst(cogConst * cogConstIn)
{ a_cogConst = cogConstIn; }

/********************************************************************/

constPoint_curveConst::constPoint_curveConst(){}

constPoint_curveConst::constPoint_curveConst(
  fLabel * fLabelIn,
  curveConst * curveConstIn)
{
  a_fLabel = fLabelIn;
  a_curveConst = curveConstIn;
}

constPoint_curveConst::~constPoint_curveConst(){}

void constPoint_curveConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_curveConst->printSelf();
}

fLabel * constPoint_curveConst::get_fLabel()
{ return a_fLabel; }
void constPoint_curveConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
curveConst * constPoint_curveConst::get_curveConst()
{ return a_curveConst; }
void constPoint_curveConst::set_curveConst(curveConst * curveConstIn)
{ a_curveConst = curveConstIn; }

/********************************************************************/

constPoint_extremConst::constPoint_extremConst(){}

constPoint_extremConst::constPoint_extremConst(
  fLabel * fLabelIn,
  extremConst * extremConstIn)
{
  a_fLabel = fLabelIn;
  a_extremConst = extremConstIn;
}

constPoint_extremConst::~constPoint_extremConst(){}

void constPoint_extremConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_extremConst->printSelf();
}

fLabel * constPoint_extremConst::get_fLabel()
{ return a_fLabel; }
void constPoint_extremConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
extremConst * constPoint_extremConst::get_extremConst()
{ return a_extremConst; }
void constPoint_extremConst::set_extremConst(extremConst * extremConstIn)
{ a_extremConst = extremConstIn; }

/********************************************************************/

constPoint_intofConst::constPoint_intofConst(){}

constPoint_intofConst::constPoint_intofConst(
  fLabel * fLabelIn,
  intofConst * intofConstIn)
{
  a_fLabel = fLabelIn;
  a_intofConst = intofConstIn;
}

constPoint_intofConst::~constPoint_intofConst(){}

void constPoint_intofConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_intofConst->printSelf();
}

fLabel * constPoint_intofConst::get_fLabel()
{ return a_fLabel; }
void constPoint_intofConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intofConst * constPoint_intofConst::get_intofConst()
{ return a_intofConst; }
void constPoint_intofConst::set_intofConst(intofConst * intofConstIn)
{ a_intofConst = intofConstIn; }

/********************************************************************/

constPoint_midptConst::constPoint_midptConst(){}

constPoint_midptConst::constPoint_midptConst(
  fLabel * fLabelIn,
  midptConst * midptConstIn)
{
  a_fLabel = fLabelIn;
  a_midptConst = midptConstIn;
}

constPoint_midptConst::~constPoint_midptConst(){}

void constPoint_midptConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_midptConst->printSelf();
}

fLabel * constPoint_midptConst::get_fLabel()
{ return a_fLabel; }
void constPoint_midptConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
midptConst * constPoint_midptConst::get_midptConst()
{ return a_midptConst; }
void constPoint_midptConst::set_midptConst(midptConst * midptConstIn)
{ a_midptConst = midptConstIn; }

/********************************************************************/

constPoint_moveptConst::constPoint_moveptConst(){}

constPoint_moveptConst::constPoint_moveptConst(
  fLabel * fLabelIn,
  moveptConst * moveptConstIn)
{
  a_fLabel = fLabelIn;
  a_moveptConst = moveptConstIn;
}

constPoint_moveptConst::~constPoint_moveptConst(){}

void constPoint_moveptConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_moveptConst->printSelf();
}

fLabel * constPoint_moveptConst::get_fLabel()
{ return a_fLabel; }
void constPoint_moveptConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
moveptConst * constPoint_moveptConst::get_moveptConst()
{ return a_moveptConst; }
void constPoint_moveptConst::set_moveptConst(moveptConst * moveptConstIn)
{ a_moveptConst = moveptConstIn; }

/********************************************************************/

constPoint_pierceConst::constPoint_pierceConst(){}

constPoint_pierceConst::constPoint_pierceConst(
  fLabel * fLabelIn,
  pierceConst * pierceConstIn)
{
  a_fLabel = fLabelIn;
  a_pierceConst = pierceConstIn;
}

constPoint_pierceConst::~constPoint_pierceConst(){}

void constPoint_pierceConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_pierceConst->printSelf();
}

fLabel * constPoint_pierceConst::get_fLabel()
{ return a_fLabel; }
void constPoint_pierceConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
pierceConst * constPoint_pierceConst::get_pierceConst()
{ return a_pierceConst; }
void constPoint_pierceConst::set_pierceConst(pierceConst * pierceConstIn)
{ a_pierceConst = pierceConstIn; }

/********************************************************************/

constPoint_projptConst::constPoint_projptConst(){}

constPoint_projptConst::constPoint_projptConst(
  fLabel * fLabelIn,
  projptConst * projptConstIn)
{
  a_fLabel = fLabelIn;
  a_projptConst = projptConstIn;
}

constPoint_projptConst::~constPoint_projptConst(){}

void constPoint_projptConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_projptConst->printSelf();
}

fLabel * constPoint_projptConst::get_fLabel()
{ return a_fLabel; }
void constPoint_projptConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
projptConst * constPoint_projptConst::get_projptConst()
{ return a_projptConst; }
void constPoint_projptConst::set_projptConst(projptConst * projptConstIn)
{ a_projptConst = projptConstIn; }

/********************************************************************/

constPoint_trConst::constPoint_trConst(){}

constPoint_trConst::constPoint_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constPoint_trConst::~constPoint_trConst(){}

void constPoint_trConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constPoint_trConst::get_fLabel()
{ return a_fLabel; }
void constPoint_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constPoint_trConst::get_trConst()
{ return a_trConst; }
void constPoint_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constPoint_vertexConst::constPoint_vertexConst(){}

constPoint_vertexConst::constPoint_vertexConst(
  fLabel * fLabelIn,
  vertexConst * vertexConstIn)
{
  a_fLabel = fLabelIn;
  a_vertexConst = vertexConstIn;
}

constPoint_vertexConst::~constPoint_vertexConst(){}

void constPoint_vertexConst::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_vertexConst->printSelf();
}

fLabel * constPoint_vertexConst::get_fLabel()
{ return a_fLabel; }
void constPoint_vertexConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
vertexConst * constPoint_vertexConst::get_vertexConst()
{ return a_vertexConst; }
void constPoint_vertexConst::set_vertexConst(vertexConst * vertexConstIn)
{ a_vertexConst = vertexConstIn; }

/********************************************************************/

constPoint_retrieve1::constPoint_retrieve1(){}

constPoint_retrieve1::constPoint_retrieve1(
  fLabel * fLabelIn,
  retrieve1 * retrieve1In)
{
  a_fLabel = fLabelIn;
  a_retrieve1 = retrieve1In;
}

constPoint_retrieve1::~constPoint_retrieve1(){}

void constPoint_retrieve1::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_retrieve1->printSelf();
}

fLabel * constPoint_retrieve1::get_fLabel()
{ return a_fLabel; }
void constPoint_retrieve1::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
retrieve1 * constPoint_retrieve1::get_retrieve1()
{ return a_retrieve1; }
void constPoint_retrieve1::set_retrieve1(retrieve1 * retrieve1In)
{ a_retrieve1 = retrieve1In; }

/********************************************************************/

retrieve1::retrieve1(){}

retrieve1::retrieve1(
  rentVal * searchRadIn,
  std::list<faLabel *> * featureActualListIn)
{
  searchRad = searchRadIn;
  a_featureActualList = featureActualListIn;
}

retrieve1::~retrieve1(){}

void retrieve1::printSelf()
{
  printf("RETRIEVE");
  printf(",");
  searchRad->printSelf();
  printf(",");
  if (a_featureActualList->begin() == a_featureActualList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<faLabel *>::iterator iter;
      for (iter = a_featureActualList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureActualList->end())
            break;
          printf(",");
        }
    }
}

rentVal * retrieve1::get_searchRad()
{ return searchRad; }
void retrieve1::set_searchRad(rentVal * searchRadIn)
{ searchRad = searchRadIn; }
std::list<faLabel *> * retrieve1::get_featureActualList()
{ return a_featureActualList; }
void retrieve1::set_featureActualList(std::list<faLabel *> * featureActualListIn)
{ a_featureActualList = featureActualListIn; }

/********************************************************************/

retrieve2::retrieve2(){}

retrieve2::retrieve2(
  rentVal * searchRadIn,
  rentVal * depthIn,
  std::list<faLabel *> * featureActualListIn)
{
  searchRad = searchRadIn;
  depth = depthIn;
  a_featureActualList = featureActualListIn;
}

retrieve2::~retrieve2(){}

void retrieve2::printSelf()
{
  printf("RETRIEVE");
  printf(",");
  searchRad->printSelf();
  printf(",");
  depth->printSelf();
  printf(",");
  if (a_featureActualList->begin() == a_featureActualList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<faLabel *>::iterator iter;
      for (iter = a_featureActualList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureActualList->end())
            break;
          printf(",");
        }
    }
}

rentVal * retrieve2::get_searchRad()
{ return searchRad; }
void retrieve2::set_searchRad(rentVal * searchRadIn)
{ searchRad = searchRadIn; }
rentVal * retrieve2::get_depth()
{ return depth; }
void retrieve2::set_depth(rentVal * depthIn)
{ depth = depthIn; }
std::list<faLabel *> * retrieve2::get_featureActualList()
{ return a_featureActualList; }
void retrieve2::set_featureActualList(std::list<faLabel *> * featureActualListIn)
{ a_featureActualList = featureActualListIn; }

/********************************************************************/

retrieve4::retrieve4(){}

retrieve4::retrieve4(
  rentVal * distIn,
  rentVal * patchRadIn,
  rentVal * depthIn,
  rentVal * searchRadIn,
  std::list<faLabel *> * featureActualListIn)
{
  dist = distIn;
  patchRad = patchRadIn;
  depth = depthIn;
  searchRad = searchRadIn;
  a_featureActualList = featureActualListIn;
}

retrieve4::~retrieve4(){}

void retrieve4::printSelf()
{
  printf("RETRIEVE");
  printf(",");
  dist->printSelf();
  printf(",");
  patchRad->printSelf();
  printf(",");
  depth->printSelf();
  printf(",");
  searchRad->printSelf();
  printf(",");
  if (a_featureActualList->begin() == a_featureActualList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<faLabel *>::iterator iter;
      for (iter = a_featureActualList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureActualList->end())
            break;
          printf(",");
        }
    }
}

rentVal * retrieve4::get_dist()
{ return dist; }
void retrieve4::set_dist(rentVal * distIn)
{ dist = distIn; }
rentVal * retrieve4::get_patchRad()
{ return patchRad; }
void retrieve4::set_patchRad(rentVal * patchRadIn)
{ patchRad = patchRadIn; }
rentVal * retrieve4::get_depth()
{ return depth; }
void retrieve4::set_depth(rentVal * depthIn)
{ depth = depthIn; }
rentVal * retrieve4::get_searchRad()
{ return searchRad; }
void retrieve4::set_searchRad(rentVal * searchRadIn)
{ searchRad = searchRadIn; }
std::list<faLabel *> * retrieve4::get_featureActualList()
{ return a_featureActualList; }
void retrieve4::set_featureActualList(std::list<faLabel *> * featureActualListIn)
{ a_featureActualList = featureActualListIn; }

/********************************************************************/

retrieve2b::retrieve2b(){}

retrieve2b::retrieve2b(
  rentVal * searchRadIn,
  vector * axisIn,
  std::list<faLabel *> * featureActualListIn)
{
  searchRad = searchRadIn;
  axis = axisIn;
  a_featureActualList = featureActualListIn;
}

retrieve2b::~retrieve2b(){}

void retrieve2b::printSelf()
{
  printf("RETRIEVE");
  printf(",");
  searchRad->printSelf();
  if (axis)
    {
      printf(",");
      axis->printSelf();
    }
  printf(",");
  if (a_featureActualList->begin() == a_featureActualList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<faLabel *>::iterator iter;
      for (iter = a_featureActualList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureActualList->end())
            break;
          printf(",");
        }
    }
}

rentVal * retrieve2b::get_searchRad()
{ return searchRad; }
void retrieve2b::set_searchRad(rentVal * searchRadIn)
{ searchRad = searchRadIn; }
vector * retrieve2b::get_axis()
{ return axis; }
void retrieve2b::set_axis(vector * axisIn)
{ axis = axisIn; }
std::list<faLabel *> * retrieve2b::get_featureActualList()
{ return a_featureActualList; }
void retrieve2b::set_featureActualList(std::list<faLabel *> * featureActualListIn)
{ a_featureActualList = featureActualListIn; }

/********************************************************************/

constRctngl::constRctngl(){};

constRctngl::~constRctngl(){}

/********************************************************************/

constRctngl_bfConst::constRctngl_bfConst(){}

constRctngl_bfConst::constRctngl_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constRctngl_bfConst::~constRctngl_bfConst(){}

void constRctngl_bfConst::printSelf()
{
  printf("RCTNGL");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constRctngl_bfConst::get_fLabel()
{ return a_fLabel; }
void constRctngl_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constRctngl_bfConst::get_bfConst()
{ return a_bfConst; }
void constRctngl_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constRctngl_trConst::constRctngl_trConst(){}

constRctngl_trConst::constRctngl_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constRctngl_trConst::~constRctngl_trConst(){}

void constRctngl_trConst::printSelf()
{
  printf("RCTNGL");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constRctngl_trConst::get_fLabel()
{ return a_fLabel; }
void constRctngl_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constRctngl_trConst::get_trConst()
{ return a_trConst; }
void constRctngl_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constSgage::constSgage(){}

constSgage::constSgage(
  seLabel * seLabelIn,
  sgageConst * sgageConstIn)
{
  a_seLabel = seLabelIn;
  a_sgageConst = sgageConstIn;
}

constSgage::~constSgage(){}

void constSgage::printSelf()
{
  printf("SGAGE");
  printf(",");
  a_seLabel->printSelf();
  printf(",");
  a_sgageConst->printSelf();
}

seLabel * constSgage::get_seLabel()
{ return a_seLabel; }
void constSgage::set_seLabel(seLabel * seLabelIn)
{ a_seLabel = seLabelIn; }
sgageConst * constSgage::get_sgageConst()
{ return a_sgageConst; }
void constSgage::set_sgageConst(sgageConst * sgageConstIn)
{ a_sgageConst = sgageConstIn; }

/********************************************************************/

constSpart::constSpart(){}

constSpart::constSpart(
  stLabel * stLabelIn,
  spartConst * spartConstIn)
{
  a_stLabel = stLabelIn;
  a_spartConst = spartConstIn;
}

constSpart::~constSpart(){}

void constSpart::printSelf()
{
  printf("SPART");
  printf(",");
  a_stLabel->printSelf();
  printf(",");
  a_spartConst->printSelf();
}

stLabel * constSpart::get_stLabel()
{ return a_stLabel; }
void constSpart::set_stLabel(stLabel * stLabelIn)
{ a_stLabel = stLabelIn; }
spartConst * constSpart::get_spartConst()
{ return a_spartConst; }
void constSpart::set_spartConst(spartConst * spartConstIn)
{ a_spartConst = spartConstIn; }

/********************************************************************/

constSphere::constSphere(){};

constSphere::~constSphere(){}

/********************************************************************/

constSphere_bfConst::constSphere_bfConst(){}

constSphere_bfConst::constSphere_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constSphere_bfConst::~constSphere_bfConst(){}

void constSphere_bfConst::printSelf()
{
  printf("SPHERE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constSphere_bfConst::get_fLabel()
{ return a_fLabel; }
void constSphere_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constSphere_bfConst::get_bfConst()
{ return a_bfConst; }
void constSphere_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constSphere_trConst::constSphere_trConst(){}

constSphere_trConst::constSphere_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constSphere_trConst::~constSphere_trConst(){}

void constSphere_trConst::printSelf()
{
  printf("SPHERE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constSphere_trConst::get_fLabel()
{ return a_fLabel; }
void constSphere_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constSphere_trConst::get_trConst()
{ return a_trConst; }
void constSphere_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

constSphere_retrieve2b::constSphere_retrieve2b(){}

constSphere_retrieve2b::constSphere_retrieve2b(
  fLabel * fLabelIn,
  retrieve2b * retrieve2bIn)
{
  a_fLabel = fLabelIn;
  a_retrieve2b = retrieve2bIn;
}

constSphere_retrieve2b::~constSphere_retrieve2b(){}

void constSphere_retrieve2b::printSelf()
{
  printf("SPHERE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_retrieve2b->printSelf();
}

fLabel * constSphere_retrieve2b::get_fLabel()
{ return a_fLabel; }
void constSphere_retrieve2b::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
retrieve2b * constSphere_retrieve2b::get_retrieve2b()
{ return a_retrieve2b; }
void constSphere_retrieve2b::set_retrieve2b(retrieve2b * retrieve2bIn)
{ a_retrieve2b = retrieve2bIn; }

/********************************************************************/

constSympln::constSympln(){}

constSympln::constSympln(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constSympln::~constSympln(){}

void constSympln::printSelf()
{
  printf("SYMPLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constSympln::get_fLabel()
{ return a_fLabel; }
void constSympln::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constSympln::get_bfConst()
{ return a_bfConst; }
void constSympln::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constTorus::constTorus(){};

constTorus::~constTorus(){}

/********************************************************************/

constTorus_bfConst::constTorus_bfConst(){}

constTorus_bfConst::constTorus_bfConst(
  fLabel * fLabelIn,
  bfConst * bfConstIn)
{
  a_fLabel = fLabelIn;
  a_bfConst = bfConstIn;
}

constTorus_bfConst::~constTorus_bfConst(){}

void constTorus_bfConst::printSelf()
{
  printf("TORUS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_bfConst->printSelf();
}

fLabel * constTorus_bfConst::get_fLabel()
{ return a_fLabel; }
void constTorus_bfConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
bfConst * constTorus_bfConst::get_bfConst()
{ return a_bfConst; }
void constTorus_bfConst::set_bfConst(bfConst * bfConstIn)
{ a_bfConst = bfConstIn; }

/********************************************************************/

constTorus_trConst::constTorus_trConst(){}

constTorus_trConst::constTorus_trConst(
  fLabel * fLabelIn,
  trConst * trConstIn)
{
  a_fLabel = fLabelIn;
  a_trConst = trConstIn;
}

constTorus_trConst::~constTorus_trConst(){}

void constTorus_trConst::printSelf()
{
  printf("TORUS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_trConst->printSelf();
}

fLabel * constTorus_trConst::get_fLabel()
{ return a_fLabel; }
void constTorus_trConst::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
trConst * constTorus_trConst::get_trConst()
{ return a_trConst; }
void constTorus_trConst::set_trConst(trConst * trConstIn)
{ a_trConst = trConstIn; }

/********************************************************************/

bfConst::bfConst(){};

bfConst::~bfConst(){}

/********************************************************************/

bfConst_featureList::bfConst_featureList(){}

bfConst_featureList::bfConst_featureList(
  std::list<featureLabel *> * featureListIn)
{
  a_featureList = featureListIn;
}

bfConst_featureList::~bfConst_featureList(){}

void bfConst_featureList::printSelf()
{
  printf("BF");
  printf(",");
  if (a_featureList->begin() == a_featureList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<featureLabel *>::iterator iter;
      for (iter = a_featureList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureList->end())
            break;
          printf(",");
        }
    }
}

std::list<featureLabel *> * bfConst_featureList::get_featureList()
{ return a_featureList; }
void bfConst_featureList::set_featureList(std::list<featureLabel *> * featureListIn)
{ a_featureList = featureListIn; }

/********************************************************************/

bfConst_indexedFeatureList::bfConst_indexedFeatureList(){}

bfConst_indexedFeatureList::bfConst_indexedFeatureList(
  std::list<indexedFeature *> * indexedFeatureListIn)
{
  a_indexedFeatureList = indexedFeatureListIn;
}

bfConst_indexedFeatureList::~bfConst_indexedFeatureList(){}

void bfConst_indexedFeatureList::printSelf()
{
  printf("BF");
  printf(",");
  if (a_indexedFeatureList->begin() == a_indexedFeatureList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<indexedFeature *>::iterator iter;
      for (iter = a_indexedFeatureList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_indexedFeatureList->end())
            break;
          printf(",");
        }
    }
}

std::list<indexedFeature *> * bfConst_indexedFeatureList::get_indexedFeatureList()
{ return a_indexedFeatureList; }
void bfConst_indexedFeatureList::set_indexedFeatureList(std::list<indexedFeature *> * indexedFeatureListIn)
{ a_indexedFeatureList = indexedFeatureListIn; }

/********************************************************************/

cogConst::cogConst(){}

cogConst::cogConst(
  std::list<featureLabel *> * featureListIn)
{
  a_featureList = featureListIn;
}

cogConst::~cogConst(){}

void cogConst::printSelf()
{
  printf("COG");
  printf(",");
  if (a_featureList->begin() == a_featureList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<featureLabel *>::iterator iter;
      for (iter = a_featureList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureList->end())
            break;
          printf(",");
        }
    }
}

std::list<featureLabel *> * cogConst::get_featureList()
{ return a_featureList; }
void cogConst::set_featureList(std::list<featureLabel *> * featureListIn)
{ a_featureList = featureListIn; }

/********************************************************************/

coneConst::coneConst(){};

coneConst::~coneConst(){}

/********************************************************************/

coneConst_DIAM::coneConst_DIAM(){}

coneConst_DIAM::coneConst_DIAM(
  rentVal * diamIn,
  faLabel * faLabelIn)
{
  diam = diamIn;
  a_faLabel = faLabelIn;
}

coneConst_DIAM::~coneConst_DIAM(){}

void coneConst_DIAM::printSelf()
{
  printf("CONE");
  printf(",");
  printf("DIAM");
  printf(",");
  diam->printSelf();
  printf(",");
  a_faLabel->printSelf();
}

rentVal * coneConst_DIAM::get_diam()
{ return diam; }
void coneConst_DIAM::set_diam(rentVal * diamIn)
{ diam = diamIn; }
faLabel * coneConst_DIAM::get_faLabel()
{ return a_faLabel; }
void coneConst_DIAM::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

coneConst_DIST::coneConst_DIST(){}

coneConst_DIST::coneConst_DIST(
  rentVal * distIn,
  faLabel * faLabelIn)
{
  dist = distIn;
  a_faLabel = faLabelIn;
}

coneConst_DIST::~coneConst_DIST(){}

void coneConst_DIST::printSelf()
{
  printf("CONE");
  printf(",");
  printf("DIST");
  printf(",");
  dist->printSelf();
  printf(",");
  a_faLabel->printSelf();
}

rentVal * coneConst_DIST::get_dist()
{ return dist; }
void coneConst_DIST::set_dist(rentVal * distIn)
{ dist = distIn; }
faLabel * coneConst_DIST::get_faLabel()
{ return a_faLabel; }
void coneConst_DIST::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

curveConst::curveConst(){}

curveConst::curveConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

curveConst::~curveConst(){}

void curveConst::printSelf()
{
  printf("CURVE");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * curveConst::get_faLabel()
{ return a_faLabel; }
void curveConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * curveConst::get_featureLabel()
{ return a_featureLabel; }
void curveConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

extremConst::extremConst(){};

extremConst::~extremConst(){}

/********************************************************************/

extremConst_MIN::extremConst_MIN(){}

extremConst_MIN::extremConst_MIN(
  faLabel * faLabelIn,
  extremConstDir * extremConstDirIn)
{
  a_faLabel = faLabelIn;
  a_extremConstDir = extremConstDirIn;
}

extremConst_MIN::~extremConst_MIN(){}

void extremConst_MIN::printSelf()
{
  printf("EXTREM");
  printf(",");
  printf("MIN");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_extremConstDir->printSelf();
}

faLabel * extremConst_MIN::get_faLabel()
{ return a_faLabel; }
void extremConst_MIN::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
extremConstDir * extremConst_MIN::get_extremConstDir()
{ return a_extremConstDir; }
void extremConst_MIN::set_extremConstDir(extremConstDir * extremConstDirIn)
{ a_extremConstDir = extremConstDirIn; }

/********************************************************************/

extremConst_MAX::extremConst_MAX(){}

extremConst_MAX::extremConst_MAX(
  faLabel * faLabelIn,
  extremConstDir * extremConstDirIn)
{
  a_faLabel = faLabelIn;
  a_extremConstDir = extremConstDirIn;
}

extremConst_MAX::~extremConst_MAX(){}

void extremConst_MAX::printSelf()
{
  printf("EXTREM");
  printf(",");
  printf("MAX");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_extremConstDir->printSelf();
}

faLabel * extremConst_MAX::get_faLabel()
{ return a_faLabel; }
void extremConst_MAX::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
extremConstDir * extremConst_MAX::get_extremConstDir()
{ return a_extremConstDir; }
void extremConst_MAX::set_extremConstDir(extremConstDir * extremConstDirIn)
{ a_extremConstDir = extremConstDirIn; }

/********************************************************************/

extremConstDir::extremConstDir(){};

extremConstDir::~extremConstDir(){}

/********************************************************************/

extremConstAxial::extremConstAxial(){};

extremConstAxial::~extremConstAxial(){}

/********************************************************************/

extremConstVectorial::extremConstVectorial(){}

extremConstVectorial::extremConstVectorial(
  vector * dirIn)
{
  dir = dirIn;
}

extremConstVectorial::~extremConstVectorial(){}

void extremConstVectorial::printSelf()
{
  printf("VEC");
  printf(",");
  dir->printSelf();
}

vector * extremConstVectorial::get_dir()
{ return dir; }
void extremConstVectorial::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

extremConstFeature::extremConstFeature(){};

extremConstFeature::~extremConstFeature(){}

/********************************************************************/

extremConstRadial::extremConstRadial(){}

extremConstRadial::~extremConstRadial(){}

void extremConstRadial::printSelf()
{
  printf("RADIAL");
}

/********************************************************************/

intofConst::intofConst(){}

intofConst::intofConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

intofConst::~intofConst(){}

void intofConst::printSelf()
{
  printf("INTOF");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * intofConst::get_faLabel()
{ return a_faLabel; }
void intofConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * intofConst::get_featureLabel()
{ return a_featureLabel; }
void intofConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

midliConst::midliConst(){}

midliConst::midliConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

midliConst::~midliConst(){}

void midliConst::printSelf()
{
  printf("MIDLI");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * midliConst::get_faLabel()
{ return a_faLabel; }
void midliConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * midliConst::get_featureLabel()
{ return a_featureLabel; }
void midliConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

midplConst::midplConst(){}

midplConst::midplConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

midplConst::~midplConst(){}

void midplConst::printSelf()
{
  printf("MIDPL");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * midplConst::get_faLabel()
{ return a_faLabel; }
void midplConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * midplConst::get_featureLabel()
{ return a_featureLabel; }
void midplConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

midptConst::midptConst(){}

midptConst::midptConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

midptConst::~midptConst(){}

void midptConst::printSelf()
{
  printf("MIDPT");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * midptConst::get_faLabel()
{ return a_faLabel; }
void midptConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * midptConst::get_featureLabel()
{ return a_featureLabel; }
void midptConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

moveptConst::moveptConst(){};

moveptConst::~moveptConst(){}

/********************************************************************/

moveptConstVec::moveptConstVec(){}

moveptConstVec::moveptConstVec(
  faLabel * faLabelIn,
  vector * offsetIn)
{
  a_faLabel = faLabelIn;
  offset = offsetIn;
}

moveptConstVec::~moveptConstVec(){}

void moveptConstVec::printSelf()
{
  printf("MOVEPT");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  offset->printSelf();
}

faLabel * moveptConstVec::get_faLabel()
{ return a_faLabel; }
void moveptConstVec::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
vector * moveptConstVec::get_offset()
{ return offset; }
void moveptConstVec::set_offset(vector * offsetIn)
{ offset = offsetIn; }

/********************************************************************/

moveptConstAxis::moveptConstAxis(){}

moveptConstAxis::moveptConstAxis(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn,
  rentVal * distIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
  dist = distIn;
}

moveptConstAxis::~moveptConstAxis(){}

void moveptConstAxis::printSelf()
{
  printf("MOVEPT");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
  printf(",");
  dist->printSelf();
}

faLabel * moveptConstAxis::get_faLabel()
{ return a_faLabel; }
void moveptConstAxis::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * moveptConstAxis::get_featureLabel()
{ return a_featureLabel; }
void moveptConstAxis::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
rentVal * moveptConstAxis::get_dist()
{ return dist; }
void moveptConstAxis::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

nearptConst::nearptConst(){}

nearptConst::nearptConst(
  faLabel * faLabelIn)
{
  a_faLabel = faLabelIn;
}

nearptConst::~nearptConst(){}

void nearptConst::printSelf()
{
  printf("NEARPT");
  printf(",");
  a_faLabel->printSelf();
}

faLabel * nearptConst::get_faLabel()
{ return a_faLabel; }
void nearptConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

offsetConst::offsetConst(){}

offsetConst::offsetConst(
  std::list<featureLabel *> * featureListIn)
{
  a_featureList = featureListIn;
}

offsetConst::~offsetConst(){}

void offsetConst::printSelf()
{
  printf("OFFSET");
  printf(",");
  if (a_featureList->begin() == a_featureList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<featureLabel *>::iterator iter;
      for (iter = a_featureList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureList->end())
            break;
          printf(",");
        }
    }
}

std::list<featureLabel *> * offsetConst::get_featureList()
{ return a_featureList; }
void offsetConst::set_featureList(std::list<featureLabel *> * featureListIn)
{ a_featureList = featureListIn; }

/********************************************************************/

partoConst::partoConst(){};

partoConst::~partoConst(){}

/********************************************************************/

partoConstAct::partoConstAct(){}

partoConstAct::partoConstAct(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

partoConstAct::~partoConstAct(){}

void partoConstAct::printSelf()
{
  printf("PARTO");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  printf("THRU");
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * partoConstAct::get_faLabel()
{ return a_faLabel; }
void partoConstAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * partoConstAct::get_featureLabel()
{ return a_featureLabel; }
void partoConstAct::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

partoConstNom::partoConstNom(){}

partoConstNom::partoConstNom(
  fLabel * fLabelIn,
  faLabel * faLabelIn)
{
  a_fLabel = fLabelIn;
  a_faLabel = faLabelIn;
}

partoConstNom::~partoConstNom(){}

void partoConstNom::printSelf()
{
  printf("PARTO");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  printf("THRU");
  printf(",");
  a_faLabel->printSelf();
}

fLabel * partoConstNom::get_fLabel()
{ return a_fLabel; }
void partoConstNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
faLabel * partoConstNom::get_faLabel()
{ return a_faLabel; }
void partoConstNom::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

perptoConst::perptoConst(){};

perptoConst::~perptoConst(){}

/********************************************************************/

perptoConstAct::perptoConstAct(){}

perptoConstAct::perptoConstAct(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

perptoConstAct::~perptoConstAct(){}

void perptoConstAct::printSelf()
{
  printf("PERPTO");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  printf("THRU");
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * perptoConstAct::get_faLabel()
{ return a_faLabel; }
void perptoConstAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * perptoConstAct::get_featureLabel()
{ return a_featureLabel; }
void perptoConstAct::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

perptoConstNom::perptoConstNom(){}

perptoConstNom::perptoConstNom(
  fLabel * fLabelIn,
  faLabel * faLabelIn)
{
  a_fLabel = fLabelIn;
  a_faLabel = faLabelIn;
}

perptoConstNom::~perptoConstNom(){}

void perptoConstNom::printSelf()
{
  printf("PERPTO");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  printf("THRU");
  printf(",");
  a_faLabel->printSelf();
}

fLabel * perptoConstNom::get_fLabel()
{ return a_fLabel; }
void perptoConstNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
faLabel * perptoConstNom::get_faLabel()
{ return a_faLabel; }
void perptoConstNom::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

pierceConst::pierceConst(){}

pierceConst::pierceConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

pierceConst::~pierceConst(){}

void pierceConst::printSelf()
{
  printf("PIERCE");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * pierceConst::get_faLabel()
{ return a_faLabel; }
void pierceConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * pierceConst::get_featureLabel()
{ return a_featureLabel; }
void pierceConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

projctConst::projctConst(){}

projctConst::projctConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

projctConst::~projctConst(){}

void projctConst::printSelf()
{
  printf("PROJCT");
  printf(",");
  a_faLabel->printSelf();
  if (a_featureLabel)
    {
      printf(",");
      a_featureLabel->printSelf();
    }
}

faLabel * projctConst::get_faLabel()
{ return a_faLabel; }
void projctConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * projctConst::get_featureLabel()
{ return a_featureLabel; }
void projctConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

projliConst::projliConst(){}

projliConst::projliConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

projliConst::~projliConst(){}

void projliConst::printSelf()
{
  printf("PROJLI");
  printf(",");
  a_faLabel->printSelf();
  if (a_featureLabel)
    {
      printf(",");
      a_featureLabel->printSelf();
    }
}

faLabel * projliConst::get_faLabel()
{ return a_faLabel; }
void projliConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * projliConst::get_featureLabel()
{ return a_featureLabel; }
void projliConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

projptConst::projptConst(){}

projptConst::projptConst(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

projptConst::~projptConst(){}

void projptConst::printSelf()
{
  printf("PROJPT");
  printf(",");
  a_faLabel->printSelf();
  if (a_featureLabel)
    {
      printf(",");
      a_featureLabel->printSelf();
    }
}

faLabel * projptConst::get_faLabel()
{ return a_faLabel; }
void projptConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * projptConst::get_featureLabel()
{ return a_featureLabel; }
void projptConst::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

sgageConst::sgageConst(){}

sgageConst::sgageConst(
  std::list<fLabel *> * featureNominalListIn)
{
  a_featureNominalList = featureNominalListIn;
}

sgageConst::~sgageConst(){}

void sgageConst::printSelf()
{
  if (a_featureNominalList->begin() == a_featureNominalList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<fLabel *>::iterator iter;
      for (iter = a_featureNominalList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureNominalList->end())
            break;
          printf(",");
        }
    }
}

std::list<fLabel *> * sgageConst::get_featureNominalList()
{ return a_featureNominalList; }
void sgageConst::set_featureNominalList(std::list<fLabel *> * featureNominalListIn)
{ a_featureNominalList = featureNominalListIn; }

/********************************************************************/

spartConst::spartConst(){}

spartConst::spartConst(
  std::list<faLabel *> * featureActualListIn)
{
  a_featureActualList = featureActualListIn;
}

spartConst::~spartConst(){}

void spartConst::printSelf()
{
  if (a_featureActualList->begin() == a_featureActualList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<faLabel *>::iterator iter;
      for (iter = a_featureActualList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureActualList->end())
            break;
          printf(",");
        }
    }
}

std::list<faLabel *> * spartConst::get_featureActualList()
{ return a_featureActualList; }
void spartConst::set_featureActualList(std::list<faLabel *> * featureActualListIn)
{ a_featureActualList = featureActualListIn; }

/********************************************************************/

tantoConst::tantoConst(){};

tantoConst::~tantoConst(){}

/********************************************************************/

tantoConstFa::tantoConstFa(){}

tantoConstFa::tantoConstFa(
  faLabel * faLabelIn,
  bool has_THRUIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  has_THRU = has_THRUIn;
  a_featureLabel = featureLabelIn;
}

tantoConstFa::~tantoConstFa(){}

void tantoConstFa::printSelf()
{
  printf("TANTO");
  printf(",");
  a_faLabel->printSelf();
  if (has_THRU == true)
    {
      printf(",");
      printf("THRU");
    }
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * tantoConstFa::get_faLabel()
{ return a_faLabel; }
void tantoConstFa::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
bool tantoConstFa::get_has_THRU()
{ return has_THRU; }
void tantoConstFa::set_has_THRU(bool has_THRUIn)
{ has_THRU = has_THRUIn; }
featureLabel * tantoConstFa::get_featureLabel()
{ return a_featureLabel; }
void tantoConstFa::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

tantoConstF::tantoConstF(){}

tantoConstF::tantoConstF(
  fLabel * fLabelIn,
  faLabel * faLabelIn)
{
  a_fLabel = fLabelIn;
  a_faLabel = faLabelIn;
}

tantoConstF::~tantoConstF(){}

void tantoConstF::printSelf()
{
  printf("TANTO");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  printf("THRU");
  printf(",");
  a_faLabel->printSelf();
}

fLabel * tantoConstF::get_fLabel()
{ return a_fLabel; }
void tantoConstF::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
faLabel * tantoConstF::get_faLabel()
{ return a_faLabel; }
void tantoConstF::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

tantoConstPlane::tantoConstPlane(){};

tantoConstPlane::~tantoConstPlane(){}

/********************************************************************/

tantoConstPlaneFa::tantoConstPlaneFa(){}

tantoConstPlaneFa::tantoConstPlaneFa(
  faLabel * faLabelIn,
  featureLabel * featureLabelIn)
{
  a_faLabel = faLabelIn;
  a_featureLabel = featureLabelIn;
}

tantoConstPlaneFa::~tantoConstPlaneFa(){}

void tantoConstPlaneFa::printSelf()
{
  printf("TANTO");
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  printf("THRU");
  printf(",");
  a_featureLabel->printSelf();
}

faLabel * tantoConstPlaneFa::get_faLabel()
{ return a_faLabel; }
void tantoConstPlaneFa::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featureLabel * tantoConstPlaneFa::get_featureLabel()
{ return a_featureLabel; }
void tantoConstPlaneFa::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

tantoConstPlaneF::tantoConstPlaneF(){}

tantoConstPlaneF::tantoConstPlaneF(
  fLabel * fLabelIn,
  faLabel * faLabelIn)
{
  a_fLabel = fLabelIn;
  a_faLabel = faLabelIn;
}

tantoConstPlaneF::~tantoConstPlaneF(){}

void tantoConstPlaneF::printSelf()
{
  printf("TANTO");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  printf("THRU");
  printf(",");
  a_faLabel->printSelf();
}

fLabel * tantoConstPlaneF::get_fLabel()
{ return a_fLabel; }
void tantoConstPlaneF::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
faLabel * tantoConstPlaneF::get_faLabel()
{ return a_faLabel; }
void tantoConstPlaneF::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

trConst::trConst(){}

trConst::trConst(
  faLabel * faLabelIn,
  datumLabel * datumLabelIn)
{
  a_faLabel = faLabelIn;
  a_datumLabel = datumLabelIn;
}

trConst::~trConst(){}

void trConst::printSelf()
{
  printf("TR");
  printf(",");
  a_faLabel->printSelf();
  if (a_datumLabel)
    {
      printf(",");
      a_datumLabel->printSelf();
    }
}

faLabel * trConst::get_faLabel()
{ return a_faLabel; }
void trConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
datumLabel * trConst::get_datumLabel()
{ return a_datumLabel; }
void trConst::set_datumLabel(datumLabel * datumLabelIn)
{ a_datumLabel = datumLabelIn; }

/********************************************************************/

vertexConst::vertexConst(){}

vertexConst::vertexConst(
  faLabel * faLabelIn)
{
  a_faLabel = faLabelIn;
}

vertexConst::~vertexConst(){}

void vertexConst::printSelf()
{
  printf("VERTEX");
  printf(",");
  a_faLabel->printSelf();
}

faLabel * vertexConst::get_faLabel()
{ return a_faLabel; }
void vertexConst::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

crgdefStm::crgdefStm(){}

crgdefStm::crgdefStm(
  crLabelConst * crLabelConstIn,
  crgdefMinor * crgdefMinorIn)
{
  a_crLabelConst = crLabelConstIn;
  a_crgdefMinor = crgdefMinorIn;
}

crgdefStm::~crgdefStm(){}

void crgdefStm::printSelf()
{
  a_crLabelConst->printSelf();
  printf("=");
  a_crgdefMinor->printSelf();
  printf("%c%c", 13, 10);
}

crLabelConst * crgdefStm::get_crLabelConst()
{ return a_crLabelConst; }
void crgdefStm::set_crLabelConst(crLabelConst * crLabelConstIn)
{ a_crLabelConst = crLabelConstIn; }
crgdefMinor * crgdefStm::get_crgdefMinor()
{ return a_crgdefMinor; }
void crgdefStm::set_crgdefMinor(crgdefMinor * crgdefMinorIn)
{ a_crgdefMinor = crgdefMinorIn; }

/********************************************************************/

crgdefMinor::crgdefMinor(){};

crgdefMinor::~crgdefMinor(){}

/********************************************************************/

crgdefNoData::crgdefNoData(){}

crgdefNoData::~crgdefNoData(){}

void crgdefNoData::printSelf()
{
  printf("CRGDEF");
}

/********************************************************************/

crgdefData::crgdefData(){}

crgdefData::crgdefData(
  impCartPoint * zoneMinIn,
  impCartPoint * zoneMaxIn,
  vector * xVecIn,
  vector * yVecIn,
  vector * zVecIn,
  vector * aVecIn)
{
  zoneMin = zoneMinIn;
  zoneMax = zoneMaxIn;
  xVec = xVecIn;
  yVec = yVecIn;
  zVec = zVecIn;
  aVec = aVecIn;
}

crgdefData::~crgdefData(){}

void crgdefData::printSelf()
{
  printf("CRGDEF");
  printf("/");
  zoneMin->printSelf();
  printf(",");
  zoneMax->printSelf();
  printf(",");
  xVec->printSelf();
  printf(",");
  yVec->printSelf();
  printf(",");
  zVec->printSelf();
  printf(",");
  aVec->printSelf();
}

impCartPoint * crgdefData::get_zoneMin()
{ return zoneMin; }
void crgdefData::set_zoneMin(impCartPoint * zoneMinIn)
{ zoneMin = zoneMinIn; }
impCartPoint * crgdefData::get_zoneMax()
{ return zoneMax; }
void crgdefData::set_zoneMax(impCartPoint * zoneMaxIn)
{ zoneMax = zoneMaxIn; }
vector * crgdefData::get_xVec()
{ return xVec; }
void crgdefData::set_xVec(vector * xVecIn)
{ xVec = xVecIn; }
vector * crgdefData::get_yVec()
{ return yVec; }
void crgdefData::set_yVec(vector * yVecIn)
{ yVec = yVecIn; }
vector * crgdefData::get_zVec()
{ return zVec; }
void crgdefData::set_zVec(vector * zVecIn)
{ zVec = zVecIn; }
vector * crgdefData::get_aVec()
{ return aVec; }
void crgdefData::set_aVec(vector * aVecIn)
{ aVec = aVecIn; }

/********************************************************************/

crmodeStm::crmodeStm(){}

crmodeStm::crmodeStm(
  crmodeMinor * crmodeMinorIn)
{
  a_crmodeMinor = crmodeMinorIn;
}

crmodeStm::~crmodeStm(){}

void crmodeStm::printSelf()
{
  printf("CRMODE");
  printf("/");
  a_crmodeMinor->printSelf();
  printf("%c%c", 13, 10);
}

crmodeMinor * crmodeStm::get_crmodeMinor()
{ return a_crmodeMinor; }
void crmodeStm::set_crmodeMinor(crmodeMinor * crmodeMinorIn)
{ a_crmodeMinor = crmodeMinorIn; }

/********************************************************************/

crmodeMinor::crmodeMinor(){};

crmodeMinor::~crmodeMinor(){}

/********************************************************************/

crmodeMinor_SEQNTL::crmodeMinor_SEQNTL(){}

crmodeMinor_SEQNTL::~crmodeMinor_SEQNTL(){}

void crmodeMinor_SEQNTL::printSelf()
{
  printf("SEQNTL");
}

/********************************************************************/

crmodeMinor_SIMUL::crmodeMinor_SIMUL(){}

crmodeMinor_SIMUL::~crmodeMinor_SIMUL(){}

void crmodeMinor_SIMUL::printSelf()
{
  printf("SIMUL");
}

/********************************************************************/

crmodeMinor_SYNC::crmodeMinor_SYNC(){}

crmodeMinor_SYNC::~crmodeMinor_SYNC(){}

void crmodeMinor_SYNC::printSelf()
{
  printf("SYNC");
}

/********************************************************************/

crosclStm::crosclStm(){}

crosclStm::crosclStm(
  state * stateIn)
{
  a_state = stateIn;
}

crosclStm::~crosclStm(){}

void crosclStm::printSelf()
{
  printf("CROSCL");
  printf("/");
  a_state->printSelf();
  printf("%c%c", 13, 10);
}

state * crosclStm::get_state()
{ return a_state; }
void crosclStm::set_state(state * stateIn)
{ a_state = stateIn; }

/********************************************************************/

crslctMinor::crslctMinor(){};

crslctMinor::~crslctMinor(){}

/********************************************************************/

crslctMinor_crLabelConst::crslctMinor_crLabelConst(){}

crslctMinor_crLabelConst::crslctMinor_crLabelConst(
  crLabelConst * crLabelConstIn)
{
  a_crLabelConst = crLabelConstIn;
}

crslctMinor_crLabelConst::~crslctMinor_crLabelConst(){}

void crslctMinor_crLabelConst::printSelf()
{
  a_crLabelConst->printSelf();
}

crLabelConst * crslctMinor_crLabelConst::get_crLabelConst()
{ return a_crLabelConst; }
void crslctMinor_crLabelConst::set_crLabelConst(crLabelConst * crLabelConstIn)
{ a_crLabelConst = crLabelConstIn; }

/********************************************************************/

crslctMinor_ALL::crslctMinor_ALL(){}

crslctMinor_ALL::~crslctMinor_ALL(){}

void crslctMinor_ALL::printSelf()
{
  printf("ALL");
}

/********************************************************************/

cutcomStm::cutcomStm(){}

cutcomStm::cutcomStm(
  ccLabel * ccLabelIn,
  cutcomMinor * cutcomMinorIn)
{
  a_ccLabel = ccLabelIn;
  a_cutcomMinor = cutcomMinorIn;
}

cutcomStm::~cutcomStm(){}

void cutcomStm::printSelf()
{
  a_ccLabel->printSelf();
  printf("=");
  printf("CUTCOM");
  printf("/");
  a_cutcomMinor->printSelf();
  printf("%c%c", 13, 10);
}

ccLabel * cutcomStm::get_ccLabel()
{ return a_ccLabel; }
void cutcomStm::set_ccLabel(ccLabel * ccLabelIn)
{ a_ccLabel = ccLabelIn; }
cutcomMinor * cutcomStm::get_cutcomMinor()
{ return a_cutcomMinor; }
void cutcomStm::set_cutcomMinor(cutcomMinor * cutcomMinorIn)
{ a_cutcomMinor = cutcomMinorIn; }

/********************************************************************/

cutcomMinor::cutcomMinor(){};

cutcomMinor::~cutcomMinor(){}

/********************************************************************/

cutcomAdjust::cutcomAdjust(){}

cutcomAdjust::cutcomAdjust(
  mdLabel * mdLabelIn,
  tlLabel * tlLabelIn,
  leftRight * leftRightIn,
  plan * planIn,
  rentVal * amtIn)
{
  a_mdLabel = mdLabelIn;
  a_tlLabel = tlLabelIn;
  a_leftRight = leftRightIn;
  a_plan = planIn;
  amt = amtIn;
}

cutcomAdjust::~cutcomAdjust(){}

void cutcomAdjust::printSelf()
{
  a_mdLabel->printSelf();
  printf(",");
  printf("ADJUST");
  printf(",");
  a_tlLabel->printSelf();
  printf(",");
  a_leftRight->printSelf();
  printf(",");
  a_plan->printSelf();
  printf(",");
  amt->printSelf();
}

mdLabel * cutcomAdjust::get_mdLabel()
{ return a_mdLabel; }
void cutcomAdjust::set_mdLabel(mdLabel * mdLabelIn)
{ a_mdLabel = mdLabelIn; }
tlLabel * cutcomAdjust::get_tlLabel()
{ return a_tlLabel; }
void cutcomAdjust::set_tlLabel(tlLabel * tlLabelIn)
{ a_tlLabel = tlLabelIn; }
leftRight * cutcomAdjust::get_leftRight()
{ return a_leftRight; }
void cutcomAdjust::set_leftRight(leftRight * leftRightIn)
{ a_leftRight = leftRightIn; }
plan * cutcomAdjust::get_plan()
{ return a_plan; }
void cutcomAdjust::set_plan(plan * planIn)
{ a_plan = planIn; }
rentVal * cutcomAdjust::get_amt()
{ return amt; }
void cutcomAdjust::set_amt(rentVal * amtIn)
{ amt = amtIn; }

/********************************************************************/

cutcomParam::cutcomParam(){}

cutcomParam::cutcomParam(
  mdLabel * mdLabelIn,
  pointVecCart * pointVecCartIn)
{
  a_mdLabel = mdLabelIn;
  a_pointVecCart = pointVecCartIn;
}

cutcomParam::~cutcomParam(){}

void cutcomParam::printSelf()
{
  a_mdLabel->printSelf();
  printf(",");
  printf("PARAM");
  printf(",");
  a_pointVecCart->printSelf();
}

mdLabel * cutcomParam::get_mdLabel()
{ return a_mdLabel; }
void cutcomParam::set_mdLabel(mdLabel * mdLabelIn)
{ a_mdLabel = mdLabelIn; }
pointVecCart * cutcomParam::get_pointVecCart()
{ return a_pointVecCart; }
void cutcomParam::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }

/********************************************************************/

cutcomMatrix::cutcomMatrix(){}

cutcomMatrix::cutcomMatrix(
  mdLabel * mdLabelIn,
  cutcomMatx * cutcomMatxIn)
{
  a_mdLabel = mdLabelIn;
  a_cutcomMatx = cutcomMatxIn;
}

cutcomMatrix::~cutcomMatrix(){}

void cutcomMatrix::printSelf()
{
  a_mdLabel->printSelf();
  printf(",");
  printf("MATRIX");
  printf(",");
  a_cutcomMatx->printSelf();
}

mdLabel * cutcomMatrix::get_mdLabel()
{ return a_mdLabel; }
void cutcomMatrix::set_mdLabel(mdLabel * mdLabelIn)
{ a_mdLabel = mdLabelIn; }
cutcomMatx * cutcomMatrix::get_cutcomMatx()
{ return a_cutcomMatx; }
void cutcomMatrix::set_cutcomMatx(cutcomMatx * cutcomMatxIn)
{ a_cutcomMatx = cutcomMatxIn; }

/********************************************************************/

cutcomMatx::cutcomMatx(){}

cutcomMatx::cutcomMatx(
  rentVal * dxIn,
  rentVal * dyIn,
  rentVal * dzIn,
  rentVal * ixIn,
  rentVal * iyIn,
  rentVal * izIn,
  rentVal * jxIn,
  rentVal * jyIn,
  rentVal * jzIn,
  rentVal * kxIn,
  rentVal * kyIn,
  rentVal * kzIn)
{
  dx = dxIn;
  dy = dyIn;
  dz = dzIn;
  ix = ixIn;
  iy = iyIn;
  iz = izIn;
  jx = jxIn;
  jy = jyIn;
  jz = jzIn;
  kx = kxIn;
  ky = kyIn;
  kz = kzIn;
}

cutcomMatx::~cutcomMatx(){}

void cutcomMatx::printSelf()
{
  dx->printSelf();
  printf(",");
  dy->printSelf();
  printf(",");
  dz->printSelf();
  printf(",");
  ix->printSelf();
  printf(",");
  iy->printSelf();
  printf(",");
  iz->printSelf();
  printf(",");
  jx->printSelf();
  printf(",");
  jy->printSelf();
  printf(",");
  jz->printSelf();
  printf(",");
  kx->printSelf();
  printf(",");
  ky->printSelf();
  printf(",");
  kz->printSelf();
}

rentVal * cutcomMatx::get_dx()
{ return dx; }
void cutcomMatx::set_dx(rentVal * dxIn)
{ dx = dxIn; }
rentVal * cutcomMatx::get_dy()
{ return dy; }
void cutcomMatx::set_dy(rentVal * dyIn)
{ dy = dyIn; }
rentVal * cutcomMatx::get_dz()
{ return dz; }
void cutcomMatx::set_dz(rentVal * dzIn)
{ dz = dzIn; }
rentVal * cutcomMatx::get_ix()
{ return ix; }
void cutcomMatx::set_ix(rentVal * ixIn)
{ ix = ixIn; }
rentVal * cutcomMatx::get_iy()
{ return iy; }
void cutcomMatx::set_iy(rentVal * iyIn)
{ iy = iyIn; }
rentVal * cutcomMatx::get_iz()
{ return iz; }
void cutcomMatx::set_iz(rentVal * izIn)
{ iz = izIn; }
rentVal * cutcomMatx::get_jx()
{ return jx; }
void cutcomMatx::set_jx(rentVal * jxIn)
{ jx = jxIn; }
rentVal * cutcomMatx::get_jy()
{ return jy; }
void cutcomMatx::set_jy(rentVal * jyIn)
{ jy = jyIn; }
rentVal * cutcomMatx::get_jz()
{ return jz; }
void cutcomMatx::set_jz(rentVal * jzIn)
{ jz = jzIn; }
rentVal * cutcomMatx::get_kx()
{ return kx; }
void cutcomMatx::set_kx(rentVal * kxIn)
{ kx = kxIn; }
rentVal * cutcomMatx::get_ky()
{ return ky; }
void cutcomMatx::set_ky(rentVal * kyIn)
{ ky = kyIn; }
rentVal * cutcomMatx::get_kz()
{ return kz; }
void cutcomMatx::set_kz(rentVal * kzIn)
{ kz = kzIn; }

/********************************************************************/

cutcomUserdf::cutcomUserdf(){}

cutcomUserdf::cutcomUserdf(
  mdLabel * mdLabelIn,
  stringVal * textIn)
{
  a_mdLabel = mdLabelIn;
  text = textIn;
}

cutcomUserdf::~cutcomUserdf(){}

void cutcomUserdf::printSelf()
{
  a_mdLabel->printSelf();
  printf(",");
  printf("USERDF");
  printf(",");
  text->printSelf();
}

mdLabel * cutcomUserdf::get_mdLabel()
{ return a_mdLabel; }
void cutcomUserdf::set_mdLabel(mdLabel * mdLabelIn)
{ a_mdLabel = mdLabelIn; }
stringVal * cutcomUserdf::get_text()
{ return text; }
void cutcomUserdf::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

czoneStm::czoneStm(){}

czoneStm::czoneStm(
  czLabel * czLabelIn)
{
  a_czLabel = czLabelIn;
}

czoneStm::~czoneStm(){}

void czoneStm::printSelf()
{
  a_czLabel->printSelf();
  printf("=");
  printf("CZONE");
  printf("%c%c", 13, 10);
}

czLabel * czoneStm::get_czLabel()
{ return a_czLabel; }
void czoneStm::set_czLabel(czLabel * czLabelIn)
{ a_czLabel = czLabelIn; }

/********************************************************************/

datdefStm::datdefStm(){}

datdefStm::datdefStm(
  datdefMinor * datdefMinorIn)
{
  a_datdefMinor = datdefMinorIn;
}

datdefStm::~datdefStm(){}

void datdefStm::printSelf()
{
  printf("DATDEF");
  printf("/");
  a_datdefMinor->printSelf();
  printf("%c%c", 13, 10);
}

datdefMinor * datdefStm::get_datdefMinor()
{ return a_datdefMinor; }
void datdefStm::set_datdefMinor(datdefMinor * datdefMinorIn)
{ a_datdefMinor = datdefMinorIn; }

/********************************************************************/

datdefMinor::datdefMinor(){};

datdefMinor::~datdefMinor(){}

/********************************************************************/

datdefMinor_featureLabel1::datdefMinor_featureLabel1(){}

datdefMinor_featureLabel1::datdefMinor_featureLabel1(
  featureLabel1 * featureLabel1In,
  datLabel * datLabelIn)
{
  a_featureLabel1 = featureLabel1In;
  a_datLabel = datLabelIn;
}

datdefMinor_featureLabel1::~datdefMinor_featureLabel1(){}

void datdefMinor_featureLabel1::printSelf()
{
  a_featureLabel1->printSelf();
  printf(",");
  a_datLabel->printSelf();
}

featureLabel1 * datdefMinor_featureLabel1::get_featureLabel1()
{ return a_featureLabel1; }
void datdefMinor_featureLabel1::set_featureLabel1(featureLabel1 * featureLabel1In)
{ a_featureLabel1 = featureLabel1In; }
datLabel * datdefMinor_featureLabel1::get_datLabel()
{ return a_datLabel; }
void datdefMinor_featureLabel1::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }

/********************************************************************/

datdefMinor_dattrgList::datdefMinor_dattrgList(){}

datdefMinor_dattrgList::datdefMinor_dattrgList(
  std::list<dattrgLabel *> * dattrgListIn,
  fLabel * fLabelIn,
  datLabel * datLabelIn)
{
  a_dattrgList = dattrgListIn;
  a_fLabel = fLabelIn;
  a_datLabel = datLabelIn;
}

datdefMinor_dattrgList::~datdefMinor_dattrgList(){}

void datdefMinor_dattrgList::printSelf()
{
  if (a_dattrgList->begin() == a_dattrgList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<dattrgLabel *>::iterator iter;
      for (iter = a_dattrgList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_dattrgList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  a_datLabel->printSelf();
}

std::list<dattrgLabel *> * datdefMinor_dattrgList::get_dattrgList()
{ return a_dattrgList; }
void datdefMinor_dattrgList::set_dattrgList(std::list<dattrgLabel *> * dattrgListIn)
{ a_dattrgList = dattrgListIn; }
fLabel * datdefMinor_dattrgList::get_fLabel()
{ return a_fLabel; }
void datdefMinor_dattrgList::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
datLabel * datdefMinor_dattrgList::get_datLabel()
{ return a_datLabel; }
void datdefMinor_dattrgList::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }

/********************************************************************/

datsetStm::datsetStm(){}

datsetStm::datsetStm(
  dLabel * dLabelIn,
  datsetMinor * datsetMinorIn)
{
  a_dLabel = dLabelIn;
  a_datsetMinor = datsetMinorIn;
}

datsetStm::~datsetStm(){}

void datsetStm::printSelf()
{
  a_dLabel->printSelf();
  printf("=");
  printf("DATSET");
  printf("/");
  a_datsetMinor->printSelf();
  printf("%c%c", 13, 10);
}

dLabel * datsetStm::get_dLabel()
{ return a_dLabel; }
void datsetStm::set_dLabel(dLabel * dLabelIn)
{ a_dLabel = dLabelIn; }
datsetMinor * datsetStm::get_datsetMinor()
{ return a_datsetMinor; }
void datsetStm::set_datsetMinor(datsetMinor * datsetMinorIn)
{ a_datsetMinor = datsetMinorIn; }

/********************************************************************/

datsetMinor::datsetMinor(){};

datsetMinor::~datsetMinor(){}

/********************************************************************/

datsetMcs::datsetMcs(){}

datsetMcs::~datsetMcs(){}

void datsetMcs::printSelf()
{
  printf("MCS");
}

/********************************************************************/

datsetMatrix::datsetMatrix(){}

datsetMatrix::datsetMatrix(
  matrix * matrixIn)
{
  a_matrix = matrixIn;
}

datsetMatrix::~datsetMatrix(){}

void datsetMatrix::printSelf()
{
  printf("TRMATX");
  printf(",");
  a_matrix->printSelf();
}

matrix * datsetMatrix::get_matrix()
{ return a_matrix; }
void datsetMatrix::set_matrix(matrix * matrixIn)
{ a_matrix = matrixIn; }

/********************************************************************/

datsetDats::datsetDats(){}

datsetDats::datsetDats(
  datsetSpec * spec1In,
  datsetSpec * spec2In,
  datsetSpec * spec3In)
{
  spec1 = spec1In;
  spec2 = spec2In;
  spec3 = spec3In;
}

datsetDats::~datsetDats(){}

void datsetDats::printSelf()
{
  spec1->printSelf();
  if (spec2)
    {
      printf(",");
      spec2->printSelf();
      if (spec3)
        {
          printf(",");
          spec3->printSelf();
        }
    }
}

datsetSpec * datsetDats::get_spec1()
{ return spec1; }
void datsetDats::set_spec1(datsetSpec * spec1In)
{ spec1 = spec1In; }
datsetSpec * datsetDats::get_spec2()
{ return spec2; }
void datsetDats::set_spec2(datsetSpec * spec2In)
{ spec2 = spec2In; }
datsetSpec * datsetDats::get_spec3()
{ return spec3; }
void datsetDats::set_spec3(datsetSpec * spec3In)
{ spec3 = spec3In; }

/********************************************************************/

datsetDrf::datsetDrf(){}

datsetDrf::datsetDrf(
  taLabel * taLabelIn,
  tier * tierIn,
  dir * dir1In,
  dir * dir2In)
{
  a_taLabel = taLabelIn;
  a_tier = tierIn;
  dir1 = dir1In;
  dir2 = dir2In;
}

datsetDrf::~datsetDrf(){}

void datsetDrf::printSelf()
{
  printf("DRF");
  printf(",");
  a_taLabel->printSelf();
  if (a_tier)
    {
      printf(",");
      a_tier->printSelf();
    }
  printf(",");
  dir1->printSelf();
  printf(",");
  dir2->printSelf();
}

taLabel * datsetDrf::get_taLabel()
{ return a_taLabel; }
void datsetDrf::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
tier * datsetDrf::get_tier()
{ return a_tier; }
void datsetDrf::set_tier(tier * tierIn)
{ a_tier = tierIn; }
dir * datsetDrf::get_dir1()
{ return dir1; }
void datsetDrf::set_dir1(dir * dir1In)
{ dir1 = dir1In; }
dir * datsetDrf::get_dir2()
{ return dir2; }
void datsetDrf::set_dir2(dir * dir2In)
{ dir2 = dir2In; }

/********************************************************************/

tier::tier(){};

tier::~tier(){}

/********************************************************************/

tier_UPTIER::tier_UPTIER(){}

tier_UPTIER::~tier_UPTIER(){}

void tier_UPTIER::printSelf()
{
  printf("UPTIER");
}

/********************************************************************/

tier_LOTIER::tier_LOTIER(){}

tier_LOTIER::~tier_LOTIER(){}

void tier_LOTIER::printSelf()
{
  printf("LOTIER");
}

/********************************************************************/

datsetSpec::datsetSpec(){};

datsetSpec::~datsetSpec(){}

/********************************************************************/

datsetSpecNoDir::datsetSpecNoDir(){}

datsetSpecNoDir::datsetSpecNoDir(
  datLabel * datLabelIn,
  orig * orig1In,
  orig * orig2In,
  orig * orig3In)
{
  a_datLabel = datLabelIn;
  orig1 = orig1In;
  orig2 = orig2In;
  orig3 = orig3In;
}

datsetSpecNoDir::~datsetSpecNoDir(){}

void datsetSpecNoDir::printSelf()
{
  a_datLabel->printSelf();
  printf(",");
  orig1->printSelf();
  if (orig2)
    {
      printf(",");
      orig2->printSelf();
      if (orig3)
        {
          printf(",");
          orig3->printSelf();
        }
    }
}

datLabel * datsetSpecNoDir::get_datLabel()
{ return a_datLabel; }
void datsetSpecNoDir::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
orig * datsetSpecNoDir::get_orig1()
{ return orig1; }
void datsetSpecNoDir::set_orig1(orig * orig1In)
{ orig1 = orig1In; }
orig * datsetSpecNoDir::get_orig2()
{ return orig2; }
void datsetSpecNoDir::set_orig2(orig * orig2In)
{ orig2 = orig2In; }
orig * datsetSpecNoDir::get_orig3()
{ return orig3; }
void datsetSpecNoDir::set_orig3(orig * orig3In)
{ orig3 = orig3In; }

/********************************************************************/

datsetSpecDir::datsetSpecDir(){}

datsetSpecDir::datsetSpecDir(
  datLabel * datLabelIn,
  dir * dirIn,
  orig * orig1In,
  orig * orig2In,
  orig * orig3In)
{
  a_datLabel = datLabelIn;
  a_dir = dirIn;
  orig1 = orig1In;
  orig2 = orig2In;
  orig3 = orig3In;
}

datsetSpecDir::~datsetSpecDir(){}

void datsetSpecDir::printSelf()
{
  a_datLabel->printSelf();
  printf(",");
  a_dir->printSelf();
  if (orig1)
    {
      printf(",");
      orig1->printSelf();
      if (orig2)
        {
          printf(",");
          orig2->printSelf();
          if (orig3)
            {
              printf(",");
              orig3->printSelf();
            }
        }
    }
}

datLabel * datsetSpecDir::get_datLabel()
{ return a_datLabel; }
void datsetSpecDir::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
dir * datsetSpecDir::get_dir()
{ return a_dir; }
void datsetSpecDir::set_dir(dir * dirIn)
{ a_dir = dirIn; }
orig * datsetSpecDir::get_orig1()
{ return orig1; }
void datsetSpecDir::set_orig1(orig * orig1In)
{ orig1 = orig1In; }
orig * datsetSpecDir::get_orig2()
{ return orig2; }
void datsetSpecDir::set_orig2(orig * orig2In)
{ orig2 = orig2In; }
orig * datsetSpecDir::get_orig3()
{ return orig3; }
void datsetSpecDir::set_orig3(orig * orig3In)
{ orig3 = orig3In; }

/********************************************************************/

dattrgdefStm::dattrgdefStm(){}

dattrgdefStm::dattrgdefStm(
  dattrgMinor * dattrgMinorIn)
{
  a_dattrgMinor = dattrgMinorIn;
}

dattrgdefStm::~dattrgdefStm(){}

void dattrgdefStm::printSelf()
{
  printf("DATTRGDEF");
  printf("/");
  a_dattrgMinor->printSelf();
  printf("%c%c", 13, 10);
}

dattrgMinor * dattrgdefStm::get_dattrgMinor()
{ return a_dattrgMinor; }
void dattrgdefStm::set_dattrgMinor(dattrgMinor * dattrgMinorIn)
{ a_dattrgMinor = dattrgMinorIn; }

/********************************************************************/

dattrgMinor::dattrgMinor(){}

dattrgMinor::dattrgMinor(
  std::list<featureLabel *> * featureListIn,
  dattrgLabel * dattrgLabelIn)
{
  a_featureList = featureListIn;
  a_dattrgLabel = dattrgLabelIn;
}

dattrgMinor::~dattrgMinor(){}

void dattrgMinor::printSelf()
{
  if (a_featureList->begin() == a_featureList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<featureLabel *>::iterator iter;
      for (iter = a_featureList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  a_dattrgLabel->printSelf();
}

std::list<featureLabel *> * dattrgMinor::get_featureList()
{ return a_featureList; }
void dattrgMinor::set_featureList(std::list<featureLabel *> * featureListIn)
{ a_featureList = featureListIn; }
dattrgLabel * dattrgMinor::get_dattrgLabel()
{ return a_dattrgLabel; }
void dattrgMinor::set_dattrgLabel(dattrgLabel * dattrgLabelIn)
{ a_dattrgLabel = dattrgLabelIn; }

/********************************************************************/

declStm::declStm(){}

declStm::declStm(
  declMinor * declMinorIn)
{
  a_declMinor = declMinorIn;
}

declStm::~declStm(){}

void declStm::printSelf()
{
  printf("DECL");
  printf("/");
  a_declMinor->printSelf();
  printf("%c%c", 13, 10);
}

declMinor * declStm::get_declMinor()
{ return a_declMinor; }
void declStm::set_declMinor(declMinor * declMinorIn)
{ a_declMinor = declMinorIn; }

/********************************************************************/

declMinor::declMinor(){}

declMinor::declMinor(
  declScope * declScopeIn,
  declType * declTypeIn,
  std::list<declVar *> * declVarListIn)
{
  a_declScope = declScopeIn;
  a_declType = declTypeIn;
  a_declVarList = declVarListIn;
}

declMinor::~declMinor(){}

void declMinor::printSelf()
{
  if (a_declScope)
    {
      a_declScope->printSelf();
      printf(",");
    }
  a_declType->printSelf();
  printf(",");
  if (a_declVarList->begin() == a_declVarList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<declVar *>::iterator iter;
      for (iter = a_declVarList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_declVarList->end())
            break;
          printf(",");
        }
    }
}

declScope * declMinor::get_declScope()
{ return a_declScope; }
void declMinor::set_declScope(declScope * declScopeIn)
{ a_declScope = declScopeIn; }
declType * declMinor::get_declType()
{ return a_declType; }
void declMinor::set_declType(declType * declTypeIn)
{ a_declType = declTypeIn; }
std::list<declVar *> * declMinor::get_declVarList()
{ return a_declVarList; }
void declMinor::set_declVarList(std::list<declVar *> * declVarListIn)
{ a_declVarList = declVarListIn; }

/********************************************************************/

declScope::declScope(){};

declScope::~declScope(){}

/********************************************************************/

declScope_COMMON::declScope_COMMON(){}

declScope_COMMON::~declScope_COMMON(){}

void declScope_COMMON::printSelf()
{
  printf("COMMON");
}

/********************************************************************/

declScope_GLOBAL::declScope_GLOBAL(){}

declScope_GLOBAL::~declScope_GLOBAL(){}

void declScope_GLOBAL::printSelf()
{
  printf("GLOBAL");
}

/********************************************************************/

declScope_LOCAL::declScope_LOCAL(){}

declScope_LOCAL::~declScope_LOCAL(){}

void declScope_LOCAL::printSelf()
{
  printf("LOCAL");
}

/********************************************************************/

declType::declType(){};

declType::~declType(){}

/********************************************************************/

declType_BOOL::declType_BOOL(){}

declType_BOOL::~declType_BOOL(){}

void declType_BOOL::printSelf()
{
  printf("BOOL");
}

/********************************************************************/

declType_INTGR::declType_INTGR(){}

declType_INTGR::~declType_INTGR(){}

void declType_INTGR::printSelf()
{
  printf("INTGR");
}

/********************************************************************/

declType_LONG::declType_LONG(){}

declType_LONG::~declType_LONG(){}

void declType_LONG::printSelf()
{
  printf("LONG");
}

/********************************************************************/

declType_REAL::declType_REAL(){}

declType_REAL::~declType_REAL(){}

void declType_REAL::printSelf()
{
  printf("REAL");
}

/********************************************************************/

declType_DOUBLE::declType_DOUBLE(){}

declType_DOUBLE::~declType_DOUBLE(){}

void declType_DOUBLE::printSelf()
{
  printf("DOUBLE");
}

/********************************************************************/

declType_CHAR::declType_CHAR(){}

declType_CHAR::declType_CHAR(
  intVal * sizeIn)
{
  size = sizeIn;
}

declType_CHAR::~declType_CHAR(){}

void declType_CHAR::printSelf()
{
  printf("CHAR");
  printf(",");
  size->printSelf();
}

intVal * declType_CHAR::get_size()
{ return size; }
void declType_CHAR::set_size(intVal * sizeIn)
{ size = sizeIn; }

/********************************************************************/

declType_VECTOR::declType_VECTOR(){}

declType_VECTOR::~declType_VECTOR(){}

void declType_VECTOR::printSelf()
{
  printf("VECTOR");
}

/********************************************************************/

declVar::declVar(){}

declVar::declVar(
  char * stringIn,
  std::list<intConst *> * declIndicesListIn)
{
  a_string = stringIn;
  a_declIndicesList = declIndicesListIn;
}

declVar::~declVar(){}

void declVar::printSelf()
{
  printf("%s", a_string);
  if (a_declIndicesList)
    {
      printf("[");
      if (a_declIndicesList->begin() == a_declIndicesList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<intConst *>::iterator iter;
          for (iter = a_declIndicesList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_declIndicesList->end())
                break;
              printf(",");
            }
        }
      printf("]");
    }
}

char * declVar::get_string()
{ return a_string; }
void declVar::set_string(char * stringIn)
{ a_string = stringIn; }
std::list<intConst *> * declVar::get_declIndicesList()
{ return a_declIndicesList; }
void declVar::set_declIndicesList(std::list<intConst *> * declIndicesListIn)
{ a_declIndicesList = declIndicesListIn; }

/********************************************************************/

decplStm::decplStm(){}

decplStm::decplStm(
  decplMinor * decplMinorIn)
{
  a_decplMinor = decplMinorIn;
}

decplStm::~decplStm(){}

void decplStm::printSelf()
{
  printf("DECPL");
  printf("/");
  a_decplMinor->printSelf();
  printf("%c%c", 13, 10);
}

decplMinor * decplStm::get_decplMinor()
{ return a_decplMinor; }
void decplStm::set_decplMinor(decplMinor * decplMinorIn)
{ a_decplMinor = decplMinorIn; }

/********************************************************************/

decplMinor::decplMinor(){};

decplMinor::~decplMinor(){}

/********************************************************************/

decplMinor_decplAll::decplMinor_decplAll(){}

decplMinor_decplAll::decplMinor_decplAll(
  decplAll * decplAllIn)
{
  a_decplAll = decplAllIn;
}

decplMinor_decplAll::~decplMinor_decplAll(){}

void decplMinor_decplAll::printSelf()
{
  a_decplAll->printSelf();
}

decplAll * decplMinor_decplAll::get_decplAll()
{ return a_decplAll; }
void decplMinor_decplAll::set_decplAll(decplAll * decplAllIn)
{ a_decplAll = decplAllIn; }

/********************************************************************/

decplMinor_decplList::decplMinor_decplList(){}

decplMinor_decplList::decplMinor_decplList(
  std::list<decplSelection *> * decplListIn)
{
  a_decplList = decplListIn;
}

decplMinor_decplList::~decplMinor_decplList(){}

void decplMinor_decplList::printSelf()
{
  if (a_decplList->begin() == a_decplList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<decplSelection *>::iterator iter;
      for (iter = a_decplList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_decplList->end())
            break;
          printf(",");
        }
    }
}

std::list<decplSelection *> * decplMinor_decplList::get_decplList()
{ return a_decplList; }
void decplMinor_decplList::set_decplList(std::list<decplSelection *> * decplListIn)
{ a_decplList = decplListIn; }

/********************************************************************/

decplAll::decplAll(){}

decplAll::decplAll(
  decplNdigits * decplNdigitsIn)
{
  a_decplNdigits = decplNdigitsIn;
}

decplAll::~decplAll(){}

void decplAll::printSelf()
{
  printf("ALL");
  printf(",");
  a_decplNdigits->printSelf();
}

decplNdigits * decplAll::get_decplNdigits()
{ return a_decplNdigits; }
void decplAll::set_decplNdigits(decplNdigits * decplNdigitsIn)
{ a_decplNdigits = decplNdigitsIn; }

/********************************************************************/

decplNdigits::decplNdigits(){};

decplNdigits::~decplNdigits(){}

/********************************************************************/

decplNdigits_DEFALT::decplNdigits_DEFALT(){}

decplNdigits_DEFALT::~decplNdigits_DEFALT(){}

void decplNdigits_DEFALT::printSelf()
{
  printf("DEFALT");
}

/********************************************************************/

decplNdigits_intVal::decplNdigits_intVal(){}

decplNdigits_intVal::decplNdigits_intVal(
  intVal * decimalIn)
{
  decimal = decimalIn;
}

decplNdigits_intVal::~decplNdigits_intVal(){}

void decplNdigits_intVal::printSelf()
{
  decimal->printSelf();
}

intVal * decplNdigits_intVal::get_decimal()
{ return decimal; }
void decplNdigits_intVal::set_decimal(intVal * decimalIn)
{ decimal = decimalIn; }

/********************************************************************/

decplSelection::decplSelection(){};

decplSelection::~decplSelection(){}

/********************************************************************/

decplSelection_ANGLE::decplSelection_ANGLE(){}

decplSelection_ANGLE::decplSelection_ANGLE(
  decplNdigits * decplNdigitsIn)
{
  a_decplNdigits = decplNdigitsIn;
}

decplSelection_ANGLE::~decplSelection_ANGLE(){}

void decplSelection_ANGLE::printSelf()
{
  printf("ANGLE");
  printf(",");
  a_decplNdigits->printSelf();
}

decplNdigits * decplSelection_ANGLE::get_decplNdigits()
{ return a_decplNdigits; }
void decplSelection_ANGLE::set_decplNdigits(decplNdigits * decplNdigitsIn)
{ a_decplNdigits = decplNdigitsIn; }

/********************************************************************/

decplSelection_DIST::decplSelection_DIST(){}

decplSelection_DIST::decplSelection_DIST(
  decplNdigits * decplNdigitsIn)
{
  a_decplNdigits = decplNdigitsIn;
}

decplSelection_DIST::~decplSelection_DIST(){}

void decplSelection_DIST::printSelf()
{
  printf("DIST");
  printf(",");
  a_decplNdigits->printSelf();
}

decplNdigits * decplSelection_DIST::get_decplNdigits()
{ return a_decplNdigits; }
void decplSelection_DIST::set_decplNdigits(decplNdigits * decplNdigitsIn)
{ a_decplNdigits = decplNdigitsIn; }

/********************************************************************/

decplSelection_HUMID::decplSelection_HUMID(){}

decplSelection_HUMID::decplSelection_HUMID(
  decplNdigits * decplNdigitsIn)
{
  a_decplNdigits = decplNdigitsIn;
}

decplSelection_HUMID::~decplSelection_HUMID(){}

void decplSelection_HUMID::printSelf()
{
  printf("HUMID");
  printf(",");
  a_decplNdigits->printSelf();
}

decplNdigits * decplSelection_HUMID::get_decplNdigits()
{ return a_decplNdigits; }
void decplSelection_HUMID::set_decplNdigits(decplNdigits * decplNdigitsIn)
{ a_decplNdigits = decplNdigitsIn; }

/********************************************************************/

decplSelection_DEV::decplSelection_DEV(){}

decplSelection_DEV::decplSelection_DEV(
  decplNdigits * decplNdigitsIn)
{
  a_decplNdigits = decplNdigitsIn;
}

decplSelection_DEV::~decplSelection_DEV(){}

void decplSelection_DEV::printSelf()
{
  printf("DEV");
  printf(",");
  a_decplNdigits->printSelf();
}

decplNdigits * decplSelection_DEV::get_decplNdigits()
{ return a_decplNdigits; }
void decplSelection_DEV::set_decplNdigits(decplNdigits * decplNdigitsIn)
{ a_decplNdigits = decplNdigitsIn; }

/********************************************************************/

decplSelection_TEMP::decplSelection_TEMP(){}

decplSelection_TEMP::decplSelection_TEMP(
  decplNdigits * decplNdigitsIn)
{
  a_decplNdigits = decplNdigitsIn;
}

decplSelection_TEMP::~decplSelection_TEMP(){}

void decplSelection_TEMP::printSelf()
{
  printf("TEMP");
  printf(",");
  a_decplNdigits->printSelf();
}

decplNdigits * decplSelection_TEMP::get_decplNdigits()
{ return a_decplNdigits; }
void decplSelection_TEMP::set_decplNdigits(decplNdigits * decplNdigitsIn)
{ a_decplNdigits = decplNdigitsIn; }

/********************************************************************/

decplSelection_VEC::decplSelection_VEC(){}

decplSelection_VEC::decplSelection_VEC(
  decplNdigits * decplNdigitsIn)
{
  a_decplNdigits = decplNdigitsIn;
}

decplSelection_VEC::~decplSelection_VEC(){}

void decplSelection_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  a_decplNdigits->printSelf();
}

decplNdigits * decplSelection_VEC::get_decplNdigits()
{ return a_decplNdigits; }
void decplSelection_VEC::set_decplNdigits(decplNdigits * decplNdigitsIn)
{ a_decplNdigits = decplNdigitsIn; }

/********************************************************************/

deleteStm::deleteStm(){}

deleteStm::deleteStm(
  deleteMinor * deleteMinorIn)
{
  a_deleteMinor = deleteMinorIn;
}

deleteStm::~deleteStm(){}

void deleteStm::printSelf()
{
  printf("DELETE");
  printf("/");
  a_deleteMinor->printSelf();
  printf("%c%c", 13, 10);
}

deleteMinor * deleteStm::get_deleteMinor()
{ return a_deleteMinor; }
void deleteStm::set_deleteMinor(deleteMinor * deleteMinorIn)
{ a_deleteMinor = deleteMinorIn; }

/********************************************************************/

deleteMinor::deleteMinor(){};

deleteMinor::~deleteMinor(){}

/********************************************************************/

deleteDatum::deleteDatum(){}

deleteDatum::deleteDatum(
  datumLabel1 * datumLabel1In,
  didLabel * didLabelIn)
{
  a_datumLabel1 = datumLabel1In;
  a_didLabel = didLabelIn;
}

deleteDatum::~deleteDatum(){}

void deleteDatum::printSelf()
{
  a_datumLabel1->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
}

datumLabel1 * deleteDatum::get_datumLabel1()
{ return a_datumLabel1; }
void deleteDatum::set_datumLabel1(datumLabel1 * datumLabel1In)
{ a_datumLabel1 = datumLabel1In; }
didLabel * deleteDatum::get_didLabel()
{ return a_didLabel; }
void deleteDatum::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

deleteSensor::deleteSensor(){}

deleteSensor::deleteSensor(
  sensorLabel1 * sensorLabel1In,
  didLabel * didLabelIn)
{
  a_sensorLabel1 = sensorLabel1In;
  a_didLabel = didLabelIn;
}

deleteSensor::~deleteSensor(){}

void deleteSensor::printSelf()
{
  a_sensorLabel1->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
}

sensorLabel1 * deleteSensor::get_sensorLabel1()
{ return a_sensorLabel1; }
void deleteSensor::set_sensorLabel1(sensorLabel1 * sensorLabel1In)
{ a_sensorLabel1 = sensorLabel1In; }
didLabel * deleteSensor::get_didLabel()
{ return a_didLabel; }
void deleteSensor::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

deleteFeature::deleteFeature(){}

deleteFeature::deleteFeature(
  faLabel * faLabelIn,
  didLabel * didLabelIn)
{
  a_faLabel = faLabelIn;
  a_didLabel = didLabelIn;
}

deleteFeature::~deleteFeature(){}

void deleteFeature::printSelf()
{
  a_faLabel->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
}

faLabel * deleteFeature::get_faLabel()
{ return a_faLabel; }
void deleteFeature::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
didLabel * deleteFeature::get_didLabel()
{ return a_didLabel; }
void deleteFeature::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

deleteRotaryTable::deleteRotaryTable(){}

deleteRotaryTable::deleteRotaryTable(
  rtLabel * rtLabelIn,
  didLabel * didLabelIn)
{
  a_rtLabel = rtLabelIn;
  a_didLabel = didLabelIn;
}

deleteRotaryTable::~deleteRotaryTable(){}

void deleteRotaryTable::printSelf()
{
  a_rtLabel->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
}

rtLabel * deleteRotaryTable::get_rtLabel()
{ return a_rtLabel; }
void deleteRotaryTable::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
didLabel * deleteRotaryTable::get_didLabel()
{ return a_didLabel; }
void deleteRotaryTable::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

deleteAllSensors::deleteAllSensors(){}

deleteAllSensors::deleteAllSensors(
  std::list<saLabel *> * saLabelListIn,
  didLabel * didLabelIn)
{
  a_saLabelList = saLabelListIn;
  a_didLabel = didLabelIn;
}

deleteAllSensors::~deleteAllSensors(){}

void deleteAllSensors::printSelf()
{
  printf("ALLSA");
  if (a_saLabelList)
    {
      printf(",");
      printf("EXCEPT");
      printf(",");
      if (a_saLabelList->begin() == a_saLabelList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<saLabel *>::iterator iter;
          for (iter = a_saLabelList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_saLabelList->end())
                break;
              printf(",");
            }
        }
    }
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
}

std::list<saLabel *> * deleteAllSensors::get_saLabelList()
{ return a_saLabelList; }
void deleteAllSensors::set_saLabelList(std::list<saLabel *> * saLabelListIn)
{ a_saLabelList = saLabelListIn; }
didLabel * deleteAllSensors::get_didLabel()
{ return a_didLabel; }
void deleteAllSensors::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

deviceStm::deviceStm(){}

deviceStm::deviceStm(
  didLabel * didLabelIn,
  deviceMinor * deviceMinorIn)
{
  a_didLabel = didLabelIn;
  a_deviceMinor = deviceMinorIn;
}

deviceStm::~deviceStm(){}

void deviceStm::printSelf()
{
  a_didLabel->printSelf();
  printf("=");
  printf("DEVICE");
  printf("/");
  a_deviceMinor->printSelf();
  printf("%c%c", 13, 10);
}

didLabel * deviceStm::get_didLabel()
{ return a_didLabel; }
void deviceStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
deviceMinor * deviceStm::get_deviceMinor()
{ return a_deviceMinor; }
void deviceStm::set_deviceMinor(deviceMinor * deviceMinorIn)
{ a_deviceMinor = deviceMinorIn; }

/********************************************************************/

deviceMinor::deviceMinor(){};

deviceMinor::~deviceMinor(){}

/********************************************************************/

deviceMinor_device::deviceMinor_device(){}

deviceMinor_device::deviceMinor_device(
  device * deviceIn,
  stringVal * nameIn)
{
  a_device = deviceIn;
  name = nameIn;
}

deviceMinor_device::~deviceMinor_device(){}

void deviceMinor_device::printSelf()
{
  a_device->printSelf();
  printf(",");
  name->printSelf();
}

device * deviceMinor_device::get_device()
{ return a_device; }
void deviceMinor_device::set_device(device * deviceIn)
{ a_device = deviceIn; }
stringVal * deviceMinor_device::get_name()
{ return name; }
void deviceMinor_device::set_name(stringVal * nameIn)
{ name = nameIn; }

/********************************************************************/

deviceMinor_INCR::deviceMinor_INCR(){}

deviceMinor_INCR::deviceMinor_INCR(
  stringVal * maskIn)
{
  mask = maskIn;
}

deviceMinor_INCR::~deviceMinor_INCR(){}

void deviceMinor_INCR::printSelf()
{
  printf("INCR");
  printf(",");
  mask->printSelf();
}

stringVal * deviceMinor_INCR::get_mask()
{ return mask; }
void deviceMinor_INCR::set_mask(stringVal * maskIn)
{ mask = maskIn; }

/********************************************************************/

dftcasStm::dftcasStm(){}

dftcasStm::~dftcasStm(){}

void dftcasStm::printSelf()
{
  printf("DFTCAS");
  printf("%c%c", 13, 10);
}

/********************************************************************/

displyStm::displyStm(){};

displyStm::~displyStm(){}

/********************************************************************/

displyStmOff::displyStmOff(){}

displyStmOff::displyStmOff(
  displyOff * displyOffIn)
{
  a_displyOff = displyOffIn;
}

displyStmOff::~displyStmOff(){}

void displyStmOff::printSelf()
{
  printf("DISPLY");
  printf("/");
  a_displyOff->printSelf();
  printf("%c%c", 13, 10);
}

displyOff * displyStmOff::get_displyOff()
{ return a_displyOff; }
void displyStmOff::set_displyOff(displyOff * displyOffIn)
{ a_displyOff = displyOffIn; }

/********************************************************************/

displyStmSpec::displyStmSpec(){}

displyStmSpec::displyStmSpec(
  std::list<displySpecItem *> * displySpecListIn)
{
  a_displySpecList = displySpecListIn;
}

displyStmSpec::~displyStmSpec(){}

void displyStmSpec::printSelf()
{
  printf("DISPLY");
  printf("/");
  if (a_displySpecList->begin() == a_displySpecList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<displySpecItem *>::iterator iter;
      for (iter = a_displySpecList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_displySpecList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

std::list<displySpecItem *> * displyStmSpec::get_displySpecList()
{ return a_displySpecList; }
void displyStmSpec::set_displySpecList(std::list<displySpecItem *> * displySpecListIn)
{ a_displySpecList = displySpecListIn; }

/********************************************************************/

displyOff::displyOff(){}

displyOff::~displyOff(){}

void displyOff::printSelf()
{
  printf("OFF");
}

/********************************************************************/

displySpecItem::displySpecItem(){};

displySpecItem::~displySpecItem(){}

/********************************************************************/

displyItemDMIS::displyItemDMIS(){}

displyItemDMIS::displyItemDMIS(
  device * deviceIn,
  vLabel * vLabelIn)
{
  a_device = deviceIn;
  a_vLabel = vLabelIn;
}

displyItemDMIS::~displyItemDMIS(){}

void displyItemDMIS::printSelf()
{
  a_device->printSelf();
  printf(",");
  printf("DMIS");
  if (a_vLabel)
    {
      printf(",");
      a_vLabel->printSelf();
    }
}

device * displyItemDMIS::get_device()
{ return a_device; }
void displyItemDMIS::set_device(device * deviceIn)
{ a_device = deviceIn; }
vLabel * displyItemDMIS::get_vLabel()
{ return a_vLabel; }
void displyItemDMIS::set_vLabel(vLabel * vLabelIn)
{ a_vLabel = vLabelIn; }

/********************************************************************/

displyItemNoDMIS::displyItemNoDMIS(){}

displyItemNoDMIS::displyItemNoDMIS(
  device * deviceIn,
  vLabel * vLabelIn)
{
  a_device = deviceIn;
  a_vLabel = vLabelIn;
}

displyItemNoDMIS::~displyItemNoDMIS(){}

void displyItemNoDMIS::printSelf()
{
  a_device->printSelf();
  printf(",");
  a_vLabel->printSelf();
}

device * displyItemNoDMIS::get_device()
{ return a_device; }
void displyItemNoDMIS::set_device(device * deviceIn)
{ a_device = deviceIn; }
vLabel * displyItemNoDMIS::get_vLabel()
{ return a_vLabel; }
void displyItemNoDMIS::set_vLabel(vLabel * vLabelIn)
{ a_vLabel = vLabelIn; }

/********************************************************************/

dmehwMinor::dmehwMinor(){};

dmehwMinor::~dmehwMinor(){}

/********************************************************************/

dmehwMinor_CONTIN::dmehwMinor_CONTIN(){}

dmehwMinor_CONTIN::~dmehwMinor_CONTIN(){}

void dmehwMinor_CONTIN::printSelf()
{
  printf("CONTIN");
}

/********************************************************************/

dmehwMinor_PAUSE::dmehwMinor_PAUSE(){}

dmehwMinor_PAUSE::~dmehwMinor_PAUSE(){}

void dmehwMinor_PAUSE::printSelf()
{
  printf("PAUSE");
}

/********************************************************************/

dmehwMinor_SINGLE::dmehwMinor_SINGLE(){}

dmehwMinor_SINGLE::~dmehwMinor_SINGLE(){}

void dmehwMinor_SINGLE::printSelf()
{
  printf("SINGLE");
}

/********************************************************************/

dmehwMinor_AUTO::dmehwMinor_AUTO(){}

dmehwMinor_AUTO::~dmehwMinor_AUTO(){}

void dmehwMinor_AUTO::printSelf()
{
  printf("AUTO");
}

/********************************************************************/

dmehwMinor_jointConf::dmehwMinor_jointConf(){}

dmehwMinor_jointConf::dmehwMinor_jointConf(
  jointConf * jointConfIn)
{
  a_jointConf = jointConfIn;
}

dmehwMinor_jointConf::~dmehwMinor_jointConf(){}

void dmehwMinor_jointConf::printSelf()
{
  a_jointConf->printSelf();
}

jointConf * dmehwMinor_jointConf::get_jointConf()
{ return a_jointConf; }
void dmehwMinor_jointConf::set_jointConf(jointConf * jointConfIn)
{ a_jointConf = jointConfIn; }

/********************************************************************/

jointConf::jointConf(){}

jointConf::jointConf(
  rightyLefty * rightyLeftyIn,
  aboveBelow * aboveBelowIn,
  flipNoFlip * flipNoFlipIn,
  std::list<stringVal *> * stringListIn)
{
  a_rightyLefty = rightyLeftyIn;
  a_aboveBelow = aboveBelowIn;
  a_flipNoFlip = flipNoFlipIn;
  a_stringList = stringListIn;
}

jointConf::~jointConf(){}

void jointConf::printSelf()
{
  printf("JOINTCONFIG");
  if (a_rightyLefty)
    {
      printf(",");
      a_rightyLefty->printSelf();
    }
  if (a_aboveBelow)
    {
      printf(",");
      a_aboveBelow->printSelf();
    }
  if (a_flipNoFlip)
    {
      printf(",");
      a_flipNoFlip->printSelf();
    }
  if (a_stringList)
    {
      printf(",");
      if (a_stringList->begin() == a_stringList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<stringVal *>::iterator iter;
          for (iter = a_stringList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_stringList->end())
                break;
              printf(",");
            }
        }
    }
}

rightyLefty * jointConf::get_rightyLefty()
{ return a_rightyLefty; }
void jointConf::set_rightyLefty(rightyLefty * rightyLeftyIn)
{ a_rightyLefty = rightyLeftyIn; }
aboveBelow * jointConf::get_aboveBelow()
{ return a_aboveBelow; }
void jointConf::set_aboveBelow(aboveBelow * aboveBelowIn)
{ a_aboveBelow = aboveBelowIn; }
flipNoFlip * jointConf::get_flipNoFlip()
{ return a_flipNoFlip; }
void jointConf::set_flipNoFlip(flipNoFlip * flipNoFlipIn)
{ a_flipNoFlip = flipNoFlipIn; }
std::list<stringVal *> * jointConf::get_stringList()
{ return a_stringList; }
void jointConf::set_stringList(std::list<stringVal *> * stringListIn)
{ a_stringList = stringListIn; }

/********************************************************************/

rightyLefty::rightyLefty(){};

rightyLefty::~rightyLefty(){}

/********************************************************************/

rightyLefty_RIGHTY::rightyLefty_RIGHTY(){}

rightyLefty_RIGHTY::~rightyLefty_RIGHTY(){}

void rightyLefty_RIGHTY::printSelf()
{
  printf("RIGHTY");
}

/********************************************************************/

rightyLefty_LEFTY::rightyLefty_LEFTY(){}

rightyLefty_LEFTY::~rightyLefty_LEFTY(){}

void rightyLefty_LEFTY::printSelf()
{
  printf("LEFTY");
}

/********************************************************************/

aboveBelow::aboveBelow(){};

aboveBelow::~aboveBelow(){}

/********************************************************************/

aboveBelow_ABOVE::aboveBelow_ABOVE(){}

aboveBelow_ABOVE::~aboveBelow_ABOVE(){}

void aboveBelow_ABOVE::printSelf()
{
  printf("ABOVE");
}

/********************************************************************/

aboveBelow_BELOW::aboveBelow_BELOW(){}

aboveBelow_BELOW::~aboveBelow_BELOW(){}

void aboveBelow_BELOW::printSelf()
{
  printf("BELOW");
}

/********************************************************************/

flipNoFlip::flipNoFlip(){};

flipNoFlip::~flipNoFlip(){}

/********************************************************************/

flipNoFlip_FLIP::flipNoFlip_FLIP(){}

flipNoFlip_FLIP::~flipNoFlip_FLIP(){}

void flipNoFlip_FLIP::printSelf()
{
  printf("FLIP");
}

/********************************************************************/

flipNoFlip_NOFLIP::flipNoFlip_NOFLIP(){}

flipNoFlip_NOFLIP::~flipNoFlip_NOFLIP(){}

void flipNoFlip_NOFLIP::printSelf()
{
  printf("NOFLIP");
}

/********************************************************************/

dmeidStm::dmeidStm(){}

dmeidStm::dmeidStm(
  diLabel * diLabelIn,
  stringVal * textIn)
{
  a_diLabel = diLabelIn;
  text = textIn;
}

dmeidStm::~dmeidStm(){}

void dmeidStm::printSelf()
{
  a_diLabel->printSelf();
  printf("=");
  printf("DMEID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

diLabel * dmeidStm::get_diLabel()
{ return a_diLabel; }
void dmeidStm::set_diLabel(diLabel * diLabelIn)
{ a_diLabel = diLabelIn; }
stringVal * dmeidStm::get_text()
{ return text; }
void dmeidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

dmeswMinor::dmeswMinor(){};

dmeswMinor::~dmeswMinor(){}

/********************************************************************/

dmeswComand::dmeswComand(){}

dmeswComand::dmeswComand(
  stringVal * commandIn)
{
  command = commandIn;
}

dmeswComand::~dmeswComand(){}

void dmeswComand::printSelf()
{
  printf("COMAND");
  printf(",");
  command->printSelf();
}

stringVal * dmeswComand::get_command()
{ return command; }
void dmeswComand::set_command(stringVal * commandIn)
{ command = commandIn; }

/********************************************************************/

dmeswDelay::dmeswDelay(){}

dmeswDelay::dmeswDelay(
  intVal * secsIn)
{
  secs = secsIn;
}

dmeswDelay::~dmeswDelay(){}

void dmeswDelay::printSelf()
{
  printf("DELAY");
  printf(",");
  secs->printSelf();
}

intVal * dmeswDelay::get_secs()
{ return secs; }
void dmeswDelay::set_secs(intVal * secsIn)
{ secs = secsIn; }

/********************************************************************/

dmeswSwitch::dmeswSwitch(){};

dmeswSwitch::~dmeswSwitch(){}

/********************************************************************/

dmeswSwitch_CONTIN::dmeswSwitch_CONTIN(){}

dmeswSwitch_CONTIN::~dmeswSwitch_CONTIN(){}

void dmeswSwitch_CONTIN::printSelf()
{
  printf("CONTIN");
}

/********************************************************************/

dmeswSwitch_PAUSE::dmeswSwitch_PAUSE(){}

dmeswSwitch_PAUSE::~dmeswSwitch_PAUSE(){}

void dmeswSwitch_PAUSE::printSelf()
{
  printf("PAUSE");
}

/********************************************************************/

dmeswiStm::dmeswiStm(){}

dmeswiStm::dmeswiStm(
  dsLabel * dsLabelIn,
  stringVal * textIn)
{
  a_dsLabel = dsLabelIn;
  text = textIn;
}

dmeswiStm::~dmeswiStm(){}

void dmeswiStm::printSelf()
{
  a_dsLabel->printSelf();
  printf("=");
  printf("DMESWI");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

dsLabel * dmeswiStm::get_dsLabel()
{ return a_dsLabel; }
void dmeswiStm::set_dsLabel(dsLabel * dsLabelIn)
{ a_dsLabel = dsLabelIn; }
stringVal * dmeswiStm::get_text()
{ return text; }
void dmeswiStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

dmeswvStm::dmeswvStm(){}

dmeswvStm::dmeswvStm(
  dvLabel * dvLabelIn,
  stringVal * textIn)
{
  a_dvLabel = dvLabelIn;
  text = textIn;
}

dmeswvStm::~dmeswvStm(){}

void dmeswvStm::printSelf()
{
  a_dvLabel->printSelf();
  printf("=");
  printf("DMESWV");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

dvLabel * dmeswvStm::get_dvLabel()
{ return a_dvLabel; }
void dmeswvStm::set_dvLabel(dvLabel * dvLabelIn)
{ a_dvLabel = dvLabelIn; }
stringVal * dmeswvStm::get_text()
{ return text; }
void dmeswvStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

dmisOffStm::dmisOffStm(){}

dmisOffStm::~dmisOffStm(){}

void dmisOffStm::printSelf()
{
  printf("DMIS");
  printf("/");
  printf("OFF");
  printf("%c%c", 13, 10);
}

/********************************************************************/

dmisOnStm::dmisOnStm(){}

dmisOnStm::~dmisOnStm(){}

void dmisOnStm::printSelf()
{
  printf("DMIS");
  printf("/");
  printf("ON");
  printf("%c%c", 13, 10);
}

/********************************************************************/

dmismdStm::dmismdStm(){}

dmismdStm::dmismdStm(
  stringConst * stringConstIn,
  versionTag * versionTagIn,
  std::list<conformItem *> * conformItemListIn)
{
  a_stringConst = stringConstIn;
  a_versionTag = versionTagIn;
  a_conformItemList = conformItemListIn;
}

dmismdStm::~dmismdStm(){}

void dmismdStm::printSelf()
{
  printf("DMISMD");
  printf("/");
  a_stringConst->printSelf();
  printf(",");
  a_versionTag->printSelf();
  if (a_conformItemList)
    {
      printf(",");
      if (a_conformItemList->begin() == a_conformItemList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<conformItem *>::iterator iter;
          for (iter = a_conformItemList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_conformItemList->end())
                break;
              printf(",");
            }
        }
    }
  printf("%c%c", 13, 10);
}

stringConst * dmismdStm::get_stringConst()
{ return a_stringConst; }
void dmismdStm::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }
versionTag * dmismdStm::get_versionTag()
{ return a_versionTag; }
void dmismdStm::set_versionTag(versionTag * versionTagIn)
{ a_versionTag = versionTagIn; }
std::list<conformItem *> * dmismdStm::get_conformItemList()
{ return a_conformItemList; }
void dmismdStm::set_conformItemList(std::list<conformItem *> * conformItemListIn)
{ a_conformItemList = conformItemListIn; }

/********************************************************************/

dmismnStm::dmismnStm(){}

dmismnStm::dmismnStm(
  stringConst * stringConstIn,
  versionTag * versionTagIn,
  std::list<conformItem *> * conformItemListIn)
{
  a_stringConst = stringConstIn;
  a_versionTag = versionTagIn;
  a_conformItemList = conformItemListIn;
}

dmismnStm::~dmismnStm(){}

void dmismnStm::printSelf()
{
  printf("DMISMN");
  printf("/");
  a_stringConst->printSelf();
  printf(",");
  a_versionTag->printSelf();
  if (a_conformItemList)
    {
      printf(",");
      if (a_conformItemList->begin() == a_conformItemList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<conformItem *>::iterator iter;
          for (iter = a_conformItemList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_conformItemList->end())
                break;
              printf(",");
            }
        }
    }
  printf("%c%c", 13, 10);
}

stringConst * dmismnStm::get_stringConst()
{ return a_stringConst; }
void dmismnStm::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }
versionTag * dmismnStm::get_versionTag()
{ return a_versionTag; }
void dmismnStm::set_versionTag(versionTag * versionTagIn)
{ a_versionTag = versionTagIn; }
std::list<conformItem *> * dmismnStm::get_conformItemList()
{ return a_conformItemList; }
void dmismnStm::set_conformItemList(std::list<conformItem *> * conformItemListIn)
{ a_conformItemList = conformItemListIn; }

/********************************************************************/

conformItem::conformItem(){}

conformItem::conformItem(
  conformType * conformTypeIn,
  int intIn)
{
  a_conformType = conformTypeIn;
  a_int = intIn;
}

conformItem::~conformItem(){}

void conformItem::printSelf()
{
  a_conformType->printSelf();
  printf(",");
  printf("%d", a_int);
}

conformType * conformItem::get_conformType()
{ return a_conformType; }
void conformItem::set_conformType(conformType * conformTypeIn)
{ a_conformType = conformTypeIn; }
int conformItem::get_int()
{ return a_int; }
void conformItem::set_int(int intIn)
{ a_int = intIn; }

/********************************************************************/

conformType::conformType(){};

conformType::~conformType(){}

/********************************************************************/

conformType_CT::conformType_CT(){}

conformType_CT::~conformType_CT(){}

void conformType_CT::printSelf()
{
  printf("CT");
}

/********************************************************************/

conformType_FX::conformType_FX(){}

conformType_FX::~conformType_FX(){}

void conformType_FX::printSelf()
{
  printf("FX");
}

/********************************************************************/

conformType_IP::conformType_IP(){}

conformType_IP::~conformType_IP(){}

void conformType_IP::printSelf()
{
  printf("IP");
}

/********************************************************************/

conformType_MC::conformType_MC(){}

conformType_MC::~conformType_MC(){}

void conformType_MC::printSelf()
{
  printf("MC");
}

/********************************************************************/

conformType_MU::conformType_MU(){}

conformType_MU::~conformType_MU(){}

void conformType_MU::printSelf()
{
  printf("MU");
}

/********************************************************************/

conformType_PM::conformType_PM(){}

conformType_PM::~conformType_PM(){}

void conformType_PM::printSelf()
{
  printf("PM");
}

/********************************************************************/

conformType_QI::conformType_QI(){}

conformType_QI::~conformType_QI(){}

void conformType_QI::printSelf()
{
  printf("QI");
}

/********************************************************************/

conformType_RY::conformType_RY(){}

conformType_RY::~conformType_RY(){}

void conformType_RY::printSelf()
{
  printf("RY");
}

/********************************************************************/

conformType_SF::conformType_SF(){}

conformType_SF::~conformType_SF(){}

void conformType_SF::printSelf()
{
  printf("SF");
}

/********************************************************************/

conformType_TW::conformType_TW(){}

conformType_TW::~conformType_TW(){}

void conformType_TW::printSelf()
{
  printf("TW");
}

/********************************************************************/

doStm::doStm(){}

doStm::doStm(
  intVar * indexIn,
  intVal * initIn,
  intVal * limitIn,
  intVal * incrIn)
{
  index = indexIn;
  init = initIn;
  limit = limitIn;
  incr = incrIn;
}

doStm::~doStm(){}

void doStm::printSelf()
{
  printf("DO");
  printf("/");
  index->printSelf();
  printf(",");
  init->printSelf();
  printf(",");
  limit->printSelf();
  if (incr)
    {
      printf(",");
      incr->printSelf();
    }
  printf("%c%c", 13, 10);
}

intVar * doStm::get_index()
{ return index; }
void doStm::set_index(intVar * indexIn)
{ index = indexIn; }
intVal * doStm::get_init()
{ return init; }
void doStm::set_init(intVal * initIn)
{ init = initIn; }
intVal * doStm::get_limit()
{ return limit; }
void doStm::set_limit(intVal * limitIn)
{ limit = limitIn; }
intVal * doStm::get_incr()
{ return incr; }
void doStm::set_incr(intVal * incrIn)
{ incr = incrIn; }

/********************************************************************/

elseStm::elseStm(){}

elseStm::~elseStm(){}

void elseStm::printSelf()
{
  printf("ELSE");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endcasStm::endcasStm(){}

endcasStm::~endcasStm(){}

void endcasStm::printSelf()
{
  printf("ENDCAS");
  printf("%c%c", 13, 10);
}

/********************************************************************/

enddoStm::enddoStm(){}

enddoStm::~enddoStm(){}

void enddoStm::printSelf()
{
  printf("ENDDO");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endfilStm::endfilStm(){}

endfilStm::~endfilStm(){}

void endfilStm::printSelf()
{
  printf("ENDFIL");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endgoStm::endgoStm(){}

endgoStm::~endgoStm(){}

void endgoStm::printSelf()
{
  printf("ENDGO");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endifStm::endifStm(){}

endifStm::~endifStm(){}

void endifStm::printSelf()
{
  printf("ENDIF");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endmacStm::endmacStm(){}

endmacStm::~endmacStm(){}

void endmacStm::printSelf()
{
  printf("ENDMAC");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endmesStm::endmesStm(){}

endmesStm::~endmesStm(){}

void endmesStm::printSelf()
{
  printf("ENDMES");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endselStm::endselStm(){}

endselStm::~endselStm(){}

void endselStm::printSelf()
{
  printf("ENDSEL");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endsimreqtStm::endsimreqtStm(){}

endsimreqtStm::~endsimreqtStm(){}

void endsimreqtStm::printSelf()
{
  printf("ENDSIMREQT");
  printf("%c%c", 13, 10);
}

/********************************************************************/

endxtnStm::endxtnStm(){}

endxtnStm::~endxtnStm(){}

void endxtnStm::printSelf()
{
  printf("ENDXTN");
  printf("%c%c", 13, 10);
}

/********************************************************************/

equateStm::equateStm(){}

equateStm::equateStm(
  equateMinor * equateMinorIn)
{
  a_equateMinor = equateMinorIn;
}

equateStm::~equateStm(){}

void equateStm::printSelf()
{
  printf("EQUATE");
  printf("/");
  a_equateMinor->printSelf();
  printf("%c%c", 13, 10);
}

equateMinor * equateStm::get_equateMinor()
{ return a_equateMinor; }
void equateStm::set_equateMinor(equateMinor * equateMinorIn)
{ a_equateMinor = equateMinorIn; }

/********************************************************************/

equateMinor::equateMinor(){};

equateMinor::~equateMinor(){}

/********************************************************************/

equateDatum::equateDatum(){}

equateDatum::equateDatum(
  daLabel * equateFromIn,
  daLabel * equateToIn)
{
  equateFrom = equateFromIn;
  equateTo = equateToIn;
}

equateDatum::~equateDatum(){}

void equateDatum::printSelf()
{
  equateFrom->printSelf();
  printf(",");
  equateTo->printSelf();
}

daLabel * equateDatum::get_equateFrom()
{ return equateFrom; }
void equateDatum::set_equateFrom(daLabel * equateFromIn)
{ equateFrom = equateFromIn; }
daLabel * equateDatum::get_equateTo()
{ return equateTo; }
void equateDatum::set_equateTo(daLabel * equateToIn)
{ equateTo = equateToIn; }

/********************************************************************/

equateCad::equateCad(){}

equateCad::equateCad(
  daLabel * equateFromIn,
  equateCadcs * equateCadcsIn)
{
  equateFrom = equateFromIn;
  a_equateCadcs = equateCadcsIn;
}

equateCad::~equateCad(){}

void equateCad::printSelf()
{
  equateFrom->printSelf();
  printf(",");
  printf("CADCS");
  printf(",");
  a_equateCadcs->printSelf();
}

daLabel * equateCad::get_equateFrom()
{ return equateFrom; }
void equateCad::set_equateFrom(daLabel * equateFromIn)
{ equateFrom = equateFromIn; }
equateCadcs * equateCad::get_equateCadcs()
{ return a_equateCadcs; }
void equateCad::set_equateCadcs(equateCadcs * equateCadcsIn)
{ a_equateCadcs = equateCadcsIn; }

/********************************************************************/

equateCadcs::equateCadcs(){};

equateCadcs::~equateCadcs(){}

/********************************************************************/

equateCadcs_matrix::equateCadcs_matrix(){}

equateCadcs_matrix::equateCadcs_matrix(
  didLabel * didLabelIn,
  matrix * matrixIn)
{
  a_didLabel = didLabelIn;
  a_matrix = matrixIn;
}

equateCadcs_matrix::~equateCadcs_matrix(){}

void equateCadcs_matrix::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  a_matrix->printSelf();
}

didLabel * equateCadcs_matrix::get_didLabel()
{ return a_didLabel; }
void equateCadcs_matrix::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
matrix * equateCadcs_matrix::get_matrix()
{ return a_matrix; }
void equateCadcs_matrix::set_matrix(matrix * matrixIn)
{ a_matrix = matrixIn; }

/********************************************************************/

equateCadcs_stringVal::equateCadcs_stringVal(){}

equateCadcs_stringVal::equateCadcs_stringVal(
  didLabel * didLabelIn,
  stringVal * textIn)
{
  a_didLabel = didLabelIn;
  text = textIn;
}

equateCadcs_stringVal::~equateCadcs_stringVal(){}

void equateCadcs_stringVal::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  text->printSelf();
}

didLabel * equateCadcs_stringVal::get_didLabel()
{ return a_didLabel; }
void equateCadcs_stringVal::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
stringVal * equateCadcs_stringVal::get_text()
{ return text; }
void equateCadcs_stringVal::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

errorMinor::errorMinor(){};

errorMinor::~errorMinor(){}

/********************************************************************/

errorMinor_jumpLabel::errorMinor_jumpLabel(){}

errorMinor_jumpLabel::errorMinor_jumpLabel(
  jumpLabel * jumpLabelIn,
  errorCondition * errorConditionIn)
{
  a_jumpLabel = jumpLabelIn;
  a_errorCondition = errorConditionIn;
}

errorMinor_jumpLabel::~errorMinor_jumpLabel(){}

void errorMinor_jumpLabel::printSelf()
{
  a_jumpLabel->printSelf();
  printf(",");
  a_errorCondition->printSelf();
}

jumpLabel * errorMinor_jumpLabel::get_jumpLabel()
{ return a_jumpLabel; }
void errorMinor_jumpLabel::set_jumpLabel(jumpLabel * jumpLabelIn)
{ a_jumpLabel = jumpLabelIn; }
errorCondition * errorMinor_jumpLabel::get_errorCondition()
{ return a_errorCondition; }
void errorMinor_jumpLabel::set_errorCondition(errorCondition * errorConditionIn)
{ a_errorCondition = errorConditionIn; }

/********************************************************************/

errorMinor_AUTO::errorMinor_AUTO(){}

errorMinor_AUTO::errorMinor_AUTO(
  errorCondition * errorConditionIn)
{
  a_errorCondition = errorConditionIn;
}

errorMinor_AUTO::~errorMinor_AUTO(){}

void errorMinor_AUTO::printSelf()
{
  printf("AUTO");
  printf(",");
  a_errorCondition->printSelf();
}

errorCondition * errorMinor_AUTO::get_errorCondition()
{ return a_errorCondition; }
void errorMinor_AUTO::set_errorCondition(errorCondition * errorConditionIn)
{ a_errorCondition = errorConditionIn; }

/********************************************************************/

errorMinor_OFF::errorMinor_OFF(){}

errorMinor_OFF::~errorMinor_OFF(){}

void errorMinor_OFF::printSelf()
{
  printf("OFF");
}

/********************************************************************/

errorCondition::errorCondition(){};

errorCondition::~errorCondition(){}

/********************************************************************/

errorCondition_ALL::errorCondition_ALL(){}

errorCondition_ALL::~errorCondition_ALL(){}

void errorCondition_ALL::printSelf()
{
  printf("ALL");
}

/********************************************************************/

errorCondition_ILLEGALTOUCH::errorCondition_ILLEGALTOUCH(){}

errorCondition_ILLEGALTOUCH::~errorCondition_ILLEGALTOUCH(){}

void errorCondition_ILLEGALTOUCH::printSelf()
{
  printf("ILLEGALTOUCH");
}

/********************************************************************/

errorCondition_NOTOUCH::errorCondition_NOTOUCH(){}

errorCondition_NOTOUCH::~errorCondition_NOTOUCH(){}

void errorCondition_NOTOUCH::printSelf()
{
  printf("NOTOUCH");
}

/********************************************************************/

errorCondition_intVal::errorCondition_intVal(){}

errorCondition_intVal::errorCondition_intVal(
  intVal * ercodeIn)
{
  ercode = ercodeIn;
}

errorCondition_intVal::~errorCondition_intVal(){}

void errorCondition_intVal::printSelf()
{
  ercode->printSelf();
}

intVal * errorCondition_intVal::get_ercode()
{ return ercode; }
void errorCondition_intVal::set_ercode(intVal * ercodeIn)
{ ercode = ercodeIn; }

/********************************************************************/

evalStm::evalStm(){}

evalStm::evalStm(
  evalMinor * evalMinorIn)
{
  a_evalMinor = evalMinorIn;
}

evalStm::~evalStm(){}

void evalStm::printSelf()
{
  printf("EVAL");
  printf("/");
  a_evalMinor->printSelf();
  printf("%c%c", 13, 10);
}

evalMinor * evalStm::get_evalMinor()
{ return a_evalMinor; }
void evalStm::set_evalMinor(evalMinor * evalMinorIn)
{ a_evalMinor = evalMinorIn; }

/********************************************************************/

evalMinor::evalMinor(){};

evalMinor::~evalMinor(){}

/********************************************************************/

evalFeat::evalFeat(){};

evalFeat::~evalFeat(){}

/********************************************************************/

evalFeatFaT::evalFeatFaT(){}

evalFeatFaT::evalFeatFaT(
  faLabel * faIn,
  std::list<tLabel *> * tLabelListIn)
{
  fa = faIn;
  a_tLabelList = tLabelListIn;
}

evalFeatFaT::~evalFeatFaT(){}

void evalFeatFaT::printSelf()
{
  fa->printSelf();
  printf(",");
  if (a_tLabelList->begin() == a_tLabelList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<tLabel *>::iterator iter;
      for (iter = a_tLabelList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_tLabelList->end())
            break;
          printf(",");
        }
    }
}

faLabel * evalFeatFaT::get_fa()
{ return fa; }
void evalFeatFaT::set_fa(faLabel * faIn)
{ fa = faIn; }
std::list<tLabel *> * evalFeatFaT::get_tLabelList()
{ return a_tLabelList; }
void evalFeatFaT::set_tLabelList(std::list<tLabel *> * tLabelListIn)
{ a_tLabelList = tLabelListIn; }

/********************************************************************/

evalFeatFaFT::evalFeatFaFT(){}

evalFeatFaFT::evalFeatFaFT(
  faLabel * faIn,
  fLabel * fIn,
  tLabel * tIn)
{
  fa = faIn;
  f = fIn;
  t = tIn;
}

evalFeatFaFT::~evalFeatFaFT(){}

void evalFeatFaFT::printSelf()
{
  fa->printSelf();
  printf(",");
  f->printSelf();
  printf(",");
  t->printSelf();
}

faLabel * evalFeatFaFT::get_fa()
{ return fa; }
void evalFeatFaFT::set_fa(faLabel * faIn)
{ fa = faIn; }
fLabel * evalFeatFaFT::get_f()
{ return f; }
void evalFeatFaFT::set_f(fLabel * fIn)
{ f = fIn; }
tLabel * evalFeatFaFT::get_t()
{ return t; }
void evalFeatFaFT::set_t(tLabel * tIn)
{ t = tIn; }

/********************************************************************/

evalFeatFFaT::evalFeatFFaT(){}

evalFeatFFaT::evalFeatFFaT(
  fLabel * fIn,
  faLabel * faIn,
  tLabel * tIn)
{
  f = fIn;
  fa = faIn;
  t = tIn;
}

evalFeatFFaT::~evalFeatFFaT(){}

void evalFeatFFaT::printSelf()
{
  f->printSelf();
  printf(",");
  fa->printSelf();
  printf(",");
  t->printSelf();
}

fLabel * evalFeatFFaT::get_f()
{ return f; }
void evalFeatFFaT::set_f(fLabel * fIn)
{ f = fIn; }
faLabel * evalFeatFFaT::get_fa()
{ return fa; }
void evalFeatFFaT::set_fa(faLabel * faIn)
{ fa = faIn; }
tLabel * evalFeatFFaT::get_t()
{ return t; }
void evalFeatFFaT::set_t(tLabel * tIn)
{ t = tIn; }

/********************************************************************/

evalFeatFaFaT::evalFeatFaFaT(){}

evalFeatFaFaT::evalFeatFaFaT(
  faLabel * fa1In,
  faLabel * fa2In,
  tLabel * tIn)
{
  fa1 = fa1In;
  fa2 = fa2In;
  t = tIn;
}

evalFeatFaFaT::~evalFeatFaFaT(){}

void evalFeatFaFaT::printSelf()
{
  fa1->printSelf();
  printf(",");
  fa2->printSelf();
  printf(",");
  t->printSelf();
}

faLabel * evalFeatFaFaT::get_fa1()
{ return fa1; }
void evalFeatFaFaT::set_fa1(faLabel * fa1In)
{ fa1 = fa1In; }
faLabel * evalFeatFaFaT::get_fa2()
{ return fa2; }
void evalFeatFaFaT::set_fa2(faLabel * fa2In)
{ fa2 = fa2In; }
tLabel * evalFeatFaFaT::get_t()
{ return t; }
void evalFeatFaFaT::set_t(tLabel * tIn)
{ t = tIn; }

/********************************************************************/

evalDat::evalDat(){};

evalDat::~evalDat(){}

/********************************************************************/

evalDatDatFa::evalDatDatFa(){}

evalDatDatFa::evalDatDatFa(
  datLabel * datLabelIn,
  faLabel * faLabelIn,
  tLabel * tLabelIn)
{
  a_datLabel = datLabelIn;
  a_faLabel = faLabelIn;
  a_tLabel = tLabelIn;
}

evalDatDatFa::~evalDatDatFa(){}

void evalDatDatFa::printSelf()
{
  a_datLabel->printSelf();
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_tLabel->printSelf();
}

datLabel * evalDatDatFa::get_datLabel()
{ return a_datLabel; }
void evalDatDatFa::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
faLabel * evalDatDatFa::get_faLabel()
{ return a_faLabel; }
void evalDatDatFa::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
tLabel * evalDatDatFa::get_tLabel()
{ return a_tLabel; }
void evalDatDatFa::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }

/********************************************************************/

evalDatFaDat::evalDatFaDat(){}

evalDatFaDat::evalDatFaDat(
  faLabel * faLabelIn,
  datLabel * datLabelIn,
  tLabel * tLabelIn)
{
  a_faLabel = faLabelIn;
  a_datLabel = datLabelIn;
  a_tLabel = tLabelIn;
}

evalDatFaDat::~evalDatFaDat(){}

void evalDatFaDat::printSelf()
{
  a_faLabel->printSelf();
  printf(",");
  a_datLabel->printSelf();
  printf(",");
  a_tLabel->printSelf();
}

faLabel * evalDatFaDat::get_faLabel()
{ return a_faLabel; }
void evalDatFaDat::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
datLabel * evalDatFaDat::get_datLabel()
{ return a_datLabel; }
void evalDatFaDat::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
tLabel * evalDatFaDat::get_tLabel()
{ return a_tLabel; }
void evalDatFaDat::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }

/********************************************************************/

evalKeychar::evalKeychar(){};

evalKeychar::~evalKeychar(){}

/********************************************************************/

extensStm::extensStm(){}

extensStm::extensStm(
  sxLabel * sxLabelIn,
  extensMinor * extensMinorIn)
{
  a_sxLabel = sxLabelIn;
  a_extensMinor = extensMinorIn;
}

extensStm::~extensStm(){}

void extensStm::printSelf()
{
  a_sxLabel->printSelf();
  printf("=");
  printf("EXTENS");
  printf("/");
  a_extensMinor->printSelf();
  printf("%c%c", 13, 10);
}

sxLabel * extensStm::get_sxLabel()
{ return a_sxLabel; }
void extensStm::set_sxLabel(sxLabel * sxLabelIn)
{ a_sxLabel = sxLabelIn; }
extensMinor * extensStm::get_extensMinor()
{ return a_extensMinor; }
void extensStm::set_extensMinor(extensMinor * extensMinorIn)
{ a_extensMinor = extensMinorIn; }

/********************************************************************/

extensMinor::extensMinor(){};

extensMinor::~extensMinor(){}

/********************************************************************/

extensMinor_vector::extensMinor_vector(){}

extensMinor_vector::extensMinor_vector(
  vector * offsetIn)
{
  offset = offsetIn;
}

extensMinor_vector::~extensMinor_vector(){}

void extensMinor_vector::printSelf()
{
  offset->printSelf();
}

vector * extensMinor_vector::get_offset()
{ return offset; }
void extensMinor_vector::set_offset(vector * offsetIn)
{ offset = offsetIn; }

/********************************************************************/

extensMinor_VEC::extensMinor_VEC(){}

extensMinor_VEC::extensMinor_VEC(
  vector * perpIn,
  rentVal * lengthIn)
{
  perp = perpIn;
  length = lengthIn;
}

extensMinor_VEC::~extensMinor_VEC(){}

void extensMinor_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  perp->printSelf();
  printf(",");
  length->printSelf();
}

vector * extensMinor_VEC::get_perp()
{ return perp; }
void extensMinor_VEC::set_perp(vector * perpIn)
{ perp = perpIn; }
rentVal * extensMinor_VEC::get_length()
{ return length; }
void extensMinor_VEC::set_length(rentVal * lengthIn)
{ length = lengthIn; }

/********************************************************************/

extfilStm::extfilStm(){}

extfilStm::extfilStm(
  extfilMinor * extfilMinorIn)
{
  a_extfilMinor = extfilMinorIn;
}

extfilStm::~extfilStm(){}

void extfilStm::printSelf()
{
  printf("EXTFIL");
  printf("/");
  a_extfilMinor->printSelf();
  printf("%c%c", 13, 10);
}

extfilMinor * extfilStm::get_extfilMinor()
{ return a_extfilMinor; }
void extfilStm::set_extfilMinor(extfilMinor * extfilMinorIn)
{ a_extfilMinor = extfilMinorIn; }

/********************************************************************/

extfilMinor::extfilMinor(){};

extfilMinor::~extfilMinor(){}

/********************************************************************/

extfilDmis::extfilDmis(){}

extfilDmis::extfilDmis(
  stringVal * filenameIn)
{
  filename = filenameIn;
}

extfilDmis::~extfilDmis(){}

void extfilDmis::printSelf()
{
  printf("DMIS");
  printf(",");
  filename->printSelf();
}

stringVal * extfilDmis::get_filename()
{ return filename; }
void extfilDmis::set_filename(stringVal * filenameIn)
{ filename = filenameIn; }

/********************************************************************/

extfilDme::extfilDme(){}

extfilDme::extfilDme(
  stringVal * filenameIn)
{
  filename = filenameIn;
}

extfilDme::~extfilDme(){}

void extfilDme::printSelf()
{
  printf("DME");
  printf(",");
  filename->printSelf();
}

stringVal * extfilDme::get_filename()
{ return filename; }
void extfilDme::set_filename(stringVal * filenameIn)
{ filename = filenameIn; }

/********************************************************************/

featArc1Stm::featArc1Stm(){};

featArc1Stm::~featArc1Stm(){}

/********************************************************************/

featArc1Nom::featArc1Nom(){}

featArc1Nom::featArc1Nom(
  fLabel * fLabelIn,
  featMinorArc1 * featMinorArc1In)
{
  a_fLabel = fLabelIn;
  a_featMinorArc1 = featMinorArc1In;
}

featArc1Nom::~featArc1Nom(){}

void featArc1Nom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorArc1->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featArc1Nom::get_fLabel()
{ return a_fLabel; }
void featArc1Nom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorArc1 * featArc1Nom::get_featMinorArc1()
{ return a_featMinorArc1; }
void featArc1Nom::set_featMinorArc1(featMinorArc1 * featMinorArc1In)
{ a_featMinorArc1 = featMinorArc1In; }

/********************************************************************/

featArc1Act::featArc1Act(){}

featArc1Act::featArc1Act(
  faLabel * faLabelIn,
  featMinorArc1 * featMinorArc1In)
{
  a_faLabel = faLabelIn;
  a_featMinorArc1 = featMinorArc1In;
}

featArc1Act::~featArc1Act(){}

void featArc1Act::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorArc1->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featArc1Act::get_faLabel()
{ return a_faLabel; }
void featArc1Act::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorArc1 * featArc1Act::get_featMinorArc1()
{ return a_featMinorArc1; }
void featArc1Act::set_featMinorArc1(featMinorArc1 * featMinorArc1In)
{ a_featMinorArc1 = featMinorArc1In; }

/********************************************************************/

featArc2Stm::featArc2Stm(){};

featArc2Stm::~featArc2Stm(){}

/********************************************************************/

featArc2Nom::featArc2Nom(){}

featArc2Nom::featArc2Nom(
  fLabel * fLabelIn,
  featMinorArc2 * featMinorArc2In)
{
  a_fLabel = fLabelIn;
  a_featMinorArc2 = featMinorArc2In;
}

featArc2Nom::~featArc2Nom(){}

void featArc2Nom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorArc2->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featArc2Nom::get_fLabel()
{ return a_fLabel; }
void featArc2Nom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorArc2 * featArc2Nom::get_featMinorArc2()
{ return a_featMinorArc2; }
void featArc2Nom::set_featMinorArc2(featMinorArc2 * featMinorArc2In)
{ a_featMinorArc2 = featMinorArc2In; }

/********************************************************************/

featArc2Act::featArc2Act(){}

featArc2Act::featArc2Act(
  faLabel * faLabelIn,
  featMinorArc2 * featMinorArc2In)
{
  a_faLabel = faLabelIn;
  a_featMinorArc2 = featMinorArc2In;
}

featArc2Act::~featArc2Act(){}

void featArc2Act::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorArc2->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featArc2Act::get_faLabel()
{ return a_faLabel; }
void featArc2Act::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorArc2 * featArc2Act::get_featMinorArc2()
{ return a_featMinorArc2; }
void featArc2Act::set_featMinorArc2(featMinorArc2 * featMinorArc2In)
{ a_featMinorArc2 = featMinorArc2In; }

/********************************************************************/

featCircleStm::featCircleStm(){};

featCircleStm::~featCircleStm(){}

/********************************************************************/

featCircleNom::featCircleNom(){}

featCircleNom::featCircleNom(
  fLabel * fLabelIn,
  featMinorCircle * featMinorCircleIn)
{
  a_fLabel = fLabelIn;
  a_featMinorCircle = featMinorCircleIn;
}

featCircleNom::~featCircleNom(){}

void featCircleNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCircle->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featCircleNom::get_fLabel()
{ return a_fLabel; }
void featCircleNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorCircle * featCircleNom::get_featMinorCircle()
{ return a_featMinorCircle; }
void featCircleNom::set_featMinorCircle(featMinorCircle * featMinorCircleIn)
{ a_featMinorCircle = featMinorCircleIn; }

/********************************************************************/

featCircleAct::featCircleAct(){}

featCircleAct::featCircleAct(
  faLabel * faLabelIn,
  featMinorCircle * featMinorCircleIn)
{
  a_faLabel = faLabelIn;
  a_featMinorCircle = featMinorCircleIn;
}

featCircleAct::~featCircleAct(){}

void featCircleAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCircle->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featCircleAct::get_faLabel()
{ return a_faLabel; }
void featCircleAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorCircle * featCircleAct::get_featMinorCircle()
{ return a_featMinorCircle; }
void featCircleAct::set_featMinorCircle(featMinorCircle * featMinorCircleIn)
{ a_featMinorCircle = featMinorCircleIn; }

/********************************************************************/

featCompoundStm::featCompoundStm(){}

featCompoundStm::featCompoundStm(
  fLabel * fLabelIn,
  featMinorCompound * featMinorCompoundIn)
{
  a_fLabel = fLabelIn;
  a_featMinorCompound = featMinorCompoundIn;
}

featCompoundStm::~featCompoundStm(){}

void featCompoundStm::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCompound->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featCompoundStm::get_fLabel()
{ return a_fLabel; }
void featCompoundStm::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorCompound * featCompoundStm::get_featMinorCompound()
{ return a_featMinorCompound; }
void featCompoundStm::set_featMinorCompound(featMinorCompound * featMinorCompoundIn)
{ a_featMinorCompound = featMinorCompoundIn; }

/********************************************************************/

featConeStm::featConeStm(){};

featConeStm::~featConeStm(){}

/********************************************************************/

featConeNom::featConeNom(){}

featConeNom::featConeNom(
  fLabel * fLabelIn,
  featMinorCone * featMinorConeIn)
{
  a_fLabel = fLabelIn;
  a_featMinorCone = featMinorConeIn;
}

featConeNom::~featConeNom(){}

void featConeNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCone->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featConeNom::get_fLabel()
{ return a_fLabel; }
void featConeNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorCone * featConeNom::get_featMinorCone()
{ return a_featMinorCone; }
void featConeNom::set_featMinorCone(featMinorCone * featMinorConeIn)
{ a_featMinorCone = featMinorConeIn; }

/********************************************************************/

featConeAct::featConeAct(){}

featConeAct::featConeAct(
  faLabel * faLabelIn,
  featMinorCone * featMinorConeIn)
{
  a_faLabel = faLabelIn;
  a_featMinorCone = featMinorConeIn;
}

featConeAct::~featConeAct(){}

void featConeAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCone->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featConeAct::get_faLabel()
{ return a_faLabel; }
void featConeAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorCone * featConeAct::get_featMinorCone()
{ return a_featMinorCone; }
void featConeAct::set_featMinorCone(featMinorCone * featMinorConeIn)
{ a_featMinorCone = featMinorConeIn; }

/********************************************************************/

featConradsegStm::featConradsegStm(){};

featConradsegStm::~featConradsegStm(){}

/********************************************************************/

featConradsegNom::featConradsegNom(){}

featConradsegNom::featConradsegNom(
  fLabel * fLabelIn,
  featMinorConradseg * featMinorConradsegIn)
{
  a_fLabel = fLabelIn;
  a_featMinorConradseg = featMinorConradsegIn;
}

featConradsegNom::~featConradsegNom(){}

void featConradsegNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorConradseg->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featConradsegNom::get_fLabel()
{ return a_fLabel; }
void featConradsegNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorConradseg * featConradsegNom::get_featMinorConradseg()
{ return a_featMinorConradseg; }
void featConradsegNom::set_featMinorConradseg(featMinorConradseg * featMinorConradsegIn)
{ a_featMinorConradseg = featMinorConradsegIn; }

/********************************************************************/

featConradsegAct::featConradsegAct(){}

featConradsegAct::featConradsegAct(
  faLabel * faLabelIn,
  featMinorConradseg * featMinorConradsegIn)
{
  a_faLabel = faLabelIn;
  a_featMinorConradseg = featMinorConradsegIn;
}

featConradsegAct::~featConradsegAct(){}

void featConradsegAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorConradseg->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featConradsegAct::get_faLabel()
{ return a_faLabel; }
void featConradsegAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorConradseg * featConradsegAct::get_featMinorConradseg()
{ return a_featMinorConradseg; }
void featConradsegAct::set_featMinorConradseg(featMinorConradseg * featMinorConradsegIn)
{ a_featMinorConradseg = featMinorConradsegIn; }

/********************************************************************/

featCparlnStm::featCparlnStm(){};

featCparlnStm::~featCparlnStm(){}

/********************************************************************/

featCparlnNom::featCparlnNom(){}

featCparlnNom::featCparlnNom(
  fLabel * fLabelIn,
  featMinorCparln * featMinorCparlnIn)
{
  a_fLabel = fLabelIn;
  a_featMinorCparln = featMinorCparlnIn;
}

featCparlnNom::~featCparlnNom(){}

void featCparlnNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCparln->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featCparlnNom::get_fLabel()
{ return a_fLabel; }
void featCparlnNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorCparln * featCparlnNom::get_featMinorCparln()
{ return a_featMinorCparln; }
void featCparlnNom::set_featMinorCparln(featMinorCparln * featMinorCparlnIn)
{ a_featMinorCparln = featMinorCparlnIn; }

/********************************************************************/

featCparlnAct::featCparlnAct(){}

featCparlnAct::featCparlnAct(
  faLabel * faLabelIn,
  featMinorCparln * featMinorCparlnIn)
{
  a_faLabel = faLabelIn;
  a_featMinorCparln = featMinorCparlnIn;
}

featCparlnAct::~featCparlnAct(){}

void featCparlnAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCparln->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featCparlnAct::get_faLabel()
{ return a_faLabel; }
void featCparlnAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorCparln * featCparlnAct::get_featMinorCparln()
{ return a_featMinorCparln; }
void featCparlnAct::set_featMinorCparln(featMinorCparln * featMinorCparlnIn)
{ a_featMinorCparln = featMinorCparlnIn; }

/********************************************************************/

featCylndrStm::featCylndrStm(){};

featCylndrStm::~featCylndrStm(){}

/********************************************************************/

featCylndrNom::featCylndrNom(){}

featCylndrNom::featCylndrNom(
  fLabel * fLabelIn,
  featMinorCylndr * featMinorCylndrIn)
{
  a_fLabel = fLabelIn;
  a_featMinorCylndr = featMinorCylndrIn;
}

featCylndrNom::~featCylndrNom(){}

void featCylndrNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCylndr->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featCylndrNom::get_fLabel()
{ return a_fLabel; }
void featCylndrNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorCylndr * featCylndrNom::get_featMinorCylndr()
{ return a_featMinorCylndr; }
void featCylndrNom::set_featMinorCylndr(featMinorCylndr * featMinorCylndrIn)
{ a_featMinorCylndr = featMinorCylndrIn; }

/********************************************************************/

featCylndrAct::featCylndrAct(){}

featCylndrAct::featCylndrAct(
  faLabel * faLabelIn,
  featMinorCylndr * featMinorCylndrIn)
{
  a_faLabel = faLabelIn;
  a_featMinorCylndr = featMinorCylndrIn;
}

featCylndrAct::~featCylndrAct(){}

void featCylndrAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCylndr->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featCylndrAct::get_faLabel()
{ return a_faLabel; }
void featCylndrAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorCylndr * featCylndrAct::get_featMinorCylndr()
{ return a_featMinorCylndr; }
void featCylndrAct::set_featMinorCylndr(featMinorCylndr * featMinorCylndrIn)
{ a_featMinorCylndr = featMinorCylndrIn; }

/********************************************************************/

featCylradsegStm::featCylradsegStm(){};

featCylradsegStm::~featCylradsegStm(){}

/********************************************************************/

featCylradsegNom::featCylradsegNom(){}

featCylradsegNom::featCylradsegNom(
  fLabel * fLabelIn,
  featMinorCylradseg * featMinorCylradsegIn)
{
  a_fLabel = fLabelIn;
  a_featMinorCylradseg = featMinorCylradsegIn;
}

featCylradsegNom::~featCylradsegNom(){}

void featCylradsegNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCylradseg->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featCylradsegNom::get_fLabel()
{ return a_fLabel; }
void featCylradsegNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorCylradseg * featCylradsegNom::get_featMinorCylradseg()
{ return a_featMinorCylradseg; }
void featCylradsegNom::set_featMinorCylradseg(featMinorCylradseg * featMinorCylradsegIn)
{ a_featMinorCylradseg = featMinorCylradsegIn; }

/********************************************************************/

featCylradsegAct::featCylradsegAct(){}

featCylradsegAct::featCylradsegAct(
  faLabel * faLabelIn,
  featMinorCylradseg * featMinorCylradsegIn)
{
  a_faLabel = faLabelIn;
  a_featMinorCylradseg = featMinorCylradsegIn;
}

featCylradsegAct::~featCylradsegAct(){}

void featCylradsegAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorCylradseg->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featCylradsegAct::get_faLabel()
{ return a_faLabel; }
void featCylradsegAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorCylradseg * featCylradsegAct::get_featMinorCylradseg()
{ return a_featMinorCylradseg; }
void featCylradsegAct::set_featMinorCylradseg(featMinorCylradseg * featMinorCylradsegIn)
{ a_featMinorCylradseg = featMinorCylradsegIn; }

/********************************************************************/

featEdgeptStm::featEdgeptStm(){};

featEdgeptStm::~featEdgeptStm(){}

/********************************************************************/

featEdgeptNom::featEdgeptNom(){}

featEdgeptNom::featEdgeptNom(
  fLabel * fLabelIn,
  featMinorEdgept * featMinorEdgeptIn)
{
  a_fLabel = fLabelIn;
  a_featMinorEdgept = featMinorEdgeptIn;
}

featEdgeptNom::~featEdgeptNom(){}

void featEdgeptNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorEdgept->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featEdgeptNom::get_fLabel()
{ return a_fLabel; }
void featEdgeptNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorEdgept * featEdgeptNom::get_featMinorEdgept()
{ return a_featMinorEdgept; }
void featEdgeptNom::set_featMinorEdgept(featMinorEdgept * featMinorEdgeptIn)
{ a_featMinorEdgept = featMinorEdgeptIn; }

/********************************************************************/

featEdgeptAct::featEdgeptAct(){}

featEdgeptAct::featEdgeptAct(
  faLabel * faLabelIn,
  featMinorEdgept * featMinorEdgeptIn)
{
  a_faLabel = faLabelIn;
  a_featMinorEdgept = featMinorEdgeptIn;
}

featEdgeptAct::~featEdgeptAct(){}

void featEdgeptAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorEdgept->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featEdgeptAct::get_faLabel()
{ return a_faLabel; }
void featEdgeptAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorEdgept * featEdgeptAct::get_featMinorEdgept()
{ return a_featMinorEdgept; }
void featEdgeptAct::set_featMinorEdgept(featMinorEdgept * featMinorEdgeptIn)
{ a_featMinorEdgept = featMinorEdgeptIn; }

/********************************************************************/

featEllipsStm::featEllipsStm(){};

featEllipsStm::~featEllipsStm(){}

/********************************************************************/

featEllipsNom::featEllipsNom(){}

featEllipsNom::featEllipsNom(
  fLabel * fLabelIn,
  featMinorEllips * featMinorEllipsIn)
{
  a_fLabel = fLabelIn;
  a_featMinorEllips = featMinorEllipsIn;
}

featEllipsNom::~featEllipsNom(){}

void featEllipsNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorEllips->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featEllipsNom::get_fLabel()
{ return a_fLabel; }
void featEllipsNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorEllips * featEllipsNom::get_featMinorEllips()
{ return a_featMinorEllips; }
void featEllipsNom::set_featMinorEllips(featMinorEllips * featMinorEllipsIn)
{ a_featMinorEllips = featMinorEllipsIn; }

/********************************************************************/

featEllipsAct::featEllipsAct(){}

featEllipsAct::featEllipsAct(
  faLabel * faLabelIn,
  featMinorEllips * featMinorEllipsIn)
{
  a_faLabel = faLabelIn;
  a_featMinorEllips = featMinorEllipsIn;
}

featEllipsAct::~featEllipsAct(){}

void featEllipsAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorEllips->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featEllipsAct::get_faLabel()
{ return a_faLabel; }
void featEllipsAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorEllips * featEllipsAct::get_featMinorEllips()
{ return a_featMinorEllips; }
void featEllipsAct::set_featMinorEllips(featMinorEllips * featMinorEllipsIn)
{ a_featMinorEllips = featMinorEllipsIn; }

/********************************************************************/

featElongcylStm::featElongcylStm(){};

featElongcylStm::~featElongcylStm(){}

/********************************************************************/

featElongcylNom::featElongcylNom(){}

featElongcylNom::featElongcylNom(
  fLabel * fLabelIn,
  featMinorElongcyl * featMinorElongcylIn)
{
  a_fLabel = fLabelIn;
  a_featMinorElongcyl = featMinorElongcylIn;
}

featElongcylNom::~featElongcylNom(){}

void featElongcylNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorElongcyl->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featElongcylNom::get_fLabel()
{ return a_fLabel; }
void featElongcylNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorElongcyl * featElongcylNom::get_featMinorElongcyl()
{ return a_featMinorElongcyl; }
void featElongcylNom::set_featMinorElongcyl(featMinorElongcyl * featMinorElongcylIn)
{ a_featMinorElongcyl = featMinorElongcylIn; }

/********************************************************************/

featElongcylAct::featElongcylAct(){}

featElongcylAct::featElongcylAct(
  faLabel * faLabelIn,
  featMinorElongcyl * featMinorElongcylIn)
{
  a_faLabel = faLabelIn;
  a_featMinorElongcyl = featMinorElongcylIn;
}

featElongcylAct::~featElongcylAct(){}

void featElongcylAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorElongcyl->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featElongcylAct::get_faLabel()
{ return a_faLabel; }
void featElongcylAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorElongcyl * featElongcylAct::get_featMinorElongcyl()
{ return a_featMinorElongcyl; }
void featElongcylAct::set_featMinorElongcyl(featMinorElongcyl * featMinorElongcylIn)
{ a_featMinorElongcyl = featMinorElongcylIn; }

/********************************************************************/

featGcurveStm::featGcurveStm(){}

featGcurveStm::featGcurveStm(
  fLabel * fLabelIn,
  featMinorGcurve * featMinorGcurveIn)
{
  a_fLabel = fLabelIn;
  a_featMinorGcurve = featMinorGcurveIn;
}

featGcurveStm::~featGcurveStm(){}

void featGcurveStm::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorGcurve->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featGcurveStm::get_fLabel()
{ return a_fLabel; }
void featGcurveStm::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorGcurve * featGcurveStm::get_featMinorGcurve()
{ return a_featMinorGcurve; }
void featGcurveStm::set_featMinorGcurve(featMinorGcurve * featMinorGcurveIn)
{ a_featMinorGcurve = featMinorGcurveIn; }

/********************************************************************/

featGeomStm::featGeomStm(){}

featGeomStm::featGeomStm(
  fLabel * fLabelIn,
  featMinorGeom * featMinorGeomIn)
{
  a_fLabel = fLabelIn;
  a_featMinorGeom = featMinorGeomIn;
}

featGeomStm::~featGeomStm(){}

void featGeomStm::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorGeom->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featGeomStm::get_fLabel()
{ return a_fLabel; }
void featGeomStm::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorGeom * featGeomStm::get_featMinorGeom()
{ return a_featMinorGeom; }
void featGeomStm::set_featMinorGeom(featMinorGeom * featMinorGeomIn)
{ a_featMinorGeom = featMinorGeomIn; }

/********************************************************************/

featGsurfStm::featGsurfStm(){}

featGsurfStm::featGsurfStm(
  fLabel * fLabelIn,
  featMinorGsurf * featMinorGsurfIn)
{
  a_fLabel = fLabelIn;
  a_featMinorGsurf = featMinorGsurfIn;
}

featGsurfStm::~featGsurfStm(){}

void featGsurfStm::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorGsurf->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featGsurfStm::get_fLabel()
{ return a_fLabel; }
void featGsurfStm::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorGsurf * featGsurfStm::get_featMinorGsurf()
{ return a_featMinorGsurf; }
void featGsurfStm::set_featMinorGsurf(featMinorGsurf * featMinorGsurfIn)
{ a_featMinorGsurf = featMinorGsurfIn; }

/********************************************************************/

featLineStm::featLineStm(){};

featLineStm::~featLineStm(){}

/********************************************************************/

featLineNom::featLineNom(){}

featLineNom::featLineNom(
  fLabel * fLabelIn,
  featMinorLine * featMinorLineIn)
{
  a_fLabel = fLabelIn;
  a_featMinorLine = featMinorLineIn;
}

featLineNom::~featLineNom(){}

void featLineNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorLine->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featLineNom::get_fLabel()
{ return a_fLabel; }
void featLineNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorLine * featLineNom::get_featMinorLine()
{ return a_featMinorLine; }
void featLineNom::set_featMinorLine(featMinorLine * featMinorLineIn)
{ a_featMinorLine = featMinorLineIn; }

/********************************************************************/

featLineAct::featLineAct(){}

featLineAct::featLineAct(
  faLabel * faLabelIn,
  featMinorLine * featMinorLineIn)
{
  a_faLabel = faLabelIn;
  a_featMinorLine = featMinorLineIn;
}

featLineAct::~featLineAct(){}

void featLineAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorLine->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featLineAct::get_faLabel()
{ return a_faLabel; }
void featLineAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorLine * featLineAct::get_featMinorLine()
{ return a_featMinorLine; }
void featLineAct::set_featMinorLine(featMinorLine * featMinorLineIn)
{ a_featMinorLine = featMinorLineIn; }

/********************************************************************/

featObjectStm::featObjectStm(){};

featObjectStm::~featObjectStm(){}

/********************************************************************/

featObjectNom::featObjectNom(){}

featObjectNom::featObjectNom(
  fLabel * fLabelIn,
  featMinorObject * featMinorObjectIn)
{
  a_fLabel = fLabelIn;
  a_featMinorObject = featMinorObjectIn;
}

featObjectNom::~featObjectNom(){}

void featObjectNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorObject->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featObjectNom::get_fLabel()
{ return a_fLabel; }
void featObjectNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorObject * featObjectNom::get_featMinorObject()
{ return a_featMinorObject; }
void featObjectNom::set_featMinorObject(featMinorObject * featMinorObjectIn)
{ a_featMinorObject = featMinorObjectIn; }

/********************************************************************/

featObjectAct::featObjectAct(){}

featObjectAct::featObjectAct(
  faLabel * faLabelIn,
  featMinorObject * featMinorObjectIn)
{
  a_faLabel = faLabelIn;
  a_featMinorObject = featMinorObjectIn;
}

featObjectAct::~featObjectAct(){}

void featObjectAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorObject->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featObjectAct::get_faLabel()
{ return a_faLabel; }
void featObjectAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorObject * featObjectAct::get_featMinorObject()
{ return a_featMinorObject; }
void featObjectAct::set_featMinorObject(featMinorObject * featMinorObjectIn)
{ a_featMinorObject = featMinorObjectIn; }

/********************************************************************/

featParplnStm::featParplnStm(){};

featParplnStm::~featParplnStm(){}

/********************************************************************/

featParplnNom::featParplnNom(){}

featParplnNom::featParplnNom(
  fLabel * fLabelIn,
  featMinorParpln * featMinorParplnIn)
{
  a_fLabel = fLabelIn;
  a_featMinorParpln = featMinorParplnIn;
}

featParplnNom::~featParplnNom(){}

void featParplnNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorParpln->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featParplnNom::get_fLabel()
{ return a_fLabel; }
void featParplnNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorParpln * featParplnNom::get_featMinorParpln()
{ return a_featMinorParpln; }
void featParplnNom::set_featMinorParpln(featMinorParpln * featMinorParplnIn)
{ a_featMinorParpln = featMinorParplnIn; }

/********************************************************************/

featParplnAct::featParplnAct(){}

featParplnAct::featParplnAct(
  faLabel * faLabelIn,
  featMinorParpln * featMinorParplnIn)
{
  a_faLabel = faLabelIn;
  a_featMinorParpln = featMinorParplnIn;
}

featParplnAct::~featParplnAct(){}

void featParplnAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorParpln->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featParplnAct::get_faLabel()
{ return a_faLabel; }
void featParplnAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorParpln * featParplnAct::get_featMinorParpln()
{ return a_featMinorParpln; }
void featParplnAct::set_featMinorParpln(featMinorParpln * featMinorParplnIn)
{ a_featMinorParpln = featMinorParplnIn; }

/********************************************************************/

featPaternStm::featPaternStm(){}

featPaternStm::featPaternStm(
  fLabel * fLabelIn,
  featMinorPatern * featMinorPaternIn)
{
  a_fLabel = fLabelIn;
  a_featMinorPatern = featMinorPaternIn;
}

featPaternStm::~featPaternStm(){}

void featPaternStm::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorPatern->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featPaternStm::get_fLabel()
{ return a_fLabel; }
void featPaternStm::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorPatern * featPaternStm::get_featMinorPatern()
{ return a_featMinorPatern; }
void featPaternStm::set_featMinorPatern(featMinorPatern * featMinorPaternIn)
{ a_featMinorPatern = featMinorPaternIn; }

/********************************************************************/

featPlaneStm::featPlaneStm(){};

featPlaneStm::~featPlaneStm(){}

/********************************************************************/

featPlaneNom::featPlaneNom(){}

featPlaneNom::featPlaneNom(
  fLabel * fLabelIn,
  featMinorPlane * featMinorPlaneIn)
{
  a_fLabel = fLabelIn;
  a_featMinorPlane = featMinorPlaneIn;
}

featPlaneNom::~featPlaneNom(){}

void featPlaneNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorPlane->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featPlaneNom::get_fLabel()
{ return a_fLabel; }
void featPlaneNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorPlane * featPlaneNom::get_featMinorPlane()
{ return a_featMinorPlane; }
void featPlaneNom::set_featMinorPlane(featMinorPlane * featMinorPlaneIn)
{ a_featMinorPlane = featMinorPlaneIn; }

/********************************************************************/

featPlaneAct::featPlaneAct(){}

featPlaneAct::featPlaneAct(
  faLabel * faLabelIn,
  featMinorPlane * featMinorPlaneIn)
{
  a_faLabel = faLabelIn;
  a_featMinorPlane = featMinorPlaneIn;
}

featPlaneAct::~featPlaneAct(){}

void featPlaneAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorPlane->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featPlaneAct::get_faLabel()
{ return a_faLabel; }
void featPlaneAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorPlane * featPlaneAct::get_featMinorPlane()
{ return a_featMinorPlane; }
void featPlaneAct::set_featMinorPlane(featMinorPlane * featMinorPlaneIn)
{ a_featMinorPlane = featMinorPlaneIn; }

/********************************************************************/

featPointStm::featPointStm(){};

featPointStm::~featPointStm(){}

/********************************************************************/

featPointNom::featPointNom(){}

featPointNom::featPointNom(
  fLabel * fLabelIn,
  featMinorPoint * featMinorPointIn)
{
  a_fLabel = fLabelIn;
  a_featMinorPoint = featMinorPointIn;
}

featPointNom::~featPointNom(){}

void featPointNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorPoint->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featPointNom::get_fLabel()
{ return a_fLabel; }
void featPointNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorPoint * featPointNom::get_featMinorPoint()
{ return a_featMinorPoint; }
void featPointNom::set_featMinorPoint(featMinorPoint * featMinorPointIn)
{ a_featMinorPoint = featMinorPointIn; }

/********************************************************************/

featPointAct::featPointAct(){}

featPointAct::featPointAct(
  faLabel * faLabelIn,
  featMinorPoint * featMinorPointIn)
{
  a_faLabel = faLabelIn;
  a_featMinorPoint = featMinorPointIn;
}

featPointAct::~featPointAct(){}

void featPointAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorPoint->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featPointAct::get_faLabel()
{ return a_faLabel; }
void featPointAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorPoint * featPointAct::get_featMinorPoint()
{ return a_featMinorPoint; }
void featPointAct::set_featMinorPoint(featMinorPoint * featMinorPointIn)
{ a_featMinorPoint = featMinorPointIn; }

/********************************************************************/

featRctnglStm::featRctnglStm(){};

featRctnglStm::~featRctnglStm(){}

/********************************************************************/

featRctnglNom::featRctnglNom(){}

featRctnglNom::featRctnglNom(
  fLabel * fLabelIn,
  featMinorRctngl * featMinorRctnglIn)
{
  a_fLabel = fLabelIn;
  a_featMinorRctngl = featMinorRctnglIn;
}

featRctnglNom::~featRctnglNom(){}

void featRctnglNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorRctngl->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featRctnglNom::get_fLabel()
{ return a_fLabel; }
void featRctnglNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorRctngl * featRctnglNom::get_featMinorRctngl()
{ return a_featMinorRctngl; }
void featRctnglNom::set_featMinorRctngl(featMinorRctngl * featMinorRctnglIn)
{ a_featMinorRctngl = featMinorRctnglIn; }

/********************************************************************/

featRctnglAct::featRctnglAct(){}

featRctnglAct::featRctnglAct(
  faLabel * faLabelIn,
  featMinorRctngl * featMinorRctnglIn)
{
  a_faLabel = faLabelIn;
  a_featMinorRctngl = featMinorRctnglIn;
}

featRctnglAct::~featRctnglAct(){}

void featRctnglAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorRctngl->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featRctnglAct::get_faLabel()
{ return a_faLabel; }
void featRctnglAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorRctngl * featRctnglAct::get_featMinorRctngl()
{ return a_featMinorRctngl; }
void featRctnglAct::set_featMinorRctngl(featMinorRctngl * featMinorRctnglIn)
{ a_featMinorRctngl = featMinorRctnglIn; }

/********************************************************************/

featRevsurfStm::featRevsurfStm(){};

featRevsurfStm::~featRevsurfStm(){}

/********************************************************************/

featRevsurfNom::featRevsurfNom(){}

featRevsurfNom::featRevsurfNom(
  fLabel * fLabelIn,
  featMinorRevsurf * featMinorRevsurfIn)
{
  a_fLabel = fLabelIn;
  a_featMinorRevsurf = featMinorRevsurfIn;
}

featRevsurfNom::~featRevsurfNom(){}

void featRevsurfNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorRevsurf->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featRevsurfNom::get_fLabel()
{ return a_fLabel; }
void featRevsurfNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorRevsurf * featRevsurfNom::get_featMinorRevsurf()
{ return a_featMinorRevsurf; }
void featRevsurfNom::set_featMinorRevsurf(featMinorRevsurf * featMinorRevsurfIn)
{ a_featMinorRevsurf = featMinorRevsurfIn; }

/********************************************************************/

featRevsurfAct::featRevsurfAct(){}

featRevsurfAct::featRevsurfAct(
  faLabel * faLabelIn,
  featMinorRevsurf * featMinorRevsurfIn)
{
  a_faLabel = faLabelIn;
  a_featMinorRevsurf = featMinorRevsurfIn;
}

featRevsurfAct::~featRevsurfAct(){}

void featRevsurfAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorRevsurf->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featRevsurfAct::get_faLabel()
{ return a_faLabel; }
void featRevsurfAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorRevsurf * featRevsurfAct::get_featMinorRevsurf()
{ return a_featMinorRevsurf; }
void featRevsurfAct::set_featMinorRevsurf(featMinorRevsurf * featMinorRevsurfIn)
{ a_featMinorRevsurf = featMinorRevsurfIn; }

/********************************************************************/

featSphereStm::featSphereStm(){};

featSphereStm::~featSphereStm(){}

/********************************************************************/

featSphereNom::featSphereNom(){}

featSphereNom::featSphereNom(
  fLabel * fLabelIn,
  featMinorSphere * featMinorSphereIn)
{
  a_fLabel = fLabelIn;
  a_featMinorSphere = featMinorSphereIn;
}

featSphereNom::~featSphereNom(){}

void featSphereNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorSphere->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featSphereNom::get_fLabel()
{ return a_fLabel; }
void featSphereNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorSphere * featSphereNom::get_featMinorSphere()
{ return a_featMinorSphere; }
void featSphereNom::set_featMinorSphere(featMinorSphere * featMinorSphereIn)
{ a_featMinorSphere = featMinorSphereIn; }

/********************************************************************/

featSphereAct::featSphereAct(){}

featSphereAct::featSphereAct(
  faLabel * faLabelIn,
  featMinorSphere * featMinorSphereIn)
{
  a_faLabel = faLabelIn;
  a_featMinorSphere = featMinorSphereIn;
}

featSphereAct::~featSphereAct(){}

void featSphereAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorSphere->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featSphereAct::get_faLabel()
{ return a_faLabel; }
void featSphereAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorSphere * featSphereAct::get_featMinorSphere()
{ return a_featMinorSphere; }
void featSphereAct::set_featMinorSphere(featMinorSphere * featMinorSphereIn)
{ a_featMinorSphere = featMinorSphereIn; }

/********************************************************************/

featSphradsegStm::featSphradsegStm(){};

featSphradsegStm::~featSphradsegStm(){}

/********************************************************************/

featSphradsegNom::featSphradsegNom(){}

featSphradsegNom::featSphradsegNom(
  fLabel * fLabelIn,
  featMinorSphradseg * featMinorSphradsegIn)
{
  a_fLabel = fLabelIn;
  a_featMinorSphradseg = featMinorSphradsegIn;
}

featSphradsegNom::~featSphradsegNom(){}

void featSphradsegNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorSphradseg->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featSphradsegNom::get_fLabel()
{ return a_fLabel; }
void featSphradsegNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorSphradseg * featSphradsegNom::get_featMinorSphradseg()
{ return a_featMinorSphradseg; }
void featSphradsegNom::set_featMinorSphradseg(featMinorSphradseg * featMinorSphradsegIn)
{ a_featMinorSphradseg = featMinorSphradsegIn; }

/********************************************************************/

featSphradsegAct::featSphradsegAct(){}

featSphradsegAct::featSphradsegAct(
  faLabel * faLabelIn,
  featMinorSphradseg * featMinorSphradsegIn)
{
  a_faLabel = faLabelIn;
  a_featMinorSphradseg = featMinorSphradsegIn;
}

featSphradsegAct::~featSphradsegAct(){}

void featSphradsegAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorSphradseg->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featSphradsegAct::get_faLabel()
{ return a_faLabel; }
void featSphradsegAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorSphradseg * featSphradsegAct::get_featMinorSphradseg()
{ return a_featMinorSphradseg; }
void featSphradsegAct::set_featMinorSphradseg(featMinorSphradseg * featMinorSphradsegIn)
{ a_featMinorSphradseg = featMinorSphradsegIn; }

/********************************************************************/

featSymplnStm::featSymplnStm(){};

featSymplnStm::~featSymplnStm(){}

/********************************************************************/

featSymplnNom::featSymplnNom(){}

featSymplnNom::featSymplnNom(
  fLabel * fLabelIn,
  featMinorSympln * featMinorSymplnIn)
{
  a_fLabel = fLabelIn;
  a_featMinorSympln = featMinorSymplnIn;
}

featSymplnNom::~featSymplnNom(){}

void featSymplnNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorSympln->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featSymplnNom::get_fLabel()
{ return a_fLabel; }
void featSymplnNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorSympln * featSymplnNom::get_featMinorSympln()
{ return a_featMinorSympln; }
void featSymplnNom::set_featMinorSympln(featMinorSympln * featMinorSymplnIn)
{ a_featMinorSympln = featMinorSymplnIn; }

/********************************************************************/

featSymplnAct::featSymplnAct(){}

featSymplnAct::featSymplnAct(
  faLabel * faLabelIn,
  featMinorSympln * featMinorSymplnIn)
{
  a_faLabel = faLabelIn;
  a_featMinorSympln = featMinorSymplnIn;
}

featSymplnAct::~featSymplnAct(){}

void featSymplnAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorSympln->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featSymplnAct::get_faLabel()
{ return a_faLabel; }
void featSymplnAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorSympln * featSymplnAct::get_featMinorSympln()
{ return a_featMinorSympln; }
void featSymplnAct::set_featMinorSympln(featMinorSympln * featMinorSymplnIn)
{ a_featMinorSympln = featMinorSymplnIn; }

/********************************************************************/

featTorradsegStm::featTorradsegStm(){};

featTorradsegStm::~featTorradsegStm(){}

/********************************************************************/

featTorradsegNom::featTorradsegNom(){}

featTorradsegNom::featTorradsegNom(
  fLabel * fLabelIn,
  featMinorTorradseg * featMinorTorradsegIn)
{
  a_fLabel = fLabelIn;
  a_featMinorTorradseg = featMinorTorradsegIn;
}

featTorradsegNom::~featTorradsegNom(){}

void featTorradsegNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorTorradseg->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featTorradsegNom::get_fLabel()
{ return a_fLabel; }
void featTorradsegNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorTorradseg * featTorradsegNom::get_featMinorTorradseg()
{ return a_featMinorTorradseg; }
void featTorradsegNom::set_featMinorTorradseg(featMinorTorradseg * featMinorTorradsegIn)
{ a_featMinorTorradseg = featMinorTorradsegIn; }

/********************************************************************/

featTorradsegAct::featTorradsegAct(){}

featTorradsegAct::featTorradsegAct(
  faLabel * faLabelIn,
  featMinorTorradseg * featMinorTorradsegIn)
{
  a_faLabel = faLabelIn;
  a_featMinorTorradseg = featMinorTorradsegIn;
}

featTorradsegAct::~featTorradsegAct(){}

void featTorradsegAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorTorradseg->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featTorradsegAct::get_faLabel()
{ return a_faLabel; }
void featTorradsegAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorTorradseg * featTorradsegAct::get_featMinorTorradseg()
{ return a_featMinorTorradseg; }
void featTorradsegAct::set_featMinorTorradseg(featMinorTorradseg * featMinorTorradsegIn)
{ a_featMinorTorradseg = featMinorTorradsegIn; }

/********************************************************************/

featTorusStm::featTorusStm(){};

featTorusStm::~featTorusStm(){}

/********************************************************************/

featTorusNom::featTorusNom(){}

featTorusNom::featTorusNom(
  fLabel * fLabelIn,
  featMinorTorus * featMinorTorusIn)
{
  a_fLabel = fLabelIn;
  a_featMinorTorus = featMinorTorusIn;
}

featTorusNom::~featTorusNom(){}

void featTorusNom::printSelf()
{
  a_fLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorTorus->printSelf();
  printf("%c%c", 13, 10);
}

fLabel * featTorusNom::get_fLabel()
{ return a_fLabel; }
void featTorusNom::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
featMinorTorus * featTorusNom::get_featMinorTorus()
{ return a_featMinorTorus; }
void featTorusNom::set_featMinorTorus(featMinorTorus * featMinorTorusIn)
{ a_featMinorTorus = featMinorTorusIn; }

/********************************************************************/

featTorusAct::featTorusAct(){}

featTorusAct::featTorusAct(
  faLabel * faLabelIn,
  featMinorTorus * featMinorTorusIn)
{
  a_faLabel = faLabelIn;
  a_featMinorTorus = featMinorTorusIn;
}

featTorusAct::~featTorusAct(){}

void featTorusAct::printSelf()
{
  a_faLabel->printSelf();
  printf("=");
  printf("FEAT");
  printf("/");
  a_featMinorTorus->printSelf();
  printf("%c%c", 13, 10);
}

faLabel * featTorusAct::get_faLabel()
{ return a_faLabel; }
void featTorusAct::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
featMinorTorus * featTorusAct::get_featMinorTorus()
{ return a_featMinorTorus; }
void featTorusAct::set_featMinorTorus(featMinorTorus * featMinorTorusIn)
{ a_featMinorTorus = featMinorTorusIn; }

/********************************************************************/

featMinorArc1::featMinorArc1(){}

featMinorArc1::featMinorArc1(
  matDir * matDirIn,
  typePoint * typePointIn,
  vector * planeVecIn,
  rentVal * radiusIn,
  angle * startAngleIn,
  angle * includAngleIn,
  vector * startVecIn)
{
  a_matDir = matDirIn;
  a_typePoint = typePointIn;
  planeVec = planeVecIn;
  radius = radiusIn;
  startAngle = startAngleIn;
  includAngle = includAngleIn;
  startVec = startVecIn;
}

featMinorArc1::~featMinorArc1(){}

void featMinorArc1::printSelf()
{
  printf("ARC");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  planeVec->printSelf();
  printf(",");
  radius->printSelf();
  printf(",");
  startAngle->printSelf();
  printf(",");
  includAngle->printSelf();
  if (startVec)
    {
      printf(",");
      startVec->printSelf();
    }
}

matDir * featMinorArc1::get_matDir()
{ return a_matDir; }
void featMinorArc1::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorArc1::get_typePoint()
{ return a_typePoint; }
void featMinorArc1::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featMinorArc1::get_planeVec()
{ return planeVec; }
void featMinorArc1::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }
rentVal * featMinorArc1::get_radius()
{ return radius; }
void featMinorArc1::set_radius(rentVal * radiusIn)
{ radius = radiusIn; }
angle * featMinorArc1::get_startAngle()
{ return startAngle; }
void featMinorArc1::set_startAngle(angle * startAngleIn)
{ startAngle = startAngleIn; }
angle * featMinorArc1::get_includAngle()
{ return includAngle; }
void featMinorArc1::set_includAngle(angle * includAngleIn)
{ includAngle = includAngleIn; }
vector * featMinorArc1::get_startVec()
{ return startVec; }
void featMinorArc1::set_startVec(vector * startVecIn)
{ startVec = startVecIn; }

/********************************************************************/

featMinorArc2::featMinorArc2(){}

featMinorArc2::featMinorArc2(
  matDir * matDirIn,
  impCartPoint * end1In,
  impCartPoint * end2In,
  impCartPoint * midPtIn,
  impCartPoint * centerIn)
{
  a_matDir = matDirIn;
  end1 = end1In;
  end2 = end2In;
  midPt = midPtIn;
  center = centerIn;
}

featMinorArc2::~featMinorArc2(){}

void featMinorArc2::printSelf()
{
  printf("ARC");
  printf(",");
  printf("4POINT");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  end1->printSelf();
  printf(",");
  end2->printSelf();
  printf(",");
  midPt->printSelf();
  printf(",");
  center->printSelf();
}

matDir * featMinorArc2::get_matDir()
{ return a_matDir; }
void featMinorArc2::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
impCartPoint * featMinorArc2::get_end1()
{ return end1; }
void featMinorArc2::set_end1(impCartPoint * end1In)
{ end1 = end1In; }
impCartPoint * featMinorArc2::get_end2()
{ return end2; }
void featMinorArc2::set_end2(impCartPoint * end2In)
{ end2 = end2In; }
impCartPoint * featMinorArc2::get_midPt()
{ return midPt; }
void featMinorArc2::set_midPt(impCartPoint * midPtIn)
{ midPt = midPtIn; }
impCartPoint * featMinorArc2::get_center()
{ return center; }
void featMinorArc2::set_center(impCartPoint * centerIn)
{ center = centerIn; }

/********************************************************************/

featMinorCircle::featMinorCircle(){}

featMinorCircle::featMinorCircle(
  matDir * matDirIn,
  typePoint * centerIn,
  vector * planeVecIn,
  rentVal * diamIn)
{
  a_matDir = matDirIn;
  center = centerIn;
  planeVec = planeVecIn;
  diam = diamIn;
}

featMinorCircle::~featMinorCircle(){}

void featMinorCircle::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  center->printSelf();
  printf(",");
  planeVec->printSelf();
  printf(",");
  diam->printSelf();
}

matDir * featMinorCircle::get_matDir()
{ return a_matDir; }
void featMinorCircle::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorCircle::get_center()
{ return center; }
void featMinorCircle::set_center(typePoint * centerIn)
{ center = centerIn; }
vector * featMinorCircle::get_planeVec()
{ return planeVec; }
void featMinorCircle::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }
rentVal * featMinorCircle::get_diam()
{ return diam; }
void featMinorCircle::set_diam(rentVal * diamIn)
{ diam = diamIn; }

/********************************************************************/

featMinorCompound::featMinorCompound(){};

featMinorCompound::~featMinorCompound(){}

/********************************************************************/

featCompoundAxial::featCompoundAxial(){}

featCompoundAxial::featCompoundAxial(
  typePoint * typePointIn,
  vector * dirIn,
  fLabel * fLabelIn,
  std::list<fLabel *> * featureNominalListIn)
{
  a_typePoint = typePointIn;
  dir = dirIn;
  a_fLabel = fLabelIn;
  a_featureNominalList = featureNominalListIn;
}

featCompoundAxial::~featCompoundAxial(){}

void featCompoundAxial::printSelf()
{
  printf("COMPOUND");
  printf(",");
  printf("AXIAL");
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  dir->printSelf();
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  if (a_featureNominalList->begin() == a_featureNominalList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<fLabel *>::iterator iter;
      for (iter = a_featureNominalList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureNominalList->end())
            break;
          printf(",");
        }
    }
}

typePoint * featCompoundAxial::get_typePoint()
{ return a_typePoint; }
void featCompoundAxial::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featCompoundAxial::get_dir()
{ return dir; }
void featCompoundAxial::set_dir(vector * dirIn)
{ dir = dirIn; }
fLabel * featCompoundAxial::get_fLabel()
{ return a_fLabel; }
void featCompoundAxial::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
std::list<fLabel *> * featCompoundAxial::get_featureNominalList()
{ return a_featureNominalList; }
void featCompoundAxial::set_featureNominalList(std::list<fLabel *> * featureNominalListIn)
{ a_featureNominalList = featureNominalListIn; }

/********************************************************************/

featCompoundPlane::featCompoundPlane(){}

featCompoundPlane::featCompoundPlane(
  typePoint * typePointIn,
  vector * dirIn,
  fLabel * fLabelIn,
  std::list<fLabel *> * featureNominalListIn)
{
  a_typePoint = typePointIn;
  dir = dirIn;
  a_fLabel = fLabelIn;
  a_featureNominalList = featureNominalListIn;
}

featCompoundPlane::~featCompoundPlane(){}

void featCompoundPlane::printSelf()
{
  printf("COMPOUND");
  printf(",");
  printf("PLANE");
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  dir->printSelf();
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  if (a_featureNominalList->begin() == a_featureNominalList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<fLabel *>::iterator iter;
      for (iter = a_featureNominalList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureNominalList->end())
            break;
          printf(",");
        }
    }
}

typePoint * featCompoundPlane::get_typePoint()
{ return a_typePoint; }
void featCompoundPlane::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featCompoundPlane::get_dir()
{ return dir; }
void featCompoundPlane::set_dir(vector * dirIn)
{ dir = dirIn; }
fLabel * featCompoundPlane::get_fLabel()
{ return a_fLabel; }
void featCompoundPlane::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
std::list<fLabel *> * featCompoundPlane::get_featureNominalList()
{ return a_featureNominalList; }
void featCompoundPlane::set_featureNominalList(std::list<fLabel *> * featureNominalListIn)
{ a_featureNominalList = featureNominalListIn; }

/********************************************************************/

featCompoundSphere::featCompoundSphere(){}

featCompoundSphere::featCompoundSphere(
  typePoint * typePointIn,
  fLabel * fLabelIn,
  std::list<fLabel *> * featureNominalListIn)
{
  a_typePoint = typePointIn;
  a_fLabel = fLabelIn;
  a_featureNominalList = featureNominalListIn;
}

featCompoundSphere::~featCompoundSphere(){}

void featCompoundSphere::printSelf()
{
  printf("COMPOUND");
  printf(",");
  printf("SPHERE");
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  if (a_featureNominalList->begin() == a_featureNominalList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<fLabel *>::iterator iter;
      for (iter = a_featureNominalList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureNominalList->end())
            break;
          printf(",");
        }
    }
}

typePoint * featCompoundSphere::get_typePoint()
{ return a_typePoint; }
void featCompoundSphere::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
fLabel * featCompoundSphere::get_fLabel()
{ return a_fLabel; }
void featCompoundSphere::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
std::list<fLabel *> * featCompoundSphere::get_featureNominalList()
{ return a_featureNominalList; }
void featCompoundSphere::set_featureNominalList(std::list<fLabel *> * featureNominalListIn)
{ a_featureNominalList = featureNominalListIn; }

/********************************************************************/

featMinorCone::featMinorCone(){}

featMinorCone::featMinorCone(
  matDir * matDirIn,
  typePoint * vertexIn,
  vector * axisIn,
  angle * angIn)
{
  a_matDir = matDirIn;
  vertex = vertexIn;
  axis = axisIn;
  ang = angIn;
}

featMinorCone::~featMinorCone(){}

void featMinorCone::printSelf()
{
  printf("CONE");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  vertex->printSelf();
  printf(",");
  axis->printSelf();
  printf(",");
  ang->printSelf();
}

matDir * featMinorCone::get_matDir()
{ return a_matDir; }
void featMinorCone::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorCone::get_vertex()
{ return vertex; }
void featMinorCone::set_vertex(typePoint * vertexIn)
{ vertex = vertexIn; }
vector * featMinorCone::get_axis()
{ return axis; }
void featMinorCone::set_axis(vector * axisIn)
{ axis = axisIn; }
angle * featMinorCone::get_ang()
{ return ang; }
void featMinorCone::set_ang(angle * angIn)
{ ang = angIn; }

/********************************************************************/

featMinorConradseg::featMinorConradseg(){};

featMinorConradseg::~featMinorConradseg(){}

/********************************************************************/

featConradsegCart::featConradsegCart(){}

featConradsegCart::featConradsegCart(
  matDir * matDirIn,
  cartPoint * axisStartIn,
  impCartPoint * axisEndIn,
  rentVal * startRadIn,
  rentVal * endRadIn,
  vector * longStartIn,
  vector * longEndIn)
{
  a_matDir = matDirIn;
  axisStart = axisStartIn;
  axisEnd = axisEndIn;
  startRad = startRadIn;
  endRad = endRadIn;
  longStart = longStartIn;
  longEnd = longEndIn;
}

featConradsegCart::~featConradsegCart(){}

void featConradsegCart::printSelf()
{
  printf("CONRADSEGMNT");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  axisStart->printSelf();
  printf(",");
  axisEnd->printSelf();
  printf(",");
  startRad->printSelf();
  printf(",");
  endRad->printSelf();
  printf(",");
  longStart->printSelf();
  printf(",");
  longEnd->printSelf();
}

matDir * featConradsegCart::get_matDir()
{ return a_matDir; }
void featConradsegCart::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
cartPoint * featConradsegCart::get_axisStart()
{ return axisStart; }
void featConradsegCart::set_axisStart(cartPoint * axisStartIn)
{ axisStart = axisStartIn; }
impCartPoint * featConradsegCart::get_axisEnd()
{ return axisEnd; }
void featConradsegCart::set_axisEnd(impCartPoint * axisEndIn)
{ axisEnd = axisEndIn; }
rentVal * featConradsegCart::get_startRad()
{ return startRad; }
void featConradsegCart::set_startRad(rentVal * startRadIn)
{ startRad = startRadIn; }
rentVal * featConradsegCart::get_endRad()
{ return endRad; }
void featConradsegCart::set_endRad(rentVal * endRadIn)
{ endRad = endRadIn; }
vector * featConradsegCart::get_longStart()
{ return longStart; }
void featConradsegCart::set_longStart(vector * longStartIn)
{ longStart = longStartIn; }
vector * featConradsegCart::get_longEnd()
{ return longEnd; }
void featConradsegCart::set_longEnd(vector * longEndIn)
{ longEnd = longEndIn; }

/********************************************************************/

featConradsegPol::featConradsegPol(){}

featConradsegPol::featConradsegPol(
  matDir * matDirIn,
  polPoint * axisStartIn,
  impPolPoint * axisEndIn,
  rentVal * startRadIn,
  rentVal * endRadIn,
  vector * longStartIn,
  vector * longEndIn)
{
  a_matDir = matDirIn;
  axisStart = axisStartIn;
  axisEnd = axisEndIn;
  startRad = startRadIn;
  endRad = endRadIn;
  longStart = longStartIn;
  longEnd = longEndIn;
}

featConradsegPol::~featConradsegPol(){}

void featConradsegPol::printSelf()
{
  printf("CONRADSEGMNT");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  axisStart->printSelf();
  printf(",");
  axisEnd->printSelf();
  printf(",");
  startRad->printSelf();
  printf(",");
  endRad->printSelf();
  printf(",");
  longStart->printSelf();
  printf(",");
  longEnd->printSelf();
}

matDir * featConradsegPol::get_matDir()
{ return a_matDir; }
void featConradsegPol::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
polPoint * featConradsegPol::get_axisStart()
{ return axisStart; }
void featConradsegPol::set_axisStart(polPoint * axisStartIn)
{ axisStart = axisStartIn; }
impPolPoint * featConradsegPol::get_axisEnd()
{ return axisEnd; }
void featConradsegPol::set_axisEnd(impPolPoint * axisEndIn)
{ axisEnd = axisEndIn; }
rentVal * featConradsegPol::get_startRad()
{ return startRad; }
void featConradsegPol::set_startRad(rentVal * startRadIn)
{ startRad = startRadIn; }
rentVal * featConradsegPol::get_endRad()
{ return endRad; }
void featConradsegPol::set_endRad(rentVal * endRadIn)
{ endRad = endRadIn; }
vector * featConradsegPol::get_longStart()
{ return longStart; }
void featConradsegPol::set_longStart(vector * longStartIn)
{ longStart = longStartIn; }
vector * featConradsegPol::get_longEnd()
{ return longEnd; }
void featConradsegPol::set_longEnd(vector * longEndIn)
{ longEnd = longEndIn; }

/********************************************************************/

featMinorCparln::featMinorCparln(){}

featMinorCparln::featMinorCparln(
  matDir * matDirIn,
  flatRoundOpen * flatRoundOpenIn,
  typePoint * centerIn,
  vector * surfVecIn,
  vector * lineVecIn,
  rentVal * lenIn,
  rentVal * widthIn)
{
  a_matDir = matDirIn;
  a_flatRoundOpen = flatRoundOpenIn;
  center = centerIn;
  surfVec = surfVecIn;
  lineVec = lineVecIn;
  len = lenIn;
  width = widthIn;
}

featMinorCparln::~featMinorCparln(){}

void featMinorCparln::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  a_flatRoundOpen->printSelf();
  printf(",");
  center->printSelf();
  printf(",");
  surfVec->printSelf();
  printf(",");
  lineVec->printSelf();
  printf(",");
  len->printSelf();
  printf(",");
  width->printSelf();
}

matDir * featMinorCparln::get_matDir()
{ return a_matDir; }
void featMinorCparln::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
flatRoundOpen * featMinorCparln::get_flatRoundOpen()
{ return a_flatRoundOpen; }
void featMinorCparln::set_flatRoundOpen(flatRoundOpen * flatRoundOpenIn)
{ a_flatRoundOpen = flatRoundOpenIn; }
typePoint * featMinorCparln::get_center()
{ return center; }
void featMinorCparln::set_center(typePoint * centerIn)
{ center = centerIn; }
vector * featMinorCparln::get_surfVec()
{ return surfVec; }
void featMinorCparln::set_surfVec(vector * surfVecIn)
{ surfVec = surfVecIn; }
vector * featMinorCparln::get_lineVec()
{ return lineVec; }
void featMinorCparln::set_lineVec(vector * lineVecIn)
{ lineVec = lineVecIn; }
rentVal * featMinorCparln::get_len()
{ return len; }
void featMinorCparln::set_len(rentVal * lenIn)
{ len = lenIn; }
rentVal * featMinorCparln::get_width()
{ return width; }
void featMinorCparln::set_width(rentVal * widthIn)
{ width = widthIn; }

/********************************************************************/

featMinorCylndr::featMinorCylndr(){}

featMinorCylndr::featMinorCylndr(
  matDir * matDirIn,
  typePoint * axisPointIn,
  vector * axisVecIn,
  rentVal * diamIn,
  rentVal * lenIn)
{
  a_matDir = matDirIn;
  axisPoint = axisPointIn;
  axisVec = axisVecIn;
  diam = diamIn;
  len = lenIn;
}

featMinorCylndr::~featMinorCylndr(){}

void featMinorCylndr::printSelf()
{
  printf("CYLNDR");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  axisPoint->printSelf();
  printf(",");
  axisVec->printSelf();
  printf(",");
  diam->printSelf();
  if (len)
    {
      printf(",");
      len->printSelf();
    }
}

matDir * featMinorCylndr::get_matDir()
{ return a_matDir; }
void featMinorCylndr::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorCylndr::get_axisPoint()
{ return axisPoint; }
void featMinorCylndr::set_axisPoint(typePoint * axisPointIn)
{ axisPoint = axisPointIn; }
vector * featMinorCylndr::get_axisVec()
{ return axisVec; }
void featMinorCylndr::set_axisVec(vector * axisVecIn)
{ axisVec = axisVecIn; }
rentVal * featMinorCylndr::get_diam()
{ return diam; }
void featMinorCylndr::set_diam(rentVal * diamIn)
{ diam = diamIn; }
rentVal * featMinorCylndr::get_len()
{ return len; }
void featMinorCylndr::set_len(rentVal * lenIn)
{ len = lenIn; }

/********************************************************************/

featMinorCylradseg::featMinorCylradseg(){};

featMinorCylradseg::~featMinorCylradseg(){}

/********************************************************************/

featCylradsegCart::featCylradsegCart(){}

featCylradsegCart::featCylradsegCart(
  matDir * matDirIn,
  cartPoint * axisStartIn,
  impCartPoint * axisEndIn,
  rentVal * radIn,
  vector * longStartIn,
  vector * longEndIn)
{
  a_matDir = matDirIn;
  axisStart = axisStartIn;
  axisEnd = axisEndIn;
  rad = radIn;
  longStart = longStartIn;
  longEnd = longEndIn;
}

featCylradsegCart::~featCylradsegCart(){}

void featCylradsegCart::printSelf()
{
  printf("CYLRADSEGMNT");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  axisStart->printSelf();
  printf(",");
  axisEnd->printSelf();
  printf(",");
  rad->printSelf();
  printf(",");
  longStart->printSelf();
  printf(",");
  longEnd->printSelf();
}

matDir * featCylradsegCart::get_matDir()
{ return a_matDir; }
void featCylradsegCart::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
cartPoint * featCylradsegCart::get_axisStart()
{ return axisStart; }
void featCylradsegCart::set_axisStart(cartPoint * axisStartIn)
{ axisStart = axisStartIn; }
impCartPoint * featCylradsegCart::get_axisEnd()
{ return axisEnd; }
void featCylradsegCart::set_axisEnd(impCartPoint * axisEndIn)
{ axisEnd = axisEndIn; }
rentVal * featCylradsegCart::get_rad()
{ return rad; }
void featCylradsegCart::set_rad(rentVal * radIn)
{ rad = radIn; }
vector * featCylradsegCart::get_longStart()
{ return longStart; }
void featCylradsegCart::set_longStart(vector * longStartIn)
{ longStart = longStartIn; }
vector * featCylradsegCart::get_longEnd()
{ return longEnd; }
void featCylradsegCart::set_longEnd(vector * longEndIn)
{ longEnd = longEndIn; }

/********************************************************************/

featCylradsegPol::featCylradsegPol(){}

featCylradsegPol::featCylradsegPol(
  matDir * matDirIn,
  polPoint * axisStartIn,
  impPolPoint * axisEndIn,
  rentVal * radIn,
  vector * longStartIn,
  vector * longEndIn)
{
  a_matDir = matDirIn;
  axisStart = axisStartIn;
  axisEnd = axisEndIn;
  rad = radIn;
  longStart = longStartIn;
  longEnd = longEndIn;
}

featCylradsegPol::~featCylradsegPol(){}

void featCylradsegPol::printSelf()
{
  printf("CYLRADSEGMNT");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  axisStart->printSelf();
  printf(",");
  axisEnd->printSelf();
  printf(",");
  rad->printSelf();
  printf(",");
  longStart->printSelf();
  printf(",");
  longEnd->printSelf();
}

matDir * featCylradsegPol::get_matDir()
{ return a_matDir; }
void featCylradsegPol::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
polPoint * featCylradsegPol::get_axisStart()
{ return axisStart; }
void featCylradsegPol::set_axisStart(polPoint * axisStartIn)
{ axisStart = axisStartIn; }
impPolPoint * featCylradsegPol::get_axisEnd()
{ return axisEnd; }
void featCylradsegPol::set_axisEnd(impPolPoint * axisEndIn)
{ axisEnd = axisEndIn; }
rentVal * featCylradsegPol::get_rad()
{ return rad; }
void featCylradsegPol::set_rad(rentVal * radIn)
{ rad = radIn; }
vector * featCylradsegPol::get_longStart()
{ return longStart; }
void featCylradsegPol::set_longStart(vector * longStartIn)
{ longStart = longStartIn; }
vector * featCylradsegPol::get_longEnd()
{ return longEnd; }
void featCylradsegPol::set_longEnd(vector * longEndIn)
{ longEnd = longEndIn; }

/********************************************************************/

featMinorEdgept::featMinorEdgept(){}

featMinorEdgept::featMinorEdgept(
  typePoint * typePointIn,
  vector * edgeNormIn,
  vector * surfNormIn)
{
  a_typePoint = typePointIn;
  edgeNorm = edgeNormIn;
  surfNorm = surfNormIn;
}

featMinorEdgept::~featMinorEdgept(){}

void featMinorEdgept::printSelf()
{
  printf("EDGEPT");
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  edgeNorm->printSelf();
  printf(",");
  surfNorm->printSelf();
}

typePoint * featMinorEdgept::get_typePoint()
{ return a_typePoint; }
void featMinorEdgept::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featMinorEdgept::get_edgeNorm()
{ return edgeNorm; }
void featMinorEdgept::set_edgeNorm(vector * edgeNormIn)
{ edgeNorm = edgeNormIn; }
vector * featMinorEdgept::get_surfNorm()
{ return surfNorm; }
void featMinorEdgept::set_surfNorm(vector * surfNormIn)
{ surfNorm = surfNormIn; }

/********************************************************************/

featMinorEllips::featMinorEllips(){};

featMinorEllips::~featMinorEllips(){}

/********************************************************************/

featEllipsCart::featEllipsCart(){}

featEllipsCart::featEllipsCart(
  matDir * matDirIn,
  cartPoint * focus1In,
  impCartPoint * focus2In,
  radiusSpec * radiusSpecIn,
  vector * planeVecIn,
  rentVal * diamIn)
{
  a_matDir = matDirIn;
  focus1 = focus1In;
  focus2 = focus2In;
  a_radiusSpec = radiusSpecIn;
  planeVec = planeVecIn;
  diam = diamIn;
}

featEllipsCart::~featEllipsCart(){}

void featEllipsCart::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  focus1->printSelf();
  printf(",");
  focus2->printSelf();
  printf(",");
  a_radiusSpec->printSelf();
  printf(",");
  planeVec->printSelf();
  printf(",");
  diam->printSelf();
}

matDir * featEllipsCart::get_matDir()
{ return a_matDir; }
void featEllipsCart::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
cartPoint * featEllipsCart::get_focus1()
{ return focus1; }
void featEllipsCart::set_focus1(cartPoint * focus1In)
{ focus1 = focus1In; }
impCartPoint * featEllipsCart::get_focus2()
{ return focus2; }
void featEllipsCart::set_focus2(impCartPoint * focus2In)
{ focus2 = focus2In; }
radiusSpec * featEllipsCart::get_radiusSpec()
{ return a_radiusSpec; }
void featEllipsCart::set_radiusSpec(radiusSpec * radiusSpecIn)
{ a_radiusSpec = radiusSpecIn; }
vector * featEllipsCart::get_planeVec()
{ return planeVec; }
void featEllipsCart::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }
rentVal * featEllipsCart::get_diam()
{ return diam; }
void featEllipsCart::set_diam(rentVal * diamIn)
{ diam = diamIn; }

/********************************************************************/

featEllipsPol::featEllipsPol(){}

featEllipsPol::featEllipsPol(
  matDir * matDirIn,
  polPoint * focus1In,
  impPolPoint * focus2In,
  radiusSpec * radiusSpecIn,
  vector * planeVecIn,
  rentVal * diamIn)
{
  a_matDir = matDirIn;
  focus1 = focus1In;
  focus2 = focus2In;
  a_radiusSpec = radiusSpecIn;
  planeVec = planeVecIn;
  diam = diamIn;
}

featEllipsPol::~featEllipsPol(){}

void featEllipsPol::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  focus1->printSelf();
  printf(",");
  focus2->printSelf();
  printf(",");
  a_radiusSpec->printSelf();
  printf(",");
  planeVec->printSelf();
  printf(",");
  diam->printSelf();
}

matDir * featEllipsPol::get_matDir()
{ return a_matDir; }
void featEllipsPol::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
polPoint * featEllipsPol::get_focus1()
{ return focus1; }
void featEllipsPol::set_focus1(polPoint * focus1In)
{ focus1 = focus1In; }
impPolPoint * featEllipsPol::get_focus2()
{ return focus2; }
void featEllipsPol::set_focus2(impPolPoint * focus2In)
{ focus2 = focus2In; }
radiusSpec * featEllipsPol::get_radiusSpec()
{ return a_radiusSpec; }
void featEllipsPol::set_radiusSpec(radiusSpec * radiusSpecIn)
{ a_radiusSpec = radiusSpecIn; }
vector * featEllipsPol::get_planeVec()
{ return planeVec; }
void featEllipsPol::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }
rentVal * featEllipsPol::get_diam()
{ return diam; }
void featEllipsPol::set_diam(rentVal * diamIn)
{ diam = diamIn; }

/********************************************************************/

featMinorElongcyl::featMinorElongcyl(){}

featMinorElongcyl::featMinorElongcyl(
  matDir * matDirIn,
  typePoint * planePtIn,
  vector * planeVecIn,
  vector * axisVecIn,
  rentVal * sizeIn,
  rentVal * radiusIn,
  rentVal * lenIn)
{
  a_matDir = matDirIn;
  planePt = planePtIn;
  planeVec = planeVecIn;
  axisVec = axisVecIn;
  size = sizeIn;
  radius = radiusIn;
  len = lenIn;
}

featMinorElongcyl::~featMinorElongcyl(){}

void featMinorElongcyl::printSelf()
{
  printf("ELONGCYL");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  planePt->printSelf();
  printf(",");
  planeVec->printSelf();
  printf(",");
  axisVec->printSelf();
  printf(",");
  size->printSelf();
  printf(",");
  radius->printSelf();
  if (len)
    {
      printf(",");
      len->printSelf();
    }
}

matDir * featMinorElongcyl::get_matDir()
{ return a_matDir; }
void featMinorElongcyl::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorElongcyl::get_planePt()
{ return planePt; }
void featMinorElongcyl::set_planePt(typePoint * planePtIn)
{ planePt = planePtIn; }
vector * featMinorElongcyl::get_planeVec()
{ return planeVec; }
void featMinorElongcyl::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }
vector * featMinorElongcyl::get_axisVec()
{ return axisVec; }
void featMinorElongcyl::set_axisVec(vector * axisVecIn)
{ axisVec = axisVecIn; }
rentVal * featMinorElongcyl::get_size()
{ return size; }
void featMinorElongcyl::set_size(rentVal * sizeIn)
{ size = sizeIn; }
rentVal * featMinorElongcyl::get_radius()
{ return radius; }
void featMinorElongcyl::set_radius(rentVal * radiusIn)
{ radius = radiusIn; }
rentVal * featMinorElongcyl::get_len()
{ return len; }
void featMinorElongcyl::set_len(rentVal * lenIn)
{ len = lenIn; }

/********************************************************************/

featMinorGeom::featMinorGeom(){}

featMinorGeom::featMinorGeom(
  gLabel * gLabelIn,
  coordType * coordTypeIn)
{
  a_gLabel = gLabelIn;
  a_coordType = coordTypeIn;
}

featMinorGeom::~featMinorGeom(){}

void featMinorGeom::printSelf()
{
  printf("GEOM");
  printf(",");
  a_gLabel->printSelf();
  printf(",");
  a_coordType->printSelf();
}

gLabel * featMinorGeom::get_gLabel()
{ return a_gLabel; }
void featMinorGeom::set_gLabel(gLabel * gLabelIn)
{ a_gLabel = gLabelIn; }
coordType * featMinorGeom::get_coordType()
{ return a_coordType; }
void featMinorGeom::set_coordType(coordType * coordTypeIn)
{ a_coordType = coordTypeIn; }

/********************************************************************/

featMinorGcurve::featMinorGcurve(){};

featMinorGcurve::~featMinorGcurve(){}

/********************************************************************/

featGcurveCart::featGcurveCart(){}

featGcurveCart::featGcurveCart(
  pointVecCart * planeDataIn,
  pointVecCart * curveData1In,
  std::list<pointVecCart *> * curveDataRestIn)
{
  planeData = planeDataIn;
  curveData1 = curveData1In;
  curveDataRest = curveDataRestIn;
}

featGcurveCart::~featGcurveCart(){}

void featGcurveCart::printSelf()
{
  printf("GCURVE");
  printf(",");
  printf("CART");
  printf(",");
  planeData->printSelf();
  if (curveData1)
    {
      printf(",");
      printf("PTDATA");
      printf(",");
      curveData1->printSelf();
      printf(",");
      if (curveDataRest->begin() == curveDataRest->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<pointVecCart *>::iterator iter;
          for (iter = curveDataRest->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == curveDataRest->end())
                break;
              printf(",");
            }
        }
    }
}

pointVecCart * featGcurveCart::get_planeData()
{ return planeData; }
void featGcurveCart::set_planeData(pointVecCart * planeDataIn)
{ planeData = planeDataIn; }
pointVecCart * featGcurveCart::get_curveData1()
{ return curveData1; }
void featGcurveCart::set_curveData1(pointVecCart * curveData1In)
{ curveData1 = curveData1In; }
std::list<pointVecCart *> * featGcurveCart::get_curveDataRest()
{ return curveDataRest; }
void featGcurveCart::set_curveDataRest(std::list<pointVecCart *> * curveDataRestIn)
{ curveDataRest = curveDataRestIn; }

/********************************************************************/

featGcurvePol::featGcurvePol(){}

featGcurvePol::featGcurvePol(
  pointVecPol * planeDataIn,
  pointVecPol * curveData1In,
  std::list<pointVecPol *> * curveDataRestIn)
{
  planeData = planeDataIn;
  curveData1 = curveData1In;
  curveDataRest = curveDataRestIn;
}

featGcurvePol::~featGcurvePol(){}

void featGcurvePol::printSelf()
{
  printf("GCURVE");
  printf(",");
  printf("POL");
  printf(",");
  planeData->printSelf();
  if (curveData1)
    {
      printf(",");
      printf("PTDATA");
      printf(",");
      curveData1->printSelf();
      printf(",");
      if (curveDataRest->begin() == curveDataRest->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<pointVecPol *>::iterator iter;
          for (iter = curveDataRest->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == curveDataRest->end())
                break;
              printf(",");
            }
        }
    }
}

pointVecPol * featGcurvePol::get_planeData()
{ return planeData; }
void featGcurvePol::set_planeData(pointVecPol * planeDataIn)
{ planeData = planeDataIn; }
pointVecPol * featGcurvePol::get_curveData1()
{ return curveData1; }
void featGcurvePol::set_curveData1(pointVecPol * curveData1In)
{ curveData1 = curveData1In; }
std::list<pointVecPol *> * featGcurvePol::get_curveDataRest()
{ return curveDataRest; }
void featGcurvePol::set_curveDataRest(std::list<pointVecPol *> * curveDataRestIn)
{ curveDataRest = curveDataRestIn; }

/********************************************************************/

featMinorGsurf::featMinorGsurf(){};

featMinorGsurf::~featMinorGsurf(){}

/********************************************************************/

featGsurfPlain::featGsurfPlain(){}

featGsurfPlain::~featGsurfPlain(){}

void featGsurfPlain::printSelf()
{
  printf("GSURF");
}

/********************************************************************/

featGsurfCart::featGsurfCart(){}

featGsurfCart::featGsurfCart(
  pointVecCart * pt1In,
  pointVecCart * pt2In,
  std::list<pointVecCart *> * morePtsIn)
{
  pt1 = pt1In;
  pt2 = pt2In;
  morePts = morePtsIn;
}

featGsurfCart::~featGsurfCart(){}

void featGsurfCart::printSelf()
{
  printf("GSURF");
  printf(",");
  printf("CART");
  if (pt1)
    {
      printf(",");
      printf("PTDATA");
      printf(",");
      pt1->printSelf();
      printf(",");
      pt2->printSelf();
      printf(",");
      if (morePts->begin() == morePts->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<pointVecCart *>::iterator iter;
          for (iter = morePts->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == morePts->end())
                break;
              printf(",");
            }
        }
    }
}

pointVecCart * featGsurfCart::get_pt1()
{ return pt1; }
void featGsurfCart::set_pt1(pointVecCart * pt1In)
{ pt1 = pt1In; }
pointVecCart * featGsurfCart::get_pt2()
{ return pt2; }
void featGsurfCart::set_pt2(pointVecCart * pt2In)
{ pt2 = pt2In; }
std::list<pointVecCart *> * featGsurfCart::get_morePts()
{ return morePts; }
void featGsurfCart::set_morePts(std::list<pointVecCart *> * morePtsIn)
{ morePts = morePtsIn; }

/********************************************************************/

featGsurfPol::featGsurfPol(){}

featGsurfPol::featGsurfPol(
  pointVecPol * pt1In,
  pointVecPol * pt2In,
  std::list<pointVecPol *> * morePtsIn)
{
  pt1 = pt1In;
  pt2 = pt2In;
  morePts = morePtsIn;
}

featGsurfPol::~featGsurfPol(){}

void featGsurfPol::printSelf()
{
  printf("GSURF");
  printf(",");
  printf("POL");
  if (pt1)
    {
      printf(",");
      printf("PTDATA");
      printf(",");
      pt1->printSelf();
      printf(",");
      pt2->printSelf();
      printf(",");
      if (morePts->begin() == morePts->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<pointVecPol *>::iterator iter;
          for (iter = morePts->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == morePts->end())
                break;
              printf(",");
            }
        }
    }
}

pointVecPol * featGsurfPol::get_pt1()
{ return pt1; }
void featGsurfPol::set_pt1(pointVecPol * pt1In)
{ pt1 = pt1In; }
pointVecPol * featGsurfPol::get_pt2()
{ return pt2; }
void featGsurfPol::set_pt2(pointVecPol * pt2In)
{ pt2 = pt2In; }
std::list<pointVecPol *> * featGsurfPol::get_morePts()
{ return morePts; }
void featGsurfPol::set_morePts(std::list<pointVecPol *> * morePtsIn)
{ morePts = morePtsIn; }

/********************************************************************/

featMinorLine::featMinorLine(){};

featMinorLine::~featMinorLine(){}

/********************************************************************/

featLineBndCart::featLineBndCart(){}

featLineBndCart::featLineBndCart(
  cartPoint * startIn,
  impCartPoint * endIn,
  vector * planeVecIn)
{
  start = startIn;
  end = endIn;
  planeVec = planeVecIn;
}

featLineBndCart::~featLineBndCart(){}

void featLineBndCart::printSelf()
{
  printf("LINE");
  printf(",");
  printf("BND");
  printf(",");
  start->printSelf();
  printf(",");
  end->printSelf();
  printf(",");
  planeVec->printSelf();
}

cartPoint * featLineBndCart::get_start()
{ return start; }
void featLineBndCart::set_start(cartPoint * startIn)
{ start = startIn; }
impCartPoint * featLineBndCart::get_end()
{ return end; }
void featLineBndCart::set_end(impCartPoint * endIn)
{ end = endIn; }
vector * featLineBndCart::get_planeVec()
{ return planeVec; }
void featLineBndCart::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

featLineBndPol::featLineBndPol(){}

featLineBndPol::featLineBndPol(
  polPoint * startIn,
  impPolPoint * endIn,
  vector * planeVecIn)
{
  start = startIn;
  end = endIn;
  planeVec = planeVecIn;
}

featLineBndPol::~featLineBndPol(){}

void featLineBndPol::printSelf()
{
  printf("LINE");
  printf(",");
  printf("BND");
  printf(",");
  start->printSelf();
  printf(",");
  end->printSelf();
  printf(",");
  planeVec->printSelf();
}

polPoint * featLineBndPol::get_start()
{ return start; }
void featLineBndPol::set_start(polPoint * startIn)
{ start = startIn; }
impPolPoint * featLineBndPol::get_end()
{ return end; }
void featLineBndPol::set_end(impPolPoint * endIn)
{ end = endIn; }
vector * featLineBndPol::get_planeVec()
{ return planeVec; }
void featLineBndPol::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

featLineUnbndCart::featLineUnbndCart(){}

featLineUnbndCart::featLineUnbndCart(
  cartPoint * cartPointIn,
  vector * lineVecIn,
  vector * planeVecIn)
{
  a_cartPoint = cartPointIn;
  lineVec = lineVecIn;
  planeVec = planeVecIn;
}

featLineUnbndCart::~featLineUnbndCart(){}

void featLineUnbndCart::printSelf()
{
  printf("LINE");
  printf(",");
  printf("UNBND");
  printf(",");
  a_cartPoint->printSelf();
  printf(",");
  lineVec->printSelf();
  printf(",");
  planeVec->printSelf();
}

cartPoint * featLineUnbndCart::get_cartPoint()
{ return a_cartPoint; }
void featLineUnbndCart::set_cartPoint(cartPoint * cartPointIn)
{ a_cartPoint = cartPointIn; }
vector * featLineUnbndCart::get_lineVec()
{ return lineVec; }
void featLineUnbndCart::set_lineVec(vector * lineVecIn)
{ lineVec = lineVecIn; }
vector * featLineUnbndCart::get_planeVec()
{ return planeVec; }
void featLineUnbndCart::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

featLineUnbndPol::featLineUnbndPol(){}

featLineUnbndPol::featLineUnbndPol(
  polPoint * polPointIn,
  vector * lineVecIn,
  vector * planeVecIn)
{
  a_polPoint = polPointIn;
  lineVec = lineVecIn;
  planeVec = planeVecIn;
}

featLineUnbndPol::~featLineUnbndPol(){}

void featLineUnbndPol::printSelf()
{
  printf("LINE");
  printf(",");
  printf("UNBND");
  printf(",");
  a_polPoint->printSelf();
  printf(",");
  lineVec->printSelf();
  printf(",");
  planeVec->printSelf();
}

polPoint * featLineUnbndPol::get_polPoint()
{ return a_polPoint; }
void featLineUnbndPol::set_polPoint(polPoint * polPointIn)
{ a_polPoint = polPointIn; }
vector * featLineUnbndPol::get_lineVec()
{ return lineVec; }
void featLineUnbndPol::set_lineVec(vector * lineVecIn)
{ lineVec = lineVecIn; }
vector * featLineUnbndPol::get_planeVec()
{ return planeVec; }
void featLineUnbndPol::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

featMinorObject::featMinorObject(){}

featMinorObject::featMinorObject(
  std::list<param *> * paramListIn)
{
  a_paramList = paramListIn;
}

featMinorObject::~featMinorObject(){}

void featMinorObject::printSelf()
{
  printf("OBJECT");
  printf(",");
  if (a_paramList->begin() == a_paramList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<param *>::iterator iter;
      for (iter = a_paramList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_paramList->end())
            break;
          printf(",");
        }
    }
}

std::list<param *> * featMinorObject::get_paramList()
{ return a_paramList; }
void featMinorObject::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

featMinorParpln::featMinorParpln(){};

featMinorParpln::~featMinorParpln(){}

/********************************************************************/

featParplnPointsCart::featParplnPointsCart(){}

featParplnPointsCart::featParplnPointsCart(
  matDir * matDirIn,
  cartPoint * centerPtIn,
  pointVecCart * plane1dataIn,
  pointVecCart * plane2dataIn,
  rentVal * widthIn)
{
  a_matDir = matDirIn;
  centerPt = centerPtIn;
  plane1data = plane1dataIn;
  plane2data = plane2dataIn;
  width = widthIn;
}

featParplnPointsCart::~featParplnPointsCart(){}

void featParplnPointsCart::printSelf()
{
  printf("PARPLN");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  centerPt->printSelf();
  printf(",");
  plane1data->printSelf();
  printf(",");
  plane2data->printSelf();
  printf(",");
  width->printSelf();
}

matDir * featParplnPointsCart::get_matDir()
{ return a_matDir; }
void featParplnPointsCart::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
cartPoint * featParplnPointsCart::get_centerPt()
{ return centerPt; }
void featParplnPointsCart::set_centerPt(cartPoint * centerPtIn)
{ centerPt = centerPtIn; }
pointVecCart * featParplnPointsCart::get_plane1data()
{ return plane1data; }
void featParplnPointsCart::set_plane1data(pointVecCart * plane1dataIn)
{ plane1data = plane1dataIn; }
pointVecCart * featParplnPointsCart::get_plane2data()
{ return plane2data; }
void featParplnPointsCart::set_plane2data(pointVecCart * plane2dataIn)
{ plane2data = plane2dataIn; }
rentVal * featParplnPointsCart::get_width()
{ return width; }
void featParplnPointsCart::set_width(rentVal * widthIn)
{ width = widthIn; }

/********************************************************************/

featParplnPointsPol::featParplnPointsPol(){}

featParplnPointsPol::featParplnPointsPol(
  matDir * matDirIn,
  polPoint * centerPtIn,
  pointVecPol * plane1dataIn,
  pointVecPol * plane2dataIn,
  rentVal * widthIn)
{
  a_matDir = matDirIn;
  centerPt = centerPtIn;
  plane1data = plane1dataIn;
  plane2data = plane2dataIn;
  width = widthIn;
}

featParplnPointsPol::~featParplnPointsPol(){}

void featParplnPointsPol::printSelf()
{
  printf("PARPLN");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  centerPt->printSelf();
  printf(",");
  plane1data->printSelf();
  printf(",");
  plane2data->printSelf();
  printf(",");
  width->printSelf();
}

matDir * featParplnPointsPol::get_matDir()
{ return a_matDir; }
void featParplnPointsPol::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
polPoint * featParplnPointsPol::get_centerPt()
{ return centerPt; }
void featParplnPointsPol::set_centerPt(polPoint * centerPtIn)
{ centerPt = centerPtIn; }
pointVecPol * featParplnPointsPol::get_plane1data()
{ return plane1data; }
void featParplnPointsPol::set_plane1data(pointVecPol * plane1dataIn)
{ plane1data = plane1dataIn; }
pointVecPol * featParplnPointsPol::get_plane2data()
{ return plane2data; }
void featParplnPointsPol::set_plane2data(pointVecPol * plane2dataIn)
{ plane2data = plane2dataIn; }
rentVal * featParplnPointsPol::get_width()
{ return width; }
void featParplnPointsPol::set_width(rentVal * widthIn)
{ width = widthIn; }

/********************************************************************/

featParplnMidplCart::featParplnMidplCart(){}

featParplnMidplCart::featParplnMidplCart(
  matDir * matDirIn,
  cartPoint * centerPtIn,
  vector * centerVecIn,
  rentVal * widthIn)
{
  a_matDir = matDirIn;
  centerPt = centerPtIn;
  centerVec = centerVecIn;
  width = widthIn;
}

featParplnMidplCart::~featParplnMidplCart(){}

void featParplnMidplCart::printSelf()
{
  printf("PARPLN");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  printf("MIDPL");
  printf(",");
  centerPt->printSelf();
  printf(",");
  centerVec->printSelf();
  printf(",");
  width->printSelf();
}

matDir * featParplnMidplCart::get_matDir()
{ return a_matDir; }
void featParplnMidplCart::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
cartPoint * featParplnMidplCart::get_centerPt()
{ return centerPt; }
void featParplnMidplCart::set_centerPt(cartPoint * centerPtIn)
{ centerPt = centerPtIn; }
vector * featParplnMidplCart::get_centerVec()
{ return centerVec; }
void featParplnMidplCart::set_centerVec(vector * centerVecIn)
{ centerVec = centerVecIn; }
rentVal * featParplnMidplCart::get_width()
{ return width; }
void featParplnMidplCart::set_width(rentVal * widthIn)
{ width = widthIn; }

/********************************************************************/

featParplnMidplPol::featParplnMidplPol(){}

featParplnMidplPol::featParplnMidplPol(
  matDir * matDirIn,
  polPoint * centerPtIn,
  vector * centerVecIn,
  rentVal * widthIn)
{
  a_matDir = matDirIn;
  centerPt = centerPtIn;
  centerVec = centerVecIn;
  width = widthIn;
}

featParplnMidplPol::~featParplnMidplPol(){}

void featParplnMidplPol::printSelf()
{
  printf("PARPLN");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  printf("MIDPL");
  printf(",");
  centerPt->printSelf();
  printf(",");
  centerVec->printSelf();
  printf(",");
  width->printSelf();
}

matDir * featParplnMidplPol::get_matDir()
{ return a_matDir; }
void featParplnMidplPol::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
polPoint * featParplnMidplPol::get_centerPt()
{ return centerPt; }
void featParplnMidplPol::set_centerPt(polPoint * centerPtIn)
{ centerPt = centerPtIn; }
vector * featParplnMidplPol::get_centerVec()
{ return centerVec; }
void featParplnMidplPol::set_centerVec(vector * centerVecIn)
{ centerVec = centerVecIn; }
rentVal * featParplnMidplPol::get_width()
{ return width; }
void featParplnMidplPol::set_width(rentVal * widthIn)
{ width = widthIn; }

/********************************************************************/

featMinorPatern::featMinorPatern(){}

featMinorPatern::featMinorPatern(
  fLabel * fLabelIn,
  std::list<fLabel *> * featureNominalListIn)
{
  a_fLabel = fLabelIn;
  a_featureNominalList = featureNominalListIn;
}

featMinorPatern::~featMinorPatern(){}

void featMinorPatern::printSelf()
{
  printf("PATERN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  if (a_featureNominalList->begin() == a_featureNominalList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<fLabel *>::iterator iter;
      for (iter = a_featureNominalList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureNominalList->end())
            break;
          printf(",");
        }
    }
}

fLabel * featMinorPatern::get_fLabel()
{ return a_fLabel; }
void featMinorPatern::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
std::list<fLabel *> * featMinorPatern::get_featureNominalList()
{ return a_featureNominalList; }
void featMinorPatern::set_featureNominalList(std::list<fLabel *> * featureNominalListIn)
{ a_featureNominalList = featureNominalListIn; }

/********************************************************************/

featMinorPlane::featMinorPlane(){}

featMinorPlane::featMinorPlane(
  typePoint * typePointIn,
  vector * planeVecIn)
{
  a_typePoint = typePointIn;
  planeVec = planeVecIn;
}

featMinorPlane::~featMinorPlane(){}

void featMinorPlane::printSelf()
{
  printf("PLANE");
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  planeVec->printSelf();
}

typePoint * featMinorPlane::get_typePoint()
{ return a_typePoint; }
void featMinorPlane::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featMinorPlane::get_planeVec()
{ return planeVec; }
void featMinorPlane::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

featMinorPoint::featMinorPoint(){}

featMinorPoint::featMinorPoint(
  typePoint * typePointIn,
  vector * surfNormIn)
{
  a_typePoint = typePointIn;
  surfNorm = surfNormIn;
}

featMinorPoint::~featMinorPoint(){}

void featMinorPoint::printSelf()
{
  printf("POINT");
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  surfNorm->printSelf();
}

typePoint * featMinorPoint::get_typePoint()
{ return a_typePoint; }
void featMinorPoint::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featMinorPoint::get_surfNorm()
{ return surfNorm; }
void featMinorPoint::set_surfNorm(vector * surfNormIn)
{ surfNorm = surfNormIn; }

/********************************************************************/

featMinorRctngl::featMinorRctngl(){}

featMinorRctngl::featMinorRctngl(
  matDir * matDirIn,
  typePoint * centerIn,
  vector * faceVec1In,
  rentVal * width1In,
  vector * faceVec2In,
  rentVal * width2In,
  vector * faceVec3In,
  rentVal * width3In)
{
  a_matDir = matDirIn;
  center = centerIn;
  faceVec1 = faceVec1In;
  width1 = width1In;
  faceVec2 = faceVec2In;
  width2 = width2In;
  faceVec3 = faceVec3In;
  width3 = width3In;
}

featMinorRctngl::~featMinorRctngl(){}

void featMinorRctngl::printSelf()
{
  printf("RCTNGL");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  center->printSelf();
  printf(",");
  faceVec1->printSelf();
  printf(",");
  width1->printSelf();
  printf(",");
  faceVec2->printSelf();
  printf(",");
  width2->printSelf();
  printf(",");
  faceVec3->printSelf();
  printf(",");
  width3->printSelf();
}

matDir * featMinorRctngl::get_matDir()
{ return a_matDir; }
void featMinorRctngl::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorRctngl::get_center()
{ return center; }
void featMinorRctngl::set_center(typePoint * centerIn)
{ center = centerIn; }
vector * featMinorRctngl::get_faceVec1()
{ return faceVec1; }
void featMinorRctngl::set_faceVec1(vector * faceVec1In)
{ faceVec1 = faceVec1In; }
rentVal * featMinorRctngl::get_width1()
{ return width1; }
void featMinorRctngl::set_width1(rentVal * width1In)
{ width1 = width1In; }
vector * featMinorRctngl::get_faceVec2()
{ return faceVec2; }
void featMinorRctngl::set_faceVec2(vector * faceVec2In)
{ faceVec2 = faceVec2In; }
rentVal * featMinorRctngl::get_width2()
{ return width2; }
void featMinorRctngl::set_width2(rentVal * width2In)
{ width2 = width2In; }
vector * featMinorRctngl::get_faceVec3()
{ return faceVec3; }
void featMinorRctngl::set_faceVec3(vector * faceVec3In)
{ faceVec3 = faceVec3In; }
rentVal * featMinorRctngl::get_width3()
{ return width3; }
void featMinorRctngl::set_width3(rentVal * width3In)
{ width3 = width3In; }

/********************************************************************/

featMinorRevsurf::featMinorRevsurf(){};

featMinorRevsurf::~featMinorRevsurf(){}

/********************************************************************/

featRevsurfCart::featRevsurfCart(){}

featRevsurfCart::featRevsurfCart(
  matDir * matDirIn,
  typePoint * typePointIn,
  vector * axisIn,
  cartPoint * cartPointIn,
  std::list<impCartPoint *> * impCartPointListIn)
{
  a_matDir = matDirIn;
  a_typePoint = typePointIn;
  axis = axisIn;
  a_cartPoint = cartPointIn;
  a_impCartPointList = impCartPointListIn;
}

featRevsurfCart::~featRevsurfCart(){}

void featRevsurfCart::printSelf()
{
  printf("REVSURF");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  axis->printSelf();
  printf(",");
  a_cartPoint->printSelf();
  printf(",");
  if (a_impCartPointList->begin() == a_impCartPointList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<impCartPoint *>::iterator iter;
      for (iter = a_impCartPointList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_impCartPointList->end())
            break;
          printf(",");
        }
    }
}

matDir * featRevsurfCart::get_matDir()
{ return a_matDir; }
void featRevsurfCart::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featRevsurfCart::get_typePoint()
{ return a_typePoint; }
void featRevsurfCart::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featRevsurfCart::get_axis()
{ return axis; }
void featRevsurfCart::set_axis(vector * axisIn)
{ axis = axisIn; }
cartPoint * featRevsurfCart::get_cartPoint()
{ return a_cartPoint; }
void featRevsurfCart::set_cartPoint(cartPoint * cartPointIn)
{ a_cartPoint = cartPointIn; }
std::list<impCartPoint *> * featRevsurfCart::get_impCartPointList()
{ return a_impCartPointList; }
void featRevsurfCart::set_impCartPointList(std::list<impCartPoint *> * impCartPointListIn)
{ a_impCartPointList = impCartPointListIn; }

/********************************************************************/

featRevsurfPol::featRevsurfPol(){}

featRevsurfPol::featRevsurfPol(
  matDir * matDirIn,
  typePoint * typePointIn,
  vector * axisIn,
  polPoint * polPointIn,
  std::list<impPolPoint *> * impPolPointListIn)
{
  a_matDir = matDirIn;
  a_typePoint = typePointIn;
  axis = axisIn;
  a_polPoint = polPointIn;
  a_impPolPointList = impPolPointListIn;
}

featRevsurfPol::~featRevsurfPol(){}

void featRevsurfPol::printSelf()
{
  printf("REVSURF");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  axis->printSelf();
  printf(",");
  a_polPoint->printSelf();
  printf(",");
  if (a_impPolPointList->begin() == a_impPolPointList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<impPolPoint *>::iterator iter;
      for (iter = a_impPolPointList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_impPolPointList->end())
            break;
          printf(",");
        }
    }
}

matDir * featRevsurfPol::get_matDir()
{ return a_matDir; }
void featRevsurfPol::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featRevsurfPol::get_typePoint()
{ return a_typePoint; }
void featRevsurfPol::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * featRevsurfPol::get_axis()
{ return axis; }
void featRevsurfPol::set_axis(vector * axisIn)
{ axis = axisIn; }
polPoint * featRevsurfPol::get_polPoint()
{ return a_polPoint; }
void featRevsurfPol::set_polPoint(polPoint * polPointIn)
{ a_polPoint = polPointIn; }
std::list<impPolPoint *> * featRevsurfPol::get_impPolPointList()
{ return a_impPolPointList; }
void featRevsurfPol::set_impPolPointList(std::list<impPolPoint *> * impPolPointListIn)
{ a_impPolPointList = impPolPointListIn; }

/********************************************************************/

featMinorSphere::featMinorSphere(){}

featMinorSphere::featMinorSphere(
  matDir * matDirIn,
  typePoint * centerIn,
  rentVal * diamIn,
  vector * orientIn,
  angle * latIn)
{
  a_matDir = matDirIn;
  center = centerIn;
  diam = diamIn;
  orient = orientIn;
  lat = latIn;
}

featMinorSphere::~featMinorSphere(){}

void featMinorSphere::printSelf()
{
  printf("SPHERE");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  center->printSelf();
  printf(",");
  diam->printSelf();
  if (orient)
    {
      printf(",");
      orient->printSelf();
      if (lat)
        {
          printf(",");
          lat->printSelf();
        }
    }
}

matDir * featMinorSphere::get_matDir()
{ return a_matDir; }
void featMinorSphere::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorSphere::get_center()
{ return center; }
void featMinorSphere::set_center(typePoint * centerIn)
{ center = centerIn; }
rentVal * featMinorSphere::get_diam()
{ return diam; }
void featMinorSphere::set_diam(rentVal * diamIn)
{ diam = diamIn; }
vector * featMinorSphere::get_orient()
{ return orient; }
void featMinorSphere::set_orient(vector * orientIn)
{ orient = orientIn; }
angle * featMinorSphere::get_lat()
{ return lat; }
void featMinorSphere::set_lat(angle * latIn)
{ lat = latIn; }

/********************************************************************/

featMinorSphradseg::featMinorSphradseg(){}

featMinorSphradseg::featMinorSphradseg(
  matDir * matDirIn,
  typePoint * centerIn,
  rentVal * diamIn,
  vector * northIn,
  rentVal * latStartIn,
  rentVal * latStopIn,
  vector * primeIn,
  rentVal * longStartIn,
  rentVal * longStopIn)
{
  a_matDir = matDirIn;
  center = centerIn;
  diam = diamIn;
  north = northIn;
  latStart = latStartIn;
  latStop = latStopIn;
  prime = primeIn;
  longStart = longStartIn;
  longStop = longStopIn;
}

featMinorSphradseg::~featMinorSphradseg(){}

void featMinorSphradseg::printSelf()
{
  printf("SPHRADSEGMNT");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  center->printSelf();
  printf(",");
  diam->printSelf();
  printf(",");
  north->printSelf();
  printf(",");
  latStart->printSelf();
  printf(",");
  latStop->printSelf();
  printf(",");
  prime->printSelf();
  printf(",");
  longStart->printSelf();
  printf(",");
  longStop->printSelf();
}

matDir * featMinorSphradseg::get_matDir()
{ return a_matDir; }
void featMinorSphradseg::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorSphradseg::get_center()
{ return center; }
void featMinorSphradseg::set_center(typePoint * centerIn)
{ center = centerIn; }
rentVal * featMinorSphradseg::get_diam()
{ return diam; }
void featMinorSphradseg::set_diam(rentVal * diamIn)
{ diam = diamIn; }
vector * featMinorSphradseg::get_north()
{ return north; }
void featMinorSphradseg::set_north(vector * northIn)
{ north = northIn; }
rentVal * featMinorSphradseg::get_latStart()
{ return latStart; }
void featMinorSphradseg::set_latStart(rentVal * latStartIn)
{ latStart = latStartIn; }
rentVal * featMinorSphradseg::get_latStop()
{ return latStop; }
void featMinorSphradseg::set_latStop(rentVal * latStopIn)
{ latStop = latStopIn; }
vector * featMinorSphradseg::get_prime()
{ return prime; }
void featMinorSphradseg::set_prime(vector * primeIn)
{ prime = primeIn; }
rentVal * featMinorSphradseg::get_longStart()
{ return longStart; }
void featMinorSphradseg::set_longStart(rentVal * longStartIn)
{ longStart = longStartIn; }
rentVal * featMinorSphradseg::get_longStop()
{ return longStop; }
void featMinorSphradseg::set_longStop(rentVal * longStopIn)
{ longStop = longStopIn; }

/********************************************************************/

featMinorSympln::featMinorSympln(){};

featMinorSympln::~featMinorSympln(){}

/********************************************************************/

featSymplnCart::featSymplnCart(){}

featSymplnCart::featSymplnCart(
  matDir * matDirIn,
  cartPoint * centerPtIn,
  pointVecCart * plane1dataIn,
  pointVecCart * plane2dataIn,
  rentVal * widthIn)
{
  a_matDir = matDirIn;
  centerPt = centerPtIn;
  plane1data = plane1dataIn;
  plane2data = plane2dataIn;
  width = widthIn;
}

featSymplnCart::~featSymplnCart(){}

void featSymplnCart::printSelf()
{
  printf("SYMPLN");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  centerPt->printSelf();
  printf(",");
  plane1data->printSelf();
  printf(",");
  plane2data->printSelf();
  printf(",");
  width->printSelf();
}

matDir * featSymplnCart::get_matDir()
{ return a_matDir; }
void featSymplnCart::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
cartPoint * featSymplnCart::get_centerPt()
{ return centerPt; }
void featSymplnCart::set_centerPt(cartPoint * centerPtIn)
{ centerPt = centerPtIn; }
pointVecCart * featSymplnCart::get_plane1data()
{ return plane1data; }
void featSymplnCart::set_plane1data(pointVecCart * plane1dataIn)
{ plane1data = plane1dataIn; }
pointVecCart * featSymplnCart::get_plane2data()
{ return plane2data; }
void featSymplnCart::set_plane2data(pointVecCart * plane2dataIn)
{ plane2data = plane2dataIn; }
rentVal * featSymplnCart::get_width()
{ return width; }
void featSymplnCart::set_width(rentVal * widthIn)
{ width = widthIn; }

/********************************************************************/

featSymplnPol::featSymplnPol(){}

featSymplnPol::featSymplnPol(
  matDir * matDirIn,
  polPoint * centerPtIn,
  pointVecPol * plane1dataIn,
  pointVecPol * plane2dataIn,
  rentVal * widthIn)
{
  a_matDir = matDirIn;
  centerPt = centerPtIn;
  plane1data = plane1dataIn;
  plane2data = plane2dataIn;
  width = widthIn;
}

featSymplnPol::~featSymplnPol(){}

void featSymplnPol::printSelf()
{
  printf("SYMPLN");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  centerPt->printSelf();
  printf(",");
  plane1data->printSelf();
  printf(",");
  plane2data->printSelf();
  printf(",");
  width->printSelf();
}

matDir * featSymplnPol::get_matDir()
{ return a_matDir; }
void featSymplnPol::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
polPoint * featSymplnPol::get_centerPt()
{ return centerPt; }
void featSymplnPol::set_centerPt(polPoint * centerPtIn)
{ centerPt = centerPtIn; }
pointVecPol * featSymplnPol::get_plane1data()
{ return plane1data; }
void featSymplnPol::set_plane1data(pointVecPol * plane1dataIn)
{ plane1data = plane1dataIn; }
pointVecPol * featSymplnPol::get_plane2data()
{ return plane2data; }
void featSymplnPol::set_plane2data(pointVecPol * plane2dataIn)
{ plane2data = plane2dataIn; }
rentVal * featSymplnPol::get_width()
{ return width; }
void featSymplnPol::set_width(rentVal * widthIn)
{ width = widthIn; }

/********************************************************************/

featMinorTorradseg::featMinorTorradseg(){}

featMinorTorradseg::featMinorTorradseg(
  matDir * matDirIn,
  typePoint * centerIn,
  rentVal * majradIn,
  rentVal * minradIn,
  vector * northIn,
  rentVal * latStartIn,
  rentVal * latStopIn,
  vector * primeIn,
  rentVal * longStartIn,
  rentVal * longStopIn)
{
  a_matDir = matDirIn;
  center = centerIn;
  majrad = majradIn;
  minrad = minradIn;
  north = northIn;
  latStart = latStartIn;
  latStop = latStopIn;
  prime = primeIn;
  longStart = longStartIn;
  longStop = longStopIn;
}

featMinorTorradseg::~featMinorTorradseg(){}

void featMinorTorradseg::printSelf()
{
  printf("TORRADSEGMNT");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  center->printSelf();
  printf(",");
  majrad->printSelf();
  printf(",");
  minrad->printSelf();
  printf(",");
  north->printSelf();
  printf(",");
  latStart->printSelf();
  printf(",");
  latStop->printSelf();
  printf(",");
  prime->printSelf();
  printf(",");
  longStart->printSelf();
  printf(",");
  longStop->printSelf();
}

matDir * featMinorTorradseg::get_matDir()
{ return a_matDir; }
void featMinorTorradseg::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorTorradseg::get_center()
{ return center; }
void featMinorTorradseg::set_center(typePoint * centerIn)
{ center = centerIn; }
rentVal * featMinorTorradseg::get_majrad()
{ return majrad; }
void featMinorTorradseg::set_majrad(rentVal * majradIn)
{ majrad = majradIn; }
rentVal * featMinorTorradseg::get_minrad()
{ return minrad; }
void featMinorTorradseg::set_minrad(rentVal * minradIn)
{ minrad = minradIn; }
vector * featMinorTorradseg::get_north()
{ return north; }
void featMinorTorradseg::set_north(vector * northIn)
{ north = northIn; }
rentVal * featMinorTorradseg::get_latStart()
{ return latStart; }
void featMinorTorradseg::set_latStart(rentVal * latStartIn)
{ latStart = latStartIn; }
rentVal * featMinorTorradseg::get_latStop()
{ return latStop; }
void featMinorTorradseg::set_latStop(rentVal * latStopIn)
{ latStop = latStopIn; }
vector * featMinorTorradseg::get_prime()
{ return prime; }
void featMinorTorradseg::set_prime(vector * primeIn)
{ prime = primeIn; }
rentVal * featMinorTorradseg::get_longStart()
{ return longStart; }
void featMinorTorradseg::set_longStart(rentVal * longStartIn)
{ longStart = longStartIn; }
rentVal * featMinorTorradseg::get_longStop()
{ return longStop; }
void featMinorTorradseg::set_longStop(rentVal * longStopIn)
{ longStop = longStopIn; }

/********************************************************************/

featMinorTorus::featMinorTorus(){}

featMinorTorus::featMinorTorus(
  matDir * matDirIn,
  typePoint * centerIn,
  vector * axisIn,
  rentVal * majorDiamIn,
  rentVal * minorDiamIn)
{
  a_matDir = matDirIn;
  center = centerIn;
  axis = axisIn;
  majorDiam = majorDiamIn;
  minorDiam = minorDiamIn;
}

featMinorTorus::~featMinorTorus(){}

void featMinorTorus::printSelf()
{
  printf("TORUS");
  printf(",");
  a_matDir->printSelf();
  printf(",");
  center->printSelf();
  printf(",");
  axis->printSelf();
  printf(",");
  majorDiam->printSelf();
  printf(",");
  minorDiam->printSelf();
}

matDir * featMinorTorus::get_matDir()
{ return a_matDir; }
void featMinorTorus::set_matDir(matDir * matDirIn)
{ a_matDir = matDirIn; }
typePoint * featMinorTorus::get_center()
{ return center; }
void featMinorTorus::set_center(typePoint * centerIn)
{ center = centerIn; }
vector * featMinorTorus::get_axis()
{ return axis; }
void featMinorTorus::set_axis(vector * axisIn)
{ axis = axisIn; }
rentVal * featMinorTorus::get_majorDiam()
{ return majorDiam; }
void featMinorTorus::set_majorDiam(rentVal * majorDiamIn)
{ majorDiam = majorDiamIn; }
rentVal * featMinorTorus::get_minorDiam()
{ return minorDiam; }
void featMinorTorus::set_minorDiam(rentVal * minorDiamIn)
{ minorDiam = minorDiamIn; }

/********************************************************************/

fedratMinor::fedratMinor(){};

fedratMinor::~fedratMinor(){}

/********************************************************************/

fedratMeas::fedratMeas(){}

fedratMeas::fedratMeas(
  fedratLinSpec * fedratLinSpecIn)
{
  a_fedratLinSpec = fedratLinSpecIn;
}

fedratMeas::~fedratMeas(){}

void fedratMeas::printSelf()
{
  printf("MESVEL");
  printf(",");
  a_fedratLinSpec->printSelf();
}

fedratLinSpec * fedratMeas::get_fedratLinSpec()
{ return a_fedratLinSpec; }
void fedratMeas::set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn)
{ a_fedratLinSpec = fedratLinSpecIn; }

/********************************************************************/

fedratPos::fedratPos(){}

fedratPos::fedratPos(
  fedratLinSpec * fedratLinSpecIn)
{
  a_fedratLinSpec = fedratLinSpecIn;
}

fedratPos::~fedratPos(){}

void fedratPos::printSelf()
{
  printf("POSVEL");
  printf(",");
  a_fedratLinSpec->printSelf();
}

fedratLinSpec * fedratPos::get_fedratLinSpec()
{ return a_fedratLinSpec; }
void fedratPos::set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn)
{ a_fedratLinSpec = fedratLinSpecIn; }

/********************************************************************/

fedratRot::fedratRot(){}

fedratRot::fedratRot(
  fedratAngSpec * fedratAngSpecIn)
{
  a_fedratAngSpec = fedratAngSpecIn;
}

fedratRot::~fedratRot(){}

void fedratRot::printSelf()
{
  printf("ROTVEL");
  printf(",");
  a_fedratAngSpec->printSelf();
}

fedratAngSpec * fedratRot::get_fedratAngSpec()
{ return a_fedratAngSpec; }
void fedratRot::set_fedratAngSpec(fedratAngSpec * fedratAngSpecIn)
{ a_fedratAngSpec = fedratAngSpecIn; }

/********************************************************************/

fedratScan::fedratScan(){}

fedratScan::fedratScan(
  fedratLinSpec * fedratLinSpecIn)
{
  a_fedratLinSpec = fedratLinSpecIn;
}

fedratScan::~fedratScan(){}

void fedratScan::printSelf()
{
  printf("SCNVEL");
  printf(",");
  a_fedratLinSpec->printSelf();
}

fedratLinSpec * fedratScan::get_fedratLinSpec()
{ return a_fedratLinSpec; }
void fedratScan::set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn)
{ a_fedratLinSpec = fedratLinSpecIn; }

/********************************************************************/

fedratHedRot::fedratHedRot(){}

fedratHedRot::fedratHedRot(
  fedratLinSpec * fedratLinSpecIn)
{
  a_fedratLinSpec = fedratLinSpecIn;
}

fedratHedRot::~fedratHedRot(){}

void fedratHedRot::printSelf()
{
  printf("HEDROTVEL");
  printf(",");
  a_fedratLinSpec->printSelf();
}

fedratLinSpec * fedratHedRot::get_fedratLinSpec()
{ return a_fedratLinSpec; }
void fedratHedRot::set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn)
{ a_fedratLinSpec = fedratLinSpecIn; }

/********************************************************************/

fedratHedMeas::fedratHedMeas(){}

fedratHedMeas::fedratHedMeas(
  fedratLinSpec * fedratLinSpecIn)
{
  a_fedratLinSpec = fedratLinSpecIn;
}

fedratHedMeas::~fedratHedMeas(){}

void fedratHedMeas::printSelf()
{
  printf("HEDMESVEL");
  printf(",");
  a_fedratLinSpec->printSelf();
}

fedratLinSpec * fedratHedMeas::get_fedratLinSpec()
{ return a_fedratLinSpec; }
void fedratHedMeas::set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn)
{ a_fedratLinSpec = fedratLinSpecIn; }

/********************************************************************/

fedratHedScan::fedratHedScan(){}

fedratHedScan::fedratHedScan(
  fedratLinSpec * fedratLinSpecIn)
{
  a_fedratLinSpec = fedratLinSpecIn;
}

fedratHedScan::~fedratHedScan(){}

void fedratHedScan::printSelf()
{
  printf("HEDSCNVEL");
  printf(",");
  a_fedratLinSpec->printSelf();
}

fedratLinSpec * fedratHedScan::get_fedratLinSpec()
{ return a_fedratLinSpec; }
void fedratHedScan::set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn)
{ a_fedratLinSpec = fedratLinSpecIn; }

/********************************************************************/

fedratAngSpec::fedratAngSpec(){};

fedratAngSpec::~fedratAngSpec(){}

/********************************************************************/

fedratLinSpec::fedratLinSpec(){};

fedratLinSpec::~fedratLinSpec(){}

/********************************************************************/

fedratLinear::fedratLinear(){};

fedratLinear::~fedratLinear(){}

/********************************************************************/

fedratLinear_MPM::fedratLinear_MPM(){}

fedratLinear_MPM::fedratLinear_MPM(
  rentVal * rateIn)
{
  rate = rateIn;
}

fedratLinear_MPM::~fedratLinear_MPM(){}

void fedratLinear_MPM::printSelf()
{
  printf("MPM");
  printf(",");
  rate->printSelf();
}

rentVal * fedratLinear_MPM::get_rate()
{ return rate; }
void fedratLinear_MPM::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

fedratLinear_MMPS::fedratLinear_MMPS(){}

fedratLinear_MMPS::fedratLinear_MMPS(
  rentVal * rateIn)
{
  rate = rateIn;
}

fedratLinear_MMPS::~fedratLinear_MMPS(){}

void fedratLinear_MMPS::printSelf()
{
  printf("MMPS");
  printf(",");
  rate->printSelf();
}

rentVal * fedratLinear_MMPS::get_rate()
{ return rate; }
void fedratLinear_MMPS::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

fedratLinear_IPM::fedratLinear_IPM(){}

fedratLinear_IPM::fedratLinear_IPM(
  rentVal * rateIn)
{
  rate = rateIn;
}

fedratLinear_IPM::~fedratLinear_IPM(){}

void fedratLinear_IPM::printSelf()
{
  printf("IPM");
  printf(",");
  rate->printSelf();
}

rentVal * fedratLinear_IPM::get_rate()
{ return rate; }
void fedratLinear_IPM::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

fedratLinear_IPS::fedratLinear_IPS(){}

fedratLinear_IPS::fedratLinear_IPS(
  rentVal * rateIn)
{
  rate = rateIn;
}

fedratLinear_IPS::~fedratLinear_IPS(){}

void fedratLinear_IPS::printSelf()
{
  printf("IPS");
  printf(",");
  rate->printSelf();
}

rentVal * fedratLinear_IPS::get_rate()
{ return rate; }
void fedratLinear_IPS::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

fedratAngular::fedratAngular(){}

fedratAngular::fedratAngular(
  rentVal * rateIn)
{
  rate = rateIn;
}

fedratAngular::~fedratAngular(){}

void fedratAngular::printSelf()
{
  printf("RPM");
  printf(",");
  rate->printSelf();
}

rentVal * fedratAngular::get_rate()
{ return rate; }
void fedratAngular::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

fedratDef::fedratDef(){};

fedratDef::~fedratDef(){}

/********************************************************************/

fedratDef_PCENT::fedratDef_PCENT(){}

fedratDef_PCENT::fedratDef_PCENT(
  rentVal * rateIn)
{
  rate = rateIn;
}

fedratDef_PCENT::~fedratDef_PCENT(){}

void fedratDef_PCENT::printSelf()
{
  printf("PCENT");
  printf(",");
  rate->printSelf();
}

rentVal * fedratDef_PCENT::get_rate()
{ return rate; }
void fedratDef_PCENT::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

fedratDef_HIGH::fedratDef_HIGH(){}

fedratDef_HIGH::~fedratDef_HIGH(){}

void fedratDef_HIGH::printSelf()
{
  printf("HIGH");
}

/********************************************************************/

fedratDef_LOW::fedratDef_LOW(){}

fedratDef_LOW::~fedratDef_LOW(){}

void fedratDef_LOW::printSelf()
{
  printf("LOW");
}

/********************************************************************/

fedratDef_DEFALT::fedratDef_DEFALT(){}

fedratDef_DEFALT::~fedratDef_DEFALT(){}

void fedratDef_DEFALT::printSelf()
{
  printf("DEFALT");
}

/********************************************************************/

fildefStm::fildefStm(){}

fildefStm::fildefStm(
  vfLabel * vfLabelIn,
  intVal * codeIn)
{
  a_vfLabel = vfLabelIn;
  code = codeIn;
}

fildefStm::~fildefStm(){}

void fildefStm::printSelf()
{
  a_vfLabel->printSelf();
  printf("=");
  printf("FILDEF");
  printf("/");
  printf("CODE");
  printf(",");
  code->printSelf();
  printf("%c%c", 13, 10);
}

vfLabel * fildefStm::get_vfLabel()
{ return a_vfLabel; }
void fildefStm::set_vfLabel(vfLabel * vfLabelIn)
{ a_vfLabel = vfLabelIn; }
intVal * fildefStm::get_code()
{ return code; }
void fildefStm::set_code(intVal * codeIn)
{ code = codeIn; }

/********************************************************************/

filnamStm::filnamStm(){}

filnamStm::filnamStm(
  stringConst * stringConstIn,
  versionTag * versionTagIn)
{
  a_stringConst = stringConstIn;
  a_versionTag = versionTagIn;
}

filnamStm::~filnamStm(){}

void filnamStm::printSelf()
{
  printf("FILNAM");
  printf("/");
  a_stringConst->printSelf();
  printf(",");
  a_versionTag->printSelf();
  printf("%c%c", 13, 10);
}

stringConst * filnamStm::get_stringConst()
{ return a_stringConst; }
void filnamStm::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }
versionTag * filnamStm::get_versionTag()
{ return a_versionTag; }
void filnamStm::set_versionTag(versionTag * versionTagIn)
{ a_versionTag = versionTagIn; }

/********************************************************************/

fixtidStm::fixtidStm(){}

fixtidStm::fixtidStm(
  fiLabel * fiLabelIn,
  stringVal * textIn)
{
  a_fiLabel = fiLabelIn;
  text = textIn;
}

fixtidStm::~fixtidStm(){}

void fixtidStm::printSelf()
{
  a_fiLabel->printSelf();
  printf("=");
  printf("FIXTID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

fiLabel * fixtidStm::get_fiLabel()
{ return a_fiLabel; }
void fixtidStm::set_fiLabel(fiLabel * fiLabelIn)
{ a_fiLabel = fiLabelIn; }
stringVal * fixtidStm::get_text()
{ return text; }
void fixtidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

fixtsnStm::fixtsnStm(){}

fixtsnStm::fixtsnStm(
  fsLabel * fsLabelIn,
  stringVal * textIn)
{
  a_fsLabel = fsLabelIn;
  text = textIn;
}

fixtsnStm::~fixtsnStm(){}

void fixtsnStm::printSelf()
{
  a_fsLabel->printSelf();
  printf("=");
  printf("FIXTSN");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

fsLabel * fixtsnStm::get_fsLabel()
{ return a_fsLabel; }
void fixtsnStm::set_fsLabel(fsLabel * fsLabelIn)
{ a_fsLabel = fsLabelIn; }
stringVal * fixtsnStm::get_text()
{ return text; }
void fixtsnStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

flyStm::flyStm(){}

flyStm::flyStm(
  flyMinor * flyMinorIn)
{
  a_flyMinor = flyMinorIn;
}

flyStm::~flyStm(){}

void flyStm::printSelf()
{
  printf("FLY");
  printf("/");
  a_flyMinor->printSelf();
  printf("%c%c", 13, 10);
}

flyMinor * flyStm::get_flyMinor()
{ return a_flyMinor; }
void flyStm::set_flyMinor(flyMinor * flyMinorIn)
{ a_flyMinor = flyMinorIn; }

/********************************************************************/

flyMinor::flyMinor(){};

flyMinor::~flyMinor(){}

/********************************************************************/

flyMinor_OFF::flyMinor_OFF(){}

flyMinor_OFF::~flyMinor_OFF(){}

void flyMinor_OFF::printSelf()
{
  printf("OFF");
}

/********************************************************************/

flyMinor_rentVal::flyMinor_rentVal(){}

flyMinor_rentVal::flyMinor_rentVal(
  rentVal * radiusIn)
{
  radius = radiusIn;
}

flyMinor_rentVal::~flyMinor_rentVal(){}

void flyMinor_rentVal::printSelf()
{
  radius->printSelf();
}

rentVal * flyMinor_rentVal::get_radius()
{ return radius; }
void flyMinor_rentVal::set_radius(rentVal * radiusIn)
{ radius = radiusIn; }

/********************************************************************/

fromMinor::fromMinor(){};

fromMinor::~fromMinor(){}

/********************************************************************/

fromMinor_cartPoint::fromMinor_cartPoint(){}

fromMinor_cartPoint::fromMinor_cartPoint(
  cartPoint * cartPointIn,
  bool has_RAMIn)
{
  a_cartPoint = cartPointIn;
  has_RAM = has_RAMIn;
}

fromMinor_cartPoint::~fromMinor_cartPoint(){}

void fromMinor_cartPoint::printSelf()
{
  a_cartPoint->printSelf();
  if (has_RAM == true)
    {
      printf(",");
      printf("RAM");
    }
}

cartPoint * fromMinor_cartPoint::get_cartPoint()
{ return a_cartPoint; }
void fromMinor_cartPoint::set_cartPoint(cartPoint * cartPointIn)
{ a_cartPoint = cartPointIn; }
bool fromMinor_cartPoint::get_has_RAM()
{ return has_RAM; }
void fromMinor_cartPoint::set_has_RAM(bool has_RAMIn)
{ has_RAM = has_RAMIn; }

/********************************************************************/

fromMinor_DME::fromMinor_DME(){}

fromMinor_DME::~fromMinor_DME(){}

void fromMinor_DME::printSelf()
{
  printf("DME");
}

/********************************************************************/

fromMinor_impCartPoint::fromMinor_impCartPoint(){}

fromMinor_impCartPoint::fromMinor_impCartPoint(
  impCartPoint * impCartPointIn,
  bool has_RAMIn)
{
  a_impCartPoint = impCartPointIn;
  has_RAM = has_RAMIn;
}

fromMinor_impCartPoint::~fromMinor_impCartPoint(){}

void fromMinor_impCartPoint::printSelf()
{
  a_impCartPoint->printSelf();
  if (has_RAM == true)
    {
      printf(",");
      printf("RAM");
    }
}

impCartPoint * fromMinor_impCartPoint::get_impCartPoint()
{ return a_impCartPoint; }
void fromMinor_impCartPoint::set_impCartPoint(impCartPoint * impCartPointIn)
{ a_impCartPoint = impCartPointIn; }
bool fromMinor_impCartPoint::get_has_RAM()
{ return has_RAM; }
void fromMinor_impCartPoint::set_has_RAM(bool has_RAMIn)
{ has_RAM = has_RAMIn; }

/********************************************************************/

fromMinor_polPoint::fromMinor_polPoint(){}

fromMinor_polPoint::fromMinor_polPoint(
  polPoint * polPointIn,
  bool has_RAMIn)
{
  a_polPoint = polPointIn;
  has_RAM = has_RAMIn;
}

fromMinor_polPoint::~fromMinor_polPoint(){}

void fromMinor_polPoint::printSelf()
{
  a_polPoint->printSelf();
  if (has_RAM == true)
    {
      printf(",");
      printf("RAM");
    }
}

polPoint * fromMinor_polPoint::get_polPoint()
{ return a_polPoint; }
void fromMinor_polPoint::set_polPoint(polPoint * polPointIn)
{ a_polPoint = polPointIn; }
bool fromMinor_polPoint::get_has_RAM()
{ return has_RAM; }
void fromMinor_polPoint::set_has_RAM(bool has_RAMIn)
{ has_RAM = has_RAMIn; }

/********************************************************************/

fromMinor_SCALE::fromMinor_SCALE(){}

fromMinor_SCALE::~fromMinor_SCALE(){}

void fromMinor_SCALE::printSelf()
{
  printf("SCALE");
}

/********************************************************************/

geoalgStm::geoalgStm(){}

geoalgStm::geoalgStm(
  geoalgMinor * geoalgMinorIn)
{
  a_geoalgMinor = geoalgMinorIn;
}

geoalgStm::~geoalgStm(){}

void geoalgStm::printSelf()
{
  printf("GEOALG");
  printf("/");
  a_geoalgMinor->printSelf();
  printf("%c%c", 13, 10);
}

geoalgMinor * geoalgStm::get_geoalgMinor()
{ return a_geoalgMinor; }
void geoalgStm::set_geoalgMinor(geoalgMinor * geoalgMinorIn)
{ a_geoalgMinor = geoalgMinorIn; }

/********************************************************************/

geoalgMinor::geoalgMinor(){};

geoalgMinor::~geoalgMinor(){}

/********************************************************************/

geoalgArc::geoalgArc(){}

geoalgArc::geoalgArc(
  geoalgSpec1 * geoalgSpec1In)
{
  a_geoalgSpec1 = geoalgSpec1In;
}

geoalgArc::~geoalgArc(){}

void geoalgArc::printSelf()
{
  printf("ARC");
  printf(",");
  a_geoalgSpec1->printSelf();
}

geoalgSpec1 * geoalgArc::get_geoalgSpec1()
{ return a_geoalgSpec1; }
void geoalgArc::set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In)
{ a_geoalgSpec1 = geoalgSpec1In; }

/********************************************************************/

geoalgCircle::geoalgCircle(){}

geoalgCircle::geoalgCircle(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgCircle::~geoalgCircle(){}

void geoalgCircle::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgCircle::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgCircle::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgCone::geoalgCone(){}

geoalgCone::geoalgCone(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgCone::~geoalgCone(){}

void geoalgCone::printSelf()
{
  printf("CONE");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgCone::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgCone::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgConradsegmnt::geoalgConradsegmnt(){}

geoalgConradsegmnt::geoalgConradsegmnt(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgConradsegmnt::~geoalgConradsegmnt(){}

void geoalgConradsegmnt::printSelf()
{
  printf("CONRADSEGMNT");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgConradsegmnt::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgConradsegmnt::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgCparln::geoalgCparln(){}

geoalgCparln::geoalgCparln(
  geoalgSpec3 * geoalgSpec3In)
{
  a_geoalgSpec3 = geoalgSpec3In;
}

geoalgCparln::~geoalgCparln(){}

void geoalgCparln::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_geoalgSpec3->printSelf();
}

geoalgSpec3 * geoalgCparln::get_geoalgSpec3()
{ return a_geoalgSpec3; }
void geoalgCparln::set_geoalgSpec3(geoalgSpec3 * geoalgSpec3In)
{ a_geoalgSpec3 = geoalgSpec3In; }

/********************************************************************/

geoalgCylndr::geoalgCylndr(){}

geoalgCylndr::geoalgCylndr(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgCylndr::~geoalgCylndr(){}

void geoalgCylndr::printSelf()
{
  printf("CYLNDR");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgCylndr::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgCylndr::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgCylradsegmnt::geoalgCylradsegmnt(){}

geoalgCylradsegmnt::geoalgCylradsegmnt(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgCylradsegmnt::~geoalgCylradsegmnt(){}

void geoalgCylradsegmnt::printSelf()
{
  printf("CYLRADSEGMNT");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgCylradsegmnt::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgCylradsegmnt::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgEllips::geoalgEllips(){}

geoalgEllips::geoalgEllips(
  geoalgSpec1 * geoalgSpec1In)
{
  a_geoalgSpec1 = geoalgSpec1In;
}

geoalgEllips::~geoalgEllips(){}

void geoalgEllips::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_geoalgSpec1->printSelf();
}

geoalgSpec1 * geoalgEllips::get_geoalgSpec1()
{ return a_geoalgSpec1; }
void geoalgEllips::set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In)
{ a_geoalgSpec1 = geoalgSpec1In; }

/********************************************************************/

geoalgElongcyl::geoalgElongcyl(){}

geoalgElongcyl::geoalgElongcyl(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgElongcyl::~geoalgElongcyl(){}

void geoalgElongcyl::printSelf()
{
  printf("ELONGCYL");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgElongcyl::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgElongcyl::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgGcurve::geoalgGcurve(){}

geoalgGcurve::geoalgGcurve(
  geoalgSpec4 * geoalgSpec4In)
{
  a_geoalgSpec4 = geoalgSpec4In;
}

geoalgGcurve::~geoalgGcurve(){}

void geoalgGcurve::printSelf()
{
  printf("GCURVE");
  printf(",");
  a_geoalgSpec4->printSelf();
}

geoalgSpec4 * geoalgGcurve::get_geoalgSpec4()
{ return a_geoalgSpec4; }
void geoalgGcurve::set_geoalgSpec4(geoalgSpec4 * geoalgSpec4In)
{ a_geoalgSpec4 = geoalgSpec4In; }

/********************************************************************/

geoalgGsurf::geoalgGsurf(){}

geoalgGsurf::geoalgGsurf(
  geoalgSpec5 * geoalgSpec5In)
{
  a_geoalgSpec5 = geoalgSpec5In;
}

geoalgGsurf::~geoalgGsurf(){}

void geoalgGsurf::printSelf()
{
  printf("GSURF");
  printf(",");
  a_geoalgSpec5->printSelf();
}

geoalgSpec5 * geoalgGsurf::get_geoalgSpec5()
{ return a_geoalgSpec5; }
void geoalgGsurf::set_geoalgSpec5(geoalgSpec5 * geoalgSpec5In)
{ a_geoalgSpec5 = geoalgSpec5In; }

/********************************************************************/

geoalgLine::geoalgLine(){}

geoalgLine::geoalgLine(
  geoalgSpec1 * geoalgSpec1In)
{
  a_geoalgSpec1 = geoalgSpec1In;
}

geoalgLine::~geoalgLine(){}

void geoalgLine::printSelf()
{
  printf("LINE");
  printf(",");
  a_geoalgSpec1->printSelf();
}

geoalgSpec1 * geoalgLine::get_geoalgSpec1()
{ return a_geoalgSpec1; }
void geoalgLine::set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In)
{ a_geoalgSpec1 = geoalgSpec1In; }

/********************************************************************/

geoalgObject::geoalgObject(){}

geoalgObject::geoalgObject(
  geoalgSpec3 * geoalgSpec3In)
{
  a_geoalgSpec3 = geoalgSpec3In;
}

geoalgObject::~geoalgObject(){}

void geoalgObject::printSelf()
{
  printf("OBJECT");
  printf(",");
  a_geoalgSpec3->printSelf();
}

geoalgSpec3 * geoalgObject::get_geoalgSpec3()
{ return a_geoalgSpec3; }
void geoalgObject::set_geoalgSpec3(geoalgSpec3 * geoalgSpec3In)
{ a_geoalgSpec3 = geoalgSpec3In; }

/********************************************************************/

geoalgParpln::geoalgParpln(){}

geoalgParpln::geoalgParpln(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgParpln::~geoalgParpln(){}

void geoalgParpln::printSelf()
{
  printf("PARPLN");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgParpln::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgParpln::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgPlane::geoalgPlane(){}

geoalgPlane::geoalgPlane(
  geoalgSpec1 * geoalgSpec1In)
{
  a_geoalgSpec1 = geoalgSpec1In;
}

geoalgPlane::~geoalgPlane(){}

void geoalgPlane::printSelf()
{
  printf("PLANE");
  printf(",");
  a_geoalgSpec1->printSelf();
}

geoalgSpec1 * geoalgPlane::get_geoalgSpec1()
{ return a_geoalgSpec1; }
void geoalgPlane::set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In)
{ a_geoalgSpec1 = geoalgSpec1In; }

/********************************************************************/

geoalgRctngl::geoalgRctngl(){}

geoalgRctngl::geoalgRctngl(
  geoalgSpec1 * geoalgSpec1In)
{
  a_geoalgSpec1 = geoalgSpec1In;
}

geoalgRctngl::~geoalgRctngl(){}

void geoalgRctngl::printSelf()
{
  printf("RCTNGL");
  printf(",");
  a_geoalgSpec1->printSelf();
}

geoalgSpec1 * geoalgRctngl::get_geoalgSpec1()
{ return a_geoalgSpec1; }
void geoalgRctngl::set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In)
{ a_geoalgSpec1 = geoalgSpec1In; }

/********************************************************************/

geoalgRevsurf::geoalgRevsurf(){}

geoalgRevsurf::geoalgRevsurf(
  geoalgSpec6 * geoalgSpec6In)
{
  a_geoalgSpec6 = geoalgSpec6In;
}

geoalgRevsurf::~geoalgRevsurf(){}

void geoalgRevsurf::printSelf()
{
  printf("REVSURF");
  printf(",");
  a_geoalgSpec6->printSelf();
}

geoalgSpec6 * geoalgRevsurf::get_geoalgSpec6()
{ return a_geoalgSpec6; }
void geoalgRevsurf::set_geoalgSpec6(geoalgSpec6 * geoalgSpec6In)
{ a_geoalgSpec6 = geoalgSpec6In; }

/********************************************************************/

geoalgSphere::geoalgSphere(){}

geoalgSphere::geoalgSphere(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgSphere::~geoalgSphere(){}

void geoalgSphere::printSelf()
{
  printf("SPHERE");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgSphere::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgSphere::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgSphradsegmnt::geoalgSphradsegmnt(){}

geoalgSphradsegmnt::geoalgSphradsegmnt(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgSphradsegmnt::~geoalgSphradsegmnt(){}

void geoalgSphradsegmnt::printSelf()
{
  printf("SPHRADSEGMNT");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgSphradsegmnt::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgSphradsegmnt::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgSympln::geoalgSympln(){}

geoalgSympln::geoalgSympln(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgSympln::~geoalgSympln(){}

void geoalgSympln::printSelf()
{
  printf("SYMPLN");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgSympln::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgSympln::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgTorus::geoalgTorus(){}

geoalgTorus::geoalgTorus(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgTorus::~geoalgTorus(){}

void geoalgTorus::printSelf()
{
  printf("TORUS");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgTorus::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgTorus::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgTorradsegmnt::geoalgTorradsegmnt(){}

geoalgTorradsegmnt::geoalgTorradsegmnt(
  geoalgSpec2 * geoalgSpec2In)
{
  a_geoalgSpec2 = geoalgSpec2In;
}

geoalgTorradsegmnt::~geoalgTorradsegmnt(){}

void geoalgTorradsegmnt::printSelf()
{
  printf("TORRADSEGMNT");
  printf(",");
  a_geoalgSpec2->printSelf();
}

geoalgSpec2 * geoalgTorradsegmnt::get_geoalgSpec2()
{ return a_geoalgSpec2; }
void geoalgTorradsegmnt::set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In)
{ a_geoalgSpec2 = geoalgSpec2In; }

/********************************************************************/

geoalgSpec1::geoalgSpec1(){};

geoalgSpec1::~geoalgSpec1(){}

/********************************************************************/

geoalgSpec1_LSTSQR::geoalgSpec1_LSTSQR(){}

geoalgSpec1_LSTSQR::geoalgSpec1_LSTSQR(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec1_LSTSQR::~geoalgSpec1_LSTSQR(){}

void geoalgSpec1_LSTSQR::printSelf()
{
  printf("LSTSQR");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec1_LSTSQR::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec1_LSTSQR::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec1_MINMAX::geoalgSpec1_MINMAX(){}

geoalgSpec1_MINMAX::geoalgSpec1_MINMAX(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec1_MINMAX::~geoalgSpec1_MINMAX(){}

void geoalgSpec1_MINMAX::printSelf()
{
  printf("MINMAX");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec1_MINMAX::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec1_MINMAX::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec1_DEFALT::geoalgSpec1_DEFALT(){}

geoalgSpec1_DEFALT::geoalgSpec1_DEFALT(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec1_DEFALT::~geoalgSpec1_DEFALT(){}

void geoalgSpec1_DEFALT::printSelf()
{
  printf("DEFALT");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec1_DEFALT::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec1_DEFALT::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec1_EXTERN::geoalgSpec1_EXTERN(){}

geoalgSpec1_EXTERN::geoalgSpec1_EXTERN(
  geoalgExternFunc * geoalgExternFuncIn,
  std::list<param *> * paramListIn,
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgExternFunc = geoalgExternFuncIn;
  a_paramList = paramListIn;
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec1_EXTERN::~geoalgSpec1_EXTERN(){}

void geoalgSpec1_EXTERN::printSelf()
{
  printf("EXTERN");
  printf(",");
  a_geoalgExternFunc->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgExternFunc * geoalgSpec1_EXTERN::get_geoalgExternFunc()
{ return a_geoalgExternFunc; }
void geoalgSpec1_EXTERN::set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn)
{ a_geoalgExternFunc = geoalgExternFuncIn; }
std::list<param *> * geoalgSpec1_EXTERN::get_paramList()
{ return a_paramList; }
void geoalgSpec1_EXTERN::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }
geoalgFilterSettings * geoalgSpec1_EXTERN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec1_EXTERN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec2::geoalgSpec2(){};

geoalgSpec2::~geoalgSpec2(){}

/********************************************************************/

geoalgSpec2_LSTSQR::geoalgSpec2_LSTSQR(){}

geoalgSpec2_LSTSQR::geoalgSpec2_LSTSQR(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec2_LSTSQR::~geoalgSpec2_LSTSQR(){}

void geoalgSpec2_LSTSQR::printSelf()
{
  printf("LSTSQR");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec2_LSTSQR::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec2_LSTSQR::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec2_MINMAX::geoalgSpec2_MINMAX(){}

geoalgSpec2_MINMAX::geoalgSpec2_MINMAX(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec2_MINMAX::~geoalgSpec2_MINMAX(){}

void geoalgSpec2_MINMAX::printSelf()
{
  printf("MINMAX");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec2_MINMAX::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec2_MINMAX::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec2_MAXINS::geoalgSpec2_MAXINS(){}

geoalgSpec2_MAXINS::geoalgSpec2_MAXINS(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec2_MAXINS::~geoalgSpec2_MAXINS(){}

void geoalgSpec2_MAXINS::printSelf()
{
  printf("MAXINS");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec2_MAXINS::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec2_MAXINS::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec2_MINCIR::geoalgSpec2_MINCIR(){}

geoalgSpec2_MINCIR::geoalgSpec2_MINCIR(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec2_MINCIR::~geoalgSpec2_MINCIR(){}

void geoalgSpec2_MINCIR::printSelf()
{
  printf("MINCIR");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec2_MINCIR::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec2_MINCIR::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec2_DEFALT::geoalgSpec2_DEFALT(){}

geoalgSpec2_DEFALT::geoalgSpec2_DEFALT(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec2_DEFALT::~geoalgSpec2_DEFALT(){}

void geoalgSpec2_DEFALT::printSelf()
{
  printf("DEFALT");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec2_DEFALT::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec2_DEFALT::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec2_EXTERN::geoalgSpec2_EXTERN(){}

geoalgSpec2_EXTERN::geoalgSpec2_EXTERN(
  geoalgExternFunc * geoalgExternFuncIn,
  std::list<param *> * paramListIn,
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgExternFunc = geoalgExternFuncIn;
  a_paramList = paramListIn;
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec2_EXTERN::~geoalgSpec2_EXTERN(){}

void geoalgSpec2_EXTERN::printSelf()
{
  printf("EXTERN");
  printf(",");
  a_geoalgExternFunc->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgExternFunc * geoalgSpec2_EXTERN::get_geoalgExternFunc()
{ return a_geoalgExternFunc; }
void geoalgSpec2_EXTERN::set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn)
{ a_geoalgExternFunc = geoalgExternFuncIn; }
std::list<param *> * geoalgSpec2_EXTERN::get_paramList()
{ return a_paramList; }
void geoalgSpec2_EXTERN::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }
geoalgFilterSettings * geoalgSpec2_EXTERN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec2_EXTERN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec3::geoalgSpec3(){};

geoalgSpec3::~geoalgSpec3(){}

/********************************************************************/

geoalgSpec3_DEFALT::geoalgSpec3_DEFALT(){}

geoalgSpec3_DEFALT::geoalgSpec3_DEFALT(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec3_DEFALT::~geoalgSpec3_DEFALT(){}

void geoalgSpec3_DEFALT::printSelf()
{
  printf("DEFALT");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec3_DEFALT::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec3_DEFALT::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec3_EXTERN::geoalgSpec3_EXTERN(){}

geoalgSpec3_EXTERN::geoalgSpec3_EXTERN(
  geoalgExternFunc * geoalgExternFuncIn,
  std::list<param *> * paramListIn,
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgExternFunc = geoalgExternFuncIn;
  a_paramList = paramListIn;
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec3_EXTERN::~geoalgSpec3_EXTERN(){}

void geoalgSpec3_EXTERN::printSelf()
{
  printf("EXTERN");
  printf(",");
  a_geoalgExternFunc->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgExternFunc * geoalgSpec3_EXTERN::get_geoalgExternFunc()
{ return a_geoalgExternFunc; }
void geoalgSpec3_EXTERN::set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn)
{ a_geoalgExternFunc = geoalgExternFuncIn; }
std::list<param *> * geoalgSpec3_EXTERN::get_paramList()
{ return a_paramList; }
void geoalgSpec3_EXTERN::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }
geoalgFilterSettings * geoalgSpec3_EXTERN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec3_EXTERN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec4::geoalgSpec4(){};

geoalgSpec4::~geoalgSpec4(){}

/********************************************************************/

geoalgSpec4_LSTSQR::geoalgSpec4_LSTSQR(){}

geoalgSpec4_LSTSQR::geoalgSpec4_LSTSQR(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec4_LSTSQR::~geoalgSpec4_LSTSQR(){}

void geoalgSpec4_LSTSQR::printSelf()
{
  printf("LSTSQR");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec4_LSTSQR::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec4_LSTSQR::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec4_MINMAX::geoalgSpec4_MINMAX(){}

geoalgSpec4_MINMAX::geoalgSpec4_MINMAX(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec4_MINMAX::~geoalgSpec4_MINMAX(){}

void geoalgSpec4_MINMAX::printSelf()
{
  printf("MINMAX");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec4_MINMAX::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec4_MINMAX::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec4_BSPLIN::geoalgSpec4_BSPLIN(){}

geoalgSpec4_BSPLIN::geoalgSpec4_BSPLIN(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec4_BSPLIN::~geoalgSpec4_BSPLIN(){}

void geoalgSpec4_BSPLIN::printSelf()
{
  printf("BSPLIN");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec4_BSPLIN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec4_BSPLIN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec4_DEFALT::geoalgSpec4_DEFALT(){}

geoalgSpec4_DEFALT::geoalgSpec4_DEFALT(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec4_DEFALT::~geoalgSpec4_DEFALT(){}

void geoalgSpec4_DEFALT::printSelf()
{
  printf("DEFALT");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec4_DEFALT::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec4_DEFALT::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec4_EXTERN::geoalgSpec4_EXTERN(){}

geoalgSpec4_EXTERN::geoalgSpec4_EXTERN(
  geoalgExternFunc * geoalgExternFuncIn,
  std::list<param *> * paramListIn,
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgExternFunc = geoalgExternFuncIn;
  a_paramList = paramListIn;
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec4_EXTERN::~geoalgSpec4_EXTERN(){}

void geoalgSpec4_EXTERN::printSelf()
{
  printf("EXTERN");
  printf(",");
  a_geoalgExternFunc->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgExternFunc * geoalgSpec4_EXTERN::get_geoalgExternFunc()
{ return a_geoalgExternFunc; }
void geoalgSpec4_EXTERN::set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn)
{ a_geoalgExternFunc = geoalgExternFuncIn; }
std::list<param *> * geoalgSpec4_EXTERN::get_paramList()
{ return a_paramList; }
void geoalgSpec4_EXTERN::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }
geoalgFilterSettings * geoalgSpec4_EXTERN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec4_EXTERN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec5::geoalgSpec5(){};

geoalgSpec5::~geoalgSpec5(){}

/********************************************************************/

geoalgSpec5_LSTSQR::geoalgSpec5_LSTSQR(){}

geoalgSpec5_LSTSQR::geoalgSpec5_LSTSQR(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec5_LSTSQR::~geoalgSpec5_LSTSQR(){}

void geoalgSpec5_LSTSQR::printSelf()
{
  printf("LSTSQR");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec5_LSTSQR::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec5_LSTSQR::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec5_MINMAX::geoalgSpec5_MINMAX(){}

geoalgSpec5_MINMAX::geoalgSpec5_MINMAX(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec5_MINMAX::~geoalgSpec5_MINMAX(){}

void geoalgSpec5_MINMAX::printSelf()
{
  printf("MINMAX");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec5_MINMAX::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec5_MINMAX::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec5_BEZIER::geoalgSpec5_BEZIER(){}

geoalgSpec5_BEZIER::geoalgSpec5_BEZIER(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec5_BEZIER::~geoalgSpec5_BEZIER(){}

void geoalgSpec5_BEZIER::printSelf()
{
  printf("BEZIER");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec5_BEZIER::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec5_BEZIER::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec5_NURBS::geoalgSpec5_NURBS(){}

geoalgSpec5_NURBS::geoalgSpec5_NURBS(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec5_NURBS::~geoalgSpec5_NURBS(){}

void geoalgSpec5_NURBS::printSelf()
{
  printf("NURBS");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec5_NURBS::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec5_NURBS::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec5_DEFALT::geoalgSpec5_DEFALT(){}

geoalgSpec5_DEFALT::geoalgSpec5_DEFALT(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec5_DEFALT::~geoalgSpec5_DEFALT(){}

void geoalgSpec5_DEFALT::printSelf()
{
  printf("DEFALT");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec5_DEFALT::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec5_DEFALT::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec5_EXTERN::geoalgSpec5_EXTERN(){}

geoalgSpec5_EXTERN::geoalgSpec5_EXTERN(
  geoalgExternFunc * geoalgExternFuncIn,
  std::list<param *> * paramListIn,
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgExternFunc = geoalgExternFuncIn;
  a_paramList = paramListIn;
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec5_EXTERN::~geoalgSpec5_EXTERN(){}

void geoalgSpec5_EXTERN::printSelf()
{
  printf("EXTERN");
  printf(",");
  a_geoalgExternFunc->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgExternFunc * geoalgSpec5_EXTERN::get_geoalgExternFunc()
{ return a_geoalgExternFunc; }
void geoalgSpec5_EXTERN::set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn)
{ a_geoalgExternFunc = geoalgExternFuncIn; }
std::list<param *> * geoalgSpec5_EXTERN::get_paramList()
{ return a_paramList; }
void geoalgSpec5_EXTERN::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }
geoalgFilterSettings * geoalgSpec5_EXTERN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec5_EXTERN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec6::geoalgSpec6(){};

geoalgSpec6::~geoalgSpec6(){}

/********************************************************************/

geoalgSpec6_LSTSQR::geoalgSpec6_LSTSQR(){}

geoalgSpec6_LSTSQR::geoalgSpec6_LSTSQR(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec6_LSTSQR::~geoalgSpec6_LSTSQR(){}

void geoalgSpec6_LSTSQR::printSelf()
{
  printf("LSTSQR");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec6_LSTSQR::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec6_LSTSQR::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec6_BSPLIN::geoalgSpec6_BSPLIN(){}

geoalgSpec6_BSPLIN::geoalgSpec6_BSPLIN(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec6_BSPLIN::~geoalgSpec6_BSPLIN(){}

void geoalgSpec6_BSPLIN::printSelf()
{
  printf("BSPLIN");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec6_BSPLIN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec6_BSPLIN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec6_DEFALT::geoalgSpec6_DEFALT(){}

geoalgSpec6_DEFALT::geoalgSpec6_DEFALT(
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec6_DEFALT::~geoalgSpec6_DEFALT(){}

void geoalgSpec6_DEFALT::printSelf()
{
  printf("DEFALT");
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgFilterSettings * geoalgSpec6_DEFALT::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec6_DEFALT::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgSpec6_EXTERN::geoalgSpec6_EXTERN(){}

geoalgSpec6_EXTERN::geoalgSpec6_EXTERN(
  geoalgExternFunc * geoalgExternFuncIn,
  std::list<param *> * paramListIn,
  geoalgFilterSettings * geoalgFilterSettingsIn)
{
  a_geoalgExternFunc = geoalgExternFuncIn;
  a_paramList = paramListIn;
  a_geoalgFilterSettings = geoalgFilterSettingsIn;
}

geoalgSpec6_EXTERN::~geoalgSpec6_EXTERN(){}

void geoalgSpec6_EXTERN::printSelf()
{
  printf("EXTERN");
  printf(",");
  a_geoalgExternFunc->printSelf();
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
  if (a_geoalgFilterSettings)
    {
      printf(",");
      a_geoalgFilterSettings->printSelf();
    }
}

geoalgExternFunc * geoalgSpec6_EXTERN::get_geoalgExternFunc()
{ return a_geoalgExternFunc; }
void geoalgSpec6_EXTERN::set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn)
{ a_geoalgExternFunc = geoalgExternFuncIn; }
std::list<param *> * geoalgSpec6_EXTERN::get_paramList()
{ return a_paramList; }
void geoalgSpec6_EXTERN::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }
geoalgFilterSettings * geoalgSpec6_EXTERN::get_geoalgFilterSettings()
{ return a_geoalgFilterSettings; }
void geoalgSpec6_EXTERN::set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn)
{ a_geoalgFilterSettings = geoalgFilterSettingsIn; }

/********************************************************************/

geoalgExternFunc::geoalgExternFunc(){};

geoalgExternFunc::~geoalgExternFunc(){}

/********************************************************************/

geoalgExternFunc_DMIS::geoalgExternFunc_DMIS(){}

geoalgExternFunc_DMIS::geoalgExternFunc_DMIS(
  mLabel * mLabelIn)
{
  a_mLabel = mLabelIn;
}

geoalgExternFunc_DMIS::~geoalgExternFunc_DMIS(){}

void geoalgExternFunc_DMIS::printSelf()
{
  printf("DMIS");
  printf(",");
  a_mLabel->printSelf();
}

mLabel * geoalgExternFunc_DMIS::get_mLabel()
{ return a_mLabel; }
void geoalgExternFunc_DMIS::set_mLabel(mLabel * mLabelIn)
{ a_mLabel = mLabelIn; }

/********************************************************************/

geoalgExternFunc_DME::geoalgExternFunc_DME(){}

geoalgExternFunc_DME::geoalgExternFunc_DME(
  stringVal * routineIn)
{
  routine = routineIn;
}

geoalgExternFunc_DME::~geoalgExternFunc_DME(){}

void geoalgExternFunc_DME::printSelf()
{
  printf("DME");
  printf(",");
  routine->printSelf();
}

stringVal * geoalgExternFunc_DME::get_routine()
{ return routine; }
void geoalgExternFunc_DME::set_routine(stringVal * routineIn)
{ routine = routineIn; }

/********************************************************************/

geoalgExternFunc_SYS::geoalgExternFunc_SYS(){}

geoalgExternFunc_SYS::geoalgExternFunc_SYS(
  stringVal * pathnameIn)
{
  pathname = pathnameIn;
}

geoalgExternFunc_SYS::~geoalgExternFunc_SYS(){}

void geoalgExternFunc_SYS::printSelf()
{
  printf("SYS");
  printf(",");
  pathname->printSelf();
}

stringVal * geoalgExternFunc_SYS::get_pathname()
{ return pathname; }
void geoalgExternFunc_SYS::set_pathname(stringVal * pathnameIn)
{ pathname = pathnameIn; }

/********************************************************************/

geoalgFilterSettings::geoalgFilterSettings(){};

geoalgFilterSettings::~geoalgFilterSettings(){}

/********************************************************************/

geoalgFiltSetFilt::geoalgFiltSetFilt(){}

geoalgFiltSetFilt::geoalgFiltSetFilt(
  geoalgEliminate * geoalgEliminateIn,
  geoalgFilter * geoalgFilterIn)
{
  a_geoalgEliminate = geoalgEliminateIn;
  a_geoalgFilter = geoalgFilterIn;
}

geoalgFiltSetFilt::~geoalgFiltSetFilt(){}

void geoalgFiltSetFilt::printSelf()
{
  if (a_geoalgEliminate)
    {
      a_geoalgEliminate->printSelf();
      printf(",");
    }
  a_geoalgFilter->printSelf();
}

geoalgEliminate * geoalgFiltSetFilt::get_geoalgEliminate()
{ return a_geoalgEliminate; }
void geoalgFiltSetFilt::set_geoalgEliminate(geoalgEliminate * geoalgEliminateIn)
{ a_geoalgEliminate = geoalgEliminateIn; }
geoalgFilter * geoalgFiltSetFilt::get_geoalgFilter()
{ return a_geoalgFilter; }
void geoalgFiltSetFilt::set_geoalgFilter(geoalgFilter * geoalgFilterIn)
{ a_geoalgFilter = geoalgFilterIn; }

/********************************************************************/

geoalgFiltSetElim::geoalgFiltSetElim(){}

geoalgFiltSetElim::geoalgFiltSetElim(
  geoalgEliminate * geoalgEliminateIn)
{
  a_geoalgEliminate = geoalgEliminateIn;
}

geoalgFiltSetElim::~geoalgFiltSetElim(){}

void geoalgFiltSetElim::printSelf()
{
  a_geoalgEliminate->printSelf();
}

geoalgEliminate * geoalgFiltSetElim::get_geoalgEliminate()
{ return a_geoalgEliminate; }
void geoalgFiltSetElim::set_geoalgEliminate(geoalgEliminate * geoalgEliminateIn)
{ a_geoalgEliminate = geoalgEliminateIn; }

/********************************************************************/

geoalgEliminate::geoalgEliminate(){};

geoalgEliminate::~geoalgEliminate(){}

/********************************************************************/

geoalgEliminateStd::geoalgEliminateStd(){}

geoalgEliminateStd::geoalgEliminateStd(
  rentVal * devValIn)
{
  devVal = devValIn;
}

geoalgEliminateStd::~geoalgEliminateStd(){}

void geoalgEliminateStd::printSelf()
{
  printf("ELIMINATE");
  printf(",");
  printf("STDDEV_LIMIT");
  printf(",");
  devVal->printSelf();
}

rentVal * geoalgEliminateStd::get_devVal()
{ return devVal; }
void geoalgEliminateStd::set_devVal(rentVal * devValIn)
{ devVal = devValIn; }

/********************************************************************/

geoalgEliminateOff::geoalgEliminateOff(){}

geoalgEliminateOff::~geoalgEliminateOff(){}

void geoalgEliminateOff::printSelf()
{
  printf("ELIMINATE");
  printf(",");
  printf("OFF");
}

/********************************************************************/

geoalgFilter::geoalgFilter(){};

geoalgFilter::~geoalgFilter(){}

/********************************************************************/

geoalgFilterLambda::geoalgFilterLambda(){}

geoalgFilterLambda::geoalgFilterLambda(
  geoalgFilterType * geoalgFilterTypeIn)
{
  a_geoalgFilterType = geoalgFilterTypeIn;
}

geoalgFilterLambda::~geoalgFilterLambda(){}

void geoalgFilterLambda::printSelf()
{
  printf("FILTER");
  printf(",");
  printf("LAMBDAC");
  printf(",");
  a_geoalgFilterType->printSelf();
}

geoalgFilterType * geoalgFilterLambda::get_geoalgFilterType()
{ return a_geoalgFilterType; }
void geoalgFilterLambda::set_geoalgFilterType(geoalgFilterType * geoalgFilterTypeIn)
{ a_geoalgFilterType = geoalgFilterTypeIn; }

/********************************************************************/

geoalgFilterCirc::geoalgFilterCirc(){}

geoalgFilterCirc::geoalgFilterCirc(
  geoalgFilterType * geoalgFilterTypeIn)
{
  a_geoalgFilterType = geoalgFilterTypeIn;
}

geoalgFilterCirc::~geoalgFilterCirc(){}

void geoalgFilterCirc::printSelf()
{
  printf("FILTER");
  printf(",");
  printf("CIRCULAR");
  printf(",");
  a_geoalgFilterType->printSelf();
}

geoalgFilterType * geoalgFilterCirc::get_geoalgFilterType()
{ return a_geoalgFilterType; }
void geoalgFilterCirc::set_geoalgFilterType(geoalgFilterType * geoalgFilterTypeIn)
{ a_geoalgFilterType = geoalgFilterTypeIn; }

/********************************************************************/

geoalgFilterOff::geoalgFilterOff(){}

geoalgFilterOff::~geoalgFilterOff(){}

void geoalgFilterOff::printSelf()
{
  printf("FILTER");
  printf(",");
  printf("OFF");
}

/********************************************************************/

geoalgFilterType::geoalgFilterType(){};

geoalgFilterType::~geoalgFilterType(){}

/********************************************************************/

geoalgFilterType_LOWPASS::geoalgFilterType_LOWPASS(){}

geoalgFilterType_LOWPASS::geoalgFilterType_LOWPASS(
  rentVal * waveValIn,
  geoalgFilterCurve * geoalgFilterCurveIn)
{
  waveVal = waveValIn;
  a_geoalgFilterCurve = geoalgFilterCurveIn;
}

geoalgFilterType_LOWPASS::~geoalgFilterType_LOWPASS(){}

void geoalgFilterType_LOWPASS::printSelf()
{
  printf("LOWPASS");
  printf(",");
  waveVal->printSelf();
  printf(",");
  a_geoalgFilterCurve->printSelf();
}

rentVal * geoalgFilterType_LOWPASS::get_waveVal()
{ return waveVal; }
void geoalgFilterType_LOWPASS::set_waveVal(rentVal * waveValIn)
{ waveVal = waveValIn; }
geoalgFilterCurve * geoalgFilterType_LOWPASS::get_geoalgFilterCurve()
{ return a_geoalgFilterCurve; }
void geoalgFilterType_LOWPASS::set_geoalgFilterCurve(geoalgFilterCurve * geoalgFilterCurveIn)
{ a_geoalgFilterCurve = geoalgFilterCurveIn; }

/********************************************************************/

geoalgFilterType_HIGHPASS::geoalgFilterType_HIGHPASS(){}

geoalgFilterType_HIGHPASS::geoalgFilterType_HIGHPASS(
  rentVal * waveValIn,
  geoalgFilterCurve * geoalgFilterCurveIn)
{
  waveVal = waveValIn;
  a_geoalgFilterCurve = geoalgFilterCurveIn;
}

geoalgFilterType_HIGHPASS::~geoalgFilterType_HIGHPASS(){}

void geoalgFilterType_HIGHPASS::printSelf()
{
  printf("HIGHPASS");
  printf(",");
  waveVal->printSelf();
  printf(",");
  a_geoalgFilterCurve->printSelf();
}

rentVal * geoalgFilterType_HIGHPASS::get_waveVal()
{ return waveVal; }
void geoalgFilterType_HIGHPASS::set_waveVal(rentVal * waveValIn)
{ waveVal = waveValIn; }
geoalgFilterCurve * geoalgFilterType_HIGHPASS::get_geoalgFilterCurve()
{ return a_geoalgFilterCurve; }
void geoalgFilterType_HIGHPASS::set_geoalgFilterCurve(geoalgFilterCurve * geoalgFilterCurveIn)
{ a_geoalgFilterCurve = geoalgFilterCurveIn; }

/********************************************************************/

geoalgFilterType_BANDPASS::geoalgFilterType_BANDPASS(){}

geoalgFilterType_BANDPASS::geoalgFilterType_BANDPASS(
  rentVal * waveVal1In,
  rentVal * waveVal2In,
  geoalgFilterCurve * geoalgFilterCurveIn)
{
  waveVal1 = waveVal1In;
  waveVal2 = waveVal2In;
  a_geoalgFilterCurve = geoalgFilterCurveIn;
}

geoalgFilterType_BANDPASS::~geoalgFilterType_BANDPASS(){}

void geoalgFilterType_BANDPASS::printSelf()
{
  printf("BANDPASS");
  printf(",");
  waveVal1->printSelf();
  printf(",");
  waveVal2->printSelf();
  printf(",");
  a_geoalgFilterCurve->printSelf();
}

rentVal * geoalgFilterType_BANDPASS::get_waveVal1()
{ return waveVal1; }
void geoalgFilterType_BANDPASS::set_waveVal1(rentVal * waveVal1In)
{ waveVal1 = waveVal1In; }
rentVal * geoalgFilterType_BANDPASS::get_waveVal2()
{ return waveVal2; }
void geoalgFilterType_BANDPASS::set_waveVal2(rentVal * waveVal2In)
{ waveVal2 = waveVal2In; }
geoalgFilterCurve * geoalgFilterType_BANDPASS::get_geoalgFilterCurve()
{ return a_geoalgFilterCurve; }
void geoalgFilterType_BANDPASS::set_geoalgFilterCurve(geoalgFilterCurve * geoalgFilterCurveIn)
{ a_geoalgFilterCurve = geoalgFilterCurveIn; }

/********************************************************************/

geoalgFilterCurve::geoalgFilterCurve(){};

geoalgFilterCurve::~geoalgFilterCurve(){}

/********************************************************************/

geoalgFilterCurve_GAUSS::geoalgFilterCurve_GAUSS(){}

geoalgFilterCurve_GAUSS::~geoalgFilterCurve_GAUSS(){}

void geoalgFilterCurve_GAUSS::printSelf()
{
  printf("GAUSS");
}

/********************************************************************/

geoalgFilterCurve_TWORC::geoalgFilterCurve_TWORC(){}

geoalgFilterCurve_TWORC::~geoalgFilterCurve_TWORC(){}

void geoalgFilterCurve_TWORC::printSelf()
{
  printf("2RC");
}

/********************************************************************/

geoalgFilterCurve_SPLINE::geoalgFilterCurve_SPLINE(){}

geoalgFilterCurve_SPLINE::~geoalgFilterCurve_SPLINE(){}

void geoalgFilterCurve_SPLINE::printSelf()
{
  printf("SPLINE");
}

/********************************************************************/

geoalgFilterCurve_RECFILT::geoalgFilterCurve_RECFILT(){}

geoalgFilterCurve_RECFILT::~geoalgFilterCurve_RECFILT(){}

void geoalgFilterCurve_RECFILT::printSelf()
{
  printf("RECFILT");
}

/********************************************************************/

geomStm::geomStm(){}

geomStm::geomStm(
  gLabel * gLabelIn,
  geomMinor * geomMinorIn)
{
  a_gLabel = gLabelIn;
  a_geomMinor = geomMinorIn;
}

geomStm::~geomStm(){}

void geomStm::printSelf()
{
  a_gLabel->printSelf();
  printf("=");
  printf("GEOM");
  printf("/");
  a_geomMinor->printSelf();
  printf("%c%c", 13, 10);
}

gLabel * geomStm::get_gLabel()
{ return a_gLabel; }
void geomStm::set_gLabel(gLabel * gLabelIn)
{ a_gLabel = gLabelIn; }
geomMinor * geomStm::get_geomMinor()
{ return a_geomMinor; }
void geomStm::set_geomMinor(geomMinor * geomMinorIn)
{ a_geomMinor = geomMinorIn; }

/********************************************************************/

geomMinor::geomMinor(){};

geomMinor::~geomMinor(){}

/********************************************************************/

geomStmNone::geomStmNone(){}

geomStmNone::~geomStmNone(){}

void geomStmNone::printSelf()
{
  printf("NONE");
}

/********************************************************************/

geomStmDid::geomStmDid(){}

geomStmDid::geomStmDid(
  didLabel * didLabelIn)
{
  a_didLabel = didLabelIn;
}

geomStmDid::~geomStmDid(){}

void geomStmDid::printSelf()
{
  a_didLabel->printSelf();
}

didLabel * geomStmDid::get_didLabel()
{ return a_didLabel; }
void geomStmDid::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

geomStmOffset::geomStmOffset(){}

geomStmOffset::geomStmOffset(
  gLabel * gLabelIn,
  rentVal * distIn)
{
  a_gLabel = gLabelIn;
  dist = distIn;
}

geomStmOffset::~geomStmOffset(){}

void geomStmOffset::printSelf()
{
  a_gLabel->printSelf();
  if (dist)
    {
      printf(",");
      printf("OFFSET");
      printf(",");
      dist->printSelf();
    }
}

gLabel * geomStmOffset::get_gLabel()
{ return a_gLabel; }
void geomStmOffset::set_gLabel(gLabel * gLabelIn)
{ a_gLabel = gLabelIn; }
rentVal * geomStmOffset::get_dist()
{ return dist; }
void geomStmOffset::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

geomStmEntity::geomStmEntity(){}

geomStmEntity::geomStmEntity(
  gLabel * gLabelIn,
  std::list<geomEntityItem *> * geomEntityListIn)
{
  a_gLabel = gLabelIn;
  a_geomEntityList = geomEntityListIn;
}

geomStmEntity::~geomStmEntity(){}

void geomStmEntity::printSelf()
{
  a_gLabel->printSelf();
  printf(",");
  printf("ENTITY");
  printf(",");
  if (a_geomEntityList->begin() == a_geomEntityList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<geomEntityItem *>::iterator iter;
      for (iter = a_geomEntityList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_geomEntityList->end())
            break;
          printf(",");
        }
    }
}

gLabel * geomStmEntity::get_gLabel()
{ return a_gLabel; }
void geomStmEntity::set_gLabel(gLabel * gLabelIn)
{ a_gLabel = gLabelIn; }
std::list<geomEntityItem *> * geomStmEntity::get_geomEntityList()
{ return a_geomEntityList; }
void geomStmEntity::set_geomEntityList(std::list<geomEntityItem *> * geomEntityListIn)
{ a_geomEntityList = geomEntityListIn; }

/********************************************************************/

geomEntityItem::geomEntityItem(){}

geomEntityItem::geomEntityItem(
  stringVal * identityIn,
  rentVal * distIn)
{
  identity = identityIn;
  dist = distIn;
}

geomEntityItem::~geomEntityItem(){}

void geomEntityItem::printSelf()
{
  identity->printSelf();
  if (dist)
    {
      printf(",");
      printf("OFFSET");
      printf(",");
      dist->printSelf();
    }
}

stringVal * geomEntityItem::get_identity()
{ return identity; }
void geomEntityItem::set_identity(stringVal * identityIn)
{ identity = identityIn; }
rentVal * geomEntityItem::get_dist()
{ return dist; }
void geomEntityItem::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

gotargStm::gotargStm(){};

gotargStm::~gotargStm(){}

/********************************************************************/

gotargXyz::gotargXyz(){}

gotargXyz::gotargXyz(
  impCartPoint * impCartPointIn)
{
  a_impCartPoint = impCartPointIn;
}

gotargXyz::~gotargXyz(){}

void gotargXyz::printSelf()
{
  printf("GOTARG");
  printf("/");
  a_impCartPoint->printSelf();
  printf("%c%c", 13, 10);
}

impCartPoint * gotargXyz::get_impCartPoint()
{ return a_impCartPoint; }
void gotargXyz::set_impCartPoint(impCartPoint * impCartPointIn)
{ a_impCartPoint = impCartPointIn; }

/********************************************************************/

gotargCart::gotargCart(){}

gotargCart::gotargCart(
  cartPoint * cartPointIn)
{
  a_cartPoint = cartPointIn;
}

gotargCart::~gotargCart(){}

void gotargCart::printSelf()
{
  printf("GOTARG");
  printf("/");
  a_cartPoint->printSelf();
  printf("%c%c", 13, 10);
}

cartPoint * gotargCart::get_cartPoint()
{ return a_cartPoint; }
void gotargCart::set_cartPoint(cartPoint * cartPointIn)
{ a_cartPoint = cartPointIn; }

/********************************************************************/

gotargPol::gotargPol(){}

gotargPol::gotargPol(
  polPoint * polPointIn)
{
  a_polPoint = polPointIn;
}

gotargPol::~gotargPol(){}

void gotargPol::printSelf()
{
  printf("GOTARG");
  printf("/");
  a_polPoint->printSelf();
  printf("%c%c", 13, 10);
}

polPoint * gotargPol::get_polPoint()
{ return a_polPoint; }
void gotargPol::set_polPoint(polPoint * polPointIn)
{ a_polPoint = polPointIn; }

/********************************************************************/

gotoMinor::gotoMinor(){};

gotoMinor::~gotoMinor(){}

/********************************************************************/

gotoAxis::gotoAxis(){}

gotoAxis::gotoAxis(
  gotoAxisSpec * spec1In,
  gotoAxisSpec * spec2In,
  gotoAxisSpec * spec3In)
{
  spec1 = spec1In;
  spec2 = spec2In;
  spec3 = spec3In;
}

gotoAxis::~gotoAxis(){}

void gotoAxis::printSelf()
{
  spec1->printSelf();
  if (spec2)
    {
      printf(",");
      spec2->printSelf();
      if (spec3)
        {
          printf(",");
          spec3->printSelf();
        }
    }
}

gotoAxisSpec * gotoAxis::get_spec1()
{ return spec1; }
void gotoAxis::set_spec1(gotoAxisSpec * spec1In)
{ spec1 = spec1In; }
gotoAxisSpec * gotoAxis::get_spec2()
{ return spec2; }
void gotoAxis::set_spec2(gotoAxisSpec * spec2In)
{ spec2 = spec2In; }
gotoAxisSpec * gotoAxis::get_spec3()
{ return spec3; }
void gotoAxis::set_spec3(gotoAxisSpec * spec3In)
{ spec3 = spec3In; }

/********************************************************************/

gotoAxisSpec::gotoAxisSpec(){}

gotoAxisSpec::gotoAxisSpec(
  axis * axisNameIn,
  rentVal * axisCoordIn)
{
  axisName = axisNameIn;
  axisCoord = axisCoordIn;
}

gotoAxisSpec::~gotoAxisSpec(){}

void gotoAxisSpec::printSelf()
{
  axisName->printSelf();
  printf(",");
  axisCoord->printSelf();
}

axis * gotoAxisSpec::get_axisName()
{ return axisName; }
void gotoAxisSpec::set_axisName(axis * axisNameIn)
{ axisName = axisNameIn; }
rentVal * gotoAxisSpec::get_axisCoord()
{ return axisCoord; }
void gotoAxisSpec::set_axisCoord(rentVal * axisCoordIn)
{ axisCoord = axisCoordIn; }

/********************************************************************/

gotoAbs::gotoAbs(){};

gotoAbs::~gotoAbs(){}

/********************************************************************/

gotoAbsXyz::gotoAbsXyz(){}

gotoAbsXyz::gotoAbsXyz(
  impCartPoint * impCartPointIn)
{
  a_impCartPoint = impCartPointIn;
}

gotoAbsXyz::~gotoAbsXyz(){}

void gotoAbsXyz::printSelf()
{
  a_impCartPoint->printSelf();
}

impCartPoint * gotoAbsXyz::get_impCartPoint()
{ return a_impCartPoint; }
void gotoAbsXyz::set_impCartPoint(impCartPoint * impCartPointIn)
{ a_impCartPoint = impCartPointIn; }

/********************************************************************/

gotoAbsXyzSens::gotoAbsXyzSens(){}

gotoAbsXyzSens::gotoAbsXyzSens(
  impCartPoint * impCartPointIn,
  sensorMove * sensorMoveIn)
{
  a_impCartPoint = impCartPointIn;
  a_sensorMove = sensorMoveIn;
}

gotoAbsXyzSens::~gotoAbsXyzSens(){}

void gotoAbsXyzSens::printSelf()
{
  a_impCartPoint->printSelf();
  printf(",");
  a_sensorMove->printSelf();
}

impCartPoint * gotoAbsXyzSens::get_impCartPoint()
{ return a_impCartPoint; }
void gotoAbsXyzSens::set_impCartPoint(impCartPoint * impCartPointIn)
{ a_impCartPoint = impCartPointIn; }
sensorMove * gotoAbsXyzSens::get_sensorMove()
{ return a_sensorMove; }
void gotoAbsXyzSens::set_sensorMove(sensorMove * sensorMoveIn)
{ a_sensorMove = sensorMoveIn; }

/********************************************************************/

gotoAbsCart::gotoAbsCart(){}

gotoAbsCart::gotoAbsCart(
  cartPoint * cartPointIn)
{
  a_cartPoint = cartPointIn;
}

gotoAbsCart::~gotoAbsCart(){}

void gotoAbsCart::printSelf()
{
  a_cartPoint->printSelf();
}

cartPoint * gotoAbsCart::get_cartPoint()
{ return a_cartPoint; }
void gotoAbsCart::set_cartPoint(cartPoint * cartPointIn)
{ a_cartPoint = cartPointIn; }

/********************************************************************/

gotoAbsCartSens::gotoAbsCartSens(){}

gotoAbsCartSens::gotoAbsCartSens(
  cartPoint * cartPointIn,
  sensorMove * sensorMoveIn)
{
  a_cartPoint = cartPointIn;
  a_sensorMove = sensorMoveIn;
}

gotoAbsCartSens::~gotoAbsCartSens(){}

void gotoAbsCartSens::printSelf()
{
  a_cartPoint->printSelf();
  printf(",");
  a_sensorMove->printSelf();
}

cartPoint * gotoAbsCartSens::get_cartPoint()
{ return a_cartPoint; }
void gotoAbsCartSens::set_cartPoint(cartPoint * cartPointIn)
{ a_cartPoint = cartPointIn; }
sensorMove * gotoAbsCartSens::get_sensorMove()
{ return a_sensorMove; }
void gotoAbsCartSens::set_sensorMove(sensorMove * sensorMoveIn)
{ a_sensorMove = sensorMoveIn; }

/********************************************************************/

gotoAbsPol::gotoAbsPol(){}

gotoAbsPol::gotoAbsPol(
  polPoint * polPointIn)
{
  a_polPoint = polPointIn;
}

gotoAbsPol::~gotoAbsPol(){}

void gotoAbsPol::printSelf()
{
  a_polPoint->printSelf();
}

polPoint * gotoAbsPol::get_polPoint()
{ return a_polPoint; }
void gotoAbsPol::set_polPoint(polPoint * polPointIn)
{ a_polPoint = polPointIn; }

/********************************************************************/

gotoAbsPolSens::gotoAbsPolSens(){}

gotoAbsPolSens::gotoAbsPolSens(
  polPoint * polPointIn,
  sensorMove * sensorMoveIn)
{
  a_polPoint = polPointIn;
  a_sensorMove = sensorMoveIn;
}

gotoAbsPolSens::~gotoAbsPolSens(){}

void gotoAbsPolSens::printSelf()
{
  a_polPoint->printSelf();
  printf(",");
  a_sensorMove->printSelf();
}

polPoint * gotoAbsPolSens::get_polPoint()
{ return a_polPoint; }
void gotoAbsPolSens::set_polPoint(polPoint * polPointIn)
{ a_polPoint = polPointIn; }
sensorMove * gotoAbsPolSens::get_sensorMove()
{ return a_sensorMove; }
void gotoAbsPolSens::set_sensorMove(sensorMove * sensorMoveIn)
{ a_sensorMove = sensorMoveIn; }

/********************************************************************/

sensorMove::sensorMove(){};

sensorMove::~sensorMove(){}

/********************************************************************/

sensorMove_saLabel::sensorMove_saLabel(){}

sensorMove_saLabel::sensorMove_saLabel(
  saLabel * saLabelIn)
{
  a_saLabel = saLabelIn;
}

sensorMove_saLabel::~sensorMove_saLabel(){}

void sensorMove_saLabel::printSelf()
{
  a_saLabel->printSelf();
}

saLabel * sensorMove_saLabel::get_saLabel()
{ return a_saLabel; }
void sensorMove_saLabel::set_saLabel(saLabel * saLabelIn)
{ a_saLabel = saLabelIn; }

/********************************************************************/

sensorMove_gotoWristList::sensorMove_gotoWristList(){}

sensorMove_gotoWristList::sensorMove_gotoWristList(
  std::list<gotoWristItem *> * gotoWristListIn)
{
  a_gotoWristList = gotoWristListIn;
}

sensorMove_gotoWristList::~sensorMove_gotoWristList(){}

void sensorMove_gotoWristList::printSelf()
{
  if (a_gotoWristList->begin() == a_gotoWristList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<gotoWristItem *>::iterator iter;
      for (iter = a_gotoWristList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_gotoWristList->end())
            break;
          printf(",");
        }
    }
}

std::list<gotoWristItem *> * sensorMove_gotoWristList::get_gotoWristList()
{ return a_gotoWristList; }
void sensorMove_gotoWristList::set_gotoWristList(std::list<gotoWristItem *> * gotoWristListIn)
{ a_gotoWristList = gotoWristListIn; }

/********************************************************************/

sensorMove_probeOrient::sensorMove_probeOrient(){}

sensorMove_probeOrient::sensorMove_probeOrient(
  probeOrient * probeOrientIn)
{
  a_probeOrient = probeOrientIn;
}

sensorMove_probeOrient::~sensorMove_probeOrient(){}

void sensorMove_probeOrient::printSelf()
{
  a_probeOrient->printSelf();
}

probeOrient * sensorMove_probeOrient::get_probeOrient()
{ return a_probeOrient; }
void sensorMove_probeOrient::set_probeOrient(probeOrient * probeOrientIn)
{ a_probeOrient = probeOrientIn; }

/********************************************************************/

gotoRel::gotoRel(){}

gotoRel::gotoRel(
  rentVal * distIn,
  vector * dirIn)
{
  dist = distIn;
  dir = dirIn;
}

gotoRel::~gotoRel(){}

void gotoRel::printSelf()
{
  printf("INCR");
  printf(",");
  dist->printSelf();
  printf(",");
  dir->printSelf();
}

rentVal * gotoRel::get_dist()
{ return dist; }
void gotoRel::set_dist(rentVal * distIn)
{ dist = distIn; }
vector * gotoRel::get_dir()
{ return dir; }
void gotoRel::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

gotoArc::gotoArc(){}

gotoArc::gotoArc(
  impCartPoint * interIn,
  impCartPoint * endIn,
  probeOrient * probeOrientIn)
{
  inter = interIn;
  end = endIn;
  a_probeOrient = probeOrientIn;
}

gotoArc::~gotoArc(){}

void gotoArc::printSelf()
{
  printf("ARC");
  printf(",");
  inter->printSelf();
  printf(",");
  end->printSelf();
  if (a_probeOrient)
    {
      printf(",");
      a_probeOrient->printSelf();
    }
}

impCartPoint * gotoArc::get_inter()
{ return inter; }
void gotoArc::set_inter(impCartPoint * interIn)
{ inter = interIn; }
impCartPoint * gotoArc::get_end()
{ return end; }
void gotoArc::set_end(impCartPoint * endIn)
{ end = endIn; }
probeOrient * gotoArc::get_probeOrient()
{ return a_probeOrient; }
void gotoArc::set_probeOrient(probeOrient * probeOrientIn)
{ a_probeOrient = probeOrientIn; }

/********************************************************************/

probeOrient::probeOrient(){};

probeOrient::~probeOrient(){}

/********************************************************************/

probeOrient_featureLabel::probeOrient_featureLabel(){}

probeOrient_featureLabel::probeOrient_featureLabel(
  featureLabel * featureLabelIn,
  angle * angleIn)
{
  a_featureLabel = featureLabelIn;
  a_angle = angleIn;
}

probeOrient_featureLabel::~probeOrient_featureLabel(){}

void probeOrient_featureLabel::printSelf()
{
  a_featureLabel->printSelf();
  if (a_angle)
    {
      printf(",");
      printf("FZ");
      printf(",");
      a_angle->printSelf();
    }
}

featureLabel * probeOrient_featureLabel::get_featureLabel()
{ return a_featureLabel; }
void probeOrient_featureLabel::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
angle * probeOrient_featureLabel::get_angle()
{ return a_angle; }
void probeOrient_featureLabel::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

probeOrient_VEC::probeOrient_VEC(){}

probeOrient_VEC::probeOrient_VEC(
  vector * dirIn,
  angle * angleIn)
{
  dir = dirIn;
  a_angle = angleIn;
}

probeOrient_VEC::~probeOrient_VEC(){}

void probeOrient_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  dir->printSelf();
  if (a_angle)
    {
      printf(",");
      printf("FZ");
      printf(",");
      a_angle->printSelf();
    }
}

vector * probeOrient_VEC::get_dir()
{ return dir; }
void probeOrient_VEC::set_dir(vector * dirIn)
{ dir = dirIn; }
angle * probeOrient_VEC::get_angle()
{ return a_angle; }
void probeOrient_VEC::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

probeOrient_PCS::probeOrient_PCS(){}

probeOrient_PCS::probeOrient_PCS(
  euler * eulerIn)
{
  a_euler = eulerIn;
}

probeOrient_PCS::~probeOrient_PCS(){}

void probeOrient_PCS::printSelf()
{
  printf("PCS");
  printf(",");
  a_euler->printSelf();
}

euler * probeOrient_PCS::get_euler()
{ return a_euler; }
void probeOrient_PCS::set_euler(euler * eulerIn)
{ a_euler = eulerIn; }

/********************************************************************/

probeOrient_HEADCS::probeOrient_HEADCS(){}

probeOrient_HEADCS::probeOrient_HEADCS(
  rentVal * rot1In,
  rentVal * rot2In,
  rentVal * rot3In)
{
  rot1 = rot1In;
  rot2 = rot2In;
  rot3 = rot3In;
}

probeOrient_HEADCS::~probeOrient_HEADCS(){}

void probeOrient_HEADCS::printSelf()
{
  printf("HEADCS");
  printf(",");
  rot1->printSelf();
  printf(",");
  rot2->printSelf();
  if (rot3)
    {
      printf(",");
      rot3->printSelf();
    }
}

rentVal * probeOrient_HEADCS::get_rot1()
{ return rot1; }
void probeOrient_HEADCS::set_rot1(rentVal * rot1In)
{ rot1 = rot1In; }
rentVal * probeOrient_HEADCS::get_rot2()
{ return rot2; }
void probeOrient_HEADCS::set_rot2(rentVal * rot2In)
{ rot2 = rot2In; }
rentVal * probeOrient_HEADCS::get_rot3()
{ return rot3; }
void probeOrient_HEADCS::set_rot3(rentVal * rot3In)
{ rot3 = rot3In; }

/********************************************************************/

gotoWristItem::gotoWristItem(){}

gotoWristItem::gotoWristItem(
  swLabel * swLabelIn,
  std::list<gotoWristAngleItem *> * gotoWristAngleListIn)
{
  a_swLabel = swLabelIn;
  a_gotoWristAngleList = gotoWristAngleListIn;
}

gotoWristItem::~gotoWristItem(){}

void gotoWristItem::printSelf()
{
  a_swLabel->printSelf();
  printf(",");
  if (a_gotoWristAngleList->begin() == a_gotoWristAngleList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<gotoWristAngleItem *>::iterator iter;
      for (iter = a_gotoWristAngleList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_gotoWristAngleList->end())
            break;
          printf(",");
        }
    }
}

swLabel * gotoWristItem::get_swLabel()
{ return a_swLabel; }
void gotoWristItem::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
std::list<gotoWristAngleItem *> * gotoWristItem::get_gotoWristAngleList()
{ return a_gotoWristAngleList; }
void gotoWristItem::set_gotoWristAngleList(std::list<gotoWristAngleItem *> * gotoWristAngleListIn)
{ a_gotoWristAngleList = gotoWristAngleListIn; }

/********************************************************************/

gotoWristAngleItem::gotoWristAngleItem(){}

gotoWristAngleItem::gotoWristAngleItem(
  stringVal * anglenameIn,
  angle * angleIn)
{
  anglename = anglenameIn;
  a_angle = angleIn;
}

gotoWristAngleItem::~gotoWristAngleItem(){}

void gotoWristAngleItem::printSelf()
{
  anglename->printSelf();
  printf(",");
  a_angle->printSelf();
}

stringVal * gotoWristAngleItem::get_anglename()
{ return anglename; }
void gotoWristAngleItem::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }
angle * gotoWristAngleItem::get_angle()
{ return a_angle; }
void gotoWristAngleItem::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

groupStm::groupStm(){}

groupStm::groupStm(
  gsaLabel * gsaLabelIn,
  saLabel * saLabelIn,
  std::list<saLabel *> * saLabelListIn)
{
  a_gsaLabel = gsaLabelIn;
  a_saLabel = saLabelIn;
  a_saLabelList = saLabelListIn;
}

groupStm::~groupStm(){}

void groupStm::printSelf()
{
  a_gsaLabel->printSelf();
  printf("=");
  printf("GROUP");
  printf("/");
  a_saLabel->printSelf();
  printf(",");
  if (a_saLabelList->begin() == a_saLabelList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<saLabel *>::iterator iter;
      for (iter = a_saLabelList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_saLabelList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

gsaLabel * groupStm::get_gsaLabel()
{ return a_gsaLabel; }
void groupStm::set_gsaLabel(gsaLabel * gsaLabelIn)
{ a_gsaLabel = gsaLabelIn; }
saLabel * groupStm::get_saLabel()
{ return a_saLabel; }
void groupStm::set_saLabel(saLabel * saLabelIn)
{ a_saLabel = saLabelIn; }
std::list<saLabel *> * groupStm::get_saLabelList()
{ return a_saLabelList; }
void groupStm::set_saLabelList(std::list<saLabel *> * saLabelListIn)
{ a_saLabelList = saLabelListIn; }

/********************************************************************/

ifStm::ifStm(){}

ifStm::ifStm(
  boolVal * boolValIn)
{
  a_boolVal = boolValIn;
}

ifStm::~ifStm(){}

void ifStm::printSelf()
{
  printf("IF");
  printf("/");
  printf("(");
  a_boolVal->printSelf();
  printf(")");
  printf("%c%c", 13, 10);
}

boolVal * ifStm::get_boolVal()
{ return a_boolVal; }
void ifStm::set_boolVal(boolVal * boolValIn)
{ a_boolVal = boolValIn; }

/********************************************************************/

includMinor::includMinor(){};

includMinor::~includMinor(){}

/********************************************************************/

includDmis::includDmis(){}

includDmis::includDmis(
  stringConst * stringConstIn)
{
  a_stringConst = stringConstIn;
}

includDmis::~includDmis(){}

void includDmis::printSelf()
{
  printf("DMIS");
  printf(",");
  a_stringConst->printSelf();
}

stringConst * includDmis::get_stringConst()
{ return a_stringConst; }
void includDmis::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }

/********************************************************************/

includDme::includDme(){}

includDme::includDme(
  stringConst * stringConstIn)
{
  a_stringConst = stringConstIn;
}

includDme::~includDme(){}

void includDme::printSelf()
{
  printf("DME");
  printf(",");
  a_stringConst->printSelf();
}

stringConst * includDme::get_stringConst()
{ return a_stringConst; }
void includDme::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }

/********************************************************************/

iteratStm::iteratStm(){}

iteratStm::iteratStm(
  realVar * realVarIn,
  iteratMinor * iteratMinorIn)
{
  a_realVar = realVarIn;
  a_iteratMinor = iteratMinorIn;
}

iteratStm::~iteratStm(){}

void iteratStm::printSelf()
{
  a_realVar->printSelf();
  printf("=");
  printf("ITERAT");
  printf("/");
  a_iteratMinor->printSelf();
  printf("%c%c", 13, 10);
}

realVar * iteratStm::get_realVar()
{ return a_realVar; }
void iteratStm::set_realVar(realVar * realVarIn)
{ a_realVar = realVarIn; }
iteratMinor * iteratStm::get_iteratMinor()
{ return a_iteratMinor; }
void iteratStm::set_iteratMinor(iteratMinor * iteratMinorIn)
{ a_iteratMinor = iteratMinorIn; }

/********************************************************************/

iteratMinor::iteratMinor(){}

iteratMinor::iteratMinor(
  jumpLabel * startIn,
  jumpLabel * failIn,
  iteratConvergence * iteratConvergenceIn,
  intVal * limitIn,
  std::list<iteratCriterionItem *> * iteratCriterionListIn)
{
  start = startIn;
  fail = failIn;
  a_iteratConvergence = iteratConvergenceIn;
  limit = limitIn;
  a_iteratCriterionList = iteratCriterionListIn;
}

iteratMinor::~iteratMinor(){}

void iteratMinor::printSelf()
{
  start->printSelf();
  printf(",");
  fail->printSelf();
  printf(",");
  a_iteratConvergence->printSelf();
  printf(",");
  limit->printSelf();
  printf(",");
  if (a_iteratCriterionList->begin() == a_iteratCriterionList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<iteratCriterionItem *>::iterator iter;
      for (iter = a_iteratCriterionList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_iteratCriterionList->end())
            break;
          printf(",");
        }
    }
}

jumpLabel * iteratMinor::get_start()
{ return start; }
void iteratMinor::set_start(jumpLabel * startIn)
{ start = startIn; }
jumpLabel * iteratMinor::get_fail()
{ return fail; }
void iteratMinor::set_fail(jumpLabel * failIn)
{ fail = failIn; }
iteratConvergence * iteratMinor::get_iteratConvergence()
{ return a_iteratConvergence; }
void iteratMinor::set_iteratConvergence(iteratConvergence * iteratConvergenceIn)
{ a_iteratConvergence = iteratConvergenceIn; }
intVal * iteratMinor::get_limit()
{ return limit; }
void iteratMinor::set_limit(intVal * limitIn)
{ limit = limitIn; }
std::list<iteratCriterionItem *> * iteratMinor::get_iteratCriterionList()
{ return a_iteratCriterionList; }
void iteratMinor::set_iteratCriterionList(std::list<iteratCriterionItem *> * iteratCriterionListIn)
{ a_iteratCriterionList = iteratCriterionListIn; }

/********************************************************************/

iteratConvergence::iteratConvergence(){};

iteratConvergence::~iteratConvergence(){}

/********************************************************************/

iteratConvergence_ABSL::iteratConvergence_ABSL(){}

iteratConvergence_ABSL::iteratConvergence_ABSL(
  rentVal * convergIn)
{
  converg = convergIn;
}

iteratConvergence_ABSL::~iteratConvergence_ABSL(){}

void iteratConvergence_ABSL::printSelf()
{
  converg->printSelf();
  printf(",");
  printf("ABSL");
}

rentVal * iteratConvergence_ABSL::get_converg()
{ return converg; }
void iteratConvergence_ABSL::set_converg(rentVal * convergIn)
{ converg = convergIn; }

/********************************************************************/

iteratConvergence_INCR::iteratConvergence_INCR(){}

iteratConvergence_INCR::iteratConvergence_INCR(
  rentVal * convergIn)
{
  converg = convergIn;
}

iteratConvergence_INCR::~iteratConvergence_INCR(){}

void iteratConvergence_INCR::printSelf()
{
  converg->printSelf();
  printf(",");
  printf("INCR");
}

rentVal * iteratConvergence_INCR::get_converg()
{ return converg; }
void iteratConvergence_INCR::set_converg(rentVal * convergIn)
{ converg = convergIn; }

/********************************************************************/

iteratCriterionItem::iteratCriterionItem(){}

iteratCriterionItem::iteratCriterionItem(
  iteratCriterionStart * iteratCriterionStartIn,
  std::list<faLabel *> * featureActualListIn)
{
  a_iteratCriterionStart = iteratCriterionStartIn;
  a_featureActualList = featureActualListIn;
}

iteratCriterionItem::~iteratCriterionItem(){}

void iteratCriterionItem::printSelf()
{
  a_iteratCriterionStart->printSelf();
  printf(",");
  if (a_featureActualList->begin() == a_featureActualList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<faLabel *>::iterator iter;
      for (iter = a_featureActualList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_featureActualList->end())
            break;
          printf(",");
        }
    }
}

iteratCriterionStart * iteratCriterionItem::get_iteratCriterionStart()
{ return a_iteratCriterionStart; }
void iteratCriterionItem::set_iteratCriterionStart(iteratCriterionStart * iteratCriterionStartIn)
{ a_iteratCriterionStart = iteratCriterionStartIn; }
std::list<faLabel *> * iteratCriterionItem::get_featureActualList()
{ return a_featureActualList; }
void iteratCriterionItem::set_featureActualList(std::list<faLabel *> * featureActualListIn)
{ a_featureActualList = featureActualListIn; }

/********************************************************************/

iteratCriterionStart::iteratCriterionStart(){};

iteratCriterionStart::~iteratCriterionStart(){}

/********************************************************************/

iteratCriterionStart_axis::iteratCriterionStart_axis(){}

iteratCriterionStart_axis::iteratCriterionStart_axis(
  axis * axisIn)
{
  a_axis = axisIn;
}

iteratCriterionStart_axis::~iteratCriterionStart_axis(){}

void iteratCriterionStart_axis::printSelf()
{
  a_axis->printSelf();
}

axis * iteratCriterionStart_axis::get_axis()
{ return a_axis; }
void iteratCriterionStart_axis::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

iteratCriterionStart_vector::iteratCriterionStart_vector(){}

iteratCriterionStart_vector::iteratCriterionStart_vector(
  vector * dirIn)
{
  dir = dirIn;
}

iteratCriterionStart_vector::~iteratCriterionStart_vector(){}

void iteratCriterionStart_vector::printSelf()
{
  dir->printSelf();
}

vector * iteratCriterionStart_vector::get_dir()
{ return dir; }
void iteratCriterionStart_vector::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

iteratCriterionStart_NOM::iteratCriterionStart_NOM(){}

iteratCriterionStart_NOM::~iteratCriterionStart_NOM(){}

void iteratCriterionStart_NOM::printSelf()
{
  printf("NOM");
}

/********************************************************************/

keycharStm::keycharStm(){}

keycharStm::keycharStm(
  kcLabel * kcLabelIn,
  keycharMinor * keycharMinorIn)
{
  a_kcLabel = kcLabelIn;
  a_keycharMinor = keycharMinorIn;
}

keycharStm::~keycharStm(){}

void keycharStm::printSelf()
{
  a_kcLabel->printSelf();
  printf("=");
  printf("KEYCHAR");
  printf("/");
  a_keycharMinor->printSelf();
  printf("%c%c", 13, 10);
}

kcLabel * keycharStm::get_kcLabel()
{ return a_kcLabel; }
void keycharStm::set_kcLabel(kcLabel * kcLabelIn)
{ a_kcLabel = kcLabelIn; }
keycharMinor * keycharStm::get_keycharMinor()
{ return a_keycharMinor; }
void keycharStm::set_keycharMinor(keycharMinor * keycharMinorIn)
{ a_keycharMinor = keycharMinorIn; }

/********************************************************************/

keycharMinor::keycharMinor(){};

keycharMinor::~keycharMinor(){}

/********************************************************************/

keycharOneFeature::keycharOneFeature(){}

keycharOneFeature::keycharOneFeature(
  fLabel * fLabelIn,
  std::list<tLabel *> * tLabelListIn,
  criticality * criticalityIn)
{
  a_fLabel = fLabelIn;
  a_tLabelList = tLabelListIn;
  a_criticality = criticalityIn;
}

keycharOneFeature::~keycharOneFeature(){}

void keycharOneFeature::printSelf()
{
  a_fLabel->printSelf();
  printf(",");
  if (a_tLabelList->begin() == a_tLabelList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<tLabel *>::iterator iter;
      for (iter = a_tLabelList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_tLabelList->end())
            break;
          printf(",");
        }
    }
  if (a_criticality)
    {
      printf(",");
      a_criticality->printSelf();
    }
}

fLabel * keycharOneFeature::get_fLabel()
{ return a_fLabel; }
void keycharOneFeature::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
std::list<tLabel *> * keycharOneFeature::get_tLabelList()
{ return a_tLabelList; }
void keycharOneFeature::set_tLabelList(std::list<tLabel *> * tLabelListIn)
{ a_tLabelList = tLabelListIn; }
criticality * keycharOneFeature::get_criticality()
{ return a_criticality; }
void keycharOneFeature::set_criticality(criticality * criticalityIn)
{ a_criticality = criticalityIn; }

/********************************************************************/

keycharTwoFeatures::keycharTwoFeatures(){}

keycharTwoFeatures::keycharTwoFeatures(
  fLabel * feat1In,
  fLabel * feat2In,
  tLabel * tLabelIn,
  criticality * criticalityIn)
{
  feat1 = feat1In;
  feat2 = feat2In;
  a_tLabel = tLabelIn;
  a_criticality = criticalityIn;
}

keycharTwoFeatures::~keycharTwoFeatures(){}

void keycharTwoFeatures::printSelf()
{
  feat1->printSelf();
  printf(",");
  feat2->printSelf();
  printf(",");
  a_tLabel->printSelf();
  if (a_criticality)
    {
      printf(",");
      a_criticality->printSelf();
    }
}

fLabel * keycharTwoFeatures::get_feat1()
{ return feat1; }
void keycharTwoFeatures::set_feat1(fLabel * feat1In)
{ feat1 = feat1In; }
fLabel * keycharTwoFeatures::get_feat2()
{ return feat2; }
void keycharTwoFeatures::set_feat2(fLabel * feat2In)
{ feat2 = feat2In; }
tLabel * keycharTwoFeatures::get_tLabel()
{ return a_tLabel; }
void keycharTwoFeatures::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
criticality * keycharTwoFeatures::get_criticality()
{ return a_criticality; }
void keycharTwoFeatures::set_criticality(criticality * criticalityIn)
{ a_criticality = criticalityIn; }

/********************************************************************/

criticality::criticality(){};

criticality::~criticality(){}

/********************************************************************/

criticality_CRITICAL::criticality_CRITICAL(){}

criticality_CRITICAL::~criticality_CRITICAL(){}

void criticality_CRITICAL::printSelf()
{
  printf("CRITICAL");
}

/********************************************************************/

criticality_MAJOR::criticality_MAJOR(){}

criticality_MAJOR::~criticality_MAJOR(){}

void criticality_MAJOR::printSelf()
{
  printf("MAJOR");
}

/********************************************************************/

criticality_MINOR::criticality_MINOR(){}

criticality_MINOR::~criticality_MINOR(){}

void criticality_MINOR::printSelf()
{
  printf("MINOR");
}

/********************************************************************/

litdefStm::litdefStm(){}

litdefStm::litdefStm(
  vlLabel * vlLabelIn,
  litdefMinor * litdefMinorIn)
{
  a_vlLabel = vlLabelIn;
  a_litdefMinor = litdefMinorIn;
}

litdefStm::~litdefStm(){}

void litdefStm::printSelf()
{
  a_vlLabel->printSelf();
  printf("=");
  printf("LITDEF");
  printf("/");
  a_litdefMinor->printSelf();
  printf("%c%c", 13, 10);
}

vlLabel * litdefStm::get_vlLabel()
{ return a_vlLabel; }
void litdefStm::set_vlLabel(vlLabel * vlLabelIn)
{ a_vlLabel = vlLabelIn; }
litdefMinor * litdefStm::get_litdefMinor()
{ return a_litdefMinor; }
void litdefStm::set_litdefMinor(litdefMinor * litdefMinorIn)
{ a_litdefMinor = litdefMinorIn; }

/********************************************************************/

litdefMinor::litdefMinor(){};

litdefMinor::~litdefMinor(){}

/********************************************************************/

litdefLight::litdefLight(){}

litdefLight::litdefLight(
  litdefLightType * litdefLightTypeIn,
  vector * axisIn)
{
  a_litdefLightType = litdefLightTypeIn;
  axis = axisIn;
}

litdefLight::~litdefLight(){}

void litdefLight::printSelf()
{
  a_litdefLightType->printSelf();
  printf(",");
  axis->printSelf();
}

litdefLightType * litdefLight::get_litdefLightType()
{ return a_litdefLightType; }
void litdefLight::set_litdefLightType(litdefLightType * litdefLightTypeIn)
{ a_litdefLightType = litdefLightTypeIn; }
vector * litdefLight::get_axis()
{ return axis; }
void litdefLight::set_axis(vector * axisIn)
{ axis = axisIn; }

/********************************************************************/

litdefLightType::litdefLightType(){};

litdefLightType::~litdefLightType(){}

/********************************************************************/

litdefLightType_SURF::litdefLightType_SURF(){}

litdefLightType_SURF::~litdefLightType_SURF(){}

void litdefLightType_SURF::printSelf()
{
  printf("SURF");
}

/********************************************************************/

litdefLightType_BACK::litdefLightType_BACK(){}

litdefLightType_BACK::~litdefLightType_BACK(){}

void litdefLightType_BACK::printSelf()
{
  printf("BACK");
}

/********************************************************************/

litdefLightType_GRID::litdefLightType_GRID(){}

litdefLightType_GRID::~litdefLightType_GRID(){}

void litdefLightType_GRID::printSelf()
{
  printf("GRID");
}

/********************************************************************/

litdefLightType_OBLQ::litdefLightType_OBLQ(){}

litdefLightType_OBLQ::~litdefLightType_OBLQ(){}

void litdefLightType_OBLQ::printSelf()
{
  printf("OBLQ");
}

/********************************************************************/

litdefStrobe::litdefStrobe(){}

litdefStrobe::litdefStrobe(
  litdefStrobeType * litdefStrobeTypeIn,
  rentVal * timeonIn,
  vector * axisIn)
{
  a_litdefStrobeType = litdefStrobeTypeIn;
  timeon = timeonIn;
  axis = axisIn;
}

litdefStrobe::~litdefStrobe(){}

void litdefStrobe::printSelf()
{
  printf("STROBE");
  printf(",");
  a_litdefStrobeType->printSelf();
  printf(",");
  timeon->printSelf();
  printf(",");
  axis->printSelf();
}

litdefStrobeType * litdefStrobe::get_litdefStrobeType()
{ return a_litdefStrobeType; }
void litdefStrobe::set_litdefStrobeType(litdefStrobeType * litdefStrobeTypeIn)
{ a_litdefStrobeType = litdefStrobeTypeIn; }
rentVal * litdefStrobe::get_timeon()
{ return timeon; }
void litdefStrobe::set_timeon(rentVal * timeonIn)
{ timeon = timeonIn; }
vector * litdefStrobe::get_axis()
{ return axis; }
void litdefStrobe::set_axis(vector * axisIn)
{ axis = axisIn; }

/********************************************************************/

litdefStrobeType::litdefStrobeType(){};

litdefStrobeType::~litdefStrobeType(){}

/********************************************************************/

litdefStrobeType_CYCLE::litdefStrobeType_CYCLE(){}

litdefStrobeType_CYCLE::litdefStrobeType_CYCLE(
  rentVal * valueIn)
{
  value = valueIn;
}

litdefStrobeType_CYCLE::~litdefStrobeType_CYCLE(){}

void litdefStrobeType_CYCLE::printSelf()
{
  printf("CYCLE");
  printf(",");
  value->printSelf();
}

rentVal * litdefStrobeType_CYCLE::get_value()
{ return value; }
void litdefStrobeType_CYCLE::set_value(rentVal * valueIn)
{ value = valueIn; }

/********************************************************************/

litdefStrobeType_TRIGER::litdefStrobeType_TRIGER(){}

litdefStrobeType_TRIGER::~litdefStrobeType_TRIGER(){}

void litdefStrobeType_TRIGER::printSelf()
{
  printf("TRIGER");
}

/********************************************************************/

locateStm::locateStm(){}

locateStm::locateStm(
  dLabel * dLabelIn,
  locateTransAllowed * locateTransAllowedIn,
  locateRotAllowed * locateRotAllowedIn,
  std::list<locateLabel *> * locateLabelListIn)
{
  a_dLabel = dLabelIn;
  a_locateTransAllowed = locateTransAllowedIn;
  a_locateRotAllowed = locateRotAllowedIn;
  a_locateLabelList = locateLabelListIn;
}

locateStm::~locateStm(){}

void locateStm::printSelf()
{
  a_dLabel->printSelf();
  printf("=");
  printf("LOCATE");
  printf("/");
  if (a_locateTransAllowed)
    {
      a_locateTransAllowed->printSelf();
      printf(",");
    }
  if (a_locateRotAllowed)
    {
      a_locateRotAllowed->printSelf();
      printf(",");
    }
  if (a_locateLabelList->begin() == a_locateLabelList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<locateLabel *>::iterator iter;
      for (iter = a_locateLabelList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_locateLabelList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

dLabel * locateStm::get_dLabel()
{ return a_dLabel; }
void locateStm::set_dLabel(dLabel * dLabelIn)
{ a_dLabel = dLabelIn; }
locateTransAllowed * locateStm::get_locateTransAllowed()
{ return a_locateTransAllowed; }
void locateStm::set_locateTransAllowed(locateTransAllowed * locateTransAllowedIn)
{ a_locateTransAllowed = locateTransAllowedIn; }
locateRotAllowed * locateStm::get_locateRotAllowed()
{ return a_locateRotAllowed; }
void locateStm::set_locateRotAllowed(locateRotAllowed * locateRotAllowedIn)
{ a_locateRotAllowed = locateRotAllowedIn; }
std::list<locateLabel *> * locateStm::get_locateLabelList()
{ return a_locateLabelList; }
void locateStm::set_locateLabelList(std::list<locateLabel *> * locateLabelListIn)
{ a_locateLabelList = locateLabelListIn; }

/********************************************************************/

locateTransAllowed::locateTransAllowed(){};

locateTransAllowed::~locateTransAllowed(){}

/********************************************************************/

locateTransAllowed_XDIR::locateTransAllowed_XDIR(){}

locateTransAllowed_XDIR::~locateTransAllowed_XDIR(){}

void locateTransAllowed_XDIR::printSelf()
{
  printf("XDIR");
}

/********************************************************************/

locateTransAllowed_YDIR::locateTransAllowed_YDIR(){}

locateTransAllowed_YDIR::~locateTransAllowed_YDIR(){}

void locateTransAllowed_YDIR::printSelf()
{
  printf("YDIR");
}

/********************************************************************/

locateTransAllowed_ZDIR::locateTransAllowed_ZDIR(){}

locateTransAllowed_ZDIR::~locateTransAllowed_ZDIR(){}

void locateTransAllowed_ZDIR::printSelf()
{
  printf("ZDIR");
}

/********************************************************************/

locateTransAllowed_XYDIR::locateTransAllowed_XYDIR(){}

locateTransAllowed_XYDIR::~locateTransAllowed_XYDIR(){}

void locateTransAllowed_XYDIR::printSelf()
{
  printf("XYDIR");
}

/********************************************************************/

locateTransAllowed_YZDIR::locateTransAllowed_YZDIR(){}

locateTransAllowed_YZDIR::~locateTransAllowed_YZDIR(){}

void locateTransAllowed_YZDIR::printSelf()
{
  printf("YZDIR");
}

/********************************************************************/

locateTransAllowed_ZXDIR::locateTransAllowed_ZXDIR(){}

locateTransAllowed_ZXDIR::~locateTransAllowed_ZXDIR(){}

void locateTransAllowed_ZXDIR::printSelf()
{
  printf("ZXDIR");
}

/********************************************************************/

locateTransAllowed_XYZDIR::locateTransAllowed_XYZDIR(){}

locateTransAllowed_XYZDIR::~locateTransAllowed_XYZDIR(){}

void locateTransAllowed_XYZDIR::printSelf()
{
  printf("XYZDIR");
}

/********************************************************************/

locateTransAllowed_NOTRAN::locateTransAllowed_NOTRAN(){}

locateTransAllowed_NOTRAN::~locateTransAllowed_NOTRAN(){}

void locateTransAllowed_NOTRAN::printSelf()
{
  printf("NOTRAN");
}

/********************************************************************/

locateRotAllowed::locateRotAllowed(){};

locateRotAllowed::~locateRotAllowed(){}

/********************************************************************/

locateRotAllowed_XAXIS::locateRotAllowed_XAXIS(){}

locateRotAllowed_XAXIS::~locateRotAllowed_XAXIS(){}

void locateRotAllowed_XAXIS::printSelf()
{
  printf("XAXIS");
}

/********************************************************************/

locateRotAllowed_YAXIS::locateRotAllowed_YAXIS(){}

locateRotAllowed_YAXIS::~locateRotAllowed_YAXIS(){}

void locateRotAllowed_YAXIS::printSelf()
{
  printf("YAXIS");
}

/********************************************************************/

locateRotAllowed_ZAXIS::locateRotAllowed_ZAXIS(){}

locateRotAllowed_ZAXIS::~locateRotAllowed_ZAXIS(){}

void locateRotAllowed_ZAXIS::printSelf()
{
  printf("ZAXIS");
}

/********************************************************************/

locateRotAllowed_XYAXIS::locateRotAllowed_XYAXIS(){}

locateRotAllowed_XYAXIS::~locateRotAllowed_XYAXIS(){}

void locateRotAllowed_XYAXIS::printSelf()
{
  printf("XYAXIS");
}

/********************************************************************/

locateRotAllowed_YZAXIS::locateRotAllowed_YZAXIS(){}

locateRotAllowed_YZAXIS::~locateRotAllowed_YZAXIS(){}

void locateRotAllowed_YZAXIS::printSelf()
{
  printf("YZAXIS");
}

/********************************************************************/

locateRotAllowed_ZXAXIS::locateRotAllowed_ZXAXIS(){}

locateRotAllowed_ZXAXIS::~locateRotAllowed_ZXAXIS(){}

void locateRotAllowed_ZXAXIS::printSelf()
{
  printf("ZXAXIS");
}

/********************************************************************/

locateRotAllowed_XYZAXI::locateRotAllowed_XYZAXI(){}

locateRotAllowed_XYZAXI::~locateRotAllowed_XYZAXI(){}

void locateRotAllowed_XYZAXI::printSelf()
{
  printf("XYZAXI");
}

/********************************************************************/

locateRotAllowed_NOROT::locateRotAllowed_NOROT(){}

locateRotAllowed_NOROT::~locateRotAllowed_NOROT(){}

void locateRotAllowed_NOROT::printSelf()
{
  printf("NOROT");
}

/********************************************************************/

locateLabel::locateLabel(){};

locateLabel::~locateLabel(){}

/********************************************************************/

lotidStm::lotidStm(){}

lotidStm::lotidStm(
  liLabel * liLabelIn,
  stringVal * textIn)
{
  a_liLabel = liLabelIn;
  text = textIn;
}

lotidStm::~lotidStm(){}

void lotidStm::printSelf()
{
  a_liLabel->printSelf();
  printf("=");
  printf("LOTID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

liLabel * lotidStm::get_liLabel()
{ return a_liLabel; }
void lotidStm::set_liLabel(liLabel * liLabelIn)
{ a_liLabel = liLabelIn; }
stringVal * lotidStm::get_text()
{ return text; }
void lotidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

macroStm::macroStm(){}

macroStm::macroStm(
  mLabelConst * mLabelConstIn,
  std::list<macroPar *> * macroParListIn)
{
  a_mLabelConst = mLabelConstIn;
  a_macroParList = macroParListIn;
}

macroStm::~macroStm(){}

void macroStm::printSelf()
{
  a_mLabelConst->printSelf();
  printf("=");
  printf("MACRO");
  if (a_macroParList)
    {
      printf("/");
      if (a_macroParList->begin() == a_macroParList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<macroPar *>::iterator iter;
          for (iter = a_macroParList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_macroParList->end())
                break;
              printf(",");
            }
        }
    }
  printf("%c%c", 13, 10);
}

mLabelConst * macroStm::get_mLabelConst()
{ return a_mLabelConst; }
void macroStm::set_mLabelConst(mLabelConst * mLabelConstIn)
{ a_mLabelConst = mLabelConstIn; }
std::list<macroPar *> * macroStm::get_macroParList()
{ return a_macroParList; }
void macroStm::set_macroParList(std::list<macroPar *> * macroParListIn)
{ a_macroParList = macroParListIn; }

/********************************************************************/

macroPar::macroPar(){};

macroPar::~macroPar(){}

/********************************************************************/

macroPar_MACROVARNAME::macroPar_MACROVARNAME(){}

macroPar_MACROVARNAME::macroPar_MACROVARNAME(
  char * stringIn)
{
  a_string = stringIn;
}

macroPar_MACROVARNAME::~macroPar_MACROVARNAME(){}

void macroPar_MACROVARNAME::printSelf()
{
  printf("%s", a_string);
}

char * macroPar_MACROVARNAME::get_string()
{ return a_string; }
void macroPar_MACROVARNAME::set_string(char * stringIn)
{ a_string = stringIn; }

/********************************************************************/

macroPar_stringConst::macroPar_stringConst(){}

macroPar_stringConst::macroPar_stringConst(
  stringConst * stringConstIn)
{
  a_stringConst = stringConstIn;
}

macroPar_stringConst::~macroPar_stringConst(){}

void macroPar_stringConst::printSelf()
{
  a_stringConst->printSelf();
}

stringConst * macroPar_stringConst::get_stringConst()
{ return a_stringConst; }
void macroPar_stringConst::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }

/********************************************************************/

matdefStm::matdefStm(){}

matdefStm::matdefStm(
  maLabel * maLabelIn,
  matdefMinor * matdefMinorIn)
{
  a_maLabel = maLabelIn;
  a_matdefMinor = matdefMinorIn;
}

matdefStm::~matdefStm(){}

void matdefStm::printSelf()
{
  a_maLabel->printSelf();
  printf("=");
  printf("MATDEF");
  printf("/");
  a_matdefMinor->printSelf();
  printf("%c%c", 13, 10);
}

maLabel * matdefStm::get_maLabel()
{ return a_maLabel; }
void matdefStm::set_maLabel(maLabel * maLabelIn)
{ a_maLabel = maLabelIn; }
matdefMinor * matdefStm::get_matdefMinor()
{ return a_matdefMinor; }
void matdefStm::set_matdefMinor(matdefMinor * matdefMinorIn)
{ a_matdefMinor = matdefMinorIn; }

/********************************************************************/

matdefMinor::matdefMinor(){};

matdefMinor::~matdefMinor(){}

/********************************************************************/

matdefFeat::matdefFeat(){}

matdefFeat::matdefFeat(
  fLabel * fLabelIn,
  matdefSpec * matdefSpecIn)
{
  a_fLabel = fLabelIn;
  a_matdefSpec = matdefSpecIn;
}

matdefFeat::~matdefFeat(){}

void matdefFeat::printSelf()
{
  a_fLabel->printSelf();
  printf(",");
  a_matdefSpec->printSelf();
}

fLabel * matdefFeat::get_fLabel()
{ return a_fLabel; }
void matdefFeat::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
matdefSpec * matdefFeat::get_matdefSpec()
{ return a_matdefSpec; }
void matdefFeat::set_matdefSpec(matdefSpec * matdefSpecIn)
{ a_matdefSpec = matdefSpecIn; }

/********************************************************************/

matdefGeom::matdefGeom(){}

matdefGeom::matdefGeom(
  gLabel * gLabelIn,
  matdefSpec * matdefSpecIn)
{
  a_gLabel = gLabelIn;
  a_matdefSpec = matdefSpecIn;
}

matdefGeom::~matdefGeom(){}

void matdefGeom::printSelf()
{
  a_gLabel->printSelf();
  printf(",");
  a_matdefSpec->printSelf();
}

gLabel * matdefGeom::get_gLabel()
{ return a_gLabel; }
void matdefGeom::set_gLabel(gLabel * gLabelIn)
{ a_gLabel = gLabelIn; }
matdefSpec * matdefGeom::get_matdefSpec()
{ return a_matdefSpec; }
void matdefGeom::set_matdefSpec(matdefSpec * matdefSpecIn)
{ a_matdefSpec = matdefSpecIn; }

/********************************************************************/

matdefSpec::matdefSpec(){}

matdefSpec::matdefSpec(
  std::list<faLabel *> * faLabelListIn,
  matdefType * matdefTypeIn)
{
  a_faLabelList = faLabelListIn;
  a_matdefType = matdefTypeIn;
}

matdefSpec::~matdefSpec(){}

void matdefSpec::printSelf()
{
  if (a_faLabelList->begin() == a_faLabelList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<faLabel *>::iterator iter;
      for (iter = a_faLabelList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_faLabelList->end())
            break;
          printf(",");
        }
    }
  if (a_matdefType)
    {
      printf(",");
      a_matdefType->printSelf();
    }
}

std::list<faLabel *> * matdefSpec::get_faLabelList()
{ return a_faLabelList; }
void matdefSpec::set_faLabelList(std::list<faLabel *> * faLabelListIn)
{ a_faLabelList = faLabelListIn; }
matdefType * matdefSpec::get_matdefType()
{ return a_matdefType; }
void matdefSpec::set_matdefType(matdefType * matdefTypeIn)
{ a_matdefType = matdefTypeIn; }

/********************************************************************/

matdefType::matdefType(){};

matdefType::~matdefType(){}

/********************************************************************/

matdefTypeZone::matdefTypeZone(){}

matdefTypeZone::matdefTypeZone(
  matdefMating * matdefMatingIn,
  matdefMethod * matdefMethodIn,
  rentVal * fitzonIn,
  matdefMat * matdefMatIn)
{
  a_matdefMating = matdefMatingIn;
  a_matdefMethod = matdefMethodIn;
  fitzon = fitzonIn;
  a_matdefMat = matdefMatIn;
}

matdefTypeZone::~matdefTypeZone(){}

void matdefTypeZone::printSelf()
{
  a_matdefMating->printSelf();
  printf(",");
  a_matdefMethod->printSelf();
  printf(",");
  fitzon->printSelf();
  if (a_matdefMat)
    {
      printf(",");
      a_matdefMat->printSelf();
    }
}

matdefMating * matdefTypeZone::get_matdefMating()
{ return a_matdefMating; }
void matdefTypeZone::set_matdefMating(matdefMating * matdefMatingIn)
{ a_matdefMating = matdefMatingIn; }
matdefMethod * matdefTypeZone::get_matdefMethod()
{ return a_matdefMethod; }
void matdefTypeZone::set_matdefMethod(matdefMethod * matdefMethodIn)
{ a_matdefMethod = matdefMethodIn; }
rentVal * matdefTypeZone::get_fitzon()
{ return fitzon; }
void matdefTypeZone::set_fitzon(rentVal * fitzonIn)
{ fitzon = fitzonIn; }
matdefMat * matdefTypeZone::get_matdefMat()
{ return a_matdefMat; }
void matdefTypeZone::set_matdefMat(matdefMat * matdefMatIn)
{ a_matdefMat = matdefMatIn; }

/********************************************************************/

matdefTypeBand::matdefTypeBand(){}

matdefTypeBand::matdefTypeBand(
  matdefMating * matdefMatingIn,
  matdefMethod * matdefMethodIn,
  rentVal * lobandIn,
  rentVal * upbandIn,
  matdefMat * matdefMatIn)
{
  a_matdefMating = matdefMatingIn;
  a_matdefMethod = matdefMethodIn;
  loband = lobandIn;
  upband = upbandIn;
  a_matdefMat = matdefMatIn;
}

matdefTypeBand::~matdefTypeBand(){}

void matdefTypeBand::printSelf()
{
  a_matdefMating->printSelf();
  printf(",");
  a_matdefMethod->printSelf();
  printf(",");
  loband->printSelf();
  printf(",");
  upband->printSelf();
  if (a_matdefMat)
    {
      printf(",");
      a_matdefMat->printSelf();
    }
}

matdefMating * matdefTypeBand::get_matdefMating()
{ return a_matdefMating; }
void matdefTypeBand::set_matdefMating(matdefMating * matdefMatingIn)
{ a_matdefMating = matdefMatingIn; }
matdefMethod * matdefTypeBand::get_matdefMethod()
{ return a_matdefMethod; }
void matdefTypeBand::set_matdefMethod(matdefMethod * matdefMethodIn)
{ a_matdefMethod = matdefMethodIn; }
rentVal * matdefTypeBand::get_loband()
{ return loband; }
void matdefTypeBand::set_loband(rentVal * lobandIn)
{ loband = lobandIn; }
rentVal * matdefTypeBand::get_upband()
{ return upband; }
void matdefTypeBand::set_upband(rentVal * upbandIn)
{ upband = upbandIn; }
matdefMat * matdefTypeBand::get_matdefMat()
{ return a_matdefMat; }
void matdefTypeBand::set_matdefMat(matdefMat * matdefMatIn)
{ a_matdefMat = matdefMatIn; }

/********************************************************************/

matdefMating::matdefMating(){};

matdefMating::~matdefMating(){}

/********************************************************************/

matdefMating_PT2PT::matdefMating_PT2PT(){}

matdefMating_PT2PT::~matdefMating_PT2PT(){}

void matdefMating_PT2PT::printSelf()
{
  printf("PT2PT");
}

/********************************************************************/

matdefMating_PT2LN::matdefMating_PT2LN(){}

matdefMating_PT2LN::~matdefMating_PT2LN(){}

void matdefMating_PT2LN::printSelf()
{
  printf("PT2LN");
}

/********************************************************************/

matdefMating_PT2PL::matdefMating_PT2PL(){}

matdefMating_PT2PL::~matdefMating_PT2PL(){}

void matdefMating_PT2PL::printSelf()
{
  printf("PT2PL");
}

/********************************************************************/

matdefMating_LN2LN::matdefMating_LN2LN(){}

matdefMating_LN2LN::~matdefMating_LN2LN(){}

void matdefMating_LN2LN::printSelf()
{
  printf("LN2LN");
}

/********************************************************************/

matdefMethod::matdefMethod(){};

matdefMethod::~matdefMethod(){}

/********************************************************************/

matdefMethod_BF::matdefMethod_BF(){}

matdefMethod_BF::~matdefMethod_BF(){}

void matdefMethod_BF::printSelf()
{
  printf("BF");
}

/********************************************************************/

matdefMethod_FZ::matdefMethod_FZ(){}

matdefMethod_FZ::~matdefMethod_FZ(){}

void matdefMethod_FZ::printSelf()
{
  printf("FZ");
}

/********************************************************************/

matdefMat::matdefMat(){};

matdefMat::~matdefMat(){}

/********************************************************************/

matdefMat_MMC::matdefMat_MMC(){}

matdefMat_MMC::matdefMat_MMC(
  tLabel * tLabelIn)
{
  a_tLabel = tLabelIn;
}

matdefMat_MMC::~matdefMat_MMC(){}

void matdefMat_MMC::printSelf()
{
  printf("MMC");
  printf(",");
  a_tLabel->printSelf();
}

tLabel * matdefMat_MMC::get_tLabel()
{ return a_tLabel; }
void matdefMat_MMC::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }

/********************************************************************/

matdefMat_LMC::matdefMat_LMC(){}

matdefMat_LMC::matdefMat_LMC(
  tLabel * tLabelIn)
{
  a_tLabel = tLabelIn;
}

matdefMat_LMC::~matdefMat_LMC(){}

void matdefMat_LMC::printSelf()
{
  printf("LMC");
  printf(",");
  a_tLabel->printSelf();
}

tLabel * matdefMat_LMC::get_tLabel()
{ return a_tLabel; }
void matdefMat_LMC::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }

/********************************************************************/

measStm::measStm(){}

measStm::measStm(
  measMinor * measMinorIn,
  fLabel * fLabelIn,
  intVal * numMeasIn)
{
  a_measMinor = measMinorIn;
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
}

measStm::~measStm(){}

void measStm::printSelf()
{
  printf("MEAS");
  printf("/");
  a_measMinor->printSelf();
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf("%c%c", 13, 10);
}

measMinor * measStm::get_measMinor()
{ return a_measMinor; }
void measStm::set_measMinor(measMinor * measMinorIn)
{ a_measMinor = measMinorIn; }
fLabel * measStm::get_fLabel()
{ return a_fLabel; }
void measStm::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * measStm::get_numMeas()
{ return numMeas; }
void measStm::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }

/********************************************************************/

measMinor::measMinor(){};

measMinor::~measMinor(){}

/********************************************************************/

measMinorOther::measMinorOther(){}

measMinorOther::measMinorOther(
  measGeotype * measGeotypeIn)
{
  a_measGeotype = measGeotypeIn;
}

measMinorOther::~measMinorOther(){}

void measMinorOther::printSelf()
{
  a_measGeotype->printSelf();
  printf(",");
}

measGeotype * measMinorOther::get_measGeotype()
{ return a_measGeotype; }
void measMinorOther::set_measGeotype(measGeotype * measGeotypeIn)
{ a_measGeotype = measGeotypeIn; }

/********************************************************************/

measMinorPoint::measMinorPoint(){}

measMinorPoint::~measMinorPoint(){}

void measMinorPoint::printSelf()
{
  printf("POINT");
  printf(",");
}

/********************************************************************/

measMinorComp::measMinorComp(){}

measMinorComp::measMinorComp(
  measVar2 * measVar2In)
{
  a_measVar2 = measVar2In;
}

measMinorComp::~measMinorComp(){}

void measMinorComp::printSelf()
{
  printf("POINT");
  printf(",");
  printf("COMP");
  printf(",");
  a_measVar2->printSelf();
  printf(",");
}

measVar2 * measMinorComp::get_measVar2()
{ return a_measVar2; }
void measMinorComp::set_measVar2(measVar2 * measVar2In)
{ a_measVar2 = measVar2In; }

/********************************************************************/

measGeotype::measGeotype(){};

measGeotype::~measGeotype(){}

/********************************************************************/

measGeotype_ARC::measGeotype_ARC(){}

measGeotype_ARC::~measGeotype_ARC(){}

void measGeotype_ARC::printSelf()
{
  printf("ARC");
}

/********************************************************************/

measGeotype_CIRCLE::measGeotype_CIRCLE(){}

measGeotype_CIRCLE::~measGeotype_CIRCLE(){}

void measGeotype_CIRCLE::printSelf()
{
  printf("CIRCLE");
}

/********************************************************************/

measGeotype_CONE::measGeotype_CONE(){}

measGeotype_CONE::~measGeotype_CONE(){}

void measGeotype_CONE::printSelf()
{
  printf("CONE");
}

/********************************************************************/

measGeotype_CONRADSEGMNT::measGeotype_CONRADSEGMNT(){}

measGeotype_CONRADSEGMNT::~measGeotype_CONRADSEGMNT(){}

void measGeotype_CONRADSEGMNT::printSelf()
{
  printf("CONRADSEGMNT");
}

/********************************************************************/

measGeotype_CPARLN::measGeotype_CPARLN(){}

measGeotype_CPARLN::~measGeotype_CPARLN(){}

void measGeotype_CPARLN::printSelf()
{
  printf("CPARLN");
}

/********************************************************************/

measGeotype_CYLNDR::measGeotype_CYLNDR(){}

measGeotype_CYLNDR::~measGeotype_CYLNDR(){}

void measGeotype_CYLNDR::printSelf()
{
  printf("CYLNDR");
}

/********************************************************************/

measGeotype_CYLRADSEGMNT::measGeotype_CYLRADSEGMNT(){}

measGeotype_CYLRADSEGMNT::~measGeotype_CYLRADSEGMNT(){}

void measGeotype_CYLRADSEGMNT::printSelf()
{
  printf("CYLRADSEGMNT");
}

/********************************************************************/

measGeotype_EDGEPT::measGeotype_EDGEPT(){}

measGeotype_EDGEPT::~measGeotype_EDGEPT(){}

void measGeotype_EDGEPT::printSelf()
{
  printf("EDGEPT");
}

/********************************************************************/

measGeotype_ELLIPS::measGeotype_ELLIPS(){}

measGeotype_ELLIPS::~measGeotype_ELLIPS(){}

void measGeotype_ELLIPS::printSelf()
{
  printf("ELLIPS");
}

/********************************************************************/

measGeotype_ELONGCYL::measGeotype_ELONGCYL(){}

measGeotype_ELONGCYL::~measGeotype_ELONGCYL(){}

void measGeotype_ELONGCYL::printSelf()
{
  printf("ELONGCYL");
}

/********************************************************************/

measGeotype_GCURVE::measGeotype_GCURVE(){}

measGeotype_GCURVE::~measGeotype_GCURVE(){}

void measGeotype_GCURVE::printSelf()
{
  printf("GCURVE");
}

/********************************************************************/

measGeotype_GSURF::measGeotype_GSURF(){}

measGeotype_GSURF::~measGeotype_GSURF(){}

void measGeotype_GSURF::printSelf()
{
  printf("GSURF");
}

/********************************************************************/

measGeotype_LINE::measGeotype_LINE(){}

measGeotype_LINE::~measGeotype_LINE(){}

void measGeotype_LINE::printSelf()
{
  printf("LINE");
}

/********************************************************************/

measGeotype_OBJECT::measGeotype_OBJECT(){}

measGeotype_OBJECT::~measGeotype_OBJECT(){}

void measGeotype_OBJECT::printSelf()
{
  printf("OBJECT");
}

/********************************************************************/

measGeotype_PARPLN::measGeotype_PARPLN(){}

measGeotype_PARPLN::~measGeotype_PARPLN(){}

void measGeotype_PARPLN::printSelf()
{
  printf("PARPLN");
}

/********************************************************************/

measGeotype_PLANE::measGeotype_PLANE(){}

measGeotype_PLANE::~measGeotype_PLANE(){}

void measGeotype_PLANE::printSelf()
{
  printf("PLANE");
}

/********************************************************************/

measGeotype_REVSURF::measGeotype_REVSURF(){}

measGeotype_REVSURF::~measGeotype_REVSURF(){}

void measGeotype_REVSURF::printSelf()
{
  printf("REVSURF");
}

/********************************************************************/

measGeotype_RCTNGL::measGeotype_RCTNGL(){}

measGeotype_RCTNGL::~measGeotype_RCTNGL(){}

void measGeotype_RCTNGL::printSelf()
{
  printf("RCTNGL");
}

/********************************************************************/

measGeotype_SPHERE::measGeotype_SPHERE(){}

measGeotype_SPHERE::~measGeotype_SPHERE(){}

void measGeotype_SPHERE::printSelf()
{
  printf("SPHERE");
}

/********************************************************************/

measGeotype_SPHRADSEGMNT::measGeotype_SPHRADSEGMNT(){}

measGeotype_SPHRADSEGMNT::~measGeotype_SPHRADSEGMNT(){}

void measGeotype_SPHRADSEGMNT::printSelf()
{
  printf("SPHRADSEGMNT");
}

/********************************************************************/

measGeotype_SYMPLN::measGeotype_SYMPLN(){}

measGeotype_SYMPLN::~measGeotype_SYMPLN(){}

void measGeotype_SYMPLN::printSelf()
{
  printf("SYMPLN");
}

/********************************************************************/

measGeotype_TORUS::measGeotype_TORUS(){}

measGeotype_TORUS::~measGeotype_TORUS(){}

void measGeotype_TORUS::printSelf()
{
  printf("TORUS");
}

/********************************************************************/

measGeotype_TORRADSEGMNT::measGeotype_TORRADSEGMNT(){}

measGeotype_TORRADSEGMNT::~measGeotype_TORRADSEGMNT(){}

void measGeotype_TORRADSEGMNT::printSelf()
{
  printf("TORRADSEGMNT");
}

/********************************************************************/

measVar2::measVar2(){};

measVar2::~measVar2(){}

/********************************************************************/

measVar2_AXDIR::measVar2_AXDIR(){}

measVar2_AXDIR::~measVar2_AXDIR(){}

void measVar2_AXDIR::printSelf()
{
  printf("AXDIR");
}

/********************************************************************/

measVar2_DME::measVar2_DME(){}

measVar2_DME::~measVar2_DME(){}

void measVar2_DME::printSelf()
{
  printf("DME");
}

/********************************************************************/

measVar2_FEAT::measVar2_FEAT(){}

measVar2_FEAT::measVar2_FEAT(
  measVar2Aux * measVar2AuxIn)
{
  a_measVar2Aux = measVar2AuxIn;
}

measVar2_FEAT::~measVar2_FEAT(){}

void measVar2_FEAT::printSelf()
{
  printf("FEAT");
  printf(",");
  a_measVar2Aux->printSelf();
}

measVar2Aux * measVar2_FEAT::get_measVar2Aux()
{ return a_measVar2Aux; }
void measVar2_FEAT::set_measVar2Aux(measVar2Aux * measVar2AuxIn)
{ a_measVar2Aux = measVar2AuxIn; }

/********************************************************************/

measVar2_POL::measVar2_POL(){}

measVar2_POL::~measVar2_POL(){}

void measVar2_POL::printSelf()
{
  printf("POL");
}

/********************************************************************/

measVar2_SPH::measVar2_SPH(){}

measVar2_SPH::~measVar2_SPH(){}

void measVar2_SPH::printSelf()
{
  printf("SPH");
}

/********************************************************************/

measVar2_VEC::measVar2_VEC(){}

measVar2_VEC::measVar2_VEC(
  vector * compDirIn)
{
  compDir = compDirIn;
}

measVar2_VEC::~measVar2_VEC(){}

void measVar2_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  compDir->printSelf();
}

vector * measVar2_VEC::get_compDir()
{ return compDir; }
void measVar2_VEC::set_compDir(vector * compDirIn)
{ compDir = compDirIn; }

/********************************************************************/

measVar2Aux::measVar2Aux(){};

measVar2Aux::~measVar2Aux(){}

/********************************************************************/

mfgdevStm::mfgdevStm(){}

mfgdevStm::mfgdevStm(
  mdLabel * mdLabelIn,
  stringVal * textIn)
{
  a_mdLabel = mdLabelIn;
  text = textIn;
}

mfgdevStm::~mfgdevStm(){}

void mfgdevStm::printSelf()
{
  a_mdLabel->printSelf();
  printf("=");
  printf("MFGDEV");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

mdLabel * mfgdevStm::get_mdLabel()
{ return a_mdLabel; }
void mfgdevStm::set_mdLabel(mdLabel * mdLabelIn)
{ a_mdLabel = mdLabelIn; }
stringVal * mfgdevStm::get_text()
{ return text; }
void mfgdevStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

modeStm::modeStm(){}

modeStm::modeStm(
  bool has_AUTOIn,
  bool has_PROGIn)
{
  has_AUTO = has_AUTOIn;
  has_PROG = has_PROGIn;
}

modeStm::~modeStm(){}

void modeStm::printSelf()
{
  printf("MODE");
  printf("/");
  if (has_AUTO == true)
    {
      printf("AUTO");
      printf(",");
    }
  if (has_PROG == true)
    {
      printf("PROG");
      printf(",");
    }
  printf("MAN");
  printf("%c%c", 13, 10);
}

bool modeStm::get_has_AUTO()
{ return has_AUTO; }
void modeStm::set_has_AUTO(bool has_AUTOIn)
{ has_AUTO = has_AUTOIn; }
bool modeStm::get_has_PROG()
{ return has_PROG; }
void modeStm::set_has_PROG(bool has_PROGIn)
{ has_PROG = has_PROGIn; }

/********************************************************************/

obtainLabeled::obtainLabeled(){};

obtainLabeled::~obtainLabeled(){}

/********************************************************************/

obtainLabeled_datumLabel1::obtainLabeled_datumLabel1(){}

obtainLabeled_datumLabel1::obtainLabeled_datumLabel1(
  datumLabel1 * datumLabel1In,
  intVal * indexIn)
{
  a_datumLabel1 = datumLabel1In;
  index = indexIn;
}

obtainLabeled_datumLabel1::~obtainLabeled_datumLabel1(){}

void obtainLabeled_datumLabel1::printSelf()
{
  a_datumLabel1->printSelf();
  printf(",");
  index->printSelf();
}

datumLabel1 * obtainLabeled_datumLabel1::get_datumLabel1()
{ return a_datumLabel1; }
void obtainLabeled_datumLabel1::set_datumLabel1(datumLabel1 * datumLabel1In)
{ a_datumLabel1 = datumLabel1In; }
intVal * obtainLabeled_datumLabel1::get_index()
{ return index; }
void obtainLabeled_datumLabel1::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_featureLabel::obtainLabeled_featureLabel(){}

obtainLabeled_featureLabel::obtainLabeled_featureLabel(
  featureLabel * featureLabelIn,
  intVal * indexIn)
{
  a_featureLabel = featureLabelIn;
  index = indexIn;
}

obtainLabeled_featureLabel::~obtainLabeled_featureLabel(){}

void obtainLabeled_featureLabel::printSelf()
{
  a_featureLabel->printSelf();
  printf(",");
  index->printSelf();
}

featureLabel * obtainLabeled_featureLabel::get_featureLabel()
{ return a_featureLabel; }
void obtainLabeled_featureLabel::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
intVal * obtainLabeled_featureLabel::get_index()
{ return index; }
void obtainLabeled_featureLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_sensorLabel1::obtainLabeled_sensorLabel1(){}

obtainLabeled_sensorLabel1::obtainLabeled_sensorLabel1(
  sensorLabel1 * sensorLabel1In,
  intVal * indexIn)
{
  a_sensorLabel1 = sensorLabel1In;
  index = indexIn;
}

obtainLabeled_sensorLabel1::~obtainLabeled_sensorLabel1(){}

void obtainLabeled_sensorLabel1::printSelf()
{
  a_sensorLabel1->printSelf();
  printf(",");
  index->printSelf();
}

sensorLabel1 * obtainLabeled_sensorLabel1::get_sensorLabel1()
{ return a_sensorLabel1; }
void obtainLabeled_sensorLabel1::set_sensorLabel1(sensorLabel1 * sensorLabel1In)
{ a_sensorLabel1 = sensorLabel1In; }
intVal * obtainLabeled_sensorLabel1::get_index()
{ return index; }
void obtainLabeled_sensorLabel1::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_toleranceLabel::obtainLabeled_toleranceLabel(){}

obtainLabeled_toleranceLabel::obtainLabeled_toleranceLabel(
  toleranceLabel * toleranceLabelIn,
  intVal * indexIn)
{
  a_toleranceLabel = toleranceLabelIn;
  index = indexIn;
}

obtainLabeled_toleranceLabel::~obtainLabeled_toleranceLabel(){}

void obtainLabeled_toleranceLabel::printSelf()
{
  a_toleranceLabel->printSelf();
  printf(",");
  index->printSelf();
}

toleranceLabel * obtainLabeled_toleranceLabel::get_toleranceLabel()
{ return a_toleranceLabel; }
void obtainLabeled_toleranceLabel::set_toleranceLabel(toleranceLabel * toleranceLabelIn)
{ a_toleranceLabel = toleranceLabelIn; }
intVal * obtainLabeled_toleranceLabel::get_index()
{ return index; }
void obtainLabeled_toleranceLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_didLabel::obtainLabeled_didLabel(){}

obtainLabeled_didLabel::obtainLabeled_didLabel(
  didLabel * didLabelIn,
  intVal * indexIn)
{
  a_didLabel = didLabelIn;
  index = indexIn;
}

obtainLabeled_didLabel::~obtainLabeled_didLabel(){}

void obtainLabeled_didLabel::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  index->printSelf();
}

didLabel * obtainLabeled_didLabel::get_didLabel()
{ return a_didLabel; }
void obtainLabeled_didLabel::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
intVal * obtainLabeled_didLabel::get_index()
{ return index; }
void obtainLabeled_didLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_qisLabel::obtainLabeled_qisLabel(){}

obtainLabeled_qisLabel::obtainLabeled_qisLabel(
  qisLabel * qisLabelIn,
  intVal * indexIn)
{
  a_qisLabel = qisLabelIn;
  index = indexIn;
}

obtainLabeled_qisLabel::~obtainLabeled_qisLabel(){}

void obtainLabeled_qisLabel::printSelf()
{
  a_qisLabel->printSelf();
  printf(",");
  index->printSelf();
}

qisLabel * obtainLabeled_qisLabel::get_qisLabel()
{ return a_qisLabel; }
void obtainLabeled_qisLabel::set_qisLabel(qisLabel * qisLabelIn)
{ a_qisLabel = qisLabelIn; }
intVal * obtainLabeled_qisLabel::get_index()
{ return index; }
void obtainLabeled_qisLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_crLabel::obtainLabeled_crLabel(){}

obtainLabeled_crLabel::obtainLabeled_crLabel(
  crLabel * crLabelIn,
  intVal * indexIn)
{
  a_crLabel = crLabelIn;
  index = indexIn;
}

obtainLabeled_crLabel::~obtainLabeled_crLabel(){}

void obtainLabeled_crLabel::printSelf()
{
  a_crLabel->printSelf();
  printf(",");
  index->printSelf();
}

crLabel * obtainLabeled_crLabel::get_crLabel()
{ return a_crLabel; }
void obtainLabeled_crLabel::set_crLabel(crLabel * crLabelIn)
{ a_crLabel = crLabelIn; }
intVal * obtainLabeled_crLabel::get_index()
{ return index; }
void obtainLabeled_crLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_gLabel::obtainLabeled_gLabel(){}

obtainLabeled_gLabel::obtainLabeled_gLabel(
  gLabel * gLabelIn,
  intVal * indexIn)
{
  a_gLabel = gLabelIn;
  index = indexIn;
}

obtainLabeled_gLabel::~obtainLabeled_gLabel(){}

void obtainLabeled_gLabel::printSelf()
{
  a_gLabel->printSelf();
  printf(",");
  index->printSelf();
}

gLabel * obtainLabeled_gLabel::get_gLabel()
{ return a_gLabel; }
void obtainLabeled_gLabel::set_gLabel(gLabel * gLabelIn)
{ a_gLabel = gLabelIn; }
intVal * obtainLabeled_gLabel::get_index()
{ return index; }
void obtainLabeled_gLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_gsaLabel::obtainLabeled_gsaLabel(){}

obtainLabeled_gsaLabel::obtainLabeled_gsaLabel(
  gsaLabel * gsaLabelIn,
  intVal * indexIn)
{
  a_gsaLabel = gsaLabelIn;
  index = indexIn;
}

obtainLabeled_gsaLabel::~obtainLabeled_gsaLabel(){}

void obtainLabeled_gsaLabel::printSelf()
{
  a_gsaLabel->printSelf();
  printf(",");
  index->printSelf();
}

gsaLabel * obtainLabeled_gsaLabel::get_gsaLabel()
{ return a_gsaLabel; }
void obtainLabeled_gsaLabel::set_gsaLabel(gsaLabel * gsaLabelIn)
{ a_gsaLabel = gsaLabelIn; }
intVal * obtainLabeled_gsaLabel::get_index()
{ return index; }
void obtainLabeled_gsaLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_kcLabel::obtainLabeled_kcLabel(){}

obtainLabeled_kcLabel::obtainLabeled_kcLabel(
  kcLabel * kcLabelIn,
  intVal * indexIn)
{
  a_kcLabel = kcLabelIn;
  index = indexIn;
}

obtainLabeled_kcLabel::~obtainLabeled_kcLabel(){}

void obtainLabeled_kcLabel::printSelf()
{
  a_kcLabel->printSelf();
  printf(",");
  index->printSelf();
}

kcLabel * obtainLabeled_kcLabel::get_kcLabel()
{ return a_kcLabel; }
void obtainLabeled_kcLabel::set_kcLabel(kcLabel * kcLabelIn)
{ a_kcLabel = kcLabelIn; }
intVal * obtainLabeled_kcLabel::get_index()
{ return index; }
void obtainLabeled_kcLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_maLabel::obtainLabeled_maLabel(){}

obtainLabeled_maLabel::obtainLabeled_maLabel(
  maLabel * maLabelIn,
  intVal * indexIn)
{
  a_maLabel = maLabelIn;
  index = indexIn;
}

obtainLabeled_maLabel::~obtainLabeled_maLabel(){}

void obtainLabeled_maLabel::printSelf()
{
  a_maLabel->printSelf();
  printf(",");
  index->printSelf();
}

maLabel * obtainLabeled_maLabel::get_maLabel()
{ return a_maLabel; }
void obtainLabeled_maLabel::set_maLabel(maLabel * maLabelIn)
{ a_maLabel = maLabelIn; }
intVal * obtainLabeled_maLabel::get_index()
{ return index; }
void obtainLabeled_maLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_pLabel::obtainLabeled_pLabel(){}

obtainLabeled_pLabel::obtainLabeled_pLabel(
  pLabel * pLabelIn,
  intVal * indexIn)
{
  a_pLabel = pLabelIn;
  index = indexIn;
}

obtainLabeled_pLabel::~obtainLabeled_pLabel(){}

void obtainLabeled_pLabel::printSelf()
{
  a_pLabel->printSelf();
  printf(",");
  index->printSelf();
}

pLabel * obtainLabeled_pLabel::get_pLabel()
{ return a_pLabel; }
void obtainLabeled_pLabel::set_pLabel(pLabel * pLabelIn)
{ a_pLabel = pLabelIn; }
intVal * obtainLabeled_pLabel::get_index()
{ return index; }
void obtainLabeled_pLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_rLabel::obtainLabeled_rLabel(){}

obtainLabeled_rLabel::obtainLabeled_rLabel(
  rLabel * rLabelIn,
  intVal * indexIn)
{
  a_rLabel = rLabelIn;
  index = indexIn;
}

obtainLabeled_rLabel::~obtainLabeled_rLabel(){}

void obtainLabeled_rLabel::printSelf()
{
  a_rLabel->printSelf();
  printf(",");
  index->printSelf();
}

rLabel * obtainLabeled_rLabel::get_rLabel()
{ return a_rLabel; }
void obtainLabeled_rLabel::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }
intVal * obtainLabeled_rLabel::get_index()
{ return index; }
void obtainLabeled_rLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_rmLabel::obtainLabeled_rmLabel(){}

obtainLabeled_rmLabel::obtainLabeled_rmLabel(
  rmLabel * rmLabelIn,
  intVal * indexIn)
{
  a_rmLabel = rmLabelIn;
  index = indexIn;
}

obtainLabeled_rmLabel::~obtainLabeled_rmLabel(){}

void obtainLabeled_rmLabel::printSelf()
{
  a_rmLabel->printSelf();
  printf(",");
  index->printSelf();
}

rmLabel * obtainLabeled_rmLabel::get_rmLabel()
{ return a_rmLabel; }
void obtainLabeled_rmLabel::set_rmLabel(rmLabel * rmLabelIn)
{ a_rmLabel = rmLabelIn; }
intVal * obtainLabeled_rmLabel::get_index()
{ return index; }
void obtainLabeled_rmLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_rtLabel::obtainLabeled_rtLabel(){}

obtainLabeled_rtLabel::obtainLabeled_rtLabel(
  rtLabel * rtLabelIn,
  intVal * indexIn)
{
  a_rtLabel = rtLabelIn;
  index = indexIn;
}

obtainLabeled_rtLabel::~obtainLabeled_rtLabel(){}

void obtainLabeled_rtLabel::printSelf()
{
  a_rtLabel->printSelf();
  printf(",");
  index->printSelf();
}

rtLabel * obtainLabeled_rtLabel::get_rtLabel()
{ return a_rtLabel; }
void obtainLabeled_rtLabel::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
intVal * obtainLabeled_rtLabel::get_index()
{ return index; }
void obtainLabeled_rtLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_sgLabel::obtainLabeled_sgLabel(){}

obtainLabeled_sgLabel::obtainLabeled_sgLabel(
  sgLabel * sgLabelIn,
  intVal * indexIn)
{
  a_sgLabel = sgLabelIn;
  index = indexIn;
}

obtainLabeled_sgLabel::~obtainLabeled_sgLabel(){}

void obtainLabeled_sgLabel::printSelf()
{
  a_sgLabel->printSelf();
  printf(",");
  index->printSelf();
}

sgLabel * obtainLabeled_sgLabel::get_sgLabel()
{ return a_sgLabel; }
void obtainLabeled_sgLabel::set_sgLabel(sgLabel * sgLabelIn)
{ a_sgLabel = sgLabelIn; }
intVal * obtainLabeled_sgLabel::get_index()
{ return index; }
void obtainLabeled_sgLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_sgsLabel::obtainLabeled_sgsLabel(){}

obtainLabeled_sgsLabel::obtainLabeled_sgsLabel(
  sgsLabel * sgsLabelIn,
  intVal * indexIn)
{
  a_sgsLabel = sgsLabelIn;
  index = indexIn;
}

obtainLabeled_sgsLabel::~obtainLabeled_sgsLabel(){}

void obtainLabeled_sgsLabel::printSelf()
{
  a_sgsLabel->printSelf();
  printf(",");
  index->printSelf();
}

sgsLabel * obtainLabeled_sgsLabel::get_sgsLabel()
{ return a_sgsLabel; }
void obtainLabeled_sgsLabel::set_sgsLabel(sgsLabel * sgsLabelIn)
{ a_sgsLabel = sgsLabelIn; }
intVal * obtainLabeled_sgsLabel::get_index()
{ return index; }
void obtainLabeled_sgsLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_sraLabel::obtainLabeled_sraLabel(){}

obtainLabeled_sraLabel::obtainLabeled_sraLabel(
  sraLabel * sraLabelIn,
  intVal * indexIn)
{
  a_sraLabel = sraLabelIn;
  index = indexIn;
}

obtainLabeled_sraLabel::~obtainLabeled_sraLabel(){}

void obtainLabeled_sraLabel::printSelf()
{
  a_sraLabel->printSelf();
  printf(",");
  index->printSelf();
}

sraLabel * obtainLabeled_sraLabel::get_sraLabel()
{ return a_sraLabel; }
void obtainLabeled_sraLabel::set_sraLabel(sraLabel * sraLabelIn)
{ a_sraLabel = sraLabelIn; }
intVal * obtainLabeled_sraLabel::get_index()
{ return index; }
void obtainLabeled_sraLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_ssLabel::obtainLabeled_ssLabel(){}

obtainLabeled_ssLabel::obtainLabeled_ssLabel(
  ssLabel * ssLabelIn,
  intVal * indexIn)
{
  a_ssLabel = ssLabelIn;
  index = indexIn;
}

obtainLabeled_ssLabel::~obtainLabeled_ssLabel(){}

void obtainLabeled_ssLabel::printSelf()
{
  a_ssLabel->printSelf();
  printf(",");
  index->printSelf();
}

ssLabel * obtainLabeled_ssLabel::get_ssLabel()
{ return a_ssLabel; }
void obtainLabeled_ssLabel::set_ssLabel(ssLabel * ssLabelIn)
{ a_ssLabel = ssLabelIn; }
intVal * obtainLabeled_ssLabel::get_index()
{ return index; }
void obtainLabeled_ssLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_swLabel::obtainLabeled_swLabel(){}

obtainLabeled_swLabel::obtainLabeled_swLabel(
  swLabel * swLabelIn,
  intVal * indexIn)
{
  a_swLabel = swLabelIn;
  index = indexIn;
}

obtainLabeled_swLabel::~obtainLabeled_swLabel(){}

void obtainLabeled_swLabel::printSelf()
{
  a_swLabel->printSelf();
  printf(",");
  index->printSelf();
}

swLabel * obtainLabeled_swLabel::get_swLabel()
{ return a_swLabel; }
void obtainLabeled_swLabel::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
intVal * obtainLabeled_swLabel::get_index()
{ return index; }
void obtainLabeled_swLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_sxLabel::obtainLabeled_sxLabel(){}

obtainLabeled_sxLabel::obtainLabeled_sxLabel(
  sxLabel * sxLabelIn,
  intVal * indexIn)
{
  a_sxLabel = sxLabelIn;
  index = indexIn;
}

obtainLabeled_sxLabel::~obtainLabeled_sxLabel(){}

void obtainLabeled_sxLabel::printSelf()
{
  a_sxLabel->printSelf();
  printf(",");
  index->printSelf();
}

sxLabel * obtainLabeled_sxLabel::get_sxLabel()
{ return a_sxLabel; }
void obtainLabeled_sxLabel::set_sxLabel(sxLabel * sxLabelIn)
{ a_sxLabel = sxLabelIn; }
intVal * obtainLabeled_sxLabel::get_index()
{ return index; }
void obtainLabeled_sxLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_thLabel::obtainLabeled_thLabel(){}

obtainLabeled_thLabel::obtainLabeled_thLabel(
  thLabel * thLabelIn,
  intVal * indexIn)
{
  a_thLabel = thLabelIn;
  index = indexIn;
}

obtainLabeled_thLabel::~obtainLabeled_thLabel(){}

void obtainLabeled_thLabel::printSelf()
{
  a_thLabel->printSelf();
  printf(",");
  index->printSelf();
}

thLabel * obtainLabeled_thLabel::get_thLabel()
{ return a_thLabel; }
void obtainLabeled_thLabel::set_thLabel(thLabel * thLabelIn)
{ a_thLabel = thLabelIn; }
intVal * obtainLabeled_thLabel::get_index()
{ return index; }
void obtainLabeled_thLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_vLabel::obtainLabeled_vLabel(){}

obtainLabeled_vLabel::obtainLabeled_vLabel(
  vLabel * vLabelIn,
  intVal * indexIn)
{
  a_vLabel = vLabelIn;
  index = indexIn;
}

obtainLabeled_vLabel::~obtainLabeled_vLabel(){}

void obtainLabeled_vLabel::printSelf()
{
  a_vLabel->printSelf();
  printf(",");
  index->printSelf();
}

vLabel * obtainLabeled_vLabel::get_vLabel()
{ return a_vLabel; }
void obtainLabeled_vLabel::set_vLabel(vLabel * vLabelIn)
{ a_vLabel = vLabelIn; }
intVal * obtainLabeled_vLabel::get_index()
{ return index; }
void obtainLabeled_vLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_vaLabel::obtainLabeled_vaLabel(){}

obtainLabeled_vaLabel::obtainLabeled_vaLabel(
  vaLabel * vaLabelIn,
  intVal * indexIn)
{
  a_vaLabel = vaLabelIn;
  index = indexIn;
}

obtainLabeled_vaLabel::~obtainLabeled_vaLabel(){}

void obtainLabeled_vaLabel::printSelf()
{
  a_vaLabel->printSelf();
  printf(",");
  index->printSelf();
}

vaLabel * obtainLabeled_vaLabel::get_vaLabel()
{ return a_vaLabel; }
void obtainLabeled_vaLabel::set_vaLabel(vaLabel * vaLabelIn)
{ a_vaLabel = vaLabelIn; }
intVal * obtainLabeled_vaLabel::get_index()
{ return index; }
void obtainLabeled_vaLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_vfLabel::obtainLabeled_vfLabel(){}

obtainLabeled_vfLabel::obtainLabeled_vfLabel(
  vfLabel * vfLabelIn,
  intVal * indexIn)
{
  a_vfLabel = vfLabelIn;
  index = indexIn;
}

obtainLabeled_vfLabel::~obtainLabeled_vfLabel(){}

void obtainLabeled_vfLabel::printSelf()
{
  a_vfLabel->printSelf();
  printf(",");
  index->printSelf();
}

vfLabel * obtainLabeled_vfLabel::get_vfLabel()
{ return a_vfLabel; }
void obtainLabeled_vfLabel::set_vfLabel(vfLabel * vfLabelIn)
{ a_vfLabel = vfLabelIn; }
intVal * obtainLabeled_vfLabel::get_index()
{ return index; }
void obtainLabeled_vfLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_vlLabel::obtainLabeled_vlLabel(){}

obtainLabeled_vlLabel::obtainLabeled_vlLabel(
  vlLabel * vlLabelIn,
  intVal * indexIn)
{
  a_vlLabel = vlLabelIn;
  index = indexIn;
}

obtainLabeled_vlLabel::~obtainLabeled_vlLabel(){}

void obtainLabeled_vlLabel::printSelf()
{
  a_vlLabel->printSelf();
  printf(",");
  index->printSelf();
}

vlLabel * obtainLabeled_vlLabel::get_vlLabel()
{ return a_vlLabel; }
void obtainLabeled_vlLabel::set_vlLabel(vlLabel * vlLabelIn)
{ a_vlLabel = vlLabelIn; }
intVal * obtainLabeled_vlLabel::get_index()
{ return index; }
void obtainLabeled_vlLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainLabeled_vwLabel::obtainLabeled_vwLabel(){}

obtainLabeled_vwLabel::obtainLabeled_vwLabel(
  vwLabel * vwLabelIn,
  intVal * indexIn)
{
  a_vwLabel = vwLabelIn;
  index = indexIn;
}

obtainLabeled_vwLabel::~obtainLabeled_vwLabel(){}

void obtainLabeled_vwLabel::printSelf()
{
  a_vwLabel->printSelf();
  printf(",");
  index->printSelf();
}

vwLabel * obtainLabeled_vwLabel::get_vwLabel()
{ return a_vwLabel; }
void obtainLabeled_vwLabel::set_vwLabel(vwLabel * vwLabelIn)
{ a_vwLabel = vwLabelIn; }
intVal * obtainLabeled_vwLabel::get_index()
{ return index; }
void obtainLabeled_vwLabel::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

obtainPoint::obtainPoint(){}

obtainPoint::obtainPoint(
  featureLabel * featureLabelIn,
  intVal * subscrIn,
  intVal * indexIn)
{
  a_featureLabel = featureLabelIn;
  subscr = subscrIn;
  index = indexIn;
}

obtainPoint::~obtainPoint(){}

void obtainPoint::printSelf()
{
  a_featureLabel->printSelf();
  printf("[");
  subscr->printSelf();
  printf("]");
  printf(",");
  index->printSelf();
}

featureLabel * obtainPoint::get_featureLabel()
{ return a_featureLabel; }
void obtainPoint::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
intVal * obtainPoint::get_subscr()
{ return subscr; }
void obtainPoint::set_subscr(intVal * subscrIn)
{ subscr = subscrIn; }
intVal * obtainPoint::get_index()
{ return index; }
void obtainPoint::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

openStm::openStm(){}

openStm::openStm(
  openMinor * openMinorIn)
{
  a_openMinor = openMinorIn;
}

openStm::~openStm(){}

void openStm::printSelf()
{
  printf("OPEN");
  printf("/");
  a_openMinor->printSelf();
  printf("%c%c", 13, 10);
}

openMinor * openStm::get_openMinor()
{ return a_openMinor; }
void openStm::set_openMinor(openMinor * openMinorIn)
{ a_openMinor = openMinorIn; }

/********************************************************************/

openMinor::openMinor(){};

openMinor::~openMinor(){}

/********************************************************************/

openMinor_openDevice::openMinor_openDevice(){}

openMinor_openDevice::openMinor_openDevice(
  didLabel * didLabelIn,
  openDevice * openDeviceIn)
{
  a_didLabel = didLabelIn;
  a_openDevice = openDeviceIn;
}

openMinor_openDevice::~openMinor_openDevice(){}

void openMinor_openDevice::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  a_openDevice->printSelf();
}

didLabel * openMinor_openDevice::get_didLabel()
{ return a_didLabel; }
void openMinor_openDevice::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
openDevice * openMinor_openDevice::get_openDevice()
{ return a_openDevice; }
void openMinor_openDevice::set_openDevice(openDevice * openDeviceIn)
{ a_openDevice = openDeviceIn; }

/********************************************************************/

openMinor_openFdata::openMinor_openFdata(){}

openMinor_openFdata::openMinor_openFdata(
  didLabel * didLabelIn,
  openFdata * openFdataIn)
{
  a_didLabel = didLabelIn;
  a_openFdata = openFdataIn;
}

openMinor_openFdata::~openMinor_openFdata(){}

void openMinor_openFdata::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  a_openFdata->printSelf();
}

didLabel * openMinor_openFdata::get_didLabel()
{ return a_didLabel; }
void openMinor_openFdata::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
openFdata * openMinor_openFdata::get_openFdata()
{ return a_openFdata; }
void openMinor_openFdata::set_openFdata(openFdata * openFdataIn)
{ a_openFdata = openFdataIn; }

/********************************************************************/

openMinor_openCadfile::openMinor_openCadfile(){}

openMinor_openCadfile::openMinor_openCadfile(
  didLabel * didLabelIn,
  openCadfile * openCadfileIn)
{
  a_didLabel = didLabelIn;
  a_openCadfile = openCadfileIn;
}

openMinor_openCadfile::~openMinor_openCadfile(){}

void openMinor_openCadfile::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  a_openCadfile->printSelf();
}

didLabel * openMinor_openCadfile::get_didLabel()
{ return a_didLabel; }
void openMinor_openCadfile::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
openCadfile * openMinor_openCadfile::get_openCadfile()
{ return a_openCadfile; }
void openMinor_openCadfile::set_openCadfile(openCadfile * openCadfileIn)
{ a_openCadfile = openCadfileIn; }

/********************************************************************/

openMinor_storageSpecList::openMinor_storageSpecList(){}

openMinor_storageSpecList::openMinor_storageSpecList(
  didLabel * didLabelIn,
  std::list<storageSpec *> * storageSpecListIn)
{
  a_didLabel = didLabelIn;
  a_storageSpecList = storageSpecListIn;
}

openMinor_storageSpecList::~openMinor_storageSpecList(){}

void openMinor_storageSpecList::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  if (a_storageSpecList->begin() == a_storageSpecList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<storageSpec *>::iterator iter;
      for (iter = a_storageSpecList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_storageSpecList->end())
            break;
          printf(",");
        }
    }
}

didLabel * openMinor_storageSpecList::get_didLabel()
{ return a_didLabel; }
void openMinor_storageSpecList::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
std::list<storageSpec *> * openMinor_storageSpecList::get_storageSpecList()
{ return a_storageSpecList; }
void openMinor_storageSpecList::set_storageSpecList(std::list<storageSpec *> * storageSpecListIn)
{ a_storageSpecList = storageSpecListIn; }

/********************************************************************/

openMinor_openDMLfile::openMinor_openDMLfile(){}

openMinor_openDMLfile::openMinor_openDMLfile(
  didLabel * didLabelIn,
  openDMLfile * openDMLfileIn)
{
  a_didLabel = didLabelIn;
  a_openDMLfile = openDMLfileIn;
}

openMinor_openDMLfile::~openMinor_openDMLfile(){}

void openMinor_openDMLfile::printSelf()
{
  a_didLabel->printSelf();
  printf(",");
  a_openDMLfile->printSelf();
}

didLabel * openMinor_openDMLfile::get_didLabel()
{ return a_didLabel; }
void openMinor_openDMLfile::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
openDMLfile * openMinor_openDMLfile::get_openDMLfile()
{ return a_openDMLfile; }
void openMinor_openDMLfile::set_openDMLfile(openDMLfile * openDMLfileIn)
{ a_openDMLfile = openDMLfileIn; }

/********************************************************************/

openDevice::openDevice(){};

openDevice::~openDevice(){}

/********************************************************************/

openDevice_inputAccess::openDevice_inputAccess(){}

openDevice_inputAccess::openDevice_inputAccess(
  inputAccess * inputAccessIn)
{
  a_inputAccess = inputAccessIn;
}

openDevice_inputAccess::~openDevice_inputAccess(){}

void openDevice_inputAccess::printSelf()
{
  printf("DIRECT");
  printf(",");
  a_inputAccess->printSelf();
}

inputAccess * openDevice_inputAccess::get_inputAccess()
{ return a_inputAccess; }
void openDevice_inputAccess::set_inputAccess(inputAccess * inputAccessIn)
{ a_inputAccess = inputAccessIn; }

/********************************************************************/

openDevice_outputAccess::openDevice_outputAccess(){}

openDevice_outputAccess::openDevice_outputAccess(
  outputAccess * outputAccessIn)
{
  a_outputAccess = outputAccessIn;
}

openDevice_outputAccess::~openDevice_outputAccess(){}

void openDevice_outputAccess::printSelf()
{
  printf("DIRECT");
  printf(",");
  a_outputAccess->printSelf();
}

outputAccess * openDevice_outputAccess::get_outputAccess()
{ return a_outputAccess; }
void openDevice_outputAccess::set_outputAccess(outputAccess * outputAccessIn)
{ a_outputAccess = outputAccessIn; }

/********************************************************************/

inputAccess::inputAccess(){}

inputAccess::~inputAccess(){}

void inputAccess::printSelf()
{
  printf("INPUT");
}

/********************************************************************/

outputAccess::outputAccess(){};

outputAccess::~outputAccess(){}

/********************************************************************/

outputAccessUnspec::outputAccessUnspec(){}

outputAccessUnspec::~outputAccessUnspec(){}

void outputAccessUnspec::printSelf()
{
  printf("OUTPUT");
}

/********************************************************************/

outputAccessAppend::outputAccessAppend(){}

outputAccessAppend::~outputAccessAppend(){}

void outputAccessAppend::printSelf()
{
  printf("OUTPUT");
  printf(",");
  printf("APPEND");
}

/********************************************************************/

outputAccessOverwr::outputAccessOverwr(){}

outputAccessOverwr::~outputAccessOverwr(){}

void outputAccessOverwr::printSelf()
{
  printf("OUTPUT");
  printf(",");
  printf("OVERWR");
}

/********************************************************************/

openFdata::openFdata(){};

openFdata::~openFdata(){}

/********************************************************************/

openFdata_vLabel::openFdata_vLabel(){}

openFdata_vLabel::openFdata_vLabel(
  vLabel * vLabelIn,
  outputAccess * outputAccessIn)
{
  a_vLabel = vLabelIn;
  a_outputAccess = outputAccessIn;
}

openFdata_vLabel::~openFdata_vLabel(){}

void openFdata_vLabel::printSelf()
{
  printf("FDATA");
  printf(",");
  a_vLabel->printSelf();
  printf(",");
  a_outputAccess->printSelf();
}

vLabel * openFdata_vLabel::get_vLabel()
{ return a_vLabel; }
void openFdata_vLabel::set_vLabel(vLabel * vLabelIn)
{ a_vLabel = vLabelIn; }
outputAccess * openFdata_vLabel::get_outputAccess()
{ return a_outputAccess; }
void openFdata_vLabel::set_outputAccess(outputAccess * outputAccessIn)
{ a_outputAccess = outputAccessIn; }

/********************************************************************/

openFdata_DMIS::openFdata_DMIS(){}

openFdata_DMIS::openFdata_DMIS(
  outputAccess * outputAccessIn)
{
  a_outputAccess = outputAccessIn;
}

openFdata_DMIS::~openFdata_DMIS(){}

void openFdata_DMIS::printSelf()
{
  printf("FDATA");
  printf(",");
  printf("DMIS");
  printf(",");
  a_outputAccess->printSelf();
}

outputAccess * openFdata_DMIS::get_outputAccess()
{ return a_outputAccess; }
void openFdata_DMIS::set_outputAccess(outputAccess * outputAccessIn)
{ a_outputAccess = outputAccessIn; }

/********************************************************************/

openCadfile::openCadfile(){}

openCadfile::openCadfile(
  cadfileType * cadfileTypeIn)
{
  a_cadfileType = cadfileTypeIn;
}

openCadfile::~openCadfile(){}

void openCadfile::printSelf()
{
  printf("CAD");
  if (a_cadfileType)
    {
      printf(",");
      a_cadfileType->printSelf();
    }
}

cadfileType * openCadfile::get_cadfileType()
{ return a_cadfileType; }
void openCadfile::set_cadfileType(cadfileType * cadfileTypeIn)
{ a_cadfileType = cadfileTypeIn; }

/********************************************************************/

cadfileType::cadfileType(){};

cadfileType::~cadfileType(){}

/********************************************************************/

cadfileType_STEP::cadfileType_STEP(){}

cadfileType_STEP::~cadfileType_STEP(){}

void cadfileType_STEP::printSelf()
{
  printf("STEP");
}

/********************************************************************/

cadfileType_IGES::cadfileType_IGES(){}

cadfileType_IGES::~cadfileType_IGES(){}

void cadfileType_IGES::printSelf()
{
  printf("IGES");
}

/********************************************************************/

cadfileType_VENDOR::cadfileType_VENDOR(){}

cadfileType_VENDOR::cadfileType_VENDOR(
  stringVal * textIn)
{
  text = textIn;
}

cadfileType_VENDOR::~cadfileType_VENDOR(){}

void cadfileType_VENDOR::printSelf()
{
  printf("VENDOR");
  printf(",");
  text->printSelf();
}

stringVal * cadfileType_VENDOR::get_text()
{ return text; }
void cadfileType_VENDOR::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

storageSpec::storageSpec(){};

storageSpec::~storageSpec(){}

/********************************************************************/

storageSpec_SNS::storageSpec_SNS(){}

storageSpec_SNS::~storageSpec_SNS(){}

void storageSpec_SNS::printSelf()
{
  printf("SNS");
}

/********************************************************************/

storageSpec_PCS::storageSpec_PCS(){}

storageSpec_PCS::~storageSpec_PCS(){}

void storageSpec_PCS::printSelf()
{
  printf("PCS");
}

/********************************************************************/

storageSpec_FEATUR::storageSpec_FEATUR(){}

storageSpec_FEATUR::~storageSpec_FEATUR(){}

void storageSpec_FEATUR::printSelf()
{
  printf("FEATUR");
}

/********************************************************************/

storageSpec_RTAB::storageSpec_RTAB(){}

storageSpec_RTAB::~storageSpec_RTAB(){}

void storageSpec_RTAB::printSelf()
{
  printf("RTAB");
}

/********************************************************************/

openDMLfile::openDMLfile(){};

openDMLfile::~openDMLfile(){}

/********************************************************************/

openDmlInput::openDmlInput(){}

openDmlInput::openDmlInput(
  stringVal * versionIn)
{
  version = versionIn;
}

openDmlInput::~openDmlInput(){}

void openDmlInput::printSelf()
{
  printf("DML");
  printf(",");
  version->printSelf();
  printf(",");
  printf("INPUT");
}

stringVal * openDmlInput::get_version()
{ return version; }
void openDmlInput::set_version(stringVal * versionIn)
{ version = versionIn; }

/********************************************************************/

openDmlOutput::openDmlOutput(){}

openDmlOutput::openDmlOutput(
  stringVal * versionIn,
  state * stateIn)
{
  version = versionIn;
  a_state = stateIn;
}

openDmlOutput::~openDmlOutput(){}

void openDmlOutput::printSelf()
{
  printf("DML");
  printf(",");
  version->printSelf();
  printf(",");
  printf("OUTPUT");
  printf(",");
  printf("PTDATA");
  printf(",");
  a_state->printSelf();
}

stringVal * openDmlOutput::get_version()
{ return version; }
void openDmlOutput::set_version(stringVal * versionIn)
{ version = versionIn; }
state * openDmlOutput::get_state()
{ return a_state; }
void openDmlOutput::set_state(state * stateIn)
{ a_state = stateIn; }

/********************************************************************/

operidStm::operidStm(){}

operidStm::operidStm(
  opLabel * opLabelIn,
  stringVal * textIn)
{
  a_opLabel = opLabelIn;
  text = textIn;
}

operidStm::~operidStm(){}

void operidStm::printSelf()
{
  a_opLabel->printSelf();
  printf("=");
  printf("OPERID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

opLabel * operidStm::get_opLabel()
{ return a_opLabel; }
void operidStm::set_opLabel(opLabel * opLabelIn)
{ a_opLabel = opLabelIn; }
stringVal * operidStm::get_text()
{ return text; }
void operidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

outputStm::outputStm(){}

outputStm::outputStm(
  outputMinor * outputMinorIn)
{
  a_outputMinor = outputMinorIn;
}

outputStm::~outputStm(){}

void outputStm::printSelf()
{
  printf("OUTPUT");
  printf("/");
  a_outputMinor->printSelf();
  printf("%c%c", 13, 10);
}

outputMinor * outputStm::get_outputMinor()
{ return a_outputMinor; }
void outputStm::set_outputMinor(outputMinor * outputMinorIn)
{ a_outputMinor = outputMinorIn; }

/********************************************************************/

outputMinor::outputMinor(){};

outputMinor::~outputMinor(){}

/********************************************************************/

outputFeatData::outputFeatData(){};

outputFeatData::~outputFeatData(){}

/********************************************************************/

outputFeat::outputFeat(){};

outputFeat::~outputFeat(){}

/********************************************************************/

outputFeat1F::outputFeat1F(){}

outputFeat1F::outputFeat1F(
  fLabel * fIn,
  pointRange * pointRangeIn,
  rLabel * rLabelIn)
{
  f = fIn;
  a_pointRange = pointRangeIn;
  a_rLabel = rLabelIn;
}

outputFeat1F::~outputFeat1F(){}

void outputFeat1F::printSelf()
{
  f->printSelf();
  if (a_pointRange)
    {
      a_pointRange->printSelf();
    }
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

fLabel * outputFeat1F::get_f()
{ return f; }
void outputFeat1F::set_f(fLabel * fIn)
{ f = fIn; }
pointRange * outputFeat1F::get_pointRange()
{ return a_pointRange; }
void outputFeat1F::set_pointRange(pointRange * pointRangeIn)
{ a_pointRange = pointRangeIn; }
rLabel * outputFeat1F::get_rLabel()
{ return a_rLabel; }
void outputFeat1F::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputFeat1Fa::outputFeat1Fa(){}

outputFeat1Fa::outputFeat1Fa(
  faLabel * faIn,
  pointRange * pointRangeIn,
  rLabel * rLabelIn)
{
  fa = faIn;
  a_pointRange = pointRangeIn;
  a_rLabel = rLabelIn;
}

outputFeat1Fa::~outputFeat1Fa(){}

void outputFeat1Fa::printSelf()
{
  fa->printSelf();
  if (a_pointRange)
    {
      a_pointRange->printSelf();
    }
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

faLabel * outputFeat1Fa::get_fa()
{ return fa; }
void outputFeat1Fa::set_fa(faLabel * faIn)
{ fa = faIn; }
pointRange * outputFeat1Fa::get_pointRange()
{ return a_pointRange; }
void outputFeat1Fa::set_pointRange(pointRange * pointRangeIn)
{ a_pointRange = pointRangeIn; }
rLabel * outputFeat1Fa::get_rLabel()
{ return a_rLabel; }
void outputFeat1Fa::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputFeat2FFaTa::outputFeat2FFaTa(){}

outputFeat2FFaTa::outputFeat2FFaTa(
  fLabel * fIn,
  faLabel * faIn,
  taLabel * taIn,
  rLabel * rLabelIn)
{
  f = fIn;
  fa = faIn;
  ta = taIn;
  a_rLabel = rLabelIn;
}

outputFeat2FFaTa::~outputFeat2FFaTa(){}

void outputFeat2FFaTa::printSelf()
{
  f->printSelf();
  printf(",");
  fa->printSelf();
  printf(",");
  ta->printSelf();
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

fLabel * outputFeat2FFaTa::get_f()
{ return f; }
void outputFeat2FFaTa::set_f(fLabel * fIn)
{ f = fIn; }
faLabel * outputFeat2FFaTa::get_fa()
{ return fa; }
void outputFeat2FFaTa::set_fa(faLabel * faIn)
{ fa = faIn; }
taLabel * outputFeat2FFaTa::get_ta()
{ return ta; }
void outputFeat2FFaTa::set_ta(taLabel * taIn)
{ ta = taIn; }
rLabel * outputFeat2FFaTa::get_rLabel()
{ return a_rLabel; }
void outputFeat2FFaTa::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputFeat2FaFaTa::outputFeat2FaFaTa(){}

outputFeat2FaFaTa::outputFeat2FaFaTa(
  faLabel * fa1In,
  faLabel * fa2In,
  taLabel * taIn,
  rLabel * rLabelIn)
{
  fa1 = fa1In;
  fa2 = fa2In;
  ta = taIn;
  a_rLabel = rLabelIn;
}

outputFeat2FaFaTa::~outputFeat2FaFaTa(){}

void outputFeat2FaFaTa::printSelf()
{
  fa1->printSelf();
  printf(",");
  fa2->printSelf();
  printf(",");
  ta->printSelf();
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

faLabel * outputFeat2FaFaTa::get_fa1()
{ return fa1; }
void outputFeat2FaFaTa::set_fa1(faLabel * fa1In)
{ fa1 = fa1In; }
faLabel * outputFeat2FaFaTa::get_fa2()
{ return fa2; }
void outputFeat2FaFaTa::set_fa2(faLabel * fa2In)
{ fa2 = fa2In; }
taLabel * outputFeat2FaFaTa::get_ta()
{ return ta; }
void outputFeat2FaFaTa::set_ta(taLabel * taIn)
{ ta = taIn; }
rLabel * outputFeat2FaFaTa::get_rLabel()
{ return a_rLabel; }
void outputFeat2FaFaTa::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputFeat2FFT::outputFeat2FFT(){}

outputFeat2FFT::outputFeat2FFT(
  fLabel * f1In,
  fLabel * f2In,
  tLabel * tIn,
  rLabel * rLabelIn)
{
  f1 = f1In;
  f2 = f2In;
  t = tIn;
  a_rLabel = rLabelIn;
}

outputFeat2FFT::~outputFeat2FFT(){}

void outputFeat2FFT::printSelf()
{
  f1->printSelf();
  printf(",");
  f2->printSelf();
  printf(",");
  t->printSelf();
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

fLabel * outputFeat2FFT::get_f1()
{ return f1; }
void outputFeat2FFT::set_f1(fLabel * f1In)
{ f1 = f1In; }
fLabel * outputFeat2FFT::get_f2()
{ return f2; }
void outputFeat2FFT::set_f2(fLabel * f2In)
{ f2 = f2In; }
tLabel * outputFeat2FFT::get_t()
{ return t; }
void outputFeat2FFT::set_t(tLabel * tIn)
{ t = tIn; }
rLabel * outputFeat2FFT::get_rLabel()
{ return a_rLabel; }
void outputFeat2FFT::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputFeat2FaFTa::outputFeat2FaFTa(){}

outputFeat2FaFTa::outputFeat2FaFTa(
  faLabel * faIn,
  fLabel * fIn,
  taLabel * taIn,
  rLabel * rLabelIn)
{
  fa = faIn;
  f = fIn;
  ta = taIn;
  a_rLabel = rLabelIn;
}

outputFeat2FaFTa::~outputFeat2FaFTa(){}

void outputFeat2FaFTa::printSelf()
{
  fa->printSelf();
  printf(",");
  f->printSelf();
  printf(",");
  ta->printSelf();
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

faLabel * outputFeat2FaFTa::get_fa()
{ return fa; }
void outputFeat2FaFTa::set_fa(faLabel * faIn)
{ fa = faIn; }
fLabel * outputFeat2FaFTa::get_f()
{ return f; }
void outputFeat2FaFTa::set_f(fLabel * fIn)
{ f = fIn; }
taLabel * outputFeat2FaFTa::get_ta()
{ return ta; }
void outputFeat2FaFTa::set_ta(taLabel * taIn)
{ ta = taIn; }
rLabel * outputFeat2FaFTa::get_rLabel()
{ return a_rLabel; }
void outputFeat2FaFTa::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputFeat1FT::outputFeat1FT(){}

outputFeat1FT::outputFeat1FT(
  fLabel * fIn,
  pointRange * pointRangeIn,
  std::list<tLabel *> * tLabelListIn,
  rLabel * rLabelIn)
{
  f = fIn;
  a_pointRange = pointRangeIn;
  a_tLabelList = tLabelListIn;
  a_rLabel = rLabelIn;
}

outputFeat1FT::~outputFeat1FT(){}

void outputFeat1FT::printSelf()
{
  f->printSelf();
  if (a_pointRange)
    {
      a_pointRange->printSelf();
    }
  printf(",");
  if (a_tLabelList->begin() == a_tLabelList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<tLabel *>::iterator iter;
      for (iter = a_tLabelList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_tLabelList->end())
            break;
          printf(",");
        }
    }
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

fLabel * outputFeat1FT::get_f()
{ return f; }
void outputFeat1FT::set_f(fLabel * fIn)
{ f = fIn; }
pointRange * outputFeat1FT::get_pointRange()
{ return a_pointRange; }
void outputFeat1FT::set_pointRange(pointRange * pointRangeIn)
{ a_pointRange = pointRangeIn; }
std::list<tLabel *> * outputFeat1FT::get_tLabelList()
{ return a_tLabelList; }
void outputFeat1FT::set_tLabelList(std::list<tLabel *> * tLabelListIn)
{ a_tLabelList = tLabelListIn; }
rLabel * outputFeat1FT::get_rLabel()
{ return a_rLabel; }
void outputFeat1FT::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputFeat1FaTa::outputFeat1FaTa(){}

outputFeat1FaTa::outputFeat1FaTa(
  faLabel * faIn,
  pointRange * pointRangeIn,
  std::list<taLabel *> * taLabelListIn,
  rLabel * rLabelIn)
{
  fa = faIn;
  a_pointRange = pointRangeIn;
  a_taLabelList = taLabelListIn;
  a_rLabel = rLabelIn;
}

outputFeat1FaTa::~outputFeat1FaTa(){}

void outputFeat1FaTa::printSelf()
{
  fa->printSelf();
  if (a_pointRange)
    {
      a_pointRange->printSelf();
    }
  printf(",");
  if (a_taLabelList->begin() == a_taLabelList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<taLabel *>::iterator iter;
      for (iter = a_taLabelList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_taLabelList->end())
            break;
          printf(",");
        }
    }
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

faLabel * outputFeat1FaTa::get_fa()
{ return fa; }
void outputFeat1FaTa::set_fa(faLabel * faIn)
{ fa = faIn; }
pointRange * outputFeat1FaTa::get_pointRange()
{ return a_pointRange; }
void outputFeat1FaTa::set_pointRange(pointRange * pointRangeIn)
{ a_pointRange = pointRangeIn; }
std::list<taLabel *> * outputFeat1FaTa::get_taLabelList()
{ return a_taLabelList; }
void outputFeat1FaTa::set_taLabelList(std::list<taLabel *> * taLabelListIn)
{ a_taLabelList = taLabelListIn; }
rLabel * outputFeat1FaTa::get_rLabel()
{ return a_rLabel; }
void outputFeat1FaTa::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputDat::outputDat(){};

outputDat::~outputDat(){}

/********************************************************************/

outputDat_datLabel::outputDat_datLabel(){}

outputDat_datLabel::outputDat_datLabel(
  datLabel * datLabelIn,
  faLabel * faLabelIn,
  taLabel * taLabelIn,
  rLabel * rLabelIn)
{
  a_datLabel = datLabelIn;
  a_faLabel = faLabelIn;
  a_taLabel = taLabelIn;
  a_rLabel = rLabelIn;
}

outputDat_datLabel::~outputDat_datLabel(){}

void outputDat_datLabel::printSelf()
{
  a_datLabel->printSelf();
  printf(",");
  a_faLabel->printSelf();
  printf(",");
  a_taLabel->printSelf();
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

datLabel * outputDat_datLabel::get_datLabel()
{ return a_datLabel; }
void outputDat_datLabel::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
faLabel * outputDat_datLabel::get_faLabel()
{ return a_faLabel; }
void outputDat_datLabel::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
taLabel * outputDat_datLabel::get_taLabel()
{ return a_taLabel; }
void outputDat_datLabel::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
rLabel * outputDat_datLabel::get_rLabel()
{ return a_rLabel; }
void outputDat_datLabel::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputDat_faLabel::outputDat_faLabel(){}

outputDat_faLabel::outputDat_faLabel(
  faLabel * faLabelIn,
  datLabel * datLabelIn,
  taLabel * taLabelIn,
  rLabel * rLabelIn)
{
  a_faLabel = faLabelIn;
  a_datLabel = datLabelIn;
  a_taLabel = taLabelIn;
  a_rLabel = rLabelIn;
}

outputDat_faLabel::~outputDat_faLabel(){}

void outputDat_faLabel::printSelf()
{
  a_faLabel->printSelf();
  printf(",");
  a_datLabel->printSelf();
  printf(",");
  a_taLabel->printSelf();
  if (a_rLabel)
    {
      printf(",");
      a_rLabel->printSelf();
    }
}

faLabel * outputDat_faLabel::get_faLabel()
{ return a_faLabel; }
void outputDat_faLabel::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
datLabel * outputDat_faLabel::get_datLabel()
{ return a_datLabel; }
void outputDat_faLabel::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
taLabel * outputDat_faLabel::get_taLabel()
{ return a_taLabel; }
void outputDat_faLabel::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
rLabel * outputDat_faLabel::get_rLabel()
{ return a_rLabel; }
void outputDat_faLabel::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }

/********************************************************************/

outputReportData::outputReportData(){};

outputReportData::~outputReportData(){}

/********************************************************************/

outputConstData::outputConstData(){};

outputConstData::~outputConstData(){}

/********************************************************************/

outputConstGaugeData::outputConstGaugeData(){}

outputConstGaugeData::outputConstGaugeData(
  seLabel * seLabelIn)
{
  a_seLabel = seLabelIn;
}

outputConstGaugeData::~outputConstGaugeData(){}

void outputConstGaugeData::printSelf()
{
  a_seLabel->printSelf();
}

seLabel * outputConstGaugeData::get_seLabel()
{ return a_seLabel; }
void outputConstGaugeData::set_seLabel(seLabel * seLabelIn)
{ a_seLabel = seLabelIn; }

/********************************************************************/

outputConstPartData::outputConstPartData(){}

outputConstPartData::outputConstPartData(
  stLabel * stLabelIn)
{
  a_stLabel = stLabelIn;
}

outputConstPartData::~outputConstPartData(){}

void outputConstPartData::printSelf()
{
  a_stLabel->printSelf();
}

stLabel * outputConstPartData::get_stLabel()
{ return a_stLabel; }
void outputConstPartData::set_stLabel(stLabel * stLabelIn)
{ a_stLabel = stLabelIn; }

/********************************************************************/

outputConstBothData::outputConstBothData(){}

outputConstBothData::outputConstBothData(
  stLabel * stLabelIn,
  seLabel * seLabelIn,
  toleranceLabel * toleranceLabelIn)
{
  a_stLabel = stLabelIn;
  a_seLabel = seLabelIn;
  a_toleranceLabel = toleranceLabelIn;
}

outputConstBothData::~outputConstBothData(){}

void outputConstBothData::printSelf()
{
  a_stLabel->printSelf();
  printf(",");
  a_seLabel->printSelf();
  printf(",");
  a_toleranceLabel->printSelf();
}

stLabel * outputConstBothData::get_stLabel()
{ return a_stLabel; }
void outputConstBothData::set_stLabel(stLabel * stLabelIn)
{ a_stLabel = stLabelIn; }
seLabel * outputConstBothData::get_seLabel()
{ return a_seLabel; }
void outputConstBothData::set_seLabel(seLabel * seLabelIn)
{ a_seLabel = seLabelIn; }
toleranceLabel * outputConstBothData::get_toleranceLabel()
{ return a_toleranceLabel; }
void outputConstBothData::set_toleranceLabel(toleranceLabel * toleranceLabelIn)
{ a_toleranceLabel = toleranceLabelIn; }

/********************************************************************/

outputKeycharData::outputKeycharData(){};

outputKeycharData::~outputKeycharData(){}

/********************************************************************/

outputToleranceData::outputToleranceData(){};

outputToleranceData::~outputToleranceData(){}

/********************************************************************/

outputSensorData::outputSensorData(){};

outputSensorData::~outputSensorData(){}

/********************************************************************/

outputSensorData_sLabel::outputSensorData_sLabel(){}

outputSensorData_sLabel::outputSensorData_sLabel(
  sLabel * sLabelIn)
{
  a_sLabel = sLabelIn;
}

outputSensorData_sLabel::~outputSensorData_sLabel(){}

void outputSensorData_sLabel::printSelf()
{
  a_sLabel->printSelf();
}

sLabel * outputSensorData_sLabel::get_sLabel()
{ return a_sLabel; }
void outputSensorData_sLabel::set_sLabel(sLabel * sLabelIn)
{ a_sLabel = sLabelIn; }

/********************************************************************/

outputSensorData_saLabel::outputSensorData_saLabel(){}

outputSensorData_saLabel::outputSensorData_saLabel(
  saLabel * saLabelIn,
  outputSensorDesc * outputSensorDescIn)
{
  a_saLabel = saLabelIn;
  a_outputSensorDesc = outputSensorDescIn;
}

outputSensorData_saLabel::~outputSensorData_saLabel(){}

void outputSensorData_saLabel::printSelf()
{
  a_saLabel->printSelf();
  if (a_outputSensorDesc)
    {
      printf(",");
      a_outputSensorDesc->printSelf();
    }
}

saLabel * outputSensorData_saLabel::get_saLabel()
{ return a_saLabel; }
void outputSensorData_saLabel::set_saLabel(saLabel * saLabelIn)
{ a_saLabel = saLabelIn; }
outputSensorDesc * outputSensorData_saLabel::get_outputSensorDesc()
{ return a_outputSensorDesc; }
void outputSensorData_saLabel::set_outputSensorDesc(outputSensorDesc * outputSensorDescIn)
{ a_outputSensorDesc = outputSensorDescIn; }

/********************************************************************/

outputSensorDesc::outputSensorDesc(){};

outputSensorDesc::~outputSensorDesc(){}

/********************************************************************/

outputSensorDesc_stringVal::outputSensorDesc_stringVal(){}

outputSensorDesc_stringVal::outputSensorDesc_stringVal(
  stringVal * descIn,
  std::list<outputSensorWristItem *> * outputSensorWristListIn)
{
  desc = descIn;
  a_outputSensorWristList = outputSensorWristListIn;
}

outputSensorDesc_stringVal::~outputSensorDesc_stringVal(){}

void outputSensorDesc_stringVal::printSelf()
{
  desc->printSelf();
  if (a_outputSensorWristList)
    {
      printf(",");
      if (a_outputSensorWristList->begin() == a_outputSensorWristList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<outputSensorWristItem *>::iterator iter;
          for (iter = a_outputSensorWristList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_outputSensorWristList->end())
                break;
              printf(",");
            }
        }
    }
}

stringVal * outputSensorDesc_stringVal::get_desc()
{ return desc; }
void outputSensorDesc_stringVal::set_desc(stringVal * descIn)
{ desc = descIn; }
std::list<outputSensorWristItem *> * outputSensorDesc_stringVal::get_outputSensorWristList()
{ return a_outputSensorWristList; }
void outputSensorDesc_stringVal::set_outputSensorWristList(std::list<outputSensorWristItem *> * outputSensorWristListIn)
{ a_outputSensorWristList = outputSensorWristListIn; }

/********************************************************************/

outputSensorDesc_intVal::outputSensorDesc_intVal(){}

outputSensorDesc_intVal::outputSensorDesc_intVal(
  intVal * tipnumIn,
  std::list<outputSensorWristItem *> * outputSensorWristListIn)
{
  tipnum = tipnumIn;
  a_outputSensorWristList = outputSensorWristListIn;
}

outputSensorDesc_intVal::~outputSensorDesc_intVal(){}

void outputSensorDesc_intVal::printSelf()
{
  tipnum->printSelf();
  if (a_outputSensorWristList)
    {
      printf(",");
      if (a_outputSensorWristList->begin() == a_outputSensorWristList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<outputSensorWristItem *>::iterator iter;
          for (iter = a_outputSensorWristList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_outputSensorWristList->end())
                break;
              printf(",");
            }
        }
    }
}

intVal * outputSensorDesc_intVal::get_tipnum()
{ return tipnum; }
void outputSensorDesc_intVal::set_tipnum(intVal * tipnumIn)
{ tipnum = tipnumIn; }
std::list<outputSensorWristItem *> * outputSensorDesc_intVal::get_outputSensorWristList()
{ return a_outputSensorWristList; }
void outputSensorDesc_intVal::set_outputSensorWristList(std::list<outputSensorWristItem *> * outputSensorWristListIn)
{ a_outputSensorWristList = outputSensorWristListIn; }

/********************************************************************/

outputSensorDesc_outputSensorWristList::outputSensorDesc_outputSensorWristList(){}

outputSensorDesc_outputSensorWristList::outputSensorDesc_outputSensorWristList(
  std::list<outputSensorWristItem *> * outputSensorWristListIn)
{
  a_outputSensorWristList = outputSensorWristListIn;
}

outputSensorDesc_outputSensorWristList::~outputSensorDesc_outputSensorWristList(){}

void outputSensorDesc_outputSensorWristList::printSelf()
{
  if (a_outputSensorWristList->begin() == a_outputSensorWristList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<outputSensorWristItem *>::iterator iter;
      for (iter = a_outputSensorWristList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_outputSensorWristList->end())
            break;
          printf(",");
        }
    }
}

std::list<outputSensorWristItem *> * outputSensorDesc_outputSensorWristList::get_outputSensorWristList()
{ return a_outputSensorWristList; }
void outputSensorDesc_outputSensorWristList::set_outputSensorWristList(std::list<outputSensorWristItem *> * outputSensorWristListIn)
{ a_outputSensorWristList = outputSensorWristListIn; }

/********************************************************************/

outputSensorDesc_CURENT::outputSensorDesc_CURENT(){}

outputSensorDesc_CURENT::~outputSensorDesc_CURENT(){}

void outputSensorDesc_CURENT::printSelf()
{
  printf("CURENT");
}

/********************************************************************/

outputSensorWristItem::outputSensorWristItem(){}

outputSensorWristItem::outputSensorWristItem(
  swLabel * swLabelIn,
  std::list<outputSensorWristAngle *> * outputSensorWristAngleListIn)
{
  a_swLabel = swLabelIn;
  a_outputSensorWristAngleList = outputSensorWristAngleListIn;
}

outputSensorWristItem::~outputSensorWristItem(){}

void outputSensorWristItem::printSelf()
{
  a_swLabel->printSelf();
  printf(",");
  if (a_outputSensorWristAngleList->begin() == a_outputSensorWristAngleList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<outputSensorWristAngle *>::iterator iter;
      for (iter = a_outputSensorWristAngleList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_outputSensorWristAngleList->end())
            break;
          printf(",");
        }
    }
}

swLabel * outputSensorWristItem::get_swLabel()
{ return a_swLabel; }
void outputSensorWristItem::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
std::list<outputSensorWristAngle *> * outputSensorWristItem::get_outputSensorWristAngleList()
{ return a_outputSensorWristAngleList; }
void outputSensorWristItem::set_outputSensorWristAngleList(std::list<outputSensorWristAngle *> * outputSensorWristAngleListIn)
{ a_outputSensorWristAngleList = outputSensorWristAngleListIn; }

/********************************************************************/

outputSensorWristAngle::outputSensorWristAngle(){}

outputSensorWristAngle::outputSensorWristAngle(
  stringVal * anglenameIn,
  angle * angleIn)
{
  anglename = anglenameIn;
  a_angle = angleIn;
}

outputSensorWristAngle::~outputSensorWristAngle(){}

void outputSensorWristAngle::printSelf()
{
  anglename->printSelf();
  printf(",");
  a_angle->printSelf();
}

stringVal * outputSensorWristAngle::get_anglename()
{ return anglename; }
void outputSensorWristAngle::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }
angle * outputSensorWristAngle::get_angle()
{ return a_angle; }
void outputSensorWristAngle::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

pameasMinor::pameasMinor(){};

pameasMinor::~pameasMinor(){}

/********************************************************************/

pameasMinor_pameasVar2List::pameasMinor_pameasVar2List(){}

pameasMinor_pameasVar2List::pameasMinor_pameasVar2List(
  std::list<pameasVar2ListItem *> * pameasVar2ListIn)
{
  a_pameasVar2List = pameasVar2ListIn;
}

pameasMinor_pameasVar2List::~pameasMinor_pameasVar2List(){}

void pameasMinor_pameasVar2List::printSelf()
{
  if (a_pameasVar2List->begin() == a_pameasVar2List->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<pameasVar2ListItem *>::iterator iter;
      for (iter = a_pameasVar2List->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_pameasVar2List->end())
            break;
          printf(",");
        }
    }
}

std::list<pameasVar2ListItem *> * pameasMinor_pameasVar2List::get_pameasVar2List()
{ return a_pameasVar2List; }
void pameasMinor_pameasVar2List::set_pameasVar2List(std::list<pameasVar2ListItem *> * pameasVar2ListIn)
{ a_pameasVar2List = pameasVar2ListIn; }

/********************************************************************/

pameasMinor_pameasVar3List::pameasMinor_pameasVar3List(){}

pameasMinor_pameasVar3List::pameasMinor_pameasVar3List(
  std::list<pameasVar3ListItem *> * pameasVar3ListIn)
{
  a_pameasVar3List = pameasVar3ListIn;
}

pameasMinor_pameasVar3List::~pameasMinor_pameasVar3List(){}

void pameasMinor_pameasVar3List::printSelf()
{
  if (a_pameasVar3List->begin() == a_pameasVar3List->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<pameasVar3ListItem *>::iterator iter;
      for (iter = a_pameasVar3List->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_pameasVar3List->end())
            break;
          printf(",");
        }
    }
}

std::list<pameasVar3ListItem *> * pameasMinor_pameasVar3List::get_pameasVar3List()
{ return a_pameasVar3List; }
void pameasMinor_pameasVar3List::set_pameasVar3List(std::list<pameasVar3ListItem *> * pameasVar3ListIn)
{ a_pameasVar3List = pameasVar3ListIn; }

/********************************************************************/

pameasDetail::pameasDetail(){};

pameasDetail::~pameasDetail(){}

/********************************************************************/

pameasDetailDistance::pameasDetailDistance(){}

pameasDetailDistance::pameasDetailDistance(
  rentVal * distIn,
  pameasFedrat * feedIn,
  rentVal * pitchIn)
{
  dist = distIn;
  feed = feedIn;
  pitch = pitchIn;
}

pameasDetailDistance::~pameasDetailDistance(){}

void pameasDetailDistance::printSelf()
{
  printf("DISTANCE");
  printf(",");
  dist->printSelf();
  if (feed)
    {
      printf(",");
      printf("SCNVEL");
      printf(",");
      feed->printSelf();
    }
  if (pitch)
    {
      printf(",");
      printf("PITCH");
      printf(",");
      pitch->printSelf();
    }
}

rentVal * pameasDetailDistance::get_dist()
{ return dist; }
void pameasDetailDistance::set_dist(rentVal * distIn)
{ dist = distIn; }
pameasFedrat * pameasDetailDistance::get_feed()
{ return feed; }
void pameasDetailDistance::set_feed(pameasFedrat * feedIn)
{ feed = feedIn; }
rentVal * pameasDetailDistance::get_pitch()
{ return pitch; }
void pameasDetailDistance::set_pitch(rentVal * pitchIn)
{ pitch = pitchIn; }

/********************************************************************/

pameasDetailScnvelData::pameasDetailScnvelData(){}

pameasDetailScnvelData::pameasDetailScnvelData(
  pameasFedrat * feedIn,
  rentVal * pitchIn)
{
  feed = feedIn;
  pitch = pitchIn;
}

pameasDetailScnvelData::~pameasDetailScnvelData(){}

void pameasDetailScnvelData::printSelf()
{
  printf("SCNVEL");
  printf(",");
  feed->printSelf();
  if (pitch)
    {
      printf(",");
      printf("PITCH");
      printf(",");
      pitch->printSelf();
    }
}

pameasFedrat * pameasDetailScnvelData::get_feed()
{ return feed; }
void pameasDetailScnvelData::set_feed(pameasFedrat * feedIn)
{ feed = feedIn; }
rentVal * pameasDetailScnvelData::get_pitch()
{ return pitch; }
void pameasDetailScnvelData::set_pitch(rentVal * pitchIn)
{ pitch = pitchIn; }

/********************************************************************/

pameasDetailPitch::pameasDetailPitch(){}

pameasDetailPitch::pameasDetailPitch(
  rentVal * pitchIn)
{
  pitch = pitchIn;
}

pameasDetailPitch::~pameasDetailPitch(){}

void pameasDetailPitch::printSelf()
{
  printf("PITCH");
  printf(",");
  pitch->printSelf();
}

rentVal * pameasDetailPitch::get_pitch()
{ return pitch; }
void pameasDetailPitch::set_pitch(rentVal * pitchIn)
{ pitch = pitchIn; }

/********************************************************************/

pameasDetailNoData::pameasDetailNoData(){}

pameasDetailNoData::~pameasDetailNoData(){}

void pameasDetailNoData::printSelf()
{
  printf("NODATA");
}

/********************************************************************/

pameasDetailScnvelNoData::pameasDetailScnvelNoData(){}

pameasDetailScnvelNoData::pameasDetailScnvelNoData(
  pameasFedrat * feedIn)
{
  feed = feedIn;
}

pameasDetailScnvelNoData::~pameasDetailScnvelNoData(){}

void pameasDetailScnvelNoData::printSelf()
{
  printf("SCNVEL");
  printf(",");
  feed->printSelf();
  printf(",");
  printf("NODATA");
}

pameasFedrat * pameasDetailScnvelNoData::get_feed()
{ return feed; }
void pameasDetailScnvelNoData::set_feed(pameasFedrat * feedIn)
{ feed = feedIn; }

/********************************************************************/

pameasVar2ListItem::pameasVar2ListItem(){}

pameasVar2ListItem::pameasVar2ListItem(
  pameasDetail * pameasDetailIn,
  pLabel * pLabelIn,
  vector * apprchIn,
  vector * forceVecIn,
  forceOrDeflection * forceOrDeflectionIn,
  pameasRemove * pameasRemoveIn,
  rtLabel * rtLabelIn)
{
  a_pameasDetail = pameasDetailIn;
  a_pLabel = pLabelIn;
  apprch = apprchIn;
  forceVec = forceVecIn;
  a_forceOrDeflection = forceOrDeflectionIn;
  a_pameasRemove = pameasRemoveIn;
  a_rtLabel = rtLabelIn;
}

pameasVar2ListItem::~pameasVar2ListItem(){}

void pameasVar2ListItem::printSelf()
{
  a_pameasDetail->printSelf();
  printf(",");
  a_pLabel->printSelf();
  if (apprch)
    {
      printf(",");
      apprch->printSelf();
    }
  if (forceVec)
    {
      printf(",");
      printf("SELFCENTER");
      printf(",");
      forceVec->printSelf();
      if (a_forceOrDeflection)
        {
          printf(",");
          a_forceOrDeflection->printSelf();
        }
    }
  if (a_pameasRemove)
    {
      printf(",");
      a_pameasRemove->printSelf();
    }
  if (a_rtLabel)
    {
      printf(",");
      printf("ROTARY");
      printf(",");
      a_rtLabel->printSelf();
    }
}

pameasDetail * pameasVar2ListItem::get_pameasDetail()
{ return a_pameasDetail; }
void pameasVar2ListItem::set_pameasDetail(pameasDetail * pameasDetailIn)
{ a_pameasDetail = pameasDetailIn; }
pLabel * pameasVar2ListItem::get_pLabel()
{ return a_pLabel; }
void pameasVar2ListItem::set_pLabel(pLabel * pLabelIn)
{ a_pLabel = pLabelIn; }
vector * pameasVar2ListItem::get_apprch()
{ return apprch; }
void pameasVar2ListItem::set_apprch(vector * apprchIn)
{ apprch = apprchIn; }
vector * pameasVar2ListItem::get_forceVec()
{ return forceVec; }
void pameasVar2ListItem::set_forceVec(vector * forceVecIn)
{ forceVec = forceVecIn; }
forceOrDeflection * pameasVar2ListItem::get_forceOrDeflection()
{ return a_forceOrDeflection; }
void pameasVar2ListItem::set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn)
{ a_forceOrDeflection = forceOrDeflectionIn; }
pameasRemove * pameasVar2ListItem::get_pameasRemove()
{ return a_pameasRemove; }
void pameasVar2ListItem::set_pameasRemove(pameasRemove * pameasRemoveIn)
{ a_pameasRemove = pameasRemoveIn; }
rtLabel * pameasVar2ListItem::get_rtLabel()
{ return a_rtLabel; }
void pameasVar2ListItem::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }

/********************************************************************/

pameasVar3ListItem::pameasVar3ListItem(){}

pameasVar3ListItem::pameasVar3ListItem(
  pLabel * pLabelIn,
  vector * apprchIn,
  vector * forceVecIn,
  forceOrDeflection * forceOrDeflectionIn,
  pameasRemove * pameasRemoveIn,
  rtLabel * rtLabelIn)
{
  a_pLabel = pLabelIn;
  apprch = apprchIn;
  forceVec = forceVecIn;
  a_forceOrDeflection = forceOrDeflectionIn;
  a_pameasRemove = pameasRemoveIn;
  a_rtLabel = rtLabelIn;
}

pameasVar3ListItem::~pameasVar3ListItem(){}

void pameasVar3ListItem::printSelf()
{
  a_pLabel->printSelf();
  if (apprch)
    {
      printf(",");
      apprch->printSelf();
    }
  if (forceVec)
    {
      printf(",");
      printf("SELFCENTER");
      printf(",");
      forceVec->printSelf();
      if (a_forceOrDeflection)
        {
          printf(",");
          a_forceOrDeflection->printSelf();
        }
    }
  if (a_pameasRemove)
    {
      printf(",");
      a_pameasRemove->printSelf();
    }
  if (a_rtLabel)
    {
      printf(",");
      printf("ROTARY");
      printf(",");
      a_rtLabel->printSelf();
    }
}

pLabel * pameasVar3ListItem::get_pLabel()
{ return a_pLabel; }
void pameasVar3ListItem::set_pLabel(pLabel * pLabelIn)
{ a_pLabel = pLabelIn; }
vector * pameasVar3ListItem::get_apprch()
{ return apprch; }
void pameasVar3ListItem::set_apprch(vector * apprchIn)
{ apprch = apprchIn; }
vector * pameasVar3ListItem::get_forceVec()
{ return forceVec; }
void pameasVar3ListItem::set_forceVec(vector * forceVecIn)
{ forceVec = forceVecIn; }
forceOrDeflection * pameasVar3ListItem::get_forceOrDeflection()
{ return a_forceOrDeflection; }
void pameasVar3ListItem::set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn)
{ a_forceOrDeflection = forceOrDeflectionIn; }
pameasRemove * pameasVar3ListItem::get_pameasRemove()
{ return a_pameasRemove; }
void pameasVar3ListItem::set_pameasRemove(pameasRemove * pameasRemoveIn)
{ a_pameasRemove = pameasRemoveIn; }
rtLabel * pameasVar3ListItem::get_rtLabel()
{ return a_rtLabel; }
void pameasVar3ListItem::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }

/********************************************************************/

pameasRemove::pameasRemove(){};

pameasRemove::~pameasRemove(){}

/********************************************************************/

pameasRemoveCount::pameasRemoveCount(){}

pameasRemoveCount::pameasRemoveCount(
  intVal * numPt1In,
  intVal * numPt2In)
{
  numPt1 = numPt1In;
  numPt2 = numPt2In;
}

pameasRemoveCount::~pameasRemoveCount(){}

void pameasRemoveCount::printSelf()
{
  printf("REMOVE");
  printf(",");
  printf("COUNT");
  printf(",");
  numPt1->printSelf();
  printf(",");
  numPt2->printSelf();
}

intVal * pameasRemoveCount::get_numPt1()
{ return numPt1; }
void pameasRemoveCount::set_numPt1(intVal * numPt1In)
{ numPt1 = numPt1In; }
intVal * pameasRemoveCount::get_numPt2()
{ return numPt2; }
void pameasRemoveCount::set_numPt2(intVal * numPt2In)
{ numPt2 = numPt2In; }

/********************************************************************/

pameasRemoveDist::pameasRemoveDist(){}

pameasRemoveDist::pameasRemoveDist(
  rentVal * dist1In,
  rentVal * dist2In)
{
  dist1 = dist1In;
  dist2 = dist2In;
}

pameasRemoveDist::~pameasRemoveDist(){}

void pameasRemoveDist::printSelf()
{
  printf("REMOVE");
  printf(",");
  printf("DIST");
  printf(",");
  dist1->printSelf();
  printf(",");
  dist2->printSelf();
}

rentVal * pameasRemoveDist::get_dist1()
{ return dist1; }
void pameasRemoveDist::set_dist1(rentVal * dist1In)
{ dist1 = dist1In; }
rentVal * pameasRemoveDist::get_dist2()
{ return dist2; }
void pameasRemoveDist::set_dist2(rentVal * dist2In)
{ dist2 = dist2In; }

/********************************************************************/

pameasRemoveAll::pameasRemoveAll(){}

pameasRemoveAll::~pameasRemoveAll(){}

void pameasRemoveAll::printSelf()
{
  printf("REMOVE");
  printf(",");
  printf("ALL");
}

/********************************************************************/

pameasFedrat::pameasFedrat(){};

pameasFedrat::~pameasFedrat(){}

/********************************************************************/

pameasFedrat_MPM::pameasFedrat_MPM(){}

pameasFedrat_MPM::pameasFedrat_MPM(
  rentVal * rateIn)
{
  rate = rateIn;
}

pameasFedrat_MPM::~pameasFedrat_MPM(){}

void pameasFedrat_MPM::printSelf()
{
  printf("MPM");
  printf(",");
  rate->printSelf();
}

rentVal * pameasFedrat_MPM::get_rate()
{ return rate; }
void pameasFedrat_MPM::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

pameasFedrat_MMPS::pameasFedrat_MMPS(){}

pameasFedrat_MMPS::pameasFedrat_MMPS(
  rentVal * rateIn)
{
  rate = rateIn;
}

pameasFedrat_MMPS::~pameasFedrat_MMPS(){}

void pameasFedrat_MMPS::printSelf()
{
  printf("MMPS");
  printf(",");
  rate->printSelf();
}

rentVal * pameasFedrat_MMPS::get_rate()
{ return rate; }
void pameasFedrat_MMPS::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

pameasFedrat_IPM::pameasFedrat_IPM(){}

pameasFedrat_IPM::pameasFedrat_IPM(
  rentVal * rateIn)
{
  rate = rateIn;
}

pameasFedrat_IPM::~pameasFedrat_IPM(){}

void pameasFedrat_IPM::printSelf()
{
  printf("IPM");
  printf(",");
  rate->printSelf();
}

rentVal * pameasFedrat_IPM::get_rate()
{ return rate; }
void pameasFedrat_IPM::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

pameasFedrat_IPS::pameasFedrat_IPS(){}

pameasFedrat_IPS::pameasFedrat_IPS(
  rentVal * rateIn)
{
  rate = rateIn;
}

pameasFedrat_IPS::~pameasFedrat_IPS(){}

void pameasFedrat_IPS::printSelf()
{
  printf("IPS");
  printf(",");
  rate->printSelf();
}

rentVal * pameasFedrat_IPS::get_rate()
{ return rate; }
void pameasFedrat_IPS::set_rate(rentVal * rateIn)
{ rate = rateIn; }

/********************************************************************/

partidStm::partidStm(){}

partidStm::partidStm(
  pnLabel * pnLabelIn,
  stringVal * textIn)
{
  a_pnLabel = pnLabelIn;
  text = textIn;
}

partidStm::~partidStm(){}

void partidStm::printSelf()
{
  a_pnLabel->printSelf();
  printf("=");
  printf("PARTID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

pnLabel * partidStm::get_pnLabel()
{ return a_pnLabel; }
void partidStm::set_pnLabel(pnLabel * pnLabelIn)
{ a_pnLabel = pnLabelIn; }
stringVal * partidStm::get_text()
{ return text; }
void partidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

partrvStm::partrvStm(){}

partrvStm::partrvStm(
  prLabel * prLabelIn,
  stringVal * textIn)
{
  a_prLabel = prLabelIn;
  text = textIn;
}

partrvStm::~partrvStm(){}

void partrvStm::printSelf()
{
  a_prLabel->printSelf();
  printf("=");
  printf("PARTRV");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

prLabel * partrvStm::get_prLabel()
{ return a_prLabel; }
void partrvStm::set_prLabel(prLabel * prLabelIn)
{ a_prLabel = prLabelIn; }
stringVal * partrvStm::get_text()
{ return text; }
void partrvStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

partsnStm::partsnStm(){}

partsnStm::partsnStm(
  psLabel * psLabelIn,
  stringVal * textIn)
{
  a_psLabel = psLabelIn;
  text = textIn;
}

partsnStm::~partsnStm(){}

void partsnStm::printSelf()
{
  a_psLabel->printSelf();
  printf("=");
  printf("PARTSN");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

psLabel * partsnStm::get_psLabel()
{ return a_psLabel; }
void partsnStm::set_psLabel(psLabel * psLabelIn)
{ a_psLabel = psLabelIn; }
stringVal * partsnStm::get_text()
{ return text; }
void partsnStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

pathStm::pathStm(){}

pathStm::pathStm(
  pLabel * pLabelIn,
  pathMinor * pathMinorIn)
{
  a_pLabel = pLabelIn;
  a_pathMinor = pathMinorIn;
}

pathStm::~pathStm(){}

void pathStm::printSelf()
{
  a_pLabel->printSelf();
  printf("=");
  printf("PATH");
  printf("/");
  a_pathMinor->printSelf();
  printf("%c%c", 13, 10);
}

pLabel * pathStm::get_pLabel()
{ return a_pLabel; }
void pathStm::set_pLabel(pLabel * pLabelIn)
{ a_pLabel = pLabelIn; }
pathMinor * pathStm::get_pathMinor()
{ return a_pathMinor; }
void pathStm::set_pathMinor(pathMinor * pathMinorIn)
{ a_pathMinor = pathMinorIn; }

/********************************************************************/

pathMinor::pathMinor(){};

pathMinor::~pathMinor(){}

/********************************************************************/

euler::euler(){}

euler::euler(
  rentVal * ang1In,
  rentVal * ang2In,
  rentVal * ang3In)
{
  ang1 = ang1In;
  ang2 = ang2In;
  ang3 = ang3In;
}

euler::~euler(){}

void euler::printSelf()
{
  ang1->printSelf();
  printf(",");
  ang2->printSelf();
  printf(",");
  ang3->printSelf();
}

rentVal * euler::get_ang1()
{ return ang1; }
void euler::set_ang1(rentVal * ang1In)
{ ang1 = ang1In; }
rentVal * euler::get_ang2()
{ return ang2; }
void euler::set_ang2(rentVal * ang2In)
{ ang2 = ang2In; }
rentVal * euler::get_ang3()
{ return ang3; }
void euler::set_ang3(rentVal * ang3In)
{ ang3 = ang3In; }

/********************************************************************/

pathPoint::pathPoint(){}

pathPoint::pathPoint(
  typePoint * typePointIn,
  vector * dirIn)
{
  a_typePoint = typePointIn;
  dir = dirIn;
}

pathPoint::~pathPoint(){}

void pathPoint::printSelf()
{
  printf("POINT");
  printf(",");
  a_typePoint->printSelf();
  printf(",");
  dir->printSelf();
}

typePoint * pathPoint::get_typePoint()
{ return a_typePoint; }
void pathPoint::set_typePoint(typePoint * typePointIn)
{ a_typePoint = typePointIn; }
vector * pathPoint::get_dir()
{ return dir; }
void pathPoint::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

pathArc::pathArc(){}

pathArc::pathArc(
  typePoint * centerIn,
  vector * planeVecIn,
  rentVal * radiusIn,
  angle * startAngleIn,
  angle * includAngleIn,
  vector * startVecIn)
{
  center = centerIn;
  planeVec = planeVecIn;
  radius = radiusIn;
  startAngle = startAngleIn;
  includAngle = includAngleIn;
  startVec = startVecIn;
}

pathArc::~pathArc(){}

void pathArc::printSelf()
{
  printf("ARC");
  printf(",");
  center->printSelf();
  printf(",");
  planeVec->printSelf();
  printf(",");
  radius->printSelf();
  printf(",");
  startAngle->printSelf();
  printf(",");
  includAngle->printSelf();
  if (startVec)
    {
      printf(",");
      startVec->printSelf();
    }
}

typePoint * pathArc::get_center()
{ return center; }
void pathArc::set_center(typePoint * centerIn)
{ center = centerIn; }
vector * pathArc::get_planeVec()
{ return planeVec; }
void pathArc::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }
rentVal * pathArc::get_radius()
{ return radius; }
void pathArc::set_radius(rentVal * radiusIn)
{ radius = radiusIn; }
angle * pathArc::get_startAngle()
{ return startAngle; }
void pathArc::set_startAngle(angle * startAngleIn)
{ startAngle = startAngleIn; }
angle * pathArc::get_includAngle()
{ return includAngle; }
void pathArc::set_includAngle(angle * includAngleIn)
{ includAngle = includAngleIn; }
vector * pathArc::get_startVec()
{ return startVec; }
void pathArc::set_startVec(vector * startVecIn)
{ startVec = startVecIn; }

/********************************************************************/

pathCurve::pathCurve(){};

pathCurve::~pathCurve(){}

/********************************************************************/

pathCurve_pathCurvePtdata::pathCurve_pathCurvePtdata(){}

pathCurve_pathCurvePtdata::pathCurve_pathCurvePtdata(
  pathCurvePtdata * pathCurvePtdataIn)
{
  a_pathCurvePtdata = pathCurvePtdataIn;
}

pathCurve_pathCurvePtdata::~pathCurve_pathCurvePtdata(){}

void pathCurve_pathCurvePtdata::printSelf()
{
  printf("CURVE");
  printf(",");
  a_pathCurvePtdata->printSelf();
}

pathCurvePtdata * pathCurve_pathCurvePtdata::get_pathCurvePtdata()
{ return a_pathCurvePtdata; }
void pathCurve_pathCurvePtdata::set_pathCurvePtdata(pathCurvePtdata * pathCurvePtdataIn)
{ a_pathCurvePtdata = pathCurvePtdataIn; }

/********************************************************************/

pathCurve_pathCurvePoints::pathCurve_pathCurvePoints(){}

pathCurve_pathCurvePoints::pathCurve_pathCurvePoints(
  pathCurvePoints * pathCurvePointsIn)
{
  a_pathCurvePoints = pathCurvePointsIn;
}

pathCurve_pathCurvePoints::~pathCurve_pathCurvePoints(){}

void pathCurve_pathCurvePoints::printSelf()
{
  printf("CURVE");
  printf(",");
  a_pathCurvePoints->printSelf();
}

pathCurvePoints * pathCurve_pathCurvePoints::get_pathCurvePoints()
{ return a_pathCurvePoints; }
void pathCurve_pathCurvePoints::set_pathCurvePoints(pathCurvePoints * pathCurvePointsIn)
{ a_pathCurvePoints = pathCurvePointsIn; }

/********************************************************************/

pathCurvePtdata::pathCurvePtdata(){};

pathCurvePtdata::~pathCurvePtdata(){}

/********************************************************************/

curvePtdataPcs::curvePtdataPcs(){}

curvePtdataPcs::curvePtdataPcs(
  pointVecCart * pointVecCartIn,
  euler * eulerIn,
  std::list<curvePtdataPcsListItem *> * curvePtdataPcsListIn)
{
  a_pointVecCart = pointVecCartIn;
  a_euler = eulerIn;
  a_curvePtdataPcsList = curvePtdataPcsListIn;
}

curvePtdataPcs::~curvePtdataPcs(){}

void curvePtdataPcs::printSelf()
{
  printf("PTDATA");
  printf(",");
  a_pointVecCart->printSelf();
  if (a_euler)
    {
      printf(",");
      printf("PCS");
      printf(",");
      a_euler->printSelf();
    }
  printf(",");
  if (a_curvePtdataPcsList->begin() == a_curvePtdataPcsList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<curvePtdataPcsListItem *>::iterator iter;
      for (iter = a_curvePtdataPcsList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_curvePtdataPcsList->end())
            break;
          printf(",");
        }
    }
}

pointVecCart * curvePtdataPcs::get_pointVecCart()
{ return a_pointVecCart; }
void curvePtdataPcs::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
euler * curvePtdataPcs::get_euler()
{ return a_euler; }
void curvePtdataPcs::set_euler(euler * eulerIn)
{ a_euler = eulerIn; }
std::list<curvePtdataPcsListItem *> * curvePtdataPcs::get_curvePtdataPcsList()
{ return a_curvePtdataPcsList; }
void curvePtdataPcs::set_curvePtdataPcsList(std::list<curvePtdataPcsListItem *> * curvePtdataPcsListIn)
{ a_curvePtdataPcsList = curvePtdataPcsListIn; }

/********************************************************************/

curvePtdataPcsListItem::curvePtdataPcsListItem(){}

curvePtdataPcsListItem::curvePtdataPcsListItem(
  pointVecCart * pointVecCartIn,
  euler * eulerIn)
{
  a_pointVecCart = pointVecCartIn;
  a_euler = eulerIn;
}

curvePtdataPcsListItem::~curvePtdataPcsListItem(){}

void curvePtdataPcsListItem::printSelf()
{
  printf("PTDATA");
  printf(",");
  a_pointVecCart->printSelf();
  if (a_euler)
    {
      printf(",");
      printf("PCS");
      printf(",");
      a_euler->printSelf();
    }
}

pointVecCart * curvePtdataPcsListItem::get_pointVecCart()
{ return a_pointVecCart; }
void curvePtdataPcsListItem::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
euler * curvePtdataPcsListItem::get_euler()
{ return a_euler; }
void curvePtdataPcsListItem::set_euler(euler * eulerIn)
{ a_euler = eulerIn; }

/********************************************************************/

curvePtdataHeadcs::curvePtdataHeadcs(){}

curvePtdataHeadcs::curvePtdataHeadcs(
  pointVecCart * pointVecCartIn,
  rentVal * rot1In,
  rentVal * rot2In,
  rentVal * rot3In,
  std::list<curvePtdataHeadcsListItem *> * curvePtdataHeadcsListIn)
{
  a_pointVecCart = pointVecCartIn;
  rot1 = rot1In;
  rot2 = rot2In;
  rot3 = rot3In;
  a_curvePtdataHeadcsList = curvePtdataHeadcsListIn;
}

curvePtdataHeadcs::~curvePtdataHeadcs(){}

void curvePtdataHeadcs::printSelf()
{
  printf("PTDATA");
  printf(",");
  a_pointVecCart->printSelf();
  printf(",");
  printf("HEADCS");
  printf(",");
  rot1->printSelf();
  printf(",");
  rot2->printSelf();
  if (rot3)
    {
      printf(",");
      rot3->printSelf();
    }
  printf(",");
  if (a_curvePtdataHeadcsList->begin() == a_curvePtdataHeadcsList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<curvePtdataHeadcsListItem *>::iterator iter;
      for (iter = a_curvePtdataHeadcsList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_curvePtdataHeadcsList->end())
            break;
          printf(",");
        }
    }
}

pointVecCart * curvePtdataHeadcs::get_pointVecCart()
{ return a_pointVecCart; }
void curvePtdataHeadcs::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
rentVal * curvePtdataHeadcs::get_rot1()
{ return rot1; }
void curvePtdataHeadcs::set_rot1(rentVal * rot1In)
{ rot1 = rot1In; }
rentVal * curvePtdataHeadcs::get_rot2()
{ return rot2; }
void curvePtdataHeadcs::set_rot2(rentVal * rot2In)
{ rot2 = rot2In; }
rentVal * curvePtdataHeadcs::get_rot3()
{ return rot3; }
void curvePtdataHeadcs::set_rot3(rentVal * rot3In)
{ rot3 = rot3In; }
std::list<curvePtdataHeadcsListItem *> * curvePtdataHeadcs::get_curvePtdataHeadcsList()
{ return a_curvePtdataHeadcsList; }
void curvePtdataHeadcs::set_curvePtdataHeadcsList(std::list<curvePtdataHeadcsListItem *> * curvePtdataHeadcsListIn)
{ a_curvePtdataHeadcsList = curvePtdataHeadcsListIn; }

/********************************************************************/

curvePtdataHeadcsListItem::curvePtdataHeadcsListItem(){}

curvePtdataHeadcsListItem::curvePtdataHeadcsListItem(
  pointVecCart * pointVecCartIn,
  rentVal * rot1In,
  rentVal * rot2In,
  rentVal * rot3In)
{
  a_pointVecCart = pointVecCartIn;
  rot1 = rot1In;
  rot2 = rot2In;
  rot3 = rot3In;
}

curvePtdataHeadcsListItem::~curvePtdataHeadcsListItem(){}

void curvePtdataHeadcsListItem::printSelf()
{
  printf("PTDATA");
  printf(",");
  a_pointVecCart->printSelf();
  if (rot1)
    {
      printf(",");
      printf("HEADCS");
      printf(",");
      rot1->printSelf();
      printf(",");
      rot2->printSelf();
      if (rot3)
        {
          printf(",");
          rot3->printSelf();
        }
    }
}

pointVecCart * curvePtdataHeadcsListItem::get_pointVecCart()
{ return a_pointVecCart; }
void curvePtdataHeadcsListItem::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
rentVal * curvePtdataHeadcsListItem::get_rot1()
{ return rot1; }
void curvePtdataHeadcsListItem::set_rot1(rentVal * rot1In)
{ rot1 = rot1In; }
rentVal * curvePtdataHeadcsListItem::get_rot2()
{ return rot2; }
void curvePtdataHeadcsListItem::set_rot2(rentVal * rot2In)
{ rot2 = rot2In; }
rentVal * curvePtdataHeadcsListItem::get_rot3()
{ return rot3; }
void curvePtdataHeadcsListItem::set_rot3(rentVal * rot3In)
{ rot3 = rot3In; }

/********************************************************************/

pathCurvePoints::pathCurvePoints(){}

pathCurvePoints::pathCurvePoints(
  pointVecCart * pointVecCartIn,
  std::list<pointVecCart *> * pointVecCartListIn)
{
  a_pointVecCart = pointVecCartIn;
  a_pointVecCartList = pointVecCartListIn;
}

pathCurvePoints::~pathCurvePoints(){}

void pathCurvePoints::printSelf()
{
  a_pointVecCart->printSelf();
  printf(",");
  if (a_pointVecCartList->begin() == a_pointVecCartList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<pointVecCart *>::iterator iter;
      for (iter = a_pointVecCartList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_pointVecCartList->end())
            break;
          printf(",");
        }
    }
}

pointVecCart * pathCurvePoints::get_pointVecCart()
{ return a_pointVecCart; }
void pathCurvePoints::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
std::list<pointVecCart *> * pathCurvePoints::get_pointVecCartList()
{ return a_pointVecCartList; }
void pathCurvePoints::set_pointVecCartList(std::list<pointVecCart *> * pointVecCartListIn)
{ a_pointVecCartList = pointVecCartListIn; }

/********************************************************************/

pathHelical::pathHelical(){}

pathHelical::pathHelical(
  typePoint * centerIn,
  vector * axisVecIn,
  rentVal * radiusIn,
  angle * startAngleIn,
  angle * includAngleIn,
  vector * startVecIn,
  rentVal * pitchIn,
  angle * coneAngleIn)
{
  center = centerIn;
  axisVec = axisVecIn;
  radius = radiusIn;
  startAngle = startAngleIn;
  includAngle = includAngleIn;
  startVec = startVecIn;
  pitch = pitchIn;
  coneAngle = coneAngleIn;
}

pathHelical::~pathHelical(){}

void pathHelical::printSelf()
{
  printf("HELICAL");
  printf(",");
  center->printSelf();
  printf(",");
  axisVec->printSelf();
  printf(",");
  radius->printSelf();
  printf(",");
  startAngle->printSelf();
  printf(",");
  includAngle->printSelf();
  if (startVec)
    {
      printf(",");
      startVec->printSelf();
    }
  printf(",");
  pitch->printSelf();
  if (coneAngle)
    {
      printf(",");
      coneAngle->printSelf();
    }
}

typePoint * pathHelical::get_center()
{ return center; }
void pathHelical::set_center(typePoint * centerIn)
{ center = centerIn; }
vector * pathHelical::get_axisVec()
{ return axisVec; }
void pathHelical::set_axisVec(vector * axisVecIn)
{ axisVec = axisVecIn; }
rentVal * pathHelical::get_radius()
{ return radius; }
void pathHelical::set_radius(rentVal * radiusIn)
{ radius = radiusIn; }
angle * pathHelical::get_startAngle()
{ return startAngle; }
void pathHelical::set_startAngle(angle * startAngleIn)
{ startAngle = startAngleIn; }
angle * pathHelical::get_includAngle()
{ return includAngle; }
void pathHelical::set_includAngle(angle * includAngleIn)
{ includAngle = includAngleIn; }
vector * pathHelical::get_startVec()
{ return startVec; }
void pathHelical::set_startVec(vector * startVecIn)
{ startVec = startVecIn; }
rentVal * pathHelical::get_pitch()
{ return pitch; }
void pathHelical::set_pitch(rentVal * pitchIn)
{ pitch = pitchIn; }
angle * pathHelical::get_coneAngle()
{ return coneAngle; }
void pathHelical::set_coneAngle(angle * coneAngleIn)
{ coneAngle = coneAngleIn; }

/********************************************************************/

pathLine::pathLine(){};

pathLine::~pathLine(){}

/********************************************************************/

pathLineCart::pathLineCart(){}

pathLineCart::pathLineCart(
  impCartPoint * startIn,
  csSpec * startSpecIn,
  impCartPoint * endIn,
  csSpec * endSpecIn,
  vector * planeVecIn)
{
  start = startIn;
  startSpec = startSpecIn;
  end = endIn;
  endSpec = endSpecIn;
  planeVec = planeVecIn;
}

pathLineCart::~pathLineCart(){}

void pathLineCart::printSelf()
{
  printf("LINE");
  printf(",");
  printf("BND");
  printf(",");
  printf("CART");
  printf(",");
  printf("START");
  printf(",");
  start->printSelf();
  printf(",");
  if (startSpec)
    {
      startSpec->printSelf();
      printf(",");
    }
  printf("END");
  printf(",");
  end->printSelf();
  printf(",");
  if (endSpec)
    {
      endSpec->printSelf();
      printf(",");
    }
  printf("VEC");
  printf(",");
  planeVec->printSelf();
}

impCartPoint * pathLineCart::get_start()
{ return start; }
void pathLineCart::set_start(impCartPoint * startIn)
{ start = startIn; }
csSpec * pathLineCart::get_startSpec()
{ return startSpec; }
void pathLineCart::set_startSpec(csSpec * startSpecIn)
{ startSpec = startSpecIn; }
impCartPoint * pathLineCart::get_end()
{ return end; }
void pathLineCart::set_end(impCartPoint * endIn)
{ end = endIn; }
csSpec * pathLineCart::get_endSpec()
{ return endSpec; }
void pathLineCart::set_endSpec(csSpec * endSpecIn)
{ endSpec = endSpecIn; }
vector * pathLineCart::get_planeVec()
{ return planeVec; }
void pathLineCart::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

pathLinePol::pathLinePol(){}

pathLinePol::pathLinePol(
  impPolPoint * startIn,
  impPolPoint * endIn,
  vector * planeVecIn)
{
  start = startIn;
  end = endIn;
  planeVec = planeVecIn;
}

pathLinePol::~pathLinePol(){}

void pathLinePol::printSelf()
{
  printf("LINE");
  printf(",");
  printf("BND");
  printf(",");
  printf("POL");
  printf(",");
  start->printSelf();
  printf(",");
  end->printSelf();
  printf(",");
  printf("VEC");
  printf(",");
  planeVec->printSelf();
}

impPolPoint * pathLinePol::get_start()
{ return start; }
void pathLinePol::set_start(impPolPoint * startIn)
{ start = startIn; }
impPolPoint * pathLinePol::get_end()
{ return end; }
void pathLinePol::set_end(impPolPoint * endIn)
{ end = endIn; }
vector * pathLinePol::get_planeVec()
{ return planeVec; }
void pathLinePol::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

csSpec::csSpec(){};

csSpec::~csSpec(){}

/********************************************************************/

csSpec_PCS::csSpec_PCS(){}

csSpec_PCS::csSpec_PCS(
  euler * eulerIn)
{
  a_euler = eulerIn;
}

csSpec_PCS::~csSpec_PCS(){}

void csSpec_PCS::printSelf()
{
  printf("PCS");
  printf(",");
  a_euler->printSelf();
}

euler * csSpec_PCS::get_euler()
{ return a_euler; }
void csSpec_PCS::set_euler(euler * eulerIn)
{ a_euler = eulerIn; }

/********************************************************************/

csSpec_HEADCS::csSpec_HEADCS(){}

csSpec_HEADCS::csSpec_HEADCS(
  rentVal * rot1In,
  rentVal * rot2In,
  rentVal * rot3In)
{
  rot1 = rot1In;
  rot2 = rot2In;
  rot3 = rot3In;
}

csSpec_HEADCS::~csSpec_HEADCS(){}

void csSpec_HEADCS::printSelf()
{
  printf("HEADCS");
  printf(",");
  rot1->printSelf();
  printf(",");
  rot2->printSelf();
  if (rot3)
    {
      printf(",");
      rot3->printSelf();
    }
}

rentVal * csSpec_HEADCS::get_rot1()
{ return rot1; }
void csSpec_HEADCS::set_rot1(rentVal * rot1In)
{ rot1 = rot1In; }
rentVal * csSpec_HEADCS::get_rot2()
{ return rot2; }
void csSpec_HEADCS::set_rot2(rentVal * rot2In)
{ rot2 = rot2In; }
rentVal * csSpec_HEADCS::get_rot3()
{ return rot3; }
void csSpec_HEADCS::set_rot3(rentVal * rot3In)
{ rot3 = rot3In; }

/********************************************************************/

pathSurface::pathSurface(){};

pathSurface::~pathSurface(){}

/********************************************************************/

pathSurfacePlain::pathSurfacePlain(){}

pathSurfacePlain::pathSurfacePlain(
  std::list<surfPtdataListItem *> * surfPtdataListIn)
{
  a_surfPtdataList = surfPtdataListIn;
}

pathSurfacePlain::~pathSurfacePlain(){}

void pathSurfacePlain::printSelf()
{
  printf("SURFACE");
  printf(",");
  if (a_surfPtdataList->begin() == a_surfPtdataList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<surfPtdataListItem *>::iterator iter;
      for (iter = a_surfPtdataList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_surfPtdataList->end())
            break;
          printf(",");
        }
    }
}

std::list<surfPtdataListItem *> * pathSurfacePlain::get_surfPtdataList()
{ return a_surfPtdataList; }
void pathSurfacePlain::set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn)
{ a_surfPtdataList = surfPtdataListIn; }

/********************************************************************/

pathSurfacePcs::pathSurfacePcs(){}

pathSurfacePcs::pathSurfacePcs(
  std::list<surfPtdataListItem *> * surfPtdataListIn,
  euler * eulerIn)
{
  a_surfPtdataList = surfPtdataListIn;
  a_euler = eulerIn;
}

pathSurfacePcs::~pathSurfacePcs(){}

void pathSurfacePcs::printSelf()
{
  printf("SURFACE");
  printf(",");
  if (a_surfPtdataList->begin() == a_surfPtdataList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<surfPtdataListItem *>::iterator iter;
      for (iter = a_surfPtdataList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_surfPtdataList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  printf("PCS");
  printf(",");
  a_euler->printSelf();
}

std::list<surfPtdataListItem *> * pathSurfacePcs::get_surfPtdataList()
{ return a_surfPtdataList; }
void pathSurfacePcs::set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn)
{ a_surfPtdataList = surfPtdataListIn; }
euler * pathSurfacePcs::get_euler()
{ return a_euler; }
void pathSurfacePcs::set_euler(euler * eulerIn)
{ a_euler = eulerIn; }

/********************************************************************/

pathSurfacePcsData::pathSurfacePcsData(){}

pathSurfacePcsData::pathSurfacePcsData(
  std::list<surfPtdataListItem *> * surfPtdataListIn,
  euler * eulerIn,
  std::list<surfPtdataPcsListItem *> * surfPtdataPcsListIn)
{
  a_surfPtdataList = surfPtdataListIn;
  a_euler = eulerIn;
  a_surfPtdataPcsList = surfPtdataPcsListIn;
}

pathSurfacePcsData::~pathSurfacePcsData(){}

void pathSurfacePcsData::printSelf()
{
  printf("SURFACE");
  printf(",");
  if (a_surfPtdataList->begin() == a_surfPtdataList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<surfPtdataListItem *>::iterator iter;
      for (iter = a_surfPtdataList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_surfPtdataList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  printf("PCS");
  printf(",");
  a_euler->printSelf();
  printf(",");
  if (a_surfPtdataPcsList->begin() == a_surfPtdataPcsList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<surfPtdataPcsListItem *>::iterator iter;
      for (iter = a_surfPtdataPcsList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_surfPtdataPcsList->end())
            break;
          printf(",");
        }
    }
}

std::list<surfPtdataListItem *> * pathSurfacePcsData::get_surfPtdataList()
{ return a_surfPtdataList; }
void pathSurfacePcsData::set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn)
{ a_surfPtdataList = surfPtdataListIn; }
euler * pathSurfacePcsData::get_euler()
{ return a_euler; }
void pathSurfacePcsData::set_euler(euler * eulerIn)
{ a_euler = eulerIn; }
std::list<surfPtdataPcsListItem *> * pathSurfacePcsData::get_surfPtdataPcsList()
{ return a_surfPtdataPcsList; }
void pathSurfacePcsData::set_surfPtdataPcsList(std::list<surfPtdataPcsListItem *> * surfPtdataPcsListIn)
{ a_surfPtdataPcsList = surfPtdataPcsListIn; }

/********************************************************************/

pathSurfaceHeadcs::pathSurfaceHeadcs(){}

pathSurfaceHeadcs::pathSurfaceHeadcs(
  std::list<surfPtdataListItem *> * surfPtdataListIn,
  rentVal * rot1In,
  rentVal * rot2In,
  rentVal * rot3In)
{
  a_surfPtdataList = surfPtdataListIn;
  rot1 = rot1In;
  rot2 = rot2In;
  rot3 = rot3In;
}

pathSurfaceHeadcs::~pathSurfaceHeadcs(){}

void pathSurfaceHeadcs::printSelf()
{
  printf("SURFACE");
  printf(",");
  if (a_surfPtdataList->begin() == a_surfPtdataList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<surfPtdataListItem *>::iterator iter;
      for (iter = a_surfPtdataList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_surfPtdataList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  printf("HEADCS");
  printf(",");
  rot1->printSelf();
  printf(",");
  rot2->printSelf();
  if (rot3)
    {
      printf(",");
      rot3->printSelf();
    }
}

std::list<surfPtdataListItem *> * pathSurfaceHeadcs::get_surfPtdataList()
{ return a_surfPtdataList; }
void pathSurfaceHeadcs::set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn)
{ a_surfPtdataList = surfPtdataListIn; }
rentVal * pathSurfaceHeadcs::get_rot1()
{ return rot1; }
void pathSurfaceHeadcs::set_rot1(rentVal * rot1In)
{ rot1 = rot1In; }
rentVal * pathSurfaceHeadcs::get_rot2()
{ return rot2; }
void pathSurfaceHeadcs::set_rot2(rentVal * rot2In)
{ rot2 = rot2In; }
rentVal * pathSurfaceHeadcs::get_rot3()
{ return rot3; }
void pathSurfaceHeadcs::set_rot3(rentVal * rot3In)
{ rot3 = rot3In; }

/********************************************************************/

pathSurfaceHeadcsData::pathSurfaceHeadcsData(){}

pathSurfaceHeadcsData::pathSurfaceHeadcsData(
  std::list<surfPtdataListItem *> * surfPtdataListIn,
  rentVal * rot1In,
  rentVal * rot2In,
  rentVal * rot3In,
  std::list<surfPtdataHeadcsListItem *> * surfPtdataHeadcsListIn)
{
  a_surfPtdataList = surfPtdataListIn;
  rot1 = rot1In;
  rot2 = rot2In;
  rot3 = rot3In;
  a_surfPtdataHeadcsList = surfPtdataHeadcsListIn;
}

pathSurfaceHeadcsData::~pathSurfaceHeadcsData(){}

void pathSurfaceHeadcsData::printSelf()
{
  printf("SURFACE");
  printf(",");
  if (a_surfPtdataList->begin() == a_surfPtdataList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<surfPtdataListItem *>::iterator iter;
      for (iter = a_surfPtdataList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_surfPtdataList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  printf("HEADCS");
  printf(",");
  rot1->printSelf();
  printf(",");
  rot2->printSelf();
  if (rot3)
    {
      printf(",");
      rot3->printSelf();
    }
  printf(",");
  if (a_surfPtdataHeadcsList->begin() == a_surfPtdataHeadcsList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<surfPtdataHeadcsListItem *>::iterator iter;
      for (iter = a_surfPtdataHeadcsList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_surfPtdataHeadcsList->end())
            break;
          printf(",");
        }
    }
}

std::list<surfPtdataListItem *> * pathSurfaceHeadcsData::get_surfPtdataList()
{ return a_surfPtdataList; }
void pathSurfaceHeadcsData::set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn)
{ a_surfPtdataList = surfPtdataListIn; }
rentVal * pathSurfaceHeadcsData::get_rot1()
{ return rot1; }
void pathSurfaceHeadcsData::set_rot1(rentVal * rot1In)
{ rot1 = rot1In; }
rentVal * pathSurfaceHeadcsData::get_rot2()
{ return rot2; }
void pathSurfaceHeadcsData::set_rot2(rentVal * rot2In)
{ rot2 = rot2In; }
rentVal * pathSurfaceHeadcsData::get_rot3()
{ return rot3; }
void pathSurfaceHeadcsData::set_rot3(rentVal * rot3In)
{ rot3 = rot3In; }
std::list<surfPtdataHeadcsListItem *> * pathSurfaceHeadcsData::get_surfPtdataHeadcsList()
{ return a_surfPtdataHeadcsList; }
void pathSurfaceHeadcsData::set_surfPtdataHeadcsList(std::list<surfPtdataHeadcsListItem *> * surfPtdataHeadcsListIn)
{ a_surfPtdataHeadcsList = surfPtdataHeadcsListIn; }

/********************************************************************/

surfPtdataListItem::surfPtdataListItem(){}

surfPtdataListItem::surfPtdataListItem(
  pointVecCart * pointVecCartIn,
  rentVal * widthIn,
  rentVal * heightIn)
{
  a_pointVecCart = pointVecCartIn;
  width = widthIn;
  height = heightIn;
}

surfPtdataListItem::~surfPtdataListItem(){}

void surfPtdataListItem::printSelf()
{
  printf("PTDATA");
  printf(",");
  a_pointVecCart->printSelf();
  printf(",");
  width->printSelf();
  printf(",");
  height->printSelf();
}

pointVecCart * surfPtdataListItem::get_pointVecCart()
{ return a_pointVecCart; }
void surfPtdataListItem::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
rentVal * surfPtdataListItem::get_width()
{ return width; }
void surfPtdataListItem::set_width(rentVal * widthIn)
{ width = widthIn; }
rentVal * surfPtdataListItem::get_height()
{ return height; }
void surfPtdataListItem::set_height(rentVal * heightIn)
{ height = heightIn; }

/********************************************************************/

surfPtdataPcsListItem::surfPtdataPcsListItem(){}

surfPtdataPcsListItem::surfPtdataPcsListItem(
  pointVecCart * pointVecCartIn,
  rentVal * widthIn,
  rentVal * heightIn,
  euler * eulerIn)
{
  a_pointVecCart = pointVecCartIn;
  width = widthIn;
  height = heightIn;
  a_euler = eulerIn;
}

surfPtdataPcsListItem::~surfPtdataPcsListItem(){}

void surfPtdataPcsListItem::printSelf()
{
  printf("PTDATA");
  printf(",");
  a_pointVecCart->printSelf();
  printf(",");
  width->printSelf();
  printf(",");
  height->printSelf();
  if (a_euler)
    {
      printf(",");
      printf("PCS");
      printf(",");
      a_euler->printSelf();
    }
}

pointVecCart * surfPtdataPcsListItem::get_pointVecCart()
{ return a_pointVecCart; }
void surfPtdataPcsListItem::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
rentVal * surfPtdataPcsListItem::get_width()
{ return width; }
void surfPtdataPcsListItem::set_width(rentVal * widthIn)
{ width = widthIn; }
rentVal * surfPtdataPcsListItem::get_height()
{ return height; }
void surfPtdataPcsListItem::set_height(rentVal * heightIn)
{ height = heightIn; }
euler * surfPtdataPcsListItem::get_euler()
{ return a_euler; }
void surfPtdataPcsListItem::set_euler(euler * eulerIn)
{ a_euler = eulerIn; }

/********************************************************************/

surfPtdataHeadcsListItem::surfPtdataHeadcsListItem(){}

surfPtdataHeadcsListItem::surfPtdataHeadcsListItem(
  pointVecCart * pointVecCartIn,
  rentVal * widthIn,
  rentVal * heightIn,
  rentVal * rot1In,
  rentVal * rot2In,
  rentVal * rot3In)
{
  a_pointVecCart = pointVecCartIn;
  width = widthIn;
  height = heightIn;
  rot1 = rot1In;
  rot2 = rot2In;
  rot3 = rot3In;
}

surfPtdataHeadcsListItem::~surfPtdataHeadcsListItem(){}

void surfPtdataHeadcsListItem::printSelf()
{
  printf("PTDATA");
  printf(",");
  a_pointVecCart->printSelf();
  printf(",");
  width->printSelf();
  printf(",");
  height->printSelf();
  if (rot1)
    {
      printf(",");
      printf("HEADCS");
      printf(",");
      rot1->printSelf();
      printf(",");
      rot2->printSelf();
      if (rot3)
        {
          printf(",");
          rot3->printSelf();
        }
    }
}

pointVecCart * surfPtdataHeadcsListItem::get_pointVecCart()
{ return a_pointVecCart; }
void surfPtdataHeadcsListItem::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
rentVal * surfPtdataHeadcsListItem::get_width()
{ return width; }
void surfPtdataHeadcsListItem::set_width(rentVal * widthIn)
{ width = widthIn; }
rentVal * surfPtdataHeadcsListItem::get_height()
{ return height; }
void surfPtdataHeadcsListItem::set_height(rentVal * heightIn)
{ height = heightIn; }
rentVal * surfPtdataHeadcsListItem::get_rot1()
{ return rot1; }
void surfPtdataHeadcsListItem::set_rot1(rentVal * rot1In)
{ rot1 = rot1In; }
rentVal * surfPtdataHeadcsListItem::get_rot2()
{ return rot2; }
void surfPtdataHeadcsListItem::set_rot2(rentVal * rot2In)
{ rot2 = rot2In; }
rentVal * surfPtdataHeadcsListItem::get_rot3()
{ return rot3; }
void surfPtdataHeadcsListItem::set_rot3(rentVal * rot3In)
{ rot3 = rot3In; }

/********************************************************************/

pathUnknown::pathUnknown(){}

pathUnknown::pathUnknown(
  impCartPoint * startIn,
  impCartPoint * directionIn,
  impCartPoint * endIn,
  vector * planeVecIn)
{
  start = startIn;
  direction = directionIn;
  end = endIn;
  planeVec = planeVecIn;
}

pathUnknown::~pathUnknown(){}

void pathUnknown::printSelf()
{
  printf("UNKNOWN");
  printf(",");
  start->printSelf();
  printf(",");
  direction->printSelf();
  printf(",");
  end->printSelf();
  if (planeVec)
    {
      printf(",");
      planeVec->printSelf();
    }
}

impCartPoint * pathUnknown::get_start()
{ return start; }
void pathUnknown::set_start(impCartPoint * startIn)
{ start = startIn; }
impCartPoint * pathUnknown::get_direction()
{ return direction; }
void pathUnknown::set_direction(impCartPoint * directionIn)
{ direction = directionIn; }
impCartPoint * pathUnknown::get_end()
{ return end; }
void pathUnknown::set_end(impCartPoint * endIn)
{ end = endIn; }
vector * pathUnknown::get_planeVec()
{ return planeVec; }
void pathUnknown::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

planidStm::planidStm(){}

planidStm::planidStm(
  plLabel * plLabelIn,
  stringVal * textIn)
{
  a_plLabel = plLabelIn;
  text = textIn;
}

planidStm::~planidStm(){}

void planidStm::printSelf()
{
  a_plLabel->printSelf();
  printf("=");
  printf("PLANID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

plLabel * planidStm::get_plLabel()
{ return a_plLabel; }
void planidStm::set_plLabel(plLabel * plLabelIn)
{ a_plLabel = plLabelIn; }
stringVal * planidStm::get_text()
{ return text; }
void planidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

popStm::popStm(){}

popStm::popStm(
  std::list<stackElement *> * stackElementListIn)
{
  a_stackElementList = stackElementListIn;
}

popStm::~popStm(){}

void popStm::printSelf()
{
  printf("POP");
  printf("/");
  if (a_stackElementList->begin() == a_stackElementList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<stackElement *>::iterator iter;
      for (iter = a_stackElementList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_stackElementList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

std::list<stackElement *> * popStm::get_stackElementList()
{ return a_stackElementList; }
void popStm::set_stackElementList(std::list<stackElement *> * stackElementListIn)
{ a_stackElementList = stackElementListIn; }

/********************************************************************/

prcompStm::prcompStm(){}

prcompStm::prcompStm(
  state * stateIn)
{
  a_state = stateIn;
}

prcompStm::~prcompStm(){}

void prcompStm::printSelf()
{
  printf("PRCOMP");
  printf("/");
  a_state->printSelf();
  printf("%c%c", 13, 10);
}

state * prcompStm::get_state()
{ return a_state; }
void prcompStm::set_state(state * stateIn)
{ a_state = stateIn; }

/********************************************************************/

prevopStm::prevopStm(){}

prevopStm::prevopStm(
  pvLabel * pvLabelIn,
  stringVal * textIn)
{
  a_pvLabel = pvLabelIn;
  text = textIn;
}

prevopStm::~prevopStm(){}

void prevopStm::printSelf()
{
  a_pvLabel->printSelf();
  printf("=");
  printf("PREVOP");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

pvLabel * prevopStm::get_pvLabel()
{ return a_pvLabel; }
void prevopStm::set_pvLabel(pvLabel * pvLabelIn)
{ a_pvLabel = pvLabelIn; }
stringVal * prevopStm::get_text()
{ return text; }
void prevopStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

procidStm::procidStm(){}

procidStm::procidStm(
  pcLabel * pcLabelIn,
  stringVal * textIn)
{
  a_pcLabel = pcLabelIn;
  text = textIn;
}

procidStm::~procidStm(){}

void procidStm::printSelf()
{
  a_pcLabel->printSelf();
  printf("=");
  printf("PROCID");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

pcLabel * procidStm::get_pcLabel()
{ return a_pcLabel; }
void procidStm::set_pcLabel(pcLabel * pcLabelIn)
{ a_pcLabel = pcLabelIn; }
stringVal * procidStm::get_text()
{ return text; }
void procidStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

promptStm::promptStm(){};

promptStm::~promptStm(){}

/********************************************************************/

promptStm_boolVar::promptStm_boolVar(){}

promptStm_boolVar::promptStm_boolVar(
  boolVar * boolVarIn,
  stringVal * textIn)
{
  a_boolVar = boolVarIn;
  text = textIn;
}

promptStm_boolVar::~promptStm_boolVar(){}

void promptStm_boolVar::printSelf()
{
  a_boolVar->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  printf("%c%c", 13, 10);
}

boolVar * promptStm_boolVar::get_boolVar()
{ return a_boolVar; }
void promptStm_boolVar::set_boolVar(boolVar * boolVarIn)
{ a_boolVar = boolVarIn; }
stringVal * promptStm_boolVar::get_text()
{ return text; }
void promptStm_boolVar::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

promptStm_stringVar::promptStm_stringVar(){}

promptStm_stringVar::promptStm_stringVar(
  stringVar * stringVarIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_stringVar = stringVarIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_stringVar::~promptStm_stringVar(){}

void promptStm_stringVar::printSelf()
{
  a_stringVar->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

stringVar * promptStm_stringVar::get_stringVar()
{ return a_stringVar; }
void promptStm_stringVar::set_stringVar(stringVar * stringVarIn)
{ a_stringVar = stringVarIn; }
stringVal * promptStm_stringVar::get_text()
{ return text; }
void promptStm_stringVar::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_stringVar::get_maxSize()
{ return maxSize; }
void promptStm_stringVar::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_intVar::promptStm_intVar(){}

promptStm_intVar::promptStm_intVar(
  intVar * intVarIn,
  promptIntEnd * promptIntEndIn)
{
  a_intVar = intVarIn;
  a_promptIntEnd = promptIntEndIn;
}

promptStm_intVar::~promptStm_intVar(){}

void promptStm_intVar::printSelf()
{
  a_intVar->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  a_promptIntEnd->printSelf();
  printf("%c%c", 13, 10);
}

intVar * promptStm_intVar::get_intVar()
{ return a_intVar; }
void promptStm_intVar::set_intVar(intVar * intVarIn)
{ a_intVar = intVarIn; }
promptIntEnd * promptStm_intVar::get_promptIntEnd()
{ return a_promptIntEnd; }
void promptStm_intVar::set_promptIntEnd(promptIntEnd * promptIntEndIn)
{ a_promptIntEnd = promptIntEndIn; }

/********************************************************************/

promptStm_realVar::promptStm_realVar(){}

promptStm_realVar::promptStm_realVar(
  realVar * realVarIn,
  stringVal * textIn,
  rentVal * maxvalIn,
  rentVal * minvalIn)
{
  a_realVar = realVarIn;
  text = textIn;
  maxval = maxvalIn;
  minval = minvalIn;
}

promptStm_realVar::~promptStm_realVar(){}

void promptStm_realVar::printSelf()
{
  a_realVar->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxval)
    {
      printf(",");
      maxval->printSelf();
      if (minval)
        {
          printf(",");
          minval->printSelf();
        }
    }
  printf("%c%c", 13, 10);
}

realVar * promptStm_realVar::get_realVar()
{ return a_realVar; }
void promptStm_realVar::set_realVar(realVar * realVarIn)
{ a_realVar = realVarIn; }
stringVal * promptStm_realVar::get_text()
{ return text; }
void promptStm_realVar::set_text(stringVal * textIn)
{ text = textIn; }
rentVal * promptStm_realVar::get_maxval()
{ return maxval; }
void promptStm_realVar::set_maxval(rentVal * maxvalIn)
{ maxval = maxvalIn; }
rentVal * promptStm_realVar::get_minval()
{ return minval; }
void promptStm_realVar::set_minval(rentVal * minvalIn)
{ minval = minvalIn; }

/********************************************************************/

promptStm_ccLabel::promptStm_ccLabel(){}

promptStm_ccLabel::promptStm_ccLabel(
  ccLabel * ccLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_ccLabel = ccLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_ccLabel::~promptStm_ccLabel(){}

void promptStm_ccLabel::printSelf()
{
  a_ccLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

ccLabel * promptStm_ccLabel::get_ccLabel()
{ return a_ccLabel; }
void promptStm_ccLabel::set_ccLabel(ccLabel * ccLabelIn)
{ a_ccLabel = ccLabelIn; }
stringVal * promptStm_ccLabel::get_text()
{ return text; }
void promptStm_ccLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_ccLabel::get_maxSize()
{ return maxSize; }
void promptStm_ccLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_ciLabel::promptStm_ciLabel(){}

promptStm_ciLabel::promptStm_ciLabel(
  ciLabel * ciLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_ciLabel = ciLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_ciLabel::~promptStm_ciLabel(){}

void promptStm_ciLabel::printSelf()
{
  a_ciLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

ciLabel * promptStm_ciLabel::get_ciLabel()
{ return a_ciLabel; }
void promptStm_ciLabel::set_ciLabel(ciLabel * ciLabelIn)
{ a_ciLabel = ciLabelIn; }
stringVal * promptStm_ciLabel::get_text()
{ return text; }
void promptStm_ciLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_ciLabel::get_maxSize()
{ return maxSize; }
void promptStm_ciLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_csLabel::promptStm_csLabel(){}

promptStm_csLabel::promptStm_csLabel(
  csLabel * csLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_csLabel = csLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_csLabel::~promptStm_csLabel(){}

void promptStm_csLabel::printSelf()
{
  a_csLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

csLabel * promptStm_csLabel::get_csLabel()
{ return a_csLabel; }
void promptStm_csLabel::set_csLabel(csLabel * csLabelIn)
{ a_csLabel = csLabelIn; }
stringVal * promptStm_csLabel::get_text()
{ return text; }
void promptStm_csLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_csLabel::get_maxSize()
{ return maxSize; }
void promptStm_csLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_diLabel::promptStm_diLabel(){}

promptStm_diLabel::promptStm_diLabel(
  diLabel * diLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_diLabel = diLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_diLabel::~promptStm_diLabel(){}

void promptStm_diLabel::printSelf()
{
  a_diLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

diLabel * promptStm_diLabel::get_diLabel()
{ return a_diLabel; }
void promptStm_diLabel::set_diLabel(diLabel * diLabelIn)
{ a_diLabel = diLabelIn; }
stringVal * promptStm_diLabel::get_text()
{ return text; }
void promptStm_diLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_diLabel::get_maxSize()
{ return maxSize; }
void promptStm_diLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_dsLabel::promptStm_dsLabel(){}

promptStm_dsLabel::promptStm_dsLabel(
  dsLabel * dsLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_dsLabel = dsLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_dsLabel::~promptStm_dsLabel(){}

void promptStm_dsLabel::printSelf()
{
  a_dsLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

dsLabel * promptStm_dsLabel::get_dsLabel()
{ return a_dsLabel; }
void promptStm_dsLabel::set_dsLabel(dsLabel * dsLabelIn)
{ a_dsLabel = dsLabelIn; }
stringVal * promptStm_dsLabel::get_text()
{ return text; }
void promptStm_dsLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_dsLabel::get_maxSize()
{ return maxSize; }
void promptStm_dsLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_dvLabel::promptStm_dvLabel(){}

promptStm_dvLabel::promptStm_dvLabel(
  dvLabel * dvLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_dvLabel = dvLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_dvLabel::~promptStm_dvLabel(){}

void promptStm_dvLabel::printSelf()
{
  a_dvLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

dvLabel * promptStm_dvLabel::get_dvLabel()
{ return a_dvLabel; }
void promptStm_dvLabel::set_dvLabel(dvLabel * dvLabelIn)
{ a_dvLabel = dvLabelIn; }
stringVal * promptStm_dvLabel::get_text()
{ return text; }
void promptStm_dvLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_dvLabel::get_maxSize()
{ return maxSize; }
void promptStm_dvLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_fiLabel::promptStm_fiLabel(){}

promptStm_fiLabel::promptStm_fiLabel(
  fiLabel * fiLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_fiLabel = fiLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_fiLabel::~promptStm_fiLabel(){}

void promptStm_fiLabel::printSelf()
{
  a_fiLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

fiLabel * promptStm_fiLabel::get_fiLabel()
{ return a_fiLabel; }
void promptStm_fiLabel::set_fiLabel(fiLabel * fiLabelIn)
{ a_fiLabel = fiLabelIn; }
stringVal * promptStm_fiLabel::get_text()
{ return text; }
void promptStm_fiLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_fiLabel::get_maxSize()
{ return maxSize; }
void promptStm_fiLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_fsLabel::promptStm_fsLabel(){}

promptStm_fsLabel::promptStm_fsLabel(
  fsLabel * fsLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_fsLabel = fsLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_fsLabel::~promptStm_fsLabel(){}

void promptStm_fsLabel::printSelf()
{
  a_fsLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

fsLabel * promptStm_fsLabel::get_fsLabel()
{ return a_fsLabel; }
void promptStm_fsLabel::set_fsLabel(fsLabel * fsLabelIn)
{ a_fsLabel = fsLabelIn; }
stringVal * promptStm_fsLabel::get_text()
{ return text; }
void promptStm_fsLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_fsLabel::get_maxSize()
{ return maxSize; }
void promptStm_fsLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_liLabel::promptStm_liLabel(){}

promptStm_liLabel::promptStm_liLabel(
  liLabel * liLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_liLabel = liLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_liLabel::~promptStm_liLabel(){}

void promptStm_liLabel::printSelf()
{
  a_liLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

liLabel * promptStm_liLabel::get_liLabel()
{ return a_liLabel; }
void promptStm_liLabel::set_liLabel(liLabel * liLabelIn)
{ a_liLabel = liLabelIn; }
stringVal * promptStm_liLabel::get_text()
{ return text; }
void promptStm_liLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_liLabel::get_maxSize()
{ return maxSize; }
void promptStm_liLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_mdLabel::promptStm_mdLabel(){}

promptStm_mdLabel::promptStm_mdLabel(
  mdLabel * mdLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_mdLabel = mdLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_mdLabel::~promptStm_mdLabel(){}

void promptStm_mdLabel::printSelf()
{
  a_mdLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

mdLabel * promptStm_mdLabel::get_mdLabel()
{ return a_mdLabel; }
void promptStm_mdLabel::set_mdLabel(mdLabel * mdLabelIn)
{ a_mdLabel = mdLabelIn; }
stringVal * promptStm_mdLabel::get_text()
{ return text; }
void promptStm_mdLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_mdLabel::get_maxSize()
{ return maxSize; }
void promptStm_mdLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_opLabel::promptStm_opLabel(){}

promptStm_opLabel::promptStm_opLabel(
  opLabel * opLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_opLabel = opLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_opLabel::~promptStm_opLabel(){}

void promptStm_opLabel::printSelf()
{
  a_opLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

opLabel * promptStm_opLabel::get_opLabel()
{ return a_opLabel; }
void promptStm_opLabel::set_opLabel(opLabel * opLabelIn)
{ a_opLabel = opLabelIn; }
stringVal * promptStm_opLabel::get_text()
{ return text; }
void promptStm_opLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_opLabel::get_maxSize()
{ return maxSize; }
void promptStm_opLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_pcLabel::promptStm_pcLabel(){}

promptStm_pcLabel::promptStm_pcLabel(
  pcLabel * pcLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_pcLabel = pcLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_pcLabel::~promptStm_pcLabel(){}

void promptStm_pcLabel::printSelf()
{
  a_pcLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

pcLabel * promptStm_pcLabel::get_pcLabel()
{ return a_pcLabel; }
void promptStm_pcLabel::set_pcLabel(pcLabel * pcLabelIn)
{ a_pcLabel = pcLabelIn; }
stringVal * promptStm_pcLabel::get_text()
{ return text; }
void promptStm_pcLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_pcLabel::get_maxSize()
{ return maxSize; }
void promptStm_pcLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_plLabel::promptStm_plLabel(){}

promptStm_plLabel::promptStm_plLabel(
  plLabel * plLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_plLabel = plLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_plLabel::~promptStm_plLabel(){}

void promptStm_plLabel::printSelf()
{
  a_plLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

plLabel * promptStm_plLabel::get_plLabel()
{ return a_plLabel; }
void promptStm_plLabel::set_plLabel(plLabel * plLabelIn)
{ a_plLabel = plLabelIn; }
stringVal * promptStm_plLabel::get_text()
{ return text; }
void promptStm_plLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_plLabel::get_maxSize()
{ return maxSize; }
void promptStm_plLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_pnLabel::promptStm_pnLabel(){}

promptStm_pnLabel::promptStm_pnLabel(
  pnLabel * pnLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_pnLabel = pnLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_pnLabel::~promptStm_pnLabel(){}

void promptStm_pnLabel::printSelf()
{
  a_pnLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

pnLabel * promptStm_pnLabel::get_pnLabel()
{ return a_pnLabel; }
void promptStm_pnLabel::set_pnLabel(pnLabel * pnLabelIn)
{ a_pnLabel = pnLabelIn; }
stringVal * promptStm_pnLabel::get_text()
{ return text; }
void promptStm_pnLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_pnLabel::get_maxSize()
{ return maxSize; }
void promptStm_pnLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_prLabel::promptStm_prLabel(){}

promptStm_prLabel::promptStm_prLabel(
  prLabel * prLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_prLabel = prLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_prLabel::~promptStm_prLabel(){}

void promptStm_prLabel::printSelf()
{
  a_prLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

prLabel * promptStm_prLabel::get_prLabel()
{ return a_prLabel; }
void promptStm_prLabel::set_prLabel(prLabel * prLabelIn)
{ a_prLabel = prLabelIn; }
stringVal * promptStm_prLabel::get_text()
{ return text; }
void promptStm_prLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_prLabel::get_maxSize()
{ return maxSize; }
void promptStm_prLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_psLabel::promptStm_psLabel(){}

promptStm_psLabel::promptStm_psLabel(
  psLabel * psLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_psLabel = psLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_psLabel::~promptStm_psLabel(){}

void promptStm_psLabel::printSelf()
{
  a_psLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

psLabel * promptStm_psLabel::get_psLabel()
{ return a_psLabel; }
void promptStm_psLabel::set_psLabel(psLabel * psLabelIn)
{ a_psLabel = psLabelIn; }
stringVal * promptStm_psLabel::get_text()
{ return text; }
void promptStm_psLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_psLabel::get_maxSize()
{ return maxSize; }
void promptStm_psLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_pvLabel::promptStm_pvLabel(){}

promptStm_pvLabel::promptStm_pvLabel(
  pvLabel * pvLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_pvLabel = pvLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_pvLabel::~promptStm_pvLabel(){}

void promptStm_pvLabel::printSelf()
{
  a_pvLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

pvLabel * promptStm_pvLabel::get_pvLabel()
{ return a_pvLabel; }
void promptStm_pvLabel::set_pvLabel(pvLabel * pvLabelIn)
{ a_pvLabel = pvLabelIn; }
stringVal * promptStm_pvLabel::get_text()
{ return text; }
void promptStm_pvLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_pvLabel::get_maxSize()
{ return maxSize; }
void promptStm_pvLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_qLabel::promptStm_qLabel(){}

promptStm_qLabel::promptStm_qLabel(
  qLabel * qLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_qLabel = qLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_qLabel::~promptStm_qLabel(){}

void promptStm_qLabel::printSelf()
{
  a_qLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

qLabel * promptStm_qLabel::get_qLabel()
{ return a_qLabel; }
void promptStm_qLabel::set_qLabel(qLabel * qLabelIn)
{ a_qLabel = qLabelIn; }
stringVal * promptStm_qLabel::get_text()
{ return text; }
void promptStm_qLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_qLabel::get_maxSize()
{ return maxSize; }
void promptStm_qLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptStm_tlLabel::promptStm_tlLabel(){}

promptStm_tlLabel::promptStm_tlLabel(
  tlLabel * tlLabelIn,
  stringVal * textIn,
  intVal * maxSizeIn)
{
  a_tlLabel = tlLabelIn;
  text = textIn;
  maxSize = maxSizeIn;
}

promptStm_tlLabel::~promptStm_tlLabel(){}

void promptStm_tlLabel::printSelf()
{
  a_tlLabel->printSelf();
  printf("=");
  printf("PROMPT");
  printf("/");
  text->printSelf();
  if (maxSize)
    {
      printf(",");
      maxSize->printSelf();
    }
  printf("%c%c", 13, 10);
}

tlLabel * promptStm_tlLabel::get_tlLabel()
{ return a_tlLabel; }
void promptStm_tlLabel::set_tlLabel(tlLabel * tlLabelIn)
{ a_tlLabel = tlLabelIn; }
stringVal * promptStm_tlLabel::get_text()
{ return text; }
void promptStm_tlLabel::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptStm_tlLabel::get_maxSize()
{ return maxSize; }
void promptStm_tlLabel::set_maxSize(intVal * maxSizeIn)
{ maxSize = maxSizeIn; }

/********************************************************************/

promptIntEnd::promptIntEnd(){};

promptIntEnd::~promptIntEnd(){}

/********************************************************************/

promptIntEnd_stringVal::promptIntEnd_stringVal(){}

promptIntEnd_stringVal::promptIntEnd_stringVal(
  stringVal * textIn,
  intVal * maxvalIn,
  intVal * minvalIn)
{
  text = textIn;
  maxval = maxvalIn;
  minval = minvalIn;
}

promptIntEnd_stringVal::~promptIntEnd_stringVal(){}

void promptIntEnd_stringVal::printSelf()
{
  text->printSelf();
  if (maxval)
    {
      printf(",");
      maxval->printSelf();
      if (minval)
        {
          printf(",");
          minval->printSelf();
        }
    }
}

stringVal * promptIntEnd_stringVal::get_text()
{ return text; }
void promptIntEnd_stringVal::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptIntEnd_stringVal::get_maxval()
{ return maxval; }
void promptIntEnd_stringVal::set_maxval(intVal * maxvalIn)
{ maxval = maxvalIn; }
intVal * promptIntEnd_stringVal::get_minval()
{ return minval; }
void promptIntEnd_stringVal::set_minval(intVal * minvalIn)
{ minval = minvalIn; }

/********************************************************************/

promptIntEnd_promptItemList::promptIntEnd_promptItemList(){}

promptIntEnd_promptItemList::promptIntEnd_promptItemList(
  std::list<promptItem *> * promptItemListIn)
{
  a_promptItemList = promptItemListIn;
}

promptIntEnd_promptItemList::~promptIntEnd_promptItemList(){}

void promptIntEnd_promptItemList::printSelf()
{
  if (a_promptItemList->begin() == a_promptItemList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<promptItem *>::iterator iter;
      for (iter = a_promptItemList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_promptItemList->end())
            break;
          printf(",");
        }
    }
}

std::list<promptItem *> * promptIntEnd_promptItemList::get_promptItemList()
{ return a_promptItemList; }
void promptIntEnd_promptItemList::set_promptItemList(std::list<promptItem *> * promptItemListIn)
{ a_promptItemList = promptItemListIn; }

/********************************************************************/

promptItem::promptItem(){};

promptItem::~promptItem(){}

/********************************************************************/

promptItem_BUTTON::promptItem_BUTTON(){}

promptItem_BUTTON::promptItem_BUTTON(
  stringVal * textIn,
  intVal * retValIn)
{
  text = textIn;
  retVal = retValIn;
}

promptItem_BUTTON::~promptItem_BUTTON(){}

void promptItem_BUTTON::printSelf()
{
  printf("BUTTON");
  printf(",");
  text->printSelf();
  printf(",");
  retVal->printSelf();
}

stringVal * promptItem_BUTTON::get_text()
{ return text; }
void promptItem_BUTTON::set_text(stringVal * textIn)
{ text = textIn; }
intVal * promptItem_BUTTON::get_retVal()
{ return retVal; }
void promptItem_BUTTON::set_retVal(intVal * retValIn)
{ retVal = retValIn; }

/********************************************************************/

promptItem_CHECK::promptItem_CHECK(){}

promptItem_CHECK::promptItem_CHECK(
  stringVal * textIn,
  boolVar * boolVarIn)
{
  text = textIn;
  a_boolVar = boolVarIn;
}

promptItem_CHECK::~promptItem_CHECK(){}

void promptItem_CHECK::printSelf()
{
  printf("CHECK");
  printf(",");
  text->printSelf();
  printf(",");
  a_boolVar->printSelf();
}

stringVal * promptItem_CHECK::get_text()
{ return text; }
void promptItem_CHECK::set_text(stringVal * textIn)
{ text = textIn; }
boolVar * promptItem_CHECK::get_boolVar()
{ return a_boolVar; }
void promptItem_CHECK::set_boolVar(boolVar * boolVarIn)
{ a_boolVar = boolVarIn; }

/********************************************************************/

promptItem_EDIT::promptItem_EDIT(){}

promptItem_EDIT::promptItem_EDIT(
  promptVar * promptVarIn,
  rentVal * maxvalIn,
  rentVal * minvalIn)
{
  a_promptVar = promptVarIn;
  maxval = maxvalIn;
  minval = minvalIn;
}

promptItem_EDIT::~promptItem_EDIT(){}

void promptItem_EDIT::printSelf()
{
  printf("EDIT");
  printf(",");
  a_promptVar->printSelf();
  if (maxval)
    {
      printf(",");
      maxval->printSelf();
      if (minval)
        {
          printf(",");
          minval->printSelf();
        }
    }
}

promptVar * promptItem_EDIT::get_promptVar()
{ return a_promptVar; }
void promptItem_EDIT::set_promptVar(promptVar * promptVarIn)
{ a_promptVar = promptVarIn; }
rentVal * promptItem_EDIT::get_maxval()
{ return maxval; }
void promptItem_EDIT::set_maxval(rentVal * maxvalIn)
{ maxval = maxvalIn; }
rentVal * promptItem_EDIT::get_minval()
{ return minval; }
void promptItem_EDIT::set_minval(rentVal * minvalIn)
{ minval = minvalIn; }

/********************************************************************/

promptItem_GROUP::promptItem_GROUP(){}

promptItem_GROUP::promptItem_GROUP(
  stringVal * textIn,
  promptVar * promptVarIn,
  stringVal * item1In,
  std::list<stringVal *> * moreItemsIn)
{
  text = textIn;
  a_promptVar = promptVarIn;
  item1 = item1In;
  moreItems = moreItemsIn;
}

promptItem_GROUP::~promptItem_GROUP(){}

void promptItem_GROUP::printSelf()
{
  printf("GROUP");
  printf(",");
  text->printSelf();
  printf(",");
  a_promptVar->printSelf();
  printf(",");
  item1->printSelf();
  printf(",");
  if (moreItems->begin() == moreItems->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<stringVal *>::iterator iter;
      for (iter = moreItems->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == moreItems->end())
            break;
          printf(",");
        }
    }
}

stringVal * promptItem_GROUP::get_text()
{ return text; }
void promptItem_GROUP::set_text(stringVal * textIn)
{ text = textIn; }
promptVar * promptItem_GROUP::get_promptVar()
{ return a_promptVar; }
void promptItem_GROUP::set_promptVar(promptVar * promptVarIn)
{ a_promptVar = promptVarIn; }
stringVal * promptItem_GROUP::get_item1()
{ return item1; }
void promptItem_GROUP::set_item1(stringVal * item1In)
{ item1 = item1In; }
std::list<stringVal *> * promptItem_GROUP::get_moreItems()
{ return moreItems; }
void promptItem_GROUP::set_moreItems(std::list<stringVal *> * moreItemsIn)
{ moreItems = moreItemsIn; }

/********************************************************************/

promptItem_LIST::promptItem_LIST(){}

promptItem_LIST::promptItem_LIST(
  promptVar * promptVarIn,
  stringVal * item1In,
  std::list<stringVal *> * moreItemsIn)
{
  a_promptVar = promptVarIn;
  item1 = item1In;
  moreItems = moreItemsIn;
}

promptItem_LIST::~promptItem_LIST(){}

void promptItem_LIST::printSelf()
{
  printf("LIST");
  printf(",");
  a_promptVar->printSelf();
  printf(",");
  item1->printSelf();
  printf(",");
  if (moreItems->begin() == moreItems->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<stringVal *>::iterator iter;
      for (iter = moreItems->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == moreItems->end())
            break;
          printf(",");
        }
    }
}

promptVar * promptItem_LIST::get_promptVar()
{ return a_promptVar; }
void promptItem_LIST::set_promptVar(promptVar * promptVarIn)
{ a_promptVar = promptVarIn; }
stringVal * promptItem_LIST::get_item1()
{ return item1; }
void promptItem_LIST::set_item1(stringVal * item1In)
{ item1 = item1In; }
std::list<stringVal *> * promptItem_LIST::get_moreItems()
{ return moreItems; }
void promptItem_LIST::set_moreItems(std::list<stringVal *> * moreItemsIn)
{ moreItems = moreItemsIn; }

/********************************************************************/

promptItem_PICTURE::promptItem_PICTURE(){}

promptItem_PICTURE::promptItem_PICTURE(
  stringVal * filenameIn,
  intVal * indexIn)
{
  filename = filenameIn;
  index = indexIn;
}

promptItem_PICTURE::~promptItem_PICTURE(){}

void promptItem_PICTURE::printSelf()
{
  printf("PICTURE");
  printf(",");
  filename->printSelf();
  if (index)
    {
      printf(",");
      index->printSelf();
    }
}

stringVal * promptItem_PICTURE::get_filename()
{ return filename; }
void promptItem_PICTURE::set_filename(stringVal * filenameIn)
{ filename = filenameIn; }
intVal * promptItem_PICTURE::get_index()
{ return index; }
void promptItem_PICTURE::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

promptItem_PIXBTN::promptItem_PIXBTN(){}

promptItem_PIXBTN::promptItem_PIXBTN(
  stringVal * filnam1In,
  stringVal * filnam2In,
  intVal * retValIn)
{
  filnam1 = filnam1In;
  filnam2 = filnam2In;
  retVal = retValIn;
}

promptItem_PIXBTN::~promptItem_PIXBTN(){}

void promptItem_PIXBTN::printSelf()
{
  printf("PIXBTN");
  printf(",");
  filnam1->printSelf();
  if (filnam2)
    {
      printf(",");
      filnam2->printSelf();
    }
  printf(",");
  retVal->printSelf();
}

stringVal * promptItem_PIXBTN::get_filnam1()
{ return filnam1; }
void promptItem_PIXBTN::set_filnam1(stringVal * filnam1In)
{ filnam1 = filnam1In; }
stringVal * promptItem_PIXBTN::get_filnam2()
{ return filnam2; }
void promptItem_PIXBTN::set_filnam2(stringVal * filnam2In)
{ filnam2 = filnam2In; }
intVal * promptItem_PIXBTN::get_retVal()
{ return retVal; }
void promptItem_PIXBTN::set_retVal(intVal * retValIn)
{ retVal = retValIn; }

/********************************************************************/

promptItem_SOUND::promptItem_SOUND(){}

promptItem_SOUND::promptItem_SOUND(
  stringVal * filenameIn)
{
  filename = filenameIn;
}

promptItem_SOUND::~promptItem_SOUND(){}

void promptItem_SOUND::printSelf()
{
  printf("SOUND");
  printf(",");
  filename->printSelf();
}

stringVal * promptItem_SOUND::get_filename()
{ return filename; }
void promptItem_SOUND::set_filename(stringVal * filenameIn)
{ filename = filenameIn; }

/********************************************************************/

promptItem_TEXT::promptItem_TEXT(){}

promptItem_TEXT::promptItem_TEXT(
  stringVal * textIn)
{
  text = textIn;
}

promptItem_TEXT::~promptItem_TEXT(){}

void promptItem_TEXT::printSelf()
{
  printf("TEXT");
  printf(",");
  text->printSelf();
}

stringVal * promptItem_TEXT::get_text()
{ return text; }
void promptItem_TEXT::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

promptItem_TITLE::promptItem_TITLE(){}

promptItem_TITLE::promptItem_TITLE(
  stringVal * textIn)
{
  text = textIn;
}

promptItem_TITLE::~promptItem_TITLE(){}

void promptItem_TITLE::printSelf()
{
  printf("TITLE");
  printf(",");
  text->printSelf();
}

stringVal * promptItem_TITLE::get_text()
{ return text; }
void promptItem_TITLE::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

promptVar::promptVar(){};

promptVar::~promptVar(){}

/********************************************************************/

psthruStm::psthruStm(){}

psthruStm::psthruStm(
  psthruMinor * psthruMinorIn)
{
  a_psthruMinor = psthruMinorIn;
}

psthruStm::~psthruStm(){}

void psthruStm::printSelf()
{
  printf("PSTHRU");
  printf("/");
  a_psthruMinor->printSelf();
  printf("%c%c", 13, 10);
}

psthruMinor * psthruStm::get_psthruMinor()
{ return a_psthruMinor; }
void psthruStm::set_psthruMinor(psthruMinor * psthruMinorIn)
{ a_psthruMinor = psthruMinorIn; }

/********************************************************************/

psthruMinor::psthruMinor(){};

psthruMinor::~psthruMinor(){}

/********************************************************************/

psthruMinor_COMAND::psthruMinor_COMAND(){}

psthruMinor_COMAND::psthruMinor_COMAND(
  stringVal * commandIn)
{
  command = commandIn;
}

psthruMinor_COMAND::~psthruMinor_COMAND(){}

void psthruMinor_COMAND::printSelf()
{
  printf("COMAND");
  printf(",");
  command->printSelf();
}

stringVal * psthruMinor_COMAND::get_command()
{ return command; }
void psthruMinor_COMAND::set_command(stringVal * commandIn)
{ command = commandIn; }

/********************************************************************/

psthruMinor_CONTIN::psthruMinor_CONTIN(){}

psthruMinor_CONTIN::~psthruMinor_CONTIN(){}

void psthruMinor_CONTIN::printSelf()
{
  printf("CONTIN");
}

/********************************************************************/

psthruMinor_PAUSE::psthruMinor_PAUSE(){}

psthruMinor_PAUSE::~psthruMinor_PAUSE(){}

void psthruMinor_PAUSE::printSelf()
{
  printf("PAUSE");
}

/********************************************************************/

psthruMinor_START::psthruMinor_START(){}

psthruMinor_START::~psthruMinor_START(){}

void psthruMinor_START::printSelf()
{
  printf("START");
}

/********************************************************************/

psthruMinor_STOP::psthruMinor_STOP(){}

psthruMinor_STOP::~psthruMinor_STOP(){}

void psthruMinor_STOP::printSelf()
{
  printf("STOP");
}

/********************************************************************/

psthruMinor_TRMATX::psthruMinor_TRMATX(){}

psthruMinor_TRMATX::psthruMinor_TRMATX(
  matrix * matrixIn)
{
  a_matrix = matrixIn;
}

psthruMinor_TRMATX::~psthruMinor_TRMATX(){}

void psthruMinor_TRMATX::printSelf()
{
  printf("TRMATX");
  printf(",");
  a_matrix->printSelf();
}

matrix * psthruMinor_TRMATX::get_matrix()
{ return a_matrix; }
void psthruMinor_TRMATX::set_matrix(matrix * matrixIn)
{ a_matrix = matrixIn; }

/********************************************************************/

ptbuffStm::ptbuffStm(){}

ptbuffStm::ptbuffStm(
  state * stateIn)
{
  a_state = stateIn;
}

ptbuffStm::~ptbuffStm(){}

void ptbuffStm::printSelf()
{
  printf("PTBUFF");
  printf("/");
  a_state->printSelf();
  printf("%c%c", 13, 10);
}

state * ptbuffStm::get_state()
{ return a_state; }
void ptbuffStm::set_state(state * stateIn)
{ a_state = stateIn; }

/********************************************************************/

ptmeasEnd::ptmeasEnd(){};

ptmeasEnd::~ptmeasEnd(){}

/********************************************************************/

ptmeasEnd_csSpec::ptmeasEnd_csSpec(){}

ptmeasEnd_csSpec::ptmeasEnd_csSpec(
  csSpec * csSpecIn,
  touchSpec * touchSpecIn)
{
  a_csSpec = csSpecIn;
  a_touchSpec = touchSpecIn;
}

ptmeasEnd_csSpec::~ptmeasEnd_csSpec(){}

void ptmeasEnd_csSpec::printSelf()
{
  a_csSpec->printSelf();
  if (a_touchSpec)
    {
      printf(",");
      a_touchSpec->printSelf();
    }
}

csSpec * ptmeasEnd_csSpec::get_csSpec()
{ return a_csSpec; }
void ptmeasEnd_csSpec::set_csSpec(csSpec * csSpecIn)
{ a_csSpec = csSpecIn; }
touchSpec * ptmeasEnd_csSpec::get_touchSpec()
{ return a_touchSpec; }
void ptmeasEnd_csSpec::set_touchSpec(touchSpec * touchSpecIn)
{ a_touchSpec = touchSpecIn; }

/********************************************************************/

ptmeasEnd_touchSpec::ptmeasEnd_touchSpec(){}

ptmeasEnd_touchSpec::ptmeasEnd_touchSpec(
  touchSpec * touchSpecIn)
{
  a_touchSpec = touchSpecIn;
}

ptmeasEnd_touchSpec::~ptmeasEnd_touchSpec(){}

void ptmeasEnd_touchSpec::printSelf()
{
  a_touchSpec->printSelf();
}

touchSpec * ptmeasEnd_touchSpec::get_touchSpec()
{ return a_touchSpec; }
void ptmeasEnd_touchSpec::set_touchSpec(touchSpec * touchSpecIn)
{ a_touchSpec = touchSpecIn; }

/********************************************************************/

touchSpec::touchSpec(){};

touchSpec::~touchSpec(){}

/********************************************************************/

touchSpec_HEADTOUCH::touchSpec_HEADTOUCH(){}

touchSpec_HEADTOUCH::~touchSpec_HEADTOUCH(){}

void touchSpec_HEADTOUCH::printSelf()
{
  printf("HEADTOUCH");
}

/********************************************************************/

touchSpec_ALLAXESTOUCH::touchSpec_ALLAXESTOUCH(){}

touchSpec_ALLAXESTOUCH::~touchSpec_ALLAXESTOUCH(){}

void touchSpec_ALLAXESTOUCH::printSelf()
{
  printf("ALLAXESTOUCH");
}

/********************************************************************/

pushStm::pushStm(){}

pushStm::pushStm(
  std::list<stackElement *> * stackElementListIn)
{
  a_stackElementList = stackElementListIn;
}

pushStm::~pushStm(){}

void pushStm::printSelf()
{
  printf("PUSH");
  printf("/");
  if (a_stackElementList->begin() == a_stackElementList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<stackElement *>::iterator iter;
      for (iter = a_stackElementList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_stackElementList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

std::list<stackElement *> * pushStm::get_stackElementList()
{ return a_stackElementList; }
void pushStm::set_stackElementList(std::list<stackElement *> * stackElementListIn)
{ a_stackElementList = stackElementListIn; }

/********************************************************************/

qisdefStm::qisdefStm(){}

qisdefStm::qisdefStm(
  qLabel * qLabelIn,
  stringVal * typIn,
  stringVal * textIn)
{
  a_qLabel = qLabelIn;
  typ = typIn;
  text = textIn;
}

qisdefStm::~qisdefStm(){}

void qisdefStm::printSelf()
{
  a_qLabel->printSelf();
  printf("=");
  printf("QISDEF");
  printf("/");
  typ->printSelf();
  if (text)
    {
      printf(",");
      text->printSelf();
    }
  printf("%c%c", 13, 10);
}

qLabel * qisdefStm::get_qLabel()
{ return a_qLabel; }
void qisdefStm::set_qLabel(qLabel * qLabelIn)
{ a_qLabel = qLabelIn; }
stringVal * qisdefStm::get_typ()
{ return typ; }
void qisdefStm::set_typ(stringVal * typIn)
{ typ = typIn; }
stringVal * qisdefStm::get_text()
{ return text; }
void qisdefStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

readStm::readStm(){}

readStm::readStm(
  didLabel * didLabelIn,
  std::list<readSpec *> * readSpecListIn)
{
  a_didLabel = didLabelIn;
  a_readSpecList = readSpecListIn;
}

readStm::~readStm(){}

void readStm::printSelf()
{
  printf("READ");
  printf("/");
  a_didLabel->printSelf();
  printf(",");
  if (a_readSpecList->begin() == a_readSpecList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<readSpec *>::iterator iter;
      for (iter = a_readSpecList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_readSpecList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

didLabel * readStm::get_didLabel()
{ return a_didLabel; }
void readStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
std::list<readSpec *> * readStm::get_readSpecList()
{ return a_readSpecList; }
void readStm::set_readSpecList(std::list<readSpec *> * readSpecListIn)
{ a_readSpecList = readSpecListIn; }

/********************************************************************/

readSpec::readSpec(){}

readSpec::readSpec(
  rwVar * rwVarIn,
  rwFormat * rwFormatIn)
{
  a_rwVar = rwVarIn;
  a_rwFormat = rwFormatIn;
}

readSpec::~readSpec(){}

void readSpec::printSelf()
{
  a_rwVar->printSelf();
  if (a_rwFormat)
    {
      a_rwFormat->printSelf();
    }
}

rwVar * readSpec::get_rwVar()
{ return a_rwVar; }
void readSpec::set_rwVar(rwVar * rwVarIn)
{ a_rwVar = rwVarIn; }
rwFormat * readSpec::get_rwFormat()
{ return a_rwFormat; }
void readSpec::set_rwFormat(rwFormat * rwFormatIn)
{ a_rwFormat = rwFormatIn; }

/********************************************************************/

recallDatumStm::recallDatumStm(){}

recallDatumStm::recallDatumStm(
  datumLabel2 * datumLabel2In,
  didLabel * didLabelIn)
{
  a_datumLabel2 = datumLabel2In;
  a_didLabel = didLabelIn;
}

recallDatumStm::~recallDatumStm(){}

void recallDatumStm::printSelf()
{
  printf("RECALL");
  printf("/");
  a_datumLabel2->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
  printf("%c%c", 13, 10);
}

datumLabel2 * recallDatumStm::get_datumLabel2()
{ return a_datumLabel2; }
void recallDatumStm::set_datumLabel2(datumLabel2 * datumLabel2In)
{ a_datumLabel2 = datumLabel2In; }
didLabel * recallDatumStm::get_didLabel()
{ return a_didLabel; }
void recallDatumStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

recallFeatureStm::recallFeatureStm(){}

recallFeatureStm::recallFeatureStm(
  faLabel * faLabelIn,
  didLabel * didLabelIn)
{
  a_faLabel = faLabelIn;
  a_didLabel = didLabelIn;
}

recallFeatureStm::~recallFeatureStm(){}

void recallFeatureStm::printSelf()
{
  printf("RECALL");
  printf("/");
  a_faLabel->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
  printf("%c%c", 13, 10);
}

faLabel * recallFeatureStm::get_faLabel()
{ return a_faLabel; }
void recallFeatureStm::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
didLabel * recallFeatureStm::get_didLabel()
{ return a_didLabel; }
void recallFeatureStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

recallRotaryTableStm::recallRotaryTableStm(){}

recallRotaryTableStm::recallRotaryTableStm(
  rtLabel * rtLabelIn,
  didLabel * didLabelIn)
{
  a_rtLabel = rtLabelIn;
  a_didLabel = didLabelIn;
}

recallRotaryTableStm::~recallRotaryTableStm(){}

void recallRotaryTableStm::printSelf()
{
  printf("RECALL");
  printf("/");
  a_rtLabel->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
  printf("%c%c", 13, 10);
}

rtLabel * recallRotaryTableStm::get_rtLabel()
{ return a_rtLabel; }
void recallRotaryTableStm::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
didLabel * recallRotaryTableStm::get_didLabel()
{ return a_didLabel; }
void recallRotaryTableStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

recallDMLStm::recallDMLStm(){}

recallDMLStm::recallDMLStm(
  didLabel * didLabelIn,
  daLabel * daLabelIn)
{
  a_didLabel = didLabelIn;
  a_daLabel = daLabelIn;
}

recallDMLStm::~recallDMLStm(){}

void recallDMLStm::printSelf()
{
  printf("RECALL");
  printf("/");
  printf("DML");
  printf(",");
  a_didLabel->printSelf();
  printf(",");
  a_daLabel->printSelf();
  printf("%c%c", 13, 10);
}

didLabel * recallDMLStm::get_didLabel()
{ return a_didLabel; }
void recallDMLStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
daLabel * recallDMLStm::get_daLabel()
{ return a_daLabel; }
void recallDMLStm::set_daLabel(daLabel * daLabelIn)
{ a_daLabel = daLabelIn; }

/********************************************************************/

refmntStm::refmntStm(){}

refmntStm::refmntStm(
  rmLabel * rmLabelIn,
  vector * xVecIn,
  vector * zVecIn,
  vector * offsetIn)
{
  a_rmLabel = rmLabelIn;
  xVec = xVecIn;
  zVec = zVecIn;
  offset = offsetIn;
}

refmntStm::~refmntStm(){}

void refmntStm::printSelf()
{
  a_rmLabel->printSelf();
  printf("=");
  printf("REFMNT");
  printf("/");
  printf("XVEC");
  printf(",");
  xVec->printSelf();
  printf(",");
  printf("ZVEC");
  printf(",");
  zVec->printSelf();
  printf(",");
  printf("MNTLEN");
  printf(",");
  offset->printSelf();
  printf("%c%c", 13, 10);
}

rmLabel * refmntStm::get_rmLabel()
{ return a_rmLabel; }
void refmntStm::set_rmLabel(rmLabel * rmLabelIn)
{ a_rmLabel = rmLabelIn; }
vector * refmntStm::get_xVec()
{ return xVec; }
void refmntStm::set_xVec(vector * xVecIn)
{ xVec = xVecIn; }
vector * refmntStm::get_zVec()
{ return zVec; }
void refmntStm::set_zVec(vector * zVecIn)
{ zVec = zVecIn; }
vector * refmntStm::get_offset()
{ return offset; }
void refmntStm::set_offset(vector * offsetIn)
{ offset = offsetIn; }

/********************************************************************/

reportStm::reportStm(){}

reportStm::reportStm(
  rLabel * rLabelIn,
  std::list<reportItem *> * reportItemListIn,
  stringVal * textIn)
{
  a_rLabel = rLabelIn;
  a_reportItemList = reportItemListIn;
  text = textIn;
}

reportStm::~reportStm(){}

void reportStm::printSelf()
{
  a_rLabel->printSelf();
  printf("=");
  printf("REPORT");
  printf("/");
  if (a_reportItemList->begin() == a_reportItemList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<reportItem *>::iterator iter;
      for (iter = a_reportItemList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_reportItemList->end())
            break;
          printf(",");
        }
    }
  if (text)
    {
      printf(",");
      text->printSelf();
    }
  printf("%c%c", 13, 10);
}

rLabel * reportStm::get_rLabel()
{ return a_rLabel; }
void reportStm::set_rLabel(rLabel * rLabelIn)
{ a_rLabel = rLabelIn; }
std::list<reportItem *> * reportStm::get_reportItemList()
{ return a_reportItemList; }
void reportStm::set_reportItemList(std::list<reportItem *> * reportItemListIn)
{ a_reportItemList = reportItemListIn; }
stringVal * reportStm::get_text()
{ return text; }
void reportStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

reportItem::reportItem(){};

reportItem::~reportItem(){}

/********************************************************************/

reportItem_ALGOR::reportItem_ALGOR(){}

reportItem_ALGOR::~reportItem_ALGOR(){}

void reportItem_ALGOR::printSelf()
{
  printf("ALGOR");
}

/********************************************************************/

reportItem_DATE::reportItem_DATE(){}

reportItem_DATE::~reportItem_DATE(){}

void reportItem_DATE::printSelf()
{
  printf("DATE");
}

/********************************************************************/

reportItem_HUMID::reportItem_HUMID(){}

reportItem_HUMID::~reportItem_HUMID(){}

void reportItem_HUMID::printSelf()
{
  printf("HUMID");
}

/********************************************************************/

reportItem_MODE::reportItem_MODE(){}

reportItem_MODE::~reportItem_MODE(){}

void reportItem_MODE::printSelf()
{
  printf("MODE");
}

/********************************************************************/

reportItem_TEMPC::reportItem_TEMPC(){}

reportItem_TEMPC::~reportItem_TEMPC(){}

void reportItem_TEMPC::printSelf()
{
  printf("TEMPC");
}

/********************************************************************/

reportItem_TEMPF::reportItem_TEMPF(){}

reportItem_TEMPF::~reportItem_TEMPF(){}

void reportItem_TEMPF::printSelf()
{
  printf("TEMPF");
}

/********************************************************************/

reportItem_TEMPWC::reportItem_TEMPWC(){}

reportItem_TEMPWC::~reportItem_TEMPWC(){}

void reportItem_TEMPWC::printSelf()
{
  printf("TEMPWC");
}

/********************************************************************/

reportItem_TEMPWF::reportItem_TEMPWF(){}

reportItem_TEMPWF::~reportItem_TEMPWF(){}

void reportItem_TEMPWF::printSelf()
{
  printf("TEMPWF");
}

/********************************************************************/

reportItem_TIME::reportItem_TIME(){}

reportItem_TIME::~reportItem_TIME(){}

void reportItem_TIME::printSelf()
{
  printf("TIME");
}

/********************************************************************/

reportItem_qisLabel::reportItem_qisLabel(){}

reportItem_qisLabel::reportItem_qisLabel(
  qisLabel * qisLabelIn)
{
  a_qisLabel = qisLabelIn;
}

reportItem_qisLabel::~reportItem_qisLabel(){}

void reportItem_qisLabel::printSelf()
{
  a_qisLabel->printSelf();
}

qisLabel * reportItem_qisLabel::get_qisLabel()
{ return a_qisLabel; }
void reportItem_qisLabel::set_qisLabel(qisLabel * qisLabelIn)
{ a_qisLabel = qisLabelIn; }

/********************************************************************/

resumeStm::resumeStm(){}

resumeStm::resumeStm(
  resumeMinor * resumeMinorIn)
{
  a_resumeMinor = resumeMinorIn;
}

resumeStm::~resumeStm(){}

void resumeStm::printSelf()
{
  printf("RESUME");
  printf("/");
  a_resumeMinor->printSelf();
  printf("%c%c", 13, 10);
}

resumeMinor * resumeStm::get_resumeMinor()
{ return a_resumeMinor; }
void resumeStm::set_resumeMinor(resumeMinor * resumeMinorIn)
{ a_resumeMinor = resumeMinorIn; }

/********************************************************************/

resumeMinor::resumeMinor(){};

resumeMinor::~resumeMinor(){}

/********************************************************************/

resumeMinor_jumpLabel::resumeMinor_jumpLabel(){}

resumeMinor_jumpLabel::resumeMinor_jumpLabel(
  jumpLabel * jumpLabelIn)
{
  a_jumpLabel = jumpLabelIn;
}

resumeMinor_jumpLabel::~resumeMinor_jumpLabel(){}

void resumeMinor_jumpLabel::printSelf()
{
  a_jumpLabel->printSelf();
}

jumpLabel * resumeMinor_jumpLabel::get_jumpLabel()
{ return a_jumpLabel; }
void resumeMinor_jumpLabel::set_jumpLabel(jumpLabel * jumpLabelIn)
{ a_jumpLabel = jumpLabelIn; }

/********************************************************************/

resumeMinor_CURENT::resumeMinor_CURENT(){}

resumeMinor_CURENT::~resumeMinor_CURENT(){}

void resumeMinor_CURENT::printSelf()
{
  printf("CURENT");
}

/********************************************************************/

resumeMinor_END::resumeMinor_END(){}

resumeMinor_END::~resumeMinor_END(){}

void resumeMinor_END::printSelf()
{
  printf("END");
}

/********************************************************************/

resumeMinor_NEXT::resumeMinor_NEXT(){}

resumeMinor_NEXT::~resumeMinor_NEXT(){}

void resumeMinor_NEXT::printSelf()
{
  printf("NEXT");
}

/********************************************************************/

resumeMinor_START::resumeMinor_START(){}

resumeMinor_START::~resumeMinor_START(){}

void resumeMinor_START::printSelf()
{
  printf("START");
}

/********************************************************************/

resumeMinor_STOP::resumeMinor_STOP(){}

resumeMinor_STOP::~resumeMinor_STOP(){}

void resumeMinor_STOP::printSelf()
{
  printf("STOP");
}

/********************************************************************/

rmeasStm::rmeasStm(){}

rmeasStm::rmeasStm(
  rmeasMinor * rmeasMinorIn)
{
  a_rmeasMinor = rmeasMinorIn;
}

rmeasStm::~rmeasStm(){}

void rmeasStm::printSelf()
{
  printf("RMEAS");
  printf("/");
  a_rmeasMinor->printSelf();
  printf("%c%c", 13, 10);
}

rmeasMinor * rmeasStm::get_rmeasMinor()
{ return a_rmeasMinor; }
void rmeasStm::set_rmeasMinor(rmeasMinor * rmeasMinorIn)
{ a_rmeasMinor = rmeasMinorIn; }

/********************************************************************/

rmeasMinor::rmeasMinor(){};

rmeasMinor::~rmeasMinor(){}

/********************************************************************/

rmeasArc::rmeasArc(){};

rmeasArc::~rmeasArc(){}

/********************************************************************/

rmeasArc_rmeasSpecFa::rmeasArc_rmeasSpecFa(){}

rmeasArc_rmeasSpecFa::rmeasArc_rmeasSpecFa(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasArc_rmeasSpecFa::~rmeasArc_rmeasSpecFa(){}

void rmeasArc_rmeasSpecFa::printSelf()
{
  printf("ARC");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasArc_rmeasSpecFa::get_fLabel()
{ return a_fLabel; }
void rmeasArc_rmeasSpecFa::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasArc_rmeasSpecFa::get_numMeas()
{ return numMeas; }
void rmeasArc_rmeasSpecFa::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasArc_rmeasSpecFa::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasArc_rmeasSpecFa::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasArc_rmeasSpecVecbld::rmeasArc_rmeasSpecVecbld(){}

rmeasArc_rmeasSpecVecbld::rmeasArc_rmeasSpecVecbld(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbld * rmeasSpecVecbldIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
}

rmeasArc_rmeasSpecVecbld::~rmeasArc_rmeasSpecVecbld(){}

void rmeasArc_rmeasSpecVecbld::printSelf()
{
  printf("ARC");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbld->printSelf();
}

fLabel * rmeasArc_rmeasSpecVecbld::get_fLabel()
{ return a_fLabel; }
void rmeasArc_rmeasSpecVecbld::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasArc_rmeasSpecVecbld::get_numMeas()
{ return numMeas; }
void rmeasArc_rmeasSpecVecbld::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbld * rmeasArc_rmeasSpecVecbld::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasArc_rmeasSpecVecbld::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }

/********************************************************************/

rmeasCircle::rmeasCircle(){};

rmeasCircle::~rmeasCircle(){}

/********************************************************************/

rmeasCircle_rmeasSpecFa::rmeasCircle_rmeasSpecFa(){}

rmeasCircle_rmeasSpecFa::rmeasCircle_rmeasSpecFa(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasCircle_rmeasSpecFa::~rmeasCircle_rmeasSpecFa(){}

void rmeasCircle_rmeasSpecFa::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasCircle_rmeasSpecFa::get_fLabel()
{ return a_fLabel; }
void rmeasCircle_rmeasSpecFa::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasCircle_rmeasSpecFa::get_numMeas()
{ return numMeas; }
void rmeasCircle_rmeasSpecFa::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasCircle_rmeasSpecFa::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasCircle_rmeasSpecFa::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasCircle_rmeasSpecVecbld::rmeasCircle_rmeasSpecVecbld(){}

rmeasCircle_rmeasSpecVecbld::rmeasCircle_rmeasSpecVecbld(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbld * rmeasSpecVecbldIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
}

rmeasCircle_rmeasSpecVecbld::~rmeasCircle_rmeasSpecVecbld(){}

void rmeasCircle_rmeasSpecVecbld::printSelf()
{
  printf("CIRCLE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbld->printSelf();
}

fLabel * rmeasCircle_rmeasSpecVecbld::get_fLabel()
{ return a_fLabel; }
void rmeasCircle_rmeasSpecVecbld::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasCircle_rmeasSpecVecbld::get_numMeas()
{ return numMeas; }
void rmeasCircle_rmeasSpecVecbld::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbld * rmeasCircle_rmeasSpecVecbld::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasCircle_rmeasSpecVecbld::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }

/********************************************************************/

rmeasCone::rmeasCone(){}

rmeasCone::rmeasCone(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasCone::~rmeasCone(){}

void rmeasCone::printSelf()
{
  printf("CONE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasCone::get_fLabel()
{ return a_fLabel; }
void rmeasCone::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasCone::get_numMeas()
{ return numMeas; }
void rmeasCone::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasCone::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasCone::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasCparln::rmeasCparln(){};

rmeasCparln::~rmeasCparln(){}

/********************************************************************/

rmeasCparln_rmeasSpecFaOrient::rmeasCparln_rmeasSpecFaOrient(){}

rmeasCparln_rmeasSpecFaOrient::rmeasCparln_rmeasSpecFaOrient(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFaOrient * rmeasSpecFaOrientIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFaOrient = rmeasSpecFaOrientIn;
}

rmeasCparln_rmeasSpecFaOrient::~rmeasCparln_rmeasSpecFaOrient(){}

void rmeasCparln_rmeasSpecFaOrient::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFaOrient->printSelf();
}

fLabel * rmeasCparln_rmeasSpecFaOrient::get_fLabel()
{ return a_fLabel; }
void rmeasCparln_rmeasSpecFaOrient::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasCparln_rmeasSpecFaOrient::get_numMeas()
{ return numMeas; }
void rmeasCparln_rmeasSpecFaOrient::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFaOrient * rmeasCparln_rmeasSpecFaOrient::get_rmeasSpecFaOrient()
{ return a_rmeasSpecFaOrient; }
void rmeasCparln_rmeasSpecFaOrient::set_rmeasSpecFaOrient(rmeasSpecFaOrient * rmeasSpecFaOrientIn)
{ a_rmeasSpecFaOrient = rmeasSpecFaOrientIn; }

/********************************************************************/

rmeasCparln_rmeasSpecVecbldOrient::rmeasCparln_rmeasSpecVecbldOrient(){}

rmeasCparln_rmeasSpecVecbldOrient::rmeasCparln_rmeasSpecVecbldOrient(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbldOrient * rmeasSpecVecbldOrientIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbldOrient = rmeasSpecVecbldOrientIn;
}

rmeasCparln_rmeasSpecVecbldOrient::~rmeasCparln_rmeasSpecVecbldOrient(){}

void rmeasCparln_rmeasSpecVecbldOrient::printSelf()
{
  printf("CPARLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbldOrient->printSelf();
}

fLabel * rmeasCparln_rmeasSpecVecbldOrient::get_fLabel()
{ return a_fLabel; }
void rmeasCparln_rmeasSpecVecbldOrient::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasCparln_rmeasSpecVecbldOrient::get_numMeas()
{ return numMeas; }
void rmeasCparln_rmeasSpecVecbldOrient::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbldOrient * rmeasCparln_rmeasSpecVecbldOrient::get_rmeasSpecVecbldOrient()
{ return a_rmeasSpecVecbldOrient; }
void rmeasCparln_rmeasSpecVecbldOrient::set_rmeasSpecVecbldOrient(rmeasSpecVecbldOrient * rmeasSpecVecbldOrientIn)
{ a_rmeasSpecVecbldOrient = rmeasSpecVecbldOrientIn; }

/********************************************************************/

rmeasCylndr::rmeasCylndr(){}

rmeasCylndr::rmeasCylndr(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasCylndr::~rmeasCylndr(){}

void rmeasCylndr::printSelf()
{
  printf("CYLNDR");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasCylndr::get_fLabel()
{ return a_fLabel; }
void rmeasCylndr::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasCylndr::get_numMeas()
{ return numMeas; }
void rmeasCylndr::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasCylndr::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasCylndr::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasEdgept::rmeasEdgept(){};

rmeasEdgept::~rmeasEdgept(){}

/********************************************************************/

rmeasEdgept_rmeasSpecFaAxis::rmeasEdgept_rmeasSpecFaAxis(){}

rmeasEdgept_rmeasSpecFaAxis::rmeasEdgept_rmeasSpecFaAxis(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFaAxis = rmeasSpecFaAxisIn;
}

rmeasEdgept_rmeasSpecFaAxis::~rmeasEdgept_rmeasSpecFaAxis(){}

void rmeasEdgept_rmeasSpecFaAxis::printSelf()
{
  printf("EDGEPT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFaAxis->printSelf();
}

fLabel * rmeasEdgept_rmeasSpecFaAxis::get_fLabel()
{ return a_fLabel; }
void rmeasEdgept_rmeasSpecFaAxis::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasEdgept_rmeasSpecFaAxis::get_numMeas()
{ return numMeas; }
void rmeasEdgept_rmeasSpecFaAxis::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFaAxis * rmeasEdgept_rmeasSpecFaAxis::get_rmeasSpecFaAxis()
{ return a_rmeasSpecFaAxis; }
void rmeasEdgept_rmeasSpecFaAxis::set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{ a_rmeasSpecFaAxis = rmeasSpecFaAxisIn; }

/********************************************************************/

rmeasEdgept_rmeasSpecVecbldEdgept::rmeasEdgept_rmeasSpecVecbldEdgept(){}

rmeasEdgept_rmeasSpecVecbldEdgept::rmeasEdgept_rmeasSpecVecbldEdgept(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbldEdgept * rmeasSpecVecbldEdgeptIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbldEdgept = rmeasSpecVecbldEdgeptIn;
}

rmeasEdgept_rmeasSpecVecbldEdgept::~rmeasEdgept_rmeasSpecVecbldEdgept(){}

void rmeasEdgept_rmeasSpecVecbldEdgept::printSelf()
{
  printf("EDGEPT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbldEdgept->printSelf();
}

fLabel * rmeasEdgept_rmeasSpecVecbldEdgept::get_fLabel()
{ return a_fLabel; }
void rmeasEdgept_rmeasSpecVecbldEdgept::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasEdgept_rmeasSpecVecbldEdgept::get_numMeas()
{ return numMeas; }
void rmeasEdgept_rmeasSpecVecbldEdgept::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbldEdgept * rmeasEdgept_rmeasSpecVecbldEdgept::get_rmeasSpecVecbldEdgept()
{ return a_rmeasSpecVecbldEdgept; }
void rmeasEdgept_rmeasSpecVecbldEdgept::set_rmeasSpecVecbldEdgept(rmeasSpecVecbldEdgept * rmeasSpecVecbldEdgeptIn)
{ a_rmeasSpecVecbldEdgept = rmeasSpecVecbldEdgeptIn; }

/********************************************************************/

rmeasEllips::rmeasEllips(){};

rmeasEllips::~rmeasEllips(){}

/********************************************************************/

rmeasEllips_rmeasSpecFa::rmeasEllips_rmeasSpecFa(){}

rmeasEllips_rmeasSpecFa::rmeasEllips_rmeasSpecFa(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasEllips_rmeasSpecFa::~rmeasEllips_rmeasSpecFa(){}

void rmeasEllips_rmeasSpecFa::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasEllips_rmeasSpecFa::get_fLabel()
{ return a_fLabel; }
void rmeasEllips_rmeasSpecFa::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasEllips_rmeasSpecFa::get_numMeas()
{ return numMeas; }
void rmeasEllips_rmeasSpecFa::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasEllips_rmeasSpecFa::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasEllips_rmeasSpecFa::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasEllips_rmeasSpecVecbld::rmeasEllips_rmeasSpecVecbld(){}

rmeasEllips_rmeasSpecVecbld::rmeasEllips_rmeasSpecVecbld(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbld * rmeasSpecVecbldIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
}

rmeasEllips_rmeasSpecVecbld::~rmeasEllips_rmeasSpecVecbld(){}

void rmeasEllips_rmeasSpecVecbld::printSelf()
{
  printf("ELLIPS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbld->printSelf();
}

fLabel * rmeasEllips_rmeasSpecVecbld::get_fLabel()
{ return a_fLabel; }
void rmeasEllips_rmeasSpecVecbld::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasEllips_rmeasSpecVecbld::get_numMeas()
{ return numMeas; }
void rmeasEllips_rmeasSpecVecbld::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbld * rmeasEllips_rmeasSpecVecbld::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasEllips_rmeasSpecVecbld::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }

/********************************************************************/

rmeasGcurve::rmeasGcurve(){};

rmeasGcurve::~rmeasGcurve(){}

/********************************************************************/

rmeasGcurve_rmeasSpecFeatAxis::rmeasGcurve_rmeasSpecFeatAxis(){}

rmeasGcurve_rmeasSpecFeatAxis::rmeasGcurve_rmeasSpecFeatAxis(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFeatAxis * rmeasSpecFeatAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFeatAxis = rmeasSpecFeatAxisIn;
}

rmeasGcurve_rmeasSpecFeatAxis::~rmeasGcurve_rmeasSpecFeatAxis(){}

void rmeasGcurve_rmeasSpecFeatAxis::printSelf()
{
  printf("GCURVE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFeatAxis->printSelf();
}

fLabel * rmeasGcurve_rmeasSpecFeatAxis::get_fLabel()
{ return a_fLabel; }
void rmeasGcurve_rmeasSpecFeatAxis::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasGcurve_rmeasSpecFeatAxis::get_numMeas()
{ return numMeas; }
void rmeasGcurve_rmeasSpecFeatAxis::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFeatAxis * rmeasGcurve_rmeasSpecFeatAxis::get_rmeasSpecFeatAxis()
{ return a_rmeasSpecFeatAxis; }
void rmeasGcurve_rmeasSpecFeatAxis::set_rmeasSpecFeatAxis(rmeasSpecFeatAxis * rmeasSpecFeatAxisIn)
{ a_rmeasSpecFeatAxis = rmeasSpecFeatAxisIn; }

/********************************************************************/

rmeasGcurve_rmeasSpecVecbld::rmeasGcurve_rmeasSpecVecbld(){}

rmeasGcurve_rmeasSpecVecbld::rmeasGcurve_rmeasSpecVecbld(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbld * rmeasSpecVecbldIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
}

rmeasGcurve_rmeasSpecVecbld::~rmeasGcurve_rmeasSpecVecbld(){}

void rmeasGcurve_rmeasSpecVecbld::printSelf()
{
  printf("GCURVE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbld->printSelf();
}

fLabel * rmeasGcurve_rmeasSpecVecbld::get_fLabel()
{ return a_fLabel; }
void rmeasGcurve_rmeasSpecVecbld::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasGcurve_rmeasSpecVecbld::get_numMeas()
{ return numMeas; }
void rmeasGcurve_rmeasSpecVecbld::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbld * rmeasGcurve_rmeasSpecVecbld::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasGcurve_rmeasSpecVecbld::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }

/********************************************************************/

rmeasGsurf::rmeasGsurf(){}

rmeasGsurf::rmeasGsurf(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFaAxis = rmeasSpecFaAxisIn;
}

rmeasGsurf::~rmeasGsurf(){}

void rmeasGsurf::printSelf()
{
  printf("GSURF");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFaAxis->printSelf();
}

fLabel * rmeasGsurf::get_fLabel()
{ return a_fLabel; }
void rmeasGsurf::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasGsurf::get_numMeas()
{ return numMeas; }
void rmeasGsurf::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFaAxis * rmeasGsurf::get_rmeasSpecFaAxis()
{ return a_rmeasSpecFaAxis; }
void rmeasGsurf::set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{ a_rmeasSpecFaAxis = rmeasSpecFaAxisIn; }

/********************************************************************/

rmeasLine::rmeasLine(){};

rmeasLine::~rmeasLine(){}

/********************************************************************/

rmeasLine_rmeasSpecFeatAxis::rmeasLine_rmeasSpecFeatAxis(){}

rmeasLine_rmeasSpecFeatAxis::rmeasLine_rmeasSpecFeatAxis(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFeatAxis * rmeasSpecFeatAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFeatAxis = rmeasSpecFeatAxisIn;
}

rmeasLine_rmeasSpecFeatAxis::~rmeasLine_rmeasSpecFeatAxis(){}

void rmeasLine_rmeasSpecFeatAxis::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFeatAxis->printSelf();
}

fLabel * rmeasLine_rmeasSpecFeatAxis::get_fLabel()
{ return a_fLabel; }
void rmeasLine_rmeasSpecFeatAxis::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasLine_rmeasSpecFeatAxis::get_numMeas()
{ return numMeas; }
void rmeasLine_rmeasSpecFeatAxis::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFeatAxis * rmeasLine_rmeasSpecFeatAxis::get_rmeasSpecFeatAxis()
{ return a_rmeasSpecFeatAxis; }
void rmeasLine_rmeasSpecFeatAxis::set_rmeasSpecFeatAxis(rmeasSpecFeatAxis * rmeasSpecFeatAxisIn)
{ a_rmeasSpecFeatAxis = rmeasSpecFeatAxisIn; }

/********************************************************************/

rmeasLine_rmeasSpecVecbld::rmeasLine_rmeasSpecVecbld(){}

rmeasLine_rmeasSpecVecbld::rmeasLine_rmeasSpecVecbld(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbld * rmeasSpecVecbldIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
}

rmeasLine_rmeasSpecVecbld::~rmeasLine_rmeasSpecVecbld(){}

void rmeasLine_rmeasSpecVecbld::printSelf()
{
  printf("LINE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbld->printSelf();
}

fLabel * rmeasLine_rmeasSpecVecbld::get_fLabel()
{ return a_fLabel; }
void rmeasLine_rmeasSpecVecbld::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasLine_rmeasSpecVecbld::get_numMeas()
{ return numMeas; }
void rmeasLine_rmeasSpecVecbld::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbld * rmeasLine_rmeasSpecVecbld::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasLine_rmeasSpecVecbld::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }

/********************************************************************/

rmeasObject::rmeasObject(){};

rmeasObject::~rmeasObject(){}

/********************************************************************/

rmeasObject_rmeasSpecFa::rmeasObject_rmeasSpecFa(){}

rmeasObject_rmeasSpecFa::rmeasObject_rmeasSpecFa(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasObject_rmeasSpecFa::~rmeasObject_rmeasSpecFa(){}

void rmeasObject_rmeasSpecFa::printSelf()
{
  printf("OBJECT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasObject_rmeasSpecFa::get_fLabel()
{ return a_fLabel; }
void rmeasObject_rmeasSpecFa::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasObject_rmeasSpecFa::get_numMeas()
{ return numMeas; }
void rmeasObject_rmeasSpecFa::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasObject_rmeasSpecFa::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasObject_rmeasSpecFa::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasObject_rmeasSpecVecbld::rmeasObject_rmeasSpecVecbld(){}

rmeasObject_rmeasSpecVecbld::rmeasObject_rmeasSpecVecbld(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbld * rmeasSpecVecbldIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
}

rmeasObject_rmeasSpecVecbld::~rmeasObject_rmeasSpecVecbld(){}

void rmeasObject_rmeasSpecVecbld::printSelf()
{
  printf("OBJECT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbld->printSelf();
}

fLabel * rmeasObject_rmeasSpecVecbld::get_fLabel()
{ return a_fLabel; }
void rmeasObject_rmeasSpecVecbld::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasObject_rmeasSpecVecbld::get_numMeas()
{ return numMeas; }
void rmeasObject_rmeasSpecVecbld::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbld * rmeasObject_rmeasSpecVecbld::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasObject_rmeasSpecVecbld::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }

/********************************************************************/

rmeasParpln::rmeasParpln(){}

rmeasParpln::rmeasParpln(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasParpln::~rmeasParpln(){}

void rmeasParpln::printSelf()
{
  printf("PARPLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasParpln::get_fLabel()
{ return a_fLabel; }
void rmeasParpln::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasParpln::get_numMeas()
{ return numMeas; }
void rmeasParpln::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasParpln::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasParpln::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasPlane::rmeasPlane(){}

rmeasPlane::rmeasPlane(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFaAxis = rmeasSpecFaAxisIn;
}

rmeasPlane::~rmeasPlane(){}

void rmeasPlane::printSelf()
{
  printf("PLANE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFaAxis->printSelf();
}

fLabel * rmeasPlane::get_fLabel()
{ return a_fLabel; }
void rmeasPlane::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasPlane::get_numMeas()
{ return numMeas; }
void rmeasPlane::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFaAxis * rmeasPlane::get_rmeasSpecFaAxis()
{ return a_rmeasSpecFaAxis; }
void rmeasPlane::set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{ a_rmeasSpecFaAxis = rmeasSpecFaAxisIn; }

/********************************************************************/

rmeasPoint::rmeasPoint(){};

rmeasPoint::~rmeasPoint(){}

/********************************************************************/

rmeasPoint_rmeasSpecFaAxis::rmeasPoint_rmeasSpecFaAxis(){}

rmeasPoint_rmeasSpecFaAxis::rmeasPoint_rmeasSpecFaAxis(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFaAxis = rmeasSpecFaAxisIn;
}

rmeasPoint_rmeasSpecFaAxis::~rmeasPoint_rmeasSpecFaAxis(){}

void rmeasPoint_rmeasSpecFaAxis::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFaAxis->printSelf();
}

fLabel * rmeasPoint_rmeasSpecFaAxis::get_fLabel()
{ return a_fLabel; }
void rmeasPoint_rmeasSpecFaAxis::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasPoint_rmeasSpecFaAxis::get_numMeas()
{ return numMeas; }
void rmeasPoint_rmeasSpecFaAxis::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFaAxis * rmeasPoint_rmeasSpecFaAxis::get_rmeasSpecFaAxis()
{ return a_rmeasSpecFaAxis; }
void rmeasPoint_rmeasSpecFaAxis::set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{ a_rmeasSpecFaAxis = rmeasSpecFaAxisIn; }

/********************************************************************/

rmeasPoint_rmeasSpecVecbld::rmeasPoint_rmeasSpecVecbld(){}

rmeasPoint_rmeasSpecVecbld::rmeasPoint_rmeasSpecVecbld(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecVecbld * rmeasSpecVecbldIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
}

rmeasPoint_rmeasSpecVecbld::~rmeasPoint_rmeasSpecVecbld(){}

void rmeasPoint_rmeasSpecVecbld::printSelf()
{
  printf("POINT");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecVecbld->printSelf();
}

fLabel * rmeasPoint_rmeasSpecVecbld::get_fLabel()
{ return a_fLabel; }
void rmeasPoint_rmeasSpecVecbld::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasPoint_rmeasSpecVecbld::get_numMeas()
{ return numMeas; }
void rmeasPoint_rmeasSpecVecbld::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecVecbld * rmeasPoint_rmeasSpecVecbld::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasPoint_rmeasSpecVecbld::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }

/********************************************************************/

rmeasRctngl::rmeasRctngl(){}

rmeasRctngl::rmeasRctngl(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasRctngl::~rmeasRctngl(){}

void rmeasRctngl::printSelf()
{
  printf("RCTNGL");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasRctngl::get_fLabel()
{ return a_fLabel; }
void rmeasRctngl::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasRctngl::get_numMeas()
{ return numMeas; }
void rmeasRctngl::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasRctngl::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasRctngl::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasSphere::rmeasSphere(){}

rmeasSphere::rmeasSphere(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFaAxis = rmeasSpecFaAxisIn;
}

rmeasSphere::~rmeasSphere(){}

void rmeasSphere::printSelf()
{
  printf("SPHERE");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFaAxis->printSelf();
}

fLabel * rmeasSphere::get_fLabel()
{ return a_fLabel; }
void rmeasSphere::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasSphere::get_numMeas()
{ return numMeas; }
void rmeasSphere::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFaAxis * rmeasSphere::get_rmeasSpecFaAxis()
{ return a_rmeasSpecFaAxis; }
void rmeasSphere::set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{ a_rmeasSpecFaAxis = rmeasSpecFaAxisIn; }

/********************************************************************/

rmeasSympln::rmeasSympln(){}

rmeasSympln::rmeasSympln(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFa * rmeasSpecFaIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFa = rmeasSpecFaIn;
}

rmeasSympln::~rmeasSympln(){}

void rmeasSympln::printSelf()
{
  printf("SYMPLN");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFa->printSelf();
}

fLabel * rmeasSympln::get_fLabel()
{ return a_fLabel; }
void rmeasSympln::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasSympln::get_numMeas()
{ return numMeas; }
void rmeasSympln::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFa * rmeasSympln::get_rmeasSpecFa()
{ return a_rmeasSpecFa; }
void rmeasSympln::set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn)
{ a_rmeasSpecFa = rmeasSpecFaIn; }

/********************************************************************/

rmeasTorus::rmeasTorus(){}

rmeasTorus::rmeasTorus(
  fLabel * fLabelIn,
  intVal * numMeasIn,
  rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{
  a_fLabel = fLabelIn;
  numMeas = numMeasIn;
  a_rmeasSpecFaAxis = rmeasSpecFaAxisIn;
}

rmeasTorus::~rmeasTorus(){}

void rmeasTorus::printSelf()
{
  printf("TORUS");
  printf(",");
  a_fLabel->printSelf();
  printf(",");
  numMeas->printSelf();
  printf(",");
  a_rmeasSpecFaAxis->printSelf();
}

fLabel * rmeasTorus::get_fLabel()
{ return a_fLabel; }
void rmeasTorus::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }
intVal * rmeasTorus::get_numMeas()
{ return numMeas; }
void rmeasTorus::set_numMeas(intVal * numMeasIn)
{ numMeas = numMeasIn; }
rmeasSpecFaAxis * rmeasTorus::get_rmeasSpecFaAxis()
{ return a_rmeasSpecFaAxis; }
void rmeasTorus::set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn)
{ a_rmeasSpecFaAxis = rmeasSpecFaAxisIn; }

/********************************************************************/

rmeasSpecFa::rmeasSpecFa(){};

rmeasSpecFa::~rmeasSpecFa(){}

/********************************************************************/

rmeasSpecFaAxis::rmeasSpecFaAxis(){};

rmeasSpecFaAxis::~rmeasSpecFaAxis(){}

/********************************************************************/

rmeasSpecFaAxis_faLabel::rmeasSpecFaAxis_faLabel(){}

rmeasSpecFaAxis_faLabel::rmeasSpecFaAxis_faLabel(
  faLabel * faLabelIn,
  axis * axisIn)
{
  a_faLabel = faLabelIn;
  a_axis = axisIn;
}

rmeasSpecFaAxis_faLabel::~rmeasSpecFaAxis_faLabel(){}

void rmeasSpecFaAxis_faLabel::printSelf()
{
  a_faLabel->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
}

faLabel * rmeasSpecFaAxis_faLabel::get_faLabel()
{ return a_faLabel; }
void rmeasSpecFaAxis_faLabel::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
axis * rmeasSpecFaAxis_faLabel::get_axis()
{ return a_axis; }
void rmeasSpecFaAxis_faLabel::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

rmeasSpecFaAxis_axis::rmeasSpecFaAxis_axis(){}

rmeasSpecFaAxis_axis::rmeasSpecFaAxis_axis(
  axis * axisIn)
{
  a_axis = axisIn;
}

rmeasSpecFaAxis_axis::~rmeasSpecFaAxis_axis(){}

void rmeasSpecFaAxis_axis::printSelf()
{
  a_axis->printSelf();
}

axis * rmeasSpecFaAxis_axis::get_axis()
{ return a_axis; }
void rmeasSpecFaAxis_axis::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

rmeasSpecFaOrient::rmeasSpecFaOrient(){}

rmeasSpecFaOrient::rmeasSpecFaOrient(
  faLabel * faLabelIn,
  bool has_ORIENTIn)
{
  a_faLabel = faLabelIn;
  has_ORIENT = has_ORIENTIn;
}

rmeasSpecFaOrient::~rmeasSpecFaOrient(){}

void rmeasSpecFaOrient::printSelf()
{
  a_faLabel->printSelf();
  if (has_ORIENT == true)
    {
      printf(",");
      printf("ORIENT");
    }
}

faLabel * rmeasSpecFaOrient::get_faLabel()
{ return a_faLabel; }
void rmeasSpecFaOrient::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
bool rmeasSpecFaOrient::get_has_ORIENT()
{ return has_ORIENT; }
void rmeasSpecFaOrient::set_has_ORIENT(bool has_ORIENTIn)
{ has_ORIENT = has_ORIENTIn; }

/********************************************************************/

rmeasSpecFeatAxis::rmeasSpecFeatAxis(){};

rmeasSpecFeatAxis::~rmeasSpecFeatAxis(){}

/********************************************************************/

rmeasSpecFeatAxis_featureLabel1::rmeasSpecFeatAxis_featureLabel1(){}

rmeasSpecFeatAxis_featureLabel1::rmeasSpecFeatAxis_featureLabel1(
  featureLabel1 * featureLabel1In,
  axis * axisIn)
{
  a_featureLabel1 = featureLabel1In;
  a_axis = axisIn;
}

rmeasSpecFeatAxis_featureLabel1::~rmeasSpecFeatAxis_featureLabel1(){}

void rmeasSpecFeatAxis_featureLabel1::printSelf()
{
  a_featureLabel1->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
}

featureLabel1 * rmeasSpecFeatAxis_featureLabel1::get_featureLabel1()
{ return a_featureLabel1; }
void rmeasSpecFeatAxis_featureLabel1::set_featureLabel1(featureLabel1 * featureLabel1In)
{ a_featureLabel1 = featureLabel1In; }
axis * rmeasSpecFeatAxis_featureLabel1::get_axis()
{ return a_axis; }
void rmeasSpecFeatAxis_featureLabel1::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

rmeasSpecFeatAxis_axis::rmeasSpecFeatAxis_axis(){}

rmeasSpecFeatAxis_axis::rmeasSpecFeatAxis_axis(
  axis * axisIn)
{
  a_axis = axisIn;
}

rmeasSpecFeatAxis_axis::~rmeasSpecFeatAxis_axis(){}

void rmeasSpecFeatAxis_axis::printSelf()
{
  a_axis->printSelf();
}

axis * rmeasSpecFeatAxis_axis::get_axis()
{ return a_axis; }
void rmeasSpecFeatAxis_axis::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

rmeasSpecVecbld::rmeasSpecVecbld(){}

rmeasSpecVecbld::rmeasSpecVecbld(
  rentVal * rIn,
  intVal * numPtsIn)
{
  r = rIn;
  numPts = numPtsIn;
}

rmeasSpecVecbld::~rmeasSpecVecbld(){}

void rmeasSpecVecbld::printSelf()
{
  printf("VECBLD");
  printf(",");
  r->printSelf();
  printf(",");
  numPts->printSelf();
}

rentVal * rmeasSpecVecbld::get_r()
{ return r; }
void rmeasSpecVecbld::set_r(rentVal * rIn)
{ r = rIn; }
intVal * rmeasSpecVecbld::get_numPts()
{ return numPts; }
void rmeasSpecVecbld::set_numPts(intVal * numPtsIn)
{ numPts = numPtsIn; }

/********************************************************************/

rmeasSpecVecbldOrient::rmeasSpecVecbldOrient(){}

rmeasSpecVecbldOrient::rmeasSpecVecbldOrient(
  rmeasSpecVecbld * rmeasSpecVecbldIn,
  bool has_ORIENTIn)
{
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
  has_ORIENT = has_ORIENTIn;
}

rmeasSpecVecbldOrient::~rmeasSpecVecbldOrient(){}

void rmeasSpecVecbldOrient::printSelf()
{
  a_rmeasSpecVecbld->printSelf();
  if (has_ORIENT == true)
    {
      printf(",");
      printf("ORIENT");
    }
}

rmeasSpecVecbld * rmeasSpecVecbldOrient::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasSpecVecbldOrient::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }
bool rmeasSpecVecbldOrient::get_has_ORIENT()
{ return has_ORIENT; }
void rmeasSpecVecbldOrient::set_has_ORIENT(bool has_ORIENTIn)
{ has_ORIENT = has_ORIENTIn; }

/********************************************************************/

rmeasSpecVecbldEdgept::rmeasSpecVecbldEdgept(){}

rmeasSpecVecbldEdgept::rmeasSpecVecbldEdgept(
  rmeasSpecVecbld * rmeasSpecVecbldIn,
  rentVal * offsetIn,
  posDir * posDirIn,
  axis * axisIn)
{
  a_rmeasSpecVecbld = rmeasSpecVecbldIn;
  offset = offsetIn;
  a_posDir = posDirIn;
  a_axis = axisIn;
}

rmeasSpecVecbldEdgept::~rmeasSpecVecbldEdgept(){}

void rmeasSpecVecbldEdgept::printSelf()
{
  a_rmeasSpecVecbld->printSelf();
  printf(",");
  offset->printSelf();
  if (a_posDir)
    {
      printf(",");
      a_posDir->printSelf();
    }
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
}

rmeasSpecVecbld * rmeasSpecVecbldEdgept::get_rmeasSpecVecbld()
{ return a_rmeasSpecVecbld; }
void rmeasSpecVecbldEdgept::set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn)
{ a_rmeasSpecVecbld = rmeasSpecVecbldIn; }
rentVal * rmeasSpecVecbldEdgept::get_offset()
{ return offset; }
void rmeasSpecVecbldEdgept::set_offset(rentVal * offsetIn)
{ offset = offsetIn; }
posDir * rmeasSpecVecbldEdgept::get_posDir()
{ return a_posDir; }
void rmeasSpecVecbldEdgept::set_posDir(posDir * posDirIn)
{ a_posDir = posDirIn; }
axis * rmeasSpecVecbldEdgept::get_axis()
{ return a_axis; }
void rmeasSpecVecbldEdgept::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

rotabMinor::rotabMinor(){};

rotabMinor::~rotabMinor(){}

/********************************************************************/

rotabAbs::rotabAbs(){}

rotabAbs::rotabAbs(
  rtLabel * rtLabelIn,
  rotAbs * rotAbsIn,
  rotType * rotTypeIn,
  angle * rotAngleIn,
  angle * maxDevIn)
{
  a_rtLabel = rtLabelIn;
  a_rotAbs = rotAbsIn;
  a_rotType = rotTypeIn;
  rotAngle = rotAngleIn;
  maxDev = maxDevIn;
}

rotabAbs::~rotabAbs(){}

void rotabAbs::printSelf()
{
  a_rtLabel->printSelf();
  printf(",");
  a_rotAbs->printSelf();
  printf(",");
  a_rotType->printSelf();
  printf(",");
  rotAngle->printSelf();
  if (maxDev)
    {
      printf(",");
      printf("FZ");
      printf(",");
      maxDev->printSelf();
    }
}

rtLabel * rotabAbs::get_rtLabel()
{ return a_rtLabel; }
void rotabAbs::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
rotAbs * rotabAbs::get_rotAbs()
{ return a_rotAbs; }
void rotabAbs::set_rotAbs(rotAbs * rotAbsIn)
{ a_rotAbs = rotAbsIn; }
rotType * rotabAbs::get_rotType()
{ return a_rotType; }
void rotabAbs::set_rotType(rotType * rotTypeIn)
{ a_rotType = rotTypeIn; }
angle * rotabAbs::get_rotAngle()
{ return rotAngle; }
void rotabAbs::set_rotAngle(angle * rotAngleIn)
{ rotAngle = rotAngleIn; }
angle * rotabAbs::get_maxDev()
{ return maxDev; }
void rotabAbs::set_maxDev(angle * maxDevIn)
{ maxDev = maxDevIn; }

/********************************************************************/

rotabIncr::rotabIncr(){}

rotabIncr::rotabIncr(
  rtLabel * rtLabelIn,
  rotIncr * rotIncrIn,
  rotType * rotTypeIn,
  angle * rotAngleIn,
  angle * maxDevIn)
{
  a_rtLabel = rtLabelIn;
  a_rotIncr = rotIncrIn;
  a_rotType = rotTypeIn;
  rotAngle = rotAngleIn;
  maxDev = maxDevIn;
}

rotabIncr::~rotabIncr(){}

void rotabIncr::printSelf()
{
  a_rtLabel->printSelf();
  printf(",");
  a_rotIncr->printSelf();
  printf(",");
  a_rotType->printSelf();
  printf(",");
  rotAngle->printSelf();
  if (maxDev)
    {
      printf(",");
      printf("FZ");
      printf(",");
      maxDev->printSelf();
    }
}

rtLabel * rotabIncr::get_rtLabel()
{ return a_rtLabel; }
void rotabIncr::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
rotIncr * rotabIncr::get_rotIncr()
{ return a_rotIncr; }
void rotabIncr::set_rotIncr(rotIncr * rotIncrIn)
{ a_rotIncr = rotIncrIn; }
rotType * rotabIncr::get_rotType()
{ return a_rotType; }
void rotabIncr::set_rotType(rotType * rotTypeIn)
{ a_rotType = rotTypeIn; }
angle * rotabIncr::get_rotAngle()
{ return rotAngle; }
void rotabIncr::set_rotAngle(angle * rotAngleIn)
{ rotAngle = rotAngleIn; }
angle * rotabIncr::get_maxDev()
{ return maxDev; }
void rotabIncr::set_maxDev(angle * maxDevIn)
{ maxDev = maxDevIn; }

/********************************************************************/

rotabFeat::rotabFeat(){}

rotabFeat::rotabFeat(
  rtLabel * rtLabelIn,
  featureLabel * featureLabelIn,
  rotType * rotTypeIn,
  rotDir * rotDirIn)
{
  a_rtLabel = rtLabelIn;
  a_featureLabel = featureLabelIn;
  a_rotType = rotTypeIn;
  a_rotDir = rotDirIn;
}

rotabFeat::~rotabFeat(){}

void rotabFeat::printSelf()
{
  a_rtLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
  printf(",");
  a_rotType->printSelf();
  printf(",");
  a_rotDir->printSelf();
}

rtLabel * rotabFeat::get_rtLabel()
{ return a_rtLabel; }
void rotabFeat::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
featureLabel * rotabFeat::get_featureLabel()
{ return a_featureLabel; }
void rotabFeat::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
rotType * rotabFeat::get_rotType()
{ return a_rotType; }
void rotabFeat::set_rotType(rotType * rotTypeIn)
{ a_rotType = rotTypeIn; }
rotDir * rotabFeat::get_rotDir()
{ return a_rotDir; }
void rotabFeat::set_rotDir(rotDir * rotDirIn)
{ a_rotDir = rotDirIn; }

/********************************************************************/

rotateStm::rotateStm(){}

rotateStm::rotateStm(
  dLabel * dLabelIn,
  rotateMinor * rotateMinorIn)
{
  a_dLabel = dLabelIn;
  a_rotateMinor = rotateMinorIn;
}

rotateStm::~rotateStm(){}

void rotateStm::printSelf()
{
  a_dLabel->printSelf();
  printf("=");
  printf("ROTATE");
  printf("/");
  a_rotateMinor->printSelf();
  printf("%c%c", 13, 10);
}

dLabel * rotateStm::get_dLabel()
{ return a_dLabel; }
void rotateStm::set_dLabel(dLabel * dLabelIn)
{ a_dLabel = dLabelIn; }
rotateMinor * rotateStm::get_rotateMinor()
{ return a_rotateMinor; }
void rotateStm::set_rotateMinor(rotateMinor * rotateMinorIn)
{ a_rotateMinor = rotateMinorIn; }

/********************************************************************/

rotateMinor::rotateMinor(){};

rotateMinor::~rotateMinor(){}

/********************************************************************/

rotateValue::rotateValue(){}

rotateValue::rotateValue(
  axis * axisIn,
  angle * angleIn)
{
  a_axis = axisIn;
  a_angle = angleIn;
}

rotateValue::~rotateValue(){}

void rotateValue::printSelf()
{
  a_axis->printSelf();
  printf(",");
  a_angle->printSelf();
}

axis * rotateValue::get_axis()
{ return a_axis; }
void rotateValue::set_axis(axis * axisIn)
{ a_axis = axisIn; }
angle * rotateValue::get_angle()
{ return a_angle; }
void rotateValue::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

rotateFeature::rotateFeature(){}

rotateFeature::rotateFeature(
  axis * axisIn,
  featureLabel * featureLabelIn,
  dir * dirIn)
{
  a_axis = axisIn;
  a_featureLabel = featureLabelIn;
  a_dir = dirIn;
}

rotateFeature::~rotateFeature(){}

void rotateFeature::printSelf()
{
  a_axis->printSelf();
  printf(",");
  a_featureLabel->printSelf();
  printf(",");
  a_dir->printSelf();
}

axis * rotateFeature::get_axis()
{ return a_axis; }
void rotateFeature::set_axis(axis * axisIn)
{ a_axis = axisIn; }
featureLabel * rotateFeature::get_featureLabel()
{ return a_featureLabel; }
void rotateFeature::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
dir * rotateFeature::get_dir()
{ return a_dir; }
void rotateFeature::set_dir(dir * dirIn)
{ a_dir = dirIn; }

/********************************************************************/

rotateDatum::rotateDatum(){}

rotateDatum::rotateDatum(
  axis * axisIn,
  datLabel * datLabelIn,
  dir * dirIn)
{
  a_axis = axisIn;
  a_datLabel = datLabelIn;
  a_dir = dirIn;
}

rotateDatum::~rotateDatum(){}

void rotateDatum::printSelf()
{
  a_axis->printSelf();
  printf(",");
  a_datLabel->printSelf();
  printf(",");
  a_dir->printSelf();
}

axis * rotateDatum::get_axis()
{ return a_axis; }
void rotateDatum::set_axis(axis * axisIn)
{ a_axis = axisIn; }
datLabel * rotateDatum::get_datLabel()
{ return a_datLabel; }
void rotateDatum::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
dir * rotateDatum::get_dir()
{ return a_dir; }
void rotateDatum::set_dir(dir * dirIn)
{ a_dir = dirIn; }

/********************************************************************/

rotdefStm::rotdefStm(){}

rotdefStm::rotdefStm(
  rtLabel * theTableIn,
  pointVecCart * pointVecCartIn,
  rtLabel * otherTableIn)
{
  theTable = theTableIn;
  a_pointVecCart = pointVecCartIn;
  otherTable = otherTableIn;
}

rotdefStm::~rotdefStm(){}

void rotdefStm::printSelf()
{
  theTable->printSelf();
  printf("=");
  printf("ROTDEF");
  printf("/");
  a_pointVecCart->printSelf();
  if (otherTable)
    {
      printf(",");
      otherTable->printSelf();
    }
  printf("%c%c", 13, 10);
}

rtLabel * rotdefStm::get_theTable()
{ return theTable; }
void rotdefStm::set_theTable(rtLabel * theTableIn)
{ theTable = theTableIn; }
pointVecCart * rotdefStm::get_pointVecCart()
{ return a_pointVecCart; }
void rotdefStm::set_pointVecCart(pointVecCart * pointVecCartIn)
{ a_pointVecCart = pointVecCartIn; }
rtLabel * rotdefStm::get_otherTable()
{ return otherTable; }
void rotdefStm::set_otherTable(rtLabel * otherTableIn)
{ otherTable = otherTableIn; }

/********************************************************************/

saveDatumStm::saveDatumStm(){}

saveDatumStm::saveDatumStm(
  datumLabel1 * datumLabel1In,
  didLabel * didLabelIn)
{
  a_datumLabel1 = datumLabel1In;
  a_didLabel = didLabelIn;
}

saveDatumStm::~saveDatumStm(){}

void saveDatumStm::printSelf()
{
  printf("SAVE");
  printf("/");
  a_datumLabel1->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
  printf("%c%c", 13, 10);
}

datumLabel1 * saveDatumStm::get_datumLabel1()
{ return a_datumLabel1; }
void saveDatumStm::set_datumLabel1(datumLabel1 * datumLabel1In)
{ a_datumLabel1 = datumLabel1In; }
didLabel * saveDatumStm::get_didLabel()
{ return a_didLabel; }
void saveDatumStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

saveFeatureStm::saveFeatureStm(){}

saveFeatureStm::saveFeatureStm(
  faLabel * faLabelIn,
  didLabel * didLabelIn)
{
  a_faLabel = faLabelIn;
  a_didLabel = didLabelIn;
}

saveFeatureStm::~saveFeatureStm(){}

void saveFeatureStm::printSelf()
{
  printf("SAVE");
  printf("/");
  a_faLabel->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
  printf("%c%c", 13, 10);
}

faLabel * saveFeatureStm::get_faLabel()
{ return a_faLabel; }
void saveFeatureStm::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
didLabel * saveFeatureStm::get_didLabel()
{ return a_didLabel; }
void saveFeatureStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

saveRotaryTableStm::saveRotaryTableStm(){}

saveRotaryTableStm::saveRotaryTableStm(
  rtLabel * rtLabelIn,
  didLabel * didLabelIn)
{
  a_rtLabel = rtLabelIn;
  a_didLabel = didLabelIn;
}

saveRotaryTableStm::~saveRotaryTableStm(){}

void saveRotaryTableStm::printSelf()
{
  printf("SAVE");
  printf("/");
  a_rtLabel->printSelf();
  if (a_didLabel)
    {
      printf(",");
      a_didLabel->printSelf();
    }
  printf("%c%c", 13, 10);
}

rtLabel * saveRotaryTableStm::get_rtLabel()
{ return a_rtLabel; }
void saveRotaryTableStm::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }
didLabel * saveRotaryTableStm::get_didLabel()
{ return a_didLabel; }
void saveRotaryTableStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }

/********************************************************************/

saveDMLStm::saveDMLStm(){}

saveDMLStm::saveDMLStm(
  didLabel * didLabelIn,
  daLabel * daLabelIn)
{
  a_didLabel = didLabelIn;
  a_daLabel = daLabelIn;
}

saveDMLStm::~saveDMLStm(){}

void saveDMLStm::printSelf()
{
  printf("SAVE");
  printf("/");
  printf("DML");
  printf(",");
  a_didLabel->printSelf();
  printf(",");
  a_daLabel->printSelf();
  printf("%c%c", 13, 10);
}

didLabel * saveDMLStm::get_didLabel()
{ return a_didLabel; }
void saveDMLStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
daLabel * saveDMLStm::get_daLabel()
{ return a_daLabel; }
void saveDMLStm::set_daLabel(daLabel * daLabelIn)
{ a_daLabel = daLabelIn; }

/********************************************************************/

scnmodStm::scnmodStm(){}

scnmodStm::scnmodStm(
  state * stateIn)
{
  a_state = stateIn;
}

scnmodStm::~scnmodStm(){}

void scnmodStm::printSelf()
{
  printf("SCNMOD");
  printf("/");
  a_state->printSelf();
  printf("%c%c", 13, 10);
}

state * scnmodStm::get_state()
{ return a_state; }
void scnmodStm::set_state(state * stateIn)
{ a_state = stateIn; }

/********************************************************************/

scnsetStm::scnsetStm(){}

scnsetStm::scnsetStm(
  scnsetMinor * scnsetMinorIn)
{
  a_scnsetMinor = scnsetMinorIn;
}

scnsetStm::~scnsetStm(){}

void scnsetStm::printSelf()
{
  printf("SCNSET");
  printf("/");
  a_scnsetMinor->printSelf();
  printf("%c%c", 13, 10);
}

scnsetMinor * scnsetStm::get_scnsetMinor()
{ return a_scnsetMinor; }
void scnsetStm::set_scnsetMinor(scnsetMinor * scnsetMinorIn)
{ a_scnsetMinor = scnsetMinorIn; }

/********************************************************************/

scnsetMinor::scnsetMinor(){};

scnsetMinor::~scnsetMinor(){}

/********************************************************************/

scnsetPeck::scnsetPeck(){}

scnsetPeck::scnsetPeck(
  scnsetSample * scnsetSampleIn)
{
  a_scnsetSample = scnsetSampleIn;
}

scnsetPeck::~scnsetPeck(){}

void scnsetPeck::printSelf()
{
  printf("PECK");
  printf(",");
  a_scnsetSample->printSelf();
}

scnsetSample * scnsetPeck::get_scnsetSample()
{ return a_scnsetSample; }
void scnsetPeck::set_scnsetSample(scnsetSample * scnsetSampleIn)
{ a_scnsetSample = scnsetSampleIn; }

/********************************************************************/

scnsetDrag::scnsetDrag(){}

scnsetDrag::scnsetDrag(
  scnsetSampleDrag * scnsetSampleDragIn)
{
  a_scnsetSampleDrag = scnsetSampleDragIn;
}

scnsetDrag::~scnsetDrag(){}

void scnsetDrag::printSelf()
{
  printf("DRAG");
  printf(",");
  a_scnsetSampleDrag->printSelf();
}

scnsetSampleDrag * scnsetDrag::get_scnsetSampleDrag()
{ return a_scnsetSampleDrag; }
void scnsetDrag::set_scnsetSampleDrag(scnsetSampleDrag * scnsetSampleDragIn)
{ a_scnsetSampleDrag = scnsetSampleDragIn; }

/********************************************************************/

scnsetNoncon::scnsetNoncon(){}

scnsetNoncon::scnsetNoncon(
  scnsetSample * scnsetSampleIn)
{
  a_scnsetSample = scnsetSampleIn;
}

scnsetNoncon::~scnsetNoncon(){}

void scnsetNoncon::printSelf()
{
  printf("NONCON");
  printf(",");
  a_scnsetSample->printSelf();
}

scnsetSample * scnsetNoncon::get_scnsetSample()
{ return a_scnsetSample; }
void scnsetNoncon::set_scnsetSample(scnsetSample * scnsetSampleIn)
{ a_scnsetSample = scnsetSampleIn; }

/********************************************************************/

scnsetStop::scnsetStop(){};

scnsetStop::~scnsetStop(){}

/********************************************************************/

scnsetStopPlane::scnsetStopPlane(){}

scnsetStopPlane::scnsetStopPlane(
  vector * planeVecIn,
  rentVal * radiusIn,
  intVal * countIn)
{
  planeVec = planeVecIn;
  radius = radiusIn;
  count = countIn;
}

scnsetStopPlane::~scnsetStopPlane(){}

void scnsetStopPlane::printSelf()
{
  printf("STOP");
  printf(",");
  printf("PLANE");
  printf(",");
  planeVec->printSelf();
  if (radius)
    {
      printf(",");
      printf("RADIUS");
      printf(",");
      radius->printSelf();
    }
  if (count)
    {
      printf(",");
      printf("COUNT");
      printf(",");
      count->printSelf();
    }
}

vector * scnsetStopPlane::get_planeVec()
{ return planeVec; }
void scnsetStopPlane::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }
rentVal * scnsetStopPlane::get_radius()
{ return radius; }
void scnsetStopPlane::set_radius(rentVal * radiusIn)
{ radius = radiusIn; }
intVal * scnsetStopPlane::get_count()
{ return count; }
void scnsetStopPlane::set_count(intVal * countIn)
{ count = countIn; }

/********************************************************************/

scnsetStopSphere::scnsetStopSphere(){}

scnsetStopSphere::scnsetStopSphere(
  rentVal * radiusIn)
{
  radius = radiusIn;
}

scnsetStopSphere::~scnsetStopSphere(){}

void scnsetStopSphere::printSelf()
{
  printf("STOP");
  printf(",");
  printf("SPHERE");
  printf(",");
  radius->printSelf();
}

rentVal * scnsetStopSphere::get_radius()
{ return radius; }
void scnsetStopSphere::set_radius(rentVal * radiusIn)
{ radius = radiusIn; }

/********************************************************************/

scnsetVendor::scnsetVendor(){};

scnsetVendor::~scnsetVendor(){}

/********************************************************************/

scnsetVendor_FORM::scnsetVendor_FORM(){}

scnsetVendor_FORM::~scnsetVendor_FORM(){}

void scnsetVendor_FORM::printSelf()
{
  printf("VENDOR");
  printf(",");
  printf("FORM");
}

/********************************************************************/

scnsetVendor_POS::scnsetVendor_POS(){}

scnsetVendor_POS::~scnsetVendor_POS(){}

void scnsetVendor_POS::printSelf()
{
  printf("VENDOR");
  printf(",");
  printf("POS");
}

/********************************************************************/

scnsetVendor_SIZE::scnsetVendor_SIZE(){}

scnsetVendor_SIZE::~scnsetVendor_SIZE(){}

void scnsetVendor_SIZE::printSelf()
{
  printf("VENDOR");
  printf(",");
  printf("SIZE");
}

/********************************************************************/

scnsetSample::scnsetSample(){};

scnsetSample::~scnsetSample(){}

/********************************************************************/

scnsetSample_DIST::scnsetSample_DIST(){}

scnsetSample_DIST::scnsetSample_DIST(
  rentVal * distIn,
  axis * axisIn)
{
  dist = distIn;
  a_axis = axisIn;
}

scnsetSample_DIST::~scnsetSample_DIST(){}

void scnsetSample_DIST::printSelf()
{
  printf("DIST");
  printf(",");
  dist->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
}

rentVal * scnsetSample_DIST::get_dist()
{ return dist; }
void scnsetSample_DIST::set_dist(rentVal * distIn)
{ dist = distIn; }
axis * scnsetSample_DIST::get_axis()
{ return a_axis; }
void scnsetSample_DIST::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

scnsetSample_CHORD::scnsetSample_CHORD(){}

scnsetSample_CHORD::scnsetSample_CHORD(
  rentVal * chordIn,
  rentVal * maxdistIn)
{
  chord = chordIn;
  maxdist = maxdistIn;
}

scnsetSample_CHORD::~scnsetSample_CHORD(){}

void scnsetSample_CHORD::printSelf()
{
  printf("CHORD");
  printf(",");
  chord->printSelf();
  if (maxdist)
    {
      printf(",");
      maxdist->printSelf();
    }
}

rentVal * scnsetSample_CHORD::get_chord()
{ return chord; }
void scnsetSample_CHORD::set_chord(rentVal * chordIn)
{ chord = chordIn; }
rentVal * scnsetSample_CHORD::get_maxdist()
{ return maxdist; }
void scnsetSample_CHORD::set_maxdist(rentVal * maxdistIn)
{ maxdist = maxdistIn; }

/********************************************************************/

scnsetSample_TIME::scnsetSample_TIME(){}

scnsetSample_TIME::scnsetSample_TIME(
  rentVal * timeIn)
{
  time = timeIn;
}

scnsetSample_TIME::~scnsetSample_TIME(){}

void scnsetSample_TIME::printSelf()
{
  printf("TIME");
  printf(",");
  time->printSelf();
}

rentVal * scnsetSample_TIME::get_time()
{ return time; }
void scnsetSample_TIME::set_time(rentVal * timeIn)
{ time = timeIn; }

/********************************************************************/

scnsetSample_ANGLE::scnsetSample_ANGLE(){}

scnsetSample_ANGLE::scnsetSample_ANGLE(
  angle * angleIn)
{
  a_angle = angleIn;
}

scnsetSample_ANGLE::~scnsetSample_ANGLE(){}

void scnsetSample_ANGLE::printSelf()
{
  printf("ANGLE");
  printf(",");
  a_angle->printSelf();
}

angle * scnsetSample_ANGLE::get_angle()
{ return a_angle; }
void scnsetSample_ANGLE::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

scnsetSample_DEFALT::scnsetSample_DEFALT(){}

scnsetSample_DEFALT::~scnsetSample_DEFALT(){}

void scnsetSample_DEFALT::printSelf()
{
  printf("DEFALT");
}

/********************************************************************/

scnsetSampleDrag::scnsetSampleDrag(){};

scnsetSampleDrag::~scnsetSampleDrag(){}

/********************************************************************/

scnsetSampleDrag_DIST::scnsetSampleDrag_DIST(){}

scnsetSampleDrag_DIST::scnsetSampleDrag_DIST(
  rentVal * distIn,
  axis * axisIn,
  forceOrDeflection * forceOrDeflectionIn)
{
  dist = distIn;
  a_axis = axisIn;
  a_forceOrDeflection = forceOrDeflectionIn;
}

scnsetSampleDrag_DIST::~scnsetSampleDrag_DIST(){}

void scnsetSampleDrag_DIST::printSelf()
{
  printf("DIST");
  printf(",");
  dist->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
  if (a_forceOrDeflection)
    {
      printf(",");
      a_forceOrDeflection->printSelf();
    }
}

rentVal * scnsetSampleDrag_DIST::get_dist()
{ return dist; }
void scnsetSampleDrag_DIST::set_dist(rentVal * distIn)
{ dist = distIn; }
axis * scnsetSampleDrag_DIST::get_axis()
{ return a_axis; }
void scnsetSampleDrag_DIST::set_axis(axis * axisIn)
{ a_axis = axisIn; }
forceOrDeflection * scnsetSampleDrag_DIST::get_forceOrDeflection()
{ return a_forceOrDeflection; }
void scnsetSampleDrag_DIST::set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn)
{ a_forceOrDeflection = forceOrDeflectionIn; }

/********************************************************************/

scnsetSampleDrag_CHORD::scnsetSampleDrag_CHORD(){}

scnsetSampleDrag_CHORD::scnsetSampleDrag_CHORD(
  rentVal * chordIn,
  rentVal * maxdistIn,
  forceOrDeflection * forceOrDeflectionIn)
{
  chord = chordIn;
  maxdist = maxdistIn;
  a_forceOrDeflection = forceOrDeflectionIn;
}

scnsetSampleDrag_CHORD::~scnsetSampleDrag_CHORD(){}

void scnsetSampleDrag_CHORD::printSelf()
{
  printf("CHORD");
  printf(",");
  chord->printSelf();
  if (maxdist)
    {
      printf(",");
      maxdist->printSelf();
    }
  if (a_forceOrDeflection)
    {
      printf(",");
      a_forceOrDeflection->printSelf();
    }
}

rentVal * scnsetSampleDrag_CHORD::get_chord()
{ return chord; }
void scnsetSampleDrag_CHORD::set_chord(rentVal * chordIn)
{ chord = chordIn; }
rentVal * scnsetSampleDrag_CHORD::get_maxdist()
{ return maxdist; }
void scnsetSampleDrag_CHORD::set_maxdist(rentVal * maxdistIn)
{ maxdist = maxdistIn; }
forceOrDeflection * scnsetSampleDrag_CHORD::get_forceOrDeflection()
{ return a_forceOrDeflection; }
void scnsetSampleDrag_CHORD::set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn)
{ a_forceOrDeflection = forceOrDeflectionIn; }

/********************************************************************/

scnsetSampleDrag_TIME::scnsetSampleDrag_TIME(){}

scnsetSampleDrag_TIME::scnsetSampleDrag_TIME(
  rentVal * timeIn,
  forceOrDeflection * forceOrDeflectionIn)
{
  time = timeIn;
  a_forceOrDeflection = forceOrDeflectionIn;
}

scnsetSampleDrag_TIME::~scnsetSampleDrag_TIME(){}

void scnsetSampleDrag_TIME::printSelf()
{
  printf("TIME");
  printf(",");
  time->printSelf();
  if (a_forceOrDeflection)
    {
      printf(",");
      a_forceOrDeflection->printSelf();
    }
}

rentVal * scnsetSampleDrag_TIME::get_time()
{ return time; }
void scnsetSampleDrag_TIME::set_time(rentVal * timeIn)
{ time = timeIn; }
forceOrDeflection * scnsetSampleDrag_TIME::get_forceOrDeflection()
{ return a_forceOrDeflection; }
void scnsetSampleDrag_TIME::set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn)
{ a_forceOrDeflection = forceOrDeflectionIn; }

/********************************************************************/

scnsetSampleDrag_ANGLE::scnsetSampleDrag_ANGLE(){}

scnsetSampleDrag_ANGLE::scnsetSampleDrag_ANGLE(
  angle * angleIn,
  forceOrDeflection * forceOrDeflectionIn)
{
  a_angle = angleIn;
  a_forceOrDeflection = forceOrDeflectionIn;
}

scnsetSampleDrag_ANGLE::~scnsetSampleDrag_ANGLE(){}

void scnsetSampleDrag_ANGLE::printSelf()
{
  printf("ANGLE");
  printf(",");
  a_angle->printSelf();
  if (a_forceOrDeflection)
    {
      printf(",");
      a_forceOrDeflection->printSelf();
    }
}

angle * scnsetSampleDrag_ANGLE::get_angle()
{ return a_angle; }
void scnsetSampleDrag_ANGLE::set_angle(angle * angleIn)
{ a_angle = angleIn; }
forceOrDeflection * scnsetSampleDrag_ANGLE::get_forceOrDeflection()
{ return a_forceOrDeflection; }
void scnsetSampleDrag_ANGLE::set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn)
{ a_forceOrDeflection = forceOrDeflectionIn; }

/********************************************************************/

scnsetSampleDrag_DEFALT::scnsetSampleDrag_DEFALT(){}

scnsetSampleDrag_DEFALT::scnsetSampleDrag_DEFALT(
  forceOrDeflection * forceOrDeflectionIn)
{
  a_forceOrDeflection = forceOrDeflectionIn;
}

scnsetSampleDrag_DEFALT::~scnsetSampleDrag_DEFALT(){}

void scnsetSampleDrag_DEFALT::printSelf()
{
  printf("DEFALT");
  if (a_forceOrDeflection)
    {
      printf(",");
      a_forceOrDeflection->printSelf();
    }
}

forceOrDeflection * scnsetSampleDrag_DEFALT::get_forceOrDeflection()
{ return a_forceOrDeflection; }
void scnsetSampleDrag_DEFALT::set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn)
{ a_forceOrDeflection = forceOrDeflectionIn; }

/********************************************************************/

forceOrDeflection::forceOrDeflection(){};

forceOrDeflection::~forceOrDeflection(){}

/********************************************************************/

forceOrDeflection_FORCE::forceOrDeflection_FORCE(){}

forceOrDeflection_FORCE::forceOrDeflection_FORCE(
  rentVal * forceIn)
{
  force = forceIn;
}

forceOrDeflection_FORCE::~forceOrDeflection_FORCE(){}

void forceOrDeflection_FORCE::printSelf()
{
  printf("FORCE");
  printf(",");
  force->printSelf();
}

rentVal * forceOrDeflection_FORCE::get_force()
{ return force; }
void forceOrDeflection_FORCE::set_force(rentVal * forceIn)
{ force = forceIn; }

/********************************************************************/

forceOrDeflection_DEFLECTION::forceOrDeflection_DEFLECTION(){}

forceOrDeflection_DEFLECTION::forceOrDeflection_DEFLECTION(
  rentVal * deflvalIn)
{
  deflval = deflvalIn;
}

forceOrDeflection_DEFLECTION::~forceOrDeflection_DEFLECTION(){}

void forceOrDeflection_DEFLECTION::printSelf()
{
  printf("DEFLECTION");
  printf(",");
  deflval->printSelf();
}

rentVal * forceOrDeflection_DEFLECTION::get_deflval()
{ return deflval; }
void forceOrDeflection_DEFLECTION::set_deflval(rentVal * deflvalIn)
{ deflval = deflvalIn; }

/********************************************************************/

selectStm::selectStm(){};

selectStm::~selectStm(){}

/********************************************************************/

selectStmInt::selectStmInt(){}

selectStmInt::selectStmInt(
  intVal * argIn)
{
  arg = argIn;
}

selectStmInt::~selectStmInt(){}

void selectStmInt::printSelf()
{
  printf("SELECT");
  printf("/");
  arg->printSelf();
  printf("%c%c", 13, 10);
}

intVal * selectStmInt::get_arg()
{ return arg; }
void selectStmInt::set_arg(intVal * argIn)
{ arg = argIn; }

/********************************************************************/

selectStmString::selectStmString(){}

selectStmString::selectStmString(
  stringVal * argIn)
{
  arg = argIn;
}

selectStmString::~selectStmString(){}

void selectStmString::printSelf()
{
  printf("SELECT");
  printf("/");
  arg->printSelf();
  printf("%c%c", 13, 10);
}

stringVal * selectStmString::get_arg()
{ return arg; }
void selectStmString::set_arg(stringVal * argIn)
{ arg = argIn; }

/********************************************************************/

sensorStm::sensorStm(){}

sensorStm::sensorStm(
  ssLabel * ssLabelIn,
  sensorMinor * sensorMinorIn)
{
  a_ssLabel = ssLabelIn;
  a_sensorMinor = sensorMinorIn;
}

sensorStm::~sensorStm(){}

void sensorStm::printSelf()
{
  a_ssLabel->printSelf();
  printf("=");
  printf("SENSOR");
  printf("/");
  a_sensorMinor->printSelf();
  printf("%c%c", 13, 10);
}

ssLabel * sensorStm::get_ssLabel()
{ return a_ssLabel; }
void sensorStm::set_ssLabel(ssLabel * ssLabelIn)
{ a_ssLabel = ssLabelIn; }
sensorMinor * sensorStm::get_sensorMinor()
{ return a_sensorMinor; }
void sensorStm::set_sensorMinor(sensorMinor * sensorMinorIn)
{ a_sensorMinor = sensorMinorIn; }

/********************************************************************/

sensorMinor::sensorMinor(){};

sensorMinor::~sensorMinor(){}

/********************************************************************/

sensorProbe::sensorProbe(){}

sensorProbe::sensorProbe(
  sensorProbeGeometry * sensorProbeGeometryIn,
  sensorProbeForm * sensorProbeFormIn,
  sensorItem * sensorItemIn)
{
  a_sensorProbeGeometry = sensorProbeGeometryIn;
  a_sensorProbeForm = sensorProbeFormIn;
  a_sensorItem = sensorItemIn;
}

sensorProbe::~sensorProbe(){}

void sensorProbe::printSelf()
{
  printf("PROBE");
  printf(",");
  a_sensorProbeGeometry->printSelf();
  if (a_sensorProbeForm)
    {
      printf(",");
      a_sensorProbeForm->printSelf();
    }
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorProbeGeometry * sensorProbe::get_sensorProbeGeometry()
{ return a_sensorProbeGeometry; }
void sensorProbe::set_sensorProbeGeometry(sensorProbeGeometry * sensorProbeGeometryIn)
{ a_sensorProbeGeometry = sensorProbeGeometryIn; }
sensorProbeForm * sensorProbe::get_sensorProbeForm()
{ return a_sensorProbeForm; }
void sensorProbe::set_sensorProbeForm(sensorProbeForm * sensorProbeFormIn)
{ a_sensorProbeForm = sensorProbeFormIn; }
sensorItem * sensorProbe::get_sensorItem()
{ return a_sensorItem; }
void sensorProbe::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorMltprb::sensorMltprb(){}

sensorMltprb::sensorMltprb(
  intVal * numStyliIn,
  std::list<sensorMltprbItem *> * sensorMltprbItemListIn,
  sensorItem * sensorItemIn)
{
  numStyli = numStyliIn;
  a_sensorMltprbItemList = sensorMltprbItemListIn;
  a_sensorItem = sensorItemIn;
}

sensorMltprb::~sensorMltprb(){}

void sensorMltprb::printSelf()
{
  printf("MLTPRB");
  printf(",");
  numStyli->printSelf();
  printf(",");
  if (a_sensorMltprbItemList->begin() == a_sensorMltprbItemList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<sensorMltprbItem *>::iterator iter;
      for (iter = a_sensorMltprbItemList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_sensorMltprbItemList->end())
            break;
          printf(",");
        }
    }
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

intVal * sensorMltprb::get_numStyli()
{ return numStyli; }
void sensorMltprb::set_numStyli(intVal * numStyliIn)
{ numStyli = numStyliIn; }
std::list<sensorMltprbItem *> * sensorMltprb::get_sensorMltprbItemList()
{ return a_sensorMltprbItemList; }
void sensorMltprb::set_sensorMltprbItemList(std::list<sensorMltprbItem *> * sensorMltprbItemListIn)
{ a_sensorMltprbItemList = sensorMltprbItemListIn; }
sensorItem * sensorMltprb::get_sensorItem()
{ return a_sensorItem; }
void sensorMltprb::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorVideo::sensorVideo(){}

sensorVideo::sensorVideo(
  sensorGeometry * sensorGeometryIn,
  rentVal * focalIn,
  rentVal * magIn,
  rentVal * apertIn,
  sensorItem * sensorItemIn)
{
  a_sensorGeometry = sensorGeometryIn;
  focal = focalIn;
  mag = magIn;
  apert = apertIn;
  a_sensorItem = sensorItemIn;
}

sensorVideo::~sensorVideo(){}

void sensorVideo::printSelf()
{
  printf("VIDEO");
  printf(",");
  a_sensorGeometry->printSelf();
  printf(",");
  focal->printSelf();
  printf(",");
  mag->printSelf();
  printf(",");
  apert->printSelf();
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorGeometry * sensorVideo::get_sensorGeometry()
{ return a_sensorGeometry; }
void sensorVideo::set_sensorGeometry(sensorGeometry * sensorGeometryIn)
{ a_sensorGeometry = sensorGeometryIn; }
rentVal * sensorVideo::get_focal()
{ return focal; }
void sensorVideo::set_focal(rentVal * focalIn)
{ focal = focalIn; }
rentVal * sensorVideo::get_mag()
{ return mag; }
void sensorVideo::set_mag(rentVal * magIn)
{ mag = magIn; }
rentVal * sensorVideo::get_apert()
{ return apert; }
void sensorVideo::set_apert(rentVal * apertIn)
{ apert = apertIn; }
sensorItem * sensorVideo::get_sensorItem()
{ return a_sensorItem; }
void sensorVideo::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorLaser::sensorLaser(){}

sensorLaser::sensorLaser(
  sensorGeometry * sensorGeometryIn,
  rentVal * powerIn,
  rentVal * shuterIn,
  sensorItem * sensorItemIn)
{
  a_sensorGeometry = sensorGeometryIn;
  power = powerIn;
  shuter = shuterIn;
  a_sensorItem = sensorItemIn;
}

sensorLaser::~sensorLaser(){}

void sensorLaser::printSelf()
{
  printf("LASER");
  printf(",");
  a_sensorGeometry->printSelf();
  printf(",");
  power->printSelf();
  printf(",");
  shuter->printSelf();
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorGeometry * sensorLaser::get_sensorGeometry()
{ return a_sensorGeometry; }
void sensorLaser::set_sensorGeometry(sensorGeometry * sensorGeometryIn)
{ a_sensorGeometry = sensorGeometryIn; }
rentVal * sensorLaser::get_power()
{ return power; }
void sensorLaser::set_power(rentVal * powerIn)
{ power = powerIn; }
rentVal * sensorLaser::get_shuter()
{ return shuter; }
void sensorLaser::set_shuter(rentVal * shuterIn)
{ shuter = shuterIn; }
sensorItem * sensorLaser::get_sensorItem()
{ return a_sensorItem; }
void sensorLaser::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorInfred::sensorInfred(){}

sensorInfred::sensorInfred(
  sensorGeometry * sensorGeometryIn,
  rentVal * fovxIn,
  rentVal * fovyIn,
  rentVal * freqIn,
  rentVal * dwellIn,
  sensorItem * sensorItemIn)
{
  a_sensorGeometry = sensorGeometryIn;
  fovx = fovxIn;
  fovy = fovyIn;
  freq = freqIn;
  dwell = dwellIn;
  a_sensorItem = sensorItemIn;
}

sensorInfred::~sensorInfred(){}

void sensorInfred::printSelf()
{
  printf("INFRED");
  printf(",");
  a_sensorGeometry->printSelf();
  printf(",");
  fovx->printSelf();
  printf(",");
  fovy->printSelf();
  printf(",");
  freq->printSelf();
  printf(",");
  dwell->printSelf();
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorGeometry * sensorInfred::get_sensorGeometry()
{ return a_sensorGeometry; }
void sensorInfred::set_sensorGeometry(sensorGeometry * sensorGeometryIn)
{ a_sensorGeometry = sensorGeometryIn; }
rentVal * sensorInfred::get_fovx()
{ return fovx; }
void sensorInfred::set_fovx(rentVal * fovxIn)
{ fovx = fovxIn; }
rentVal * sensorInfred::get_fovy()
{ return fovy; }
void sensorInfred::set_fovy(rentVal * fovyIn)
{ fovy = fovyIn; }
rentVal * sensorInfred::get_freq()
{ return freq; }
void sensorInfred::set_freq(rentVal * freqIn)
{ freq = freqIn; }
rentVal * sensorInfred::get_dwell()
{ return dwell; }
void sensorInfred::set_dwell(rentVal * dwellIn)
{ dwell = dwellIn; }
sensorItem * sensorInfred::get_sensorItem()
{ return a_sensorItem; }
void sensorInfred::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorNoncon::sensorNoncon(){}

sensorNoncon::sensorNoncon(
  sensorGeometry * sensorGeometryIn,
  intVal * numProbesIn,
  sensorItem * sensorItemIn)
{
  a_sensorGeometry = sensorGeometryIn;
  numProbes = numProbesIn;
  a_sensorItem = sensorItemIn;
}

sensorNoncon::~sensorNoncon(){}

void sensorNoncon::printSelf()
{
  printf("NONCON");
  printf(",");
  a_sensorGeometry->printSelf();
  printf(",");
  numProbes->printSelf();
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorGeometry * sensorNoncon::get_sensorGeometry()
{ return a_sensorGeometry; }
void sensorNoncon::set_sensorGeometry(sensorGeometry * sensorGeometryIn)
{ a_sensorGeometry = sensorGeometryIn; }
intVal * sensorNoncon::get_numProbes()
{ return numProbes; }
void sensorNoncon::set_numProbes(intVal * numProbesIn)
{ numProbes = numProbesIn; }
sensorItem * sensorNoncon::get_sensorItem()
{ return a_sensorItem; }
void sensorNoncon::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorPoint::sensorPoint(){}

sensorPoint::sensorPoint(
  sensorGeometry * sensorGeometryIn,
  rentVal * fovnIn,
  sensorItem * sensorItemIn)
{
  a_sensorGeometry = sensorGeometryIn;
  fovn = fovnIn;
  a_sensorItem = sensorItemIn;
}

sensorPoint::~sensorPoint(){}

void sensorPoint::printSelf()
{
  printf("POINT");
  printf(",");
  a_sensorGeometry->printSelf();
  printf(",");
  fovn->printSelf();
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorGeometry * sensorPoint::get_sensorGeometry()
{ return a_sensorGeometry; }
void sensorPoint::set_sensorGeometry(sensorGeometry * sensorGeometryIn)
{ a_sensorGeometry = sensorGeometryIn; }
rentVal * sensorPoint::get_fovn()
{ return fovn; }
void sensorPoint::set_fovn(rentVal * fovnIn)
{ fovn = fovnIn; }
sensorItem * sensorPoint::get_sensorItem()
{ return a_sensorItem; }
void sensorPoint::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorLine::sensorLine(){}

sensorLine::sensorLine(
  sensorGeometry * sensorGeometryIn,
  rentVal * fovnIn,
  rentVal * fovcIn,
  sensorItem * sensorItemIn)
{
  a_sensorGeometry = sensorGeometryIn;
  fovn = fovnIn;
  fovc = fovcIn;
  a_sensorItem = sensorItemIn;
}

sensorLine::~sensorLine(){}

void sensorLine::printSelf()
{
  printf("LINE");
  printf(",");
  a_sensorGeometry->printSelf();
  printf(",");
  fovn->printSelf();
  printf(",");
  fovc->printSelf();
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorGeometry * sensorLine::get_sensorGeometry()
{ return a_sensorGeometry; }
void sensorLine::set_sensorGeometry(sensorGeometry * sensorGeometryIn)
{ a_sensorGeometry = sensorGeometryIn; }
rentVal * sensorLine::get_fovn()
{ return fovn; }
void sensorLine::set_fovn(rentVal * fovnIn)
{ fovn = fovnIn; }
rentVal * sensorLine::get_fovc()
{ return fovc; }
void sensorLine::set_fovc(rentVal * fovcIn)
{ fovc = fovcIn; }
sensorItem * sensorLine::get_sensorItem()
{ return a_sensorItem; }
void sensorLine::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorArea::sensorArea(){}

sensorArea::sensorArea(
  sensorGeometry * sensorGeometryIn,
  rentVal * fovcIn,
  rentVal * fovoIn,
  rentVal * fovnIn,
  sensorItem * sensorItemIn)
{
  a_sensorGeometry = sensorGeometryIn;
  fovc = fovcIn;
  fovo = fovoIn;
  fovn = fovnIn;
  a_sensorItem = sensorItemIn;
}

sensorArea::~sensorArea(){}

void sensorArea::printSelf()
{
  printf("AREA");
  printf(",");
  a_sensorGeometry->printSelf();
  printf(",");
  fovc->printSelf();
  printf(",");
  fovo->printSelf();
  printf(",");
  fovn->printSelf();
  if (a_sensorItem)
    {
      printf(",");
      a_sensorItem->printSelf();
    }
}

sensorGeometry * sensorArea::get_sensorGeometry()
{ return a_sensorGeometry; }
void sensorArea::set_sensorGeometry(sensorGeometry * sensorGeometryIn)
{ a_sensorGeometry = sensorGeometryIn; }
rentVal * sensorArea::get_fovc()
{ return fovc; }
void sensorArea::set_fovc(rentVal * fovcIn)
{ fovc = fovcIn; }
rentVal * sensorArea::get_fovo()
{ return fovo; }
void sensorArea::set_fovo(rentVal * fovoIn)
{ fovo = fovoIn; }
rentVal * sensorArea::get_fovn()
{ return fovn; }
void sensorArea::set_fovn(rentVal * fovnIn)
{ fovn = fovnIn; }
sensorItem * sensorArea::get_sensorItem()
{ return a_sensorItem; }
void sensorArea::set_sensorItem(sensorItem * sensorItemIn)
{ a_sensorItem = sensorItemIn; }

/********************************************************************/

sensorProbeGeometry::sensorProbeGeometry(){}

sensorProbeGeometry::sensorProbeGeometry(
  vector * offsetIn,
  vector * normalIn,
  rentVal * diamIn)
{
  offset = offsetIn;
  normal = normalIn;
  diam = diamIn;
}

sensorProbeGeometry::~sensorProbeGeometry(){}

void sensorProbeGeometry::printSelf()
{
  offset->printSelf();
  printf(",");
  normal->printSelf();
  printf(",");
  diam->printSelf();
}

vector * sensorProbeGeometry::get_offset()
{ return offset; }
void sensorProbeGeometry::set_offset(vector * offsetIn)
{ offset = offsetIn; }
vector * sensorProbeGeometry::get_normal()
{ return normal; }
void sensorProbeGeometry::set_normal(vector * normalIn)
{ normal = normalIn; }
rentVal * sensorProbeGeometry::get_diam()
{ return diam; }
void sensorProbeGeometry::set_diam(rentVal * diamIn)
{ diam = diamIn; }

/********************************************************************/

sensorProbeForm::sensorProbeForm(){};

sensorProbeForm::~sensorProbeForm(){}

/********************************************************************/

sensorProbeForm_SPHERE::sensorProbeForm_SPHERE(){}

sensorProbeForm_SPHERE::~sensorProbeForm_SPHERE(){}

void sensorProbeForm_SPHERE::printSelf()
{
  printf("SPHERE");
}

/********************************************************************/

sensorProbeForm_CYLNDR::sensorProbeForm_CYLNDR(){}

sensorProbeForm_CYLNDR::sensorProbeForm_CYLNDR(
  rentVal * len1In)
{
  len1 = len1In;
}

sensorProbeForm_CYLNDR::~sensorProbeForm_CYLNDR(){}

void sensorProbeForm_CYLNDR::printSelf()
{
  printf("CYLNDR");
  printf(",");
  len1->printSelf();
}

rentVal * sensorProbeForm_CYLNDR::get_len1()
{ return len1; }
void sensorProbeForm_CYLNDR::set_len1(rentVal * len1In)
{ len1 = len1In; }

/********************************************************************/

sensorProbeForm_DISK::sensorProbeForm_DISK(){}

sensorProbeForm_DISK::sensorProbeForm_DISK(
  rentVal * thknIn)
{
  thkn = thknIn;
}

sensorProbeForm_DISK::~sensorProbeForm_DISK(){}

void sensorProbeForm_DISK::printSelf()
{
  printf("DISK");
  printf(",");
  thkn->printSelf();
}

rentVal * sensorProbeForm_DISK::get_thkn()
{ return thkn; }
void sensorProbeForm_DISK::set_thkn(rentVal * thknIn)
{ thkn = thknIn; }

/********************************************************************/

sensorItem::sensorItem(){};

sensorItem::~sensorItem(){}

/********************************************************************/

sensorItem_stringVal::sensorItem_stringVal(){}

sensorItem_stringVal::sensorItem_stringVal(
  stringVal * dataStorIn,
  stringVal * dataListIn,
  stringVal * dataItemIn)
{
  dataStor = dataStorIn;
  dataList = dataListIn;
  dataItem = dataItemIn;
}

sensorItem_stringVal::~sensorItem_stringVal(){}

void sensorItem_stringVal::printSelf()
{
  dataStor->printSelf();
  printf(",");
  dataList->printSelf();
  printf(",");
  dataItem->printSelf();
}

stringVal * sensorItem_stringVal::get_dataStor()
{ return dataStor; }
void sensorItem_stringVal::set_dataStor(stringVal * dataStorIn)
{ dataStor = dataStorIn; }
stringVal * sensorItem_stringVal::get_dataList()
{ return dataList; }
void sensorItem_stringVal::set_dataList(stringVal * dataListIn)
{ dataList = dataListIn; }
stringVal * sensorItem_stringVal::get_dataItem()
{ return dataItem; }
void sensorItem_stringVal::set_dataItem(stringVal * dataItemIn)
{ dataItem = dataItemIn; }

/********************************************************************/

sensorItem_intVal::sensorItem_intVal(){}

sensorItem_intVal::sensorItem_intVal(
  stringVal * dataStorIn,
  stringVal * dataListIn,
  intVal * indexIn)
{
  dataStor = dataStorIn;
  dataList = dataListIn;
  index = indexIn;
}

sensorItem_intVal::~sensorItem_intVal(){}

void sensorItem_intVal::printSelf()
{
  dataStor->printSelf();
  printf(",");
  dataList->printSelf();
  printf(",");
  index->printSelf();
}

stringVal * sensorItem_intVal::get_dataStor()
{ return dataStor; }
void sensorItem_intVal::set_dataStor(stringVal * dataStorIn)
{ dataStor = dataStorIn; }
stringVal * sensorItem_intVal::get_dataList()
{ return dataList; }
void sensorItem_intVal::set_dataList(stringVal * dataListIn)
{ dataList = dataListIn; }
intVal * sensorItem_intVal::get_index()
{ return index; }
void sensorItem_intVal::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

sensorMltprbItem::sensorMltprbItem(){};

sensorMltprbItem::~sensorMltprbItem(){}

/********************************************************************/

sensorMltprbItem_stringVal::sensorMltprbItem_stringVal(){}

sensorMltprbItem_stringVal::sensorMltprbItem_stringVal(
  stringVal * descIn,
  sensorProbeGeometry * sensorProbeGeometryIn)
{
  desc = descIn;
  a_sensorProbeGeometry = sensorProbeGeometryIn;
}

sensorMltprbItem_stringVal::~sensorMltprbItem_stringVal(){}

void sensorMltprbItem_stringVal::printSelf()
{
  desc->printSelf();
  printf(",");
  a_sensorProbeGeometry->printSelf();
}

stringVal * sensorMltprbItem_stringVal::get_desc()
{ return desc; }
void sensorMltprbItem_stringVal::set_desc(stringVal * descIn)
{ desc = descIn; }
sensorProbeGeometry * sensorMltprbItem_stringVal::get_sensorProbeGeometry()
{ return a_sensorProbeGeometry; }
void sensorMltprbItem_stringVal::set_sensorProbeGeometry(sensorProbeGeometry * sensorProbeGeometryIn)
{ a_sensorProbeGeometry = sensorProbeGeometryIn; }

/********************************************************************/

sensorMltprbItem_intVal::sensorMltprbItem_intVal(){}

sensorMltprbItem_intVal::sensorMltprbItem_intVal(
  intVal * tipnumIn,
  sensorProbeGeometry * sensorProbeGeometryIn)
{
  tipnum = tipnumIn;
  a_sensorProbeGeometry = sensorProbeGeometryIn;
}

sensorMltprbItem_intVal::~sensorMltprbItem_intVal(){}

void sensorMltprbItem_intVal::printSelf()
{
  tipnum->printSelf();
  printf(",");
  a_sensorProbeGeometry->printSelf();
}

intVal * sensorMltprbItem_intVal::get_tipnum()
{ return tipnum; }
void sensorMltprbItem_intVal::set_tipnum(intVal * tipnumIn)
{ tipnum = tipnumIn; }
sensorProbeGeometry * sensorMltprbItem_intVal::get_sensorProbeGeometry()
{ return a_sensorProbeGeometry; }
void sensorMltprbItem_intVal::set_sensorProbeGeometry(sensorProbeGeometry * sensorProbeGeometryIn)
{ a_sensorProbeGeometry = sensorProbeGeometryIn; }

/********************************************************************/

sensorGeometry::sensorGeometry(){}

sensorGeometry::sensorGeometry(
  vector * offsetIn,
  vector * normalIn,
  vector * clockIn)
{
  offset = offsetIn;
  normal = normalIn;
  clock = clockIn;
}

sensorGeometry::~sensorGeometry(){}

void sensorGeometry::printSelf()
{
  offset->printSelf();
  printf(",");
  normal->printSelf();
  printf(",");
  clock->printSelf();
}

vector * sensorGeometry::get_offset()
{ return offset; }
void sensorGeometry::set_offset(vector * offsetIn)
{ offset = offsetIn; }
vector * sensorGeometry::get_normal()
{ return normal; }
void sensorGeometry::set_normal(vector * normalIn)
{ normal = normalIn; }
vector * sensorGeometry::get_clock()
{ return clock; }
void sensorGeometry::set_clock(vector * clockIn)
{ clock = clockIn; }

/********************************************************************/

simreqtStm::simreqtStm(){}

simreqtStm::simreqtStm(
  srLabel * srLabelIn,
  simreqtMinor * simreqtMinorIn)
{
  a_srLabel = srLabelIn;
  a_simreqtMinor = simreqtMinorIn;
}

simreqtStm::~simreqtStm(){}

void simreqtStm::printSelf()
{
  a_srLabel->printSelf();
  printf("=");
  printf("SIMREQT");
  printf("/");
  a_simreqtMinor->printSelf();
  printf("%c%c", 13, 10);
}

srLabel * simreqtStm::get_srLabel()
{ return a_srLabel; }
void simreqtStm::set_srLabel(srLabel * srLabelIn)
{ a_srLabel = srLabelIn; }
simreqtMinor * simreqtStm::get_simreqtMinor()
{ return a_simreqtMinor; }
void simreqtStm::set_simreqtMinor(simreqtMinor * simreqtMinorIn)
{ a_simreqtMinor = simreqtMinorIn; }

/********************************************************************/

simreqtMinor::simreqtMinor(){};

simreqtMinor::~simreqtMinor(){}

/********************************************************************/

simreqtMinor_FIRST::simreqtMinor_FIRST(){}

simreqtMinor_FIRST::~simreqtMinor_FIRST(){}

void simreqtMinor_FIRST::printSelf()
{
  printf("FIRST");
}

/********************************************************************/

simreqtMinor_OPTIMAL::simreqtMinor_OPTIMAL(){}

simreqtMinor_OPTIMAL::~simreqtMinor_OPTIMAL(){}

void simreqtMinor_OPTIMAL::printSelf()
{
  printf("OPTIMAL");
}

/********************************************************************/

snsdefStm::snsdefStm(){}

snsdefStm::snsdefStm(
  sLabel * sLabelIn,
  snsdefMinor * snsdefMinorIn)
{
  a_sLabel = sLabelIn;
  a_snsdefMinor = snsdefMinorIn;
}

snsdefStm::~snsdefStm(){}

void snsdefStm::printSelf()
{
  a_sLabel->printSelf();
  printf("=");
  printf("SNSDEF");
  printf("/");
  a_snsdefMinor->printSelf();
  printf("%c%c", 13, 10);
}

sLabel * snsdefStm::get_sLabel()
{ return a_sLabel; }
void snsdefStm::set_sLabel(sLabel * sLabelIn)
{ a_sLabel = sLabelIn; }
snsdefMinor * snsdefStm::get_snsdefMinor()
{ return a_snsdefMinor; }
void snsdefStm::set_snsdefMinor(snsdefMinor * snsdefMinorIn)
{ a_snsdefMinor = snsdefMinorIn; }

/********************************************************************/

snsdefMinor::snsdefMinor(){};

snsdefMinor::~snsdefMinor(){}

/********************************************************************/

snsdefProbe::snsdefProbe(){}

snsdefProbe::snsdefProbe(
  snsdefType * snsdefTypeIn,
  probeLocation * probeLocationIn,
  rentVal * diamIn,
  snsdefProbeForm * snsdefProbeFormIn)
{
  a_snsdefType = snsdefTypeIn;
  a_probeLocation = probeLocationIn;
  diam = diamIn;
  a_snsdefProbeForm = snsdefProbeFormIn;
}

snsdefProbe::~snsdefProbe(){}

void snsdefProbe::printSelf()
{
  printf("PROBE");
  printf(",");
  a_snsdefType->printSelf();
  printf(",");
  a_probeLocation->printSelf();
  printf(",");
  diam->printSelf();
  if (a_snsdefProbeForm)
    {
      printf(",");
      a_snsdefProbeForm->printSelf();
    }
}

snsdefType * snsdefProbe::get_snsdefType()
{ return a_snsdefType; }
void snsdefProbe::set_snsdefType(snsdefType * snsdefTypeIn)
{ a_snsdefType = snsdefTypeIn; }
probeLocation * snsdefProbe::get_probeLocation()
{ return a_probeLocation; }
void snsdefProbe::set_probeLocation(probeLocation * probeLocationIn)
{ a_probeLocation = probeLocationIn; }
rentVal * snsdefProbe::get_diam()
{ return diam; }
void snsdefProbe::set_diam(rentVal * diamIn)
{ diam = diamIn; }
snsdefProbeForm * snsdefProbe::get_snsdefProbeForm()
{ return a_snsdefProbeForm; }
void snsdefProbe::set_snsdefProbeForm(snsdefProbeForm * snsdefProbeFormIn)
{ a_snsdefProbeForm = snsdefProbeFormIn; }

/********************************************************************/

probeLocation::probeLocation(){};

probeLocation::~probeLocation(){}

/********************************************************************/

probeLocCart::probeLocCart(){}

probeLocCart::probeLocCart(
  vector * distVecIn,
  vector * mountAxisVecIn)
{
  distVec = distVecIn;
  mountAxisVec = mountAxisVecIn;
}

probeLocCart::~probeLocCart(){}

void probeLocCart::printSelf()
{
  printf("CART");
  printf(",");
  distVec->printSelf();
  printf(",");
  mountAxisVec->printSelf();
}

vector * probeLocCart::get_distVec()
{ return distVec; }
void probeLocCart::set_distVec(vector * distVecIn)
{ distVec = distVecIn; }
vector * probeLocCart::get_mountAxisVec()
{ return mountAxisVec; }
void probeLocCart::set_mountAxisVec(vector * mountAxisVecIn)
{ mountAxisVec = mountAxisVecIn; }

/********************************************************************/

probeLocPol::probeLocPol(){}

probeLocPol::probeLocPol(
  angle * tiltIn,
  angle * rotIn,
  vector * mountAxisVecIn,
  rentVal * len1In)
{
  tilt = tiltIn;
  rot = rotIn;
  mountAxisVec = mountAxisVecIn;
  len1 = len1In;
}

probeLocPol::~probeLocPol(){}

void probeLocPol::printSelf()
{
  printf("POL");
  printf(",");
  tilt->printSelf();
  printf(",");
  rot->printSelf();
  printf(",");
  mountAxisVec->printSelf();
  printf(",");
  len1->printSelf();
}

angle * probeLocPol::get_tilt()
{ return tilt; }
void probeLocPol::set_tilt(angle * tiltIn)
{ tilt = tiltIn; }
angle * probeLocPol::get_rot()
{ return rot; }
void probeLocPol::set_rot(angle * rotIn)
{ rot = rotIn; }
vector * probeLocPol::get_mountAxisVec()
{ return mountAxisVec; }
void probeLocPol::set_mountAxisVec(vector * mountAxisVecIn)
{ mountAxisVec = mountAxisVecIn; }
rentVal * probeLocPol::get_len1()
{ return len1; }
void probeLocPol::set_len1(rentVal * len1In)
{ len1 = len1In; }

/********************************************************************/

probeLocVec::probeLocVec(){}

probeLocVec::probeLocVec(
  vector * tipVecIn,
  vector * mountAxisVecIn,
  rentVal * len1In)
{
  tipVec = tipVecIn;
  mountAxisVec = mountAxisVecIn;
  len1 = len1In;
}

probeLocVec::~probeLocVec(){}

void probeLocVec::printSelf()
{
  printf("VEC");
  printf(",");
  tipVec->printSelf();
  printf(",");
  mountAxisVec->printSelf();
  printf(",");
  len1->printSelf();
}

vector * probeLocVec::get_tipVec()
{ return tipVec; }
void probeLocVec::set_tipVec(vector * tipVecIn)
{ tipVec = tipVecIn; }
vector * probeLocVec::get_mountAxisVec()
{ return mountAxisVec; }
void probeLocVec::set_mountAxisVec(vector * mountAxisVecIn)
{ mountAxisVec = mountAxisVecIn; }
rentVal * probeLocVec::get_len1()
{ return len1; }
void probeLocVec::set_len1(rentVal * len1In)
{ len1 = len1In; }

/********************************************************************/

probeLocSnsCart::probeLocSnsCart(){}

probeLocSnsCart::probeLocSnsCart(
  sensorLabel2 * sensorLabel2In,
  vector * relVecIn)
{
  a_sensorLabel2 = sensorLabel2In;
  relVec = relVecIn;
}

probeLocSnsCart::~probeLocSnsCart(){}

void probeLocSnsCart::printSelf()
{
  a_sensorLabel2->printSelf();
  printf(",");
  printf("CART");
  printf(",");
  relVec->printSelf();
}

sensorLabel2 * probeLocSnsCart::get_sensorLabel2()
{ return a_sensorLabel2; }
void probeLocSnsCart::set_sensorLabel2(sensorLabel2 * sensorLabel2In)
{ a_sensorLabel2 = sensorLabel2In; }
vector * probeLocSnsCart::get_relVec()
{ return relVec; }
void probeLocSnsCart::set_relVec(vector * relVecIn)
{ relVec = relVecIn; }

/********************************************************************/

probeLocSnsVec::probeLocSnsVec(){}

probeLocSnsVec::probeLocSnsVec(
  sensorLabel2 * sensorLabel2In,
  vector * relVecIn,
  rentVal * rlenIn)
{
  a_sensorLabel2 = sensorLabel2In;
  relVec = relVecIn;
  rlen = rlenIn;
}

probeLocSnsVec::~probeLocSnsVec(){}

void probeLocSnsVec::printSelf()
{
  a_sensorLabel2->printSelf();
  printf(",");
  printf("VEC");
  printf(",");
  relVec->printSelf();
  printf(",");
  rlen->printSelf();
}

sensorLabel2 * probeLocSnsVec::get_sensorLabel2()
{ return a_sensorLabel2; }
void probeLocSnsVec::set_sensorLabel2(sensorLabel2 * sensorLabel2In)
{ a_sensorLabel2 = sensorLabel2In; }
vector * probeLocSnsVec::get_relVec()
{ return relVec; }
void probeLocSnsVec::set_relVec(vector * relVecIn)
{ relVec = relVecIn; }
rentVal * probeLocSnsVec::get_rlen()
{ return rlen; }
void probeLocSnsVec::set_rlen(rentVal * rlenIn)
{ rlen = rlenIn; }

/********************************************************************/

snsdefProbeForm::snsdefProbeForm(){};

snsdefProbeForm::~snsdefProbeForm(){}

/********************************************************************/

snsdefProbeForm_SPHERE::snsdefProbeForm_SPHERE(){}

snsdefProbeForm_SPHERE::~snsdefProbeForm_SPHERE(){}

void snsdefProbeForm_SPHERE::printSelf()
{
  printf("SPHERE");
}

/********************************************************************/

snsdefProbeForm_CYLNDR::snsdefProbeForm_CYLNDR(){}

snsdefProbeForm_CYLNDR::snsdefProbeForm_CYLNDR(
  rentVal * len2In)
{
  len2 = len2In;
}

snsdefProbeForm_CYLNDR::~snsdefProbeForm_CYLNDR(){}

void snsdefProbeForm_CYLNDR::printSelf()
{
  printf("CYLNDR");
  printf(",");
  len2->printSelf();
}

rentVal * snsdefProbeForm_CYLNDR::get_len2()
{ return len2; }
void snsdefProbeForm_CYLNDR::set_len2(rentVal * len2In)
{ len2 = len2In; }

/********************************************************************/

snsdefProbeForm_DISK::snsdefProbeForm_DISK(){}

snsdefProbeForm_DISK::snsdefProbeForm_DISK(
  rentVal * thknIn)
{
  thkn = thknIn;
}

snsdefProbeForm_DISK::~snsdefProbeForm_DISK(){}

void snsdefProbeForm_DISK::printSelf()
{
  printf("DISK");
  printf(",");
  thkn->printSelf();
}

rentVal * snsdefProbeForm_DISK::get_thkn()
{ return thkn; }
void snsdefProbeForm_DISK::set_thkn(rentVal * thknIn)
{ thkn = thknIn; }

/********************************************************************/

snsdefVideo::snsdefVideo(){}

snsdefVideo::snsdefVideo(
  snsdefType * snsdefTypeIn,
  snsdefLocation * snsdefLocationIn,
  rentVal * focalIn,
  rentVal * magIn,
  rentVal * apertIn)
{
  a_snsdefType = snsdefTypeIn;
  a_snsdefLocation = snsdefLocationIn;
  focal = focalIn;
  mag = magIn;
  apert = apertIn;
}

snsdefVideo::~snsdefVideo(){}

void snsdefVideo::printSelf()
{
  printf("VIDEO");
  printf(",");
  a_snsdefType->printSelf();
  printf(",");
  a_snsdefLocation->printSelf();
  printf(",");
  focal->printSelf();
  printf(",");
  mag->printSelf();
  printf(",");
  apert->printSelf();
}

snsdefType * snsdefVideo::get_snsdefType()
{ return a_snsdefType; }
void snsdefVideo::set_snsdefType(snsdefType * snsdefTypeIn)
{ a_snsdefType = snsdefTypeIn; }
snsdefLocation * snsdefVideo::get_snsdefLocation()
{ return a_snsdefLocation; }
void snsdefVideo::set_snsdefLocation(snsdefLocation * snsdefLocationIn)
{ a_snsdefLocation = snsdefLocationIn; }
rentVal * snsdefVideo::get_focal()
{ return focal; }
void snsdefVideo::set_focal(rentVal * focalIn)
{ focal = focalIn; }
rentVal * snsdefVideo::get_mag()
{ return mag; }
void snsdefVideo::set_mag(rentVal * magIn)
{ mag = magIn; }
rentVal * snsdefVideo::get_apert()
{ return apert; }
void snsdefVideo::set_apert(rentVal * apertIn)
{ apert = apertIn; }

/********************************************************************/

snsdefLaser::snsdefLaser(){}

snsdefLaser::snsdefLaser(
  snsdefType * snsdefTypeIn,
  snsdefLocation * snsdefLocationIn,
  rentVal * powerIn,
  rentVal * shuterIn)
{
  a_snsdefType = snsdefTypeIn;
  a_snsdefLocation = snsdefLocationIn;
  power = powerIn;
  shuter = shuterIn;
}

snsdefLaser::~snsdefLaser(){}

void snsdefLaser::printSelf()
{
  printf("LASER");
  printf(",");
  a_snsdefType->printSelf();
  printf(",");
  a_snsdefLocation->printSelf();
  printf(",");
  power->printSelf();
  printf(",");
  shuter->printSelf();
}

snsdefType * snsdefLaser::get_snsdefType()
{ return a_snsdefType; }
void snsdefLaser::set_snsdefType(snsdefType * snsdefTypeIn)
{ a_snsdefType = snsdefTypeIn; }
snsdefLocation * snsdefLaser::get_snsdefLocation()
{ return a_snsdefLocation; }
void snsdefLaser::set_snsdefLocation(snsdefLocation * snsdefLocationIn)
{ a_snsdefLocation = snsdefLocationIn; }
rentVal * snsdefLaser::get_power()
{ return power; }
void snsdefLaser::set_power(rentVal * powerIn)
{ power = powerIn; }
rentVal * snsdefLaser::get_shuter()
{ return shuter; }
void snsdefLaser::set_shuter(rentVal * shuterIn)
{ shuter = shuterIn; }

/********************************************************************/

snsdefInfred::snsdefInfred(){}

snsdefInfred::snsdefInfred(
  snsdefType * snsdefTypeIn,
  snsdefLocation * snsdefLocationIn,
  rentVal * fovxIn,
  rentVal * fovyIn,
  rentVal * freqIn,
  rentVal * dwellIn)
{
  a_snsdefType = snsdefTypeIn;
  a_snsdefLocation = snsdefLocationIn;
  fovx = fovxIn;
  fovy = fovyIn;
  freq = freqIn;
  dwell = dwellIn;
}

snsdefInfred::~snsdefInfred(){}

void snsdefInfred::printSelf()
{
  printf("INFRED");
  printf(",");
  a_snsdefType->printSelf();
  printf(",");
  a_snsdefLocation->printSelf();
  printf(",");
  fovx->printSelf();
  printf(",");
  fovy->printSelf();
  printf(",");
  freq->printSelf();
  printf(",");
  dwell->printSelf();
}

snsdefType * snsdefInfred::get_snsdefType()
{ return a_snsdefType; }
void snsdefInfred::set_snsdefType(snsdefType * snsdefTypeIn)
{ a_snsdefType = snsdefTypeIn; }
snsdefLocation * snsdefInfred::get_snsdefLocation()
{ return a_snsdefLocation; }
void snsdefInfred::set_snsdefLocation(snsdefLocation * snsdefLocationIn)
{ a_snsdefLocation = snsdefLocationIn; }
rentVal * snsdefInfred::get_fovx()
{ return fovx; }
void snsdefInfred::set_fovx(rentVal * fovxIn)
{ fovx = fovxIn; }
rentVal * snsdefInfred::get_fovy()
{ return fovy; }
void snsdefInfred::set_fovy(rentVal * fovyIn)
{ fovy = fovyIn; }
rentVal * snsdefInfred::get_freq()
{ return freq; }
void snsdefInfred::set_freq(rentVal * freqIn)
{ freq = freqIn; }
rentVal * snsdefInfred::get_dwell()
{ return dwell; }
void snsdefInfred::set_dwell(rentVal * dwellIn)
{ dwell = dwellIn; }

/********************************************************************/

snsdefNoncon::snsdefNoncon(){}

snsdefNoncon::snsdefNoncon(
  snsdefType * snsdefTypeIn,
  snsdefLocation * snsdefLocationIn,
  intVal * numProbesIn)
{
  a_snsdefType = snsdefTypeIn;
  a_snsdefLocation = snsdefLocationIn;
  numProbes = numProbesIn;
}

snsdefNoncon::~snsdefNoncon(){}

void snsdefNoncon::printSelf()
{
  printf("NONCON");
  printf(",");
  a_snsdefType->printSelf();
  printf(",");
  a_snsdefLocation->printSelf();
  printf(",");
  numProbes->printSelf();
}

snsdefType * snsdefNoncon::get_snsdefType()
{ return a_snsdefType; }
void snsdefNoncon::set_snsdefType(snsdefType * snsdefTypeIn)
{ a_snsdefType = snsdefTypeIn; }
snsdefLocation * snsdefNoncon::get_snsdefLocation()
{ return a_snsdefLocation; }
void snsdefNoncon::set_snsdefLocation(snsdefLocation * snsdefLocationIn)
{ a_snsdefLocation = snsdefLocationIn; }
intVal * snsdefNoncon::get_numProbes()
{ return numProbes; }
void snsdefNoncon::set_numProbes(intVal * numProbesIn)
{ numProbes = numProbesIn; }

/********************************************************************/

snsdefLocation::snsdefLocation(){};

snsdefLocation::~snsdefLocation(){}

/********************************************************************/

snsdefLocation_CART::snsdefLocation_CART(){}

snsdefLocation_CART::snsdefLocation_CART(
  vector * distVecIn,
  vector * sockAxisIn)
{
  distVec = distVecIn;
  sockAxis = sockAxisIn;
}

snsdefLocation_CART::~snsdefLocation_CART(){}

void snsdefLocation_CART::printSelf()
{
  printf("CART");
  printf(",");
  distVec->printSelf();
  printf(",");
  sockAxis->printSelf();
}

vector * snsdefLocation_CART::get_distVec()
{ return distVec; }
void snsdefLocation_CART::set_distVec(vector * distVecIn)
{ distVec = distVecIn; }
vector * snsdefLocation_CART::get_sockAxis()
{ return sockAxis; }
void snsdefLocation_CART::set_sockAxis(vector * sockAxisIn)
{ sockAxis = sockAxisIn; }

/********************************************************************/

snsdefLocation_POL::snsdefLocation_POL(){}

snsdefLocation_POL::snsdefLocation_POL(
  angle * tiltIn,
  angle * rotIn,
  vector * sockAxisIn)
{
  tilt = tiltIn;
  rot = rotIn;
  sockAxis = sockAxisIn;
}

snsdefLocation_POL::~snsdefLocation_POL(){}

void snsdefLocation_POL::printSelf()
{
  printf("POL");
  printf(",");
  tilt->printSelf();
  printf(",");
  rot->printSelf();
  printf(",");
  sockAxis->printSelf();
}

angle * snsdefLocation_POL::get_tilt()
{ return tilt; }
void snsdefLocation_POL::set_tilt(angle * tiltIn)
{ tilt = tiltIn; }
angle * snsdefLocation_POL::get_rot()
{ return rot; }
void snsdefLocation_POL::set_rot(angle * rotIn)
{ rot = rotIn; }
vector * snsdefLocation_POL::get_sockAxis()
{ return sockAxis; }
void snsdefLocation_POL::set_sockAxis(vector * sockAxisIn)
{ sockAxis = sockAxisIn; }

/********************************************************************/

snsdefLocation_VEC::snsdefLocation_VEC(){}

snsdefLocation_VEC::snsdefLocation_VEC(
  vector * beamAxisIn,
  vector * sockAxisIn)
{
  beamAxis = beamAxisIn;
  sockAxis = sockAxisIn;
}

snsdefLocation_VEC::~snsdefLocation_VEC(){}

void snsdefLocation_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  beamAxis->printSelf();
  printf(",");
  sockAxis->printSelf();
}

vector * snsdefLocation_VEC::get_beamAxis()
{ return beamAxis; }
void snsdefLocation_VEC::set_beamAxis(vector * beamAxisIn)
{ beamAxis = beamAxisIn; }
vector * snsdefLocation_VEC::get_sockAxis()
{ return sockAxis; }
void snsdefLocation_VEC::set_sockAxis(vector * sockAxisIn)
{ sockAxis = sockAxisIn; }

/********************************************************************/

snsdefType::snsdefType(){};

snsdefType::~snsdefType(){}

/********************************************************************/

snsdefType_FIXED::snsdefType_FIXED(){}

snsdefType_FIXED::~snsdefType_FIXED(){}

void snsdefType_FIXED::printSelf()
{
  printf("FIXED");
}

/********************************************************************/

snsdefType_INDEX::snsdefType_INDEX(){}

snsdefType_INDEX::~snsdefType_INDEX(){}

void snsdefType_INDEX::printSelf()
{
  printf("INDEX");
}

/********************************************************************/

snsdefBuildSensor::snsdefBuildSensor(){};

snsdefBuildSensor::~snsdefBuildSensor(){}

/********************************************************************/

snsdefBuild::snsdefBuild(){}

snsdefBuild::snsdefBuild(
  std::list<snsdefBuildItem *> * snsdefBuildItemListIn,
  snsdefBuildSensor * snsdefBuildSensorIn)
{
  a_snsdefBuildItemList = snsdefBuildItemListIn;
  a_snsdefBuildSensor = snsdefBuildSensorIn;
}

snsdefBuild::~snsdefBuild(){}

void snsdefBuild::printSelf()
{
  printf("BUILD");
  printf(",");
  if (a_snsdefBuildItemList->begin() == a_snsdefBuildItemList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<snsdefBuildItem *>::iterator iter;
      for (iter = a_snsdefBuildItemList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_snsdefBuildItemList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  a_snsdefBuildSensor->printSelf();
}

std::list<snsdefBuildItem *> * snsdefBuild::get_snsdefBuildItemList()
{ return a_snsdefBuildItemList; }
void snsdefBuild::set_snsdefBuildItemList(std::list<snsdefBuildItem *> * snsdefBuildItemListIn)
{ a_snsdefBuildItemList = snsdefBuildItemListIn; }
snsdefBuildSensor * snsdefBuild::get_snsdefBuildSensor()
{ return a_snsdefBuildSensor; }
void snsdefBuild::set_snsdefBuildSensor(snsdefBuildSensor * snsdefBuildSensorIn)
{ a_snsdefBuildSensor = snsdefBuildSensorIn; }

/********************************************************************/

snsdefBuildItem::snsdefBuildItem(){};

snsdefBuildItem::~snsdefBuildItem(){}

/********************************************************************/

snsdefBuildItem_sgLabel::snsdefBuildItem_sgLabel(){}

snsdefBuildItem_sgLabel::snsdefBuildItem_sgLabel(
  sgLabel * sgLabelIn)
{
  a_sgLabel = sgLabelIn;
}

snsdefBuildItem_sgLabel::~snsdefBuildItem_sgLabel(){}

void snsdefBuildItem_sgLabel::printSelf()
{
  a_sgLabel->printSelf();
}

sgLabel * snsdefBuildItem_sgLabel::get_sgLabel()
{ return a_sgLabel; }
void snsdefBuildItem_sgLabel::set_sgLabel(sgLabel * sgLabelIn)
{ a_sgLabel = sgLabelIn; }

/********************************************************************/

snsdefBuildItem_swLabel::snsdefBuildItem_swLabel(){}

snsdefBuildItem_swLabel::snsdefBuildItem_swLabel(
  swLabel * swLabelIn,
  std::list<snsdefWristAngleItem *> * snsdefWristAngleListIn)
{
  a_swLabel = swLabelIn;
  a_snsdefWristAngleList = snsdefWristAngleListIn;
}

snsdefBuildItem_swLabel::~snsdefBuildItem_swLabel(){}

void snsdefBuildItem_swLabel::printSelf()
{
  a_swLabel->printSelf();
  if (a_snsdefWristAngleList)
    {
      printf(",");
      if (a_snsdefWristAngleList->begin() == a_snsdefWristAngleList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<snsdefWristAngleItem *>::iterator iter;
          for (iter = a_snsdefWristAngleList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_snsdefWristAngleList->end())
                break;
              printf(",");
            }
        }
    }
}

swLabel * snsdefBuildItem_swLabel::get_swLabel()
{ return a_swLabel; }
void snsdefBuildItem_swLabel::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
std::list<snsdefWristAngleItem *> * snsdefBuildItem_swLabel::get_snsdefWristAngleList()
{ return a_snsdefWristAngleList; }
void snsdefBuildItem_swLabel::set_snsdefWristAngleList(std::list<snsdefWristAngleItem *> * snsdefWristAngleListIn)
{ a_snsdefWristAngleList = snsdefWristAngleListIn; }

/********************************************************************/

snsdefBuildItem_sxLabel::snsdefBuildItem_sxLabel(){}

snsdefBuildItem_sxLabel::snsdefBuildItem_sxLabel(
  sxLabel * sxLabelIn)
{
  a_sxLabel = sxLabelIn;
}

snsdefBuildItem_sxLabel::~snsdefBuildItem_sxLabel(){}

void snsdefBuildItem_sxLabel::printSelf()
{
  a_sxLabel->printSelf();
}

sxLabel * snsdefBuildItem_sxLabel::get_sxLabel()
{ return a_sxLabel; }
void snsdefBuildItem_sxLabel::set_sxLabel(sxLabel * sxLabelIn)
{ a_sxLabel = sxLabelIn; }

/********************************************************************/

snsdefBuildItem_rmLabel::snsdefBuildItem_rmLabel(){}

snsdefBuildItem_rmLabel::snsdefBuildItem_rmLabel(
  rmLabel * rmLabelIn)
{
  a_rmLabel = rmLabelIn;
}

snsdefBuildItem_rmLabel::~snsdefBuildItem_rmLabel(){}

void snsdefBuildItem_rmLabel::printSelf()
{
  a_rmLabel->printSelf();
}

rmLabel * snsdefBuildItem_rmLabel::get_rmLabel()
{ return a_rmLabel; }
void snsdefBuildItem_rmLabel::set_rmLabel(rmLabel * rmLabelIn)
{ a_rmLabel = rmLabelIn; }

/********************************************************************/

snsdefWristAngleItem::snsdefWristAngleItem(){}

snsdefWristAngleItem::snsdefWristAngleItem(
  stringVal * anglenameIn,
  angle * angleIn)
{
  anglename = anglenameIn;
  a_angle = angleIn;
}

snsdefWristAngleItem::~snsdefWristAngleItem(){}

void snsdefWristAngleItem::printSelf()
{
  anglename->printSelf();
  printf(",");
  a_angle->printSelf();
}

stringVal * snsdefWristAngleItem::get_anglename()
{ return anglename; }
void snsdefWristAngleItem::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }
angle * snsdefWristAngleItem::get_angle()
{ return a_angle; }
void snsdefWristAngleItem::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

snsetItem::snsetItem(){};

snsetItem::~snsetItem(){}

/********************************************************************/

snsetItem_snsetTypeAndValue::snsetItem_snsetTypeAndValue(){}

snsetItem_snsetTypeAndValue::snsetItem_snsetTypeAndValue(
  snsetTypeAndValue * snsetTypeAndValueIn)
{
  a_snsetTypeAndValue = snsetTypeAndValueIn;
}

snsetItem_snsetTypeAndValue::~snsetItem_snsetTypeAndValue(){}

void snsetItem_snsetTypeAndValue::printSelf()
{
  a_snsetTypeAndValue->printSelf();
}

snsetTypeAndValue * snsetItem_snsetTypeAndValue::get_snsetTypeAndValue()
{ return a_snsetTypeAndValue; }
void snsetItem_snsetTypeAndValue::set_snsetTypeAndValue(snsetTypeAndValue * snsetTypeAndValueIn)
{ a_snsetTypeAndValue = snsetTypeAndValueIn; }

/********************************************************************/

snsetItem_snsetType::snsetItem_snsetType(){}

snsetItem_snsetType::snsetItem_snsetType(
  snsetType * snsetTypeIn)
{
  a_snsetType = snsetTypeIn;
}

snsetItem_snsetType::~snsetItem_snsetType(){}

void snsetItem_snsetType::printSelf()
{
  a_snsetType->printSelf();
}

snsetType * snsetItem_snsetType::get_snsetType()
{ return a_snsetType; }
void snsetItem_snsetType::set_snsetType(snsetType * snsetTypeIn)
{ a_snsetType = snsetTypeIn; }

/********************************************************************/

snsetItem_snsetLabelAndValue::snsetItem_snsetLabelAndValue(){}

snsetItem_snsetLabelAndValue::snsetItem_snsetLabelAndValue(
  snsetLabelAndValue * snsetLabelAndValueIn)
{
  a_snsetLabelAndValue = snsetLabelAndValueIn;
}

snsetItem_snsetLabelAndValue::~snsetItem_snsetLabelAndValue(){}

void snsetItem_snsetLabelAndValue::printSelf()
{
  a_snsetLabelAndValue->printSelf();
}

snsetLabelAndValue * snsetItem_snsetLabelAndValue::get_snsetLabelAndValue()
{ return a_snsetLabelAndValue; }
void snsetItem_snsetLabelAndValue::set_snsetLabelAndValue(snsetLabelAndValue * snsetLabelAndValueIn)
{ a_snsetLabelAndValue = snsetLabelAndValueIn; }

/********************************************************************/

snsetItem_snsetLabel::snsetItem_snsetLabel(){}

snsetItem_snsetLabel::snsetItem_snsetLabel(
  snsetLabel * snsetLabelIn)
{
  a_snsetLabel = snsetLabelIn;
}

snsetItem_snsetLabel::~snsetItem_snsetLabel(){}

void snsetItem_snsetLabel::printSelf()
{
  a_snsetLabel->printSelf();
}

snsetLabel * snsetItem_snsetLabel::get_snsetLabel()
{ return a_snsetLabel; }
void snsetItem_snsetLabel::set_snsetLabel(snsetLabel * snsetLabelIn)
{ a_snsetLabel = snsetLabelIn; }

/********************************************************************/

snsetItem_snsetToggle::snsetItem_snsetToggle(){}

snsetItem_snsetToggle::snsetItem_snsetToggle(
  snsetToggle * snsetToggleIn)
{
  a_snsetToggle = snsetToggleIn;
}

snsetItem_snsetToggle::~snsetItem_snsetToggle(){}

void snsetItem_snsetToggle::printSelf()
{
  a_snsetToggle->printSelf();
}

snsetToggle * snsetItem_snsetToggle::get_snsetToggle()
{ return a_snsetToggle; }
void snsetItem_snsetToggle::set_snsetToggle(snsetToggle * snsetToggleIn)
{ a_snsetToggle = snsetToggleIn; }

/********************************************************************/

snsetItem_CLRSRF::snsetItem_CLRSRF(){}

snsetItem_CLRSRF::snsetItem_CLRSRF(
  snsetFeat * snsetFeatIn,
  rentVal * distIn)
{
  a_snsetFeat = snsetFeatIn;
  dist = distIn;
}

snsetItem_CLRSRF::~snsetItem_CLRSRF(){}

void snsetItem_CLRSRF::printSelf()
{
  printf("CLRSRF");
  printf(",");
  a_snsetFeat->printSelf();
  if (dist)
    {
      printf(",");
      dist->printSelf();
    }
}

snsetFeat * snsetItem_CLRSRF::get_snsetFeat()
{ return a_snsetFeat; }
void snsetItem_CLRSRF::set_snsetFeat(snsetFeat * snsetFeatIn)
{ a_snsetFeat = snsetFeatIn; }
rentVal * snsetItem_CLRSRF::get_dist()
{ return dist; }
void snsetItem_CLRSRF::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

snsetItem_DEPTH::snsetItem_DEPTH(){}

snsetItem_DEPTH::snsetItem_DEPTH(
  snsetFeat * snsetFeatIn,
  rentVal * distIn)
{
  a_snsetFeat = snsetFeatIn;
  dist = distIn;
}

snsetItem_DEPTH::~snsetItem_DEPTH(){}

void snsetItem_DEPTH::printSelf()
{
  printf("DEPTH");
  printf(",");
  a_snsetFeat->printSelf();
  if (dist)
    {
      printf(",");
      dist->printSelf();
    }
}

snsetFeat * snsetItem_DEPTH::get_snsetFeat()
{ return a_snsetFeat; }
void snsetItem_DEPTH::set_snsetFeat(snsetFeat * snsetFeatIn)
{ a_snsetFeat = snsetFeatIn; }
rentVal * snsetItem_DEPTH::get_dist()
{ return dist; }
void snsetItem_DEPTH::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

snsetTypeAndValue::snsetTypeAndValue(){};

snsetTypeAndValue::~snsetTypeAndValue(){}

/********************************************************************/

snsetTypeAndValue_APPRCH::snsetTypeAndValue_APPRCH(){}

snsetTypeAndValue_APPRCH::snsetTypeAndValue_APPRCH(
  rentVal * distIn)
{
  dist = distIn;
}

snsetTypeAndValue_APPRCH::~snsetTypeAndValue_APPRCH(){}

void snsetTypeAndValue_APPRCH::printSelf()
{
  printf("APPRCH");
  printf(",");
  dist->printSelf();
}

rentVal * snsetTypeAndValue_APPRCH::get_dist()
{ return dist; }
void snsetTypeAndValue_APPRCH::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

snsetTypeAndValue_CLRSRF::snsetTypeAndValue_CLRSRF(){}

snsetTypeAndValue_CLRSRF::snsetTypeAndValue_CLRSRF(
  rentVal * distIn)
{
  dist = distIn;
}

snsetTypeAndValue_CLRSRF::~snsetTypeAndValue_CLRSRF(){}

void snsetTypeAndValue_CLRSRF::printSelf()
{
  printf("CLRSRF");
  printf(",");
  dist->printSelf();
}

rentVal * snsetTypeAndValue_CLRSRF::get_dist()
{ return dist; }
void snsetTypeAndValue_CLRSRF::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

snsetTypeAndValue_DEPTH::snsetTypeAndValue_DEPTH(){}

snsetTypeAndValue_DEPTH::snsetTypeAndValue_DEPTH(
  rentVal * distIn)
{
  dist = distIn;
}

snsetTypeAndValue_DEPTH::~snsetTypeAndValue_DEPTH(){}

void snsetTypeAndValue_DEPTH::printSelf()
{
  printf("DEPTH");
  printf(",");
  dist->printSelf();
}

rentVal * snsetTypeAndValue_DEPTH::get_dist()
{ return dist; }
void snsetTypeAndValue_DEPTH::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

snsetTypeAndValue_MINCON::snsetTypeAndValue_MINCON(){}

snsetTypeAndValue_MINCON::snsetTypeAndValue_MINCON(
  rentVal * levelIn)
{
  level = levelIn;
}

snsetTypeAndValue_MINCON::~snsetTypeAndValue_MINCON(){}

void snsetTypeAndValue_MINCON::printSelf()
{
  printf("MINCON");
  printf(",");
  level->printSelf();
}

rentVal * snsetTypeAndValue_MINCON::get_level()
{ return level; }
void snsetTypeAndValue_MINCON::set_level(rentVal * levelIn)
{ level = levelIn; }

/********************************************************************/

snsetTypeAndValue_RETRCT::snsetTypeAndValue_RETRCT(){}

snsetTypeAndValue_RETRCT::snsetTypeAndValue_RETRCT(
  rentVal * distIn)
{
  dist = distIn;
}

snsetTypeAndValue_RETRCT::~snsetTypeAndValue_RETRCT(){}

void snsetTypeAndValue_RETRCT::printSelf()
{
  printf("RETRCT");
  printf(",");
  dist->printSelf();
}

rentVal * snsetTypeAndValue_RETRCT::get_dist()
{ return dist; }
void snsetTypeAndValue_RETRCT::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

snsetTypeAndValue_SEARCH::snsetTypeAndValue_SEARCH(){}

snsetTypeAndValue_SEARCH::snsetTypeAndValue_SEARCH(
  rentVal * distIn)
{
  dist = distIn;
}

snsetTypeAndValue_SEARCH::~snsetTypeAndValue_SEARCH(){}

void snsetTypeAndValue_SEARCH::printSelf()
{
  printf("SEARCH");
  printf(",");
  dist->printSelf();
}

rentVal * snsetTypeAndValue_SEARCH::get_dist()
{ return dist; }
void snsetTypeAndValue_SEARCH::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

snsetTypeAndValue_SCALEX::snsetTypeAndValue_SCALEX(){}

snsetTypeAndValue_SCALEX::snsetTypeAndValue_SCALEX(
  rentVal * scaleIn)
{
  scale = scaleIn;
}

snsetTypeAndValue_SCALEX::~snsetTypeAndValue_SCALEX(){}

void snsetTypeAndValue_SCALEX::printSelf()
{
  printf("SCALEX");
  printf(",");
  scale->printSelf();
}

rentVal * snsetTypeAndValue_SCALEX::get_scale()
{ return scale; }
void snsetTypeAndValue_SCALEX::set_scale(rentVal * scaleIn)
{ scale = scaleIn; }

/********************************************************************/

snsetTypeAndValue_SCALEY::snsetTypeAndValue_SCALEY(){}

snsetTypeAndValue_SCALEY::snsetTypeAndValue_SCALEY(
  rentVal * scaleIn)
{
  scale = scaleIn;
}

snsetTypeAndValue_SCALEY::~snsetTypeAndValue_SCALEY(){}

void snsetTypeAndValue_SCALEY::printSelf()
{
  printf("SCALEY");
  printf(",");
  scale->printSelf();
}

rentVal * snsetTypeAndValue_SCALEY::get_scale()
{ return scale; }
void snsetTypeAndValue_SCALEY::set_scale(rentVal * scaleIn)
{ scale = scaleIn; }

/********************************************************************/

snsetType::snsetType(){};

snsetType::~snsetType(){}

/********************************************************************/

snsetType_FOCUSY::snsetType_FOCUSY(){}

snsetType_FOCUSY::~snsetType_FOCUSY(){}

void snsetType_FOCUSY::printSelf()
{
  printf("FOCUSY");
}

/********************************************************************/

snsetType_FOCUSN::snsetType_FOCUSN(){}

snsetType_FOCUSN::~snsetType_FOCUSN(){}

void snsetType_FOCUSN::printSelf()
{
  printf("FOCUSN");
}

/********************************************************************/

snsetToggle::snsetToggle(){};

snsetToggle::~snsetToggle(){}

/********************************************************************/

snsetToggle_CLRSRF::snsetToggle_CLRSRF(){}

snsetToggle_CLRSRF::~snsetToggle_CLRSRF(){}

void snsetToggle_CLRSRF::printSelf()
{
  printf("CLRSRF");
  printf(",");
  printf("OFF");
}

/********************************************************************/

snsetToggle_DEPTH::snsetToggle_DEPTH(){}

snsetToggle_DEPTH::~snsetToggle_DEPTH(){}

void snsetToggle_DEPTH::printSelf()
{
  printf("DEPTH");
  printf(",");
  printf("OFF");
}

/********************************************************************/

snsetLabelAndValue::snsetLabelAndValue(){}

snsetLabelAndValue::snsetLabelAndValue(
  vlLabel * vlLabelIn,
  rentVal * intnstyIn)
{
  a_vlLabel = vlLabelIn;
  intnsty = intnstyIn;
}

snsetLabelAndValue::~snsetLabelAndValue(){}

void snsetLabelAndValue::printSelf()
{
  a_vlLabel->printSelf();
  printf(",");
  intnsty->printSelf();
}

vlLabel * snsetLabelAndValue::get_vlLabel()
{ return a_vlLabel; }
void snsetLabelAndValue::set_vlLabel(vlLabel * vlLabelIn)
{ a_vlLabel = vlLabelIn; }
rentVal * snsetLabelAndValue::get_intnsty()
{ return intnsty; }
void snsetLabelAndValue::set_intnsty(rentVal * intnstyIn)
{ intnsty = intnstyIn; }

/********************************************************************/

snsetLabel::snsetLabel(){};

snsetLabel::~snsetLabel(){}

/********************************************************************/

snsetFeat::snsetFeat(){};

snsetFeat::~snsetFeat(){}

/********************************************************************/

snsgrpStm::snsgrpStm(){}

snsgrpStm::snsgrpStm(
  sgsLabel * sgsLabelIn,
  snsgrpMinor * snsgrpMinorIn)
{
  a_sgsLabel = sgsLabelIn;
  a_snsgrpMinor = snsgrpMinorIn;
}

snsgrpStm::~snsgrpStm(){}

void snsgrpStm::printSelf()
{
  a_sgsLabel->printSelf();
  printf("=");
  printf("SNSGRP");
  printf("/");
  a_snsgrpMinor->printSelf();
  printf("%c%c", 13, 10);
}

sgsLabel * snsgrpStm::get_sgsLabel()
{ return a_sgsLabel; }
void snsgrpStm::set_sgsLabel(sgsLabel * sgsLabelIn)
{ a_sgsLabel = sgsLabelIn; }
snsgrpMinor * snsgrpStm::get_snsgrpMinor()
{ return a_snsgrpMinor; }
void snsgrpStm::set_snsgrpMinor(snsgrpMinor * snsgrpMinorIn)
{ a_snsgrpMinor = snsgrpMinorIn; }

/********************************************************************/

snsgrpMinor::snsgrpMinor(){};

snsgrpMinor::~snsgrpMinor(){}

/********************************************************************/

snsgrpMinor_ssLabel::snsgrpMinor_ssLabel(){}

snsgrpMinor_ssLabel::snsgrpMinor_ssLabel(
  std::list<snsgrpItem *> * snsgrpItemListIn,
  ssLabel * ssLabelIn)
{
  a_snsgrpItemList = snsgrpItemListIn;
  a_ssLabel = ssLabelIn;
}

snsgrpMinor_ssLabel::~snsgrpMinor_ssLabel(){}

void snsgrpMinor_ssLabel::printSelf()
{
  printf("BUILD");
  printf(",");
  if (a_snsgrpItemList->begin() == a_snsgrpItemList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<snsgrpItem *>::iterator iter;
      for (iter = a_snsgrpItemList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_snsgrpItemList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  a_ssLabel->printSelf();
}

std::list<snsgrpItem *> * snsgrpMinor_ssLabel::get_snsgrpItemList()
{ return a_snsgrpItemList; }
void snsgrpMinor_ssLabel::set_snsgrpItemList(std::list<snsgrpItem *> * snsgrpItemListIn)
{ a_snsgrpItemList = snsgrpItemListIn; }
ssLabel * snsgrpMinor_ssLabel::get_ssLabel()
{ return a_ssLabel; }
void snsgrpMinor_ssLabel::set_ssLabel(ssLabel * ssLabelIn)
{ a_ssLabel = ssLabelIn; }

/********************************************************************/

snsgrpMinor_sgsLabel::snsgrpMinor_sgsLabel(){}

snsgrpMinor_sgsLabel::snsgrpMinor_sgsLabel(
  std::list<snsgrpItem *> * snsgrpItemListIn,
  sgsLabel * sgsLabelIn)
{
  a_snsgrpItemList = snsgrpItemListIn;
  a_sgsLabel = sgsLabelIn;
}

snsgrpMinor_sgsLabel::~snsgrpMinor_sgsLabel(){}

void snsgrpMinor_sgsLabel::printSelf()
{
  printf("BUILD");
  printf(",");
  if (a_snsgrpItemList->begin() == a_snsgrpItemList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<snsgrpItem *>::iterator iter;
      for (iter = a_snsgrpItemList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_snsgrpItemList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  a_sgsLabel->printSelf();
}

std::list<snsgrpItem *> * snsgrpMinor_sgsLabel::get_snsgrpItemList()
{ return a_snsgrpItemList; }
void snsgrpMinor_sgsLabel::set_snsgrpItemList(std::list<snsgrpItem *> * snsgrpItemListIn)
{ a_snsgrpItemList = snsgrpItemListIn; }
sgsLabel * snsgrpMinor_sgsLabel::get_sgsLabel()
{ return a_sgsLabel; }
void snsgrpMinor_sgsLabel::set_sgsLabel(sgsLabel * sgsLabelIn)
{ a_sgsLabel = sgsLabelIn; }

/********************************************************************/

snsgrpItem::snsgrpItem(){};

snsgrpItem::~snsgrpItem(){}

/********************************************************************/

snslctGroup::snslctGroup(){};

snslctGroup::~snslctGroup(){}

/********************************************************************/

snslctGroupFeat::snslctGroupFeat(){}

snslctGroupFeat::snslctGroupFeat(
  gsaLabel * gsaLabelIn,
  featureLabel * featureLabelIn,
  angle * angleIn)
{
  a_gsaLabel = gsaLabelIn;
  a_featureLabel = featureLabelIn;
  a_angle = angleIn;
}

snslctGroupFeat::~snslctGroupFeat(){}

void snslctGroupFeat::printSelf()
{
  a_gsaLabel->printSelf();
  printf(",");
  a_featureLabel->printSelf();
  if (a_angle)
    {
      printf(",");
      printf("FZ");
      printf(",");
      a_angle->printSelf();
    }
}

gsaLabel * snslctGroupFeat::get_gsaLabel()
{ return a_gsaLabel; }
void snslctGroupFeat::set_gsaLabel(gsaLabel * gsaLabelIn)
{ a_gsaLabel = gsaLabelIn; }
featureLabel * snslctGroupFeat::get_featureLabel()
{ return a_featureLabel; }
void snslctGroupFeat::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
angle * snslctGroupFeat::get_angle()
{ return a_angle; }
void snslctGroupFeat::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

snslctGroupVec::snslctGroupVec(){}

snslctGroupVec::snslctGroupVec(
  gsaLabel * gsaLabelIn,
  vector * dirIn,
  angle * angleIn)
{
  a_gsaLabel = gsaLabelIn;
  dir = dirIn;
  a_angle = angleIn;
}

snslctGroupVec::~snslctGroupVec(){}

void snslctGroupVec::printSelf()
{
  a_gsaLabel->printSelf();
  printf(",");
  printf("VEC");
  printf(",");
  dir->printSelf();
  if (a_angle)
    {
      printf(",");
      printf("FZ");
      printf(",");
      a_angle->printSelf();
    }
}

gsaLabel * snslctGroupVec::get_gsaLabel()
{ return a_gsaLabel; }
void snslctGroupVec::set_gsaLabel(gsaLabel * gsaLabelIn)
{ a_gsaLabel = gsaLabelIn; }
vector * snslctGroupVec::get_dir()
{ return dir; }
void snslctGroupVec::set_dir(vector * dirIn)
{ dir = dirIn; }
angle * snslctGroupVec::get_angle()
{ return a_angle; }
void snslctGroupVec::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

snslctSensor::snslctSensor(){};

snslctSensor::~snslctSensor(){}

/********************************************************************/

snslctSensorTip::snslctSensorTip(){}

snslctSensorTip::snslctSensorTip(
  sensorLabel2 * sensorLabel2In,
  snslctTipData * snslctTipDataIn,
  snslctData * snslctDataIn)
{
  a_sensorLabel2 = sensorLabel2In;
  a_snslctTipData = snslctTipDataIn;
  a_snslctData = snslctDataIn;
}

snslctSensorTip::~snslctSensorTip(){}

void snslctSensorTip::printSelf()
{
  a_sensorLabel2->printSelf();
  if (a_snslctTipData)
    {
      printf(",");
      a_snslctTipData->printSelf();
    }
  if (a_snslctData)
    {
      printf(",");
      a_snslctData->printSelf();
    }
}

sensorLabel2 * snslctSensorTip::get_sensorLabel2()
{ return a_sensorLabel2; }
void snslctSensorTip::set_sensorLabel2(sensorLabel2 * sensorLabel2In)
{ a_sensorLabel2 = sensorLabel2In; }
snslctTipData * snslctSensorTip::get_snslctTipData()
{ return a_snslctTipData; }
void snslctSensorTip::set_snslctTipData(snslctTipData * snslctTipDataIn)
{ a_snslctTipData = snslctTipDataIn; }
snslctData * snslctSensorTip::get_snslctData()
{ return a_snslctData; }
void snslctSensorTip::set_snslctData(snslctData * snslctDataIn)
{ a_snslctData = snslctDataIn; }

/********************************************************************/

snslctSensorList::snslctSensorList(){}

snslctSensorList::snslctSensorList(
  sensorLabel2 * sensorLabel2In,
  std::list<sensorLabel2 *> * sensorListIn)
{
  a_sensorLabel2 = sensorLabel2In;
  a_sensorList = sensorListIn;
}

snslctSensorList::~snslctSensorList(){}

void snslctSensorList::printSelf()
{
  a_sensorLabel2->printSelf();
  printf(",");
  if (a_sensorList->begin() == a_sensorList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<sensorLabel2 *>::iterator iter;
      for (iter = a_sensorList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_sensorList->end())
            break;
          printf(",");
        }
    }
}

sensorLabel2 * snslctSensorList::get_sensorLabel2()
{ return a_sensorLabel2; }
void snslctSensorList::set_sensorLabel2(sensorLabel2 * sensorLabel2In)
{ a_sensorLabel2 = sensorLabel2In; }
std::list<sensorLabel2 *> * snslctSensorList::get_sensorList()
{ return a_sensorList; }
void snslctSensorList::set_sensorList(std::list<sensorLabel2 *> * sensorListIn)
{ a_sensorList = sensorListIn; }

/********************************************************************/

snslctTipData::snslctTipData(){};

snslctTipData::~snslctTipData(){}

/********************************************************************/

snslctData::snslctData(){};

snslctData::~snslctData(){}

/********************************************************************/

snslctData_snslctWristList::snslctData_snslctWristList(){}

snslctData_snslctWristList::snslctData_snslctWristList(
  std::list<snslctWristItem *> * snslctWristListIn)
{
  a_snslctWristList = snslctWristListIn;
}

snslctData_snslctWristList::~snslctData_snslctWristList(){}

void snslctData_snslctWristList::printSelf()
{
  if (a_snslctWristList->begin() == a_snslctWristList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<snslctWristItem *>::iterator iter;
      for (iter = a_snslctWristList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_snslctWristList->end())
            break;
          printf(",");
        }
    }
}

std::list<snslctWristItem *> * snslctData_snslctWristList::get_snslctWristList()
{ return a_snslctWristList; }
void snslctData_snslctWristList::set_snslctWristList(std::list<snslctWristItem *> * snslctWristListIn)
{ a_snslctWristList = snslctWristListIn; }

/********************************************************************/

snslctData_probeOrient::snslctData_probeOrient(){}

snslctData_probeOrient::snslctData_probeOrient(
  probeOrient * probeOrientIn)
{
  a_probeOrient = probeOrientIn;
}

snslctData_probeOrient::~snslctData_probeOrient(){}

void snslctData_probeOrient::printSelf()
{
  a_probeOrient->printSelf();
}

probeOrient * snslctData_probeOrient::get_probeOrient()
{ return a_probeOrient; }
void snslctData_probeOrient::set_probeOrient(probeOrient * probeOrientIn)
{ a_probeOrient = probeOrientIn; }

/********************************************************************/

snslctWristItem::snslctWristItem(){}

snslctWristItem::snslctWristItem(
  swLabel * swLabelIn,
  std::list<snslctWristAngleItem *> * snslctWristAngleListIn)
{
  a_swLabel = swLabelIn;
  a_snslctWristAngleList = snslctWristAngleListIn;
}

snslctWristItem::~snslctWristItem(){}

void snslctWristItem::printSelf()
{
  a_swLabel->printSelf();
  printf(",");
  if (a_snslctWristAngleList->begin() == a_snslctWristAngleList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<snslctWristAngleItem *>::iterator iter;
      for (iter = a_snslctWristAngleList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_snslctWristAngleList->end())
            break;
          printf(",");
        }
    }
}

swLabel * snslctWristItem::get_swLabel()
{ return a_swLabel; }
void snslctWristItem::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
std::list<snslctWristAngleItem *> * snslctWristItem::get_snslctWristAngleList()
{ return a_snslctWristAngleList; }
void snslctWristItem::set_snslctWristAngleList(std::list<snslctWristAngleItem *> * snslctWristAngleListIn)
{ a_snslctWristAngleList = snslctWristAngleListIn; }

/********************************************************************/

snslctWristAngleItem::snslctWristAngleItem(){};

snslctWristAngleItem::~snslctWristAngleItem(){}

/********************************************************************/

snslctWristAngleAngle::snslctWristAngleAngle(){}

snslctWristAngleAngle::snslctWristAngleAngle(
  stringVal * anglenameIn,
  angle * angleIn)
{
  anglename = anglenameIn;
  a_angle = angleIn;
}

snslctWristAngleAngle::~snslctWristAngleAngle(){}

void snslctWristAngleAngle::printSelf()
{
  anglename->printSelf();
  printf(",");
  a_angle->printSelf();
}

stringVal * snslctWristAngleAngle::get_anglename()
{ return anglename; }
void snslctWristAngleAngle::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }
angle * snslctWristAngleAngle::get_angle()
{ return a_angle; }
void snslctWristAngleAngle::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

snslctWristAngleFeat::snslctWristAngleFeat(){}

snslctWristAngleFeat::snslctWristAngleFeat(
  stringVal * anglenameIn,
  featureLabel * featureLabelIn,
  angle * angleIn)
{
  anglename = anglenameIn;
  a_featureLabel = featureLabelIn;
  a_angle = angleIn;
}

snslctWristAngleFeat::~snslctWristAngleFeat(){}

void snslctWristAngleFeat::printSelf()
{
  anglename->printSelf();
  printf(",");
  a_featureLabel->printSelf();
  if (a_angle)
    {
      printf(",");
      printf("FZ");
      printf(",");
      a_angle->printSelf();
    }
}

stringVal * snslctWristAngleFeat::get_anglename()
{ return anglename; }
void snslctWristAngleFeat::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }
featureLabel * snslctWristAngleFeat::get_featureLabel()
{ return a_featureLabel; }
void snslctWristAngleFeat::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
angle * snslctWristAngleFeat::get_angle()
{ return a_angle; }
void snslctWristAngleFeat::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

snslctWristAngleVec::snslctWristAngleVec(){}

snslctWristAngleVec::snslctWristAngleVec(
  stringVal * anglenameIn,
  vector * dirIn,
  angle * angleIn)
{
  anglename = anglenameIn;
  dir = dirIn;
  a_angle = angleIn;
}

snslctWristAngleVec::~snslctWristAngleVec(){}

void snslctWristAngleVec::printSelf()
{
  anglename->printSelf();
  printf(",");
  printf("VEC");
  printf(",");
  dir->printSelf();
  if (a_angle)
    {
      printf(",");
      printf("FZ");
      printf(",");
      a_angle->printSelf();
    }
}

stringVal * snslctWristAngleVec::get_anglename()
{ return anglename; }
void snslctWristAngleVec::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }
vector * snslctWristAngleVec::get_dir()
{ return dir; }
void snslctWristAngleVec::set_dir(vector * dirIn)
{ dir = dirIn; }
angle * snslctWristAngleVec::get_angle()
{ return a_angle; }
void snslctWristAngleVec::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

snsmntStm::snsmntStm(){}

snsmntStm::snsmntStm(
  snsmntMinor * snsmntMinorIn)
{
  a_snsmntMinor = snsmntMinorIn;
}

snsmntStm::~snsmntStm(){}

void snsmntStm::printSelf()
{
  printf("SNSMNT");
  printf("/");
  a_snsmntMinor->printSelf();
  printf("%c%c", 13, 10);
}

snsmntMinor * snsmntStm::get_snsmntMinor()
{ return a_snsmntMinor; }
void snsmntStm::set_snsmntMinor(snsmntMinor * snsmntMinorIn)
{ a_snsmntMinor = snsmntMinorIn; }

/********************************************************************/

snsmntMinor::snsmntMinor(){}

snsmntMinor::snsmntMinor(
  vector * xVecIn,
  vector * zVecIn,
  vector * distVecIn)
{
  xVec = xVecIn;
  zVec = zVecIn;
  distVec = distVecIn;
}

snsmntMinor::~snsmntMinor(){}

void snsmntMinor::printSelf()
{
  printf("XVEC");
  printf(",");
  xVec->printSelf();
  printf(",");
  printf("ZVEC");
  printf(",");
  zVec->printSelf();
  printf(",");
  printf("MNTLEN");
  printf(",");
  distVec->printSelf();
}

vector * snsmntMinor::get_xVec()
{ return xVec; }
void snsmntMinor::set_xVec(vector * xVecIn)
{ xVec = xVecIn; }
vector * snsmntMinor::get_zVec()
{ return zVec; }
void snsmntMinor::set_zVec(vector * zVecIn)
{ zVec = zVecIn; }
vector * snsmntMinor::get_distVec()
{ return distVec; }
void snsmntMinor::set_distVec(vector * distVecIn)
{ distVec = distVecIn; }

/********************************************************************/

tecompStm::tecompStm(){}

tecompStm::tecompStm(
  tecompMinor * tecompMinorIn)
{
  a_tecompMinor = tecompMinorIn;
}

tecompStm::~tecompStm(){}

void tecompStm::printSelf()
{
  printf("TECOMP");
  printf("/");
  a_tecompMinor->printSelf();
  printf("%c%c", 13, 10);
}

tecompMinor * tecompStm::get_tecompMinor()
{ return a_tecompMinor; }
void tecompStm::set_tecompMinor(tecompMinor * tecompMinorIn)
{ a_tecompMinor = tecompMinorIn; }

/********************************************************************/

tecompMinor::tecompMinor(){};

tecompMinor::~tecompMinor(){}

/********************************************************************/

tecompMinorMach::tecompMinorMach(){}

tecompMinorMach::tecompMinorMach(
  state * stateIn)
{
  a_state = stateIn;
}

tecompMinorMach::~tecompMinorMach(){}

void tecompMinorMach::printSelf()
{
  printf("MACH");
  printf(",");
  a_state->printSelf();
}

state * tecompMinorMach::get_state()
{ return a_state; }
void tecompMinorMach::set_state(state * stateIn)
{ a_state = stateIn; }

/********************************************************************/

tecompMinorOnList::tecompMinorOnList(){}

tecompMinorOnList::tecompMinorOnList(
  tecompVar2 * tecompVar2In,
  rentVal * tmpexpIn,
  rentVal * tmpexpuncIn,
  std::list<stringVal *> * stringListIn)
{
  a_tecompVar2 = tecompVar2In;
  tmpexp = tmpexpIn;
  tmpexpunc = tmpexpuncIn;
  a_stringList = stringListIn;
}

tecompMinorOnList::~tecompMinorOnList(){}

void tecompMinorOnList::printSelf()
{
  printf("PART");
  printf(",");
  printf("ON");
  if (a_tecompVar2)
    {
      a_tecompVar2->printSelf();
    }
  printf(",");
  tmpexp->printSelf();
  if (tmpexpunc)
    {
      printf(",");
      tmpexpunc->printSelf();
    }
  printf(",");
  if (a_stringList->begin() == a_stringList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<stringVal *>::iterator iter;
      for (iter = a_stringList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_stringList->end())
            break;
          printf(",");
        }
    }
}

tecompVar2 * tecompMinorOnList::get_tecompVar2()
{ return a_tecompVar2; }
void tecompMinorOnList::set_tecompVar2(tecompVar2 * tecompVar2In)
{ a_tecompVar2 = tecompVar2In; }
rentVal * tecompMinorOnList::get_tmpexp()
{ return tmpexp; }
void tecompMinorOnList::set_tmpexp(rentVal * tmpexpIn)
{ tmpexp = tmpexpIn; }
rentVal * tecompMinorOnList::get_tmpexpunc()
{ return tmpexpunc; }
void tecompMinorOnList::set_tmpexpunc(rentVal * tmpexpuncIn)
{ tmpexpunc = tmpexpuncIn; }
std::list<stringVal *> * tecompMinorOnList::get_stringList()
{ return a_stringList; }
void tecompMinorOnList::set_stringList(std::list<stringVal *> * stringListIn)
{ a_stringList = stringListIn; }

/********************************************************************/

tecompMinorOnAll::tecompMinorOnAll(){}

tecompMinorOnAll::tecompMinorOnAll(
  tecompVar2 * tecompVar2In,
  rentVal * tmpexpIn,
  rentVal * tmpexpuncIn)
{
  a_tecompVar2 = tecompVar2In;
  tmpexp = tmpexpIn;
  tmpexpunc = tmpexpuncIn;
}

tecompMinorOnAll::~tecompMinorOnAll(){}

void tecompMinorOnAll::printSelf()
{
  printf("PART");
  printf(",");
  printf("ON");
  if (a_tecompVar2)
    {
      a_tecompVar2->printSelf();
    }
  printf(",");
  tmpexp->printSelf();
  if (tmpexpunc)
    {
      printf(",");
      tmpexpunc->printSelf();
    }
  printf(",");
  printf("ALL");
}

tecompVar2 * tecompMinorOnAll::get_tecompVar2()
{ return a_tecompVar2; }
void tecompMinorOnAll::set_tecompVar2(tecompVar2 * tecompVar2In)
{ a_tecompVar2 = tecompVar2In; }
rentVal * tecompMinorOnAll::get_tmpexp()
{ return tmpexp; }
void tecompMinorOnAll::set_tmpexp(rentVal * tmpexpIn)
{ tmpexp = tmpexpIn; }
rentVal * tecompMinorOnAll::get_tmpexpunc()
{ return tmpexpunc; }
void tecompMinorOnAll::set_tmpexpunc(rentVal * tmpexpuncIn)
{ tmpexpunc = tmpexpuncIn; }

/********************************************************************/

tecompMinorOff::tecompMinorOff(){}

tecompMinorOff::~tecompMinorOff(){}

void tecompMinorOff::printSelf()
{
  printf("PART");
  printf(",");
  printf("OFF");
}

/********************************************************************/

tecompVar2::tecompVar2(){};

tecompVar2::~tecompVar2(){}

/********************************************************************/

tecompDatum::tecompDatum(){}

tecompDatum::tecompDatum(
  daLabel * daLabelIn)
{
  a_daLabel = daLabelIn;
}

tecompDatum::~tecompDatum(){}

void tecompDatum::printSelf()
{
  printf(",");
  a_daLabel->printSelf();
}

daLabel * tecompDatum::get_daLabel()
{ return a_daLabel; }
void tecompDatum::set_daLabel(daLabel * daLabelIn)
{ a_daLabel = daLabelIn; }

/********************************************************************/

tecompOffset::tecompOffset(){}

tecompOffset::tecompOffset(
  rentVal * xoffIn,
  rentVal * yoffIn,
  rentVal * zoffIn)
{
  xoff = xoffIn;
  yoff = yoffIn;
  zoff = zoffIn;
}

tecompOffset::~tecompOffset(){}

void tecompOffset::printSelf()
{
  printf(",");
  printf("OFFSET");
  printf(",");
  xoff->printSelf();
  printf(",");
  yoff->printSelf();
  printf(",");
  zoff->printSelf();
}

rentVal * tecompOffset::get_xoff()
{ return xoff; }
void tecompOffset::set_xoff(rentVal * xoffIn)
{ xoff = xoffIn; }
rentVal * tecompOffset::get_yoff()
{ return yoff; }
void tecompOffset::set_yoff(rentVal * yoffIn)
{ yoff = yoffIn; }
rentVal * tecompOffset::get_zoff()
{ return zoff; }
void tecompOffset::set_zoff(rentVal * zoffIn)
{ zoff = zoffIn; }

/********************************************************************/

textMinor::textMinor(){};

textMinor::~textMinor(){}

/********************************************************************/

textMan::textMan(){}

textMan::textMan(
  stringVal * textIn)
{
  text = textIn;
}

textMan::~textMan(){}

void textMan::printSelf()
{
  printf("MAN");
  printf(",");
  text->printSelf();
}

stringVal * textMan::get_text()
{ return text; }
void textMan::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

textOper::textOper(){}

textOper::textOper(
  stringVal * textIn)
{
  text = textIn;
}

textOper::~textOper(){}

void textOper::printSelf()
{
  printf("OPER");
  printf(",");
  text->printSelf();
}

stringVal * textOper::get_text()
{ return text; }
void textOper::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

textOutfil::textOutfil(){}

textOutfil::textOutfil(
  stringVal * textIn)
{
  text = textIn;
}

textOutfil::~textOutfil(){}

void textOutfil::printSelf()
{
  printf("OUTFIL");
  printf(",");
  text->printSelf();
}

stringVal * textOutfil::get_text()
{ return text; }
void textOutfil::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

textQuery::textQuery(){}

textQuery::textQuery(
  textQueryFormat * textQueryFormatIn,
  stringVal * textIn)
{
  a_textQueryFormat = textQueryFormatIn;
  text = textIn;
}

textQuery::~textQuery(){}

void textQuery::printSelf()
{
  printf("QUERY");
  printf(",");
  a_textQueryFormat->printSelf();
  printf(",");
  text->printSelf();
}

textQueryFormat * textQuery::get_textQueryFormat()
{ return a_textQueryFormat; }
void textQuery::set_textQueryFormat(textQueryFormat * textQueryFormatIn)
{ a_textQueryFormat = textQueryFormatIn; }
stringVal * textQuery::get_text()
{ return text; }
void textQuery::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

textQueryFormat::textQueryFormat(){}

textQueryFormat::textQueryFormat(
  labelName * labelNameIn,
  intVal * lengthIn,
  textType * textTypeIn,
  leftRight * leftRightIn)
{
  a_labelName = labelNameIn;
  length = lengthIn;
  a_textType = textTypeIn;
  a_leftRight = leftRightIn;
}

textQueryFormat::~textQueryFormat(){}

void textQueryFormat::printSelf()
{
  a_labelName->printSelf();
  printf(",");
  length->printSelf();
  printf(",");
  a_textType->printSelf();
  printf(",");
  a_leftRight->printSelf();
}

labelName * textQueryFormat::get_labelName()
{ return a_labelName; }
void textQueryFormat::set_labelName(labelName * labelNameIn)
{ a_labelName = labelNameIn; }
intVal * textQueryFormat::get_length()
{ return length; }
void textQueryFormat::set_length(intVal * lengthIn)
{ length = lengthIn; }
textType * textQueryFormat::get_textType()
{ return a_textType; }
void textQueryFormat::set_textType(textType * textTypeIn)
{ a_textType = textTypeIn; }
leftRight * textQueryFormat::get_leftRight()
{ return a_leftRight; }
void textQueryFormat::set_leftRight(leftRight * leftRightIn)
{ a_leftRight = leftRightIn; }

/********************************************************************/

textType::textType(){};

textType::~textType(){}

/********************************************************************/

textType_ALPHA::textType_ALPHA(){}

textType_ALPHA::~textType_ALPHA(){}

void textType_ALPHA::printSelf()
{
  printf("ALPHA");
}

/********************************************************************/

textType_NUMERIC::textType_NUMERIC(){}

textType_NUMERIC::~textType_NUMERIC(){}

void textType_NUMERIC::printSelf()
{
  printf("NUMERIC");
}

/********************************************************************/

textType_PRNTCHAR::textType_PRNTCHAR(){}

textType_PRNTCHAR::~textType_PRNTCHAR(){}

void textType_PRNTCHAR::printSelf()
{
  printf("PRNTCHAR");
}

/********************************************************************/

thldefStm::thldefStm(){}

thldefStm::thldefStm(
  thLabel * thLabelIn,
  std::list<thldefPocket *> * thldefPocketListIn)
{
  a_thLabel = thLabelIn;
  a_thldefPocketList = thldefPocketListIn;
}

thldefStm::~thldefStm(){}

void thldefStm::printSelf()
{
  a_thLabel->printSelf();
  printf("=");
  printf("THLDEF");
  printf("/");
  if (a_thldefPocketList->begin() == a_thldefPocketList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<thldefPocket *>::iterator iter;
      for (iter = a_thldefPocketList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_thldefPocketList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

thLabel * thldefStm::get_thLabel()
{ return a_thLabel; }
void thldefStm::set_thLabel(thLabel * thLabelIn)
{ a_thLabel = thLabelIn; }
std::list<thldefPocket *> * thldefStm::get_thldefPocketList()
{ return a_thldefPocketList; }
void thldefStm::set_thldefPocketList(std::list<thldefPocket *> * thldefPocketListIn)
{ a_thldefPocketList = thldefPocketListIn; }

/********************************************************************/

thldefPocket::thldefPocket(){};

thldefPocket::~thldefPocket(){}

/********************************************************************/

thldefPocket_sLabel::thldefPocket_sLabel(){}

thldefPocket_sLabel::thldefPocket_sLabel(
  sLabel * sLabelIn,
  intVal * pocketIn)
{
  a_sLabel = sLabelIn;
  pocket = pocketIn;
}

thldefPocket_sLabel::~thldefPocket_sLabel(){}

void thldefPocket_sLabel::printSelf()
{
  a_sLabel->printSelf();
  printf(",");
  pocket->printSelf();
}

sLabel * thldefPocket_sLabel::get_sLabel()
{ return a_sLabel; }
void thldefPocket_sLabel::set_sLabel(sLabel * sLabelIn)
{ a_sLabel = sLabelIn; }
intVal * thldefPocket_sLabel::get_pocket()
{ return pocket; }
void thldefPocket_sLabel::set_pocket(intVal * pocketIn)
{ pocket = pocketIn; }

/********************************************************************/

thldefPocket_ssLabel::thldefPocket_ssLabel(){}

thldefPocket_ssLabel::thldefPocket_ssLabel(
  ssLabel * ssLabelIn,
  intVal * pocketIn)
{
  a_ssLabel = ssLabelIn;
  pocket = pocketIn;
}

thldefPocket_ssLabel::~thldefPocket_ssLabel(){}

void thldefPocket_ssLabel::printSelf()
{
  a_ssLabel->printSelf();
  printf(",");
  pocket->printSelf();
}

ssLabel * thldefPocket_ssLabel::get_ssLabel()
{ return a_ssLabel; }
void thldefPocket_ssLabel::set_ssLabel(ssLabel * ssLabelIn)
{ a_ssLabel = ssLabelIn; }
intVal * thldefPocket_ssLabel::get_pocket()
{ return pocket; }
void thldefPocket_ssLabel::set_pocket(intVal * pocketIn)
{ pocket = pocketIn; }

/********************************************************************/

thldefPocket_sgsLabel::thldefPocket_sgsLabel(){}

thldefPocket_sgsLabel::thldefPocket_sgsLabel(
  sgsLabel * sgsLabelIn,
  intVal * pocketIn)
{
  a_sgsLabel = sgsLabelIn;
  pocket = pocketIn;
}

thldefPocket_sgsLabel::~thldefPocket_sgsLabel(){}

void thldefPocket_sgsLabel::printSelf()
{
  a_sgsLabel->printSelf();
  printf(",");
  pocket->printSelf();
}

sgsLabel * thldefPocket_sgsLabel::get_sgsLabel()
{ return a_sgsLabel; }
void thldefPocket_sgsLabel::set_sgsLabel(sgsLabel * sgsLabelIn)
{ a_sgsLabel = sgsLabelIn; }
intVal * thldefPocket_sgsLabel::get_pocket()
{ return pocket; }
void thldefPocket_sgsLabel::set_pocket(intVal * pocketIn)
{ pocket = pocketIn; }

/********************************************************************/

thldefPocket_sgLabel::thldefPocket_sgLabel(){}

thldefPocket_sgLabel::thldefPocket_sgLabel(
  sgLabel * sgLabelIn,
  intVal * pocketIn)
{
  a_sgLabel = sgLabelIn;
  pocket = pocketIn;
}

thldefPocket_sgLabel::~thldefPocket_sgLabel(){}

void thldefPocket_sgLabel::printSelf()
{
  a_sgLabel->printSelf();
  printf(",");
  pocket->printSelf();
}

sgLabel * thldefPocket_sgLabel::get_sgLabel()
{ return a_sgLabel; }
void thldefPocket_sgLabel::set_sgLabel(sgLabel * sgLabelIn)
{ a_sgLabel = sgLabelIn; }
intVal * thldefPocket_sgLabel::get_pocket()
{ return pocket; }
void thldefPocket_sgLabel::set_pocket(intVal * pocketIn)
{ pocket = pocketIn; }

/********************************************************************/

thldefPocket_swLabel::thldefPocket_swLabel(){}

thldefPocket_swLabel::thldefPocket_swLabel(
  swLabel * swLabelIn,
  intVal * pocketIn)
{
  a_swLabel = swLabelIn;
  pocket = pocketIn;
}

thldefPocket_swLabel::~thldefPocket_swLabel(){}

void thldefPocket_swLabel::printSelf()
{
  a_swLabel->printSelf();
  printf(",");
  pocket->printSelf();
}

swLabel * thldefPocket_swLabel::get_swLabel()
{ return a_swLabel; }
void thldefPocket_swLabel::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
intVal * thldefPocket_swLabel::get_pocket()
{ return pocket; }
void thldefPocket_swLabel::set_pocket(intVal * pocketIn)
{ pocket = pocketIn; }

/********************************************************************/

thldefPocket_sxLabel::thldefPocket_sxLabel(){}

thldefPocket_sxLabel::thldefPocket_sxLabel(
  sxLabel * sxLabelIn,
  intVal * pocketIn)
{
  a_sxLabel = sxLabelIn;
  pocket = pocketIn;
}

thldefPocket_sxLabel::~thldefPocket_sxLabel(){}

void thldefPocket_sxLabel::printSelf()
{
  a_sxLabel->printSelf();
  printf(",");
  pocket->printSelf();
}

sxLabel * thldefPocket_sxLabel::get_sxLabel()
{ return a_sxLabel; }
void thldefPocket_sxLabel::set_sxLabel(sxLabel * sxLabelIn)
{ a_sxLabel = sxLabelIn; }
intVal * thldefPocket_sxLabel::get_pocket()
{ return pocket; }
void thldefPocket_sxLabel::set_pocket(intVal * pocketIn)
{ pocket = pocketIn; }

/********************************************************************/

thldefPocket_rmLabel::thldefPocket_rmLabel(){}

thldefPocket_rmLabel::thldefPocket_rmLabel(
  rmLabel * rmLabelIn,
  intVal * pocketIn)
{
  a_rmLabel = rmLabelIn;
  pocket = pocketIn;
}

thldefPocket_rmLabel::~thldefPocket_rmLabel(){}

void thldefPocket_rmLabel::printSelf()
{
  a_rmLabel->printSelf();
  printf(",");
  pocket->printSelf();
}

rmLabel * thldefPocket_rmLabel::get_rmLabel()
{ return a_rmLabel; }
void thldefPocket_rmLabel::set_rmLabel(rmLabel * rmLabelIn)
{ a_rmLabel = rmLabelIn; }
intVal * thldefPocket_rmLabel::get_pocket()
{ return pocket; }
void thldefPocket_rmLabel::set_pocket(intVal * pocketIn)
{ pocket = pocketIn; }

/********************************************************************/

tolAnglStm::tolAnglStm(){}

tolAnglStm::tolAnglStm(
  tLabel * tLabelIn,
  angle * lotolIn,
  angle * uptolIn)
{
  a_tLabel = tLabelIn;
  lotol = lotolIn;
  uptol = uptolIn;
}

tolAnglStm::~tolAnglStm(){}

void tolAnglStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("ANGL");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolAnglStm::get_tLabel()
{ return a_tLabel; }
void tolAnglStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
angle * tolAnglStm::get_lotol()
{ return lotol; }
void tolAnglStm::set_lotol(angle * lotolIn)
{ lotol = lotolIn; }
angle * tolAnglStm::get_uptol()
{ return uptol; }
void tolAnglStm::set_uptol(angle * uptolIn)
{ uptol = uptolIn; }

/********************************************************************/

tolAnglbStm::tolAnglbStm(){}

tolAnglbStm::tolAnglbStm(
  tLabel * tLabelIn,
  angle * angIn,
  angle * lotolIn,
  angle * uptolIn,
  tolZoneDir2 * tolZoneDir2In)
{
  a_tLabel = tLabelIn;
  ang = angIn;
  lotol = lotolIn;
  uptol = uptolIn;
  a_tolZoneDir2 = tolZoneDir2In;
}

tolAnglbStm::~tolAnglbStm(){}

void tolAnglbStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("ANGLB");
  printf(",");
  ang->printSelf();
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (a_tolZoneDir2)
    {
      printf(",");
      a_tolZoneDir2->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolAnglbStm::get_tLabel()
{ return a_tLabel; }
void tolAnglbStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
angle * tolAnglbStm::get_ang()
{ return ang; }
void tolAnglbStm::set_ang(angle * angIn)
{ ang = angIn; }
angle * tolAnglbStm::get_lotol()
{ return lotol; }
void tolAnglbStm::set_lotol(angle * lotolIn)
{ lotol = lotolIn; }
angle * tolAnglbStm::get_uptol()
{ return uptol; }
void tolAnglbStm::set_uptol(angle * uptolIn)
{ uptol = uptolIn; }
tolZoneDir2 * tolAnglbStm::get_tolZoneDir2()
{ return a_tolZoneDir2; }
void tolAnglbStm::set_tolZoneDir2(tolZoneDir2 * tolZoneDir2In)
{ a_tolZoneDir2 = tolZoneDir2In; }

/********************************************************************/

tolZoneDir2::tolZoneDir2(){};

tolZoneDir2::~tolZoneDir2(){}

/********************************************************************/

tolZoneDir2_XYPLAN::tolZoneDir2_XYPLAN(){}

tolZoneDir2_XYPLAN::~tolZoneDir2_XYPLAN(){}

void tolZoneDir2_XYPLAN::printSelf()
{
  printf("XYPLAN");
}

/********************************************************************/

tolZoneDir2_YZPLAN::tolZoneDir2_YZPLAN(){}

tolZoneDir2_YZPLAN::~tolZoneDir2_YZPLAN(){}

void tolZoneDir2_YZPLAN::printSelf()
{
  printf("YZPLAN");
}

/********************************************************************/

tolZoneDir2_ZXPLAN::tolZoneDir2_ZXPLAN(){}

tolZoneDir2_ZXPLAN::~tolZoneDir2_ZXPLAN(){}

void tolZoneDir2_ZXPLAN::printSelf()
{
  printf("ZXPLAN");
}

/********************************************************************/

tolZoneDir2_VEC::tolZoneDir2_VEC(){}

tolZoneDir2_VEC::tolZoneDir2_VEC(
  vector * planeVecIn)
{
  planeVec = planeVecIn;
}

tolZoneDir2_VEC::~tolZoneDir2_VEC(){}

void tolZoneDir2_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  planeVec->printSelf();
}

vector * tolZoneDir2_VEC::get_planeVec()
{ return planeVec; }
void tolZoneDir2_VEC::set_planeVec(vector * planeVecIn)
{ planeVec = planeVecIn; }

/********************************************************************/

tolAnglwrtStm::tolAnglwrtStm(){}

tolAnglwrtStm::tolAnglwrtStm(
  tLabel * tLabelIn,
  angle * angIn,
  angle * lotolIn,
  angle * uptolIn,
  tolFeature * tolFeatureIn,
  tolZoneDir2 * tolZoneDir2In)
{
  a_tLabel = tLabelIn;
  ang = angIn;
  lotol = lotolIn;
  uptol = uptolIn;
  a_tolFeature = tolFeatureIn;
  a_tolZoneDir2 = tolZoneDir2In;
}

tolAnglwrtStm::~tolAnglwrtStm(){}

void tolAnglwrtStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("ANGLWRT");
  printf(",");
  ang->printSelf();
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  printf(",");
  a_tolFeature->printSelf();
  if (a_tolZoneDir2)
    {
      printf(",");
      a_tolZoneDir2->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolAnglwrtStm::get_tLabel()
{ return a_tLabel; }
void tolAnglwrtStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
angle * tolAnglwrtStm::get_ang()
{ return ang; }
void tolAnglwrtStm::set_ang(angle * angIn)
{ ang = angIn; }
angle * tolAnglwrtStm::get_lotol()
{ return lotol; }
void tolAnglwrtStm::set_lotol(angle * lotolIn)
{ lotol = lotolIn; }
angle * tolAnglwrtStm::get_uptol()
{ return uptol; }
void tolAnglwrtStm::set_uptol(angle * uptolIn)
{ uptol = uptolIn; }
tolFeature * tolAnglwrtStm::get_tolFeature()
{ return a_tolFeature; }
void tolAnglwrtStm::set_tolFeature(tolFeature * tolFeatureIn)
{ a_tolFeature = tolFeatureIn; }
tolZoneDir2 * tolAnglwrtStm::get_tolZoneDir2()
{ return a_tolZoneDir2; }
void tolAnglwrtStm::set_tolZoneDir2(tolZoneDir2 * tolZoneDir2In)
{ a_tolZoneDir2 = tolZoneDir2In; }

/********************************************************************/

tolAnglrStm::tolAnglrStm(){}

tolAnglrStm::tolAnglrStm(
  tLabel * tLabelIn,
  angle * angleIn,
  tolAppData * tolAppDataIn)
{
  a_tLabel = tLabelIn;
  a_angle = angleIn;
  a_tolAppData = tolAppDataIn;
}

tolAnglrStm::~tolAnglrStm(){}

void tolAnglrStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("ANGLR");
  printf(",");
  a_angle->printSelf();
  printf(",");
  a_tolAppData->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolAnglrStm::get_tLabel()
{ return a_tLabel; }
void tolAnglrStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
angle * tolAnglrStm::get_angle()
{ return a_angle; }
void tolAnglrStm::set_angle(angle * angleIn)
{ a_angle = angleIn; }
tolAppData * tolAnglrStm::get_tolAppData()
{ return a_tolAppData; }
void tolAnglrStm::set_tolAppData(tolAppData * tolAppDataIn)
{ a_tolAppData = tolAppDataIn; }

/********************************************************************/

tolCirltyStm::tolCirltyStm(){}

tolCirltyStm::tolCirltyStm(
  tLabel * tLabelIn,
  rentVal * tolzonIn)
{
  a_tLabel = tLabelIn;
  tolzon = tolzonIn;
}

tolCirltyStm::~tolCirltyStm(){}

void tolCirltyStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("CIRLTY");
  printf(",");
  tolzon->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolCirltyStm::get_tLabel()
{ return a_tLabel; }
void tolCirltyStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolCirltyStm::get_tolzon()
{ return tolzon; }
void tolCirltyStm::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }

/********************************************************************/

tolCompos1::tolCompos1(){}

tolCompos1::tolCompos1(
  rentVal * tolzon1In,
  tolMatCond * tolMatCondIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In)
{
  tolzon1 = tolzon1In;
  a_tolMatCond = tolMatCondIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
}

tolCompos1::~tolCompos1(){}

void tolCompos1::printSelf()
{
  tolzon1->printSelf();
  if (a_tolMatCond)
    {
      printf(",");
      a_tolMatCond->printSelf();
    }
  printf(",");
  tfm1->printSelf();
  if (tfm2)
    {
      printf(",");
      tfm2->printSelf();
      if (tfm3)
        {
          printf(",");
          tfm3->printSelf();
        }
    }
}

rentVal * tolCompos1::get_tolzon1()
{ return tolzon1; }
void tolCompos1::set_tolzon1(rentVal * tolzon1In)
{ tolzon1 = tolzon1In; }
tolMatCond * tolCompos1::get_tolMatCond()
{ return a_tolMatCond; }
void tolCompos1::set_tolMatCond(tolMatCond * tolMatCondIn)
{ a_tolMatCond = tolMatCondIn; }
tolFeatureMat * tolCompos1::get_tfm1()
{ return tfm1; }
void tolCompos1::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolCompos1::get_tfm2()
{ return tfm2; }
void tolCompos1::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolCompos1::get_tfm3()
{ return tfm3; }
void tolCompos1::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }

/********************************************************************/

tolCompos2::tolCompos2(){}

tolCompos2::tolCompos2(
  rentVal * tolzon2In,
  tolMatCond * tolMatCondIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In)
{
  tolzon2 = tolzon2In;
  a_tolMatCond = tolMatCondIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
}

tolCompos2::~tolCompos2(){}

void tolCompos2::printSelf()
{
  tolzon2->printSelf();
  if (a_tolMatCond)
    {
      printf(",");
      a_tolMatCond->printSelf();
    }
  if (tfm1)
    {
      printf(",");
      tfm1->printSelf();
      if (tfm2)
        {
          printf(",");
          tfm2->printSelf();
          if (tfm3)
            {
              printf(",");
              tfm3->printSelf();
            }
        }
    }
}

rentVal * tolCompos2::get_tolzon2()
{ return tolzon2; }
void tolCompos2::set_tolzon2(rentVal * tolzon2In)
{ tolzon2 = tolzon2In; }
tolMatCond * tolCompos2::get_tolMatCond()
{ return a_tolMatCond; }
void tolCompos2::set_tolMatCond(tolMatCond * tolMatCondIn)
{ a_tolMatCond = tolMatCondIn; }
tolFeatureMat * tolCompos2::get_tfm1()
{ return tfm1; }
void tolCompos2::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolCompos2::get_tfm2()
{ return tfm2; }
void tolCompos2::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolCompos2::get_tfm3()
{ return tfm3; }
void tolCompos2::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }

/********************************************************************/

tolComposStm::tolComposStm(){}

tolComposStm::tolComposStm(
  tLabel * tLabelIn,
  tolCompos1 * tolCompos1In,
  tolCompos2 * tolCompos2In)
{
  a_tLabel = tLabelIn;
  a_tolCompos1 = tolCompos1In;
  a_tolCompos2 = tolCompos2In;
}

tolComposStm::~tolComposStm(){}

void tolComposStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("COMPOS");
  printf(",");
  printf("PATERN");
  printf(",");
  a_tolCompos1->printSelf();
  printf(",");
  printf("FEATUR");
  printf(",");
  a_tolCompos2->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolComposStm::get_tLabel()
{ return a_tLabel; }
void tolComposStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolCompos1 * tolComposStm::get_tolCompos1()
{ return a_tolCompos1; }
void tolComposStm::set_tolCompos1(tolCompos1 * tolCompos1In)
{ a_tolCompos1 = tolCompos1In; }
tolCompos2 * tolComposStm::get_tolCompos2()
{ return a_tolCompos2; }
void tolComposStm::set_tolCompos2(tolCompos2 * tolCompos2In)
{ a_tolCompos2 = tolCompos2In; }

/********************************************************************/

tolFeatureMat::tolFeatureMat(){};

tolFeatureMat::~tolFeatureMat(){}

/********************************************************************/

tolFeatureMat_datLabel::tolFeatureMat_datLabel(){}

tolFeatureMat_datLabel::tolFeatureMat_datLabel(
  datLabel * datLabelIn,
  tolMatCond * tolMatCondIn)
{
  a_datLabel = datLabelIn;
  a_tolMatCond = tolMatCondIn;
}

tolFeatureMat_datLabel::~tolFeatureMat_datLabel(){}

void tolFeatureMat_datLabel::printSelf()
{
  a_datLabel->printSelf();
  if (a_tolMatCond)
    {
      printf(",");
      a_tolMatCond->printSelf();
    }
}

datLabel * tolFeatureMat_datLabel::get_datLabel()
{ return a_datLabel; }
void tolFeatureMat_datLabel::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
tolMatCond * tolFeatureMat_datLabel::get_tolMatCond()
{ return a_tolMatCond; }
void tolFeatureMat_datLabel::set_tolMatCond(tolMatCond * tolMatCondIn)
{ a_tolMatCond = tolMatCondIn; }

/********************************************************************/

tolFeatureMat_faLabel::tolFeatureMat_faLabel(){}

tolFeatureMat_faLabel::tolFeatureMat_faLabel(
  faLabel * faLabelIn,
  tolMatCond * tolMatCondIn)
{
  a_faLabel = faLabelIn;
  a_tolMatCond = tolMatCondIn;
}

tolFeatureMat_faLabel::~tolFeatureMat_faLabel(){}

void tolFeatureMat_faLabel::printSelf()
{
  a_faLabel->printSelf();
  if (a_tolMatCond)
    {
      printf(",");
      a_tolMatCond->printSelf();
    }
}

faLabel * tolFeatureMat_faLabel::get_faLabel()
{ return a_faLabel; }
void tolFeatureMat_faLabel::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
tolMatCond * tolFeatureMat_faLabel::get_tolMatCond()
{ return a_tolMatCond; }
void tolFeatureMat_faLabel::set_tolMatCond(tolMatCond * tolMatCondIn)
{ a_tolMatCond = tolMatCondIn; }

/********************************************************************/

tolFeatureMat_fLabel::tolFeatureMat_fLabel(){}

tolFeatureMat_fLabel::tolFeatureMat_fLabel(
  fLabel * fLabelIn)
{
  a_fLabel = fLabelIn;
}

tolFeatureMat_fLabel::~tolFeatureMat_fLabel(){}

void tolFeatureMat_fLabel::printSelf()
{
  a_fLabel->printSelf();
}

fLabel * tolFeatureMat_fLabel::get_fLabel()
{ return a_fLabel; }
void tolFeatureMat_fLabel::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }

/********************************************************************/

tolConcenStm::tolConcenStm(){}

tolConcenStm::tolConcenStm(
  tLabel * tLabelIn,
  rentVal * tolzonIn,
  tolFeature * tolFeatureIn)
{
  a_tLabel = tLabelIn;
  tolzon = tolzonIn;
  a_tolFeature = tolFeatureIn;
}

tolConcenStm::~tolConcenStm(){}

void tolConcenStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("CONCEN");
  printf(",");
  tolzon->printSelf();
  printf(",");
  a_tolFeature->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolConcenStm::get_tLabel()
{ return a_tLabel; }
void tolConcenStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolConcenStm::get_tolzon()
{ return tolzon; }
void tolConcenStm::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
tolFeature * tolConcenStm::get_tolFeature()
{ return a_tolFeature; }
void tolConcenStm::set_tolFeature(tolFeature * tolFeatureIn)
{ a_tolFeature = tolFeatureIn; }

/********************************************************************/

tolCortolStm::tolCortolStm(){}

tolCortolStm::tolCortolStm(
  tLabel * tLabelIn,
  tolCortolMinor * tolCortolMinorIn)
{
  a_tLabel = tLabelIn;
  a_tolCortolMinor = tolCortolMinorIn;
}

tolCortolStm::~tolCortolStm(){}

void tolCortolStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("CORTOL");
  printf(",");
  a_tolCortolMinor->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolCortolStm::get_tLabel()
{ return a_tLabel; }
void tolCortolStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolCortolMinor * tolCortolStm::get_tolCortolMinor()
{ return a_tolCortolMinor; }
void tolCortolStm::set_tolCortolMinor(tolCortolMinor * tolCortolMinorIn)
{ a_tolCortolMinor = tolCortolMinorIn; }

/********************************************************************/

tolCortolMinor::tolCortolMinor(){};

tolCortolMinor::~tolCortolMinor(){}

/********************************************************************/

tolCortolAxis::tolCortolAxis(){}

tolCortolAxis::tolCortolAxis(
  axis * axisIn,
  rentVal * lotolIn,
  rentVal * uptolIn,
  axial * axialIn)
{
  a_axis = axisIn;
  lotol = lotolIn;
  uptol = uptolIn;
  a_axial = axialIn;
}

tolCortolAxis::~tolCortolAxis(){}

void tolCortolAxis::printSelf()
{
  a_axis->printSelf();
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (a_axial)
    {
      printf(",");
      a_axial->printSelf();
    }
}

axis * tolCortolAxis::get_axis()
{ return a_axis; }
void tolCortolAxis::set_axis(axis * axisIn)
{ a_axis = axisIn; }
rentVal * tolCortolAxis::get_lotol()
{ return lotol; }
void tolCortolAxis::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolCortolAxis::get_uptol()
{ return uptol; }
void tolCortolAxis::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
axial * tolCortolAxis::get_axial()
{ return a_axial; }
void tolCortolAxis::set_axial(axial * axialIn)
{ a_axial = axialIn; }

/********************************************************************/

tolCortolRadial::tolCortolRadial(){}

tolCortolRadial::tolCortolRadial(
  rentVal * lotolIn,
  rentVal * uptolIn)
{
  lotol = lotolIn;
  uptol = uptolIn;
}

tolCortolRadial::~tolCortolRadial(){}

void tolCortolRadial::printSelf()
{
  printf("RADIAL");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
}

rentVal * tolCortolRadial::get_lotol()
{ return lotol; }
void tolCortolRadial::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolCortolRadial::get_uptol()
{ return uptol; }
void tolCortolRadial::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }

/********************************************************************/

tolCortolAngle::tolCortolAngle(){}

tolCortolAngle::tolCortolAngle(
  rentVal * lotolIn,
  rentVal * uptolIn)
{
  lotol = lotolIn;
  uptol = uptolIn;
}

tolCortolAngle::~tolCortolAngle(){}

void tolCortolAngle::printSelf()
{
  printf("ANGLE");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
}

rentVal * tolCortolAngle::get_lotol()
{ return lotol; }
void tolCortolAngle::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolCortolAngle::get_uptol()
{ return uptol; }
void tolCortolAngle::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }

/********************************************************************/

axial::axial(){}

axial::axial(
  featureLabel * featureLabelIn,
  rentVal * distIn)
{
  a_featureLabel = featureLabelIn;
  dist = distIn;
}

axial::~axial(){}

void axial::printSelf()
{
  printf("AXIAL");
  printf(",");
  a_featureLabel->printSelf();
  if (dist)
    {
      printf(",");
      dist->printSelf();
    }
}

featureLabel * axial::get_featureLabel()
{ return a_featureLabel; }
void axial::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
rentVal * axial::get_dist()
{ return dist; }
void axial::set_dist(rentVal * distIn)
{ dist = distIn; }

/********************************************************************/

tolCproflStm::tolCproflStm(){}

tolCproflStm::tolCproflStm(
  tLabel * tLabelIn,
  tolCprofSpecC * upperIn,
  tolCprofSpec * lowerIn)
{
  a_tLabel = tLabelIn;
  upper = upperIn;
  lower = lowerIn;
}

tolCproflStm::~tolCproflStm(){}

void tolCproflStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("CPROFL");
  printf(",");
  upper->printSelf();
  lower->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolCproflStm::get_tLabel()
{ return a_tLabel; }
void tolCproflStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolCprofSpecC * tolCproflStm::get_upper()
{ return upper; }
void tolCproflStm::set_upper(tolCprofSpecC * upperIn)
{ upper = upperIn; }
tolCprofSpec * tolCproflStm::get_lower()
{ return lower; }
void tolCproflStm::set_lower(tolCprofSpec * lowerIn)
{ lower = lowerIn; }

/********************************************************************/

tolCprofsStm::tolCprofsStm(){}

tolCprofsStm::tolCprofsStm(
  tLabel * tLabelIn,
  tolCprofSpecC * upperIn,
  tolCprofSpec * lowerIn)
{
  a_tLabel = tLabelIn;
  upper = upperIn;
  lower = lowerIn;
}

tolCprofsStm::~tolCprofsStm(){}

void tolCprofsStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("CPROFS");
  printf(",");
  upper->printSelf();
  lower->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolCprofsStm::get_tLabel()
{ return a_tLabel; }
void tolCprofsStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolCprofSpecC * tolCprofsStm::get_upper()
{ return upper; }
void tolCprofsStm::set_upper(tolCprofSpecC * upperIn)
{ upper = upperIn; }
tolCprofSpec * tolCprofsStm::get_lower()
{ return lower; }
void tolCprofsStm::set_lower(tolCprofSpec * lowerIn)
{ lower = lowerIn; }

/********************************************************************/

tolCprofSpec::tolCprofSpec(){}

tolCprofSpec::tolCprofSpec(
  rentVal * lotolIn,
  rentVal * uptolIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In,
  bool has_AVGDEVIn)
{
  lotol = lotolIn;
  uptol = uptolIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
  has_AVGDEV = has_AVGDEVIn;
}

tolCprofSpec::~tolCprofSpec(){}

void tolCprofSpec::printSelf()
{
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (tfm1)
    {
      printf(",");
      tfm1->printSelf();
      if (tfm2)
        {
          printf(",");
          tfm2->printSelf();
          if (tfm3)
            {
              printf(",");
              tfm3->printSelf();
            }
        }
    }
  if (has_AVGDEV == true)
    {
      printf(",");
      printf("AVGDEV");
    }
}

rentVal * tolCprofSpec::get_lotol()
{ return lotol; }
void tolCprofSpec::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolCprofSpec::get_uptol()
{ return uptol; }
void tolCprofSpec::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
tolFeatureMat * tolCprofSpec::get_tfm1()
{ return tfm1; }
void tolCprofSpec::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolCprofSpec::get_tfm2()
{ return tfm2; }
void tolCprofSpec::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolCprofSpec::get_tfm3()
{ return tfm3; }
void tolCprofSpec::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }
bool tolCprofSpec::get_has_AVGDEV()
{ return has_AVGDEV; }
void tolCprofSpec::set_has_AVGDEV(bool has_AVGDEVIn)
{ has_AVGDEV = has_AVGDEVIn; }

/********************************************************************/

tolCprofSpecC::tolCprofSpecC(){}

tolCprofSpecC::tolCprofSpecC(
  rentVal * lotolIn,
  rentVal * uptolIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In,
  bool has_AVGDEVIn)
{
  lotol = lotolIn;
  uptol = uptolIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
  has_AVGDEV = has_AVGDEVIn;
}

tolCprofSpecC::~tolCprofSpecC(){}

void tolCprofSpecC::printSelf()
{
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (tfm1)
    {
      printf(",");
      tfm1->printSelf();
      if (tfm2)
        {
          printf(",");
          tfm2->printSelf();
          if (tfm3)
            {
              printf(",");
              tfm3->printSelf();
            }
        }
    }
  if (has_AVGDEV == true)
    {
      printf(",");
      printf("AVGDEV");
    }
  printf(",");
}

rentVal * tolCprofSpecC::get_lotol()
{ return lotol; }
void tolCprofSpecC::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolCprofSpecC::get_uptol()
{ return uptol; }
void tolCprofSpecC::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
tolFeatureMat * tolCprofSpecC::get_tfm1()
{ return tfm1; }
void tolCprofSpecC::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolCprofSpecC::get_tfm2()
{ return tfm2; }
void tolCprofSpecC::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolCprofSpecC::get_tfm3()
{ return tfm3; }
void tolCprofSpecC::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }
bool tolCprofSpecC::get_has_AVGDEV()
{ return has_AVGDEV; }
void tolCprofSpecC::set_has_AVGDEV(bool has_AVGDEVIn)
{ has_AVGDEV = has_AVGDEVIn; }

/********************************************************************/

tolCrnoutStm::tolCrnoutStm(){}

tolCrnoutStm::tolCrnoutStm(
  tLabel * tLabelIn,
  rentVal * tolzonIn,
  datLabel * datLabelIn,
  tolFeature * tolFeat1In,
  tolFeature * tolFeat2In,
  vector * dirIn)
{
  a_tLabel = tLabelIn;
  tolzon = tolzonIn;
  a_datLabel = datLabelIn;
  tolFeat1 = tolFeat1In;
  tolFeat2 = tolFeat2In;
  dir = dirIn;
}

tolCrnoutStm::~tolCrnoutStm(){}

void tolCrnoutStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("CRNOUT");
  printf(",");
  tolzon->printSelf();
  printf(",");
  a_datLabel->printSelf();
  if (tolFeat1)
    {
      printf(",");
      tolFeat1->printSelf();
      if (tolFeat2)
        {
          printf(",");
          tolFeat2->printSelf();
        }
    }
  if (dir)
    {
      printf(",");
      printf("VEC");
      printf(",");
      dir->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolCrnoutStm::get_tLabel()
{ return a_tLabel; }
void tolCrnoutStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolCrnoutStm::get_tolzon()
{ return tolzon; }
void tolCrnoutStm::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
datLabel * tolCrnoutStm::get_datLabel()
{ return a_datLabel; }
void tolCrnoutStm::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
tolFeature * tolCrnoutStm::get_tolFeat1()
{ return tolFeat1; }
void tolCrnoutStm::set_tolFeat1(tolFeature * tolFeat1In)
{ tolFeat1 = tolFeat1In; }
tolFeature * tolCrnoutStm::get_tolFeat2()
{ return tolFeat2; }
void tolCrnoutStm::set_tolFeat2(tolFeature * tolFeat2In)
{ tolFeat2 = tolFeat2In; }
vector * tolCrnoutStm::get_dir()
{ return dir; }
void tolCrnoutStm::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

tolCylctyStm::tolCylctyStm(){}

tolCylctyStm::tolCylctyStm(
  tLabel * tLabelIn,
  rentVal * tolzonIn)
{
  a_tLabel = tLabelIn;
  tolzon = tolzonIn;
}

tolCylctyStm::~tolCylctyStm(){}

void tolCylctyStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("CYLCTY");
  printf(",");
  tolzon->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolCylctyStm::get_tLabel()
{ return a_tLabel; }
void tolCylctyStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolCylctyStm::get_tolzon()
{ return tolzon; }
void tolCylctyStm::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }

/********************************************************************/

tolDiamStm::tolDiamStm(){}

tolDiamStm::tolDiamStm(
  tLabel * tLabelIn,
  tolDiamMinor * tolDiamMinorIn)
{
  a_tLabel = tLabelIn;
  a_tolDiamMinor = tolDiamMinorIn;
}

tolDiamStm::~tolDiamStm(){}

void tolDiamStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("DIAM");
  printf(",");
  a_tolDiamMinor->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolDiamStm::get_tLabel()
{ return a_tLabel; }
void tolDiamStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolDiamMinor * tolDiamStm::get_tolDiamMinor()
{ return a_tolDiamMinor; }
void tolDiamStm::set_tolDiamMinor(tolDiamMinor * tolDiamMinorIn)
{ a_tolDiamMinor = tolDiamMinorIn; }

/********************************************************************/

tolDiamMinor::tolDiamMinor(){};

tolDiamMinor::~tolDiamMinor(){}

/********************************************************************/

tolDiamPlain::tolDiamPlain(){}

tolDiamPlain::tolDiamPlain(
  rentVal * lotolIn,
  rentVal * uptolIn,
  radiusSpec * radiusSpecIn)
{
  lotol = lotolIn;
  uptol = uptolIn;
  a_radiusSpec = radiusSpecIn;
}

tolDiamPlain::~tolDiamPlain(){}

void tolDiamPlain::printSelf()
{
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (a_radiusSpec)
    {
      printf(",");
      a_radiusSpec->printSelf();
    }
}

rentVal * tolDiamPlain::get_lotol()
{ return lotol; }
void tolDiamPlain::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolDiamPlain::get_uptol()
{ return uptol; }
void tolDiamPlain::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
radiusSpec * tolDiamPlain::get_radiusSpec()
{ return a_radiusSpec; }
void tolDiamPlain::set_radiusSpec(radiusSpec * radiusSpecIn)
{ a_radiusSpec = radiusSpecIn; }

/********************************************************************/

tolDiamAvg::tolDiamAvg(){}

tolDiamAvg::tolDiamAvg(
  rentVal * lotolIn,
  rentVal * uptolIn,
  radiusSpec * radiusSpecIn)
{
  lotol = lotolIn;
  uptol = uptolIn;
  a_radiusSpec = radiusSpecIn;
}

tolDiamAvg::~tolDiamAvg(){}

void tolDiamAvg::printSelf()
{
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (a_radiusSpec)
    {
      printf(",");
      a_radiusSpec->printSelf();
    }
  printf(",");
  printf("AVG");
}

rentVal * tolDiamAvg::get_lotol()
{ return lotol; }
void tolDiamAvg::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolDiamAvg::get_uptol()
{ return uptol; }
void tolDiamAvg::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
radiusSpec * tolDiamAvg::get_radiusSpec()
{ return a_radiusSpec; }
void tolDiamAvg::set_radiusSpec(radiusSpec * radiusSpecIn)
{ a_radiusSpec = radiusSpecIn; }

/********************************************************************/

tolDiamMinmax::tolDiamMinmax(){}

tolDiamMinmax::tolDiamMinmax(
  rentVal * lotolIn,
  rentVal * uptolIn,
  radiusSpec * radiusSpecIn)
{
  lotol = lotolIn;
  uptol = uptolIn;
  a_radiusSpec = radiusSpecIn;
}

tolDiamMinmax::~tolDiamMinmax(){}

void tolDiamMinmax::printSelf()
{
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (a_radiusSpec)
    {
      printf(",");
      a_radiusSpec->printSelf();
    }
  printf(",");
  printf("MINMAX");
}

rentVal * tolDiamMinmax::get_lotol()
{ return lotol; }
void tolDiamMinmax::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolDiamMinmax::get_uptol()
{ return uptol; }
void tolDiamMinmax::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
radiusSpec * tolDiamMinmax::get_radiusSpec()
{ return a_radiusSpec; }
void tolDiamMinmax::set_radiusSpec(radiusSpec * radiusSpecIn)
{ a_radiusSpec = radiusSpecIn; }

/********************************************************************/

avgMaxMin::avgMaxMin(){};

avgMaxMin::~avgMaxMin(){}

/********************************************************************/

avgMaxMin_AVG::avgMaxMin_AVG(){}

avgMaxMin_AVG::~avgMaxMin_AVG(){}

void avgMaxMin_AVG::printSelf()
{
  printf(",");
  printf("AVG");
}

/********************************************************************/

avgMaxMin_MAX::avgMaxMin_MAX(){}

avgMaxMin_MAX::~avgMaxMin_MAX(){}

void avgMaxMin_MAX::printSelf()
{
  printf(",");
  printf("MAX");
}

/********************************************************************/

avgMaxMin_MIN::avgMaxMin_MIN(){}

avgMaxMin_MIN::~avgMaxMin_MIN(){}

void avgMaxMin_MIN::printSelf()
{
  printf(",");
  printf("MIN");
}

/********************************************************************/

tolDistbStm::tolDistbStm(){}

tolDistbStm::tolDistbStm(
  tLabel * tLabelIn,
  tolDistbTol * tolDistbTolIn,
  tolDistbDir * tolDistbDirIn,
  avgMaxMin * avgMaxMinIn)
{
  a_tLabel = tLabelIn;
  a_tolDistbTol = tolDistbTolIn;
  a_tolDistbDir = tolDistbDirIn;
  a_avgMaxMin = avgMaxMinIn;
}

tolDistbStm::~tolDistbStm(){}

void tolDistbStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("DISTB");
  printf(",");
  a_tolDistbTol->printSelf();
  printf(",");
  a_tolDistbDir->printSelf();
  if (a_avgMaxMin)
    {
      a_avgMaxMin->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolDistbStm::get_tLabel()
{ return a_tLabel; }
void tolDistbStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolDistbTol * tolDistbStm::get_tolDistbTol()
{ return a_tolDistbTol; }
void tolDistbStm::set_tolDistbTol(tolDistbTol * tolDistbTolIn)
{ a_tolDistbTol = tolDistbTolIn; }
tolDistbDir * tolDistbStm::get_tolDistbDir()
{ return a_tolDistbDir; }
void tolDistbStm::set_tolDistbDir(tolDistbDir * tolDistbDirIn)
{ a_tolDistbDir = tolDistbDirIn; }
avgMaxMin * tolDistbStm::get_avgMaxMin()
{ return a_avgMaxMin; }
void tolDistbStm::set_avgMaxMin(avgMaxMin * avgMaxMinIn)
{ a_avgMaxMin = avgMaxMinIn; }

/********************************************************************/

tolDistbDir::tolDistbDir(){};

tolDistbDir::~tolDistbDir(){}

/********************************************************************/

tolDistbDir_XAXIS::tolDistbDir_XAXIS(){}

tolDistbDir_XAXIS::~tolDistbDir_XAXIS(){}

void tolDistbDir_XAXIS::printSelf()
{
  printf("XAXIS");
}

/********************************************************************/

tolDistbDir_YAXIS::tolDistbDir_YAXIS(){}

tolDistbDir_YAXIS::~tolDistbDir_YAXIS(){}

void tolDistbDir_YAXIS::printSelf()
{
  printf("YAXIS");
}

/********************************************************************/

tolDistbDir_ZAXIS::tolDistbDir_ZAXIS(){}

tolDistbDir_ZAXIS::~tolDistbDir_ZAXIS(){}

void tolDistbDir_ZAXIS::printSelf()
{
  printf("ZAXIS");
}

/********************************************************************/

tolDistbDir_PT2PT::tolDistbDir_PT2PT(){}

tolDistbDir_PT2PT::~tolDistbDir_PT2PT(){}

void tolDistbDir_PT2PT::printSelf()
{
  printf("PT2PT");
}

/********************************************************************/

tolDistbTol::tolDistbTol(){};

tolDistbTol::~tolDistbTol(){}

/********************************************************************/

tolDistbLimit::tolDistbLimit(){}

tolDistbLimit::tolDistbLimit(
  rentVal * lolimtIn,
  rentVal * uplimtIn)
{
  lolimt = lolimtIn;
  uplimt = uplimtIn;
}

tolDistbLimit::~tolDistbLimit(){}

void tolDistbLimit::printSelf()
{
  printf("LIMIT");
  printf(",");
  lolimt->printSelf();
  printf(",");
  uplimt->printSelf();
}

rentVal * tolDistbLimit::get_lolimt()
{ return lolimt; }
void tolDistbLimit::set_lolimt(rentVal * lolimtIn)
{ lolimt = lolimtIn; }
rentVal * tolDistbLimit::get_uplimt()
{ return uplimt; }
void tolDistbLimit::set_uplimt(rentVal * uplimtIn)
{ uplimt = uplimtIn; }

/********************************************************************/

tolDistbNominl::tolDistbNominl(){}

tolDistbNominl::tolDistbNominl(
  rentVal * distIn,
  rentVal * lotolIn,
  rentVal * uptolIn)
{
  dist = distIn;
  lotol = lotolIn;
  uptol = uptolIn;
}

tolDistbNominl::~tolDistbNominl(){}

void tolDistbNominl::printSelf()
{
  printf("NOMINL");
  printf(",");
  dist->printSelf();
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
}

rentVal * tolDistbNominl::get_dist()
{ return dist; }
void tolDistbNominl::set_dist(rentVal * distIn)
{ dist = distIn; }
rentVal * tolDistbNominl::get_lotol()
{ return lotol; }
void tolDistbNominl::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolDistbNominl::get_uptol()
{ return uptol; }
void tolDistbNominl::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }

/********************************************************************/

tolDistwrtStm::tolDistwrtStm(){}

tolDistwrtStm::tolDistwrtStm(
  tLabel * tLabelIn,
  tolDistbTol * tolDistbTolIn,
  tolFeature * tolFeatureIn,
  tolDistbDir * tolDistbDirIn,
  avgMaxMin * avgMaxMinIn)
{
  a_tLabel = tLabelIn;
  a_tolDistbTol = tolDistbTolIn;
  a_tolFeature = tolFeatureIn;
  a_tolDistbDir = tolDistbDirIn;
  a_avgMaxMin = avgMaxMinIn;
}

tolDistwrtStm::~tolDistwrtStm(){}

void tolDistwrtStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("DISTWRT");
  printf(",");
  a_tolDistbTol->printSelf();
  printf(",");
  a_tolFeature->printSelf();
  printf(",");
  a_tolDistbDir->printSelf();
  if (a_avgMaxMin)
    {
      a_avgMaxMin->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolDistwrtStm::get_tLabel()
{ return a_tLabel; }
void tolDistwrtStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolDistbTol * tolDistwrtStm::get_tolDistbTol()
{ return a_tolDistbTol; }
void tolDistwrtStm::set_tolDistbTol(tolDistbTol * tolDistbTolIn)
{ a_tolDistbTol = tolDistbTolIn; }
tolFeature * tolDistwrtStm::get_tolFeature()
{ return a_tolFeature; }
void tolDistwrtStm::set_tolFeature(tolFeature * tolFeatureIn)
{ a_tolFeature = tolFeatureIn; }
tolDistbDir * tolDistwrtStm::get_tolDistbDir()
{ return a_tolDistbDir; }
void tolDistwrtStm::set_tolDistbDir(tolDistbDir * tolDistbDirIn)
{ a_tolDistbDir = tolDistbDirIn; }
avgMaxMin * tolDistwrtStm::get_avgMaxMin()
{ return a_avgMaxMin; }
void tolDistwrtStm::set_avgMaxMin(avgMaxMin * avgMaxMinIn)
{ a_avgMaxMin = avgMaxMinIn; }

/********************************************************************/

tolFlatStm::tolFlatStm(){}

tolFlatStm::tolFlatStm(
  tLabel * tLabelIn,
  tolFlatMinor * tolFlatMinorIn)
{
  a_tLabel = tLabelIn;
  a_tolFlatMinor = tolFlatMinorIn;
}

tolFlatStm::~tolFlatStm(){}

void tolFlatStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("FLAT");
  printf(",");
  a_tolFlatMinor->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolFlatStm::get_tLabel()
{ return a_tLabel; }
void tolFlatStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolFlatMinor * tolFlatStm::get_tolFlatMinor()
{ return a_tolFlatMinor; }
void tolFlatStm::set_tolFlatMinor(tolFlatMinor * tolFlatMinorIn)
{ a_tolFlatMinor = tolFlatMinorIn; }

/********************************************************************/

tolFlatMinor::tolFlatMinor(){};

tolFlatMinor::~tolFlatMinor(){}

/********************************************************************/

tolFlatZon::tolFlatZon(){}

tolFlatZon::tolFlatZon(
  rentVal * tolzonIn)
{
  tolzon = tolzonIn;
}

tolFlatZon::~tolFlatZon(){}

void tolFlatZon::printSelf()
{
  tolzon->printSelf();
}

rentVal * tolFlatZon::get_tolzon()
{ return tolzon; }
void tolFlatZon::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }

/********************************************************************/

tolFlatPer::tolFlatPer(){}

tolFlatPer::tolFlatPer(
  rentVal * tolzon1In,
  rentVal * unit1In,
  rentVal * unit2In)
{
  tolzon1 = tolzon1In;
  unit1 = unit1In;
  unit2 = unit2In;
}

tolFlatPer::~tolFlatPer(){}

void tolFlatPer::printSelf()
{
  tolzon1->printSelf();
  printf(",");
  unit1->printSelf();
  printf(",");
  unit2->printSelf();
}

rentVal * tolFlatPer::get_tolzon1()
{ return tolzon1; }
void tolFlatPer::set_tolzon1(rentVal * tolzon1In)
{ tolzon1 = tolzon1In; }
rentVal * tolFlatPer::get_unit1()
{ return unit1; }
void tolFlatPer::set_unit1(rentVal * unit1In)
{ unit1 = unit1In; }
rentVal * tolFlatPer::get_unit2()
{ return unit2; }
void tolFlatPer::set_unit2(rentVal * unit2In)
{ unit2 = unit2In; }

/********************************************************************/

tolFlatZonPer::tolFlatZonPer(){}

tolFlatZonPer::tolFlatZonPer(
  rentVal * tolzonIn,
  rentVal * tolzon1In,
  rentVal * unit1In,
  rentVal * unit2In)
{
  tolzon = tolzonIn;
  tolzon1 = tolzon1In;
  unit1 = unit1In;
  unit2 = unit2In;
}

tolFlatZonPer::~tolFlatZonPer(){}

void tolFlatZonPer::printSelf()
{
  tolzon->printSelf();
  printf(",");
  tolzon1->printSelf();
  printf(",");
  unit1->printSelf();
  printf(",");
  unit2->printSelf();
}

rentVal * tolFlatZonPer::get_tolzon()
{ return tolzon; }
void tolFlatZonPer::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
rentVal * tolFlatZonPer::get_tolzon1()
{ return tolzon1; }
void tolFlatZonPer::set_tolzon1(rentVal * tolzon1In)
{ tolzon1 = tolzon1In; }
rentVal * tolFlatZonPer::get_unit1()
{ return unit1; }
void tolFlatZonPer::set_unit1(rentVal * unit1In)
{ unit1 = unit1In; }
rentVal * tolFlatZonPer::get_unit2()
{ return unit2; }
void tolFlatZonPer::set_unit2(rentVal * unit2In)
{ unit2 = unit2In; }

/********************************************************************/

tolGtolStm::tolGtolStm(){}

tolGtolStm::tolGtolStm(
  tLabel * tLabelIn,
  tolGtolTrans * tolGtolTransIn,
  tolGtolRot * tolGtolRotIn,
  intVal * maxitrIn,
  rentVal * minshfIn,
  angle * maxrotIn,
  tolGtolSpec * tolGtolSpecIn)
{
  a_tLabel = tLabelIn;
  a_tolGtolTrans = tolGtolTransIn;
  a_tolGtolRot = tolGtolRotIn;
  maxitr = maxitrIn;
  minshf = minshfIn;
  maxrot = maxrotIn;
  a_tolGtolSpec = tolGtolSpecIn;
}

tolGtolStm::~tolGtolStm(){}

void tolGtolStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("GTOL");
  printf(",");
  a_tolGtolTrans->printSelf();
  printf(",");
  a_tolGtolRot->printSelf();
  printf(",");
  maxitr->printSelf();
  printf(",");
  minshf->printSelf();
  printf(",");
  maxrot->printSelf();
  if (a_tolGtolSpec)
    {
      printf(",");
      a_tolGtolSpec->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolGtolStm::get_tLabel()
{ return a_tLabel; }
void tolGtolStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolGtolTrans * tolGtolStm::get_tolGtolTrans()
{ return a_tolGtolTrans; }
void tolGtolStm::set_tolGtolTrans(tolGtolTrans * tolGtolTransIn)
{ a_tolGtolTrans = tolGtolTransIn; }
tolGtolRot * tolGtolStm::get_tolGtolRot()
{ return a_tolGtolRot; }
void tolGtolStm::set_tolGtolRot(tolGtolRot * tolGtolRotIn)
{ a_tolGtolRot = tolGtolRotIn; }
intVal * tolGtolStm::get_maxitr()
{ return maxitr; }
void tolGtolStm::set_maxitr(intVal * maxitrIn)
{ maxitr = maxitrIn; }
rentVal * tolGtolStm::get_minshf()
{ return minshf; }
void tolGtolStm::set_minshf(rentVal * minshfIn)
{ minshf = minshfIn; }
angle * tolGtolStm::get_maxrot()
{ return maxrot; }
void tolGtolStm::set_maxrot(angle * maxrotIn)
{ maxrot = maxrotIn; }
tolGtolSpec * tolGtolStm::get_tolGtolSpec()
{ return a_tolGtolSpec; }
void tolGtolStm::set_tolGtolSpec(tolGtolSpec * tolGtolSpecIn)
{ a_tolGtolSpec = tolGtolSpecIn; }

/********************************************************************/

tolGtolTrans::tolGtolTrans(){};

tolGtolTrans::~tolGtolTrans(){}

/********************************************************************/

tolGtolTrans_XDIR::tolGtolTrans_XDIR(){}

tolGtolTrans_XDIR::~tolGtolTrans_XDIR(){}

void tolGtolTrans_XDIR::printSelf()
{
  printf("XDIR");
}

/********************************************************************/

tolGtolTrans_YDIR::tolGtolTrans_YDIR(){}

tolGtolTrans_YDIR::~tolGtolTrans_YDIR(){}

void tolGtolTrans_YDIR::printSelf()
{
  printf("YDIR");
}

/********************************************************************/

tolGtolTrans_ZDIR::tolGtolTrans_ZDIR(){}

tolGtolTrans_ZDIR::~tolGtolTrans_ZDIR(){}

void tolGtolTrans_ZDIR::printSelf()
{
  printf("ZDIR");
}

/********************************************************************/

tolGtolTrans_XYDIR::tolGtolTrans_XYDIR(){}

tolGtolTrans_XYDIR::~tolGtolTrans_XYDIR(){}

void tolGtolTrans_XYDIR::printSelf()
{
  printf("XYDIR");
}

/********************************************************************/

tolGtolTrans_YZDIR::tolGtolTrans_YZDIR(){}

tolGtolTrans_YZDIR::~tolGtolTrans_YZDIR(){}

void tolGtolTrans_YZDIR::printSelf()
{
  printf("YZDIR");
}

/********************************************************************/

tolGtolTrans_ZXDIR::tolGtolTrans_ZXDIR(){}

tolGtolTrans_ZXDIR::~tolGtolTrans_ZXDIR(){}

void tolGtolTrans_ZXDIR::printSelf()
{
  printf("ZXDIR");
}

/********************************************************************/

tolGtolTrans_XYZDIR::tolGtolTrans_XYZDIR(){}

tolGtolTrans_XYZDIR::~tolGtolTrans_XYZDIR(){}

void tolGtolTrans_XYZDIR::printSelf()
{
  printf("XYZDIR");
}

/********************************************************************/

tolGtolTrans_NOTRAN::tolGtolTrans_NOTRAN(){}

tolGtolTrans_NOTRAN::~tolGtolTrans_NOTRAN(){}

void tolGtolTrans_NOTRAN::printSelf()
{
  printf("NOTRAN");
}

/********************************************************************/

tolGtolRot::tolGtolRot(){};

tolGtolRot::~tolGtolRot(){}

/********************************************************************/

tolGtolRot_XAXIS::tolGtolRot_XAXIS(){}

tolGtolRot_XAXIS::~tolGtolRot_XAXIS(){}

void tolGtolRot_XAXIS::printSelf()
{
  printf("XAXIS");
}

/********************************************************************/

tolGtolRot_YAXIS::tolGtolRot_YAXIS(){}

tolGtolRot_YAXIS::~tolGtolRot_YAXIS(){}

void tolGtolRot_YAXIS::printSelf()
{
  printf("YAXIS");
}

/********************************************************************/

tolGtolRot_ZAXIS::tolGtolRot_ZAXIS(){}

tolGtolRot_ZAXIS::~tolGtolRot_ZAXIS(){}

void tolGtolRot_ZAXIS::printSelf()
{
  printf("ZAXIS");
}

/********************************************************************/

tolGtolRot_XYAXIS::tolGtolRot_XYAXIS(){}

tolGtolRot_XYAXIS::~tolGtolRot_XYAXIS(){}

void tolGtolRot_XYAXIS::printSelf()
{
  printf("XYAXIS");
}

/********************************************************************/

tolGtolRot_YZAXIS::tolGtolRot_YZAXIS(){}

tolGtolRot_YZAXIS::~tolGtolRot_YZAXIS(){}

void tolGtolRot_YZAXIS::printSelf()
{
  printf("YZAXIS");
}

/********************************************************************/

tolGtolRot_ZXAXIS::tolGtolRot_ZXAXIS(){}

tolGtolRot_ZXAXIS::~tolGtolRot_ZXAXIS(){}

void tolGtolRot_ZXAXIS::printSelf()
{
  printf("ZXAXIS");
}

/********************************************************************/

tolGtolRot_XYZAXI::tolGtolRot_XYZAXI(){}

tolGtolRot_XYZAXI::~tolGtolRot_XYZAXI(){}

void tolGtolRot_XYZAXI::printSelf()
{
  printf("XYZAXI");
}

/********************************************************************/

tolGtolRot_NOROT::tolGtolRot_NOROT(){}

tolGtolRot_NOROT::~tolGtolRot_NOROT(){}

void tolGtolRot_NOROT::printSelf()
{
  printf("NOROT");
}

/********************************************************************/

tolGtolSpec::tolGtolSpec(){};

tolGtolSpec::~tolGtolSpec(){}

/********************************************************************/

tolGtolSpec_PERCNT::tolGtolSpec_PERCNT(){}

tolGtolSpec_PERCNT::~tolGtolSpec_PERCNT(){}

void tolGtolSpec_PERCNT::printSelf()
{
  printf("PERCNT");
}

/********************************************************************/

tolGtolSpec_INTFPT::tolGtolSpec_INTFPT(){}

tolGtolSpec_INTFPT::~tolGtolSpec_INTFPT(){}

void tolGtolSpec_INTFPT::printSelf()
{
  printf("INTFPT");
}

/********************************************************************/

tolAppData::tolAppData(){}

tolAppData::tolAppData(
  rentVal * tolzonIn,
  tolMaxMatCond * tolMaxMatCondIn,
  tolFeatMaxMat * ref1In,
  tolFeatMaxMat * ref2In,
  tolZoneType * tolZoneTypeIn,
  tolZoneDir * tolZoneDirIn)
{
  tolzon = tolzonIn;
  a_tolMaxMatCond = tolMaxMatCondIn;
  ref1 = ref1In;
  ref2 = ref2In;
  a_tolZoneType = tolZoneTypeIn;
  a_tolZoneDir = tolZoneDirIn;
}

tolAppData::~tolAppData(){}

void tolAppData::printSelf()
{
  tolzon->printSelf();
  if (a_tolMaxMatCond)
    {
      printf(",");
      a_tolMaxMatCond->printSelf();
    }
  printf(",");
  ref1->printSelf();
  if (ref2)
    {
      printf(",");
      ref2->printSelf();
    }
  if (a_tolZoneType)
    {
      printf(",");
      a_tolZoneType->printSelf();
    }
  if (a_tolZoneDir)
    {
      printf(",");
      a_tolZoneDir->printSelf();
    }
}

rentVal * tolAppData::get_tolzon()
{ return tolzon; }
void tolAppData::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
tolMaxMatCond * tolAppData::get_tolMaxMatCond()
{ return a_tolMaxMatCond; }
void tolAppData::set_tolMaxMatCond(tolMaxMatCond * tolMaxMatCondIn)
{ a_tolMaxMatCond = tolMaxMatCondIn; }
tolFeatMaxMat * tolAppData::get_ref1()
{ return ref1; }
void tolAppData::set_ref1(tolFeatMaxMat * ref1In)
{ ref1 = ref1In; }
tolFeatMaxMat * tolAppData::get_ref2()
{ return ref2; }
void tolAppData::set_ref2(tolFeatMaxMat * ref2In)
{ ref2 = ref2In; }
tolZoneType * tolAppData::get_tolZoneType()
{ return a_tolZoneType; }
void tolAppData::set_tolZoneType(tolZoneType * tolZoneTypeIn)
{ a_tolZoneType = tolZoneTypeIn; }
tolZoneDir * tolAppData::get_tolZoneDir()
{ return a_tolZoneDir; }
void tolAppData::set_tolZoneDir(tolZoneDir * tolZoneDirIn)
{ a_tolZoneDir = tolZoneDirIn; }

/********************************************************************/

tolFeatMaxMat::tolFeatMaxMat(){};

tolFeatMaxMat::~tolFeatMaxMat(){}

/********************************************************************/

tolFeatMaxMat_datLabel::tolFeatMaxMat_datLabel(){}

tolFeatMaxMat_datLabel::tolFeatMaxMat_datLabel(
  datLabel * datLabelIn,
  tolMaxMatCond * tolMaxMatCondIn)
{
  a_datLabel = datLabelIn;
  a_tolMaxMatCond = tolMaxMatCondIn;
}

tolFeatMaxMat_datLabel::~tolFeatMaxMat_datLabel(){}

void tolFeatMaxMat_datLabel::printSelf()
{
  a_datLabel->printSelf();
  if (a_tolMaxMatCond)
    {
      printf(",");
      a_tolMaxMatCond->printSelf();
    }
}

datLabel * tolFeatMaxMat_datLabel::get_datLabel()
{ return a_datLabel; }
void tolFeatMaxMat_datLabel::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
tolMaxMatCond * tolFeatMaxMat_datLabel::get_tolMaxMatCond()
{ return a_tolMaxMatCond; }
void tolFeatMaxMat_datLabel::set_tolMaxMatCond(tolMaxMatCond * tolMaxMatCondIn)
{ a_tolMaxMatCond = tolMaxMatCondIn; }

/********************************************************************/

tolFeatMaxMat_faLabel::tolFeatMaxMat_faLabel(){}

tolFeatMaxMat_faLabel::tolFeatMaxMat_faLabel(
  faLabel * faLabelIn,
  tolMaxMatCond * tolMaxMatCondIn)
{
  a_faLabel = faLabelIn;
  a_tolMaxMatCond = tolMaxMatCondIn;
}

tolFeatMaxMat_faLabel::~tolFeatMaxMat_faLabel(){}

void tolFeatMaxMat_faLabel::printSelf()
{
  a_faLabel->printSelf();
  if (a_tolMaxMatCond)
    {
      printf(",");
      a_tolMaxMatCond->printSelf();
    }
}

faLabel * tolFeatMaxMat_faLabel::get_faLabel()
{ return a_faLabel; }
void tolFeatMaxMat_faLabel::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
tolMaxMatCond * tolFeatMaxMat_faLabel::get_tolMaxMatCond()
{ return a_tolMaxMatCond; }
void tolFeatMaxMat_faLabel::set_tolMaxMatCond(tolMaxMatCond * tolMaxMatCondIn)
{ a_tolMaxMatCond = tolMaxMatCondIn; }

/********************************************************************/

tolFeatMaxMat_fLabel::tolFeatMaxMat_fLabel(){}

tolFeatMaxMat_fLabel::tolFeatMaxMat_fLabel(
  fLabel * fLabelIn)
{
  a_fLabel = fLabelIn;
}

tolFeatMaxMat_fLabel::~tolFeatMaxMat_fLabel(){}

void tolFeatMaxMat_fLabel::printSelf()
{
  a_fLabel->printSelf();
}

fLabel * tolFeatMaxMat_fLabel::get_fLabel()
{ return a_fLabel; }
void tolFeatMaxMat_fLabel::set_fLabel(fLabel * fLabelIn)
{ a_fLabel = fLabelIn; }

/********************************************************************/

tolMaxMatCond::tolMaxMatCond(){};

tolMaxMatCond::~tolMaxMatCond(){}

/********************************************************************/

tolMaxMatCond_LMC::tolMaxMatCond_LMC(){}

tolMaxMatCond_LMC::tolMaxMatCond_LMC(
  rentVal * limIn)
{
  lim = limIn;
}

tolMaxMatCond_LMC::~tolMaxMatCond_LMC(){}

void tolMaxMatCond_LMC::printSelf()
{
  printf("LMC");
  if (lim)
    {
      printf(",");
      printf("MAX");
      printf(",");
      lim->printSelf();
    }
}

rentVal * tolMaxMatCond_LMC::get_lim()
{ return lim; }
void tolMaxMatCond_LMC::set_lim(rentVal * limIn)
{ lim = limIn; }

/********************************************************************/

tolMaxMatCond_RFS::tolMaxMatCond_RFS(){}

tolMaxMatCond_RFS::~tolMaxMatCond_RFS(){}

void tolMaxMatCond_RFS::printSelf()
{
  printf("RFS");
}

/********************************************************************/

tolMaxMatCond_MMC::tolMaxMatCond_MMC(){}

tolMaxMatCond_MMC::tolMaxMatCond_MMC(
  rentVal * limIn)
{
  lim = limIn;
}

tolMaxMatCond_MMC::~tolMaxMatCond_MMC(){}

void tolMaxMatCond_MMC::printSelf()
{
  printf("MMC");
  if (lim)
    {
      printf(",");
      printf("MAX");
      printf(",");
      lim->printSelf();
    }
}

rentVal * tolMaxMatCond_MMC::get_lim()
{ return lim; }
void tolMaxMatCond_MMC::set_lim(rentVal * limIn)
{ lim = limIn; }

/********************************************************************/

tolZoneDir::tolZoneDir(){};

tolZoneDir::~tolZoneDir(){}

/********************************************************************/

tolZoneDir_XAXIS::tolZoneDir_XAXIS(){}

tolZoneDir_XAXIS::~tolZoneDir_XAXIS(){}

void tolZoneDir_XAXIS::printSelf()
{
  printf("XAXIS");
}

/********************************************************************/

tolZoneDir_YAXIS::tolZoneDir_YAXIS(){}

tolZoneDir_YAXIS::~tolZoneDir_YAXIS(){}

void tolZoneDir_YAXIS::printSelf()
{
  printf("YAXIS");
}

/********************************************************************/

tolZoneDir_ZAXIS::tolZoneDir_ZAXIS(){}

tolZoneDir_ZAXIS::~tolZoneDir_ZAXIS(){}

void tolZoneDir_ZAXIS::printSelf()
{
  printf("ZAXIS");
}

/********************************************************************/

tolZoneDir_VEC::tolZoneDir_VEC(){}

tolZoneDir_VEC::tolZoneDir_VEC(
  vector * dirIn)
{
  dir = dirIn;
}

tolZoneDir_VEC::~tolZoneDir_VEC(){}

void tolZoneDir_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  dir->printSelf();
}

vector * tolZoneDir_VEC::get_dir()
{ return dir; }
void tolZoneDir_VEC::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

tolParlelStm::tolParlelStm(){}

tolParlelStm::tolParlelStm(
  tLabel * tLabelIn,
  tolAppData * tolAppDataIn)
{
  a_tLabel = tLabelIn;
  a_tolAppData = tolAppDataIn;
}

tolParlelStm::~tolParlelStm(){}

void tolParlelStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("PARLEL");
  printf(",");
  a_tolAppData->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolParlelStm::get_tLabel()
{ return a_tLabel; }
void tolParlelStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolAppData * tolParlelStm::get_tolAppData()
{ return a_tolAppData; }
void tolParlelStm::set_tolAppData(tolAppData * tolAppDataIn)
{ a_tolAppData = tolAppDataIn; }

/********************************************************************/

tolPerpStm::tolPerpStm(){}

tolPerpStm::tolPerpStm(
  tLabel * tLabelIn,
  tolAppData * tolAppDataIn)
{
  a_tLabel = tLabelIn;
  a_tolAppData = tolAppDataIn;
}

tolPerpStm::~tolPerpStm(){}

void tolPerpStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("PERP");
  printf(",");
  a_tolAppData->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolPerpStm::get_tLabel()
{ return a_tLabel; }
void tolPerpStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolAppData * tolPerpStm::get_tolAppData()
{ return a_tolAppData; }
void tolPerpStm::set_tolAppData(tolAppData * tolAppDataIn)
{ a_tolAppData = tolAppDataIn; }

/********************************************************************/

tolPosStm::tolPosStm(){}

tolPosStm::tolPosStm(
  tLabel * tLabelIn,
  tolPosStart * tolPosStartIn,
  tolPosEnd * tolPosEndIn)
{
  a_tLabel = tLabelIn;
  a_tolPosStart = tolPosStartIn;
  a_tolPosEnd = tolPosEndIn;
}

tolPosStm::~tolPosStm(){}

void tolPosStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("POS");
  printf(",");
  a_tolPosStart->printSelf();
  a_tolPosEnd->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolPosStm::get_tLabel()
{ return a_tLabel; }
void tolPosStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolPosStart * tolPosStm::get_tolPosStart()
{ return a_tolPosStart; }
void tolPosStm::set_tolPosStart(tolPosStart * tolPosStartIn)
{ a_tolPosStart = tolPosStartIn; }
tolPosEnd * tolPosStm::get_tolPosEnd()
{ return a_tolPosEnd; }
void tolPosStm::set_tolPosEnd(tolPosEnd * tolPosEndIn)
{ a_tolPosEnd = tolPosEndIn; }

/********************************************************************/

tolPosStart::tolPosStart(){};

tolPosStart::~tolPosStart(){}

/********************************************************************/

tolPosStart_TWOD::tolPosStart_TWOD(){}

tolPosStart_TWOD::tolPosStart_TWOD(
  rentVal * tolzonIn)
{
  tolzon = tolzonIn;
}

tolPosStart_TWOD::~tolPosStart_TWOD(){}

void tolPosStart_TWOD::printSelf()
{
  printf("2D");
  printf(",");
  tolzon->printSelf();
}

rentVal * tolPosStart_TWOD::get_tolzon()
{ return tolzon; }
void tolPosStart_TWOD::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }

/********************************************************************/

tolPosStart_THREED::tolPosStart_THREED(){}

tolPosStart_THREED::tolPosStart_THREED(
  rentVal * tolzonIn)
{
  tolzon = tolzonIn;
}

tolPosStart_THREED::~tolPosStart_THREED(){}

void tolPosStart_THREED::printSelf()
{
  printf("3D");
  printf(",");
  tolzon->printSelf();
}

rentVal * tolPosStart_THREED::get_tolzon()
{ return tolzon; }
void tolPosStart_THREED::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }

/********************************************************************/

tolPosEnd::tolPosEnd(){}

tolPosEnd::tolPosEnd(
  tolMatCond * tolMatCondIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In,
  tolPosMethod * tolPosMethodIn)
{
  a_tolMatCond = tolMatCondIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
  a_tolPosMethod = tolPosMethodIn;
}

tolPosEnd::~tolPosEnd(){}

void tolPosEnd::printSelf()
{
  if (a_tolMatCond)
    {
      printf(",");
      a_tolMatCond->printSelf();
    }
  if (tfm1)
    {
      printf(",");
      tfm1->printSelf();
      if (tfm2)
        {
          printf(",");
          tfm2->printSelf();
          if (tfm3)
            {
              printf(",");
              tfm3->printSelf();
            }
        }
    }
  if (a_tolPosMethod)
    {
      printf(",");
      a_tolPosMethod->printSelf();
    }
}

tolMatCond * tolPosEnd::get_tolMatCond()
{ return a_tolMatCond; }
void tolPosEnd::set_tolMatCond(tolMatCond * tolMatCondIn)
{ a_tolMatCond = tolMatCondIn; }
tolFeatureMat * tolPosEnd::get_tfm1()
{ return tfm1; }
void tolPosEnd::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolPosEnd::get_tfm2()
{ return tfm2; }
void tolPosEnd::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolPosEnd::get_tfm3()
{ return tfm3; }
void tolPosEnd::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }
tolPosMethod * tolPosEnd::get_tolPosMethod()
{ return a_tolPosMethod; }
void tolPosEnd::set_tolPosMethod(tolPosMethod * tolPosMethodIn)
{ a_tolPosMethod = tolPosMethodIn; }

/********************************************************************/

tolPosMethod::tolPosMethod(){};

tolPosMethod::~tolPosMethod(){}

/********************************************************************/

tolPosMethod_XAXIS::tolPosMethod_XAXIS(){}

tolPosMethod_XAXIS::~tolPosMethod_XAXIS(){}

void tolPosMethod_XAXIS::printSelf()
{
  printf("XAXIS");
}

/********************************************************************/

tolPosMethod_YAXIS::tolPosMethod_YAXIS(){}

tolPosMethod_YAXIS::~tolPosMethod_YAXIS(){}

void tolPosMethod_YAXIS::printSelf()
{
  printf("YAXIS");
}

/********************************************************************/

tolPosMethod_ZAXIS::tolPosMethod_ZAXIS(){}

tolPosMethod_ZAXIS::~tolPosMethod_ZAXIS(){}

void tolPosMethod_ZAXIS::printSelf()
{
  printf("ZAXIS");
}

/********************************************************************/

tolPosMethod_RADIAL::tolPosMethod_RADIAL(){}

tolPosMethod_RADIAL::~tolPosMethod_RADIAL(){}

void tolPosMethod_RADIAL::printSelf()
{
  printf("RADIAL");
}

/********************************************************************/

tolPosMethod_ANGLE::tolPosMethod_ANGLE(){}

tolPosMethod_ANGLE::~tolPosMethod_ANGLE(){}

void tolPosMethod_ANGLE::printSelf()
{
  printf("ANGLE");
}

/********************************************************************/

tolPosMethod_VEC::tolPosMethod_VEC(){}

tolPosMethod_VEC::tolPosMethod_VEC(
  vector * dirIn)
{
  dir = dirIn;
}

tolPosMethod_VEC::~tolPosMethod_VEC(){}

void tolPosMethod_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  dir->printSelf();
}

vector * tolPosMethod_VEC::get_dir()
{ return dir; }
void tolPosMethod_VEC::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

tolProflStm::tolProflStm(){}

tolProflStm::tolProflStm(
  tLabel * tLabelIn,
  rentVal * lotolIn,
  rentVal * uptolIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In,
  tolZoneDir2 * tolZoneDir2In)
{
  a_tLabel = tLabelIn;
  lotol = lotolIn;
  uptol = uptolIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
  a_tolZoneDir2 = tolZoneDir2In;
}

tolProflStm::~tolProflStm(){}

void tolProflStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("PROFL");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (tfm1)
    {
      printf(",");
      tfm1->printSelf();
      if (tfm2)
        {
          printf(",");
          tfm2->printSelf();
          if (tfm3)
            {
              printf(",");
              tfm3->printSelf();
            }
        }
    }
  if (a_tolZoneDir2)
    {
      printf(",");
      a_tolZoneDir2->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolProflStm::get_tLabel()
{ return a_tLabel; }
void tolProflStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolProflStm::get_lotol()
{ return lotol; }
void tolProflStm::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolProflStm::get_uptol()
{ return uptol; }
void tolProflStm::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
tolFeatureMat * tolProflStm::get_tfm1()
{ return tfm1; }
void tolProflStm::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolProflStm::get_tfm2()
{ return tfm2; }
void tolProflStm::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolProflStm::get_tfm3()
{ return tfm3; }
void tolProflStm::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }
tolZoneDir2 * tolProflStm::get_tolZoneDir2()
{ return a_tolZoneDir2; }
void tolProflStm::set_tolZoneDir2(tolZoneDir2 * tolZoneDir2In)
{ a_tolZoneDir2 = tolZoneDir2In; }

/********************************************************************/

tolProfpStm::tolProfpStm(){}

tolProfpStm::tolProfpStm(
  tLabel * tLabelIn,
  rentVal * lotolIn,
  rentVal * uptolIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In)
{
  a_tLabel = tLabelIn;
  lotol = lotolIn;
  uptol = uptolIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
}

tolProfpStm::~tolProfpStm(){}

void tolProfpStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("PROFP");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (tfm1)
    {
      printf(",");
      tfm1->printSelf();
      if (tfm2)
        {
          printf(",");
          tfm2->printSelf();
          if (tfm3)
            {
              printf(",");
              tfm3->printSelf();
            }
        }
    }
  printf("%c%c", 13, 10);
}

tLabel * tolProfpStm::get_tLabel()
{ return a_tLabel; }
void tolProfpStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolProfpStm::get_lotol()
{ return lotol; }
void tolProfpStm::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolProfpStm::get_uptol()
{ return uptol; }
void tolProfpStm::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
tolFeatureMat * tolProfpStm::get_tfm1()
{ return tfm1; }
void tolProfpStm::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolProfpStm::get_tfm2()
{ return tfm2; }
void tolProfpStm::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolProfpStm::get_tfm3()
{ return tfm3; }
void tolProfpStm::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }

/********************************************************************/

tolProfsStm::tolProfsStm(){}

tolProfsStm::tolProfsStm(
  tLabel * tLabelIn,
  rentVal * lotolIn,
  rentVal * uptolIn,
  tolFeatureMat * tfm1In,
  tolFeatureMat * tfm2In,
  tolFeatureMat * tfm3In,
  bool has_AVGDEVIn)
{
  a_tLabel = tLabelIn;
  lotol = lotolIn;
  uptol = uptolIn;
  tfm1 = tfm1In;
  tfm2 = tfm2In;
  tfm3 = tfm3In;
  has_AVGDEV = has_AVGDEVIn;
}

tolProfsStm::~tolProfsStm(){}

void tolProfsStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("PROFS");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (tfm1)
    {
      printf(",");
      tfm1->printSelf();
      if (tfm2)
        {
          printf(",");
          tfm2->printSelf();
          if (tfm3)
            {
              printf(",");
              tfm3->printSelf();
            }
        }
    }
  if (has_AVGDEV == true)
    {
      printf(",");
      printf("AVGDEV");
    }
  printf("%c%c", 13, 10);
}

tLabel * tolProfsStm::get_tLabel()
{ return a_tLabel; }
void tolProfsStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolProfsStm::get_lotol()
{ return lotol; }
void tolProfsStm::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolProfsStm::get_uptol()
{ return uptol; }
void tolProfsStm::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
tolFeatureMat * tolProfsStm::get_tfm1()
{ return tfm1; }
void tolProfsStm::set_tfm1(tolFeatureMat * tfm1In)
{ tfm1 = tfm1In; }
tolFeatureMat * tolProfsStm::get_tfm2()
{ return tfm2; }
void tolProfsStm::set_tfm2(tolFeatureMat * tfm2In)
{ tfm2 = tfm2In; }
tolFeatureMat * tolProfsStm::get_tfm3()
{ return tfm3; }
void tolProfsStm::set_tfm3(tolFeatureMat * tfm3In)
{ tfm3 = tfm3In; }
bool tolProfsStm::get_has_AVGDEV()
{ return has_AVGDEV; }
void tolProfsStm::set_has_AVGDEV(bool has_AVGDEVIn)
{ has_AVGDEV = has_AVGDEVIn; }

/********************************************************************/

tolRadStm::tolRadStm(){}

tolRadStm::tolRadStm(
  tLabel * tLabelIn,
  rentVal * lotolIn,
  rentVal * uptolIn,
  tolRadSpec * tolRadSpecIn,
  bool has_MINMAXIn)
{
  a_tLabel = tLabelIn;
  lotol = lotolIn;
  uptol = uptolIn;
  a_tolRadSpec = tolRadSpecIn;
  has_MINMAX = has_MINMAXIn;
}

tolRadStm::~tolRadStm(){}

void tolRadStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("RAD");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (a_tolRadSpec)
    {
      printf(",");
      a_tolRadSpec->printSelf();
    }
  if (has_MINMAX == true)
    {
      printf(",");
      printf("MINMAX");
    }
  printf("%c%c", 13, 10);
}

tLabel * tolRadStm::get_tLabel()
{ return a_tLabel; }
void tolRadStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolRadStm::get_lotol()
{ return lotol; }
void tolRadStm::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolRadStm::get_uptol()
{ return uptol; }
void tolRadStm::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
tolRadSpec * tolRadStm::get_tolRadSpec()
{ return a_tolRadSpec; }
void tolRadStm::set_tolRadSpec(tolRadSpec * tolRadSpecIn)
{ a_tolRadSpec = tolRadSpecIn; }
bool tolRadStm::get_has_MINMAX()
{ return has_MINMAX; }
void tolRadStm::set_has_MINMAX(bool has_MINMAXIn)
{ has_MINMAX = has_MINMAXIn; }

/********************************************************************/

tolRadSpec::tolRadSpec(){};

tolRadSpec::~tolRadSpec(){}

/********************************************************************/

tolRadSpec_AVG::tolRadSpec_AVG(){}

tolRadSpec_AVG::~tolRadSpec_AVG(){}

void tolRadSpec_AVG::printSelf()
{
  printf("AVG");
}

/********************************************************************/

tolRadSpec_CRAD::tolRadSpec_CRAD(){}

tolRadSpec_CRAD::~tolRadSpec_CRAD(){}

void tolRadSpec_CRAD::printSelf()
{
  printf("CRAD");
}

/********************************************************************/

tolZoneDir3::tolZoneDir3(){};

tolZoneDir3::~tolZoneDir3(){}

/********************************************************************/

tolZoneDir3_XDIR::tolZoneDir3_XDIR(){}

tolZoneDir3_XDIR::~tolZoneDir3_XDIR(){}

void tolZoneDir3_XDIR::printSelf()
{
  printf("XDIR");
}

/********************************************************************/

tolZoneDir3_YDIR::tolZoneDir3_YDIR(){}

tolZoneDir3_YDIR::~tolZoneDir3_YDIR(){}

void tolZoneDir3_YDIR::printSelf()
{
  printf("YDIR");
}

/********************************************************************/

tolZoneDir3_ZDIR::tolZoneDir3_ZDIR(){}

tolZoneDir3_ZDIR::~tolZoneDir3_ZDIR(){}

void tolZoneDir3_ZDIR::printSelf()
{
  printf("ZDIR");
}

/********************************************************************/

tolZoneDir3_VEC::tolZoneDir3_VEC(){}

tolZoneDir3_VEC::tolZoneDir3_VEC(
  vector * dirIn)
{
  dir = dirIn;
}

tolZoneDir3_VEC::~tolZoneDir3_VEC(){}

void tolZoneDir3_VEC::printSelf()
{
  printf("VEC");
  printf(",");
  dir->printSelf();
}

vector * tolZoneDir3_VEC::get_dir()
{ return dir; }
void tolZoneDir3_VEC::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

tolStrghtStm::tolStrghtStm(){}

tolStrghtStm::tolStrghtStm(
  tLabel * tLabelIn,
  tolStrghtMinor * tolStrghtMinorIn)
{
  a_tLabel = tLabelIn;
  a_tolStrghtMinor = tolStrghtMinorIn;
}

tolStrghtStm::~tolStrghtStm(){}

void tolStrghtStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("STRGHT");
  printf(",");
  a_tolStrghtMinor->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolStrghtStm::get_tLabel()
{ return a_tLabel; }
void tolStrghtStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
tolStrghtMinor * tolStrghtStm::get_tolStrghtMinor()
{ return a_tolStrghtMinor; }
void tolStrghtStm::set_tolStrghtMinor(tolStrghtMinor * tolStrghtMinorIn)
{ a_tolStrghtMinor = tolStrghtMinorIn; }

/********************************************************************/

tolStrghtMinor::tolStrghtMinor(){};

tolStrghtMinor::~tolStrghtMinor(){}

/********************************************************************/

tolStrghtPlain::tolStrghtPlain(){}

tolStrghtPlain::tolStrghtPlain(
  rentVal * tolzonIn,
  axis * axisIn,
  tolZoneDir3 * tolZoneDir3In)
{
  tolzon = tolzonIn;
  a_axis = axisIn;
  a_tolZoneDir3 = tolZoneDir3In;
}

tolStrghtPlain::~tolStrghtPlain(){}

void tolStrghtPlain::printSelf()
{
  tolzon->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
  if (a_tolZoneDir3)
    {
      printf(",");
      a_tolZoneDir3->printSelf();
    }
}

rentVal * tolStrghtPlain::get_tolzon()
{ return tolzon; }
void tolStrghtPlain::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
axis * tolStrghtPlain::get_axis()
{ return a_axis; }
void tolStrghtPlain::set_axis(axis * axisIn)
{ a_axis = axisIn; }
tolZoneDir3 * tolStrghtPlain::get_tolZoneDir3()
{ return a_tolZoneDir3; }
void tolStrghtPlain::set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In)
{ a_tolZoneDir3 = tolZoneDir3In; }

/********************************************************************/

tolStrghtMat::tolStrghtMat(){}

tolStrghtMat::tolStrghtMat(
  rentVal * tolzonIn,
  tolMatCond * tolMatCondIn,
  axis * axisIn,
  tolZoneDir3 * tolZoneDir3In)
{
  tolzon = tolzonIn;
  a_tolMatCond = tolMatCondIn;
  a_axis = axisIn;
  a_tolZoneDir3 = tolZoneDir3In;
}

tolStrghtMat::~tolStrghtMat(){}

void tolStrghtMat::printSelf()
{
  tolzon->printSelf();
  printf(",");
  a_tolMatCond->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
  if (a_tolZoneDir3)
    {
      printf(",");
      a_tolZoneDir3->printSelf();
    }
}

rentVal * tolStrghtMat::get_tolzon()
{ return tolzon; }
void tolStrghtMat::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
tolMatCond * tolStrghtMat::get_tolMatCond()
{ return a_tolMatCond; }
void tolStrghtMat::set_tolMatCond(tolMatCond * tolMatCondIn)
{ a_tolMatCond = tolMatCondIn; }
axis * tolStrghtMat::get_axis()
{ return a_axis; }
void tolStrghtMat::set_axis(axis * axisIn)
{ a_axis = axisIn; }
tolZoneDir3 * tolStrghtMat::get_tolZoneDir3()
{ return a_tolZoneDir3; }
void tolStrghtMat::set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In)
{ a_tolZoneDir3 = tolZoneDir3In; }

/********************************************************************/

tolStrghtPer1::tolStrghtPer1(){}

tolStrghtPer1::tolStrghtPer1(
  rentVal * tolzonIn,
  rentVal * unitIn,
  axis * axisIn,
  tolZoneDir3 * tolZoneDir3In)
{
  tolzon = tolzonIn;
  unit = unitIn;
  a_axis = axisIn;
  a_tolZoneDir3 = tolZoneDir3In;
}

tolStrghtPer1::~tolStrghtPer1(){}

void tolStrghtPer1::printSelf()
{
  tolzon->printSelf();
  printf(",");
  unit->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
  if (a_tolZoneDir3)
    {
      printf(",");
      a_tolZoneDir3->printSelf();
    }
}

rentVal * tolStrghtPer1::get_tolzon()
{ return tolzon; }
void tolStrghtPer1::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
rentVal * tolStrghtPer1::get_unit()
{ return unit; }
void tolStrghtPer1::set_unit(rentVal * unitIn)
{ unit = unitIn; }
axis * tolStrghtPer1::get_axis()
{ return a_axis; }
void tolStrghtPer1::set_axis(axis * axisIn)
{ a_axis = axisIn; }
tolZoneDir3 * tolStrghtPer1::get_tolZoneDir3()
{ return a_tolZoneDir3; }
void tolStrghtPer1::set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In)
{ a_tolZoneDir3 = tolZoneDir3In; }

/********************************************************************/

tolStrghtPer2::tolStrghtPer2(){}

tolStrghtPer2::tolStrghtPer2(
  rentVal * tolzonIn,
  rentVal * tolzon1In,
  rentVal * unitIn,
  axis * axisIn,
  tolZoneDir3 * tolZoneDir3In)
{
  tolzon = tolzonIn;
  tolzon1 = tolzon1In;
  unit = unitIn;
  a_axis = axisIn;
  a_tolZoneDir3 = tolZoneDir3In;
}

tolStrghtPer2::~tolStrghtPer2(){}

void tolStrghtPer2::printSelf()
{
  tolzon->printSelf();
  printf(",");
  tolzon1->printSelf();
  printf(",");
  unit->printSelf();
  if (a_axis)
    {
      printf(",");
      a_axis->printSelf();
    }
  if (a_tolZoneDir3)
    {
      printf(",");
      a_tolZoneDir3->printSelf();
    }
}

rentVal * tolStrghtPer2::get_tolzon()
{ return tolzon; }
void tolStrghtPer2::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
rentVal * tolStrghtPer2::get_tolzon1()
{ return tolzon1; }
void tolStrghtPer2::set_tolzon1(rentVal * tolzon1In)
{ tolzon1 = tolzon1In; }
rentVal * tolStrghtPer2::get_unit()
{ return unit; }
void tolStrghtPer2::set_unit(rentVal * unitIn)
{ unit = unitIn; }
axis * tolStrghtPer2::get_axis()
{ return a_axis; }
void tolStrghtPer2::set_axis(axis * axisIn)
{ a_axis = axisIn; }
tolZoneDir3 * tolStrghtPer2::get_tolZoneDir3()
{ return a_tolZoneDir3; }
void tolStrghtPer2::set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In)
{ a_tolZoneDir3 = tolZoneDir3In; }

/********************************************************************/

tolSymStm::tolSymStm(){}

tolSymStm::tolSymStm(
  tLabel * tLabelIn,
  rentVal * tolzonIn,
  tolFeatureMat * tolFeatureMatIn,
  tolZoneDir3 * tolZoneDir3In)
{
  a_tLabel = tLabelIn;
  tolzon = tolzonIn;
  a_tolFeatureMat = tolFeatureMatIn;
  a_tolZoneDir3 = tolZoneDir3In;
}

tolSymStm::~tolSymStm(){}

void tolSymStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("SYM");
  printf(",");
  tolzon->printSelf();
  printf(",");
  a_tolFeatureMat->printSelf();
  if (a_tolZoneDir3)
    {
      printf(",");
      a_tolZoneDir3->printSelf();
    }
  printf("%c%c", 13, 10);
}

tLabel * tolSymStm::get_tLabel()
{ return a_tLabel; }
void tolSymStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolSymStm::get_tolzon()
{ return tolzon; }
void tolSymStm::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
tolFeatureMat * tolSymStm::get_tolFeatureMat()
{ return a_tolFeatureMat; }
void tolSymStm::set_tolFeatureMat(tolFeatureMat * tolFeatureMatIn)
{ a_tolFeatureMat = tolFeatureMatIn; }
tolZoneDir3 * tolSymStm::get_tolZoneDir3()
{ return a_tolZoneDir3; }
void tolSymStm::set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In)
{ a_tolZoneDir3 = tolZoneDir3In; }

/********************************************************************/

tolTrnoutStm::tolTrnoutStm(){}

tolTrnoutStm::tolTrnoutStm(
  tLabel * tLabelIn,
  rentVal * tolzonIn,
  datLabel * datLabelIn,
  tolFeature * tolFeat1In,
  tolFeature * tolFeat2In)
{
  a_tLabel = tLabelIn;
  tolzon = tolzonIn;
  a_datLabel = datLabelIn;
  tolFeat1 = tolFeat1In;
  tolFeat2 = tolFeat2In;
}

tolTrnoutStm::~tolTrnoutStm(){}

void tolTrnoutStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("TRNOUT");
  printf(",");
  tolzon->printSelf();
  printf(",");
  a_datLabel->printSelf();
  if (tolFeat1)
    {
      printf(",");
      tolFeat1->printSelf();
      if (tolFeat2)
        {
          printf(",");
          tolFeat2->printSelf();
        }
    }
  printf("%c%c", 13, 10);
}

tLabel * tolTrnoutStm::get_tLabel()
{ return a_tLabel; }
void tolTrnoutStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolTrnoutStm::get_tolzon()
{ return tolzon; }
void tolTrnoutStm::set_tolzon(rentVal * tolzonIn)
{ tolzon = tolzonIn; }
datLabel * tolTrnoutStm::get_datLabel()
{ return a_datLabel; }
void tolTrnoutStm::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }
tolFeature * tolTrnoutStm::get_tolFeat1()
{ return tolFeat1; }
void tolTrnoutStm::set_tolFeat1(tolFeature * tolFeat1In)
{ tolFeat1 = tolFeat1In; }
tolFeature * tolTrnoutStm::get_tolFeat2()
{ return tolFeat2; }
void tolTrnoutStm::set_tolFeat2(tolFeature * tolFeat2In)
{ tolFeat2 = tolFeat2In; }

/********************************************************************/

tolUsetolStm::tolUsetolStm(){}

tolUsetolStm::tolUsetolStm(
  tLabel * tLabelIn,
  stringVal * textIn)
{
  a_tLabel = tLabelIn;
  text = textIn;
}

tolUsetolStm::~tolUsetolStm(){}

void tolUsetolStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("USETOL");
  printf(",");
  text->printSelf();
  printf("%c%c", 13, 10);
}

tLabel * tolUsetolStm::get_tLabel()
{ return a_tLabel; }
void tolUsetolStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
stringVal * tolUsetolStm::get_text()
{ return text; }
void tolUsetolStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

tolWidthStm::tolWidthStm(){}

tolWidthStm::tolWidthStm(
  tLabel * tLabelIn,
  rentVal * lotolIn,
  rentVal * uptolIn,
  tolWidthDir * tolWidthDirIn,
  bool has_MINMAXIn)
{
  a_tLabel = tLabelIn;
  lotol = lotolIn;
  uptol = uptolIn;
  a_tolWidthDir = tolWidthDirIn;
  has_MINMAX = has_MINMAXIn;
}

tolWidthStm::~tolWidthStm(){}

void tolWidthStm::printSelf()
{
  a_tLabel->printSelf();
  printf("=");
  printf("TOL");
  printf("/");
  printf("WIDTH");
  printf(",");
  lotol->printSelf();
  printf(",");
  uptol->printSelf();
  if (a_tolWidthDir)
    {
      printf(",");
      a_tolWidthDir->printSelf();
    }
  if (has_MINMAX == true)
    {
      printf(",");
      printf("MINMAX");
    }
  printf("%c%c", 13, 10);
}

tLabel * tolWidthStm::get_tLabel()
{ return a_tLabel; }
void tolWidthStm::set_tLabel(tLabel * tLabelIn)
{ a_tLabel = tLabelIn; }
rentVal * tolWidthStm::get_lotol()
{ return lotol; }
void tolWidthStm::set_lotol(rentVal * lotolIn)
{ lotol = lotolIn; }
rentVal * tolWidthStm::get_uptol()
{ return uptol; }
void tolWidthStm::set_uptol(rentVal * uptolIn)
{ uptol = uptolIn; }
tolWidthDir * tolWidthStm::get_tolWidthDir()
{ return a_tolWidthDir; }
void tolWidthStm::set_tolWidthDir(tolWidthDir * tolWidthDirIn)
{ a_tolWidthDir = tolWidthDirIn; }
bool tolWidthStm::get_has_MINMAX()
{ return has_MINMAX; }
void tolWidthStm::set_has_MINMAX(bool has_MINMAXIn)
{ has_MINMAX = has_MINMAXIn; }

/********************************************************************/

tolWidthDir::tolWidthDir(){};

tolWidthDir::~tolWidthDir(){}

/********************************************************************/

tolWidthDir_vector::tolWidthDir_vector(){}

tolWidthDir_vector::tolWidthDir_vector(
  vector * dirIn)
{
  dir = dirIn;
}

tolWidthDir_vector::~tolWidthDir_vector(){}

void tolWidthDir_vector::printSelf()
{
  dir->printSelf();
}

vector * tolWidthDir_vector::get_dir()
{ return dir; }
void tolWidthDir_vector::set_dir(vector * dirIn)
{ dir = dirIn; }

/********************************************************************/

tolWidthDir_SHORT::tolWidthDir_SHORT(){}

tolWidthDir_SHORT::~tolWidthDir_SHORT(){}

void tolWidthDir_SHORT::printSelf()
{
  printf("SHORT");
}

/********************************************************************/

tolWidthDir_LONG::tolWidthDir_LONG(){}

tolWidthDir_LONG::~tolWidthDir_LONG(){}

void tolWidthDir_LONG::printSelf()
{
  printf("LONG");
}

/********************************************************************/

tolFeature::tolFeature(){};

tolFeature::~tolFeature(){}

/********************************************************************/

tolMatCond::tolMatCond(){};

tolMatCond::~tolMatCond(){}

/********************************************************************/

tolMatCond_MMC::tolMatCond_MMC(){}

tolMatCond_MMC::~tolMatCond_MMC(){}

void tolMatCond_MMC::printSelf()
{
  printf("MMC");
}

/********************************************************************/

tolMatCond_LMC::tolMatCond_LMC(){}

tolMatCond_LMC::~tolMatCond_LMC(){}

void tolMatCond_LMC::printSelf()
{
  printf("LMC");
}

/********************************************************************/

tolMatCond_RFS::tolMatCond_RFS(){}

tolMatCond_RFS::~tolMatCond_RFS(){}

void tolMatCond_RFS::printSelf()
{
  printf("RFS");
}

/********************************************************************/

tolZoneType::tolZoneType(){};

tolZoneType::~tolZoneType(){}

/********************************************************************/

tolZoneType_TANGPL::tolZoneType_TANGPL(){}

tolZoneType_TANGPL::~tolZoneType_TANGPL(){}

void tolZoneType_TANGPL::printSelf()
{
  printf("TANGPL");
}

/********************************************************************/

tolZoneType_PARPLN::tolZoneType_PARPLN(){}

tolZoneType_PARPLN::~tolZoneType_PARPLN(){}

void tolZoneType_PARPLN::printSelf()
{
  printf("PARPLN");
}

/********************************************************************/

tooldfStm::tooldfStm(){}

tooldfStm::tooldfStm(
  tlLabel * tlLabelIn,
  mdLabel * mdLabelIn,
  stringVal * textIn)
{
  a_tlLabel = tlLabelIn;
  a_mdLabel = mdLabelIn;
  text = textIn;
}

tooldfStm::~tooldfStm(){}

void tooldfStm::printSelf()
{
  a_tlLabel->printSelf();
  printf("=");
  printf("TOOLDF");
  printf("/");
  a_mdLabel->printSelf();
  printf(",");
  text->printSelf();
  printf("%c%c", 13, 10);
}

tlLabel * tooldfStm::get_tlLabel()
{ return a_tlLabel; }
void tooldfStm::set_tlLabel(tlLabel * tlLabelIn)
{ a_tlLabel = tlLabelIn; }
mdLabel * tooldfStm::get_mdLabel()
{ return a_mdLabel; }
void tooldfStm::set_mdLabel(mdLabel * mdLabelIn)
{ a_mdLabel = mdLabelIn; }
stringVal * tooldfStm::get_text()
{ return text; }
void tooldfStm::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

transStm::transStm(){}

transStm::transStm(
  dLabel * dLabelIn,
  transMinor * tMinor1In,
  transMinor * tMinor2In,
  transMinor * tMinor3In)
{
  a_dLabel = dLabelIn;
  tMinor1 = tMinor1In;
  tMinor2 = tMinor2In;
  tMinor3 = tMinor3In;
}

transStm::~transStm(){}

void transStm::printSelf()
{
  a_dLabel->printSelf();
  printf("=");
  printf("TRANS");
  printf("/");
  tMinor1->printSelf();
  if (tMinor2)
    {
      printf(",");
      tMinor2->printSelf();
      if (tMinor3)
        {
          printf(",");
          tMinor3->printSelf();
        }
    }
  printf("%c%c", 13, 10);
}

dLabel * transStm::get_dLabel()
{ return a_dLabel; }
void transStm::set_dLabel(dLabel * dLabelIn)
{ a_dLabel = dLabelIn; }
transMinor * transStm::get_tMinor1()
{ return tMinor1; }
void transStm::set_tMinor1(transMinor * tMinor1In)
{ tMinor1 = tMinor1In; }
transMinor * transStm::get_tMinor2()
{ return tMinor2; }
void transStm::set_tMinor2(transMinor * tMinor2In)
{ tMinor2 = tMinor2In; }
transMinor * transStm::get_tMinor3()
{ return tMinor3; }
void transStm::set_tMinor3(transMinor * tMinor3In)
{ tMinor3 = tMinor3In; }

/********************************************************************/

transMinor::transMinor(){};

transMinor::~transMinor(){}

/********************************************************************/

transValue::transValue(){}

transValue::transValue(
  orig * origIn,
  rentVal * valueIn)
{
  a_orig = origIn;
  value = valueIn;
}

transValue::~transValue(){}

void transValue::printSelf()
{
  a_orig->printSelf();
  printf(",");
  value->printSelf();
}

orig * transValue::get_orig()
{ return a_orig; }
void transValue::set_orig(orig * origIn)
{ a_orig = origIn; }
rentVal * transValue::get_value()
{ return value; }
void transValue::set_value(rentVal * valueIn)
{ value = valueIn; }

/********************************************************************/

transFeature::transFeature(){}

transFeature::transFeature(
  orig * origIn,
  featureLabel * featureLabelIn)
{
  a_orig = origIn;
  a_featureLabel = featureLabelIn;
}

transFeature::~transFeature(){}

void transFeature::printSelf()
{
  a_orig->printSelf();
  printf(",");
  a_featureLabel->printSelf();
}

orig * transFeature::get_orig()
{ return a_orig; }
void transFeature::set_orig(orig * origIn)
{ a_orig = origIn; }
featureLabel * transFeature::get_featureLabel()
{ return a_featureLabel; }
void transFeature::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

transDatum::transDatum(){}

transDatum::transDatum(
  orig * origIn,
  datLabel * datLabelIn)
{
  a_orig = origIn;
  a_datLabel = datLabelIn;
}

transDatum::~transDatum(){}

void transDatum::printSelf()
{
  a_orig->printSelf();
  printf(",");
  a_datLabel->printSelf();
}

orig * transDatum::get_orig()
{ return a_orig; }
void transDatum::set_orig(orig * origIn)
{ a_orig = origIn; }
datLabel * transDatum::get_datLabel()
{ return a_datLabel; }
void transDatum::set_datLabel(datLabel * datLabelIn)
{ a_datLabel = datLabelIn; }

/********************************************************************/

transProbe::transProbe(){};

transProbe::~transProbe(){}

/********************************************************************/

transProbe_MINUSPRBRAD::transProbe_MINUSPRBRAD(){}

transProbe_MINUSPRBRAD::transProbe_MINUSPRBRAD(
  orig * origIn)
{
  a_orig = origIn;
}

transProbe_MINUSPRBRAD::~transProbe_MINUSPRBRAD(){}

void transProbe_MINUSPRBRAD::printSelf()
{
  a_orig->printSelf();
  printf(",");
  printf("-PRBRAD");
}

orig * transProbe_MINUSPRBRAD::get_orig()
{ return a_orig; }
void transProbe_MINUSPRBRAD::set_orig(orig * origIn)
{ a_orig = origIn; }

/********************************************************************/

transProbe_PRBRAD::transProbe_PRBRAD(){}

transProbe_PRBRAD::transProbe_PRBRAD(
  orig * origIn)
{
  a_orig = origIn;
}

transProbe_PRBRAD::~transProbe_PRBRAD(){}

void transProbe_PRBRAD::printSelf()
{
  a_orig->printSelf();
  printf(",");
  printf("PRBRAD");
}

orig * transProbe_PRBRAD::get_orig()
{ return a_orig; }
void transProbe_PRBRAD::set_orig(orig * origIn)
{ a_orig = origIn; }

/********************************************************************/

uncertalgStm::uncertalgStm(){}

uncertalgStm::uncertalgStm(
  uLabel * uLabelIn,
  uncertMinor * uncertMinorIn)
{
  a_uLabel = uLabelIn;
  a_uncertMinor = uncertMinorIn;
}

uncertalgStm::~uncertalgStm(){}

void uncertalgStm::printSelf()
{
  a_uLabel->printSelf();
  printf("=");
  printf("UNCERTALG");
  printf("/");
  a_uncertMinor->printSelf();
  printf("%c%c", 13, 10);
}

uLabel * uncertalgStm::get_uLabel()
{ return a_uLabel; }
void uncertalgStm::set_uLabel(uLabel * uLabelIn)
{ a_uLabel = uLabelIn; }
uncertMinor * uncertalgStm::get_uncertMinor()
{ return a_uncertMinor; }
void uncertalgStm::set_uncertMinor(uncertMinor * uncertMinorIn)
{ a_uncertMinor = uncertMinorIn; }

/********************************************************************/

uncertMinor::uncertMinor(){};

uncertMinor::~uncertMinor(){}

/********************************************************************/

uncertMinor_ALGOR::uncertMinor_ALGOR(){}

uncertMinor_ALGOR::uncertMinor_ALGOR(
  intVal * codeIn)
{
  code = codeIn;
}

uncertMinor_ALGOR::~uncertMinor_ALGOR(){}

void uncertMinor_ALGOR::printSelf()
{
  printf("ALGOR");
  printf(",");
  code->printSelf();
}

intVal * uncertMinor_ALGOR::get_code()
{ return code; }
void uncertMinor_ALGOR::set_code(intVal * codeIn)
{ code = codeIn; }

/********************************************************************/

uncertMinor_stringVal::uncertMinor_stringVal(){}

uncertMinor_stringVal::uncertMinor_stringVal(
  stringVal * nameIn,
  uncertVar3 * uncertVar3In)
{
  name = nameIn;
  a_uncertVar3 = uncertVar3In;
}

uncertMinor_stringVal::~uncertMinor_stringVal(){}

void uncertMinor_stringVal::printSelf()
{
  name->printSelf();
  printf(",");
  a_uncertVar3->printSelf();
}

stringVal * uncertMinor_stringVal::get_name()
{ return name; }
void uncertMinor_stringVal::set_name(stringVal * nameIn)
{ name = nameIn; }
uncertVar3 * uncertMinor_stringVal::get_uncertVar3()
{ return a_uncertVar3; }
void uncertMinor_stringVal::set_uncertVar3(uncertVar3 * uncertVar3In)
{ a_uncertVar3 = uncertVar3In; }

/********************************************************************/

uncertVar3::uncertVar3(){};

uncertVar3::~uncertVar3(){}

/********************************************************************/

uncertVar3_DME::uncertVar3_DME(){}

uncertVar3_DME::uncertVar3_DME(
  std::list<param *> * paramListIn)
{
  a_paramList = paramListIn;
}

uncertVar3_DME::~uncertVar3_DME(){}

void uncertVar3_DME::printSelf()
{
  printf("DME");
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
}

std::list<param *> * uncertVar3_DME::get_paramList()
{ return a_paramList; }
void uncertVar3_DME::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

uncertVar3_SENS::uncertVar3_SENS(){}

uncertVar3_SENS::uncertVar3_SENS(
  std::list<param *> * paramListIn)
{
  a_paramList = paramListIn;
}

uncertVar3_SENS::~uncertVar3_SENS(){}

void uncertVar3_SENS::printSelf()
{
  printf("SENS");
  if (a_paramList)
    {
      printf(",");
      if (a_paramList->begin() == a_paramList->end())
        fprintf(stderr, "list empty\n");
      else
        {
          std::list<param *>::iterator iter;
          for (iter = a_paramList->begin(); ; )
            {
              (*iter)->printSelf();
              if (++iter == a_paramList->end())
                break;
              printf(",");
            }
        }
    }
}

std::list<param *> * uncertVar3_SENS::get_paramList()
{ return a_paramList; }
void uncertVar3_SENS::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

uncertVar3_paramList::uncertVar3_paramList(){}

uncertVar3_paramList::uncertVar3_paramList(
  std::list<param *> * paramListIn)
{
  a_paramList = paramListIn;
}

uncertVar3_paramList::~uncertVar3_paramList(){}

void uncertVar3_paramList::printSelf()
{
  if (a_paramList->begin() == a_paramList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<param *>::iterator iter;
      for (iter = a_paramList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_paramList->end())
            break;
          printf(",");
        }
    }
}

std::list<param *> * uncertVar3_paramList::get_paramList()
{ return a_paramList; }
void uncertVar3_paramList::set_paramList(std::list<param *> * paramListIn)
{ a_paramList = paramListIn; }

/********************************************************************/

uncertsetStm::uncertsetStm(){}

uncertsetStm::uncertsetStm(
  uncertsetMinor * uncertsetMinorIn)
{
  a_uncertsetMinor = uncertsetMinorIn;
}

uncertsetStm::~uncertsetStm(){}

void uncertsetStm::printSelf()
{
  printf("UNCERTSET");
  printf("/");
  a_uncertsetMinor->printSelf();
  printf("%c%c", 13, 10);
}

uncertsetMinor * uncertsetStm::get_uncertsetMinor()
{ return a_uncertsetMinor; }
void uncertsetStm::set_uncertsetMinor(uncertsetMinor * uncertsetMinorIn)
{ a_uncertsetMinor = uncertsetMinorIn; }

/********************************************************************/

uncertsetMinor::uncertsetMinor(){};

uncertsetMinor::~uncertsetMinor(){}

/********************************************************************/

uncertsetMinor_ON::uncertsetMinor_ON(){}

uncertsetMinor_ON::uncertsetMinor_ON(
  uLabel * uLabelIn,
  uncertsetVar2 * uncertsetVar2In)
{
  a_uLabel = uLabelIn;
  a_uncertsetVar2 = uncertsetVar2In;
}

uncertsetMinor_ON::~uncertsetMinor_ON(){}

void uncertsetMinor_ON::printSelf()
{
  printf("ON");
  printf(",");
  a_uLabel->printSelf();
  printf(",");
  a_uncertsetVar2->printSelf();
}

uLabel * uncertsetMinor_ON::get_uLabel()
{ return a_uLabel; }
void uncertsetMinor_ON::set_uLabel(uLabel * uLabelIn)
{ a_uLabel = uLabelIn; }
uncertsetVar2 * uncertsetMinor_ON::get_uncertsetVar2()
{ return a_uncertsetVar2; }
void uncertsetMinor_ON::set_uncertsetVar2(uncertsetVar2 * uncertsetVar2In)
{ a_uncertsetVar2 = uncertsetVar2In; }

/********************************************************************/

uncertsetMinor_OFF::uncertsetMinor_OFF(){}

uncertsetMinor_OFF::~uncertsetMinor_OFF(){}

void uncertsetMinor_OFF::printSelf()
{
  printf("OFF");
}

/********************************************************************/

uncertsetVar2::uncertsetVar2(){};

uncertsetVar2::~uncertsetVar2(){}

/********************************************************************/

uncertsetVar2_drLabel::uncertsetVar2_drLabel(){}

uncertsetVar2_drLabel::uncertsetVar2_drLabel(
  drLabel * drLabelIn)
{
  a_drLabel = drLabelIn;
}

uncertsetVar2_drLabel::~uncertsetVar2_drLabel(){}

void uncertsetVar2_drLabel::printSelf()
{
  a_drLabel->printSelf();
}

drLabel * uncertsetVar2_drLabel::get_drLabel()
{ return a_drLabel; }
void uncertsetVar2_drLabel::set_drLabel(drLabel * drLabelIn)
{ a_drLabel = drLabelIn; }

/********************************************************************/

uncertsetVar2_NONE::uncertsetVar2_NONE(){}

uncertsetVar2_NONE::~uncertsetVar2_NONE(){}

void uncertsetVar2_NONE::printSelf()
{
  printf("NONE");
}

/********************************************************************/

unitsStm::unitsStm(){}

unitsStm::unitsStm(
  lengthUnit * lengthUnitIn,
  angleUnit * angleUnitIn,
  tempUnit * tempUnitIn)
{
  a_lengthUnit = lengthUnitIn;
  a_angleUnit = angleUnitIn;
  a_tempUnit = tempUnitIn;
}

unitsStm::~unitsStm(){}

void unitsStm::printSelf()
{
  printf("UNITS");
  printf("/");
  a_lengthUnit->printSelf();
  printf(",");
  a_angleUnit->printSelf();
  if (a_tempUnit)
    {
      printf(",");
      a_tempUnit->printSelf();
    }
  printf("%c%c", 13, 10);
}

lengthUnit * unitsStm::get_lengthUnit()
{ return a_lengthUnit; }
void unitsStm::set_lengthUnit(lengthUnit * lengthUnitIn)
{ a_lengthUnit = lengthUnitIn; }
angleUnit * unitsStm::get_angleUnit()
{ return a_angleUnit; }
void unitsStm::set_angleUnit(angleUnit * angleUnitIn)
{ a_angleUnit = angleUnitIn; }
tempUnit * unitsStm::get_tempUnit()
{ return a_tempUnit; }
void unitsStm::set_tempUnit(tempUnit * tempUnitIn)
{ a_tempUnit = tempUnitIn; }

/********************************************************************/

lengthUnit::lengthUnit(){};

lengthUnit::~lengthUnit(){}

/********************************************************************/

lengthUnit_MM::lengthUnit_MM(){}

lengthUnit_MM::~lengthUnit_MM(){}

void lengthUnit_MM::printSelf()
{
  printf("MM");
}

/********************************************************************/

lengthUnit_CM::lengthUnit_CM(){}

lengthUnit_CM::~lengthUnit_CM(){}

void lengthUnit_CM::printSelf()
{
  printf("CM");
}

/********************************************************************/

lengthUnit_METER::lengthUnit_METER(){}

lengthUnit_METER::~lengthUnit_METER(){}

void lengthUnit_METER::printSelf()
{
  printf("METER");
}

/********************************************************************/

lengthUnit_INCH::lengthUnit_INCH(){}

lengthUnit_INCH::~lengthUnit_INCH(){}

void lengthUnit_INCH::printSelf()
{
  printf("INCH");
}

/********************************************************************/

lengthUnit_FEET::lengthUnit_FEET(){}

lengthUnit_FEET::~lengthUnit_FEET(){}

void lengthUnit_FEET::printSelf()
{
  printf("FEET");
}

/********************************************************************/

angleUnit::angleUnit(){};

angleUnit::~angleUnit(){}

/********************************************************************/

angleUnit_ANGDEC::angleUnit_ANGDEC(){}

angleUnit_ANGDEC::~angleUnit_ANGDEC(){}

void angleUnit_ANGDEC::printSelf()
{
  printf("ANGDEC");
}

/********************************************************************/

angleUnit_ANGDMS::angleUnit_ANGDMS(){}

angleUnit_ANGDMS::~angleUnit_ANGDMS(){}

void angleUnit_ANGDMS::printSelf()
{
  printf("ANGDMS");
}

/********************************************************************/

angleUnit_ANGRAD::angleUnit_ANGRAD(){}

angleUnit_ANGRAD::~angleUnit_ANGRAD(){}

void angleUnit_ANGRAD::printSelf()
{
  printf("ANGRAD");
}

/********************************************************************/

tempUnit::tempUnit(){};

tempUnit::~tempUnit(){}

/********************************************************************/

tempUnit_TEMPF::tempUnit_TEMPF(){}

tempUnit_TEMPF::~tempUnit_TEMPF(){}

void tempUnit_TEMPF::printSelf()
{
  printf("TEMPF");
}

/********************************************************************/

tempUnit_TEMPC::tempUnit_TEMPC(){}

tempUnit_TEMPC::~tempUnit_TEMPC(){}

void tempUnit_TEMPC::printSelf()
{
  printf("TEMPC");
}

/********************************************************************/

valueMinorBool::valueMinorBool(){};

valueMinorBool::~valueMinorBool(){}

/********************************************************************/

valueMinorString::valueMinorString(){};

valueMinorString::~valueMinorString(){}

/********************************************************************/

valueMinorInt::valueMinorInt(){};

valueMinorInt::~valueMinorInt(){}

/********************************************************************/

valueMinorReal::valueMinorReal(){};

valueMinorReal::~valueMinorReal(){}

/********************************************************************/

valueMinorVector::valueMinorVector(){};

valueMinorVector::~valueMinorVector(){}

/********************************************************************/

valueAclratReal::valueAclratReal(){};

valueAclratReal::~valueAclratReal(){}

/********************************************************************/

valueAclratReal_MESACL::valueAclratReal_MESACL(){}

valueAclratReal_MESACL::~valueAclratReal_MESACL(){}

void valueAclratReal_MESACL::printSelf()
{
  printf("ACLRAT");
  printf(",");
  printf("MESACL");
}

/********************************************************************/

valueAclratReal_POSACL::valueAclratReal_POSACL(){}

valueAclratReal_POSACL::~valueAclratReal_POSACL(){}

void valueAclratReal_POSACL::printSelf()
{
  printf("ACLRAT");
  printf(",");
  printf("POSACL");
}

/********************************************************************/

valueAclratReal_ROTACL::valueAclratReal_ROTACL(){}

valueAclratReal_ROTACL::~valueAclratReal_ROTACL(){}

void valueAclratReal_ROTACL::printSelf()
{
  printf("ACLRAT");
  printf(",");
  printf("ROTACL");
}

/********************************************************************/

valueAclratString::valueAclratString(){}

valueAclratString::valueAclratString(
  valueAclratReal * valueAclratRealIn)
{
  a_valueAclratReal = valueAclratRealIn;
}

valueAclratString::~valueAclratString(){}

void valueAclratString::printSelf()
{
  a_valueAclratReal->printSelf();
  printf(",");
  printf("ACEL");
}

valueAclratReal * valueAclratString::get_valueAclratReal()
{ return a_valueAclratReal; }
void valueAclratString::set_valueAclratReal(valueAclratReal * valueAclratRealIn)
{ a_valueAclratReal = valueAclratRealIn; }

/********************************************************************/

valueBadtst::valueBadtst(){}

valueBadtst::~valueBadtst(){}

void valueBadtst::printSelf()
{
  printf("BADTST");
}

/********************************************************************/

valueBoundString::valueBoundString(){};

valueBoundString::~valueBoundString(){}

/********************************************************************/

valueBoundString_featureLabel::valueBoundString_featureLabel(){}

valueBoundString_featureLabel::valueBoundString_featureLabel(
  featureLabel * featureLabelIn,
  intVal * bndnumIn)
{
  a_featureLabel = featureLabelIn;
  bndnum = bndnumIn;
}

valueBoundString_featureLabel::~valueBoundString_featureLabel(){}

void valueBoundString_featureLabel::printSelf()
{
  printf("BOUND");
  printf(",");
  a_featureLabel->printSelf();
  printf(",");
  bndnum->printSelf();
}

featureLabel * valueBoundString_featureLabel::get_featureLabel()
{ return a_featureLabel; }
void valueBoundString_featureLabel::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }
intVal * valueBoundString_featureLabel::get_bndnum()
{ return bndnum; }
void valueBoundString_featureLabel::set_bndnum(intVal * bndnumIn)
{ bndnum = bndnumIn; }

/********************************************************************/

valueBoundString_toleranceLabel::valueBoundString_toleranceLabel(){}

valueBoundString_toleranceLabel::valueBoundString_toleranceLabel(
  toleranceLabel * toleranceLabelIn,
  intVal * bndnumIn)
{
  a_toleranceLabel = toleranceLabelIn;
  bndnum = bndnumIn;
}

valueBoundString_toleranceLabel::~valueBoundString_toleranceLabel(){}

void valueBoundString_toleranceLabel::printSelf()
{
  printf("BOUND");
  printf(",");
  a_toleranceLabel->printSelf();
  printf(",");
  bndnum->printSelf();
}

toleranceLabel * valueBoundString_toleranceLabel::get_toleranceLabel()
{ return a_toleranceLabel; }
void valueBoundString_toleranceLabel::set_toleranceLabel(toleranceLabel * toleranceLabelIn)
{ a_toleranceLabel = toleranceLabelIn; }
intVal * valueBoundString_toleranceLabel::get_bndnum()
{ return bndnum; }
void valueBoundString_toleranceLabel::set_bndnum(intVal * bndnumIn)
{ bndnum = bndnumIn; }

/********************************************************************/

valueBoundInt::valueBoundInt(){};

valueBoundInt::~valueBoundInt(){}

/********************************************************************/

valueBoundInt_featureLabel::valueBoundInt_featureLabel(){}

valueBoundInt_featureLabel::valueBoundInt_featureLabel(
  featureLabel * featureLabelIn)
{
  a_featureLabel = featureLabelIn;
}

valueBoundInt_featureLabel::~valueBoundInt_featureLabel(){}

void valueBoundInt_featureLabel::printSelf()
{
  printf("BOUND");
  printf(",");
  a_featureLabel->printSelf();
  printf(",");
  printf("COUNT");
}

featureLabel * valueBoundInt_featureLabel::get_featureLabel()
{ return a_featureLabel; }
void valueBoundInt_featureLabel::set_featureLabel(featureLabel * featureLabelIn)
{ a_featureLabel = featureLabelIn; }

/********************************************************************/

valueBoundInt_toleranceLabel::valueBoundInt_toleranceLabel(){}

valueBoundInt_toleranceLabel::valueBoundInt_toleranceLabel(
  toleranceLabel * toleranceLabelIn)
{
  a_toleranceLabel = toleranceLabelIn;
}

valueBoundInt_toleranceLabel::~valueBoundInt_toleranceLabel(){}

void valueBoundInt_toleranceLabel::printSelf()
{
  printf("BOUND");
  printf(",");
  a_toleranceLabel->printSelf();
  printf(",");
  printf("COUNT");
}

toleranceLabel * valueBoundInt_toleranceLabel::get_toleranceLabel()
{ return a_toleranceLabel; }
void valueBoundInt_toleranceLabel::set_toleranceLabel(toleranceLabel * toleranceLabelIn)
{ a_toleranceLabel = toleranceLabelIn; }

/********************************************************************/

valueCrmode::valueCrmode(){}

valueCrmode::~valueCrmode(){}

void valueCrmode::printSelf()
{
  printf("CRMODE");
}

/********************************************************************/

valueCroscl::valueCroscl(){}

valueCroscl::~valueCroscl(){}

void valueCroscl::printSelf()
{
  printf("CROSCL");
}

/********************************************************************/

valueCrslct::valueCrslct(){}

valueCrslct::~valueCrslct(){}

void valueCrslct::printSelf()
{
  printf("CRSLCT");
}

/********************************************************************/

valueCzslct::valueCzslct(){}

valueCzslct::valueCzslct(
  czLabel * czLabelIn)
{
  a_czLabel = czLabelIn;
}

valueCzslct::~valueCzslct(){}

void valueCzslct::printSelf()
{
  printf("CZSLCT");
  printf(",");
  a_czLabel->printSelf();
}

czLabel * valueCzslct::get_czLabel()
{ return a_czLabel; }
void valueCzslct::set_czLabel(czLabel * czLabelIn)
{ a_czLabel = czLabelIn; }

/********************************************************************/

valueDatset::valueDatset(){}

valueDatset::~valueDatset(){}

void valueDatset::printSelf()
{
  printf("DATSET");
}

/********************************************************************/

valueDeflection::valueDeflection(){}

valueDeflection::~valueDeflection(){}

void valueDeflection::printSelf()
{
  printf("DEFLECTION");
}

/********************************************************************/

valueDmismd::valueDmismd(){};

valueDmismd::~valueDmismd(){}

/********************************************************************/

valueDmismd_NAME::valueDmismd_NAME(){}

valueDmismd_NAME::~valueDmismd_NAME(){}

void valueDmismd_NAME::printSelf()
{
  printf("DMISMD");
  printf(",");
  printf("NAME");
}

/********************************************************************/

valueDmismd_VERSION::valueDmismd_VERSION(){}

valueDmismd_VERSION::~valueDmismd_VERSION(){}

void valueDmismd_VERSION::printSelf()
{
  printf("DMISMD");
  printf(",");
  printf("VERSION");
}

/********************************************************************/

valueDmismn::valueDmismn(){};

valueDmismn::~valueDmismn(){}

/********************************************************************/

valueDmismn_NAME::valueDmismn_NAME(){}

valueDmismn_NAME::~valueDmismn_NAME(){}

void valueDmismn_NAME::printSelf()
{
  printf("DMISMN");
  printf(",");
  printf("NAME");
}

/********************************************************************/

valueDmismn_VERSION::valueDmismn_VERSION(){}

valueDmismn_VERSION::~valueDmismn_VERSION(){}

void valueDmismn_VERSION::printSelf()
{
  printf("DMISMN");
  printf(",");
  printf("VERSION");
}

/********************************************************************/

valueError::valueError(){};

valueError::~valueError(){}

/********************************************************************/

valueError_ERR::valueError_ERR(){}

valueError_ERR::~valueError_ERR(){}

void valueError_ERR::printSelf()
{
  printf("ERROR");
  printf(",");
  printf("ERR");
}

/********************************************************************/

valueError_ERRMODE::valueError_ERRMODE(){}

valueError_ERRMODE::~valueError_ERRMODE(){}

void valueError_ERRMODE::printSelf()
{
  printf("ERROR");
  printf(",");
  printf("ERRMODE");
}

/********************************************************************/

valueFedratReal::valueFedratReal(){};

valueFedratReal::~valueFedratReal(){}

/********************************************************************/

valueFedratReal_MESVEL::valueFedratReal_MESVEL(){}

valueFedratReal_MESVEL::~valueFedratReal_MESVEL(){}

void valueFedratReal_MESVEL::printSelf()
{
  printf("FEDRAT");
  printf(",");
  printf("MESVEL");
}

/********************************************************************/

valueFedratReal_POSVEL::valueFedratReal_POSVEL(){}

valueFedratReal_POSVEL::~valueFedratReal_POSVEL(){}

void valueFedratReal_POSVEL::printSelf()
{
  printf("FEDRAT");
  printf(",");
  printf("POSVEL");
}

/********************************************************************/

valueFedratReal_ROTVEL::valueFedratReal_ROTVEL(){}

valueFedratReal_ROTVEL::~valueFedratReal_ROTVEL(){}

void valueFedratReal_ROTVEL::printSelf()
{
  printf("FEDRAT");
  printf(",");
  printf("ROTVEL");
}

/********************************************************************/

valueFedratReal_SCNVEL::valueFedratReal_SCNVEL(){}

valueFedratReal_SCNVEL::~valueFedratReal_SCNVEL(){}

void valueFedratReal_SCNVEL::printSelf()
{
  printf("FEDRAT");
  printf(",");
  printf("SCNVEL");
}

/********************************************************************/

valueFedratString::valueFedratString(){}

valueFedratString::valueFedratString(
  valueFedratReal * valueFedratRealIn)
{
  a_valueFedratReal = valueFedratRealIn;
}

valueFedratString::~valueFedratString(){}

void valueFedratString::printSelf()
{
  a_valueFedratReal->printSelf();
  printf(",");
  printf("FEED");
}

valueFedratReal * valueFedratString::get_valueFedratReal()
{ return a_valueFedratReal; }
void valueFedratString::set_valueFedratReal(valueFedratReal * valueFedratRealIn)
{ a_valueFedratReal = valueFedratRealIn; }

/********************************************************************/

valueFilnam::valueFilnam(){};

valueFilnam::~valueFilnam(){}

/********************************************************************/

valueFilnam_NAME::valueFilnam_NAME(){}

valueFilnam_NAME::~valueFilnam_NAME(){}

void valueFilnam_NAME::printSelf()
{
  printf("FILNAM");
  printf(",");
  printf("NAME");
}

/********************************************************************/

valueFilnam_VERSION::valueFilnam_VERSION(){}

valueFilnam_VERSION::~valueFilnam_VERSION(){}

void valueFilnam_VERSION::printSelf()
{
  printf("FILNAM");
  printf(",");
  printf("VERSION");
}

/********************************************************************/

valueFinpos::valueFinpos(){}

valueFinpos::~valueFinpos(){}

void valueFinpos::printSelf()
{
  printf("FINPOS");
}

/********************************************************************/

valueGeoalg::valueGeoalg(){}

valueGeoalg::valueGeoalg(
  measGeotype * measGeotypeIn)
{
  a_measGeotype = measGeotypeIn;
}

valueGeoalg::~valueGeoalg(){}

void valueGeoalg::printSelf()
{
  printf("GEOALG");
  printf(",");
  a_measGeotype->printSelf();
}

measGeotype * valueGeoalg::get_measGeotype()
{ return a_measGeotype; }
void valueGeoalg::set_measGeotype(measGeotype * measGeotypeIn)
{ a_measGeotype = measGeotypeIn; }

/********************************************************************/

valueGotoReal::valueGotoReal(){}

valueGotoReal::valueGotoReal(
  axis * axisIn)
{
  a_axis = axisIn;
}

valueGotoReal::~valueGotoReal(){}

void valueGotoReal::printSelf()
{
  printf("GOTO");
  printf(",");
  a_axis->printSelf();
}

axis * valueGotoReal::get_axis()
{ return a_axis; }
void valueGotoReal::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

valueGotoVector::valueGotoVector(){}

valueGotoVector::~valueGotoVector(){}

void valueGotoVector::printSelf()
{
  printf("GOTO");
  printf(",");
  printf("POS");
}

/********************************************************************/

valueKeychar::valueKeychar(){};

valueKeychar::~valueKeychar(){}

/********************************************************************/

valueMode::valueMode(){}

valueMode::~valueMode(){}

void valueMode::printSelf()
{
  printf("MODE");
}

/********************************************************************/

valuePrcomp::valuePrcomp(){}

valuePrcomp::~valuePrcomp(){}

void valuePrcomp::printSelf()
{
  printf("PRCOMP");
}

/********************************************************************/

valuePtbuff::valuePtbuff(){}

valuePtbuff::~valuePtbuff(){}

void valuePtbuff::printSelf()
{
  printf("PTBUFF");
}

/********************************************************************/

valuePtmeasReal::valuePtmeasReal(){}

valuePtmeasReal::valuePtmeasReal(
  axis * axisIn)
{
  a_axis = axisIn;
}

valuePtmeasReal::~valuePtmeasReal(){}

void valuePtmeasReal::printSelf()
{
  printf("PTMEAS");
  printf(",");
  a_axis->printSelf();
}

axis * valuePtmeasReal::get_axis()
{ return a_axis; }
void valuePtmeasReal::set_axis(axis * axisIn)
{ a_axis = axisIn; }

/********************************************************************/

valuePtmeasVector::valuePtmeasVector(){}

valuePtmeasVector::~valuePtmeasVector(){}

void valuePtmeasVector::printSelf()
{
  printf("PTMEAS");
  printf(",");
  printf("POS");
}

/********************************************************************/

valueScnmod::valueScnmod(){}

valueScnmod::~valueScnmod(){}

void valueScnmod::printSelf()
{
  printf("SCNMOD");
}

/********************************************************************/

valueSnsetReal::valueSnsetReal(){};

valueSnsetReal::~valueSnsetReal(){}

/********************************************************************/

valueSnsetRealApprch::valueSnsetRealApprch(){}

valueSnsetRealApprch::~valueSnsetRealApprch(){}

void valueSnsetRealApprch::printSelf()
{
  printf("SNSET");
  printf(",");
  printf("APPRCH");
}

/********************************************************************/

valueSnsetRealRetrct::valueSnsetRealRetrct(){}

valueSnsetRealRetrct::~valueSnsetRealRetrct(){}

void valueSnsetRealRetrct::printSelf()
{
  printf("SNSET");
  printf(",");
  printf("RETRCT");
}

/********************************************************************/

valueSnsetRealSearch::valueSnsetRealSearch(){}

valueSnsetRealSearch::~valueSnsetRealSearch(){}

void valueSnsetRealSearch::printSelf()
{
  printf("SNSET");
  printf(",");
  printf("SEARCH");
}

/********************************************************************/

valueSnsetRealClrsrf::valueSnsetRealClrsrf(){}

valueSnsetRealClrsrf::~valueSnsetRealClrsrf(){}

void valueSnsetRealClrsrf::printSelf()
{
  printf("SNSET");
  printf(",");
  printf("CLRSRF");
  printf(",");
  printf("DIST");
}

/********************************************************************/

valueSnsetRealDepth::valueSnsetRealDepth(){}

valueSnsetRealDepth::~valueSnsetRealDepth(){}

void valueSnsetRealDepth::printSelf()
{
  printf("SNSET");
  printf(",");
  printf("DEPTH");
  printf(",");
  printf("DIST");
}

/********************************************************************/

valueSnsetString::valueSnsetString(){};

valueSnsetString::~valueSnsetString(){}

/********************************************************************/

valueSnsetString_CLRSRF::valueSnsetString_CLRSRF(){}

valueSnsetString_CLRSRF::~valueSnsetString_CLRSRF(){}

void valueSnsetString_CLRSRF::printSelf()
{
  printf("SNSET");
  printf(",");
  printf("CLRSRF");
}

/********************************************************************/

valueSnsetString_DEPTH::valueSnsetString_DEPTH(){}

valueSnsetString_DEPTH::~valueSnsetString_DEPTH(){}

void valueSnsetString_DEPTH::printSelf()
{
  printf("SNSET");
  printf(",");
  printf("DEPTH");
}

/********************************************************************/

valueSnslct::valueSnslct(){}

valueSnslct::~valueSnslct(){}

void valueSnslct::printSelf()
{
  printf("SNSLCT");
}

/********************************************************************/

valueSnsmnt::valueSnsmnt(){};

valueSnsmnt::~valueSnsmnt(){}

/********************************************************************/

valueSnsmnt_XVEC::valueSnsmnt_XVEC(){}

valueSnsmnt_XVEC::~valueSnsmnt_XVEC(){}

void valueSnsmnt_XVEC::printSelf()
{
  printf("SNSMNT");
  printf(",");
  printf("XVEC");
}

/********************************************************************/

valueSnsmnt_ZVEC::valueSnsmnt_ZVEC(){}

valueSnsmnt_ZVEC::~valueSnsmnt_ZVEC(){}

void valueSnsmnt_ZVEC::printSelf()
{
  printf("SNSMNT");
  printf(",");
  printf("ZVEC");
}

/********************************************************************/

valueSnsmnt_MNTLEN::valueSnsmnt_MNTLEN(){}

valueSnsmnt_MNTLEN::~valueSnsmnt_MNTLEN(){}

void valueSnsmnt_MNTLEN::printSelf()
{
  printf("SNSMNT");
  printf(",");
  printf("MNTLEN");
}

/********************************************************************/

valueTecomp::valueTecomp(){}

valueTecomp::~valueTecomp(){}

void valueTecomp::printSelf()
{
  printf("TECOMP");
}

/********************************************************************/

valueUnits::valueUnits(){};

valueUnits::~valueUnits(){}

/********************************************************************/

valueUnits_DIST::valueUnits_DIST(){}

valueUnits_DIST::~valueUnits_DIST(){}

void valueUnits_DIST::printSelf()
{
  printf("UNITS");
  printf(",");
  printf("DIST");
}

/********************************************************************/

valueUnits_ANGL::valueUnits_ANGL(){}

valueUnits_ANGL::~valueUnits_ANGL(){}

void valueUnits_ANGL::printSelf()
{
  printf("UNITS");
  printf(",");
  printf("ANGL");
}

/********************************************************************/

valueUnits_TEMP::valueUnits_TEMP(){}

valueUnits_TEMP::~valueUnits_TEMP(){}

void valueUnits_TEMP::printSelf()
{
  printf("UNITS");
  printf(",");
  printf("TEMP");
}

/********************************************************************/

valueWkplan::valueWkplan(){}

valueWkplan::~valueWkplan(){}

void valueWkplan::printSelf()
{
  printf("WKPLAN");
}

/********************************************************************/

valueFaInt::valueFaInt(){}

valueFaInt::valueFaInt(
  faLabel * faLabelIn)
{
  a_faLabel = faLabelIn;
}

valueFaInt::~valueFaInt(){}

void valueFaInt::printSelf()
{
  a_faLabel->printSelf();
  printf(",");
  printf("PTDATA");
}

faLabel * valueFaInt::get_faLabel()
{ return a_faLabel; }
void valueFaInt::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }

/********************************************************************/

valueFaReal::valueFaReal(){}

valueFaReal::valueFaReal(
  faLabel * faLabelIn,
  intVal * sizenumIn)
{
  a_faLabel = faLabelIn;
  sizenum = sizenumIn;
}

valueFaReal::~valueFaReal(){}

void valueFaReal::printSelf()
{
  a_faLabel->printSelf();
  printf(",");
  printf("SIZE");
  if (sizenum)
    {
      printf(",");
      sizenum->printSelf();
    }
}

faLabel * valueFaReal::get_faLabel()
{ return a_faLabel; }
void valueFaReal::set_faLabel(faLabel * faLabelIn)
{ a_faLabel = faLabelIn; }
intVal * valueFaReal::get_sizenum()
{ return sizenum; }
void valueFaReal::set_sizenum(intVal * sizenumIn)
{ sizenum = sizenumIn; }

/********************************************************************/

valueRt::valueRt(){};

valueRt::~valueRt(){}

/********************************************************************/

valueRt_CW::valueRt_CW(){}

valueRt_CW::valueRt_CW(
  rtLabel * rtLabelIn)
{
  a_rtLabel = rtLabelIn;
}

valueRt_CW::~valueRt_CW(){}

void valueRt_CW::printSelf()
{
  a_rtLabel->printSelf();
  printf(",");
  printf("ANGL");
  printf(",");
  printf("CW");
}

rtLabel * valueRt_CW::get_rtLabel()
{ return a_rtLabel; }
void valueRt_CW::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }

/********************************************************************/

valueRt_CCW::valueRt_CCW(){}

valueRt_CCW::valueRt_CCW(
  rtLabel * rtLabelIn)
{
  a_rtLabel = rtLabelIn;
}

valueRt_CCW::~valueRt_CCW(){}

void valueRt_CCW::printSelf()
{
  a_rtLabel->printSelf();
  printf(",");
  printf("ANGL");
  printf(",");
  printf("CCW");
}

rtLabel * valueRt_CCW::get_rtLabel()
{ return a_rtLabel; }
void valueRt_CCW::set_rtLabel(rtLabel * rtLabelIn)
{ a_rtLabel = rtLabelIn; }

/********************************************************************/

valueSa::valueSa(){};

valueSa::~valueSa(){}

/********************************************************************/

valueSaPlain::valueSaPlain(){}

valueSaPlain::valueSaPlain(
  saLabel * saLabelIn)
{
  a_saLabel = saLabelIn;
}

valueSaPlain::~valueSaPlain(){}

void valueSaPlain::printSelf()
{
  a_saLabel->printSelf();
}

saLabel * valueSaPlain::get_saLabel()
{ return a_saLabel; }
void valueSaPlain::set_saLabel(saLabel * saLabelIn)
{ a_saLabel = saLabelIn; }

/********************************************************************/

valueSaDesc::valueSaDesc(){}

valueSaDesc::valueSaDesc(
  saLabel * saLabelIn,
  stringVal * descIn)
{
  a_saLabel = saLabelIn;
  desc = descIn;
}

valueSaDesc::~valueSaDesc(){}

void valueSaDesc::printSelf()
{
  a_saLabel->printSelf();
  printf(",");
  desc->printSelf();
}

saLabel * valueSaDesc::get_saLabel()
{ return a_saLabel; }
void valueSaDesc::set_saLabel(saLabel * saLabelIn)
{ a_saLabel = saLabelIn; }
stringVal * valueSaDesc::get_desc()
{ return desc; }
void valueSaDesc::set_desc(stringVal * descIn)
{ desc = descIn; }

/********************************************************************/

valueSaTipnum::valueSaTipnum(){}

valueSaTipnum::valueSaTipnum(
  saLabel * saLabelIn,
  intVal * tipnumIn)
{
  a_saLabel = saLabelIn;
  tipnum = tipnumIn;
}

valueSaTipnum::~valueSaTipnum(){}

void valueSaTipnum::printSelf()
{
  a_saLabel->printSelf();
  printf(",");
  tipnum->printSelf();
}

saLabel * valueSaTipnum::get_saLabel()
{ return a_saLabel; }
void valueSaTipnum::set_saLabel(saLabel * saLabelIn)
{ a_saLabel = saLabelIn; }
intVal * valueSaTipnum::get_tipnum()
{ return tipnum; }
void valueSaTipnum::set_tipnum(intVal * tipnumIn)
{ tipnum = tipnumIn; }

/********************************************************************/

valueSw::valueSw(){}

valueSw::valueSw(
  swLabel * swLabelIn,
  stringVal * anglenameIn)
{
  a_swLabel = swLabelIn;
  anglename = anglenameIn;
}

valueSw::~valueSw(){}

void valueSw::printSelf()
{
  a_swLabel->printSelf();
  printf(",");
  printf("ANGLE");
  printf(",");
  anglename->printSelf();
}

swLabel * valueSw::get_swLabel()
{ return a_swLabel; }
void valueSw::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
stringVal * valueSw::get_anglename()
{ return anglename; }
void valueSw::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }

/********************************************************************/

valueTaBool::valueTaBool(){};

valueTaBool::~valueTaBool(){}

/********************************************************************/

valueTaBoolIntol::valueTaBoolIntol(){}

valueTaBoolIntol::valueTaBoolIntol(
  taLabel * taLabelIn,
  intVal * tolnumIn)
{
  a_taLabel = taLabelIn;
  tolnum = tolnumIn;
}

valueTaBoolIntol::~valueTaBoolIntol(){}

void valueTaBoolIntol::printSelf()
{
  a_taLabel->printSelf();
  printf(",");
  printf("INTOL");
  if (tolnum)
    {
      printf(",");
      tolnum->printSelf();
    }
}

taLabel * valueTaBoolIntol::get_taLabel()
{ return a_taLabel; }
void valueTaBoolIntol::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
intVal * valueTaBoolIntol::get_tolnum()
{ return tolnum; }
void valueTaBoolIntol::set_tolnum(intVal * tolnumIn)
{ tolnum = tolnumIn; }

/********************************************************************/

valueTaBoolOutol::valueTaBoolOutol(){}

valueTaBoolOutol::valueTaBoolOutol(
  taLabel * taLabelIn,
  intVal * tolnumIn)
{
  a_taLabel = taLabelIn;
  tolnum = tolnumIn;
}

valueTaBoolOutol::~valueTaBoolOutol(){}

void valueTaBoolOutol::printSelf()
{
  a_taLabel->printSelf();
  printf(",");
  printf("OUTOL");
  if (tolnum)
    {
      printf(",");
      tolnum->printSelf();
    }
}

taLabel * valueTaBoolOutol::get_taLabel()
{ return a_taLabel; }
void valueTaBoolOutol::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
intVal * valueTaBoolOutol::get_tolnum()
{ return tolnum; }
void valueTaBoolOutol::set_tolnum(intVal * tolnumIn)
{ tolnum = tolnumIn; }

/********************************************************************/

valueTaReal::valueTaReal(){};

valueTaReal::~valueTaReal(){}

/********************************************************************/

valueTaRealAct::valueTaRealAct(){}

valueTaRealAct::valueTaRealAct(
  taLabel * taLabelIn,
  intVal * tolnumIn)
{
  a_taLabel = taLabelIn;
  tolnum = tolnumIn;
}

valueTaRealAct::~valueTaRealAct(){}

void valueTaRealAct::printSelf()
{
  a_taLabel->printSelf();
  printf(",");
  printf("ACT");
  if (tolnum)
    {
      printf(",");
      tolnum->printSelf();
    }
}

taLabel * valueTaRealAct::get_taLabel()
{ return a_taLabel; }
void valueTaRealAct::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
intVal * valueTaRealAct::get_tolnum()
{ return tolnum; }
void valueTaRealAct::set_tolnum(intVal * tolnumIn)
{ tolnum = tolnumIn; }

/********************************************************************/

valueTaRealDev::valueTaRealDev(){}

valueTaRealDev::valueTaRealDev(
  taLabel * taLabelIn,
  intVal * tolnumIn)
{
  a_taLabel = taLabelIn;
  tolnum = tolnumIn;
}

valueTaRealDev::~valueTaRealDev(){}

void valueTaRealDev::printSelf()
{
  a_taLabel->printSelf();
  printf(",");
  printf("DEV");
  if (tolnum)
    {
      printf(",");
      tolnum->printSelf();
    }
}

taLabel * valueTaRealDev::get_taLabel()
{ return a_taLabel; }
void valueTaRealDev::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
intVal * valueTaRealDev::get_tolnum()
{ return tolnum; }
void valueTaRealDev::set_tolnum(intVal * tolnumIn)
{ tolnum = tolnumIn; }

/********************************************************************/

valueTaRealAmt::valueTaRealAmt(){}

valueTaRealAmt::valueTaRealAmt(
  taLabel * taLabelIn,
  intVal * tolnumIn)
{
  a_taLabel = taLabelIn;
  tolnum = tolnumIn;
}

valueTaRealAmt::~valueTaRealAmt(){}

void valueTaRealAmt::printSelf()
{
  a_taLabel->printSelf();
  printf(",");
  printf("AMT");
  if (tolnum)
    {
      printf(",");
      tolnum->printSelf();
    }
}

taLabel * valueTaRealAmt::get_taLabel()
{ return a_taLabel; }
void valueTaRealAmt::set_taLabel(taLabel * taLabelIn)
{ a_taLabel = taLabelIn; }
intVal * valueTaRealAmt::get_tolnum()
{ return tolnum; }
void valueTaRealAmt::set_tolnum(intVal * tolnumIn)
{ tolnum = tolnumIn; }

/********************************************************************/

vformStm::vformStm(){}

vformStm::vformStm(
  vLabel * vLabelIn,
  std::list<vformItem *> * vformItemListIn)
{
  a_vLabel = vLabelIn;
  a_vformItemList = vformItemListIn;
}

vformStm::~vformStm(){}

void vformStm::printSelf()
{
  a_vLabel->printSelf();
  printf("=");
  printf("VFORM");
  printf("/");
  if (a_vformItemList->begin() == a_vformItemList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<vformItem *>::iterator iter;
      for (iter = a_vformItemList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_vformItemList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

vLabel * vformStm::get_vLabel()
{ return a_vLabel; }
void vformStm::set_vLabel(vLabel * vLabelIn)
{ a_vLabel = vLabelIn; }
std::list<vformItem *> * vformStm::get_vformItemList()
{ return a_vformItemList; }
void vformStm::set_vformItemList(std::list<vformItem *> * vformItemListIn)
{ a_vformItemList = vformItemListIn; }

/********************************************************************/

vformItem::vformItem(){};

vformItem::~vformItem(){}

/********************************************************************/

vformItem_NOM::vformItem_NOM(){}

vformItem_NOM::vformItem_NOM(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_NOM::~vformItem_NOM(){}

void vformItem_NOM::printSelf()
{
  printf("NOM");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_NOM::get_text()
{ return text; }
void vformItem_NOM::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

vformItem_ACT::vformItem_ACT(){}

vformItem_ACT::vformItem_ACT(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_ACT::~vformItem_ACT(){}

void vformItem_ACT::printSelf()
{
  printf("ACT");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_ACT::get_text()
{ return text; }
void vformItem_ACT::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

vformItem_DEV::vformItem_DEV(){}

vformItem_DEV::vformItem_DEV(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_DEV::~vformItem_DEV(){}

void vformItem_DEV::printSelf()
{
  printf("DEV");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_DEV::get_text()
{ return text; }
void vformItem_DEV::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

vformItem_AMT::vformItem_AMT(){}

vformItem_AMT::vformItem_AMT(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_AMT::~vformItem_AMT(){}

void vformItem_AMT::printSelf()
{
  printf("AMT");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_AMT::get_text()
{ return text; }
void vformItem_AMT::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

vformItem_HIST::vformItem_HIST(){}

vformItem_HIST::vformItem_HIST(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_HIST::~vformItem_HIST(){}

void vformItem_HIST::printSelf()
{
  printf("HIST");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_HIST::get_text()
{ return text; }
void vformItem_HIST::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

vformItem_PLOT::vformItem_PLOT(){}

vformItem_PLOT::vformItem_PLOT(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_PLOT::~vformItem_PLOT(){}

void vformItem_PLOT::printSelf()
{
  printf("PLOT");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_PLOT::get_text()
{ return text; }
void vformItem_PLOT::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

vformItem_STAT::vformItem_STAT(){}

vformItem_STAT::vformItem_STAT(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_STAT::~vformItem_STAT(){}

void vformItem_STAT::printSelf()
{
  printf("STAT");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_STAT::get_text()
{ return text; }
void vformItem_STAT::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

vformItem_ALL::vformItem_ALL(){}

vformItem_ALL::~vformItem_ALL(){}

void vformItem_ALL::printSelf()
{
  printf("ALL");
}

/********************************************************************/

vformItem_DME::vformItem_DME(){}

vformItem_DME::vformItem_DME(
  stringVal * textIn)
{
  text = textIn;
}

vformItem_DME::~vformItem_DME(){}

void vformItem_DME::printSelf()
{
  printf("DME");
  if (text)
    {
      printf(",");
      text->printSelf();
    }
}

stringVal * vformItem_DME::get_text()
{ return text; }
void vformItem_DME::set_text(stringVal * textIn)
{ text = textIn; }

/********************************************************************/

windefStm::windefStm(){}

windefStm::windefStm(
  vwLabel * vwLabelIn,
  windefMinor * windefMinorIn)
{
  a_vwLabel = vwLabelIn;
  a_windefMinor = windefMinorIn;
}

windefStm::~windefStm(){}

void windefStm::printSelf()
{
  a_vwLabel->printSelf();
  printf("=");
  printf("WINDEF");
  printf("/");
  a_windefMinor->printSelf();
  printf("%c%c", 13, 10);
}

vwLabel * windefStm::get_vwLabel()
{ return a_vwLabel; }
void windefStm::set_vwLabel(vwLabel * vwLabelIn)
{ a_vwLabel = vwLabelIn; }
windefMinor * windefStm::get_windefMinor()
{ return a_windefMinor; }
void windefStm::set_windefMinor(windefMinor * windefMinorIn)
{ a_windefMinor = windefMinorIn; }

/********************************************************************/

windefMinor::windefMinor(){};

windefMinor::~windefMinor(){}

/********************************************************************/

windefEdgeln::windefEdgeln(){}

windefEdgeln::windefEdgeln(
  impCartPoint * impCartPointIn,
  angle * angleIn,
  rentVal * lenIn)
{
  a_impCartPoint = impCartPointIn;
  a_angle = angleIn;
  len = lenIn;
}

windefEdgeln::~windefEdgeln(){}

void windefEdgeln::printSelf()
{
  printf("EDGELN");
  printf(",");
  a_impCartPoint->printSelf();
  printf(",");
  a_angle->printSelf();
  printf(",");
  len->printSelf();
}

impCartPoint * windefEdgeln::get_impCartPoint()
{ return a_impCartPoint; }
void windefEdgeln::set_impCartPoint(impCartPoint * impCartPointIn)
{ a_impCartPoint = impCartPointIn; }
angle * windefEdgeln::get_angle()
{ return a_angle; }
void windefEdgeln::set_angle(angle * angleIn)
{ a_angle = angleIn; }
rentVal * windefEdgeln::get_len()
{ return len; }
void windefEdgeln::set_len(rentVal * lenIn)
{ len = lenIn; }

/********************************************************************/

windefBox::windefBox(){}

windefBox::windefBox(
  impCartPoint * impCartPointIn,
  rentVal * dxIn,
  rentVal * dyIn,
  angle * angleIn)
{
  a_impCartPoint = impCartPointIn;
  dx = dxIn;
  dy = dyIn;
  a_angle = angleIn;
}

windefBox::~windefBox(){}

void windefBox::printSelf()
{
  printf("BOX");
  printf(",");
  a_impCartPoint->printSelf();
  printf(",");
  dx->printSelf();
  printf(",");
  dy->printSelf();
  printf(",");
  a_angle->printSelf();
}

impCartPoint * windefBox::get_impCartPoint()
{ return a_impCartPoint; }
void windefBox::set_impCartPoint(impCartPoint * impCartPointIn)
{ a_impCartPoint = impCartPointIn; }
rentVal * windefBox::get_dx()
{ return dx; }
void windefBox::set_dx(rentVal * dxIn)
{ dx = dxIn; }
rentVal * windefBox::get_dy()
{ return dy; }
void windefBox::set_dy(rentVal * dyIn)
{ dy = dyIn; }
angle * windefBox::get_angle()
{ return a_angle; }
void windefBox::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

wristStm::wristStm(){}

wristStm::wristStm(
  swLabel * swLabelIn,
  std::list<wristDef *> * wristListIn,
  wristMountOffset * wristMountOffsetIn,
  wristDataDesc * wristDataDescIn)
{
  a_swLabel = swLabelIn;
  a_wristList = wristListIn;
  a_wristMountOffset = wristMountOffsetIn;
  a_wristDataDesc = wristDataDescIn;
}

wristStm::~wristStm(){}

void wristStm::printSelf()
{
  a_swLabel->printSelf();
  printf("=");
  printf("WRIST");
  printf("/");
  if (a_wristList->begin() == a_wristList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<wristDef *>::iterator iter;
      for (iter = a_wristList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_wristList->end())
            break;
          printf(",");
        }
    }
  printf(",");
  a_wristMountOffset->printSelf();
  if (a_wristDataDesc)
    {
      printf(",");
      a_wristDataDesc->printSelf();
    }
  printf("%c%c", 13, 10);
}

swLabel * wristStm::get_swLabel()
{ return a_swLabel; }
void wristStm::set_swLabel(swLabel * swLabelIn)
{ a_swLabel = swLabelIn; }
std::list<wristDef *> * wristStm::get_wristList()
{ return a_wristList; }
void wristStm::set_wristList(std::list<wristDef *> * wristListIn)
{ a_wristList = wristListIn; }
wristMountOffset * wristStm::get_wristMountOffset()
{ return a_wristMountOffset; }
void wristStm::set_wristMountOffset(wristMountOffset * wristMountOffsetIn)
{ a_wristMountOffset = wristMountOffsetIn; }
wristDataDesc * wristStm::get_wristDataDesc()
{ return a_wristDataDesc; }
void wristStm::set_wristDataDesc(wristDataDesc * wristDataDescIn)
{ a_wristDataDesc = wristDataDescIn; }

/********************************************************************/

wristDef::wristDef(){}

wristDef::wristDef(
  wristMountDef * wristMountDefIn,
  wristRotDef * wristRotDefIn)
{
  a_wristMountDef = wristMountDefIn;
  a_wristRotDef = wristRotDefIn;
}

wristDef::~wristDef(){}

void wristDef::printSelf()
{
  a_wristMountDef->printSelf();
  printf(",");
  a_wristRotDef->printSelf();
}

wristMountDef * wristDef::get_wristMountDef()
{ return a_wristMountDef; }
void wristDef::set_wristMountDef(wristMountDef * wristMountDefIn)
{ a_wristMountDef = wristMountDefIn; }
wristRotDef * wristDef::get_wristRotDef()
{ return a_wristRotDef; }
void wristDef::set_wristRotDef(wristRotDef * wristRotDefIn)
{ a_wristRotDef = wristRotDefIn; }

/********************************************************************/

wristMountDef::wristMountDef(){}

wristMountDef::wristMountDef(
  vector * offsetIn,
  vector * axisVecIn,
  vector * zeroVecIn)
{
  offset = offsetIn;
  axisVec = axisVecIn;
  zeroVec = zeroVecIn;
}

wristMountDef::~wristMountDef(){}

void wristMountDef::printSelf()
{
  printf("ROTCEN");
  printf(",");
  offset->printSelf();
  printf(",");
  axisVec->printSelf();
  printf(",");
  zeroVec->printSelf();
}

vector * wristMountDef::get_offset()
{ return offset; }
void wristMountDef::set_offset(vector * offsetIn)
{ offset = offsetIn; }
vector * wristMountDef::get_axisVec()
{ return axisVec; }
void wristMountDef::set_axisVec(vector * axisVecIn)
{ axisVec = axisVecIn; }
vector * wristMountDef::get_zeroVec()
{ return zeroVec; }
void wristMountDef::set_zeroVec(vector * zeroVecIn)
{ zeroVec = zeroVecIn; }

/********************************************************************/

wristRotDef::wristRotDef(){}

wristRotDef::wristRotDef(
  stringVal * anglenameIn,
  wristRotLimit * wristRotLimitIn,
  wristRotStep * wristRotStepIn)
{
  anglename = anglenameIn;
  a_wristRotLimit = wristRotLimitIn;
  a_wristRotStep = wristRotStepIn;
}

wristRotDef::~wristRotDef(){}

void wristRotDef::printSelf()
{
  printf("ANGLE");
  printf(",");
  anglename->printSelf();
  printf(",");
  a_wristRotLimit->printSelf();
  printf(",");
  a_wristRotStep->printSelf();
}

stringVal * wristRotDef::get_anglename()
{ return anglename; }
void wristRotDef::set_anglename(stringVal * anglenameIn)
{ anglename = anglenameIn; }
wristRotLimit * wristRotDef::get_wristRotLimit()
{ return a_wristRotLimit; }
void wristRotDef::set_wristRotLimit(wristRotLimit * wristRotLimitIn)
{ a_wristRotLimit = wristRotLimitIn; }
wristRotStep * wristRotDef::get_wristRotStep()
{ return a_wristRotStep; }
void wristRotDef::set_wristRotStep(wristRotStep * wristRotStepIn)
{ a_wristRotStep = wristRotStepIn; }

/********************************************************************/

wristRotLimit::wristRotLimit(){};

wristRotLimit::~wristRotLimit(){}

/********************************************************************/

wristRotLimit_angle::wristRotLimit_angle(){}

wristRotLimit_angle::wristRotLimit_angle(
  angle * beginIn,
  angle * endIn)
{
  begin = beginIn;
  end = endIn;
}

wristRotLimit_angle::~wristRotLimit_angle(){}

void wristRotLimit_angle::printSelf()
{
  begin->printSelf();
  printf(",");
  end->printSelf();
}

angle * wristRotLimit_angle::get_begin()
{ return begin; }
void wristRotLimit_angle::set_begin(angle * beginIn)
{ begin = beginIn; }
angle * wristRotLimit_angle::get_end()
{ return end; }
void wristRotLimit_angle::set_end(angle * endIn)
{ end = endIn; }

/********************************************************************/

wristRotLimit_THRU::wristRotLimit_THRU(){}

wristRotLimit_THRU::~wristRotLimit_THRU(){}

void wristRotLimit_THRU::printSelf()
{
  printf("THRU");
}

/********************************************************************/

wristRotStep::wristRotStep(){};

wristRotStep::~wristRotStep(){}

/********************************************************************/

wristRotStep_angle::wristRotStep_angle(){}

wristRotStep_angle::wristRotStep_angle(
  angle * angleIn)
{
  a_angle = angleIn;
}

wristRotStep_angle::~wristRotStep_angle(){}

void wristRotStep_angle::printSelf()
{
  a_angle->printSelf();
}

angle * wristRotStep_angle::get_angle()
{ return a_angle; }
void wristRotStep_angle::set_angle(angle * angleIn)
{ a_angle = angleIn; }

/********************************************************************/

wristRotStep_CONTIN::wristRotStep_CONTIN(){}

wristRotStep_CONTIN::~wristRotStep_CONTIN(){}

void wristRotStep_CONTIN::printSelf()
{
  printf("CONTIN");
}

/********************************************************************/

wristMountOffset::wristMountOffset(){}

wristMountOffset::wristMountOffset(
  vector * offsetIn)
{
  offset = offsetIn;
}

wristMountOffset::~wristMountOffset(){}

void wristMountOffset::printSelf()
{
  printf("MNTLEN");
  printf(",");
  offset->printSelf();
}

vector * wristMountOffset::get_offset()
{ return offset; }
void wristMountOffset::set_offset(vector * offsetIn)
{ offset = offsetIn; }

/********************************************************************/

wristDataDesc::wristDataDesc(){};

wristDataDesc::~wristDataDesc(){}

/********************************************************************/

wristDataDesc_stringVal::wristDataDesc_stringVal(){}

wristDataDesc_stringVal::wristDataDesc_stringVal(
  stringVal * dataStorIn,
  stringVal * dataListIn,
  stringVal * dataItemIn)
{
  dataStor = dataStorIn;
  dataList = dataListIn;
  dataItem = dataItemIn;
}

wristDataDesc_stringVal::~wristDataDesc_stringVal(){}

void wristDataDesc_stringVal::printSelf()
{
  dataStor->printSelf();
  printf(",");
  dataList->printSelf();
  printf(",");
  dataItem->printSelf();
}

stringVal * wristDataDesc_stringVal::get_dataStor()
{ return dataStor; }
void wristDataDesc_stringVal::set_dataStor(stringVal * dataStorIn)
{ dataStor = dataStorIn; }
stringVal * wristDataDesc_stringVal::get_dataList()
{ return dataList; }
void wristDataDesc_stringVal::set_dataList(stringVal * dataListIn)
{ dataList = dataListIn; }
stringVal * wristDataDesc_stringVal::get_dataItem()
{ return dataItem; }
void wristDataDesc_stringVal::set_dataItem(stringVal * dataItemIn)
{ dataItem = dataItemIn; }

/********************************************************************/

wristDataDesc_intVal::wristDataDesc_intVal(){}

wristDataDesc_intVal::wristDataDesc_intVal(
  stringVal * dataStorIn,
  stringVal * dataListIn,
  intVal * indexIn)
{
  dataStor = dataStorIn;
  dataList = dataListIn;
  index = indexIn;
}

wristDataDesc_intVal::~wristDataDesc_intVal(){}

void wristDataDesc_intVal::printSelf()
{
  dataStor->printSelf();
  printf(",");
  dataList->printSelf();
  printf(",");
  index->printSelf();
}

stringVal * wristDataDesc_intVal::get_dataStor()
{ return dataStor; }
void wristDataDesc_intVal::set_dataStor(stringVal * dataStorIn)
{ dataStor = dataStorIn; }
stringVal * wristDataDesc_intVal::get_dataList()
{ return dataList; }
void wristDataDesc_intVal::set_dataList(stringVal * dataListIn)
{ dataList = dataListIn; }
intVal * wristDataDesc_intVal::get_index()
{ return index; }
void wristDataDesc_intVal::set_index(intVal * indexIn)
{ index = indexIn; }

/********************************************************************/

writeStm::writeStm(){}

writeStm::writeStm(
  didLabel * didLabelIn,
  std::list<writeSpec *> * writeSpecListIn)
{
  a_didLabel = didLabelIn;
  a_writeSpecList = writeSpecListIn;
}

writeStm::~writeStm(){}

void writeStm::printSelf()
{
  printf("WRITE");
  printf("/");
  a_didLabel->printSelf();
  printf(",");
  if (a_writeSpecList->begin() == a_writeSpecList->end())
    fprintf(stderr, "list empty\n");
  else
    {
      std::list<writeSpec *>::iterator iter;
      for (iter = a_writeSpecList->begin(); ; )
        {
          (*iter)->printSelf();
          if (++iter == a_writeSpecList->end())
            break;
          printf(",");
        }
    }
  printf("%c%c", 13, 10);
}

didLabel * writeStm::get_didLabel()
{ return a_didLabel; }
void writeStm::set_didLabel(didLabel * didLabelIn)
{ a_didLabel = didLabelIn; }
std::list<writeSpec *> * writeStm::get_writeSpecList()
{ return a_writeSpecList; }
void writeStm::set_writeSpecList(std::list<writeSpec *> * writeSpecListIn)
{ a_writeSpecList = writeSpecListIn; }

/********************************************************************/

writeSpec::writeSpec(){};

writeSpec::~writeSpec(){}

/********************************************************************/

writeSpec_stringConst::writeSpec_stringConst(){}

writeSpec_stringConst::writeSpec_stringConst(
  stringConst * stringConstIn)
{
  a_stringConst = stringConstIn;
}

writeSpec_stringConst::~writeSpec_stringConst(){}

void writeSpec_stringConst::printSelf()
{
  a_stringConst->printSelf();
}

stringConst * writeSpec_stringConst::get_stringConst()
{ return a_stringConst; }
void writeSpec_stringConst::set_stringConst(stringConst * stringConstIn)
{ a_stringConst = stringConstIn; }

/********************************************************************/

writeSpec_stringFunc::writeSpec_stringFunc(){}

writeSpec_stringFunc::writeSpec_stringFunc(
  stringFunc * stringFuncIn)
{
  a_stringFunc = stringFuncIn;
}

writeSpec_stringFunc::~writeSpec_stringFunc(){}

void writeSpec_stringFunc::printSelf()
{
  a_stringFunc->printSelf();
}

stringFunc * writeSpec_stringFunc::get_stringFunc()
{ return a_stringFunc; }
void writeSpec_stringFunc::set_stringFunc(stringFunc * stringFuncIn)
{ a_stringFunc = stringFuncIn; }

/********************************************************************/

writeSpec_rwVar::writeSpec_rwVar(){}

writeSpec_rwVar::writeSpec_rwVar(
  rwVar * rwVarIn,
  rwFormat * rwFormatIn)
{
  a_rwVar = rwVarIn;
  a_rwFormat = rwFormatIn;
}

writeSpec_rwVar::~writeSpec_rwVar(){}

void writeSpec_rwVar::printSelf()
{
  a_rwVar->printSelf();
  if (a_rwFormat)
    {
      a_rwFormat->printSelf();
    }
}

rwVar * writeSpec_rwVar::get_rwVar()
{ return a_rwVar; }
void writeSpec_rwVar::set_rwVar(rwVar * rwVarIn)
{ a_rwVar = rwVarIn; }
rwFormat * writeSpec_rwVar::get_rwFormat()
{ return a_rwFormat; }
void writeSpec_rwVar::set_rwFormat(rwFormat * rwFormatIn)
{ a_rwFormat = rwFormatIn; }

/********************************************************************/

xternStm::xternStm(){}

xternStm::~xternStm(){}

void xternStm::printSelf()
{
  printf("XTERN");
  printf("%c%c", 13, 10);
}

/********************************************************************/

xtractStm::xtractStm(){}

xtractStm::xtractStm(
  fLabel * fLabelIn,
  faLabel * faLabelIn)
{
  a_fLabel = fLabelIn;
  a_faLabel = faLabelIn;
}

xtract