/*

This reads lines from the file whose name is the first command
argument until a line starting with "0 parser errors" is
encountered. If there were no parser errors and no parser warnings,
this is the first line.  If there were parser warnings but no parser errors,
this is some other line. If there were parser errors, that line is never
found, so 1 is returned.

If there are expected to be parser warnings but no parser errors, the
second command argument should be 1, and in this case the function
does nothing more except return 0.

Otherwise, the function checks that the next line starts with
"0 parser warnings".  If not the function returns 1.

If there are expected to be no parser errors or warnings, but there are
expected to be conformance tester errors, the second command argument
should be 2, and in the case the function does nothing more except return 0.

If there are expected to be no errors or warnings of any sort, the second
command argument should be something other than 1 or 2 (4 is good). In
this case the function checks that the fourth line of the file starts with
"0 conformance checker errors". If it does, 0 is returned. Otherwise, 1
is returned.

This is using strncmp rather than strcmp because the line endings may
differ between Linux (or Sun) and Windows.

*/
 
#include <stdio.h>
#include <string.h>

int main(int argc, char * argv[])
{
  FILE * inFile;
  char buf[2000];
  char * result;
 
  inFile = fopen(argv[1], "r");
  if (inFile == 0)
    return(1);
  while ((result = fgets(buf, 2000, inFile)))
    {
      if (strncmp(buf, "0 parser errors", 15) == 0)
	break;
    }
  if (result == 0)
    {
      fclose(inFile);
      return(1);
    }
  if (argv[2][0] == '1') 
    return 0;
  if (fgets(buf, 2000, inFile) == 0) { fclose(inFile); return(1); }
  if (strncmp(buf, "0 parser warnings", 17))
    {
      fclose(inFile);
      return(1);
    }
  if (argv[2][0] == '2') 
    return 0;
  if (fgets(buf, 2000, inFile) == 0) { fclose(inFile); return(1); }
  if (fgets(buf, 2000, inFile) == 0) { fclose(inFile); return(1); }
  return (strncmp(buf, "0 conformance checker errors", 28) ? 1 : 0);
}

