#include <string.h>  // for strlen, strcpy, strcat
#include <stdio.h>   // for fopen, etc.

/*

This takes three arguments:
1. the name of a file containing report messages that should be 
   produced by the dmisParser.
2. the name of a file containing report messages that were produced
   by the dmisParser, followed by a reprint of the DMIS input file
   that was parsed by the dmisParser.
3. the name of a file to print that (if the check below passes) will
   contain the end of the second input file (the reprinted file part).

This checks that the lines at the beginning of the second input file
are identical to the lines of the first input file. If so, this returns 0.
If not, this returns 1.

If any of the files cannot be opened, this also returns 1.

*/

int main(int argc, char * argv[])
{
  FILE * startFile;
  FILE * inFile;
  FILE * outFile;
  char inBuf[2000];
  char startBuf[2000];

  if (argc != 4)
    return(1);
  startFile = fopen(argv[1], "r");
  if (startFile == 0)
    {
      fclose(startFile);
      return(1);
    }
  inFile = fopen(argv[2], "r");
  if (inFile == 0)
    {
      fclose(startFile);
      fclose(inFile);
      return(1);
    }
  outFile = fopen(argv[3], "w");
  if (outFile == 0)
    {
      fclose(startFile);
      fclose(inFile);
      fclose(outFile);
      return(1);
    }
  while (fgets(startBuf, 2000, startFile))
    {
      if (fgets(inBuf, 2000, inFile) == 0)
	{
	  fclose(startFile);
	  fclose(inFile);
	  fclose(outFile);
	  return(1);
	}
      if (strcmp(inBuf, startBuf))
	{
	  fclose(startFile);
	  fclose(inFile);
	  fclose(outFile);
	  return(1);
	}
    }
  while (fgets(inBuf, 2000, inFile))
    {
      fprintf(outFile, "%s", inBuf);
    }
  fclose(startFile);
  fclose(inFile);
  fclose(outFile);
  return(0);
}
