/* makeBound

This is a simple tutorial program illustrating how to build a DMIS
statement using C++ classes. The executable compiled from this
program prints the line

BOUND/F(f1),F(f2),F(f3)

This example shows a second method of using classes and functions from
the NDTS namespace. If you are able to handle any conflicts that
arise between names in your code and names in the NDTS namespace by
changing your code, then the one line "using namespace NDTS;" will
allow you to use everything in the NDTS namespace without using the
NDTS:: prefix. The #include must come before the "using namespace NDTS;".

*/

#include "dmis.hh"

using namespace NDTS;

boundStm * makeBound2(
 char * boundLabel,
 char * featLabel1,
 char * featLabel2)
{
  std::list<featureLabel *> * featureLabels;

  featureLabels = new std::list<featureLabel *>;
  featureLabels->push_back(new fLabel
			   (new labelNameCon
			    (new labelNameConst(featLabel1))));
  featureLabels->push_back(new fLabel
			   (new labelNameCon
			    (new labelNameConst(featLabel2))));
  return new boundStm
    (new boundFeat
     (new fLabel
      (new labelNameCon
       (new labelNameConst(boundLabel))),
      featureLabels));
}

int main()
{
  makeBound2("f1", "f2", "f3")->printSelf();
  return 0;
}
