#ifndef DMIS_HH
#define DMIS_HH
/*

This file defines classes used to represent data in program files.
The meaning of each class definition is documented. In the
documentation, punctuation marks and special characters that should
appear in program files are enclosed in quotes. Special characters
such as square brackets [] used to represent items that are optional
in program files are used without quotes.

A class is defined for each definition of each production in the EBNF
file that does not define a list or give the spelling of a token. In
addition, a parent class is defined for each production that has two
or more definitions.

Items such as command names and commas that are always the same in
every instance of a class are not represented in the class. Only those
items than can differ between instances are represented. For example
a boundStm has the EBNF form "BOUND '/' boundMinor #". The only
thing in a boundStm that varies between instances is the boundMinor, so
only the boundMinor is represented in the boundStm class.

Each item from an EBNF definition that is represented in a C++ class for
the definition is represented by a data member of the class. Each
represented item is either a list or a class, and they are represented
as follows.

   Each list data member is represented by a pointer to a C++ standard
   library list of pointers to the class for the item of which the list
   is composed. For example, a dmisItemList is a list of dmisItem, and
   inputFile uses dmisItemList, so in the definition of the C++ inputFile
   class, there is the line "std::list<dmisItem *> * a_dmisItemList;".

   Every other data member is represented by a pointer to the class for
   that item. For example the boundStm class has only one data member.
   The data member is a pointer to a boundMinor. In the definition of
   the boundStm class, there is the line "boundMinor * a_boundMinor;"

Optional items for terminals and nonterminals are represented the same
way as non-optional items. The only difference is that when an
instance of a class is built, any pointer to an optional item may be
NULL, while no pointer to a non-optional item may be NULL.

The entire set of optional items in an optional containing only
constants (no terminal or nonterminal) are represented by a single
boolean. The boolean is true if the optional is present and false if
not.

For each data member of a C++ class, there is a method to get the data
member, and a method to set it. The name of each method is the name of the
data member preceded by either "get_" or "set_". The get method
has no arguments and returns the type of data in the data member. The set
method has an argument whose type is the type of the data member and
returns nothing.

Each class from which no other class is derived has two constructors and
a destructor. One of the constructors takes no arguments, and all it does
is set the "typ" data member of the base class. The other constructor
takes as many arguments as there are data members and sets all the data
members.

*/

#include <list>

namespace NDTS {

#define isA(a,b) dynamic_cast<b *>(a)

class aboveBelow;
class aboveBelow_ABOVE;
class aboveBelow_BELOW;
class aclratAngSpec;
class aclratAngular;
class aclratDef;
class aclratDef_DEFALT;
class aclratDef_HIGH;
class aclratDef_LOW;
class aclratDef_PCENT;
class aclratHedMeas;
class aclratHedRot;
class aclratHedScan;
class aclratLinSpec;
class aclratLinear;
class aclratLinear_IPMM;
class aclratLinear_IPSS;
class aclratLinear_MMPSS;
class aclratLinear_MPMM;
class aclratMeas;
class aclratMinor;
class aclratPos;
class aclratRot;
class aclratScan;
class aclratStm;
class algdefMinor;
class algdefMinor_CODE;
class algdefMinor_stringVal;
class algdefStm;
class angle;
class angleDms;
class angleUnit;
class angleUnit_ANGDEC;
class angleUnit_ANGDMS;
class angleUnit_ANGRAD;
class anyVal;
class arrayIndex;
class assignBool;
class assignInt;
class assignReal;
class assignStm;
class assignStm_assignBool;
class assignStm_assignInt;
class assignStm_assignReal;
class assignStm_assignString;
class assignStm_assignVector;
class assignString;
class assignVector;
class avgMaxMin;
class avgMaxMin_AVG;
class avgMaxMin_MAX;
class avgMaxMin_MIN;
class axial;
class axis;
class axis_XAXIS;
class axis_YAXIS;
class axis_ZAXIS;
class badtstStm;
class bfConst;
class bfConst_featureList;
class bfConst_indexedFeatureList;
class boolConst;
class boolConst_FALSE;
class boolConst_TRUE;
class boolExpr;
class boolExpr_PAREN;
class boolExpr_boolRel;
class boolExpr_intRel;
class boolExpr_realRel;
class boolExpr_stringRel;
class boolExpr_vectorRel;
class boolFunc;
class boolFuncBadgt;
class boolFuncBadpt;
class boolFuncEof;
class boolFuncEoln;
class boolFuncExist;
class boolFuncExist_dLabel;
class boolFuncExist_daLabel;
class boolFuncExist_didLabel;
class boolFuncExist_fLabel;
class boolFuncExist_faLabel;
class boolFuncExist_sLabel;
class boolFuncExist_saLabel;
class boolRel;
class boolRel_AND;
class boolRel_EQ;
class boolRel_NE;
class boolRel_NOT;
class boolRel_OR;
class boolVal;
class boolVar;
class boundFeat;
class boundMinor;
class boundStm;
class boundTol;
class cadfileType;
class cadfileType_IGES;
class cadfileType_STEP;
class cadfileType_VENDOR;
class calibMasterBlock;
class calibMasterMinor;
class calibMasterStm;
class calibRtabBlock;
class calibRtabMinor;
class calibRtabMinorRecalib;
class calibRtabMinorSpec;
class calibRtabSpec;
class calibRtabSpec_fLabel;
class calibRtabSpec_faLabel;
class calibRtabStm;
class calibSensBlock;
class calibSensBlockItem;
class calibSensBlockStatement;
class calibSensCaseBlock;
class calibSensDefaultCaseBlock;
class calibSensDoBlock;
class calibSensIfBlock;
class calibSensMinor;
class calibSensMinorRecalib;
class calibSensMinorSpec;
class calibSensSelectBlock;
class calibSensSpec;
class calibSensSpecInt;
class calibSensSpecString;
class calibSensStm;
class callBlock;
class callMacro;
class callMinor;
class callModule;
class callProgram;
class callRoutine;
class callStm;
class callType;
class callType_ATTACH;
class callType_CONT;
class callType_WAIT;
class cartPoint;
class caseBlock;
class caseStm;
class caseStmInt;
class caseStmString;
class ccLabel;
class ciLabel;
class clmpidStm;
class clmpsnStm;
class closeDelete;
class closeEnd;
class closeKeep;
class closeMinor;
class closePlain;
class closeStm;
class cmpntgrpSpec;
class cmpntgrpStm;
class cnfrmrulCode;
class cnfrmrulMinor;
class cnfrmrulName;
class cnfrmrulStm;
class cogConst;
class coneConst;
class coneConst_DIAM;
class coneConst_DIST;
class conformItem;
class conformType;
class conformType_CT;
class conformType_FX;
class conformType_IP;
class conformType_MC;
class conformType_MU;
class conformType_PM;
class conformType_QI;
class conformType_RY;
class conformType_SF;
class conformType_TW;
class constArc;
class constArc_bfConst;
class constArc_projctConst;
class constArc_trConst;
class constCircle;
class constCircle_bfConst;
class constCircle_coneConst;
class constCircle_intofConst;
class constCircle_projctConst;
class constCircle_retrieve2;
class constCircle_tantoConst;
class constCircle_trConst;
class constCompound;
class constCone;
class constCone_bfConst;
class constCone_trConst;
class constCparln;
class constCparln_bfConst;
class constCparln_projctConst;
class constCparln_retrieve2;
class constCparln_trConst;
class constCylndr;
class constCylndr_bfConst;
class constCylndr_retrieve1;
class constCylndr_trConst;
class constEdgept;
class constEllips;
class constEllips_bfConst;
class constEllips_intofConst;
class constEllips_projctConst;
class constEllips_trConst;
class constGcurve;
class constGcurve_bfConst;
class constGcurve_projctConst;
class constGcurve_trConst;
class constGeom;
class constGsurf;
class constGsurf_bfConst;
class constGsurf_trConst;
class constLine;
class constLine_bfConst;
class constLine_intofConst;
class constLine_midliConst;
class constLine_offsetConst;
class constLine_partoConst;
class constLine_perptoConst;
class constLine_projliConst;
class constLine_tantoConst;
class constLine_trConst;
class constMinor;
class constParpln;
class constPatern;
class constPatern_BUILD;
class constPatern_trConst;
class constPlane;
class constPlane_bfConst;
class constPlane_midplConst;
class constPlane_offsetConst;
class constPlane_partoConst;
class constPlane_perptoConst;
class constPlane_tantoConstPlane;
class constPlane_trConst;
class constPoint;
class constPoint_cogConst;
class constPoint_curveConst;
class constPoint_extremConst;
class constPoint_intofConst;
class constPoint_midptConst;
class constPoint_moveptConst;
class constPoint_pierceConst;
class constPoint_projptConst;
class constPoint_retrieve1;
class constPoint_trConst;
class constPoint_vertexConst;
class constRctngl;
class constRctngl_bfConst;
class constRctngl_trConst;
class constSgage;
class constSpart;
class constSphere;
class constSphere_bfConst;
class constSphere_retrieve2b;
class constSphere_trConst;
class constStm;
class constSympln;
class constTorus;
class constTorus_bfConst;
class constTorus_trConst;
class coordType;
class coordType_CART;
class coordType_POL;
class crLabel;
class crLabelConst;
class crgdefData;
class crgdefMinor;
class crgdefNoData;
class crgdefStm;
class criticality;
class criticality_CRITICAL;
class criticality_MAJOR;
class criticality_MINOR;
class crmodeMinor;
class crmodeMinor_SEQNTL;
class crmodeMinor_SIMUL;
class crmodeMinor_SYNC;
class crmodeStm;
class crosclStm;
class crslctMinor;
class crslctMinor_ALL;
class crslctMinor_crLabelConst;
class crslctStm;
class csLabel;
class csSpec;
class csSpec_HEADCS;
class csSpec_PCS;
class curveConst;
class curvePtdataHeadcs;
class curvePtdataHeadcsListItem;
class curvePtdataPcs;
class curvePtdataPcsListItem;
class cutcomAdjust;
class cutcomMatrix;
class cutcomMatx;
class cutcomMinor;
class cutcomParam;
class cutcomStm;
class cutcomUserdf;
class czLabel;
class czoneStm;
class czslctStm;
class dLabel;
class daLabel;
class datLabel;
class datdefMinor;
class datdefMinor_dattrgList;
class datdefMinor_featureLabel1;
class datdefStm;
class datsetDats;
class datsetDrf;
class datsetMatrix;
class datsetMcs;
class datsetMinor;
class datsetSpec;
class datsetSpecDir;
class datsetSpecNoDir;
class datsetStm;
class dattrgLabel;
class dattrgMinor;
class dattrgdefStm;
class datumLabel;
class datumLabel1;
class datumLabel2;
class declMinor;
class declScope;
class declScope_COMMON;
class declScope_GLOBAL;
class declScope_LOCAL;
class declStm;
class declType;
class declType_BOOL;
class declType_CHAR;
class declType_DOUBLE;
class declType_INTGR;
class declType_LONG;
class declType_REAL;
class declType_VECTOR;
class declVar;
class decplAll;
class decplMinor;
class decplMinor_decplAll;
class decplMinor_decplList;
class decplNdigits;
class decplNdigits_DEFALT;
class decplNdigits_intVal;
class decplSelection;
class decplSelection_ANGLE;
class decplSelection_DEV;
class decplSelection_DIST;
class decplSelection_HUMID;
class decplSelection_TEMP;
class decplSelection_VEC;
class decplStm;
class defaultCaseBlock;
class deleteAllSensors;
class deleteDatum;
class deleteFeature;
class deleteMinor;
class deleteRotaryTable;
class deleteSensor;
class deleteStm;
class device;
class deviceMinor;
class deviceMinor_INCR;
class deviceMinor_device;
class deviceStm;
class device_COMM;
class device_PRINT;
class device_STOR;
class device_TERM;
class dftcasStm;
class diLabel;
class didLabel;
class dir;
class displyItemDMIS;
class displyItemNoDMIS;
class displyOff;
class displySpecItem;
class displyStm;
class displyStmOff;
class displyStmSpec;
class dmehwMinor;
class dmehwMinor_AUTO;
class dmehwMinor_CONTIN;
class dmehwMinor_PAUSE;
class dmehwMinor_SINGLE;
class dmehwMinor_jointConf;
class dmehwStm;
class dmeidStm;
class dmeswComand;
class dmeswDelay;
class dmeswMinor;
class dmeswStm;
class dmeswSwitch;
class dmeswSwitch_CONTIN;
class dmeswSwitch_PAUSE;
class dmeswiStm;
class dmeswvStm;
class dmisBlock;
class dmisFirstStatement;
class dmisFreeStatement;
class dmisItem;
class dmisOffBlock;
class dmisOffStm;
class dmisOnStm;
class dmismdStm;
class dmismnStm;
class doBlock;
class doStm;
class drLabel;
class dsLabel;
class dvLabel;
class elseStm;
class endcasStm;
class enddoStm;
class endfilStm;
class endgoStm;
class endifStm;
class endmacStm;
class endmesStm;
class endselStm;
class endsimreqtStm;
class endxtnStm;
class equateCad;
class equateCadcs;
class equateCadcs_matrix;
class equateCadcs_stringVal;
class equateDatum;
class equateMinor;
class equateStm;
class errorCondition;
class errorCondition_ALL;
class errorCondition_ILLEGALTOUCH;
class errorCondition_NOTOUCH;
class errorCondition_intVal;
class errorMinor;
class errorMinor_AUTO;
class errorMinor_OFF;
class errorMinor_jumpLabel;
class errorStm;
class euler;
class evalDat;
class evalDatDatFa;
class evalDatFaDat;
class evalFeat;
class evalFeatFFaT;
class evalFeatFaFT;
class evalFeatFaFaT;
class evalFeatFaT;
class evalKeychar;
class evalMinor;
class evalOrOutput;
class evalStm;
class extensMinor;
class extensMinor_VEC;
class extensMinor_vector;
class extensStm;
class extfilDme;
class extfilDmis;
class extfilMinor;
class extfilStm;
class extremConst;
class extremConstAxial;
class extremConstDir;
class extremConstFeature;
class extremConstRadial;
class extremConstVectorial;
class extremConst_MAX;
class extremConst_MIN;
class fLabel;
class faLabel;
class featArc1Act;
class featArc1Nom;
class featArc1Stm;
class featArc2Act;
class featArc2Nom;
class featArc2Stm;
class featCircleAct;
class featCircleNom;
class featCircleStm;
class featCompoundAxial;
class featCompoundPlane;
class featCompoundSphere;
class featCompoundStm;
class featConeAct;
class featConeNom;
class featConeStm;
class featConradsegAct;
class featConradsegCart;
class featConradsegNom;
class featConradsegPol;
class featConradsegStm;
class featCparlnAct;
class featCparlnNom;
class featCparlnStm;
class featCylndrAct;
class featCylndrNom;
class featCylndrStm;
class featCylradsegAct;
class featCylradsegCart;
class featCylradsegNom;
class featCylradsegPol;
class featCylradsegStm;
class featEdgeptAct;
class featEdgeptNom;
class featEdgeptStm;
class featEllipsAct;
class featEllipsCart;
class featEllipsNom;
class featEllipsPol;
class featEllipsStm;
class featElongcylAct;
class featElongcylNom;
class featElongcylStm;
class featGcurveCart;
class featGcurvePol;
class featGcurveStm;
class featGeomStm;
class featGsurfCart;
class featGsurfPlain;
class featGsurfPol;
class featGsurfStm;
class featLineAct;
class featLineBndCart;
class featLineBndPol;
class featLineNom;
class featLineStm;
class featLineUnbndCart;
class featLineUnbndPol;
class featMinorArc1;
class featMinorArc2;
class featMinorCircle;
class featMinorCompound;
class featMinorCone;
class featMinorConradseg;
class featMinorCparln;
class featMinorCylndr;
class featMinorCylradseg;
class featMinorEdgept;
class featMinorEllips;
class featMinorElongcyl;
class featMinorGcurve;
class featMinorGeom;
class featMinorGsurf;
class featMinorLine;
class featMinorObject;
class featMinorParpln;
class featMinorPatern;
class featMinorPlane;
class featMinorPoint;
class featMinorRctngl;
class featMinorRevsurf;
class featMinorSphere;
class featMinorSphradseg;
class featMinorSympln;
class featMinorTorradseg;
class featMinorTorus;
class featObjectAct;
class featObjectNom;
class featObjectStm;
class featParplnAct;
class featParplnMidplCart;
class featParplnMidplPol;
class featParplnNom;
class featParplnPointsCart;
class featParplnPointsPol;
class featParplnStm;
class featPaternStm;
class featPlaneAct;
class featPlaneNom;
class featPlaneStm;
class featPointAct;
class featPointNom;
class featPointStm;
class featRctnglAct;
class featRctnglNom;
class featRctnglStm;
class featRevsurfAct;
class featRevsurfCart;
class featRevsurfNom;
class featRevsurfPol;
class featRevsurfStm;
class featSphereAct;
class featSphereNom;
class featSphereStm;
class featSphradsegAct;
class featSphradsegNom;
class featSphradsegStm;
class featSymplnAct;
class featSymplnCart;
class featSymplnNom;
class featSymplnPol;
class featSymplnStm;
class featTorradsegAct;
class featTorradsegNom;
class featTorradsegStm;
class featTorusAct;
class featTorusNom;
class featTorusStm;
class featureLabel;
class featureLabel1;
class fedratAngSpec;
class fedratAngular;
class fedratDef;
class fedratDef_DEFALT;
class fedratDef_HIGH;
class fedratDef_LOW;
class fedratDef_PCENT;
class fedratHedMeas;
class fedratHedRot;
class fedratHedScan;
class fedratLinSpec;
class fedratLinear;
class fedratLinear_IPM;
class fedratLinear_IPS;
class fedratLinear_MMPS;
class fedratLinear_MPM;
class fedratMeas;
class fedratMinor;
class fedratPos;
class fedratRot;
class fedratScan;
class fedratStm;
class fiLabel;
class fildefStm;
class filnamStm;
class finposStm;
class fixtidStm;
class fixtsnStm;
class flatRoundOpen;
class flatRoundOpen_FLAT;
class flatRoundOpen_OPEN;
class flatRoundOpen_ROUND;
class flipNoFlip;
class flipNoFlip_FLIP;
class flipNoFlip_NOFLIP;
class flyMinor;
class flyMinor_OFF;
class flyMinor_rentVal;
class flyStm;
class forceOrDeflection;
class forceOrDeflection_DEFLECTION;
class forceOrDeflection_FORCE;
class fromMinor;
class fromMinor_DME;
class fromMinor_SCALE;
class fromMinor_cartPoint;
class fromMinor_impCartPoint;
class fromMinor_polPoint;
class fromStm;
class fsLabel;
class gLabel;
class geoalgArc;
class geoalgCircle;
class geoalgCone;
class geoalgConradsegmnt;
class geoalgCparln;
class geoalgCylndr;
class geoalgCylradsegmnt;
class geoalgEliminate;
class geoalgEliminateOff;
class geoalgEliminateStd;
class geoalgEllips;
class geoalgElongcyl;
class geoalgExternFunc;
class geoalgExternFunc_DME;
class geoalgExternFunc_DMIS;
class geoalgExternFunc_SYS;
class geoalgFiltSetElim;
class geoalgFiltSetFilt;
class geoalgFilter;
class geoalgFilterCirc;
class geoalgFilterCurve;
class geoalgFilterCurve_GAUSS;
class geoalgFilterCurve_RECFILT;
class geoalgFilterCurve_SPLINE;
class geoalgFilterCurve_TWORC;
class geoalgFilterLambda;
class geoalgFilterOff;
class geoalgFilterSettings;
class geoalgFilterType;
class geoalgFilterType_BANDPASS;
class geoalgFilterType_HIGHPASS;
class geoalgFilterType_LOWPASS;
class geoalgGcurve;
class geoalgGsurf;
class geoalgLine;
class geoalgMinor;
class geoalgObject;
class geoalgParpln;
class geoalgPlane;
class geoalgRctngl;
class geoalgRevsurf;
class geoalgSpec1;
class geoalgSpec1_DEFALT;
class geoalgSpec1_EXTERN;
class geoalgSpec1_LSTSQR;
class geoalgSpec1_MINMAX;
class geoalgSpec2;
class geoalgSpec2_DEFALT;
class geoalgSpec2_EXTERN;
class geoalgSpec2_LSTSQR;
class geoalgSpec2_MAXINS;
class geoalgSpec2_MINCIR;
class geoalgSpec2_MINMAX;
class geoalgSpec3;
class geoalgSpec3_DEFALT;
class geoalgSpec3_EXTERN;
class geoalgSpec4;
class geoalgSpec4_BSPLIN;
class geoalgSpec4_DEFALT;
class geoalgSpec4_EXTERN;
class geoalgSpec4_LSTSQR;
class geoalgSpec4_MINMAX;
class geoalgSpec5;
class geoalgSpec5_BEZIER;
class geoalgSpec5_DEFALT;
class geoalgSpec5_EXTERN;
class geoalgSpec5_LSTSQR;
class geoalgSpec5_MINMAX;
class geoalgSpec5_NURBS;
class geoalgSpec6;
class geoalgSpec6_BSPLIN;
class geoalgSpec6_DEFALT;
class geoalgSpec6_EXTERN;
class geoalgSpec6_LSTSQR;
class geoalgSphere;
class geoalgSphradsegmnt;
class geoalgStm;
class geoalgSympln;
class geoalgTorradsegmnt;
class geoalgTorus;
class geomEntityItem;
class geomMinor;
class geomStm;
class geomStmDid;
class geomStmEntity;
class geomStmNone;
class geomStmOffset;
class gohomeStm;
class gotargBlock;
class gotargCart;
class gotargPol;
class gotargStm;
class gotargXyz;
class gotoAbs;
class gotoAbsCart;
class gotoAbsCartSens;
class gotoAbsPol;
class gotoAbsPolSens;
class gotoAbsXyz;
class gotoAbsXyzSens;
class gotoArc;
class gotoAxis;
class gotoAxisSpec;
class gotoMinor;
class gotoRel;
class gotoStm;
class gotoWristAngleItem;
class gotoWristItem;
class groupStm;
class gsaLabel;
class ifBlock;
class ifStm;
class impCartPoint;
class impPolPoint;
class includDme;
class includDmis;
class includMinor;
class includStm;
class indexedFeature;
class inputAccess;
class inputFile;
class intConst;
class intExpr;
class intExprDivid;
class intExprMinus;
class intExprNegat;
class intExprParen;
class intExprPlus;
class intExprPosit;
class intExprPower;
class intExprTimes;
class intFunc;
class intFuncAbs;
class intFuncIndx;
class intFuncInt;
class intFuncLen;
class intFuncMod;
class intFuncNint;
class intFuncOrd;
class intFuncOrd_boolVal;
class intFuncOrd_stringVal;
class intFuncPtdata;
class intFuncSensnotouch;
class intFuncSign;
class intFuncSiltch;
class intRealExpr;
class intRealExpr_DIVID;
class intRealExpr_MINUS;
class intRealExpr_PLUS;
class intRealExpr_POWER;
class intRealExpr_TIMES;
class intRealRel;
class intRealRel_EQ;
class intRealRel_GE;
class intRealRel_GT;
class intRealRel_LE;
class intRealRel_LT;
class intRealRel_NE;
class intRel;
class intRel_EQ;
class intRel_GE;
class intRel_GT;
class intRel_LE;
class intRel_LT;
class intRel_NE;
class intVal;
class intVar;
class intVecExpr_TIMES;
class intofConst;
class iteratConvergence;
class iteratConvergence_ABSL;
class iteratConvergence_INCR;
class iteratCriterionItem;
class iteratCriterionStart;
class iteratCriterionStart_NOM;
class iteratCriterionStart_axis;
class iteratCriterionStart_vector;
class iteratMinor;
class iteratStm;
class jointConf;
class jumpLabel;
class jumpStm;
class jumptoStm;
class kcLabel;
class kcaLabel;
class keycharMinor;
class keycharOneFeature;
class keycharStm;
class keycharTwoFeatures;
class labelName;
class labelNameAt;
class labelNameCon;
class labelNameConst;
class leftRight;
class leftRight_LEFT;
class leftRight_RIGHT;
class lengthUnit;
class lengthUnit_CM;
class lengthUnit_FEET;
class lengthUnit_INCH;
class lengthUnit_METER;
class lengthUnit_MM;
class liLabel;
class litdefLight;
class litdefLightType;
class litdefLightType_BACK;
class litdefLightType_GRID;
class litdefLightType_OBLQ;
class litdefLightType_SURF;
class litdefMinor;
class litdefStm;
class litdefStrobe;
class litdefStrobeType;
class litdefStrobeType_CYCLE;
class litdefStrobeType_TRIGER;
class locateLabel;
class locateRotAllowed;
class locateRotAllowed_NOROT;
class locateRotAllowed_XAXIS;
class locateRotAllowed_XYAXIS;
class locateRotAllowed_XYZAXI;
class locateRotAllowed_YAXIS;
class locateRotAllowed_YZAXIS;
class locateRotAllowed_ZAXIS;
class locateRotAllowed_ZXAXIS;
class locateStm;
class locateTransAllowed;
class locateTransAllowed_NOTRAN;
class locateTransAllowed_XDIR;
class locateTransAllowed_XYDIR;
class locateTransAllowed_XYZDIR;
class locateTransAllowed_YDIR;
class locateTransAllowed_YZDIR;
class locateTransAllowed_ZDIR;
class locateTransAllowed_ZXDIR;
class longShort;
class longShort_LONG;
class longShort_SHORT;
class lotidStm;
class mLabel;
class mLabelConst;
class maLabel;
class macroBlock;
class macroPar;
class macroPar_MACROVARNAME;
class macroPar_stringConst;
class macroStm;
class matDir;
class matDir_INNER;
class matDir_OUTER;
class matdefFeat;
class matdefGeom;
class matdefMat;
class matdefMat_LMC;
class matdefMat_MMC;
class matdefMating;
class matdefMating_LN2LN;
class matdefMating_PT2LN;
class matdefMating_PT2PL;
class matdefMating_PT2PT;
class matdefMethod;
class matdefMethod_BF;
class matdefMethod_FZ;
class matdefMinor;
class matdefSpec;
class matdefStm;
class matdefType;
class matdefTypeBand;
class matdefTypeZone;
class matrix;
class mdLabel;
class measBlock;
class measBlockItem;
class measBlockStatement;
class measBlock_measStm;
class measBlock_rmeasStm;
class measCaseBlock;
class measDefaultCaseBlock;
class measDoBlock;
class measGeotype;
class measGeotype_ARC;
class measGeotype_CIRCLE;
class measGeotype_CONE;
class measGeotype_CONRADSEGMNT;
class measGeotype_CPARLN;
class measGeotype_CYLNDR;
class measGeotype_CYLRADSEGMNT;
class measGeotype_EDGEPT;
class measGeotype_ELLIPS;
class measGeotype_ELONGCYL;
class measGeotype_GCURVE;
class measGeotype_GSURF;
class measGeotype_LINE;
class measGeotype_OBJECT;
class measGeotype_PARPLN;
class measGeotype_PLANE;
class measGeotype_RCTNGL;
class measGeotype_REVSURF;
class measGeotype_SPHERE;
class measGeotype_SPHRADSEGMNT;
class measGeotype_SYMPLN;
class measGeotype_TORRADSEGMNT;
class measGeotype_TORUS;
class measIfBlock;
class measMinor;
class measMinorComp;
class measMinorOther;
class measMinorPoint;
class measSelectBlock;
class measStm;
class measVar2;
class measVar2Aux;
class measVar2_AXDIR;
class measVar2_DME;
class measVar2_FEAT;
class measVar2_POL;
class measVar2_SPH;
class measVar2_VEC;
class mfgdevStm;
class midliConst;
class midplConst;
class midptConst;
class minusSign;
class modeStm;
class moveptConst;
class moveptConstAxis;
class moveptConstVec;
class nearptConst;
class negDir;
class negDir_MINUSXDIR;
class negDir_MINUSYDIR;
class negDir_MINUSZDIR;
class noParseStm;
class obtainBool;
class obtainInt;
class obtainLabeled;
class obtainLabeled_crLabel;
class obtainLabeled_datumLabel1;
class obtainLabeled_didLabel;
class obtainLabeled_featureLabel;
class obtainLabeled_gLabel;
class obtainLabeled_gsaLabel;
class obtainLabeled_kcLabel;
class obtainLabeled_maLabel;
class obtainLabeled_pLabel;
class obtainLabeled_qisLabel;
class obtainLabeled_rLabel;
class obtainLabeled_rmLabel;
class obtainLabeled_rtLabel;
class obtainLabeled_sensorLabel1;
class obtainLabeled_sgLabel;
class obtainLabeled_sgsLabel;
class obtainLabeled_sraLabel;
class obtainLabeled_ssLabel;
class obtainLabeled_swLabel;
class obtainLabeled_sxLabel;
class obtainLabeled_thLabel;
class obtainLabeled_toleranceLabel;
class obtainLabeled_vLabel;
class obtainLabeled_vaLabel;
class obtainLabeled_vfLabel;
class obtainLabeled_vlLabel;
class obtainLabeled_vwLabel;
class obtainPoint;
class obtainRealLabel;
class obtainRealPoint;
class obtainStm;
class obtainString;
class offsetConst;
class opLabel;
class openCadfile;
class openDMLfile;
class openDevice;
class openDevice_inputAccess;
class openDevice_outputAccess;
class openDmlInput;
class openDmlOutput;
class openFdata;
class openFdata_DMIS;
class openFdata_vLabel;
class openMinor;
class openMinor_openCadfile;
class openMinor_openDMLfile;
class openMinor_openDevice;
class openMinor_openFdata;
class openMinor_storageSpecList;
class openStm;
class operidStm;
class orig;
class orig_XORIG;
class orig_YORIG;
class orig_ZORIG;
class outputAccess;
class outputAccessAppend;
class outputAccessOverwr;
class outputAccessUnspec;
class outputConstBothData;
class outputConstData;
class outputConstGaugeData;
class outputConstPartData;
class outputDat;
class outputDat_datLabel;
class outputDat_faLabel;
class outputFeat;
class outputFeat1F;
class outputFeat1FT;
class outputFeat1Fa;
class outputFeat1FaTa;
class outputFeat2FFT;
class outputFeat2FFaTa;
class outputFeat2FaFTa;
class outputFeat2FaFaTa;
class outputFeatData;
class outputKeycharData;
class outputMinor;
class outputReportData;
class outputSensorData;
class outputSensorData_sLabel;
class outputSensorData_saLabel;
class outputSensorDesc;
class outputSensorDesc_CURENT;
class outputSensorDesc_intVal;
class outputSensorDesc_outputSensorWristList;
class outputSensorDesc_stringVal;
class outputSensorWristAngle;
class outputSensorWristItem;
class outputStm;
class outputToleranceData;
class pLabel;
class pameasDetail;
class pameasDetailDistance;
class pameasDetailNoData;
class pameasDetailPitch;
class pameasDetailScnvelData;
class pameasDetailScnvelNoData;
class pameasFedrat;
class pameasFedrat_IPM;
class pameasFedrat_IPS;
class pameasFedrat_MMPS;
class pameasFedrat_MPM;
class pameasMinor;
class pameasMinor_pameasVar2List;
class pameasMinor_pameasVar3List;
class pameasRemove;
class pameasRemoveAll;
class pameasRemoveCount;
class pameasRemoveDist;
class pameasStm;
class pameasVar2ListItem;
class pameasVar3ListItem;
class param;
class partidStm;
class partoConst;
class partoConstAct;
class partoConstNom;
class partrvStm;
class partsnStm;
class pathArc;
class pathCurve;
class pathCurvePoints;
class pathCurvePtdata;
class pathCurve_pathCurvePoints;
class pathCurve_pathCurvePtdata;
class pathHelical;
class pathLine;
class pathLineCart;
class pathLinePol;
class pathMinor;
class pathPoint;
class pathStm;
class pathSurface;
class pathSurfaceHeadcs;
class pathSurfaceHeadcsData;
class pathSurfacePcs;
class pathSurfacePcsData;
class pathSurfacePlain;
class pathUnknown;
class pcLabel;
class perptoConst;
class perptoConstAct;
class perptoConstNom;
class pierceConst;
class plLabel;
class plan;
class plan_XYPLAN;
class plan_YZPLAN;
class plan_ZXPLAN;
class planidStm;
class plusSign;
class pnLabel;
class pointRange;
class pointVecCart;
class pointVecPol;
class polPoint;
class popStm;
class posDir;
class posDir_XDIR;
class posDir_YDIR;
class posDir_ZDIR;
class prLabel;
class prcompStm;
class prevopStm;
class probeLocCart;
class probeLocPol;
class probeLocSnsCart;
class probeLocSnsVec;
class probeLocVec;
class probeLocation;
class probeOrient;
class probeOrient_HEADCS;
class probeOrient_PCS;
class probeOrient_VEC;
class probeOrient_featureLabel;
class procidStm;
class projctConst;
class projliConst;
class projptConst;
class promptIntEnd;
class promptIntEnd_promptItemList;
class promptIntEnd_stringVal;
class promptItem;
class promptItem_BUTTON;
class promptItem_CHECK;
class promptItem_EDIT;
class promptItem_GROUP;
class promptItem_LIST;
class promptItem_PICTURE;
class promptItem_PIXBTN;
class promptItem_SOUND;
class promptItem_TEXT;
class promptItem_TITLE;
class promptStm;
class promptStm_boolVar;
class promptStm_ccLabel;
class promptStm_ciLabel;
class promptStm_csLabel;
class promptStm_diLabel;
class promptStm_dsLabel;
class promptStm_dvLabel;
class promptStm_fiLabel;
class promptStm_fsLabel;
class promptStm_intVar;
class promptStm_liLabel;
class promptStm_mdLabel;
class promptStm_opLabel;
class promptStm_pcLabel;
class promptStm_plLabel;
class promptStm_pnLabel;
class promptStm_prLabel;
class promptStm_psLabel;
class promptStm_pvLabel;
class promptStm_qLabel;
class promptStm_realVar;
class promptStm_stringVar;
class promptStm_tlLabel;
class promptVar;
class psLabel;
class psthruMinor;
class psthruMinor_COMAND;
class psthruMinor_CONTIN;
class psthruMinor_PAUSE;
class psthruMinor_START;
class psthruMinor_STOP;
class psthruMinor_TRMATX;
class psthruStm;
class ptbuffStm;
class ptmeasEnd;
class ptmeasEnd_csSpec;
class ptmeasEnd_touchSpec;
class ptmeasStm;
class pushStm;
class pvLabel;
class qLabel;
class qisLabel;
class qisdefStm;
class rLabel;
class radiusSpec;
class radiusSpec_MAJOR;
class radiusSpec_MINOR;
class rapidStm;
class readSpec;
class readStm;
class realConst;
class realExpr;
class realExprNegat;
class realExprParen;
class realExprPosit;
class realFunc;
class realFuncAbs;
class realFuncAcos;
class realFuncAsin;
class realFuncAtan;
class realFuncAtan2;
class realFuncCos;
class realFuncDble;
class realFuncDtor;
class realFuncExp;
class realFuncLn;
class realFuncLog;
class realFuncMn;
class realFuncMod;
class realFuncMx;
class realFuncQtemp;
class realFuncRand;
class realFuncRl;
class realFuncRtod;
class realFuncSign;
class realFuncSin;
class realFuncSqrt;
class realFuncTan;
class realFuncVal;
class realFuncVdot;
class realFuncVecX;
class realFuncVecY;
class realFuncVecZ;
class realFuncVmag;
class realIntExpr;
class realIntExpr_DIVID;
class realIntExpr_MINUS;
class realIntExpr_PLUS;
class realIntExpr_POWER;
class realIntExpr_TIMES;
class realIntRel;
class realIntRel_EQ;
class realIntRel_GE;
class realIntRel_GT;
class realIntRel_LE;
class realIntRel_LT;
class realIntRel_NE;
class realRealExpr;
class realRealExpr_DIVID;
class realRealExpr_MINUS;
class realRealExpr_PLUS;
class realRealExpr_POWER;
class realRealExpr_TIMES;
class realRealRel;
class realRealRel_EQ;
class realRealRel_GE;
class realRealRel_GT;
class realRealRel_LE;
class realRealRel_LT;
class realRealRel_NE;
class realRel;
class realVal;
class realVar;
class realVecExpr_TIMES;
class recallDMLStm;
class recallDatumStm;
class recallFeatureStm;
class recallRotaryTableStm;
class recallSensorStm;
class refmntStm;
class rentVal;
class reportItem;
class reportItem_ALGOR;
class reportItem_DATE;
class reportItem_HUMID;
class reportItem_MODE;
class reportItem_TEMPC;
class reportItem_TEMPF;
class reportItem_TEMPWC;
class reportItem_TEMPWF;
class reportItem_TIME;
class reportItem_qisLabel;
class reportStm;
class resumeMinor;
class resumeMinor_CURENT;
class resumeMinor_END;
class resumeMinor_NEXT;
class resumeMinor_START;
class resumeMinor_STOP;
class resumeMinor_jumpLabel;
class resumeStm;
class retrieve1;
class retrieve2;
class retrieve2b;
class retrieve4;
class rightyLefty;
class rightyLefty_LEFTY;
class rightyLefty_RIGHTY;
class rmLabel;
class rmeasArc;
class rmeasArc_rmeasSpecFa;
class rmeasArc_rmeasSpecVecbld;
class rmeasCircle;
class rmeasCircle_rmeasSpecFa;
class rmeasCircle_rmeasSpecVecbld;
class rmeasCone;
class rmeasCparln;
class rmeasCparln_rmeasSpecFaOrient;
class rmeasCparln_rmeasSpecVecbldOrient;
class rmeasCylndr;
class rmeasEdgept;
class rmeasEdgept_rmeasSpecFaAxis;
class rmeasEdgept_rmeasSpecVecbldEdgept;
class rmeasEllips;
class rmeasEllips_rmeasSpecFa;
class rmeasEllips_rmeasSpecVecbld;
class rmeasGcurve;
class rmeasGcurve_rmeasSpecFeatAxis;
class rmeasGcurve_rmeasSpecVecbld;
class rmeasGsurf;
class rmeasLine;
class rmeasLine_rmeasSpecFeatAxis;
class rmeasLine_rmeasSpecVecbld;
class rmeasMinor;
class rmeasObject;
class rmeasObject_rmeasSpecFa;
class rmeasObject_rmeasSpecVecbld;
class rmeasParpln;
class rmeasPlane;
class rmeasPoint;
class rmeasPoint_rmeasSpecFaAxis;
class rmeasPoint_rmeasSpecVecbld;
class rmeasRctngl;
class rmeasSpecFa;
class rmeasSpecFaAxis;
class rmeasSpecFaAxis_axis;
class rmeasSpecFaAxis_faLabel;
class rmeasSpecFaOrient;
class rmeasSpecFeatAxis;
class rmeasSpecFeatAxis_axis;
class rmeasSpecFeatAxis_featureLabel1;
class rmeasSpecVecbld;
class rmeasSpecVecbldEdgept;
class rmeasSpecVecbldOrient;
class rmeasSphere;
class rmeasStm;
class rmeasSympln;
class rmeasTorus;
class rotAbs;
class rotDir;
class rotDir_SHORT;
class rotDir_rotOrient;
class rotIncr;
class rotOrient;
class rotOrient_CCW;
class rotOrient_CW;
class rotType;
class rotType_ROTNUL;
class rotType_ROTORG;
class rotType_ROTTOT;
class rotabAbs;
class rotabFeat;
class rotabIncr;
class rotabMinor;
class rotabStm;
class rotateDatum;
class rotateFeature;
class rotateMinor;
class rotateStm;
class rotateValue;
class rotdefStm;
class rotsetStm;
class rtLabel;
class rwFormat;
class rwVar;
class sLabel;
class saLabel;
class saveDMLStm;
class saveDatumStm;
class saveFeatureStm;
class saveRotaryTableStm;
class saveSensorStm;
class scnmodStm;
class scnsetDrag;
class scnsetMinor;
class scnsetNoncon;
class scnsetPeck;
class scnsetSample;
class scnsetSampleDrag;
class scnsetSampleDrag_ANGLE;
class scnsetSampleDrag_CHORD;
class scnsetSampleDrag_DEFALT;
class scnsetSampleDrag_DIST;
class scnsetSampleDrag_TIME;
class scnsetSample_ANGLE;
class scnsetSample_CHORD;
class scnsetSample_DEFALT;
class scnsetSample_DIST;
class scnsetSample_TIME;
class scnsetStm;
class scnsetStop;
class scnsetStopPlane;
class scnsetStopSphere;
class scnsetVendor;
class scnsetVendor_FORM;
class scnsetVendor_POS;
class scnsetVendor_SIZE;
class seLabel;
class secondsString;
class secondsString_INTSTRING;
class secondsString_REALSTRING;
class selectBlock;
class selectStm;
class selectStmInt;
class selectStmString;
class sensorArea;
class sensorGeometry;
class sensorInfred;
class sensorItem;
class sensorItem_intVal;
class sensorItem_stringVal;
class sensorLabel1;
class sensorLabel2;
class sensorLaser;
class sensorLine;
class sensorMinor;
class sensorMltprb;
class sensorMltprbItem;
class sensorMltprbItem_intVal;
class sensorMltprbItem_stringVal;
class sensorMove;
class sensorMove_gotoWristList;
class sensorMove_probeOrient;
class sensorMove_saLabel;
class sensorNoncon;
class sensorPoint;
class sensorProbe;
class sensorProbeForm;
class sensorProbeForm_CYLNDR;
class sensorProbeForm_DISK;
class sensorProbeForm_SPHERE;
class sensorProbeGeometry;
class sensorStm;
class sensorVideo;
class sgLabel;
class sgageConst;
class sgsLabel;
class sign;
class simreqtBlock;
class simreqtMinor;
class simreqtMinor_FIRST;
class simreqtMinor_OPTIMAL;
class simreqtStm;
class snsdefBuild;
class snsdefBuildItem;
class snsdefBuildItem_rmLabel;
class snsdefBuildItem_sgLabel;
class snsdefBuildItem_swLabel;
class snsdefBuildItem_sxLabel;
class snsdefBuildSensor;
class snsdefInfred;
class snsdefLaser;
class snsdefLocation;
class snsdefLocation_CART;
class snsdefLocation_POL;
class snsdefLocation_VEC;
class snsdefMinor;
class snsdefNoncon;
class snsdefProbe;
class snsdefProbeForm;
class snsdefProbeForm_CYLNDR;
class snsdefProbeForm_DISK;
class snsdefProbeForm_SPHERE;
class snsdefStm;
class snsdefType;
class snsdefType_FIXED;
class snsdefType_INDEX;
class snsdefVideo;
class snsdefWristAngleItem;
class snsetFeat;
class snsetItem;
class snsetItem_CLRSRF;
class snsetItem_DEPTH;
class snsetItem_snsetLabel;
class snsetItem_snsetLabelAndValue;
class snsetItem_snsetToggle;
class snsetItem_snsetType;
class snsetItem_snsetTypeAndValue;
class snsetLabel;
class snsetLabelAndValue;
class snsetStm;
class snsetToggle;
class snsetToggle_CLRSRF;
class snsetToggle_DEPTH;
class snsetType;
class snsetTypeAndValue;
class snsetTypeAndValue_APPRCH;
class snsetTypeAndValue_CLRSRF;
class snsetTypeAndValue_DEPTH;
class snsetTypeAndValue_MINCON;
class snsetTypeAndValue_RETRCT;
class snsetTypeAndValue_SCALEX;
class snsetTypeAndValue_SCALEY;
class snsetTypeAndValue_SEARCH;
class snsetType_FOCUSN;
class snsetType_FOCUSY;
class snsgrpItem;
class snsgrpMinor;
class snsgrpMinor_sgsLabel;
class snsgrpMinor_ssLabel;
class snsgrpStm;
class snslctData;
class snslctData_probeOrient;
class snslctData_snslctWristList;
class snslctGroup;
class snslctGroupFeat;
class snslctGroupVec;
class snslctSensor;
class snslctSensorList;
class snslctSensorTip;
class snslctStm;
class snslctStmGroup;
class snslctStmSensor;
class snslctTipData;
class snslctWristAngleAngle;
class snslctWristAngleFeat;
class snslctWristAngleItem;
class snslctWristAngleVec;
class snslctWristItem;
class snsmntMinor;
class snsmntStm;
class spartConst;
class srLabel;
class sraLabel;
class ssLabel;
class stLabel;
class stackElement;
class stackElement_ALGOR;
class stackElement_DATSET;
class stackElement_DME;
class stackElement_REPORT;
class state;
class state_OFF;
class state_ON;
class storageSpec;
class storageSpec_FEATUR;
class storageSpec_PCS;
class storageSpec_RTAB;
class storageSpec_SNS;
class strVar7;
class stringConst;
class stringFunc;
class stringFuncChr;
class stringFuncConcat;
class stringFuncElemnt;
class stringFuncLwc;
class stringFuncRpt;
class stringFuncScfeat;
class stringFuncScsns;
class stringFuncSdate;
class stringFuncSdatetime;
class stringFuncSelapsetime;
class stringFuncSerror;
class stringFuncSmode;
class stringFuncStime;
class stringFuncStr;
class stringFuncSubstr;
class stringFuncTrim;
class stringFuncUpc;
class stringRel;
class stringRel_EQ;
class stringRel_GE;
class stringRel_GT;
class stringRel_LE;
class stringRel_LT;
class stringRel_NE;
class stringVal;
class stringVar;
class surfPtdataHeadcsListItem;
class surfPtdataListItem;
class surfPtdataPcsListItem;
class swLabel;
class sxLabel;
class tLabel;
class taLabel;
class tantoConst;
class tantoConstF;
class tantoConstFa;
class tantoConstPlane;
class tantoConstPlaneF;
class tantoConstPlaneFa;
class tecompDatum;
class tecompMinor;
class tecompMinorMach;
class tecompMinorOff;
class tecompMinorOnAll;
class tecompMinorOnList;
class tecompOffset;
class tecompStm;
class tecompVar2;
class tempUnit;
class tempUnit_TEMPC;
class tempUnit_TEMPF;
class textMan;
class textMinor;
class textOper;
class textOutfil;
class textQuery;
class textQueryFormat;
class textStm;
class textType;
class textType_ALPHA;
class textType_NUMERIC;
class textType_PRNTCHAR;
class thLabel;
class thldefPocket;
class thldefPocket_rmLabel;
class thldefPocket_sLabel;
class thldefPocket_sgLabel;
class thldefPocket_sgsLabel;
class thldefPocket_ssLabel;
class thldefPocket_swLabel;
class thldefPocket_sxLabel;
class thldefStm;
class tier;
class tier_LOTIER;
class tier_UPTIER;
class tlLabel;
class tolAnglStm;
class tolAnglbStm;
class tolAnglrStm;
class tolAnglwrtStm;
class tolAppData;
class tolCirltyStm;
class tolCompos1;
class tolCompos2;
class tolComposStm;
class tolConcenStm;
class tolCortolAngle;
class tolCortolAxis;
class tolCortolMinor;
class tolCortolRadial;
class tolCortolStm;
class tolCprofSpec;
class tolCprofSpecC;
class tolCproflStm;
class tolCprofsStm;
class tolCrnoutStm;
class tolCylctyStm;
class tolDiamAvg;
class tolDiamMinmax;
class tolDiamMinor;
class tolDiamPlain;
class tolDiamStm;
class tolDistbDir;
class tolDistbDir_PT2PT;
class tolDistbDir_XAXIS;
class tolDistbDir_YAXIS;
class tolDistbDir_ZAXIS;
class tolDistbLimit;
class tolDistbNominl;
class tolDistbStm;
class tolDistbTol;
class tolDistwrtStm;
class tolFeatMaxMat;
class tolFeatMaxMat_datLabel;
class tolFeatMaxMat_fLabel;
class tolFeatMaxMat_faLabel;
class tolFeature;
class tolFeatureMat;
class tolFeatureMat_datLabel;
class tolFeatureMat_fLabel;
class tolFeatureMat_faLabel;
class tolFlatMinor;
class tolFlatPer;
class tolFlatStm;
class tolFlatZon;
class tolFlatZonPer;
class tolGtolRot;
class tolGtolRot_NOROT;
class tolGtolRot_XAXIS;
class tolGtolRot_XYAXIS;
class tolGtolRot_XYZAXI;
class tolGtolRot_YAXIS;
class tolGtolRot_YZAXIS;
class tolGtolRot_ZAXIS;
class tolGtolRot_ZXAXIS;
class tolGtolSpec;
class tolGtolSpec_INTFPT;
class tolGtolSpec_PERCNT;
class tolGtolStm;
class tolGtolTrans;
class tolGtolTrans_NOTRAN;
class tolGtolTrans_XDIR;
class tolGtolTrans_XYDIR;
class tolGtolTrans_XYZDIR;
class tolGtolTrans_YDIR;
class tolGtolTrans_YZDIR;
class tolGtolTrans_ZDIR;
class tolGtolTrans_ZXDIR;
class tolMatCond;
class tolMatCond_LMC;
class tolMatCond_MMC;
class tolMatCond_RFS;
class tolMaxMatCond;
class tolMaxMatCond_LMC;
class tolMaxMatCond_MMC;
class tolMaxMatCond_RFS;
class tolParlelStm;
class tolPerpStm;
class tolPosEnd;
class tolPosMethod;
class tolPosMethod_ANGLE;
class tolPosMethod_RADIAL;
class tolPosMethod_VEC;
class tolPosMethod_XAXIS;
class tolPosMethod_YAXIS;
class tolPosMethod_ZAXIS;
class tolPosStart;
class tolPosStart_THREED;
class tolPosStart_TWOD;
class tolPosStm;
class tolProflStm;
class tolProfpStm;
class tolProfsStm;
class tolRadSpec;
class tolRadSpec_AVG;
class tolRadSpec_CRAD;
class tolRadStm;
class tolStrghtMat;
class tolStrghtMinor;
class tolStrghtPer1;
class tolStrghtPer2;
class tolStrghtPlain;
class tolStrghtStm;
class tolSymStm;
class tolTrnoutStm;
class tolUsetolStm;
class tolWidthDir;
class tolWidthDir_LONG;
class tolWidthDir_SHORT;
class tolWidthDir_vector;
class tolWidthStm;
class tolZoneDir;
class tolZoneDir2;
class tolZoneDir2_VEC;
class tolZoneDir2_XYPLAN;
class tolZoneDir2_YZPLAN;
class tolZoneDir2_ZXPLAN;
class tolZoneDir3;
class tolZoneDir3_VEC;
class tolZoneDir3_XDIR;
class tolZoneDir3_YDIR;
class tolZoneDir3_ZDIR;
class tolZoneDir_VEC;
class tolZoneDir_XAXIS;
class tolZoneDir_YAXIS;
class tolZoneDir_ZAXIS;
class tolZoneType;
class tolZoneType_PARPLN;
class tolZoneType_TANGPL;
class toleranceLabel;
class tooldfStm;
class touchSpec;
class touchSpec_ALLAXESTOUCH;
class touchSpec_HEADTOUCH;
class trConst;
class transDatum;
class transFeature;
class transMinor;
class transProbe;
class transProbe_MINUSPRBRAD;
class transProbe_PRBRAD;
class transStm;
class transValue;
class typePoint;
class uLabel;
class uncertMinor;
class uncertMinor_ALGOR;
class uncertMinor_stringVal;
class uncertVar3;
class uncertVar3_DME;
class uncertVar3_SENS;
class uncertVar3_paramList;
class uncertalgStm;
class uncertsetMinor;
class uncertsetMinor_OFF;
class uncertsetMinor_ON;
class uncertsetStm;
class uncertsetVar2;
class uncertsetVar2_NONE;
class uncertsetVar2_drLabel;
class unitsStm;
class vLabel;
class vaLabel;
class valueAclratReal;
class valueAclratReal_MESACL;
class valueAclratReal_POSACL;
class valueAclratReal_ROTACL;
class valueAclratString;
class valueBadtst;
class valueBoundInt;
class valueBoundInt_featureLabel;
class valueBoundInt_toleranceLabel;
class valueBoundString;
class valueBoundString_featureLabel;
class valueBoundString_toleranceLabel;
class valueCrmode;
class valueCroscl;
class valueCrslct;
class valueCzslct;
class valueDatset;
class valueDeflection;
class valueDmismd;
class valueDmismd_NAME;
class valueDmismd_VERSION;
class valueDmismn;
class valueDmismn_NAME;
class valueDmismn_VERSION;
class valueError;
class valueError_ERR;
class valueError_ERRMODE;
class valueFaInt;
class valueFaReal;
class valueFedratReal;
class valueFedratReal_MESVEL;
class valueFedratReal_POSVEL;
class valueFedratReal_ROTVEL;
class valueFedratReal_SCNVEL;
class valueFedratString;
class valueFilnam;
class valueFilnam_NAME;
class valueFilnam_VERSION;
class valueFinpos;
class valueGeoalg;
class valueGotoReal;
class valueGotoVector;
class valueKeychar;
class valueMinorBool;
class valueMinorInt;
class valueMinorReal;
class valueMinorString;
class valueMinorVector;
class valueMode;
class valuePrcomp;
class valuePtbuff;
class valuePtmeasReal;
class valuePtmeasVector;
class valueRt;
class valueRt_CCW;
class valueRt_CW;
class valueSa;
class valueSaDesc;
class valueSaPlain;
class valueSaTipnum;
class valueScnmod;
class valueSnsetReal;
class valueSnsetRealApprch;
class valueSnsetRealClrsrf;
class valueSnsetRealDepth;
class valueSnsetRealRetrct;
class valueSnsetRealSearch;
class valueSnsetString;
class valueSnsetString_CLRSRF;
class valueSnsetString_DEPTH;
class valueSnslct;
class valueSnsmnt;
class valueSnsmnt_MNTLEN;
class valueSnsmnt_XVEC;
class valueSnsmnt_ZVEC;
class valueStm;
class valueStm_boolVar;
class valueStm_intVar;
class valueStm_realVar;
class valueStm_stringVar;
class valueStm_vectorVar;
class valueSw;
class valueTaBool;
class valueTaBoolIntol;
class valueTaBoolOutol;
class valueTaReal;
class valueTaRealAct;
class valueTaRealAmt;
class valueTaRealDev;
class valueTecomp;
class valueUnits;
class valueUnits_ANGL;
class valueUnits_DIST;
class valueUnits_TEMP;
class valueWkplan;
class vecExpr_MINUS;
class vecExpr_PAREN;
class vecExpr_PLUS;
class vecIntExpr_DIVID;
class vecIntExpr_TIMES;
class vecRealExpr_DIVID;
class vecRealExpr_TIMES;
class vector;
class vectorExpr;
class vectorFunc;
class vectorFuncVcart;
class vectorFuncVcross;
class vectorFuncVmcs;
class vectorFuncVpcs;
class vectorFuncVpol;
class vectorFuncVunit;
class vectorRel;
class vectorRel_EQ;
class vectorRel_NE;
class vectorVal;
class vectorVar;
class versionTag;
class vertexConst;
class vfLabel;
class vformItem;
class vformItem_ACT;
class vformItem_ALL;
class vformItem_AMT;
class vformItem_DEV;
class vformItem_DME;
class vformItem_HIST;
class vformItem_NOM;
class vformItem_PLOT;
class vformItem_STAT;
class vformStm;
class vlLabel;
class vwLabel;
class windefBox;
class windefEdgeln;
class windefMinor;
class windefStm;
class wkplanStm;
class wristDataDesc;
class wristDataDesc_intVal;
class wristDataDesc_stringVal;
class wristDef;
class wristMountDef;
class wristMountOffset;
class wristRotDef;
class wristRotLimit;
class wristRotLimit_THRU;
class wristRotLimit_angle;
class wristRotStep;
class wristRotStep_CONTIN;
class wristRotStep_angle;
class wristStm;
class writeSpec;
class writeSpec_rwVar;
class writeSpec_stringConst;
class writeSpec_stringFunc;
class writeStm;
class xternBlock;
class xternStm;
class xtractStm;
class dmisCppBase;
class dmisStatement;

/********************************************************************/

/* dmisCppBase

This is the base class for all other classes. It has a virtual
function printSelf.

*/

class dmisCppBase
{
public:
  dmisCppBase();
  virtual ~dmisCppBase();
  virtual void printSelf() = 0;
};

/********************************************************************/

/* dmisStatement

This is the dmisStatement class.

*/

class dmisStatement :
  public dmisCppBase
{
public:
  dmisStatement();
  ~dmisStatement();
};

/********************************************************************/

/* inputFile

This is a class for the single definition of inputFile.
It represents the following items:

dmisFirstStatement [dmisItemList] endfilStm

*/

class inputFile :
  public dmisCppBase
{
public:
  inputFile();
  inputFile(
    dmisFirstStatement * dmisFirstStatementIn,
    std::list<dmisItem *> * dmisItemListIn,
    endfilStm * endfilStmIn);
  ~inputFile();
  void printSelf();
  dmisFirstStatement * get_dmisFirstStatement();
  void set_dmisFirstStatement(dmisFirstStatement * dmisFirstStatementIn);
  std::list<dmisItem *> * get_dmisItemList();
  void set_dmisItemList(std::list<dmisItem *> * dmisItemListIn);
  endfilStm * get_endfilStm();
  void set_endfilStm(endfilStm * endfilStmIn);
private:
  dmisFirstStatement * a_dmisFirstStatement;
  std::list<dmisItem *> * a_dmisItemList;
  endfilStm * a_endfilStm;
};

/********************************************************************/

/* dmisItem

This is a parent class.

*/

class dmisItem :
  public dmisCppBase
{
public:
  dmisItem();
  ~dmisItem();
  void printSelf() = 0;
};

/********************************************************************/

/* dmisFirstStatement

This is a parent class.

*/

class dmisFirstStatement :
  public dmisCppBase
{
public:
  dmisFirstStatement();
  ~dmisFirstStatement();
  void printSelf() = 0;
};

/********************************************************************/

/* dmisBlock

This is a parent class.

*/

class dmisBlock :
  public dmisItem
{
public:
  dmisBlock();
  ~dmisBlock();
  void printSelf() = 0;
};

/********************************************************************/

/* calibMasterBlock

This is a class for the single definition of calibMasterBlock.
It represents the following items:

calibMasterStm [calibSensBlockItemList] endmesStm

*/

class calibMasterBlock :
  public dmisBlock
{
public:
  calibMasterBlock();
  calibMasterBlock(
    calibMasterStm * calibMasterStmIn,
    std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
    endmesStm * endmesStmIn);
  ~calibMasterBlock();
  void printSelf();
  calibMasterStm * get_calibMasterStm();
  void set_calibMasterStm(calibMasterStm * calibMasterStmIn);
  std::list<calibSensBlockItem *> * get_calibSensBlockItemList();
  void set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn);
  endmesStm * get_endmesStm();
  void set_endmesStm(endmesStm * endmesStmIn);
private:
  calibMasterStm * a_calibMasterStm;
  std::list<calibSensBlockItem *> * a_calibSensBlockItemList;
  endmesStm * a_endmesStm;
};

/********************************************************************/

/* calibRtabBlock

This is a class for the single definition of calibRtabBlock.
It represents the following items:

calibRtabStm [measBlockItemList] endmesStm

*/

class calibRtabBlock :
  public dmisBlock
{
public:
  calibRtabBlock();
  calibRtabBlock(
    calibRtabStm * calibRtabStmIn,
    std::list<measBlockItem *> * measBlockItemListIn,
    endmesStm * endmesStmIn);
  ~calibRtabBlock();
  void printSelf();
  calibRtabStm * get_calibRtabStm();
  void set_calibRtabStm(calibRtabStm * calibRtabStmIn);
  std::list<measBlockItem *> * get_measBlockItemList();
  void set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn);
  endmesStm * get_endmesStm();
  void set_endmesStm(endmesStm * endmesStmIn);
private:
  calibRtabStm * a_calibRtabStm;
  std::list<measBlockItem *> * a_measBlockItemList;
  endmesStm * a_endmesStm;
};

/********************************************************************/

/* calibSensBlock

This is a class for the single definition of calibSensBlock.
It represents the following items:

calibSensStm [calibSensBlockItemList] endmesStm

*/

class calibSensBlock :
  public dmisBlock
{
public:
  calibSensBlock();
  calibSensBlock(
    calibSensStm * calibSensStmIn,
    std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
    endmesStm * endmesStmIn);
  ~calibSensBlock();
  void printSelf();
  calibSensStm * get_calibSensStm();
  void set_calibSensStm(calibSensStm * calibSensStmIn);
  std::list<calibSensBlockItem *> * get_calibSensBlockItemList();
  void set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn);
  endmesStm * get_endmesStm();
  void set_endmesStm(endmesStm * endmesStmIn);
private:
  calibSensStm * a_calibSensStm;
  std::list<calibSensBlockItem *> * a_calibSensBlockItemList;
  endmesStm * a_endmesStm;
};

/********************************************************************/

/* calibSensBlockItem

This is a parent class.

*/

class calibSensBlockItem :
  public dmisCppBase
{
public:
  calibSensBlockItem();
  ~calibSensBlockItem();
  void printSelf() = 0;
};

/********************************************************************/

/* calibSensDoBlock

This is a class for the single definition of calibSensDoBlock.
It represents the following items:

doStm [calibSensBlockItemList] enddoStm

*/

class calibSensDoBlock :
  public calibSensBlockItem
{
public:
  calibSensDoBlock();
  calibSensDoBlock(
    doStm * doStmIn,
    std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
    enddoStm * enddoStmIn);
  ~calibSensDoBlock();
  void printSelf();
  doStm * get_doStm();
  void set_doStm(doStm * doStmIn);
  std::list<calibSensBlockItem *> * get_calibSensBlockItemList();
  void set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn);
  enddoStm * get_enddoStm();
  void set_enddoStm(enddoStm * enddoStmIn);
private:
  doStm * a_doStm;
  std::list<calibSensBlockItem *> * a_calibSensBlockItemList;
  enddoStm * a_enddoStm;
};

/********************************************************************/

/* calibSensIfBlock

This is a class for the single definition of calibSensIfBlock.
It represents the following items:

ifStm [calibSensBlockItemList] [elseStm [calibSensBlockItemList]] endifStm

*/

class calibSensIfBlock :
  public calibSensBlockItem
{
public:
  calibSensIfBlock();
  calibSensIfBlock(
    ifStm * ifStmIn,
    std::list<calibSensBlockItem *> * ifListIn,
    elseStm * elseStmIn,
    std::list<calibSensBlockItem *> * elseListIn,
    endifStm * endifStmIn);
  ~calibSensIfBlock();
  void printSelf();
  ifStm * get_ifStm();
  void set_ifStm(ifStm * ifStmIn);
  std::list<calibSensBlockItem *> * get_ifList();
  void set_ifList(std::list<calibSensBlockItem *> * ifListIn);
  elseStm * get_elseStm();
  void set_elseStm(elseStm * elseStmIn);
  std::list<calibSensBlockItem *> * get_elseList();
  void set_elseList(std::list<calibSensBlockItem *> * elseListIn);
  endifStm * get_endifStm();
  void set_endifStm(endifStm * endifStmIn);
private:
  ifStm * a_ifStm;
  std::list<calibSensBlockItem *> * ifList;
  elseStm * a_elseStm;
  std::list<calibSensBlockItem *> * elseList;
  endifStm * a_endifStm;
};

/********************************************************************/

/* calibSensSelectBlock

This is a class for the single definition of calibSensSelectBlock.
It represents the following items:

selectStm calibSensCaseBlockList [calibSensDefaultCaseBlock] endselStm

*/

class calibSensSelectBlock :
  public calibSensBlockItem
{
public:
  calibSensSelectBlock();
  calibSensSelectBlock(
    selectStm * selectStmIn,
    std::list<calibSensCaseBlock *> * calibSensCaseBlockListIn,
    calibSensDefaultCaseBlock * calibSensDefaultCaseBlockIn,
    endselStm * endselStmIn);
  ~calibSensSelectBlock();
  void printSelf();
  selectStm * get_selectStm();
  void set_selectStm(selectStm * selectStmIn);
  std::list<calibSensCaseBlock *> * get_calibSensCaseBlockList();
  void set_calibSensCaseBlockList(std::list<calibSensCaseBlock *> * calibSensCaseBlockListIn);
  calibSensDefaultCaseBlock * get_calibSensDefaultCaseBlock();
  void set_calibSensDefaultCaseBlock(calibSensDefaultCaseBlock * calibSensDefaultCaseBlockIn);
  endselStm * get_endselStm();
  void set_endselStm(endselStm * endselStmIn);
private:
  selectStm * a_selectStm;
  std::list<calibSensCaseBlock *> * a_calibSensCaseBlockList;
  calibSensDefaultCaseBlock * a_calibSensDefaultCaseBlock;
  endselStm * a_endselStm;
};

/********************************************************************/

/* calibSensCaseBlock

This is a class for the single definition of calibSensCaseBlock.
It represents the following items:

caseList [calibSensBlockItemList] endcasStm

*/

class calibSensCaseBlock :
  public dmisCppBase
{
public:
  calibSensCaseBlock();
  calibSensCaseBlock(
    std::list<caseStm *> * caseListIn,
    std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
    endcasStm * endcasStmIn);
  ~calibSensCaseBlock();
  void printSelf();
  std::list<caseStm *> * get_caseList();
  void set_caseList(std::list<caseStm *> * caseListIn);
  std::list<calibSensBlockItem *> * get_calibSensBlockItemList();
  void set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn);
  endcasStm * get_endcasStm();
  void set_endcasStm(endcasStm * endcasStmIn);
private:
  std::list<caseStm *> * a_caseList;
  std::list<calibSensBlockItem *> * a_calibSensBlockItemList;
  endcasStm * a_endcasStm;
};

/********************************************************************/

/* calibSensDefaultCaseBlock

This is a class for the single definition of calibSensDefaultCaseBlock.
It represents the following items:

dftcasStm [calibSensBlockItemList] endcasStm

*/

class calibSensDefaultCaseBlock :
  public dmisCppBase
{
public:
  calibSensDefaultCaseBlock();
  calibSensDefaultCaseBlock(
    dftcasStm * dftcasStmIn,
    std::list<calibSensBlockItem *> * calibSensBlockItemListIn,
    endcasStm * endcasStmIn);
  ~calibSensDefaultCaseBlock();
  void printSelf();
  dftcasStm * get_dftcasStm();
  void set_dftcasStm(dftcasStm * dftcasStmIn);
  std::list<calibSensBlockItem *> * get_calibSensBlockItemList();
  void set_calibSensBlockItemList(std::list<calibSensBlockItem *> * calibSensBlockItemListIn);
  endcasStm * get_endcasStm();
  void set_endcasStm(endcasStm * endcasStmIn);
private:
  dftcasStm * a_dftcasStm;
  std::list<calibSensBlockItem *> * a_calibSensBlockItemList;
  endcasStm * a_endcasStm;
};

/********************************************************************/

/* callBlock

This is a class for the single definition of callBlock.
It represents the following items:

callStm [dmisItemList] endmacStm

*/

class callBlock :
  public dmisBlock
{
public:
  callBlock();
  callBlock(
    callStm * callStmIn,
    std::list<dmisItem *> * dmisItemListIn,
    endmacStm * endmacStmIn);
  ~callBlock();
  void printSelf();
  callStm * get_callStm();
  void set_callStm(callStm * callStmIn);
  std::list<dmisItem *> * get_dmisItemList();
  void set_dmisItemList(std::list<dmisItem *> * dmisItemListIn);
  endmacStm * get_endmacStm();
  void set_endmacStm(endmacStm * endmacStmIn);
private:
  callStm * a_callStm;
  std::list<dmisItem *> * a_dmisItemList;
  endmacStm * a_endmacStm;
};

/********************************************************************/

/* caseBlock

This is a class for the single definition of caseBlock.
It represents the following items:

caseList [dmisItemList] endcasStm

*/

class caseBlock :
  public dmisCppBase
{
public:
  caseBlock();
  caseBlock(
    std::list<caseStm *> * caseListIn,
    std::list<dmisItem *> * dmisItemListIn,
    endcasStm * endcasStmIn);
  ~caseBlock();
  void printSelf();
  std::list<caseStm *> * get_caseList();
  void set_caseList(std::list<caseStm *> * caseListIn);
  std::list<dmisItem *> * get_dmisItemList();
  void set_dmisItemList(std::list<dmisItem *> * dmisItemListIn);
  endcasStm * get_endcasStm();
  void set_endcasStm(endcasStm * endcasStmIn);
private:
  std::list<caseStm *> * a_caseList;
  std::list<dmisItem *> * a_dmisItemList;
  endcasStm * a_endcasStm;
};

/********************************************************************/

/* defaultCaseBlock

This is a class for the single definition of defaultCaseBlock.
It represents the following items:

dftcasStm [dmisItemList] endcasStm

*/

class defaultCaseBlock :
  public dmisCppBase
{
public:
  defaultCaseBlock();
  defaultCaseBlock(
    dftcasStm * dftcasStmIn,
    std::list<dmisItem *> * dmisItemListIn,
    endcasStm * endcasStmIn);
  ~defaultCaseBlock();
  void printSelf();
  dftcasStm * get_dftcasStm();
  void set_dftcasStm(dftcasStm * dftcasStmIn);
  std::list<dmisItem *> * get_dmisItemList();
  void set_dmisItemList(std::list<dmisItem *> * dmisItemListIn);
  endcasStm * get_endcasStm();
  void set_endcasStm(endcasStm * endcasStmIn);
private:
  dftcasStm * a_dftcasStm;
  std::list<dmisItem *> * a_dmisItemList;
  endcasStm * a_endcasStm;
};

/********************************************************************/

/* dmisOffBlock

This is a class for the single definition of dmisOffBlock.
It represents the following items:

dmisOffStm [noParseStmList] dmisOnStm

*/

class dmisOffBlock :
  public dmisBlock
{
public:
  dmisOffBlock();
  dmisOffBlock(
    dmisOffStm * dmisOffStmIn,
    std::list<noParseStm *> * noParseStmListIn,
    dmisOnStm * dmisOnStmIn);
  ~dmisOffBlock();
  void printSelf();
  dmisOffStm * get_dmisOffStm();
  void set_dmisOffStm(dmisOffStm * dmisOffStmIn);
  std::list<noParseStm *> * get_noParseStmList();
  void set_noParseStmList(std::list<noParseStm *> * noParseStmListIn);
  dmisOnStm * get_dmisOnStm();
  void set_dmisOnStm(dmisOnStm * dmisOnStmIn);
private:
  dmisOffStm * a_dmisOffStm;
  std::list<noParseStm *> * a_noParseStmList;
  dmisOnStm * a_dmisOnStm;
};

/********************************************************************/

/* doBlock

This is a class for the single definition of doBlock.
It represents the following items:

doStm [dmisItemList] enddoStm

*/

class doBlock :
  public dmisBlock
{
public:
  doBlock();
  doBlock(
    doStm * doStmIn,
    std::list<dmisItem *> * dmisItemListIn,
    enddoStm * enddoStmIn);
  ~doBlock();
  void printSelf();
  doStm * get_doStm();
  void set_doStm(doStm * doStmIn);
  std::list<dmisItem *> * get_dmisItemList();
  void set_dmisItemList(std::list<dmisItem *> * dmisItemListIn);
  enddoStm * get_enddoStm();
  void set_enddoStm(enddoStm * enddoStmIn);
private:
  doStm * a_doStm;
  std::list<dmisItem *> * a_dmisItemList;
  enddoStm * a_enddoStm;
};

/********************************************************************/

/* gotargBlock

This is a class for the single definition of gotargBlock.
It represents the following items:

gotargStm gotoStm gotoList endgoStm

*/

class gotargBlock :
  public dmisBlock,
  public calibSensBlockItem
{
public:
  gotargBlock();
  gotargBlock(
    gotargStm * gotargStmIn,
    gotoStm * gotoStmIn,
    std::list<gotoStm *> * gotoListIn,
    endgoStm * endgoStmIn);
  ~gotargBlock();
  void printSelf();
  gotargStm * get_gotargStm();
  void set_gotargStm(gotargStm * gotargStmIn);
  gotoStm * get_gotoStm();
  void set_gotoStm(gotoStm * gotoStmIn);
  std::list<gotoStm *> * get_gotoList();
  void set_gotoList(std::list<gotoStm *> * gotoListIn);
  endgoStm * get_endgoStm();
  void set_endgoStm(endgoStm * endgoStmIn);
private:
  gotargStm * a_gotargStm;
  gotoStm * a_gotoStm;
  std::list<gotoStm *> * a_gotoList;
  endgoStm * a_endgoStm;
};

/********************************************************************/

/* ifBlock

This is a class for the single definition of ifBlock.
It represents the following items:

ifStm [dmisItemList] [elseStm [dmisItemList]] endifStm

*/

class ifBlock :
  public dmisBlock
{
public:
  ifBlock();
  ifBlock(
    ifStm * ifStmIn,
    std::list<dmisItem *> * ifListIn,
    elseStm * elseStmIn,
    std::list<dmisItem *> * elseListIn,
    endifStm * endifStmIn);
  ~ifBlock();
  void printSelf();
  ifStm * get_ifStm();
  void set_ifStm(ifStm * ifStmIn);
  std::list<dmisItem *> * get_ifList();
  void set_ifList(std::list<dmisItem *> * ifListIn);
  elseStm * get_elseStm();
  void set_elseStm(elseStm * elseStmIn);
  std::list<dmisItem *> * get_elseList();
  void set_elseList(std::list<dmisItem *> * elseListIn);
  endifStm * get_endifStm();
  void set_endifStm(endifStm * endifStmIn);
private:
  ifStm * a_ifStm;
  std::list<dmisItem *> * ifList;
  elseStm * a_elseStm;
  std::list<dmisItem *> * elseList;
  endifStm * a_endifStm;
};

/********************************************************************/

/* macroBlock

This is a class for the single definition of macroBlock.
It represents the following items:

macroStm [noParseStmList] endmacStm

*/

class macroBlock :
  public dmisBlock
{
public:
  macroBlock();
  macroBlock(
    macroStm * macroStmIn,
    std::list<noParseStm *> * noParseStmListIn,
    endmacStm * endmacStmIn,
    int macroIsRealIn);
  ~macroBlock();
  void printSelf();
  macroStm * get_macroStm();
  void set_macroStm(macroStm * macroStmIn);
  std::list<noParseStm *> * get_noParseStmList();
  void set_noParseStmList(std::list<noParseStm *> * noParseStmListIn);
  endmacStm * get_endmacStm();
  void set_endmacStm(endmacStm * endmacStmIn);
private:
  macroStm * a_macroStm;
  std::list<noParseStm *> * a_noParseStmList;
  endmacStm * a_endmacStm;
  int macroIsReal;
};

/********************************************************************/

/* measBlock

This is a parent class.

*/

class measBlock :
  public dmisBlock
{
public:
  measBlock();
  ~measBlock();
  void printSelf() = 0;
};

/********************************************************************/

/* measBlock_measStm

This is a derived class for one of the definitions of measBlock.
It represents the following items:

measStm [measBlockItemList] endmesStm

*/

class measBlock_measStm :
  public measBlock
{
public:
  measBlock_measStm();
  measBlock_measStm(
    measStm * measStmIn,
    std::list<measBlockItem *> * measBlockItemListIn,
    endmesStm * endmesStmIn);
  ~measBlock_measStm();
  void printSelf();
  measStm * get_measStm();
  void set_measStm(measStm * measStmIn);
  std::list<measBlockItem *> * get_measBlockItemList();
  void set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn);
  endmesStm * get_endmesStm();
  void set_endmesStm(endmesStm * endmesStmIn);
private:
  measStm * a_measStm;
  std::list<measBlockItem *> * a_measBlockItemList;
  endmesStm * a_endmesStm;
};

/********************************************************************/

/* measBlock_rmeasStm

This is a derived class for one of the definitions of measBlock.
It represents the following items:

rmeasStm [measBlockItemList] endmesStm

*/

class measBlock_rmeasStm :
  public measBlock
{
public:
  measBlock_rmeasStm();
  measBlock_rmeasStm(
    rmeasStm * rmeasStmIn,
    std::list<measBlockItem *> * measBlockItemListIn,
    endmesStm * endmesStmIn);
  ~measBlock_rmeasStm();
  void printSelf();
  rmeasStm * get_rmeasStm();
  void set_rmeasStm(rmeasStm * rmeasStmIn);
  std::list<measBlockItem *> * get_measBlockItemList();
  void set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn);
  endmesStm * get_endmesStm();
  void set_endmesStm(endmesStm * endmesStmIn);
private:
  rmeasStm * a_rmeasStm;
  std::list<measBlockItem *> * a_measBlockItemList;
  endmesStm * a_endmesStm;
};

/********************************************************************/

/* measBlockItem

This is a parent class.

*/

class measBlockItem :
  public dmisCppBase
{
public:
  measBlockItem();
  ~measBlockItem();
  void printSelf() = 0;
};

/********************************************************************/

/* measDoBlock

This is a class for the single definition of measDoBlock.
It represents the following items:

doStm [measBlockItemList] enddoStm

*/

class measDoBlock :
  public measBlockItem
{
public:
  measDoBlock();
  measDoBlock(
    doStm * doStmIn,
    std::list<measBlockItem *> * measBlockItemListIn,
    enddoStm * enddoStmIn);
  ~measDoBlock();
  void printSelf();
  doStm * get_doStm();
  void set_doStm(doStm * doStmIn);
  std::list<measBlockItem *> * get_measBlockItemList();
  void set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn);
  enddoStm * get_enddoStm();
  void set_enddoStm(enddoStm * enddoStmIn);
private:
  doStm * a_doStm;
  std::list<measBlockItem *> * a_measBlockItemList;
  enddoStm * a_enddoStm;
};

/********************************************************************/

/* measIfBlock

This is a class for the single definition of measIfBlock.
It represents the following items:

ifStm [measBlockItemList] [elseStm [measBlockItemList]] endifStm

*/

class measIfBlock :
  public measBlockItem
{
public:
  measIfBlock();
  measIfBlock(
    ifStm * ifStmIn,
    std::list<measBlockItem *> * ifListIn,
    elseStm * elseStmIn,
    std::list<measBlockItem *> * elseListIn,
    endifStm * endifStmIn);
  ~measIfBlock();
  void printSelf();
  ifStm * get_ifStm();
  void set_ifStm(ifStm * ifStmIn);
  std::list<measBlockItem *> * get_ifList();
  void set_ifList(std::list<measBlockItem *> * ifListIn);
  elseStm * get_elseStm();
  void set_elseStm(elseStm * elseStmIn);
  std::list<measBlockItem *> * get_elseList();
  void set_elseList(std::list<measBlockItem *> * elseListIn);
  endifStm * get_endifStm();
  void set_endifStm(endifStm * endifStmIn);
private:
  ifStm * a_ifStm;
  std::list<measBlockItem *> * ifList;
  elseStm * a_elseStm;
  std::list<measBlockItem *> * elseList;
  endifStm * a_endifStm;
};

/********************************************************************/

/* measSelectBlock

This is a class for the single definition of measSelectBlock.
It represents the following items:

selectStm measCaseBlockList [measDefaultCaseBlock] endselStm

*/

class measSelectBlock :
  public measBlockItem
{
public:
  measSelectBlock();
  measSelectBlock(
    selectStm * selectStmIn,
    std::list<measCaseBlock *> * measCaseBlockListIn,
    measDefaultCaseBlock * measDefaultCaseBlockIn,
    endselStm * endselStmIn);
  ~measSelectBlock();
  void printSelf();
  selectStm * get_selectStm();
  void set_selectStm(selectStm * selectStmIn);
  std::list<measCaseBlock *> * get_measCaseBlockList();
  void set_measCaseBlockList(std::list<measCaseBlock *> * measCaseBlockListIn);
  measDefaultCaseBlock * get_measDefaultCaseBlock();
  void set_measDefaultCaseBlock(measDefaultCaseBlock * measDefaultCaseBlockIn);
  endselStm * get_endselStm();
  void set_endselStm(endselStm * endselStmIn);
private:
  selectStm * a_selectStm;
  std::list<measCaseBlock *> * a_measCaseBlockList;
  measDefaultCaseBlock * a_measDefaultCaseBlock;
  endselStm * a_endselStm;
};

/********************************************************************/

/* measCaseBlock

This is a class for the single definition of measCaseBlock.
It represents the following items:

caseStm [measBlockItemList] endcasStm

*/

class measCaseBlock :
  public dmisCppBase
{
public:
  measCaseBlock();
  measCaseBlock(
    caseStm * caseStmIn,
    std::list<measBlockItem *> * measBlockItemListIn,
    endcasStm * endcasStmIn);
  ~measCaseBlock();
  void printSelf();
  caseStm * get_caseStm();
  void set_caseStm(caseStm * caseStmIn);
  std::list<measBlockItem *> * get_measBlockItemList();
  void set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn);
  endcasStm * get_endcasStm();
  void set_endcasStm(endcasStm * endcasStmIn);
private:
  caseStm * a_caseStm;
  std::list<measBlockItem *> * a_measBlockItemList;
  endcasStm * a_endcasStm;
};

/********************************************************************/

/* measDefaultCaseBlock

This is a class for the single definition of measDefaultCaseBlock.
It represents the following items:

dftcasStm [measBlockItemList] endcasStm

*/

class measDefaultCaseBlock :
  public dmisCppBase
{
public:
  measDefaultCaseBlock();
  measDefaultCaseBlock(
    dftcasStm * dftcasStmIn,
    std::list<measBlockItem *> * measBlockItemListIn,
    endcasStm * endcasStmIn);
  ~measDefaultCaseBlock();
  void printSelf();
  dftcasStm * get_dftcasStm();
  void set_dftcasStm(dftcasStm * dftcasStmIn);
  std::list<measBlockItem *> * get_measBlockItemList();
  void set_measBlockItemList(std::list<measBlockItem *> * measBlockItemListIn);
  endcasStm * get_endcasStm();
  void set_endcasStm(endcasStm * endcasStmIn);
private:
  dftcasStm * a_dftcasStm;
  std::list<measBlockItem *> * a_measBlockItemList;
  endcasStm * a_endcasStm;
};

/********************************************************************/

/* selectBlock

This is a class for the single definition of selectBlock.
It represents the following items:

selectStm caseBlockList [defaultCaseBlock] endselStm

*/

class selectBlock :
  public dmisBlock
{
public:
  selectBlock();
  selectBlock(
    selectStm * selectStmIn,
    std::list<caseBlock *> * caseBlockListIn,
    defaultCaseBlock * defaultCaseBlockIn,
    endselStm * endselStmIn);
  ~selectBlock();
  void printSelf();
  selectStm * get_selectStm();
  void set_selectStm(selectStm * selectStmIn);
  std::list<caseBlock *> * get_caseBlockList();
  void set_caseBlockList(std::list<caseBlock *> * caseBlockListIn);
  defaultCaseBlock * get_defaultCaseBlock();
  void set_defaultCaseBlock(defaultCaseBlock * defaultCaseBlockIn);
  endselStm * get_endselStm();
  void set_endselStm(endselStm * endselStmIn);
private:
  selectStm * a_selectStm;
  std::list<caseBlock *> * a_caseBlockList;
  defaultCaseBlock * a_defaultCaseBlock;
  endselStm * a_endselStm;
};

/********************************************************************/

/* simreqtBlock

This is a class for the single definition of simreqtBlock.
It represents the following items:

simreqtStm [evalOrOutputList] endsimreqtStm

*/

class simreqtBlock :
  public dmisBlock
{
public:
  simreqtBlock();
  simreqtBlock(
    simreqtStm * simreqtStmIn,
    std::list<evalOrOutput *> * evalOrOutputListIn,
    endsimreqtStm * endsimreqtStmIn);
  ~simreqtBlock();
  void printSelf();
  simreqtStm * get_simreqtStm();
  void set_simreqtStm(simreqtStm * simreqtStmIn);
  std::list<evalOrOutput *> * get_evalOrOutputList();
  void set_evalOrOutputList(std::list<evalOrOutput *> * evalOrOutputListIn);
  endsimreqtStm * get_endsimreqtStm();
  void set_endsimreqtStm(endsimreqtStm * endsimreqtStmIn);
private:
  simreqtStm * a_simreqtStm;
  std::list<evalOrOutput *> * a_evalOrOutputList;
  endsimreqtStm * a_endsimreqtStm;
};

/********************************************************************/

/* evalOrOutput

This is a parent class.

*/

class evalOrOutput :
  public dmisCppBase
{
public:
  evalOrOutput();
  ~evalOrOutput();
  void printSelf() = 0;
};

/********************************************************************/

/* xternBlock

This is a class for the single definition of xternBlock.
It represents the following items:

xternStm [extfilList] endxtnStm

*/

class xternBlock :
  public dmisBlock
{
public:
  xternBlock();
  xternBlock(
    xternStm * xternStmIn,
    std::list<extfilStm *> * extfilListIn,
    endxtnStm * endxtnStmIn);
  ~xternBlock();
  void printSelf();
  xternStm * get_xternStm();
  void set_xternStm(xternStm * xternStmIn);
  std::list<extfilStm *> * get_extfilList();
  void set_extfilList(std::list<extfilStm *> * extfilListIn);
  endxtnStm * get_endxtnStm();
  void set_endxtnStm(endxtnStm * endxtnStmIn);
private:
  xternStm * a_xternStm;
  std::list<extfilStm *> * a_extfilList;
  endxtnStm * a_endxtnStm;
};

/********************************************************************/

/* dmisFreeStatement

This is a parent class.

*/

class dmisFreeStatement :
  public dmisItem
{
public:
  dmisFreeStatement();
  ~dmisFreeStatement();
  void printSelf() = 0;
};

/********************************************************************/

/* stringRel

This is a parent class.

*/

class stringRel :
  public dmisCppBase
{
public:
  stringRel();
  ~stringRel();
  void printSelf() = 0;
};

/********************************************************************/

/* stringRel_EQ

This is a derived class for one of the definitions of stringRel.
It represents the following items:

stringVal EQ stringVal

*/

class stringRel_EQ :
  public stringRel
{
public:
  stringRel_EQ();
  stringRel_EQ(
    stringVal * leftIn,
    stringVal * rightIn);
  ~stringRel_EQ();
  void printSelf();
  stringVal * get_left();
  void set_left(stringVal * leftIn);
  stringVal * get_right();
  void set_right(stringVal * rightIn);
private:
  stringVal * left;
  stringVal * right;
};

/********************************************************************/

/* stringRel_NE

This is a derived class for one of the definitions of stringRel.
It represents the following items:

stringVal NE stringVal

*/

class stringRel_NE :
  public stringRel
{
public:
  stringRel_NE();
  stringRel_NE(
    stringVal * leftIn,
    stringVal * rightIn);
  ~stringRel_NE();
  void printSelf();
  stringVal * get_left();
  void set_left(stringVal * leftIn);
  stringVal * get_right();
  void set_right(stringVal * rightIn);
private:
  stringVal * left;
  stringVal * right;
};

/********************************************************************/

/* stringRel_LT

This is a derived class for one of the definitions of stringRel.
It represents the following items:

stringVal LT stringVal

*/

class stringRel_LT :
  public stringRel
{
public:
  stringRel_LT();
  stringRel_LT(
    stringVal * leftIn,
    stringVal * rightIn);
  ~stringRel_LT();
  void printSelf();
  stringVal * get_left();
  void set_left(stringVal * leftIn);
  stringVal * get_right();
  void set_right(stringVal * rightIn);
private:
  stringVal * left;
  stringVal * right;
};

/********************************************************************/

/* stringRel_LE

This is a derived class for one of the definitions of stringRel.
It represents the following items:

stringVal LE stringVal

*/

class stringRel_LE :
  public stringRel
{
public:
  stringRel_LE();
  stringRel_LE(
    stringVal * leftIn,
    stringVal * rightIn);
  ~stringRel_LE();
  void printSelf();
  stringVal * get_left();
  void set_left(stringVal * leftIn);
  stringVal * get_right();
  void set_right(stringVal * rightIn);
private:
  stringVal * left;
  stringVal * right;
};

/********************************************************************/

/* stringRel_GT

This is a derived class for one of the definitions of stringRel.
It represents the following items:

stringVal GT stringVal

*/

class stringRel_GT :
  public stringRel
{
public:
  stringRel_GT();
  stringRel_GT(
    stringVal * leftIn,
    stringVal * rightIn);
  ~stringRel_GT();
  void printSelf();
  stringVal * get_left();
  void set_left(stringVal * leftIn);
  stringVal * get_right();
  void set_right(stringVal * rightIn);
private:
  stringVal * left;
  stringVal * right;
};

/********************************************************************/

/* stringRel_GE

This is a derived class for one of the definitions of stringRel.
It represents the following items:

stringVal GE stringVal

*/

class stringRel_GE :
  public stringRel
{
public:
  stringRel_GE();
  stringRel_GE(
    stringVal * leftIn,
    stringVal * rightIn);
  ~stringRel_GE();
  void printSelf();
  stringVal * get_left();
  void set_left(stringVal * leftIn);
  stringVal * get_right();
  void set_right(stringVal * rightIn);
private:
  stringVal * left;
  stringVal * right;
};

/********************************************************************/

/* boolRel

This is a parent class.

*/

class boolRel :
  public dmisCppBase
{
public:
  boolRel();
  ~boolRel();
  void printSelf() = 0;
};

/********************************************************************/

/* boolRel_NOT

This is a derived class for one of the definitions of boolRel.
It represents the following items:

NOT boolVal

*/

class boolRel_NOT :
  public boolRel
{
public:
  boolRel_NOT();
  boolRel_NOT(
    boolVal * boolValIn);
  ~boolRel_NOT();
  void printSelf();
  boolVal * get_boolVal();
  void set_boolVal(boolVal * boolValIn);
private:
  boolVal * a_boolVal;
};

/********************************************************************/

/* boolRel_AND

This is a derived class for one of the definitions of boolRel.
It represents the following items:

boolVal AND boolVal

*/

class boolRel_AND :
  public boolRel
{
public:
  boolRel_AND();
  boolRel_AND(
    boolVal * leftIn,
    boolVal * rightIn);
  ~boolRel_AND();
  void printSelf();
  boolVal * get_left();
  void set_left(boolVal * leftIn);
  boolVal * get_right();
  void set_right(boolVal * rightIn);
private:
  boolVal * left;
  boolVal * right;
};

/********************************************************************/

/* boolRel_OR

This is a derived class for one of the definitions of boolRel.
It represents the following items:

boolVal OR boolVal

*/

class boolRel_OR :
  public boolRel
{
public:
  boolRel_OR();
  boolRel_OR(
    boolVal * leftIn,
    boolVal * rightIn);
  ~boolRel_OR();
  void printSelf();
  boolVal * get_left();
  void set_left(boolVal * leftIn);
  boolVal * get_right();
  void set_right(boolVal * rightIn);
private:
  boolVal * left;
  boolVal * right;
};

/********************************************************************/

/* boolRel_EQ

This is a derived class for one of the definitions of boolRel.
It represents the following items:

boolVal EQ boolVal

*/

class boolRel_EQ :
  public boolRel
{
public:
  boolRel_EQ();
  boolRel_EQ(
    boolVal * leftIn,
    boolVal * rightIn);
  ~boolRel_EQ();
  void printSelf();
  boolVal * get_left();
  void set_left(boolVal * leftIn);
  boolVal * get_right();
  void set_right(boolVal * rightIn);
private:
  boolVal * left;
  boolVal * right;
};

/********************************************************************/

/* boolRel_NE

This is a derived class for one of the definitions of boolRel.
It represents the following items:

boolVal NE boolVal

*/

class boolRel_NE :
  public boolRel
{
public:
  boolRel_NE();
  boolRel_NE(
    boolVal * leftIn,
    boolVal * rightIn);
  ~boolRel_NE();
  void printSelf();
  boolVal * get_left();
  void set_left(boolVal * leftIn);
  boolVal * get_right();
  void set_right(boolVal * rightIn);
private:
  boolVal * left;
  boolVal * right;
};

/********************************************************************/

/* intRel

This is a parent class.

*/

class intRel :
  public dmisCppBase
{
public:
  intRel();
  ~intRel();
  void printSelf() = 0;
};

/********************************************************************/

/* intRel_EQ

This is a derived class for one of the definitions of intRel.
It represents the following items:

intVal EQ intVal

*/

class intRel_EQ :
  public intRel
{
public:
  intRel_EQ();
  intRel_EQ(
    intVal * leftIn,
    intVal * rightIn);
  ~intRel_EQ();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  intVal * left;
  intVal * right;
};

/********************************************************************/

/* intRel_NE

This is a derived class for one of the definitions of intRel.
It represents the following items:

intVal NE intVal

*/

class intRel_NE :
  public intRel
{
public:
  intRel_NE();
  intRel_NE(
    intVal * leftIn,
    intVal * rightIn);
  ~intRel_NE();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  intVal * left;
  intVal * right;
};

/********************************************************************/

/* intRel_LT

This is a derived class for one of the definitions of intRel.
It represents the following items:

intVal LT intVal

*/

class intRel_LT :
  public intRel
{
public:
  intRel_LT();
  intRel_LT(
    intVal * leftIn,
    intVal * rightIn);
  ~intRel_LT();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  intVal * left;
  intVal * right;
};

/********************************************************************/

/* intRel_LE

This is a derived class for one of the definitions of intRel.
It represents the following items:

intVal LE intVal

*/

class intRel_LE :
  public intRel
{
public:
  intRel_LE();
  intRel_LE(
    intVal * leftIn,
    intVal * rightIn);
  ~intRel_LE();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  intVal * left;
  intVal * right;
};

/********************************************************************/

/* intRel_GT

This is a derived class for one of the definitions of intRel.
It represents the following items:

intVal GT intVal

*/

class intRel_GT :
  public intRel
{
public:
  intRel_GT();
  intRel_GT(
    intVal * leftIn,
    intVal * rightIn);
  ~intRel_GT();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  intVal * left;
  intVal * right;
};

/********************************************************************/

/* intRel_GE

This is a derived class for one of the definitions of intRel.
It represents the following items:

intVal GE intVal

*/

class intRel_GE :
  public intRel
{
public:
  intRel_GE();
  intRel_GE(
    intVal * leftIn,
    intVal * rightIn);
  ~intRel_GE();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  intVal * left;
  intVal * right;
};

/********************************************************************/

/* realRel

This is a parent class.

*/

class realRel :
  public dmisCppBase
{
public:
  realRel();
  ~realRel();
  void printSelf() = 0;
};

/********************************************************************/

/* realRealRel

This is a parent class.

*/

class realRealRel :
  public realRel
{
public:
  realRealRel();
  ~realRealRel();
  void printSelf() = 0;
};

/********************************************************************/

/* realRealRel_EQ

This is a derived class for one of the definitions of realRealRel.
It represents the following items:

realVal EQ realVal

*/

class realRealRel_EQ :
  public realRealRel
{
public:
  realRealRel_EQ();
  realRealRel_EQ(
    realVal * leftIn,
    realVal * rightIn);
  ~realRealRel_EQ();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  realVal * left;
  realVal * right;
};

/********************************************************************/

/* realRealRel_NE

This is a derived class for one of the definitions of realRealRel.
It represents the following items:

realVal NE realVal

*/

class realRealRel_NE :
  public realRealRel
{
public:
  realRealRel_NE();
  realRealRel_NE(
    realVal * leftIn,
    realVal * rightIn);
  ~realRealRel_NE();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  realVal * left;
  realVal * right;
};

/********************************************************************/

/* realRealRel_LT

This is a derived class for one of the definitions of realRealRel.
It represents the following items:

realVal LT realVal

*/

class realRealRel_LT :
  public realRealRel
{
public:
  realRealRel_LT();
  realRealRel_LT(
    realVal * leftIn,
    realVal * rightIn);
  ~realRealRel_LT();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  realVal * left;
  realVal * right;
};

/********************************************************************/

/* realRealRel_LE

This is a derived class for one of the definitions of realRealRel.
It represents the following items:

realVal LE realVal

*/

class realRealRel_LE :
  public realRealRel
{
public:
  realRealRel_LE();
  realRealRel_LE(
    realVal * leftIn,
    realVal * rightIn);
  ~realRealRel_LE();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  realVal * left;
  realVal * right;
};

/********************************************************************/

/* realRealRel_GT

This is a derived class for one of the definitions of realRealRel.
It represents the following items:

realVal GT realVal

*/

class realRealRel_GT :
  public realRealRel
{
public:
  realRealRel_GT();
  realRealRel_GT(
    realVal * leftIn,
    realVal * rightIn);
  ~realRealRel_GT();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  realVal * left;
  realVal * right;
};

/********************************************************************/

/* realRealRel_GE

This is a derived class for one of the definitions of realRealRel.
It represents the following items:

realVal GE realVal

*/

class realRealRel_GE :
  public realRealRel
{
public:
  realRealRel_GE();
  realRealRel_GE(
    realVal * leftIn,
    realVal * rightIn);
  ~realRealRel_GE();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  realVal * left;
  realVal * right;
};

/********************************************************************/

/* intRealRel

This is a parent class.

*/

class intRealRel :
  public realRel
{
public:
  intRealRel();
  ~intRealRel();
  void printSelf() = 0;
};

/********************************************************************/

/* intRealRel_EQ

This is a derived class for one of the definitions of intRealRel.
It represents the following items:

intVal EQ realVal

*/

class intRealRel_EQ :
  public intRealRel
{
public:
  intRealRel_EQ();
  intRealRel_EQ(
    intVal * leftIn,
    realVal * rightIn);
  ~intRealRel_EQ();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  intVal * left;
  realVal * right;
};

/********************************************************************/

/* intRealRel_NE

This is a derived class for one of the definitions of intRealRel.
It represents the following items:

intVal NE realVal

*/

class intRealRel_NE :
  public intRealRel
{
public:
  intRealRel_NE();
  intRealRel_NE(
    intVal * leftIn,
    realVal * rightIn);
  ~intRealRel_NE();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  intVal * left;
  realVal * right;
};

/********************************************************************/

/* intRealRel_LT

This is a derived class for one of the definitions of intRealRel.
It represents the following items:

intVal LT realVal

*/

class intRealRel_LT :
  public intRealRel
{
public:
  intRealRel_LT();
  intRealRel_LT(
    intVal * leftIn,
    realVal * rightIn);
  ~intRealRel_LT();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  intVal * left;
  realVal * right;
};

/********************************************************************/

/* intRealRel_LE

This is a derived class for one of the definitions of intRealRel.
It represents the following items:

intVal LE realVal

*/

class intRealRel_LE :
  public intRealRel
{
public:
  intRealRel_LE();
  intRealRel_LE(
    intVal * leftIn,
    realVal * rightIn);
  ~intRealRel_LE();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  intVal * left;
  realVal * right;
};

/********************************************************************/

/* intRealRel_GT

This is a derived class for one of the definitions of intRealRel.
It represents the following items:

intVal GT realVal

*/

class intRealRel_GT :
  public intRealRel
{
public:
  intRealRel_GT();
  intRealRel_GT(
    intVal * leftIn,
    realVal * rightIn);
  ~intRealRel_GT();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  intVal * left;
  realVal * right;
};

/********************************************************************/

/* intRealRel_GE

This is a derived class for one of the definitions of intRealRel.
It represents the following items:

intVal GE realVal

*/

class intRealRel_GE :
  public intRealRel
{
public:
  intRealRel_GE();
  intRealRel_GE(
    intVal * leftIn,
    realVal * rightIn);
  ~intRealRel_GE();
  void printSelf();
  intVal * get_left();
  void set_left(intVal * leftIn);
  realVal * get_right();
  void set_right(realVal * rightIn);
private:
  intVal * left;
  realVal * right;
};

/********************************************************************/

/* realIntRel

This is a parent class.

*/

class realIntRel :
  public realRel
{
public:
  realIntRel();
  ~realIntRel();
  void printSelf() = 0;
};

/********************************************************************/

/* realIntRel_EQ

This is a derived class for one of the definitions of realIntRel.
It represents the following items:

realVal EQ intVal

*/

class realIntRel_EQ :
  public realIntRel
{
public:
  realIntRel_EQ();
  realIntRel_EQ(
    realVal * leftIn,
    intVal * rightIn);
  ~realIntRel_EQ();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  realVal * left;
  intVal * right;
};

/********************************************************************/

/* realIntRel_NE

This is a derived class for one of the definitions of realIntRel.
It represents the following items:

realVal NE intVal

*/

class realIntRel_NE :
  public realIntRel
{
public:
  realIntRel_NE();
  realIntRel_NE(
    realVal * leftIn,
    intVal * rightIn);
  ~realIntRel_NE();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  realVal * left;
  intVal * right;
};

/********************************************************************/

/* realIntRel_LT

This is a derived class for one of the definitions of realIntRel.
It represents the following items:

realVal LT intVal

*/

class realIntRel_LT :
  public realIntRel
{
public:
  realIntRel_LT();
  realIntRel_LT(
    realVal * leftIn,
    intVal * rightIn);
  ~realIntRel_LT();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  realVal * left;
  intVal * right;
};

/********************************************************************/

/* realIntRel_LE

This is a derived class for one of the definitions of realIntRel.
It represents the following items:

realVal LE intVal

*/

class realIntRel_LE :
  public realIntRel
{
public:
  realIntRel_LE();
  realIntRel_LE(
    realVal * leftIn,
    intVal * rightIn);
  ~realIntRel_LE();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  realVal * left;
  intVal * right;
};

/********************************************************************/

/* realIntRel_GT

This is a derived class for one of the definitions of realIntRel.
It represents the following items:

realVal GT intVal

*/

class realIntRel_GT :
  public realIntRel
{
public:
  realIntRel_GT();
  realIntRel_GT(
    realVal * leftIn,
    intVal * rightIn);
  ~realIntRel_GT();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  realVal * left;
  intVal * right;
};

/********************************************************************/

/* realIntRel_GE

This is a derived class for one of the definitions of realIntRel.
It represents the following items:

realVal GE intVal

*/

class realIntRel_GE :
  public realIntRel
{
public:
  realIntRel_GE();
  realIntRel_GE(
    realVal * leftIn,
    intVal * rightIn);
  ~realIntRel_GE();
  void printSelf();
  realVal * get_left();
  void set_left(realVal * leftIn);
  intVal * get_right();
  void set_right(intVal * rightIn);
private:
  realVal * left;
  intVal * right;
};

/********************************************************************/

/* vectorRel

This is a parent class.

*/

class vectorRel :
  public dmisCppBase
{
public:
  vectorRel();
  ~vectorRel();
  void printSelf() = 0;
};

/********************************************************************/

/* vectorRel_EQ

This is a derived class for one of the definitions of vectorRel.
It represents the following items:

vectorVal EQ vectorVal

*/

class vectorRel_EQ :
  public vectorRel
{
public:
  vectorRel_EQ();
  vectorRel_EQ(
    vectorVal * leftIn,
    vectorVal * rightIn);
  ~vectorRel_EQ();
  void printSelf();
  vectorVal * get_left();
  void set_left(vectorVal * leftIn);
  vectorVal * get_right();
  void set_right(vectorVal * rightIn);
private:
  vectorVal * left;
  vectorVal * right;
};

/********************************************************************/

/* vectorRel_NE

This is a derived class for one of the definitions of vectorRel.
It represents the following items:

vectorVal NE vectorVal

*/

class vectorRel_NE :
  public vectorRel
{
public:
  vectorRel_NE();
  vectorRel_NE(
    vectorVal * leftIn,
    vectorVal * rightIn);
  ~vectorRel_NE();
  void printSelf();
  vectorVal * get_left();
  void set_left(vectorVal * leftIn);
  vectorVal * get_right();
  void set_right(vectorVal * rightIn);
private:
  vectorVal * left;
  vectorVal * right;
};

/********************************************************************/

/* arrayIndex

This is a class for the single definition of arrayIndex.
It represents the following items:

'[' intList ']'

*/

class arrayIndex :
  public dmisCppBase
{
public:
  arrayIndex();
  arrayIndex(
    std::list<intVal *> * indexesIn);
  ~arrayIndex();
  void printSelf();
  std::list<intVal *> * get_indexes();
  void set_indexes(std::list<intVal *> * indexesIn);
private:
  std::list<intVal *> * indexes;
};

/********************************************************************/

/* longShort

This is a parent class.

*/

class longShort :
  public dmisCppBase
{
public:
  longShort();
  ~longShort();
  void printSelf() = 0;
};

/********************************************************************/

/* longShort_LONG

This is a derived class for one of the definitions of longShort.
It represents the following items:

LONG

*/

class longShort_LONG :
  public longShort
{
public:
  longShort_LONG();
  ~longShort_LONG();
  void printSelf();
};

/********************************************************************/

/* longShort_SHORT

This is a derived class for one of the definitions of longShort.
It represents the following items:

SHORT

*/

class longShort_SHORT :
  public longShort
{
public:
  longShort_SHORT();
  ~longShort_SHORT();
  void printSelf();
};

/********************************************************************/

/* strVar7

This is a class for the single definition of strVar7.
It represents the following items:

',' intVal [':' intVal]

*/

class strVar7 :
  public dmisCppBase
{
public:
  strVar7();
  strVar7(
    intVal * widthIn,
    intVal * decimalIn);
  ~strVar7();
  void printSelf();
  intVal * get_width();
  void set_width(intVal * widthIn);
  intVal * get_decimal();
  void set_decimal(intVal * decimalIn);
private:
  intVal * width;
  intVal * decimal;
};

/********************************************************************/

/* labelNameConst

This is a class for the single definition of labelNameConst.
It represents the following items:

'(' LBLNAME ')'

*/

class labelNameConst :
  public dmisCppBase
{
public:
  labelNameConst();
  labelNameConst(
    char * stringIn);
  ~labelNameConst();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
private:
  char * a_string;
};

/********************************************************************/

/* datumLabel

This is a parent class.

*/

class datumLabel :
  public dmisCppBase
{
public:
  datumLabel();
  ~datumLabel();
  void printSelf() = 0;
};

/********************************************************************/

/* datumLabel1

This is a parent class.

*/

class datumLabel1 :
  public dmisCppBase
{
public:
  datumLabel1();
  ~datumLabel1();
  void printSelf() = 0;
};

/********************************************************************/

/* datumLabel2

This is a parent class.

*/

class datumLabel2 :
  public dmisCppBase
{
public:
  datumLabel2();
  ~datumLabel2();
  void printSelf() = 0;
};

/********************************************************************/

/* featureLabel1

This is a parent class.

*/

class featureLabel1 :
  public dmisCppBase
{
public:
  featureLabel1();
  ~featureLabel1();
  void printSelf() = 0;
};

/********************************************************************/

/* sensorLabel1

This is a parent class.

*/

class sensorLabel1 :
  public dmisCppBase
{
public:
  sensorLabel1();
  ~sensorLabel1();
  void printSelf() = 0;
};

/********************************************************************/

/* sensorLabel2

This is a parent class.

*/

class sensorLabel2 :
  public dmisCppBase
{
public:
  sensorLabel2();
  ~sensorLabel2();
  void printSelf() = 0;
};

/********************************************************************/

/* toleranceLabel

This is a parent class.

*/

class toleranceLabel :
  public dmisCppBase
{
public:
  toleranceLabel();
  ~toleranceLabel();
  void printSelf() = 0;
};

/********************************************************************/

/* crLabel

This is a class for the single definition of crLabel.
It represents the following items:

CR labelName

*/

class crLabel :
  public dmisCppBase
{
public:
  crLabel();
  crLabel(
    labelName * labelNameIn);
  ~crLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* crLabelConst

This is a class for the single definition of crLabelConst.
It represents the following items:

CR labelNameConst

*/

class crLabelConst :
  public dmisCppBase
{
public:
  crLabelConst();
  crLabelConst(
    labelNameConst * labelNameConstIn);
  ~crLabelConst();
  void printSelf();
  labelNameConst * get_labelNameConst();
  void set_labelNameConst(labelNameConst * labelNameConstIn);
private:
  labelNameConst * a_labelNameConst;
};

/********************************************************************/

/* czLabel

This is a class for the single definition of czLabel.
It represents the following items:

CZ labelName

*/

class czLabel :
  public dmisCppBase
{
public:
  czLabel();
  czLabel(
    labelName * labelNameIn);
  ~czLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* dLabel

This is a class for the single definition of dLabel.
It represents the following items:

D labelName

*/

class dLabel :
  public datumLabel,
  public datumLabel1,
  public datumLabel2
{
public:
  dLabel();
  dLabel(
    labelName * labelNameIn);
  ~dLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* daLabel

This is a class for the single definition of daLabel.
It represents the following items:

DA labelName

*/

class daLabel :
  public datumLabel,
  public datumLabel1,
  public datumLabel2
{
public:
  daLabel();
  daLabel(
    labelName * labelNameIn);
  ~daLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* dattrgLabel

This is a class for the single definition of dattrgLabel.
It represents the following items:

DATTRG labelName

*/

class dattrgLabel :
  public dmisCppBase
{
public:
  dattrgLabel();
  dattrgLabel(
    labelName * labelNameIn);
  ~dattrgLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* didLabel

This is a class for the single definition of didLabel.
It represents the following items:

DID labelName

*/

class didLabel :
  public dmisCppBase
{
public:
  didLabel();
  didLabel(
    labelName * labelNameIn);
  ~didLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* drLabel

This is a class for the single definition of drLabel.
It represents the following items:

DR labelName

*/

class drLabel :
  public dmisCppBase
{
public:
  drLabel();
  drLabel(
    labelName * labelNameIn);
  ~drLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* gsaLabel

This is a class for the single definition of gsaLabel.
It represents the following items:

GSA labelName

*/

class gsaLabel :
  public dmisCppBase
{
public:
  gsaLabel();
  gsaLabel(
    labelName * labelNameIn);
  ~gsaLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* mLabel

This is a class for the single definition of mLabel.
It represents the following items:

M labelName

*/

class mLabel :
  public dmisCppBase
{
public:
  mLabel();
  mLabel(
    labelName * labelNameIn);
  ~mLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* mLabelConst

This is a class for the single definition of mLabelConst.
It represents the following items:

M labelNameConst

*/

class mLabelConst :
  public dmisCppBase
{
public:
  mLabelConst();
  mLabelConst(
    labelNameConst * labelNameConstIn);
  ~mLabelConst();
  void printSelf();
  labelNameConst * get_labelNameConst();
  void set_labelNameConst(labelNameConst * labelNameConstIn);
private:
  labelNameConst * a_labelNameConst;
};

/********************************************************************/

/* pLabel

This is a class for the single definition of pLabel.
It represents the following items:

P labelName

*/

class pLabel :
  public dmisCppBase
{
public:
  pLabel();
  pLabel(
    labelName * labelNameIn);
  ~pLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* rtLabel

This is a class for the single definition of rtLabel.
It represents the following items:

RT labelName

*/

class rtLabel :
  public dmisCppBase
{
public:
  rtLabel();
  rtLabel(
    labelName * labelNameIn);
  ~rtLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* sLabel

This is a class for the single definition of sLabel.
It represents the following items:

S labelName

*/

class sLabel :
  public sensorLabel1,
  public sensorLabel2
{
public:
  sLabel();
  sLabel(
    labelName * labelNameIn);
  ~sLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* saLabel

This is a class for the single definition of saLabel.
It represents the following items:

SA labelName

*/

class saLabel :
  public sensorLabel1,
  public sensorLabel2
{
public:
  saLabel();
  saLabel(
    labelName * labelNameIn);
  ~saLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* seLabel

This is a class for the single definition of seLabel.
It represents the following items:

SE labelName

*/

class seLabel :
  public dmisCppBase
{
public:
  seLabel();
  seLabel(
    labelName * labelNameIn);
  ~seLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* srLabel

This is a class for the single definition of srLabel.
It represents the following items:

SR labelName

*/

class srLabel :
  public dmisCppBase
{
public:
  srLabel();
  srLabel(
    labelName * labelNameIn);
  ~srLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* sraLabel

This is a class for the single definition of sraLabel.
It represents the following items:

SRA labelName

*/

class sraLabel :
  public dmisCppBase
{
public:
  sraLabel();
  sraLabel(
    labelName * labelNameIn);
  ~sraLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* stLabel

This is a class for the single definition of stLabel.
It represents the following items:

ST labelName

*/

class stLabel :
  public dmisCppBase
{
public:
  stLabel();
  stLabel(
    labelName * labelNameIn);
  ~stLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* thLabel

This is a class for the single definition of thLabel.
It represents the following items:

TH labelName

*/

class thLabel :
  public dmisCppBase
{
public:
  thLabel();
  thLabel(
    labelName * labelNameIn);
  ~thLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* uLabel

This is a class for the single definition of uLabel.
It represents the following items:

U labelName

*/

class uLabel :
  public dmisCppBase
{
public:
  uLabel();
  uLabel(
    labelName * labelNameIn);
  ~uLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* vLabel

This is a class for the single definition of vLabel.
It represents the following items:

V labelName

*/

class vLabel :
  public dmisCppBase
{
public:
  vLabel();
  vLabel(
    labelName * labelNameIn);
  ~vLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* vlLabel

This is a class for the single definition of vlLabel.
It represents the following items:

VL labelName

*/

class vlLabel :
  public dmisCppBase
{
public:
  vlLabel();
  vlLabel(
    labelName * labelNameIn);
  ~vlLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* jumpLabel

This is a parent class.

*/

class jumpLabel :
  public dmisCppBase
{
public:
  jumpLabel();
  ~jumpLabel();
  void printSelf() = 0;
};

/********************************************************************/

/* param

This is a parent class.

*/

class param :
  public dmisCppBase
{
public:
  param();
  ~param();
  void printSelf() = 0;
};

/********************************************************************/

/* leftRight

This is a parent class.

*/

class leftRight :
  public dmisCppBase
{
public:
  leftRight();
  ~leftRight();
  void printSelf() = 0;
};

/********************************************************************/

/* leftRight_LEFT

This is a derived class for one of the definitions of leftRight.
It represents the following items:

LEFT

*/

class leftRight_LEFT :
  public leftRight
{
public:
  leftRight_LEFT();
  ~leftRight_LEFT();
  void printSelf();
};

/********************************************************************/

/* leftRight_RIGHT

This is a derived class for one of the definitions of leftRight.
It represents the following items:

RIGHT

*/

class leftRight_RIGHT :
  public leftRight
{
public:
  leftRight_RIGHT();
  ~leftRight_RIGHT();
  void printSelf();
};

/********************************************************************/

/* pointRange

This is a class for the single definition of pointRange.
It represents the following items:

'[' intVal [',' intVal] ']'

*/

class pointRange :
  public dmisCppBase
{
public:
  pointRange();
  pointRange(
    intVal * index1In,
    intVal * index2In);
  ~pointRange();
  void printSelf();
  intVal * get_index1();
  void set_index1(intVal * index1In);
  intVal * get_index2();
  void set_index2(intVal * index2In);
private:
  intVal * index1;
  intVal * index2;
};

/********************************************************************/

/* indexedFeature

This is a class for the single definition of indexedFeature.
It represents the following items:

featureLabel pointRange

*/

class indexedFeature :
  public dmisCppBase
{
public:
  indexedFeature();
  indexedFeature(
    featureLabel * featureLabelIn,
    pointRange * pointRangeIn);
  ~indexedFeature();
  void printSelf();
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  pointRange * get_pointRange();
  void set_pointRange(pointRange * pointRangeIn);
private:
  featureLabel * a_featureLabel;
  pointRange * a_pointRange;
};

/********************************************************************/

/* versionTag

This is a class for the single definition of versionTag.
It represents the following items:

REALSTRING

*/

class versionTag :
  public dmisCppBase
{
public:
  versionTag();
  versionTag(
    double doubleIn);
  ~versionTag();
  void printSelf();
  double get_double();
  void set_double(double doubleIn);
private:
  double a_double;
};

/********************************************************************/

/* angle

This is a parent class.

*/

class angle :
  public dmisCppBase
{
public:
  angle();
  ~angle();
  void printSelf() = 0;
};

/********************************************************************/

/* angleDms

This is a class for the single definition of angleDms.
It represents the following items:

INTSTRING ':' INTSTRING [':' secondsString]

*/

class angleDms :
  public angle
{
public:
  angleDms();
  angleDms(
    int degreesIn,
    int minutesIn,
    secondsString * secondsStringIn);
  ~angleDms();
  void printSelf();
  int get_degrees();
  void set_degrees(int degreesIn);
  int get_minutes();
  void set_minutes(int minutesIn);
  secondsString * get_secondsString();
  void set_secondsString(secondsString * secondsStringIn);
private:
  int degrees;
  int minutes;
  secondsString * a_secondsString;
};

/********************************************************************/

/* noParseStm

This is a class for the single definition of noParseStm.
It represents the following items:

CHARSTRING #

*/

class noParseStm :
  public dmisCppBase
{
public:
  noParseStm();
  noParseStm(
    char * stringIn);
  ~noParseStm();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
private:
  char * a_string;
};

/********************************************************************/

/* secondsString

This is a parent class.

*/

class secondsString :
  public dmisCppBase
{
public:
  secondsString();
  ~secondsString();
  void printSelf() = 0;
};

/********************************************************************/

/* secondsString_REALSTRING

This is a derived class for one of the definitions of secondsString.
It represents the following items:

REALSTRING

*/

class secondsString_REALSTRING :
  public secondsString
{
public:
  secondsString_REALSTRING();
  secondsString_REALSTRING(
    double doubleIn);
  ~secondsString_REALSTRING();
  void printSelf();
  double get_double();
  void set_double(double doubleIn);
private:
  double a_double;
};

/********************************************************************/

/* secondsString_INTSTRING

This is a derived class for one of the definitions of secondsString.
It represents the following items:

INTSTRING

*/

class secondsString_INTSTRING :
  public secondsString
{
public:
  secondsString_INTSTRING();
  secondsString_INTSTRING(
    int intIn);
  ~secondsString_INTSTRING();
  void printSelf();
  int get_int();
  void set_int(int intIn);
private:
  int a_int;
};

/********************************************************************/

/* vector

This is a class for the single definition of vector.
It represents the following items:

rentVal ',' rentVal ',' rentVal

*/

class vector :
  public dmisCppBase
{
public:
  vector();
  vector(
    rentVal * iIn,
    rentVal * jIn,
    rentVal * kIn);
  ~vector();
  void printSelf();
  rentVal * get_i();
  void set_i(rentVal * iIn);
  rentVal * get_j();
  void set_j(rentVal * jIn);
  rentVal * get_k();
  void set_k(rentVal * kIn);
private:
  rentVal * i;
  rentVal * j;
  rentVal * k;
};

/********************************************************************/

/* matrix

This is a class for the single definition of matrix.
It represents the following items:

rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal

*/

class matrix :
  public dmisCppBase
{
public:
  matrix();
  matrix(
    rentVal * a1In,
    rentVal * a2In,
    rentVal * a3In,
    rentVal * b1In,
    rentVal * b2In,
    rentVal * b3In,
    rentVal * c1In,
    rentVal * c2In,
    rentVal * c3In,
    rentVal * d1In,
    rentVal * d2In,
    rentVal * d3In);
  ~matrix();
  void printSelf();
  rentVal * get_a1();
  void set_a1(rentVal * a1In);
  rentVal * get_a2();
  void set_a2(rentVal * a2In);
  rentVal * get_a3();
  void set_a3(rentVal * a3In);
  rentVal * get_b1();
  void set_b1(rentVal * b1In);
  rentVal * get_b2();
  void set_b2(rentVal * b2In);
  rentVal * get_b3();
  void set_b3(rentVal * b3In);
  rentVal * get_c1();
  void set_c1(rentVal * c1In);
  rentVal * get_c2();
  void set_c2(rentVal * c2In);
  rentVal * get_c3();
  void set_c3(rentVal * c3In);
  rentVal * get_d1();
  void set_d1(rentVal * d1In);
  rentVal * get_d2();
  void set_d2(rentVal * d2In);
  rentVal * get_d3();
  void set_d3(rentVal * d3In);
private:
  rentVal * a1;
  rentVal * a2;
  rentVal * a3;
  rentVal * b1;
  rentVal * b2;
  rentVal * b3;
  rentVal * c1;
  rentVal * c2;
  rentVal * c3;
  rentVal * d1;
  rentVal * d2;
  rentVal * d3;
};

/********************************************************************/

/* rwVar

This is a parent class.

*/

class rwVar :
  public dmisCppBase
{
public:
  rwVar();
  ~rwVar();
  void printSelf() = 0;
};

/********************************************************************/

/* rwFormat

This is a class for the single definition of rwFormat.
It represents the following items:

':' intVal [':' intVal]

*/

class rwFormat :
  public dmisCppBase
{
public:
  rwFormat();
  rwFormat(
    intVal * widthIn,
    intVal * decimalIn);
  ~rwFormat();
  void printSelf();
  intVal * get_width();
  void set_width(intVal * widthIn);
  intVal * get_decimal();
  void set_decimal(intVal * decimalIn);
private:
  intVal * width;
  intVal * decimal;
};

/********************************************************************/

/* device

This is a parent class.

*/

class device :
  public dmisCppBase
{
public:
  device();
  ~device();
  void printSelf() = 0;
};

/********************************************************************/

/* device_PRINT

This is a derived class for one of the definitions of device.
It represents the following items:

PRINT

*/

class device_PRINT :
  public device
{
public:
  device_PRINT();
  ~device_PRINT();
  void printSelf();
};

/********************************************************************/

/* device_TERM

This is a derived class for one of the definitions of device.
It represents the following items:

TERM

*/

class device_TERM :
  public device
{
public:
  device_TERM();
  ~device_TERM();
  void printSelf();
};

/********************************************************************/

/* device_COMM

This is a derived class for one of the definitions of device.
It represents the following items:

COMM

*/

class device_COMM :
  public device
{
public:
  device_COMM();
  ~device_COMM();
  void printSelf();
};

/********************************************************************/

/* device_STOR

This is a derived class for one of the definitions of device.
It represents the following items:

STOR

*/

class device_STOR :
  public device
{
public:
  device_STOR();
  ~device_STOR();
  void printSelf();
};

/********************************************************************/

/* state

This is a parent class.

*/

class state :
  public dmisCppBase
{
public:
  state();
  ~state();
  void printSelf() = 0;
};

/********************************************************************/

/* state_ON

This is a derived class for one of the definitions of state.
It represents the following items:

ON

*/

class state_ON :
  public state
{
public:
  state_ON();
  ~state_ON();
  void printSelf();
};

/********************************************************************/

/* state_OFF

This is a derived class for one of the definitions of state.
It represents the following items:

OFF

*/

class state_OFF :
  public state
{
public:
  state_OFF();
  ~state_OFF();
  void printSelf();
};

/********************************************************************/

/* coordType

This is a parent class.

*/

class coordType :
  public dmisCppBase
{
public:
  coordType();
  ~coordType();
  void printSelf() = 0;
};

/********************************************************************/

/* coordType_CART

This is a derived class for one of the definitions of coordType.
It represents the following items:

CART

*/

class coordType_CART :
  public coordType
{
public:
  coordType_CART();
  ~coordType_CART();
  void printSelf();
};

/********************************************************************/

/* coordType_POL

This is a derived class for one of the definitions of coordType.
It represents the following items:

POL

*/

class coordType_POL :
  public coordType
{
public:
  coordType_POL();
  ~coordType_POL();
  void printSelf();
};

/********************************************************************/

/* impCartPoint

This is a class for the single definition of impCartPoint.
It represents the following items:

rentVal ',' rentVal ',' rentVal

*/

class impCartPoint :
  public dmisCppBase
{
public:
  impCartPoint();
  impCartPoint(
    rentVal * xIn,
    rentVal * yIn,
    rentVal * zIn);
  ~impCartPoint();
  void printSelf();
  rentVal * get_x();
  void set_x(rentVal * xIn);
  rentVal * get_y();
  void set_y(rentVal * yIn);
  rentVal * get_z();
  void set_z(rentVal * zIn);
private:
  rentVal * x;
  rentVal * y;
  rentVal * z;
};

/********************************************************************/

/* impPolPoint

This is a class for the single definition of impPolPoint.
It represents the following items:

rentVal ',' rentVal ',' rentVal

*/

class impPolPoint :
  public dmisCppBase
{
public:
  impPolPoint();
  impPolPoint(
    rentVal * rIn,
    rentVal * aIn,
    rentVal * hIn);
  ~impPolPoint();
  void printSelf();
  rentVal * get_r();
  void set_r(rentVal * rIn);
  rentVal * get_a();
  void set_a(rentVal * aIn);
  rentVal * get_h();
  void set_h(rentVal * hIn);
private:
  rentVal * r;
  rentVal * a;
  rentVal * h;
};

/********************************************************************/

/* typePoint

This is a parent class.

*/

class typePoint :
  public dmisCppBase
{
public:
  typePoint();
  ~typePoint();
  void printSelf() = 0;
};

/********************************************************************/

/* pointVecCart

This is a class for the single definition of pointVecCart.
It represents the following items:

rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal

*/

class pointVecCart :
  public dmisCppBase
{
public:
  pointVecCart();
  pointVecCart(
    rentVal * xIn,
    rentVal * yIn,
    rentVal * zIn,
    rentVal * iIn,
    rentVal * jIn,
    rentVal * kIn);
  ~pointVecCart();
  void printSelf();
  rentVal * get_x();
  void set_x(rentVal * xIn);
  rentVal * get_y();
  void set_y(rentVal * yIn);
  rentVal * get_z();
  void set_z(rentVal * zIn);
  rentVal * get_i();
  void set_i(rentVal * iIn);
  rentVal * get_j();
  void set_j(rentVal * jIn);
  rentVal * get_k();
  void set_k(rentVal * kIn);
private:
  rentVal * x;
  rentVal * y;
  rentVal * z;
  rentVal * i;
  rentVal * j;
  rentVal * k;
};

/********************************************************************/

/* pointVecPol

This is a class for the single definition of pointVecPol.
It represents the following items:

rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal

*/

class pointVecPol :
  public dmisCppBase
{
public:
  pointVecPol();
  pointVecPol(
    rentVal * rIn,
    rentVal * aIn,
    rentVal * hIn,
    rentVal * iIn,
    rentVal * jIn,
    rentVal * kIn);
  ~pointVecPol();
  void printSelf();
  rentVal * get_r();
  void set_r(rentVal * rIn);
  rentVal * get_a();
  void set_a(rentVal * aIn);
  rentVal * get_h();
  void set_h(rentVal * hIn);
  rentVal * get_i();
  void set_i(rentVal * iIn);
  rentVal * get_j();
  void set_j(rentVal * jIn);
  rentVal * get_k();
  void set_k(rentVal * kIn);
private:
  rentVal * r;
  rentVal * a;
  rentVal * h;
  rentVal * i;
  rentVal * j;
  rentVal * k;
};

/********************************************************************/

/* axis

This is a parent class.

*/

class axis :
  public dmisCppBase
{
public:
  axis();
  ~axis();
  void printSelf() = 0;
};

/********************************************************************/

/* axis_XAXIS

This is a derived class for one of the definitions of axis.
It represents the following items:

XAXIS

*/

class axis_XAXIS :
  public axis
{
public:
  axis_XAXIS();
  ~axis_XAXIS();
  void printSelf();
};

/********************************************************************/

/* axis_YAXIS

This is a derived class for one of the definitions of axis.
It represents the following items:

YAXIS

*/

class axis_YAXIS :
  public axis
{
public:
  axis_YAXIS();
  ~axis_YAXIS();
  void printSelf();
};

/********************************************************************/

/* axis_ZAXIS

This is a derived class for one of the definitions of axis.
It represents the following items:

ZAXIS

*/

class axis_ZAXIS :
  public axis
{
public:
  axis_ZAXIS();
  ~axis_ZAXIS();
  void printSelf();
};

/********************************************************************/

/* orig

This is a parent class.

*/

class orig :
  public dmisCppBase
{
public:
  orig();
  ~orig();
  void printSelf() = 0;
};

/********************************************************************/

/* orig_XORIG

This is a derived class for one of the definitions of orig.
It represents the following items:

XORIG

*/

class orig_XORIG :
  public orig
{
public:
  orig_XORIG();
  ~orig_XORIG();
  void printSelf();
};

/********************************************************************/

/* orig_YORIG

This is a derived class for one of the definitions of orig.
It represents the following items:

YORIG

*/

class orig_YORIG :
  public orig
{
public:
  orig_YORIG();
  ~orig_YORIG();
  void printSelf();
};

/********************************************************************/

/* orig_ZORIG

This is a derived class for one of the definitions of orig.
It represents the following items:

ZORIG

*/

class orig_ZORIG :
  public orig
{
public:
  orig_ZORIG();
  ~orig_ZORIG();
  void printSelf();
};

/********************************************************************/

/* dir

This is a parent class.

*/

class dir :
  public dmisCppBase
{
public:
  dir();
  ~dir();
  void printSelf() = 0;
};

/********************************************************************/

/* negDir

This is a parent class.

*/

class negDir :
  public dir
{
public:
  negDir();
  ~negDir();
  void printSelf() = 0;
};

/********************************************************************/

/* negDir_MINUSXDIR

This is a derived class for one of the definitions of negDir.
It represents the following items:

MINUSXDIR

*/

class negDir_MINUSXDIR :
  public negDir
{
public:
  negDir_MINUSXDIR();
  ~negDir_MINUSXDIR();
  void printSelf();
};

/********************************************************************/

/* negDir_MINUSYDIR

This is a derived class for one of the definitions of negDir.
It represents the following items:

MINUSYDIR

*/

class negDir_MINUSYDIR :
  public negDir
{
public:
  negDir_MINUSYDIR();
  ~negDir_MINUSYDIR();
  void printSelf();
};

/********************************************************************/

/* negDir_MINUSZDIR

This is a derived class for one of the definitions of negDir.
It represents the following items:

MINUSZDIR

*/

class negDir_MINUSZDIR :
  public negDir
{
public:
  negDir_MINUSZDIR();
  ~negDir_MINUSZDIR();
  void printSelf();
};

/********************************************************************/

/* plan

This is a parent class.

*/

class plan :
  public dmisCppBase
{
public:
  plan();
  ~plan();
  void printSelf() = 0;
};

/********************************************************************/

/* plan_XYPLAN

This is a derived class for one of the definitions of plan.
It represents the following items:

XYPLAN

*/

class plan_XYPLAN :
  public plan
{
public:
  plan_XYPLAN();
  ~plan_XYPLAN();
  void printSelf();
};

/********************************************************************/

/* plan_YZPLAN

This is a derived class for one of the definitions of plan.
It represents the following items:

YZPLAN

*/

class plan_YZPLAN :
  public plan
{
public:
  plan_YZPLAN();
  ~plan_YZPLAN();
  void printSelf();
};

/********************************************************************/

/* plan_ZXPLAN

This is a derived class for one of the definitions of plan.
It represents the following items:

ZXPLAN

*/

class plan_ZXPLAN :
  public plan
{
public:
  plan_ZXPLAN();
  ~plan_ZXPLAN();
  void printSelf();
};

/********************************************************************/

/* matDir

This is a parent class.

*/

class matDir :
  public dmisCppBase
{
public:
  matDir();
  ~matDir();
  void printSelf() = 0;
};

/********************************************************************/

/* matDir_INNER

This is a derived class for one of the definitions of matDir.
It represents the following items:

INNER

*/

class matDir_INNER :
  public matDir
{
public:
  matDir_INNER();
  ~matDir_INNER();
  void printSelf();
};

/********************************************************************/

/* matDir_OUTER

This is a derived class for one of the definitions of matDir.
It represents the following items:

OUTER

*/

class matDir_OUTER :
  public matDir
{
public:
  matDir_OUTER();
  ~matDir_OUTER();
  void printSelf();
};

/********************************************************************/

/* flatRoundOpen

This is a parent class.

*/

class flatRoundOpen :
  public dmisCppBase
{
public:
  flatRoundOpen();
  ~flatRoundOpen();
  void printSelf() = 0;
};

/********************************************************************/

/* flatRoundOpen_FLAT

This is a derived class for one of the definitions of flatRoundOpen.
It represents the following items:

FLAT

*/

class flatRoundOpen_FLAT :
  public flatRoundOpen
{
public:
  flatRoundOpen_FLAT();
  ~flatRoundOpen_FLAT();
  void printSelf();
};

/********************************************************************/

/* flatRoundOpen_ROUND

This is a derived class for one of the definitions of flatRoundOpen.
It represents the following items:

ROUND

*/

class flatRoundOpen_ROUND :
  public flatRoundOpen
{
public:
  flatRoundOpen_ROUND();
  ~flatRoundOpen_ROUND();
  void printSelf();
};

/********************************************************************/

/* flatRoundOpen_OPEN

This is a derived class for one of the definitions of flatRoundOpen.
It represents the following items:

OPEN

*/

class flatRoundOpen_OPEN :
  public flatRoundOpen
{
public:
  flatRoundOpen_OPEN();
  ~flatRoundOpen_OPEN();
  void printSelf();
};

/********************************************************************/

/* radiusSpec

This is a parent class.

*/

class radiusSpec :
  public dmisCppBase
{
public:
  radiusSpec();
  ~radiusSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* radiusSpec_MAJOR

This is a derived class for one of the definitions of radiusSpec.
It represents the following items:

MAJOR

*/

class radiusSpec_MAJOR :
  public radiusSpec
{
public:
  radiusSpec_MAJOR();
  ~radiusSpec_MAJOR();
  void printSelf();
};

/********************************************************************/

/* radiusSpec_MINOR

This is a derived class for one of the definitions of radiusSpec.
It represents the following items:

MINOR

*/

class radiusSpec_MINOR :
  public radiusSpec
{
public:
  radiusSpec_MINOR();
  ~radiusSpec_MINOR();
  void printSelf();
};

/********************************************************************/

/* stackElement

This is a parent class.

*/

class stackElement :
  public dmisCppBase
{
public:
  stackElement();
  ~stackElement();
  void printSelf() = 0;
};

/********************************************************************/

/* stackElement_ALGOR

This is a derived class for one of the definitions of stackElement.
It represents the following items:

ALGOR

*/

class stackElement_ALGOR :
  public stackElement
{
public:
  stackElement_ALGOR();
  ~stackElement_ALGOR();
  void printSelf();
};

/********************************************************************/

/* stackElement_DME

This is a derived class for one of the definitions of stackElement.
It represents the following items:

DME

*/

class stackElement_DME :
  public stackElement
{
public:
  stackElement_DME();
  ~stackElement_DME();
  void printSelf();
};

/********************************************************************/

/* stackElement_DATSET

This is a derived class for one of the definitions of stackElement.
It represents the following items:

DATSET

*/

class stackElement_DATSET :
  public stackElement
{
public:
  stackElement_DATSET();
  ~stackElement_DATSET();
  void printSelf();
};

/********************************************************************/

/* stackElement_REPORT

This is a derived class for one of the definitions of stackElement.
It represents the following items:

REPORT

*/

class stackElement_REPORT :
  public stackElement
{
public:
  stackElement_REPORT();
  ~stackElement_REPORT();
  void printSelf();
};

/********************************************************************/

/* rotType

This is a parent class.

*/

class rotType :
  public dmisCppBase
{
public:
  rotType();
  ~rotType();
  void printSelf() = 0;
};

/********************************************************************/

/* rotType_ROTTOT

This is a derived class for one of the definitions of rotType.
It represents the following items:

ROTTOT

*/

class rotType_ROTTOT :
  public rotType
{
public:
  rotType_ROTTOT();
  ~rotType_ROTTOT();
  void printSelf();
};

/********************************************************************/

/* rotType_ROTORG

This is a derived class for one of the definitions of rotType.
It represents the following items:

ROTORG

*/

class rotType_ROTORG :
  public rotType
{
public:
  rotType_ROTORG();
  ~rotType_ROTORG();
  void printSelf();
};

/********************************************************************/

/* rotType_ROTNUL

This is a derived class for one of the definitions of rotType.
It represents the following items:

ROTNUL

*/

class rotType_ROTNUL :
  public rotType
{
public:
  rotType_ROTNUL();
  ~rotType_ROTNUL();
  void printSelf();
};

/********************************************************************/

/* rotDir

This is a parent class.

*/

class rotDir :
  public dmisCppBase
{
public:
  rotDir();
  ~rotDir();
  void printSelf() = 0;
};

/********************************************************************/

/* rotDir_rotOrient

This is a derived class for one of the definitions of rotDir.
It represents the following items:

rotOrient

*/

class rotDir_rotOrient :
  public rotDir
{
public:
  rotDir_rotOrient();
  rotDir_rotOrient(
    rotOrient * rotOrientIn);
  ~rotDir_rotOrient();
  void printSelf();
  rotOrient * get_rotOrient();
  void set_rotOrient(rotOrient * rotOrientIn);
private:
  rotOrient * a_rotOrient;
};

/********************************************************************/

/* rotDir_SHORT

This is a derived class for one of the definitions of rotDir.
It represents the following items:

SHORT

*/

class rotDir_SHORT :
  public rotDir
{
public:
  rotDir_SHORT();
  ~rotDir_SHORT();
  void printSelf();
};

/********************************************************************/

/* rotOrient

This is a parent class.

*/

class rotOrient :
  public dmisCppBase
{
public:
  rotOrient();
  ~rotOrient();
  void printSelf() = 0;
};

/********************************************************************/

/* rotOrient_CW

This is a derived class for one of the definitions of rotOrient.
It represents the following items:

CW

*/

class rotOrient_CW :
  public rotOrient
{
public:
  rotOrient_CW();
  ~rotOrient_CW();
  void printSelf();
};

/********************************************************************/

/* rotOrient_CCW

This is a derived class for one of the definitions of rotOrient.
It represents the following items:

CCW

*/

class rotOrient_CCW :
  public rotOrient
{
public:
  rotOrient_CCW();
  ~rotOrient_CCW();
  void printSelf();
};

/********************************************************************/

/* rotAbs

This is a class for the single definition of rotAbs.
It represents the following items:

ABSL ',' rotDir

*/

class rotAbs :
  public dmisCppBase
{
public:
  rotAbs();
  rotAbs(
    rotDir * rotDirIn);
  ~rotAbs();
  void printSelf();
  rotDir * get_rotDir();
  void set_rotDir(rotDir * rotDirIn);
private:
  rotDir * a_rotDir;
};

/********************************************************************/

/* rotIncr

This is a class for the single definition of rotIncr.
It represents the following items:

INCR ',' rotOrient

*/

class rotIncr :
  public dmisCppBase
{
public:
  rotIncr();
  rotIncr(
    rotOrient * rotOrientIn);
  ~rotIncr();
  void printSelf();
  rotOrient * get_rotOrient();
  void set_rotOrient(rotOrient * rotOrientIn);
private:
  rotOrient * a_rotOrient;
};

/********************************************************************/

/* aclratMinor

This is a parent class.

*/

class aclratMinor :
  public dmisCppBase
{
public:
  aclratMinor();
  ~aclratMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* aclratMeas

This is a class for the single definition of aclratMeas.
It represents the following items:

MESACL ',' aclratLinSpec

*/

class aclratMeas :
  public aclratMinor
{
public:
  aclratMeas();
  aclratMeas(
    aclratLinSpec * aclratLinSpecIn);
  ~aclratMeas();
  void printSelf();
  aclratLinSpec * get_aclratLinSpec();
  void set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn);
private:
  aclratLinSpec * a_aclratLinSpec;
};

/********************************************************************/

/* aclratPos

This is a class for the single definition of aclratPos.
It represents the following items:

POSACL ',' aclratLinSpec

*/

class aclratPos :
  public aclratMinor
{
public:
  aclratPos();
  aclratPos(
    aclratLinSpec * aclratLinSpecIn);
  ~aclratPos();
  void printSelf();
  aclratLinSpec * get_aclratLinSpec();
  void set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn);
private:
  aclratLinSpec * a_aclratLinSpec;
};

/********************************************************************/

/* aclratRot

This is a class for the single definition of aclratRot.
It represents the following items:

ROTACL ',' aclratAngSpec

*/

class aclratRot :
  public aclratMinor
{
public:
  aclratRot();
  aclratRot(
    aclratAngSpec * aclratAngSpecIn);
  ~aclratRot();
  void printSelf();
  aclratAngSpec * get_aclratAngSpec();
  void set_aclratAngSpec(aclratAngSpec * aclratAngSpecIn);
private:
  aclratAngSpec * a_aclratAngSpec;
};

/********************************************************************/

/* aclratScan

This is a class for the single definition of aclratScan.
It represents the following items:

SCNACL ',' aclratLinSpec

*/

class aclratScan :
  public aclratMinor
{
public:
  aclratScan();
  aclratScan(
    aclratLinSpec * aclratLinSpecIn);
  ~aclratScan();
  void printSelf();
  aclratLinSpec * get_aclratLinSpec();
  void set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn);
private:
  aclratLinSpec * a_aclratLinSpec;
};

/********************************************************************/

/* aclratHedRot

This is a class for the single definition of aclratHedRot.
It represents the following items:

HEDROTACL ',' aclratLinSpec

*/

class aclratHedRot :
  public aclratMinor
{
public:
  aclratHedRot();
  aclratHedRot(
    aclratLinSpec * aclratLinSpecIn);
  ~aclratHedRot();
  void printSelf();
  aclratLinSpec * get_aclratLinSpec();
  void set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn);
private:
  aclratLinSpec * a_aclratLinSpec;
};

/********************************************************************/

/* aclratHedMeas

This is a class for the single definition of aclratHedMeas.
It represents the following items:

HEDMESACL ',' aclratLinSpec

*/

class aclratHedMeas :
  public aclratMinor
{
public:
  aclratHedMeas();
  aclratHedMeas(
    aclratLinSpec * aclratLinSpecIn);
  ~aclratHedMeas();
  void printSelf();
  aclratLinSpec * get_aclratLinSpec();
  void set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn);
private:
  aclratLinSpec * a_aclratLinSpec;
};

/********************************************************************/

/* aclratHedScan

This is a class for the single definition of aclratHedScan.
It represents the following items:

HEDSCNACL ',' aclratLinSpec

*/

class aclratHedScan :
  public aclratMinor
{
public:
  aclratHedScan();
  aclratHedScan(
    aclratLinSpec * aclratLinSpecIn);
  ~aclratHedScan();
  void printSelf();
  aclratLinSpec * get_aclratLinSpec();
  void set_aclratLinSpec(aclratLinSpec * aclratLinSpecIn);
private:
  aclratLinSpec * a_aclratLinSpec;
};

/********************************************************************/

/* aclratAngSpec

This is a parent class.

*/

class aclratAngSpec :
  public dmisCppBase
{
public:
  aclratAngSpec();
  ~aclratAngSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* aclratLinSpec

This is a parent class.

*/

class aclratLinSpec :
  public dmisCppBase
{
public:
  aclratLinSpec();
  ~aclratLinSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* aclratLinear

This is a parent class.

*/

class aclratLinear :
  public aclratLinSpec
{
public:
  aclratLinear();
  ~aclratLinear();
  void printSelf() = 0;
};

/********************************************************************/

/* aclratLinear_MPMM

This is a derived class for one of the definitions of aclratLinear.
It represents the following items:

MPMM ',' rentVal

*/

class aclratLinear_MPMM :
  public aclratLinear
{
public:
  aclratLinear_MPMM();
  aclratLinear_MPMM(
    rentVal * accelIn);
  ~aclratLinear_MPMM();
  void printSelf();
  rentVal * get_accel();
  void set_accel(rentVal * accelIn);
private:
  rentVal * accel;
};

/********************************************************************/

/* aclratLinear_MMPSS

This is a derived class for one of the definitions of aclratLinear.
It represents the following items:

MMPSS ',' rentVal

*/

class aclratLinear_MMPSS :
  public aclratLinear
{
public:
  aclratLinear_MMPSS();
  aclratLinear_MMPSS(
    rentVal * accelIn);
  ~aclratLinear_MMPSS();
  void printSelf();
  rentVal * get_accel();
  void set_accel(rentVal * accelIn);
private:
  rentVal * accel;
};

/********************************************************************/

/* aclratLinear_IPMM

This is a derived class for one of the definitions of aclratLinear.
It represents the following items:

IPMM ',' rentVal

*/

class aclratLinear_IPMM :
  public aclratLinear
{
public:
  aclratLinear_IPMM();
  aclratLinear_IPMM(
    rentVal * accelIn);
  ~aclratLinear_IPMM();
  void printSelf();
  rentVal * get_accel();
  void set_accel(rentVal * accelIn);
private:
  rentVal * accel;
};

/********************************************************************/

/* aclratLinear_IPSS

This is a derived class for one of the definitions of aclratLinear.
It represents the following items:

IPSS ',' rentVal

*/

class aclratLinear_IPSS :
  public aclratLinear
{
public:
  aclratLinear_IPSS();
  aclratLinear_IPSS(
    rentVal * accelIn);
  ~aclratLinear_IPSS();
  void printSelf();
  rentVal * get_accel();
  void set_accel(rentVal * accelIn);
private:
  rentVal * accel;
};

/********************************************************************/

/* aclratAngular

This is a class for the single definition of aclratAngular.
It represents the following items:

RPMM ',' rentVal

*/

class aclratAngular :
  public aclratAngSpec
{
public:
  aclratAngular();
  aclratAngular(
    rentVal * accelIn);
  ~aclratAngular();
  void printSelf();
  rentVal * get_accel();
  void set_accel(rentVal * accelIn);
private:
  rentVal * accel;
};

/********************************************************************/

/* aclratDef

This is a parent class.

*/

class aclratDef :
  public aclratAngSpec,
  public aclratLinSpec
{
public:
  aclratDef();
  ~aclratDef();
  void printSelf() = 0;
};

/********************************************************************/

/* aclratDef_PCENT

This is a derived class for one of the definitions of aclratDef.
It represents the following items:

PCENT ',' rentVal

*/

class aclratDef_PCENT :
  public aclratDef
{
public:
  aclratDef_PCENT();
  aclratDef_PCENT(
    rentVal * accelIn);
  ~aclratDef_PCENT();
  void printSelf();
  rentVal * get_accel();
  void set_accel(rentVal * accelIn);
private:
  rentVal * accel;
};

/********************************************************************/

/* aclratDef_HIGH

This is a derived class for one of the definitions of aclratDef.
It represents the following items:

HIGH

*/

class aclratDef_HIGH :
  public aclratDef
{
public:
  aclratDef_HIGH();
  ~aclratDef_HIGH();
  void printSelf();
};

/********************************************************************/

/* aclratDef_LOW

This is a derived class for one of the definitions of aclratDef.
It represents the following items:

LOW

*/

class aclratDef_LOW :
  public aclratDef
{
public:
  aclratDef_LOW();
  ~aclratDef_LOW();
  void printSelf();
};

/********************************************************************/

/* aclratDef_DEFALT

This is a derived class for one of the definitions of aclratDef.
It represents the following items:

DEFALT

*/

class aclratDef_DEFALT :
  public aclratDef
{
public:
  aclratDef_DEFALT();
  ~aclratDef_DEFALT();
  void printSelf();
};

/********************************************************************/

/* algdefStm

This is a class for the single definition of algdefStm.
It represents the following items:

vaLabel '=' ALGDEF '/' algdefMinor #

*/

class algdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  algdefStm();
  algdefStm(
    vaLabel * vaLabelIn,
    algdefMinor * algdefMinorIn);
  ~algdefStm();
  void printSelf();
  vaLabel * get_vaLabel();
  void set_vaLabel(vaLabel * vaLabelIn);
  algdefMinor * get_algdefMinor();
  void set_algdefMinor(algdefMinor * algdefMinorIn);
private:
  vaLabel * a_vaLabel;
  algdefMinor * a_algdefMinor;
};

/********************************************************************/

/* algdefMinor

This is a parent class.

*/

class algdefMinor :
  public dmisCppBase
{
public:
  algdefMinor();
  ~algdefMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* algdefMinor_CODE

This is a derived class for one of the definitions of algdefMinor.
It represents the following items:

CODE ',' intVal

*/

class algdefMinor_CODE :
  public algdefMinor
{
public:
  algdefMinor_CODE();
  algdefMinor_CODE(
    intVal * codeIn);
  ~algdefMinor_CODE();
  void printSelf();
  intVal * get_code();
  void set_code(intVal * codeIn);
private:
  intVal * code;
};

/********************************************************************/

/* algdefMinor_stringVal

This is a derived class for one of the definitions of algdefMinor.
It represents the following items:

stringVal [',' paramList]

*/

class algdefMinor_stringVal :
  public algdefMinor
{
public:
  algdefMinor_stringVal();
  algdefMinor_stringVal(
    stringVal * nameIn,
    std::list<param *> * paramListIn);
  ~algdefMinor_stringVal();
  void printSelf();
  stringVal * get_name();
  void set_name(stringVal * nameIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  stringVal * name;
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* assignString

This is a class for the single definition of assignString.
It represents the following items:

stringVar '=' ASSIGN '/' stringVal

*/

class assignString :
  public dmisCppBase
{
public:
  assignString();
  assignString(
    stringVar * stringVarIn,
    stringVal * strIn);
  ~assignString();
  void printSelf();
  stringVar * get_stringVar();
  void set_stringVar(stringVar * stringVarIn);
  stringVal * get_str();
  void set_str(stringVal * strIn);
private:
  stringVar * a_stringVar;
  stringVal * str;
};

/********************************************************************/

/* assignBool

This is a class for the single definition of assignBool.
It represents the following items:

boolVar '=' ASSIGN '/' boolVal

*/

class assignBool :
  public dmisCppBase
{
public:
  assignBool();
  assignBool(
    boolVar * boolVarIn,
    boolVal * valueIn);
  ~assignBool();
  void printSelf();
  boolVar * get_boolVar();
  void set_boolVar(boolVar * boolVarIn);
  boolVal * get_value();
  void set_value(boolVal * valueIn);
private:
  boolVar * a_boolVar;
  boolVal * value;
};

/********************************************************************/

/* assignInt

This is a class for the single definition of assignInt.
It represents the following items:

intVar '=' ASSIGN '/' rentVal

*/

class assignInt :
  public dmisCppBase
{
public:
  assignInt();
  assignInt(
    intVar * intVarIn,
    rentVal * valueIn);
  ~assignInt();
  void printSelf();
  intVar * get_intVar();
  void set_intVar(intVar * intVarIn);
  rentVal * get_value();
  void set_value(rentVal * valueIn);
private:
  intVar * a_intVar;
  rentVal * value;
};

/********************************************************************/

/* assignReal

This is a class for the single definition of assignReal.
It represents the following items:

realVar '=' ASSIGN '/' rentVal

*/

class assignReal :
  public dmisCppBase
{
public:
  assignReal();
  assignReal(
    realVar * realVarIn,
    rentVal * valueIn);
  ~assignReal();
  void printSelf();
  realVar * get_realVar();
  void set_realVar(realVar * realVarIn);
  rentVal * get_value();
  void set_value(rentVal * valueIn);
private:
  realVar * a_realVar;
  rentVal * value;
};

/********************************************************************/

/* assignVector

This is a class for the single definition of assignVector.
It represents the following items:

vectorVar '=' ASSIGN '/' vectorVal

*/

class assignVector :
  public dmisCppBase
{
public:
  assignVector();
  assignVector(
    vectorVar * vectorVarIn,
    vectorVal * valueIn);
  ~assignVector();
  void printSelf();
  vectorVar * get_vectorVar();
  void set_vectorVar(vectorVar * vectorVarIn);
  vectorVal * get_value();
  void set_value(vectorVal * valueIn);
private:
  vectorVar * a_vectorVar;
  vectorVal * value;
};

/********************************************************************/

/* boundStm

This is a class for the single definition of boundStm.
It represents the following items:

BOUND '/' boundMinor #

*/

class boundStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  boundStm();
  boundStm(
    boundMinor * boundMinorIn);
  ~boundStm();
  void printSelf();
  boundMinor * get_boundMinor();
  void set_boundMinor(boundMinor * boundMinorIn);
private:
  boundMinor * a_boundMinor;
};

/********************************************************************/

/* boundMinor

This is a parent class.

*/

class boundMinor :
  public dmisCppBase
{
public:
  boundMinor();
  ~boundMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* boundFeat

This is a class for the single definition of boundFeat.
It represents the following items:

fLabel ',' featureList

*/

class boundFeat :
  public boundMinor
{
public:
  boundFeat();
  boundFeat(
    fLabel * fLabelIn,
    std::list<featureLabel *> * featureListIn);
  ~boundFeat();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  std::list<featureLabel *> * get_featureList();
  void set_featureList(std::list<featureLabel *> * featureListIn);
private:
  fLabel * a_fLabel;
  std::list<featureLabel *> * a_featureList;
};

/********************************************************************/

/* boundTol

This is a class for the single definition of boundTol.
It represents the following items:

tLabel ',' featureList

*/

class boundTol :
  public boundMinor
{
public:
  boundTol();
  boundTol(
    tLabel * tLabelIn,
    std::list<featureLabel *> * featureListIn);
  ~boundTol();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  std::list<featureLabel *> * get_featureList();
  void set_featureList(std::list<featureLabel *> * featureListIn);
private:
  tLabel * a_tLabel;
  std::list<featureLabel *> * a_featureList;
};

/********************************************************************/

/* calibSensStm

This is a class for the single definition of calibSensStm.
It represents the following items:

CALIB '/' calibSensMinor #

*/

class calibSensStm :
  public dmisStatement
{
public:
  calibSensStm();
  calibSensStm(
    calibSensMinor * calibSensMinorIn);
  ~calibSensStm();
  void printSelf();
  calibSensMinor * get_calibSensMinor();
  void set_calibSensMinor(calibSensMinor * calibSensMinorIn);
private:
  calibSensMinor * a_calibSensMinor;
};

/********************************************************************/

/* calibRtabStm

This is a class for the single definition of calibRtabStm.
It represents the following items:

CALIB '/' calibRtabMinor #

*/

class calibRtabStm :
  public dmisStatement
{
public:
  calibRtabStm();
  calibRtabStm(
    calibRtabMinor * calibRtabMinorIn);
  ~calibRtabStm();
  void printSelf();
  calibRtabMinor * get_calibRtabMinor();
  void set_calibRtabMinor(calibRtabMinor * calibRtabMinorIn);
private:
  calibRtabMinor * a_calibRtabMinor;
};

/********************************************************************/

/* calibMasterStm

This is a class for the single definition of calibMasterStm.
It represents the following items:

CALIB '/' calibMasterMinor #

*/

class calibMasterStm :
  public dmisStatement
{
public:
  calibMasterStm();
  calibMasterStm(
    calibMasterMinor * calibMasterMinorIn);
  ~calibMasterStm();
  void printSelf();
  calibMasterMinor * get_calibMasterMinor();
  void set_calibMasterMinor(calibMasterMinor * calibMasterMinorIn);
private:
  calibMasterMinor * a_calibMasterMinor;
};

/********************************************************************/

/* calibSensMinor

This is a parent class.

*/

class calibSensMinor :
  public dmisCppBase
{
public:
  calibSensMinor();
  ~calibSensMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* calibSensMinorSpec

This is a derived class for one of the definitions of calibSensMinor.
It represents the following items:

SENS ',' sLabel ',' calibSensSpec

*/

class calibSensMinorSpec :
  public calibSensMinor
{
public:
  calibSensMinorSpec();
  calibSensMinorSpec(
    sLabel * sLabelIn,
    calibSensSpec * calibSensSpecIn);
  ~calibSensMinorSpec();
  void printSelf();
  sLabel * get_sLabel();
  void set_sLabel(sLabel * sLabelIn);
  calibSensSpec * get_calibSensSpec();
  void set_calibSensSpec(calibSensSpec * calibSensSpecIn);
private:
  sLabel * a_sLabel;
  calibSensSpec * a_calibSensSpec;
};

/********************************************************************/

/* calibSensMinorRecalib

This is a derived class for one of the definitions of calibSensMinor.
It represents the following items:

SENS ',' RECALIB

*/

class calibSensMinorRecalib :
  public calibSensMinor
{
public:
  calibSensMinorRecalib();
  ~calibSensMinorRecalib();
  void printSelf();
};

/********************************************************************/

/* calibSensSpec

This is a parent class.

*/

class calibSensSpec :
  public dmisCppBase
{
public:
  calibSensSpec();
  ~calibSensSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* calibSensSpecInt

This is a derived class for one of the definitions of calibSensSpec.
It represents the following items:

featureLabel1 ',' intVal

*/

class calibSensSpecInt :
  public calibSensSpec
{
public:
  calibSensSpecInt();
  calibSensSpecInt(
    featureLabel1 * featureLabel1In,
    intVal * numMeasIn);
  ~calibSensSpecInt();
  void printSelf();
  featureLabel1 * get_featureLabel1();
  void set_featureLabel1(featureLabel1 * featureLabel1In);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
private:
  featureLabel1 * a_featureLabel1;
  intVal * numMeas;
};

/********************************************************************/

/* calibSensSpecString

This is a derived class for one of the definitions of calibSensSpec.
It represents the following items:

featureLabel1 ',' stringVal [',' intVal]

*/

class calibSensSpecString :
  public calibSensSpec
{
public:
  calibSensSpecString();
  calibSensSpecString(
    featureLabel1 * featureLabel1In,
    stringVal * textIn,
    intVal * numMeasIn);
  ~calibSensSpecString();
  void printSelf();
  featureLabel1 * get_featureLabel1();
  void set_featureLabel1(featureLabel1 * featureLabel1In);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
private:
  featureLabel1 * a_featureLabel1;
  stringVal * text;
  intVal * numMeas;
};

/********************************************************************/

/* calibRtabMinor

This is a parent class.

*/

class calibRtabMinor :
  public dmisCppBase
{
public:
  calibRtabMinor();
  ~calibRtabMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* calibRtabMinorSpec

This is a derived class for one of the definitions of calibRtabMinor.
It represents the following items:

RTAB ',' rtLabel ',' calibRtabSpec

*/

class calibRtabMinorSpec :
  public calibRtabMinor
{
public:
  calibRtabMinorSpec();
  calibRtabMinorSpec(
    rtLabel * rtLabelIn,
    calibRtabSpec * calibRtabSpecIn);
  ~calibRtabMinorSpec();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  calibRtabSpec * get_calibRtabSpec();
  void set_calibRtabSpec(calibRtabSpec * calibRtabSpecIn);
private:
  rtLabel * a_rtLabel;
  calibRtabSpec * a_calibRtabSpec;
};

/********************************************************************/

/* calibRtabMinorRecalib

This is a derived class for one of the definitions of calibRtabMinor.
It represents the following items:

RTAB ',' RECALIB

*/

class calibRtabMinorRecalib :
  public calibRtabMinor
{
public:
  calibRtabMinorRecalib();
  ~calibRtabMinorRecalib();
  void printSelf();
};

/********************************************************************/

/* calibRtabSpec

This is a parent class.

*/

class calibRtabSpec :
  public dmisCppBase
{
public:
  calibRtabSpec();
  ~calibRtabSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* calibRtabSpec_fLabel

This is a derived class for one of the definitions of calibRtabSpec.
It represents the following items:

fLabel ',' intVal

*/

class calibRtabSpec_fLabel :
  public calibRtabSpec
{
public:
  calibRtabSpec_fLabel();
  calibRtabSpec_fLabel(
    fLabel * fLabelIn,
    intVal * numMeasIn);
  ~calibRtabSpec_fLabel();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
};

/********************************************************************/

/* calibRtabSpec_faLabel

This is a derived class for one of the definitions of calibRtabSpec.
It represents the following items:

faLabel ',' faLabel

*/

class calibRtabSpec_faLabel :
  public calibRtabSpec
{
public:
  calibRtabSpec_faLabel();
  calibRtabSpec_faLabel(
    faLabel * feat1In,
    faLabel * feat2In);
  ~calibRtabSpec_faLabel();
  void printSelf();
  faLabel * get_feat1();
  void set_feat1(faLabel * feat1In);
  faLabel * get_feat2();
  void set_feat2(faLabel * feat2In);
private:
  faLabel * feat1;
  faLabel * feat2;
};

/********************************************************************/

/* calibMasterMinor

This is a class for the single definition of calibMasterMinor.
It represents the following items:

MASTER ',' stringVal

*/

class calibMasterMinor :
  public dmisCppBase
{
public:
  calibMasterMinor();
  calibMasterMinor(
    stringVal * artNameIn);
  ~calibMasterMinor();
  void printSelf();
  stringVal * get_artName();
  void set_artName(stringVal * artNameIn);
private:
  stringVal * artName;
};

/********************************************************************/

/* callStm

This is a class for the single definition of callStm.
It represents the following items:

CALL '/' callMinor #

*/

class callStm :
  public dmisStatement
{
public:
  callStm();
  callStm(
    callMinor * callMinorIn);
  ~callStm();
  void printSelf();
  callMinor * get_callMinor();
  void set_callMinor(callMinor * callMinorIn);
private:
  callMinor * a_callMinor;
};

/********************************************************************/

/* callMinor

This is a parent class.

*/

class callMinor :
  public dmisCppBase
{
public:
  callMinor();
  ~callMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* callMacro

This is a class for the single definition of callMacro.
It represents the following items:

[EXTERN ',' DMIS ','] mLabel [',' CHARSTRING]

*/

class callMacro :
  public callMinor
{
public:
  callMacro();
  callMacro(
    bool has_EXTERNIn,
    mLabel * mLabelIn,
    char * stringIn);
  ~callMacro();
  void printSelf();
  bool get_has_EXTERN();
  void set_has_EXTERN(bool has_EXTERNIn);
  mLabel * get_mLabel();
  void set_mLabel(mLabel * mLabelIn);
  char * get_string();
  void set_string(char * stringIn);
private:
  bool has_EXTERN;
  mLabel * a_mLabel;
  char * a_string;
};

/********************************************************************/

/* callModule

This is a class for the single definition of callModule.
It represents the following items:

EXTERN ',' DMIS ',' stringVal

*/

class callModule :
  public callMinor
{
public:
  callModule();
  callModule(
    stringVal * modIdIn);
  ~callModule();
  void printSelf();
  stringVal * get_modId();
  void set_modId(stringVal * modIdIn);
private:
  stringVal * modId;
};

/********************************************************************/

/* callRoutine

This is a class for the single definition of callRoutine.
It represents the following items:

EXTERN ',' DME ',' stringVal [',' callType] [',' paramList]

*/

class callRoutine :
  public callMinor
{
public:
  callRoutine();
  callRoutine(
    stringVal * routineIn,
    callType * callTypeIn,
    std::list<param *> * paramListIn);
  ~callRoutine();
  void printSelf();
  stringVal * get_routine();
  void set_routine(stringVal * routineIn);
  callType * get_callType();
  void set_callType(callType * callTypeIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  stringVal * routine;
  callType * a_callType;
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* callProgram

This is a class for the single definition of callProgram.
It represents the following items:

EXTERN ',' SYS ',' stringVal [',' callType] [',' paramList]

*/

class callProgram :
  public callMinor
{
public:
  callProgram();
  callProgram(
    stringVal * pathnameIn,
    callType * callTypeIn,
    std::list<param *> * paramListIn);
  ~callProgram();
  void printSelf();
  stringVal * get_pathname();
  void set_pathname(stringVal * pathnameIn);
  callType * get_callType();
  void set_callType(callType * callTypeIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  stringVal * pathname;
  callType * a_callType;
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* callType

This is a parent class.

*/

class callType :
  public dmisCppBase
{
public:
  callType();
  ~callType();
  void printSelf() = 0;
};

/********************************************************************/

/* callType_WAIT

This is a derived class for one of the definitions of callType.
It represents the following items:

WAIT

*/

class callType_WAIT :
  public callType
{
public:
  callType_WAIT();
  ~callType_WAIT();
  void printSelf();
};

/********************************************************************/

/* callType_CONT

This is a derived class for one of the definitions of callType.
It represents the following items:

CONT

*/

class callType_CONT :
  public callType
{
public:
  callType_CONT();
  ~callType_CONT();
  void printSelf();
};

/********************************************************************/

/* callType_ATTACH

This is a derived class for one of the definitions of callType.
It represents the following items:

ATTACH

*/

class callType_ATTACH :
  public callType
{
public:
  callType_ATTACH();
  ~callType_ATTACH();
  void printSelf();
};

/********************************************************************/

/* caseStm

This is a parent class.

*/

class caseStm :
  public dmisStatement
{
public:
  caseStm();
  ~caseStm();
  void printSelf() = 0;
};

/********************************************************************/

/* caseStmInt

This is a derived class for one of the definitions of caseStm.
It represents the following items:

CASE '/' [sign] intConst #

*/

class caseStmInt :
  public caseStm
{
public:
  caseStmInt();
  caseStmInt(
    sign * signIn,
    intConst * intConstIn);
  ~caseStmInt();
  void printSelf();
  sign * get_sign();
  void set_sign(sign * signIn);
  intConst * get_intConst();
  void set_intConst(intConst * intConstIn);
private:
  sign * a_sign;
  intConst * a_intConst;
};

/********************************************************************/

/* caseStmString

This is a derived class for one of the definitions of caseStm.
It represents the following items:

CASE '/' stringConst #

*/

class caseStmString :
  public caseStm
{
public:
  caseStmString();
  caseStmString(
    stringConst * stringConstIn);
  ~caseStmString();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
private:
  stringConst * a_stringConst;
};

/********************************************************************/

/* sign

This is a parent class.

*/

class sign :
  public dmisCppBase
{
public:
  sign();
  ~sign();
  void printSelf() = 0;
};

/********************************************************************/

/* clmpidStm

This is a class for the single definition of clmpidStm.
It represents the following items:

ciLabel '=' CLMPID '/' stringVal #

*/

class clmpidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  clmpidStm();
  clmpidStm(
    ciLabel * ciLabelIn,
    stringVal * textIn);
  ~clmpidStm();
  void printSelf();
  ciLabel * get_ciLabel();
  void set_ciLabel(ciLabel * ciLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  ciLabel * a_ciLabel;
  stringVal * text;
};

/********************************************************************/

/* clmpsnStm

This is a class for the single definition of clmpsnStm.
It represents the following items:

csLabel '=' CLMPSN '/' stringVal #

*/

class clmpsnStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  clmpsnStm();
  clmpsnStm(
    csLabel * csLabelIn,
    stringVal * textIn);
  ~clmpsnStm();
  void printSelf();
  csLabel * get_csLabel();
  void set_csLabel(csLabel * csLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  csLabel * a_csLabel;
  stringVal * text;
};

/********************************************************************/

/* closeStm

This is a class for the single definition of closeStm.
It represents the following items:

CLOSE '/' closeMinor #

*/

class closeStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  closeStm();
  closeStm(
    closeMinor * closeMinorIn);
  ~closeStm();
  void printSelf();
  closeMinor * get_closeMinor();
  void set_closeMinor(closeMinor * closeMinorIn);
private:
  closeMinor * a_closeMinor;
};

/********************************************************************/

/* closeMinor

This is a parent class.

*/

class closeMinor :
  public dmisCppBase
{
public:
  closeMinor();
  ~closeMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* closePlain

This is a derived class for one of the definitions of closeMinor.
It represents the following items:

didLabel

*/

class closePlain :
  public closeMinor
{
public:
  closePlain();
  closePlain(
    didLabel * didLabelIn);
  ~closePlain();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* closeKeep

This is a derived class for one of the definitions of closeMinor.
It represents the following items:

didLabel ',' KEEP

*/

class closeKeep :
  public closeMinor
{
public:
  closeKeep();
  closeKeep(
    didLabel * didLabelIn);
  ~closeKeep();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* closeDelete

This is a derived class for one of the definitions of closeMinor.
It represents the following items:

didLabel ',' DELETE

*/

class closeDelete :
  public closeMinor
{
public:
  closeDelete();
  closeDelete(
    didLabel * didLabelIn);
  ~closeDelete();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* closeEnd

This is a derived class for one of the definitions of closeMinor.
It represents the following items:

didLabel ',' END

*/

class closeEnd :
  public closeMinor
{
public:
  closeEnd();
  closeEnd(
    didLabel * didLabelIn);
  ~closeEnd();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* cmpntgrpStm

This is a class for the single definition of cmpntgrpStm.
It represents the following items:

sgLabel '=' CMPNTGRP '/' BUILD ',' cmpntgrpSpecList #

*/

class cmpntgrpStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  cmpntgrpStm();
  cmpntgrpStm(
    sgLabel * sgLabelIn,
    std::list<cmpntgrpSpec *> * cmpntgrpSpecListIn);
  ~cmpntgrpStm();
  void printSelf();
  sgLabel * get_sgLabel();
  void set_sgLabel(sgLabel * sgLabelIn);
  std::list<cmpntgrpSpec *> * get_cmpntgrpSpecList();
  void set_cmpntgrpSpecList(std::list<cmpntgrpSpec *> * cmpntgrpSpecListIn);
private:
  sgLabel * a_sgLabel;
  std::list<cmpntgrpSpec *> * a_cmpntgrpSpecList;
};

/********************************************************************/

/* cmpntgrpSpec

This is a parent class.

*/

class cmpntgrpSpec :
  public dmisCppBase
{
public:
  cmpntgrpSpec();
  ~cmpntgrpSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* cnfrmrulStm

This is a class for the single definition of cnfrmrulStm.
It represents the following items:

drLabel '=' CNFRMRUL '/' cnfrmrulMinor #

*/

class cnfrmrulStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  cnfrmrulStm();
  cnfrmrulStm(
    drLabel * drLabelIn,
    cnfrmrulMinor * cnfrmrulMinorIn);
  ~cnfrmrulStm();
  void printSelf();
  drLabel * get_drLabel();
  void set_drLabel(drLabel * drLabelIn);
  cnfrmrulMinor * get_cnfrmrulMinor();
  void set_cnfrmrulMinor(cnfrmrulMinor * cnfrmrulMinorIn);
private:
  drLabel * a_drLabel;
  cnfrmrulMinor * a_cnfrmrulMinor;
};

/********************************************************************/

/* cnfrmrulMinor

This is a parent class.

*/

class cnfrmrulMinor :
  public dmisCppBase
{
public:
  cnfrmrulMinor();
  ~cnfrmrulMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* cnfrmrulCode

This is a derived class for one of the definitions of cnfrmrulMinor.
It represents the following items:

RULE ',' intVal

*/

class cnfrmrulCode :
  public cnfrmrulMinor
{
public:
  cnfrmrulCode();
  cnfrmrulCode(
    intVal * codeIn);
  ~cnfrmrulCode();
  void printSelf();
  intVal * get_code();
  void set_code(intVal * codeIn);
private:
  intVal * code;
};

/********************************************************************/

/* cnfrmrulName

This is a derived class for one of the definitions of cnfrmrulMinor.
It represents the following items:

stringVal [',' paramList]

*/

class cnfrmrulName :
  public cnfrmrulMinor
{
public:
  cnfrmrulName();
  cnfrmrulName(
    stringVal * nameIn,
    std::list<param *> * paramListIn);
  ~cnfrmrulName();
  void printSelf();
  stringVal * get_name();
  void set_name(stringVal * nameIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  stringVal * name;
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* constStm

This is a class for the single definition of constStm.
It represents the following items:

CONST '/' constMinor #

*/

class constStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  constStm();
  constStm(
    constMinor * constMinorIn);
  ~constStm();
  void printSelf();
  constMinor * get_constMinor();
  void set_constMinor(constMinor * constMinorIn);
private:
  constMinor * a_constMinor;
};

/********************************************************************/

/* constMinor

This is a parent class.

*/

class constMinor :
  public dmisCppBase
{
public:
  constMinor();
  ~constMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* constArc

This is a parent class.

*/

class constArc :
  public constMinor
{
public:
  constArc();
  ~constArc();
  void printSelf() = 0;
};

/********************************************************************/

/* constArc_bfConst

This is a derived class for one of the definitions of constArc.
It represents the following items:

ARC ',' fLabel ',' bfConst

*/

class constArc_bfConst :
  public constArc
{
public:
  constArc_bfConst();
  constArc_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constArc_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constArc_projctConst

This is a derived class for one of the definitions of constArc.
It represents the following items:

ARC ',' fLabel ',' projctConst

*/

class constArc_projctConst :
  public constArc
{
public:
  constArc_projctConst();
  constArc_projctConst(
    fLabel * fLabelIn,
    projctConst * projctConstIn);
  ~constArc_projctConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  projctConst * get_projctConst();
  void set_projctConst(projctConst * projctConstIn);
private:
  fLabel * a_fLabel;
  projctConst * a_projctConst;
};

/********************************************************************/

/* constArc_trConst

This is a derived class for one of the definitions of constArc.
It represents the following items:

ARC ',' fLabel ',' trConst

*/

class constArc_trConst :
  public constArc
{
public:
  constArc_trConst();
  constArc_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constArc_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constCircle

This is a parent class.

*/

class constCircle :
  public constMinor
{
public:
  constCircle();
  ~constCircle();
  void printSelf() = 0;
};

/********************************************************************/

/* constCircle_bfConst

This is a derived class for one of the definitions of constCircle.
It represents the following items:

CIRCLE ',' fLabel ',' bfConst

*/

class constCircle_bfConst :
  public constCircle
{
public:
  constCircle_bfConst();
  constCircle_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constCircle_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constCircle_coneConst

This is a derived class for one of the definitions of constCircle.
It represents the following items:

CIRCLE ',' fLabel ',' coneConst

*/

class constCircle_coneConst :
  public constCircle
{
public:
  constCircle_coneConst();
  constCircle_coneConst(
    fLabel * fLabelIn,
    coneConst * coneConstIn);
  ~constCircle_coneConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  coneConst * get_coneConst();
  void set_coneConst(coneConst * coneConstIn);
private:
  fLabel * a_fLabel;
  coneConst * a_coneConst;
};

/********************************************************************/

/* constCircle_intofConst

This is a derived class for one of the definitions of constCircle.
It represents the following items:

CIRCLE ',' fLabel ',' intofConst

*/

class constCircle_intofConst :
  public constCircle
{
public:
  constCircle_intofConst();
  constCircle_intofConst(
    fLabel * fLabelIn,
    intofConst * intofConstIn);
  ~constCircle_intofConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intofConst * get_intofConst();
  void set_intofConst(intofConst * intofConstIn);
private:
  fLabel * a_fLabel;
  intofConst * a_intofConst;
};

/********************************************************************/

/* constCircle_projctConst

This is a derived class for one of the definitions of constCircle.
It represents the following items:

CIRCLE ',' fLabel ',' projctConst

*/

class constCircle_projctConst :
  public constCircle
{
public:
  constCircle_projctConst();
  constCircle_projctConst(
    fLabel * fLabelIn,
    projctConst * projctConstIn);
  ~constCircle_projctConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  projctConst * get_projctConst();
  void set_projctConst(projctConst * projctConstIn);
private:
  fLabel * a_fLabel;
  projctConst * a_projctConst;
};

/********************************************************************/

/* constCircle_tantoConst

This is a derived class for one of the definitions of constCircle.
It represents the following items:

CIRCLE ',' fLabel ',' tantoConst

*/

class constCircle_tantoConst :
  public constCircle
{
public:
  constCircle_tantoConst();
  constCircle_tantoConst(
    fLabel * fLabelIn,
    tantoConst * tantoConstIn);
  ~constCircle_tantoConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  tantoConst * get_tantoConst();
  void set_tantoConst(tantoConst * tantoConstIn);
private:
  fLabel * a_fLabel;
  tantoConst * a_tantoConst;
};

/********************************************************************/

/* constCircle_trConst

This is a derived class for one of the definitions of constCircle.
It represents the following items:

CIRCLE ',' fLabel ',' trConst

*/

class constCircle_trConst :
  public constCircle
{
public:
  constCircle_trConst();
  constCircle_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constCircle_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constCircle_retrieve2

This is a derived class for one of the definitions of constCircle.
It represents the following items:

CIRCLE ',' fLabel ',' retrieve2

*/

class constCircle_retrieve2 :
  public constCircle
{
public:
  constCircle_retrieve2();
  constCircle_retrieve2(
    fLabel * fLabelIn,
    retrieve2 * retrieve2In);
  ~constCircle_retrieve2();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  retrieve2 * get_retrieve2();
  void set_retrieve2(retrieve2 * retrieve2In);
private:
  fLabel * a_fLabel;
  retrieve2 * a_retrieve2;
};

/********************************************************************/

/* constCompound

This is a class for the single definition of constCompound.
It represents the following items:

COMPOUND ',' fLabel ',' BUILD

*/

class constCompound :
  public constMinor
{
public:
  constCompound();
  constCompound(
    fLabel * fLabelIn);
  ~constCompound();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
private:
  fLabel * a_fLabel;
};

/********************************************************************/

/* constCone

This is a parent class.

*/

class constCone :
  public constMinor
{
public:
  constCone();
  ~constCone();
  void printSelf() = 0;
};

/********************************************************************/

/* constCone_bfConst

This is a derived class for one of the definitions of constCone.
It represents the following items:

CONE ',' fLabel ',' bfConst

*/

class constCone_bfConst :
  public constCone
{
public:
  constCone_bfConst();
  constCone_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constCone_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constCone_trConst

This is a derived class for one of the definitions of constCone.
It represents the following items:

CONE ',' fLabel ',' trConst

*/

class constCone_trConst :
  public constCone
{
public:
  constCone_trConst();
  constCone_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constCone_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constCparln

This is a parent class.

*/

class constCparln :
  public constMinor
{
public:
  constCparln();
  ~constCparln();
  void printSelf() = 0;
};

/********************************************************************/

/* constCparln_bfConst

This is a derived class for one of the definitions of constCparln.
It represents the following items:

CPARLN ',' fLabel ',' bfConst

*/

class constCparln_bfConst :
  public constCparln
{
public:
  constCparln_bfConst();
  constCparln_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constCparln_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constCparln_projctConst

This is a derived class for one of the definitions of constCparln.
It represents the following items:

CPARLN ',' fLabel ',' projctConst

*/

class constCparln_projctConst :
  public constCparln
{
public:
  constCparln_projctConst();
  constCparln_projctConst(
    fLabel * fLabelIn,
    projctConst * projctConstIn);
  ~constCparln_projctConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  projctConst * get_projctConst();
  void set_projctConst(projctConst * projctConstIn);
private:
  fLabel * a_fLabel;
  projctConst * a_projctConst;
};

/********************************************************************/

/* constCparln_trConst

This is a derived class for one of the definitions of constCparln.
It represents the following items:

CPARLN ',' fLabel ',' trConst

*/

class constCparln_trConst :
  public constCparln
{
public:
  constCparln_trConst();
  constCparln_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constCparln_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constCparln_retrieve2

This is a derived class for one of the definitions of constCparln.
It represents the following items:

CPARLN ',' fLabel ',' retrieve2

*/

class constCparln_retrieve2 :
  public constCparln
{
public:
  constCparln_retrieve2();
  constCparln_retrieve2(
    fLabel * fLabelIn,
    retrieve2 * retrieve2In);
  ~constCparln_retrieve2();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  retrieve2 * get_retrieve2();
  void set_retrieve2(retrieve2 * retrieve2In);
private:
  fLabel * a_fLabel;
  retrieve2 * a_retrieve2;
};

/********************************************************************/

/* constCylndr

This is a parent class.

*/

class constCylndr :
  public constMinor
{
public:
  constCylndr();
  ~constCylndr();
  void printSelf() = 0;
};

/********************************************************************/

/* constCylndr_bfConst

This is a derived class for one of the definitions of constCylndr.
It represents the following items:

CYLNDR ',' fLabel ',' bfConst

*/

class constCylndr_bfConst :
  public constCylndr
{
public:
  constCylndr_bfConst();
  constCylndr_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constCylndr_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constCylndr_trConst

This is a derived class for one of the definitions of constCylndr.
It represents the following items:

CYLNDR ',' fLabel ',' trConst

*/

class constCylndr_trConst :
  public constCylndr
{
public:
  constCylndr_trConst();
  constCylndr_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constCylndr_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constCylndr_retrieve1

This is a derived class for one of the definitions of constCylndr.
It represents the following items:

CYLNDR ',' fLabel ',' retrieve1

*/

class constCylndr_retrieve1 :
  public constCylndr
{
public:
  constCylndr_retrieve1();
  constCylndr_retrieve1(
    fLabel * fLabelIn,
    retrieve1 * retrieve1In);
  ~constCylndr_retrieve1();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  retrieve1 * get_retrieve1();
  void set_retrieve1(retrieve1 * retrieve1In);
private:
  fLabel * a_fLabel;
  retrieve1 * a_retrieve1;
};

/********************************************************************/

/* constEllips

This is a parent class.

*/

class constEllips :
  public constMinor
{
public:
  constEllips();
  ~constEllips();
  void printSelf() = 0;
};

/********************************************************************/

/* constEllips_bfConst

This is a derived class for one of the definitions of constEllips.
It represents the following items:

ELLIPS ',' fLabel ',' bfConst

*/

class constEllips_bfConst :
  public constEllips
{
public:
  constEllips_bfConst();
  constEllips_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constEllips_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constEllips_intofConst

This is a derived class for one of the definitions of constEllips.
It represents the following items:

ELLIPS ',' fLabel ',' intofConst

*/

class constEllips_intofConst :
  public constEllips
{
public:
  constEllips_intofConst();
  constEllips_intofConst(
    fLabel * fLabelIn,
    intofConst * intofConstIn);
  ~constEllips_intofConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intofConst * get_intofConst();
  void set_intofConst(intofConst * intofConstIn);
private:
  fLabel * a_fLabel;
  intofConst * a_intofConst;
};

/********************************************************************/

/* constEllips_projctConst

This is a derived class for one of the definitions of constEllips.
It represents the following items:

ELLIPS ',' fLabel ',' projctConst

*/

class constEllips_projctConst :
  public constEllips
{
public:
  constEllips_projctConst();
  constEllips_projctConst(
    fLabel * fLabelIn,
    projctConst * projctConstIn);
  ~constEllips_projctConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  projctConst * get_projctConst();
  void set_projctConst(projctConst * projctConstIn);
private:
  fLabel * a_fLabel;
  projctConst * a_projctConst;
};

/********************************************************************/

/* constEllips_trConst

This is a derived class for one of the definitions of constEllips.
It represents the following items:

ELLIPS ',' fLabel ',' trConst

*/

class constEllips_trConst :
  public constEllips
{
public:
  constEllips_trConst();
  constEllips_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constEllips_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constEdgept

This is a class for the single definition of constEdgept.
It represents the following items:

EDGEPT ',' fLabel ',' retrieve4

*/

class constEdgept :
  public constMinor
{
public:
  constEdgept();
  constEdgept(
    fLabel * fLabelIn,
    retrieve4 * retrieve4In);
  ~constEdgept();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  retrieve4 * get_retrieve4();
  void set_retrieve4(retrieve4 * retrieve4In);
private:
  fLabel * a_fLabel;
  retrieve4 * a_retrieve4;
};

/********************************************************************/

/* constGeom

This is a class for the single definition of constGeom.
It represents the following items:

GEOM ',' fLabel ',' nearptConst

*/

class constGeom :
  public constMinor
{
public:
  constGeom();
  constGeom(
    fLabel * fLabelIn,
    nearptConst * nearptConstIn);
  ~constGeom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  nearptConst * get_nearptConst();
  void set_nearptConst(nearptConst * nearptConstIn);
private:
  fLabel * a_fLabel;
  nearptConst * a_nearptConst;
};

/********************************************************************/

/* constGcurve

This is a parent class.

*/

class constGcurve :
  public constMinor
{
public:
  constGcurve();
  ~constGcurve();
  void printSelf() = 0;
};

/********************************************************************/

/* constGcurve_bfConst

This is a derived class for one of the definitions of constGcurve.
It represents the following items:

GCURVE ',' fLabel ',' bfConst

*/

class constGcurve_bfConst :
  public constGcurve
{
public:
  constGcurve_bfConst();
  constGcurve_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constGcurve_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constGcurve_projctConst

This is a derived class for one of the definitions of constGcurve.
It represents the following items:

GCURVE ',' fLabel ',' projctConst

*/

class constGcurve_projctConst :
  public constGcurve
{
public:
  constGcurve_projctConst();
  constGcurve_projctConst(
    fLabel * fLabelIn,
    projctConst * projctConstIn);
  ~constGcurve_projctConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  projctConst * get_projctConst();
  void set_projctConst(projctConst * projctConstIn);
private:
  fLabel * a_fLabel;
  projctConst * a_projctConst;
};

/********************************************************************/

/* constGcurve_trConst

This is a derived class for one of the definitions of constGcurve.
It represents the following items:

GCURVE ',' fLabel ',' trConst

*/

class constGcurve_trConst :
  public constGcurve
{
public:
  constGcurve_trConst();
  constGcurve_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constGcurve_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constGsurf

This is a parent class.

*/

class constGsurf :
  public constMinor
{
public:
  constGsurf();
  ~constGsurf();
  void printSelf() = 0;
};

/********************************************************************/

/* constGsurf_bfConst

This is a derived class for one of the definitions of constGsurf.
It represents the following items:

GSURF ',' fLabel ',' bfConst

*/

class constGsurf_bfConst :
  public constGsurf
{
public:
  constGsurf_bfConst();
  constGsurf_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constGsurf_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constGsurf_trConst

This is a derived class for one of the definitions of constGsurf.
It represents the following items:

GSURF ',' fLabel ',' trConst

*/

class constGsurf_trConst :
  public constGsurf
{
public:
  constGsurf_trConst();
  constGsurf_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constGsurf_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constLine

This is a parent class.

*/

class constLine :
  public constMinor
{
public:
  constLine();
  ~constLine();
  void printSelf() = 0;
};

/********************************************************************/

/* constLine_bfConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' bfConst

*/

class constLine_bfConst :
  public constLine
{
public:
  constLine_bfConst();
  constLine_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constLine_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constLine_intofConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' intofConst

*/

class constLine_intofConst :
  public constLine
{
public:
  constLine_intofConst();
  constLine_intofConst(
    fLabel * fLabelIn,
    intofConst * intofConstIn);
  ~constLine_intofConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intofConst * get_intofConst();
  void set_intofConst(intofConst * intofConstIn);
private:
  fLabel * a_fLabel;
  intofConst * a_intofConst;
};

/********************************************************************/

/* constLine_midliConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' midliConst

*/

class constLine_midliConst :
  public constLine
{
public:
  constLine_midliConst();
  constLine_midliConst(
    fLabel * fLabelIn,
    midliConst * midliConstIn);
  ~constLine_midliConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  midliConst * get_midliConst();
  void set_midliConst(midliConst * midliConstIn);
private:
  fLabel * a_fLabel;
  midliConst * a_midliConst;
};

/********************************************************************/

/* constLine_offsetConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' offsetConst

*/

class constLine_offsetConst :
  public constLine
{
public:
  constLine_offsetConst();
  constLine_offsetConst(
    fLabel * fLabelIn,
    offsetConst * offsetConstIn);
  ~constLine_offsetConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  offsetConst * get_offsetConst();
  void set_offsetConst(offsetConst * offsetConstIn);
private:
  fLabel * a_fLabel;
  offsetConst * a_offsetConst;
};

/********************************************************************/

/* constLine_partoConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' partoConst

*/

class constLine_partoConst :
  public constLine
{
public:
  constLine_partoConst();
  constLine_partoConst(
    fLabel * fLabelIn,
    partoConst * partoConstIn);
  ~constLine_partoConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  partoConst * get_partoConst();
  void set_partoConst(partoConst * partoConstIn);
private:
  fLabel * a_fLabel;
  partoConst * a_partoConst;
};

/********************************************************************/

/* constLine_perptoConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' perptoConst

*/

class constLine_perptoConst :
  public constLine
{
public:
  constLine_perptoConst();
  constLine_perptoConst(
    fLabel * fLabelIn,
    perptoConst * perptoConstIn);
  ~constLine_perptoConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  perptoConst * get_perptoConst();
  void set_perptoConst(perptoConst * perptoConstIn);
private:
  fLabel * a_fLabel;
  perptoConst * a_perptoConst;
};

/********************************************************************/

/* constLine_projliConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' projliConst

*/

class constLine_projliConst :
  public constLine
{
public:
  constLine_projliConst();
  constLine_projliConst(
    fLabel * fLabelIn,
    projliConst * projliConstIn);
  ~constLine_projliConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  projliConst * get_projliConst();
  void set_projliConst(projliConst * projliConstIn);
private:
  fLabel * a_fLabel;
  projliConst * a_projliConst;
};

/********************************************************************/

/* constLine_tantoConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' tantoConst

*/

class constLine_tantoConst :
  public constLine
{
public:
  constLine_tantoConst();
  constLine_tantoConst(
    fLabel * fLabelIn,
    tantoConst * tantoConstIn);
  ~constLine_tantoConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  tantoConst * get_tantoConst();
  void set_tantoConst(tantoConst * tantoConstIn);
private:
  fLabel * a_fLabel;
  tantoConst * a_tantoConst;
};

/********************************************************************/

/* constLine_trConst

This is a derived class for one of the definitions of constLine.
It represents the following items:

LINE ',' fLabel ',' trConst

*/

class constLine_trConst :
  public constLine
{
public:
  constLine_trConst();
  constLine_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constLine_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constParpln

This is a class for the single definition of constParpln.
It represents the following items:

PARPLN ',' fLabel ',' bfConst

*/

class constParpln :
  public constMinor
{
public:
  constParpln();
  constParpln(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constParpln();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constPatern

This is a parent class.

*/

class constPatern :
  public constMinor
{
public:
  constPatern();
  ~constPatern();
  void printSelf() = 0;
};

/********************************************************************/

/* constPatern_trConst

This is a derived class for one of the definitions of constPatern.
It represents the following items:

PATERN ',' fLabel ',' trConst

*/

class constPatern_trConst :
  public constPatern
{
public:
  constPatern_trConst();
  constPatern_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constPatern_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constPatern_BUILD

This is a derived class for one of the definitions of constPatern.
It represents the following items:

PATERN ',' fLabel ',' BUILD

*/

class constPatern_BUILD :
  public constPatern
{
public:
  constPatern_BUILD();
  constPatern_BUILD(
    fLabel * fLabelIn);
  ~constPatern_BUILD();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
private:
  fLabel * a_fLabel;
};

/********************************************************************/

/* constPlane

This is a parent class.

*/

class constPlane :
  public constMinor
{
public:
  constPlane();
  ~constPlane();
  void printSelf() = 0;
};

/********************************************************************/

/* constPlane_bfConst

This is a derived class for one of the definitions of constPlane.
It represents the following items:

PLANE ',' fLabel ',' bfConst

*/

class constPlane_bfConst :
  public constPlane
{
public:
  constPlane_bfConst();
  constPlane_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constPlane_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constPlane_midplConst

This is a derived class for one of the definitions of constPlane.
It represents the following items:

PLANE ',' fLabel ',' midplConst

*/

class constPlane_midplConst :
  public constPlane
{
public:
  constPlane_midplConst();
  constPlane_midplConst(
    fLabel * fLabelIn,
    midplConst * midplConstIn);
  ~constPlane_midplConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  midplConst * get_midplConst();
  void set_midplConst(midplConst * midplConstIn);
private:
  fLabel * a_fLabel;
  midplConst * a_midplConst;
};

/********************************************************************/

/* constPlane_offsetConst

This is a derived class for one of the definitions of constPlane.
It represents the following items:

PLANE ',' fLabel ',' offsetConst

*/

class constPlane_offsetConst :
  public constPlane
{
public:
  constPlane_offsetConst();
  constPlane_offsetConst(
    fLabel * fLabelIn,
    offsetConst * offsetConstIn);
  ~constPlane_offsetConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  offsetConst * get_offsetConst();
  void set_offsetConst(offsetConst * offsetConstIn);
private:
  fLabel * a_fLabel;
  offsetConst * a_offsetConst;
};

/********************************************************************/

/* constPlane_partoConst

This is a derived class for one of the definitions of constPlane.
It represents the following items:

PLANE ',' fLabel ',' partoConst

*/

class constPlane_partoConst :
  public constPlane
{
public:
  constPlane_partoConst();
  constPlane_partoConst(
    fLabel * fLabelIn,
    partoConst * partoConstIn);
  ~constPlane_partoConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  partoConst * get_partoConst();
  void set_partoConst(partoConst * partoConstIn);
private:
  fLabel * a_fLabel;
  partoConst * a_partoConst;
};

/********************************************************************/

/* constPlane_perptoConst

This is a derived class for one of the definitions of constPlane.
It represents the following items:

PLANE ',' fLabel ',' perptoConst

*/

class constPlane_perptoConst :
  public constPlane
{
public:
  constPlane_perptoConst();
  constPlane_perptoConst(
    fLabel * fLabelIn,
    perptoConst * perptoConstIn);
  ~constPlane_perptoConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  perptoConst * get_perptoConst();
  void set_perptoConst(perptoConst * perptoConstIn);
private:
  fLabel * a_fLabel;
  perptoConst * a_perptoConst;
};

/********************************************************************/

/* constPlane_tantoConstPlane

This is a derived class for one of the definitions of constPlane.
It represents the following items:

PLANE ',' fLabel ',' tantoConstPlane

*/

class constPlane_tantoConstPlane :
  public constPlane
{
public:
  constPlane_tantoConstPlane();
  constPlane_tantoConstPlane(
    fLabel * fLabelIn,
    tantoConstPlane * tantoConstPlaneIn);
  ~constPlane_tantoConstPlane();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  tantoConstPlane * get_tantoConstPlane();
  void set_tantoConstPlane(tantoConstPlane * tantoConstPlaneIn);
private:
  fLabel * a_fLabel;
  tantoConstPlane * a_tantoConstPlane;
};

/********************************************************************/

/* constPlane_trConst

This is a derived class for one of the definitions of constPlane.
It represents the following items:

PLANE ',' fLabel ',' trConst

*/

class constPlane_trConst :
  public constPlane
{
public:
  constPlane_trConst();
  constPlane_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constPlane_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constPoint

This is a parent class.

*/

class constPoint :
  public constMinor
{
public:
  constPoint();
  ~constPoint();
  void printSelf() = 0;
};

/********************************************************************/

/* constPoint_cogConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' cogConst

*/

class constPoint_cogConst :
  public constPoint
{
public:
  constPoint_cogConst();
  constPoint_cogConst(
    fLabel * fLabelIn,
    cogConst * cogConstIn);
  ~constPoint_cogConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  cogConst * get_cogConst();
  void set_cogConst(cogConst * cogConstIn);
private:
  fLabel * a_fLabel;
  cogConst * a_cogConst;
};

/********************************************************************/

/* constPoint_curveConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' curveConst

*/

class constPoint_curveConst :
  public constPoint
{
public:
  constPoint_curveConst();
  constPoint_curveConst(
    fLabel * fLabelIn,
    curveConst * curveConstIn);
  ~constPoint_curveConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  curveConst * get_curveConst();
  void set_curveConst(curveConst * curveConstIn);
private:
  fLabel * a_fLabel;
  curveConst * a_curveConst;
};

/********************************************************************/

/* constPoint_extremConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' extremConst

*/

class constPoint_extremConst :
  public constPoint
{
public:
  constPoint_extremConst();
  constPoint_extremConst(
    fLabel * fLabelIn,
    extremConst * extremConstIn);
  ~constPoint_extremConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  extremConst * get_extremConst();
  void set_extremConst(extremConst * extremConstIn);
private:
  fLabel * a_fLabel;
  extremConst * a_extremConst;
};

/********************************************************************/

/* constPoint_intofConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' intofConst

*/

class constPoint_intofConst :
  public constPoint
{
public:
  constPoint_intofConst();
  constPoint_intofConst(
    fLabel * fLabelIn,
    intofConst * intofConstIn);
  ~constPoint_intofConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intofConst * get_intofConst();
  void set_intofConst(intofConst * intofConstIn);
private:
  fLabel * a_fLabel;
  intofConst * a_intofConst;
};

/********************************************************************/

/* constPoint_midptConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' midptConst

*/

class constPoint_midptConst :
  public constPoint
{
public:
  constPoint_midptConst();
  constPoint_midptConst(
    fLabel * fLabelIn,
    midptConst * midptConstIn);
  ~constPoint_midptConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  midptConst * get_midptConst();
  void set_midptConst(midptConst * midptConstIn);
private:
  fLabel * a_fLabel;
  midptConst * a_midptConst;
};

/********************************************************************/

/* constPoint_moveptConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' moveptConst

*/

class constPoint_moveptConst :
  public constPoint
{
public:
  constPoint_moveptConst();
  constPoint_moveptConst(
    fLabel * fLabelIn,
    moveptConst * moveptConstIn);
  ~constPoint_moveptConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  moveptConst * get_moveptConst();
  void set_moveptConst(moveptConst * moveptConstIn);
private:
  fLabel * a_fLabel;
  moveptConst * a_moveptConst;
};

/********************************************************************/

/* constPoint_pierceConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' pierceConst

*/

class constPoint_pierceConst :
  public constPoint
{
public:
  constPoint_pierceConst();
  constPoint_pierceConst(
    fLabel * fLabelIn,
    pierceConst * pierceConstIn);
  ~constPoint_pierceConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  pierceConst * get_pierceConst();
  void set_pierceConst(pierceConst * pierceConstIn);
private:
  fLabel * a_fLabel;
  pierceConst * a_pierceConst;
};

/********************************************************************/

/* constPoint_projptConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' projptConst

*/

class constPoint_projptConst :
  public constPoint
{
public:
  constPoint_projptConst();
  constPoint_projptConst(
    fLabel * fLabelIn,
    projptConst * projptConstIn);
  ~constPoint_projptConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  projptConst * get_projptConst();
  void set_projptConst(projptConst * projptConstIn);
private:
  fLabel * a_fLabel;
  projptConst * a_projptConst;
};

/********************************************************************/

/* constPoint_trConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' trConst

*/

class constPoint_trConst :
  public constPoint
{
public:
  constPoint_trConst();
  constPoint_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constPoint_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constPoint_vertexConst

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' vertexConst

*/

class constPoint_vertexConst :
  public constPoint
{
public:
  constPoint_vertexConst();
  constPoint_vertexConst(
    fLabel * fLabelIn,
    vertexConst * vertexConstIn);
  ~constPoint_vertexConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  vertexConst * get_vertexConst();
  void set_vertexConst(vertexConst * vertexConstIn);
private:
  fLabel * a_fLabel;
  vertexConst * a_vertexConst;
};

/********************************************************************/

/* constPoint_retrieve1

This is a derived class for one of the definitions of constPoint.
It represents the following items:

POINT ',' fLabel ',' retrieve1

*/

class constPoint_retrieve1 :
  public constPoint
{
public:
  constPoint_retrieve1();
  constPoint_retrieve1(
    fLabel * fLabelIn,
    retrieve1 * retrieve1In);
  ~constPoint_retrieve1();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  retrieve1 * get_retrieve1();
  void set_retrieve1(retrieve1 * retrieve1In);
private:
  fLabel * a_fLabel;
  retrieve1 * a_retrieve1;
};

/********************************************************************/

/* retrieve1

This is a class for the single definition of retrieve1.
It represents the following items:

RETRIEVE ',' rentVal ',' featureActualList

*/

class retrieve1 :
  public dmisCppBase
{
public:
  retrieve1();
  retrieve1(
    rentVal * searchRadIn,
    std::list<faLabel *> * featureActualListIn);
  ~retrieve1();
  void printSelf();
  rentVal * get_searchRad();
  void set_searchRad(rentVal * searchRadIn);
  std::list<faLabel *> * get_featureActualList();
  void set_featureActualList(std::list<faLabel *> * featureActualListIn);
private:
  rentVal * searchRad;
  std::list<faLabel *> * a_featureActualList;
};

/********************************************************************/

/* retrieve2

This is a class for the single definition of retrieve2.
It represents the following items:

RETRIEVE ',' rentVal ',' rentVal ',' featureActualList

*/

class retrieve2 :
  public dmisCppBase
{
public:
  retrieve2();
  retrieve2(
    rentVal * searchRadIn,
    rentVal * depthIn,
    std::list<faLabel *> * featureActualListIn);
  ~retrieve2();
  void printSelf();
  rentVal * get_searchRad();
  void set_searchRad(rentVal * searchRadIn);
  rentVal * get_depth();
  void set_depth(rentVal * depthIn);
  std::list<faLabel *> * get_featureActualList();
  void set_featureActualList(std::list<faLabel *> * featureActualListIn);
private:
  rentVal * searchRad;
  rentVal * depth;
  std::list<faLabel *> * a_featureActualList;
};

/********************************************************************/

/* retrieve4

This is a class for the single definition of retrieve4.
It represents the following items:

RETRIEVE ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' featureActualList

*/

class retrieve4 :
  public dmisCppBase
{
public:
  retrieve4();
  retrieve4(
    rentVal * distIn,
    rentVal * patchRadIn,
    rentVal * depthIn,
    rentVal * searchRadIn,
    std::list<faLabel *> * featureActualListIn);
  ~retrieve4();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
  rentVal * get_patchRad();
  void set_patchRad(rentVal * patchRadIn);
  rentVal * get_depth();
  void set_depth(rentVal * depthIn);
  rentVal * get_searchRad();
  void set_searchRad(rentVal * searchRadIn);
  std::list<faLabel *> * get_featureActualList();
  void set_featureActualList(std::list<faLabel *> * featureActualListIn);
private:
  rentVal * dist;
  rentVal * patchRad;
  rentVal * depth;
  rentVal * searchRad;
  std::list<faLabel *> * a_featureActualList;
};

/********************************************************************/

/* retrieve2b

This is a class for the single definition of retrieve2b.
It represents the following items:

RETRIEVE ',' rentVal [',' vector] ',' featureActualList

*/

class retrieve2b :
  public dmisCppBase
{
public:
  retrieve2b();
  retrieve2b(
    rentVal * searchRadIn,
    vector * axisIn,
    std::list<faLabel *> * featureActualListIn);
  ~retrieve2b();
  void printSelf();
  rentVal * get_searchRad();
  void set_searchRad(rentVal * searchRadIn);
  vector * get_axis();
  void set_axis(vector * axisIn);
  std::list<faLabel *> * get_featureActualList();
  void set_featureActualList(std::list<faLabel *> * featureActualListIn);
private:
  rentVal * searchRad;
  vector * axis;
  std::list<faLabel *> * a_featureActualList;
};

/********************************************************************/

/* constRctngl

This is a parent class.

*/

class constRctngl :
  public constMinor
{
public:
  constRctngl();
  ~constRctngl();
  void printSelf() = 0;
};

/********************************************************************/

/* constRctngl_bfConst

This is a derived class for one of the definitions of constRctngl.
It represents the following items:

RCTNGL ',' fLabel ',' bfConst

*/

class constRctngl_bfConst :
  public constRctngl
{
public:
  constRctngl_bfConst();
  constRctngl_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constRctngl_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constRctngl_trConst

This is a derived class for one of the definitions of constRctngl.
It represents the following items:

RCTNGL ',' fLabel ',' trConst

*/

class constRctngl_trConst :
  public constRctngl
{
public:
  constRctngl_trConst();
  constRctngl_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constRctngl_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constSgage

This is a class for the single definition of constSgage.
It represents the following items:

SGAGE ',' seLabel ',' sgageConst

*/

class constSgage :
  public constMinor
{
public:
  constSgage();
  constSgage(
    seLabel * seLabelIn,
    sgageConst * sgageConstIn);
  ~constSgage();
  void printSelf();
  seLabel * get_seLabel();
  void set_seLabel(seLabel * seLabelIn);
  sgageConst * get_sgageConst();
  void set_sgageConst(sgageConst * sgageConstIn);
private:
  seLabel * a_seLabel;
  sgageConst * a_sgageConst;
};

/********************************************************************/

/* constSpart

This is a class for the single definition of constSpart.
It represents the following items:

SPART ',' stLabel ',' spartConst

*/

class constSpart :
  public constMinor
{
public:
  constSpart();
  constSpart(
    stLabel * stLabelIn,
    spartConst * spartConstIn);
  ~constSpart();
  void printSelf();
  stLabel * get_stLabel();
  void set_stLabel(stLabel * stLabelIn);
  spartConst * get_spartConst();
  void set_spartConst(spartConst * spartConstIn);
private:
  stLabel * a_stLabel;
  spartConst * a_spartConst;
};

/********************************************************************/

/* constSphere

This is a parent class.

*/

class constSphere :
  public constMinor
{
public:
  constSphere();
  ~constSphere();
  void printSelf() = 0;
};

/********************************************************************/

/* constSphere_bfConst

This is a derived class for one of the definitions of constSphere.
It represents the following items:

SPHERE ',' fLabel ',' bfConst

*/

class constSphere_bfConst :
  public constSphere
{
public:
  constSphere_bfConst();
  constSphere_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constSphere_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constSphere_trConst

This is a derived class for one of the definitions of constSphere.
It represents the following items:

SPHERE ',' fLabel ',' trConst

*/

class constSphere_trConst :
  public constSphere
{
public:
  constSphere_trConst();
  constSphere_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constSphere_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* constSphere_retrieve2b

This is a derived class for one of the definitions of constSphere.
It represents the following items:

SPHERE ',' fLabel ',' retrieve2b

*/

class constSphere_retrieve2b :
  public constSphere
{
public:
  constSphere_retrieve2b();
  constSphere_retrieve2b(
    fLabel * fLabelIn,
    retrieve2b * retrieve2bIn);
  ~constSphere_retrieve2b();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  retrieve2b * get_retrieve2b();
  void set_retrieve2b(retrieve2b * retrieve2bIn);
private:
  fLabel * a_fLabel;
  retrieve2b * a_retrieve2b;
};

/********************************************************************/

/* constSympln

This is a class for the single definition of constSympln.
It represents the following items:

SYMPLN ',' fLabel ',' bfConst

*/

class constSympln :
  public constMinor
{
public:
  constSympln();
  constSympln(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constSympln();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constTorus

This is a parent class.

*/

class constTorus :
  public constMinor
{
public:
  constTorus();
  ~constTorus();
  void printSelf() = 0;
};

/********************************************************************/

/* constTorus_bfConst

This is a derived class for one of the definitions of constTorus.
It represents the following items:

TORUS ',' fLabel ',' bfConst

*/

class constTorus_bfConst :
  public constTorus
{
public:
  constTorus_bfConst();
  constTorus_bfConst(
    fLabel * fLabelIn,
    bfConst * bfConstIn);
  ~constTorus_bfConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  bfConst * get_bfConst();
  void set_bfConst(bfConst * bfConstIn);
private:
  fLabel * a_fLabel;
  bfConst * a_bfConst;
};

/********************************************************************/

/* constTorus_trConst

This is a derived class for one of the definitions of constTorus.
It represents the following items:

TORUS ',' fLabel ',' trConst

*/

class constTorus_trConst :
  public constTorus
{
public:
  constTorus_trConst();
  constTorus_trConst(
    fLabel * fLabelIn,
    trConst * trConstIn);
  ~constTorus_trConst();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  trConst * get_trConst();
  void set_trConst(trConst * trConstIn);
private:
  fLabel * a_fLabel;
  trConst * a_trConst;
};

/********************************************************************/

/* bfConst

This is a parent class.

*/

class bfConst :
  public dmisCppBase
{
public:
  bfConst();
  ~bfConst();
  void printSelf() = 0;
};

/********************************************************************/

/* bfConst_featureList

This is a derived class for one of the definitions of bfConst.
It represents the following items:

BF ',' featureList

*/

class bfConst_featureList :
  public bfConst
{
public:
  bfConst_featureList();
  bfConst_featureList(
    std::list<featureLabel *> * featureListIn);
  ~bfConst_featureList();
  void printSelf();
  std::list<featureLabel *> * get_featureList();
  void set_featureList(std::list<featureLabel *> * featureListIn);
private:
  std::list<featureLabel *> * a_featureList;
};

/********************************************************************/

/* bfConst_indexedFeatureList

This is a derived class for one of the definitions of bfConst.
It represents the following items:

BF ',' indexedFeatureList

*/

class bfConst_indexedFeatureList :
  public bfConst
{
public:
  bfConst_indexedFeatureList();
  bfConst_indexedFeatureList(
    std::list<indexedFeature *> * indexedFeatureListIn);
  ~bfConst_indexedFeatureList();
  void printSelf();
  std::list<indexedFeature *> * get_indexedFeatureList();
  void set_indexedFeatureList(std::list<indexedFeature *> * indexedFeatureListIn);
private:
  std::list<indexedFeature *> * a_indexedFeatureList;
};

/********************************************************************/

/* cogConst

This is a class for the single definition of cogConst.
It represents the following items:

COG ',' featureList

*/

class cogConst :
  public dmisCppBase
{
public:
  cogConst();
  cogConst(
    std::list<featureLabel *> * featureListIn);
  ~cogConst();
  void printSelf();
  std::list<featureLabel *> * get_featureList();
  void set_featureList(std::list<featureLabel *> * featureListIn);
private:
  std::list<featureLabel *> * a_featureList;
};

/********************************************************************/

/* coneConst

This is a parent class.

*/

class coneConst :
  public dmisCppBase
{
public:
  coneConst();
  ~coneConst();
  void printSelf() = 0;
};

/********************************************************************/

/* coneConst_DIAM

This is a derived class for one of the definitions of coneConst.
It represents the following items:

CONE ',' DIAM ',' rentVal ',' faLabel

*/

class coneConst_DIAM :
  public coneConst
{
public:
  coneConst_DIAM();
  coneConst_DIAM(
    rentVal * diamIn,
    faLabel * faLabelIn);
  ~coneConst_DIAM();
  void printSelf();
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  rentVal * diam;
  faLabel * a_faLabel;
};

/********************************************************************/

/* coneConst_DIST

This is a derived class for one of the definitions of coneConst.
It represents the following items:

CONE ',' DIST ',' rentVal ',' faLabel

*/

class coneConst_DIST :
  public coneConst
{
public:
  coneConst_DIST();
  coneConst_DIST(
    rentVal * distIn,
    faLabel * faLabelIn);
  ~coneConst_DIST();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  rentVal * dist;
  faLabel * a_faLabel;
};

/********************************************************************/

/* curveConst

This is a class for the single definition of curveConst.
It represents the following items:

CURVE ',' faLabel ',' featureLabel

*/

class curveConst :
  public dmisCppBase
{
public:
  curveConst();
  curveConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~curveConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* extremConst

This is a parent class.

*/

class extremConst :
  public dmisCppBase
{
public:
  extremConst();
  ~extremConst();
  void printSelf() = 0;
};

/********************************************************************/

/* extremConst_MIN

This is a derived class for one of the definitions of extremConst.
It represents the following items:

EXTREM ',' MIN ',' faLabel ',' extremConstDir

*/

class extremConst_MIN :
  public extremConst
{
public:
  extremConst_MIN();
  extremConst_MIN(
    faLabel * faLabelIn,
    extremConstDir * extremConstDirIn);
  ~extremConst_MIN();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  extremConstDir * get_extremConstDir();
  void set_extremConstDir(extremConstDir * extremConstDirIn);
private:
  faLabel * a_faLabel;
  extremConstDir * a_extremConstDir;
};

/********************************************************************/

/* extremConst_MAX

This is a derived class for one of the definitions of extremConst.
It represents the following items:

EXTREM ',' MAX ',' faLabel ',' extremConstDir

*/

class extremConst_MAX :
  public extremConst
{
public:
  extremConst_MAX();
  extremConst_MAX(
    faLabel * faLabelIn,
    extremConstDir * extremConstDirIn);
  ~extremConst_MAX();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  extremConstDir * get_extremConstDir();
  void set_extremConstDir(extremConstDir * extremConstDirIn);
private:
  faLabel * a_faLabel;
  extremConstDir * a_extremConstDir;
};

/********************************************************************/

/* extremConstDir

This is a parent class.

*/

class extremConstDir :
  public dmisCppBase
{
public:
  extremConstDir();
  ~extremConstDir();
  void printSelf() = 0;
};

/********************************************************************/

/* extremConstAxial

This is a parent class.

*/

class extremConstAxial :
  public extremConstDir
{
public:
  extremConstAxial();
  ~extremConstAxial();
  void printSelf() = 0;
};

/********************************************************************/

/* extremConstVectorial

This is a class for the single definition of extremConstVectorial.
It represents the following items:

VEC ',' vector

*/

class extremConstVectorial :
  public extremConstDir
{
public:
  extremConstVectorial();
  extremConstVectorial(
    vector * dirIn);
  ~extremConstVectorial();
  void printSelf();
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  vector * dir;
};

/********************************************************************/

/* extremConstFeature

This is a parent class.

*/

class extremConstFeature :
  public extremConstDir
{
public:
  extremConstFeature();
  ~extremConstFeature();
  void printSelf() = 0;
};

/********************************************************************/

/* extremConstRadial

This is a class for the single definition of extremConstRadial.
It represents the following items:

RADIAL

*/

class extremConstRadial :
  public extremConstDir
{
public:
  extremConstRadial();
  ~extremConstRadial();
  void printSelf();
};

/********************************************************************/

/* intofConst

This is a class for the single definition of intofConst.
It represents the following items:

INTOF ',' faLabel ',' featureLabel

*/

class intofConst :
  public dmisCppBase
{
public:
  intofConst();
  intofConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~intofConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* midliConst

This is a class for the single definition of midliConst.
It represents the following items:

MIDLI ',' faLabel ',' featureLabel

*/

class midliConst :
  public dmisCppBase
{
public:
  midliConst();
  midliConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~midliConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* midplConst

This is a class for the single definition of midplConst.
It represents the following items:

MIDPL ',' faLabel ',' featureLabel

*/

class midplConst :
  public dmisCppBase
{
public:
  midplConst();
  midplConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~midplConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* midptConst

This is a class for the single definition of midptConst.
It represents the following items:

MIDPT ',' faLabel ',' featureLabel

*/

class midptConst :
  public dmisCppBase
{
public:
  midptConst();
  midptConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~midptConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* moveptConst

This is a parent class.

*/

class moveptConst :
  public dmisCppBase
{
public:
  moveptConst();
  ~moveptConst();
  void printSelf() = 0;
};

/********************************************************************/

/* moveptConstVec

This is a derived class for one of the definitions of moveptConst.
It represents the following items:

MOVEPT ',' faLabel ',' vector

*/

class moveptConstVec :
  public moveptConst
{
public:
  moveptConstVec();
  moveptConstVec(
    faLabel * faLabelIn,
    vector * offsetIn);
  ~moveptConstVec();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  vector * get_offset();
  void set_offset(vector * offsetIn);
private:
  faLabel * a_faLabel;
  vector * offset;
};

/********************************************************************/

/* moveptConstAxis

This is a derived class for one of the definitions of moveptConst.
It represents the following items:

MOVEPT ',' faLabel ',' featureLabel ',' rentVal

*/

class moveptConstAxis :
  public moveptConst
{
public:
  moveptConstAxis();
  moveptConstAxis(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn,
    rentVal * distIn);
  ~moveptConstAxis();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
  rentVal * dist;
};

/********************************************************************/

/* nearptConst

This is a class for the single definition of nearptConst.
It represents the following items:

NEARPT ',' faLabel

*/

class nearptConst :
  public dmisCppBase
{
public:
  nearptConst();
  nearptConst(
    faLabel * faLabelIn);
  ~nearptConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  faLabel * a_faLabel;
};

/********************************************************************/

/* offsetConst

This is a class for the single definition of offsetConst.
It represents the following items:

OFFSET ',' featureList

*/

class offsetConst :
  public dmisCppBase
{
public:
  offsetConst();
  offsetConst(
    std::list<featureLabel *> * featureListIn);
  ~offsetConst();
  void printSelf();
  std::list<featureLabel *> * get_featureList();
  void set_featureList(std::list<featureLabel *> * featureListIn);
private:
  std::list<featureLabel *> * a_featureList;
};

/********************************************************************/

/* partoConst

This is a parent class.

*/

class partoConst :
  public dmisCppBase
{
public:
  partoConst();
  ~partoConst();
  void printSelf() = 0;
};

/********************************************************************/

/* partoConstAct

This is a derived class for one of the definitions of partoConst.
It represents the following items:

PARTO ',' faLabel ',' THRU ',' featureLabel

*/

class partoConstAct :
  public partoConst
{
public:
  partoConstAct();
  partoConstAct(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~partoConstAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* partoConstNom

This is a derived class for one of the definitions of partoConst.
It represents the following items:

PARTO ',' fLabel ',' THRU ',' faLabel

*/

class partoConstNom :
  public partoConst
{
public:
  partoConstNom();
  partoConstNom(
    fLabel * fLabelIn,
    faLabel * faLabelIn);
  ~partoConstNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  fLabel * a_fLabel;
  faLabel * a_faLabel;
};

/********************************************************************/

/* perptoConst

This is a parent class.

*/

class perptoConst :
  public dmisCppBase
{
public:
  perptoConst();
  ~perptoConst();
  void printSelf() = 0;
};

/********************************************************************/

/* perptoConstAct

This is a derived class for one of the definitions of perptoConst.
It represents the following items:

PERPTO ',' faLabel ',' THRU ',' featureLabel

*/

class perptoConstAct :
  public perptoConst
{
public:
  perptoConstAct();
  perptoConstAct(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~perptoConstAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* perptoConstNom

This is a derived class for one of the definitions of perptoConst.
It represents the following items:

PERPTO ',' fLabel ',' THRU ',' faLabel

*/

class perptoConstNom :
  public perptoConst
{
public:
  perptoConstNom();
  perptoConstNom(
    fLabel * fLabelIn,
    faLabel * faLabelIn);
  ~perptoConstNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  fLabel * a_fLabel;
  faLabel * a_faLabel;
};

/********************************************************************/

/* pierceConst

This is a class for the single definition of pierceConst.
It represents the following items:

PIERCE ',' faLabel ',' featureLabel

*/

class pierceConst :
  public dmisCppBase
{
public:
  pierceConst();
  pierceConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~pierceConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* projctConst

This is a class for the single definition of projctConst.
It represents the following items:

PROJCT ',' faLabel [',' featureLabel]

*/

class projctConst :
  public dmisCppBase
{
public:
  projctConst();
  projctConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~projctConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* projliConst

This is a class for the single definition of projliConst.
It represents the following items:

PROJLI ',' faLabel [',' featureLabel]

*/

class projliConst :
  public dmisCppBase
{
public:
  projliConst();
  projliConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~projliConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* projptConst

This is a class for the single definition of projptConst.
It represents the following items:

PROJPT ',' faLabel [',' featureLabel]

*/

class projptConst :
  public dmisCppBase
{
public:
  projptConst();
  projptConst(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~projptConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* sgageConst

This is a class for the single definition of sgageConst.
It represents the following items:

featureNominalList

*/

class sgageConst :
  public dmisCppBase
{
public:
  sgageConst();
  sgageConst(
    std::list<fLabel *> * featureNominalListIn);
  ~sgageConst();
  void printSelf();
  std::list<fLabel *> * get_featureNominalList();
  void set_featureNominalList(std::list<fLabel *> * featureNominalListIn);
private:
  std::list<fLabel *> * a_featureNominalList;
};

/********************************************************************/

/* spartConst

This is a class for the single definition of spartConst.
It represents the following items:

featureActualList

*/

class spartConst :
  public dmisCppBase
{
public:
  spartConst();
  spartConst(
    std::list<faLabel *> * featureActualListIn);
  ~spartConst();
  void printSelf();
  std::list<faLabel *> * get_featureActualList();
  void set_featureActualList(std::list<faLabel *> * featureActualListIn);
private:
  std::list<faLabel *> * a_featureActualList;
};

/********************************************************************/

/* tantoConst

This is a parent class.

*/

class tantoConst :
  public dmisCppBase
{
public:
  tantoConst();
  ~tantoConst();
  void printSelf() = 0;
};

/********************************************************************/

/* tantoConstFa

This is a derived class for one of the definitions of tantoConst.
It represents the following items:

TANTO ',' faLabel [',' THRU] ',' featureLabel

*/

class tantoConstFa :
  public tantoConst
{
public:
  tantoConstFa();
  tantoConstFa(
    faLabel * faLabelIn,
    bool has_THRUIn,
    featureLabel * featureLabelIn);
  ~tantoConstFa();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  bool get_has_THRU();
  void set_has_THRU(bool has_THRUIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  bool has_THRU;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* tantoConstF

This is a derived class for one of the definitions of tantoConst.
It represents the following items:

TANTO ',' fLabel ',' THRU ',' faLabel

*/

class tantoConstF :
  public tantoConst
{
public:
  tantoConstF();
  tantoConstF(
    fLabel * fLabelIn,
    faLabel * faLabelIn);
  ~tantoConstF();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  fLabel * a_fLabel;
  faLabel * a_faLabel;
};

/********************************************************************/

/* tantoConstPlane

This is a parent class.

*/

class tantoConstPlane :
  public dmisCppBase
{
public:
  tantoConstPlane();
  ~tantoConstPlane();
  void printSelf() = 0;
};

/********************************************************************/

/* tantoConstPlaneFa

This is a derived class for one of the definitions of tantoConstPlane.
It represents the following items:

TANTO ',' faLabel ',' THRU ',' featureLabel

*/

class tantoConstPlaneFa :
  public tantoConstPlane
{
public:
  tantoConstPlaneFa();
  tantoConstPlaneFa(
    faLabel * faLabelIn,
    featureLabel * featureLabelIn);
  ~tantoConstPlaneFa();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  faLabel * a_faLabel;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* tantoConstPlaneF

This is a derived class for one of the definitions of tantoConstPlane.
It represents the following items:

TANTO ',' fLabel ',' THRU ',' faLabel

*/

class tantoConstPlaneF :
  public tantoConstPlane
{
public:
  tantoConstPlaneF();
  tantoConstPlaneF(
    fLabel * fLabelIn,
    faLabel * faLabelIn);
  ~tantoConstPlaneF();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  fLabel * a_fLabel;
  faLabel * a_faLabel;
};

/********************************************************************/

/* trConst

This is a class for the single definition of trConst.
It represents the following items:

TR ',' faLabel [',' datumLabel]

*/

class trConst :
  public dmisCppBase
{
public:
  trConst();
  trConst(
    faLabel * faLabelIn,
    datumLabel * datumLabelIn);
  ~trConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  datumLabel * get_datumLabel();
  void set_datumLabel(datumLabel * datumLabelIn);
private:
  faLabel * a_faLabel;
  datumLabel * a_datumLabel;
};

/********************************************************************/

/* vertexConst

This is a class for the single definition of vertexConst.
It represents the following items:

VERTEX ',' faLabel

*/

class vertexConst :
  public dmisCppBase
{
public:
  vertexConst();
  vertexConst(
    faLabel * faLabelIn);
  ~vertexConst();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  faLabel * a_faLabel;
};

/********************************************************************/

/* crgdefStm

This is a class for the single definition of crgdefStm.
It represents the following items:

crLabelConst '=' crgdefMinor #

*/

class crgdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  crgdefStm();
  crgdefStm(
    crLabelConst * crLabelConstIn,
    crgdefMinor * crgdefMinorIn);
  ~crgdefStm();
  void printSelf();
  crLabelConst * get_crLabelConst();
  void set_crLabelConst(crLabelConst * crLabelConstIn);
  crgdefMinor * get_crgdefMinor();
  void set_crgdefMinor(crgdefMinor * crgdefMinorIn);
private:
  crLabelConst * a_crLabelConst;
  crgdefMinor * a_crgdefMinor;
};

/********************************************************************/

/* crgdefMinor

This is a parent class.

*/

class crgdefMinor :
  public dmisCppBase
{
public:
  crgdefMinor();
  ~crgdefMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* crgdefNoData

This is a derived class for one of the definitions of crgdefMinor.
It represents the following items:

CRGDEF

*/

class crgdefNoData :
  public crgdefMinor
{
public:
  crgdefNoData();
  ~crgdefNoData();
  void printSelf();
};

/********************************************************************/

/* crgdefData

This is a derived class for one of the definitions of crgdefMinor.
It represents the following items:

CRGDEF '/' impCartPoint ',' impCartPoint ',' vector ',' vector ',' vector ',' vector

*/

class crgdefData :
  public crgdefMinor
{
public:
  crgdefData();
  crgdefData(
    impCartPoint * zoneMinIn,
    impCartPoint * zoneMaxIn,
    vector * xVecIn,
    vector * yVecIn,
    vector * zVecIn,
    vector * aVecIn);
  ~crgdefData();
  void printSelf();
  impCartPoint * get_zoneMin();
  void set_zoneMin(impCartPoint * zoneMinIn);
  impCartPoint * get_zoneMax();
  void set_zoneMax(impCartPoint * zoneMaxIn);
  vector * get_xVec();
  void set_xVec(vector * xVecIn);
  vector * get_yVec();
  void set_yVec(vector * yVecIn);
  vector * get_zVec();
  void set_zVec(vector * zVecIn);
  vector * get_aVec();
  void set_aVec(vector * aVecIn);
private:
  impCartPoint * zoneMin;
  impCartPoint * zoneMax;
  vector * xVec;
  vector * yVec;
  vector * zVec;
  vector * aVec;
};

/********************************************************************/

/* crmodeStm

This is a class for the single definition of crmodeStm.
It represents the following items:

CRMODE '/' crmodeMinor #

*/

class crmodeStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  crmodeStm();
  crmodeStm(
    crmodeMinor * crmodeMinorIn);
  ~crmodeStm();
  void printSelf();
  crmodeMinor * get_crmodeMinor();
  void set_crmodeMinor(crmodeMinor * crmodeMinorIn);
private:
  crmodeMinor * a_crmodeMinor;
};

/********************************************************************/

/* crmodeMinor

This is a parent class.

*/

class crmodeMinor :
  public dmisCppBase
{
public:
  crmodeMinor();
  ~crmodeMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* crmodeMinor_SEQNTL

This is a derived class for one of the definitions of crmodeMinor.
It represents the following items:

SEQNTL

*/

class crmodeMinor_SEQNTL :
  public crmodeMinor
{
public:
  crmodeMinor_SEQNTL();
  ~crmodeMinor_SEQNTL();
  void printSelf();
};

/********************************************************************/

/* crmodeMinor_SIMUL

This is a derived class for one of the definitions of crmodeMinor.
It represents the following items:

SIMUL

*/

class crmodeMinor_SIMUL :
  public crmodeMinor
{
public:
  crmodeMinor_SIMUL();
  ~crmodeMinor_SIMUL();
  void printSelf();
};

/********************************************************************/

/* crmodeMinor_SYNC

This is a derived class for one of the definitions of crmodeMinor.
It represents the following items:

SYNC

*/

class crmodeMinor_SYNC :
  public crmodeMinor
{
public:
  crmodeMinor_SYNC();
  ~crmodeMinor_SYNC();
  void printSelf();
};

/********************************************************************/

/* crosclStm

This is a class for the single definition of crosclStm.
It represents the following items:

CROSCL '/' state #

*/

class crosclStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  crosclStm();
  crosclStm(
    state * stateIn);
  ~crosclStm();
  void printSelf();
  state * get_state();
  void set_state(state * stateIn);
private:
  state * a_state;
};

/********************************************************************/

/* crslctMinor

This is a parent class.

*/

class crslctMinor :
  public dmisCppBase
{
public:
  crslctMinor();
  ~crslctMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* crslctMinor_crLabelConst

This is a derived class for one of the definitions of crslctMinor.
It represents the following items:

crLabelConst

*/

class crslctMinor_crLabelConst :
  public crslctMinor
{
public:
  crslctMinor_crLabelConst();
  crslctMinor_crLabelConst(
    crLabelConst * crLabelConstIn);
  ~crslctMinor_crLabelConst();
  void printSelf();
  crLabelConst * get_crLabelConst();
  void set_crLabelConst(crLabelConst * crLabelConstIn);
private:
  crLabelConst * a_crLabelConst;
};

/********************************************************************/

/* crslctMinor_ALL

This is a derived class for one of the definitions of crslctMinor.
It represents the following items:

ALL

*/

class crslctMinor_ALL :
  public crslctMinor
{
public:
  crslctMinor_ALL();
  ~crslctMinor_ALL();
  void printSelf();
};

/********************************************************************/

/* cutcomStm

This is a class for the single definition of cutcomStm.
It represents the following items:

ccLabel '=' CUTCOM '/' cutcomMinor #

*/

class cutcomStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  cutcomStm();
  cutcomStm(
    ccLabel * ccLabelIn,
    cutcomMinor * cutcomMinorIn);
  ~cutcomStm();
  void printSelf();
  ccLabel * get_ccLabel();
  void set_ccLabel(ccLabel * ccLabelIn);
  cutcomMinor * get_cutcomMinor();
  void set_cutcomMinor(cutcomMinor * cutcomMinorIn);
private:
  ccLabel * a_ccLabel;
  cutcomMinor * a_cutcomMinor;
};

/********************************************************************/

/* cutcomMinor

This is a parent class.

*/

class cutcomMinor :
  public dmisCppBase
{
public:
  cutcomMinor();
  ~cutcomMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* cutcomAdjust

This is a class for the single definition of cutcomAdjust.
It represents the following items:

mdLabel ',' ADJUST ',' tlLabel ',' leftRight ',' plan ',' rentVal

*/

class cutcomAdjust :
  public cutcomMinor
{
public:
  cutcomAdjust();
  cutcomAdjust(
    mdLabel * mdLabelIn,
    tlLabel * tlLabelIn,
    leftRight * leftRightIn,
    plan * planIn,
    rentVal * amtIn);
  ~cutcomAdjust();
  void printSelf();
  mdLabel * get_mdLabel();
  void set_mdLabel(mdLabel * mdLabelIn);
  tlLabel * get_tlLabel();
  void set_tlLabel(tlLabel * tlLabelIn);
  leftRight * get_leftRight();
  void set_leftRight(leftRight * leftRightIn);
  plan * get_plan();
  void set_plan(plan * planIn);
  rentVal * get_amt();
  void set_amt(rentVal * amtIn);
private:
  mdLabel * a_mdLabel;
  tlLabel * a_tlLabel;
  leftRight * a_leftRight;
  plan * a_plan;
  rentVal * amt;
};

/********************************************************************/

/* cutcomParam

This is a class for the single definition of cutcomParam.
It represents the following items:

mdLabel ',' PARAM ',' pointVecCart

*/

class cutcomParam :
  public cutcomMinor
{
public:
  cutcomParam();
  cutcomParam(
    mdLabel * mdLabelIn,
    pointVecCart * pointVecCartIn);
  ~cutcomParam();
  void printSelf();
  mdLabel * get_mdLabel();
  void set_mdLabel(mdLabel * mdLabelIn);
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
private:
  mdLabel * a_mdLabel;
  pointVecCart * a_pointVecCart;
};

/********************************************************************/

/* cutcomMatrix

This is a class for the single definition of cutcomMatrix.
It represents the following items:

mdLabel ',' MATRIX ',' cutcomMatx

*/

class cutcomMatrix :
  public cutcomMinor
{
public:
  cutcomMatrix();
  cutcomMatrix(
    mdLabel * mdLabelIn,
    cutcomMatx * cutcomMatxIn);
  ~cutcomMatrix();
  void printSelf();
  mdLabel * get_mdLabel();
  void set_mdLabel(mdLabel * mdLabelIn);
  cutcomMatx * get_cutcomMatx();
  void set_cutcomMatx(cutcomMatx * cutcomMatxIn);
private:
  mdLabel * a_mdLabel;
  cutcomMatx * a_cutcomMatx;
};

/********************************************************************/

/* cutcomMatx

This is a class for the single definition of cutcomMatx.
It represents the following items:

rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal ',' rentVal

*/

class cutcomMatx :
  public dmisCppBase
{
public:
  cutcomMatx();
  cutcomMatx(
    rentVal * dxIn,
    rentVal * dyIn,
    rentVal * dzIn,
    rentVal * ixIn,
    rentVal * iyIn,
    rentVal * izIn,
    rentVal * jxIn,
    rentVal * jyIn,
    rentVal * jzIn,
    rentVal * kxIn,
    rentVal * kyIn,
    rentVal * kzIn);
  ~cutcomMatx();
  void printSelf();
  rentVal * get_dx();
  void set_dx(rentVal * dxIn);
  rentVal * get_dy();
  void set_dy(rentVal * dyIn);
  rentVal * get_dz();
  void set_dz(rentVal * dzIn);
  rentVal * get_ix();
  void set_ix(rentVal * ixIn);
  rentVal * get_iy();
  void set_iy(rentVal * iyIn);
  rentVal * get_iz();
  void set_iz(rentVal * izIn);
  rentVal * get_jx();
  void set_jx(rentVal * jxIn);
  rentVal * get_jy();
  void set_jy(rentVal * jyIn);
  rentVal * get_jz();
  void set_jz(rentVal * jzIn);
  rentVal * get_kx();
  void set_kx(rentVal * kxIn);
  rentVal * get_ky();
  void set_ky(rentVal * kyIn);
  rentVal * get_kz();
  void set_kz(rentVal * kzIn);
private:
  rentVal * dx;
  rentVal * dy;
  rentVal * dz;
  rentVal * ix;
  rentVal * iy;
  rentVal * iz;
  rentVal * jx;
  rentVal * jy;
  rentVal * jz;
  rentVal * kx;
  rentVal * ky;
  rentVal * kz;
};

/********************************************************************/

/* cutcomUserdf

This is a class for the single definition of cutcomUserdf.
It represents the following items:

mdLabel ',' USERDF ',' stringVal

*/

class cutcomUserdf :
  public cutcomMinor
{
public:
  cutcomUserdf();
  cutcomUserdf(
    mdLabel * mdLabelIn,
    stringVal * textIn);
  ~cutcomUserdf();
  void printSelf();
  mdLabel * get_mdLabel();
  void set_mdLabel(mdLabel * mdLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  mdLabel * a_mdLabel;
  stringVal * text;
};

/********************************************************************/

/* czoneStm

This is a class for the single definition of czoneStm.
It represents the following items:

czLabel '=' CZONE #

*/

class czoneStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  czoneStm();
  czoneStm(
    czLabel * czLabelIn);
  ~czoneStm();
  void printSelf();
  czLabel * get_czLabel();
  void set_czLabel(czLabel * czLabelIn);
private:
  czLabel * a_czLabel;
};

/********************************************************************/

/* datdefStm

This is a class for the single definition of datdefStm.
It represents the following items:

DATDEF '/' datdefMinor #

*/

class datdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  datdefStm();
  datdefStm(
    datdefMinor * datdefMinorIn);
  ~datdefStm();
  void printSelf();
  datdefMinor * get_datdefMinor();
  void set_datdefMinor(datdefMinor * datdefMinorIn);
private:
  datdefMinor * a_datdefMinor;
};

/********************************************************************/

/* datdefMinor

This is a parent class.

*/

class datdefMinor :
  public dmisCppBase
{
public:
  datdefMinor();
  ~datdefMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* datdefMinor_featureLabel1

This is a derived class for one of the definitions of datdefMinor.
It represents the following items:

featureLabel1 ',' datLabel

*/

class datdefMinor_featureLabel1 :
  public datdefMinor
{
public:
  datdefMinor_featureLabel1();
  datdefMinor_featureLabel1(
    featureLabel1 * featureLabel1In,
    datLabel * datLabelIn);
  ~datdefMinor_featureLabel1();
  void printSelf();
  featureLabel1 * get_featureLabel1();
  void set_featureLabel1(featureLabel1 * featureLabel1In);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
private:
  featureLabel1 * a_featureLabel1;
  datLabel * a_datLabel;
};

/********************************************************************/

/* datdefMinor_dattrgList

This is a derived class for one of the definitions of datdefMinor.
It represents the following items:

dattrgList ',' fLabel ',' datLabel

*/

class datdefMinor_dattrgList :
  public datdefMinor
{
public:
  datdefMinor_dattrgList();
  datdefMinor_dattrgList(
    std::list<dattrgLabel *> * dattrgListIn,
    fLabel * fLabelIn,
    datLabel * datLabelIn);
  ~datdefMinor_dattrgList();
  void printSelf();
  std::list<dattrgLabel *> * get_dattrgList();
  void set_dattrgList(std::list<dattrgLabel *> * dattrgListIn);
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
private:
  std::list<dattrgLabel *> * a_dattrgList;
  fLabel * a_fLabel;
  datLabel * a_datLabel;
};

/********************************************************************/

/* datsetStm

This is a class for the single definition of datsetStm.
It represents the following items:

dLabel '=' DATSET '/' datsetMinor #

*/

class datsetStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  datsetStm();
  datsetStm(
    dLabel * dLabelIn,
    datsetMinor * datsetMinorIn);
  ~datsetStm();
  void printSelf();
  dLabel * get_dLabel();
  void set_dLabel(dLabel * dLabelIn);
  datsetMinor * get_datsetMinor();
  void set_datsetMinor(datsetMinor * datsetMinorIn);
private:
  dLabel * a_dLabel;
  datsetMinor * a_datsetMinor;
};

/********************************************************************/

/* datsetMinor

This is a parent class.

*/

class datsetMinor :
  public dmisCppBase
{
public:
  datsetMinor();
  ~datsetMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* datsetMcs

This is a class for the single definition of datsetMcs.
It represents the following items:

MCS

*/

class datsetMcs :
  public datsetMinor
{
public:
  datsetMcs();
  ~datsetMcs();
  void printSelf();
};

/********************************************************************/

/* datsetMatrix

This is a class for the single definition of datsetMatrix.
It represents the following items:

TRMATX ',' matrix

*/

class datsetMatrix :
  public datsetMinor
{
public:
  datsetMatrix();
  datsetMatrix(
    matrix * matrixIn);
  ~datsetMatrix();
  void printSelf();
  matrix * get_matrix();
  void set_matrix(matrix * matrixIn);
private:
  matrix * a_matrix;
};

/********************************************************************/

/* datsetDats

This is a class for the single definition of datsetDats.
It represents the following items:

datsetSpec [',' datsetSpec [',' datsetSpec]]

*/

class datsetDats :
  public datsetMinor
{
public:
  datsetDats();
  datsetDats(
    datsetSpec * spec1In,
    datsetSpec * spec2In,
    datsetSpec * spec3In);
  ~datsetDats();
  void printSelf();
  datsetSpec * get_spec1();
  void set_spec1(datsetSpec * spec1In);
  datsetSpec * get_spec2();
  void set_spec2(datsetSpec * spec2In);
  datsetSpec * get_spec3();
  void set_spec3(datsetSpec * spec3In);
private:
  datsetSpec * spec1;
  datsetSpec * spec2;
  datsetSpec * spec3;
};

/********************************************************************/

/* datsetDrf

This is a class for the single definition of datsetDrf.
It represents the following items:

DRF ',' taLabel [',' tier] ',' dir ',' dir

*/

class datsetDrf :
  public datsetMinor
{
public:
  datsetDrf();
  datsetDrf(
    taLabel * taLabelIn,
    tier * tierIn,
    dir * dir1In,
    dir * dir2In);
  ~datsetDrf();
  void printSelf();
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  tier * get_tier();
  void set_tier(tier * tierIn);
  dir * get_dir1();
  void set_dir1(dir * dir1In);
  dir * get_dir2();
  void set_dir2(dir * dir2In);
private:
  taLabel * a_taLabel;
  tier * a_tier;
  dir * dir1;
  dir * dir2;
};

/********************************************************************/

/* tier

This is a parent class.

*/

class tier :
  public dmisCppBase
{
public:
  tier();
  ~tier();
  void printSelf() = 0;
};

/********************************************************************/

/* tier_UPTIER

This is a derived class for one of the definitions of tier.
It represents the following items:

UPTIER

*/

class tier_UPTIER :
  public tier
{
public:
  tier_UPTIER();
  ~tier_UPTIER();
  void printSelf();
};

/********************************************************************/

/* tier_LOTIER

This is a derived class for one of the definitions of tier.
It represents the following items:

LOTIER

*/

class tier_LOTIER :
  public tier
{
public:
  tier_LOTIER();
  ~tier_LOTIER();
  void printSelf();
};

/********************************************************************/

/* datsetSpec

This is a parent class.

*/

class datsetSpec :
  public dmisCppBase
{
public:
  datsetSpec();
  ~datsetSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* datsetSpecNoDir

This is a derived class for one of the definitions of datsetSpec.
It represents the following items:

datLabel ',' orig [',' orig [',' orig]]

*/

class datsetSpecNoDir :
  public datsetSpec
{
public:
  datsetSpecNoDir();
  datsetSpecNoDir(
    datLabel * datLabelIn,
    orig * orig1In,
    orig * orig2In,
    orig * orig3In);
  ~datsetSpecNoDir();
  void printSelf();
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  orig * get_orig1();
  void set_orig1(orig * orig1In);
  orig * get_orig2();
  void set_orig2(orig * orig2In);
  orig * get_orig3();
  void set_orig3(orig * orig3In);
private:
  datLabel * a_datLabel;
  orig * orig1;
  orig * orig2;
  orig * orig3;
};

/********************************************************************/

/* datsetSpecDir

This is a derived class for one of the definitions of datsetSpec.
It represents the following items:

datLabel ',' dir [',' orig [',' orig [',' orig]]]

*/

class datsetSpecDir :
  public datsetSpec
{
public:
  datsetSpecDir();
  datsetSpecDir(
    datLabel * datLabelIn,
    dir * dirIn,
    orig * orig1In,
    orig * orig2In,
    orig * orig3In);
  ~datsetSpecDir();
  void printSelf();
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  dir * get_dir();
  void set_dir(dir * dirIn);
  orig * get_orig1();
  void set_orig1(orig * orig1In);
  orig * get_orig2();
  void set_orig2(orig * orig2In);
  orig * get_orig3();
  void set_orig3(orig * orig3In);
private:
  datLabel * a_datLabel;
  dir * a_dir;
  orig * orig1;
  orig * orig2;
  orig * orig3;
};

/********************************************************************/

/* dattrgdefStm

This is a class for the single definition of dattrgdefStm.
It represents the following items:

DATTRGDEF '/' dattrgMinor #

*/

class dattrgdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  dattrgdefStm();
  dattrgdefStm(
    dattrgMinor * dattrgMinorIn);
  ~dattrgdefStm();
  void printSelf();
  dattrgMinor * get_dattrgMinor();
  void set_dattrgMinor(dattrgMinor * dattrgMinorIn);
private:
  dattrgMinor * a_dattrgMinor;
};

/********************************************************************/

/* dattrgMinor

This is a class for the single definition of dattrgMinor.
It represents the following items:

featureList ',' dattrgLabel

*/

class dattrgMinor :
  public dmisCppBase
{
public:
  dattrgMinor();
  dattrgMinor(
    std::list<featureLabel *> * featureListIn,
    dattrgLabel * dattrgLabelIn);
  ~dattrgMinor();
  void printSelf();
  std::list<featureLabel *> * get_featureList();
  void set_featureList(std::list<featureLabel *> * featureListIn);
  dattrgLabel * get_dattrgLabel();
  void set_dattrgLabel(dattrgLabel * dattrgLabelIn);
private:
  std::list<featureLabel *> * a_featureList;
  dattrgLabel * a_dattrgLabel;
};

/********************************************************************/

/* declStm

This is a class for the single definition of declStm.
It represents the following items:

DECL '/' declMinor #

*/

class declStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  declStm();
  declStm(
    declMinor * declMinorIn);
  ~declStm();
  void printSelf();
  declMinor * get_declMinor();
  void set_declMinor(declMinor * declMinorIn);
private:
  declMinor * a_declMinor;
};

/********************************************************************/

/* declMinor

This is a class for the single definition of declMinor.
It represents the following items:

[declScope ','] declType ',' declVarList

*/

class declMinor :
  public dmisCppBase
{
public:
  declMinor();
  declMinor(
    declScope * declScopeIn,
    declType * declTypeIn,
    std::list<declVar *> * declVarListIn);
  ~declMinor();
  void printSelf();
  declScope * get_declScope();
  void set_declScope(declScope * declScopeIn);
  declType * get_declType();
  void set_declType(declType * declTypeIn);
  std::list<declVar *> * get_declVarList();
  void set_declVarList(std::list<declVar *> * declVarListIn);
private:
  declScope * a_declScope;
  declType * a_declType;
  std::list<declVar *> * a_declVarList;
};

/********************************************************************/

/* declScope

This is a parent class.

*/

class declScope :
  public dmisCppBase
{
public:
  declScope();
  ~declScope();
  void printSelf() = 0;
};

/********************************************************************/

/* declScope_COMMON

This is a derived class for one of the definitions of declScope.
It represents the following items:

COMMON

*/

class declScope_COMMON :
  public declScope
{
public:
  declScope_COMMON();
  ~declScope_COMMON();
  void printSelf();
};

/********************************************************************/

/* declScope_GLOBAL

This is a derived class for one of the definitions of declScope.
It represents the following items:

GLOBAL

*/

class declScope_GLOBAL :
  public declScope
{
public:
  declScope_GLOBAL();
  ~declScope_GLOBAL();
  void printSelf();
};

/********************************************************************/

/* declScope_LOCAL

This is a derived class for one of the definitions of declScope.
It represents the following items:

LOCAL

*/

class declScope_LOCAL :
  public declScope
{
public:
  declScope_LOCAL();
  ~declScope_LOCAL();
  void printSelf();
};

/********************************************************************/

/* declType

This is a parent class.

*/

class declType :
  public dmisCppBase
{
public:
  declType();
  ~declType();
  void printSelf() = 0;
};

/********************************************************************/

/* declType_BOOL

This is a derived class for one of the definitions of declType.
It represents the following items:

BOOL

*/

class declType_BOOL :
  public declType
{
public:
  declType_BOOL();
  ~declType_BOOL();
  void printSelf();
};

/********************************************************************/

/* declType_INTGR

This is a derived class for one of the definitions of declType.
It represents the following items:

INTGR

*/

class declType_INTGR :
  public declType
{
public:
  declType_INTGR();
  ~declType_INTGR();
  void printSelf();
};

/********************************************************************/

/* declType_LONG

This is a derived class for one of the definitions of declType.
It represents the following items:

LONG

*/

class declType_LONG :
  public declType
{
public:
  declType_LONG();
  ~declType_LONG();
  void printSelf();
};

/********************************************************************/

/* declType_REAL

This is a derived class for one of the definitions of declType.
It represents the following items:

REAL

*/

class declType_REAL :
  public declType
{
public:
  declType_REAL();
  ~declType_REAL();
  void printSelf();
};

/********************************************************************/

/* declType_DOUBLE

This is a derived class for one of the definitions of declType.
It represents the following items:

DOUBLE

*/

class declType_DOUBLE :
  public declType
{
public:
  declType_DOUBLE();
  ~declType_DOUBLE();
  void printSelf();
};

/********************************************************************/

/* declType_CHAR

This is a derived class for one of the definitions of declType.
It represents the following items:

CHAR ',' intVal

*/

class declType_CHAR :
  public declType
{
public:
  declType_CHAR();
  declType_CHAR(
    intVal * sizeIn);
  ~declType_CHAR();
  void printSelf();
  intVal * get_size();
  void set_size(intVal * sizeIn);
private:
  intVal * size;
};

/********************************************************************/

/* declType_VECTOR

This is a derived class for one of the definitions of declType.
It represents the following items:

VECTOR

*/

class declType_VECTOR :
  public declType
{
public:
  declType_VECTOR();
  ~declType_VECTOR();
  void printSelf();
};

/********************************************************************/

/* declVar

This is a class for the single definition of declVar.
It represents the following items:

DECLVARNAME ['[' declIndicesList ']']

*/

class declVar :
  public dmisCppBase
{
public:
  declVar();
  declVar(
    char * stringIn,
    std::list<intConst *> * declIndicesListIn);
  ~declVar();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
  std::list<intConst *> * get_declIndicesList();
  void set_declIndicesList(std::list<intConst *> * declIndicesListIn);
private:
  char * a_string;
  std::list<intConst *> * a_declIndicesList;
};

/********************************************************************/

/* decplStm

This is a class for the single definition of decplStm.
It represents the following items:

DECPL '/' decplMinor #

*/

class decplStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  decplStm();
  decplStm(
    decplMinor * decplMinorIn);
  ~decplStm();
  void printSelf();
  decplMinor * get_decplMinor();
  void set_decplMinor(decplMinor * decplMinorIn);
private:
  decplMinor * a_decplMinor;
};

/********************************************************************/

/* decplMinor

This is a parent class.

*/

class decplMinor :
  public dmisCppBase
{
public:
  decplMinor();
  ~decplMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* decplMinor_decplAll

This is a derived class for one of the definitions of decplMinor.
It represents the following items:

decplAll

*/

class decplMinor_decplAll :
  public decplMinor
{
public:
  decplMinor_decplAll();
  decplMinor_decplAll(
    decplAll * decplAllIn);
  ~decplMinor_decplAll();
  void printSelf();
  decplAll * get_decplAll();
  void set_decplAll(decplAll * decplAllIn);
private:
  decplAll * a_decplAll;
};

/********************************************************************/

/* decplMinor_decplList

This is a derived class for one of the definitions of decplMinor.
It represents the following items:

decplList

*/

class decplMinor_decplList :
  public decplMinor
{
public:
  decplMinor_decplList();
  decplMinor_decplList(
    std::list<decplSelection *> * decplListIn);
  ~decplMinor_decplList();
  void printSelf();
  std::list<decplSelection *> * get_decplList();
  void set_decplList(std::list<decplSelection *> * decplListIn);
private:
  std::list<decplSelection *> * a_decplList;
};

/********************************************************************/

/* decplAll

This is a class for the single definition of decplAll.
It represents the following items:

ALL ',' decplNdigits

*/

class decplAll :
  public dmisCppBase
{
public:
  decplAll();
  decplAll(
    decplNdigits * decplNdigitsIn);
  ~decplAll();
  void printSelf();
  decplNdigits * get_decplNdigits();
  void set_decplNdigits(decplNdigits * decplNdigitsIn);
private:
  decplNdigits * a_decplNdigits;
};

/********************************************************************/

/* decplNdigits

This is a parent class.

*/

class decplNdigits :
  public dmisCppBase
{
public:
  decplNdigits();
  ~decplNdigits();
  void printSelf() = 0;
};

/********************************************************************/

/* decplNdigits_DEFALT

This is a derived class for one of the definitions of decplNdigits.
It represents the following items:

DEFALT

*/

class decplNdigits_DEFALT :
  public decplNdigits
{
public:
  decplNdigits_DEFALT();
  ~decplNdigits_DEFALT();
  void printSelf();
};

/********************************************************************/

/* decplNdigits_intVal

This is a derived class for one of the definitions of decplNdigits.
It represents the following items:

intVal

*/

class decplNdigits_intVal :
  public decplNdigits
{
public:
  decplNdigits_intVal();
  decplNdigits_intVal(
    intVal * decimalIn);
  ~decplNdigits_intVal();
  void printSelf();
  intVal * get_decimal();
  void set_decimal(intVal * decimalIn);
private:
  intVal * decimal;
};

/********************************************************************/

/* decplSelection

This is a parent class.

*/

class decplSelection :
  public dmisCppBase
{
public:
  decplSelection();
  ~decplSelection();
  void printSelf() = 0;
};

/********************************************************************/

/* decplSelection_ANGLE

This is a derived class for one of the definitions of decplSelection.
It represents the following items:

ANGLE ',' decplNdigits

*/

class decplSelection_ANGLE :
  public decplSelection
{
public:
  decplSelection_ANGLE();
  decplSelection_ANGLE(
    decplNdigits * decplNdigitsIn);
  ~decplSelection_ANGLE();
  void printSelf();
  decplNdigits * get_decplNdigits();
  void set_decplNdigits(decplNdigits * decplNdigitsIn);
private:
  decplNdigits * a_decplNdigits;
};

/********************************************************************/

/* decplSelection_DIST

This is a derived class for one of the definitions of decplSelection.
It represents the following items:

DIST ',' decplNdigits

*/

class decplSelection_DIST :
  public decplSelection
{
public:
  decplSelection_DIST();
  decplSelection_DIST(
    decplNdigits * decplNdigitsIn);
  ~decplSelection_DIST();
  void printSelf();
  decplNdigits * get_decplNdigits();
  void set_decplNdigits(decplNdigits * decplNdigitsIn);
private:
  decplNdigits * a_decplNdigits;
};

/********************************************************************/

/* decplSelection_HUMID

This is a derived class for one of the definitions of decplSelection.
It represents the following items:

HUMID ',' decplNdigits

*/

class decplSelection_HUMID :
  public decplSelection
{
public:
  decplSelection_HUMID();
  decplSelection_HUMID(
    decplNdigits * decplNdigitsIn);
  ~decplSelection_HUMID();
  void printSelf();
  decplNdigits * get_decplNdigits();
  void set_decplNdigits(decplNdigits * decplNdigitsIn);
private:
  decplNdigits * a_decplNdigits;
};

/********************************************************************/

/* decplSelection_DEV

This is a derived class for one of the definitions of decplSelection.
It represents the following items:

DEV ',' decplNdigits

*/

class decplSelection_DEV :
  public decplSelection
{
public:
  decplSelection_DEV();
  decplSelection_DEV(
    decplNdigits * decplNdigitsIn);
  ~decplSelection_DEV();
  void printSelf();
  decplNdigits * get_decplNdigits();
  void set_decplNdigits(decplNdigits * decplNdigitsIn);
private:
  decplNdigits * a_decplNdigits;
};

/********************************************************************/

/* decplSelection_TEMP

This is a derived class for one of the definitions of decplSelection.
It represents the following items:

TEMP ',' decplNdigits

*/

class decplSelection_TEMP :
  public decplSelection
{
public:
  decplSelection_TEMP();
  decplSelection_TEMP(
    decplNdigits * decplNdigitsIn);
  ~decplSelection_TEMP();
  void printSelf();
  decplNdigits * get_decplNdigits();
  void set_decplNdigits(decplNdigits * decplNdigitsIn);
private:
  decplNdigits * a_decplNdigits;
};

/********************************************************************/

/* decplSelection_VEC

This is a derived class for one of the definitions of decplSelection.
It represents the following items:

VEC ',' decplNdigits

*/

class decplSelection_VEC :
  public decplSelection
{
public:
  decplSelection_VEC();
  decplSelection_VEC(
    decplNdigits * decplNdigitsIn);
  ~decplSelection_VEC();
  void printSelf();
  decplNdigits * get_decplNdigits();
  void set_decplNdigits(decplNdigits * decplNdigitsIn);
private:
  decplNdigits * a_decplNdigits;
};

/********************************************************************/

/* deleteStm

This is a class for the single definition of deleteStm.
It represents the following items:

DELETE '/' deleteMinor #

*/

class deleteStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  deleteStm();
  deleteStm(
    deleteMinor * deleteMinorIn);
  ~deleteStm();
  void printSelf();
  deleteMinor * get_deleteMinor();
  void set_deleteMinor(deleteMinor * deleteMinorIn);
private:
  deleteMinor * a_deleteMinor;
};

/********************************************************************/

/* deleteMinor

This is a parent class.

*/

class deleteMinor :
  public dmisCppBase
{
public:
  deleteMinor();
  ~deleteMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* deleteDatum

This is a class for the single definition of deleteDatum.
It represents the following items:

datumLabel1 [',' didLabel]

*/

class deleteDatum :
  public deleteMinor
{
public:
  deleteDatum();
  deleteDatum(
    datumLabel1 * datumLabel1In,
    didLabel * didLabelIn);
  ~deleteDatum();
  void printSelf();
  datumLabel1 * get_datumLabel1();
  void set_datumLabel1(datumLabel1 * datumLabel1In);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  datumLabel1 * a_datumLabel1;
  didLabel * a_didLabel;
};

/********************************************************************/

/* deleteSensor

This is a class for the single definition of deleteSensor.
It represents the following items:

sensorLabel1 [',' didLabel]

*/

class deleteSensor :
  public deleteMinor
{
public:
  deleteSensor();
  deleteSensor(
    sensorLabel1 * sensorLabel1In,
    didLabel * didLabelIn);
  ~deleteSensor();
  void printSelf();
  sensorLabel1 * get_sensorLabel1();
  void set_sensorLabel1(sensorLabel1 * sensorLabel1In);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  sensorLabel1 * a_sensorLabel1;
  didLabel * a_didLabel;
};

/********************************************************************/

/* deleteFeature

This is a class for the single definition of deleteFeature.
It represents the following items:

faLabel [',' didLabel]

*/

class deleteFeature :
  public deleteMinor
{
public:
  deleteFeature();
  deleteFeature(
    faLabel * faLabelIn,
    didLabel * didLabelIn);
  ~deleteFeature();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  faLabel * a_faLabel;
  didLabel * a_didLabel;
};

/********************************************************************/

/* deleteRotaryTable

This is a class for the single definition of deleteRotaryTable.
It represents the following items:

rtLabel [',' didLabel]

*/

class deleteRotaryTable :
  public deleteMinor
{
public:
  deleteRotaryTable();
  deleteRotaryTable(
    rtLabel * rtLabelIn,
    didLabel * didLabelIn);
  ~deleteRotaryTable();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  rtLabel * a_rtLabel;
  didLabel * a_didLabel;
};

/********************************************************************/

/* deleteAllSensors

This is a class for the single definition of deleteAllSensors.
It represents the following items:

ALLSA [',' EXCEPT ',' saLabelList] [',' didLabel]

*/

class deleteAllSensors :
  public deleteMinor
{
public:
  deleteAllSensors();
  deleteAllSensors(
    std::list<saLabel *> * saLabelListIn,
    didLabel * didLabelIn);
  ~deleteAllSensors();
  void printSelf();
  std::list<saLabel *> * get_saLabelList();
  void set_saLabelList(std::list<saLabel *> * saLabelListIn);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  std::list<saLabel *> * a_saLabelList;
  didLabel * a_didLabel;
};

/********************************************************************/

/* deviceStm

This is a class for the single definition of deviceStm.
It represents the following items:

didLabel '=' DEVICE '/' deviceMinor #

*/

class deviceStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  deviceStm();
  deviceStm(
    didLabel * didLabelIn,
    deviceMinor * deviceMinorIn);
  ~deviceStm();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  deviceMinor * get_deviceMinor();
  void set_deviceMinor(deviceMinor * deviceMinorIn);
private:
  didLabel * a_didLabel;
  deviceMinor * a_deviceMinor;
};

/********************************************************************/

/* deviceMinor

This is a parent class.

*/

class deviceMinor :
  public dmisCppBase
{
public:
  deviceMinor();
  ~deviceMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* deviceMinor_device

This is a derived class for one of the definitions of deviceMinor.
It represents the following items:

device ',' stringVal

*/

class deviceMinor_device :
  public deviceMinor
{
public:
  deviceMinor_device();
  deviceMinor_device(
    device * deviceIn,
    stringVal * nameIn);
  ~deviceMinor_device();
  void printSelf();
  device * get_device();
  void set_device(device * deviceIn);
  stringVal * get_name();
  void set_name(stringVal * nameIn);
private:
  device * a_device;
  stringVal * name;
};

/********************************************************************/

/* deviceMinor_INCR

This is a derived class for one of the definitions of deviceMinor.
It represents the following items:

INCR ',' stringVal

*/

class deviceMinor_INCR :
  public deviceMinor
{
public:
  deviceMinor_INCR();
  deviceMinor_INCR(
    stringVal * maskIn);
  ~deviceMinor_INCR();
  void printSelf();
  stringVal * get_mask();
  void set_mask(stringVal * maskIn);
private:
  stringVal * mask;
};

/********************************************************************/

/* dftcasStm

This is a class for the single definition of dftcasStm.
It represents the following items:

DFTCAS #

*/

class dftcasStm :
  public dmisStatement
{
public:
  dftcasStm();
  ~dftcasStm();
  void printSelf();
};

/********************************************************************/

/* displyStm

This is a parent class.

*/

class displyStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  displyStm();
  ~displyStm();
  void printSelf() = 0;
};

/********************************************************************/

/* displyStmOff

This is a derived class for one of the definitions of displyStm.
It represents the following items:

DISPLY '/' displyOff #

*/

class displyStmOff :
  public displyStm
{
public:
  displyStmOff();
  displyStmOff(
    displyOff * displyOffIn);
  ~displyStmOff();
  void printSelf();
  displyOff * get_displyOff();
  void set_displyOff(displyOff * displyOffIn);
private:
  displyOff * a_displyOff;
};

/********************************************************************/

/* displyStmSpec

This is a derived class for one of the definitions of displyStm.
It represents the following items:

DISPLY '/' displySpecList #

*/

class displyStmSpec :
  public displyStm
{
public:
  displyStmSpec();
  displyStmSpec(
    std::list<displySpecItem *> * displySpecListIn);
  ~displyStmSpec();
  void printSelf();
  std::list<displySpecItem *> * get_displySpecList();
  void set_displySpecList(std::list<displySpecItem *> * displySpecListIn);
private:
  std::list<displySpecItem *> * a_displySpecList;
};

/********************************************************************/

/* displyOff

This is a class for the single definition of displyOff.
It represents the following items:

OFF

*/

class displyOff :
  public dmisCppBase
{
public:
  displyOff();
  ~displyOff();
  void printSelf();
};

/********************************************************************/

/* displySpecItem

This is a parent class.

*/

class displySpecItem :
  public dmisCppBase
{
public:
  displySpecItem();
  ~displySpecItem();
  void printSelf() = 0;
};

/********************************************************************/

/* displyItemDMIS

This is a derived class for one of the definitions of displySpecItem.
It represents the following items:

device ',' DMIS [',' vLabel]

*/

class displyItemDMIS :
  public displySpecItem
{
public:
  displyItemDMIS();
  displyItemDMIS(
    device * deviceIn,
    vLabel * vLabelIn);
  ~displyItemDMIS();
  void printSelf();
  device * get_device();
  void set_device(device * deviceIn);
  vLabel * get_vLabel();
  void set_vLabel(vLabel * vLabelIn);
private:
  device * a_device;
  vLabel * a_vLabel;
};

/********************************************************************/

/* displyItemNoDMIS

This is a derived class for one of the definitions of displySpecItem.
It represents the following items:

device ',' vLabel

*/

class displyItemNoDMIS :
  public displySpecItem
{
public:
  displyItemNoDMIS();
  displyItemNoDMIS(
    device * deviceIn,
    vLabel * vLabelIn);
  ~displyItemNoDMIS();
  void printSelf();
  device * get_device();
  void set_device(device * deviceIn);
  vLabel * get_vLabel();
  void set_vLabel(vLabel * vLabelIn);
private:
  device * a_device;
  vLabel * a_vLabel;
};

/********************************************************************/

/* dmehwMinor

This is a parent class.

*/

class dmehwMinor :
  public dmisCppBase
{
public:
  dmehwMinor();
  ~dmehwMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* dmehwMinor_CONTIN

This is a derived class for one of the definitions of dmehwMinor.
It represents the following items:

CONTIN

*/

class dmehwMinor_CONTIN :
  public dmehwMinor
{
public:
  dmehwMinor_CONTIN();
  ~dmehwMinor_CONTIN();
  void printSelf();
};

/********************************************************************/

/* dmehwMinor_PAUSE

This is a derived class for one of the definitions of dmehwMinor.
It represents the following items:

PAUSE

*/

class dmehwMinor_PAUSE :
  public dmehwMinor
{
public:
  dmehwMinor_PAUSE();
  ~dmehwMinor_PAUSE();
  void printSelf();
};

/********************************************************************/

/* dmehwMinor_SINGLE

This is a derived class for one of the definitions of dmehwMinor.
It represents the following items:

SINGLE

*/

class dmehwMinor_SINGLE :
  public dmehwMinor
{
public:
  dmehwMinor_SINGLE();
  ~dmehwMinor_SINGLE();
  void printSelf();
};

/********************************************************************/

/* dmehwMinor_AUTO

This is a derived class for one of the definitions of dmehwMinor.
It represents the following items:

AUTO

*/

class dmehwMinor_AUTO :
  public dmehwMinor
{
public:
  dmehwMinor_AUTO();
  ~dmehwMinor_AUTO();
  void printSelf();
};

/********************************************************************/

/* dmehwMinor_jointConf

This is a derived class for one of the definitions of dmehwMinor.
It represents the following items:

jointConf

*/

class dmehwMinor_jointConf :
  public dmehwMinor
{
public:
  dmehwMinor_jointConf();
  dmehwMinor_jointConf(
    jointConf * jointConfIn);
  ~dmehwMinor_jointConf();
  void printSelf();
  jointConf * get_jointConf();
  void set_jointConf(jointConf * jointConfIn);
private:
  jointConf * a_jointConf;
};

/********************************************************************/

/* jointConf

This is a class for the single definition of jointConf.
It represents the following items:

JOINTCONFIG [',' rightyLefty] [',' aboveBelow] [',' flipNoFlip] [',' stringList]

*/

class jointConf :
  public dmisCppBase
{
public:
  jointConf();
  jointConf(
    rightyLefty * rightyLeftyIn,
    aboveBelow * aboveBelowIn,
    flipNoFlip * flipNoFlipIn,
    std::list<stringVal *> * stringListIn);
  ~jointConf();
  void printSelf();
  rightyLefty * get_rightyLefty();
  void set_rightyLefty(rightyLefty * rightyLeftyIn);
  aboveBelow * get_aboveBelow();
  void set_aboveBelow(aboveBelow * aboveBelowIn);
  flipNoFlip * get_flipNoFlip();
  void set_flipNoFlip(flipNoFlip * flipNoFlipIn);
  std::list<stringVal *> * get_stringList();
  void set_stringList(std::list<stringVal *> * stringListIn);
private:
  rightyLefty * a_rightyLefty;
  aboveBelow * a_aboveBelow;
  flipNoFlip * a_flipNoFlip;
  std::list<stringVal *> * a_stringList;
};

/********************************************************************/

/* rightyLefty

This is a parent class.

*/

class rightyLefty :
  public dmisCppBase
{
public:
  rightyLefty();
  ~rightyLefty();
  void printSelf() = 0;
};

/********************************************************************/

/* rightyLefty_RIGHTY

This is a derived class for one of the definitions of rightyLefty.
It represents the following items:

RIGHTY

*/

class rightyLefty_RIGHTY :
  public rightyLefty
{
public:
  rightyLefty_RIGHTY();
  ~rightyLefty_RIGHTY();
  void printSelf();
};

/********************************************************************/

/* rightyLefty_LEFTY

This is a derived class for one of the definitions of rightyLefty.
It represents the following items:

LEFTY

*/

class rightyLefty_LEFTY :
  public rightyLefty
{
public:
  rightyLefty_LEFTY();
  ~rightyLefty_LEFTY();
  void printSelf();
};

/********************************************************************/

/* aboveBelow

This is a parent class.

*/

class aboveBelow :
  public dmisCppBase
{
public:
  aboveBelow();
  ~aboveBelow();
  void printSelf() = 0;
};

/********************************************************************/

/* aboveBelow_ABOVE

This is a derived class for one of the definitions of aboveBelow.
It represents the following items:

ABOVE

*/

class aboveBelow_ABOVE :
  public aboveBelow
{
public:
  aboveBelow_ABOVE();
  ~aboveBelow_ABOVE();
  void printSelf();
};

/********************************************************************/

/* aboveBelow_BELOW

This is a derived class for one of the definitions of aboveBelow.
It represents the following items:

BELOW

*/

class aboveBelow_BELOW :
  public aboveBelow
{
public:
  aboveBelow_BELOW();
  ~aboveBelow_BELOW();
  void printSelf();
};

/********************************************************************/

/* flipNoFlip

This is a parent class.

*/

class flipNoFlip :
  public dmisCppBase
{
public:
  flipNoFlip();
  ~flipNoFlip();
  void printSelf() = 0;
};

/********************************************************************/

/* flipNoFlip_FLIP

This is a derived class for one of the definitions of flipNoFlip.
It represents the following items:

FLIP

*/

class flipNoFlip_FLIP :
  public flipNoFlip
{
public:
  flipNoFlip_FLIP();
  ~flipNoFlip_FLIP();
  void printSelf();
};

/********************************************************************/

/* flipNoFlip_NOFLIP

This is a derived class for one of the definitions of flipNoFlip.
It represents the following items:

NOFLIP

*/

class flipNoFlip_NOFLIP :
  public flipNoFlip
{
public:
  flipNoFlip_NOFLIP();
  ~flipNoFlip_NOFLIP();
  void printSelf();
};

/********************************************************************/

/* dmeidStm

This is a class for the single definition of dmeidStm.
It represents the following items:

diLabel '=' DMEID '/' stringVal #

*/

class dmeidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  dmeidStm();
  dmeidStm(
    diLabel * diLabelIn,
    stringVal * textIn);
  ~dmeidStm();
  void printSelf();
  diLabel * get_diLabel();
  void set_diLabel(diLabel * diLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  diLabel * a_diLabel;
  stringVal * text;
};

/********************************************************************/

/* dmeswMinor

This is a parent class.

*/

class dmeswMinor :
  public dmisCppBase
{
public:
  dmeswMinor();
  ~dmeswMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* dmeswComand

This is a class for the single definition of dmeswComand.
It represents the following items:

COMAND ',' stringVal

*/

class dmeswComand :
  public dmeswMinor
{
public:
  dmeswComand();
  dmeswComand(
    stringVal * commandIn);
  ~dmeswComand();
  void printSelf();
  stringVal * get_command();
  void set_command(stringVal * commandIn);
private:
  stringVal * command;
};

/********************************************************************/

/* dmeswDelay

This is a class for the single definition of dmeswDelay.
It represents the following items:

DELAY ',' intVal

*/

class dmeswDelay :
  public dmeswMinor
{
public:
  dmeswDelay();
  dmeswDelay(
    intVal * secsIn);
  ~dmeswDelay();
  void printSelf();
  intVal * get_secs();
  void set_secs(intVal * secsIn);
private:
  intVal * secs;
};

/********************************************************************/

/* dmeswSwitch

This is a parent class.

*/

class dmeswSwitch :
  public dmeswMinor
{
public:
  dmeswSwitch();
  ~dmeswSwitch();
  void printSelf() = 0;
};

/********************************************************************/

/* dmeswSwitch_CONTIN

This is a derived class for one of the definitions of dmeswSwitch.
It represents the following items:

CONTIN

*/

class dmeswSwitch_CONTIN :
  public dmeswSwitch
{
public:
  dmeswSwitch_CONTIN();
  ~dmeswSwitch_CONTIN();
  void printSelf();
};

/********************************************************************/

/* dmeswSwitch_PAUSE

This is a derived class for one of the definitions of dmeswSwitch.
It represents the following items:

PAUSE

*/

class dmeswSwitch_PAUSE :
  public dmeswSwitch
{
public:
  dmeswSwitch_PAUSE();
  ~dmeswSwitch_PAUSE();
  void printSelf();
};

/********************************************************************/

/* dmeswiStm

This is a class for the single definition of dmeswiStm.
It represents the following items:

dsLabel '=' DMESWI '/' stringVal #

*/

class dmeswiStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  dmeswiStm();
  dmeswiStm(
    dsLabel * dsLabelIn,
    stringVal * textIn);
  ~dmeswiStm();
  void printSelf();
  dsLabel * get_dsLabel();
  void set_dsLabel(dsLabel * dsLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  dsLabel * a_dsLabel;
  stringVal * text;
};

/********************************************************************/

/* dmeswvStm

This is a class for the single definition of dmeswvStm.
It represents the following items:

dvLabel '=' DMESWV '/' stringVal #

*/

class dmeswvStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  dmeswvStm();
  dmeswvStm(
    dvLabel * dvLabelIn,
    stringVal * textIn);
  ~dmeswvStm();
  void printSelf();
  dvLabel * get_dvLabel();
  void set_dvLabel(dvLabel * dvLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  dvLabel * a_dvLabel;
  stringVal * text;
};

/********************************************************************/

/* dmisOffStm

This is a class for the single definition of dmisOffStm.
It represents the following items:

DMIS '/' OFF #

*/

class dmisOffStm :
  public dmisStatement
{
public:
  dmisOffStm();
  ~dmisOffStm();
  void printSelf();
};

/********************************************************************/

/* dmisOnStm

This is a class for the single definition of dmisOnStm.
It represents the following items:

DMIS '/' ON #

*/

class dmisOnStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  dmisOnStm();
  ~dmisOnStm();
  void printSelf();
};

/********************************************************************/

/* dmismdStm

This is a class for the single definition of dmismdStm.
It represents the following items:

DMISMD '/' stringConst ',' versionTag [',' conformItemList] #

*/

class dmismdStm :
  public dmisFirstStatement,
  public dmisStatement
{
public:
  dmismdStm();
  dmismdStm(
    stringConst * stringConstIn,
    versionTag * versionTagIn,
    std::list<conformItem *> * conformItemListIn);
  ~dmismdStm();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
  versionTag * get_versionTag();
  void set_versionTag(versionTag * versionTagIn);
  std::list<conformItem *> * get_conformItemList();
  void set_conformItemList(std::list<conformItem *> * conformItemListIn);
private:
  stringConst * a_stringConst;
  versionTag * a_versionTag;
  std::list<conformItem *> * a_conformItemList;
};

/********************************************************************/

/* dmismnStm

This is a class for the single definition of dmismnStm.
It represents the following items:

DMISMN '/' stringConst ',' versionTag [',' conformItemList] #

*/

class dmismnStm :
  public dmisFirstStatement,
  public dmisStatement
{
public:
  dmismnStm();
  dmismnStm(
    stringConst * stringConstIn,
    versionTag * versionTagIn,
    std::list<conformItem *> * conformItemListIn);
  ~dmismnStm();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
  versionTag * get_versionTag();
  void set_versionTag(versionTag * versionTagIn);
  std::list<conformItem *> * get_conformItemList();
  void set_conformItemList(std::list<conformItem *> * conformItemListIn);
private:
  stringConst * a_stringConst;
  versionTag * a_versionTag;
  std::list<conformItem *> * a_conformItemList;
};

/********************************************************************/

/* conformItem

This is a class for the single definition of conformItem.
It represents the following items:

conformType ',' INTSTRING

*/

class conformItem :
  public dmisCppBase
{
public:
  conformItem();
  conformItem(
    conformType * conformTypeIn,
    int intIn);
  ~conformItem();
  void printSelf();
  conformType * get_conformType();
  void set_conformType(conformType * conformTypeIn);
  int get_int();
  void set_int(int intIn);
private:
  conformType * a_conformType;
  int a_int;
};

/********************************************************************/

/* conformType

This is a parent class.

*/

class conformType :
  public dmisCppBase
{
public:
  conformType();
  ~conformType();
  void printSelf() = 0;
};

/********************************************************************/

/* conformType_CT

This is a derived class for one of the definitions of conformType.
It represents the following items:

CT

*/

class conformType_CT :
  public conformType
{
public:
  conformType_CT();
  ~conformType_CT();
  void printSelf();
};

/********************************************************************/

/* conformType_FX

This is a derived class for one of the definitions of conformType.
It represents the following items:

FX

*/

class conformType_FX :
  public conformType
{
public:
  conformType_FX();
  ~conformType_FX();
  void printSelf();
};

/********************************************************************/

/* conformType_IP

This is a derived class for one of the definitions of conformType.
It represents the following items:

IP

*/

class conformType_IP :
  public conformType
{
public:
  conformType_IP();
  ~conformType_IP();
  void printSelf();
};

/********************************************************************/

/* conformType_MC

This is a derived class for one of the definitions of conformType.
It represents the following items:

MC

*/

class conformType_MC :
  public conformType
{
public:
  conformType_MC();
  ~conformType_MC();
  void printSelf();
};

/********************************************************************/

/* conformType_MU

This is a derived class for one of the definitions of conformType.
It represents the following items:

MU

*/

class conformType_MU :
  public conformType
{
public:
  conformType_MU();
  ~conformType_MU();
  void printSelf();
};

/********************************************************************/

/* conformType_PM

This is a derived class for one of the definitions of conformType.
It represents the following items:

PM

*/

class conformType_PM :
  public conformType
{
public:
  conformType_PM();
  ~conformType_PM();
  void printSelf();
};

/********************************************************************/

/* conformType_QI

This is a derived class for one of the definitions of conformType.
It represents the following items:

QI

*/

class conformType_QI :
  public conformType
{
public:
  conformType_QI();
  ~conformType_QI();
  void printSelf();
};

/********************************************************************/

/* conformType_RY

This is a derived class for one of the definitions of conformType.
It represents the following items:

RY

*/

class conformType_RY :
  public conformType
{
public:
  conformType_RY();
  ~conformType_RY();
  void printSelf();
};

/********************************************************************/

/* conformType_SF

This is a derived class for one of the definitions of conformType.
It represents the following items:

SF

*/

class conformType_SF :
  public conformType
{
public:
  conformType_SF();
  ~conformType_SF();
  void printSelf();
};

/********************************************************************/

/* conformType_TW

This is a derived class for one of the definitions of conformType.
It represents the following items:

TW

*/

class conformType_TW :
  public conformType
{
public:
  conformType_TW();
  ~conformType_TW();
  void printSelf();
};

/********************************************************************/

/* doStm

This is a class for the single definition of doStm.
It represents the following items:

DO '/' intVar ',' intVal ',' intVal [',' intVal] #

*/

class doStm :
  public dmisStatement
{
public:
  doStm();
  doStm(
    intVar * indexIn,
    intVal * initIn,
    intVal * limitIn,
    intVal * incrIn);
  ~doStm();
  void printSelf();
  intVar * get_index();
  void set_index(intVar * indexIn);
  intVal * get_init();
  void set_init(intVal * initIn);
  intVal * get_limit();
  void set_limit(intVal * limitIn);
  intVal * get_incr();
  void set_incr(intVal * incrIn);
private:
  intVar * index;
  intVal * init;
  intVal * limit;
  intVal * incr;
};

/********************************************************************/

/* elseStm

This is a class for the single definition of elseStm.
It represents the following items:

ELSE #

*/

class elseStm :
  public dmisStatement
{
public:
  elseStm();
  ~elseStm();
  void printSelf();
};

/********************************************************************/

/* endcasStm

This is a class for the single definition of endcasStm.
It represents the following items:

ENDCAS #

*/

class endcasStm :
  public dmisStatement
{
public:
  endcasStm();
  ~endcasStm();
  void printSelf();
};

/********************************************************************/

/* enddoStm

This is a class for the single definition of enddoStm.
It represents the following items:

ENDDO #

*/

class enddoStm :
  public dmisStatement
{
public:
  enddoStm();
  ~enddoStm();
  void printSelf();
};

/********************************************************************/

/* endfilStm

This is a class for the single definition of endfilStm.
It represents the following items:

ENDFIL #

*/

class endfilStm :
  public dmisStatement
{
public:
  endfilStm();
  ~endfilStm();
  void printSelf();
};

/********************************************************************/

/* endgoStm

This is a class for the single definition of endgoStm.
It represents the following items:

ENDGO #

*/

class endgoStm :
  public dmisStatement
{
public:
  endgoStm();
  ~endgoStm();
  void printSelf();
};

/********************************************************************/

/* endifStm

This is a class for the single definition of endifStm.
It represents the following items:

ENDIF #

*/

class endifStm :
  public dmisStatement
{
public:
  endifStm();
  ~endifStm();
  void printSelf();
};

/********************************************************************/

/* endmacStm

This is a class for the single definition of endmacStm.
It represents the following items:

ENDMAC #

*/

class endmacStm :
  public dmisStatement
{
public:
  endmacStm();
  ~endmacStm();
  void printSelf();
};

/********************************************************************/

/* endmesStm

This is a class for the single definition of endmesStm.
It represents the following items:

ENDMES #

*/

class endmesStm :
  public dmisStatement
{
public:
  endmesStm();
  ~endmesStm();
  void printSelf();
};

/********************************************************************/

/* endselStm

This is a class for the single definition of endselStm.
It represents the following items:

ENDSEL #

*/

class endselStm :
  public dmisStatement
{
public:
  endselStm();
  ~endselStm();
  void printSelf();
};

/********************************************************************/

/* endsimreqtStm

This is a class for the single definition of endsimreqtStm.
It represents the following items:

ENDSIMREQT #

*/

class endsimreqtStm :
  public dmisStatement
{
public:
  endsimreqtStm();
  ~endsimreqtStm();
  void printSelf();
};

/********************************************************************/

/* endxtnStm

This is a class for the single definition of endxtnStm.
It represents the following items:

ENDXTN #

*/

class endxtnStm :
  public dmisStatement
{
public:
  endxtnStm();
  ~endxtnStm();
  void printSelf();
};

/********************************************************************/

/* equateStm

This is a class for the single definition of equateStm.
It represents the following items:

EQUATE '/' equateMinor #

*/

class equateStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  equateStm();
  equateStm(
    equateMinor * equateMinorIn);
  ~equateStm();
  void printSelf();
  equateMinor * get_equateMinor();
  void set_equateMinor(equateMinor * equateMinorIn);
private:
  equateMinor * a_equateMinor;
};

/********************************************************************/

/* equateMinor

This is a parent class.

*/

class equateMinor :
  public dmisCppBase
{
public:
  equateMinor();
  ~equateMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* equateDatum

This is a derived class for one of the definitions of equateMinor.
It represents the following items:

daLabel ',' daLabel

*/

class equateDatum :
  public equateMinor
{
public:
  equateDatum();
  equateDatum(
    daLabel * equateFromIn,
    daLabel * equateToIn);
  ~equateDatum();
  void printSelf();
  daLabel * get_equateFrom();
  void set_equateFrom(daLabel * equateFromIn);
  daLabel * get_equateTo();
  void set_equateTo(daLabel * equateToIn);
private:
  daLabel * equateFrom;
  daLabel * equateTo;
};

/********************************************************************/

/* equateCad

This is a derived class for one of the definitions of equateMinor.
It represents the following items:

daLabel ',' CADCS ',' equateCadcs

*/

class equateCad :
  public equateMinor
{
public:
  equateCad();
  equateCad(
    daLabel * equateFromIn,
    equateCadcs * equateCadcsIn);
  ~equateCad();
  void printSelf();
  daLabel * get_equateFrom();
  void set_equateFrom(daLabel * equateFromIn);
  equateCadcs * get_equateCadcs();
  void set_equateCadcs(equateCadcs * equateCadcsIn);
private:
  daLabel * equateFrom;
  equateCadcs * a_equateCadcs;
};

/********************************************************************/

/* equateCadcs

This is a parent class.

*/

class equateCadcs :
  public dmisCppBase
{
public:
  equateCadcs();
  ~equateCadcs();
  void printSelf() = 0;
};

/********************************************************************/

/* equateCadcs_matrix

This is a derived class for one of the definitions of equateCadcs.
It represents the following items:

didLabel ',' matrix

*/

class equateCadcs_matrix :
  public equateCadcs
{
public:
  equateCadcs_matrix();
  equateCadcs_matrix(
    didLabel * didLabelIn,
    matrix * matrixIn);
  ~equateCadcs_matrix();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  matrix * get_matrix();
  void set_matrix(matrix * matrixIn);
private:
  didLabel * a_didLabel;
  matrix * a_matrix;
};

/********************************************************************/

/* equateCadcs_stringVal

This is a derived class for one of the definitions of equateCadcs.
It represents the following items:

didLabel ',' stringVal

*/

class equateCadcs_stringVal :
  public equateCadcs
{
public:
  equateCadcs_stringVal();
  equateCadcs_stringVal(
    didLabel * didLabelIn,
    stringVal * textIn);
  ~equateCadcs_stringVal();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  didLabel * a_didLabel;
  stringVal * text;
};

/********************************************************************/

/* errorMinor

This is a parent class.

*/

class errorMinor :
  public dmisCppBase
{
public:
  errorMinor();
  ~errorMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* errorMinor_jumpLabel

This is a derived class for one of the definitions of errorMinor.
It represents the following items:

jumpLabel ',' errorCondition

*/

class errorMinor_jumpLabel :
  public errorMinor
{
public:
  errorMinor_jumpLabel();
  errorMinor_jumpLabel(
    jumpLabel * jumpLabelIn,
    errorCondition * errorConditionIn);
  ~errorMinor_jumpLabel();
  void printSelf();
  jumpLabel * get_jumpLabel();
  void set_jumpLabel(jumpLabel * jumpLabelIn);
  errorCondition * get_errorCondition();
  void set_errorCondition(errorCondition * errorConditionIn);
private:
  jumpLabel * a_jumpLabel;
  errorCondition * a_errorCondition;
};

/********************************************************************/

/* errorMinor_AUTO

This is a derived class for one of the definitions of errorMinor.
It represents the following items:

AUTO ',' errorCondition

*/

class errorMinor_AUTO :
  public errorMinor
{
public:
  errorMinor_AUTO();
  errorMinor_AUTO(
    errorCondition * errorConditionIn);
  ~errorMinor_AUTO();
  void printSelf();
  errorCondition * get_errorCondition();
  void set_errorCondition(errorCondition * errorConditionIn);
private:
  errorCondition * a_errorCondition;
};

/********************************************************************/

/* errorMinor_OFF

This is a derived class for one of the definitions of errorMinor.
It represents the following items:

OFF

*/

class errorMinor_OFF :
  public errorMinor
{
public:
  errorMinor_OFF();
  ~errorMinor_OFF();
  void printSelf();
};

/********************************************************************/

/* errorCondition

This is a parent class.

*/

class errorCondition :
  public dmisCppBase
{
public:
  errorCondition();
  ~errorCondition();
  void printSelf() = 0;
};

/********************************************************************/

/* errorCondition_ALL

This is a derived class for one of the definitions of errorCondition.
It represents the following items:

ALL

*/

class errorCondition_ALL :
  public errorCondition
{
public:
  errorCondition_ALL();
  ~errorCondition_ALL();
  void printSelf();
};

/********************************************************************/

/* errorCondition_ILLEGALTOUCH

This is a derived class for one of the definitions of errorCondition.
It represents the following items:

ILLEGALTOUCH

*/

class errorCondition_ILLEGALTOUCH :
  public errorCondition
{
public:
  errorCondition_ILLEGALTOUCH();
  ~errorCondition_ILLEGALTOUCH();
  void printSelf();
};

/********************************************************************/

/* errorCondition_NOTOUCH

This is a derived class for one of the definitions of errorCondition.
It represents the following items:

NOTOUCH

*/

class errorCondition_NOTOUCH :
  public errorCondition
{
public:
  errorCondition_NOTOUCH();
  ~errorCondition_NOTOUCH();
  void printSelf();
};

/********************************************************************/

/* errorCondition_intVal

This is a derived class for one of the definitions of errorCondition.
It represents the following items:

intVal

*/

class errorCondition_intVal :
  public errorCondition
{
public:
  errorCondition_intVal();
  errorCondition_intVal(
    intVal * ercodeIn);
  ~errorCondition_intVal();
  void printSelf();
  intVal * get_ercode();
  void set_ercode(intVal * ercodeIn);
private:
  intVal * ercode;
};

/********************************************************************/

/* evalStm

This is a class for the single definition of evalStm.
It represents the following items:

EVAL '/' evalMinor #

*/

class evalStm :
  public evalOrOutput,
  public dmisFreeStatement,
  public dmisStatement
{
public:
  evalStm();
  evalStm(
    evalMinor * evalMinorIn);
  ~evalStm();
  void printSelf();
  evalMinor * get_evalMinor();
  void set_evalMinor(evalMinor * evalMinorIn);
private:
  evalMinor * a_evalMinor;
};

/********************************************************************/

/* evalMinor

This is a parent class.

*/

class evalMinor :
  public dmisCppBase
{
public:
  evalMinor();
  ~evalMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* evalFeat

This is a parent class.

*/

class evalFeat :
  public evalMinor
{
public:
  evalFeat();
  ~evalFeat();
  void printSelf() = 0;
};

/********************************************************************/

/* evalFeatFaT

This is a derived class for one of the definitions of evalFeat.
It represents the following items:

faLabel ',' tLabelList

*/

class evalFeatFaT :
  public evalFeat
{
public:
  evalFeatFaT();
  evalFeatFaT(
    faLabel * faIn,
    std::list<tLabel *> * tLabelListIn);
  ~evalFeatFaT();
  void printSelf();
  faLabel * get_fa();
  void set_fa(faLabel * faIn);
  std::list<tLabel *> * get_tLabelList();
  void set_tLabelList(std::list<tLabel *> * tLabelListIn);
private:
  faLabel * fa;
  std::list<tLabel *> * a_tLabelList;
};

/********************************************************************/

/* evalFeatFaFT

This is a derived class for one of the definitions of evalFeat.
It represents the following items:

faLabel ',' fLabel ',' tLabel

*/

class evalFeatFaFT :
  public evalFeat
{
public:
  evalFeatFaFT();
  evalFeatFaFT(
    faLabel * faIn,
    fLabel * fIn,
    tLabel * tIn);
  ~evalFeatFaFT();
  void printSelf();
  faLabel * get_fa();
  void set_fa(faLabel * faIn);
  fLabel * get_f();
  void set_f(fLabel * fIn);
  tLabel * get_t();
  void set_t(tLabel * tIn);
private:
  faLabel * fa;
  fLabel * f;
  tLabel * t;
};

/********************************************************************/

/* evalFeatFFaT

This is a derived class for one of the definitions of evalFeat.
It represents the following items:

fLabel ',' faLabel ',' tLabel

*/

class evalFeatFFaT :
  public evalFeat
{
public:
  evalFeatFFaT();
  evalFeatFFaT(
    fLabel * fIn,
    faLabel * faIn,
    tLabel * tIn);
  ~evalFeatFFaT();
  void printSelf();
  fLabel * get_f();
  void set_f(fLabel * fIn);
  faLabel * get_fa();
  void set_fa(faLabel * faIn);
  tLabel * get_t();
  void set_t(tLabel * tIn);
private:
  fLabel * f;
  faLabel * fa;
  tLabel * t;
};

/********************************************************************/

/* evalFeatFaFaT

This is a derived class for one of the definitions of evalFeat.
It represents the following items:

faLabel ',' faLabel ',' tLabel

*/

class evalFeatFaFaT :
  public evalFeat
{
public:
  evalFeatFaFaT();
  evalFeatFaFaT(
    faLabel * fa1In,
    faLabel * fa2In,
    tLabel * tIn);
  ~evalFeatFaFaT();
  void printSelf();
  faLabel * get_fa1();
  void set_fa1(faLabel * fa1In);
  faLabel * get_fa2();
  void set_fa2(faLabel * fa2In);
  tLabel * get_t();
  void set_t(tLabel * tIn);
private:
  faLabel * fa1;
  faLabel * fa2;
  tLabel * t;
};

/********************************************************************/

/* evalDat

This is a parent class.

*/

class evalDat :
  public evalMinor
{
public:
  evalDat();
  ~evalDat();
  void printSelf() = 0;
};

/********************************************************************/

/* evalDatDatFa

This is a derived class for one of the definitions of evalDat.
It represents the following items:

datLabel ',' faLabel ',' tLabel

*/

class evalDatDatFa :
  public evalDat
{
public:
  evalDatDatFa();
  evalDatDatFa(
    datLabel * datLabelIn,
    faLabel * faLabelIn,
    tLabel * tLabelIn);
  ~evalDatDatFa();
  void printSelf();
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
private:
  datLabel * a_datLabel;
  faLabel * a_faLabel;
  tLabel * a_tLabel;
};

/********************************************************************/

/* evalDatFaDat

This is a derived class for one of the definitions of evalDat.
It represents the following items:

faLabel ',' datLabel ',' tLabel

*/

class evalDatFaDat :
  public evalDat
{
public:
  evalDatFaDat();
  evalDatFaDat(
    faLabel * faLabelIn,
    datLabel * datLabelIn,
    tLabel * tLabelIn);
  ~evalDatFaDat();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
private:
  faLabel * a_faLabel;
  datLabel * a_datLabel;
  tLabel * a_tLabel;
};

/********************************************************************/

/* evalKeychar

This is a parent class.

*/

class evalKeychar :
  public evalMinor
{
public:
  evalKeychar();
  ~evalKeychar();
  void printSelf() = 0;
};

/********************************************************************/

/* extensStm

This is a class for the single definition of extensStm.
It represents the following items:

sxLabel '=' EXTENS '/' extensMinor #

*/

class extensStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  extensStm();
  extensStm(
    sxLabel * sxLabelIn,
    extensMinor * extensMinorIn);
  ~extensStm();
  void printSelf();
  sxLabel * get_sxLabel();
  void set_sxLabel(sxLabel * sxLabelIn);
  extensMinor * get_extensMinor();
  void set_extensMinor(extensMinor * extensMinorIn);
private:
  sxLabel * a_sxLabel;
  extensMinor * a_extensMinor;
};

/********************************************************************/

/* extensMinor

This is a parent class.

*/

class extensMinor :
  public dmisCppBase
{
public:
  extensMinor();
  ~extensMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* extensMinor_vector

This is a derived class for one of the definitions of extensMinor.
It represents the following items:

vector

*/

class extensMinor_vector :
  public extensMinor
{
public:
  extensMinor_vector();
  extensMinor_vector(
    vector * offsetIn);
  ~extensMinor_vector();
  void printSelf();
  vector * get_offset();
  void set_offset(vector * offsetIn);
private:
  vector * offset;
};

/********************************************************************/

/* extensMinor_VEC

This is a derived class for one of the definitions of extensMinor.
It represents the following items:

VEC ',' vector ',' rentVal

*/

class extensMinor_VEC :
  public extensMinor
{
public:
  extensMinor_VEC();
  extensMinor_VEC(
    vector * perpIn,
    rentVal * lengthIn);
  ~extensMinor_VEC();
  void printSelf();
  vector * get_perp();
  void set_perp(vector * perpIn);
  rentVal * get_length();
  void set_length(rentVal * lengthIn);
private:
  vector * perp;
  rentVal * length;
};

/********************************************************************/

/* extfilStm

This is a class for the single definition of extfilStm.
It represents the following items:

EXTFIL '/' extfilMinor #

*/

class extfilStm :
  public dmisStatement
{
public:
  extfilStm();
  extfilStm(
    extfilMinor * extfilMinorIn);
  ~extfilStm();
  void printSelf();
  extfilMinor * get_extfilMinor();
  void set_extfilMinor(extfilMinor * extfilMinorIn);
private:
  extfilMinor * a_extfilMinor;
};

/********************************************************************/

/* extfilMinor

This is a parent class.

*/

class extfilMinor :
  public dmisCppBase
{
public:
  extfilMinor();
  ~extfilMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* extfilDmis

This is a class for the single definition of extfilDmis.
It represents the following items:

DMIS ',' stringVal

*/

class extfilDmis :
  public extfilMinor
{
public:
  extfilDmis();
  extfilDmis(
    stringVal * filenameIn);
  ~extfilDmis();
  void printSelf();
  stringVal * get_filename();
  void set_filename(stringVal * filenameIn);
private:
  stringVal * filename;
};

/********************************************************************/

/* extfilDme

This is a class for the single definition of extfilDme.
It represents the following items:

DME ',' stringVal

*/

class extfilDme :
  public extfilMinor
{
public:
  extfilDme();
  extfilDme(
    stringVal * filenameIn);
  ~extfilDme();
  void printSelf();
  stringVal * get_filename();
  void set_filename(stringVal * filenameIn);
private:
  stringVal * filename;
};

/********************************************************************/

/* featArc1Stm

This is a parent class.

*/

class featArc1Stm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featArc1Stm();
  ~featArc1Stm();
  void printSelf() = 0;
};

/********************************************************************/

/* featArc1Nom

This is a derived class for one of the definitions of featArc1Stm.
It represents the following items:

fLabel '=' FEAT '/' featMinorArc1 #

*/

class featArc1Nom :
  public featArc1Stm
{
public:
  featArc1Nom();
  featArc1Nom(
    fLabel * fLabelIn,
    featMinorArc1 * featMinorArc1In);
  ~featArc1Nom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorArc1 * get_featMinorArc1();
  void set_featMinorArc1(featMinorArc1 * featMinorArc1In);
private:
  fLabel * a_fLabel;
  featMinorArc1 * a_featMinorArc1;
};

/********************************************************************/

/* featArc1Act

This is a derived class for one of the definitions of featArc1Stm.
It represents the following items:

faLabel '=' FEAT '/' featMinorArc1 #

*/

class featArc1Act :
  public featArc1Stm
{
public:
  featArc1Act();
  featArc1Act(
    faLabel * faLabelIn,
    featMinorArc1 * featMinorArc1In);
  ~featArc1Act();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorArc1 * get_featMinorArc1();
  void set_featMinorArc1(featMinorArc1 * featMinorArc1In);
private:
  faLabel * a_faLabel;
  featMinorArc1 * a_featMinorArc1;
};

/********************************************************************/

/* featArc2Stm

This is a parent class.

*/

class featArc2Stm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featArc2Stm();
  ~featArc2Stm();
  void printSelf() = 0;
};

/********************************************************************/

/* featArc2Nom

This is a derived class for one of the definitions of featArc2Stm.
It represents the following items:

fLabel '=' FEAT '/' featMinorArc2 #

*/

class featArc2Nom :
  public featArc2Stm
{
public:
  featArc2Nom();
  featArc2Nom(
    fLabel * fLabelIn,
    featMinorArc2 * featMinorArc2In);
  ~featArc2Nom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorArc2 * get_featMinorArc2();
  void set_featMinorArc2(featMinorArc2 * featMinorArc2In);
private:
  fLabel * a_fLabel;
  featMinorArc2 * a_featMinorArc2;
};

/********************************************************************/

/* featArc2Act

This is a derived class for one of the definitions of featArc2Stm.
It represents the following items:

faLabel '=' FEAT '/' featMinorArc2 #

*/

class featArc2Act :
  public featArc2Stm
{
public:
  featArc2Act();
  featArc2Act(
    faLabel * faLabelIn,
    featMinorArc2 * featMinorArc2In);
  ~featArc2Act();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorArc2 * get_featMinorArc2();
  void set_featMinorArc2(featMinorArc2 * featMinorArc2In);
private:
  faLabel * a_faLabel;
  featMinorArc2 * a_featMinorArc2;
};

/********************************************************************/

/* featCircleStm

This is a parent class.

*/

class featCircleStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featCircleStm();
  ~featCircleStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featCircleNom

This is a derived class for one of the definitions of featCircleStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorCircle #

*/

class featCircleNom :
  public featCircleStm
{
public:
  featCircleNom();
  featCircleNom(
    fLabel * fLabelIn,
    featMinorCircle * featMinorCircleIn);
  ~featCircleNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorCircle * get_featMinorCircle();
  void set_featMinorCircle(featMinorCircle * featMinorCircleIn);
private:
  fLabel * a_fLabel;
  featMinorCircle * a_featMinorCircle;
};

/********************************************************************/

/* featCircleAct

This is a derived class for one of the definitions of featCircleStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorCircle #

*/

class featCircleAct :
  public featCircleStm
{
public:
  featCircleAct();
  featCircleAct(
    faLabel * faLabelIn,
    featMinorCircle * featMinorCircleIn);
  ~featCircleAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorCircle * get_featMinorCircle();
  void set_featMinorCircle(featMinorCircle * featMinorCircleIn);
private:
  faLabel * a_faLabel;
  featMinorCircle * a_featMinorCircle;
};

/********************************************************************/

/* featCompoundStm

This is a class for the single definition of featCompoundStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorCompound #

*/

class featCompoundStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featCompoundStm();
  featCompoundStm(
    fLabel * fLabelIn,
    featMinorCompound * featMinorCompoundIn);
  ~featCompoundStm();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorCompound * get_featMinorCompound();
  void set_featMinorCompound(featMinorCompound * featMinorCompoundIn);
private:
  fLabel * a_fLabel;
  featMinorCompound * a_featMinorCompound;
};

/********************************************************************/

/* featConeStm

This is a parent class.

*/

class featConeStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featConeStm();
  ~featConeStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featConeNom

This is a derived class for one of the definitions of featConeStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorCone #

*/

class featConeNom :
  public featConeStm
{
public:
  featConeNom();
  featConeNom(
    fLabel * fLabelIn,
    featMinorCone * featMinorConeIn);
  ~featConeNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorCone * get_featMinorCone();
  void set_featMinorCone(featMinorCone * featMinorConeIn);
private:
  fLabel * a_fLabel;
  featMinorCone * a_featMinorCone;
};

/********************************************************************/

/* featConeAct

This is a derived class for one of the definitions of featConeStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorCone #

*/

class featConeAct :
  public featConeStm
{
public:
  featConeAct();
  featConeAct(
    faLabel * faLabelIn,
    featMinorCone * featMinorConeIn);
  ~featConeAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorCone * get_featMinorCone();
  void set_featMinorCone(featMinorCone * featMinorConeIn);
private:
  faLabel * a_faLabel;
  featMinorCone * a_featMinorCone;
};

/********************************************************************/

/* featConradsegStm

This is a parent class.

*/

class featConradsegStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featConradsegStm();
  ~featConradsegStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featConradsegNom

This is a derived class for one of the definitions of featConradsegStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorConradseg #

*/

class featConradsegNom :
  public featConradsegStm
{
public:
  featConradsegNom();
  featConradsegNom(
    fLabel * fLabelIn,
    featMinorConradseg * featMinorConradsegIn);
  ~featConradsegNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorConradseg * get_featMinorConradseg();
  void set_featMinorConradseg(featMinorConradseg * featMinorConradsegIn);
private:
  fLabel * a_fLabel;
  featMinorConradseg * a_featMinorConradseg;
};

/********************************************************************/

/* featConradsegAct

This is a derived class for one of the definitions of featConradsegStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorConradseg #

*/

class featConradsegAct :
  public featConradsegStm
{
public:
  featConradsegAct();
  featConradsegAct(
    faLabel * faLabelIn,
    featMinorConradseg * featMinorConradsegIn);
  ~featConradsegAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorConradseg * get_featMinorConradseg();
  void set_featMinorConradseg(featMinorConradseg * featMinorConradsegIn);
private:
  faLabel * a_faLabel;
  featMinorConradseg * a_featMinorConradseg;
};

/********************************************************************/

/* featCparlnStm

This is a parent class.

*/

class featCparlnStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featCparlnStm();
  ~featCparlnStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featCparlnNom

This is a derived class for one of the definitions of featCparlnStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorCparln #

*/

class featCparlnNom :
  public featCparlnStm
{
public:
  featCparlnNom();
  featCparlnNom(
    fLabel * fLabelIn,
    featMinorCparln * featMinorCparlnIn);
  ~featCparlnNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorCparln * get_featMinorCparln();
  void set_featMinorCparln(featMinorCparln * featMinorCparlnIn);
private:
  fLabel * a_fLabel;
  featMinorCparln * a_featMinorCparln;
};

/********************************************************************/

/* featCparlnAct

This is a derived class for one of the definitions of featCparlnStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorCparln #

*/

class featCparlnAct :
  public featCparlnStm
{
public:
  featCparlnAct();
  featCparlnAct(
    faLabel * faLabelIn,
    featMinorCparln * featMinorCparlnIn);
  ~featCparlnAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorCparln * get_featMinorCparln();
  void set_featMinorCparln(featMinorCparln * featMinorCparlnIn);
private:
  faLabel * a_faLabel;
  featMinorCparln * a_featMinorCparln;
};

/********************************************************************/

/* featCylndrStm

This is a parent class.

*/

class featCylndrStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featCylndrStm();
  ~featCylndrStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featCylndrNom

This is a derived class for one of the definitions of featCylndrStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorCylndr #

*/

class featCylndrNom :
  public featCylndrStm
{
public:
  featCylndrNom();
  featCylndrNom(
    fLabel * fLabelIn,
    featMinorCylndr * featMinorCylndrIn);
  ~featCylndrNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorCylndr * get_featMinorCylndr();
  void set_featMinorCylndr(featMinorCylndr * featMinorCylndrIn);
private:
  fLabel * a_fLabel;
  featMinorCylndr * a_featMinorCylndr;
};

/********************************************************************/

/* featCylndrAct

This is a derived class for one of the definitions of featCylndrStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorCylndr #

*/

class featCylndrAct :
  public featCylndrStm
{
public:
  featCylndrAct();
  featCylndrAct(
    faLabel * faLabelIn,
    featMinorCylndr * featMinorCylndrIn);
  ~featCylndrAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorCylndr * get_featMinorCylndr();
  void set_featMinorCylndr(featMinorCylndr * featMinorCylndrIn);
private:
  faLabel * a_faLabel;
  featMinorCylndr * a_featMinorCylndr;
};

/********************************************************************/

/* featCylradsegStm

This is a parent class.

*/

class featCylradsegStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featCylradsegStm();
  ~featCylradsegStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featCylradsegNom

This is a derived class for one of the definitions of featCylradsegStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorCylradseg #

*/

class featCylradsegNom :
  public featCylradsegStm
{
public:
  featCylradsegNom();
  featCylradsegNom(
    fLabel * fLabelIn,
    featMinorCylradseg * featMinorCylradsegIn);
  ~featCylradsegNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorCylradseg * get_featMinorCylradseg();
  void set_featMinorCylradseg(featMinorCylradseg * featMinorCylradsegIn);
private:
  fLabel * a_fLabel;
  featMinorCylradseg * a_featMinorCylradseg;
};

/********************************************************************/

/* featCylradsegAct

This is a derived class for one of the definitions of featCylradsegStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorCylradseg #

*/

class featCylradsegAct :
  public featCylradsegStm
{
public:
  featCylradsegAct();
  featCylradsegAct(
    faLabel * faLabelIn,
    featMinorCylradseg * featMinorCylradsegIn);
  ~featCylradsegAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorCylradseg * get_featMinorCylradseg();
  void set_featMinorCylradseg(featMinorCylradseg * featMinorCylradsegIn);
private:
  faLabel * a_faLabel;
  featMinorCylradseg * a_featMinorCylradseg;
};

/********************************************************************/

/* featEdgeptStm

This is a parent class.

*/

class featEdgeptStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featEdgeptStm();
  ~featEdgeptStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featEdgeptNom

This is a derived class for one of the definitions of featEdgeptStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorEdgept #

*/

class featEdgeptNom :
  public featEdgeptStm
{
public:
  featEdgeptNom();
  featEdgeptNom(
    fLabel * fLabelIn,
    featMinorEdgept * featMinorEdgeptIn);
  ~featEdgeptNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorEdgept * get_featMinorEdgept();
  void set_featMinorEdgept(featMinorEdgept * featMinorEdgeptIn);
private:
  fLabel * a_fLabel;
  featMinorEdgept * a_featMinorEdgept;
};

/********************************************************************/

/* featEdgeptAct

This is a derived class for one of the definitions of featEdgeptStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorEdgept #

*/

class featEdgeptAct :
  public featEdgeptStm
{
public:
  featEdgeptAct();
  featEdgeptAct(
    faLabel * faLabelIn,
    featMinorEdgept * featMinorEdgeptIn);
  ~featEdgeptAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorEdgept * get_featMinorEdgept();
  void set_featMinorEdgept(featMinorEdgept * featMinorEdgeptIn);
private:
  faLabel * a_faLabel;
  featMinorEdgept * a_featMinorEdgept;
};

/********************************************************************/

/* featEllipsStm

This is a parent class.

*/

class featEllipsStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featEllipsStm();
  ~featEllipsStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featEllipsNom

This is a derived class for one of the definitions of featEllipsStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorEllips #

*/

class featEllipsNom :
  public featEllipsStm
{
public:
  featEllipsNom();
  featEllipsNom(
    fLabel * fLabelIn,
    featMinorEllips * featMinorEllipsIn);
  ~featEllipsNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorEllips * get_featMinorEllips();
  void set_featMinorEllips(featMinorEllips * featMinorEllipsIn);
private:
  fLabel * a_fLabel;
  featMinorEllips * a_featMinorEllips;
};

/********************************************************************/

/* featEllipsAct

This is a derived class for one of the definitions of featEllipsStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorEllips #

*/

class featEllipsAct :
  public featEllipsStm
{
public:
  featEllipsAct();
  featEllipsAct(
    faLabel * faLabelIn,
    featMinorEllips * featMinorEllipsIn);
  ~featEllipsAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorEllips * get_featMinorEllips();
  void set_featMinorEllips(featMinorEllips * featMinorEllipsIn);
private:
  faLabel * a_faLabel;
  featMinorEllips * a_featMinorEllips;
};

/********************************************************************/

/* featElongcylStm

This is a parent class.

*/

class featElongcylStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featElongcylStm();
  ~featElongcylStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featElongcylNom

This is a derived class for one of the definitions of featElongcylStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorElongcyl #

*/

class featElongcylNom :
  public featElongcylStm
{
public:
  featElongcylNom();
  featElongcylNom(
    fLabel * fLabelIn,
    featMinorElongcyl * featMinorElongcylIn);
  ~featElongcylNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorElongcyl * get_featMinorElongcyl();
  void set_featMinorElongcyl(featMinorElongcyl * featMinorElongcylIn);
private:
  fLabel * a_fLabel;
  featMinorElongcyl * a_featMinorElongcyl;
};

/********************************************************************/

/* featElongcylAct

This is a derived class for one of the definitions of featElongcylStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorElongcyl #

*/

class featElongcylAct :
  public featElongcylStm
{
public:
  featElongcylAct();
  featElongcylAct(
    faLabel * faLabelIn,
    featMinorElongcyl * featMinorElongcylIn);
  ~featElongcylAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorElongcyl * get_featMinorElongcyl();
  void set_featMinorElongcyl(featMinorElongcyl * featMinorElongcylIn);
private:
  faLabel * a_faLabel;
  featMinorElongcyl * a_featMinorElongcyl;
};

/********************************************************************/

/* featGcurveStm

This is a class for the single definition of featGcurveStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorGcurve #

*/

class featGcurveStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featGcurveStm();
  featGcurveStm(
    fLabel * fLabelIn,
    featMinorGcurve * featMinorGcurveIn);
  ~featGcurveStm();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorGcurve * get_featMinorGcurve();
  void set_featMinorGcurve(featMinorGcurve * featMinorGcurveIn);
private:
  fLabel * a_fLabel;
  featMinorGcurve * a_featMinorGcurve;
};

/********************************************************************/

/* featGeomStm

This is a class for the single definition of featGeomStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorGeom #

*/

class featGeomStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featGeomStm();
  featGeomStm(
    fLabel * fLabelIn,
    featMinorGeom * featMinorGeomIn);
  ~featGeomStm();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorGeom * get_featMinorGeom();
  void set_featMinorGeom(featMinorGeom * featMinorGeomIn);
private:
  fLabel * a_fLabel;
  featMinorGeom * a_featMinorGeom;
};

/********************************************************************/

/* featGsurfStm

This is a class for the single definition of featGsurfStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorGsurf #

*/

class featGsurfStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featGsurfStm();
  featGsurfStm(
    fLabel * fLabelIn,
    featMinorGsurf * featMinorGsurfIn);
  ~featGsurfStm();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorGsurf * get_featMinorGsurf();
  void set_featMinorGsurf(featMinorGsurf * featMinorGsurfIn);
private:
  fLabel * a_fLabel;
  featMinorGsurf * a_featMinorGsurf;
};

/********************************************************************/

/* featLineStm

This is a parent class.

*/

class featLineStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featLineStm();
  ~featLineStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featLineNom

This is a derived class for one of the definitions of featLineStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorLine #

*/

class featLineNom :
  public featLineStm
{
public:
  featLineNom();
  featLineNom(
    fLabel * fLabelIn,
    featMinorLine * featMinorLineIn);
  ~featLineNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorLine * get_featMinorLine();
  void set_featMinorLine(featMinorLine * featMinorLineIn);
private:
  fLabel * a_fLabel;
  featMinorLine * a_featMinorLine;
};

/********************************************************************/

/* featLineAct

This is a derived class for one of the definitions of featLineStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorLine #

*/

class featLineAct :
  public featLineStm
{
public:
  featLineAct();
  featLineAct(
    faLabel * faLabelIn,
    featMinorLine * featMinorLineIn);
  ~featLineAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorLine * get_featMinorLine();
  void set_featMinorLine(featMinorLine * featMinorLineIn);
private:
  faLabel * a_faLabel;
  featMinorLine * a_featMinorLine;
};

/********************************************************************/

/* featObjectStm

This is a parent class.

*/

class featObjectStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featObjectStm();
  ~featObjectStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featObjectNom

This is a derived class for one of the definitions of featObjectStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorObject #

*/

class featObjectNom :
  public featObjectStm
{
public:
  featObjectNom();
  featObjectNom(
    fLabel * fLabelIn,
    featMinorObject * featMinorObjectIn);
  ~featObjectNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorObject * get_featMinorObject();
  void set_featMinorObject(featMinorObject * featMinorObjectIn);
private:
  fLabel * a_fLabel;
  featMinorObject * a_featMinorObject;
};

/********************************************************************/

/* featObjectAct

This is a derived class for one of the definitions of featObjectStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorObject #

*/

class featObjectAct :
  public featObjectStm
{
public:
  featObjectAct();
  featObjectAct(
    faLabel * faLabelIn,
    featMinorObject * featMinorObjectIn);
  ~featObjectAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorObject * get_featMinorObject();
  void set_featMinorObject(featMinorObject * featMinorObjectIn);
private:
  faLabel * a_faLabel;
  featMinorObject * a_featMinorObject;
};

/********************************************************************/

/* featParplnStm

This is a parent class.

*/

class featParplnStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featParplnStm();
  ~featParplnStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featParplnNom

This is a derived class for one of the definitions of featParplnStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorParpln #

*/

class featParplnNom :
  public featParplnStm
{
public:
  featParplnNom();
  featParplnNom(
    fLabel * fLabelIn,
    featMinorParpln * featMinorParplnIn);
  ~featParplnNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorParpln * get_featMinorParpln();
  void set_featMinorParpln(featMinorParpln * featMinorParplnIn);
private:
  fLabel * a_fLabel;
  featMinorParpln * a_featMinorParpln;
};

/********************************************************************/

/* featParplnAct

This is a derived class for one of the definitions of featParplnStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorParpln #

*/

class featParplnAct :
  public featParplnStm
{
public:
  featParplnAct();
  featParplnAct(
    faLabel * faLabelIn,
    featMinorParpln * featMinorParplnIn);
  ~featParplnAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorParpln * get_featMinorParpln();
  void set_featMinorParpln(featMinorParpln * featMinorParplnIn);
private:
  faLabel * a_faLabel;
  featMinorParpln * a_featMinorParpln;
};

/********************************************************************/

/* featPaternStm

This is a class for the single definition of featPaternStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorPatern #

*/

class featPaternStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featPaternStm();
  featPaternStm(
    fLabel * fLabelIn,
    featMinorPatern * featMinorPaternIn);
  ~featPaternStm();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorPatern * get_featMinorPatern();
  void set_featMinorPatern(featMinorPatern * featMinorPaternIn);
private:
  fLabel * a_fLabel;
  featMinorPatern * a_featMinorPatern;
};

/********************************************************************/

/* featPlaneStm

This is a parent class.

*/

class featPlaneStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featPlaneStm();
  ~featPlaneStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featPlaneNom

This is a derived class for one of the definitions of featPlaneStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorPlane #

*/

class featPlaneNom :
  public featPlaneStm
{
public:
  featPlaneNom();
  featPlaneNom(
    fLabel * fLabelIn,
    featMinorPlane * featMinorPlaneIn);
  ~featPlaneNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorPlane * get_featMinorPlane();
  void set_featMinorPlane(featMinorPlane * featMinorPlaneIn);
private:
  fLabel * a_fLabel;
  featMinorPlane * a_featMinorPlane;
};

/********************************************************************/

/* featPlaneAct

This is a derived class for one of the definitions of featPlaneStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorPlane #

*/

class featPlaneAct :
  public featPlaneStm
{
public:
  featPlaneAct();
  featPlaneAct(
    faLabel * faLabelIn,
    featMinorPlane * featMinorPlaneIn);
  ~featPlaneAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorPlane * get_featMinorPlane();
  void set_featMinorPlane(featMinorPlane * featMinorPlaneIn);
private:
  faLabel * a_faLabel;
  featMinorPlane * a_featMinorPlane;
};

/********************************************************************/

/* featPointStm

This is a parent class.

*/

class featPointStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featPointStm();
  ~featPointStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featPointNom

This is a derived class for one of the definitions of featPointStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorPoint #

*/

class featPointNom :
  public featPointStm
{
public:
  featPointNom();
  featPointNom(
    fLabel * fLabelIn,
    featMinorPoint * featMinorPointIn);
  ~featPointNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorPoint * get_featMinorPoint();
  void set_featMinorPoint(featMinorPoint * featMinorPointIn);
private:
  fLabel * a_fLabel;
  featMinorPoint * a_featMinorPoint;
};

/********************************************************************/

/* featPointAct

This is a derived class for one of the definitions of featPointStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorPoint #

*/

class featPointAct :
  public featPointStm
{
public:
  featPointAct();
  featPointAct(
    faLabel * faLabelIn,
    featMinorPoint * featMinorPointIn);
  ~featPointAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorPoint * get_featMinorPoint();
  void set_featMinorPoint(featMinorPoint * featMinorPointIn);
private:
  faLabel * a_faLabel;
  featMinorPoint * a_featMinorPoint;
};

/********************************************************************/

/* featRctnglStm

This is a parent class.

*/

class featRctnglStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featRctnglStm();
  ~featRctnglStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featRctnglNom

This is a derived class for one of the definitions of featRctnglStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorRctngl #

*/

class featRctnglNom :
  public featRctnglStm
{
public:
  featRctnglNom();
  featRctnglNom(
    fLabel * fLabelIn,
    featMinorRctngl * featMinorRctnglIn);
  ~featRctnglNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorRctngl * get_featMinorRctngl();
  void set_featMinorRctngl(featMinorRctngl * featMinorRctnglIn);
private:
  fLabel * a_fLabel;
  featMinorRctngl * a_featMinorRctngl;
};

/********************************************************************/

/* featRctnglAct

This is a derived class for one of the definitions of featRctnglStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorRctngl #

*/

class featRctnglAct :
  public featRctnglStm
{
public:
  featRctnglAct();
  featRctnglAct(
    faLabel * faLabelIn,
    featMinorRctngl * featMinorRctnglIn);
  ~featRctnglAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorRctngl * get_featMinorRctngl();
  void set_featMinorRctngl(featMinorRctngl * featMinorRctnglIn);
private:
  faLabel * a_faLabel;
  featMinorRctngl * a_featMinorRctngl;
};

/********************************************************************/

/* featRevsurfStm

This is a parent class.

*/

class featRevsurfStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featRevsurfStm();
  ~featRevsurfStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featRevsurfNom

This is a derived class for one of the definitions of featRevsurfStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorRevsurf #

*/

class featRevsurfNom :
  public featRevsurfStm
{
public:
  featRevsurfNom();
  featRevsurfNom(
    fLabel * fLabelIn,
    featMinorRevsurf * featMinorRevsurfIn);
  ~featRevsurfNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorRevsurf * get_featMinorRevsurf();
  void set_featMinorRevsurf(featMinorRevsurf * featMinorRevsurfIn);
private:
  fLabel * a_fLabel;
  featMinorRevsurf * a_featMinorRevsurf;
};

/********************************************************************/

/* featRevsurfAct

This is a derived class for one of the definitions of featRevsurfStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorRevsurf #

*/

class featRevsurfAct :
  public featRevsurfStm
{
public:
  featRevsurfAct();
  featRevsurfAct(
    faLabel * faLabelIn,
    featMinorRevsurf * featMinorRevsurfIn);
  ~featRevsurfAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorRevsurf * get_featMinorRevsurf();
  void set_featMinorRevsurf(featMinorRevsurf * featMinorRevsurfIn);
private:
  faLabel * a_faLabel;
  featMinorRevsurf * a_featMinorRevsurf;
};

/********************************************************************/

/* featSphereStm

This is a parent class.

*/

class featSphereStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featSphereStm();
  ~featSphereStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featSphereNom

This is a derived class for one of the definitions of featSphereStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorSphere #

*/

class featSphereNom :
  public featSphereStm
{
public:
  featSphereNom();
  featSphereNom(
    fLabel * fLabelIn,
    featMinorSphere * featMinorSphereIn);
  ~featSphereNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorSphere * get_featMinorSphere();
  void set_featMinorSphere(featMinorSphere * featMinorSphereIn);
private:
  fLabel * a_fLabel;
  featMinorSphere * a_featMinorSphere;
};

/********************************************************************/

/* featSphereAct

This is a derived class for one of the definitions of featSphereStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorSphere #

*/

class featSphereAct :
  public featSphereStm
{
public:
  featSphereAct();
  featSphereAct(
    faLabel * faLabelIn,
    featMinorSphere * featMinorSphereIn);
  ~featSphereAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorSphere * get_featMinorSphere();
  void set_featMinorSphere(featMinorSphere * featMinorSphereIn);
private:
  faLabel * a_faLabel;
  featMinorSphere * a_featMinorSphere;
};

/********************************************************************/

/* featSphradsegStm

This is a parent class.

*/

class featSphradsegStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featSphradsegStm();
  ~featSphradsegStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featSphradsegNom

This is a derived class for one of the definitions of featSphradsegStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorSphradseg #

*/

class featSphradsegNom :
  public featSphradsegStm
{
public:
  featSphradsegNom();
  featSphradsegNom(
    fLabel * fLabelIn,
    featMinorSphradseg * featMinorSphradsegIn);
  ~featSphradsegNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorSphradseg * get_featMinorSphradseg();
  void set_featMinorSphradseg(featMinorSphradseg * featMinorSphradsegIn);
private:
  fLabel * a_fLabel;
  featMinorSphradseg * a_featMinorSphradseg;
};

/********************************************************************/

/* featSphradsegAct

This is a derived class for one of the definitions of featSphradsegStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorSphradseg #

*/

class featSphradsegAct :
  public featSphradsegStm
{
public:
  featSphradsegAct();
  featSphradsegAct(
    faLabel * faLabelIn,
    featMinorSphradseg * featMinorSphradsegIn);
  ~featSphradsegAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorSphradseg * get_featMinorSphradseg();
  void set_featMinorSphradseg(featMinorSphradseg * featMinorSphradsegIn);
private:
  faLabel * a_faLabel;
  featMinorSphradseg * a_featMinorSphradseg;
};

/********************************************************************/

/* featSymplnStm

This is a parent class.

*/

class featSymplnStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featSymplnStm();
  ~featSymplnStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featSymplnNom

This is a derived class for one of the definitions of featSymplnStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorSympln #

*/

class featSymplnNom :
  public featSymplnStm
{
public:
  featSymplnNom();
  featSymplnNom(
    fLabel * fLabelIn,
    featMinorSympln * featMinorSymplnIn);
  ~featSymplnNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorSympln * get_featMinorSympln();
  void set_featMinorSympln(featMinorSympln * featMinorSymplnIn);
private:
  fLabel * a_fLabel;
  featMinorSympln * a_featMinorSympln;
};

/********************************************************************/

/* featSymplnAct

This is a derived class for one of the definitions of featSymplnStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorSympln #

*/

class featSymplnAct :
  public featSymplnStm
{
public:
  featSymplnAct();
  featSymplnAct(
    faLabel * faLabelIn,
    featMinorSympln * featMinorSymplnIn);
  ~featSymplnAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorSympln * get_featMinorSympln();
  void set_featMinorSympln(featMinorSympln * featMinorSymplnIn);
private:
  faLabel * a_faLabel;
  featMinorSympln * a_featMinorSympln;
};

/********************************************************************/

/* featTorradsegStm

This is a parent class.

*/

class featTorradsegStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featTorradsegStm();
  ~featTorradsegStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featTorradsegNom

This is a derived class for one of the definitions of featTorradsegStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorTorradseg #

*/

class featTorradsegNom :
  public featTorradsegStm
{
public:
  featTorradsegNom();
  featTorradsegNom(
    fLabel * fLabelIn,
    featMinorTorradseg * featMinorTorradsegIn);
  ~featTorradsegNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorTorradseg * get_featMinorTorradseg();
  void set_featMinorTorradseg(featMinorTorradseg * featMinorTorradsegIn);
private:
  fLabel * a_fLabel;
  featMinorTorradseg * a_featMinorTorradseg;
};

/********************************************************************/

/* featTorradsegAct

This is a derived class for one of the definitions of featTorradsegStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorTorradseg #

*/

class featTorradsegAct :
  public featTorradsegStm
{
public:
  featTorradsegAct();
  featTorradsegAct(
    faLabel * faLabelIn,
    featMinorTorradseg * featMinorTorradsegIn);
  ~featTorradsegAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorTorradseg * get_featMinorTorradseg();
  void set_featMinorTorradseg(featMinorTorradseg * featMinorTorradsegIn);
private:
  faLabel * a_faLabel;
  featMinorTorradseg * a_featMinorTorradseg;
};

/********************************************************************/

/* featTorusStm

This is a parent class.

*/

class featTorusStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  featTorusStm();
  ~featTorusStm();
  void printSelf() = 0;
};

/********************************************************************/

/* featTorusNom

This is a derived class for one of the definitions of featTorusStm.
It represents the following items:

fLabel '=' FEAT '/' featMinorTorus #

*/

class featTorusNom :
  public featTorusStm
{
public:
  featTorusNom();
  featTorusNom(
    fLabel * fLabelIn,
    featMinorTorus * featMinorTorusIn);
  ~featTorusNom();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  featMinorTorus * get_featMinorTorus();
  void set_featMinorTorus(featMinorTorus * featMinorTorusIn);
private:
  fLabel * a_fLabel;
  featMinorTorus * a_featMinorTorus;
};

/********************************************************************/

/* featTorusAct

This is a derived class for one of the definitions of featTorusStm.
It represents the following items:

faLabel '=' FEAT '/' featMinorTorus #

*/

class featTorusAct :
  public featTorusStm
{
public:
  featTorusAct();
  featTorusAct(
    faLabel * faLabelIn,
    featMinorTorus * featMinorTorusIn);
  ~featTorusAct();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  featMinorTorus * get_featMinorTorus();
  void set_featMinorTorus(featMinorTorus * featMinorTorusIn);
private:
  faLabel * a_faLabel;
  featMinorTorus * a_featMinorTorus;
};

/********************************************************************/

/* featMinorArc1

This is a class for the single definition of featMinorArc1.
It represents the following items:

ARC ',' matDir ',' typePoint ',' vector ',' rentVal ',' angle ',' angle [',' vector]

*/

class featMinorArc1 :
  public dmisCppBase
{
public:
  featMinorArc1();
  featMinorArc1(
    matDir * matDirIn,
    typePoint * typePointIn,
    vector * planeVecIn,
    rentVal * radiusIn,
    angle * startAngleIn,
    angle * includAngleIn,
    vector * startVecIn);
  ~featMinorArc1();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
  rentVal * get_radius();
  void set_radius(rentVal * radiusIn);
  angle * get_startAngle();
  void set_startAngle(angle * startAngleIn);
  angle * get_includAngle();
  void set_includAngle(angle * includAngleIn);
  vector * get_startVec();
  void set_startVec(vector * startVecIn);
private:
  matDir * a_matDir;
  typePoint * a_typePoint;
  vector * planeVec;
  rentVal * radius;
  angle * startAngle;
  angle * includAngle;
  vector * startVec;
};

/********************************************************************/

/* featMinorArc2

This is a class for the single definition of featMinorArc2.
It represents the following items:

ARC ',' FOURPOINT ',' matDir ',' impCartPoint ',' impCartPoint ',' impCartPoint ',' impCartPoint

*/

class featMinorArc2 :
  public dmisCppBase
{
public:
  featMinorArc2();
  featMinorArc2(
    matDir * matDirIn,
    impCartPoint * end1In,
    impCartPoint * end2In,
    impCartPoint * midPtIn,
    impCartPoint * centerIn);
  ~featMinorArc2();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  impCartPoint * get_end1();
  void set_end1(impCartPoint * end1In);
  impCartPoint * get_end2();
  void set_end2(impCartPoint * end2In);
  impCartPoint * get_midPt();
  void set_midPt(impCartPoint * midPtIn);
  impCartPoint * get_center();
  void set_center(impCartPoint * centerIn);
private:
  matDir * a_matDir;
  impCartPoint * end1;
  impCartPoint * end2;
  impCartPoint * midPt;
  impCartPoint * center;
};

/********************************************************************/

/* featMinorCircle

This is a class for the single definition of featMinorCircle.
It represents the following items:

CIRCLE ',' matDir ',' typePoint ',' vector ',' rentVal

*/

class featMinorCircle :
  public dmisCppBase
{
public:
  featMinorCircle();
  featMinorCircle(
    matDir * matDirIn,
    typePoint * centerIn,
    vector * planeVecIn,
    rentVal * diamIn);
  ~featMinorCircle();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
private:
  matDir * a_matDir;
  typePoint * center;
  vector * planeVec;
  rentVal * diam;
};

/********************************************************************/

/* featMinorCompound

This is a parent class.

*/

class featMinorCompound :
  public dmisCppBase
{
public:
  featMinorCompound();
  ~featMinorCompound();
  void printSelf() = 0;
};

/********************************************************************/

/* featCompoundAxial

This is a derived class for one of the definitions of featMinorCompound.
It represents the following items:

COMPOUND ',' AXIAL ',' typePoint ',' vector ',' fLabel ',' featureNominalList

*/

class featCompoundAxial :
  public featMinorCompound
{
public:
  featCompoundAxial();
  featCompoundAxial(
    typePoint * typePointIn,
    vector * dirIn,
    fLabel * fLabelIn,
    std::list<fLabel *> * featureNominalListIn);
  ~featCompoundAxial();
  void printSelf();
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_dir();
  void set_dir(vector * dirIn);
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  std::list<fLabel *> * get_featureNominalList();
  void set_featureNominalList(std::list<fLabel *> * featureNominalListIn);
private:
  typePoint * a_typePoint;
  vector * dir;
  fLabel * a_fLabel;
  std::list<fLabel *> * a_featureNominalList;
};

/********************************************************************/

/* featCompoundPlane

This is a derived class for one of the definitions of featMinorCompound.
It represents the following items:

COMPOUND ',' PLANE ',' typePoint ',' vector ',' fLabel ',' featureNominalList

*/

class featCompoundPlane :
  public featMinorCompound
{
public:
  featCompoundPlane();
  featCompoundPlane(
    typePoint * typePointIn,
    vector * dirIn,
    fLabel * fLabelIn,
    std::list<fLabel *> * featureNominalListIn);
  ~featCompoundPlane();
  void printSelf();
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_dir();
  void set_dir(vector * dirIn);
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  std::list<fLabel *> * get_featureNominalList();
  void set_featureNominalList(std::list<fLabel *> * featureNominalListIn);
private:
  typePoint * a_typePoint;
  vector * dir;
  fLabel * a_fLabel;
  std::list<fLabel *> * a_featureNominalList;
};

/********************************************************************/

/* featCompoundSphere

This is a derived class for one of the definitions of featMinorCompound.
It represents the following items:

COMPOUND ',' SPHERE ',' typePoint ',' fLabel ',' featureNominalList

*/

class featCompoundSphere :
  public featMinorCompound
{
public:
  featCompoundSphere();
  featCompoundSphere(
    typePoint * typePointIn,
    fLabel * fLabelIn,
    std::list<fLabel *> * featureNominalListIn);
  ~featCompoundSphere();
  void printSelf();
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  std::list<fLabel *> * get_featureNominalList();
  void set_featureNominalList(std::list<fLabel *> * featureNominalListIn);
private:
  typePoint * a_typePoint;
  fLabel * a_fLabel;
  std::list<fLabel *> * a_featureNominalList;
};

/********************************************************************/

/* featMinorCone

This is a class for the single definition of featMinorCone.
It represents the following items:

CONE ',' matDir ',' typePoint ',' vector ',' angle

*/

class featMinorCone :
  public dmisCppBase
{
public:
  featMinorCone();
  featMinorCone(
    matDir * matDirIn,
    typePoint * vertexIn,
    vector * axisIn,
    angle * angIn);
  ~featMinorCone();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_vertex();
  void set_vertex(typePoint * vertexIn);
  vector * get_axis();
  void set_axis(vector * axisIn);
  angle * get_ang();
  void set_ang(angle * angIn);
private:
  matDir * a_matDir;
  typePoint * vertex;
  vector * axis;
  angle * ang;
};

/********************************************************************/

/* featMinorConradseg

This is a parent class.

*/

class featMinorConradseg :
  public dmisCppBase
{
public:
  featMinorConradseg();
  ~featMinorConradseg();
  void printSelf() = 0;
};

/********************************************************************/

/* featConradsegCart

This is a derived class for one of the definitions of featMinorConradseg.
It represents the following items:

CONRADSEGMNT ',' matDir ',' cartPoint ',' impCartPoint ',' rentVal ',' rentVal ',' vector ',' vector

*/

class featConradsegCart :
  public featMinorConradseg
{
public:
  featConradsegCart();
  featConradsegCart(
    matDir * matDirIn,
    cartPoint * axisStartIn,
    impCartPoint * axisEndIn,
    rentVal * startRadIn,
    rentVal * endRadIn,
    vector * longStartIn,
    vector * longEndIn);
  ~featConradsegCart();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  cartPoint * get_axisStart();
  void set_axisStart(cartPoint * axisStartIn);
  impCartPoint * get_axisEnd();
  void set_axisEnd(impCartPoint * axisEndIn);
  rentVal * get_startRad();
  void set_startRad(rentVal * startRadIn);
  rentVal * get_endRad();
  void set_endRad(rentVal * endRadIn);
  vector * get_longStart();
  void set_longStart(vector * longStartIn);
  vector * get_longEnd();
  void set_longEnd(vector * longEndIn);
private:
  matDir * a_matDir;
  cartPoint * axisStart;
  impCartPoint * axisEnd;
  rentVal * startRad;
  rentVal * endRad;
  vector * longStart;
  vector * longEnd;
};

/********************************************************************/

/* featConradsegPol

This is a derived class for one of the definitions of featMinorConradseg.
It represents the following items:

CONRADSEGMNT ',' matDir ',' polPoint ',' impPolPoint ',' rentVal ',' rentVal ',' vector ',' vector

*/

class featConradsegPol :
  public featMinorConradseg
{
public:
  featConradsegPol();
  featConradsegPol(
    matDir * matDirIn,
    polPoint * axisStartIn,
    impPolPoint * axisEndIn,
    rentVal * startRadIn,
    rentVal * endRadIn,
    vector * longStartIn,
    vector * longEndIn);
  ~featConradsegPol();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  polPoint * get_axisStart();
  void set_axisStart(polPoint * axisStartIn);
  impPolPoint * get_axisEnd();
  void set_axisEnd(impPolPoint * axisEndIn);
  rentVal * get_startRad();
  void set_startRad(rentVal * startRadIn);
  rentVal * get_endRad();
  void set_endRad(rentVal * endRadIn);
  vector * get_longStart();
  void set_longStart(vector * longStartIn);
  vector * get_longEnd();
  void set_longEnd(vector * longEndIn);
private:
  matDir * a_matDir;
  polPoint * axisStart;
  impPolPoint * axisEnd;
  rentVal * startRad;
  rentVal * endRad;
  vector * longStart;
  vector * longEnd;
};

/********************************************************************/

/* featMinorCparln

This is a class for the single definition of featMinorCparln.
It represents the following items:

CPARLN ',' matDir ',' flatRoundOpen ',' typePoint ',' vector ',' vector ',' rentVal ',' rentVal

*/

class featMinorCparln :
  public dmisCppBase
{
public:
  featMinorCparln();
  featMinorCparln(
    matDir * matDirIn,
    flatRoundOpen * flatRoundOpenIn,
    typePoint * centerIn,
    vector * surfVecIn,
    vector * lineVecIn,
    rentVal * lenIn,
    rentVal * widthIn);
  ~featMinorCparln();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  flatRoundOpen * get_flatRoundOpen();
  void set_flatRoundOpen(flatRoundOpen * flatRoundOpenIn);
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  vector * get_surfVec();
  void set_surfVec(vector * surfVecIn);
  vector * get_lineVec();
  void set_lineVec(vector * lineVecIn);
  rentVal * get_len();
  void set_len(rentVal * lenIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
private:
  matDir * a_matDir;
  flatRoundOpen * a_flatRoundOpen;
  typePoint * center;
  vector * surfVec;
  vector * lineVec;
  rentVal * len;
  rentVal * width;
};

/********************************************************************/

/* featMinorCylndr

This is a class for the single definition of featMinorCylndr.
It represents the following items:

CYLNDR ',' matDir ',' typePoint ',' vector ',' rentVal [',' rentVal]

*/

class featMinorCylndr :
  public dmisCppBase
{
public:
  featMinorCylndr();
  featMinorCylndr(
    matDir * matDirIn,
    typePoint * axisPointIn,
    vector * axisVecIn,
    rentVal * diamIn,
    rentVal * lenIn);
  ~featMinorCylndr();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_axisPoint();
  void set_axisPoint(typePoint * axisPointIn);
  vector * get_axisVec();
  void set_axisVec(vector * axisVecIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
  rentVal * get_len();
  void set_len(rentVal * lenIn);
private:
  matDir * a_matDir;
  typePoint * axisPoint;
  vector * axisVec;
  rentVal * diam;
  rentVal * len;
};

/********************************************************************/

/* featMinorCylradseg

This is a parent class.

*/

class featMinorCylradseg :
  public dmisCppBase
{
public:
  featMinorCylradseg();
  ~featMinorCylradseg();
  void printSelf() = 0;
};

/********************************************************************/

/* featCylradsegCart

This is a derived class for one of the definitions of featMinorCylradseg.
It represents the following items:

CYLRADSEGMNT ',' matDir ',' cartPoint ',' impCartPoint ',' rentVal ',' vector ',' vector

*/

class featCylradsegCart :
  public featMinorCylradseg
{
public:
  featCylradsegCart();
  featCylradsegCart(
    matDir * matDirIn,
    cartPoint * axisStartIn,
    impCartPoint * axisEndIn,
    rentVal * radIn,
    vector * longStartIn,
    vector * longEndIn);
  ~featCylradsegCart();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  cartPoint * get_axisStart();
  void set_axisStart(cartPoint * axisStartIn);
  impCartPoint * get_axisEnd();
  void set_axisEnd(impCartPoint * axisEndIn);
  rentVal * get_rad();
  void set_rad(rentVal * radIn);
  vector * get_longStart();
  void set_longStart(vector * longStartIn);
  vector * get_longEnd();
  void set_longEnd(vector * longEndIn);
private:
  matDir * a_matDir;
  cartPoint * axisStart;
  impCartPoint * axisEnd;
  rentVal * rad;
  vector * longStart;
  vector * longEnd;
};

/********************************************************************/

/* featCylradsegPol

This is a derived class for one of the definitions of featMinorCylradseg.
It represents the following items:

CYLRADSEGMNT ',' matDir ',' polPoint ',' impPolPoint ',' rentVal ',' vector ',' vector

*/

class featCylradsegPol :
  public featMinorCylradseg
{
public:
  featCylradsegPol();
  featCylradsegPol(
    matDir * matDirIn,
    polPoint * axisStartIn,
    impPolPoint * axisEndIn,
    rentVal * radIn,
    vector * longStartIn,
    vector * longEndIn);
  ~featCylradsegPol();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  polPoint * get_axisStart();
  void set_axisStart(polPoint * axisStartIn);
  impPolPoint * get_axisEnd();
  void set_axisEnd(impPolPoint * axisEndIn);
  rentVal * get_rad();
  void set_rad(rentVal * radIn);
  vector * get_longStart();
  void set_longStart(vector * longStartIn);
  vector * get_longEnd();
  void set_longEnd(vector * longEndIn);
private:
  matDir * a_matDir;
  polPoint * axisStart;
  impPolPoint * axisEnd;
  rentVal * rad;
  vector * longStart;
  vector * longEnd;
};

/********************************************************************/

/* featMinorEdgept

This is a class for the single definition of featMinorEdgept.
It represents the following items:

EDGEPT ',' typePoint ',' vector ',' vector

*/

class featMinorEdgept :
  public dmisCppBase
{
public:
  featMinorEdgept();
  featMinorEdgept(
    typePoint * typePointIn,
    vector * edgeNormIn,
    vector * surfNormIn);
  ~featMinorEdgept();
  void printSelf();
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_edgeNorm();
  void set_edgeNorm(vector * edgeNormIn);
  vector * get_surfNorm();
  void set_surfNorm(vector * surfNormIn);
private:
  typePoint * a_typePoint;
  vector * edgeNorm;
  vector * surfNorm;
};

/********************************************************************/

/* featMinorEllips

This is a parent class.

*/

class featMinorEllips :
  public dmisCppBase
{
public:
  featMinorEllips();
  ~featMinorEllips();
  void printSelf() = 0;
};

/********************************************************************/

/* featEllipsCart

This is a derived class for one of the definitions of featMinorEllips.
It represents the following items:

ELLIPS ',' matDir ',' cartPoint ',' impCartPoint ',' radiusSpec ',' vector ',' rentVal

*/

class featEllipsCart :
  public featMinorEllips
{
public:
  featEllipsCart();
  featEllipsCart(
    matDir * matDirIn,
    cartPoint * focus1In,
    impCartPoint * focus2In,
    radiusSpec * radiusSpecIn,
    vector * planeVecIn,
    rentVal * diamIn);
  ~featEllipsCart();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  cartPoint * get_focus1();
  void set_focus1(cartPoint * focus1In);
  impCartPoint * get_focus2();
  void set_focus2(impCartPoint * focus2In);
  radiusSpec * get_radiusSpec();
  void set_radiusSpec(radiusSpec * radiusSpecIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
private:
  matDir * a_matDir;
  cartPoint * focus1;
  impCartPoint * focus2;
  radiusSpec * a_radiusSpec;
  vector * planeVec;
  rentVal * diam;
};

/********************************************************************/

/* featEllipsPol

This is a derived class for one of the definitions of featMinorEllips.
It represents the following items:

ELLIPS ',' matDir ',' polPoint ',' impPolPoint ',' radiusSpec ',' vector ',' rentVal

*/

class featEllipsPol :
  public featMinorEllips
{
public:
  featEllipsPol();
  featEllipsPol(
    matDir * matDirIn,
    polPoint * focus1In,
    impPolPoint * focus2In,
    radiusSpec * radiusSpecIn,
    vector * planeVecIn,
    rentVal * diamIn);
  ~featEllipsPol();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  polPoint * get_focus1();
  void set_focus1(polPoint * focus1In);
  impPolPoint * get_focus2();
  void set_focus2(impPolPoint * focus2In);
  radiusSpec * get_radiusSpec();
  void set_radiusSpec(radiusSpec * radiusSpecIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
private:
  matDir * a_matDir;
  polPoint * focus1;
  impPolPoint * focus2;
  radiusSpec * a_radiusSpec;
  vector * planeVec;
  rentVal * diam;
};

/********************************************************************/

/* featMinorElongcyl

This is a class for the single definition of featMinorElongcyl.
It represents the following items:

ELONGCYL ',' matDir ',' typePoint ',' vector ',' vector ',' rentVal ',' rentVal [',' rentVal]

*/

class featMinorElongcyl :
  public dmisCppBase
{
public:
  featMinorElongcyl();
  featMinorElongcyl(
    matDir * matDirIn,
    typePoint * planePtIn,
    vector * planeVecIn,
    vector * axisVecIn,
    rentVal * sizeIn,
    rentVal * radiusIn,
    rentVal * lenIn);
  ~featMinorElongcyl();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_planePt();
  void set_planePt(typePoint * planePtIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
  vector * get_axisVec();
  void set_axisVec(vector * axisVecIn);
  rentVal * get_size();
  void set_size(rentVal * sizeIn);
  rentVal * get_radius();
  void set_radius(rentVal * radiusIn);
  rentVal * get_len();
  void set_len(rentVal * lenIn);
private:
  matDir * a_matDir;
  typePoint * planePt;
  vector * planeVec;
  vector * axisVec;
  rentVal * size;
  rentVal * radius;
  rentVal * len;
};

/********************************************************************/

/* featMinorGeom

This is a class for the single definition of featMinorGeom.
It represents the following items:

GEOM ',' gLabel ',' coordType

*/

class featMinorGeom :
  public dmisCppBase
{
public:
  featMinorGeom();
  featMinorGeom(
    gLabel * gLabelIn,
    coordType * coordTypeIn);
  ~featMinorGeom();
  void printSelf();
  gLabel * get_gLabel();
  void set_gLabel(gLabel * gLabelIn);
  coordType * get_coordType();
  void set_coordType(coordType * coordTypeIn);
private:
  gLabel * a_gLabel;
  coordType * a_coordType;
};

/********************************************************************/

/* featMinorGcurve

This is a parent class.

*/

class featMinorGcurve :
  public dmisCppBase
{
public:
  featMinorGcurve();
  ~featMinorGcurve();
  void printSelf() = 0;
};

/********************************************************************/

/* featGcurveCart

This is a derived class for one of the definitions of featMinorGcurve.
It represents the following items:

GCURVE ',' CART ',' pointVecCart [',' PTDATA ',' pointVecCart ',' pointVecCartList]

*/

class featGcurveCart :
  public featMinorGcurve
{
public:
  featGcurveCart();
  featGcurveCart(
    pointVecCart * planeDataIn,
    pointVecCart * curveData1In,
    std::list<pointVecCart *> * curveDataRestIn);
  ~featGcurveCart();
  void printSelf();
  pointVecCart * get_planeData();
  void set_planeData(pointVecCart * planeDataIn);
  pointVecCart * get_curveData1();
  void set_curveData1(pointVecCart * curveData1In);
  std::list<pointVecCart *> * get_curveDataRest();
  void set_curveDataRest(std::list<pointVecCart *> * curveDataRestIn);
private:
  pointVecCart * planeData;
  pointVecCart * curveData1;
  std::list<pointVecCart *> * curveDataRest;
};

/********************************************************************/

/* featGcurvePol

This is a derived class for one of the definitions of featMinorGcurve.
It represents the following items:

GCURVE ',' POL ',' pointVecPol [',' PTDATA ',' pointVecPol ',' pointVecPolList]

*/

class featGcurvePol :
  public featMinorGcurve
{
public:
  featGcurvePol();
  featGcurvePol(
    pointVecPol * planeDataIn,
    pointVecPol * curveData1In,
    std::list<pointVecPol *> * curveDataRestIn);
  ~featGcurvePol();
  void printSelf();
  pointVecPol * get_planeData();
  void set_planeData(pointVecPol * planeDataIn);
  pointVecPol * get_curveData1();
  void set_curveData1(pointVecPol * curveData1In);
  std::list<pointVecPol *> * get_curveDataRest();
  void set_curveDataRest(std::list<pointVecPol *> * curveDataRestIn);
private:
  pointVecPol * planeData;
  pointVecPol * curveData1;
  std::list<pointVecPol *> * curveDataRest;
};

/********************************************************************/

/* featMinorGsurf

This is a parent class.

*/

class featMinorGsurf :
  public dmisCppBase
{
public:
  featMinorGsurf();
  ~featMinorGsurf();
  void printSelf() = 0;
};

/********************************************************************/

/* featGsurfPlain

This is a derived class for one of the definitions of featMinorGsurf.
It represents the following items:

GSURF

*/

class featGsurfPlain :
  public featMinorGsurf
{
public:
  featGsurfPlain();
  ~featGsurfPlain();
  void printSelf();
};

/********************************************************************/

/* featGsurfCart

This is a derived class for one of the definitions of featMinorGsurf.
It represents the following items:

GSURF ',' CART [',' PTDATA ',' pointVecCart ',' pointVecCart ',' pointVecCartList]

*/

class featGsurfCart :
  public featMinorGsurf
{
public:
  featGsurfCart();
  featGsurfCart(
    pointVecCart * pt1In,
    pointVecCart * pt2In,
    std::list<pointVecCart *> * morePtsIn);
  ~featGsurfCart();
  void printSelf();
  pointVecCart * get_pt1();
  void set_pt1(pointVecCart * pt1In);
  pointVecCart * get_pt2();
  void set_pt2(pointVecCart * pt2In);
  std::list<pointVecCart *> * get_morePts();
  void set_morePts(std::list<pointVecCart *> * morePtsIn);
private:
  pointVecCart * pt1;
  pointVecCart * pt2;
  std::list<pointVecCart *> * morePts;
};

/********************************************************************/

/* featGsurfPol

This is a derived class for one of the definitions of featMinorGsurf.
It represents the following items:

GSURF ',' POL [',' PTDATA ',' pointVecPol ',' pointVecPol ',' pointVecPolList]

*/

class featGsurfPol :
  public featMinorGsurf
{
public:
  featGsurfPol();
  featGsurfPol(
    pointVecPol * pt1In,
    pointVecPol * pt2In,
    std::list<pointVecPol *> * morePtsIn);
  ~featGsurfPol();
  void printSelf();
  pointVecPol * get_pt1();
  void set_pt1(pointVecPol * pt1In);
  pointVecPol * get_pt2();
  void set_pt2(pointVecPol * pt2In);
  std::list<pointVecPol *> * get_morePts();
  void set_morePts(std::list<pointVecPol *> * morePtsIn);
private:
  pointVecPol * pt1;
  pointVecPol * pt2;
  std::list<pointVecPol *> * morePts;
};

/********************************************************************/

/* featMinorLine

This is a parent class.

*/

class featMinorLine :
  public dmisCppBase
{
public:
  featMinorLine();
  ~featMinorLine();
  void printSelf() = 0;
};

/********************************************************************/

/* featLineBndCart

This is a derived class for one of the definitions of featMinorLine.
It represents the following items:

LINE ',' BND ',' cartPoint ',' impCartPoint ',' vector

*/

class featLineBndCart :
  public featMinorLine
{
public:
  featLineBndCart();
  featLineBndCart(
    cartPoint * startIn,
    impCartPoint * endIn,
    vector * planeVecIn);
  ~featLineBndCart();
  void printSelf();
  cartPoint * get_start();
  void set_start(cartPoint * startIn);
  impCartPoint * get_end();
  void set_end(impCartPoint * endIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  cartPoint * start;
  impCartPoint * end;
  vector * planeVec;
};

/********************************************************************/

/* featLineBndPol

This is a derived class for one of the definitions of featMinorLine.
It represents the following items:

LINE ',' BND ',' polPoint ',' impPolPoint ',' vector

*/

class featLineBndPol :
  public featMinorLine
{
public:
  featLineBndPol();
  featLineBndPol(
    polPoint * startIn,
    impPolPoint * endIn,
    vector * planeVecIn);
  ~featLineBndPol();
  void printSelf();
  polPoint * get_start();
  void set_start(polPoint * startIn);
  impPolPoint * get_end();
  void set_end(impPolPoint * endIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  polPoint * start;
  impPolPoint * end;
  vector * planeVec;
};

/********************************************************************/

/* featLineUnbndCart

This is a derived class for one of the definitions of featMinorLine.
It represents the following items:

LINE ',' UNBND ',' cartPoint ',' vector ',' vector

*/

class featLineUnbndCart :
  public featMinorLine
{
public:
  featLineUnbndCart();
  featLineUnbndCart(
    cartPoint * cartPointIn,
    vector * lineVecIn,
    vector * planeVecIn);
  ~featLineUnbndCart();
  void printSelf();
  cartPoint * get_cartPoint();
  void set_cartPoint(cartPoint * cartPointIn);
  vector * get_lineVec();
  void set_lineVec(vector * lineVecIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  cartPoint * a_cartPoint;
  vector * lineVec;
  vector * planeVec;
};

/********************************************************************/

/* featLineUnbndPol

This is a derived class for one of the definitions of featMinorLine.
It represents the following items:

LINE ',' UNBND ',' polPoint ',' vector ',' vector

*/

class featLineUnbndPol :
  public featMinorLine
{
public:
  featLineUnbndPol();
  featLineUnbndPol(
    polPoint * polPointIn,
    vector * lineVecIn,
    vector * planeVecIn);
  ~featLineUnbndPol();
  void printSelf();
  polPoint * get_polPoint();
  void set_polPoint(polPoint * polPointIn);
  vector * get_lineVec();
  void set_lineVec(vector * lineVecIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  polPoint * a_polPoint;
  vector * lineVec;
  vector * planeVec;
};

/********************************************************************/

/* featMinorObject

This is a class for the single definition of featMinorObject.
It represents the following items:

OBJECT ',' paramList

*/

class featMinorObject :
  public dmisCppBase
{
public:
  featMinorObject();
  featMinorObject(
    std::list<param *> * paramListIn);
  ~featMinorObject();
  void printSelf();
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* featMinorParpln

This is a parent class.

*/

class featMinorParpln :
  public dmisCppBase
{
public:
  featMinorParpln();
  ~featMinorParpln();
  void printSelf() = 0;
};

/********************************************************************/

/* featParplnPointsCart

This is a derived class for one of the definitions of featMinorParpln.
It represents the following items:

PARPLN ',' matDir ',' cartPoint ',' pointVecCart ',' pointVecCart ',' rentVal

*/

class featParplnPointsCart :
  public featMinorParpln
{
public:
  featParplnPointsCart();
  featParplnPointsCart(
    matDir * matDirIn,
    cartPoint * centerPtIn,
    pointVecCart * plane1dataIn,
    pointVecCart * plane2dataIn,
    rentVal * widthIn);
  ~featParplnPointsCart();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  cartPoint * get_centerPt();
  void set_centerPt(cartPoint * centerPtIn);
  pointVecCart * get_plane1data();
  void set_plane1data(pointVecCart * plane1dataIn);
  pointVecCart * get_plane2data();
  void set_plane2data(pointVecCart * plane2dataIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
private:
  matDir * a_matDir;
  cartPoint * centerPt;
  pointVecCart * plane1data;
  pointVecCart * plane2data;
  rentVal * width;
};

/********************************************************************/

/* featParplnPointsPol

This is a derived class for one of the definitions of featMinorParpln.
It represents the following items:

PARPLN ',' matDir ',' polPoint ',' pointVecPol ',' pointVecPol ',' rentVal

*/

class featParplnPointsPol :
  public featMinorParpln
{
public:
  featParplnPointsPol();
  featParplnPointsPol(
    matDir * matDirIn,
    polPoint * centerPtIn,
    pointVecPol * plane1dataIn,
    pointVecPol * plane2dataIn,
    rentVal * widthIn);
  ~featParplnPointsPol();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  polPoint * get_centerPt();
  void set_centerPt(polPoint * centerPtIn);
  pointVecPol * get_plane1data();
  void set_plane1data(pointVecPol * plane1dataIn);
  pointVecPol * get_plane2data();
  void set_plane2data(pointVecPol * plane2dataIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
private:
  matDir * a_matDir;
  polPoint * centerPt;
  pointVecPol * plane1data;
  pointVecPol * plane2data;
  rentVal * width;
};

/********************************************************************/

/* featParplnMidplCart

This is a derived class for one of the definitions of featMinorParpln.
It represents the following items:

PARPLN ',' matDir ',' MIDPL ',' cartPoint ',' vector ',' rentVal

*/

class featParplnMidplCart :
  public featMinorParpln
{
public:
  featParplnMidplCart();
  featParplnMidplCart(
    matDir * matDirIn,
    cartPoint * centerPtIn,
    vector * centerVecIn,
    rentVal * widthIn);
  ~featParplnMidplCart();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  cartPoint * get_centerPt();
  void set_centerPt(cartPoint * centerPtIn);
  vector * get_centerVec();
  void set_centerVec(vector * centerVecIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
private:
  matDir * a_matDir;
  cartPoint * centerPt;
  vector * centerVec;
  rentVal * width;
};

/********************************************************************/

/* featParplnMidplPol

This is a derived class for one of the definitions of featMinorParpln.
It represents the following items:

PARPLN ',' matDir ',' MIDPL ',' polPoint ',' vector ',' rentVal

*/

class featParplnMidplPol :
  public featMinorParpln
{
public:
  featParplnMidplPol();
  featParplnMidplPol(
    matDir * matDirIn,
    polPoint * centerPtIn,
    vector * centerVecIn,
    rentVal * widthIn);
  ~featParplnMidplPol();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  polPoint * get_centerPt();
  void set_centerPt(polPoint * centerPtIn);
  vector * get_centerVec();
  void set_centerVec(vector * centerVecIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
private:
  matDir * a_matDir;
  polPoint * centerPt;
  vector * centerVec;
  rentVal * width;
};

/********************************************************************/

/* featMinorPatern

This is a class for the single definition of featMinorPatern.
It represents the following items:

PATERN ',' fLabel ',' featureNominalList

*/

class featMinorPatern :
  public dmisCppBase
{
public:
  featMinorPatern();
  featMinorPatern(
    fLabel * fLabelIn,
    std::list<fLabel *> * featureNominalListIn);
  ~featMinorPatern();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  std::list<fLabel *> * get_featureNominalList();
  void set_featureNominalList(std::list<fLabel *> * featureNominalListIn);
private:
  fLabel * a_fLabel;
  std::list<fLabel *> * a_featureNominalList;
};

/********************************************************************/

/* featMinorPlane

This is a class for the single definition of featMinorPlane.
It represents the following items:

PLANE ',' typePoint ',' vector

*/

class featMinorPlane :
  public dmisCppBase
{
public:
  featMinorPlane();
  featMinorPlane(
    typePoint * typePointIn,
    vector * planeVecIn);
  ~featMinorPlane();
  void printSelf();
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  typePoint * a_typePoint;
  vector * planeVec;
};

/********************************************************************/

/* featMinorPoint

This is a class for the single definition of featMinorPoint.
It represents the following items:

POINT ',' typePoint ',' vector

*/

class featMinorPoint :
  public dmisCppBase
{
public:
  featMinorPoint();
  featMinorPoint(
    typePoint * typePointIn,
    vector * surfNormIn);
  ~featMinorPoint();
  void printSelf();
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_surfNorm();
  void set_surfNorm(vector * surfNormIn);
private:
  typePoint * a_typePoint;
  vector * surfNorm;
};

/********************************************************************/

/* featMinorRctngl

This is a class for the single definition of featMinorRctngl.
It represents the following items:

RCTNGL ',' matDir ',' typePoint ',' vector ',' rentVal ',' vector ',' rentVal ',' vector ',' rentVal

*/

class featMinorRctngl :
  public dmisCppBase
{
public:
  featMinorRctngl();
  featMinorRctngl(
    matDir * matDirIn,
    typePoint * centerIn,
    vector * faceVec1In,
    rentVal * width1In,
    vector * faceVec2In,
    rentVal * width2In,
    vector * faceVec3In,
    rentVal * width3In);
  ~featMinorRctngl();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  vector * get_faceVec1();
  void set_faceVec1(vector * faceVec1In);
  rentVal * get_width1();
  void set_width1(rentVal * width1In);
  vector * get_faceVec2();
  void set_faceVec2(vector * faceVec2In);
  rentVal * get_width2();
  void set_width2(rentVal * width2In);
  vector * get_faceVec3();
  void set_faceVec3(vector * faceVec3In);
  rentVal * get_width3();
  void set_width3(rentVal * width3In);
private:
  matDir * a_matDir;
  typePoint * center;
  vector * faceVec1;
  rentVal * width1;
  vector * faceVec2;
  rentVal * width2;
  vector * faceVec3;
  rentVal * width3;
};

/********************************************************************/

/* featMinorRevsurf

This is a parent class.

*/

class featMinorRevsurf :
  public dmisCppBase
{
public:
  featMinorRevsurf();
  ~featMinorRevsurf();
  void printSelf() = 0;
};

/********************************************************************/

/* featRevsurfCart

This is a derived class for one of the definitions of featMinorRevsurf.
It represents the following items:

REVSURF ',' matDir ',' typePoint ',' vector ',' cartPoint ',' impCartPointList

*/

class featRevsurfCart :
  public featMinorRevsurf
{
public:
  featRevsurfCart();
  featRevsurfCart(
    matDir * matDirIn,
    typePoint * typePointIn,
    vector * axisIn,
    cartPoint * cartPointIn,
    std::list<impCartPoint *> * impCartPointListIn);
  ~featRevsurfCart();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_axis();
  void set_axis(vector * axisIn);
  cartPoint * get_cartPoint();
  void set_cartPoint(cartPoint * cartPointIn);
  std::list<impCartPoint *> * get_impCartPointList();
  void set_impCartPointList(std::list<impCartPoint *> * impCartPointListIn);
private:
  matDir * a_matDir;
  typePoint * a_typePoint;
  vector * axis;
  cartPoint * a_cartPoint;
  std::list<impCartPoint *> * a_impCartPointList;
};

/********************************************************************/

/* featRevsurfPol

This is a derived class for one of the definitions of featMinorRevsurf.
It represents the following items:

REVSURF ',' matDir ',' typePoint ',' vector ',' polPoint ',' impPolPointList

*/

class featRevsurfPol :
  public featMinorRevsurf
{
public:
  featRevsurfPol();
  featRevsurfPol(
    matDir * matDirIn,
    typePoint * typePointIn,
    vector * axisIn,
    polPoint * polPointIn,
    std::list<impPolPoint *> * impPolPointListIn);
  ~featRevsurfPol();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_axis();
  void set_axis(vector * axisIn);
  polPoint * get_polPoint();
  void set_polPoint(polPoint * polPointIn);
  std::list<impPolPoint *> * get_impPolPointList();
  void set_impPolPointList(std::list<impPolPoint *> * impPolPointListIn);
private:
  matDir * a_matDir;
  typePoint * a_typePoint;
  vector * axis;
  polPoint * a_polPoint;
  std::list<impPolPoint *> * a_impPolPointList;
};

/********************************************************************/

/* featMinorSphere

This is a class for the single definition of featMinorSphere.
It represents the following items:

SPHERE ',' matDir ',' typePoint ',' rentVal [',' vector [',' angle]]

*/

class featMinorSphere :
  public dmisCppBase
{
public:
  featMinorSphere();
  featMinorSphere(
    matDir * matDirIn,
    typePoint * centerIn,
    rentVal * diamIn,
    vector * orientIn,
    angle * latIn);
  ~featMinorSphere();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
  vector * get_orient();
  void set_orient(vector * orientIn);
  angle * get_lat();
  void set_lat(angle * latIn);
private:
  matDir * a_matDir;
  typePoint * center;
  rentVal * diam;
  vector * orient;
  angle * lat;
};

/********************************************************************/

/* featMinorSphradseg

This is a class for the single definition of featMinorSphradseg.
It represents the following items:

SPHRADSEGMNT ',' matDir ',' typePoint ',' rentVal ',' vector ',' rentVal ',' rentVal ',' vector ',' rentVal ',' rentVal

*/

class featMinorSphradseg :
  public dmisCppBase
{
public:
  featMinorSphradseg();
  featMinorSphradseg(
    matDir * matDirIn,
    typePoint * centerIn,
    rentVal * diamIn,
    vector * northIn,
    rentVal * latStartIn,
    rentVal * latStopIn,
    vector * primeIn,
    rentVal * longStartIn,
    rentVal * longStopIn);
  ~featMinorSphradseg();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
  vector * get_north();
  void set_north(vector * northIn);
  rentVal * get_latStart();
  void set_latStart(rentVal * latStartIn);
  rentVal * get_latStop();
  void set_latStop(rentVal * latStopIn);
  vector * get_prime();
  void set_prime(vector * primeIn);
  rentVal * get_longStart();
  void set_longStart(rentVal * longStartIn);
  rentVal * get_longStop();
  void set_longStop(rentVal * longStopIn);
private:
  matDir * a_matDir;
  typePoint * center;
  rentVal * diam;
  vector * north;
  rentVal * latStart;
  rentVal * latStop;
  vector * prime;
  rentVal * longStart;
  rentVal * longStop;
};

/********************************************************************/

/* featMinorSympln

This is a parent class.

*/

class featMinorSympln :
  public dmisCppBase
{
public:
  featMinorSympln();
  ~featMinorSympln();
  void printSelf() = 0;
};

/********************************************************************/

/* featSymplnCart

This is a derived class for one of the definitions of featMinorSympln.
It represents the following items:

SYMPLN ',' matDir ',' cartPoint ',' pointVecCart ',' pointVecCart ',' rentVal

*/

class featSymplnCart :
  public featMinorSympln
{
public:
  featSymplnCart();
  featSymplnCart(
    matDir * matDirIn,
    cartPoint * centerPtIn,
    pointVecCart * plane1dataIn,
    pointVecCart * plane2dataIn,
    rentVal * widthIn);
  ~featSymplnCart();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  cartPoint * get_centerPt();
  void set_centerPt(cartPoint * centerPtIn);
  pointVecCart * get_plane1data();
  void set_plane1data(pointVecCart * plane1dataIn);
  pointVecCart * get_plane2data();
  void set_plane2data(pointVecCart * plane2dataIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
private:
  matDir * a_matDir;
  cartPoint * centerPt;
  pointVecCart * plane1data;
  pointVecCart * plane2data;
  rentVal * width;
};

/********************************************************************/

/* featSymplnPol

This is a derived class for one of the definitions of featMinorSympln.
It represents the following items:

SYMPLN ',' matDir ',' polPoint ',' pointVecPol ',' pointVecPol ',' rentVal

*/

class featSymplnPol :
  public featMinorSympln
{
public:
  featSymplnPol();
  featSymplnPol(
    matDir * matDirIn,
    polPoint * centerPtIn,
    pointVecPol * plane1dataIn,
    pointVecPol * plane2dataIn,
    rentVal * widthIn);
  ~featSymplnPol();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  polPoint * get_centerPt();
  void set_centerPt(polPoint * centerPtIn);
  pointVecPol * get_plane1data();
  void set_plane1data(pointVecPol * plane1dataIn);
  pointVecPol * get_plane2data();
  void set_plane2data(pointVecPol * plane2dataIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
private:
  matDir * a_matDir;
  polPoint * centerPt;
  pointVecPol * plane1data;
  pointVecPol * plane2data;
  rentVal * width;
};

/********************************************************************/

/* featMinorTorradseg

This is a class for the single definition of featMinorTorradseg.
It represents the following items:

TORRADSEGMNT ',' matDir ',' typePoint ',' rentVal ',' rentVal ',' vector ',' rentVal ',' rentVal ',' vector ',' rentVal ',' rentVal

*/

class featMinorTorradseg :
  public dmisCppBase
{
public:
  featMinorTorradseg();
  featMinorTorradseg(
    matDir * matDirIn,
    typePoint * centerIn,
    rentVal * majradIn,
    rentVal * minradIn,
    vector * northIn,
    rentVal * latStartIn,
    rentVal * latStopIn,
    vector * primeIn,
    rentVal * longStartIn,
    rentVal * longStopIn);
  ~featMinorTorradseg();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  rentVal * get_majrad();
  void set_majrad(rentVal * majradIn);
  rentVal * get_minrad();
  void set_minrad(rentVal * minradIn);
  vector * get_north();
  void set_north(vector * northIn);
  rentVal * get_latStart();
  void set_latStart(rentVal * latStartIn);
  rentVal * get_latStop();
  void set_latStop(rentVal * latStopIn);
  vector * get_prime();
  void set_prime(vector * primeIn);
  rentVal * get_longStart();
  void set_longStart(rentVal * longStartIn);
  rentVal * get_longStop();
  void set_longStop(rentVal * longStopIn);
private:
  matDir * a_matDir;
  typePoint * center;
  rentVal * majrad;
  rentVal * minrad;
  vector * north;
  rentVal * latStart;
  rentVal * latStop;
  vector * prime;
  rentVal * longStart;
  rentVal * longStop;
};

/********************************************************************/

/* featMinorTorus

This is a class for the single definition of featMinorTorus.
It represents the following items:

TORUS ',' matDir ',' typePoint ',' vector ',' rentVal ',' rentVal

*/

class featMinorTorus :
  public dmisCppBase
{
public:
  featMinorTorus();
  featMinorTorus(
    matDir * matDirIn,
    typePoint * centerIn,
    vector * axisIn,
    rentVal * majorDiamIn,
    rentVal * minorDiamIn);
  ~featMinorTorus();
  void printSelf();
  matDir * get_matDir();
  void set_matDir(matDir * matDirIn);
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  vector * get_axis();
  void set_axis(vector * axisIn);
  rentVal * get_majorDiam();
  void set_majorDiam(rentVal * majorDiamIn);
  rentVal * get_minorDiam();
  void set_minorDiam(rentVal * minorDiamIn);
private:
  matDir * a_matDir;
  typePoint * center;
  vector * axis;
  rentVal * majorDiam;
  rentVal * minorDiam;
};

/********************************************************************/

/* fedratMinor

This is a parent class.

*/

class fedratMinor :
  public dmisCppBase
{
public:
  fedratMinor();
  ~fedratMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* fedratMeas

This is a class for the single definition of fedratMeas.
It represents the following items:

MESVEL ',' fedratLinSpec

*/

class fedratMeas :
  public fedratMinor
{
public:
  fedratMeas();
  fedratMeas(
    fedratLinSpec * fedratLinSpecIn);
  ~fedratMeas();
  void printSelf();
  fedratLinSpec * get_fedratLinSpec();
  void set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn);
private:
  fedratLinSpec * a_fedratLinSpec;
};

/********************************************************************/

/* fedratPos

This is a class for the single definition of fedratPos.
It represents the following items:

POSVEL ',' fedratLinSpec

*/

class fedratPos :
  public fedratMinor
{
public:
  fedratPos();
  fedratPos(
    fedratLinSpec * fedratLinSpecIn);
  ~fedratPos();
  void printSelf();
  fedratLinSpec * get_fedratLinSpec();
  void set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn);
private:
  fedratLinSpec * a_fedratLinSpec;
};

/********************************************************************/

/* fedratRot

This is a class for the single definition of fedratRot.
It represents the following items:

ROTVEL ',' fedratAngSpec

*/

class fedratRot :
  public fedratMinor
{
public:
  fedratRot();
  fedratRot(
    fedratAngSpec * fedratAngSpecIn);
  ~fedratRot();
  void printSelf();
  fedratAngSpec * get_fedratAngSpec();
  void set_fedratAngSpec(fedratAngSpec * fedratAngSpecIn);
private:
  fedratAngSpec * a_fedratAngSpec;
};

/********************************************************************/

/* fedratScan

This is a class for the single definition of fedratScan.
It represents the following items:

SCNVEL ',' fedratLinSpec

*/

class fedratScan :
  public fedratMinor
{
public:
  fedratScan();
  fedratScan(
    fedratLinSpec * fedratLinSpecIn);
  ~fedratScan();
  void printSelf();
  fedratLinSpec * get_fedratLinSpec();
  void set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn);
private:
  fedratLinSpec * a_fedratLinSpec;
};

/********************************************************************/

/* fedratHedRot

This is a class for the single definition of fedratHedRot.
It represents the following items:

HEDROTVEL ',' fedratLinSpec

*/

class fedratHedRot :
  public fedratMinor
{
public:
  fedratHedRot();
  fedratHedRot(
    fedratLinSpec * fedratLinSpecIn);
  ~fedratHedRot();
  void printSelf();
  fedratLinSpec * get_fedratLinSpec();
  void set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn);
private:
  fedratLinSpec * a_fedratLinSpec;
};

/********************************************************************/

/* fedratHedMeas

This is a class for the single definition of fedratHedMeas.
It represents the following items:

HEDMESVEL ',' fedratLinSpec

*/

class fedratHedMeas :
  public fedratMinor
{
public:
  fedratHedMeas();
  fedratHedMeas(
    fedratLinSpec * fedratLinSpecIn);
  ~fedratHedMeas();
  void printSelf();
  fedratLinSpec * get_fedratLinSpec();
  void set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn);
private:
  fedratLinSpec * a_fedratLinSpec;
};

/********************************************************************/

/* fedratHedScan

This is a class for the single definition of fedratHedScan.
It represents the following items:

HEDSCNVEL ',' fedratLinSpec

*/

class fedratHedScan :
  public fedratMinor
{
public:
  fedratHedScan();
  fedratHedScan(
    fedratLinSpec * fedratLinSpecIn);
  ~fedratHedScan();
  void printSelf();
  fedratLinSpec * get_fedratLinSpec();
  void set_fedratLinSpec(fedratLinSpec * fedratLinSpecIn);
private:
  fedratLinSpec * a_fedratLinSpec;
};

/********************************************************************/

/* fedratAngSpec

This is a parent class.

*/

class fedratAngSpec :
  public dmisCppBase
{
public:
  fedratAngSpec();
  ~fedratAngSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* fedratLinSpec

This is a parent class.

*/

class fedratLinSpec :
  public dmisCppBase
{
public:
  fedratLinSpec();
  ~fedratLinSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* fedratLinear

This is a parent class.

*/

class fedratLinear :
  public fedratLinSpec
{
public:
  fedratLinear();
  ~fedratLinear();
  void printSelf() = 0;
};

/********************************************************************/

/* fedratLinear_MPM

This is a derived class for one of the definitions of fedratLinear.
It represents the following items:

MPM ',' rentVal

*/

class fedratLinear_MPM :
  public fedratLinear
{
public:
  fedratLinear_MPM();
  fedratLinear_MPM(
    rentVal * rateIn);
  ~fedratLinear_MPM();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* fedratLinear_MMPS

This is a derived class for one of the definitions of fedratLinear.
It represents the following items:

MMPS ',' rentVal

*/

class fedratLinear_MMPS :
  public fedratLinear
{
public:
  fedratLinear_MMPS();
  fedratLinear_MMPS(
    rentVal * rateIn);
  ~fedratLinear_MMPS();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* fedratLinear_IPM

This is a derived class for one of the definitions of fedratLinear.
It represents the following items:

IPM ',' rentVal

*/

class fedratLinear_IPM :
  public fedratLinear
{
public:
  fedratLinear_IPM();
  fedratLinear_IPM(
    rentVal * rateIn);
  ~fedratLinear_IPM();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* fedratLinear_IPS

This is a derived class for one of the definitions of fedratLinear.
It represents the following items:

IPS ',' rentVal

*/

class fedratLinear_IPS :
  public fedratLinear
{
public:
  fedratLinear_IPS();
  fedratLinear_IPS(
    rentVal * rateIn);
  ~fedratLinear_IPS();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* fedratAngular

This is a class for the single definition of fedratAngular.
It represents the following items:

RPM ',' rentVal

*/

class fedratAngular :
  public fedratAngSpec
{
public:
  fedratAngular();
  fedratAngular(
    rentVal * rateIn);
  ~fedratAngular();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* fedratDef

This is a parent class.

*/

class fedratDef :
  public fedratAngSpec,
  public fedratLinSpec
{
public:
  fedratDef();
  ~fedratDef();
  void printSelf() = 0;
};

/********************************************************************/

/* fedratDef_PCENT

This is a derived class for one of the definitions of fedratDef.
It represents the following items:

PCENT ',' rentVal

*/

class fedratDef_PCENT :
  public fedratDef
{
public:
  fedratDef_PCENT();
  fedratDef_PCENT(
    rentVal * rateIn);
  ~fedratDef_PCENT();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* fedratDef_HIGH

This is a derived class for one of the definitions of fedratDef.
It represents the following items:

HIGH

*/

class fedratDef_HIGH :
  public fedratDef
{
public:
  fedratDef_HIGH();
  ~fedratDef_HIGH();
  void printSelf();
};

/********************************************************************/

/* fedratDef_LOW

This is a derived class for one of the definitions of fedratDef.
It represents the following items:

LOW

*/

class fedratDef_LOW :
  public fedratDef
{
public:
  fedratDef_LOW();
  ~fedratDef_LOW();
  void printSelf();
};

/********************************************************************/

/* fedratDef_DEFALT

This is a derived class for one of the definitions of fedratDef.
It represents the following items:

DEFALT

*/

class fedratDef_DEFALT :
  public fedratDef
{
public:
  fedratDef_DEFALT();
  ~fedratDef_DEFALT();
  void printSelf();
};

/********************************************************************/

/* fildefStm

This is a class for the single definition of fildefStm.
It represents the following items:

vfLabel '=' FILDEF '/' CODE ',' intVal #

*/

class fildefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  fildefStm();
  fildefStm(
    vfLabel * vfLabelIn,
    intVal * codeIn);
  ~fildefStm();
  void printSelf();
  vfLabel * get_vfLabel();
  void set_vfLabel(vfLabel * vfLabelIn);
  intVal * get_code();
  void set_code(intVal * codeIn);
private:
  vfLabel * a_vfLabel;
  intVal * code;
};

/********************************************************************/

/* filnamStm

This is a class for the single definition of filnamStm.
It represents the following items:

FILNAM '/' stringConst ',' versionTag #

*/

class filnamStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  filnamStm();
  filnamStm(
    stringConst * stringConstIn,
    versionTag * versionTagIn);
  ~filnamStm();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
  versionTag * get_versionTag();
  void set_versionTag(versionTag * versionTagIn);
private:
  stringConst * a_stringConst;
  versionTag * a_versionTag;
};

/********************************************************************/

/* fixtidStm

This is a class for the single definition of fixtidStm.
It represents the following items:

fiLabel '=' FIXTID '/' stringVal #

*/

class fixtidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  fixtidStm();
  fixtidStm(
    fiLabel * fiLabelIn,
    stringVal * textIn);
  ~fixtidStm();
  void printSelf();
  fiLabel * get_fiLabel();
  void set_fiLabel(fiLabel * fiLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  fiLabel * a_fiLabel;
  stringVal * text;
};

/********************************************************************/

/* fixtsnStm

This is a class for the single definition of fixtsnStm.
It represents the following items:

fsLabel '=' FIXTSN '/' stringVal #

*/

class fixtsnStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  fixtsnStm();
  fixtsnStm(
    fsLabel * fsLabelIn,
    stringVal * textIn);
  ~fixtsnStm();
  void printSelf();
  fsLabel * get_fsLabel();
  void set_fsLabel(fsLabel * fsLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  fsLabel * a_fsLabel;
  stringVal * text;
};

/********************************************************************/

/* flyStm

This is a class for the single definition of flyStm.
It represents the following items:

FLY '/' flyMinor #

*/

class flyStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  flyStm();
  flyStm(
    flyMinor * flyMinorIn);
  ~flyStm();
  void printSelf();
  flyMinor * get_flyMinor();
  void set_flyMinor(flyMinor * flyMinorIn);
private:
  flyMinor * a_flyMinor;
};

/********************************************************************/

/* flyMinor

This is a parent class.

*/

class flyMinor :
  public dmisCppBase
{
public:
  flyMinor();
  ~flyMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* flyMinor_OFF

This is a derived class for one of the definitions of flyMinor.
It represents the following items:

OFF

*/

class flyMinor_OFF :
  public flyMinor
{
public:
  flyMinor_OFF();
  ~flyMinor_OFF();
  void printSelf();
};

/********************************************************************/

/* flyMinor_rentVal

This is a derived class for one of the definitions of flyMinor.
It represents the following items:

rentVal

*/

class flyMinor_rentVal :
  public flyMinor
{
public:
  flyMinor_rentVal();
  flyMinor_rentVal(
    rentVal * radiusIn);
  ~flyMinor_rentVal();
  void printSelf();
  rentVal * get_radius();
  void set_radius(rentVal * radiusIn);
private:
  rentVal * radius;
};

/********************************************************************/

/* fromMinor

This is a parent class.

*/

class fromMinor :
  public dmisCppBase
{
public:
  fromMinor();
  ~fromMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* fromMinor_cartPoint

This is a derived class for one of the definitions of fromMinor.
It represents the following items:

cartPoint [',' RAM]

*/

class fromMinor_cartPoint :
  public fromMinor
{
public:
  fromMinor_cartPoint();
  fromMinor_cartPoint(
    cartPoint * cartPointIn,
    bool has_RAMIn);
  ~fromMinor_cartPoint();
  void printSelf();
  cartPoint * get_cartPoint();
  void set_cartPoint(cartPoint * cartPointIn);
  bool get_has_RAM();
  void set_has_RAM(bool has_RAMIn);
private:
  cartPoint * a_cartPoint;
  bool has_RAM;
};

/********************************************************************/

/* fromMinor_DME

This is a derived class for one of the definitions of fromMinor.
It represents the following items:

DME

*/

class fromMinor_DME :
  public fromMinor
{
public:
  fromMinor_DME();
  ~fromMinor_DME();
  void printSelf();
};

/********************************************************************/

/* fromMinor_impCartPoint

This is a derived class for one of the definitions of fromMinor.
It represents the following items:

impCartPoint [',' RAM]

*/

class fromMinor_impCartPoint :
  public fromMinor
{
public:
  fromMinor_impCartPoint();
  fromMinor_impCartPoint(
    impCartPoint * impCartPointIn,
    bool has_RAMIn);
  ~fromMinor_impCartPoint();
  void printSelf();
  impCartPoint * get_impCartPoint();
  void set_impCartPoint(impCartPoint * impCartPointIn);
  bool get_has_RAM();
  void set_has_RAM(bool has_RAMIn);
private:
  impCartPoint * a_impCartPoint;
  bool has_RAM;
};

/********************************************************************/

/* fromMinor_polPoint

This is a derived class for one of the definitions of fromMinor.
It represents the following items:

polPoint [',' RAM]

*/

class fromMinor_polPoint :
  public fromMinor
{
public:
  fromMinor_polPoint();
  fromMinor_polPoint(
    polPoint * polPointIn,
    bool has_RAMIn);
  ~fromMinor_polPoint();
  void printSelf();
  polPoint * get_polPoint();
  void set_polPoint(polPoint * polPointIn);
  bool get_has_RAM();
  void set_has_RAM(bool has_RAMIn);
private:
  polPoint * a_polPoint;
  bool has_RAM;
};

/********************************************************************/

/* fromMinor_SCALE

This is a derived class for one of the definitions of fromMinor.
It represents the following items:

SCALE

*/

class fromMinor_SCALE :
  public fromMinor
{
public:
  fromMinor_SCALE();
  ~fromMinor_SCALE();
  void printSelf();
};

/********************************************************************/

/* geoalgStm

This is a class for the single definition of geoalgStm.
It represents the following items:

GEOALG '/' geoalgMinor #

*/

class geoalgStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  geoalgStm();
  geoalgStm(
    geoalgMinor * geoalgMinorIn);
  ~geoalgStm();
  void printSelf();
  geoalgMinor * get_geoalgMinor();
  void set_geoalgMinor(geoalgMinor * geoalgMinorIn);
private:
  geoalgMinor * a_geoalgMinor;
};

/********************************************************************/

/* geoalgMinor

This is a parent class.

*/

class geoalgMinor :
  public dmisCppBase
{
public:
  geoalgMinor();
  ~geoalgMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgArc

This is a class for the single definition of geoalgArc.
It represents the following items:

ARC ',' geoalgSpec1

*/

class geoalgArc :
  public geoalgMinor
{
public:
  geoalgArc();
  geoalgArc(
    geoalgSpec1 * geoalgSpec1In);
  ~geoalgArc();
  void printSelf();
  geoalgSpec1 * get_geoalgSpec1();
  void set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In);
private:
  geoalgSpec1 * a_geoalgSpec1;
};

/********************************************************************/

/* geoalgCircle

This is a class for the single definition of geoalgCircle.
It represents the following items:

CIRCLE ',' geoalgSpec2

*/

class geoalgCircle :
  public geoalgMinor
{
public:
  geoalgCircle();
  geoalgCircle(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgCircle();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgCone

This is a class for the single definition of geoalgCone.
It represents the following items:

CONE ',' geoalgSpec2

*/

class geoalgCone :
  public geoalgMinor
{
public:
  geoalgCone();
  geoalgCone(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgCone();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgConradsegmnt

This is a class for the single definition of geoalgConradsegmnt.
It represents the following items:

CONRADSEGMNT ',' geoalgSpec2

*/

class geoalgConradsegmnt :
  public geoalgMinor
{
public:
  geoalgConradsegmnt();
  geoalgConradsegmnt(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgConradsegmnt();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgCparln

This is a class for the single definition of geoalgCparln.
It represents the following items:

CPARLN ',' geoalgSpec3

*/

class geoalgCparln :
  public geoalgMinor
{
public:
  geoalgCparln();
  geoalgCparln(
    geoalgSpec3 * geoalgSpec3In);
  ~geoalgCparln();
  void printSelf();
  geoalgSpec3 * get_geoalgSpec3();
  void set_geoalgSpec3(geoalgSpec3 * geoalgSpec3In);
private:
  geoalgSpec3 * a_geoalgSpec3;
};

/********************************************************************/

/* geoalgCylndr

This is a class for the single definition of geoalgCylndr.
It represents the following items:

CYLNDR ',' geoalgSpec2

*/

class geoalgCylndr :
  public geoalgMinor
{
public:
  geoalgCylndr();
  geoalgCylndr(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgCylndr();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgCylradsegmnt

This is a class for the single definition of geoalgCylradsegmnt.
It represents the following items:

CYLRADSEGMNT ',' geoalgSpec2

*/

class geoalgCylradsegmnt :
  public geoalgMinor
{
public:
  geoalgCylradsegmnt();
  geoalgCylradsegmnt(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgCylradsegmnt();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgEllips

This is a class for the single definition of geoalgEllips.
It represents the following items:

ELLIPS ',' geoalgSpec1

*/

class geoalgEllips :
  public geoalgMinor
{
public:
  geoalgEllips();
  geoalgEllips(
    geoalgSpec1 * geoalgSpec1In);
  ~geoalgEllips();
  void printSelf();
  geoalgSpec1 * get_geoalgSpec1();
  void set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In);
private:
  geoalgSpec1 * a_geoalgSpec1;
};

/********************************************************************/

/* geoalgElongcyl

This is a class for the single definition of geoalgElongcyl.
It represents the following items:

ELONGCYL ',' geoalgSpec2

*/

class geoalgElongcyl :
  public geoalgMinor
{
public:
  geoalgElongcyl();
  geoalgElongcyl(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgElongcyl();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgGcurve

This is a class for the single definition of geoalgGcurve.
It represents the following items:

GCURVE ',' geoalgSpec4

*/

class geoalgGcurve :
  public geoalgMinor
{
public:
  geoalgGcurve();
  geoalgGcurve(
    geoalgSpec4 * geoalgSpec4In);
  ~geoalgGcurve();
  void printSelf();
  geoalgSpec4 * get_geoalgSpec4();
  void set_geoalgSpec4(geoalgSpec4 * geoalgSpec4In);
private:
  geoalgSpec4 * a_geoalgSpec4;
};

/********************************************************************/

/* geoalgGsurf

This is a class for the single definition of geoalgGsurf.
It represents the following items:

GSURF ',' geoalgSpec5

*/

class geoalgGsurf :
  public geoalgMinor
{
public:
  geoalgGsurf();
  geoalgGsurf(
    geoalgSpec5 * geoalgSpec5In);
  ~geoalgGsurf();
  void printSelf();
  geoalgSpec5 * get_geoalgSpec5();
  void set_geoalgSpec5(geoalgSpec5 * geoalgSpec5In);
private:
  geoalgSpec5 * a_geoalgSpec5;
};

/********************************************************************/

/* geoalgLine

This is a class for the single definition of geoalgLine.
It represents the following items:

LINE ',' geoalgSpec1

*/

class geoalgLine :
  public geoalgMinor
{
public:
  geoalgLine();
  geoalgLine(
    geoalgSpec1 * geoalgSpec1In);
  ~geoalgLine();
  void printSelf();
  geoalgSpec1 * get_geoalgSpec1();
  void set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In);
private:
  geoalgSpec1 * a_geoalgSpec1;
};

/********************************************************************/

/* geoalgObject

This is a class for the single definition of geoalgObject.
It represents the following items:

OBJECT ',' geoalgSpec3

*/

class geoalgObject :
  public geoalgMinor
{
public:
  geoalgObject();
  geoalgObject(
    geoalgSpec3 * geoalgSpec3In);
  ~geoalgObject();
  void printSelf();
  geoalgSpec3 * get_geoalgSpec3();
  void set_geoalgSpec3(geoalgSpec3 * geoalgSpec3In);
private:
  geoalgSpec3 * a_geoalgSpec3;
};

/********************************************************************/

/* geoalgParpln

This is a class for the single definition of geoalgParpln.
It represents the following items:

PARPLN ',' geoalgSpec2

*/

class geoalgParpln :
  public geoalgMinor
{
public:
  geoalgParpln();
  geoalgParpln(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgParpln();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgPlane

This is a class for the single definition of geoalgPlane.
It represents the following items:

PLANE ',' geoalgSpec1

*/

class geoalgPlane :
  public geoalgMinor
{
public:
  geoalgPlane();
  geoalgPlane(
    geoalgSpec1 * geoalgSpec1In);
  ~geoalgPlane();
  void printSelf();
  geoalgSpec1 * get_geoalgSpec1();
  void set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In);
private:
  geoalgSpec1 * a_geoalgSpec1;
};

/********************************************************************/

/* geoalgRctngl

This is a class for the single definition of geoalgRctngl.
It represents the following items:

RCTNGL ',' geoalgSpec1

*/

class geoalgRctngl :
  public geoalgMinor
{
public:
  geoalgRctngl();
  geoalgRctngl(
    geoalgSpec1 * geoalgSpec1In);
  ~geoalgRctngl();
  void printSelf();
  geoalgSpec1 * get_geoalgSpec1();
  void set_geoalgSpec1(geoalgSpec1 * geoalgSpec1In);
private:
  geoalgSpec1 * a_geoalgSpec1;
};

/********************************************************************/

/* geoalgRevsurf

This is a class for the single definition of geoalgRevsurf.
It represents the following items:

REVSURF ',' geoalgSpec6

*/

class geoalgRevsurf :
  public geoalgMinor
{
public:
  geoalgRevsurf();
  geoalgRevsurf(
    geoalgSpec6 * geoalgSpec6In);
  ~geoalgRevsurf();
  void printSelf();
  geoalgSpec6 * get_geoalgSpec6();
  void set_geoalgSpec6(geoalgSpec6 * geoalgSpec6In);
private:
  geoalgSpec6 * a_geoalgSpec6;
};

/********************************************************************/

/* geoalgSphere

This is a class for the single definition of geoalgSphere.
It represents the following items:

SPHERE ',' geoalgSpec2

*/

class geoalgSphere :
  public geoalgMinor
{
public:
  geoalgSphere();
  geoalgSphere(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgSphere();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgSphradsegmnt

This is a class for the single definition of geoalgSphradsegmnt.
It represents the following items:

SPHRADSEGMNT ',' geoalgSpec2

*/

class geoalgSphradsegmnt :
  public geoalgMinor
{
public:
  geoalgSphradsegmnt();
  geoalgSphradsegmnt(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgSphradsegmnt();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgSympln

This is a class for the single definition of geoalgSympln.
It represents the following items:

SYMPLN ',' geoalgSpec2

*/

class geoalgSympln :
  public geoalgMinor
{
public:
  geoalgSympln();
  geoalgSympln(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgSympln();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgTorus

This is a class for the single definition of geoalgTorus.
It represents the following items:

TORUS ',' geoalgSpec2

*/

class geoalgTorus :
  public geoalgMinor
{
public:
  geoalgTorus();
  geoalgTorus(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgTorus();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgTorradsegmnt

This is a class for the single definition of geoalgTorradsegmnt.
It represents the following items:

TORRADSEGMNT ',' geoalgSpec2

*/

class geoalgTorradsegmnt :
  public geoalgMinor
{
public:
  geoalgTorradsegmnt();
  geoalgTorradsegmnt(
    geoalgSpec2 * geoalgSpec2In);
  ~geoalgTorradsegmnt();
  void printSelf();
  geoalgSpec2 * get_geoalgSpec2();
  void set_geoalgSpec2(geoalgSpec2 * geoalgSpec2In);
private:
  geoalgSpec2 * a_geoalgSpec2;
};

/********************************************************************/

/* geoalgSpec1

This is a parent class.

*/

class geoalgSpec1 :
  public dmisCppBase
{
public:
  geoalgSpec1();
  ~geoalgSpec1();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgSpec1_LSTSQR

This is a derived class for one of the definitions of geoalgSpec1.
It represents the following items:

LSTSQR [',' geoalgFilterSettings]

*/

class geoalgSpec1_LSTSQR :
  public geoalgSpec1
{
public:
  geoalgSpec1_LSTSQR();
  geoalgSpec1_LSTSQR(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec1_LSTSQR();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec1_MINMAX

This is a derived class for one of the definitions of geoalgSpec1.
It represents the following items:

MINMAX [',' geoalgFilterSettings]

*/

class geoalgSpec1_MINMAX :
  public geoalgSpec1
{
public:
  geoalgSpec1_MINMAX();
  geoalgSpec1_MINMAX(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec1_MINMAX();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec1_DEFALT

This is a derived class for one of the definitions of geoalgSpec1.
It represents the following items:

DEFALT [',' geoalgFilterSettings]

*/

class geoalgSpec1_DEFALT :
  public geoalgSpec1
{
public:
  geoalgSpec1_DEFALT();
  geoalgSpec1_DEFALT(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec1_DEFALT();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec1_EXTERN

This is a derived class for one of the definitions of geoalgSpec1.
It represents the following items:

EXTERN ',' geoalgExternFunc [',' paramList] [',' geoalgFilterSettings]

*/

class geoalgSpec1_EXTERN :
  public geoalgSpec1
{
public:
  geoalgSpec1_EXTERN();
  geoalgSpec1_EXTERN(
    geoalgExternFunc * geoalgExternFuncIn,
    std::list<param *> * paramListIn,
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec1_EXTERN();
  void printSelf();
  geoalgExternFunc * get_geoalgExternFunc();
  void set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgExternFunc * a_geoalgExternFunc;
  std::list<param *> * a_paramList;
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec2

This is a parent class.

*/

class geoalgSpec2 :
  public dmisCppBase
{
public:
  geoalgSpec2();
  ~geoalgSpec2();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgSpec2_LSTSQR

This is a derived class for one of the definitions of geoalgSpec2.
It represents the following items:

LSTSQR [',' geoalgFilterSettings]

*/

class geoalgSpec2_LSTSQR :
  public geoalgSpec2
{
public:
  geoalgSpec2_LSTSQR();
  geoalgSpec2_LSTSQR(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec2_LSTSQR();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec2_MINMAX

This is a derived class for one of the definitions of geoalgSpec2.
It represents the following items:

MINMAX [',' geoalgFilterSettings]

*/

class geoalgSpec2_MINMAX :
  public geoalgSpec2
{
public:
  geoalgSpec2_MINMAX();
  geoalgSpec2_MINMAX(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec2_MINMAX();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec2_MAXINS

This is a derived class for one of the definitions of geoalgSpec2.
It represents the following items:

MAXINS [',' geoalgFilterSettings]

*/

class geoalgSpec2_MAXINS :
  public geoalgSpec2
{
public:
  geoalgSpec2_MAXINS();
  geoalgSpec2_MAXINS(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec2_MAXINS();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec2_MINCIR

This is a derived class for one of the definitions of geoalgSpec2.
It represents the following items:

MINCIR [',' geoalgFilterSettings]

*/

class geoalgSpec2_MINCIR :
  public geoalgSpec2
{
public:
  geoalgSpec2_MINCIR();
  geoalgSpec2_MINCIR(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec2_MINCIR();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec2_DEFALT

This is a derived class for one of the definitions of geoalgSpec2.
It represents the following items:

DEFALT [',' geoalgFilterSettings]

*/

class geoalgSpec2_DEFALT :
  public geoalgSpec2
{
public:
  geoalgSpec2_DEFALT();
  geoalgSpec2_DEFALT(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec2_DEFALT();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec2_EXTERN

This is a derived class for one of the definitions of geoalgSpec2.
It represents the following items:

EXTERN ',' geoalgExternFunc [',' paramList] [',' geoalgFilterSettings]

*/

class geoalgSpec2_EXTERN :
  public geoalgSpec2
{
public:
  geoalgSpec2_EXTERN();
  geoalgSpec2_EXTERN(
    geoalgExternFunc * geoalgExternFuncIn,
    std::list<param *> * paramListIn,
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec2_EXTERN();
  void printSelf();
  geoalgExternFunc * get_geoalgExternFunc();
  void set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgExternFunc * a_geoalgExternFunc;
  std::list<param *> * a_paramList;
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec3

This is a parent class.

*/

class geoalgSpec3 :
  public dmisCppBase
{
public:
  geoalgSpec3();
  ~geoalgSpec3();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgSpec3_DEFALT

This is a derived class for one of the definitions of geoalgSpec3.
It represents the following items:

DEFALT [',' geoalgFilterSettings]

*/

class geoalgSpec3_DEFALT :
  public geoalgSpec3
{
public:
  geoalgSpec3_DEFALT();
  geoalgSpec3_DEFALT(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec3_DEFALT();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec3_EXTERN

This is a derived class for one of the definitions of geoalgSpec3.
It represents the following items:

EXTERN ',' geoalgExternFunc [',' paramList] [',' geoalgFilterSettings]

*/

class geoalgSpec3_EXTERN :
  public geoalgSpec3
{
public:
  geoalgSpec3_EXTERN();
  geoalgSpec3_EXTERN(
    geoalgExternFunc * geoalgExternFuncIn,
    std::list<param *> * paramListIn,
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec3_EXTERN();
  void printSelf();
  geoalgExternFunc * get_geoalgExternFunc();
  void set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgExternFunc * a_geoalgExternFunc;
  std::list<param *> * a_paramList;
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec4

This is a parent class.

*/

class geoalgSpec4 :
  public dmisCppBase
{
public:
  geoalgSpec4();
  ~geoalgSpec4();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgSpec4_LSTSQR

This is a derived class for one of the definitions of geoalgSpec4.
It represents the following items:

LSTSQR [',' geoalgFilterSettings]

*/

class geoalgSpec4_LSTSQR :
  public geoalgSpec4
{
public:
  geoalgSpec4_LSTSQR();
  geoalgSpec4_LSTSQR(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec4_LSTSQR();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec4_MINMAX

This is a derived class for one of the definitions of geoalgSpec4.
It represents the following items:

MINMAX [',' geoalgFilterSettings]

*/

class geoalgSpec4_MINMAX :
  public geoalgSpec4
{
public:
  geoalgSpec4_MINMAX();
  geoalgSpec4_MINMAX(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec4_MINMAX();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec4_BSPLIN

This is a derived class for one of the definitions of geoalgSpec4.
It represents the following items:

BSPLIN [',' geoalgFilterSettings]

*/

class geoalgSpec4_BSPLIN :
  public geoalgSpec4
{
public:
  geoalgSpec4_BSPLIN();
  geoalgSpec4_BSPLIN(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec4_BSPLIN();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec4_DEFALT

This is a derived class for one of the definitions of geoalgSpec4.
It represents the following items:

DEFALT [',' geoalgFilterSettings]

*/

class geoalgSpec4_DEFALT :
  public geoalgSpec4
{
public:
  geoalgSpec4_DEFALT();
  geoalgSpec4_DEFALT(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec4_DEFALT();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec4_EXTERN

This is a derived class for one of the definitions of geoalgSpec4.
It represents the following items:

EXTERN ',' geoalgExternFunc [',' paramList] [',' geoalgFilterSettings]

*/

class geoalgSpec4_EXTERN :
  public geoalgSpec4
{
public:
  geoalgSpec4_EXTERN();
  geoalgSpec4_EXTERN(
    geoalgExternFunc * geoalgExternFuncIn,
    std::list<param *> * paramListIn,
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec4_EXTERN();
  void printSelf();
  geoalgExternFunc * get_geoalgExternFunc();
  void set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgExternFunc * a_geoalgExternFunc;
  std::list<param *> * a_paramList;
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec5

This is a parent class.

*/

class geoalgSpec5 :
  public dmisCppBase
{
public:
  geoalgSpec5();
  ~geoalgSpec5();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgSpec5_LSTSQR

This is a derived class for one of the definitions of geoalgSpec5.
It represents the following items:

LSTSQR [',' geoalgFilterSettings]

*/

class geoalgSpec5_LSTSQR :
  public geoalgSpec5
{
public:
  geoalgSpec5_LSTSQR();
  geoalgSpec5_LSTSQR(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec5_LSTSQR();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec5_MINMAX

This is a derived class for one of the definitions of geoalgSpec5.
It represents the following items:

MINMAX [',' geoalgFilterSettings]

*/

class geoalgSpec5_MINMAX :
  public geoalgSpec5
{
public:
  geoalgSpec5_MINMAX();
  geoalgSpec5_MINMAX(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec5_MINMAX();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec5_BEZIER

This is a derived class for one of the definitions of geoalgSpec5.
It represents the following items:

BEZIER [',' geoalgFilterSettings]

*/

class geoalgSpec5_BEZIER :
  public geoalgSpec5
{
public:
  geoalgSpec5_BEZIER();
  geoalgSpec5_BEZIER(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec5_BEZIER();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec5_NURBS

This is a derived class for one of the definitions of geoalgSpec5.
It represents the following items:

NURBS [',' geoalgFilterSettings]

*/

class geoalgSpec5_NURBS :
  public geoalgSpec5
{
public:
  geoalgSpec5_NURBS();
  geoalgSpec5_NURBS(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec5_NURBS();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec5_DEFALT

This is a derived class for one of the definitions of geoalgSpec5.
It represents the following items:

DEFALT [',' geoalgFilterSettings]

*/

class geoalgSpec5_DEFALT :
  public geoalgSpec5
{
public:
  geoalgSpec5_DEFALT();
  geoalgSpec5_DEFALT(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec5_DEFALT();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec5_EXTERN

This is a derived class for one of the definitions of geoalgSpec5.
It represents the following items:

EXTERN ',' geoalgExternFunc [',' paramList] [',' geoalgFilterSettings]

*/

class geoalgSpec5_EXTERN :
  public geoalgSpec5
{
public:
  geoalgSpec5_EXTERN();
  geoalgSpec5_EXTERN(
    geoalgExternFunc * geoalgExternFuncIn,
    std::list<param *> * paramListIn,
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec5_EXTERN();
  void printSelf();
  geoalgExternFunc * get_geoalgExternFunc();
  void set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgExternFunc * a_geoalgExternFunc;
  std::list<param *> * a_paramList;
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec6

This is a parent class.

*/

class geoalgSpec6 :
  public dmisCppBase
{
public:
  geoalgSpec6();
  ~geoalgSpec6();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgSpec6_LSTSQR

This is a derived class for one of the definitions of geoalgSpec6.
It represents the following items:

LSTSQR [',' geoalgFilterSettings]

*/

class geoalgSpec6_LSTSQR :
  public geoalgSpec6
{
public:
  geoalgSpec6_LSTSQR();
  geoalgSpec6_LSTSQR(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec6_LSTSQR();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec6_BSPLIN

This is a derived class for one of the definitions of geoalgSpec6.
It represents the following items:

BSPLIN [',' geoalgFilterSettings]

*/

class geoalgSpec6_BSPLIN :
  public geoalgSpec6
{
public:
  geoalgSpec6_BSPLIN();
  geoalgSpec6_BSPLIN(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec6_BSPLIN();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec6_DEFALT

This is a derived class for one of the definitions of geoalgSpec6.
It represents the following items:

DEFALT [',' geoalgFilterSettings]

*/

class geoalgSpec6_DEFALT :
  public geoalgSpec6
{
public:
  geoalgSpec6_DEFALT();
  geoalgSpec6_DEFALT(
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec6_DEFALT();
  void printSelf();
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgSpec6_EXTERN

This is a derived class for one of the definitions of geoalgSpec6.
It represents the following items:

EXTERN ',' geoalgExternFunc [',' paramList] [',' geoalgFilterSettings]

*/

class geoalgSpec6_EXTERN :
  public geoalgSpec6
{
public:
  geoalgSpec6_EXTERN();
  geoalgSpec6_EXTERN(
    geoalgExternFunc * geoalgExternFuncIn,
    std::list<param *> * paramListIn,
    geoalgFilterSettings * geoalgFilterSettingsIn);
  ~geoalgSpec6_EXTERN();
  void printSelf();
  geoalgExternFunc * get_geoalgExternFunc();
  void set_geoalgExternFunc(geoalgExternFunc * geoalgExternFuncIn);
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
  geoalgFilterSettings * get_geoalgFilterSettings();
  void set_geoalgFilterSettings(geoalgFilterSettings * geoalgFilterSettingsIn);
private:
  geoalgExternFunc * a_geoalgExternFunc;
  std::list<param *> * a_paramList;
  geoalgFilterSettings * a_geoalgFilterSettings;
};

/********************************************************************/

/* geoalgExternFunc

This is a parent class.

*/

class geoalgExternFunc :
  public dmisCppBase
{
public:
  geoalgExternFunc();
  ~geoalgExternFunc();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgExternFunc_DMIS

This is a derived class for one of the definitions of geoalgExternFunc.
It represents the following items:

DMIS ',' mLabel

*/

class geoalgExternFunc_DMIS :
  public geoalgExternFunc
{
public:
  geoalgExternFunc_DMIS();
  geoalgExternFunc_DMIS(
    mLabel * mLabelIn);
  ~geoalgExternFunc_DMIS();
  void printSelf();
  mLabel * get_mLabel();
  void set_mLabel(mLabel * mLabelIn);
private:
  mLabel * a_mLabel;
};

/********************************************************************/

/* geoalgExternFunc_DME

This is a derived class for one of the definitions of geoalgExternFunc.
It represents the following items:

DME ',' stringVal

*/

class geoalgExternFunc_DME :
  public geoalgExternFunc
{
public:
  geoalgExternFunc_DME();
  geoalgExternFunc_DME(
    stringVal * routineIn);
  ~geoalgExternFunc_DME();
  void printSelf();
  stringVal * get_routine();
  void set_routine(stringVal * routineIn);
private:
  stringVal * routine;
};

/********************************************************************/

/* geoalgExternFunc_SYS

This is a derived class for one of the definitions of geoalgExternFunc.
It represents the following items:

SYS ',' stringVal

*/

class geoalgExternFunc_SYS :
  public geoalgExternFunc
{
public:
  geoalgExternFunc_SYS();
  geoalgExternFunc_SYS(
    stringVal * pathnameIn);
  ~geoalgExternFunc_SYS();
  void printSelf();
  stringVal * get_pathname();
  void set_pathname(stringVal * pathnameIn);
private:
  stringVal * pathname;
};

/********************************************************************/

/* geoalgFilterSettings

This is a parent class.

*/

class geoalgFilterSettings :
  public dmisCppBase
{
public:
  geoalgFilterSettings();
  ~geoalgFilterSettings();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgFiltSetFilt

This is a derived class for one of the definitions of geoalgFilterSettings.
It represents the following items:

[geoalgEliminate ','] geoalgFilter

*/

class geoalgFiltSetFilt :
  public geoalgFilterSettings
{
public:
  geoalgFiltSetFilt();
  geoalgFiltSetFilt(
    geoalgEliminate * geoalgEliminateIn,
    geoalgFilter * geoalgFilterIn);
  ~geoalgFiltSetFilt();
  void printSelf();
  geoalgEliminate * get_geoalgEliminate();
  void set_geoalgEliminate(geoalgEliminate * geoalgEliminateIn);
  geoalgFilter * get_geoalgFilter();
  void set_geoalgFilter(geoalgFilter * geoalgFilterIn);
private:
  geoalgEliminate * a_geoalgEliminate;
  geoalgFilter * a_geoalgFilter;
};

/********************************************************************/

/* geoalgFiltSetElim

This is a derived class for one of the definitions of geoalgFilterSettings.
It represents the following items:

geoalgEliminate

*/

class geoalgFiltSetElim :
  public geoalgFilterSettings
{
public:
  geoalgFiltSetElim();
  geoalgFiltSetElim(
    geoalgEliminate * geoalgEliminateIn);
  ~geoalgFiltSetElim();
  void printSelf();
  geoalgEliminate * get_geoalgEliminate();
  void set_geoalgEliminate(geoalgEliminate * geoalgEliminateIn);
private:
  geoalgEliminate * a_geoalgEliminate;
};

/********************************************************************/

/* geoalgEliminate

This is a parent class.

*/

class geoalgEliminate :
  public dmisCppBase
{
public:
  geoalgEliminate();
  ~geoalgEliminate();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgEliminateStd

This is a derived class for one of the definitions of geoalgEliminate.
It represents the following items:

ELIMINATE ',' STDDEVLIMIT ',' rentVal

*/

class geoalgEliminateStd :
  public geoalgEliminate
{
public:
  geoalgEliminateStd();
  geoalgEliminateStd(
    rentVal * devValIn);
  ~geoalgEliminateStd();
  void printSelf();
  rentVal * get_devVal();
  void set_devVal(rentVal * devValIn);
private:
  rentVal * devVal;
};

/********************************************************************/

/* geoalgEliminateOff

This is a derived class for one of the definitions of geoalgEliminate.
It represents the following items:

ELIMINATE ',' OFF

*/

class geoalgEliminateOff :
  public geoalgEliminate
{
public:
  geoalgEliminateOff();
  ~geoalgEliminateOff();
  void printSelf();
};

/********************************************************************/

/* geoalgFilter

This is a parent class.

*/

class geoalgFilter :
  public dmisCppBase
{
public:
  geoalgFilter();
  ~geoalgFilter();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgFilterLambda

This is a derived class for one of the definitions of geoalgFilter.
It represents the following items:

FILTER ',' LAMBDAC ',' geoalgFilterType

*/

class geoalgFilterLambda :
  public geoalgFilter
{
public:
  geoalgFilterLambda();
  geoalgFilterLambda(
    geoalgFilterType * geoalgFilterTypeIn);
  ~geoalgFilterLambda();
  void printSelf();
  geoalgFilterType * get_geoalgFilterType();
  void set_geoalgFilterType(geoalgFilterType * geoalgFilterTypeIn);
private:
  geoalgFilterType * a_geoalgFilterType;
};

/********************************************************************/

/* geoalgFilterCirc

This is a derived class for one of the definitions of geoalgFilter.
It represents the following items:

FILTER ',' CIRCULAR ',' geoalgFilterType

*/

class geoalgFilterCirc :
  public geoalgFilter
{
public:
  geoalgFilterCirc();
  geoalgFilterCirc(
    geoalgFilterType * geoalgFilterTypeIn);
  ~geoalgFilterCirc();
  void printSelf();
  geoalgFilterType * get_geoalgFilterType();
  void set_geoalgFilterType(geoalgFilterType * geoalgFilterTypeIn);
private:
  geoalgFilterType * a_geoalgFilterType;
};

/********************************************************************/

/* geoalgFilterOff

This is a derived class for one of the definitions of geoalgFilter.
It represents the following items:

FILTER ',' OFF

*/

class geoalgFilterOff :
  public geoalgFilter
{
public:
  geoalgFilterOff();
  ~geoalgFilterOff();
  void printSelf();
};

/********************************************************************/

/* geoalgFilterType

This is a parent class.

*/

class geoalgFilterType :
  public dmisCppBase
{
public:
  geoalgFilterType();
  ~geoalgFilterType();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgFilterType_LOWPASS

This is a derived class for one of the definitions of geoalgFilterType.
It represents the following items:

LOWPASS ',' rentVal ',' geoalgFilterCurve

*/

class geoalgFilterType_LOWPASS :
  public geoalgFilterType
{
public:
  geoalgFilterType_LOWPASS();
  geoalgFilterType_LOWPASS(
    rentVal * waveValIn,
    geoalgFilterCurve * geoalgFilterCurveIn);
  ~geoalgFilterType_LOWPASS();
  void printSelf();
  rentVal * get_waveVal();
  void set_waveVal(rentVal * waveValIn);
  geoalgFilterCurve * get_geoalgFilterCurve();
  void set_geoalgFilterCurve(geoalgFilterCurve * geoalgFilterCurveIn);
private:
  rentVal * waveVal;
  geoalgFilterCurve * a_geoalgFilterCurve;
};

/********************************************************************/

/* geoalgFilterType_HIGHPASS

This is a derived class for one of the definitions of geoalgFilterType.
It represents the following items:

HIGHPASS ',' rentVal ',' geoalgFilterCurve

*/

class geoalgFilterType_HIGHPASS :
  public geoalgFilterType
{
public:
  geoalgFilterType_HIGHPASS();
  geoalgFilterType_HIGHPASS(
    rentVal * waveValIn,
    geoalgFilterCurve * geoalgFilterCurveIn);
  ~geoalgFilterType_HIGHPASS();
  void printSelf();
  rentVal * get_waveVal();
  void set_waveVal(rentVal * waveValIn);
  geoalgFilterCurve * get_geoalgFilterCurve();
  void set_geoalgFilterCurve(geoalgFilterCurve * geoalgFilterCurveIn);
private:
  rentVal * waveVal;
  geoalgFilterCurve * a_geoalgFilterCurve;
};

/********************************************************************/

/* geoalgFilterType_BANDPASS

This is a derived class for one of the definitions of geoalgFilterType.
It represents the following items:

BANDPASS ',' rentVal ',' rentVal ',' geoalgFilterCurve

*/

class geoalgFilterType_BANDPASS :
  public geoalgFilterType
{
public:
  geoalgFilterType_BANDPASS();
  geoalgFilterType_BANDPASS(
    rentVal * waveVal1In,
    rentVal * waveVal2In,
    geoalgFilterCurve * geoalgFilterCurveIn);
  ~geoalgFilterType_BANDPASS();
  void printSelf();
  rentVal * get_waveVal1();
  void set_waveVal1(rentVal * waveVal1In);
  rentVal * get_waveVal2();
  void set_waveVal2(rentVal * waveVal2In);
  geoalgFilterCurve * get_geoalgFilterCurve();
  void set_geoalgFilterCurve(geoalgFilterCurve * geoalgFilterCurveIn);
private:
  rentVal * waveVal1;
  rentVal * waveVal2;
  geoalgFilterCurve * a_geoalgFilterCurve;
};

/********************************************************************/

/* geoalgFilterCurve

This is a parent class.

*/

class geoalgFilterCurve :
  public dmisCppBase
{
public:
  geoalgFilterCurve();
  ~geoalgFilterCurve();
  void printSelf() = 0;
};

/********************************************************************/

/* geoalgFilterCurve_GAUSS

This is a derived class for one of the definitions of geoalgFilterCurve.
It represents the following items:

GAUSS

*/

class geoalgFilterCurve_GAUSS :
  public geoalgFilterCurve
{
public:
  geoalgFilterCurve_GAUSS();
  ~geoalgFilterCurve_GAUSS();
  void printSelf();
};

/********************************************************************/

/* geoalgFilterCurve_TWORC

This is a derived class for one of the definitions of geoalgFilterCurve.
It represents the following items:

TWORC

*/

class geoalgFilterCurve_TWORC :
  public geoalgFilterCurve
{
public:
  geoalgFilterCurve_TWORC();
  ~geoalgFilterCurve_TWORC();
  void printSelf();
};

/********************************************************************/

/* geoalgFilterCurve_SPLINE

This is a derived class for one of the definitions of geoalgFilterCurve.
It represents the following items:

SPLINE

*/

class geoalgFilterCurve_SPLINE :
  public geoalgFilterCurve
{
public:
  geoalgFilterCurve_SPLINE();
  ~geoalgFilterCurve_SPLINE();
  void printSelf();
};

/********************************************************************/

/* geoalgFilterCurve_RECFILT

This is a derived class for one of the definitions of geoalgFilterCurve.
It represents the following items:

RECFILT

*/

class geoalgFilterCurve_RECFILT :
  public geoalgFilterCurve
{
public:
  geoalgFilterCurve_RECFILT();
  ~geoalgFilterCurve_RECFILT();
  void printSelf();
};

/********************************************************************/

/* geomStm

This is a class for the single definition of geomStm.
It represents the following items:

gLabel '=' GEOM '/' geomMinor #

*/

class geomStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  geomStm();
  geomStm(
    gLabel * gLabelIn,
    geomMinor * geomMinorIn);
  ~geomStm();
  void printSelf();
  gLabel * get_gLabel();
  void set_gLabel(gLabel * gLabelIn);
  geomMinor * get_geomMinor();
  void set_geomMinor(geomMinor * geomMinorIn);
private:
  gLabel * a_gLabel;
  geomMinor * a_geomMinor;
};

/********************************************************************/

/* geomMinor

This is a parent class.

*/

class geomMinor :
  public dmisCppBase
{
public:
  geomMinor();
  ~geomMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* geomStmNone

This is a derived class for one of the definitions of geomMinor.
It represents the following items:

NONE

*/

class geomStmNone :
  public geomMinor
{
public:
  geomStmNone();
  ~geomStmNone();
  void printSelf();
};

/********************************************************************/

/* geomStmDid

This is a derived class for one of the definitions of geomMinor.
It represents the following items:

didLabel

*/

class geomStmDid :
  public geomMinor
{
public:
  geomStmDid();
  geomStmDid(
    didLabel * didLabelIn);
  ~geomStmDid();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* geomStmOffset

This is a derived class for one of the definitions of geomMinor.
It represents the following items:

gLabel [',' OFFSET ',' rentVal]

*/

class geomStmOffset :
  public geomMinor
{
public:
  geomStmOffset();
  geomStmOffset(
    gLabel * gLabelIn,
    rentVal * distIn);
  ~geomStmOffset();
  void printSelf();
  gLabel * get_gLabel();
  void set_gLabel(gLabel * gLabelIn);
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  gLabel * a_gLabel;
  rentVal * dist;
};

/********************************************************************/

/* geomStmEntity

This is a derived class for one of the definitions of geomMinor.
It represents the following items:

gLabel ',' ENTITY ',' geomEntityList

*/

class geomStmEntity :
  public geomMinor
{
public:
  geomStmEntity();
  geomStmEntity(
    gLabel * gLabelIn,
    std::list<geomEntityItem *> * geomEntityListIn);
  ~geomStmEntity();
  void printSelf();
  gLabel * get_gLabel();
  void set_gLabel(gLabel * gLabelIn);
  std::list<geomEntityItem *> * get_geomEntityList();
  void set_geomEntityList(std::list<geomEntityItem *> * geomEntityListIn);
private:
  gLabel * a_gLabel;
  std::list<geomEntityItem *> * a_geomEntityList;
};

/********************************************************************/

/* geomEntityItem

This is a class for the single definition of geomEntityItem.
It represents the following items:

stringVal [',' OFFSET ',' rentVal]

*/

class geomEntityItem :
  public dmisCppBase
{
public:
  geomEntityItem();
  geomEntityItem(
    stringVal * identityIn,
    rentVal * distIn);
  ~geomEntityItem();
  void printSelf();
  stringVal * get_identity();
  void set_identity(stringVal * identityIn);
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  stringVal * identity;
  rentVal * dist;
};

/********************************************************************/

/* gotargStm

This is a parent class.

*/

class gotargStm :
  public dmisStatement
{
public:
  gotargStm();
  ~gotargStm();
  void printSelf() = 0;
};

/********************************************************************/

/* gotargXyz

This is a derived class for one of the definitions of gotargStm.
It represents the following items:

GOTARG '/' impCartPoint #

*/

class gotargXyz :
  public gotargStm
{
public:
  gotargXyz();
  gotargXyz(
    impCartPoint * impCartPointIn);
  ~gotargXyz();
  void printSelf();
  impCartPoint * get_impCartPoint();
  void set_impCartPoint(impCartPoint * impCartPointIn);
private:
  impCartPoint * a_impCartPoint;
};

/********************************************************************/

/* gotargCart

This is a derived class for one of the definitions of gotargStm.
It represents the following items:

GOTARG '/' cartPoint #

*/

class gotargCart :
  public gotargStm
{
public:
  gotargCart();
  gotargCart(
    cartPoint * cartPointIn);
  ~gotargCart();
  void printSelf();
  cartPoint * get_cartPoint();
  void set_cartPoint(cartPoint * cartPointIn);
private:
  cartPoint * a_cartPoint;
};

/********************************************************************/

/* gotargPol

This is a derived class for one of the definitions of gotargStm.
It represents the following items:

GOTARG '/' polPoint #

*/

class gotargPol :
  public gotargStm
{
public:
  gotargPol();
  gotargPol(
    polPoint * polPointIn);
  ~gotargPol();
  void printSelf();
  polPoint * get_polPoint();
  void set_polPoint(polPoint * polPointIn);
private:
  polPoint * a_polPoint;
};

/********************************************************************/

/* gotoMinor

This is a parent class.

*/

class gotoMinor :
  public dmisCppBase
{
public:
  gotoMinor();
  ~gotoMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* gotoAxis

This is a class for the single definition of gotoAxis.
It represents the following items:

gotoAxisSpec [',' gotoAxisSpec [',' gotoAxisSpec]]

*/

class gotoAxis :
  public gotoMinor
{
public:
  gotoAxis();
  gotoAxis(
    gotoAxisSpec * spec1In,
    gotoAxisSpec * spec2In,
    gotoAxisSpec * spec3In);
  ~gotoAxis();
  void printSelf();
  gotoAxisSpec * get_spec1();
  void set_spec1(gotoAxisSpec * spec1In);
  gotoAxisSpec * get_spec2();
  void set_spec2(gotoAxisSpec * spec2In);
  gotoAxisSpec * get_spec3();
  void set_spec3(gotoAxisSpec * spec3In);
private:
  gotoAxisSpec * spec1;
  gotoAxisSpec * spec2;
  gotoAxisSpec * spec3;
};

/********************************************************************/

/* gotoAxisSpec

This is a class for the single definition of gotoAxisSpec.
It represents the following items:

axis ',' rentVal

*/

class gotoAxisSpec :
  public dmisCppBase
{
public:
  gotoAxisSpec();
  gotoAxisSpec(
    axis * axisNameIn,
    rentVal * axisCoordIn);
  ~gotoAxisSpec();
  void printSelf();
  axis * get_axisName();
  void set_axisName(axis * axisNameIn);
  rentVal * get_axisCoord();
  void set_axisCoord(rentVal * axisCoordIn);
private:
  axis * axisName;
  rentVal * axisCoord;
};

/********************************************************************/

/* gotoAbs

This is a parent class.

*/

class gotoAbs :
  public gotoMinor
{
public:
  gotoAbs();
  ~gotoAbs();
  void printSelf() = 0;
};

/********************************************************************/

/* gotoAbsXyz

This is a derived class for one of the definitions of gotoAbs.
It represents the following items:

impCartPoint

*/

class gotoAbsXyz :
  public gotoAbs
{
public:
  gotoAbsXyz();
  gotoAbsXyz(
    impCartPoint * impCartPointIn);
  ~gotoAbsXyz();
  void printSelf();
  impCartPoint * get_impCartPoint();
  void set_impCartPoint(impCartPoint * impCartPointIn);
private:
  impCartPoint * a_impCartPoint;
};

/********************************************************************/

/* gotoAbsXyzSens

This is a derived class for one of the definitions of gotoAbs.
It represents the following items:

impCartPoint ',' sensorMove

*/

class gotoAbsXyzSens :
  public gotoAbs
{
public:
  gotoAbsXyzSens();
  gotoAbsXyzSens(
    impCartPoint * impCartPointIn,
    sensorMove * sensorMoveIn);
  ~gotoAbsXyzSens();
  void printSelf();
  impCartPoint * get_impCartPoint();
  void set_impCartPoint(impCartPoint * impCartPointIn);
  sensorMove * get_sensorMove();
  void set_sensorMove(sensorMove * sensorMoveIn);
private:
  impCartPoint * a_impCartPoint;
  sensorMove * a_sensorMove;
};

/********************************************************************/

/* gotoAbsCart

This is a derived class for one of the definitions of gotoAbs.
It represents the following items:

cartPoint

*/

class gotoAbsCart :
  public gotoAbs
{
public:
  gotoAbsCart();
  gotoAbsCart(
    cartPoint * cartPointIn);
  ~gotoAbsCart();
  void printSelf();
  cartPoint * get_cartPoint();
  void set_cartPoint(cartPoint * cartPointIn);
private:
  cartPoint * a_cartPoint;
};

/********************************************************************/

/* gotoAbsCartSens

This is a derived class for one of the definitions of gotoAbs.
It represents the following items:

cartPoint ',' sensorMove

*/

class gotoAbsCartSens :
  public gotoAbs
{
public:
  gotoAbsCartSens();
  gotoAbsCartSens(
    cartPoint * cartPointIn,
    sensorMove * sensorMoveIn);
  ~gotoAbsCartSens();
  void printSelf();
  cartPoint * get_cartPoint();
  void set_cartPoint(cartPoint * cartPointIn);
  sensorMove * get_sensorMove();
  void set_sensorMove(sensorMove * sensorMoveIn);
private:
  cartPoint * a_cartPoint;
  sensorMove * a_sensorMove;
};

/********************************************************************/

/* gotoAbsPol

This is a derived class for one of the definitions of gotoAbs.
It represents the following items:

polPoint

*/

class gotoAbsPol :
  public gotoAbs
{
public:
  gotoAbsPol();
  gotoAbsPol(
    polPoint * polPointIn);
  ~gotoAbsPol();
  void printSelf();
  polPoint * get_polPoint();
  void set_polPoint(polPoint * polPointIn);
private:
  polPoint * a_polPoint;
};

/********************************************************************/

/* gotoAbsPolSens

This is a derived class for one of the definitions of gotoAbs.
It represents the following items:

polPoint ',' sensorMove

*/

class gotoAbsPolSens :
  public gotoAbs
{
public:
  gotoAbsPolSens();
  gotoAbsPolSens(
    polPoint * polPointIn,
    sensorMove * sensorMoveIn);
  ~gotoAbsPolSens();
  void printSelf();
  polPoint * get_polPoint();
  void set_polPoint(polPoint * polPointIn);
  sensorMove * get_sensorMove();
  void set_sensorMove(sensorMove * sensorMoveIn);
private:
  polPoint * a_polPoint;
  sensorMove * a_sensorMove;
};

/********************************************************************/

/* sensorMove

This is a parent class.

*/

class sensorMove :
  public dmisCppBase
{
public:
  sensorMove();
  ~sensorMove();
  void printSelf() = 0;
};

/********************************************************************/

/* sensorMove_saLabel

This is a derived class for one of the definitions of sensorMove.
It represents the following items:

saLabel

*/

class sensorMove_saLabel :
  public sensorMove
{
public:
  sensorMove_saLabel();
  sensorMove_saLabel(
    saLabel * saLabelIn);
  ~sensorMove_saLabel();
  void printSelf();
  saLabel * get_saLabel();
  void set_saLabel(saLabel * saLabelIn);
private:
  saLabel * a_saLabel;
};

/********************************************************************/

/* sensorMove_gotoWristList

This is a derived class for one of the definitions of sensorMove.
It represents the following items:

gotoWristList

*/

class sensorMove_gotoWristList :
  public sensorMove
{
public:
  sensorMove_gotoWristList();
  sensorMove_gotoWristList(
    std::list<gotoWristItem *> * gotoWristListIn);
  ~sensorMove_gotoWristList();
  void printSelf();
  std::list<gotoWristItem *> * get_gotoWristList();
  void set_gotoWristList(std::list<gotoWristItem *> * gotoWristListIn);
private:
  std::list<gotoWristItem *> * a_gotoWristList;
};

/********************************************************************/

/* sensorMove_probeOrient

This is a derived class for one of the definitions of sensorMove.
It represents the following items:

probeOrient

*/

class sensorMove_probeOrient :
  public sensorMove
{
public:
  sensorMove_probeOrient();
  sensorMove_probeOrient(
    probeOrient * probeOrientIn);
  ~sensorMove_probeOrient();
  void printSelf();
  probeOrient * get_probeOrient();
  void set_probeOrient(probeOrient * probeOrientIn);
private:
  probeOrient * a_probeOrient;
};

/********************************************************************/

/* gotoRel

This is a class for the single definition of gotoRel.
It represents the following items:

INCR ',' rentVal ',' vector

*/

class gotoRel :
  public gotoMinor
{
public:
  gotoRel();
  gotoRel(
    rentVal * distIn,
    vector * dirIn);
  ~gotoRel();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  rentVal * dist;
  vector * dir;
};

/********************************************************************/

/* gotoArc

This is a class for the single definition of gotoArc.
It represents the following items:

ARC ',' impCartPoint ',' impCartPoint [',' probeOrient]

*/

class gotoArc :
  public gotoMinor
{
public:
  gotoArc();
  gotoArc(
    impCartPoint * interIn,
    impCartPoint * endIn,
    probeOrient * probeOrientIn);
  ~gotoArc();
  void printSelf();
  impCartPoint * get_inter();
  void set_inter(impCartPoint * interIn);
  impCartPoint * get_end();
  void set_end(impCartPoint * endIn);
  probeOrient * get_probeOrient();
  void set_probeOrient(probeOrient * probeOrientIn);
private:
  impCartPoint * inter;
  impCartPoint * end;
  probeOrient * a_probeOrient;
};

/********************************************************************/

/* probeOrient

This is a parent class.

*/

class probeOrient :
  public gotoMinor
{
public:
  probeOrient();
  ~probeOrient();
  void printSelf() = 0;
};

/********************************************************************/

/* probeOrient_featureLabel

This is a derived class for one of the definitions of probeOrient.
It represents the following items:

featureLabel [',' FZ ',' angle]

*/

class probeOrient_featureLabel :
  public probeOrient
{
public:
  probeOrient_featureLabel();
  probeOrient_featureLabel(
    featureLabel * featureLabelIn,
    angle * angleIn);
  ~probeOrient_featureLabel();
  void printSelf();
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  featureLabel * a_featureLabel;
  angle * a_angle;
};

/********************************************************************/

/* probeOrient_VEC

This is a derived class for one of the definitions of probeOrient.
It represents the following items:

VEC ',' vector [',' FZ ',' angle]

*/

class probeOrient_VEC :
  public probeOrient
{
public:
  probeOrient_VEC();
  probeOrient_VEC(
    vector * dirIn,
    angle * angleIn);
  ~probeOrient_VEC();
  void printSelf();
  vector * get_dir();
  void set_dir(vector * dirIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  vector * dir;
  angle * a_angle;
};

/********************************************************************/

/* probeOrient_PCS

This is a derived class for one of the definitions of probeOrient.
It represents the following items:

PCS ',' euler

*/

class probeOrient_PCS :
  public probeOrient
{
public:
  probeOrient_PCS();
  probeOrient_PCS(
    euler * eulerIn);
  ~probeOrient_PCS();
  void printSelf();
  euler * get_euler();
  void set_euler(euler * eulerIn);
private:
  euler * a_euler;
};

/********************************************************************/

/* probeOrient_HEADCS

This is a derived class for one of the definitions of probeOrient.
It represents the following items:

HEADCS ',' rentVal ',' rentVal [',' rentVal]

*/

class probeOrient_HEADCS :
  public probeOrient
{
public:
  probeOrient_HEADCS();
  probeOrient_HEADCS(
    rentVal * rot1In,
    rentVal * rot2In,
    rentVal * rot3In);
  ~probeOrient_HEADCS();
  void printSelf();
  rentVal * get_rot1();
  void set_rot1(rentVal * rot1In);
  rentVal * get_rot2();
  void set_rot2(rentVal * rot2In);
  rentVal * get_rot3();
  void set_rot3(rentVal * rot3In);
private:
  rentVal * rot1;
  rentVal * rot2;
  rentVal * rot3;
};

/********************************************************************/

/* gotoWristItem

This is a class for the single definition of gotoWristItem.
It represents the following items:

swLabel ',' gotoWristAngleList

*/

class gotoWristItem :
  public dmisCppBase
{
public:
  gotoWristItem();
  gotoWristItem(
    swLabel * swLabelIn,
    std::list<gotoWristAngleItem *> * gotoWristAngleListIn);
  ~gotoWristItem();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  std::list<gotoWristAngleItem *> * get_gotoWristAngleList();
  void set_gotoWristAngleList(std::list<gotoWristAngleItem *> * gotoWristAngleListIn);
private:
  swLabel * a_swLabel;
  std::list<gotoWristAngleItem *> * a_gotoWristAngleList;
};

/********************************************************************/

/* gotoWristAngleItem

This is a class for the single definition of gotoWristAngleItem.
It represents the following items:

stringVal ',' angle

*/

class gotoWristAngleItem :
  public dmisCppBase
{
public:
  gotoWristAngleItem();
  gotoWristAngleItem(
    stringVal * anglenameIn,
    angle * angleIn);
  ~gotoWristAngleItem();
  void printSelf();
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  stringVal * anglename;
  angle * a_angle;
};

/********************************************************************/

/* groupStm

This is a class for the single definition of groupStm.
It represents the following items:

gsaLabel '=' GROUP '/' saLabel ',' saLabelList #

*/

class groupStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  groupStm();
  groupStm(
    gsaLabel * gsaLabelIn,
    saLabel * saLabelIn,
    std::list<saLabel *> * saLabelListIn);
  ~groupStm();
  void printSelf();
  gsaLabel * get_gsaLabel();
  void set_gsaLabel(gsaLabel * gsaLabelIn);
  saLabel * get_saLabel();
  void set_saLabel(saLabel * saLabelIn);
  std::list<saLabel *> * get_saLabelList();
  void set_saLabelList(std::list<saLabel *> * saLabelListIn);
private:
  gsaLabel * a_gsaLabel;
  saLabel * a_saLabel;
  std::list<saLabel *> * a_saLabelList;
};

/********************************************************************/

/* ifStm

This is a class for the single definition of ifStm.
It represents the following items:

IF '/' '(' boolVal ')' #

*/

class ifStm :
  public dmisStatement
{
public:
  ifStm();
  ifStm(
    boolVal * boolValIn);
  ~ifStm();
  void printSelf();
  boolVal * get_boolVal();
  void set_boolVal(boolVal * boolValIn);
private:
  boolVal * a_boolVal;
};

/********************************************************************/

/* includMinor

This is a parent class.

*/

class includMinor :
  public dmisCppBase
{
public:
  includMinor();
  ~includMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* includDmis

This is a class for the single definition of includDmis.
It represents the following items:

DMIS ',' stringConst

*/

class includDmis :
  public includMinor
{
public:
  includDmis();
  includDmis(
    stringConst * stringConstIn);
  ~includDmis();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
private:
  stringConst * a_stringConst;
};

/********************************************************************/

/* includDme

This is a class for the single definition of includDme.
It represents the following items:

DME ',' stringConst

*/

class includDme :
  public includMinor
{
public:
  includDme();
  includDme(
    stringConst * stringConstIn);
  ~includDme();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
private:
  stringConst * a_stringConst;
};

/********************************************************************/

/* iteratStm

This is a class for the single definition of iteratStm.
It represents the following items:

realVar '=' ITERAT '/' iteratMinor #

*/

class iteratStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  iteratStm();
  iteratStm(
    realVar * realVarIn,
    iteratMinor * iteratMinorIn);
  ~iteratStm();
  void printSelf();
  realVar * get_realVar();
  void set_realVar(realVar * realVarIn);
  iteratMinor * get_iteratMinor();
  void set_iteratMinor(iteratMinor * iteratMinorIn);
private:
  realVar * a_realVar;
  iteratMinor * a_iteratMinor;
};

/********************************************************************/

/* iteratMinor

This is a class for the single definition of iteratMinor.
It represents the following items:

jumpLabel ',' jumpLabel ',' iteratConvergence ',' intVal ',' iteratCriterionList

*/

class iteratMinor :
  public dmisCppBase
{
public:
  iteratMinor();
  iteratMinor(
    jumpLabel * startIn,
    jumpLabel * failIn,
    iteratConvergence * iteratConvergenceIn,
    intVal * limitIn,
    std::list<iteratCriterionItem *> * iteratCriterionListIn);
  ~iteratMinor();
  void printSelf();
  jumpLabel * get_start();
  void set_start(jumpLabel * startIn);
  jumpLabel * get_fail();
  void set_fail(jumpLabel * failIn);
  iteratConvergence * get_iteratConvergence();
  void set_iteratConvergence(iteratConvergence * iteratConvergenceIn);
  intVal * get_limit();
  void set_limit(intVal * limitIn);
  std::list<iteratCriterionItem *> * get_iteratCriterionList();
  void set_iteratCriterionList(std::list<iteratCriterionItem *> * iteratCriterionListIn);
private:
  jumpLabel * start;
  jumpLabel * fail;
  iteratConvergence * a_iteratConvergence;
  intVal * limit;
  std::list<iteratCriterionItem *> * a_iteratCriterionList;
};

/********************************************************************/

/* iteratConvergence

This is a parent class.

*/

class iteratConvergence :
  public dmisCppBase
{
public:
  iteratConvergence();
  ~iteratConvergence();
  void printSelf() = 0;
};

/********************************************************************/

/* iteratConvergence_ABSL

This is a derived class for one of the definitions of iteratConvergence.
It represents the following items:

rentVal ',' ABSL

*/

class iteratConvergence_ABSL :
  public iteratConvergence
{
public:
  iteratConvergence_ABSL();
  iteratConvergence_ABSL(
    rentVal * convergIn);
  ~iteratConvergence_ABSL();
  void printSelf();
  rentVal * get_converg();
  void set_converg(rentVal * convergIn);
private:
  rentVal * converg;
};

/********************************************************************/

/* iteratConvergence_INCR

This is a derived class for one of the definitions of iteratConvergence.
It represents the following items:

rentVal ',' INCR

*/

class iteratConvergence_INCR :
  public iteratConvergence
{
public:
  iteratConvergence_INCR();
  iteratConvergence_INCR(
    rentVal * convergIn);
  ~iteratConvergence_INCR();
  void printSelf();
  rentVal * get_converg();
  void set_converg(rentVal * convergIn);
private:
  rentVal * converg;
};

/********************************************************************/

/* iteratCriterionItem

This is a class for the single definition of iteratCriterionItem.
It represents the following items:

iteratCriterionStart ',' featureActualList

*/

class iteratCriterionItem :
  public dmisCppBase
{
public:
  iteratCriterionItem();
  iteratCriterionItem(
    iteratCriterionStart * iteratCriterionStartIn,
    std::list<faLabel *> * featureActualListIn);
  ~iteratCriterionItem();
  void printSelf();
  iteratCriterionStart * get_iteratCriterionStart();
  void set_iteratCriterionStart(iteratCriterionStart * iteratCriterionStartIn);
  std::list<faLabel *> * get_featureActualList();
  void set_featureActualList(std::list<faLabel *> * featureActualListIn);
private:
  iteratCriterionStart * a_iteratCriterionStart;
  std::list<faLabel *> * a_featureActualList;
};

/********************************************************************/

/* iteratCriterionStart

This is a parent class.

*/

class iteratCriterionStart :
  public dmisCppBase
{
public:
  iteratCriterionStart();
  ~iteratCriterionStart();
  void printSelf() = 0;
};

/********************************************************************/

/* iteratCriterionStart_axis

This is a derived class for one of the definitions of iteratCriterionStart.
It represents the following items:

axis

*/

class iteratCriterionStart_axis :
  public iteratCriterionStart
{
public:
  iteratCriterionStart_axis();
  iteratCriterionStart_axis(
    axis * axisIn);
  ~iteratCriterionStart_axis();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  axis * a_axis;
};

/********************************************************************/

/* iteratCriterionStart_vector

This is a derived class for one of the definitions of iteratCriterionStart.
It represents the following items:

vector

*/

class iteratCriterionStart_vector :
  public iteratCriterionStart
{
public:
  iteratCriterionStart_vector();
  iteratCriterionStart_vector(
    vector * dirIn);
  ~iteratCriterionStart_vector();
  void printSelf();
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  vector * dir;
};

/********************************************************************/

/* iteratCriterionStart_NOM

This is a derived class for one of the definitions of iteratCriterionStart.
It represents the following items:

NOM

*/

class iteratCriterionStart_NOM :
  public iteratCriterionStart
{
public:
  iteratCriterionStart_NOM();
  ~iteratCriterionStart_NOM();
  void printSelf();
};

/********************************************************************/

/* keycharStm

This is a class for the single definition of keycharStm.
It represents the following items:

kcLabel '=' KEYCHAR '/' keycharMinor #

*/

class keycharStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  keycharStm();
  keycharStm(
    kcLabel * kcLabelIn,
    keycharMinor * keycharMinorIn);
  ~keycharStm();
  void printSelf();
  kcLabel * get_kcLabel();
  void set_kcLabel(kcLabel * kcLabelIn);
  keycharMinor * get_keycharMinor();
  void set_keycharMinor(keycharMinor * keycharMinorIn);
private:
  kcLabel * a_kcLabel;
  keycharMinor * a_keycharMinor;
};

/********************************************************************/

/* keycharMinor

This is a parent class.

*/

class keycharMinor :
  public dmisCppBase
{
public:
  keycharMinor();
  ~keycharMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* keycharOneFeature

This is a class for the single definition of keycharOneFeature.
It represents the following items:

fLabel ',' tLabelList [',' criticality]

*/

class keycharOneFeature :
  public keycharMinor
{
public:
  keycharOneFeature();
  keycharOneFeature(
    fLabel * fLabelIn,
    std::list<tLabel *> * tLabelListIn,
    criticality * criticalityIn);
  ~keycharOneFeature();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  std::list<tLabel *> * get_tLabelList();
  void set_tLabelList(std::list<tLabel *> * tLabelListIn);
  criticality * get_criticality();
  void set_criticality(criticality * criticalityIn);
private:
  fLabel * a_fLabel;
  std::list<tLabel *> * a_tLabelList;
  criticality * a_criticality;
};

/********************************************************************/

/* keycharTwoFeatures

This is a class for the single definition of keycharTwoFeatures.
It represents the following items:

fLabel ',' fLabel ',' tLabel [',' criticality]

*/

class keycharTwoFeatures :
  public keycharMinor
{
public:
  keycharTwoFeatures();
  keycharTwoFeatures(
    fLabel * feat1In,
    fLabel * feat2In,
    tLabel * tLabelIn,
    criticality * criticalityIn);
  ~keycharTwoFeatures();
  void printSelf();
  fLabel * get_feat1();
  void set_feat1(fLabel * feat1In);
  fLabel * get_feat2();
  void set_feat2(fLabel * feat2In);
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  criticality * get_criticality();
  void set_criticality(criticality * criticalityIn);
private:
  fLabel * feat1;
  fLabel * feat2;
  tLabel * a_tLabel;
  criticality * a_criticality;
};

/********************************************************************/

/* criticality

This is a parent class.

*/

class criticality :
  public dmisCppBase
{
public:
  criticality();
  ~criticality();
  void printSelf() = 0;
};

/********************************************************************/

/* criticality_CRITICAL

This is a derived class for one of the definitions of criticality.
It represents the following items:

CRITICAL

*/

class criticality_CRITICAL :
  public criticality
{
public:
  criticality_CRITICAL();
  ~criticality_CRITICAL();
  void printSelf();
};

/********************************************************************/

/* criticality_MAJOR

This is a derived class for one of the definitions of criticality.
It represents the following items:

MAJOR

*/

class criticality_MAJOR :
  public criticality
{
public:
  criticality_MAJOR();
  ~criticality_MAJOR();
  void printSelf();
};

/********************************************************************/

/* criticality_MINOR

This is a derived class for one of the definitions of criticality.
It represents the following items:

MINOR

*/

class criticality_MINOR :
  public criticality
{
public:
  criticality_MINOR();
  ~criticality_MINOR();
  void printSelf();
};

/********************************************************************/

/* litdefStm

This is a class for the single definition of litdefStm.
It represents the following items:

vlLabel '=' LITDEF '/' litdefMinor #

*/

class litdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  litdefStm();
  litdefStm(
    vlLabel * vlLabelIn,
    litdefMinor * litdefMinorIn);
  ~litdefStm();
  void printSelf();
  vlLabel * get_vlLabel();
  void set_vlLabel(vlLabel * vlLabelIn);
  litdefMinor * get_litdefMinor();
  void set_litdefMinor(litdefMinor * litdefMinorIn);
private:
  vlLabel * a_vlLabel;
  litdefMinor * a_litdefMinor;
};

/********************************************************************/

/* litdefMinor

This is a parent class.

*/

class litdefMinor :
  public dmisCppBase
{
public:
  litdefMinor();
  ~litdefMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* litdefLight

This is a class for the single definition of litdefLight.
It represents the following items:

litdefLightType ',' vector

*/

class litdefLight :
  public litdefMinor
{
public:
  litdefLight();
  litdefLight(
    litdefLightType * litdefLightTypeIn,
    vector * axisIn);
  ~litdefLight();
  void printSelf();
  litdefLightType * get_litdefLightType();
  void set_litdefLightType(litdefLightType * litdefLightTypeIn);
  vector * get_axis();
  void set_axis(vector * axisIn);
private:
  litdefLightType * a_litdefLightType;
  vector * axis;
};

/********************************************************************/

/* litdefLightType

This is a parent class.

*/

class litdefLightType :
  public dmisCppBase
{
public:
  litdefLightType();
  ~litdefLightType();
  void printSelf() = 0;
};

/********************************************************************/

/* litdefLightType_SURF

This is a derived class for one of the definitions of litdefLightType.
It represents the following items:

SURF

*/

class litdefLightType_SURF :
  public litdefLightType
{
public:
  litdefLightType_SURF();
  ~litdefLightType_SURF();
  void printSelf();
};

/********************************************************************/

/* litdefLightType_BACK

This is a derived class for one of the definitions of litdefLightType.
It represents the following items:

BACK

*/

class litdefLightType_BACK :
  public litdefLightType
{
public:
  litdefLightType_BACK();
  ~litdefLightType_BACK();
  void printSelf();
};

/********************************************************************/

/* litdefLightType_GRID

This is a derived class for one of the definitions of litdefLightType.
It represents the following items:

GRID

*/

class litdefLightType_GRID :
  public litdefLightType
{
public:
  litdefLightType_GRID();
  ~litdefLightType_GRID();
  void printSelf();
};

/********************************************************************/

/* litdefLightType_OBLQ

This is a derived class for one of the definitions of litdefLightType.
It represents the following items:

OBLQ

*/

class litdefLightType_OBLQ :
  public litdefLightType
{
public:
  litdefLightType_OBLQ();
  ~litdefLightType_OBLQ();
  void printSelf();
};

/********************************************************************/

/* litdefStrobe

This is a class for the single definition of litdefStrobe.
It represents the following items:

STROBE ',' litdefStrobeType ',' rentVal ',' vector

*/

class litdefStrobe :
  public litdefMinor
{
public:
  litdefStrobe();
  litdefStrobe(
    litdefStrobeType * litdefStrobeTypeIn,
    rentVal * timeonIn,
    vector * axisIn);
  ~litdefStrobe();
  void printSelf();
  litdefStrobeType * get_litdefStrobeType();
  void set_litdefStrobeType(litdefStrobeType * litdefStrobeTypeIn);
  rentVal * get_timeon();
  void set_timeon(rentVal * timeonIn);
  vector * get_axis();
  void set_axis(vector * axisIn);
private:
  litdefStrobeType * a_litdefStrobeType;
  rentVal * timeon;
  vector * axis;
};

/********************************************************************/

/* litdefStrobeType

This is a parent class.

*/

class litdefStrobeType :
  public dmisCppBase
{
public:
  litdefStrobeType();
  ~litdefStrobeType();
  void printSelf() = 0;
};

/********************************************************************/

/* litdefStrobeType_CYCLE

This is a derived class for one of the definitions of litdefStrobeType.
It represents the following items:

CYCLE ',' rentVal

*/

class litdefStrobeType_CYCLE :
  public litdefStrobeType
{
public:
  litdefStrobeType_CYCLE();
  litdefStrobeType_CYCLE(
    rentVal * valueIn);
  ~litdefStrobeType_CYCLE();
  void printSelf();
  rentVal * get_value();
  void set_value(rentVal * valueIn);
private:
  rentVal * value;
};

/********************************************************************/

/* litdefStrobeType_TRIGER

This is a derived class for one of the definitions of litdefStrobeType.
It represents the following items:

TRIGER

*/

class litdefStrobeType_TRIGER :
  public litdefStrobeType
{
public:
  litdefStrobeType_TRIGER();
  ~litdefStrobeType_TRIGER();
  void printSelf();
};

/********************************************************************/

/* locateStm

This is a class for the single definition of locateStm.
It represents the following items:

dLabel '=' LOCATE '/' [locateTransAllowed ','] [locateRotAllowed ','] locateLabelList #

*/

class locateStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  locateStm();
  locateStm(
    dLabel * dLabelIn,
    locateTransAllowed * locateTransAllowedIn,
    locateRotAllowed * locateRotAllowedIn,
    std::list<locateLabel *> * locateLabelListIn);
  ~locateStm();
  void printSelf();
  dLabel * get_dLabel();
  void set_dLabel(dLabel * dLabelIn);
  locateTransAllowed * get_locateTransAllowed();
  void set_locateTransAllowed(locateTransAllowed * locateTransAllowedIn);
  locateRotAllowed * get_locateRotAllowed();
  void set_locateRotAllowed(locateRotAllowed * locateRotAllowedIn);
  std::list<locateLabel *> * get_locateLabelList();
  void set_locateLabelList(std::list<locateLabel *> * locateLabelListIn);
private:
  dLabel * a_dLabel;
  locateTransAllowed * a_locateTransAllowed;
  locateRotAllowed * a_locateRotAllowed;
  std::list<locateLabel *> * a_locateLabelList;
};

/********************************************************************/

/* locateTransAllowed

This is a parent class.

*/

class locateTransAllowed :
  public dmisCppBase
{
public:
  locateTransAllowed();
  ~locateTransAllowed();
  void printSelf() = 0;
};

/********************************************************************/

/* locateTransAllowed_XDIR

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

XDIR

*/

class locateTransAllowed_XDIR :
  public locateTransAllowed
{
public:
  locateTransAllowed_XDIR();
  ~locateTransAllowed_XDIR();
  void printSelf();
};

/********************************************************************/

/* locateTransAllowed_YDIR

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

YDIR

*/

class locateTransAllowed_YDIR :
  public locateTransAllowed
{
public:
  locateTransAllowed_YDIR();
  ~locateTransAllowed_YDIR();
  void printSelf();
};

/********************************************************************/

/* locateTransAllowed_ZDIR

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

ZDIR

*/

class locateTransAllowed_ZDIR :
  public locateTransAllowed
{
public:
  locateTransAllowed_ZDIR();
  ~locateTransAllowed_ZDIR();
  void printSelf();
};

/********************************************************************/

/* locateTransAllowed_XYDIR

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

XYDIR

*/

class locateTransAllowed_XYDIR :
  public locateTransAllowed
{
public:
  locateTransAllowed_XYDIR();
  ~locateTransAllowed_XYDIR();
  void printSelf();
};

/********************************************************************/

/* locateTransAllowed_YZDIR

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

YZDIR

*/

class locateTransAllowed_YZDIR :
  public locateTransAllowed
{
public:
  locateTransAllowed_YZDIR();
  ~locateTransAllowed_YZDIR();
  void printSelf();
};

/********************************************************************/

/* locateTransAllowed_ZXDIR

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

ZXDIR

*/

class locateTransAllowed_ZXDIR :
  public locateTransAllowed
{
public:
  locateTransAllowed_ZXDIR();
  ~locateTransAllowed_ZXDIR();
  void printSelf();
};

/********************************************************************/

/* locateTransAllowed_XYZDIR

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

XYZDIR

*/

class locateTransAllowed_XYZDIR :
  public locateTransAllowed
{
public:
  locateTransAllowed_XYZDIR();
  ~locateTransAllowed_XYZDIR();
  void printSelf();
};

/********************************************************************/

/* locateTransAllowed_NOTRAN

This is a derived class for one of the definitions of locateTransAllowed.
It represents the following items:

NOTRAN

*/

class locateTransAllowed_NOTRAN :
  public locateTransAllowed
{
public:
  locateTransAllowed_NOTRAN();
  ~locateTransAllowed_NOTRAN();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed

This is a parent class.

*/

class locateRotAllowed :
  public dmisCppBase
{
public:
  locateRotAllowed();
  ~locateRotAllowed();
  void printSelf() = 0;
};

/********************************************************************/

/* locateRotAllowed_XAXIS

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

XAXIS

*/

class locateRotAllowed_XAXIS :
  public locateRotAllowed
{
public:
  locateRotAllowed_XAXIS();
  ~locateRotAllowed_XAXIS();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed_YAXIS

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

YAXIS

*/

class locateRotAllowed_YAXIS :
  public locateRotAllowed
{
public:
  locateRotAllowed_YAXIS();
  ~locateRotAllowed_YAXIS();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed_ZAXIS

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

ZAXIS

*/

class locateRotAllowed_ZAXIS :
  public locateRotAllowed
{
public:
  locateRotAllowed_ZAXIS();
  ~locateRotAllowed_ZAXIS();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed_XYAXIS

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

XYAXIS

*/

class locateRotAllowed_XYAXIS :
  public locateRotAllowed
{
public:
  locateRotAllowed_XYAXIS();
  ~locateRotAllowed_XYAXIS();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed_YZAXIS

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

YZAXIS

*/

class locateRotAllowed_YZAXIS :
  public locateRotAllowed
{
public:
  locateRotAllowed_YZAXIS();
  ~locateRotAllowed_YZAXIS();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed_ZXAXIS

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

ZXAXIS

*/

class locateRotAllowed_ZXAXIS :
  public locateRotAllowed
{
public:
  locateRotAllowed_ZXAXIS();
  ~locateRotAllowed_ZXAXIS();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed_XYZAXI

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

XYZAXI

*/

class locateRotAllowed_XYZAXI :
  public locateRotAllowed
{
public:
  locateRotAllowed_XYZAXI();
  ~locateRotAllowed_XYZAXI();
  void printSelf();
};

/********************************************************************/

/* locateRotAllowed_NOROT

This is a derived class for one of the definitions of locateRotAllowed.
It represents the following items:

NOROT

*/

class locateRotAllowed_NOROT :
  public locateRotAllowed
{
public:
  locateRotAllowed_NOROT();
  ~locateRotAllowed_NOROT();
  void printSelf();
};

/********************************************************************/

/* locateLabel

This is a parent class.

*/

class locateLabel :
  public dmisCppBase
{
public:
  locateLabel();
  ~locateLabel();
  void printSelf() = 0;
};

/********************************************************************/

/* lotidStm

This is a class for the single definition of lotidStm.
It represents the following items:

liLabel '=' LOTID '/' stringVal #

*/

class lotidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  lotidStm();
  lotidStm(
    liLabel * liLabelIn,
    stringVal * textIn);
  ~lotidStm();
  void printSelf();
  liLabel * get_liLabel();
  void set_liLabel(liLabel * liLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  liLabel * a_liLabel;
  stringVal * text;
};

/********************************************************************/

/* macroStm

This is a class for the single definition of macroStm.
It represents the following items:

mLabelConst '=' MACRO ['/' macroParList] #

*/

class macroStm :
  public dmisStatement
{
public:
  macroStm();
  macroStm(
    mLabelConst * mLabelConstIn,
    std::list<macroPar *> * macroParListIn);
  ~macroStm();
  void printSelf();
  mLabelConst * get_mLabelConst();
  void set_mLabelConst(mLabelConst * mLabelConstIn);
  std::list<macroPar *> * get_macroParList();
  void set_macroParList(std::list<macroPar *> * macroParListIn);
private:
  mLabelConst * a_mLabelConst;
  std::list<macroPar *> * a_macroParList;
};

/********************************************************************/

/* macroPar

This is a parent class.

*/

class macroPar :
  public dmisCppBase
{
public:
  macroPar();
  ~macroPar();
  void printSelf() = 0;
};

/********************************************************************/

/* macroPar_MACROVARNAME

This is a derived class for one of the definitions of macroPar.
It represents the following items:

MACROVARNAME

*/

class macroPar_MACROVARNAME :
  public macroPar
{
public:
  macroPar_MACROVARNAME();
  macroPar_MACROVARNAME(
    char * stringIn);
  ~macroPar_MACROVARNAME();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
private:
  char * a_string;
};

/********************************************************************/

/* macroPar_stringConst

This is a derived class for one of the definitions of macroPar.
It represents the following items:

stringConst

*/

class macroPar_stringConst :
  public macroPar
{
public:
  macroPar_stringConst();
  macroPar_stringConst(
    stringConst * stringConstIn);
  ~macroPar_stringConst();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
private:
  stringConst * a_stringConst;
};

/********************************************************************/

/* matdefStm

This is a class for the single definition of matdefStm.
It represents the following items:

maLabel '=' MATDEF '/' matdefMinor #

*/

class matdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  matdefStm();
  matdefStm(
    maLabel * maLabelIn,
    matdefMinor * matdefMinorIn);
  ~matdefStm();
  void printSelf();
  maLabel * get_maLabel();
  void set_maLabel(maLabel * maLabelIn);
  matdefMinor * get_matdefMinor();
  void set_matdefMinor(matdefMinor * matdefMinorIn);
private:
  maLabel * a_maLabel;
  matdefMinor * a_matdefMinor;
};

/********************************************************************/

/* matdefMinor

This is a parent class.

*/

class matdefMinor :
  public dmisCppBase
{
public:
  matdefMinor();
  ~matdefMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* matdefFeat

This is a class for the single definition of matdefFeat.
It represents the following items:

fLabel ',' matdefSpec

*/

class matdefFeat :
  public matdefMinor
{
public:
  matdefFeat();
  matdefFeat(
    fLabel * fLabelIn,
    matdefSpec * matdefSpecIn);
  ~matdefFeat();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  matdefSpec * get_matdefSpec();
  void set_matdefSpec(matdefSpec * matdefSpecIn);
private:
  fLabel * a_fLabel;
  matdefSpec * a_matdefSpec;
};

/********************************************************************/

/* matdefGeom

This is a class for the single definition of matdefGeom.
It represents the following items:

gLabel ',' matdefSpec

*/

class matdefGeom :
  public matdefMinor
{
public:
  matdefGeom();
  matdefGeom(
    gLabel * gLabelIn,
    matdefSpec * matdefSpecIn);
  ~matdefGeom();
  void printSelf();
  gLabel * get_gLabel();
  void set_gLabel(gLabel * gLabelIn);
  matdefSpec * get_matdefSpec();
  void set_matdefSpec(matdefSpec * matdefSpecIn);
private:
  gLabel * a_gLabel;
  matdefSpec * a_matdefSpec;
};

/********************************************************************/

/* matdefSpec

This is a class for the single definition of matdefSpec.
It represents the following items:

faLabelList [',' matdefType]

*/

class matdefSpec :
  public dmisCppBase
{
public:
  matdefSpec();
  matdefSpec(
    std::list<faLabel *> * faLabelListIn,
    matdefType * matdefTypeIn);
  ~matdefSpec();
  void printSelf();
  std::list<faLabel *> * get_faLabelList();
  void set_faLabelList(std::list<faLabel *> * faLabelListIn);
  matdefType * get_matdefType();
  void set_matdefType(matdefType * matdefTypeIn);
private:
  std::list<faLabel *> * a_faLabelList;
  matdefType * a_matdefType;
};

/********************************************************************/

/* matdefType

This is a parent class.

*/

class matdefType :
  public dmisCppBase
{
public:
  matdefType();
  ~matdefType();
  void printSelf() = 0;
};

/********************************************************************/

/* matdefTypeZone

This is a derived class for one of the definitions of matdefType.
It represents the following items:

matdefMating ',' matdefMethod ',' rentVal [',' matdefMat]

*/

class matdefTypeZone :
  public matdefType
{
public:
  matdefTypeZone();
  matdefTypeZone(
    matdefMating * matdefMatingIn,
    matdefMethod * matdefMethodIn,
    rentVal * fitzonIn,
    matdefMat * matdefMatIn);
  ~matdefTypeZone();
  void printSelf();
  matdefMating * get_matdefMating();
  void set_matdefMating(matdefMating * matdefMatingIn);
  matdefMethod * get_matdefMethod();
  void set_matdefMethod(matdefMethod * matdefMethodIn);
  rentVal * get_fitzon();
  void set_fitzon(rentVal * fitzonIn);
  matdefMat * get_matdefMat();
  void set_matdefMat(matdefMat * matdefMatIn);
private:
  matdefMating * a_matdefMating;
  matdefMethod * a_matdefMethod;
  rentVal * fitzon;
  matdefMat * a_matdefMat;
};

/********************************************************************/

/* matdefTypeBand

This is a derived class for one of the definitions of matdefType.
It represents the following items:

matdefMating ',' matdefMethod ',' rentVal ',' rentVal [',' matdefMat]

*/

class matdefTypeBand :
  public matdefType
{
public:
  matdefTypeBand();
  matdefTypeBand(
    matdefMating * matdefMatingIn,
    matdefMethod * matdefMethodIn,
    rentVal * lobandIn,
    rentVal * upbandIn,
    matdefMat * matdefMatIn);
  ~matdefTypeBand();
  void printSelf();
  matdefMating * get_matdefMating();
  void set_matdefMating(matdefMating * matdefMatingIn);
  matdefMethod * get_matdefMethod();
  void set_matdefMethod(matdefMethod * matdefMethodIn);
  rentVal * get_loband();
  void set_loband(rentVal * lobandIn);
  rentVal * get_upband();
  void set_upband(rentVal * upbandIn);
  matdefMat * get_matdefMat();
  void set_matdefMat(matdefMat * matdefMatIn);
private:
  matdefMating * a_matdefMating;
  matdefMethod * a_matdefMethod;
  rentVal * loband;
  rentVal * upband;
  matdefMat * a_matdefMat;
};

/********************************************************************/

/* matdefMating

This is a parent class.

*/

class matdefMating :
  public dmisCppBase
{
public:
  matdefMating();
  ~matdefMating();
  void printSelf() = 0;
};

/********************************************************************/

/* matdefMating_PT2PT

This is a derived class for one of the definitions of matdefMating.
It represents the following items:

PT2PT

*/

class matdefMating_PT2PT :
  public matdefMating
{
public:
  matdefMating_PT2PT();
  ~matdefMating_PT2PT();
  void printSelf();
};

/********************************************************************/

/* matdefMating_PT2LN

This is a derived class for one of the definitions of matdefMating.
It represents the following items:

PT2LN

*/

class matdefMating_PT2LN :
  public matdefMating
{
public:
  matdefMating_PT2LN();
  ~matdefMating_PT2LN();
  void printSelf();
};

/********************************************************************/

/* matdefMating_PT2PL

This is a derived class for one of the definitions of matdefMating.
It represents the following items:

PT2PL

*/

class matdefMating_PT2PL :
  public matdefMating
{
public:
  matdefMating_PT2PL();
  ~matdefMating_PT2PL();
  void printSelf();
};

/********************************************************************/

/* matdefMating_LN2LN

This is a derived class for one of the definitions of matdefMating.
It represents the following items:

LN2LN

*/

class matdefMating_LN2LN :
  public matdefMating
{
public:
  matdefMating_LN2LN();
  ~matdefMating_LN2LN();
  void printSelf();
};

/********************************************************************/

/* matdefMethod

This is a parent class.

*/

class matdefMethod :
  public dmisCppBase
{
public:
  matdefMethod();
  ~matdefMethod();
  void printSelf() = 0;
};

/********************************************************************/

/* matdefMethod_BF

This is a derived class for one of the definitions of matdefMethod.
It represents the following items:

BF

*/

class matdefMethod_BF :
  public matdefMethod
{
public:
  matdefMethod_BF();
  ~matdefMethod_BF();
  void printSelf();
};

/********************************************************************/

/* matdefMethod_FZ

This is a derived class for one of the definitions of matdefMethod.
It represents the following items:

FZ

*/

class matdefMethod_FZ :
  public matdefMethod
{
public:
  matdefMethod_FZ();
  ~matdefMethod_FZ();
  void printSelf();
};

/********************************************************************/

/* matdefMat

This is a parent class.

*/

class matdefMat :
  public dmisCppBase
{
public:
  matdefMat();
  ~matdefMat();
  void printSelf() = 0;
};

/********************************************************************/

/* matdefMat_MMC

This is a derived class for one of the definitions of matdefMat.
It represents the following items:

MMC ',' tLabel

*/

class matdefMat_MMC :
  public matdefMat
{
public:
  matdefMat_MMC();
  matdefMat_MMC(
    tLabel * tLabelIn);
  ~matdefMat_MMC();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
private:
  tLabel * a_tLabel;
};

/********************************************************************/

/* matdefMat_LMC

This is a derived class for one of the definitions of matdefMat.
It represents the following items:

LMC ',' tLabel

*/

class matdefMat_LMC :
  public matdefMat
{
public:
  matdefMat_LMC();
  matdefMat_LMC(
    tLabel * tLabelIn);
  ~matdefMat_LMC();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
private:
  tLabel * a_tLabel;
};

/********************************************************************/

/* measStm

This is a class for the single definition of measStm.
It represents the following items:

MEAS '/' measMinor fLabel ',' intVal #

*/

class measStm :
  public dmisStatement
{
public:
  measStm();
  measStm(
    measMinor * measMinorIn,
    fLabel * fLabelIn,
    intVal * numMeasIn);
  ~measStm();
  void printSelf();
  measMinor * get_measMinor();
  void set_measMinor(measMinor * measMinorIn);
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
private:
  measMinor * a_measMinor;
  fLabel * a_fLabel;
  intVal * numMeas;
};

/********************************************************************/

/* measMinor

This is a parent class.

*/

class measMinor :
  public dmisCppBase
{
public:
  measMinor();
  ~measMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* measMinorOther

This is a derived class for one of the definitions of measMinor.
It represents the following items:

measGeotype ','

*/

class measMinorOther :
  public measMinor
{
public:
  measMinorOther();
  measMinorOther(
    measGeotype * measGeotypeIn);
  ~measMinorOther();
  void printSelf();
  measGeotype * get_measGeotype();
  void set_measGeotype(measGeotype * measGeotypeIn);
private:
  measGeotype * a_measGeotype;
};

/********************************************************************/

/* measMinorPoint

This is a derived class for one of the definitions of measMinor.
It represents the following items:

POINT ','

*/

class measMinorPoint :
  public measMinor
{
public:
  measMinorPoint();
  ~measMinorPoint();
  void printSelf();
};

/********************************************************************/

/* measMinorComp

This is a derived class for one of the definitions of measMinor.
It represents the following items:

POINT ',' COMP ',' measVar2 ','

*/

class measMinorComp :
  public measMinor
{
public:
  measMinorComp();
  measMinorComp(
    measVar2 * measVar2In);
  ~measMinorComp();
  void printSelf();
  measVar2 * get_measVar2();
  void set_measVar2(measVar2 * measVar2In);
private:
  measVar2 * a_measVar2;
};

/********************************************************************/

/* measGeotype

This is a parent class.

*/

class measGeotype :
  public dmisCppBase
{
public:
  measGeotype();
  ~measGeotype();
  void printSelf() = 0;
};

/********************************************************************/

/* measGeotype_ARC

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

ARC

*/

class measGeotype_ARC :
  public measGeotype
{
public:
  measGeotype_ARC();
  ~measGeotype_ARC();
  void printSelf();
};

/********************************************************************/

/* measGeotype_CIRCLE

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

CIRCLE

*/

class measGeotype_CIRCLE :
  public measGeotype
{
public:
  measGeotype_CIRCLE();
  ~measGeotype_CIRCLE();
  void printSelf();
};

/********************************************************************/

/* measGeotype_CONE

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

CONE

*/

class measGeotype_CONE :
  public measGeotype
{
public:
  measGeotype_CONE();
  ~measGeotype_CONE();
  void printSelf();
};

/********************************************************************/

/* measGeotype_CONRADSEGMNT

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

CONRADSEGMNT

*/

class measGeotype_CONRADSEGMNT :
  public measGeotype
{
public:
  measGeotype_CONRADSEGMNT();
  ~measGeotype_CONRADSEGMNT();
  void printSelf();
};

/********************************************************************/

/* measGeotype_CPARLN

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

CPARLN

*/

class measGeotype_CPARLN :
  public measGeotype
{
public:
  measGeotype_CPARLN();
  ~measGeotype_CPARLN();
  void printSelf();
};

/********************************************************************/

/* measGeotype_CYLNDR

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

CYLNDR

*/

class measGeotype_CYLNDR :
  public measGeotype
{
public:
  measGeotype_CYLNDR();
  ~measGeotype_CYLNDR();
  void printSelf();
};

/********************************************************************/

/* measGeotype_CYLRADSEGMNT

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

CYLRADSEGMNT

*/

class measGeotype_CYLRADSEGMNT :
  public measGeotype
{
public:
  measGeotype_CYLRADSEGMNT();
  ~measGeotype_CYLRADSEGMNT();
  void printSelf();
};

/********************************************************************/

/* measGeotype_EDGEPT

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

EDGEPT

*/

class measGeotype_EDGEPT :
  public measGeotype
{
public:
  measGeotype_EDGEPT();
  ~measGeotype_EDGEPT();
  void printSelf();
};

/********************************************************************/

/* measGeotype_ELLIPS

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

ELLIPS

*/

class measGeotype_ELLIPS :
  public measGeotype
{
public:
  measGeotype_ELLIPS();
  ~measGeotype_ELLIPS();
  void printSelf();
};

/********************************************************************/

/* measGeotype_ELONGCYL

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

ELONGCYL

*/

class measGeotype_ELONGCYL :
  public measGeotype
{
public:
  measGeotype_ELONGCYL();
  ~measGeotype_ELONGCYL();
  void printSelf();
};

/********************************************************************/

/* measGeotype_GCURVE

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

GCURVE

*/

class measGeotype_GCURVE :
  public measGeotype
{
public:
  measGeotype_GCURVE();
  ~measGeotype_GCURVE();
  void printSelf();
};

/********************************************************************/

/* measGeotype_GSURF

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

GSURF

*/

class measGeotype_GSURF :
  public measGeotype
{
public:
  measGeotype_GSURF();
  ~measGeotype_GSURF();
  void printSelf();
};

/********************************************************************/

/* measGeotype_LINE

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

LINE

*/

class measGeotype_LINE :
  public measGeotype
{
public:
  measGeotype_LINE();
  ~measGeotype_LINE();
  void printSelf();
};

/********************************************************************/

/* measGeotype_OBJECT

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

OBJECT

*/

class measGeotype_OBJECT :
  public measGeotype
{
public:
  measGeotype_OBJECT();
  ~measGeotype_OBJECT();
  void printSelf();
};

/********************************************************************/

/* measGeotype_PARPLN

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

PARPLN

*/

class measGeotype_PARPLN :
  public measGeotype
{
public:
  measGeotype_PARPLN();
  ~measGeotype_PARPLN();
  void printSelf();
};

/********************************************************************/

/* measGeotype_PLANE

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

PLANE

*/

class measGeotype_PLANE :
  public measGeotype
{
public:
  measGeotype_PLANE();
  ~measGeotype_PLANE();
  void printSelf();
};

/********************************************************************/

/* measGeotype_REVSURF

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

REVSURF

*/

class measGeotype_REVSURF :
  public measGeotype
{
public:
  measGeotype_REVSURF();
  ~measGeotype_REVSURF();
  void printSelf();
};

/********************************************************************/

/* measGeotype_RCTNGL

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

RCTNGL

*/

class measGeotype_RCTNGL :
  public measGeotype
{
public:
  measGeotype_RCTNGL();
  ~measGeotype_RCTNGL();
  void printSelf();
};

/********************************************************************/

/* measGeotype_SPHERE

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

SPHERE

*/

class measGeotype_SPHERE :
  public measGeotype
{
public:
  measGeotype_SPHERE();
  ~measGeotype_SPHERE();
  void printSelf();
};

/********************************************************************/

/* measGeotype_SPHRADSEGMNT

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

SPHRADSEGMNT

*/

class measGeotype_SPHRADSEGMNT :
  public measGeotype
{
public:
  measGeotype_SPHRADSEGMNT();
  ~measGeotype_SPHRADSEGMNT();
  void printSelf();
};

/********************************************************************/

/* measGeotype_SYMPLN

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

SYMPLN

*/

class measGeotype_SYMPLN :
  public measGeotype
{
public:
  measGeotype_SYMPLN();
  ~measGeotype_SYMPLN();
  void printSelf();
};

/********************************************************************/

/* measGeotype_TORUS

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

TORUS

*/

class measGeotype_TORUS :
  public measGeotype
{
public:
  measGeotype_TORUS();
  ~measGeotype_TORUS();
  void printSelf();
};

/********************************************************************/

/* measGeotype_TORRADSEGMNT

This is a derived class for one of the definitions of measGeotype.
It represents the following items:

TORRADSEGMNT

*/

class measGeotype_TORRADSEGMNT :
  public measGeotype
{
public:
  measGeotype_TORRADSEGMNT();
  ~measGeotype_TORRADSEGMNT();
  void printSelf();
};

/********************************************************************/

/* measVar2

This is a parent class.

*/

class measVar2 :
  public dmisCppBase
{
public:
  measVar2();
  ~measVar2();
  void printSelf() = 0;
};

/********************************************************************/

/* measVar2_AXDIR

This is a derived class for one of the definitions of measVar2.
It represents the following items:

AXDIR

*/

class measVar2_AXDIR :
  public measVar2
{
public:
  measVar2_AXDIR();
  ~measVar2_AXDIR();
  void printSelf();
};

/********************************************************************/

/* measVar2_DME

This is a derived class for one of the definitions of measVar2.
It represents the following items:

DME

*/

class measVar2_DME :
  public measVar2
{
public:
  measVar2_DME();
  ~measVar2_DME();
  void printSelf();
};

/********************************************************************/

/* measVar2_FEAT

This is a derived class for one of the definitions of measVar2.
It represents the following items:

FEAT ',' measVar2Aux

*/

class measVar2_FEAT :
  public measVar2
{
public:
  measVar2_FEAT();
  measVar2_FEAT(
    measVar2Aux * measVar2AuxIn);
  ~measVar2_FEAT();
  void printSelf();
  measVar2Aux * get_measVar2Aux();
  void set_measVar2Aux(measVar2Aux * measVar2AuxIn);
private:
  measVar2Aux * a_measVar2Aux;
};

/********************************************************************/

/* measVar2_POL

This is a derived class for one of the definitions of measVar2.
It represents the following items:

POL

*/

class measVar2_POL :
  public measVar2
{
public:
  measVar2_POL();
  ~measVar2_POL();
  void printSelf();
};

/********************************************************************/

/* measVar2_SPH

This is a derived class for one of the definitions of measVar2.
It represents the following items:

SPH

*/

class measVar2_SPH :
  public measVar2
{
public:
  measVar2_SPH();
  ~measVar2_SPH();
  void printSelf();
};

/********************************************************************/

/* measVar2_VEC

This is a derived class for one of the definitions of measVar2.
It represents the following items:

VEC ',' vector

*/

class measVar2_VEC :
  public measVar2
{
public:
  measVar2_VEC();
  measVar2_VEC(
    vector * compDirIn);
  ~measVar2_VEC();
  void printSelf();
  vector * get_compDir();
  void set_compDir(vector * compDirIn);
private:
  vector * compDir;
};

/********************************************************************/

/* measVar2Aux

This is a parent class.

*/

class measVar2Aux :
  public dmisCppBase
{
public:
  measVar2Aux();
  ~measVar2Aux();
  void printSelf() = 0;
};

/********************************************************************/

/* mfgdevStm

This is a class for the single definition of mfgdevStm.
It represents the following items:

mdLabel '=' MFGDEV '/' stringVal #

*/

class mfgdevStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  mfgdevStm();
  mfgdevStm(
    mdLabel * mdLabelIn,
    stringVal * textIn);
  ~mfgdevStm();
  void printSelf();
  mdLabel * get_mdLabel();
  void set_mdLabel(mdLabel * mdLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  mdLabel * a_mdLabel;
  stringVal * text;
};

/********************************************************************/

/* modeStm

This is a class for the single definition of modeStm.
It represents the following items:

MODE '/' [AUTO ','] [PROG ','] MAN #

*/

class modeStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  modeStm();
  modeStm(
    bool has_AUTOIn,
    bool has_PROGIn);
  ~modeStm();
  void printSelf();
  bool get_has_AUTO();
  void set_has_AUTO(bool has_AUTOIn);
  bool get_has_PROG();
  void set_has_PROG(bool has_PROGIn);
private:
  bool has_AUTO;
  bool has_PROG;
};

/********************************************************************/

/* obtainLabeled

This is a parent class.

*/

class obtainLabeled :
  public dmisCppBase
{
public:
  obtainLabeled();
  ~obtainLabeled();
  void printSelf() = 0;
};

/********************************************************************/

/* obtainLabeled_datumLabel1

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

datumLabel1 ',' intVal

*/

class obtainLabeled_datumLabel1 :
  public obtainLabeled
{
public:
  obtainLabeled_datumLabel1();
  obtainLabeled_datumLabel1(
    datumLabel1 * datumLabel1In,
    intVal * indexIn);
  ~obtainLabeled_datumLabel1();
  void printSelf();
  datumLabel1 * get_datumLabel1();
  void set_datumLabel1(datumLabel1 * datumLabel1In);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  datumLabel1 * a_datumLabel1;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_featureLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

featureLabel ',' intVal

*/

class obtainLabeled_featureLabel :
  public obtainLabeled
{
public:
  obtainLabeled_featureLabel();
  obtainLabeled_featureLabel(
    featureLabel * featureLabelIn,
    intVal * indexIn);
  ~obtainLabeled_featureLabel();
  void printSelf();
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  featureLabel * a_featureLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_sensorLabel1

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

sensorLabel1 ',' intVal

*/

class obtainLabeled_sensorLabel1 :
  public obtainLabeled
{
public:
  obtainLabeled_sensorLabel1();
  obtainLabeled_sensorLabel1(
    sensorLabel1 * sensorLabel1In,
    intVal * indexIn);
  ~obtainLabeled_sensorLabel1();
  void printSelf();
  sensorLabel1 * get_sensorLabel1();
  void set_sensorLabel1(sensorLabel1 * sensorLabel1In);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  sensorLabel1 * a_sensorLabel1;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_toleranceLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

toleranceLabel ',' intVal

*/

class obtainLabeled_toleranceLabel :
  public obtainLabeled
{
public:
  obtainLabeled_toleranceLabel();
  obtainLabeled_toleranceLabel(
    toleranceLabel * toleranceLabelIn,
    intVal * indexIn);
  ~obtainLabeled_toleranceLabel();
  void printSelf();
  toleranceLabel * get_toleranceLabel();
  void set_toleranceLabel(toleranceLabel * toleranceLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  toleranceLabel * a_toleranceLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_didLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

didLabel ',' intVal

*/

class obtainLabeled_didLabel :
  public obtainLabeled
{
public:
  obtainLabeled_didLabel();
  obtainLabeled_didLabel(
    didLabel * didLabelIn,
    intVal * indexIn);
  ~obtainLabeled_didLabel();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  didLabel * a_didLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_qisLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

qisLabel ',' intVal

*/

class obtainLabeled_qisLabel :
  public obtainLabeled
{
public:
  obtainLabeled_qisLabel();
  obtainLabeled_qisLabel(
    qisLabel * qisLabelIn,
    intVal * indexIn);
  ~obtainLabeled_qisLabel();
  void printSelf();
  qisLabel * get_qisLabel();
  void set_qisLabel(qisLabel * qisLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  qisLabel * a_qisLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_crLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

crLabel ',' intVal

*/

class obtainLabeled_crLabel :
  public obtainLabeled
{
public:
  obtainLabeled_crLabel();
  obtainLabeled_crLabel(
    crLabel * crLabelIn,
    intVal * indexIn);
  ~obtainLabeled_crLabel();
  void printSelf();
  crLabel * get_crLabel();
  void set_crLabel(crLabel * crLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  crLabel * a_crLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_gLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

gLabel ',' intVal

*/

class obtainLabeled_gLabel :
  public obtainLabeled
{
public:
  obtainLabeled_gLabel();
  obtainLabeled_gLabel(
    gLabel * gLabelIn,
    intVal * indexIn);
  ~obtainLabeled_gLabel();
  void printSelf();
  gLabel * get_gLabel();
  void set_gLabel(gLabel * gLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  gLabel * a_gLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_gsaLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

gsaLabel ',' intVal

*/

class obtainLabeled_gsaLabel :
  public obtainLabeled
{
public:
  obtainLabeled_gsaLabel();
  obtainLabeled_gsaLabel(
    gsaLabel * gsaLabelIn,
    intVal * indexIn);
  ~obtainLabeled_gsaLabel();
  void printSelf();
  gsaLabel * get_gsaLabel();
  void set_gsaLabel(gsaLabel * gsaLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  gsaLabel * a_gsaLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_kcLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

kcLabel ',' intVal

*/

class obtainLabeled_kcLabel :
  public obtainLabeled
{
public:
  obtainLabeled_kcLabel();
  obtainLabeled_kcLabel(
    kcLabel * kcLabelIn,
    intVal * indexIn);
  ~obtainLabeled_kcLabel();
  void printSelf();
  kcLabel * get_kcLabel();
  void set_kcLabel(kcLabel * kcLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  kcLabel * a_kcLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_maLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

maLabel ',' intVal

*/

class obtainLabeled_maLabel :
  public obtainLabeled
{
public:
  obtainLabeled_maLabel();
  obtainLabeled_maLabel(
    maLabel * maLabelIn,
    intVal * indexIn);
  ~obtainLabeled_maLabel();
  void printSelf();
  maLabel * get_maLabel();
  void set_maLabel(maLabel * maLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  maLabel * a_maLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_pLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

pLabel ',' intVal

*/

class obtainLabeled_pLabel :
  public obtainLabeled
{
public:
  obtainLabeled_pLabel();
  obtainLabeled_pLabel(
    pLabel * pLabelIn,
    intVal * indexIn);
  ~obtainLabeled_pLabel();
  void printSelf();
  pLabel * get_pLabel();
  void set_pLabel(pLabel * pLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  pLabel * a_pLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_rLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

rLabel ',' intVal

*/

class obtainLabeled_rLabel :
  public obtainLabeled
{
public:
  obtainLabeled_rLabel();
  obtainLabeled_rLabel(
    rLabel * rLabelIn,
    intVal * indexIn);
  ~obtainLabeled_rLabel();
  void printSelf();
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  rLabel * a_rLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_rmLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

rmLabel ',' intVal

*/

class obtainLabeled_rmLabel :
  public obtainLabeled
{
public:
  obtainLabeled_rmLabel();
  obtainLabeled_rmLabel(
    rmLabel * rmLabelIn,
    intVal * indexIn);
  ~obtainLabeled_rmLabel();
  void printSelf();
  rmLabel * get_rmLabel();
  void set_rmLabel(rmLabel * rmLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  rmLabel * a_rmLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_rtLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

rtLabel ',' intVal

*/

class obtainLabeled_rtLabel :
  public obtainLabeled
{
public:
  obtainLabeled_rtLabel();
  obtainLabeled_rtLabel(
    rtLabel * rtLabelIn,
    intVal * indexIn);
  ~obtainLabeled_rtLabel();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  rtLabel * a_rtLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_sgLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

sgLabel ',' intVal

*/

class obtainLabeled_sgLabel :
  public obtainLabeled
{
public:
  obtainLabeled_sgLabel();
  obtainLabeled_sgLabel(
    sgLabel * sgLabelIn,
    intVal * indexIn);
  ~obtainLabeled_sgLabel();
  void printSelf();
  sgLabel * get_sgLabel();
  void set_sgLabel(sgLabel * sgLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  sgLabel * a_sgLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_sgsLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

sgsLabel ',' intVal

*/

class obtainLabeled_sgsLabel :
  public obtainLabeled
{
public:
  obtainLabeled_sgsLabel();
  obtainLabeled_sgsLabel(
    sgsLabel * sgsLabelIn,
    intVal * indexIn);
  ~obtainLabeled_sgsLabel();
  void printSelf();
  sgsLabel * get_sgsLabel();
  void set_sgsLabel(sgsLabel * sgsLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  sgsLabel * a_sgsLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_sraLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

sraLabel ',' intVal

*/

class obtainLabeled_sraLabel :
  public obtainLabeled
{
public:
  obtainLabeled_sraLabel();
  obtainLabeled_sraLabel(
    sraLabel * sraLabelIn,
    intVal * indexIn);
  ~obtainLabeled_sraLabel();
  void printSelf();
  sraLabel * get_sraLabel();
  void set_sraLabel(sraLabel * sraLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  sraLabel * a_sraLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_ssLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

ssLabel ',' intVal

*/

class obtainLabeled_ssLabel :
  public obtainLabeled
{
public:
  obtainLabeled_ssLabel();
  obtainLabeled_ssLabel(
    ssLabel * ssLabelIn,
    intVal * indexIn);
  ~obtainLabeled_ssLabel();
  void printSelf();
  ssLabel * get_ssLabel();
  void set_ssLabel(ssLabel * ssLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  ssLabel * a_ssLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_swLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

swLabel ',' intVal

*/

class obtainLabeled_swLabel :
  public obtainLabeled
{
public:
  obtainLabeled_swLabel();
  obtainLabeled_swLabel(
    swLabel * swLabelIn,
    intVal * indexIn);
  ~obtainLabeled_swLabel();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  swLabel * a_swLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_sxLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

sxLabel ',' intVal

*/

class obtainLabeled_sxLabel :
  public obtainLabeled
{
public:
  obtainLabeled_sxLabel();
  obtainLabeled_sxLabel(
    sxLabel * sxLabelIn,
    intVal * indexIn);
  ~obtainLabeled_sxLabel();
  void printSelf();
  sxLabel * get_sxLabel();
  void set_sxLabel(sxLabel * sxLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  sxLabel * a_sxLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_thLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

thLabel ',' intVal

*/

class obtainLabeled_thLabel :
  public obtainLabeled
{
public:
  obtainLabeled_thLabel();
  obtainLabeled_thLabel(
    thLabel * thLabelIn,
    intVal * indexIn);
  ~obtainLabeled_thLabel();
  void printSelf();
  thLabel * get_thLabel();
  void set_thLabel(thLabel * thLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  thLabel * a_thLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_vLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

vLabel ',' intVal

*/

class obtainLabeled_vLabel :
  public obtainLabeled
{
public:
  obtainLabeled_vLabel();
  obtainLabeled_vLabel(
    vLabel * vLabelIn,
    intVal * indexIn);
  ~obtainLabeled_vLabel();
  void printSelf();
  vLabel * get_vLabel();
  void set_vLabel(vLabel * vLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  vLabel * a_vLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_vaLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

vaLabel ',' intVal

*/

class obtainLabeled_vaLabel :
  public obtainLabeled
{
public:
  obtainLabeled_vaLabel();
  obtainLabeled_vaLabel(
    vaLabel * vaLabelIn,
    intVal * indexIn);
  ~obtainLabeled_vaLabel();
  void printSelf();
  vaLabel * get_vaLabel();
  void set_vaLabel(vaLabel * vaLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  vaLabel * a_vaLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_vfLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

vfLabel ',' intVal

*/

class obtainLabeled_vfLabel :
  public obtainLabeled
{
public:
  obtainLabeled_vfLabel();
  obtainLabeled_vfLabel(
    vfLabel * vfLabelIn,
    intVal * indexIn);
  ~obtainLabeled_vfLabel();
  void printSelf();
  vfLabel * get_vfLabel();
  void set_vfLabel(vfLabel * vfLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  vfLabel * a_vfLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_vlLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

vlLabel ',' intVal

*/

class obtainLabeled_vlLabel :
  public obtainLabeled
{
public:
  obtainLabeled_vlLabel();
  obtainLabeled_vlLabel(
    vlLabel * vlLabelIn,
    intVal * indexIn);
  ~obtainLabeled_vlLabel();
  void printSelf();
  vlLabel * get_vlLabel();
  void set_vlLabel(vlLabel * vlLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  vlLabel * a_vlLabel;
  intVal * index;
};

/********************************************************************/

/* obtainLabeled_vwLabel

This is a derived class for one of the definitions of obtainLabeled.
It represents the following items:

vwLabel ',' intVal

*/

class obtainLabeled_vwLabel :
  public obtainLabeled
{
public:
  obtainLabeled_vwLabel();
  obtainLabeled_vwLabel(
    vwLabel * vwLabelIn,
    intVal * indexIn);
  ~obtainLabeled_vwLabel();
  void printSelf();
  vwLabel * get_vwLabel();
  void set_vwLabel(vwLabel * vwLabelIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  vwLabel * a_vwLabel;
  intVal * index;
};

/********************************************************************/

/* obtainPoint

This is a class for the single definition of obtainPoint.
It represents the following items:

featureLabel '[' intVal ']' ',' intVal

*/

class obtainPoint :
  public dmisCppBase
{
public:
  obtainPoint();
  obtainPoint(
    featureLabel * featureLabelIn,
    intVal * subscrIn,
    intVal * indexIn);
  ~obtainPoint();
  void printSelf();
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  intVal * get_subscr();
  void set_subscr(intVal * subscrIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  featureLabel * a_featureLabel;
  intVal * subscr;
  intVal * index;
};

/********************************************************************/

/* openStm

This is a class for the single definition of openStm.
It represents the following items:

OPEN '/' openMinor #

*/

class openStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  openStm();
  openStm(
    openMinor * openMinorIn);
  ~openStm();
  void printSelf();
  openMinor * get_openMinor();
  void set_openMinor(openMinor * openMinorIn);
private:
  openMinor * a_openMinor;
};

/********************************************************************/

/* openMinor

This is a parent class.

*/

class openMinor :
  public dmisCppBase
{
public:
  openMinor();
  ~openMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* openMinor_openDevice

This is a derived class for one of the definitions of openMinor.
It represents the following items:

didLabel ',' openDevice

*/

class openMinor_openDevice :
  public openMinor
{
public:
  openMinor_openDevice();
  openMinor_openDevice(
    didLabel * didLabelIn,
    openDevice * openDeviceIn);
  ~openMinor_openDevice();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  openDevice * get_openDevice();
  void set_openDevice(openDevice * openDeviceIn);
private:
  didLabel * a_didLabel;
  openDevice * a_openDevice;
};

/********************************************************************/

/* openMinor_openFdata

This is a derived class for one of the definitions of openMinor.
It represents the following items:

didLabel ',' openFdata

*/

class openMinor_openFdata :
  public openMinor
{
public:
  openMinor_openFdata();
  openMinor_openFdata(
    didLabel * didLabelIn,
    openFdata * openFdataIn);
  ~openMinor_openFdata();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  openFdata * get_openFdata();
  void set_openFdata(openFdata * openFdataIn);
private:
  didLabel * a_didLabel;
  openFdata * a_openFdata;
};

/********************************************************************/

/* openMinor_openCadfile

This is a derived class for one of the definitions of openMinor.
It represents the following items:

didLabel ',' openCadfile

*/

class openMinor_openCadfile :
  public openMinor
{
public:
  openMinor_openCadfile();
  openMinor_openCadfile(
    didLabel * didLabelIn,
    openCadfile * openCadfileIn);
  ~openMinor_openCadfile();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  openCadfile * get_openCadfile();
  void set_openCadfile(openCadfile * openCadfileIn);
private:
  didLabel * a_didLabel;
  openCadfile * a_openCadfile;
};

/********************************************************************/

/* openMinor_storageSpecList

This is a derived class for one of the definitions of openMinor.
It represents the following items:

didLabel ',' storageSpecList

*/

class openMinor_storageSpecList :
  public openMinor
{
public:
  openMinor_storageSpecList();
  openMinor_storageSpecList(
    didLabel * didLabelIn,
    std::list<storageSpec *> * storageSpecListIn);
  ~openMinor_storageSpecList();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  std::list<storageSpec *> * get_storageSpecList();
  void set_storageSpecList(std::list<storageSpec *> * storageSpecListIn);
private:
  didLabel * a_didLabel;
  std::list<storageSpec *> * a_storageSpecList;
};

/********************************************************************/

/* openMinor_openDMLfile

This is a derived class for one of the definitions of openMinor.
It represents the following items:

didLabel ',' openDMLfile

*/

class openMinor_openDMLfile :
  public openMinor
{
public:
  openMinor_openDMLfile();
  openMinor_openDMLfile(
    didLabel * didLabelIn,
    openDMLfile * openDMLfileIn);
  ~openMinor_openDMLfile();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  openDMLfile * get_openDMLfile();
  void set_openDMLfile(openDMLfile * openDMLfileIn);
private:
  didLabel * a_didLabel;
  openDMLfile * a_openDMLfile;
};

/********************************************************************/

/* openDevice

This is a parent class.

*/

class openDevice :
  public dmisCppBase
{
public:
  openDevice();
  ~openDevice();
  void printSelf() = 0;
};

/********************************************************************/

/* openDevice_inputAccess

This is a derived class for one of the definitions of openDevice.
It represents the following items:

DIRECT ',' inputAccess

*/

class openDevice_inputAccess :
  public openDevice
{
public:
  openDevice_inputAccess();
  openDevice_inputAccess(
    inputAccess * inputAccessIn);
  ~openDevice_inputAccess();
  void printSelf();
  inputAccess * get_inputAccess();
  void set_inputAccess(inputAccess * inputAccessIn);
private:
  inputAccess * a_inputAccess;
};

/********************************************************************/

/* openDevice_outputAccess

This is a derived class for one of the definitions of openDevice.
It represents the following items:

DIRECT ',' outputAccess

*/

class openDevice_outputAccess :
  public openDevice
{
public:
  openDevice_outputAccess();
  openDevice_outputAccess(
    outputAccess * outputAccessIn);
  ~openDevice_outputAccess();
  void printSelf();
  outputAccess * get_outputAccess();
  void set_outputAccess(outputAccess * outputAccessIn);
private:
  outputAccess * a_outputAccess;
};

/********************************************************************/

/* inputAccess

This is a class for the single definition of inputAccess.
It represents the following items:

INPUT

*/

class inputAccess :
  public dmisCppBase
{
public:
  inputAccess();
  ~inputAccess();
  void printSelf();
};

/********************************************************************/

/* outputAccess

This is a parent class.

*/

class outputAccess :
  public dmisCppBase
{
public:
  outputAccess();
  ~outputAccess();
  void printSelf() = 0;
};

/********************************************************************/

/* outputAccessUnspec

This is a derived class for one of the definitions of outputAccess.
It represents the following items:

OUTPUT

*/

class outputAccessUnspec :
  public outputAccess
{
public:
  outputAccessUnspec();
  ~outputAccessUnspec();
  void printSelf();
};

/********************************************************************/

/* outputAccessAppend

This is a derived class for one of the definitions of outputAccess.
It represents the following items:

OUTPUT ',' APPEND

*/

class outputAccessAppend :
  public outputAccess
{
public:
  outputAccessAppend();
  ~outputAccessAppend();
  void printSelf();
};

/********************************************************************/

/* outputAccessOverwr

This is a derived class for one of the definitions of outputAccess.
It represents the following items:

OUTPUT ',' OVERWR

*/

class outputAccessOverwr :
  public outputAccess
{
public:
  outputAccessOverwr();
  ~outputAccessOverwr();
  void printSelf();
};

/********************************************************************/

/* openFdata

This is a parent class.

*/

class openFdata :
  public dmisCppBase
{
public:
  openFdata();
  ~openFdata();
  void printSelf() = 0;
};

/********************************************************************/

/* openFdata_vLabel

This is a derived class for one of the definitions of openFdata.
It represents the following items:

FDATA ',' vLabel ',' outputAccess

*/

class openFdata_vLabel :
  public openFdata
{
public:
  openFdata_vLabel();
  openFdata_vLabel(
    vLabel * vLabelIn,
    outputAccess * outputAccessIn);
  ~openFdata_vLabel();
  void printSelf();
  vLabel * get_vLabel();
  void set_vLabel(vLabel * vLabelIn);
  outputAccess * get_outputAccess();
  void set_outputAccess(outputAccess * outputAccessIn);
private:
  vLabel * a_vLabel;
  outputAccess * a_outputAccess;
};

/********************************************************************/

/* openFdata_DMIS

This is a derived class for one of the definitions of openFdata.
It represents the following items:

FDATA ',' DMIS ',' outputAccess

*/

class openFdata_DMIS :
  public openFdata
{
public:
  openFdata_DMIS();
  openFdata_DMIS(
    outputAccess * outputAccessIn);
  ~openFdata_DMIS();
  void printSelf();
  outputAccess * get_outputAccess();
  void set_outputAccess(outputAccess * outputAccessIn);
private:
  outputAccess * a_outputAccess;
};

/********************************************************************/

/* openCadfile

This is a class for the single definition of openCadfile.
It represents the following items:

CAD [',' cadfileType]

*/

class openCadfile :
  public dmisCppBase
{
public:
  openCadfile();
  openCadfile(
    cadfileType * cadfileTypeIn);
  ~openCadfile();
  void printSelf();
  cadfileType * get_cadfileType();
  void set_cadfileType(cadfileType * cadfileTypeIn);
private:
  cadfileType * a_cadfileType;
};

/********************************************************************/

/* cadfileType

This is a parent class.

*/

class cadfileType :
  public dmisCppBase
{
public:
  cadfileType();
  ~cadfileType();
  void printSelf() = 0;
};

/********************************************************************/

/* cadfileType_STEP

This is a derived class for one of the definitions of cadfileType.
It represents the following items:

STEP

*/

class cadfileType_STEP :
  public cadfileType
{
public:
  cadfileType_STEP();
  ~cadfileType_STEP();
  void printSelf();
};

/********************************************************************/

/* cadfileType_IGES

This is a derived class for one of the definitions of cadfileType.
It represents the following items:

IGES

*/

class cadfileType_IGES :
  public cadfileType
{
public:
  cadfileType_IGES();
  ~cadfileType_IGES();
  void printSelf();
};

/********************************************************************/

/* cadfileType_VENDOR

This is a derived class for one of the definitions of cadfileType.
It represents the following items:

VENDOR ',' stringVal

*/

class cadfileType_VENDOR :
  public cadfileType
{
public:
  cadfileType_VENDOR();
  cadfileType_VENDOR(
    stringVal * textIn);
  ~cadfileType_VENDOR();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* storageSpec

This is a parent class.

*/

class storageSpec :
  public dmisCppBase
{
public:
  storageSpec();
  ~storageSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* storageSpec_SNS

This is a derived class for one of the definitions of storageSpec.
It represents the following items:

SNS

*/

class storageSpec_SNS :
  public storageSpec
{
public:
  storageSpec_SNS();
  ~storageSpec_SNS();
  void printSelf();
};

/********************************************************************/

/* storageSpec_PCS

This is a derived class for one of the definitions of storageSpec.
It represents the following items:

PCS

*/

class storageSpec_PCS :
  public storageSpec
{
public:
  storageSpec_PCS();
  ~storageSpec_PCS();
  void printSelf();
};

/********************************************************************/

/* storageSpec_FEATUR

This is a derived class for one of the definitions of storageSpec.
It represents the following items:

FEATUR

*/

class storageSpec_FEATUR :
  public storageSpec
{
public:
  storageSpec_FEATUR();
  ~storageSpec_FEATUR();
  void printSelf();
};

/********************************************************************/

/* storageSpec_RTAB

This is a derived class for one of the definitions of storageSpec.
It represents the following items:

RTAB

*/

class storageSpec_RTAB :
  public storageSpec
{
public:
  storageSpec_RTAB();
  ~storageSpec_RTAB();
  void printSelf();
};

/********************************************************************/

/* openDMLfile

This is a parent class.

*/

class openDMLfile :
  public dmisCppBase
{
public:
  openDMLfile();
  ~openDMLfile();
  void printSelf() = 0;
};

/********************************************************************/

/* openDmlInput

This is a derived class for one of the definitions of openDMLfile.
It represents the following items:

DML ',' stringVal ',' INPUT

*/

class openDmlInput :
  public openDMLfile
{
public:
  openDmlInput();
  openDmlInput(
    stringVal * versionIn);
  ~openDmlInput();
  void printSelf();
  stringVal * get_version();
  void set_version(stringVal * versionIn);
private:
  stringVal * version;
};

/********************************************************************/

/* openDmlOutput

This is a derived class for one of the definitions of openDMLfile.
It represents the following items:

DML ',' stringVal ',' OUTPUT ',' PTDATA ',' state

*/

class openDmlOutput :
  public openDMLfile
{
public:
  openDmlOutput();
  openDmlOutput(
    stringVal * versionIn,
    state * stateIn);
  ~openDmlOutput();
  void printSelf();
  stringVal * get_version();
  void set_version(stringVal * versionIn);
  state * get_state();
  void set_state(state * stateIn);
private:
  stringVal * version;
  state * a_state;
};

/********************************************************************/

/* operidStm

This is a class for the single definition of operidStm.
It represents the following items:

opLabel '=' OPERID '/' stringVal #

*/

class operidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  operidStm();
  operidStm(
    opLabel * opLabelIn,
    stringVal * textIn);
  ~operidStm();
  void printSelf();
  opLabel * get_opLabel();
  void set_opLabel(opLabel * opLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  opLabel * a_opLabel;
  stringVal * text;
};

/********************************************************************/

/* outputStm

This is a class for the single definition of outputStm.
It represents the following items:

OUTPUT '/' outputMinor #

*/

class outputStm :
  public evalOrOutput,
  public dmisFreeStatement,
  public dmisStatement
{
public:
  outputStm();
  outputStm(
    outputMinor * outputMinorIn);
  ~outputStm();
  void printSelf();
  outputMinor * get_outputMinor();
  void set_outputMinor(outputMinor * outputMinorIn);
private:
  outputMinor * a_outputMinor;
};

/********************************************************************/

/* outputMinor

This is a parent class.

*/

class outputMinor :
  public dmisCppBase
{
public:
  outputMinor();
  ~outputMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* outputFeatData

This is a parent class.

*/

class outputFeatData :
  public outputMinor
{
public:
  outputFeatData();
  ~outputFeatData();
  void printSelf() = 0;
};

/********************************************************************/

/* outputFeat

This is a parent class.

*/

class outputFeat :
  public outputFeatData
{
public:
  outputFeat();
  ~outputFeat();
  void printSelf() = 0;
};

/********************************************************************/

/* outputFeat1F

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

fLabel [pointRange] [',' rLabel]

*/

class outputFeat1F :
  public outputFeat
{
public:
  outputFeat1F();
  outputFeat1F(
    fLabel * fIn,
    pointRange * pointRangeIn,
    rLabel * rLabelIn);
  ~outputFeat1F();
  void printSelf();
  fLabel * get_f();
  void set_f(fLabel * fIn);
  pointRange * get_pointRange();
  void set_pointRange(pointRange * pointRangeIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  fLabel * f;
  pointRange * a_pointRange;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputFeat1Fa

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

faLabel [pointRange] [',' rLabel]

*/

class outputFeat1Fa :
  public outputFeat
{
public:
  outputFeat1Fa();
  outputFeat1Fa(
    faLabel * faIn,
    pointRange * pointRangeIn,
    rLabel * rLabelIn);
  ~outputFeat1Fa();
  void printSelf();
  faLabel * get_fa();
  void set_fa(faLabel * faIn);
  pointRange * get_pointRange();
  void set_pointRange(pointRange * pointRangeIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  faLabel * fa;
  pointRange * a_pointRange;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputFeat2FFaTa

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

fLabel ',' faLabel ',' taLabel [',' rLabel]

*/

class outputFeat2FFaTa :
  public outputFeat
{
public:
  outputFeat2FFaTa();
  outputFeat2FFaTa(
    fLabel * fIn,
    faLabel * faIn,
    taLabel * taIn,
    rLabel * rLabelIn);
  ~outputFeat2FFaTa();
  void printSelf();
  fLabel * get_f();
  void set_f(fLabel * fIn);
  faLabel * get_fa();
  void set_fa(faLabel * faIn);
  taLabel * get_ta();
  void set_ta(taLabel * taIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  fLabel * f;
  faLabel * fa;
  taLabel * ta;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputFeat2FaFaTa

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

faLabel ',' faLabel ',' taLabel [',' rLabel]

*/

class outputFeat2FaFaTa :
  public outputFeat
{
public:
  outputFeat2FaFaTa();
  outputFeat2FaFaTa(
    faLabel * fa1In,
    faLabel * fa2In,
    taLabel * taIn,
    rLabel * rLabelIn);
  ~outputFeat2FaFaTa();
  void printSelf();
  faLabel * get_fa1();
  void set_fa1(faLabel * fa1In);
  faLabel * get_fa2();
  void set_fa2(faLabel * fa2In);
  taLabel * get_ta();
  void set_ta(taLabel * taIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  faLabel * fa1;
  faLabel * fa2;
  taLabel * ta;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputFeat2FFT

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

fLabel ',' fLabel ',' tLabel [',' rLabel]

*/

class outputFeat2FFT :
  public outputFeat
{
public:
  outputFeat2FFT();
  outputFeat2FFT(
    fLabel * f1In,
    fLabel * f2In,
    tLabel * tIn,
    rLabel * rLabelIn);
  ~outputFeat2FFT();
  void printSelf();
  fLabel * get_f1();
  void set_f1(fLabel * f1In);
  fLabel * get_f2();
  void set_f2(fLabel * f2In);
  tLabel * get_t();
  void set_t(tLabel * tIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  fLabel * f1;
  fLabel * f2;
  tLabel * t;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputFeat2FaFTa

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

faLabel ',' fLabel ',' taLabel [',' rLabel]

*/

class outputFeat2FaFTa :
  public outputFeat
{
public:
  outputFeat2FaFTa();
  outputFeat2FaFTa(
    faLabel * faIn,
    fLabel * fIn,
    taLabel * taIn,
    rLabel * rLabelIn);
  ~outputFeat2FaFTa();
  void printSelf();
  faLabel * get_fa();
  void set_fa(faLabel * faIn);
  fLabel * get_f();
  void set_f(fLabel * fIn);
  taLabel * get_ta();
  void set_ta(taLabel * taIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  faLabel * fa;
  fLabel * f;
  taLabel * ta;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputFeat1FT

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

fLabel [pointRange] ',' tLabelList [',' rLabel]

*/

class outputFeat1FT :
  public outputFeat
{
public:
  outputFeat1FT();
  outputFeat1FT(
    fLabel * fIn,
    pointRange * pointRangeIn,
    std::list<tLabel *> * tLabelListIn,
    rLabel * rLabelIn);
  ~outputFeat1FT();
  void printSelf();
  fLabel * get_f();
  void set_f(fLabel * fIn);
  pointRange * get_pointRange();
  void set_pointRange(pointRange * pointRangeIn);
  std::list<tLabel *> * get_tLabelList();
  void set_tLabelList(std::list<tLabel *> * tLabelListIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  fLabel * f;
  pointRange * a_pointRange;
  std::list<tLabel *> * a_tLabelList;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputFeat1FaTa

This is a derived class for one of the definitions of outputFeat.
It represents the following items:

faLabel [pointRange] ',' taLabelList [',' rLabel]

*/

class outputFeat1FaTa :
  public outputFeat
{
public:
  outputFeat1FaTa();
  outputFeat1FaTa(
    faLabel * faIn,
    pointRange * pointRangeIn,
    std::list<taLabel *> * taLabelListIn,
    rLabel * rLabelIn);
  ~outputFeat1FaTa();
  void printSelf();
  faLabel * get_fa();
  void set_fa(faLabel * faIn);
  pointRange * get_pointRange();
  void set_pointRange(pointRange * pointRangeIn);
  std::list<taLabel *> * get_taLabelList();
  void set_taLabelList(std::list<taLabel *> * taLabelListIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  faLabel * fa;
  pointRange * a_pointRange;
  std::list<taLabel *> * a_taLabelList;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputDat

This is a parent class.

*/

class outputDat :
  public outputFeatData
{
public:
  outputDat();
  ~outputDat();
  void printSelf() = 0;
};

/********************************************************************/

/* outputDat_datLabel

This is a derived class for one of the definitions of outputDat.
It represents the following items:

datLabel ',' faLabel ',' taLabel [',' rLabel]

*/

class outputDat_datLabel :
  public outputDat
{
public:
  outputDat_datLabel();
  outputDat_datLabel(
    datLabel * datLabelIn,
    faLabel * faLabelIn,
    taLabel * taLabelIn,
    rLabel * rLabelIn);
  ~outputDat_datLabel();
  void printSelf();
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  datLabel * a_datLabel;
  faLabel * a_faLabel;
  taLabel * a_taLabel;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputDat_faLabel

This is a derived class for one of the definitions of outputDat.
It represents the following items:

faLabel ',' datLabel ',' taLabel [',' rLabel]

*/

class outputDat_faLabel :
  public outputDat
{
public:
  outputDat_faLabel();
  outputDat_faLabel(
    faLabel * faLabelIn,
    datLabel * datLabelIn,
    taLabel * taLabelIn,
    rLabel * rLabelIn);
  ~outputDat_faLabel();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
private:
  faLabel * a_faLabel;
  datLabel * a_datLabel;
  taLabel * a_taLabel;
  rLabel * a_rLabel;
};

/********************************************************************/

/* outputReportData

This is a parent class.

*/

class outputReportData :
  public outputMinor
{
public:
  outputReportData();
  ~outputReportData();
  void printSelf() = 0;
};

/********************************************************************/

/* outputConstData

This is a parent class.

*/

class outputConstData :
  public outputMinor
{
public:
  outputConstData();
  ~outputConstData();
  void printSelf() = 0;
};

/********************************************************************/

/* outputConstGaugeData

This is a derived class for one of the definitions of outputConstData.
It represents the following items:

seLabel

*/

class outputConstGaugeData :
  public outputConstData
{
public:
  outputConstGaugeData();
  outputConstGaugeData(
    seLabel * seLabelIn);
  ~outputConstGaugeData();
  void printSelf();
  seLabel * get_seLabel();
  void set_seLabel(seLabel * seLabelIn);
private:
  seLabel * a_seLabel;
};

/********************************************************************/

/* outputConstPartData

This is a derived class for one of the definitions of outputConstData.
It represents the following items:

stLabel

*/

class outputConstPartData :
  public outputConstData
{
public:
  outputConstPartData();
  outputConstPartData(
    stLabel * stLabelIn);
  ~outputConstPartData();
  void printSelf();
  stLabel * get_stLabel();
  void set_stLabel(stLabel * stLabelIn);
private:
  stLabel * a_stLabel;
};

/********************************************************************/

/* outputConstBothData

This is a derived class for one of the definitions of outputConstData.
It represents the following items:

stLabel ',' seLabel ',' toleranceLabel

*/

class outputConstBothData :
  public outputConstData
{
public:
  outputConstBothData();
  outputConstBothData(
    stLabel * stLabelIn,
    seLabel * seLabelIn,
    toleranceLabel * toleranceLabelIn);
  ~outputConstBothData();
  void printSelf();
  stLabel * get_stLabel();
  void set_stLabel(stLabel * stLabelIn);
  seLabel * get_seLabel();
  void set_seLabel(seLabel * seLabelIn);
  toleranceLabel * get_toleranceLabel();
  void set_toleranceLabel(toleranceLabel * toleranceLabelIn);
private:
  stLabel * a_stLabel;
  seLabel * a_seLabel;
  toleranceLabel * a_toleranceLabel;
};

/********************************************************************/

/* outputKeycharData

This is a parent class.

*/

class outputKeycharData :
  public outputMinor
{
public:
  outputKeycharData();
  ~outputKeycharData();
  void printSelf() = 0;
};

/********************************************************************/

/* outputToleranceData

This is a parent class.

*/

class outputToleranceData :
  public outputMinor
{
public:
  outputToleranceData();
  ~outputToleranceData();
  void printSelf() = 0;
};

/********************************************************************/

/* outputSensorData

This is a parent class.

*/

class outputSensorData :
  public outputMinor
{
public:
  outputSensorData();
  ~outputSensorData();
  void printSelf() = 0;
};

/********************************************************************/

/* outputSensorData_sLabel

This is a derived class for one of the definitions of outputSensorData.
It represents the following items:

sLabel

*/

class outputSensorData_sLabel :
  public outputSensorData
{
public:
  outputSensorData_sLabel();
  outputSensorData_sLabel(
    sLabel * sLabelIn);
  ~outputSensorData_sLabel();
  void printSelf();
  sLabel * get_sLabel();
  void set_sLabel(sLabel * sLabelIn);
private:
  sLabel * a_sLabel;
};

/********************************************************************/

/* outputSensorData_saLabel

This is a derived class for one of the definitions of outputSensorData.
It represents the following items:

saLabel [',' outputSensorDesc]

*/

class outputSensorData_saLabel :
  public outputSensorData
{
public:
  outputSensorData_saLabel();
  outputSensorData_saLabel(
    saLabel * saLabelIn,
    outputSensorDesc * outputSensorDescIn);
  ~outputSensorData_saLabel();
  void printSelf();
  saLabel * get_saLabel();
  void set_saLabel(saLabel * saLabelIn);
  outputSensorDesc * get_outputSensorDesc();
  void set_outputSensorDesc(outputSensorDesc * outputSensorDescIn);
private:
  saLabel * a_saLabel;
  outputSensorDesc * a_outputSensorDesc;
};

/********************************************************************/

/* outputSensorDesc

This is a parent class.

*/

class outputSensorDesc :
  public dmisCppBase
{
public:
  outputSensorDesc();
  ~outputSensorDesc();
  void printSelf() = 0;
};

/********************************************************************/

/* outputSensorDesc_stringVal

This is a derived class for one of the definitions of outputSensorDesc.
It represents the following items:

stringVal [',' outputSensorWristList]

*/

class outputSensorDesc_stringVal :
  public outputSensorDesc
{
public:
  outputSensorDesc_stringVal();
  outputSensorDesc_stringVal(
    stringVal * descIn,
    std::list<outputSensorWristItem *> * outputSensorWristListIn);
  ~outputSensorDesc_stringVal();
  void printSelf();
  stringVal * get_desc();
  void set_desc(stringVal * descIn);
  std::list<outputSensorWristItem *> * get_outputSensorWristList();
  void set_outputSensorWristList(std::list<outputSensorWristItem *> * outputSensorWristListIn);
private:
  stringVal * desc;
  std::list<outputSensorWristItem *> * a_outputSensorWristList;
};

/********************************************************************/

/* outputSensorDesc_intVal

This is a derived class for one of the definitions of outputSensorDesc.
It represents the following items:

intVal [',' outputSensorWristList]

*/

class outputSensorDesc_intVal :
  public outputSensorDesc
{
public:
  outputSensorDesc_intVal();
  outputSensorDesc_intVal(
    intVal * tipnumIn,
    std::list<outputSensorWristItem *> * outputSensorWristListIn);
  ~outputSensorDesc_intVal();
  void printSelf();
  intVal * get_tipnum();
  void set_tipnum(intVal * tipnumIn);
  std::list<outputSensorWristItem *> * get_outputSensorWristList();
  void set_outputSensorWristList(std::list<outputSensorWristItem *> * outputSensorWristListIn);
private:
  intVal * tipnum;
  std::list<outputSensorWristItem *> * a_outputSensorWristList;
};

/********************************************************************/

/* outputSensorDesc_outputSensorWristList

This is a derived class for one of the definitions of outputSensorDesc.
It represents the following items:

outputSensorWristList

*/

class outputSensorDesc_outputSensorWristList :
  public outputSensorDesc
{
public:
  outputSensorDesc_outputSensorWristList();
  outputSensorDesc_outputSensorWristList(
    std::list<outputSensorWristItem *> * outputSensorWristListIn);
  ~outputSensorDesc_outputSensorWristList();
  void printSelf();
  std::list<outputSensorWristItem *> * get_outputSensorWristList();
  void set_outputSensorWristList(std::list<outputSensorWristItem *> * outputSensorWristListIn);
private:
  std::list<outputSensorWristItem *> * a_outputSensorWristList;
};

/********************************************************************/

/* outputSensorDesc_CURENT

This is a derived class for one of the definitions of outputSensorDesc.
It represents the following items:

CURENT

*/

class outputSensorDesc_CURENT :
  public outputSensorDesc
{
public:
  outputSensorDesc_CURENT();
  ~outputSensorDesc_CURENT();
  void printSelf();
};

/********************************************************************/

/* outputSensorWristItem

This is a class for the single definition of outputSensorWristItem.
It represents the following items:

swLabel ',' outputSensorWristAngleList

*/

class outputSensorWristItem :
  public dmisCppBase
{
public:
  outputSensorWristItem();
  outputSensorWristItem(
    swLabel * swLabelIn,
    std::list<outputSensorWristAngle *> * outputSensorWristAngleListIn);
  ~outputSensorWristItem();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  std::list<outputSensorWristAngle *> * get_outputSensorWristAngleList();
  void set_outputSensorWristAngleList(std::list<outputSensorWristAngle *> * outputSensorWristAngleListIn);
private:
  swLabel * a_swLabel;
  std::list<outputSensorWristAngle *> * a_outputSensorWristAngleList;
};

/********************************************************************/

/* outputSensorWristAngle

This is a class for the single definition of outputSensorWristAngle.
It represents the following items:

stringVal ',' angle

*/

class outputSensorWristAngle :
  public dmisCppBase
{
public:
  outputSensorWristAngle();
  outputSensorWristAngle(
    stringVal * anglenameIn,
    angle * angleIn);
  ~outputSensorWristAngle();
  void printSelf();
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  stringVal * anglename;
  angle * a_angle;
};

/********************************************************************/

/* pameasMinor

This is a parent class.

*/

class pameasMinor :
  public dmisCppBase
{
public:
  pameasMinor();
  ~pameasMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* pameasMinor_pameasVar2List

This is a derived class for one of the definitions of pameasMinor.
It represents the following items:

pameasVar2List

*/

class pameasMinor_pameasVar2List :
  public pameasMinor
{
public:
  pameasMinor_pameasVar2List();
  pameasMinor_pameasVar2List(
    std::list<pameasVar2ListItem *> * pameasVar2ListIn);
  ~pameasMinor_pameasVar2List();
  void printSelf();
  std::list<pameasVar2ListItem *> * get_pameasVar2List();
  void set_pameasVar2List(std::list<pameasVar2ListItem *> * pameasVar2ListIn);
private:
  std::list<pameasVar2ListItem *> * a_pameasVar2List;
};

/********************************************************************/

/* pameasMinor_pameasVar3List

This is a derived class for one of the definitions of pameasMinor.
It represents the following items:

pameasVar3List

*/

class pameasMinor_pameasVar3List :
  public pameasMinor
{
public:
  pameasMinor_pameasVar3List();
  pameasMinor_pameasVar3List(
    std::list<pameasVar3ListItem *> * pameasVar3ListIn);
  ~pameasMinor_pameasVar3List();
  void printSelf();
  std::list<pameasVar3ListItem *> * get_pameasVar3List();
  void set_pameasVar3List(std::list<pameasVar3ListItem *> * pameasVar3ListIn);
private:
  std::list<pameasVar3ListItem *> * a_pameasVar3List;
};

/********************************************************************/

/* pameasDetail

This is a parent class.

*/

class pameasDetail :
  public dmisCppBase
{
public:
  pameasDetail();
  ~pameasDetail();
  void printSelf() = 0;
};

/********************************************************************/

/* pameasDetailDistance

This is a derived class for one of the definitions of pameasDetail.
It represents the following items:

DISTANCE ',' rentVal [',' SCNVEL ',' pameasFedrat] [',' PITCH ',' rentVal]

*/

class pameasDetailDistance :
  public pameasDetail
{
public:
  pameasDetailDistance();
  pameasDetailDistance(
    rentVal * distIn,
    pameasFedrat * feedIn,
    rentVal * pitchIn);
  ~pameasDetailDistance();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
  pameasFedrat * get_feed();
  void set_feed(pameasFedrat * feedIn);
  rentVal * get_pitch();
  void set_pitch(rentVal * pitchIn);
private:
  rentVal * dist;
  pameasFedrat * feed;
  rentVal * pitch;
};

/********************************************************************/

/* pameasDetailScnvelData

This is a derived class for one of the definitions of pameasDetail.
It represents the following items:

SCNVEL ',' pameasFedrat [',' PITCH ',' rentVal]

*/

class pameasDetailScnvelData :
  public pameasDetail
{
public:
  pameasDetailScnvelData();
  pameasDetailScnvelData(
    pameasFedrat * feedIn,
    rentVal * pitchIn);
  ~pameasDetailScnvelData();
  void printSelf();
  pameasFedrat * get_feed();
  void set_feed(pameasFedrat * feedIn);
  rentVal * get_pitch();
  void set_pitch(rentVal * pitchIn);
private:
  pameasFedrat * feed;
  rentVal * pitch;
};

/********************************************************************/

/* pameasDetailPitch

This is a derived class for one of the definitions of pameasDetail.
It represents the following items:

PITCH ',' rentVal

*/

class pameasDetailPitch :
  public pameasDetail
{
public:
  pameasDetailPitch();
  pameasDetailPitch(
    rentVal * pitchIn);
  ~pameasDetailPitch();
  void printSelf();
  rentVal * get_pitch();
  void set_pitch(rentVal * pitchIn);
private:
  rentVal * pitch;
};

/********************************************************************/

/* pameasDetailNoData

This is a derived class for one of the definitions of pameasDetail.
It represents the following items:

NODATA

*/

class pameasDetailNoData :
  public pameasDetail
{
public:
  pameasDetailNoData();
  ~pameasDetailNoData();
  void printSelf();
};

/********************************************************************/

/* pameasDetailScnvelNoData

This is a derived class for one of the definitions of pameasDetail.
It represents the following items:

SCNVEL ',' pameasFedrat ',' NODATA

*/

class pameasDetailScnvelNoData :
  public pameasDetail
{
public:
  pameasDetailScnvelNoData();
  pameasDetailScnvelNoData(
    pameasFedrat * feedIn);
  ~pameasDetailScnvelNoData();
  void printSelf();
  pameasFedrat * get_feed();
  void set_feed(pameasFedrat * feedIn);
private:
  pameasFedrat * feed;
};

/********************************************************************/

/* pameasVar2ListItem

This is a class for the single definition of pameasVar2ListItem.
It represents the following items:

pameasDetail ',' pLabel [',' vector] [',' SELFCENTER ',' vector [',' forceOrDeflection]] [',' pameasRemove] [',' ROTARY ',' rtLabel]

*/

class pameasVar2ListItem :
  public dmisCppBase
{
public:
  pameasVar2ListItem();
  pameasVar2ListItem(
    pameasDetail * pameasDetailIn,
    pLabel * pLabelIn,
    vector * apprchIn,
    vector * forceVecIn,
    forceOrDeflection * forceOrDeflectionIn,
    pameasRemove * pameasRemoveIn,
    rtLabel * rtLabelIn);
  ~pameasVar2ListItem();
  void printSelf();
  pameasDetail * get_pameasDetail();
  void set_pameasDetail(pameasDetail * pameasDetailIn);
  pLabel * get_pLabel();
  void set_pLabel(pLabel * pLabelIn);
  vector * get_apprch();
  void set_apprch(vector * apprchIn);
  vector * get_forceVec();
  void set_forceVec(vector * forceVecIn);
  forceOrDeflection * get_forceOrDeflection();
  void set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn);
  pameasRemove * get_pameasRemove();
  void set_pameasRemove(pameasRemove * pameasRemoveIn);
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
private:
  pameasDetail * a_pameasDetail;
  pLabel * a_pLabel;
  vector * apprch;
  vector * forceVec;
  forceOrDeflection * a_forceOrDeflection;
  pameasRemove * a_pameasRemove;
  rtLabel * a_rtLabel;
};

/********************************************************************/

/* pameasVar3ListItem

This is a class for the single definition of pameasVar3ListItem.
It represents the following items:

pLabel [',' vector] [',' SELFCENTER ',' vector [',' forceOrDeflection]] [',' pameasRemove] [',' ROTARY ',' rtLabel]

*/

class pameasVar3ListItem :
  public dmisCppBase
{
public:
  pameasVar3ListItem();
  pameasVar3ListItem(
    pLabel * pLabelIn,
    vector * apprchIn,
    vector * forceVecIn,
    forceOrDeflection * forceOrDeflectionIn,
    pameasRemove * pameasRemoveIn,
    rtLabel * rtLabelIn);
  ~pameasVar3ListItem();
  void printSelf();
  pLabel * get_pLabel();
  void set_pLabel(pLabel * pLabelIn);
  vector * get_apprch();
  void set_apprch(vector * apprchIn);
  vector * get_forceVec();
  void set_forceVec(vector * forceVecIn);
  forceOrDeflection * get_forceOrDeflection();
  void set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn);
  pameasRemove * get_pameasRemove();
  void set_pameasRemove(pameasRemove * pameasRemoveIn);
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
private:
  pLabel * a_pLabel;
  vector * apprch;
  vector * forceVec;
  forceOrDeflection * a_forceOrDeflection;
  pameasRemove * a_pameasRemove;
  rtLabel * a_rtLabel;
};

/********************************************************************/

/* pameasRemove

This is a parent class.

*/

class pameasRemove :
  public dmisCppBase
{
public:
  pameasRemove();
  ~pameasRemove();
  void printSelf() = 0;
};

/********************************************************************/

/* pameasRemoveCount

This is a derived class for one of the definitions of pameasRemove.
It represents the following items:

REMOVE ',' COUNT ',' intVal ',' intVal

*/

class pameasRemoveCount :
  public pameasRemove
{
public:
  pameasRemoveCount();
  pameasRemoveCount(
    intVal * numPt1In,
    intVal * numPt2In);
  ~pameasRemoveCount();
  void printSelf();
  intVal * get_numPt1();
  void set_numPt1(intVal * numPt1In);
  intVal * get_numPt2();
  void set_numPt2(intVal * numPt2In);
private:
  intVal * numPt1;
  intVal * numPt2;
};

/********************************************************************/

/* pameasRemoveDist

This is a derived class for one of the definitions of pameasRemove.
It represents the following items:

REMOVE ',' DIST ',' rentVal ',' rentVal

*/

class pameasRemoveDist :
  public pameasRemove
{
public:
  pameasRemoveDist();
  pameasRemoveDist(
    rentVal * dist1In,
    rentVal * dist2In);
  ~pameasRemoveDist();
  void printSelf();
  rentVal * get_dist1();
  void set_dist1(rentVal * dist1In);
  rentVal * get_dist2();
  void set_dist2(rentVal * dist2In);
private:
  rentVal * dist1;
  rentVal * dist2;
};

/********************************************************************/

/* pameasRemoveAll

This is a derived class for one of the definitions of pameasRemove.
It represents the following items:

REMOVE ',' ALL

*/

class pameasRemoveAll :
  public pameasRemove
{
public:
  pameasRemoveAll();
  ~pameasRemoveAll();
  void printSelf();
};

/********************************************************************/

/* pameasFedrat

This is a parent class.

*/

class pameasFedrat :
  public dmisCppBase
{
public:
  pameasFedrat();
  ~pameasFedrat();
  void printSelf() = 0;
};

/********************************************************************/

/* pameasFedrat_MPM

This is a derived class for one of the definitions of pameasFedrat.
It represents the following items:

MPM ',' rentVal

*/

class pameasFedrat_MPM :
  public pameasFedrat
{
public:
  pameasFedrat_MPM();
  pameasFedrat_MPM(
    rentVal * rateIn);
  ~pameasFedrat_MPM();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* pameasFedrat_MMPS

This is a derived class for one of the definitions of pameasFedrat.
It represents the following items:

MMPS ',' rentVal

*/

class pameasFedrat_MMPS :
  public pameasFedrat
{
public:
  pameasFedrat_MMPS();
  pameasFedrat_MMPS(
    rentVal * rateIn);
  ~pameasFedrat_MMPS();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* pameasFedrat_IPM

This is a derived class for one of the definitions of pameasFedrat.
It represents the following items:

IPM ',' rentVal

*/

class pameasFedrat_IPM :
  public pameasFedrat
{
public:
  pameasFedrat_IPM();
  pameasFedrat_IPM(
    rentVal * rateIn);
  ~pameasFedrat_IPM();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* pameasFedrat_IPS

This is a derived class for one of the definitions of pameasFedrat.
It represents the following items:

IPS ',' rentVal

*/

class pameasFedrat_IPS :
  public pameasFedrat
{
public:
  pameasFedrat_IPS();
  pameasFedrat_IPS(
    rentVal * rateIn);
  ~pameasFedrat_IPS();
  void printSelf();
  rentVal * get_rate();
  void set_rate(rentVal * rateIn);
private:
  rentVal * rate;
};

/********************************************************************/

/* partidStm

This is a class for the single definition of partidStm.
It represents the following items:

pnLabel '=' PARTID '/' stringVal #

*/

class partidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  partidStm();
  partidStm(
    pnLabel * pnLabelIn,
    stringVal * textIn);
  ~partidStm();
  void printSelf();
  pnLabel * get_pnLabel();
  void set_pnLabel(pnLabel * pnLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  pnLabel * a_pnLabel;
  stringVal * text;
};

/********************************************************************/

/* partrvStm

This is a class for the single definition of partrvStm.
It represents the following items:

prLabel '=' PARTRV '/' stringVal #

*/

class partrvStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  partrvStm();
  partrvStm(
    prLabel * prLabelIn,
    stringVal * textIn);
  ~partrvStm();
  void printSelf();
  prLabel * get_prLabel();
  void set_prLabel(prLabel * prLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  prLabel * a_prLabel;
  stringVal * text;
};

/********************************************************************/

/* partsnStm

This is a class for the single definition of partsnStm.
It represents the following items:

psLabel '=' PARTSN '/' stringVal #

*/

class partsnStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  partsnStm();
  partsnStm(
    psLabel * psLabelIn,
    stringVal * textIn);
  ~partsnStm();
  void printSelf();
  psLabel * get_psLabel();
  void set_psLabel(psLabel * psLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  psLabel * a_psLabel;
  stringVal * text;
};

/********************************************************************/

/* pathStm

This is a class for the single definition of pathStm.
It represents the following items:

pLabel '=' PATH '/' pathMinor #

*/

class pathStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  pathStm();
  pathStm(
    pLabel * pLabelIn,
    pathMinor * pathMinorIn);
  ~pathStm();
  void printSelf();
  pLabel * get_pLabel();
  void set_pLabel(pLabel * pLabelIn);
  pathMinor * get_pathMinor();
  void set_pathMinor(pathMinor * pathMinorIn);
private:
  pLabel * a_pLabel;
  pathMinor * a_pathMinor;
};

/********************************************************************/

/* pathMinor

This is a parent class.

*/

class pathMinor :
  public dmisCppBase
{
public:
  pathMinor();
  ~pathMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* euler

This is a class for the single definition of euler.
It represents the following items:

rentVal ',' rentVal ',' rentVal

*/

class euler :
  public dmisCppBase
{
public:
  euler();
  euler(
    rentVal * ang1In,
    rentVal * ang2In,
    rentVal * ang3In);
  ~euler();
  void printSelf();
  rentVal * get_ang1();
  void set_ang1(rentVal * ang1In);
  rentVal * get_ang2();
  void set_ang2(rentVal * ang2In);
  rentVal * get_ang3();
  void set_ang3(rentVal * ang3In);
private:
  rentVal * ang1;
  rentVal * ang2;
  rentVal * ang3;
};

/********************************************************************/

/* pathPoint

This is a class for the single definition of pathPoint.
It represents the following items:

POINT ',' typePoint ',' vector

*/

class pathPoint :
  public pathMinor
{
public:
  pathPoint();
  pathPoint(
    typePoint * typePointIn,
    vector * dirIn);
  ~pathPoint();
  void printSelf();
  typePoint * get_typePoint();
  void set_typePoint(typePoint * typePointIn);
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  typePoint * a_typePoint;
  vector * dir;
};

/********************************************************************/

/* pathArc

This is a class for the single definition of pathArc.
It represents the following items:

ARC ',' typePoint ',' vector ',' rentVal ',' angle ',' angle [',' vector]

*/

class pathArc :
  public pathMinor
{
public:
  pathArc();
  pathArc(
    typePoint * centerIn,
    vector * planeVecIn,
    rentVal * radiusIn,
    angle * startAngleIn,
    angle * includAngleIn,
    vector * startVecIn);
  ~pathArc();
  void printSelf();
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
  rentVal * get_radius();
  void set_radius(rentVal * radiusIn);
  angle * get_startAngle();
  void set_startAngle(angle * startAngleIn);
  angle * get_includAngle();
  void set_includAngle(angle * includAngleIn);
  vector * get_startVec();
  void set_startVec(vector * startVecIn);
private:
  typePoint * center;
  vector * planeVec;
  rentVal * radius;
  angle * startAngle;
  angle * includAngle;
  vector * startVec;
};

/********************************************************************/

/* pathCurve

This is a parent class.

*/

class pathCurve :
  public pathMinor
{
public:
  pathCurve();
  ~pathCurve();
  void printSelf() = 0;
};

/********************************************************************/

/* pathCurve_pathCurvePtdata

This is a derived class for one of the definitions of pathCurve.
It represents the following items:

CURVE ',' pathCurvePtdata

*/

class pathCurve_pathCurvePtdata :
  public pathCurve
{
public:
  pathCurve_pathCurvePtdata();
  pathCurve_pathCurvePtdata(
    pathCurvePtdata * pathCurvePtdataIn);
  ~pathCurve_pathCurvePtdata();
  void printSelf();
  pathCurvePtdata * get_pathCurvePtdata();
  void set_pathCurvePtdata(pathCurvePtdata * pathCurvePtdataIn);
private:
  pathCurvePtdata * a_pathCurvePtdata;
};

/********************************************************************/

/* pathCurve_pathCurvePoints

This is a derived class for one of the definitions of pathCurve.
It represents the following items:

CURVE ',' pathCurvePoints

*/

class pathCurve_pathCurvePoints :
  public pathCurve
{
public:
  pathCurve_pathCurvePoints();
  pathCurve_pathCurvePoints(
    pathCurvePoints * pathCurvePointsIn);
  ~pathCurve_pathCurvePoints();
  void printSelf();
  pathCurvePoints * get_pathCurvePoints();
  void set_pathCurvePoints(pathCurvePoints * pathCurvePointsIn);
private:
  pathCurvePoints * a_pathCurvePoints;
};

/********************************************************************/

/* pathCurvePtdata

This is a parent class.

*/

class pathCurvePtdata :
  public dmisCppBase
{
public:
  pathCurvePtdata();
  ~pathCurvePtdata();
  void printSelf() = 0;
};

/********************************************************************/

/* curvePtdataPcs

This is a class for the single definition of curvePtdataPcs.
It represents the following items:

PTDATA ',' pointVecCart [',' PCS ',' euler] ',' curvePtdataPcsList

*/

class curvePtdataPcs :
  public pathCurvePtdata
{
public:
  curvePtdataPcs();
  curvePtdataPcs(
    pointVecCart * pointVecCartIn,
    euler * eulerIn,
    std::list<curvePtdataPcsListItem *> * curvePtdataPcsListIn);
  ~curvePtdataPcs();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  euler * get_euler();
  void set_euler(euler * eulerIn);
  std::list<curvePtdataPcsListItem *> * get_curvePtdataPcsList();
  void set_curvePtdataPcsList(std::list<curvePtdataPcsListItem *> * curvePtdataPcsListIn);
private:
  pointVecCart * a_pointVecCart;
  euler * a_euler;
  std::list<curvePtdataPcsListItem *> * a_curvePtdataPcsList;
};

/********************************************************************/

/* curvePtdataPcsListItem

This is a class for the single definition of curvePtdataPcsListItem.
It represents the following items:

PTDATA ',' pointVecCart [',' PCS ',' euler]

*/

class curvePtdataPcsListItem :
  public dmisCppBase
{
public:
  curvePtdataPcsListItem();
  curvePtdataPcsListItem(
    pointVecCart * pointVecCartIn,
    euler * eulerIn);
  ~curvePtdataPcsListItem();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  euler * get_euler();
  void set_euler(euler * eulerIn);
private:
  pointVecCart * a_pointVecCart;
  euler * a_euler;
};

/********************************************************************/

/* curvePtdataHeadcs

This is a class for the single definition of curvePtdataHeadcs.
It represents the following items:

PTDATA ',' pointVecCart ',' HEADCS ',' rentVal ',' rentVal [',' rentVal] ',' curvePtdataHeadcsList

*/

class curvePtdataHeadcs :
  public pathCurvePtdata
{
public:
  curvePtdataHeadcs();
  curvePtdataHeadcs(
    pointVecCart * pointVecCartIn,
    rentVal * rot1In,
    rentVal * rot2In,
    rentVal * rot3In,
    std::list<curvePtdataHeadcsListItem *> * curvePtdataHeadcsListIn);
  ~curvePtdataHeadcs();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  rentVal * get_rot1();
  void set_rot1(rentVal * rot1In);
  rentVal * get_rot2();
  void set_rot2(rentVal * rot2In);
  rentVal * get_rot3();
  void set_rot3(rentVal * rot3In);
  std::list<curvePtdataHeadcsListItem *> * get_curvePtdataHeadcsList();
  void set_curvePtdataHeadcsList(std::list<curvePtdataHeadcsListItem *> * curvePtdataHeadcsListIn);
private:
  pointVecCart * a_pointVecCart;
  rentVal * rot1;
  rentVal * rot2;
  rentVal * rot3;
  std::list<curvePtdataHeadcsListItem *> * a_curvePtdataHeadcsList;
};

/********************************************************************/

/* curvePtdataHeadcsListItem

This is a class for the single definition of curvePtdataHeadcsListItem.
It represents the following items:

PTDATA ',' pointVecCart [',' HEADCS ',' rentVal ',' rentVal [',' rentVal]]

*/

class curvePtdataHeadcsListItem :
  public dmisCppBase
{
public:
  curvePtdataHeadcsListItem();
  curvePtdataHeadcsListItem(
    pointVecCart * pointVecCartIn,
    rentVal * rot1In,
    rentVal * rot2In,
    rentVal * rot3In);
  ~curvePtdataHeadcsListItem();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  rentVal * get_rot1();
  void set_rot1(rentVal * rot1In);
  rentVal * get_rot2();
  void set_rot2(rentVal * rot2In);
  rentVal * get_rot3();
  void set_rot3(rentVal * rot3In);
private:
  pointVecCart * a_pointVecCart;
  rentVal * rot1;
  rentVal * rot2;
  rentVal * rot3;
};

/********************************************************************/

/* pathCurvePoints

This is a class for the single definition of pathCurvePoints.
It represents the following items:

pointVecCart ',' pointVecCartList

*/

class pathCurvePoints :
  public dmisCppBase
{
public:
  pathCurvePoints();
  pathCurvePoints(
    pointVecCart * pointVecCartIn,
    std::list<pointVecCart *> * pointVecCartListIn);
  ~pathCurvePoints();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  std::list<pointVecCart *> * get_pointVecCartList();
  void set_pointVecCartList(std::list<pointVecCart *> * pointVecCartListIn);
private:
  pointVecCart * a_pointVecCart;
  std::list<pointVecCart *> * a_pointVecCartList;
};

/********************************************************************/

/* pathHelical

This is a class for the single definition of pathHelical.
It represents the following items:

HELICAL ',' typePoint ',' vector ',' rentVal ',' angle ',' angle [',' vector] ',' rentVal [',' angle]

*/

class pathHelical :
  public pathMinor
{
public:
  pathHelical();
  pathHelical(
    typePoint * centerIn,
    vector * axisVecIn,
    rentVal * radiusIn,
    angle * startAngleIn,
    angle * includAngleIn,
    vector * startVecIn,
    rentVal * pitchIn,
    angle * coneAngleIn);
  ~pathHelical();
  void printSelf();
  typePoint * get_center();
  void set_center(typePoint * centerIn);
  vector * get_axisVec();
  void set_axisVec(vector * axisVecIn);
  rentVal * get_radius();
  void set_radius(rentVal * radiusIn);
  angle * get_startAngle();
  void set_startAngle(angle * startAngleIn);
  angle * get_includAngle();
  void set_includAngle(angle * includAngleIn);
  vector * get_startVec();
  void set_startVec(vector * startVecIn);
  rentVal * get_pitch();
  void set_pitch(rentVal * pitchIn);
  angle * get_coneAngle();
  void set_coneAngle(angle * coneAngleIn);
private:
  typePoint * center;
  vector * axisVec;
  rentVal * radius;
  angle * startAngle;
  angle * includAngle;
  vector * startVec;
  rentVal * pitch;
  angle * coneAngle;
};

/********************************************************************/

/* pathLine

This is a parent class.

*/

class pathLine :
  public pathMinor
{
public:
  pathLine();
  ~pathLine();
  void printSelf() = 0;
};

/********************************************************************/

/* pathLineCart

This is a derived class for one of the definitions of pathLine.
It represents the following items:

LINE ',' BND ',' CART ',' START ',' impCartPoint ',' [csSpec ','] END ',' impCartPoint ',' [csSpec ','] VEC ',' vector

*/

class pathLineCart :
  public pathLine
{
public:
  pathLineCart();
  pathLineCart(
    impCartPoint * startIn,
    csSpec * startSpecIn,
    impCartPoint * endIn,
    csSpec * endSpecIn,
    vector * planeVecIn);
  ~pathLineCart();
  void printSelf();
  impCartPoint * get_start();
  void set_start(impCartPoint * startIn);
  csSpec * get_startSpec();
  void set_startSpec(csSpec * startSpecIn);
  impCartPoint * get_end();
  void set_end(impCartPoint * endIn);
  csSpec * get_endSpec();
  void set_endSpec(csSpec * endSpecIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  impCartPoint * start;
  csSpec * startSpec;
  impCartPoint * end;
  csSpec * endSpec;
  vector * planeVec;
};

/********************************************************************/

/* pathLinePol

This is a derived class for one of the definitions of pathLine.
It represents the following items:

LINE ',' BND ',' POL ',' impPolPoint ',' impPolPoint ',' VEC ',' vector

*/

class pathLinePol :
  public pathLine
{
public:
  pathLinePol();
  pathLinePol(
    impPolPoint * startIn,
    impPolPoint * endIn,
    vector * planeVecIn);
  ~pathLinePol();
  void printSelf();
  impPolPoint * get_start();
  void set_start(impPolPoint * startIn);
  impPolPoint * get_end();
  void set_end(impPolPoint * endIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  impPolPoint * start;
  impPolPoint * end;
  vector * planeVec;
};

/********************************************************************/

/* csSpec

This is a parent class.

*/

class csSpec :
  public dmisCppBase
{
public:
  csSpec();
  ~csSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* csSpec_PCS

This is a derived class for one of the definitions of csSpec.
It represents the following items:

PCS ',' euler

*/

class csSpec_PCS :
  public csSpec
{
public:
  csSpec_PCS();
  csSpec_PCS(
    euler * eulerIn);
  ~csSpec_PCS();
  void printSelf();
  euler * get_euler();
  void set_euler(euler * eulerIn);
private:
  euler * a_euler;
};

/********************************************************************/

/* csSpec_HEADCS

This is a derived class for one of the definitions of csSpec.
It represents the following items:

HEADCS ',' rentVal ',' rentVal [',' rentVal]

*/

class csSpec_HEADCS :
  public csSpec
{
public:
  csSpec_HEADCS();
  csSpec_HEADCS(
    rentVal * rot1In,
    rentVal * rot2In,
    rentVal * rot3In);
  ~csSpec_HEADCS();
  void printSelf();
  rentVal * get_rot1();
  void set_rot1(rentVal * rot1In);
  rentVal * get_rot2();
  void set_rot2(rentVal * rot2In);
  rentVal * get_rot3();
  void set_rot3(rentVal * rot3In);
private:
  rentVal * rot1;
  rentVal * rot2;
  rentVal * rot3;
};

/********************************************************************/

/* pathSurface

This is a parent class.

*/

class pathSurface :
  public pathMinor
{
public:
  pathSurface();
  ~pathSurface();
  void printSelf() = 0;
};

/********************************************************************/

/* pathSurfacePlain

This is a derived class for one of the definitions of pathSurface.
It represents the following items:

SURFACE ',' surfPtdataList

*/

class pathSurfacePlain :
  public pathSurface
{
public:
  pathSurfacePlain();
  pathSurfacePlain(
    std::list<surfPtdataListItem *> * surfPtdataListIn);
  ~pathSurfacePlain();
  void printSelf();
  std::list<surfPtdataListItem *> * get_surfPtdataList();
  void set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn);
private:
  std::list<surfPtdataListItem *> * a_surfPtdataList;
};

/********************************************************************/

/* pathSurfacePcs

This is a derived class for one of the definitions of pathSurface.
It represents the following items:

SURFACE ',' surfPtdataList ',' PCS ',' euler

*/

class pathSurfacePcs :
  public pathSurface
{
public:
  pathSurfacePcs();
  pathSurfacePcs(
    std::list<surfPtdataListItem *> * surfPtdataListIn,
    euler * eulerIn);
  ~pathSurfacePcs();
  void printSelf();
  std::list<surfPtdataListItem *> * get_surfPtdataList();
  void set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn);
  euler * get_euler();
  void set_euler(euler * eulerIn);
private:
  std::list<surfPtdataListItem *> * a_surfPtdataList;
  euler * a_euler;
};

/********************************************************************/

/* pathSurfacePcsData

This is a derived class for one of the definitions of pathSurface.
It represents the following items:

SURFACE ',' surfPtdataList ',' PCS ',' euler ',' surfPtdataPcsList

*/

class pathSurfacePcsData :
  public pathSurface
{
public:
  pathSurfacePcsData();
  pathSurfacePcsData(
    std::list<surfPtdataListItem *> * surfPtdataListIn,
    euler * eulerIn,
    std::list<surfPtdataPcsListItem *> * surfPtdataPcsListIn);
  ~pathSurfacePcsData();
  void printSelf();
  std::list<surfPtdataListItem *> * get_surfPtdataList();
  void set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn);
  euler * get_euler();
  void set_euler(euler * eulerIn);
  std::list<surfPtdataPcsListItem *> * get_surfPtdataPcsList();
  void set_surfPtdataPcsList(std::list<surfPtdataPcsListItem *> * surfPtdataPcsListIn);
private:
  std::list<surfPtdataListItem *> * a_surfPtdataList;
  euler * a_euler;
  std::list<surfPtdataPcsListItem *> * a_surfPtdataPcsList;
};

/********************************************************************/

/* pathSurfaceHeadcs

This is a derived class for one of the definitions of pathSurface.
It represents the following items:

SURFACE ',' surfPtdataList ',' HEADCS ',' rentVal ',' rentVal [',' rentVal]

*/

class pathSurfaceHeadcs :
  public pathSurface
{
public:
  pathSurfaceHeadcs();
  pathSurfaceHeadcs(
    std::list<surfPtdataListItem *> * surfPtdataListIn,
    rentVal * rot1In,
    rentVal * rot2In,
    rentVal * rot3In);
  ~pathSurfaceHeadcs();
  void printSelf();
  std::list<surfPtdataListItem *> * get_surfPtdataList();
  void set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn);
  rentVal * get_rot1();
  void set_rot1(rentVal * rot1In);
  rentVal * get_rot2();
  void set_rot2(rentVal * rot2In);
  rentVal * get_rot3();
  void set_rot3(rentVal * rot3In);
private:
  std::list<surfPtdataListItem *> * a_surfPtdataList;
  rentVal * rot1;
  rentVal * rot2;
  rentVal * rot3;
};

/********************************************************************/

/* pathSurfaceHeadcsData

This is a derived class for one of the definitions of pathSurface.
It represents the following items:

SURFACE ',' surfPtdataList ',' HEADCS ',' rentVal ',' rentVal [',' rentVal] ',' surfPtdataHeadcsList

*/

class pathSurfaceHeadcsData :
  public pathSurface
{
public:
  pathSurfaceHeadcsData();
  pathSurfaceHeadcsData(
    std::list<surfPtdataListItem *> * surfPtdataListIn,
    rentVal * rot1In,
    rentVal * rot2In,
    rentVal * rot3In,
    std::list<surfPtdataHeadcsListItem *> * surfPtdataHeadcsListIn);
  ~pathSurfaceHeadcsData();
  void printSelf();
  std::list<surfPtdataListItem *> * get_surfPtdataList();
  void set_surfPtdataList(std::list<surfPtdataListItem *> * surfPtdataListIn);
  rentVal * get_rot1();
  void set_rot1(rentVal * rot1In);
  rentVal * get_rot2();
  void set_rot2(rentVal * rot2In);
  rentVal * get_rot3();
  void set_rot3(rentVal * rot3In);
  std::list<surfPtdataHeadcsListItem *> * get_surfPtdataHeadcsList();
  void set_surfPtdataHeadcsList(std::list<surfPtdataHeadcsListItem *> * surfPtdataHeadcsListIn);
private:
  std::list<surfPtdataListItem *> * a_surfPtdataList;
  rentVal * rot1;
  rentVal * rot2;
  rentVal * rot3;
  std::list<surfPtdataHeadcsListItem *> * a_surfPtdataHeadcsList;
};

/********************************************************************/

/* surfPtdataListItem

This is a class for the single definition of surfPtdataListItem.
It represents the following items:

PTDATA ',' pointVecCart ',' rentVal ',' rentVal

*/

class surfPtdataListItem :
  public dmisCppBase
{
public:
  surfPtdataListItem();
  surfPtdataListItem(
    pointVecCart * pointVecCartIn,
    rentVal * widthIn,
    rentVal * heightIn);
  ~surfPtdataListItem();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
  rentVal * get_height();
  void set_height(rentVal * heightIn);
private:
  pointVecCart * a_pointVecCart;
  rentVal * width;
  rentVal * height;
};

/********************************************************************/

/* surfPtdataPcsListItem

This is a class for the single definition of surfPtdataPcsListItem.
It represents the following items:

PTDATA ',' pointVecCart ',' rentVal ',' rentVal [',' PCS ',' euler]

*/

class surfPtdataPcsListItem :
  public dmisCppBase
{
public:
  surfPtdataPcsListItem();
  surfPtdataPcsListItem(
    pointVecCart * pointVecCartIn,
    rentVal * widthIn,
    rentVal * heightIn,
    euler * eulerIn);
  ~surfPtdataPcsListItem();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
  rentVal * get_height();
  void set_height(rentVal * heightIn);
  euler * get_euler();
  void set_euler(euler * eulerIn);
private:
  pointVecCart * a_pointVecCart;
  rentVal * width;
  rentVal * height;
  euler * a_euler;
};

/********************************************************************/

/* surfPtdataHeadcsListItem

This is a class for the single definition of surfPtdataHeadcsListItem.
It represents the following items:

PTDATA ',' pointVecCart ',' rentVal ',' rentVal [',' HEADCS ',' rentVal ',' rentVal [',' rentVal]]

*/

class surfPtdataHeadcsListItem :
  public dmisCppBase
{
public:
  surfPtdataHeadcsListItem();
  surfPtdataHeadcsListItem(
    pointVecCart * pointVecCartIn,
    rentVal * widthIn,
    rentVal * heightIn,
    rentVal * rot1In,
    rentVal * rot2In,
    rentVal * rot3In);
  ~surfPtdataHeadcsListItem();
  void printSelf();
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  rentVal * get_width();
  void set_width(rentVal * widthIn);
  rentVal * get_height();
  void set_height(rentVal * heightIn);
  rentVal * get_rot1();
  void set_rot1(rentVal * rot1In);
  rentVal * get_rot2();
  void set_rot2(rentVal * rot2In);
  rentVal * get_rot3();
  void set_rot3(rentVal * rot3In);
private:
  pointVecCart * a_pointVecCart;
  rentVal * width;
  rentVal * height;
  rentVal * rot1;
  rentVal * rot2;
  rentVal * rot3;
};

/********************************************************************/

/* pathUnknown

This is a class for the single definition of pathUnknown.
It represents the following items:

UNKNOWN ',' impCartPoint ',' impCartPoint ',' impCartPoint [',' vector]

*/

class pathUnknown :
  public pathMinor
{
public:
  pathUnknown();
  pathUnknown(
    impCartPoint * startIn,
    impCartPoint * directionIn,
    impCartPoint * endIn,
    vector * planeVecIn);
  ~pathUnknown();
  void printSelf();
  impCartPoint * get_start();
  void set_start(impCartPoint * startIn);
  impCartPoint * get_direction();
  void set_direction(impCartPoint * directionIn);
  impCartPoint * get_end();
  void set_end(impCartPoint * endIn);
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  impCartPoint * start;
  impCartPoint * direction;
  impCartPoint * end;
  vector * planeVec;
};

/********************************************************************/

/* planidStm

This is a class for the single definition of planidStm.
It represents the following items:

plLabel '=' PLANID '/' stringVal #

*/

class planidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  planidStm();
  planidStm(
    plLabel * plLabelIn,
    stringVal * textIn);
  ~planidStm();
  void printSelf();
  plLabel * get_plLabel();
  void set_plLabel(plLabel * plLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  plLabel * a_plLabel;
  stringVal * text;
};

/********************************************************************/

/* popStm

This is a class for the single definition of popStm.
It represents the following items:

POP '/' stackElementList #

*/

class popStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  popStm();
  popStm(
    std::list<stackElement *> * stackElementListIn);
  ~popStm();
  void printSelf();
  std::list<stackElement *> * get_stackElementList();
  void set_stackElementList(std::list<stackElement *> * stackElementListIn);
private:
  std::list<stackElement *> * a_stackElementList;
};

/********************************************************************/

/* prcompStm

This is a class for the single definition of prcompStm.
It represents the following items:

PRCOMP '/' state #

*/

class prcompStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  prcompStm();
  prcompStm(
    state * stateIn);
  ~prcompStm();
  void printSelf();
  state * get_state();
  void set_state(state * stateIn);
private:
  state * a_state;
};

/********************************************************************/

/* prevopStm

This is a class for the single definition of prevopStm.
It represents the following items:

pvLabel '=' PREVOP '/' stringVal #

*/

class prevopStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  prevopStm();
  prevopStm(
    pvLabel * pvLabelIn,
    stringVal * textIn);
  ~prevopStm();
  void printSelf();
  pvLabel * get_pvLabel();
  void set_pvLabel(pvLabel * pvLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  pvLabel * a_pvLabel;
  stringVal * text;
};

/********************************************************************/

/* procidStm

This is a class for the single definition of procidStm.
It represents the following items:

pcLabel '=' PROCID '/' stringVal #

*/

class procidStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  procidStm();
  procidStm(
    pcLabel * pcLabelIn,
    stringVal * textIn);
  ~procidStm();
  void printSelf();
  pcLabel * get_pcLabel();
  void set_pcLabel(pcLabel * pcLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  pcLabel * a_pcLabel;
  stringVal * text;
};

/********************************************************************/

/* promptStm

This is a parent class.

*/

class promptStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  promptStm();
  ~promptStm();
  void printSelf() = 0;
};

/********************************************************************/

/* promptStm_boolVar

This is a derived class for one of the definitions of promptStm.
It represents the following items:

boolVar '=' PROMPT '/' stringVal #

*/

class promptStm_boolVar :
  public promptStm
{
public:
  promptStm_boolVar();
  promptStm_boolVar(
    boolVar * boolVarIn,
    stringVal * textIn);
  ~promptStm_boolVar();
  void printSelf();
  boolVar * get_boolVar();
  void set_boolVar(boolVar * boolVarIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  boolVar * a_boolVar;
  stringVal * text;
};

/********************************************************************/

/* promptStm_stringVar

This is a derived class for one of the definitions of promptStm.
It represents the following items:

stringVar '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_stringVar :
  public promptStm
{
public:
  promptStm_stringVar();
  promptStm_stringVar(
    stringVar * stringVarIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_stringVar();
  void printSelf();
  stringVar * get_stringVar();
  void set_stringVar(stringVar * stringVarIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  stringVar * a_stringVar;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_intVar

This is a derived class for one of the definitions of promptStm.
It represents the following items:

intVar '=' PROMPT '/' promptIntEnd #

*/

class promptStm_intVar :
  public promptStm
{
public:
  promptStm_intVar();
  promptStm_intVar(
    intVar * intVarIn,
    promptIntEnd * promptIntEndIn);
  ~promptStm_intVar();
  void printSelf();
  intVar * get_intVar();
  void set_intVar(intVar * intVarIn);
  promptIntEnd * get_promptIntEnd();
  void set_promptIntEnd(promptIntEnd * promptIntEndIn);
private:
  intVar * a_intVar;
  promptIntEnd * a_promptIntEnd;
};

/********************************************************************/

/* promptStm_realVar

This is a derived class for one of the definitions of promptStm.
It represents the following items:

realVar '=' PROMPT '/' stringVal [',' rentVal [',' rentVal]] #

*/

class promptStm_realVar :
  public promptStm
{
public:
  promptStm_realVar();
  promptStm_realVar(
    realVar * realVarIn,
    stringVal * textIn,
    rentVal * maxvalIn,
    rentVal * minvalIn);
  ~promptStm_realVar();
  void printSelf();
  realVar * get_realVar();
  void set_realVar(realVar * realVarIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  rentVal * get_maxval();
  void set_maxval(rentVal * maxvalIn);
  rentVal * get_minval();
  void set_minval(rentVal * minvalIn);
private:
  realVar * a_realVar;
  stringVal * text;
  rentVal * maxval;
  rentVal * minval;
};

/********************************************************************/

/* promptStm_ccLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

ccLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_ccLabel :
  public promptStm
{
public:
  promptStm_ccLabel();
  promptStm_ccLabel(
    ccLabel * ccLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_ccLabel();
  void printSelf();
  ccLabel * get_ccLabel();
  void set_ccLabel(ccLabel * ccLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  ccLabel * a_ccLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_ciLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

ciLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_ciLabel :
  public promptStm
{
public:
  promptStm_ciLabel();
  promptStm_ciLabel(
    ciLabel * ciLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_ciLabel();
  void printSelf();
  ciLabel * get_ciLabel();
  void set_ciLabel(ciLabel * ciLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  ciLabel * a_ciLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_csLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

csLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_csLabel :
  public promptStm
{
public:
  promptStm_csLabel();
  promptStm_csLabel(
    csLabel * csLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_csLabel();
  void printSelf();
  csLabel * get_csLabel();
  void set_csLabel(csLabel * csLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  csLabel * a_csLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_diLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

diLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_diLabel :
  public promptStm
{
public:
  promptStm_diLabel();
  promptStm_diLabel(
    diLabel * diLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_diLabel();
  void printSelf();
  diLabel * get_diLabel();
  void set_diLabel(diLabel * diLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  diLabel * a_diLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_dsLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

dsLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_dsLabel :
  public promptStm
{
public:
  promptStm_dsLabel();
  promptStm_dsLabel(
    dsLabel * dsLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_dsLabel();
  void printSelf();
  dsLabel * get_dsLabel();
  void set_dsLabel(dsLabel * dsLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  dsLabel * a_dsLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_dvLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

dvLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_dvLabel :
  public promptStm
{
public:
  promptStm_dvLabel();
  promptStm_dvLabel(
    dvLabel * dvLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_dvLabel();
  void printSelf();
  dvLabel * get_dvLabel();
  void set_dvLabel(dvLabel * dvLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  dvLabel * a_dvLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_fiLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

fiLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_fiLabel :
  public promptStm
{
public:
  promptStm_fiLabel();
  promptStm_fiLabel(
    fiLabel * fiLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_fiLabel();
  void printSelf();
  fiLabel * get_fiLabel();
  void set_fiLabel(fiLabel * fiLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  fiLabel * a_fiLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_fsLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

fsLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_fsLabel :
  public promptStm
{
public:
  promptStm_fsLabel();
  promptStm_fsLabel(
    fsLabel * fsLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_fsLabel();
  void printSelf();
  fsLabel * get_fsLabel();
  void set_fsLabel(fsLabel * fsLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  fsLabel * a_fsLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_liLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

liLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_liLabel :
  public promptStm
{
public:
  promptStm_liLabel();
  promptStm_liLabel(
    liLabel * liLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_liLabel();
  void printSelf();
  liLabel * get_liLabel();
  void set_liLabel(liLabel * liLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  liLabel * a_liLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_mdLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

mdLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_mdLabel :
  public promptStm
{
public:
  promptStm_mdLabel();
  promptStm_mdLabel(
    mdLabel * mdLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_mdLabel();
  void printSelf();
  mdLabel * get_mdLabel();
  void set_mdLabel(mdLabel * mdLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  mdLabel * a_mdLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_opLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

opLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_opLabel :
  public promptStm
{
public:
  promptStm_opLabel();
  promptStm_opLabel(
    opLabel * opLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_opLabel();
  void printSelf();
  opLabel * get_opLabel();
  void set_opLabel(opLabel * opLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  opLabel * a_opLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_pcLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

pcLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_pcLabel :
  public promptStm
{
public:
  promptStm_pcLabel();
  promptStm_pcLabel(
    pcLabel * pcLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_pcLabel();
  void printSelf();
  pcLabel * get_pcLabel();
  void set_pcLabel(pcLabel * pcLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  pcLabel * a_pcLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_plLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

plLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_plLabel :
  public promptStm
{
public:
  promptStm_plLabel();
  promptStm_plLabel(
    plLabel * plLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_plLabel();
  void printSelf();
  plLabel * get_plLabel();
  void set_plLabel(plLabel * plLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  plLabel * a_plLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_pnLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

pnLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_pnLabel :
  public promptStm
{
public:
  promptStm_pnLabel();
  promptStm_pnLabel(
    pnLabel * pnLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_pnLabel();
  void printSelf();
  pnLabel * get_pnLabel();
  void set_pnLabel(pnLabel * pnLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  pnLabel * a_pnLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_prLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

prLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_prLabel :
  public promptStm
{
public:
  promptStm_prLabel();
  promptStm_prLabel(
    prLabel * prLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_prLabel();
  void printSelf();
  prLabel * get_prLabel();
  void set_prLabel(prLabel * prLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  prLabel * a_prLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_psLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

psLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_psLabel :
  public promptStm
{
public:
  promptStm_psLabel();
  promptStm_psLabel(
    psLabel * psLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_psLabel();
  void printSelf();
  psLabel * get_psLabel();
  void set_psLabel(psLabel * psLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  psLabel * a_psLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_pvLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

pvLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_pvLabel :
  public promptStm
{
public:
  promptStm_pvLabel();
  promptStm_pvLabel(
    pvLabel * pvLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_pvLabel();
  void printSelf();
  pvLabel * get_pvLabel();
  void set_pvLabel(pvLabel * pvLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  pvLabel * a_pvLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_qLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

qLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_qLabel :
  public promptStm
{
public:
  promptStm_qLabel();
  promptStm_qLabel(
    qLabel * qLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_qLabel();
  void printSelf();
  qLabel * get_qLabel();
  void set_qLabel(qLabel * qLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  qLabel * a_qLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptStm_tlLabel

This is a derived class for one of the definitions of promptStm.
It represents the following items:

tlLabel '=' PROMPT '/' stringVal [',' intVal] #

*/

class promptStm_tlLabel :
  public promptStm
{
public:
  promptStm_tlLabel();
  promptStm_tlLabel(
    tlLabel * tlLabelIn,
    stringVal * textIn,
    intVal * maxSizeIn);
  ~promptStm_tlLabel();
  void printSelf();
  tlLabel * get_tlLabel();
  void set_tlLabel(tlLabel * tlLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxSize();
  void set_maxSize(intVal * maxSizeIn);
private:
  tlLabel * a_tlLabel;
  stringVal * text;
  intVal * maxSize;
};

/********************************************************************/

/* promptIntEnd

This is a parent class.

*/

class promptIntEnd :
  public dmisCppBase
{
public:
  promptIntEnd();
  ~promptIntEnd();
  void printSelf() = 0;
};

/********************************************************************/

/* promptIntEnd_stringVal

This is a derived class for one of the definitions of promptIntEnd.
It represents the following items:

stringVal [',' intVal [',' intVal]]

*/

class promptIntEnd_stringVal :
  public promptIntEnd
{
public:
  promptIntEnd_stringVal();
  promptIntEnd_stringVal(
    stringVal * textIn,
    intVal * maxvalIn,
    intVal * minvalIn);
  ~promptIntEnd_stringVal();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_maxval();
  void set_maxval(intVal * maxvalIn);
  intVal * get_minval();
  void set_minval(intVal * minvalIn);
private:
  stringVal * text;
  intVal * maxval;
  intVal * minval;
};

/********************************************************************/

/* promptIntEnd_promptItemList

This is a derived class for one of the definitions of promptIntEnd.
It represents the following items:

promptItemList

*/

class promptIntEnd_promptItemList :
  public promptIntEnd
{
public:
  promptIntEnd_promptItemList();
  promptIntEnd_promptItemList(
    std::list<promptItem *> * promptItemListIn);
  ~promptIntEnd_promptItemList();
  void printSelf();
  std::list<promptItem *> * get_promptItemList();
  void set_promptItemList(std::list<promptItem *> * promptItemListIn);
private:
  std::list<promptItem *> * a_promptItemList;
};

/********************************************************************/

/* promptItem

This is a parent class.

*/

class promptItem :
  public dmisCppBase
{
public:
  promptItem();
  ~promptItem();
  void printSelf() = 0;
};

/********************************************************************/

/* promptItem_BUTTON

This is a derived class for one of the definitions of promptItem.
It represents the following items:

BUTTON ',' stringVal ',' intVal

*/

class promptItem_BUTTON :
  public promptItem
{
public:
  promptItem_BUTTON();
  promptItem_BUTTON(
    stringVal * textIn,
    intVal * retValIn);
  ~promptItem_BUTTON();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
  intVal * get_retVal();
  void set_retVal(intVal * retValIn);
private:
  stringVal * text;
  intVal * retVal;
};

/********************************************************************/

/* promptItem_CHECK

This is a derived class for one of the definitions of promptItem.
It represents the following items:

CHECK ',' stringVal ',' boolVar

*/

class promptItem_CHECK :
  public promptItem
{
public:
  promptItem_CHECK();
  promptItem_CHECK(
    stringVal * textIn,
    boolVar * boolVarIn);
  ~promptItem_CHECK();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
  boolVar * get_boolVar();
  void set_boolVar(boolVar * boolVarIn);
private:
  stringVal * text;
  boolVar * a_boolVar;
};

/********************************************************************/

/* promptItem_EDIT

This is a derived class for one of the definitions of promptItem.
It represents the following items:

EDIT ',' promptVar [',' rentVal [',' rentVal]]

*/

class promptItem_EDIT :
  public promptItem
{
public:
  promptItem_EDIT();
  promptItem_EDIT(
    promptVar * promptVarIn,
    rentVal * maxvalIn,
    rentVal * minvalIn);
  ~promptItem_EDIT();
  void printSelf();
  promptVar * get_promptVar();
  void set_promptVar(promptVar * promptVarIn);
  rentVal * get_maxval();
  void set_maxval(rentVal * maxvalIn);
  rentVal * get_minval();
  void set_minval(rentVal * minvalIn);
private:
  promptVar * a_promptVar;
  rentVal * maxval;
  rentVal * minval;
};

/********************************************************************/

/* promptItem_GROUP

This is a derived class for one of the definitions of promptItem.
It represents the following items:

GROUP ',' stringVal ',' promptVar ',' stringVal ',' stringList

*/

class promptItem_GROUP :
  public promptItem
{
public:
  promptItem_GROUP();
  promptItem_GROUP(
    stringVal * textIn,
    promptVar * promptVarIn,
    stringVal * item1In,
    std::list<stringVal *> * moreItemsIn);
  ~promptItem_GROUP();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
  promptVar * get_promptVar();
  void set_promptVar(promptVar * promptVarIn);
  stringVal * get_item1();
  void set_item1(stringVal * item1In);
  std::list<stringVal *> * get_moreItems();
  void set_moreItems(std::list<stringVal *> * moreItemsIn);
private:
  stringVal * text;
  promptVar * a_promptVar;
  stringVal * item1;
  std::list<stringVal *> * moreItems;
};

/********************************************************************/

/* promptItem_LIST

This is a derived class for one of the definitions of promptItem.
It represents the following items:

LIST ',' promptVar ',' stringVal ',' stringList

*/

class promptItem_LIST :
  public promptItem
{
public:
  promptItem_LIST();
  promptItem_LIST(
    promptVar * promptVarIn,
    stringVal * item1In,
    std::list<stringVal *> * moreItemsIn);
  ~promptItem_LIST();
  void printSelf();
  promptVar * get_promptVar();
  void set_promptVar(promptVar * promptVarIn);
  stringVal * get_item1();
  void set_item1(stringVal * item1In);
  std::list<stringVal *> * get_moreItems();
  void set_moreItems(std::list<stringVal *> * moreItemsIn);
private:
  promptVar * a_promptVar;
  stringVal * item1;
  std::list<stringVal *> * moreItems;
};

/********************************************************************/

/* promptItem_PICTURE

This is a derived class for one of the definitions of promptItem.
It represents the following items:

PICTURE ',' stringVal [',' intVal]

*/

class promptItem_PICTURE :
  public promptItem
{
public:
  promptItem_PICTURE();
  promptItem_PICTURE(
    stringVal * filenameIn,
    intVal * indexIn);
  ~promptItem_PICTURE();
  void printSelf();
  stringVal * get_filename();
  void set_filename(stringVal * filenameIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  stringVal * filename;
  intVal * index;
};

/********************************************************************/

/* promptItem_PIXBTN

This is a derived class for one of the definitions of promptItem.
It represents the following items:

PIXBTN ',' stringVal [',' stringVal] ',' intVal

*/

class promptItem_PIXBTN :
  public promptItem
{
public:
  promptItem_PIXBTN();
  promptItem_PIXBTN(
    stringVal * filnam1In,
    stringVal * filnam2In,
    intVal * retValIn);
  ~promptItem_PIXBTN();
  void printSelf();
  stringVal * get_filnam1();
  void set_filnam1(stringVal * filnam1In);
  stringVal * get_filnam2();
  void set_filnam2(stringVal * filnam2In);
  intVal * get_retVal();
  void set_retVal(intVal * retValIn);
private:
  stringVal * filnam1;
  stringVal * filnam2;
  intVal * retVal;
};

/********************************************************************/

/* promptItem_SOUND

This is a derived class for one of the definitions of promptItem.
It represents the following items:

SOUND ',' stringVal

*/

class promptItem_SOUND :
  public promptItem
{
public:
  promptItem_SOUND();
  promptItem_SOUND(
    stringVal * filenameIn);
  ~promptItem_SOUND();
  void printSelf();
  stringVal * get_filename();
  void set_filename(stringVal * filenameIn);
private:
  stringVal * filename;
};

/********************************************************************/

/* promptItem_TEXT

This is a derived class for one of the definitions of promptItem.
It represents the following items:

TEXT ',' stringVal

*/

class promptItem_TEXT :
  public promptItem
{
public:
  promptItem_TEXT();
  promptItem_TEXT(
    stringVal * textIn);
  ~promptItem_TEXT();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* promptItem_TITLE

This is a derived class for one of the definitions of promptItem.
It represents the following items:

TITLE ',' stringVal

*/

class promptItem_TITLE :
  public promptItem
{
public:
  promptItem_TITLE();
  promptItem_TITLE(
    stringVal * textIn);
  ~promptItem_TITLE();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* promptVar

This is a parent class.

*/

class promptVar :
  public dmisCppBase
{
public:
  promptVar();
  ~promptVar();
  void printSelf() = 0;
};

/********************************************************************/

/* psthruStm

This is a class for the single definition of psthruStm.
It represents the following items:

PSTHRU '/' psthruMinor #

*/

class psthruStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  psthruStm();
  psthruStm(
    psthruMinor * psthruMinorIn);
  ~psthruStm();
  void printSelf();
  psthruMinor * get_psthruMinor();
  void set_psthruMinor(psthruMinor * psthruMinorIn);
private:
  psthruMinor * a_psthruMinor;
};

/********************************************************************/

/* psthruMinor

This is a parent class.

*/

class psthruMinor :
  public dmisCppBase
{
public:
  psthruMinor();
  ~psthruMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* psthruMinor_COMAND

This is a derived class for one of the definitions of psthruMinor.
It represents the following items:

COMAND ',' stringVal

*/

class psthruMinor_COMAND :
  public psthruMinor
{
public:
  psthruMinor_COMAND();
  psthruMinor_COMAND(
    stringVal * commandIn);
  ~psthruMinor_COMAND();
  void printSelf();
  stringVal * get_command();
  void set_command(stringVal * commandIn);
private:
  stringVal * command;
};

/********************************************************************/

/* psthruMinor_CONTIN

This is a derived class for one of the definitions of psthruMinor.
It represents the following items:

CONTIN

*/

class psthruMinor_CONTIN :
  public psthruMinor
{
public:
  psthruMinor_CONTIN();
  ~psthruMinor_CONTIN();
  void printSelf();
};

/********************************************************************/

/* psthruMinor_PAUSE

This is a derived class for one of the definitions of psthruMinor.
It represents the following items:

PAUSE

*/

class psthruMinor_PAUSE :
  public psthruMinor
{
public:
  psthruMinor_PAUSE();
  ~psthruMinor_PAUSE();
  void printSelf();
};

/********************************************************************/

/* psthruMinor_START

This is a derived class for one of the definitions of psthruMinor.
It represents the following items:

START

*/

class psthruMinor_START :
  public psthruMinor
{
public:
  psthruMinor_START();
  ~psthruMinor_START();
  void printSelf();
};

/********************************************************************/

/* psthruMinor_STOP

This is a derived class for one of the definitions of psthruMinor.
It represents the following items:

STOP

*/

class psthruMinor_STOP :
  public psthruMinor
{
public:
  psthruMinor_STOP();
  ~psthruMinor_STOP();
  void printSelf();
};

/********************************************************************/

/* psthruMinor_TRMATX

This is a derived class for one of the definitions of psthruMinor.
It represents the following items:

TRMATX ',' matrix

*/

class psthruMinor_TRMATX :
  public psthruMinor
{
public:
  psthruMinor_TRMATX();
  psthruMinor_TRMATX(
    matrix * matrixIn);
  ~psthruMinor_TRMATX();
  void printSelf();
  matrix * get_matrix();
  void set_matrix(matrix * matrixIn);
private:
  matrix * a_matrix;
};

/********************************************************************/

/* ptbuffStm

This is a class for the single definition of ptbuffStm.
It represents the following items:

PTBUFF '/' state #

*/

class ptbuffStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  ptbuffStm();
  ptbuffStm(
    state * stateIn);
  ~ptbuffStm();
  void printSelf();
  state * get_state();
  void set_state(state * stateIn);
private:
  state * a_state;
};

/********************************************************************/

/* ptmeasEnd

This is a parent class.

*/

class ptmeasEnd :
  public dmisCppBase
{
public:
  ptmeasEnd();
  ~ptmeasEnd();
  void printSelf() = 0;
};

/********************************************************************/

/* ptmeasEnd_csSpec

This is a derived class for one of the definitions of ptmeasEnd.
It represents the following items:

csSpec [',' touchSpec]

*/

class ptmeasEnd_csSpec :
  public ptmeasEnd
{
public:
  ptmeasEnd_csSpec();
  ptmeasEnd_csSpec(
    csSpec * csSpecIn,
    touchSpec * touchSpecIn);
  ~ptmeasEnd_csSpec();
  void printSelf();
  csSpec * get_csSpec();
  void set_csSpec(csSpec * csSpecIn);
  touchSpec * get_touchSpec();
  void set_touchSpec(touchSpec * touchSpecIn);
private:
  csSpec * a_csSpec;
  touchSpec * a_touchSpec;
};

/********************************************************************/

/* ptmeasEnd_touchSpec

This is a derived class for one of the definitions of ptmeasEnd.
It represents the following items:

touchSpec

*/

class ptmeasEnd_touchSpec :
  public ptmeasEnd
{
public:
  ptmeasEnd_touchSpec();
  ptmeasEnd_touchSpec(
    touchSpec * touchSpecIn);
  ~ptmeasEnd_touchSpec();
  void printSelf();
  touchSpec * get_touchSpec();
  void set_touchSpec(touchSpec * touchSpecIn);
private:
  touchSpec * a_touchSpec;
};

/********************************************************************/

/* touchSpec

This is a parent class.

*/

class touchSpec :
  public dmisCppBase
{
public:
  touchSpec();
  ~touchSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* touchSpec_HEADTOUCH

This is a derived class for one of the definitions of touchSpec.
It represents the following items:

HEADTOUCH

*/

class touchSpec_HEADTOUCH :
  public touchSpec
{
public:
  touchSpec_HEADTOUCH();
  ~touchSpec_HEADTOUCH();
  void printSelf();
};

/********************************************************************/

/* touchSpec_ALLAXESTOUCH

This is a derived class for one of the definitions of touchSpec.
It represents the following items:

ALLAXESTOUCH

*/

class touchSpec_ALLAXESTOUCH :
  public touchSpec
{
public:
  touchSpec_ALLAXESTOUCH();
  ~touchSpec_ALLAXESTOUCH();
  void printSelf();
};

/********************************************************************/

/* pushStm

This is a class for the single definition of pushStm.
It represents the following items:

PUSH '/' stackElementList #

*/

class pushStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  pushStm();
  pushStm(
    std::list<stackElement *> * stackElementListIn);
  ~pushStm();
  void printSelf();
  std::list<stackElement *> * get_stackElementList();
  void set_stackElementList(std::list<stackElement *> * stackElementListIn);
private:
  std::list<stackElement *> * a_stackElementList;
};

/********************************************************************/

/* qisdefStm

This is a class for the single definition of qisdefStm.
It represents the following items:

qLabel '=' QISDEF '/' stringVal [',' stringVal] #

*/

class qisdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  qisdefStm();
  qisdefStm(
    qLabel * qLabelIn,
    stringVal * typIn,
    stringVal * textIn);
  ~qisdefStm();
  void printSelf();
  qLabel * get_qLabel();
  void set_qLabel(qLabel * qLabelIn);
  stringVal * get_typ();
  void set_typ(stringVal * typIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  qLabel * a_qLabel;
  stringVal * typ;
  stringVal * text;
};

/********************************************************************/

/* readStm

This is a class for the single definition of readStm.
It represents the following items:

READ '/' didLabel ',' readSpecList #

*/

class readStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  readStm();
  readStm(
    didLabel * didLabelIn,
    std::list<readSpec *> * readSpecListIn);
  ~readStm();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  std::list<readSpec *> * get_readSpecList();
  void set_readSpecList(std::list<readSpec *> * readSpecListIn);
private:
  didLabel * a_didLabel;
  std::list<readSpec *> * a_readSpecList;
};

/********************************************************************/

/* readSpec

This is a class for the single definition of readSpec.
It represents the following items:

rwVar [rwFormat]

*/

class readSpec :
  public dmisCppBase
{
public:
  readSpec();
  readSpec(
    rwVar * rwVarIn,
    rwFormat * rwFormatIn);
  ~readSpec();
  void printSelf();
  rwVar * get_rwVar();
  void set_rwVar(rwVar * rwVarIn);
  rwFormat * get_rwFormat();
  void set_rwFormat(rwFormat * rwFormatIn);
private:
  rwVar * a_rwVar;
  rwFormat * a_rwFormat;
};

/********************************************************************/

/* recallDatumStm

This is a class for the single definition of recallDatumStm.
It represents the following items:

RECALL '/' datumLabel2 [',' didLabel] #

*/

class recallDatumStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  recallDatumStm();
  recallDatumStm(
    datumLabel2 * datumLabel2In,
    didLabel * didLabelIn);
  ~recallDatumStm();
  void printSelf();
  datumLabel2 * get_datumLabel2();
  void set_datumLabel2(datumLabel2 * datumLabel2In);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  datumLabel2 * a_datumLabel2;
  didLabel * a_didLabel;
};

/********************************************************************/

/* recallFeatureStm

This is a class for the single definition of recallFeatureStm.
It represents the following items:

RECALL '/' faLabel [',' didLabel] #

*/

class recallFeatureStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  recallFeatureStm();
  recallFeatureStm(
    faLabel * faLabelIn,
    didLabel * didLabelIn);
  ~recallFeatureStm();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  faLabel * a_faLabel;
  didLabel * a_didLabel;
};

/********************************************************************/

/* recallRotaryTableStm

This is a class for the single definition of recallRotaryTableStm.
It represents the following items:

RECALL '/' rtLabel [',' didLabel] #

*/

class recallRotaryTableStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  recallRotaryTableStm();
  recallRotaryTableStm(
    rtLabel * rtLabelIn,
    didLabel * didLabelIn);
  ~recallRotaryTableStm();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  rtLabel * a_rtLabel;
  didLabel * a_didLabel;
};

/********************************************************************/

/* recallDMLStm

This is a class for the single definition of recallDMLStm.
It represents the following items:

RECALL '/' DML ',' didLabel ',' daLabel #

*/

class recallDMLStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  recallDMLStm();
  recallDMLStm(
    didLabel * didLabelIn,
    daLabel * daLabelIn);
  ~recallDMLStm();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  daLabel * get_daLabel();
  void set_daLabel(daLabel * daLabelIn);
private:
  didLabel * a_didLabel;
  daLabel * a_daLabel;
};

/********************************************************************/

/* refmntStm

This is a class for the single definition of refmntStm.
It represents the following items:

rmLabel '=' REFMNT '/' XVEC ',' vector ',' ZVEC ',' vector ',' MNTLEN ',' vector #

*/

class refmntStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  refmntStm();
  refmntStm(
    rmLabel * rmLabelIn,
    vector * xVecIn,
    vector * zVecIn,
    vector * offsetIn);
  ~refmntStm();
  void printSelf();
  rmLabel * get_rmLabel();
  void set_rmLabel(rmLabel * rmLabelIn);
  vector * get_xVec();
  void set_xVec(vector * xVecIn);
  vector * get_zVec();
  void set_zVec(vector * zVecIn);
  vector * get_offset();
  void set_offset(vector * offsetIn);
private:
  rmLabel * a_rmLabel;
  vector * xVec;
  vector * zVec;
  vector * offset;
};

/********************************************************************/

/* reportStm

This is a class for the single definition of reportStm.
It represents the following items:

rLabel '=' REPORT '/' reportItemList [',' stringVal] #

*/

class reportStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  reportStm();
  reportStm(
    rLabel * rLabelIn,
    std::list<reportItem *> * reportItemListIn,
    stringVal * textIn);
  ~reportStm();
  void printSelf();
  rLabel * get_rLabel();
  void set_rLabel(rLabel * rLabelIn);
  std::list<reportItem *> * get_reportItemList();
  void set_reportItemList(std::list<reportItem *> * reportItemListIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  rLabel * a_rLabel;
  std::list<reportItem *> * a_reportItemList;
  stringVal * text;
};

/********************************************************************/

/* reportItem

This is a parent class.

*/

class reportItem :
  public dmisCppBase
{
public:
  reportItem();
  ~reportItem();
  void printSelf() = 0;
};

/********************************************************************/

/* reportItem_ALGOR

This is a derived class for one of the definitions of reportItem.
It represents the following items:

ALGOR

*/

class reportItem_ALGOR :
  public reportItem
{
public:
  reportItem_ALGOR();
  ~reportItem_ALGOR();
  void printSelf();
};

/********************************************************************/

/* reportItem_DATE

This is a derived class for one of the definitions of reportItem.
It represents the following items:

DATE

*/

class reportItem_DATE :
  public reportItem
{
public:
  reportItem_DATE();
  ~reportItem_DATE();
  void printSelf();
};

/********************************************************************/

/* reportItem_HUMID

This is a derived class for one of the definitions of reportItem.
It represents the following items:

HUMID

*/

class reportItem_HUMID :
  public reportItem
{
public:
  reportItem_HUMID();
  ~reportItem_HUMID();
  void printSelf();
};

/********************************************************************/

/* reportItem_MODE

This is a derived class for one of the definitions of reportItem.
It represents the following items:

MODE

*/

class reportItem_MODE :
  public reportItem
{
public:
  reportItem_MODE();
  ~reportItem_MODE();
  void printSelf();
};

/********************************************************************/

/* reportItem_TEMPC

This is a derived class for one of the definitions of reportItem.
It represents the following items:

TEMPC

*/

class reportItem_TEMPC :
  public reportItem
{
public:
  reportItem_TEMPC();
  ~reportItem_TEMPC();
  void printSelf();
};

/********************************************************************/

/* reportItem_TEMPF

This is a derived class for one of the definitions of reportItem.
It represents the following items:

TEMPF

*/

class reportItem_TEMPF :
  public reportItem
{
public:
  reportItem_TEMPF();
  ~reportItem_TEMPF();
  void printSelf();
};

/********************************************************************/

/* reportItem_TEMPWC

This is a derived class for one of the definitions of reportItem.
It represents the following items:

TEMPWC

*/

class reportItem_TEMPWC :
  public reportItem
{
public:
  reportItem_TEMPWC();
  ~reportItem_TEMPWC();
  void printSelf();
};

/********************************************************************/

/* reportItem_TEMPWF

This is a derived class for one of the definitions of reportItem.
It represents the following items:

TEMPWF

*/

class reportItem_TEMPWF :
  public reportItem
{
public:
  reportItem_TEMPWF();
  ~reportItem_TEMPWF();
  void printSelf();
};

/********************************************************************/

/* reportItem_TIME

This is a derived class for one of the definitions of reportItem.
It represents the following items:

TIME

*/

class reportItem_TIME :
  public reportItem
{
public:
  reportItem_TIME();
  ~reportItem_TIME();
  void printSelf();
};

/********************************************************************/

/* reportItem_qisLabel

This is a derived class for one of the definitions of reportItem.
It represents the following items:

qisLabel

*/

class reportItem_qisLabel :
  public reportItem
{
public:
  reportItem_qisLabel();
  reportItem_qisLabel(
    qisLabel * qisLabelIn);
  ~reportItem_qisLabel();
  void printSelf();
  qisLabel * get_qisLabel();
  void set_qisLabel(qisLabel * qisLabelIn);
private:
  qisLabel * a_qisLabel;
};

/********************************************************************/

/* resumeStm

This is a class for the single definition of resumeStm.
It represents the following items:

RESUME '/' resumeMinor #

*/

class resumeStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  resumeStm();
  resumeStm(
    resumeMinor * resumeMinorIn);
  ~resumeStm();
  void printSelf();
  resumeMinor * get_resumeMinor();
  void set_resumeMinor(resumeMinor * resumeMinorIn);
private:
  resumeMinor * a_resumeMinor;
};

/********************************************************************/

/* resumeMinor

This is a parent class.

*/

class resumeMinor :
  public dmisCppBase
{
public:
  resumeMinor();
  ~resumeMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* resumeMinor_jumpLabel

This is a derived class for one of the definitions of resumeMinor.
It represents the following items:

jumpLabel

*/

class resumeMinor_jumpLabel :
  public resumeMinor
{
public:
  resumeMinor_jumpLabel();
  resumeMinor_jumpLabel(
    jumpLabel * jumpLabelIn);
  ~resumeMinor_jumpLabel();
  void printSelf();
  jumpLabel * get_jumpLabel();
  void set_jumpLabel(jumpLabel * jumpLabelIn);
private:
  jumpLabel * a_jumpLabel;
};

/********************************************************************/

/* resumeMinor_CURENT

This is a derived class for one of the definitions of resumeMinor.
It represents the following items:

CURENT

*/

class resumeMinor_CURENT :
  public resumeMinor
{
public:
  resumeMinor_CURENT();
  ~resumeMinor_CURENT();
  void printSelf();
};

/********************************************************************/

/* resumeMinor_END

This is a derived class for one of the definitions of resumeMinor.
It represents the following items:

END

*/

class resumeMinor_END :
  public resumeMinor
{
public:
  resumeMinor_END();
  ~resumeMinor_END();
  void printSelf();
};

/********************************************************************/

/* resumeMinor_NEXT

This is a derived class for one of the definitions of resumeMinor.
It represents the following items:

NEXT

*/

class resumeMinor_NEXT :
  public resumeMinor
{
public:
  resumeMinor_NEXT();
  ~resumeMinor_NEXT();
  void printSelf();
};

/********************************************************************/

/* resumeMinor_START

This is a derived class for one of the definitions of resumeMinor.
It represents the following items:

START

*/

class resumeMinor_START :
  public resumeMinor
{
public:
  resumeMinor_START();
  ~resumeMinor_START();
  void printSelf();
};

/********************************************************************/

/* resumeMinor_STOP

This is a derived class for one of the definitions of resumeMinor.
It represents the following items:

STOP

*/

class resumeMinor_STOP :
  public resumeMinor
{
public:
  resumeMinor_STOP();
  ~resumeMinor_STOP();
  void printSelf();
};

/********************************************************************/

/* rmeasStm

This is a class for the single definition of rmeasStm.
It represents the following items:

RMEAS '/' rmeasMinor #

*/

class rmeasStm :
  public dmisStatement
{
public:
  rmeasStm();
  rmeasStm(
    rmeasMinor * rmeasMinorIn);
  ~rmeasStm();
  void printSelf();
  rmeasMinor * get_rmeasMinor();
  void set_rmeasMinor(rmeasMinor * rmeasMinorIn);
private:
  rmeasMinor * a_rmeasMinor;
};

/********************************************************************/

/* rmeasMinor

This is a parent class.

*/

class rmeasMinor :
  public dmisCppBase
{
public:
  rmeasMinor();
  ~rmeasMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasArc

This is a parent class.

*/

class rmeasArc :
  public rmeasMinor
{
public:
  rmeasArc();
  ~rmeasArc();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasArc_rmeasSpecFa

This is a derived class for one of the definitions of rmeasArc.
It represents the following items:

ARC ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasArc_rmeasSpecFa :
  public rmeasArc
{
public:
  rmeasArc_rmeasSpecFa();
  rmeasArc_rmeasSpecFa(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasArc_rmeasSpecFa();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasArc_rmeasSpecVecbld

This is a derived class for one of the definitions of rmeasArc.
It represents the following items:

ARC ',' fLabel ',' intVal ',' rmeasSpecVecbld

*/

class rmeasArc_rmeasSpecVecbld :
  public rmeasArc
{
public:
  rmeasArc_rmeasSpecVecbld();
  rmeasArc_rmeasSpecVecbld(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbld * rmeasSpecVecbldIn);
  ~rmeasArc_rmeasSpecVecbld();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbld * a_rmeasSpecVecbld;
};

/********************************************************************/

/* rmeasCircle

This is a parent class.

*/

class rmeasCircle :
  public rmeasMinor
{
public:
  rmeasCircle();
  ~rmeasCircle();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasCircle_rmeasSpecFa

This is a derived class for one of the definitions of rmeasCircle.
It represents the following items:

CIRCLE ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasCircle_rmeasSpecFa :
  public rmeasCircle
{
public:
  rmeasCircle_rmeasSpecFa();
  rmeasCircle_rmeasSpecFa(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasCircle_rmeasSpecFa();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasCircle_rmeasSpecVecbld

This is a derived class for one of the definitions of rmeasCircle.
It represents the following items:

CIRCLE ',' fLabel ',' intVal ',' rmeasSpecVecbld

*/

class rmeasCircle_rmeasSpecVecbld :
  public rmeasCircle
{
public:
  rmeasCircle_rmeasSpecVecbld();
  rmeasCircle_rmeasSpecVecbld(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbld * rmeasSpecVecbldIn);
  ~rmeasCircle_rmeasSpecVecbld();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbld * a_rmeasSpecVecbld;
};

/********************************************************************/

/* rmeasCone

This is a class for the single definition of rmeasCone.
It represents the following items:

CONE ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasCone :
  public rmeasMinor
{
public:
  rmeasCone();
  rmeasCone(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasCone();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasCparln

This is a parent class.

*/

class rmeasCparln :
  public rmeasMinor
{
public:
  rmeasCparln();
  ~rmeasCparln();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasCparln_rmeasSpecFaOrient

This is a derived class for one of the definitions of rmeasCparln.
It represents the following items:

CPARLN ',' fLabel ',' intVal ',' rmeasSpecFaOrient

*/

class rmeasCparln_rmeasSpecFaOrient :
  public rmeasCparln
{
public:
  rmeasCparln_rmeasSpecFaOrient();
  rmeasCparln_rmeasSpecFaOrient(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFaOrient * rmeasSpecFaOrientIn);
  ~rmeasCparln_rmeasSpecFaOrient();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFaOrient * get_rmeasSpecFaOrient();
  void set_rmeasSpecFaOrient(rmeasSpecFaOrient * rmeasSpecFaOrientIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFaOrient * a_rmeasSpecFaOrient;
};

/********************************************************************/

/* rmeasCparln_rmeasSpecVecbldOrient

This is a derived class for one of the definitions of rmeasCparln.
It represents the following items:

CPARLN ',' fLabel ',' intVal ',' rmeasSpecVecbldOrient

*/

class rmeasCparln_rmeasSpecVecbldOrient :
  public rmeasCparln
{
public:
  rmeasCparln_rmeasSpecVecbldOrient();
  rmeasCparln_rmeasSpecVecbldOrient(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbldOrient * rmeasSpecVecbldOrientIn);
  ~rmeasCparln_rmeasSpecVecbldOrient();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbldOrient * get_rmeasSpecVecbldOrient();
  void set_rmeasSpecVecbldOrient(rmeasSpecVecbldOrient * rmeasSpecVecbldOrientIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbldOrient * a_rmeasSpecVecbldOrient;
};

/********************************************************************/

/* rmeasCylndr

This is a class for the single definition of rmeasCylndr.
It represents the following items:

CYLNDR ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasCylndr :
  public rmeasMinor
{
public:
  rmeasCylndr();
  rmeasCylndr(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasCylndr();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasEdgept

This is a parent class.

*/

class rmeasEdgept :
  public rmeasMinor
{
public:
  rmeasEdgept();
  ~rmeasEdgept();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasEdgept_rmeasSpecFaAxis

This is a derived class for one of the definitions of rmeasEdgept.
It represents the following items:

EDGEPT ',' fLabel ',' intVal ',' rmeasSpecFaAxis

*/

class rmeasEdgept_rmeasSpecFaAxis :
  public rmeasEdgept
{
public:
  rmeasEdgept_rmeasSpecFaAxis();
  rmeasEdgept_rmeasSpecFaAxis(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFaAxis * rmeasSpecFaAxisIn);
  ~rmeasEdgept_rmeasSpecFaAxis();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFaAxis * get_rmeasSpecFaAxis();
  void set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFaAxis * a_rmeasSpecFaAxis;
};

/********************************************************************/

/* rmeasEdgept_rmeasSpecVecbldEdgept

This is a derived class for one of the definitions of rmeasEdgept.
It represents the following items:

EDGEPT ',' fLabel ',' intVal ',' rmeasSpecVecbldEdgept

*/

class rmeasEdgept_rmeasSpecVecbldEdgept :
  public rmeasEdgept
{
public:
  rmeasEdgept_rmeasSpecVecbldEdgept();
  rmeasEdgept_rmeasSpecVecbldEdgept(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbldEdgept * rmeasSpecVecbldEdgeptIn);
  ~rmeasEdgept_rmeasSpecVecbldEdgept();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbldEdgept * get_rmeasSpecVecbldEdgept();
  void set_rmeasSpecVecbldEdgept(rmeasSpecVecbldEdgept * rmeasSpecVecbldEdgeptIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbldEdgept * a_rmeasSpecVecbldEdgept;
};

/********************************************************************/

/* rmeasEllips

This is a parent class.

*/

class rmeasEllips :
  public rmeasMinor
{
public:
  rmeasEllips();
  ~rmeasEllips();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasEllips_rmeasSpecFa

This is a derived class for one of the definitions of rmeasEllips.
It represents the following items:

ELLIPS ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasEllips_rmeasSpecFa :
  public rmeasEllips
{
public:
  rmeasEllips_rmeasSpecFa();
  rmeasEllips_rmeasSpecFa(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasEllips_rmeasSpecFa();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasEllips_rmeasSpecVecbld

This is a derived class for one of the definitions of rmeasEllips.
It represents the following items:

ELLIPS ',' fLabel ',' intVal ',' rmeasSpecVecbld

*/

class rmeasEllips_rmeasSpecVecbld :
  public rmeasEllips
{
public:
  rmeasEllips_rmeasSpecVecbld();
  rmeasEllips_rmeasSpecVecbld(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbld * rmeasSpecVecbldIn);
  ~rmeasEllips_rmeasSpecVecbld();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbld * a_rmeasSpecVecbld;
};

/********************************************************************/

/* rmeasGcurve

This is a parent class.

*/

class rmeasGcurve :
  public rmeasMinor
{
public:
  rmeasGcurve();
  ~rmeasGcurve();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasGcurve_rmeasSpecFeatAxis

This is a derived class for one of the definitions of rmeasGcurve.
It represents the following items:

GCURVE ',' fLabel ',' intVal ',' rmeasSpecFeatAxis

*/

class rmeasGcurve_rmeasSpecFeatAxis :
  public rmeasGcurve
{
public:
  rmeasGcurve_rmeasSpecFeatAxis();
  rmeasGcurve_rmeasSpecFeatAxis(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFeatAxis * rmeasSpecFeatAxisIn);
  ~rmeasGcurve_rmeasSpecFeatAxis();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFeatAxis * get_rmeasSpecFeatAxis();
  void set_rmeasSpecFeatAxis(rmeasSpecFeatAxis * rmeasSpecFeatAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFeatAxis * a_rmeasSpecFeatAxis;
};

/********************************************************************/

/* rmeasGcurve_rmeasSpecVecbld

This is a derived class for one of the definitions of rmeasGcurve.
It represents the following items:

GCURVE ',' fLabel ',' intVal ',' rmeasSpecVecbld

*/

class rmeasGcurve_rmeasSpecVecbld :
  public rmeasGcurve
{
public:
  rmeasGcurve_rmeasSpecVecbld();
  rmeasGcurve_rmeasSpecVecbld(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbld * rmeasSpecVecbldIn);
  ~rmeasGcurve_rmeasSpecVecbld();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbld * a_rmeasSpecVecbld;
};

/********************************************************************/

/* rmeasGsurf

This is a class for the single definition of rmeasGsurf.
It represents the following items:

GSURF ',' fLabel ',' intVal ',' rmeasSpecFaAxis

*/

class rmeasGsurf :
  public rmeasMinor
{
public:
  rmeasGsurf();
  rmeasGsurf(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFaAxis * rmeasSpecFaAxisIn);
  ~rmeasGsurf();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFaAxis * get_rmeasSpecFaAxis();
  void set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFaAxis * a_rmeasSpecFaAxis;
};

/********************************************************************/

/* rmeasLine

This is a parent class.

*/

class rmeasLine :
  public rmeasMinor
{
public:
  rmeasLine();
  ~rmeasLine();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasLine_rmeasSpecFeatAxis

This is a derived class for one of the definitions of rmeasLine.
It represents the following items:

LINE ',' fLabel ',' intVal ',' rmeasSpecFeatAxis

*/

class rmeasLine_rmeasSpecFeatAxis :
  public rmeasLine
{
public:
  rmeasLine_rmeasSpecFeatAxis();
  rmeasLine_rmeasSpecFeatAxis(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFeatAxis * rmeasSpecFeatAxisIn);
  ~rmeasLine_rmeasSpecFeatAxis();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFeatAxis * get_rmeasSpecFeatAxis();
  void set_rmeasSpecFeatAxis(rmeasSpecFeatAxis * rmeasSpecFeatAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFeatAxis * a_rmeasSpecFeatAxis;
};

/********************************************************************/

/* rmeasLine_rmeasSpecVecbld

This is a derived class for one of the definitions of rmeasLine.
It represents the following items:

LINE ',' fLabel ',' intVal ',' rmeasSpecVecbld

*/

class rmeasLine_rmeasSpecVecbld :
  public rmeasLine
{
public:
  rmeasLine_rmeasSpecVecbld();
  rmeasLine_rmeasSpecVecbld(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbld * rmeasSpecVecbldIn);
  ~rmeasLine_rmeasSpecVecbld();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbld * a_rmeasSpecVecbld;
};

/********************************************************************/

/* rmeasObject

This is a parent class.

*/

class rmeasObject :
  public rmeasMinor
{
public:
  rmeasObject();
  ~rmeasObject();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasObject_rmeasSpecFa

This is a derived class for one of the definitions of rmeasObject.
It represents the following items:

OBJECT ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasObject_rmeasSpecFa :
  public rmeasObject
{
public:
  rmeasObject_rmeasSpecFa();
  rmeasObject_rmeasSpecFa(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasObject_rmeasSpecFa();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasObject_rmeasSpecVecbld

This is a derived class for one of the definitions of rmeasObject.
It represents the following items:

OBJECT ',' fLabel ',' intVal ',' rmeasSpecVecbld

*/

class rmeasObject_rmeasSpecVecbld :
  public rmeasObject
{
public:
  rmeasObject_rmeasSpecVecbld();
  rmeasObject_rmeasSpecVecbld(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbld * rmeasSpecVecbldIn);
  ~rmeasObject_rmeasSpecVecbld();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbld * a_rmeasSpecVecbld;
};

/********************************************************************/

/* rmeasParpln

This is a class for the single definition of rmeasParpln.
It represents the following items:

PARPLN ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasParpln :
  public rmeasMinor
{
public:
  rmeasParpln();
  rmeasParpln(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasParpln();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasPlane

This is a class for the single definition of rmeasPlane.
It represents the following items:

PLANE ',' fLabel ',' intVal ',' rmeasSpecFaAxis

*/

class rmeasPlane :
  public rmeasMinor
{
public:
  rmeasPlane();
  rmeasPlane(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFaAxis * rmeasSpecFaAxisIn);
  ~rmeasPlane();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFaAxis * get_rmeasSpecFaAxis();
  void set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFaAxis * a_rmeasSpecFaAxis;
};

/********************************************************************/

/* rmeasPoint

This is a parent class.

*/

class rmeasPoint :
  public rmeasMinor
{
public:
  rmeasPoint();
  ~rmeasPoint();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasPoint_rmeasSpecFaAxis

This is a derived class for one of the definitions of rmeasPoint.
It represents the following items:

POINT ',' fLabel ',' intVal ',' rmeasSpecFaAxis

*/

class rmeasPoint_rmeasSpecFaAxis :
  public rmeasPoint
{
public:
  rmeasPoint_rmeasSpecFaAxis();
  rmeasPoint_rmeasSpecFaAxis(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFaAxis * rmeasSpecFaAxisIn);
  ~rmeasPoint_rmeasSpecFaAxis();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFaAxis * get_rmeasSpecFaAxis();
  void set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFaAxis * a_rmeasSpecFaAxis;
};

/********************************************************************/

/* rmeasPoint_rmeasSpecVecbld

This is a derived class for one of the definitions of rmeasPoint.
It represents the following items:

POINT ',' fLabel ',' intVal ',' rmeasSpecVecbld

*/

class rmeasPoint_rmeasSpecVecbld :
  public rmeasPoint
{
public:
  rmeasPoint_rmeasSpecVecbld();
  rmeasPoint_rmeasSpecVecbld(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecVecbld * rmeasSpecVecbldIn);
  ~rmeasPoint_rmeasSpecVecbld();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecVecbld * a_rmeasSpecVecbld;
};

/********************************************************************/

/* rmeasRctngl

This is a class for the single definition of rmeasRctngl.
It represents the following items:

RCTNGL ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasRctngl :
  public rmeasMinor
{
public:
  rmeasRctngl();
  rmeasRctngl(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasRctngl();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasSphere

This is a class for the single definition of rmeasSphere.
It represents the following items:

SPHERE ',' fLabel ',' intVal ',' rmeasSpecFaAxis

*/

class rmeasSphere :
  public rmeasMinor
{
public:
  rmeasSphere();
  rmeasSphere(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFaAxis * rmeasSpecFaAxisIn);
  ~rmeasSphere();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFaAxis * get_rmeasSpecFaAxis();
  void set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFaAxis * a_rmeasSpecFaAxis;
};

/********************************************************************/

/* rmeasSympln

This is a class for the single definition of rmeasSympln.
It represents the following items:

SYMPLN ',' fLabel ',' intVal ',' rmeasSpecFa

*/

class rmeasSympln :
  public rmeasMinor
{
public:
  rmeasSympln();
  rmeasSympln(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFa * rmeasSpecFaIn);
  ~rmeasSympln();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFa * get_rmeasSpecFa();
  void set_rmeasSpecFa(rmeasSpecFa * rmeasSpecFaIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFa * a_rmeasSpecFa;
};

/********************************************************************/

/* rmeasTorus

This is a class for the single definition of rmeasTorus.
It represents the following items:

TORUS ',' fLabel ',' intVal ',' rmeasSpecFaAxis

*/

class rmeasTorus :
  public rmeasMinor
{
public:
  rmeasTorus();
  rmeasTorus(
    fLabel * fLabelIn,
    intVal * numMeasIn,
    rmeasSpecFaAxis * rmeasSpecFaAxisIn);
  ~rmeasTorus();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  intVal * get_numMeas();
  void set_numMeas(intVal * numMeasIn);
  rmeasSpecFaAxis * get_rmeasSpecFaAxis();
  void set_rmeasSpecFaAxis(rmeasSpecFaAxis * rmeasSpecFaAxisIn);
private:
  fLabel * a_fLabel;
  intVal * numMeas;
  rmeasSpecFaAxis * a_rmeasSpecFaAxis;
};

/********************************************************************/

/* rmeasSpecFa

This is a parent class.

*/

class rmeasSpecFa :
  public dmisCppBase
{
public:
  rmeasSpecFa();
  ~rmeasSpecFa();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasSpecFaAxis

This is a parent class.

*/

class rmeasSpecFaAxis :
  public dmisCppBase
{
public:
  rmeasSpecFaAxis();
  ~rmeasSpecFaAxis();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasSpecFaAxis_faLabel

This is a derived class for one of the definitions of rmeasSpecFaAxis.
It represents the following items:

faLabel [',' axis]

*/

class rmeasSpecFaAxis_faLabel :
  public rmeasSpecFaAxis
{
public:
  rmeasSpecFaAxis_faLabel();
  rmeasSpecFaAxis_faLabel(
    faLabel * faLabelIn,
    axis * axisIn);
  ~rmeasSpecFaAxis_faLabel();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  faLabel * a_faLabel;
  axis * a_axis;
};

/********************************************************************/

/* rmeasSpecFaAxis_axis

This is a derived class for one of the definitions of rmeasSpecFaAxis.
It represents the following items:

axis

*/

class rmeasSpecFaAxis_axis :
  public rmeasSpecFaAxis
{
public:
  rmeasSpecFaAxis_axis();
  rmeasSpecFaAxis_axis(
    axis * axisIn);
  ~rmeasSpecFaAxis_axis();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  axis * a_axis;
};

/********************************************************************/

/* rmeasSpecFaOrient

This is a class for the single definition of rmeasSpecFaOrient.
It represents the following items:

faLabel [',' ORIENT]

*/

class rmeasSpecFaOrient :
  public dmisCppBase
{
public:
  rmeasSpecFaOrient();
  rmeasSpecFaOrient(
    faLabel * faLabelIn,
    bool has_ORIENTIn);
  ~rmeasSpecFaOrient();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  bool get_has_ORIENT();
  void set_has_ORIENT(bool has_ORIENTIn);
private:
  faLabel * a_faLabel;
  bool has_ORIENT;
};

/********************************************************************/

/* rmeasSpecFeatAxis

This is a parent class.

*/

class rmeasSpecFeatAxis :
  public dmisCppBase
{
public:
  rmeasSpecFeatAxis();
  ~rmeasSpecFeatAxis();
  void printSelf() = 0;
};

/********************************************************************/

/* rmeasSpecFeatAxis_featureLabel1

This is a derived class for one of the definitions of rmeasSpecFeatAxis.
It represents the following items:

featureLabel1 [',' axis]

*/

class rmeasSpecFeatAxis_featureLabel1 :
  public rmeasSpecFeatAxis
{
public:
  rmeasSpecFeatAxis_featureLabel1();
  rmeasSpecFeatAxis_featureLabel1(
    featureLabel1 * featureLabel1In,
    axis * axisIn);
  ~rmeasSpecFeatAxis_featureLabel1();
  void printSelf();
  featureLabel1 * get_featureLabel1();
  void set_featureLabel1(featureLabel1 * featureLabel1In);
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  featureLabel1 * a_featureLabel1;
  axis * a_axis;
};

/********************************************************************/

/* rmeasSpecFeatAxis_axis

This is a derived class for one of the definitions of rmeasSpecFeatAxis.
It represents the following items:

axis

*/

class rmeasSpecFeatAxis_axis :
  public rmeasSpecFeatAxis
{
public:
  rmeasSpecFeatAxis_axis();
  rmeasSpecFeatAxis_axis(
    axis * axisIn);
  ~rmeasSpecFeatAxis_axis();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  axis * a_axis;
};

/********************************************************************/

/* rmeasSpecVecbld

This is a class for the single definition of rmeasSpecVecbld.
It represents the following items:

VECBLD ',' rentVal ',' intVal

*/

class rmeasSpecVecbld :
  public dmisCppBase
{
public:
  rmeasSpecVecbld();
  rmeasSpecVecbld(
    rentVal * rIn,
    intVal * numPtsIn);
  ~rmeasSpecVecbld();
  void printSelf();
  rentVal * get_r();
  void set_r(rentVal * rIn);
  intVal * get_numPts();
  void set_numPts(intVal * numPtsIn);
private:
  rentVal * r;
  intVal * numPts;
};

/********************************************************************/

/* rmeasSpecVecbldOrient

This is a class for the single definition of rmeasSpecVecbldOrient.
It represents the following items:

rmeasSpecVecbld [',' ORIENT]

*/

class rmeasSpecVecbldOrient :
  public dmisCppBase
{
public:
  rmeasSpecVecbldOrient();
  rmeasSpecVecbldOrient(
    rmeasSpecVecbld * rmeasSpecVecbldIn,
    bool has_ORIENTIn);
  ~rmeasSpecVecbldOrient();
  void printSelf();
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
  bool get_has_ORIENT();
  void set_has_ORIENT(bool has_ORIENTIn);
private:
  rmeasSpecVecbld * a_rmeasSpecVecbld;
  bool has_ORIENT;
};

/********************************************************************/

/* rmeasSpecVecbldEdgept

This is a class for the single definition of rmeasSpecVecbldEdgept.
It represents the following items:

rmeasSpecVecbld ',' rentVal [',' posDir] [',' axis]

*/

class rmeasSpecVecbldEdgept :
  public dmisCppBase
{
public:
  rmeasSpecVecbldEdgept();
  rmeasSpecVecbldEdgept(
    rmeasSpecVecbld * rmeasSpecVecbldIn,
    rentVal * offsetIn,
    posDir * posDirIn,
    axis * axisIn);
  ~rmeasSpecVecbldEdgept();
  void printSelf();
  rmeasSpecVecbld * get_rmeasSpecVecbld();
  void set_rmeasSpecVecbld(rmeasSpecVecbld * rmeasSpecVecbldIn);
  rentVal * get_offset();
  void set_offset(rentVal * offsetIn);
  posDir * get_posDir();
  void set_posDir(posDir * posDirIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  rmeasSpecVecbld * a_rmeasSpecVecbld;
  rentVal * offset;
  posDir * a_posDir;
  axis * a_axis;
};

/********************************************************************/

/* rotabMinor

This is a parent class.

*/

class rotabMinor :
  public dmisCppBase
{
public:
  rotabMinor();
  ~rotabMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* rotabAbs

This is a derived class for one of the definitions of rotabMinor.
It represents the following items:

rtLabel ',' rotAbs ',' rotType ',' angle [',' FZ ',' angle]

*/

class rotabAbs :
  public rotabMinor
{
public:
  rotabAbs();
  rotabAbs(
    rtLabel * rtLabelIn,
    rotAbs * rotAbsIn,
    rotType * rotTypeIn,
    angle * rotAngleIn,
    angle * maxDevIn);
  ~rotabAbs();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  rotAbs * get_rotAbs();
  void set_rotAbs(rotAbs * rotAbsIn);
  rotType * get_rotType();
  void set_rotType(rotType * rotTypeIn);
  angle * get_rotAngle();
  void set_rotAngle(angle * rotAngleIn);
  angle * get_maxDev();
  void set_maxDev(angle * maxDevIn);
private:
  rtLabel * a_rtLabel;
  rotAbs * a_rotAbs;
  rotType * a_rotType;
  angle * rotAngle;
  angle * maxDev;
};

/********************************************************************/

/* rotabIncr

This is a derived class for one of the definitions of rotabMinor.
It represents the following items:

rtLabel ',' rotIncr ',' rotType ',' angle [',' FZ ',' angle]

*/

class rotabIncr :
  public rotabMinor
{
public:
  rotabIncr();
  rotabIncr(
    rtLabel * rtLabelIn,
    rotIncr * rotIncrIn,
    rotType * rotTypeIn,
    angle * rotAngleIn,
    angle * maxDevIn);
  ~rotabIncr();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  rotIncr * get_rotIncr();
  void set_rotIncr(rotIncr * rotIncrIn);
  rotType * get_rotType();
  void set_rotType(rotType * rotTypeIn);
  angle * get_rotAngle();
  void set_rotAngle(angle * rotAngleIn);
  angle * get_maxDev();
  void set_maxDev(angle * maxDevIn);
private:
  rtLabel * a_rtLabel;
  rotIncr * a_rotIncr;
  rotType * a_rotType;
  angle * rotAngle;
  angle * maxDev;
};

/********************************************************************/

/* rotabFeat

This is a derived class for one of the definitions of rotabMinor.
It represents the following items:

rtLabel ',' featureLabel ',' rotType ',' rotDir

*/

class rotabFeat :
  public rotabMinor
{
public:
  rotabFeat();
  rotabFeat(
    rtLabel * rtLabelIn,
    featureLabel * featureLabelIn,
    rotType * rotTypeIn,
    rotDir * rotDirIn);
  ~rotabFeat();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  rotType * get_rotType();
  void set_rotType(rotType * rotTypeIn);
  rotDir * get_rotDir();
  void set_rotDir(rotDir * rotDirIn);
private:
  rtLabel * a_rtLabel;
  featureLabel * a_featureLabel;
  rotType * a_rotType;
  rotDir * a_rotDir;
};

/********************************************************************/

/* rotateStm

This is a class for the single definition of rotateStm.
It represents the following items:

dLabel '=' ROTATE '/' rotateMinor #

*/

class rotateStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  rotateStm();
  rotateStm(
    dLabel * dLabelIn,
    rotateMinor * rotateMinorIn);
  ~rotateStm();
  void printSelf();
  dLabel * get_dLabel();
  void set_dLabel(dLabel * dLabelIn);
  rotateMinor * get_rotateMinor();
  void set_rotateMinor(rotateMinor * rotateMinorIn);
private:
  dLabel * a_dLabel;
  rotateMinor * a_rotateMinor;
};

/********************************************************************/

/* rotateMinor

This is a parent class.

*/

class rotateMinor :
  public dmisCppBase
{
public:
  rotateMinor();
  ~rotateMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* rotateValue

This is a class for the single definition of rotateValue.
It represents the following items:

axis ',' angle

*/

class rotateValue :
  public rotateMinor
{
public:
  rotateValue();
  rotateValue(
    axis * axisIn,
    angle * angleIn);
  ~rotateValue();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  axis * a_axis;
  angle * a_angle;
};

/********************************************************************/

/* rotateFeature

This is a class for the single definition of rotateFeature.
It represents the following items:

axis ',' featureLabel ',' dir

*/

class rotateFeature :
  public rotateMinor
{
public:
  rotateFeature();
  rotateFeature(
    axis * axisIn,
    featureLabel * featureLabelIn,
    dir * dirIn);
  ~rotateFeature();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  dir * get_dir();
  void set_dir(dir * dirIn);
private:
  axis * a_axis;
  featureLabel * a_featureLabel;
  dir * a_dir;
};

/********************************************************************/

/* rotateDatum

This is a class for the single definition of rotateDatum.
It represents the following items:

axis ',' datLabel ',' dir

*/

class rotateDatum :
  public rotateMinor
{
public:
  rotateDatum();
  rotateDatum(
    axis * axisIn,
    datLabel * datLabelIn,
    dir * dirIn);
  ~rotateDatum();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  dir * get_dir();
  void set_dir(dir * dirIn);
private:
  axis * a_axis;
  datLabel * a_datLabel;
  dir * a_dir;
};

/********************************************************************/

/* rotdefStm

This is a class for the single definition of rotdefStm.
It represents the following items:

rtLabel '=' ROTDEF '/' pointVecCart [',' rtLabel] #

*/

class rotdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  rotdefStm();
  rotdefStm(
    rtLabel * theTableIn,
    pointVecCart * pointVecCartIn,
    rtLabel * otherTableIn);
  ~rotdefStm();
  void printSelf();
  rtLabel * get_theTable();
  void set_theTable(rtLabel * theTableIn);
  pointVecCart * get_pointVecCart();
  void set_pointVecCart(pointVecCart * pointVecCartIn);
  rtLabel * get_otherTable();
  void set_otherTable(rtLabel * otherTableIn);
private:
  rtLabel * theTable;
  pointVecCart * a_pointVecCart;
  rtLabel * otherTable;
};

/********************************************************************/

/* saveDatumStm

This is a class for the single definition of saveDatumStm.
It represents the following items:

SAVE '/' datumLabel1 [',' didLabel] #

*/

class saveDatumStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  saveDatumStm();
  saveDatumStm(
    datumLabel1 * datumLabel1In,
    didLabel * didLabelIn);
  ~saveDatumStm();
  void printSelf();
  datumLabel1 * get_datumLabel1();
  void set_datumLabel1(datumLabel1 * datumLabel1In);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  datumLabel1 * a_datumLabel1;
  didLabel * a_didLabel;
};

/********************************************************************/

/* saveFeatureStm

This is a class for the single definition of saveFeatureStm.
It represents the following items:

SAVE '/' faLabel [',' didLabel] #

*/

class saveFeatureStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  saveFeatureStm();
  saveFeatureStm(
    faLabel * faLabelIn,
    didLabel * didLabelIn);
  ~saveFeatureStm();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  faLabel * a_faLabel;
  didLabel * a_didLabel;
};

/********************************************************************/

/* saveRotaryTableStm

This is a class for the single definition of saveRotaryTableStm.
It represents the following items:

SAVE '/' rtLabel [',' didLabel] #

*/

class saveRotaryTableStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  saveRotaryTableStm();
  saveRotaryTableStm(
    rtLabel * rtLabelIn,
    didLabel * didLabelIn);
  ~saveRotaryTableStm();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  rtLabel * a_rtLabel;
  didLabel * a_didLabel;
};

/********************************************************************/

/* saveDMLStm

This is a class for the single definition of saveDMLStm.
It represents the following items:

SAVE '/' DML ',' didLabel ',' daLabel #

*/

class saveDMLStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  saveDMLStm();
  saveDMLStm(
    didLabel * didLabelIn,
    daLabel * daLabelIn);
  ~saveDMLStm();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  daLabel * get_daLabel();
  void set_daLabel(daLabel * daLabelIn);
private:
  didLabel * a_didLabel;
  daLabel * a_daLabel;
};

/********************************************************************/

/* scnmodStm

This is a class for the single definition of scnmodStm.
It represents the following items:

SCNMOD '/' state #

*/

class scnmodStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  scnmodStm();
  scnmodStm(
    state * stateIn);
  ~scnmodStm();
  void printSelf();
  state * get_state();
  void set_state(state * stateIn);
private:
  state * a_state;
};

/********************************************************************/

/* scnsetStm

This is a class for the single definition of scnsetStm.
It represents the following items:

SCNSET '/' scnsetMinor #

*/

class scnsetStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  scnsetStm();
  scnsetStm(
    scnsetMinor * scnsetMinorIn);
  ~scnsetStm();
  void printSelf();
  scnsetMinor * get_scnsetMinor();
  void set_scnsetMinor(scnsetMinor * scnsetMinorIn);
private:
  scnsetMinor * a_scnsetMinor;
};

/********************************************************************/

/* scnsetMinor

This is a parent class.

*/

class scnsetMinor :
  public dmisCppBase
{
public:
  scnsetMinor();
  ~scnsetMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* scnsetPeck

This is a class for the single definition of scnsetPeck.
It represents the following items:

PECK ',' scnsetSample

*/

class scnsetPeck :
  public scnsetMinor
{
public:
  scnsetPeck();
  scnsetPeck(
    scnsetSample * scnsetSampleIn);
  ~scnsetPeck();
  void printSelf();
  scnsetSample * get_scnsetSample();
  void set_scnsetSample(scnsetSample * scnsetSampleIn);
private:
  scnsetSample * a_scnsetSample;
};

/********************************************************************/

/* scnsetDrag

This is a class for the single definition of scnsetDrag.
It represents the following items:

DRAG ',' scnsetSampleDrag

*/

class scnsetDrag :
  public scnsetMinor
{
public:
  scnsetDrag();
  scnsetDrag(
    scnsetSampleDrag * scnsetSampleDragIn);
  ~scnsetDrag();
  void printSelf();
  scnsetSampleDrag * get_scnsetSampleDrag();
  void set_scnsetSampleDrag(scnsetSampleDrag * scnsetSampleDragIn);
private:
  scnsetSampleDrag * a_scnsetSampleDrag;
};

/********************************************************************/

/* scnsetNoncon

This is a class for the single definition of scnsetNoncon.
It represents the following items:

NONCON ',' scnsetSample

*/

class scnsetNoncon :
  public scnsetMinor
{
public:
  scnsetNoncon();
  scnsetNoncon(
    scnsetSample * scnsetSampleIn);
  ~scnsetNoncon();
  void printSelf();
  scnsetSample * get_scnsetSample();
  void set_scnsetSample(scnsetSample * scnsetSampleIn);
private:
  scnsetSample * a_scnsetSample;
};

/********************************************************************/

/* scnsetStop

This is a parent class.

*/

class scnsetStop :
  public scnsetMinor
{
public:
  scnsetStop();
  ~scnsetStop();
  void printSelf() = 0;
};

/********************************************************************/

/* scnsetStopPlane

This is a class for the single definition of scnsetStopPlane.
It represents the following items:

STOP ',' PLANE ',' vector [',' RADIUS ',' rentVal] [',' COUNT ',' intVal]

*/

class scnsetStopPlane :
  public scnsetStop
{
public:
  scnsetStopPlane();
  scnsetStopPlane(
    vector * planeVecIn,
    rentVal * radiusIn,
    intVal * countIn);
  ~scnsetStopPlane();
  void printSelf();
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
  rentVal * get_radius();
  void set_radius(rentVal * radiusIn);
  intVal * get_count();
  void set_count(intVal * countIn);
private:
  vector * planeVec;
  rentVal * radius;
  intVal * count;
};

/********************************************************************/

/* scnsetStopSphere

This is a class for the single definition of scnsetStopSphere.
It represents the following items:

STOP ',' SPHERE ',' rentVal

*/

class scnsetStopSphere :
  public scnsetStop
{
public:
  scnsetStopSphere();
  scnsetStopSphere(
    rentVal * radiusIn);
  ~scnsetStopSphere();
  void printSelf();
  rentVal * get_radius();
  void set_radius(rentVal * radiusIn);
private:
  rentVal * radius;
};

/********************************************************************/

/* scnsetVendor

This is a parent class.

*/

class scnsetVendor :
  public scnsetMinor
{
public:
  scnsetVendor();
  ~scnsetVendor();
  void printSelf() = 0;
};

/********************************************************************/

/* scnsetVendor_FORM

This is a derived class for one of the definitions of scnsetVendor.
It represents the following items:

VENDOR ',' FORM

*/

class scnsetVendor_FORM :
  public scnsetVendor
{
public:
  scnsetVendor_FORM();
  ~scnsetVendor_FORM();
  void printSelf();
};

/********************************************************************/

/* scnsetVendor_POS

This is a derived class for one of the definitions of scnsetVendor.
It represents the following items:

VENDOR ',' POS

*/

class scnsetVendor_POS :
  public scnsetVendor
{
public:
  scnsetVendor_POS();
  ~scnsetVendor_POS();
  void printSelf();
};

/********************************************************************/

/* scnsetVendor_SIZE

This is a derived class for one of the definitions of scnsetVendor.
It represents the following items:

VENDOR ',' SIZE

*/

class scnsetVendor_SIZE :
  public scnsetVendor
{
public:
  scnsetVendor_SIZE();
  ~scnsetVendor_SIZE();
  void printSelf();
};

/********************************************************************/

/* scnsetSample

This is a parent class.

*/

class scnsetSample :
  public dmisCppBase
{
public:
  scnsetSample();
  ~scnsetSample();
  void printSelf() = 0;
};

/********************************************************************/

/* scnsetSample_DIST

This is a derived class for one of the definitions of scnsetSample.
It represents the following items:

DIST ',' rentVal [',' axis]

*/

class scnsetSample_DIST :
  public scnsetSample
{
public:
  scnsetSample_DIST();
  scnsetSample_DIST(
    rentVal * distIn,
    axis * axisIn);
  ~scnsetSample_DIST();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  rentVal * dist;
  axis * a_axis;
};

/********************************************************************/

/* scnsetSample_CHORD

This is a derived class for one of the definitions of scnsetSample.
It represents the following items:

CHORD ',' rentVal [',' rentVal]

*/

class scnsetSample_CHORD :
  public scnsetSample
{
public:
  scnsetSample_CHORD();
  scnsetSample_CHORD(
    rentVal * chordIn,
    rentVal * maxdistIn);
  ~scnsetSample_CHORD();
  void printSelf();
  rentVal * get_chord();
  void set_chord(rentVal * chordIn);
  rentVal * get_maxdist();
  void set_maxdist(rentVal * maxdistIn);
private:
  rentVal * chord;
  rentVal * maxdist;
};

/********************************************************************/

/* scnsetSample_TIME

This is a derived class for one of the definitions of scnsetSample.
It represents the following items:

TIME ',' rentVal

*/

class scnsetSample_TIME :
  public scnsetSample
{
public:
  scnsetSample_TIME();
  scnsetSample_TIME(
    rentVal * timeIn);
  ~scnsetSample_TIME();
  void printSelf();
  rentVal * get_time();
  void set_time(rentVal * timeIn);
private:
  rentVal * time;
};

/********************************************************************/

/* scnsetSample_ANGLE

This is a derived class for one of the definitions of scnsetSample.
It represents the following items:

ANGLE ',' angle

*/

class scnsetSample_ANGLE :
  public scnsetSample
{
public:
  scnsetSample_ANGLE();
  scnsetSample_ANGLE(
    angle * angleIn);
  ~scnsetSample_ANGLE();
  void printSelf();
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  angle * a_angle;
};

/********************************************************************/

/* scnsetSample_DEFALT

This is a derived class for one of the definitions of scnsetSample.
It represents the following items:

DEFALT

*/

class scnsetSample_DEFALT :
  public scnsetSample
{
public:
  scnsetSample_DEFALT();
  ~scnsetSample_DEFALT();
  void printSelf();
};

/********************************************************************/

/* scnsetSampleDrag

This is a parent class.

*/

class scnsetSampleDrag :
  public dmisCppBase
{
public:
  scnsetSampleDrag();
  ~scnsetSampleDrag();
  void printSelf() = 0;
};

/********************************************************************/

/* scnsetSampleDrag_DIST

This is a derived class for one of the definitions of scnsetSampleDrag.
It represents the following items:

DIST ',' rentVal [',' axis] [',' forceOrDeflection]

*/

class scnsetSampleDrag_DIST :
  public scnsetSampleDrag
{
public:
  scnsetSampleDrag_DIST();
  scnsetSampleDrag_DIST(
    rentVal * distIn,
    axis * axisIn,
    forceOrDeflection * forceOrDeflectionIn);
  ~scnsetSampleDrag_DIST();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
  forceOrDeflection * get_forceOrDeflection();
  void set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn);
private:
  rentVal * dist;
  axis * a_axis;
  forceOrDeflection * a_forceOrDeflection;
};

/********************************************************************/

/* scnsetSampleDrag_CHORD

This is a derived class for one of the definitions of scnsetSampleDrag.
It represents the following items:

CHORD ',' rentVal [',' rentVal] [',' forceOrDeflection]

*/

class scnsetSampleDrag_CHORD :
  public scnsetSampleDrag
{
public:
  scnsetSampleDrag_CHORD();
  scnsetSampleDrag_CHORD(
    rentVal * chordIn,
    rentVal * maxdistIn,
    forceOrDeflection * forceOrDeflectionIn);
  ~scnsetSampleDrag_CHORD();
  void printSelf();
  rentVal * get_chord();
  void set_chord(rentVal * chordIn);
  rentVal * get_maxdist();
  void set_maxdist(rentVal * maxdistIn);
  forceOrDeflection * get_forceOrDeflection();
  void set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn);
private:
  rentVal * chord;
  rentVal * maxdist;
  forceOrDeflection * a_forceOrDeflection;
};

/********************************************************************/

/* scnsetSampleDrag_TIME

This is a derived class for one of the definitions of scnsetSampleDrag.
It represents the following items:

TIME ',' rentVal [',' forceOrDeflection]

*/

class scnsetSampleDrag_TIME :
  public scnsetSampleDrag
{
public:
  scnsetSampleDrag_TIME();
  scnsetSampleDrag_TIME(
    rentVal * timeIn,
    forceOrDeflection * forceOrDeflectionIn);
  ~scnsetSampleDrag_TIME();
  void printSelf();
  rentVal * get_time();
  void set_time(rentVal * timeIn);
  forceOrDeflection * get_forceOrDeflection();
  void set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn);
private:
  rentVal * time;
  forceOrDeflection * a_forceOrDeflection;
};

/********************************************************************/

/* scnsetSampleDrag_ANGLE

This is a derived class for one of the definitions of scnsetSampleDrag.
It represents the following items:

ANGLE ',' angle [',' forceOrDeflection]

*/

class scnsetSampleDrag_ANGLE :
  public scnsetSampleDrag
{
public:
  scnsetSampleDrag_ANGLE();
  scnsetSampleDrag_ANGLE(
    angle * angleIn,
    forceOrDeflection * forceOrDeflectionIn);
  ~scnsetSampleDrag_ANGLE();
  void printSelf();
  angle * get_angle();
  void set_angle(angle * angleIn);
  forceOrDeflection * get_forceOrDeflection();
  void set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn);
private:
  angle * a_angle;
  forceOrDeflection * a_forceOrDeflection;
};

/********************************************************************/

/* scnsetSampleDrag_DEFALT

This is a derived class for one of the definitions of scnsetSampleDrag.
It represents the following items:

DEFALT [',' forceOrDeflection]

*/

class scnsetSampleDrag_DEFALT :
  public scnsetSampleDrag
{
public:
  scnsetSampleDrag_DEFALT();
  scnsetSampleDrag_DEFALT(
    forceOrDeflection * forceOrDeflectionIn);
  ~scnsetSampleDrag_DEFALT();
  void printSelf();
  forceOrDeflection * get_forceOrDeflection();
  void set_forceOrDeflection(forceOrDeflection * forceOrDeflectionIn);
private:
  forceOrDeflection * a_forceOrDeflection;
};

/********************************************************************/

/* forceOrDeflection

This is a parent class.

*/

class forceOrDeflection :
  public dmisCppBase
{
public:
  forceOrDeflection();
  ~forceOrDeflection();
  void printSelf() = 0;
};

/********************************************************************/

/* forceOrDeflection_FORCE

This is a derived class for one of the definitions of forceOrDeflection.
It represents the following items:

FORCE ',' rentVal

*/

class forceOrDeflection_FORCE :
  public forceOrDeflection
{
public:
  forceOrDeflection_FORCE();
  forceOrDeflection_FORCE(
    rentVal * forceIn);
  ~forceOrDeflection_FORCE();
  void printSelf();
  rentVal * get_force();
  void set_force(rentVal * forceIn);
private:
  rentVal * force;
};

/********************************************************************/

/* forceOrDeflection_DEFLECTION

This is a derived class for one of the definitions of forceOrDeflection.
It represents the following items:

DEFLECTION ',' rentVal

*/

class forceOrDeflection_DEFLECTION :
  public forceOrDeflection
{
public:
  forceOrDeflection_DEFLECTION();
  forceOrDeflection_DEFLECTION(
    rentVal * deflvalIn);
  ~forceOrDeflection_DEFLECTION();
  void printSelf();
  rentVal * get_deflval();
  void set_deflval(rentVal * deflvalIn);
private:
  rentVal * deflval;
};

/********************************************************************/

/* selectStm

This is a parent class.

*/

class selectStm :
  public dmisStatement
{
public:
  selectStm();
  ~selectStm();
  void printSelf() = 0;
};

/********************************************************************/

/* selectStmInt

This is a derived class for one of the definitions of selectStm.
It represents the following items:

SELECT '/' intVal #

*/

class selectStmInt :
  public selectStm
{
public:
  selectStmInt();
  selectStmInt(
    intVal * argIn);
  ~selectStmInt();
  void printSelf();
  intVal * get_arg();
  void set_arg(intVal * argIn);
private:
  intVal * arg;
};

/********************************************************************/

/* selectStmString

This is a derived class for one of the definitions of selectStm.
It represents the following items:

SELECT '/' stringVal #

*/

class selectStmString :
  public selectStm
{
public:
  selectStmString();
  selectStmString(
    stringVal * argIn);
  ~selectStmString();
  void printSelf();
  stringVal * get_arg();
  void set_arg(stringVal * argIn);
private:
  stringVal * arg;
};

/********************************************************************/

/* sensorStm

This is a class for the single definition of sensorStm.
It represents the following items:

ssLabel '=' SENSOR '/' sensorMinor #

*/

class sensorStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  sensorStm();
  sensorStm(
    ssLabel * ssLabelIn,
    sensorMinor * sensorMinorIn);
  ~sensorStm();
  void printSelf();
  ssLabel * get_ssLabel();
  void set_ssLabel(ssLabel * ssLabelIn);
  sensorMinor * get_sensorMinor();
  void set_sensorMinor(sensorMinor * sensorMinorIn);
private:
  ssLabel * a_ssLabel;
  sensorMinor * a_sensorMinor;
};

/********************************************************************/

/* sensorMinor

This is a parent class.

*/

class sensorMinor :
  public dmisCppBase
{
public:
  sensorMinor();
  ~sensorMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* sensorProbe

This is a class for the single definition of sensorProbe.
It represents the following items:

PROBE ',' sensorProbeGeometry [',' sensorProbeForm] [',' sensorItem]

*/

class sensorProbe :
  public sensorMinor
{
public:
  sensorProbe();
  sensorProbe(
    sensorProbeGeometry * sensorProbeGeometryIn,
    sensorProbeForm * sensorProbeFormIn,
    sensorItem * sensorItemIn);
  ~sensorProbe();
  void printSelf();
  sensorProbeGeometry * get_sensorProbeGeometry();
  void set_sensorProbeGeometry(sensorProbeGeometry * sensorProbeGeometryIn);
  sensorProbeForm * get_sensorProbeForm();
  void set_sensorProbeForm(sensorProbeForm * sensorProbeFormIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorProbeGeometry * a_sensorProbeGeometry;
  sensorProbeForm * a_sensorProbeForm;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorMltprb

This is a class for the single definition of sensorMltprb.
It represents the following items:

MLTPRB ',' intVal ',' sensorMltprbItemList [',' sensorItem]

*/

class sensorMltprb :
  public sensorMinor
{
public:
  sensorMltprb();
  sensorMltprb(
    intVal * numStyliIn,
    std::list<sensorMltprbItem *> * sensorMltprbItemListIn,
    sensorItem * sensorItemIn);
  ~sensorMltprb();
  void printSelf();
  intVal * get_numStyli();
  void set_numStyli(intVal * numStyliIn);
  std::list<sensorMltprbItem *> * get_sensorMltprbItemList();
  void set_sensorMltprbItemList(std::list<sensorMltprbItem *> * sensorMltprbItemListIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  intVal * numStyli;
  std::list<sensorMltprbItem *> * a_sensorMltprbItemList;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorVideo

This is a class for the single definition of sensorVideo.
It represents the following items:

VIDEO ',' sensorGeometry ',' rentVal ',' rentVal ',' rentVal [',' sensorItem]

*/

class sensorVideo :
  public sensorMinor
{
public:
  sensorVideo();
  sensorVideo(
    sensorGeometry * sensorGeometryIn,
    rentVal * focalIn,
    rentVal * magIn,
    rentVal * apertIn,
    sensorItem * sensorItemIn);
  ~sensorVideo();
  void printSelf();
  sensorGeometry * get_sensorGeometry();
  void set_sensorGeometry(sensorGeometry * sensorGeometryIn);
  rentVal * get_focal();
  void set_focal(rentVal * focalIn);
  rentVal * get_mag();
  void set_mag(rentVal * magIn);
  rentVal * get_apert();
  void set_apert(rentVal * apertIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorGeometry * a_sensorGeometry;
  rentVal * focal;
  rentVal * mag;
  rentVal * apert;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorLaser

This is a class for the single definition of sensorLaser.
It represents the following items:

LASER ',' sensorGeometry ',' rentVal ',' rentVal [',' sensorItem]

*/

class sensorLaser :
  public sensorMinor
{
public:
  sensorLaser();
  sensorLaser(
    sensorGeometry * sensorGeometryIn,
    rentVal * powerIn,
    rentVal * shuterIn,
    sensorItem * sensorItemIn);
  ~sensorLaser();
  void printSelf();
  sensorGeometry * get_sensorGeometry();
  void set_sensorGeometry(sensorGeometry * sensorGeometryIn);
  rentVal * get_power();
  void set_power(rentVal * powerIn);
  rentVal * get_shuter();
  void set_shuter(rentVal * shuterIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorGeometry * a_sensorGeometry;
  rentVal * power;
  rentVal * shuter;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorInfred

This is a class for the single definition of sensorInfred.
It represents the following items:

INFRED ',' sensorGeometry ',' rentVal ',' rentVal ',' rentVal ',' rentVal [',' sensorItem]

*/

class sensorInfred :
  public sensorMinor
{
public:
  sensorInfred();
  sensorInfred(
    sensorGeometry * sensorGeometryIn,
    rentVal * fovxIn,
    rentVal * fovyIn,
    rentVal * freqIn,
    rentVal * dwellIn,
    sensorItem * sensorItemIn);
  ~sensorInfred();
  void printSelf();
  sensorGeometry * get_sensorGeometry();
  void set_sensorGeometry(sensorGeometry * sensorGeometryIn);
  rentVal * get_fovx();
  void set_fovx(rentVal * fovxIn);
  rentVal * get_fovy();
  void set_fovy(rentVal * fovyIn);
  rentVal * get_freq();
  void set_freq(rentVal * freqIn);
  rentVal * get_dwell();
  void set_dwell(rentVal * dwellIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorGeometry * a_sensorGeometry;
  rentVal * fovx;
  rentVal * fovy;
  rentVal * freq;
  rentVal * dwell;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorNoncon

This is a class for the single definition of sensorNoncon.
It represents the following items:

NONCON ',' sensorGeometry ',' intVal [',' sensorItem]

*/

class sensorNoncon :
  public sensorMinor
{
public:
  sensorNoncon();
  sensorNoncon(
    sensorGeometry * sensorGeometryIn,
    intVal * numProbesIn,
    sensorItem * sensorItemIn);
  ~sensorNoncon();
  void printSelf();
  sensorGeometry * get_sensorGeometry();
  void set_sensorGeometry(sensorGeometry * sensorGeometryIn);
  intVal * get_numProbes();
  void set_numProbes(intVal * numProbesIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorGeometry * a_sensorGeometry;
  intVal * numProbes;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorPoint

This is a class for the single definition of sensorPoint.
It represents the following items:

POINT ',' sensorGeometry ',' rentVal [',' sensorItem]

*/

class sensorPoint :
  public sensorMinor
{
public:
  sensorPoint();
  sensorPoint(
    sensorGeometry * sensorGeometryIn,
    rentVal * fovnIn,
    sensorItem * sensorItemIn);
  ~sensorPoint();
  void printSelf();
  sensorGeometry * get_sensorGeometry();
  void set_sensorGeometry(sensorGeometry * sensorGeometryIn);
  rentVal * get_fovn();
  void set_fovn(rentVal * fovnIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorGeometry * a_sensorGeometry;
  rentVal * fovn;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorLine

This is a class for the single definition of sensorLine.
It represents the following items:

LINE ',' sensorGeometry ',' rentVal ',' rentVal [',' sensorItem]

*/

class sensorLine :
  public sensorMinor
{
public:
  sensorLine();
  sensorLine(
    sensorGeometry * sensorGeometryIn,
    rentVal * fovnIn,
    rentVal * fovcIn,
    sensorItem * sensorItemIn);
  ~sensorLine();
  void printSelf();
  sensorGeometry * get_sensorGeometry();
  void set_sensorGeometry(sensorGeometry * sensorGeometryIn);
  rentVal * get_fovn();
  void set_fovn(rentVal * fovnIn);
  rentVal * get_fovc();
  void set_fovc(rentVal * fovcIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorGeometry * a_sensorGeometry;
  rentVal * fovn;
  rentVal * fovc;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorArea

This is a class for the single definition of sensorArea.
It represents the following items:

AREA ',' sensorGeometry ',' rentVal ',' rentVal ',' rentVal [',' sensorItem]

*/

class sensorArea :
  public sensorMinor
{
public:
  sensorArea();
  sensorArea(
    sensorGeometry * sensorGeometryIn,
    rentVal * fovcIn,
    rentVal * fovoIn,
    rentVal * fovnIn,
    sensorItem * sensorItemIn);
  ~sensorArea();
  void printSelf();
  sensorGeometry * get_sensorGeometry();
  void set_sensorGeometry(sensorGeometry * sensorGeometryIn);
  rentVal * get_fovc();
  void set_fovc(rentVal * fovcIn);
  rentVal * get_fovo();
  void set_fovo(rentVal * fovoIn);
  rentVal * get_fovn();
  void set_fovn(rentVal * fovnIn);
  sensorItem * get_sensorItem();
  void set_sensorItem(sensorItem * sensorItemIn);
private:
  sensorGeometry * a_sensorGeometry;
  rentVal * fovc;
  rentVal * fovo;
  rentVal * fovn;
  sensorItem * a_sensorItem;
};

/********************************************************************/

/* sensorProbeGeometry

This is a class for the single definition of sensorProbeGeometry.
It represents the following items:

vector ',' vector ',' rentVal

*/

class sensorProbeGeometry :
  public dmisCppBase
{
public:
  sensorProbeGeometry();
  sensorProbeGeometry(
    vector * offsetIn,
    vector * normalIn,
    rentVal * diamIn);
  ~sensorProbeGeometry();
  void printSelf();
  vector * get_offset();
  void set_offset(vector * offsetIn);
  vector * get_normal();
  void set_normal(vector * normalIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
private:
  vector * offset;
  vector * normal;
  rentVal * diam;
};

/********************************************************************/

/* sensorProbeForm

This is a parent class.

*/

class sensorProbeForm :
  public dmisCppBase
{
public:
  sensorProbeForm();
  ~sensorProbeForm();
  void printSelf() = 0;
};

/********************************************************************/

/* sensorProbeForm_SPHERE

This is a derived class for one of the definitions of sensorProbeForm.
It represents the following items:

SPHERE

*/

class sensorProbeForm_SPHERE :
  public sensorProbeForm
{
public:
  sensorProbeForm_SPHERE();
  ~sensorProbeForm_SPHERE();
  void printSelf();
};

/********************************************************************/

/* sensorProbeForm_CYLNDR

This is a derived class for one of the definitions of sensorProbeForm.
It represents the following items:

CYLNDR ',' rentVal

*/

class sensorProbeForm_CYLNDR :
  public sensorProbeForm
{
public:
  sensorProbeForm_CYLNDR();
  sensorProbeForm_CYLNDR(
    rentVal * len1In);
  ~sensorProbeForm_CYLNDR();
  void printSelf();
  rentVal * get_len1();
  void set_len1(rentVal * len1In);
private:
  rentVal * len1;
};

/********************************************************************/

/* sensorProbeForm_DISK

This is a derived class for one of the definitions of sensorProbeForm.
It represents the following items:

DISK ',' rentVal

*/

class sensorProbeForm_DISK :
  public sensorProbeForm
{
public:
  sensorProbeForm_DISK();
  sensorProbeForm_DISK(
    rentVal * thknIn);
  ~sensorProbeForm_DISK();
  void printSelf();
  rentVal * get_thkn();
  void set_thkn(rentVal * thknIn);
private:
  rentVal * thkn;
};

/********************************************************************/

/* sensorItem

This is a parent class.

*/

class sensorItem :
  public dmisCppBase
{
public:
  sensorItem();
  ~sensorItem();
  void printSelf() = 0;
};

/********************************************************************/

/* sensorItem_stringVal

This is a derived class for one of the definitions of sensorItem.
It represents the following items:

stringVal ',' stringVal ',' stringVal

*/

class sensorItem_stringVal :
  public sensorItem
{
public:
  sensorItem_stringVal();
  sensorItem_stringVal(
    stringVal * dataStorIn,
    stringVal * dataListIn,
    stringVal * dataItemIn);
  ~sensorItem_stringVal();
  void printSelf();
  stringVal * get_dataStor();
  void set_dataStor(stringVal * dataStorIn);
  stringVal * get_dataList();
  void set_dataList(stringVal * dataListIn);
  stringVal * get_dataItem();
  void set_dataItem(stringVal * dataItemIn);
private:
  stringVal * dataStor;
  stringVal * dataList;
  stringVal * dataItem;
};

/********************************************************************/

/* sensorItem_intVal

This is a derived class for one of the definitions of sensorItem.
It represents the following items:

stringVal ',' stringVal ',' intVal

*/

class sensorItem_intVal :
  public sensorItem
{
public:
  sensorItem_intVal();
  sensorItem_intVal(
    stringVal * dataStorIn,
    stringVal * dataListIn,
    intVal * indexIn);
  ~sensorItem_intVal();
  void printSelf();
  stringVal * get_dataStor();
  void set_dataStor(stringVal * dataStorIn);
  stringVal * get_dataList();
  void set_dataList(stringVal * dataListIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  stringVal * dataStor;
  stringVal * dataList;
  intVal * index;
};

/********************************************************************/

/* sensorMltprbItem

This is a parent class.

*/

class sensorMltprbItem :
  public dmisCppBase
{
public:
  sensorMltprbItem();
  ~sensorMltprbItem();
  void printSelf() = 0;
};

/********************************************************************/

/* sensorMltprbItem_stringVal

This is a derived class for one of the definitions of sensorMltprbItem.
It represents the following items:

stringVal ',' sensorProbeGeometry

*/

class sensorMltprbItem_stringVal :
  public sensorMltprbItem
{
public:
  sensorMltprbItem_stringVal();
  sensorMltprbItem_stringVal(
    stringVal * descIn,
    sensorProbeGeometry * sensorProbeGeometryIn);
  ~sensorMltprbItem_stringVal();
  void printSelf();
  stringVal * get_desc();
  void set_desc(stringVal * descIn);
  sensorProbeGeometry * get_sensorProbeGeometry();
  void set_sensorProbeGeometry(sensorProbeGeometry * sensorProbeGeometryIn);
private:
  stringVal * desc;
  sensorProbeGeometry * a_sensorProbeGeometry;
};

/********************************************************************/

/* sensorMltprbItem_intVal

This is a derived class for one of the definitions of sensorMltprbItem.
It represents the following items:

intVal ',' sensorProbeGeometry

*/

class sensorMltprbItem_intVal :
  public sensorMltprbItem
{
public:
  sensorMltprbItem_intVal();
  sensorMltprbItem_intVal(
    intVal * tipnumIn,
    sensorProbeGeometry * sensorProbeGeometryIn);
  ~sensorMltprbItem_intVal();
  void printSelf();
  intVal * get_tipnum();
  void set_tipnum(intVal * tipnumIn);
  sensorProbeGeometry * get_sensorProbeGeometry();
  void set_sensorProbeGeometry(sensorProbeGeometry * sensorProbeGeometryIn);
private:
  intVal * tipnum;
  sensorProbeGeometry * a_sensorProbeGeometry;
};

/********************************************************************/

/* sensorGeometry

This is a class for the single definition of sensorGeometry.
It represents the following items:

vector ',' vector ',' vector

*/

class sensorGeometry :
  public dmisCppBase
{
public:
  sensorGeometry();
  sensorGeometry(
    vector * offsetIn,
    vector * normalIn,
    vector * clockIn);
  ~sensorGeometry();
  void printSelf();
  vector * get_offset();
  void set_offset(vector * offsetIn);
  vector * get_normal();
  void set_normal(vector * normalIn);
  vector * get_clock();
  void set_clock(vector * clockIn);
private:
  vector * offset;
  vector * normal;
  vector * clock;
};

/********************************************************************/

/* simreqtStm

This is a class for the single definition of simreqtStm.
It represents the following items:

srLabel '=' SIMREQT '/' simreqtMinor #

*/

class simreqtStm :
  public dmisStatement
{
public:
  simreqtStm();
  simreqtStm(
    srLabel * srLabelIn,
    simreqtMinor * simreqtMinorIn);
  ~simreqtStm();
  void printSelf();
  srLabel * get_srLabel();
  void set_srLabel(srLabel * srLabelIn);
  simreqtMinor * get_simreqtMinor();
  void set_simreqtMinor(simreqtMinor * simreqtMinorIn);
private:
  srLabel * a_srLabel;
  simreqtMinor * a_simreqtMinor;
};

/********************************************************************/

/* simreqtMinor

This is a parent class.

*/

class simreqtMinor :
  public dmisCppBase
{
public:
  simreqtMinor();
  ~simreqtMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* simreqtMinor_FIRST

This is a derived class for one of the definitions of simreqtMinor.
It represents the following items:

FIRST

*/

class simreqtMinor_FIRST :
  public simreqtMinor
{
public:
  simreqtMinor_FIRST();
  ~simreqtMinor_FIRST();
  void printSelf();
};

/********************************************************************/

/* simreqtMinor_OPTIMAL

This is a derived class for one of the definitions of simreqtMinor.
It represents the following items:

OPTIMAL

*/

class simreqtMinor_OPTIMAL :
  public simreqtMinor
{
public:
  simreqtMinor_OPTIMAL();
  ~simreqtMinor_OPTIMAL();
  void printSelf();
};

/********************************************************************/

/* snsdefStm

This is a class for the single definition of snsdefStm.
It represents the following items:

sLabel '=' SNSDEF '/' snsdefMinor #

*/

class snsdefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  snsdefStm();
  snsdefStm(
    sLabel * sLabelIn,
    snsdefMinor * snsdefMinorIn);
  ~snsdefStm();
  void printSelf();
  sLabel * get_sLabel();
  void set_sLabel(sLabel * sLabelIn);
  snsdefMinor * get_snsdefMinor();
  void set_snsdefMinor(snsdefMinor * snsdefMinorIn);
private:
  sLabel * a_sLabel;
  snsdefMinor * a_snsdefMinor;
};

/********************************************************************/

/* snsdefMinor

This is a parent class.

*/

class snsdefMinor :
  public dmisCppBase
{
public:
  snsdefMinor();
  ~snsdefMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* snsdefProbe

This is a class for the single definition of snsdefProbe.
It represents the following items:

PROBE ',' snsdefType ',' probeLocation ',' rentVal [',' snsdefProbeForm]

*/

class snsdefProbe :
  public snsdefMinor
{
public:
  snsdefProbe();
  snsdefProbe(
    snsdefType * snsdefTypeIn,
    probeLocation * probeLocationIn,
    rentVal * diamIn,
    snsdefProbeForm * snsdefProbeFormIn);
  ~snsdefProbe();
  void printSelf();
  snsdefType * get_snsdefType();
  void set_snsdefType(snsdefType * snsdefTypeIn);
  probeLocation * get_probeLocation();
  void set_probeLocation(probeLocation * probeLocationIn);
  rentVal * get_diam();
  void set_diam(rentVal * diamIn);
  snsdefProbeForm * get_snsdefProbeForm();
  void set_snsdefProbeForm(snsdefProbeForm * snsdefProbeFormIn);
private:
  snsdefType * a_snsdefType;
  probeLocation * a_probeLocation;
  rentVal * diam;
  snsdefProbeForm * a_snsdefProbeForm;
};

/********************************************************************/

/* probeLocation

This is a parent class.

*/

class probeLocation :
  public dmisCppBase
{
public:
  probeLocation();
  ~probeLocation();
  void printSelf() = 0;
};

/********************************************************************/

/* probeLocCart

This is a derived class for one of the definitions of probeLocation.
It represents the following items:

CART ',' vector ',' vector

*/

class probeLocCart :
  public probeLocation
{
public:
  probeLocCart();
  probeLocCart(
    vector * distVecIn,
    vector * mountAxisVecIn);
  ~probeLocCart();
  void printSelf();
  vector * get_distVec();
  void set_distVec(vector * distVecIn);
  vector * get_mountAxisVec();
  void set_mountAxisVec(vector * mountAxisVecIn);
private:
  vector * distVec;
  vector * mountAxisVec;
};

/********************************************************************/

/* probeLocPol

This is a derived class for one of the definitions of probeLocation.
It represents the following items:

POL ',' angle ',' angle ',' vector ',' rentVal

*/

class probeLocPol :
  public probeLocation
{
public:
  probeLocPol();
  probeLocPol(
    angle * tiltIn,
    angle * rotIn,
    vector * mountAxisVecIn,
    rentVal * len1In);
  ~probeLocPol();
  void printSelf();
  angle * get_tilt();
  void set_tilt(angle * tiltIn);
  angle * get_rot();
  void set_rot(angle * rotIn);
  vector * get_mountAxisVec();
  void set_mountAxisVec(vector * mountAxisVecIn);
  rentVal * get_len1();
  void set_len1(rentVal * len1In);
private:
  angle * tilt;
  angle * rot;
  vector * mountAxisVec;
  rentVal * len1;
};

/********************************************************************/

/* probeLocVec

This is a derived class for one of the definitions of probeLocation.
It represents the following items:

VEC ',' vector ',' vector ',' rentVal

*/

class probeLocVec :
  public probeLocation
{
public:
  probeLocVec();
  probeLocVec(
    vector * tipVecIn,
    vector * mountAxisVecIn,
    rentVal * len1In);
  ~probeLocVec();
  void printSelf();
  vector * get_tipVec();
  void set_tipVec(vector * tipVecIn);
  vector * get_mountAxisVec();
  void set_mountAxisVec(vector * mountAxisVecIn);
  rentVal * get_len1();
  void set_len1(rentVal * len1In);
private:
  vector * tipVec;
  vector * mountAxisVec;
  rentVal * len1;
};

/********************************************************************/

/* probeLocSnsCart

This is a derived class for one of the definitions of probeLocation.
It represents the following items:

sensorLabel2 ',' CART ',' vector

*/

class probeLocSnsCart :
  public probeLocation
{
public:
  probeLocSnsCart();
  probeLocSnsCart(
    sensorLabel2 * sensorLabel2In,
    vector * relVecIn);
  ~probeLocSnsCart();
  void printSelf();
  sensorLabel2 * get_sensorLabel2();
  void set_sensorLabel2(sensorLabel2 * sensorLabel2In);
  vector * get_relVec();
  void set_relVec(vector * relVecIn);
private:
  sensorLabel2 * a_sensorLabel2;
  vector * relVec;
};

/********************************************************************/

/* probeLocSnsVec

This is a derived class for one of the definitions of probeLocation.
It represents the following items:

sensorLabel2 ',' VEC ',' vector ',' rentVal

*/

class probeLocSnsVec :
  public probeLocation
{
public:
  probeLocSnsVec();
  probeLocSnsVec(
    sensorLabel2 * sensorLabel2In,
    vector * relVecIn,
    rentVal * rlenIn);
  ~probeLocSnsVec();
  void printSelf();
  sensorLabel2 * get_sensorLabel2();
  void set_sensorLabel2(sensorLabel2 * sensorLabel2In);
  vector * get_relVec();
  void set_relVec(vector * relVecIn);
  rentVal * get_rlen();
  void set_rlen(rentVal * rlenIn);
private:
  sensorLabel2 * a_sensorLabel2;
  vector * relVec;
  rentVal * rlen;
};

/********************************************************************/

/* snsdefProbeForm

This is a parent class.

*/

class snsdefProbeForm :
  public dmisCppBase
{
public:
  snsdefProbeForm();
  ~snsdefProbeForm();
  void printSelf() = 0;
};

/********************************************************************/

/* snsdefProbeForm_SPHERE

This is a derived class for one of the definitions of snsdefProbeForm.
It represents the following items:

SPHERE

*/

class snsdefProbeForm_SPHERE :
  public snsdefProbeForm
{
public:
  snsdefProbeForm_SPHERE();
  ~snsdefProbeForm_SPHERE();
  void printSelf();
};

/********************************************************************/

/* snsdefProbeForm_CYLNDR

This is a derived class for one of the definitions of snsdefProbeForm.
It represents the following items:

CYLNDR ',' rentVal

*/

class snsdefProbeForm_CYLNDR :
  public snsdefProbeForm
{
public:
  snsdefProbeForm_CYLNDR();
  snsdefProbeForm_CYLNDR(
    rentVal * len2In);
  ~snsdefProbeForm_CYLNDR();
  void printSelf();
  rentVal * get_len2();
  void set_len2(rentVal * len2In);
private:
  rentVal * len2;
};

/********************************************************************/

/* snsdefProbeForm_DISK

This is a derived class for one of the definitions of snsdefProbeForm.
It represents the following items:

DISK ',' rentVal

*/

class snsdefProbeForm_DISK :
  public snsdefProbeForm
{
public:
  snsdefProbeForm_DISK();
  snsdefProbeForm_DISK(
    rentVal * thknIn);
  ~snsdefProbeForm_DISK();
  void printSelf();
  rentVal * get_thkn();
  void set_thkn(rentVal * thknIn);
private:
  rentVal * thkn;
};

/********************************************************************/

/* snsdefVideo

This is a class for the single definition of snsdefVideo.
It represents the following items:

VIDEO ',' snsdefType ',' snsdefLocation ',' rentVal ',' rentVal ',' rentVal

*/

class snsdefVideo :
  public snsdefMinor
{
public:
  snsdefVideo();
  snsdefVideo(
    snsdefType * snsdefTypeIn,
    snsdefLocation * snsdefLocationIn,
    rentVal * focalIn,
    rentVal * magIn,
    rentVal * apertIn);
  ~snsdefVideo();
  void printSelf();
  snsdefType * get_snsdefType();
  void set_snsdefType(snsdefType * snsdefTypeIn);
  snsdefLocation * get_snsdefLocation();
  void set_snsdefLocation(snsdefLocation * snsdefLocationIn);
  rentVal * get_focal();
  void set_focal(rentVal * focalIn);
  rentVal * get_mag();
  void set_mag(rentVal * magIn);
  rentVal * get_apert();
  void set_apert(rentVal * apertIn);
private:
  snsdefType * a_snsdefType;
  snsdefLocation * a_snsdefLocation;
  rentVal * focal;
  rentVal * mag;
  rentVal * apert;
};

/********************************************************************/

/* snsdefLaser

This is a class for the single definition of snsdefLaser.
It represents the following items:

LASER ',' snsdefType ',' snsdefLocation ',' rentVal ',' rentVal

*/

class snsdefLaser :
  public snsdefMinor
{
public:
  snsdefLaser();
  snsdefLaser(
    snsdefType * snsdefTypeIn,
    snsdefLocation * snsdefLocationIn,
    rentVal * powerIn,
    rentVal * shuterIn);
  ~snsdefLaser();
  void printSelf();
  snsdefType * get_snsdefType();
  void set_snsdefType(snsdefType * snsdefTypeIn);
  snsdefLocation * get_snsdefLocation();
  void set_snsdefLocation(snsdefLocation * snsdefLocationIn);
  rentVal * get_power();
  void set_power(rentVal * powerIn);
  rentVal * get_shuter();
  void set_shuter(rentVal * shuterIn);
private:
  snsdefType * a_snsdefType;
  snsdefLocation * a_snsdefLocation;
  rentVal * power;
  rentVal * shuter;
};

/********************************************************************/

/* snsdefInfred

This is a class for the single definition of snsdefInfred.
It represents the following items:

INFRED ',' snsdefType ',' snsdefLocation ',' rentVal ',' rentVal ',' rentVal ',' rentVal

*/

class snsdefInfred :
  public snsdefMinor
{
public:
  snsdefInfred();
  snsdefInfred(
    snsdefType * snsdefTypeIn,
    snsdefLocation * snsdefLocationIn,
    rentVal * fovxIn,
    rentVal * fovyIn,
    rentVal * freqIn,
    rentVal * dwellIn);
  ~snsdefInfred();
  void printSelf();
  snsdefType * get_snsdefType();
  void set_snsdefType(snsdefType * snsdefTypeIn);
  snsdefLocation * get_snsdefLocation();
  void set_snsdefLocation(snsdefLocation * snsdefLocationIn);
  rentVal * get_fovx();
  void set_fovx(rentVal * fovxIn);
  rentVal * get_fovy();
  void set_fovy(rentVal * fovyIn);
  rentVal * get_freq();
  void set_freq(rentVal * freqIn);
  rentVal * get_dwell();
  void set_dwell(rentVal * dwellIn);
private:
  snsdefType * a_snsdefType;
  snsdefLocation * a_snsdefLocation;
  rentVal * fovx;
  rentVal * fovy;
  rentVal * freq;
  rentVal * dwell;
};

/********************************************************************/

/* snsdefNoncon

This is a class for the single definition of snsdefNoncon.
It represents the following items:

NONCON ',' snsdefType ',' snsdefLocation ',' intVal

*/

class snsdefNoncon :
  public snsdefMinor
{
public:
  snsdefNoncon();
  snsdefNoncon(
    snsdefType * snsdefTypeIn,
    snsdefLocation * snsdefLocationIn,
    intVal * numProbesIn);
  ~snsdefNoncon();
  void printSelf();
  snsdefType * get_snsdefType();
  void set_snsdefType(snsdefType * snsdefTypeIn);
  snsdefLocation * get_snsdefLocation();
  void set_snsdefLocation(snsdefLocation * snsdefLocationIn);
  intVal * get_numProbes();
  void set_numProbes(intVal * numProbesIn);
private:
  snsdefType * a_snsdefType;
  snsdefLocation * a_snsdefLocation;
  intVal * numProbes;
};

/********************************************************************/

/* snsdefLocation

This is a parent class.

*/

class snsdefLocation :
  public dmisCppBase
{
public:
  snsdefLocation();
  ~snsdefLocation();
  void printSelf() = 0;
};

/********************************************************************/

/* snsdefLocation_CART

This is a derived class for one of the definitions of snsdefLocation.
It represents the following items:

CART ',' vector ',' vector

*/

class snsdefLocation_CART :
  public snsdefLocation
{
public:
  snsdefLocation_CART();
  snsdefLocation_CART(
    vector * distVecIn,
    vector * sockAxisIn);
  ~snsdefLocation_CART();
  void printSelf();
  vector * get_distVec();
  void set_distVec(vector * distVecIn);
  vector * get_sockAxis();
  void set_sockAxis(vector * sockAxisIn);
private:
  vector * distVec;
  vector * sockAxis;
};

/********************************************************************/

/* snsdefLocation_POL

This is a derived class for one of the definitions of snsdefLocation.
It represents the following items:

POL ',' angle ',' angle ',' vector

*/

class snsdefLocation_POL :
  public snsdefLocation
{
public:
  snsdefLocation_POL();
  snsdefLocation_POL(
    angle * tiltIn,
    angle * rotIn,
    vector * sockAxisIn);
  ~snsdefLocation_POL();
  void printSelf();
  angle * get_tilt();
  void set_tilt(angle * tiltIn);
  angle * get_rot();
  void set_rot(angle * rotIn);
  vector * get_sockAxis();
  void set_sockAxis(vector * sockAxisIn);
private:
  angle * tilt;
  angle * rot;
  vector * sockAxis;
};

/********************************************************************/

/* snsdefLocation_VEC

This is a derived class for one of the definitions of snsdefLocation.
It represents the following items:

VEC ',' vector ',' vector

*/

class snsdefLocation_VEC :
  public snsdefLocation
{
public:
  snsdefLocation_VEC();
  snsdefLocation_VEC(
    vector * beamAxisIn,
    vector * sockAxisIn);
  ~snsdefLocation_VEC();
  void printSelf();
  vector * get_beamAxis();
  void set_beamAxis(vector * beamAxisIn);
  vector * get_sockAxis();
  void set_sockAxis(vector * sockAxisIn);
private:
  vector * beamAxis;
  vector * sockAxis;
};

/********************************************************************/

/* snsdefType

This is a parent class.

*/

class snsdefType :
  public dmisCppBase
{
public:
  snsdefType();
  ~snsdefType();
  void printSelf() = 0;
};

/********************************************************************/

/* snsdefType_FIXED

This is a derived class for one of the definitions of snsdefType.
It represents the following items:

FIXED

*/

class snsdefType_FIXED :
  public snsdefType
{
public:
  snsdefType_FIXED();
  ~snsdefType_FIXED();
  void printSelf();
};

/********************************************************************/

/* snsdefType_INDEX

This is a derived class for one of the definitions of snsdefType.
It represents the following items:

INDEX

*/

class snsdefType_INDEX :
  public snsdefType
{
public:
  snsdefType_INDEX();
  ~snsdefType_INDEX();
  void printSelf();
};

/********************************************************************/

/* snsdefBuildSensor

This is a parent class.

*/

class snsdefBuildSensor :
  public dmisCppBase
{
public:
  snsdefBuildSensor();
  ~snsdefBuildSensor();
  void printSelf() = 0;
};

/********************************************************************/

/* snsdefBuild

This is a class for the single definition of snsdefBuild.
It represents the following items:

BUILD ',' snsdefBuildItemList ',' snsdefBuildSensor

*/

class snsdefBuild :
  public snsdefMinor
{
public:
  snsdefBuild();
  snsdefBuild(
    std::list<snsdefBuildItem *> * snsdefBuildItemListIn,
    snsdefBuildSensor * snsdefBuildSensorIn);
  ~snsdefBuild();
  void printSelf();
  std::list<snsdefBuildItem *> * get_snsdefBuildItemList();
  void set_snsdefBuildItemList(std::list<snsdefBuildItem *> * snsdefBuildItemListIn);
  snsdefBuildSensor * get_snsdefBuildSensor();
  void set_snsdefBuildSensor(snsdefBuildSensor * snsdefBuildSensorIn);
private:
  std::list<snsdefBuildItem *> * a_snsdefBuildItemList;
  snsdefBuildSensor * a_snsdefBuildSensor;
};

/********************************************************************/

/* snsdefBuildItem

This is a parent class.

*/

class snsdefBuildItem :
  public dmisCppBase
{
public:
  snsdefBuildItem();
  ~snsdefBuildItem();
  void printSelf() = 0;
};

/********************************************************************/

/* snsdefBuildItem_sgLabel

This is a derived class for one of the definitions of snsdefBuildItem.
It represents the following items:

sgLabel

*/

class snsdefBuildItem_sgLabel :
  public snsdefBuildItem
{
public:
  snsdefBuildItem_sgLabel();
  snsdefBuildItem_sgLabel(
    sgLabel * sgLabelIn);
  ~snsdefBuildItem_sgLabel();
  void printSelf();
  sgLabel * get_sgLabel();
  void set_sgLabel(sgLabel * sgLabelIn);
private:
  sgLabel * a_sgLabel;
};

/********************************************************************/

/* snsdefBuildItem_swLabel

This is a derived class for one of the definitions of snsdefBuildItem.
It represents the following items:

swLabel [',' snsdefWristAngleList]

*/

class snsdefBuildItem_swLabel :
  public snsdefBuildItem
{
public:
  snsdefBuildItem_swLabel();
  snsdefBuildItem_swLabel(
    swLabel * swLabelIn,
    std::list<snsdefWristAngleItem *> * snsdefWristAngleListIn);
  ~snsdefBuildItem_swLabel();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  std::list<snsdefWristAngleItem *> * get_snsdefWristAngleList();
  void set_snsdefWristAngleList(std::list<snsdefWristAngleItem *> * snsdefWristAngleListIn);
private:
  swLabel * a_swLabel;
  std::list<snsdefWristAngleItem *> * a_snsdefWristAngleList;
};

/********************************************************************/

/* snsdefBuildItem_sxLabel

This is a derived class for one of the definitions of snsdefBuildItem.
It represents the following items:

sxLabel

*/

class snsdefBuildItem_sxLabel :
  public snsdefBuildItem
{
public:
  snsdefBuildItem_sxLabel();
  snsdefBuildItem_sxLabel(
    sxLabel * sxLabelIn);
  ~snsdefBuildItem_sxLabel();
  void printSelf();
  sxLabel * get_sxLabel();
  void set_sxLabel(sxLabel * sxLabelIn);
private:
  sxLabel * a_sxLabel;
};

/********************************************************************/

/* snsdefBuildItem_rmLabel

This is a derived class for one of the definitions of snsdefBuildItem.
It represents the following items:

rmLabel

*/

class snsdefBuildItem_rmLabel :
  public snsdefBuildItem
{
public:
  snsdefBuildItem_rmLabel();
  snsdefBuildItem_rmLabel(
    rmLabel * rmLabelIn);
  ~snsdefBuildItem_rmLabel();
  void printSelf();
  rmLabel * get_rmLabel();
  void set_rmLabel(rmLabel * rmLabelIn);
private:
  rmLabel * a_rmLabel;
};

/********************************************************************/

/* snsdefWristAngleItem

This is a class for the single definition of snsdefWristAngleItem.
It represents the following items:

stringVal ',' angle

*/

class snsdefWristAngleItem :
  public dmisCppBase
{
public:
  snsdefWristAngleItem();
  snsdefWristAngleItem(
    stringVal * anglenameIn,
    angle * angleIn);
  ~snsdefWristAngleItem();
  void printSelf();
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  stringVal * anglename;
  angle * a_angle;
};

/********************************************************************/

/* snsetItem

This is a parent class.

*/

class snsetItem :
  public dmisCppBase
{
public:
  snsetItem();
  ~snsetItem();
  void printSelf() = 0;
};

/********************************************************************/

/* snsetItem_snsetTypeAndValue

This is a derived class for one of the definitions of snsetItem.
It represents the following items:

snsetTypeAndValue

*/

class snsetItem_snsetTypeAndValue :
  public snsetItem
{
public:
  snsetItem_snsetTypeAndValue();
  snsetItem_snsetTypeAndValue(
    snsetTypeAndValue * snsetTypeAndValueIn);
  ~snsetItem_snsetTypeAndValue();
  void printSelf();
  snsetTypeAndValue * get_snsetTypeAndValue();
  void set_snsetTypeAndValue(snsetTypeAndValue * snsetTypeAndValueIn);
private:
  snsetTypeAndValue * a_snsetTypeAndValue;
};

/********************************************************************/

/* snsetItem_snsetType

This is a derived class for one of the definitions of snsetItem.
It represents the following items:

snsetType

*/

class snsetItem_snsetType :
  public snsetItem
{
public:
  snsetItem_snsetType();
  snsetItem_snsetType(
    snsetType * snsetTypeIn);
  ~snsetItem_snsetType();
  void printSelf();
  snsetType * get_snsetType();
  void set_snsetType(snsetType * snsetTypeIn);
private:
  snsetType * a_snsetType;
};

/********************************************************************/

/* snsetItem_snsetLabelAndValue

This is a derived class for one of the definitions of snsetItem.
It represents the following items:

snsetLabelAndValue

*/

class snsetItem_snsetLabelAndValue :
  public snsetItem
{
public:
  snsetItem_snsetLabelAndValue();
  snsetItem_snsetLabelAndValue(
    snsetLabelAndValue * snsetLabelAndValueIn);
  ~snsetItem_snsetLabelAndValue();
  void printSelf();
  snsetLabelAndValue * get_snsetLabelAndValue();
  void set_snsetLabelAndValue(snsetLabelAndValue * snsetLabelAndValueIn);
private:
  snsetLabelAndValue * a_snsetLabelAndValue;
};

/********************************************************************/

/* snsetItem_snsetLabel

This is a derived class for one of the definitions of snsetItem.
It represents the following items:

snsetLabel

*/

class snsetItem_snsetLabel :
  public snsetItem
{
public:
  snsetItem_snsetLabel();
  snsetItem_snsetLabel(
    snsetLabel * snsetLabelIn);
  ~snsetItem_snsetLabel();
  void printSelf();
  snsetLabel * get_snsetLabel();
  void set_snsetLabel(snsetLabel * snsetLabelIn);
private:
  snsetLabel * a_snsetLabel;
};

/********************************************************************/

/* snsetItem_snsetToggle

This is a derived class for one of the definitions of snsetItem.
It represents the following items:

snsetToggle

*/

class snsetItem_snsetToggle :
  public snsetItem
{
public:
  snsetItem_snsetToggle();
  snsetItem_snsetToggle(
    snsetToggle * snsetToggleIn);
  ~snsetItem_snsetToggle();
  void printSelf();
  snsetToggle * get_snsetToggle();
  void set_snsetToggle(snsetToggle * snsetToggleIn);
private:
  snsetToggle * a_snsetToggle;
};

/********************************************************************/

/* snsetItem_CLRSRF

This is a derived class for one of the definitions of snsetItem.
It represents the following items:

CLRSRF ',' snsetFeat [',' rentVal]

*/

class snsetItem_CLRSRF :
  public snsetItem
{
public:
  snsetItem_CLRSRF();
  snsetItem_CLRSRF(
    snsetFeat * snsetFeatIn,
    rentVal * distIn);
  ~snsetItem_CLRSRF();
  void printSelf();
  snsetFeat * get_snsetFeat();
  void set_snsetFeat(snsetFeat * snsetFeatIn);
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  snsetFeat * a_snsetFeat;
  rentVal * dist;
};

/********************************************************************/

/* snsetItem_DEPTH

This is a derived class for one of the definitions of snsetItem.
It represents the following items:

DEPTH ',' snsetFeat [',' rentVal]

*/

class snsetItem_DEPTH :
  public snsetItem
{
public:
  snsetItem_DEPTH();
  snsetItem_DEPTH(
    snsetFeat * snsetFeatIn,
    rentVal * distIn);
  ~snsetItem_DEPTH();
  void printSelf();
  snsetFeat * get_snsetFeat();
  void set_snsetFeat(snsetFeat * snsetFeatIn);
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  snsetFeat * a_snsetFeat;
  rentVal * dist;
};

/********************************************************************/

/* snsetTypeAndValue

This is a parent class.

*/

class snsetTypeAndValue :
  public dmisCppBase
{
public:
  snsetTypeAndValue();
  ~snsetTypeAndValue();
  void printSelf() = 0;
};

/********************************************************************/

/* snsetTypeAndValue_APPRCH

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

APPRCH ',' rentVal

*/

class snsetTypeAndValue_APPRCH :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_APPRCH();
  snsetTypeAndValue_APPRCH(
    rentVal * distIn);
  ~snsetTypeAndValue_APPRCH();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  rentVal * dist;
};

/********************************************************************/

/* snsetTypeAndValue_CLRSRF

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

CLRSRF ',' rentVal

*/

class snsetTypeAndValue_CLRSRF :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_CLRSRF();
  snsetTypeAndValue_CLRSRF(
    rentVal * distIn);
  ~snsetTypeAndValue_CLRSRF();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  rentVal * dist;
};

/********************************************************************/

/* snsetTypeAndValue_DEPTH

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

DEPTH ',' rentVal

*/

class snsetTypeAndValue_DEPTH :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_DEPTH();
  snsetTypeAndValue_DEPTH(
    rentVal * distIn);
  ~snsetTypeAndValue_DEPTH();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  rentVal * dist;
};

/********************************************************************/

/* snsetTypeAndValue_MINCON

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

MINCON ',' rentVal

*/

class snsetTypeAndValue_MINCON :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_MINCON();
  snsetTypeAndValue_MINCON(
    rentVal * levelIn);
  ~snsetTypeAndValue_MINCON();
  void printSelf();
  rentVal * get_level();
  void set_level(rentVal * levelIn);
private:
  rentVal * level;
};

/********************************************************************/

/* snsetTypeAndValue_RETRCT

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

RETRCT ',' rentVal

*/

class snsetTypeAndValue_RETRCT :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_RETRCT();
  snsetTypeAndValue_RETRCT(
    rentVal * distIn);
  ~snsetTypeAndValue_RETRCT();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  rentVal * dist;
};

/********************************************************************/

/* snsetTypeAndValue_SEARCH

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

SEARCH ',' rentVal

*/

class snsetTypeAndValue_SEARCH :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_SEARCH();
  snsetTypeAndValue_SEARCH(
    rentVal * distIn);
  ~snsetTypeAndValue_SEARCH();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  rentVal * dist;
};

/********************************************************************/

/* snsetTypeAndValue_SCALEX

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

SCALEX ',' rentVal

*/

class snsetTypeAndValue_SCALEX :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_SCALEX();
  snsetTypeAndValue_SCALEX(
    rentVal * scaleIn);
  ~snsetTypeAndValue_SCALEX();
  void printSelf();
  rentVal * get_scale();
  void set_scale(rentVal * scaleIn);
private:
  rentVal * scale;
};

/********************************************************************/

/* snsetTypeAndValue_SCALEY

This is a derived class for one of the definitions of snsetTypeAndValue.
It represents the following items:

SCALEY ',' rentVal

*/

class snsetTypeAndValue_SCALEY :
  public snsetTypeAndValue
{
public:
  snsetTypeAndValue_SCALEY();
  snsetTypeAndValue_SCALEY(
    rentVal * scaleIn);
  ~snsetTypeAndValue_SCALEY();
  void printSelf();
  rentVal * get_scale();
  void set_scale(rentVal * scaleIn);
private:
  rentVal * scale;
};

/********************************************************************/

/* snsetType

This is a parent class.

*/

class snsetType :
  public dmisCppBase
{
public:
  snsetType();
  ~snsetType();
  void printSelf() = 0;
};

/********************************************************************/

/* snsetType_FOCUSY

This is a derived class for one of the definitions of snsetType.
It represents the following items:

FOCUSY

*/

class snsetType_FOCUSY :
  public snsetType
{
public:
  snsetType_FOCUSY();
  ~snsetType_FOCUSY();
  void printSelf();
};

/********************************************************************/

/* snsetType_FOCUSN

This is a derived class for one of the definitions of snsetType.
It represents the following items:

FOCUSN

*/

class snsetType_FOCUSN :
  public snsetType
{
public:
  snsetType_FOCUSN();
  ~snsetType_FOCUSN();
  void printSelf();
};

/********************************************************************/

/* snsetToggle

This is a parent class.

*/

class snsetToggle :
  public dmisCppBase
{
public:
  snsetToggle();
  ~snsetToggle();
  void printSelf() = 0;
};

/********************************************************************/

/* snsetToggle_CLRSRF

This is a derived class for one of the definitions of snsetToggle.
It represents the following items:

CLRSRF ',' OFF

*/

class snsetToggle_CLRSRF :
  public snsetToggle
{
public:
  snsetToggle_CLRSRF();
  ~snsetToggle_CLRSRF();
  void printSelf();
};

/********************************************************************/

/* snsetToggle_DEPTH

This is a derived class for one of the definitions of snsetToggle.
It represents the following items:

DEPTH ',' OFF

*/

class snsetToggle_DEPTH :
  public snsetToggle
{
public:
  snsetToggle_DEPTH();
  ~snsetToggle_DEPTH();
  void printSelf();
};

/********************************************************************/

/* snsetLabelAndValue

This is a class for the single definition of snsetLabelAndValue.
It represents the following items:

vlLabel ',' rentVal

*/

class snsetLabelAndValue :
  public dmisCppBase
{
public:
  snsetLabelAndValue();
  snsetLabelAndValue(
    vlLabel * vlLabelIn,
    rentVal * intnstyIn);
  ~snsetLabelAndValue();
  void printSelf();
  vlLabel * get_vlLabel();
  void set_vlLabel(vlLabel * vlLabelIn);
  rentVal * get_intnsty();
  void set_intnsty(rentVal * intnstyIn);
private:
  vlLabel * a_vlLabel;
  rentVal * intnsty;
};

/********************************************************************/

/* snsetLabel

This is a parent class.

*/

class snsetLabel :
  public dmisCppBase
{
public:
  snsetLabel();
  ~snsetLabel();
  void printSelf() = 0;
};

/********************************************************************/

/* snsetFeat

This is a parent class.

*/

class snsetFeat :
  public dmisCppBase
{
public:
  snsetFeat();
  ~snsetFeat();
  void printSelf() = 0;
};

/********************************************************************/

/* snsgrpStm

This is a class for the single definition of snsgrpStm.
It represents the following items:

sgsLabel '=' SNSGRP '/' snsgrpMinor #

*/

class snsgrpStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  snsgrpStm();
  snsgrpStm(
    sgsLabel * sgsLabelIn,
    snsgrpMinor * snsgrpMinorIn);
  ~snsgrpStm();
  void printSelf();
  sgsLabel * get_sgsLabel();
  void set_sgsLabel(sgsLabel * sgsLabelIn);
  snsgrpMinor * get_snsgrpMinor();
  void set_snsgrpMinor(snsgrpMinor * snsgrpMinorIn);
private:
  sgsLabel * a_sgsLabel;
  snsgrpMinor * a_snsgrpMinor;
};

/********************************************************************/

/* snsgrpMinor

This is a parent class.

*/

class snsgrpMinor :
  public dmisCppBase
{
public:
  snsgrpMinor();
  ~snsgrpMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* snsgrpMinor_ssLabel

This is a derived class for one of the definitions of snsgrpMinor.
It represents the following items:

BUILD ',' snsgrpItemList ',' ssLabel

*/

class snsgrpMinor_ssLabel :
  public snsgrpMinor
{
public:
  snsgrpMinor_ssLabel();
  snsgrpMinor_ssLabel(
    std::list<snsgrpItem *> * snsgrpItemListIn,
    ssLabel * ssLabelIn);
  ~snsgrpMinor_ssLabel();
  void printSelf();
  std::list<snsgrpItem *> * get_snsgrpItemList();
  void set_snsgrpItemList(std::list<snsgrpItem *> * snsgrpItemListIn);
  ssLabel * get_ssLabel();
  void set_ssLabel(ssLabel * ssLabelIn);
private:
  std::list<snsgrpItem *> * a_snsgrpItemList;
  ssLabel * a_ssLabel;
};

/********************************************************************/

/* snsgrpMinor_sgsLabel

This is a derived class for one of the definitions of snsgrpMinor.
It represents the following items:

BUILD ',' snsgrpItemList ',' sgsLabel

*/

class snsgrpMinor_sgsLabel :
  public snsgrpMinor
{
public:
  snsgrpMinor_sgsLabel();
  snsgrpMinor_sgsLabel(
    std::list<snsgrpItem *> * snsgrpItemListIn,
    sgsLabel * sgsLabelIn);
  ~snsgrpMinor_sgsLabel();
  void printSelf();
  std::list<snsgrpItem *> * get_snsgrpItemList();
  void set_snsgrpItemList(std::list<snsgrpItem *> * snsgrpItemListIn);
  sgsLabel * get_sgsLabel();
  void set_sgsLabel(sgsLabel * sgsLabelIn);
private:
  std::list<snsgrpItem *> * a_snsgrpItemList;
  sgsLabel * a_sgsLabel;
};

/********************************************************************/

/* snsgrpItem

This is a parent class.

*/

class snsgrpItem :
  public dmisCppBase
{
public:
  snsgrpItem();
  ~snsgrpItem();
  void printSelf() = 0;
};

/********************************************************************/

/* snslctGroup

This is a parent class.

*/

class snslctGroup :
  public dmisCppBase
{
public:
  snslctGroup();
  ~snslctGroup();
  void printSelf() = 0;
};

/********************************************************************/

/* snslctGroupFeat

This is a derived class for one of the definitions of snslctGroup.
It represents the following items:

gsaLabel ',' featureLabel [',' FZ ',' angle]

*/

class snslctGroupFeat :
  public snslctGroup
{
public:
  snslctGroupFeat();
  snslctGroupFeat(
    gsaLabel * gsaLabelIn,
    featureLabel * featureLabelIn,
    angle * angleIn);
  ~snslctGroupFeat();
  void printSelf();
  gsaLabel * get_gsaLabel();
  void set_gsaLabel(gsaLabel * gsaLabelIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  gsaLabel * a_gsaLabel;
  featureLabel * a_featureLabel;
  angle * a_angle;
};

/********************************************************************/

/* snslctGroupVec

This is a derived class for one of the definitions of snslctGroup.
It represents the following items:

gsaLabel ',' VEC ',' vector [',' FZ ',' angle]

*/

class snslctGroupVec :
  public snslctGroup
{
public:
  snslctGroupVec();
  snslctGroupVec(
    gsaLabel * gsaLabelIn,
    vector * dirIn,
    angle * angleIn);
  ~snslctGroupVec();
  void printSelf();
  gsaLabel * get_gsaLabel();
  void set_gsaLabel(gsaLabel * gsaLabelIn);
  vector * get_dir();
  void set_dir(vector * dirIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  gsaLabel * a_gsaLabel;
  vector * dir;
  angle * a_angle;
};

/********************************************************************/

/* snslctSensor

This is a parent class.

*/

class snslctSensor :
  public dmisCppBase
{
public:
  snslctSensor();
  ~snslctSensor();
  void printSelf() = 0;
};

/********************************************************************/

/* snslctSensorTip

This is a derived class for one of the definitions of snslctSensor.
It represents the following items:

sensorLabel2 [',' snslctTipData] [',' snslctData]

*/

class snslctSensorTip :
  public snslctSensor
{
public:
  snslctSensorTip();
  snslctSensorTip(
    sensorLabel2 * sensorLabel2In,
    snslctTipData * snslctTipDataIn,
    snslctData * snslctDataIn);
  ~snslctSensorTip();
  void printSelf();
  sensorLabel2 * get_sensorLabel2();
  void set_sensorLabel2(sensorLabel2 * sensorLabel2In);
  snslctTipData * get_snslctTipData();
  void set_snslctTipData(snslctTipData * snslctTipDataIn);
  snslctData * get_snslctData();
  void set_snslctData(snslctData * snslctDataIn);
private:
  sensorLabel2 * a_sensorLabel2;
  snslctTipData * a_snslctTipData;
  snslctData * a_snslctData;
};

/********************************************************************/

/* snslctSensorList

This is a derived class for one of the definitions of snslctSensor.
It represents the following items:

sensorLabel2 ',' sensorList

*/

class snslctSensorList :
  public snslctSensor
{
public:
  snslctSensorList();
  snslctSensorList(
    sensorLabel2 * sensorLabel2In,
    std::list<sensorLabel2 *> * sensorListIn);
  ~snslctSensorList();
  void printSelf();
  sensorLabel2 * get_sensorLabel2();
  void set_sensorLabel2(sensorLabel2 * sensorLabel2In);
  std::list<sensorLabel2 *> * get_sensorList();
  void set_sensorList(std::list<sensorLabel2 *> * sensorListIn);
private:
  sensorLabel2 * a_sensorLabel2;
  std::list<sensorLabel2 *> * a_sensorList;
};

/********************************************************************/

/* snslctTipData

This is a parent class.

*/

class snslctTipData :
  public dmisCppBase
{
public:
  snslctTipData();
  ~snslctTipData();
  void printSelf() = 0;
};

/********************************************************************/

/* snslctData

This is a parent class.

*/

class snslctData :
  public dmisCppBase
{
public:
  snslctData();
  ~snslctData();
  void printSelf() = 0;
};

/********************************************************************/

/* snslctData_snslctWristList

This is a derived class for one of the definitions of snslctData.
It represents the following items:

snslctWristList

*/

class snslctData_snslctWristList :
  public snslctData
{
public:
  snslctData_snslctWristList();
  snslctData_snslctWristList(
    std::list<snslctWristItem *> * snslctWristListIn);
  ~snslctData_snslctWristList();
  void printSelf();
  std::list<snslctWristItem *> * get_snslctWristList();
  void set_snslctWristList(std::list<snslctWristItem *> * snslctWristListIn);
private:
  std::list<snslctWristItem *> * a_snslctWristList;
};

/********************************************************************/

/* snslctData_probeOrient

This is a derived class for one of the definitions of snslctData.
It represents the following items:

probeOrient

*/

class snslctData_probeOrient :
  public snslctData
{
public:
  snslctData_probeOrient();
  snslctData_probeOrient(
    probeOrient * probeOrientIn);
  ~snslctData_probeOrient();
  void printSelf();
  probeOrient * get_probeOrient();
  void set_probeOrient(probeOrient * probeOrientIn);
private:
  probeOrient * a_probeOrient;
};

/********************************************************************/

/* snslctWristItem

This is a class for the single definition of snslctWristItem.
It represents the following items:

swLabel ',' snslctWristAngleList

*/

class snslctWristItem :
  public dmisCppBase
{
public:
  snslctWristItem();
  snslctWristItem(
    swLabel * swLabelIn,
    std::list<snslctWristAngleItem *> * snslctWristAngleListIn);
  ~snslctWristItem();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  std::list<snslctWristAngleItem *> * get_snslctWristAngleList();
  void set_snslctWristAngleList(std::list<snslctWristAngleItem *> * snslctWristAngleListIn);
private:
  swLabel * a_swLabel;
  std::list<snslctWristAngleItem *> * a_snslctWristAngleList;
};

/********************************************************************/

/* snslctWristAngleItem

This is a parent class.

*/

class snslctWristAngleItem :
  public dmisCppBase
{
public:
  snslctWristAngleItem();
  ~snslctWristAngleItem();
  void printSelf() = 0;
};

/********************************************************************/

/* snslctWristAngleAngle

This is a derived class for one of the definitions of snslctWristAngleItem.
It represents the following items:

stringVal ',' angle

*/

class snslctWristAngleAngle :
  public snslctWristAngleItem
{
public:
  snslctWristAngleAngle();
  snslctWristAngleAngle(
    stringVal * anglenameIn,
    angle * angleIn);
  ~snslctWristAngleAngle();
  void printSelf();
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  stringVal * anglename;
  angle * a_angle;
};

/********************************************************************/

/* snslctWristAngleFeat

This is a derived class for one of the definitions of snslctWristAngleItem.
It represents the following items:

stringVal ',' featureLabel [',' FZ ',' angle]

*/

class snslctWristAngleFeat :
  public snslctWristAngleItem
{
public:
  snslctWristAngleFeat();
  snslctWristAngleFeat(
    stringVal * anglenameIn,
    featureLabel * featureLabelIn,
    angle * angleIn);
  ~snslctWristAngleFeat();
  void printSelf();
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  stringVal * anglename;
  featureLabel * a_featureLabel;
  angle * a_angle;
};

/********************************************************************/

/* snslctWristAngleVec

This is a derived class for one of the definitions of snslctWristAngleItem.
It represents the following items:

stringVal ',' VEC ',' vector [',' FZ ',' angle]

*/

class snslctWristAngleVec :
  public snslctWristAngleItem
{
public:
  snslctWristAngleVec();
  snslctWristAngleVec(
    stringVal * anglenameIn,
    vector * dirIn,
    angle * angleIn);
  ~snslctWristAngleVec();
  void printSelf();
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
  vector * get_dir();
  void set_dir(vector * dirIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  stringVal * anglename;
  vector * dir;
  angle * a_angle;
};

/********************************************************************/

/* snsmntStm

This is a class for the single definition of snsmntStm.
It represents the following items:

SNSMNT '/' snsmntMinor #

*/

class snsmntStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  snsmntStm();
  snsmntStm(
    snsmntMinor * snsmntMinorIn);
  ~snsmntStm();
  void printSelf();
  snsmntMinor * get_snsmntMinor();
  void set_snsmntMinor(snsmntMinor * snsmntMinorIn);
private:
  snsmntMinor * a_snsmntMinor;
};

/********************************************************************/

/* snsmntMinor

This is a class for the single definition of snsmntMinor.
It represents the following items:

XVEC ',' vector ',' ZVEC ',' vector ',' MNTLEN ',' vector

*/

class snsmntMinor :
  public dmisCppBase
{
public:
  snsmntMinor();
  snsmntMinor(
    vector * xVecIn,
    vector * zVecIn,
    vector * distVecIn);
  ~snsmntMinor();
  void printSelf();
  vector * get_xVec();
  void set_xVec(vector * xVecIn);
  vector * get_zVec();
  void set_zVec(vector * zVecIn);
  vector * get_distVec();
  void set_distVec(vector * distVecIn);
private:
  vector * xVec;
  vector * zVec;
  vector * distVec;
};

/********************************************************************/

/* tecompStm

This is a class for the single definition of tecompStm.
It represents the following items:

TECOMP '/' tecompMinor #

*/

class tecompStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tecompStm();
  tecompStm(
    tecompMinor * tecompMinorIn);
  ~tecompStm();
  void printSelf();
  tecompMinor * get_tecompMinor();
  void set_tecompMinor(tecompMinor * tecompMinorIn);
private:
  tecompMinor * a_tecompMinor;
};

/********************************************************************/

/* tecompMinor

This is a parent class.

*/

class tecompMinor :
  public dmisCppBase
{
public:
  tecompMinor();
  ~tecompMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* tecompMinorMach

This is a derived class for one of the definitions of tecompMinor.
It represents the following items:

MACH ',' state

*/

class tecompMinorMach :
  public tecompMinor
{
public:
  tecompMinorMach();
  tecompMinorMach(
    state * stateIn);
  ~tecompMinorMach();
  void printSelf();
  state * get_state();
  void set_state(state * stateIn);
private:
  state * a_state;
};

/********************************************************************/

/* tecompMinorOnList

This is a derived class for one of the definitions of tecompMinor.
It represents the following items:

PART ',' ON [tecompVar2] ',' rentVal [',' rentVal] ',' stringList

*/

class tecompMinorOnList :
  public tecompMinor
{
public:
  tecompMinorOnList();
  tecompMinorOnList(
    tecompVar2 * tecompVar2In,
    rentVal * tmpexpIn,
    rentVal * tmpexpuncIn,
    std::list<stringVal *> * stringListIn);
  ~tecompMinorOnList();
  void printSelf();
  tecompVar2 * get_tecompVar2();
  void set_tecompVar2(tecompVar2 * tecompVar2In);
  rentVal * get_tmpexp();
  void set_tmpexp(rentVal * tmpexpIn);
  rentVal * get_tmpexpunc();
  void set_tmpexpunc(rentVal * tmpexpuncIn);
  std::list<stringVal *> * get_stringList();
  void set_stringList(std::list<stringVal *> * stringListIn);
private:
  tecompVar2 * a_tecompVar2;
  rentVal * tmpexp;
  rentVal * tmpexpunc;
  std::list<stringVal *> * a_stringList;
};

/********************************************************************/

/* tecompMinorOnAll

This is a derived class for one of the definitions of tecompMinor.
It represents the following items:

PART ',' ON [tecompVar2] ',' rentVal [',' rentVal] ',' ALL

*/

class tecompMinorOnAll :
  public tecompMinor
{
public:
  tecompMinorOnAll();
  tecompMinorOnAll(
    tecompVar2 * tecompVar2In,
    rentVal * tmpexpIn,
    rentVal * tmpexpuncIn);
  ~tecompMinorOnAll();
  void printSelf();
  tecompVar2 * get_tecompVar2();
  void set_tecompVar2(tecompVar2 * tecompVar2In);
  rentVal * get_tmpexp();
  void set_tmpexp(rentVal * tmpexpIn);
  rentVal * get_tmpexpunc();
  void set_tmpexpunc(rentVal * tmpexpuncIn);
private:
  tecompVar2 * a_tecompVar2;
  rentVal * tmpexp;
  rentVal * tmpexpunc;
};

/********************************************************************/

/* tecompMinorOff

This is a derived class for one of the definitions of tecompMinor.
It represents the following items:

PART ',' OFF

*/

class tecompMinorOff :
  public tecompMinor
{
public:
  tecompMinorOff();
  ~tecompMinorOff();
  void printSelf();
};

/********************************************************************/

/* tecompVar2

This is a parent class.

*/

class tecompVar2 :
  public dmisCppBase
{
public:
  tecompVar2();
  ~tecompVar2();
  void printSelf() = 0;
};

/********************************************************************/

/* tecompDatum

This is a derived class for one of the definitions of tecompVar2.
It represents the following items:

',' daLabel

*/

class tecompDatum :
  public tecompVar2
{
public:
  tecompDatum();
  tecompDatum(
    daLabel * daLabelIn);
  ~tecompDatum();
  void printSelf();
  daLabel * get_daLabel();
  void set_daLabel(daLabel * daLabelIn);
private:
  daLabel * a_daLabel;
};

/********************************************************************/

/* tecompOffset

This is a derived class for one of the definitions of tecompVar2.
It represents the following items:

',' OFFSET ',' rentVal ',' rentVal ',' rentVal

*/

class tecompOffset :
  public tecompVar2
{
public:
  tecompOffset();
  tecompOffset(
    rentVal * xoffIn,
    rentVal * yoffIn,
    rentVal * zoffIn);
  ~tecompOffset();
  void printSelf();
  rentVal * get_xoff();
  void set_xoff(rentVal * xoffIn);
  rentVal * get_yoff();
  void set_yoff(rentVal * yoffIn);
  rentVal * get_zoff();
  void set_zoff(rentVal * zoffIn);
private:
  rentVal * xoff;
  rentVal * yoff;
  rentVal * zoff;
};

/********************************************************************/

/* textMinor

This is a parent class.

*/

class textMinor :
  public dmisCppBase
{
public:
  textMinor();
  ~textMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* textMan

This is a class for the single definition of textMan.
It represents the following items:

MAN ',' stringVal

*/

class textMan :
  public textMinor
{
public:
  textMan();
  textMan(
    stringVal * textIn);
  ~textMan();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* textOper

This is a class for the single definition of textOper.
It represents the following items:

OPER ',' stringVal

*/

class textOper :
  public textMinor
{
public:
  textOper();
  textOper(
    stringVal * textIn);
  ~textOper();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* textOutfil

This is a class for the single definition of textOutfil.
It represents the following items:

OUTFIL ',' stringVal

*/

class textOutfil :
  public textMinor
{
public:
  textOutfil();
  textOutfil(
    stringVal * textIn);
  ~textOutfil();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* textQuery

This is a class for the single definition of textQuery.
It represents the following items:

QUERY ',' textQueryFormat ',' stringVal

*/

class textQuery :
  public textMinor
{
public:
  textQuery();
  textQuery(
    textQueryFormat * textQueryFormatIn,
    stringVal * textIn);
  ~textQuery();
  void printSelf();
  textQueryFormat * get_textQueryFormat();
  void set_textQueryFormat(textQueryFormat * textQueryFormatIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  textQueryFormat * a_textQueryFormat;
  stringVal * text;
};

/********************************************************************/

/* textQueryFormat

This is a class for the single definition of textQueryFormat.
It represents the following items:

labelName ',' intVal ',' textType ',' leftRight

*/

class textQueryFormat :
  public dmisCppBase
{
public:
  textQueryFormat();
  textQueryFormat(
    labelName * labelNameIn,
    intVal * lengthIn,
    textType * textTypeIn,
    leftRight * leftRightIn);
  ~textQueryFormat();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
  intVal * get_length();
  void set_length(intVal * lengthIn);
  textType * get_textType();
  void set_textType(textType * textTypeIn);
  leftRight * get_leftRight();
  void set_leftRight(leftRight * leftRightIn);
private:
  labelName * a_labelName;
  intVal * length;
  textType * a_textType;
  leftRight * a_leftRight;
};

/********************************************************************/

/* textType

This is a parent class.

*/

class textType :
  public dmisCppBase
{
public:
  textType();
  ~textType();
  void printSelf() = 0;
};

/********************************************************************/

/* textType_ALPHA

This is a derived class for one of the definitions of textType.
It represents the following items:

ALPHA

*/

class textType_ALPHA :
  public textType
{
public:
  textType_ALPHA();
  ~textType_ALPHA();
  void printSelf();
};

/********************************************************************/

/* textType_NUMERIC

This is a derived class for one of the definitions of textType.
It represents the following items:

NUMERIC

*/

class textType_NUMERIC :
  public textType
{
public:
  textType_NUMERIC();
  ~textType_NUMERIC();
  void printSelf();
};

/********************************************************************/

/* textType_PRNTCHAR

This is a derived class for one of the definitions of textType.
It represents the following items:

PRNTCHAR

*/

class textType_PRNTCHAR :
  public textType
{
public:
  textType_PRNTCHAR();
  ~textType_PRNTCHAR();
  void printSelf();
};

/********************************************************************/

/* thldefStm

This is a class for the single definition of thldefStm.
It represents the following items:

thLabel '=' THLDEF '/' thldefPocketList #

*/

class thldefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  thldefStm();
  thldefStm(
    thLabel * thLabelIn,
    std::list<thldefPocket *> * thldefPocketListIn);
  ~thldefStm();
  void printSelf();
  thLabel * get_thLabel();
  void set_thLabel(thLabel * thLabelIn);
  std::list<thldefPocket *> * get_thldefPocketList();
  void set_thldefPocketList(std::list<thldefPocket *> * thldefPocketListIn);
private:
  thLabel * a_thLabel;
  std::list<thldefPocket *> * a_thldefPocketList;
};

/********************************************************************/

/* thldefPocket

This is a parent class.

*/

class thldefPocket :
  public dmisCppBase
{
public:
  thldefPocket();
  ~thldefPocket();
  void printSelf() = 0;
};

/********************************************************************/

/* thldefPocket_sLabel

This is a derived class for one of the definitions of thldefPocket.
It represents the following items:

sLabel ',' intVal

*/

class thldefPocket_sLabel :
  public thldefPocket
{
public:
  thldefPocket_sLabel();
  thldefPocket_sLabel(
    sLabel * sLabelIn,
    intVal * pocketIn);
  ~thldefPocket_sLabel();
  void printSelf();
  sLabel * get_sLabel();
  void set_sLabel(sLabel * sLabelIn);
  intVal * get_pocket();
  void set_pocket(intVal * pocketIn);
private:
  sLabel * a_sLabel;
  intVal * pocket;
};

/********************************************************************/

/* thldefPocket_ssLabel

This is a derived class for one of the definitions of thldefPocket.
It represents the following items:

ssLabel ',' intVal

*/

class thldefPocket_ssLabel :
  public thldefPocket
{
public:
  thldefPocket_ssLabel();
  thldefPocket_ssLabel(
    ssLabel * ssLabelIn,
    intVal * pocketIn);
  ~thldefPocket_ssLabel();
  void printSelf();
  ssLabel * get_ssLabel();
  void set_ssLabel(ssLabel * ssLabelIn);
  intVal * get_pocket();
  void set_pocket(intVal * pocketIn);
private:
  ssLabel * a_ssLabel;
  intVal * pocket;
};

/********************************************************************/

/* thldefPocket_sgsLabel

This is a derived class for one of the definitions of thldefPocket.
It represents the following items:

sgsLabel ',' intVal

*/

class thldefPocket_sgsLabel :
  public thldefPocket
{
public:
  thldefPocket_sgsLabel();
  thldefPocket_sgsLabel(
    sgsLabel * sgsLabelIn,
    intVal * pocketIn);
  ~thldefPocket_sgsLabel();
  void printSelf();
  sgsLabel * get_sgsLabel();
  void set_sgsLabel(sgsLabel * sgsLabelIn);
  intVal * get_pocket();
  void set_pocket(intVal * pocketIn);
private:
  sgsLabel * a_sgsLabel;
  intVal * pocket;
};

/********************************************************************/

/* thldefPocket_sgLabel

This is a derived class for one of the definitions of thldefPocket.
It represents the following items:

sgLabel ',' intVal

*/

class thldefPocket_sgLabel :
  public thldefPocket
{
public:
  thldefPocket_sgLabel();
  thldefPocket_sgLabel(
    sgLabel * sgLabelIn,
    intVal * pocketIn);
  ~thldefPocket_sgLabel();
  void printSelf();
  sgLabel * get_sgLabel();
  void set_sgLabel(sgLabel * sgLabelIn);
  intVal * get_pocket();
  void set_pocket(intVal * pocketIn);
private:
  sgLabel * a_sgLabel;
  intVal * pocket;
};

/********************************************************************/

/* thldefPocket_swLabel

This is a derived class for one of the definitions of thldefPocket.
It represents the following items:

swLabel ',' intVal

*/

class thldefPocket_swLabel :
  public thldefPocket
{
public:
  thldefPocket_swLabel();
  thldefPocket_swLabel(
    swLabel * swLabelIn,
    intVal * pocketIn);
  ~thldefPocket_swLabel();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  intVal * get_pocket();
  void set_pocket(intVal * pocketIn);
private:
  swLabel * a_swLabel;
  intVal * pocket;
};

/********************************************************************/

/* thldefPocket_sxLabel

This is a derived class for one of the definitions of thldefPocket.
It represents the following items:

sxLabel ',' intVal

*/

class thldefPocket_sxLabel :
  public thldefPocket
{
public:
  thldefPocket_sxLabel();
  thldefPocket_sxLabel(
    sxLabel * sxLabelIn,
    intVal * pocketIn);
  ~thldefPocket_sxLabel();
  void printSelf();
  sxLabel * get_sxLabel();
  void set_sxLabel(sxLabel * sxLabelIn);
  intVal * get_pocket();
  void set_pocket(intVal * pocketIn);
private:
  sxLabel * a_sxLabel;
  intVal * pocket;
};

/********************************************************************/

/* thldefPocket_rmLabel

This is a derived class for one of the definitions of thldefPocket.
It represents the following items:

rmLabel ',' intVal

*/

class thldefPocket_rmLabel :
  public thldefPocket
{
public:
  thldefPocket_rmLabel();
  thldefPocket_rmLabel(
    rmLabel * rmLabelIn,
    intVal * pocketIn);
  ~thldefPocket_rmLabel();
  void printSelf();
  rmLabel * get_rmLabel();
  void set_rmLabel(rmLabel * rmLabelIn);
  intVal * get_pocket();
  void set_pocket(intVal * pocketIn);
private:
  rmLabel * a_rmLabel;
  intVal * pocket;
};

/********************************************************************/

/* tolAnglStm

This is a class for the single definition of tolAnglStm.
It represents the following items:

tLabel '=' TOL '/' ANGL ',' angle ',' angle #

*/

class tolAnglStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolAnglStm();
  tolAnglStm(
    tLabel * tLabelIn,
    angle * lotolIn,
    angle * uptolIn);
  ~tolAnglStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  angle * get_lotol();
  void set_lotol(angle * lotolIn);
  angle * get_uptol();
  void set_uptol(angle * uptolIn);
private:
  tLabel * a_tLabel;
  angle * lotol;
  angle * uptol;
};

/********************************************************************/

/* tolAnglbStm

This is a class for the single definition of tolAnglbStm.
It represents the following items:

tLabel '=' TOL '/' ANGLB ',' angle ',' angle ',' angle [',' tolZoneDir2] #

*/

class tolAnglbStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolAnglbStm();
  tolAnglbStm(
    tLabel * tLabelIn,
    angle * angIn,
    angle * lotolIn,
    angle * uptolIn,
    tolZoneDir2 * tolZoneDir2In);
  ~tolAnglbStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  angle * get_ang();
  void set_ang(angle * angIn);
  angle * get_lotol();
  void set_lotol(angle * lotolIn);
  angle * get_uptol();
  void set_uptol(angle * uptolIn);
  tolZoneDir2 * get_tolZoneDir2();
  void set_tolZoneDir2(tolZoneDir2 * tolZoneDir2In);
private:
  tLabel * a_tLabel;
  angle * ang;
  angle * lotol;
  angle * uptol;
  tolZoneDir2 * a_tolZoneDir2;
};

/********************************************************************/

/* tolZoneDir2

This is a parent class.

*/

class tolZoneDir2 :
  public dmisCppBase
{
public:
  tolZoneDir2();
  ~tolZoneDir2();
  void printSelf() = 0;
};

/********************************************************************/

/* tolZoneDir2_XYPLAN

This is a derived class for one of the definitions of tolZoneDir2.
It represents the following items:

XYPLAN

*/

class tolZoneDir2_XYPLAN :
  public tolZoneDir2
{
public:
  tolZoneDir2_XYPLAN();
  ~tolZoneDir2_XYPLAN();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir2_YZPLAN

This is a derived class for one of the definitions of tolZoneDir2.
It represents the following items:

YZPLAN

*/

class tolZoneDir2_YZPLAN :
  public tolZoneDir2
{
public:
  tolZoneDir2_YZPLAN();
  ~tolZoneDir2_YZPLAN();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir2_ZXPLAN

This is a derived class for one of the definitions of tolZoneDir2.
It represents the following items:

ZXPLAN

*/

class tolZoneDir2_ZXPLAN :
  public tolZoneDir2
{
public:
  tolZoneDir2_ZXPLAN();
  ~tolZoneDir2_ZXPLAN();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir2_VEC

This is a derived class for one of the definitions of tolZoneDir2.
It represents the following items:

VEC ',' vector

*/

class tolZoneDir2_VEC :
  public tolZoneDir2
{
public:
  tolZoneDir2_VEC();
  tolZoneDir2_VEC(
    vector * planeVecIn);
  ~tolZoneDir2_VEC();
  void printSelf();
  vector * get_planeVec();
  void set_planeVec(vector * planeVecIn);
private:
  vector * planeVec;
};

/********************************************************************/

/* tolAnglwrtStm

This is a class for the single definition of tolAnglwrtStm.
It represents the following items:

tLabel '=' TOL '/' ANGLWRT ',' angle ',' angle ',' angle ',' tolFeature [',' tolZoneDir2] #

*/

class tolAnglwrtStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolAnglwrtStm();
  tolAnglwrtStm(
    tLabel * tLabelIn,
    angle * angIn,
    angle * lotolIn,
    angle * uptolIn,
    tolFeature * tolFeatureIn,
    tolZoneDir2 * tolZoneDir2In);
  ~tolAnglwrtStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  angle * get_ang();
  void set_ang(angle * angIn);
  angle * get_lotol();
  void set_lotol(angle * lotolIn);
  angle * get_uptol();
  void set_uptol(angle * uptolIn);
  tolFeature * get_tolFeature();
  void set_tolFeature(tolFeature * tolFeatureIn);
  tolZoneDir2 * get_tolZoneDir2();
  void set_tolZoneDir2(tolZoneDir2 * tolZoneDir2In);
private:
  tLabel * a_tLabel;
  angle * ang;
  angle * lotol;
  angle * uptol;
  tolFeature * a_tolFeature;
  tolZoneDir2 * a_tolZoneDir2;
};

/********************************************************************/

/* tolAnglrStm

This is a class for the single definition of tolAnglrStm.
It represents the following items:

tLabel '=' TOL '/' ANGLR ',' angle ',' tolAppData #

*/

class tolAnglrStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolAnglrStm();
  tolAnglrStm(
    tLabel * tLabelIn,
    angle * angleIn,
    tolAppData * tolAppDataIn);
  ~tolAnglrStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
  tolAppData * get_tolAppData();
  void set_tolAppData(tolAppData * tolAppDataIn);
private:
  tLabel * a_tLabel;
  angle * a_angle;
  tolAppData * a_tolAppData;
};

/********************************************************************/

/* tolCirltyStm

This is a class for the single definition of tolCirltyStm.
It represents the following items:

tLabel '=' TOL '/' CIRLTY ',' rentVal #

*/

class tolCirltyStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolCirltyStm();
  tolCirltyStm(
    tLabel * tLabelIn,
    rentVal * tolzonIn);
  ~tolCirltyStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
private:
  tLabel * a_tLabel;
  rentVal * tolzon;
};

/********************************************************************/

/* tolCompos1

This is a class for the single definition of tolCompos1.
It represents the following items:

rentVal [',' tolMatCond] ',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]

*/

class tolCompos1 :
  public dmisCppBase
{
public:
  tolCompos1();
  tolCompos1(
    rentVal * tolzon1In,
    tolMatCond * tolMatCondIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In);
  ~tolCompos1();
  void printSelf();
  rentVal * get_tolzon1();
  void set_tolzon1(rentVal * tolzon1In);
  tolMatCond * get_tolMatCond();
  void set_tolMatCond(tolMatCond * tolMatCondIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
private:
  rentVal * tolzon1;
  tolMatCond * a_tolMatCond;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
};

/********************************************************************/

/* tolCompos2

This is a class for the single definition of tolCompos2.
It represents the following items:

rentVal [',' tolMatCond] [',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]]

*/

class tolCompos2 :
  public dmisCppBase
{
public:
  tolCompos2();
  tolCompos2(
    rentVal * tolzon2In,
    tolMatCond * tolMatCondIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In);
  ~tolCompos2();
  void printSelf();
  rentVal * get_tolzon2();
  void set_tolzon2(rentVal * tolzon2In);
  tolMatCond * get_tolMatCond();
  void set_tolMatCond(tolMatCond * tolMatCondIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
private:
  rentVal * tolzon2;
  tolMatCond * a_tolMatCond;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
};

/********************************************************************/

/* tolComposStm

This is a class for the single definition of tolComposStm.
It represents the following items:

tLabel '=' TOL '/' COMPOS ',' PATERN ',' tolCompos1 ',' FEATUR ',' tolCompos2 #

*/

class tolComposStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolComposStm();
  tolComposStm(
    tLabel * tLabelIn,
    tolCompos1 * tolCompos1In,
    tolCompos2 * tolCompos2In);
  ~tolComposStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolCompos1 * get_tolCompos1();
  void set_tolCompos1(tolCompos1 * tolCompos1In);
  tolCompos2 * get_tolCompos2();
  void set_tolCompos2(tolCompos2 * tolCompos2In);
private:
  tLabel * a_tLabel;
  tolCompos1 * a_tolCompos1;
  tolCompos2 * a_tolCompos2;
};

/********************************************************************/

/* tolFeatureMat

This is a parent class.

*/

class tolFeatureMat :
  public dmisCppBase
{
public:
  tolFeatureMat();
  ~tolFeatureMat();
  void printSelf() = 0;
};

/********************************************************************/

/* tolFeatureMat_datLabel

This is a derived class for one of the definitions of tolFeatureMat.
It represents the following items:

datLabel [',' tolMatCond]

*/

class tolFeatureMat_datLabel :
  public tolFeatureMat
{
public:
  tolFeatureMat_datLabel();
  tolFeatureMat_datLabel(
    datLabel * datLabelIn,
    tolMatCond * tolMatCondIn);
  ~tolFeatureMat_datLabel();
  void printSelf();
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  tolMatCond * get_tolMatCond();
  void set_tolMatCond(tolMatCond * tolMatCondIn);
private:
  datLabel * a_datLabel;
  tolMatCond * a_tolMatCond;
};

/********************************************************************/

/* tolFeatureMat_faLabel

This is a derived class for one of the definitions of tolFeatureMat.
It represents the following items:

faLabel [',' tolMatCond]

*/

class tolFeatureMat_faLabel :
  public tolFeatureMat
{
public:
  tolFeatureMat_faLabel();
  tolFeatureMat_faLabel(
    faLabel * faLabelIn,
    tolMatCond * tolMatCondIn);
  ~tolFeatureMat_faLabel();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  tolMatCond * get_tolMatCond();
  void set_tolMatCond(tolMatCond * tolMatCondIn);
private:
  faLabel * a_faLabel;
  tolMatCond * a_tolMatCond;
};

/********************************************************************/

/* tolFeatureMat_fLabel

This is a derived class for one of the definitions of tolFeatureMat.
It represents the following items:

fLabel

*/

class tolFeatureMat_fLabel :
  public tolFeatureMat
{
public:
  tolFeatureMat_fLabel();
  tolFeatureMat_fLabel(
    fLabel * fLabelIn);
  ~tolFeatureMat_fLabel();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
private:
  fLabel * a_fLabel;
};

/********************************************************************/

/* tolConcenStm

This is a class for the single definition of tolConcenStm.
It represents the following items:

tLabel '=' TOL '/' CONCEN ',' rentVal ',' tolFeature #

*/

class tolConcenStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolConcenStm();
  tolConcenStm(
    tLabel * tLabelIn,
    rentVal * tolzonIn,
    tolFeature * tolFeatureIn);
  ~tolConcenStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  tolFeature * get_tolFeature();
  void set_tolFeature(tolFeature * tolFeatureIn);
private:
  tLabel * a_tLabel;
  rentVal * tolzon;
  tolFeature * a_tolFeature;
};

/********************************************************************/

/* tolCortolStm

This is a class for the single definition of tolCortolStm.
It represents the following items:

tLabel '=' TOL '/' CORTOL ',' tolCortolMinor #

*/

class tolCortolStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolCortolStm();
  tolCortolStm(
    tLabel * tLabelIn,
    tolCortolMinor * tolCortolMinorIn);
  ~tolCortolStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolCortolMinor * get_tolCortolMinor();
  void set_tolCortolMinor(tolCortolMinor * tolCortolMinorIn);
private:
  tLabel * a_tLabel;
  tolCortolMinor * a_tolCortolMinor;
};

/********************************************************************/

/* tolCortolMinor

This is a parent class.

*/

class tolCortolMinor :
  public dmisCppBase
{
public:
  tolCortolMinor();
  ~tolCortolMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* tolCortolAxis

This is a derived class for one of the definitions of tolCortolMinor.
It represents the following items:

axis ',' rentVal ',' rentVal [',' axial]

*/

class tolCortolAxis :
  public tolCortolMinor
{
public:
  tolCortolAxis();
  tolCortolAxis(
    axis * axisIn,
    rentVal * lotolIn,
    rentVal * uptolIn,
    axial * axialIn);
  ~tolCortolAxis();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  axial * get_axial();
  void set_axial(axial * axialIn);
private:
  axis * a_axis;
  rentVal * lotol;
  rentVal * uptol;
  axial * a_axial;
};

/********************************************************************/

/* tolCortolRadial

This is a derived class for one of the definitions of tolCortolMinor.
It represents the following items:

RADIAL ',' rentVal ',' rentVal

*/

class tolCortolRadial :
  public tolCortolMinor
{
public:
  tolCortolRadial();
  tolCortolRadial(
    rentVal * lotolIn,
    rentVal * uptolIn);
  ~tolCortolRadial();
  void printSelf();
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
private:
  rentVal * lotol;
  rentVal * uptol;
};

/********************************************************************/

/* tolCortolAngle

This is a derived class for one of the definitions of tolCortolMinor.
It represents the following items:

ANGLE ',' rentVal ',' rentVal

*/

class tolCortolAngle :
  public tolCortolMinor
{
public:
  tolCortolAngle();
  tolCortolAngle(
    rentVal * lotolIn,
    rentVal * uptolIn);
  ~tolCortolAngle();
  void printSelf();
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
private:
  rentVal * lotol;
  rentVal * uptol;
};

/********************************************************************/

/* axial

This is a class for the single definition of axial.
It represents the following items:

AXIAL ',' featureLabel [',' rentVal]

*/

class axial :
  public dmisCppBase
{
public:
  axial();
  axial(
    featureLabel * featureLabelIn,
    rentVal * distIn);
  ~axial();
  void printSelf();
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
private:
  featureLabel * a_featureLabel;
  rentVal * dist;
};

/********************************************************************/

/* tolCproflStm

This is a class for the single definition of tolCproflStm.
It represents the following items:

tLabel '=' TOL '/' CPROFL ',' tolCprofSpecC tolCprofSpec #

*/

class tolCproflStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolCproflStm();
  tolCproflStm(
    tLabel * tLabelIn,
    tolCprofSpecC * upperIn,
    tolCprofSpec * lowerIn);
  ~tolCproflStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolCprofSpecC * get_upper();
  void set_upper(tolCprofSpecC * upperIn);
  tolCprofSpec * get_lower();
  void set_lower(tolCprofSpec * lowerIn);
private:
  tLabel * a_tLabel;
  tolCprofSpecC * upper;
  tolCprofSpec * lower;
};

/********************************************************************/

/* tolCprofsStm

This is a class for the single definition of tolCprofsStm.
It represents the following items:

tLabel '=' TOL '/' CPROFS ',' tolCprofSpecC tolCprofSpec #

*/

class tolCprofsStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolCprofsStm();
  tolCprofsStm(
    tLabel * tLabelIn,
    tolCprofSpecC * upperIn,
    tolCprofSpec * lowerIn);
  ~tolCprofsStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolCprofSpecC * get_upper();
  void set_upper(tolCprofSpecC * upperIn);
  tolCprofSpec * get_lower();
  void set_lower(tolCprofSpec * lowerIn);
private:
  tLabel * a_tLabel;
  tolCprofSpecC * upper;
  tolCprofSpec * lower;
};

/********************************************************************/

/* tolCprofSpec

This is a class for the single definition of tolCprofSpec.
It represents the following items:

rentVal ',' rentVal [',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]] [',' AVGDEV]

*/

class tolCprofSpec :
  public dmisCppBase
{
public:
  tolCprofSpec();
  tolCprofSpec(
    rentVal * lotolIn,
    rentVal * uptolIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In,
    bool has_AVGDEVIn);
  ~tolCprofSpec();
  void printSelf();
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
  bool get_has_AVGDEV();
  void set_has_AVGDEV(bool has_AVGDEVIn);
private:
  rentVal * lotol;
  rentVal * uptol;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
  bool has_AVGDEV;
};

/********************************************************************/

/* tolCprofSpecC

This is a class for the single definition of tolCprofSpecC.
It represents the following items:

rentVal ',' rentVal [',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]] [',' AVGDEV] ','

*/

class tolCprofSpecC :
  public dmisCppBase
{
public:
  tolCprofSpecC();
  tolCprofSpecC(
    rentVal * lotolIn,
    rentVal * uptolIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In,
    bool has_AVGDEVIn);
  ~tolCprofSpecC();
  void printSelf();
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
  bool get_has_AVGDEV();
  void set_has_AVGDEV(bool has_AVGDEVIn);
private:
  rentVal * lotol;
  rentVal * uptol;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
  bool has_AVGDEV;
};

/********************************************************************/

/* tolCrnoutStm

This is a class for the single definition of tolCrnoutStm.
It represents the following items:

tLabel '=' TOL '/' CRNOUT ',' rentVal ',' datLabel [',' tolFeature [',' tolFeature]] [',' VEC ',' vector] #

*/

class tolCrnoutStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolCrnoutStm();
  tolCrnoutStm(
    tLabel * tLabelIn,
    rentVal * tolzonIn,
    datLabel * datLabelIn,
    tolFeature * tolFeat1In,
    tolFeature * tolFeat2In,
    vector * dirIn);
  ~tolCrnoutStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  tolFeature * get_tolFeat1();
  void set_tolFeat1(tolFeature * tolFeat1In);
  tolFeature * get_tolFeat2();
  void set_tolFeat2(tolFeature * tolFeat2In);
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  tLabel * a_tLabel;
  rentVal * tolzon;
  datLabel * a_datLabel;
  tolFeature * tolFeat1;
  tolFeature * tolFeat2;
  vector * dir;
};

/********************************************************************/

/* tolCylctyStm

This is a class for the single definition of tolCylctyStm.
It represents the following items:

tLabel '=' TOL '/' CYLCTY ',' rentVal #

*/

class tolCylctyStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolCylctyStm();
  tolCylctyStm(
    tLabel * tLabelIn,
    rentVal * tolzonIn);
  ~tolCylctyStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
private:
  tLabel * a_tLabel;
  rentVal * tolzon;
};

/********************************************************************/

/* tolDiamStm

This is a class for the single definition of tolDiamStm.
It represents the following items:

tLabel '=' TOL '/' DIAM ',' tolDiamMinor #

*/

class tolDiamStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolDiamStm();
  tolDiamStm(
    tLabel * tLabelIn,
    tolDiamMinor * tolDiamMinorIn);
  ~tolDiamStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolDiamMinor * get_tolDiamMinor();
  void set_tolDiamMinor(tolDiamMinor * tolDiamMinorIn);
private:
  tLabel * a_tLabel;
  tolDiamMinor * a_tolDiamMinor;
};

/********************************************************************/

/* tolDiamMinor

This is a parent class.

*/

class tolDiamMinor :
  public dmisCppBase
{
public:
  tolDiamMinor();
  ~tolDiamMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* tolDiamPlain

This is a derived class for one of the definitions of tolDiamMinor.
It represents the following items:

rentVal ',' rentVal [',' radiusSpec]

*/

class tolDiamPlain :
  public tolDiamMinor
{
public:
  tolDiamPlain();
  tolDiamPlain(
    rentVal * lotolIn,
    rentVal * uptolIn,
    radiusSpec * radiusSpecIn);
  ~tolDiamPlain();
  void printSelf();
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  radiusSpec * get_radiusSpec();
  void set_radiusSpec(radiusSpec * radiusSpecIn);
private:
  rentVal * lotol;
  rentVal * uptol;
  radiusSpec * a_radiusSpec;
};

/********************************************************************/

/* tolDiamAvg

This is a derived class for one of the definitions of tolDiamMinor.
It represents the following items:

rentVal ',' rentVal [',' radiusSpec] ',' AVG

*/

class tolDiamAvg :
  public tolDiamMinor
{
public:
  tolDiamAvg();
  tolDiamAvg(
    rentVal * lotolIn,
    rentVal * uptolIn,
    radiusSpec * radiusSpecIn);
  ~tolDiamAvg();
  void printSelf();
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  radiusSpec * get_radiusSpec();
  void set_radiusSpec(radiusSpec * radiusSpecIn);
private:
  rentVal * lotol;
  rentVal * uptol;
  radiusSpec * a_radiusSpec;
};

/********************************************************************/

/* tolDiamMinmax

This is a derived class for one of the definitions of tolDiamMinor.
It represents the following items:

rentVal ',' rentVal [',' radiusSpec] ',' MINMAX

*/

class tolDiamMinmax :
  public tolDiamMinor
{
public:
  tolDiamMinmax();
  tolDiamMinmax(
    rentVal * lotolIn,
    rentVal * uptolIn,
    radiusSpec * radiusSpecIn);
  ~tolDiamMinmax();
  void printSelf();
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  radiusSpec * get_radiusSpec();
  void set_radiusSpec(radiusSpec * radiusSpecIn);
private:
  rentVal * lotol;
  rentVal * uptol;
  radiusSpec * a_radiusSpec;
};

/********************************************************************/

/* avgMaxMin

This is a parent class.

*/

class avgMaxMin :
  public dmisCppBase
{
public:
  avgMaxMin();
  ~avgMaxMin();
  void printSelf() = 0;
};

/********************************************************************/

/* avgMaxMin_AVG

This is a derived class for one of the definitions of avgMaxMin.
It represents the following items:

',' AVG

*/

class avgMaxMin_AVG :
  public avgMaxMin
{
public:
  avgMaxMin_AVG();
  ~avgMaxMin_AVG();
  void printSelf();
};

/********************************************************************/

/* avgMaxMin_MAX

This is a derived class for one of the definitions of avgMaxMin.
It represents the following items:

',' MAX

*/

class avgMaxMin_MAX :
  public avgMaxMin
{
public:
  avgMaxMin_MAX();
  ~avgMaxMin_MAX();
  void printSelf();
};

/********************************************************************/

/* avgMaxMin_MIN

This is a derived class for one of the definitions of avgMaxMin.
It represents the following items:

',' MIN

*/

class avgMaxMin_MIN :
  public avgMaxMin
{
public:
  avgMaxMin_MIN();
  ~avgMaxMin_MIN();
  void printSelf();
};

/********************************************************************/

/* tolDistbStm

This is a class for the single definition of tolDistbStm.
It represents the following items:

tLabel '=' TOL '/' DISTB ',' tolDistbTol ',' tolDistbDir [avgMaxMin] #

*/

class tolDistbStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolDistbStm();
  tolDistbStm(
    tLabel * tLabelIn,
    tolDistbTol * tolDistbTolIn,
    tolDistbDir * tolDistbDirIn,
    avgMaxMin * avgMaxMinIn);
  ~tolDistbStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolDistbTol * get_tolDistbTol();
  void set_tolDistbTol(tolDistbTol * tolDistbTolIn);
  tolDistbDir * get_tolDistbDir();
  void set_tolDistbDir(tolDistbDir * tolDistbDirIn);
  avgMaxMin * get_avgMaxMin();
  void set_avgMaxMin(avgMaxMin * avgMaxMinIn);
private:
  tLabel * a_tLabel;
  tolDistbTol * a_tolDistbTol;
  tolDistbDir * a_tolDistbDir;
  avgMaxMin * a_avgMaxMin;
};

/********************************************************************/

/* tolDistbDir

This is a parent class.

*/

class tolDistbDir :
  public dmisCppBase
{
public:
  tolDistbDir();
  ~tolDistbDir();
  void printSelf() = 0;
};

/********************************************************************/

/* tolDistbDir_XAXIS

This is a derived class for one of the definitions of tolDistbDir.
It represents the following items:

XAXIS

*/

class tolDistbDir_XAXIS :
  public tolDistbDir
{
public:
  tolDistbDir_XAXIS();
  ~tolDistbDir_XAXIS();
  void printSelf();
};

/********************************************************************/

/* tolDistbDir_YAXIS

This is a derived class for one of the definitions of tolDistbDir.
It represents the following items:

YAXIS

*/

class tolDistbDir_YAXIS :
  public tolDistbDir
{
public:
  tolDistbDir_YAXIS();
  ~tolDistbDir_YAXIS();
  void printSelf();
};

/********************************************************************/

/* tolDistbDir_ZAXIS

This is a derived class for one of the definitions of tolDistbDir.
It represents the following items:

ZAXIS

*/

class tolDistbDir_ZAXIS :
  public tolDistbDir
{
public:
  tolDistbDir_ZAXIS();
  ~tolDistbDir_ZAXIS();
  void printSelf();
};

/********************************************************************/

/* tolDistbDir_PT2PT

This is a derived class for one of the definitions of tolDistbDir.
It represents the following items:

PT2PT

*/

class tolDistbDir_PT2PT :
  public tolDistbDir
{
public:
  tolDistbDir_PT2PT();
  ~tolDistbDir_PT2PT();
  void printSelf();
};

/********************************************************************/

/* tolDistbTol

This is a parent class.

*/

class tolDistbTol :
  public dmisCppBase
{
public:
  tolDistbTol();
  ~tolDistbTol();
  void printSelf() = 0;
};

/********************************************************************/

/* tolDistbLimit

This is a class for the single definition of tolDistbLimit.
It represents the following items:

LIMIT ',' rentVal ',' rentVal

*/

class tolDistbLimit :
  public tolDistbTol
{
public:
  tolDistbLimit();
  tolDistbLimit(
    rentVal * lolimtIn,
    rentVal * uplimtIn);
  ~tolDistbLimit();
  void printSelf();
  rentVal * get_lolimt();
  void set_lolimt(rentVal * lolimtIn);
  rentVal * get_uplimt();
  void set_uplimt(rentVal * uplimtIn);
private:
  rentVal * lolimt;
  rentVal * uplimt;
};

/********************************************************************/

/* tolDistbNominl

This is a class for the single definition of tolDistbNominl.
It represents the following items:

NOMINL ',' rentVal ',' rentVal ',' rentVal

*/

class tolDistbNominl :
  public tolDistbTol
{
public:
  tolDistbNominl();
  tolDistbNominl(
    rentVal * distIn,
    rentVal * lotolIn,
    rentVal * uptolIn);
  ~tolDistbNominl();
  void printSelf();
  rentVal * get_dist();
  void set_dist(rentVal * distIn);
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
private:
  rentVal * dist;
  rentVal * lotol;
  rentVal * uptol;
};

/********************************************************************/

/* tolDistwrtStm

This is a class for the single definition of tolDistwrtStm.
It represents the following items:

tLabel '=' TOL '/' DISTWRT ',' tolDistbTol ',' tolFeature ',' tolDistbDir [avgMaxMin] #

*/

class tolDistwrtStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolDistwrtStm();
  tolDistwrtStm(
    tLabel * tLabelIn,
    tolDistbTol * tolDistbTolIn,
    tolFeature * tolFeatureIn,
    tolDistbDir * tolDistbDirIn,
    avgMaxMin * avgMaxMinIn);
  ~tolDistwrtStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolDistbTol * get_tolDistbTol();
  void set_tolDistbTol(tolDistbTol * tolDistbTolIn);
  tolFeature * get_tolFeature();
  void set_tolFeature(tolFeature * tolFeatureIn);
  tolDistbDir * get_tolDistbDir();
  void set_tolDistbDir(tolDistbDir * tolDistbDirIn);
  avgMaxMin * get_avgMaxMin();
  void set_avgMaxMin(avgMaxMin * avgMaxMinIn);
private:
  tLabel * a_tLabel;
  tolDistbTol * a_tolDistbTol;
  tolFeature * a_tolFeature;
  tolDistbDir * a_tolDistbDir;
  avgMaxMin * a_avgMaxMin;
};

/********************************************************************/

/* tolFlatStm

This is a class for the single definition of tolFlatStm.
It represents the following items:

tLabel '=' TOL '/' FLAT ',' tolFlatMinor #

*/

class tolFlatStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolFlatStm();
  tolFlatStm(
    tLabel * tLabelIn,
    tolFlatMinor * tolFlatMinorIn);
  ~tolFlatStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolFlatMinor * get_tolFlatMinor();
  void set_tolFlatMinor(tolFlatMinor * tolFlatMinorIn);
private:
  tLabel * a_tLabel;
  tolFlatMinor * a_tolFlatMinor;
};

/********************************************************************/

/* tolFlatMinor

This is a parent class.

*/

class tolFlatMinor :
  public dmisCppBase
{
public:
  tolFlatMinor();
  ~tolFlatMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* tolFlatZon

This is a derived class for one of the definitions of tolFlatMinor.
It represents the following items:

rentVal

*/

class tolFlatZon :
  public tolFlatMinor
{
public:
  tolFlatZon();
  tolFlatZon(
    rentVal * tolzonIn);
  ~tolFlatZon();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
private:
  rentVal * tolzon;
};

/********************************************************************/

/* tolFlatPer

This is a derived class for one of the definitions of tolFlatMinor.
It represents the following items:

rentVal ',' rentVal ',' rentVal

*/

class tolFlatPer :
  public tolFlatMinor
{
public:
  tolFlatPer();
  tolFlatPer(
    rentVal * tolzon1In,
    rentVal * unit1In,
    rentVal * unit2In);
  ~tolFlatPer();
  void printSelf();
  rentVal * get_tolzon1();
  void set_tolzon1(rentVal * tolzon1In);
  rentVal * get_unit1();
  void set_unit1(rentVal * unit1In);
  rentVal * get_unit2();
  void set_unit2(rentVal * unit2In);
private:
  rentVal * tolzon1;
  rentVal * unit1;
  rentVal * unit2;
};

/********************************************************************/

/* tolFlatZonPer

This is a derived class for one of the definitions of tolFlatMinor.
It represents the following items:

rentVal ',' rentVal ',' rentVal ',' rentVal

*/

class tolFlatZonPer :
  public tolFlatMinor
{
public:
  tolFlatZonPer();
  tolFlatZonPer(
    rentVal * tolzonIn,
    rentVal * tolzon1In,
    rentVal * unit1In,
    rentVal * unit2In);
  ~tolFlatZonPer();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  rentVal * get_tolzon1();
  void set_tolzon1(rentVal * tolzon1In);
  rentVal * get_unit1();
  void set_unit1(rentVal * unit1In);
  rentVal * get_unit2();
  void set_unit2(rentVal * unit2In);
private:
  rentVal * tolzon;
  rentVal * tolzon1;
  rentVal * unit1;
  rentVal * unit2;
};

/********************************************************************/

/* tolGtolStm

This is a class for the single definition of tolGtolStm.
It represents the following items:

tLabel '=' TOL '/' GTOL ',' tolGtolTrans ',' tolGtolRot ',' intVal ',' rentVal ',' angle [',' tolGtolSpec] #

*/

class tolGtolStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolGtolStm();
  tolGtolStm(
    tLabel * tLabelIn,
    tolGtolTrans * tolGtolTransIn,
    tolGtolRot * tolGtolRotIn,
    intVal * maxitrIn,
    rentVal * minshfIn,
    angle * maxrotIn,
    tolGtolSpec * tolGtolSpecIn);
  ~tolGtolStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolGtolTrans * get_tolGtolTrans();
  void set_tolGtolTrans(tolGtolTrans * tolGtolTransIn);
  tolGtolRot * get_tolGtolRot();
  void set_tolGtolRot(tolGtolRot * tolGtolRotIn);
  intVal * get_maxitr();
  void set_maxitr(intVal * maxitrIn);
  rentVal * get_minshf();
  void set_minshf(rentVal * minshfIn);
  angle * get_maxrot();
  void set_maxrot(angle * maxrotIn);
  tolGtolSpec * get_tolGtolSpec();
  void set_tolGtolSpec(tolGtolSpec * tolGtolSpecIn);
private:
  tLabel * a_tLabel;
  tolGtolTrans * a_tolGtolTrans;
  tolGtolRot * a_tolGtolRot;
  intVal * maxitr;
  rentVal * minshf;
  angle * maxrot;
  tolGtolSpec * a_tolGtolSpec;
};

/********************************************************************/

/* tolGtolTrans

This is a parent class.

*/

class tolGtolTrans :
  public dmisCppBase
{
public:
  tolGtolTrans();
  ~tolGtolTrans();
  void printSelf() = 0;
};

/********************************************************************/

/* tolGtolTrans_XDIR

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

XDIR

*/

class tolGtolTrans_XDIR :
  public tolGtolTrans
{
public:
  tolGtolTrans_XDIR();
  ~tolGtolTrans_XDIR();
  void printSelf();
};

/********************************************************************/

/* tolGtolTrans_YDIR

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

YDIR

*/

class tolGtolTrans_YDIR :
  public tolGtolTrans
{
public:
  tolGtolTrans_YDIR();
  ~tolGtolTrans_YDIR();
  void printSelf();
};

/********************************************************************/

/* tolGtolTrans_ZDIR

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

ZDIR

*/

class tolGtolTrans_ZDIR :
  public tolGtolTrans
{
public:
  tolGtolTrans_ZDIR();
  ~tolGtolTrans_ZDIR();
  void printSelf();
};

/********************************************************************/

/* tolGtolTrans_XYDIR

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

XYDIR

*/

class tolGtolTrans_XYDIR :
  public tolGtolTrans
{
public:
  tolGtolTrans_XYDIR();
  ~tolGtolTrans_XYDIR();
  void printSelf();
};

/********************************************************************/

/* tolGtolTrans_YZDIR

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

YZDIR

*/

class tolGtolTrans_YZDIR :
  public tolGtolTrans
{
public:
  tolGtolTrans_YZDIR();
  ~tolGtolTrans_YZDIR();
  void printSelf();
};

/********************************************************************/

/* tolGtolTrans_ZXDIR

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

ZXDIR

*/

class tolGtolTrans_ZXDIR :
  public tolGtolTrans
{
public:
  tolGtolTrans_ZXDIR();
  ~tolGtolTrans_ZXDIR();
  void printSelf();
};

/********************************************************************/

/* tolGtolTrans_XYZDIR

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

XYZDIR

*/

class tolGtolTrans_XYZDIR :
  public tolGtolTrans
{
public:
  tolGtolTrans_XYZDIR();
  ~tolGtolTrans_XYZDIR();
  void printSelf();
};

/********************************************************************/

/* tolGtolTrans_NOTRAN

This is a derived class for one of the definitions of tolGtolTrans.
It represents the following items:

NOTRAN

*/

class tolGtolTrans_NOTRAN :
  public tolGtolTrans
{
public:
  tolGtolTrans_NOTRAN();
  ~tolGtolTrans_NOTRAN();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot

This is a parent class.

*/

class tolGtolRot :
  public dmisCppBase
{
public:
  tolGtolRot();
  ~tolGtolRot();
  void printSelf() = 0;
};

/********************************************************************/

/* tolGtolRot_XAXIS

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

XAXIS

*/

class tolGtolRot_XAXIS :
  public tolGtolRot
{
public:
  tolGtolRot_XAXIS();
  ~tolGtolRot_XAXIS();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot_YAXIS

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

YAXIS

*/

class tolGtolRot_YAXIS :
  public tolGtolRot
{
public:
  tolGtolRot_YAXIS();
  ~tolGtolRot_YAXIS();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot_ZAXIS

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

ZAXIS

*/

class tolGtolRot_ZAXIS :
  public tolGtolRot
{
public:
  tolGtolRot_ZAXIS();
  ~tolGtolRot_ZAXIS();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot_XYAXIS

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

XYAXIS

*/

class tolGtolRot_XYAXIS :
  public tolGtolRot
{
public:
  tolGtolRot_XYAXIS();
  ~tolGtolRot_XYAXIS();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot_YZAXIS

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

YZAXIS

*/

class tolGtolRot_YZAXIS :
  public tolGtolRot
{
public:
  tolGtolRot_YZAXIS();
  ~tolGtolRot_YZAXIS();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot_ZXAXIS

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

ZXAXIS

*/

class tolGtolRot_ZXAXIS :
  public tolGtolRot
{
public:
  tolGtolRot_ZXAXIS();
  ~tolGtolRot_ZXAXIS();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot_XYZAXI

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

XYZAXI

*/

class tolGtolRot_XYZAXI :
  public tolGtolRot
{
public:
  tolGtolRot_XYZAXI();
  ~tolGtolRot_XYZAXI();
  void printSelf();
};

/********************************************************************/

/* tolGtolRot_NOROT

This is a derived class for one of the definitions of tolGtolRot.
It represents the following items:

NOROT

*/

class tolGtolRot_NOROT :
  public tolGtolRot
{
public:
  tolGtolRot_NOROT();
  ~tolGtolRot_NOROT();
  void printSelf();
};

/********************************************************************/

/* tolGtolSpec

This is a parent class.

*/

class tolGtolSpec :
  public dmisCppBase
{
public:
  tolGtolSpec();
  ~tolGtolSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* tolGtolSpec_PERCNT

This is a derived class for one of the definitions of tolGtolSpec.
It represents the following items:

PERCNT

*/

class tolGtolSpec_PERCNT :
  public tolGtolSpec
{
public:
  tolGtolSpec_PERCNT();
  ~tolGtolSpec_PERCNT();
  void printSelf();
};

/********************************************************************/

/* tolGtolSpec_INTFPT

This is a derived class for one of the definitions of tolGtolSpec.
It represents the following items:

INTFPT

*/

class tolGtolSpec_INTFPT :
  public tolGtolSpec
{
public:
  tolGtolSpec_INTFPT();
  ~tolGtolSpec_INTFPT();
  void printSelf();
};

/********************************************************************/

/* tolAppData

This is a class for the single definition of tolAppData.
It represents the following items:

rentVal [',' tolMaxMatCond] ',' tolFeatMaxMat [',' tolFeatMaxMat] [',' tolZoneType] [',' tolZoneDir]

*/

class tolAppData :
  public dmisCppBase
{
public:
  tolAppData();
  tolAppData(
    rentVal * tolzonIn,
    tolMaxMatCond * tolMaxMatCondIn,
    tolFeatMaxMat * ref1In,
    tolFeatMaxMat * ref2In,
    tolZoneType * tolZoneTypeIn,
    tolZoneDir * tolZoneDirIn);
  ~tolAppData();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  tolMaxMatCond * get_tolMaxMatCond();
  void set_tolMaxMatCond(tolMaxMatCond * tolMaxMatCondIn);
  tolFeatMaxMat * get_ref1();
  void set_ref1(tolFeatMaxMat * ref1In);
  tolFeatMaxMat * get_ref2();
  void set_ref2(tolFeatMaxMat * ref2In);
  tolZoneType * get_tolZoneType();
  void set_tolZoneType(tolZoneType * tolZoneTypeIn);
  tolZoneDir * get_tolZoneDir();
  void set_tolZoneDir(tolZoneDir * tolZoneDirIn);
private:
  rentVal * tolzon;
  tolMaxMatCond * a_tolMaxMatCond;
  tolFeatMaxMat * ref1;
  tolFeatMaxMat * ref2;
  tolZoneType * a_tolZoneType;
  tolZoneDir * a_tolZoneDir;
};

/********************************************************************/

/* tolFeatMaxMat

This is a parent class.

*/

class tolFeatMaxMat :
  public dmisCppBase
{
public:
  tolFeatMaxMat();
  ~tolFeatMaxMat();
  void printSelf() = 0;
};

/********************************************************************/

/* tolFeatMaxMat_datLabel

This is a derived class for one of the definitions of tolFeatMaxMat.
It represents the following items:

datLabel [',' tolMaxMatCond]

*/

class tolFeatMaxMat_datLabel :
  public tolFeatMaxMat
{
public:
  tolFeatMaxMat_datLabel();
  tolFeatMaxMat_datLabel(
    datLabel * datLabelIn,
    tolMaxMatCond * tolMaxMatCondIn);
  ~tolFeatMaxMat_datLabel();
  void printSelf();
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  tolMaxMatCond * get_tolMaxMatCond();
  void set_tolMaxMatCond(tolMaxMatCond * tolMaxMatCondIn);
private:
  datLabel * a_datLabel;
  tolMaxMatCond * a_tolMaxMatCond;
};

/********************************************************************/

/* tolFeatMaxMat_faLabel

This is a derived class for one of the definitions of tolFeatMaxMat.
It represents the following items:

faLabel [',' tolMaxMatCond]

*/

class tolFeatMaxMat_faLabel :
  public tolFeatMaxMat
{
public:
  tolFeatMaxMat_faLabel();
  tolFeatMaxMat_faLabel(
    faLabel * faLabelIn,
    tolMaxMatCond * tolMaxMatCondIn);
  ~tolFeatMaxMat_faLabel();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  tolMaxMatCond * get_tolMaxMatCond();
  void set_tolMaxMatCond(tolMaxMatCond * tolMaxMatCondIn);
private:
  faLabel * a_faLabel;
  tolMaxMatCond * a_tolMaxMatCond;
};

/********************************************************************/

/* tolFeatMaxMat_fLabel

This is a derived class for one of the definitions of tolFeatMaxMat.
It represents the following items:

fLabel

*/

class tolFeatMaxMat_fLabel :
  public tolFeatMaxMat
{
public:
  tolFeatMaxMat_fLabel();
  tolFeatMaxMat_fLabel(
    fLabel * fLabelIn);
  ~tolFeatMaxMat_fLabel();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
private:
  fLabel * a_fLabel;
};

/********************************************************************/

/* tolMaxMatCond

This is a parent class.

*/

class tolMaxMatCond :
  public dmisCppBase
{
public:
  tolMaxMatCond();
  ~tolMaxMatCond();
  void printSelf() = 0;
};

/********************************************************************/

/* tolMaxMatCond_LMC

This is a derived class for one of the definitions of tolMaxMatCond.
It represents the following items:

LMC [',' MAX ',' rentVal]

*/

class tolMaxMatCond_LMC :
  public tolMaxMatCond
{
public:
  tolMaxMatCond_LMC();
  tolMaxMatCond_LMC(
    rentVal * limIn);
  ~tolMaxMatCond_LMC();
  void printSelf();
  rentVal * get_lim();
  void set_lim(rentVal * limIn);
private:
  rentVal * lim;
};

/********************************************************************/

/* tolMaxMatCond_RFS

This is a derived class for one of the definitions of tolMaxMatCond.
It represents the following items:

RFS

*/

class tolMaxMatCond_RFS :
  public tolMaxMatCond
{
public:
  tolMaxMatCond_RFS();
  ~tolMaxMatCond_RFS();
  void printSelf();
};

/********************************************************************/

/* tolMaxMatCond_MMC

This is a derived class for one of the definitions of tolMaxMatCond.
It represents the following items:

MMC [',' MAX ',' rentVal]

*/

class tolMaxMatCond_MMC :
  public tolMaxMatCond
{
public:
  tolMaxMatCond_MMC();
  tolMaxMatCond_MMC(
    rentVal * limIn);
  ~tolMaxMatCond_MMC();
  void printSelf();
  rentVal * get_lim();
  void set_lim(rentVal * limIn);
private:
  rentVal * lim;
};

/********************************************************************/

/* tolZoneDir

This is a parent class.

*/

class tolZoneDir :
  public dmisCppBase
{
public:
  tolZoneDir();
  ~tolZoneDir();
  void printSelf() = 0;
};

/********************************************************************/

/* tolZoneDir_XAXIS

This is a derived class for one of the definitions of tolZoneDir.
It represents the following items:

XAXIS

*/

class tolZoneDir_XAXIS :
  public tolZoneDir
{
public:
  tolZoneDir_XAXIS();
  ~tolZoneDir_XAXIS();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir_YAXIS

This is a derived class for one of the definitions of tolZoneDir.
It represents the following items:

YAXIS

*/

class tolZoneDir_YAXIS :
  public tolZoneDir
{
public:
  tolZoneDir_YAXIS();
  ~tolZoneDir_YAXIS();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir_ZAXIS

This is a derived class for one of the definitions of tolZoneDir.
It represents the following items:

ZAXIS

*/

class tolZoneDir_ZAXIS :
  public tolZoneDir
{
public:
  tolZoneDir_ZAXIS();
  ~tolZoneDir_ZAXIS();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir_VEC

This is a derived class for one of the definitions of tolZoneDir.
It represents the following items:

VEC ',' vector

*/

class tolZoneDir_VEC :
  public tolZoneDir
{
public:
  tolZoneDir_VEC();
  tolZoneDir_VEC(
    vector * dirIn);
  ~tolZoneDir_VEC();
  void printSelf();
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  vector * dir;
};

/********************************************************************/

/* tolParlelStm

This is a class for the single definition of tolParlelStm.
It represents the following items:

tLabel '=' TOL '/' PARLEL ',' tolAppData #

*/

class tolParlelStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolParlelStm();
  tolParlelStm(
    tLabel * tLabelIn,
    tolAppData * tolAppDataIn);
  ~tolParlelStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolAppData * get_tolAppData();
  void set_tolAppData(tolAppData * tolAppDataIn);
private:
  tLabel * a_tLabel;
  tolAppData * a_tolAppData;
};

/********************************************************************/

/* tolPerpStm

This is a class for the single definition of tolPerpStm.
It represents the following items:

tLabel '=' TOL '/' PERP ',' tolAppData #

*/

class tolPerpStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolPerpStm();
  tolPerpStm(
    tLabel * tLabelIn,
    tolAppData * tolAppDataIn);
  ~tolPerpStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolAppData * get_tolAppData();
  void set_tolAppData(tolAppData * tolAppDataIn);
private:
  tLabel * a_tLabel;
  tolAppData * a_tolAppData;
};

/********************************************************************/

/* tolPosStm

This is a class for the single definition of tolPosStm.
It represents the following items:

tLabel '=' TOL '/' POS ',' tolPosStart tolPosEnd #

*/

class tolPosStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolPosStm();
  tolPosStm(
    tLabel * tLabelIn,
    tolPosStart * tolPosStartIn,
    tolPosEnd * tolPosEndIn);
  ~tolPosStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolPosStart * get_tolPosStart();
  void set_tolPosStart(tolPosStart * tolPosStartIn);
  tolPosEnd * get_tolPosEnd();
  void set_tolPosEnd(tolPosEnd * tolPosEndIn);
private:
  tLabel * a_tLabel;
  tolPosStart * a_tolPosStart;
  tolPosEnd * a_tolPosEnd;
};

/********************************************************************/

/* tolPosStart

This is a parent class.

*/

class tolPosStart :
  public dmisCppBase
{
public:
  tolPosStart();
  ~tolPosStart();
  void printSelf() = 0;
};

/********************************************************************/

/* tolPosStart_TWOD

This is a derived class for one of the definitions of tolPosStart.
It represents the following items:

TWOD ',' rentVal

*/

class tolPosStart_TWOD :
  public tolPosStart
{
public:
  tolPosStart_TWOD();
  tolPosStart_TWOD(
    rentVal * tolzonIn);
  ~tolPosStart_TWOD();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
private:
  rentVal * tolzon;
};

/********************************************************************/

/* tolPosStart_THREED

This is a derived class for one of the definitions of tolPosStart.
It represents the following items:

THREED ',' rentVal

*/

class tolPosStart_THREED :
  public tolPosStart
{
public:
  tolPosStart_THREED();
  tolPosStart_THREED(
    rentVal * tolzonIn);
  ~tolPosStart_THREED();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
private:
  rentVal * tolzon;
};

/********************************************************************/

/* tolPosEnd

This is a class for the single definition of tolPosEnd.
It represents the following items:

[',' tolMatCond] [',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]] [',' tolPosMethod]

*/

class tolPosEnd :
  public dmisCppBase
{
public:
  tolPosEnd();
  tolPosEnd(
    tolMatCond * tolMatCondIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In,
    tolPosMethod * tolPosMethodIn);
  ~tolPosEnd();
  void printSelf();
  tolMatCond * get_tolMatCond();
  void set_tolMatCond(tolMatCond * tolMatCondIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
  tolPosMethod * get_tolPosMethod();
  void set_tolPosMethod(tolPosMethod * tolPosMethodIn);
private:
  tolMatCond * a_tolMatCond;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
  tolPosMethod * a_tolPosMethod;
};

/********************************************************************/

/* tolPosMethod

This is a parent class.

*/

class tolPosMethod :
  public dmisCppBase
{
public:
  tolPosMethod();
  ~tolPosMethod();
  void printSelf() = 0;
};

/********************************************************************/

/* tolPosMethod_XAXIS

This is a derived class for one of the definitions of tolPosMethod.
It represents the following items:

XAXIS

*/

class tolPosMethod_XAXIS :
  public tolPosMethod
{
public:
  tolPosMethod_XAXIS();
  ~tolPosMethod_XAXIS();
  void printSelf();
};

/********************************************************************/

/* tolPosMethod_YAXIS

This is a derived class for one of the definitions of tolPosMethod.
It represents the following items:

YAXIS

*/

class tolPosMethod_YAXIS :
  public tolPosMethod
{
public:
  tolPosMethod_YAXIS();
  ~tolPosMethod_YAXIS();
  void printSelf();
};

/********************************************************************/

/* tolPosMethod_ZAXIS

This is a derived class for one of the definitions of tolPosMethod.
It represents the following items:

ZAXIS

*/

class tolPosMethod_ZAXIS :
  public tolPosMethod
{
public:
  tolPosMethod_ZAXIS();
  ~tolPosMethod_ZAXIS();
  void printSelf();
};

/********************************************************************/

/* tolPosMethod_RADIAL

This is a derived class for one of the definitions of tolPosMethod.
It represents the following items:

RADIAL

*/

class tolPosMethod_RADIAL :
  public tolPosMethod
{
public:
  tolPosMethod_RADIAL();
  ~tolPosMethod_RADIAL();
  void printSelf();
};

/********************************************************************/

/* tolPosMethod_ANGLE

This is a derived class for one of the definitions of tolPosMethod.
It represents the following items:

ANGLE

*/

class tolPosMethod_ANGLE :
  public tolPosMethod
{
public:
  tolPosMethod_ANGLE();
  ~tolPosMethod_ANGLE();
  void printSelf();
};

/********************************************************************/

/* tolPosMethod_VEC

This is a derived class for one of the definitions of tolPosMethod.
It represents the following items:

VEC ',' vector

*/

class tolPosMethod_VEC :
  public tolPosMethod
{
public:
  tolPosMethod_VEC();
  tolPosMethod_VEC(
    vector * dirIn);
  ~tolPosMethod_VEC();
  void printSelf();
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  vector * dir;
};

/********************************************************************/

/* tolProflStm

This is a class for the single definition of tolProflStm.
It represents the following items:

tLabel '=' TOL '/' PROFL ',' rentVal ',' rentVal [',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]] [',' tolZoneDir2] #

*/

class tolProflStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolProflStm();
  tolProflStm(
    tLabel * tLabelIn,
    rentVal * lotolIn,
    rentVal * uptolIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In,
    tolZoneDir2 * tolZoneDir2In);
  ~tolProflStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
  tolZoneDir2 * get_tolZoneDir2();
  void set_tolZoneDir2(tolZoneDir2 * tolZoneDir2In);
private:
  tLabel * a_tLabel;
  rentVal * lotol;
  rentVal * uptol;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
  tolZoneDir2 * a_tolZoneDir2;
};

/********************************************************************/

/* tolProfpStm

This is a class for the single definition of tolProfpStm.
It represents the following items:

tLabel '=' TOL '/' PROFP ',' rentVal ',' rentVal [',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]] #

*/

class tolProfpStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolProfpStm();
  tolProfpStm(
    tLabel * tLabelIn,
    rentVal * lotolIn,
    rentVal * uptolIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In);
  ~tolProfpStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
private:
  tLabel * a_tLabel;
  rentVal * lotol;
  rentVal * uptol;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
};

/********************************************************************/

/* tolProfsStm

This is a class for the single definition of tolProfsStm.
It represents the following items:

tLabel '=' TOL '/' PROFS ',' rentVal ',' rentVal [',' tolFeatureMat [',' tolFeatureMat [',' tolFeatureMat]]] [',' AVGDEV] #

*/

class tolProfsStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolProfsStm();
  tolProfsStm(
    tLabel * tLabelIn,
    rentVal * lotolIn,
    rentVal * uptolIn,
    tolFeatureMat * tfm1In,
    tolFeatureMat * tfm2In,
    tolFeatureMat * tfm3In,
    bool has_AVGDEVIn);
  ~tolProfsStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  tolFeatureMat * get_tfm1();
  void set_tfm1(tolFeatureMat * tfm1In);
  tolFeatureMat * get_tfm2();
  void set_tfm2(tolFeatureMat * tfm2In);
  tolFeatureMat * get_tfm3();
  void set_tfm3(tolFeatureMat * tfm3In);
  bool get_has_AVGDEV();
  void set_has_AVGDEV(bool has_AVGDEVIn);
private:
  tLabel * a_tLabel;
  rentVal * lotol;
  rentVal * uptol;
  tolFeatureMat * tfm1;
  tolFeatureMat * tfm2;
  tolFeatureMat * tfm3;
  bool has_AVGDEV;
};

/********************************************************************/

/* tolRadStm

This is a class for the single definition of tolRadStm.
It represents the following items:

tLabel '=' TOL '/' RAD ',' rentVal ',' rentVal [',' tolRadSpec] [',' MINMAX] #

*/

class tolRadStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolRadStm();
  tolRadStm(
    tLabel * tLabelIn,
    rentVal * lotolIn,
    rentVal * uptolIn,
    tolRadSpec * tolRadSpecIn,
    bool has_MINMAXIn);
  ~tolRadStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  tolRadSpec * get_tolRadSpec();
  void set_tolRadSpec(tolRadSpec * tolRadSpecIn);
  bool get_has_MINMAX();
  void set_has_MINMAX(bool has_MINMAXIn);
private:
  tLabel * a_tLabel;
  rentVal * lotol;
  rentVal * uptol;
  tolRadSpec * a_tolRadSpec;
  bool has_MINMAX;
};

/********************************************************************/

/* tolRadSpec

This is a parent class.

*/

class tolRadSpec :
  public dmisCppBase
{
public:
  tolRadSpec();
  ~tolRadSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* tolRadSpec_AVG

This is a derived class for one of the definitions of tolRadSpec.
It represents the following items:

AVG

*/

class tolRadSpec_AVG :
  public tolRadSpec
{
public:
  tolRadSpec_AVG();
  ~tolRadSpec_AVG();
  void printSelf();
};

/********************************************************************/

/* tolRadSpec_CRAD

This is a derived class for one of the definitions of tolRadSpec.
It represents the following items:

CRAD

*/

class tolRadSpec_CRAD :
  public tolRadSpec
{
public:
  tolRadSpec_CRAD();
  ~tolRadSpec_CRAD();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir3

This is a parent class.

*/

class tolZoneDir3 :
  public dmisCppBase
{
public:
  tolZoneDir3();
  ~tolZoneDir3();
  void printSelf() = 0;
};

/********************************************************************/

/* tolZoneDir3_XDIR

This is a derived class for one of the definitions of tolZoneDir3.
It represents the following items:

XDIR

*/

class tolZoneDir3_XDIR :
  public tolZoneDir3
{
public:
  tolZoneDir3_XDIR();
  ~tolZoneDir3_XDIR();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir3_YDIR

This is a derived class for one of the definitions of tolZoneDir3.
It represents the following items:

YDIR

*/

class tolZoneDir3_YDIR :
  public tolZoneDir3
{
public:
  tolZoneDir3_YDIR();
  ~tolZoneDir3_YDIR();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir3_ZDIR

This is a derived class for one of the definitions of tolZoneDir3.
It represents the following items:

ZDIR

*/

class tolZoneDir3_ZDIR :
  public tolZoneDir3
{
public:
  tolZoneDir3_ZDIR();
  ~tolZoneDir3_ZDIR();
  void printSelf();
};

/********************************************************************/

/* tolZoneDir3_VEC

This is a derived class for one of the definitions of tolZoneDir3.
It represents the following items:

VEC ',' vector

*/

class tolZoneDir3_VEC :
  public tolZoneDir3
{
public:
  tolZoneDir3_VEC();
  tolZoneDir3_VEC(
    vector * dirIn);
  ~tolZoneDir3_VEC();
  void printSelf();
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  vector * dir;
};

/********************************************************************/

/* tolStrghtStm

This is a class for the single definition of tolStrghtStm.
It represents the following items:

tLabel '=' TOL '/' STRGHT ',' tolStrghtMinor #

*/

class tolStrghtStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolStrghtStm();
  tolStrghtStm(
    tLabel * tLabelIn,
    tolStrghtMinor * tolStrghtMinorIn);
  ~tolStrghtStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  tolStrghtMinor * get_tolStrghtMinor();
  void set_tolStrghtMinor(tolStrghtMinor * tolStrghtMinorIn);
private:
  tLabel * a_tLabel;
  tolStrghtMinor * a_tolStrghtMinor;
};

/********************************************************************/

/* tolStrghtMinor

This is a parent class.

*/

class tolStrghtMinor :
  public dmisCppBase
{
public:
  tolStrghtMinor();
  ~tolStrghtMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* tolStrghtPlain

This is a derived class for one of the definitions of tolStrghtMinor.
It represents the following items:

rentVal [',' axis] [',' tolZoneDir3]

*/

class tolStrghtPlain :
  public tolStrghtMinor
{
public:
  tolStrghtPlain();
  tolStrghtPlain(
    rentVal * tolzonIn,
    axis * axisIn,
    tolZoneDir3 * tolZoneDir3In);
  ~tolStrghtPlain();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
  tolZoneDir3 * get_tolZoneDir3();
  void set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In);
private:
  rentVal * tolzon;
  axis * a_axis;
  tolZoneDir3 * a_tolZoneDir3;
};

/********************************************************************/

/* tolStrghtMat

This is a derived class for one of the definitions of tolStrghtMinor.
It represents the following items:

rentVal ',' tolMatCond [',' axis] [',' tolZoneDir3]

*/

class tolStrghtMat :
  public tolStrghtMinor
{
public:
  tolStrghtMat();
  tolStrghtMat(
    rentVal * tolzonIn,
    tolMatCond * tolMatCondIn,
    axis * axisIn,
    tolZoneDir3 * tolZoneDir3In);
  ~tolStrghtMat();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  tolMatCond * get_tolMatCond();
  void set_tolMatCond(tolMatCond * tolMatCondIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
  tolZoneDir3 * get_tolZoneDir3();
  void set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In);
private:
  rentVal * tolzon;
  tolMatCond * a_tolMatCond;
  axis * a_axis;
  tolZoneDir3 * a_tolZoneDir3;
};

/********************************************************************/

/* tolStrghtPer1

This is a derived class for one of the definitions of tolStrghtMinor.
It represents the following items:

rentVal ',' rentVal [',' axis] [',' tolZoneDir3]

*/

class tolStrghtPer1 :
  public tolStrghtMinor
{
public:
  tolStrghtPer1();
  tolStrghtPer1(
    rentVal * tolzonIn,
    rentVal * unitIn,
    axis * axisIn,
    tolZoneDir3 * tolZoneDir3In);
  ~tolStrghtPer1();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  rentVal * get_unit();
  void set_unit(rentVal * unitIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
  tolZoneDir3 * get_tolZoneDir3();
  void set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In);
private:
  rentVal * tolzon;
  rentVal * unit;
  axis * a_axis;
  tolZoneDir3 * a_tolZoneDir3;
};

/********************************************************************/

/* tolStrghtPer2

This is a derived class for one of the definitions of tolStrghtMinor.
It represents the following items:

rentVal ',' rentVal ',' rentVal [',' axis] [',' tolZoneDir3]

*/

class tolStrghtPer2 :
  public tolStrghtMinor
{
public:
  tolStrghtPer2();
  tolStrghtPer2(
    rentVal * tolzonIn,
    rentVal * tolzon1In,
    rentVal * unitIn,
    axis * axisIn,
    tolZoneDir3 * tolZoneDir3In);
  ~tolStrghtPer2();
  void printSelf();
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  rentVal * get_tolzon1();
  void set_tolzon1(rentVal * tolzon1In);
  rentVal * get_unit();
  void set_unit(rentVal * unitIn);
  axis * get_axis();
  void set_axis(axis * axisIn);
  tolZoneDir3 * get_tolZoneDir3();
  void set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In);
private:
  rentVal * tolzon;
  rentVal * tolzon1;
  rentVal * unit;
  axis * a_axis;
  tolZoneDir3 * a_tolZoneDir3;
};

/********************************************************************/

/* tolSymStm

This is a class for the single definition of tolSymStm.
It represents the following items:

tLabel '=' TOL '/' SYM ',' rentVal ',' tolFeatureMat [',' tolZoneDir3] #

*/

class tolSymStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolSymStm();
  tolSymStm(
    tLabel * tLabelIn,
    rentVal * tolzonIn,
    tolFeatureMat * tolFeatureMatIn,
    tolZoneDir3 * tolZoneDir3In);
  ~tolSymStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  tolFeatureMat * get_tolFeatureMat();
  void set_tolFeatureMat(tolFeatureMat * tolFeatureMatIn);
  tolZoneDir3 * get_tolZoneDir3();
  void set_tolZoneDir3(tolZoneDir3 * tolZoneDir3In);
private:
  tLabel * a_tLabel;
  rentVal * tolzon;
  tolFeatureMat * a_tolFeatureMat;
  tolZoneDir3 * a_tolZoneDir3;
};

/********************************************************************/

/* tolTrnoutStm

This is a class for the single definition of tolTrnoutStm.
It represents the following items:

tLabel '=' TOL '/' TRNOUT ',' rentVal ',' datLabel [',' tolFeature [',' tolFeature]] #

*/

class tolTrnoutStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolTrnoutStm();
  tolTrnoutStm(
    tLabel * tLabelIn,
    rentVal * tolzonIn,
    datLabel * datLabelIn,
    tolFeature * tolFeat1In,
    tolFeature * tolFeat2In);
  ~tolTrnoutStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_tolzon();
  void set_tolzon(rentVal * tolzonIn);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
  tolFeature * get_tolFeat1();
  void set_tolFeat1(tolFeature * tolFeat1In);
  tolFeature * get_tolFeat2();
  void set_tolFeat2(tolFeature * tolFeat2In);
private:
  tLabel * a_tLabel;
  rentVal * tolzon;
  datLabel * a_datLabel;
  tolFeature * tolFeat1;
  tolFeature * tolFeat2;
};

/********************************************************************/

/* tolUsetolStm

This is a class for the single definition of tolUsetolStm.
It represents the following items:

tLabel '=' TOL '/' USETOL ',' stringVal #

*/

class tolUsetolStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolUsetolStm();
  tolUsetolStm(
    tLabel * tLabelIn,
    stringVal * textIn);
  ~tolUsetolStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  tLabel * a_tLabel;
  stringVal * text;
};

/********************************************************************/

/* tolWidthStm

This is a class for the single definition of tolWidthStm.
It represents the following items:

tLabel '=' TOL '/' WIDTH ',' rentVal ',' rentVal [',' tolWidthDir] [',' MINMAX] #

*/

class tolWidthStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tolWidthStm();
  tolWidthStm(
    tLabel * tLabelIn,
    rentVal * lotolIn,
    rentVal * uptolIn,
    tolWidthDir * tolWidthDirIn,
    bool has_MINMAXIn);
  ~tolWidthStm();
  void printSelf();
  tLabel * get_tLabel();
  void set_tLabel(tLabel * tLabelIn);
  rentVal * get_lotol();
  void set_lotol(rentVal * lotolIn);
  rentVal * get_uptol();
  void set_uptol(rentVal * uptolIn);
  tolWidthDir * get_tolWidthDir();
  void set_tolWidthDir(tolWidthDir * tolWidthDirIn);
  bool get_has_MINMAX();
  void set_has_MINMAX(bool has_MINMAXIn);
private:
  tLabel * a_tLabel;
  rentVal * lotol;
  rentVal * uptol;
  tolWidthDir * a_tolWidthDir;
  bool has_MINMAX;
};

/********************************************************************/

/* tolWidthDir

This is a parent class.

*/

class tolWidthDir :
  public dmisCppBase
{
public:
  tolWidthDir();
  ~tolWidthDir();
  void printSelf() = 0;
};

/********************************************************************/

/* tolWidthDir_vector

This is a derived class for one of the definitions of tolWidthDir.
It represents the following items:

vector

*/

class tolWidthDir_vector :
  public tolWidthDir
{
public:
  tolWidthDir_vector();
  tolWidthDir_vector(
    vector * dirIn);
  ~tolWidthDir_vector();
  void printSelf();
  vector * get_dir();
  void set_dir(vector * dirIn);
private:
  vector * dir;
};

/********************************************************************/

/* tolWidthDir_SHORT

This is a derived class for one of the definitions of tolWidthDir.
It represents the following items:

SHORT

*/

class tolWidthDir_SHORT :
  public tolWidthDir
{
public:
  tolWidthDir_SHORT();
  ~tolWidthDir_SHORT();
  void printSelf();
};

/********************************************************************/

/* tolWidthDir_LONG

This is a derived class for one of the definitions of tolWidthDir.
It represents the following items:

LONG

*/

class tolWidthDir_LONG :
  public tolWidthDir
{
public:
  tolWidthDir_LONG();
  ~tolWidthDir_LONG();
  void printSelf();
};

/********************************************************************/

/* tolFeature

This is a parent class.

*/

class tolFeature :
  public dmisCppBase
{
public:
  tolFeature();
  ~tolFeature();
  void printSelf() = 0;
};

/********************************************************************/

/* tolMatCond

This is a parent class.

*/

class tolMatCond :
  public dmisCppBase
{
public:
  tolMatCond();
  ~tolMatCond();
  void printSelf() = 0;
};

/********************************************************************/

/* tolMatCond_MMC

This is a derived class for one of the definitions of tolMatCond.
It represents the following items:

MMC

*/

class tolMatCond_MMC :
  public tolMatCond
{
public:
  tolMatCond_MMC();
  ~tolMatCond_MMC();
  void printSelf();
};

/********************************************************************/

/* tolMatCond_LMC

This is a derived class for one of the definitions of tolMatCond.
It represents the following items:

LMC

*/

class tolMatCond_LMC :
  public tolMatCond
{
public:
  tolMatCond_LMC();
  ~tolMatCond_LMC();
  void printSelf();
};

/********************************************************************/

/* tolMatCond_RFS

This is a derived class for one of the definitions of tolMatCond.
It represents the following items:

RFS

*/

class tolMatCond_RFS :
  public tolMatCond
{
public:
  tolMatCond_RFS();
  ~tolMatCond_RFS();
  void printSelf();
};

/********************************************************************/

/* tolZoneType

This is a parent class.

*/

class tolZoneType :
  public dmisCppBase
{
public:
  tolZoneType();
  ~tolZoneType();
  void printSelf() = 0;
};

/********************************************************************/

/* tolZoneType_TANGPL

This is a derived class for one of the definitions of tolZoneType.
It represents the following items:

TANGPL

*/

class tolZoneType_TANGPL :
  public tolZoneType
{
public:
  tolZoneType_TANGPL();
  ~tolZoneType_TANGPL();
  void printSelf();
};

/********************************************************************/

/* tolZoneType_PARPLN

This is a derived class for one of the definitions of tolZoneType.
It represents the following items:

PARPLN

*/

class tolZoneType_PARPLN :
  public tolZoneType
{
public:
  tolZoneType_PARPLN();
  ~tolZoneType_PARPLN();
  void printSelf();
};

/********************************************************************/

/* tooldfStm

This is a class for the single definition of tooldfStm.
It represents the following items:

tlLabel '=' TOOLDF '/' mdLabel ',' stringVal #

*/

class tooldfStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  tooldfStm();
  tooldfStm(
    tlLabel * tlLabelIn,
    mdLabel * mdLabelIn,
    stringVal * textIn);
  ~tooldfStm();
  void printSelf();
  tlLabel * get_tlLabel();
  void set_tlLabel(tlLabel * tlLabelIn);
  mdLabel * get_mdLabel();
  void set_mdLabel(mdLabel * mdLabelIn);
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  tlLabel * a_tlLabel;
  mdLabel * a_mdLabel;
  stringVal * text;
};

/********************************************************************/

/* transStm

This is a class for the single definition of transStm.
It represents the following items:

dLabel '=' TRANS '/' transMinor [',' transMinor [',' transMinor]] #

*/

class transStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  transStm();
  transStm(
    dLabel * dLabelIn,
    transMinor * tMinor1In,
    transMinor * tMinor2In,
    transMinor * tMinor3In);
  ~transStm();
  void printSelf();
  dLabel * get_dLabel();
  void set_dLabel(dLabel * dLabelIn);
  transMinor * get_tMinor1();
  void set_tMinor1(transMinor * tMinor1In);
  transMinor * get_tMinor2();
  void set_tMinor2(transMinor * tMinor2In);
  transMinor * get_tMinor3();
  void set_tMinor3(transMinor * tMinor3In);
private:
  dLabel * a_dLabel;
  transMinor * tMinor1;
  transMinor * tMinor2;
  transMinor * tMinor3;
};

/********************************************************************/

/* transMinor

This is a parent class.

*/

class transMinor :
  public dmisCppBase
{
public:
  transMinor();
  ~transMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* transValue

This is a class for the single definition of transValue.
It represents the following items:

orig ',' rentVal

*/

class transValue :
  public transMinor
{
public:
  transValue();
  transValue(
    orig * origIn,
    rentVal * valueIn);
  ~transValue();
  void printSelf();
  orig * get_orig();
  void set_orig(orig * origIn);
  rentVal * get_value();
  void set_value(rentVal * valueIn);
private:
  orig * a_orig;
  rentVal * value;
};

/********************************************************************/

/* transFeature

This is a class for the single definition of transFeature.
It represents the following items:

orig ',' featureLabel

*/

class transFeature :
  public transMinor
{
public:
  transFeature();
  transFeature(
    orig * origIn,
    featureLabel * featureLabelIn);
  ~transFeature();
  void printSelf();
  orig * get_orig();
  void set_orig(orig * origIn);
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  orig * a_orig;
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* transDatum

This is a class for the single definition of transDatum.
It represents the following items:

orig ',' datLabel

*/

class transDatum :
  public transMinor
{
public:
  transDatum();
  transDatum(
    orig * origIn,
    datLabel * datLabelIn);
  ~transDatum();
  void printSelf();
  orig * get_orig();
  void set_orig(orig * origIn);
  datLabel * get_datLabel();
  void set_datLabel(datLabel * datLabelIn);
private:
  orig * a_orig;
  datLabel * a_datLabel;
};

/********************************************************************/

/* transProbe

This is a parent class.

*/

class transProbe :
  public transMinor
{
public:
  transProbe();
  ~transProbe();
  void printSelf() = 0;
};

/********************************************************************/

/* transProbe_MINUSPRBRAD

This is a derived class for one of the definitions of transProbe.
It represents the following items:

orig ',' MINUSPRBRAD

*/

class transProbe_MINUSPRBRAD :
  public transProbe
{
public:
  transProbe_MINUSPRBRAD();
  transProbe_MINUSPRBRAD(
    orig * origIn);
  ~transProbe_MINUSPRBRAD();
  void printSelf();
  orig * get_orig();
  void set_orig(orig * origIn);
private:
  orig * a_orig;
};

/********************************************************************/

/* transProbe_PRBRAD

This is a derived class for one of the definitions of transProbe.
It represents the following items:

orig ',' PRBRAD

*/

class transProbe_PRBRAD :
  public transProbe
{
public:
  transProbe_PRBRAD();
  transProbe_PRBRAD(
    orig * origIn);
  ~transProbe_PRBRAD();
  void printSelf();
  orig * get_orig();
  void set_orig(orig * origIn);
private:
  orig * a_orig;
};

/********************************************************************/

/* uncertalgStm

This is a class for the single definition of uncertalgStm.
It represents the following items:

uLabel '=' UNCERTALG '/' uncertMinor #

*/

class uncertalgStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  uncertalgStm();
  uncertalgStm(
    uLabel * uLabelIn,
    uncertMinor * uncertMinorIn);
  ~uncertalgStm();
  void printSelf();
  uLabel * get_uLabel();
  void set_uLabel(uLabel * uLabelIn);
  uncertMinor * get_uncertMinor();
  void set_uncertMinor(uncertMinor * uncertMinorIn);
private:
  uLabel * a_uLabel;
  uncertMinor * a_uncertMinor;
};

/********************************************************************/

/* uncertMinor

This is a parent class.

*/

class uncertMinor :
  public dmisCppBase
{
public:
  uncertMinor();
  ~uncertMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* uncertMinor_ALGOR

This is a derived class for one of the definitions of uncertMinor.
It represents the following items:

ALGOR ',' intVal

*/

class uncertMinor_ALGOR :
  public uncertMinor
{
public:
  uncertMinor_ALGOR();
  uncertMinor_ALGOR(
    intVal * codeIn);
  ~uncertMinor_ALGOR();
  void printSelf();
  intVal * get_code();
  void set_code(intVal * codeIn);
private:
  intVal * code;
};

/********************************************************************/

/* uncertMinor_stringVal

This is a derived class for one of the definitions of uncertMinor.
It represents the following items:

stringVal ',' uncertVar3

*/

class uncertMinor_stringVal :
  public uncertMinor
{
public:
  uncertMinor_stringVal();
  uncertMinor_stringVal(
    stringVal * nameIn,
    uncertVar3 * uncertVar3In);
  ~uncertMinor_stringVal();
  void printSelf();
  stringVal * get_name();
  void set_name(stringVal * nameIn);
  uncertVar3 * get_uncertVar3();
  void set_uncertVar3(uncertVar3 * uncertVar3In);
private:
  stringVal * name;
  uncertVar3 * a_uncertVar3;
};

/********************************************************************/

/* uncertVar3

This is a parent class.

*/

class uncertVar3 :
  public dmisCppBase
{
public:
  uncertVar3();
  ~uncertVar3();
  void printSelf() = 0;
};

/********************************************************************/

/* uncertVar3_DME

This is a derived class for one of the definitions of uncertVar3.
It represents the following items:

DME [',' paramList]

*/

class uncertVar3_DME :
  public uncertVar3
{
public:
  uncertVar3_DME();
  uncertVar3_DME(
    std::list<param *> * paramListIn);
  ~uncertVar3_DME();
  void printSelf();
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* uncertVar3_SENS

This is a derived class for one of the definitions of uncertVar3.
It represents the following items:

SENS [',' paramList]

*/

class uncertVar3_SENS :
  public uncertVar3
{
public:
  uncertVar3_SENS();
  uncertVar3_SENS(
    std::list<param *> * paramListIn);
  ~uncertVar3_SENS();
  void printSelf();
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* uncertVar3_paramList

This is a derived class for one of the definitions of uncertVar3.
It represents the following items:

paramList

*/

class uncertVar3_paramList :
  public uncertVar3
{
public:
  uncertVar3_paramList();
  uncertVar3_paramList(
    std::list<param *> * paramListIn);
  ~uncertVar3_paramList();
  void printSelf();
  std::list<param *> * get_paramList();
  void set_paramList(std::list<param *> * paramListIn);
private:
  std::list<param *> * a_paramList;
};

/********************************************************************/

/* uncertsetStm

This is a class for the single definition of uncertsetStm.
It represents the following items:

UNCERTSET '/' uncertsetMinor #

*/

class uncertsetStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  uncertsetStm();
  uncertsetStm(
    uncertsetMinor * uncertsetMinorIn);
  ~uncertsetStm();
  void printSelf();
  uncertsetMinor * get_uncertsetMinor();
  void set_uncertsetMinor(uncertsetMinor * uncertsetMinorIn);
private:
  uncertsetMinor * a_uncertsetMinor;
};

/********************************************************************/

/* uncertsetMinor

This is a parent class.

*/

class uncertsetMinor :
  public dmisCppBase
{
public:
  uncertsetMinor();
  ~uncertsetMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* uncertsetMinor_ON

This is a derived class for one of the definitions of uncertsetMinor.
It represents the following items:

ON ',' uLabel ',' uncertsetVar2

*/

class uncertsetMinor_ON :
  public uncertsetMinor
{
public:
  uncertsetMinor_ON();
  uncertsetMinor_ON(
    uLabel * uLabelIn,
    uncertsetVar2 * uncertsetVar2In);
  ~uncertsetMinor_ON();
  void printSelf();
  uLabel * get_uLabel();
  void set_uLabel(uLabel * uLabelIn);
  uncertsetVar2 * get_uncertsetVar2();
  void set_uncertsetVar2(uncertsetVar2 * uncertsetVar2In);
private:
  uLabel * a_uLabel;
  uncertsetVar2 * a_uncertsetVar2;
};

/********************************************************************/

/* uncertsetMinor_OFF

This is a derived class for one of the definitions of uncertsetMinor.
It represents the following items:

OFF

*/

class uncertsetMinor_OFF :
  public uncertsetMinor
{
public:
  uncertsetMinor_OFF();
  ~uncertsetMinor_OFF();
  void printSelf();
};

/********************************************************************/

/* uncertsetVar2

This is a parent class.

*/

class uncertsetVar2 :
  public dmisCppBase
{
public:
  uncertsetVar2();
  ~uncertsetVar2();
  void printSelf() = 0;
};

/********************************************************************/

/* uncertsetVar2_drLabel

This is a derived class for one of the definitions of uncertsetVar2.
It represents the following items:

drLabel

*/

class uncertsetVar2_drLabel :
  public uncertsetVar2
{
public:
  uncertsetVar2_drLabel();
  uncertsetVar2_drLabel(
    drLabel * drLabelIn);
  ~uncertsetVar2_drLabel();
  void printSelf();
  drLabel * get_drLabel();
  void set_drLabel(drLabel * drLabelIn);
private:
  drLabel * a_drLabel;
};

/********************************************************************/

/* uncertsetVar2_NONE

This is a derived class for one of the definitions of uncertsetVar2.
It represents the following items:

NONE

*/

class uncertsetVar2_NONE :
  public uncertsetVar2
{
public:
  uncertsetVar2_NONE();
  ~uncertsetVar2_NONE();
  void printSelf();
};

/********************************************************************/

/* unitsStm

This is a class for the single definition of unitsStm.
It represents the following items:

UNITS '/' lengthUnit ',' angleUnit [',' tempUnit] #

*/

class unitsStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  unitsStm();
  unitsStm(
    lengthUnit * lengthUnitIn,
    angleUnit * angleUnitIn,
    tempUnit * tempUnitIn);
  ~unitsStm();
  void printSelf();
  lengthUnit * get_lengthUnit();
  void set_lengthUnit(lengthUnit * lengthUnitIn);
  angleUnit * get_angleUnit();
  void set_angleUnit(angleUnit * angleUnitIn);
  tempUnit * get_tempUnit();
  void set_tempUnit(tempUnit * tempUnitIn);
private:
  lengthUnit * a_lengthUnit;
  angleUnit * a_angleUnit;
  tempUnit * a_tempUnit;
};

/********************************************************************/

/* lengthUnit

This is a parent class.

*/

class lengthUnit :
  public dmisCppBase
{
public:
  lengthUnit();
  ~lengthUnit();
  void printSelf() = 0;
};

/********************************************************************/

/* lengthUnit_MM

This is a derived class for one of the definitions of lengthUnit.
It represents the following items:

MM

*/

class lengthUnit_MM :
  public lengthUnit
{
public:
  lengthUnit_MM();
  ~lengthUnit_MM();
  void printSelf();
};

/********************************************************************/

/* lengthUnit_CM

This is a derived class for one of the definitions of lengthUnit.
It represents the following items:

CM

*/

class lengthUnit_CM :
  public lengthUnit
{
public:
  lengthUnit_CM();
  ~lengthUnit_CM();
  void printSelf();
};

/********************************************************************/

/* lengthUnit_METER

This is a derived class for one of the definitions of lengthUnit.
It represents the following items:

METER

*/

class lengthUnit_METER :
  public lengthUnit
{
public:
  lengthUnit_METER();
  ~lengthUnit_METER();
  void printSelf();
};

/********************************************************************/

/* lengthUnit_INCH

This is a derived class for one of the definitions of lengthUnit.
It represents the following items:

INCH

*/

class lengthUnit_INCH :
  public lengthUnit
{
public:
  lengthUnit_INCH();
  ~lengthUnit_INCH();
  void printSelf();
};

/********************************************************************/

/* lengthUnit_FEET

This is a derived class for one of the definitions of lengthUnit.
It represents the following items:

FEET

*/

class lengthUnit_FEET :
  public lengthUnit
{
public:
  lengthUnit_FEET();
  ~lengthUnit_FEET();
  void printSelf();
};

/********************************************************************/

/* angleUnit

This is a parent class.

*/

class angleUnit :
  public dmisCppBase
{
public:
  angleUnit();
  ~angleUnit();
  void printSelf() = 0;
};

/********************************************************************/

/* angleUnit_ANGDEC

This is a derived class for one of the definitions of angleUnit.
It represents the following items:

ANGDEC

*/

class angleUnit_ANGDEC :
  public angleUnit
{
public:
  angleUnit_ANGDEC();
  ~angleUnit_ANGDEC();
  void printSelf();
};

/********************************************************************/

/* angleUnit_ANGDMS

This is a derived class for one of the definitions of angleUnit.
It represents the following items:

ANGDMS

*/

class angleUnit_ANGDMS :
  public angleUnit
{
public:
  angleUnit_ANGDMS();
  ~angleUnit_ANGDMS();
  void printSelf();
};

/********************************************************************/

/* angleUnit_ANGRAD

This is a derived class for one of the definitions of angleUnit.
It represents the following items:

ANGRAD

*/

class angleUnit_ANGRAD :
  public angleUnit
{
public:
  angleUnit_ANGRAD();
  ~angleUnit_ANGRAD();
  void printSelf();
};

/********************************************************************/

/* tempUnit

This is a parent class.

*/

class tempUnit :
  public dmisCppBase
{
public:
  tempUnit();
  ~tempUnit();
  void printSelf() = 0;
};

/********************************************************************/

/* tempUnit_TEMPF

This is a derived class for one of the definitions of tempUnit.
It represents the following items:

TEMPF

*/

class tempUnit_TEMPF :
  public tempUnit
{
public:
  tempUnit_TEMPF();
  ~tempUnit_TEMPF();
  void printSelf();
};

/********************************************************************/

/* tempUnit_TEMPC

This is a derived class for one of the definitions of tempUnit.
It represents the following items:

TEMPC

*/

class tempUnit_TEMPC :
  public tempUnit
{
public:
  tempUnit_TEMPC();
  ~tempUnit_TEMPC();
  void printSelf();
};

/********************************************************************/

/* valueMinorBool

This is a parent class.

*/

class valueMinorBool :
  public dmisCppBase
{
public:
  valueMinorBool();
  ~valueMinorBool();
  void printSelf() = 0;
};

/********************************************************************/

/* valueMinorString

This is a parent class.

*/

class valueMinorString :
  public dmisCppBase
{
public:
  valueMinorString();
  ~valueMinorString();
  void printSelf() = 0;
};

/********************************************************************/

/* valueMinorInt

This is a parent class.

*/

class valueMinorInt :
  public dmisCppBase
{
public:
  valueMinorInt();
  ~valueMinorInt();
  void printSelf() = 0;
};

/********************************************************************/

/* valueMinorReal

This is a parent class.

*/

class valueMinorReal :
  public dmisCppBase
{
public:
  valueMinorReal();
  ~valueMinorReal();
  void printSelf() = 0;
};

/********************************************************************/

/* valueMinorVector

This is a parent class.

*/

class valueMinorVector :
  public dmisCppBase
{
public:
  valueMinorVector();
  ~valueMinorVector();
  void printSelf() = 0;
};

/********************************************************************/

/* valueAclratReal

This is a parent class.

*/

class valueAclratReal :
  public valueMinorReal
{
public:
  valueAclratReal();
  ~valueAclratReal();
  void printSelf() = 0;
};

/********************************************************************/

/* valueAclratReal_MESACL

This is a derived class for one of the definitions of valueAclratReal.
It represents the following items:

ACLRAT ',' MESACL

*/

class valueAclratReal_MESACL :
  public valueAclratReal
{
public:
  valueAclratReal_MESACL();
  ~valueAclratReal_MESACL();
  void printSelf();
};

/********************************************************************/

/* valueAclratReal_POSACL

This is a derived class for one of the definitions of valueAclratReal.
It represents the following items:

ACLRAT ',' POSACL

*/

class valueAclratReal_POSACL :
  public valueAclratReal
{
public:
  valueAclratReal_POSACL();
  ~valueAclratReal_POSACL();
  void printSelf();
};

/********************************************************************/

/* valueAclratReal_ROTACL

This is a derived class for one of the definitions of valueAclratReal.
It represents the following items:

ACLRAT ',' ROTACL

*/

class valueAclratReal_ROTACL :
  public valueAclratReal
{
public:
  valueAclratReal_ROTACL();
  ~valueAclratReal_ROTACL();
  void printSelf();
};

/********************************************************************/

/* valueAclratString

This is a class for the single definition of valueAclratString.
It represents the following items:

valueAclratReal ',' ACEL

*/

class valueAclratString :
  public valueMinorString
{
public:
  valueAclratString();
  valueAclratString(
    valueAclratReal * valueAclratRealIn);
  ~valueAclratString();
  void printSelf();
  valueAclratReal * get_valueAclratReal();
  void set_valueAclratReal(valueAclratReal * valueAclratRealIn);
private:
  valueAclratReal * a_valueAclratReal;
};

/********************************************************************/

/* valueBadtst

This is a class for the single definition of valueBadtst.
It represents the following items:

BADTST

*/

class valueBadtst :
  public valueMinorBool
{
public:
  valueBadtst();
  ~valueBadtst();
  void printSelf();
};

/********************************************************************/

/* valueBoundString

This is a parent class.

*/

class valueBoundString :
  public valueMinorString
{
public:
  valueBoundString();
  ~valueBoundString();
  void printSelf() = 0;
};

/********************************************************************/

/* valueBoundString_featureLabel

This is a derived class for one of the definitions of valueBoundString.
It represents the following items:

BOUND ',' featureLabel ',' intVal

*/

class valueBoundString_featureLabel :
  public valueBoundString
{
public:
  valueBoundString_featureLabel();
  valueBoundString_featureLabel(
    featureLabel * featureLabelIn,
    intVal * bndnumIn);
  ~valueBoundString_featureLabel();
  void printSelf();
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
  intVal * get_bndnum();
  void set_bndnum(intVal * bndnumIn);
private:
  featureLabel * a_featureLabel;
  intVal * bndnum;
};

/********************************************************************/

/* valueBoundString_toleranceLabel

This is a derived class for one of the definitions of valueBoundString.
It represents the following items:

BOUND ',' toleranceLabel ',' intVal

*/

class valueBoundString_toleranceLabel :
  public valueBoundString
{
public:
  valueBoundString_toleranceLabel();
  valueBoundString_toleranceLabel(
    toleranceLabel * toleranceLabelIn,
    intVal * bndnumIn);
  ~valueBoundString_toleranceLabel();
  void printSelf();
  toleranceLabel * get_toleranceLabel();
  void set_toleranceLabel(toleranceLabel * toleranceLabelIn);
  intVal * get_bndnum();
  void set_bndnum(intVal * bndnumIn);
private:
  toleranceLabel * a_toleranceLabel;
  intVal * bndnum;
};

/********************************************************************/

/* valueBoundInt

This is a parent class.

*/

class valueBoundInt :
  public valueMinorInt
{
public:
  valueBoundInt();
  ~valueBoundInt();
  void printSelf() = 0;
};

/********************************************************************/

/* valueBoundInt_featureLabel

This is a derived class for one of the definitions of valueBoundInt.
It represents the following items:

BOUND ',' featureLabel ',' COUNT

*/

class valueBoundInt_featureLabel :
  public valueBoundInt
{
public:
  valueBoundInt_featureLabel();
  valueBoundInt_featureLabel(
    featureLabel * featureLabelIn);
  ~valueBoundInt_featureLabel();
  void printSelf();
  featureLabel * get_featureLabel();
  void set_featureLabel(featureLabel * featureLabelIn);
private:
  featureLabel * a_featureLabel;
};

/********************************************************************/

/* valueBoundInt_toleranceLabel

This is a derived class for one of the definitions of valueBoundInt.
It represents the following items:

BOUND ',' toleranceLabel ',' COUNT

*/

class valueBoundInt_toleranceLabel :
  public valueBoundInt
{
public:
  valueBoundInt_toleranceLabel();
  valueBoundInt_toleranceLabel(
    toleranceLabel * toleranceLabelIn);
  ~valueBoundInt_toleranceLabel();
  void printSelf();
  toleranceLabel * get_toleranceLabel();
  void set_toleranceLabel(toleranceLabel * toleranceLabelIn);
private:
  toleranceLabel * a_toleranceLabel;
};

/********************************************************************/

/* valueCrmode

This is a class for the single definition of valueCrmode.
It represents the following items:

CRMODE

*/

class valueCrmode :
  public valueMinorString
{
public:
  valueCrmode();
  ~valueCrmode();
  void printSelf();
};

/********************************************************************/

/* valueCroscl

This is a class for the single definition of valueCroscl.
It represents the following items:

CROSCL

*/

class valueCroscl :
  public valueMinorBool
{
public:
  valueCroscl();
  ~valueCroscl();
  void printSelf();
};

/********************************************************************/

/* valueCrslct

This is a class for the single definition of valueCrslct.
It represents the following items:

CRSLCT

*/

class valueCrslct :
  public valueMinorString
{
public:
  valueCrslct();
  ~valueCrslct();
  void printSelf();
};

/********************************************************************/

/* valueCzslct

This is a class for the single definition of valueCzslct.
It represents the following items:

CZSLCT ',' czLabel

*/

class valueCzslct :
  public valueMinorBool
{
public:
  valueCzslct();
  valueCzslct(
    czLabel * czLabelIn);
  ~valueCzslct();
  void printSelf();
  czLabel * get_czLabel();
  void set_czLabel(czLabel * czLabelIn);
private:
  czLabel * a_czLabel;
};

/********************************************************************/

/* valueDatset

This is a class for the single definition of valueDatset.
It represents the following items:

DATSET

*/

class valueDatset :
  public valueMinorString
{
public:
  valueDatset();
  ~valueDatset();
  void printSelf();
};

/********************************************************************/

/* valueDeflection

This is a class for the single definition of valueDeflection.
It represents the following items:

DEFLECTION

*/

class valueDeflection :
  public valueMinorReal
{
public:
  valueDeflection();
  ~valueDeflection();
  void printSelf();
};

/********************************************************************/

/* valueDmismd

This is a parent class.

*/

class valueDmismd :
  public valueMinorString
{
public:
  valueDmismd();
  ~valueDmismd();
  void printSelf() = 0;
};

/********************************************************************/

/* valueDmismd_NAME

This is a derived class for one of the definitions of valueDmismd.
It represents the following items:

DMISMD ',' NAME

*/

class valueDmismd_NAME :
  public valueDmismd
{
public:
  valueDmismd_NAME();
  ~valueDmismd_NAME();
  void printSelf();
};

/********************************************************************/

/* valueDmismd_VERSION

This is a derived class for one of the definitions of valueDmismd.
It represents the following items:

DMISMD ',' VERSION

*/

class valueDmismd_VERSION :
  public valueDmismd
{
public:
  valueDmismd_VERSION();
  ~valueDmismd_VERSION();
  void printSelf();
};

/********************************************************************/

/* valueDmismn

This is a parent class.

*/

class valueDmismn :
  public valueMinorString
{
public:
  valueDmismn();
  ~valueDmismn();
  void printSelf() = 0;
};

/********************************************************************/

/* valueDmismn_NAME

This is a derived class for one of the definitions of valueDmismn.
It represents the following items:

DMISMN ',' NAME

*/

class valueDmismn_NAME :
  public valueDmismn
{
public:
  valueDmismn_NAME();
  ~valueDmismn_NAME();
  void printSelf();
};

/********************************************************************/

/* valueDmismn_VERSION

This is a derived class for one of the definitions of valueDmismn.
It represents the following items:

DMISMN ',' VERSION

*/

class valueDmismn_VERSION :
  public valueDmismn
{
public:
  valueDmismn_VERSION();
  ~valueDmismn_VERSION();
  void printSelf();
};

/********************************************************************/

/* valueError

This is a parent class.

*/

class valueError :
  public valueMinorString
{
public:
  valueError();
  ~valueError();
  void printSelf() = 0;
};

/********************************************************************/

/* valueError_ERR

This is a derived class for one of the definitions of valueError.
It represents the following items:

ERROR ',' ERR

*/

class valueError_ERR :
  public valueError
{
public:
  valueError_ERR();
  ~valueError_ERR();
  void printSelf();
};

/********************************************************************/

/* valueError_ERRMODE

This is a derived class for one of the definitions of valueError.
It represents the following items:

ERROR ',' ERRMODE

*/

class valueError_ERRMODE :
  public valueError
{
public:
  valueError_ERRMODE();
  ~valueError_ERRMODE();
  void printSelf();
};

/********************************************************************/

/* valueFedratReal

This is a parent class.

*/

class valueFedratReal :
  public valueMinorReal
{
public:
  valueFedratReal();
  ~valueFedratReal();
  void printSelf() = 0;
};

/********************************************************************/

/* valueFedratReal_MESVEL

This is a derived class for one of the definitions of valueFedratReal.
It represents the following items:

FEDRAT ',' MESVEL

*/

class valueFedratReal_MESVEL :
  public valueFedratReal
{
public:
  valueFedratReal_MESVEL();
  ~valueFedratReal_MESVEL();
  void printSelf();
};

/********************************************************************/

/* valueFedratReal_POSVEL

This is a derived class for one of the definitions of valueFedratReal.
It represents the following items:

FEDRAT ',' POSVEL

*/

class valueFedratReal_POSVEL :
  public valueFedratReal
{
public:
  valueFedratReal_POSVEL();
  ~valueFedratReal_POSVEL();
  void printSelf();
};

/********************************************************************/

/* valueFedratReal_ROTVEL

This is a derived class for one of the definitions of valueFedratReal.
It represents the following items:

FEDRAT ',' ROTVEL

*/

class valueFedratReal_ROTVEL :
  public valueFedratReal
{
public:
  valueFedratReal_ROTVEL();
  ~valueFedratReal_ROTVEL();
  void printSelf();
};

/********************************************************************/

/* valueFedratReal_SCNVEL

This is a derived class for one of the definitions of valueFedratReal.
It represents the following items:

FEDRAT ',' SCNVEL

*/

class valueFedratReal_SCNVEL :
  public valueFedratReal
{
public:
  valueFedratReal_SCNVEL();
  ~valueFedratReal_SCNVEL();
  void printSelf();
};

/********************************************************************/

/* valueFedratString

This is a class for the single definition of valueFedratString.
It represents the following items:

valueFedratReal ',' FEED

*/

class valueFedratString :
  public valueMinorString
{
public:
  valueFedratString();
  valueFedratString(
    valueFedratReal * valueFedratRealIn);
  ~valueFedratString();
  void printSelf();
  valueFedratReal * get_valueFedratReal();
  void set_valueFedratReal(valueFedratReal * valueFedratRealIn);
private:
  valueFedratReal * a_valueFedratReal;
};

/********************************************************************/

/* valueFilnam

This is a parent class.

*/

class valueFilnam :
  public valueMinorString
{
public:
  valueFilnam();
  ~valueFilnam();
  void printSelf() = 0;
};

/********************************************************************/

/* valueFilnam_NAME

This is a derived class for one of the definitions of valueFilnam.
It represents the following items:

FILNAM ',' NAME

*/

class valueFilnam_NAME :
  public valueFilnam
{
public:
  valueFilnam_NAME();
  ~valueFilnam_NAME();
  void printSelf();
};

/********************************************************************/

/* valueFilnam_VERSION

This is a derived class for one of the definitions of valueFilnam.
It represents the following items:

FILNAM ',' VERSION

*/

class valueFilnam_VERSION :
  public valueFilnam
{
public:
  valueFilnam_VERSION();
  ~valueFilnam_VERSION();
  void printSelf();
};

/********************************************************************/

/* valueFinpos

This is a class for the single definition of valueFinpos.
It represents the following items:

FINPOS

*/

class valueFinpos :
  public valueMinorBool
{
public:
  valueFinpos();
  ~valueFinpos();
  void printSelf();
};

/********************************************************************/

/* valueGeoalg

This is a class for the single definition of valueGeoalg.
It represents the following items:

GEOALG ',' measGeotype

*/

class valueGeoalg :
  public valueMinorString
{
public:
  valueGeoalg();
  valueGeoalg(
    measGeotype * measGeotypeIn);
  ~valueGeoalg();
  void printSelf();
  measGeotype * get_measGeotype();
  void set_measGeotype(measGeotype * measGeotypeIn);
private:
  measGeotype * a_measGeotype;
};

/********************************************************************/

/* valueGotoReal

This is a class for the single definition of valueGotoReal.
It represents the following items:

GOTO ',' axis

*/

class valueGotoReal :
  public valueMinorReal
{
public:
  valueGotoReal();
  valueGotoReal(
    axis * axisIn);
  ~valueGotoReal();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  axis * a_axis;
};

/********************************************************************/

/* valueGotoVector

This is a class for the single definition of valueGotoVector.
It represents the following items:

GOTO ',' POS

*/

class valueGotoVector :
  public valueMinorVector
{
public:
  valueGotoVector();
  ~valueGotoVector();
  void printSelf();
};

/********************************************************************/

/* valueKeychar

This is a parent class.

*/

class valueKeychar :
  public valueMinorString
{
public:
  valueKeychar();
  ~valueKeychar();
  void printSelf() = 0;
};

/********************************************************************/

/* valueMode

This is a class for the single definition of valueMode.
It represents the following items:

MODE

*/

class valueMode :
  public valueMinorString
{
public:
  valueMode();
  ~valueMode();
  void printSelf();
};

/********************************************************************/

/* valuePrcomp

This is a class for the single definition of valuePrcomp.
It represents the following items:

PRCOMP

*/

class valuePrcomp :
  public valueMinorBool
{
public:
  valuePrcomp();
  ~valuePrcomp();
  void printSelf();
};

/********************************************************************/

/* valuePtbuff

This is a class for the single definition of valuePtbuff.
It represents the following items:

PTBUFF

*/

class valuePtbuff :
  public valueMinorBool
{
public:
  valuePtbuff();
  ~valuePtbuff();
  void printSelf();
};

/********************************************************************/

/* valuePtmeasReal

This is a class for the single definition of valuePtmeasReal.
It represents the following items:

PTMEAS ',' axis

*/

class valuePtmeasReal :
  public valueMinorReal
{
public:
  valuePtmeasReal();
  valuePtmeasReal(
    axis * axisIn);
  ~valuePtmeasReal();
  void printSelf();
  axis * get_axis();
  void set_axis(axis * axisIn);
private:
  axis * a_axis;
};

/********************************************************************/

/* valuePtmeasVector

This is a class for the single definition of valuePtmeasVector.
It represents the following items:

PTMEAS ',' POS

*/

class valuePtmeasVector :
  public valueMinorVector
{
public:
  valuePtmeasVector();
  ~valuePtmeasVector();
  void printSelf();
};

/********************************************************************/

/* valueScnmod

This is a class for the single definition of valueScnmod.
It represents the following items:

SCNMOD

*/

class valueScnmod :
  public valueMinorBool
{
public:
  valueScnmod();
  ~valueScnmod();
  void printSelf();
};

/********************************************************************/

/* valueSnsetReal

This is a parent class.

*/

class valueSnsetReal :
  public valueMinorReal
{
public:
  valueSnsetReal();
  ~valueSnsetReal();
  void printSelf() = 0;
};

/********************************************************************/

/* valueSnsetRealApprch

This is a derived class for one of the definitions of valueSnsetReal.
It represents the following items:

SNSET ',' APPRCH

*/

class valueSnsetRealApprch :
  public valueSnsetReal
{
public:
  valueSnsetRealApprch();
  ~valueSnsetRealApprch();
  void printSelf();
};

/********************************************************************/

/* valueSnsetRealRetrct

This is a derived class for one of the definitions of valueSnsetReal.
It represents the following items:

SNSET ',' RETRCT

*/

class valueSnsetRealRetrct :
  public valueSnsetReal
{
public:
  valueSnsetRealRetrct();
  ~valueSnsetRealRetrct();
  void printSelf();
};

/********************************************************************/

/* valueSnsetRealSearch

This is a derived class for one of the definitions of valueSnsetReal.
It represents the following items:

SNSET ',' SEARCH

*/

class valueSnsetRealSearch :
  public valueSnsetReal
{
public:
  valueSnsetRealSearch();
  ~valueSnsetRealSearch();
  void printSelf();
};

/********************************************************************/

/* valueSnsetRealClrsrf

This is a derived class for one of the definitions of valueSnsetReal.
It represents the following items:

SNSET ',' CLRSRF ',' DIST

*/

class valueSnsetRealClrsrf :
  public valueSnsetReal
{
public:
  valueSnsetRealClrsrf();
  ~valueSnsetRealClrsrf();
  void printSelf();
};

/********************************************************************/

/* valueSnsetRealDepth

This is a derived class for one of the definitions of valueSnsetReal.
It represents the following items:

SNSET ',' DEPTH ',' DIST

*/

class valueSnsetRealDepth :
  public valueSnsetReal
{
public:
  valueSnsetRealDepth();
  ~valueSnsetRealDepth();
  void printSelf();
};

/********************************************************************/

/* valueSnsetString

This is a parent class.

*/

class valueSnsetString :
  public valueMinorString
{
public:
  valueSnsetString();
  ~valueSnsetString();
  void printSelf() = 0;
};

/********************************************************************/

/* valueSnsetString_CLRSRF

This is a derived class for one of the definitions of valueSnsetString.
It represents the following items:

SNSET ',' CLRSRF

*/

class valueSnsetString_CLRSRF :
  public valueSnsetString
{
public:
  valueSnsetString_CLRSRF();
  ~valueSnsetString_CLRSRF();
  void printSelf();
};

/********************************************************************/

/* valueSnsetString_DEPTH

This is a derived class for one of the definitions of valueSnsetString.
It represents the following items:

SNSET ',' DEPTH

*/

class valueSnsetString_DEPTH :
  public valueSnsetString
{
public:
  valueSnsetString_DEPTH();
  ~valueSnsetString_DEPTH();
  void printSelf();
};

/********************************************************************/

/* valueSnslct

This is a class for the single definition of valueSnslct.
It represents the following items:

SNSLCT

*/

class valueSnslct :
  public valueMinorString
{
public:
  valueSnslct();
  ~valueSnslct();
  void printSelf();
};

/********************************************************************/

/* valueSnsmnt

This is a parent class.

*/

class valueSnsmnt :
  public valueMinorVector
{
public:
  valueSnsmnt();
  ~valueSnsmnt();
  void printSelf() = 0;
};

/********************************************************************/

/* valueSnsmnt_XVEC

This is a derived class for one of the definitions of valueSnsmnt.
It represents the following items:

SNSMNT ',' XVEC

*/

class valueSnsmnt_XVEC :
  public valueSnsmnt
{
public:
  valueSnsmnt_XVEC();
  ~valueSnsmnt_XVEC();
  void printSelf();
};

/********************************************************************/

/* valueSnsmnt_ZVEC

This is a derived class for one of the definitions of valueSnsmnt.
It represents the following items:

SNSMNT ',' ZVEC

*/

class valueSnsmnt_ZVEC :
  public valueSnsmnt
{
public:
  valueSnsmnt_ZVEC();
  ~valueSnsmnt_ZVEC();
  void printSelf();
};

/********************************************************************/

/* valueSnsmnt_MNTLEN

This is a derived class for one of the definitions of valueSnsmnt.
It represents the following items:

SNSMNT ',' MNTLEN

*/

class valueSnsmnt_MNTLEN :
  public valueSnsmnt
{
public:
  valueSnsmnt_MNTLEN();
  ~valueSnsmnt_MNTLEN();
  void printSelf();
};

/********************************************************************/

/* valueTecomp

This is a class for the single definition of valueTecomp.
It represents the following items:

TECOMP

*/

class valueTecomp :
  public valueMinorBool
{
public:
  valueTecomp();
  ~valueTecomp();
  void printSelf();
};

/********************************************************************/

/* valueUnits

This is a parent class.

*/

class valueUnits :
  public valueMinorString
{
public:
  valueUnits();
  ~valueUnits();
  void printSelf() = 0;
};

/********************************************************************/

/* valueUnits_DIST

This is a derived class for one of the definitions of valueUnits.
It represents the following items:

UNITS ',' DIST

*/

class valueUnits_DIST :
  public valueUnits
{
public:
  valueUnits_DIST();
  ~valueUnits_DIST();
  void printSelf();
};

/********************************************************************/

/* valueUnits_ANGL

This is a derived class for one of the definitions of valueUnits.
It represents the following items:

UNITS ',' ANGL

*/

class valueUnits_ANGL :
  public valueUnits
{
public:
  valueUnits_ANGL();
  ~valueUnits_ANGL();
  void printSelf();
};

/********************************************************************/

/* valueUnits_TEMP

This is a derived class for one of the definitions of valueUnits.
It represents the following items:

UNITS ',' TEMP

*/

class valueUnits_TEMP :
  public valueUnits
{
public:
  valueUnits_TEMP();
  ~valueUnits_TEMP();
  void printSelf();
};

/********************************************************************/

/* valueWkplan

This is a class for the single definition of valueWkplan.
It represents the following items:

WKPLAN

*/

class valueWkplan :
  public valueMinorString
{
public:
  valueWkplan();
  ~valueWkplan();
  void printSelf();
};

/********************************************************************/

/* valueFaInt

This is a class for the single definition of valueFaInt.
It represents the following items:

faLabel ',' PTDATA

*/

class valueFaInt :
  public valueMinorInt
{
public:
  valueFaInt();
  valueFaInt(
    faLabel * faLabelIn);
  ~valueFaInt();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  faLabel * a_faLabel;
};

/********************************************************************/

/* valueFaReal

This is a class for the single definition of valueFaReal.
It represents the following items:

faLabel ',' SIZE [',' intVal]

*/

class valueFaReal :
  public valueMinorReal
{
public:
  valueFaReal();
  valueFaReal(
    faLabel * faLabelIn,
    intVal * sizenumIn);
  ~valueFaReal();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
  intVal * get_sizenum();
  void set_sizenum(intVal * sizenumIn);
private:
  faLabel * a_faLabel;
  intVal * sizenum;
};

/********************************************************************/

/* valueRt

This is a parent class.

*/

class valueRt :
  public valueMinorReal
{
public:
  valueRt();
  ~valueRt();
  void printSelf() = 0;
};

/********************************************************************/

/* valueRt_CW

This is a derived class for one of the definitions of valueRt.
It represents the following items:

rtLabel ',' ANGL ',' CW

*/

class valueRt_CW :
  public valueRt
{
public:
  valueRt_CW();
  valueRt_CW(
    rtLabel * rtLabelIn);
  ~valueRt_CW();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
private:
  rtLabel * a_rtLabel;
};

/********************************************************************/

/* valueRt_CCW

This is a derived class for one of the definitions of valueRt.
It represents the following items:

rtLabel ',' ANGL ',' CCW

*/

class valueRt_CCW :
  public valueRt
{
public:
  valueRt_CCW();
  valueRt_CCW(
    rtLabel * rtLabelIn);
  ~valueRt_CCW();
  void printSelf();
  rtLabel * get_rtLabel();
  void set_rtLabel(rtLabel * rtLabelIn);
private:
  rtLabel * a_rtLabel;
};

/********************************************************************/

/* valueSa

This is a parent class.

*/

class valueSa :
  public valueMinorReal
{
public:
  valueSa();
  ~valueSa();
  void printSelf() = 0;
};

/********************************************************************/

/* valueSaPlain

This is a derived class for one of the definitions of valueSa.
It represents the following items:

saLabel

*/

class valueSaPlain :
  public valueSa
{
public:
  valueSaPlain();
  valueSaPlain(
    saLabel * saLabelIn);
  ~valueSaPlain();
  void printSelf();
  saLabel * get_saLabel();
  void set_saLabel(saLabel * saLabelIn);
private:
  saLabel * a_saLabel;
};

/********************************************************************/

/* valueSaDesc

This is a derived class for one of the definitions of valueSa.
It represents the following items:

saLabel ',' stringVal

*/

class valueSaDesc :
  public valueSa
{
public:
  valueSaDesc();
  valueSaDesc(
    saLabel * saLabelIn,
    stringVal * descIn);
  ~valueSaDesc();
  void printSelf();
  saLabel * get_saLabel();
  void set_saLabel(saLabel * saLabelIn);
  stringVal * get_desc();
  void set_desc(stringVal * descIn);
private:
  saLabel * a_saLabel;
  stringVal * desc;
};

/********************************************************************/

/* valueSaTipnum

This is a derived class for one of the definitions of valueSa.
It represents the following items:

saLabel ',' intVal

*/

class valueSaTipnum :
  public valueSa
{
public:
  valueSaTipnum();
  valueSaTipnum(
    saLabel * saLabelIn,
    intVal * tipnumIn);
  ~valueSaTipnum();
  void printSelf();
  saLabel * get_saLabel();
  void set_saLabel(saLabel * saLabelIn);
  intVal * get_tipnum();
  void set_tipnum(intVal * tipnumIn);
private:
  saLabel * a_saLabel;
  intVal * tipnum;
};

/********************************************************************/

/* valueSw

This is a class for the single definition of valueSw.
It represents the following items:

swLabel ',' ANGLE ',' stringVal

*/

class valueSw :
  public valueMinorReal
{
public:
  valueSw();
  valueSw(
    swLabel * swLabelIn,
    stringVal * anglenameIn);
  ~valueSw();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
private:
  swLabel * a_swLabel;
  stringVal * anglename;
};

/********************************************************************/

/* valueTaBool

This is a parent class.

*/

class valueTaBool :
  public valueMinorBool
{
public:
  valueTaBool();
  ~valueTaBool();
  void printSelf() = 0;
};

/********************************************************************/

/* valueTaBoolIntol

This is a derived class for one of the definitions of valueTaBool.
It represents the following items:

taLabel ',' INTOL [',' intVal]

*/

class valueTaBoolIntol :
  public valueTaBool
{
public:
  valueTaBoolIntol();
  valueTaBoolIntol(
    taLabel * taLabelIn,
    intVal * tolnumIn);
  ~valueTaBoolIntol();
  void printSelf();
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  intVal * get_tolnum();
  void set_tolnum(intVal * tolnumIn);
private:
  taLabel * a_taLabel;
  intVal * tolnum;
};

/********************************************************************/

/* valueTaBoolOutol

This is a derived class for one of the definitions of valueTaBool.
It represents the following items:

taLabel ',' OUTOL [',' intVal]

*/

class valueTaBoolOutol :
  public valueTaBool
{
public:
  valueTaBoolOutol();
  valueTaBoolOutol(
    taLabel * taLabelIn,
    intVal * tolnumIn);
  ~valueTaBoolOutol();
  void printSelf();
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  intVal * get_tolnum();
  void set_tolnum(intVal * tolnumIn);
private:
  taLabel * a_taLabel;
  intVal * tolnum;
};

/********************************************************************/

/* valueTaReal

This is a parent class.

*/

class valueTaReal :
  public valueMinorReal
{
public:
  valueTaReal();
  ~valueTaReal();
  void printSelf() = 0;
};

/********************************************************************/

/* valueTaRealAct

This is a derived class for one of the definitions of valueTaReal.
It represents the following items:

taLabel ',' ACT [',' intVal]

*/

class valueTaRealAct :
  public valueTaReal
{
public:
  valueTaRealAct();
  valueTaRealAct(
    taLabel * taLabelIn,
    intVal * tolnumIn);
  ~valueTaRealAct();
  void printSelf();
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  intVal * get_tolnum();
  void set_tolnum(intVal * tolnumIn);
private:
  taLabel * a_taLabel;
  intVal * tolnum;
};

/********************************************************************/

/* valueTaRealDev

This is a derived class for one of the definitions of valueTaReal.
It represents the following items:

taLabel ',' DEV [',' intVal]

*/

class valueTaRealDev :
  public valueTaReal
{
public:
  valueTaRealDev();
  valueTaRealDev(
    taLabel * taLabelIn,
    intVal * tolnumIn);
  ~valueTaRealDev();
  void printSelf();
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  intVal * get_tolnum();
  void set_tolnum(intVal * tolnumIn);
private:
  taLabel * a_taLabel;
  intVal * tolnum;
};

/********************************************************************/

/* valueTaRealAmt

This is a derived class for one of the definitions of valueTaReal.
It represents the following items:

taLabel ',' AMT [',' intVal]

*/

class valueTaRealAmt :
  public valueTaReal
{
public:
  valueTaRealAmt();
  valueTaRealAmt(
    taLabel * taLabelIn,
    intVal * tolnumIn);
  ~valueTaRealAmt();
  void printSelf();
  taLabel * get_taLabel();
  void set_taLabel(taLabel * taLabelIn);
  intVal * get_tolnum();
  void set_tolnum(intVal * tolnumIn);
private:
  taLabel * a_taLabel;
  intVal * tolnum;
};

/********************************************************************/

/* vformStm

This is a class for the single definition of vformStm.
It represents the following items:

vLabel '=' VFORM '/' vformItemList #

*/

class vformStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  vformStm();
  vformStm(
    vLabel * vLabelIn,
    std::list<vformItem *> * vformItemListIn);
  ~vformStm();
  void printSelf();
  vLabel * get_vLabel();
  void set_vLabel(vLabel * vLabelIn);
  std::list<vformItem *> * get_vformItemList();
  void set_vformItemList(std::list<vformItem *> * vformItemListIn);
private:
  vLabel * a_vLabel;
  std::list<vformItem *> * a_vformItemList;
};

/********************************************************************/

/* vformItem

This is a parent class.

*/

class vformItem :
  public dmisCppBase
{
public:
  vformItem();
  ~vformItem();
  void printSelf() = 0;
};

/********************************************************************/

/* vformItem_NOM

This is a derived class for one of the definitions of vformItem.
It represents the following items:

NOM [',' stringVal]

*/

class vformItem_NOM :
  public vformItem
{
public:
  vformItem_NOM();
  vformItem_NOM(
    stringVal * textIn);
  ~vformItem_NOM();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* vformItem_ACT

This is a derived class for one of the definitions of vformItem.
It represents the following items:

ACT [',' stringVal]

*/

class vformItem_ACT :
  public vformItem
{
public:
  vformItem_ACT();
  vformItem_ACT(
    stringVal * textIn);
  ~vformItem_ACT();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* vformItem_DEV

This is a derived class for one of the definitions of vformItem.
It represents the following items:

DEV [',' stringVal]

*/

class vformItem_DEV :
  public vformItem
{
public:
  vformItem_DEV();
  vformItem_DEV(
    stringVal * textIn);
  ~vformItem_DEV();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* vformItem_AMT

This is a derived class for one of the definitions of vformItem.
It represents the following items:

AMT [',' stringVal]

*/

class vformItem_AMT :
  public vformItem
{
public:
  vformItem_AMT();
  vformItem_AMT(
    stringVal * textIn);
  ~vformItem_AMT();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* vformItem_HIST

This is a derived class for one of the definitions of vformItem.
It represents the following items:

HIST [',' stringVal]

*/

class vformItem_HIST :
  public vformItem
{
public:
  vformItem_HIST();
  vformItem_HIST(
    stringVal * textIn);
  ~vformItem_HIST();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* vformItem_PLOT

This is a derived class for one of the definitions of vformItem.
It represents the following items:

PLOT [',' stringVal]

*/

class vformItem_PLOT :
  public vformItem
{
public:
  vformItem_PLOT();
  vformItem_PLOT(
    stringVal * textIn);
  ~vformItem_PLOT();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* vformItem_STAT

This is a derived class for one of the definitions of vformItem.
It represents the following items:

STAT [',' stringVal]

*/

class vformItem_STAT :
  public vformItem
{
public:
  vformItem_STAT();
  vformItem_STAT(
    stringVal * textIn);
  ~vformItem_STAT();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* vformItem_ALL

This is a derived class for one of the definitions of vformItem.
It represents the following items:

ALL

*/

class vformItem_ALL :
  public vformItem
{
public:
  vformItem_ALL();
  ~vformItem_ALL();
  void printSelf();
};

/********************************************************************/

/* vformItem_DME

This is a derived class for one of the definitions of vformItem.
It represents the following items:

DME [',' stringVal]

*/

class vformItem_DME :
  public vformItem
{
public:
  vformItem_DME();
  vformItem_DME(
    stringVal * textIn);
  ~vformItem_DME();
  void printSelf();
  stringVal * get_text();
  void set_text(stringVal * textIn);
private:
  stringVal * text;
};

/********************************************************************/

/* windefStm

This is a class for the single definition of windefStm.
It represents the following items:

vwLabel '=' WINDEF '/' windefMinor #

*/

class windefStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  windefStm();
  windefStm(
    vwLabel * vwLabelIn,
    windefMinor * windefMinorIn);
  ~windefStm();
  void printSelf();
  vwLabel * get_vwLabel();
  void set_vwLabel(vwLabel * vwLabelIn);
  windefMinor * get_windefMinor();
  void set_windefMinor(windefMinor * windefMinorIn);
private:
  vwLabel * a_vwLabel;
  windefMinor * a_windefMinor;
};

/********************************************************************/

/* windefMinor

This is a parent class.

*/

class windefMinor :
  public dmisCppBase
{
public:
  windefMinor();
  ~windefMinor();
  void printSelf() = 0;
};

/********************************************************************/

/* windefEdgeln

This is a class for the single definition of windefEdgeln.
It represents the following items:

EDGELN ',' impCartPoint ',' angle ',' rentVal

*/

class windefEdgeln :
  public windefMinor
{
public:
  windefEdgeln();
  windefEdgeln(
    impCartPoint * impCartPointIn,
    angle * angleIn,
    rentVal * lenIn);
  ~windefEdgeln();
  void printSelf();
  impCartPoint * get_impCartPoint();
  void set_impCartPoint(impCartPoint * impCartPointIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
  rentVal * get_len();
  void set_len(rentVal * lenIn);
private:
  impCartPoint * a_impCartPoint;
  angle * a_angle;
  rentVal * len;
};

/********************************************************************/

/* windefBox

This is a class for the single definition of windefBox.
It represents the following items:

BOX ',' impCartPoint ',' rentVal ',' rentVal ',' angle

*/

class windefBox :
  public windefMinor
{
public:
  windefBox();
  windefBox(
    impCartPoint * impCartPointIn,
    rentVal * dxIn,
    rentVal * dyIn,
    angle * angleIn);
  ~windefBox();
  void printSelf();
  impCartPoint * get_impCartPoint();
  void set_impCartPoint(impCartPoint * impCartPointIn);
  rentVal * get_dx();
  void set_dx(rentVal * dxIn);
  rentVal * get_dy();
  void set_dy(rentVal * dyIn);
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  impCartPoint * a_impCartPoint;
  rentVal * dx;
  rentVal * dy;
  angle * a_angle;
};

/********************************************************************/

/* wristStm

This is a class for the single definition of wristStm.
It represents the following items:

swLabel '=' WRIST '/' wristList ',' wristMountOffset [',' wristDataDesc] #

*/

class wristStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  wristStm();
  wristStm(
    swLabel * swLabelIn,
    std::list<wristDef *> * wristListIn,
    wristMountOffset * wristMountOffsetIn,
    wristDataDesc * wristDataDescIn);
  ~wristStm();
  void printSelf();
  swLabel * get_swLabel();
  void set_swLabel(swLabel * swLabelIn);
  std::list<wristDef *> * get_wristList();
  void set_wristList(std::list<wristDef *> * wristListIn);
  wristMountOffset * get_wristMountOffset();
  void set_wristMountOffset(wristMountOffset * wristMountOffsetIn);
  wristDataDesc * get_wristDataDesc();
  void set_wristDataDesc(wristDataDesc * wristDataDescIn);
private:
  swLabel * a_swLabel;
  std::list<wristDef *> * a_wristList;
  wristMountOffset * a_wristMountOffset;
  wristDataDesc * a_wristDataDesc;
};

/********************************************************************/

/* wristDef

This is a class for the single definition of wristDef.
It represents the following items:

wristMountDef ',' wristRotDef

*/

class wristDef :
  public dmisCppBase
{
public:
  wristDef();
  wristDef(
    wristMountDef * wristMountDefIn,
    wristRotDef * wristRotDefIn);
  ~wristDef();
  void printSelf();
  wristMountDef * get_wristMountDef();
  void set_wristMountDef(wristMountDef * wristMountDefIn);
  wristRotDef * get_wristRotDef();
  void set_wristRotDef(wristRotDef * wristRotDefIn);
private:
  wristMountDef * a_wristMountDef;
  wristRotDef * a_wristRotDef;
};

/********************************************************************/

/* wristMountDef

This is a class for the single definition of wristMountDef.
It represents the following items:

ROTCEN ',' vector ',' vector ',' vector

*/

class wristMountDef :
  public dmisCppBase
{
public:
  wristMountDef();
  wristMountDef(
    vector * offsetIn,
    vector * axisVecIn,
    vector * zeroVecIn);
  ~wristMountDef();
  void printSelf();
  vector * get_offset();
  void set_offset(vector * offsetIn);
  vector * get_axisVec();
  void set_axisVec(vector * axisVecIn);
  vector * get_zeroVec();
  void set_zeroVec(vector * zeroVecIn);
private:
  vector * offset;
  vector * axisVec;
  vector * zeroVec;
};

/********************************************************************/

/* wristRotDef

This is a class for the single definition of wristRotDef.
It represents the following items:

ANGLE ',' stringVal ',' wristRotLimit ',' wristRotStep

*/

class wristRotDef :
  public dmisCppBase
{
public:
  wristRotDef();
  wristRotDef(
    stringVal * anglenameIn,
    wristRotLimit * wristRotLimitIn,
    wristRotStep * wristRotStepIn);
  ~wristRotDef();
  void printSelf();
  stringVal * get_anglename();
  void set_anglename(stringVal * anglenameIn);
  wristRotLimit * get_wristRotLimit();
  void set_wristRotLimit(wristRotLimit * wristRotLimitIn);
  wristRotStep * get_wristRotStep();
  void set_wristRotStep(wristRotStep * wristRotStepIn);
private:
  stringVal * anglename;
  wristRotLimit * a_wristRotLimit;
  wristRotStep * a_wristRotStep;
};

/********************************************************************/

/* wristRotLimit

This is a parent class.

*/

class wristRotLimit :
  public dmisCppBase
{
public:
  wristRotLimit();
  ~wristRotLimit();
  void printSelf() = 0;
};

/********************************************************************/

/* wristRotLimit_angle

This is a derived class for one of the definitions of wristRotLimit.
It represents the following items:

angle ',' angle

*/

class wristRotLimit_angle :
  public wristRotLimit
{
public:
  wristRotLimit_angle();
  wristRotLimit_angle(
    angle * beginIn,
    angle * endIn);
  ~wristRotLimit_angle();
  void printSelf();
  angle * get_begin();
  void set_begin(angle * beginIn);
  angle * get_end();
  void set_end(angle * endIn);
private:
  angle * begin;
  angle * end;
};

/********************************************************************/

/* wristRotLimit_THRU

This is a derived class for one of the definitions of wristRotLimit.
It represents the following items:

THRU

*/

class wristRotLimit_THRU :
  public wristRotLimit
{
public:
  wristRotLimit_THRU();
  ~wristRotLimit_THRU();
  void printSelf();
};

/********************************************************************/

/* wristRotStep

This is a parent class.

*/

class wristRotStep :
  public dmisCppBase
{
public:
  wristRotStep();
  ~wristRotStep();
  void printSelf() = 0;
};

/********************************************************************/

/* wristRotStep_angle

This is a derived class for one of the definitions of wristRotStep.
It represents the following items:

angle

*/

class wristRotStep_angle :
  public wristRotStep
{
public:
  wristRotStep_angle();
  wristRotStep_angle(
    angle * angleIn);
  ~wristRotStep_angle();
  void printSelf();
  angle * get_angle();
  void set_angle(angle * angleIn);
private:
  angle * a_angle;
};

/********************************************************************/

/* wristRotStep_CONTIN

This is a derived class for one of the definitions of wristRotStep.
It represents the following items:

CONTIN

*/

class wristRotStep_CONTIN :
  public wristRotStep
{
public:
  wristRotStep_CONTIN();
  ~wristRotStep_CONTIN();
  void printSelf();
};

/********************************************************************/

/* wristMountOffset

This is a class for the single definition of wristMountOffset.
It represents the following items:

MNTLEN ',' vector

*/

class wristMountOffset :
  public dmisCppBase
{
public:
  wristMountOffset();
  wristMountOffset(
    vector * offsetIn);
  ~wristMountOffset();
  void printSelf();
  vector * get_offset();
  void set_offset(vector * offsetIn);
private:
  vector * offset;
};

/********************************************************************/

/* wristDataDesc

This is a parent class.

*/

class wristDataDesc :
  public dmisCppBase
{
public:
  wristDataDesc();
  ~wristDataDesc();
  void printSelf() = 0;
};

/********************************************************************/

/* wristDataDesc_stringVal

This is a derived class for one of the definitions of wristDataDesc.
It represents the following items:

stringVal ',' stringVal ',' stringVal

*/

class wristDataDesc_stringVal :
  public wristDataDesc
{
public:
  wristDataDesc_stringVal();
  wristDataDesc_stringVal(
    stringVal * dataStorIn,
    stringVal * dataListIn,
    stringVal * dataItemIn);
  ~wristDataDesc_stringVal();
  void printSelf();
  stringVal * get_dataStor();
  void set_dataStor(stringVal * dataStorIn);
  stringVal * get_dataList();
  void set_dataList(stringVal * dataListIn);
  stringVal * get_dataItem();
  void set_dataItem(stringVal * dataItemIn);
private:
  stringVal * dataStor;
  stringVal * dataList;
  stringVal * dataItem;
};

/********************************************************************/

/* wristDataDesc_intVal

This is a derived class for one of the definitions of wristDataDesc.
It represents the following items:

stringVal ',' stringVal ',' intVal

*/

class wristDataDesc_intVal :
  public wristDataDesc
{
public:
  wristDataDesc_intVal();
  wristDataDesc_intVal(
    stringVal * dataStorIn,
    stringVal * dataListIn,
    intVal * indexIn);
  ~wristDataDesc_intVal();
  void printSelf();
  stringVal * get_dataStor();
  void set_dataStor(stringVal * dataStorIn);
  stringVal * get_dataList();
  void set_dataList(stringVal * dataListIn);
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  stringVal * dataStor;
  stringVal * dataList;
  intVal * index;
};

/********************************************************************/

/* writeStm

This is a class for the single definition of writeStm.
It represents the following items:

WRITE '/' didLabel ',' writeSpecList #

*/

class writeStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  writeStm();
  writeStm(
    didLabel * didLabelIn,
    std::list<writeSpec *> * writeSpecListIn);
  ~writeStm();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
  std::list<writeSpec *> * get_writeSpecList();
  void set_writeSpecList(std::list<writeSpec *> * writeSpecListIn);
private:
  didLabel * a_didLabel;
  std::list<writeSpec *> * a_writeSpecList;
};

/********************************************************************/

/* writeSpec

This is a parent class.

*/

class writeSpec :
  public dmisCppBase
{
public:
  writeSpec();
  ~writeSpec();
  void printSelf() = 0;
};

/********************************************************************/

/* writeSpec_stringConst

This is a derived class for one of the definitions of writeSpec.
It represents the following items:

stringConst

*/

class writeSpec_stringConst :
  public writeSpec
{
public:
  writeSpec_stringConst();
  writeSpec_stringConst(
    stringConst * stringConstIn);
  ~writeSpec_stringConst();
  void printSelf();
  stringConst * get_stringConst();
  void set_stringConst(stringConst * stringConstIn);
private:
  stringConst * a_stringConst;
};

/********************************************************************/

/* writeSpec_stringFunc

This is a derived class for one of the definitions of writeSpec.
It represents the following items:

stringFunc

*/

class writeSpec_stringFunc :
  public writeSpec
{
public:
  writeSpec_stringFunc();
  writeSpec_stringFunc(
    stringFunc * stringFuncIn);
  ~writeSpec_stringFunc();
  void printSelf();
  stringFunc * get_stringFunc();
  void set_stringFunc(stringFunc * stringFuncIn);
private:
  stringFunc * a_stringFunc;
};

/********************************************************************/

/* writeSpec_rwVar

This is a derived class for one of the definitions of writeSpec.
It represents the following items:

rwVar [rwFormat]

*/

class writeSpec_rwVar :
  public writeSpec
{
public:
  writeSpec_rwVar();
  writeSpec_rwVar(
    rwVar * rwVarIn,
    rwFormat * rwFormatIn);
  ~writeSpec_rwVar();
  void printSelf();
  rwVar * get_rwVar();
  void set_rwVar(rwVar * rwVarIn);
  rwFormat * get_rwFormat();
  void set_rwFormat(rwFormat * rwFormatIn);
private:
  rwVar * a_rwVar;
  rwFormat * a_rwFormat;
};

/********************************************************************/

/* xternStm

This is a class for the single definition of xternStm.
It represents the following items:

XTERN #

*/

class xternStm :
  public dmisStatement
{
public:
  xternStm();
  ~xternStm();
  void printSelf();
};

/********************************************************************/

/* xtractStm

This is a class for the single definition of xtractStm.
It represents the following items:

XTRACT '/' fLabel ',' faLabel #

*/

class xtractStm :
  public dmisFreeStatement,
  public dmisStatement
{
public:
  xtractStm();
  xtractStm(
    fLabel * fLabelIn,
    faLabel * faLabelIn);
  ~xtractStm();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  fLabel * a_fLabel;
  faLabel * a_faLabel;
};

/********************************************************************/

/* measBlockStatement

This is a parent class.

*/

class measBlockStatement :
  public measBlockItem
{
public:
  measBlockStatement();
  ~measBlockStatement();
  void printSelf() = 0;
};

/********************************************************************/

/* anyVal

This is a parent class.

*/

class anyVal :
  public param
{
public:
  anyVal();
  ~anyVal();
  void printSelf() = 0;
};

/********************************************************************/

/* stringVal

This is a parent class.

*/

class stringVal :
  public anyVal,
  public snslctTipData
{
public:
  stringVal();
  ~stringVal();
  void printSelf() = 0;
};

/********************************************************************/

/* boolVal

This is a parent class.

*/

class boolVal :
  public anyVal
{
public:
  boolVal();
  ~boolVal();
  void printSelf() = 0;
};

/********************************************************************/

/* rentVal

This is a parent class.

*/

class rentVal :
  public anyVal,
  public angle
{
public:
  rentVal();
  ~rentVal();
  void printSelf() = 0;
};

/********************************************************************/

/* vectorVal

This is a parent class.

*/

class vectorVal :
  public anyVal
{
public:
  vectorVal();
  ~vectorVal();
  void printSelf() = 0;
};

/********************************************************************/

/* stringConst

This is a class for the single definition of stringConst.
It represents the following items:

CHARSTRING

*/

class stringConst :
  public stringVal
{
public:
  stringConst();
  stringConst(
    char * stringIn);
  ~stringConst();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
private:
  char * a_string;
};

/********************************************************************/

/* boolConst

This is a parent class.

*/

class boolConst :
  public boolVal
{
public:
  boolConst();
  ~boolConst();
  void printSelf() = 0;
};

/********************************************************************/

/* boolConst_TRUE

This is a derived class for one of the definitions of boolConst.
It represents the following items:

TRUE

*/

class boolConst_TRUE :
  public boolConst
{
public:
  boolConst_TRUE();
  ~boolConst_TRUE();
  void printSelf();
};

/********************************************************************/

/* boolConst_FALSE

This is a derived class for one of the definitions of boolConst.
It represents the following items:

FALSE

*/

class boolConst_FALSE :
  public boolConst
{
public:
  boolConst_FALSE();
  ~boolConst_FALSE();
  void printSelf();
};

/********************************************************************/

/* stringFunc

This is a parent class.

*/

class stringFunc :
  public stringVal
{
public:
  stringFunc();
  ~stringFunc();
  void printSelf() = 0;
};

/********************************************************************/

/* boolFunc

This is a parent class.

*/

class boolFunc :
  public boolVal
{
public:
  boolFunc();
  ~boolFunc();
  void printSelf() = 0;
};

/********************************************************************/

/* vectorFunc

This is a parent class.

*/

class vectorFunc :
  public vectorVal
{
public:
  vectorFunc();
  ~vectorFunc();
  void printSelf() = 0;
};

/********************************************************************/

/* boolExpr

This is a parent class.

*/

class boolExpr :
  public boolVal
{
public:
  boolExpr();
  ~boolExpr();
  void printSelf() = 0;
};

/********************************************************************/

/* boolExpr_PAREN

This is a derived class for one of the definitions of boolExpr.
It represents the following items:

'(' boolVal ')'

*/

class boolExpr_PAREN :
  public boolExpr
{
public:
  boolExpr_PAREN();
  boolExpr_PAREN(
    boolVal * boolValIn);
  ~boolExpr_PAREN();
  void printSelf();
  boolVal * get_boolVal();
  void set_boolVal(boolVal * boolValIn);
private:
  boolVal * a_boolVal;
};

/********************************************************************/

/* boolExpr_stringRel

This is a derived class for one of the definitions of boolExpr.
It represents the following items:

stringRel

*/

class boolExpr_stringRel :
  public boolExpr
{
public:
  boolExpr_stringRel();
  boolExpr_stringRel(
    stringRel * stringRelIn);
  ~boolExpr_stringRel();
  void printSelf();
  stringRel * get_stringRel();
  void set_stringRel(stringRel * stringRelIn);
private:
  stringRel * a_stringRel;
};

/********************************************************************/

/* boolExpr_boolRel

This is a derived class for one of the definitions of boolExpr.
It represents the following items:

boolRel

*/

class boolExpr_boolRel :
  public boolExpr
{
public:
  boolExpr_boolRel();
  boolExpr_boolRel(
    boolRel * boolRelIn);
  ~boolExpr_boolRel();
  void printSelf();
  boolRel * get_boolRel();
  void set_boolRel(boolRel * boolRelIn);
private:
  boolRel * a_boolRel;
};

/********************************************************************/

/* boolExpr_intRel

This is a derived class for one of the definitions of boolExpr.
It represents the following items:

intRel

*/

class boolExpr_intRel :
  public boolExpr
{
public:
  boolExpr_intRel();
  boolExpr_intRel(
    intRel * intRelIn);
  ~boolExpr_intRel();
  void printSelf();
  intRel * get_intRel();
  void set_intRel(intRel * intRelIn);
private:
  intRel * a_intRel;
};

/********************************************************************/

/* boolExpr_realRel

This is a derived class for one of the definitions of boolExpr.
It represents the following items:

realRel

*/

class boolExpr_realRel :
  public boolExpr
{
public:
  boolExpr_realRel();
  boolExpr_realRel(
    realRel * realRelIn);
  ~boolExpr_realRel();
  void printSelf();
  realRel * get_realRel();
  void set_realRel(realRel * realRelIn);
private:
  realRel * a_realRel;
};

/********************************************************************/

/* boolExpr_vectorRel

This is a derived class for one of the definitions of boolExpr.
It represents the following items:

vectorRel

*/

class boolExpr_vectorRel :
  public boolExpr
{
public:
  boolExpr_vectorRel();
  boolExpr_vectorRel(
    vectorRel * vectorRelIn);
  ~boolExpr_vectorRel();
  void printSelf();
  vectorRel * get_vectorRel();
  void set_vectorRel(vectorRel * vectorRelIn);
private:
  vectorRel * a_vectorRel;
};

/********************************************************************/

/* vectorExpr

This is a parent class.

*/

class vectorExpr :
  public vectorVal
{
public:
  vectorExpr();
  ~vectorExpr();
  void printSelf() = 0;
};

/********************************************************************/

/* vecExpr_PAREN

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

'(' vectorVal ')'

*/

class vecExpr_PAREN :
  public vectorExpr
{
public:
  vecExpr_PAREN();
  vecExpr_PAREN(
    vectorVal * vectorValIn);
  ~vecExpr_PAREN();
  void printSelf();
  vectorVal * get_vectorVal();
  void set_vectorVal(vectorVal * vectorValIn);
private:
  vectorVal * a_vectorVal;
};

/********************************************************************/

/* vecExpr_PLUS

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

vectorVal '+' vectorVal

*/

class vecExpr_PLUS :
  public vectorExpr
{
public:
  vecExpr_PLUS();
  vecExpr_PLUS(
    vectorVal * term1In,
    vectorVal * term2In);
  ~vecExpr_PLUS();
  void printSelf();
  vectorVal * get_term1();
  void set_term1(vectorVal * term1In);
  vectorVal * get_term2();
  void set_term2(vectorVal * term2In);
private:
  vectorVal * term1;
  vectorVal * term2;
};

/********************************************************************/

/* vecExpr_MINUS

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

vectorVal '-' vectorVal

*/

class vecExpr_MINUS :
  public vectorExpr
{
public:
  vecExpr_MINUS();
  vecExpr_MINUS(
    vectorVal * term1In,
    vectorVal * term2In);
  ~vecExpr_MINUS();
  void printSelf();
  vectorVal * get_term1();
  void set_term1(vectorVal * term1In);
  vectorVal * get_term2();
  void set_term2(vectorVal * term2In);
private:
  vectorVal * term1;
  vectorVal * term2;
};

/********************************************************************/

/* vecRealExpr_DIVID

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

vectorVal '/' realVal

*/

class vecRealExpr_DIVID :
  public vectorExpr
{
public:
  vecRealExpr_DIVID();
  vecRealExpr_DIVID(
    vectorVal * dvendIn,
    realVal * dvisrIn);
  ~vecRealExpr_DIVID();
  void printSelf();
  vectorVal * get_dvend();
  void set_dvend(vectorVal * dvendIn);
  realVal * get_dvisr();
  void set_dvisr(realVal * dvisrIn);
private:
  vectorVal * dvend;
  realVal * dvisr;
};

/********************************************************************/

/* vecIntExpr_DIVID

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

vectorVal '/' intVal

*/

class vecIntExpr_DIVID :
  public vectorExpr
{
public:
  vecIntExpr_DIVID();
  vecIntExpr_DIVID(
    vectorVal * dvendIn,
    intVal * dvisrIn);
  ~vecIntExpr_DIVID();
  void printSelf();
  vectorVal * get_dvend();
  void set_dvend(vectorVal * dvendIn);
  intVal * get_dvisr();
  void set_dvisr(intVal * dvisrIn);
private:
  vectorVal * dvend;
  intVal * dvisr;
};

/********************************************************************/

/* vecRealExpr_TIMES

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

vectorVal '*' realVal

*/

class vecRealExpr_TIMES :
  public vectorExpr
{
public:
  vecRealExpr_TIMES();
  vecRealExpr_TIMES(
    vectorVal * term1In,
    realVal * term2In);
  ~vecRealExpr_TIMES();
  void printSelf();
  vectorVal * get_term1();
  void set_term1(vectorVal * term1In);
  realVal * get_term2();
  void set_term2(realVal * term2In);
private:
  vectorVal * term1;
  realVal * term2;
};

/********************************************************************/

/* realVecExpr_TIMES

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

realVal '*' vectorVal

*/

class realVecExpr_TIMES :
  public vectorExpr
{
public:
  realVecExpr_TIMES();
  realVecExpr_TIMES(
    realVal * term1In,
    vectorVal * term2In);
  ~realVecExpr_TIMES();
  void printSelf();
  realVal * get_term1();
  void set_term1(realVal * term1In);
  vectorVal * get_term2();
  void set_term2(vectorVal * term2In);
private:
  realVal * term1;
  vectorVal * term2;
};

/********************************************************************/

/* vecIntExpr_TIMES

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

vectorVal '*' intVal

*/

class vecIntExpr_TIMES :
  public vectorExpr
{
public:
  vecIntExpr_TIMES();
  vecIntExpr_TIMES(
    vectorVal * term1In,
    intVal * term2In);
  ~vecIntExpr_TIMES();
  void printSelf();
  vectorVal * get_term1();
  void set_term1(vectorVal * term1In);
  intVal * get_term2();
  void set_term2(intVal * term2In);
private:
  vectorVal * term1;
  intVal * term2;
};

/********************************************************************/

/* intVecExpr_TIMES

This is a derived class for one of the definitions of vectorExpr.
It represents the following items:

intVal '*' vectorVal

*/

class intVecExpr_TIMES :
  public vectorExpr
{
public:
  intVecExpr_TIMES();
  intVecExpr_TIMES(
    intVal * term1In,
    vectorVal * term2In);
  ~intVecExpr_TIMES();
  void printSelf();
  intVal * get_term1();
  void set_term1(intVal * term1In);
  vectorVal * get_term2();
  void set_term2(vectorVal * term2In);
private:
  intVal * term1;
  vectorVal * term2;
};

/********************************************************************/

/* boolVar

This is a class for the single definition of boolVar.
It represents the following items:

BOOLVARNAME [arrayIndex]

*/

class boolVar :
  public boolVal,
  public rwVar,
  public promptVar
{
public:
  boolVar();
  boolVar(
    char * stringIn,
    arrayIndex * arrayIndexIn);
  ~boolVar();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
  arrayIndex * get_arrayIndex();
  void set_arrayIndex(arrayIndex * arrayIndexIn);
private:
  char * a_string;
  arrayIndex * a_arrayIndex;
};

/********************************************************************/

/* stringVar

This is a class for the single definition of stringVar.
It represents the following items:

STRINGVARNAME [arrayIndex]

*/

class stringVar :
  public stringVal,
  public rwVar,
  public promptVar
{
public:
  stringVar();
  stringVar(
    char * stringIn,
    arrayIndex * arrayIndexIn);
  ~stringVar();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
  arrayIndex * get_arrayIndex();
  void set_arrayIndex(arrayIndex * arrayIndexIn);
private:
  char * a_string;
  arrayIndex * a_arrayIndex;
};

/********************************************************************/

/* vectorVar

This is a class for the single definition of vectorVar.
It represents the following items:

VECTORVARNAME [arrayIndex]

*/

class vectorVar :
  public vectorVal,
  public rwVar
{
public:
  vectorVar();
  vectorVar(
    char * stringIn,
    arrayIndex * arrayIndexIn);
  ~vectorVar();
  void printSelf();
  char * get_string();
  void set_string(char * stringIn);
  arrayIndex * get_arrayIndex();
  void set_arrayIndex(arrayIndex * arrayIndexIn);
private:
  char * a_string;
  arrayIndex * a_arrayIndex;
};

/********************************************************************/

/* stringFuncChr

This is a class for the single definition of stringFuncChr.
It represents the following items:

CHR '(' intVal ')'

*/

class stringFuncChr :
  public stringFunc
{
public:
  stringFuncChr();
  stringFuncChr(
    intVal * indexIn);
  ~stringFuncChr();
  void printSelf();
  intVal * get_index();
  void set_index(intVal * indexIn);
private:
  intVal * index;
};

/********************************************************************/

/* stringFuncConcat

This is a class for the single definition of stringFuncConcat.
It represents the following items:

CONCAT '(' stringVal ',' stringList ')'

*/

class stringFuncConcat :
  public stringFunc
{
public:
  stringFuncConcat();
  stringFuncConcat(
    stringVal * str1In,
    std::list<stringVal *> * moreStrsIn);
  ~stringFuncConcat();
  void printSelf();
  stringVal * get_str1();
  void set_str1(stringVal * str1In);
  std::list<stringVal *> * get_moreStrs();
  void set_moreStrs(std::list<stringVal *> * moreStrsIn);
private:
  stringVal * str1;
  std::list<stringVal *> * moreStrs;
};

/********************************************************************/

/* stringFuncElemnt

This is a class for the single definition of stringFuncElemnt.
It represents the following items:

ELEMNT '(' intVal ',' stringVal ',' stringVal ')'

*/

class stringFuncElemnt :
  public stringFunc
{
public:
  stringFuncElemnt();
  stringFuncElemnt(
    intVal * indexIn,
    stringVal * delimIn,
    stringVal * stringsIn);
  ~stringFuncElemnt();
  void printSelf();
  intVal * get_index();
  void set_index(intVal * indexIn);
  stringVal * get_delim();
  void set_delim(stringVal * delimIn);
  stringVal * get_strings();
  void set_strings(stringVal * stringsIn);
private:
  intVal * index;
  stringVal * delim;
  stringVal * strings;
};

/********************************************************************/

/* stringFuncScfeat

This is a class for the single definition of stringFuncScfeat.
It represents the following items:

SCFEAT '(' ')'

*/

class stringFuncScfeat :
  public stringFunc
{
public:
  stringFuncScfeat();
  ~stringFuncScfeat();
  void printSelf();
};

/********************************************************************/

/* stringFuncScsns

This is a class for the single definition of stringFuncScsns.
It represents the following items:

SCSNS '(' ')'

*/

class stringFuncScsns :
  public stringFunc
{
public:
  stringFuncScsns();
  ~stringFuncScsns();
  void printSelf();
};

/********************************************************************/

/* stringFuncSdate

This is a class for the single definition of stringFuncSdate.
It represents the following items:

SDATE '(' ')'

*/

class stringFuncSdate :
  public stringFunc
{
public:
  stringFuncSdate();
  ~stringFuncSdate();
  void printSelf();
};

/********************************************************************/

/* stringFuncSerror

This is a class for the single definition of stringFuncSerror.
It represents the following items:

SERROR '(' ')'

*/

class stringFuncSerror :
  public stringFunc
{
public:
  stringFuncSerror();
  ~stringFuncSerror();
  void printSelf();
};

/********************************************************************/

/* stringFuncSmode

This is a class for the single definition of stringFuncSmode.
It represents the following items:

SMODE '(' ')'

*/

class stringFuncSmode :
  public stringFunc
{
public:
  stringFuncSmode();
  ~stringFuncSmode();
  void printSelf();
};

/********************************************************************/

/* stringFuncStime

This is a class for the single definition of stringFuncStime.
It represents the following items:

STIME '(' ')'

*/

class stringFuncStime :
  public stringFunc
{
public:
  stringFuncStime();
  ~stringFuncStime();
  void printSelf();
};

/********************************************************************/

/* stringFuncSdatetime

This is a class for the single definition of stringFuncSdatetime.
It represents the following items:

SDATETIME '(' ')'

*/

class stringFuncSdatetime :
  public stringFunc
{
public:
  stringFuncSdatetime();
  ~stringFuncSdatetime();
  void printSelf();
};

/********************************************************************/

/* stringFuncRpt

This is a class for the single definition of stringFuncRpt.
It represents the following items:

RPT '(' stringVal ',' intVal ')'

*/

class stringFuncRpt :
  public stringFunc
{
public:
  stringFuncRpt();
  stringFuncRpt(
    stringVal * strIn,
    intVal * repsIn);
  ~stringFuncRpt();
  void printSelf();
  stringVal * get_str();
  void set_str(stringVal * strIn);
  intVal * get_reps();
  void set_reps(intVal * repsIn);
private:
  stringVal * str;
  intVal * reps;
};

/********************************************************************/

/* stringFuncSelapsetime

This is a class for the single definition of stringFuncSelapsetime.
It represents the following items:

SELAPSETIME '(' stringVal ',' stringVal ',' longShort ')'

*/

class stringFuncSelapsetime :
  public stringFunc
{
public:
  stringFuncSelapsetime();
  stringFuncSelapsetime(
    stringVal * startIn,
    stringVal * stopIn,
    longShort * longShortIn);
  ~stringFuncSelapsetime();
  void printSelf();
  stringVal * get_start();
  void set_start(stringVal * startIn);
  stringVal * get_stop();
  void set_stop(stringVal * stopIn);
  longShort * get_longShort();
  void set_longShort(longShort * longShortIn);
private:
  stringVal * start;
  stringVal * stop;
  longShort * a_longShort;
};

/********************************************************************/

/* stringFuncStr

This is a class for the single definition of stringFuncStr.
It represents the following items:

STR '(' rentVal [strVar7] ')'

*/

class stringFuncStr :
  public stringFunc
{
public:
  stringFuncStr();
  stringFuncStr(
    rentVal * xIn,
    strVar7 * strVar7In);
  ~stringFuncStr();
  void printSelf();
  rentVal * get_x();
  void set_x(rentVal * xIn);
  strVar7 * get_strVar7();
  void set_strVar7(strVar7 * strVar7In);
private:
  rentVal * x;
  strVar7 * a_strVar7;
};

/********************************************************************/

/* stringFuncLwc

This is a class for the single definition of stringFuncLwc.
It represents the following items:

LWC '(' stringVal ')'

*/

class stringFuncLwc :
  public stringFunc
{
public:
  stringFuncLwc();
  stringFuncLwc(
    stringVal * strIn);
  ~stringFuncLwc();
  void printSelf();
  stringVal * get_str();
  void set_str(stringVal * strIn);
private:
  stringVal * str;
};

/********************************************************************/

/* stringFuncTrim

This is a class for the single definition of stringFuncTrim.
It represents the following items:

TRIM '(' stringVal ')'

*/

class stringFuncTrim :
  public stringFunc
{
public:
  stringFuncTrim();
  stringFuncTrim(
    stringVal * strIn);
  ~stringFuncTrim();
  void printSelf();
  stringVal * get_str();
  void set_str(stringVal * strIn);
private:
  stringVal * str;
};

/********************************************************************/

/* stringFuncUpc

This is a class for the single definition of stringFuncUpc.
It represents the following items:

UPC '(' stringVal ')'

*/

class stringFuncUpc :
  public stringFunc
{
public:
  stringFuncUpc();
  stringFuncUpc(
    stringVal * strIn);
  ~stringFuncUpc();
  void printSelf();
  stringVal * get_str();
  void set_str(stringVal * strIn);
private:
  stringVal * str;
};

/********************************************************************/

/* stringFuncSubstr

This is a class for the single definition of stringFuncSubstr.
It represents the following items:

SUBSTR '(' stringVal ',' intVal [',' intVal] ')'

*/

class stringFuncSubstr :
  public stringFunc
{
public:
  stringFuncSubstr();
  stringFuncSubstr(
    stringVal * strIn,
    intVal * startIndexIn,
    intVal * endIndexIn);
  ~stringFuncSubstr();
  void printSelf();
  stringVal * get_str();
  void set_str(stringVal * strIn);
  intVal * get_startIndex();
  void set_startIndex(intVal * startIndexIn);
  intVal * get_endIndex();
  void set_endIndex(intVal * endIndexIn);
private:
  stringVal * str;
  intVal * startIndex;
  intVal * endIndex;
};

/********************************************************************/

/* boolFuncBadgt

This is a class for the single definition of boolFuncBadgt.
It represents the following items:

BADGT '(' ')'

*/

class boolFuncBadgt :
  public boolFunc
{
public:
  boolFuncBadgt();
  ~boolFuncBadgt();
  void printSelf();
};

/********************************************************************/

/* boolFuncExist

This is a parent class.

*/

class boolFuncExist :
  public boolFunc
{
public:
  boolFuncExist();
  ~boolFuncExist();
  void printSelf() = 0;
};

/********************************************************************/

/* boolFuncExist_sLabel

This is a derived class for one of the definitions of boolFuncExist.
It represents the following items:

EXIST '(' sLabel ')'

*/

class boolFuncExist_sLabel :
  public boolFuncExist
{
public:
  boolFuncExist_sLabel();
  boolFuncExist_sLabel(
    sLabel * sLabelIn);
  ~boolFuncExist_sLabel();
  void printSelf();
  sLabel * get_sLabel();
  void set_sLabel(sLabel * sLabelIn);
private:
  sLabel * a_sLabel;
};

/********************************************************************/

/* boolFuncExist_saLabel

This is a derived class for one of the definitions of boolFuncExist.
It represents the following items:

EXIST '(' saLabel ')'

*/

class boolFuncExist_saLabel :
  public boolFuncExist
{
public:
  boolFuncExist_saLabel();
  boolFuncExist_saLabel(
    saLabel * saLabelIn);
  ~boolFuncExist_saLabel();
  void printSelf();
  saLabel * get_saLabel();
  void set_saLabel(saLabel * saLabelIn);
private:
  saLabel * a_saLabel;
};

/********************************************************************/

/* boolFuncExist_dLabel

This is a derived class for one of the definitions of boolFuncExist.
It represents the following items:

EXIST '(' dLabel ')'

*/

class boolFuncExist_dLabel :
  public boolFuncExist
{
public:
  boolFuncExist_dLabel();
  boolFuncExist_dLabel(
    dLabel * dLabelIn);
  ~boolFuncExist_dLabel();
  void printSelf();
  dLabel * get_dLabel();
  void set_dLabel(dLabel * dLabelIn);
private:
  dLabel * a_dLabel;
};

/********************************************************************/

/* boolFuncExist_daLabel

This is a derived class for one of the definitions of boolFuncExist.
It represents the following items:

EXIST '(' daLabel ')'

*/

class boolFuncExist_daLabel :
  public boolFuncExist
{
public:
  boolFuncExist_daLabel();
  boolFuncExist_daLabel(
    daLabel * daLabelIn);
  ~boolFuncExist_daLabel();
  void printSelf();
  daLabel * get_daLabel();
  void set_daLabel(daLabel * daLabelIn);
private:
  daLabel * a_daLabel;
};

/********************************************************************/

/* boolFuncExist_didLabel

This is a derived class for one of the definitions of boolFuncExist.
It represents the following items:

EXIST '(' didLabel ')'

*/

class boolFuncExist_didLabel :
  public boolFuncExist
{
public:
  boolFuncExist_didLabel();
  boolFuncExist_didLabel(
    didLabel * didLabelIn);
  ~boolFuncExist_didLabel();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* boolFuncExist_fLabel

This is a derived class for one of the definitions of boolFuncExist.
It represents the following items:

EXIST '(' fLabel ')'

*/

class boolFuncExist_fLabel :
  public boolFuncExist
{
public:
  boolFuncExist_fLabel();
  boolFuncExist_fLabel(
    fLabel * fLabelIn);
  ~boolFuncExist_fLabel();
  void printSelf();
  fLabel * get_fLabel();
  void set_fLabel(fLabel * fLabelIn);
private:
  fLabel * a_fLabel;
};

/********************************************************************/

/* boolFuncExist_faLabel

This is a derived class for one of the definitions of boolFuncExist.
It represents the following items:

EXIST '(' faLabel ')'

*/

class boolFuncExist_faLabel :
  public boolFuncExist
{
public:
  boolFuncExist_faLabel();
  boolFuncExist_faLabel(
    faLabel * faLabelIn);
  ~boolFuncExist_faLabel();
  void printSelf();
  faLabel * get_faLabel();
  void set_faLabel(faLabel * faLabelIn);
private:
  faLabel * a_faLabel;
};

/********************************************************************/

/* boolFuncBadpt

This is a class for the single definition of boolFuncBadpt.
It represents the following items:

BADPT '(' ')'

*/

class boolFuncBadpt :
  public boolFunc
{
public:
  boolFuncBadpt();
  ~boolFuncBadpt();
  void printSelf();
};

/********************************************************************/

/* boolFuncEof

This is a class for the single definition of boolFuncEof.
It represents the following items:

WWEOF '(' didLabel ')'

*/

class boolFuncEof :
  public boolFunc
{
public:
  boolFuncEof();
  boolFuncEof(
    didLabel * didLabelIn);
  ~boolFuncEof();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* boolFuncEoln

This is a class for the single definition of boolFuncEoln.
It represents the following items:

EOLN '(' didLabel ')'

*/

class boolFuncEoln :
  public boolFunc
{
public:
  boolFuncEoln();
  boolFuncEoln(
    didLabel * didLabelIn);
  ~boolFuncEoln();
  void printSelf();
  didLabel * get_didLabel();
  void set_didLabel(didLabel * didLabelIn);
private:
  didLabel * a_didLabel;
};

/********************************************************************/

/* vectorFuncVcart

This is a class for the single definition of vectorFuncVcart.
It represents the following items:

VCART '(' rentVal ',' rentVal ',' rentVal ')'

*/

class vectorFuncVcart :
  public vectorFunc
{
public:
  vectorFuncVcart();
  vectorFuncVcart(
    rentVal * xIn,
    rentVal * yIn,
    rentVal * zIn);
  ~vectorFuncVcart();
  void printSelf();
  rentVal * get_x();
  void set_x(rentVal * xIn);
  rentVal * get_y();
  void set_y(rentVal * yIn);
  rentVal * get_z();
  void set_z(rentVal * zIn);
private:
  rentVal * x;
  rentVal * y;
  rentVal * z;
};

/********************************************************************/

/* vectorFuncVcross

This is a class for the single definition of vectorFuncVcross.
It represents the following items:

VCROSS '(' vectorVal ',' vectorVal ')'

*/

class vectorFuncVcross :
  public vectorFunc
{
public:
  vectorFuncVcross();
  vectorFuncVcross(
    vectorVal * v1In,
    vectorVal * v2In);
  ~vectorFuncVcross();
  void printSelf();
  vectorVal * get_v1();
  void set_v1(vectorVal * v1In);
  vectorVal * get_v2();
  void set_v2(vectorVal * v2In);
private:
  vectorVal * v1;
  vectorVal * v2;
};

/********************************************************************/

/* vectorFuncVmcs

This is a class for the single definition of vectorFuncVmcs.
It represents the following items:

VMCS '(' vectorVal ')'

*/

class vectorFuncVmcs :
  public vectorFunc
{
public:
  vectorFuncVmcs();
  vectorFuncVmcs(
    vectorVal * vectorValIn);
  ~vectorFuncVmcs();
  void printSelf();
  vectorVal * get_vectorVal();
  void set_vectorVal(vectorVal * vectorValIn);
private:
  vectorVal * a_vectorVal;
};

/********************************************************************/

/* vectorFuncVpcs

This is a class for the single definition of vectorFuncVpcs.
It represents the following items:

VPCS '(' vectorVal ')'

*/

class vectorFuncVpcs :
  public vectorFunc
{
public:
  vectorFuncVpcs();
  vectorFuncVpcs(
    vectorVal * vectorValIn);
  ~vectorFuncVpcs();
  void printSelf();
  vectorVal * get_vectorVal();
  void set_vectorVal(vectorVal * vectorValIn);
private:
  vectorVal * a_vectorVal;
};

/********************************************************************/

/* vectorFuncVpol

This is a class for the single definition of vectorFuncVpol.
It represents the following items:

VPOL '(' rentVal ',' angle ',' rentVal ')'

*/

class vectorFuncVpol :
  public vectorFunc
{
public:
  vectorFuncVpol();
  vectorFuncVpol(
    rentVal * rIn,
    angle * aIn,
    rentVal * hIn);
  ~vectorFuncVpol();
  void printSelf();
  rentVal * get_r();
  void set_r(rentVal * rIn);
  angle * get_a();
  void set_a(angle * aIn);
  rentVal * get_h();
  void set_h(rentVal * hIn);
private:
  rentVal * r;
  angle * a;
  rentVal * h;
};

/********************************************************************/

/* vectorFuncVunit

This is a class for the single definition of vectorFuncVunit.
It represents the following items:

VUNIT '(' vectorVal ')'

*/

class vectorFuncVunit :
  public vectorFunc
{
public:
  vectorFuncVunit();
  vectorFuncVunit(
    vectorVal * vectorValIn);
  ~vectorFuncVunit();
  void printSelf();
  vectorVal * get_vectorVal();
  void set_vectorVal(vectorVal * vectorValIn);
private:
  vectorVal * a_vectorVal;
};

/********************************************************************/

/* labelName

This is a parent class.

*/

class labelName :
  public jumpLabel
{
public:
  labelName();
  ~labelName();
  void printSelf() = 0;
};

/********************************************************************/

/* labelNameCon

This is a derived class for one of the definitions of labelName.
It represents the following items:

labelNameConst

*/

class labelNameCon :
  public labelName
{
public:
  labelNameCon();
  labelNameCon(
    labelNameConst * labelNameConstIn);
  ~labelNameCon();
  void printSelf();
  labelNameConst * get_labelNameConst();
  void set_labelNameConst(labelNameConst * labelNameConstIn);
private:
  labelNameConst * a_labelNameConst;
};

/********************************************************************/

/* labelNameAt

This is a derived class for one of the definitions of labelName.
It represents the following items:

'(' '@' stringVar ')'

*/

class labelNameAt :
  public labelName
{
public:
  labelNameAt();
  labelNameAt(
    stringVar * stringVarIn);
  ~labelNameAt();
  void printSelf();
  stringVar * get_stringVar();
  void set_stringVar(stringVar * stringVarIn);
private:
  stringVar * a_stringVar;
};

/********************************************************************/

/* featureLabel

This is a parent class.

*/

class featureLabel :
  public extremConstFeature
{
public:
  featureLabel();
  ~featureLabel();
  void printSelf() = 0;
};

/********************************************************************/

/* qisLabel

This is a parent class.

*/

class qisLabel :
  public promptVar
{
public:
  qisLabel();
  ~qisLabel();
  void printSelf() = 0;
};

/********************************************************************/

/* ccLabel

This is a class for the single definition of ccLabel.
It represents the following items:

CC labelName

*/

class ccLabel :
  public qisLabel
{
public:
  ccLabel();
  ccLabel(
    labelName * labelNameIn);
  ~ccLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* ciLabel

This is a class for the single definition of ciLabel.
It represents the following items:

CI labelName

*/

class ciLabel :
  public qisLabel
{
public:
  ciLabel();
  ciLabel(
    labelName * labelNameIn);
  ~ciLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* csLabel

This is a class for the single definition of csLabel.
It represents the following items:

CS labelName

*/

class csLabel :
  public qisLabel
{
public:
  csLabel();
  csLabel(
    labelName * labelNameIn);
  ~csLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* datLabel

This is a class for the single definition of datLabel.
It represents the following items:

DAT labelName

*/

class datLabel :
  public locateLabel,
  public snsetFeat,
  public tolFeature
{
public:
  datLabel();
  datLabel(
    labelName * labelNameIn);
  ~datLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* diLabel

This is a class for the single definition of diLabel.
It represents the following items:

DI labelName

*/

class diLabel :
  public qisLabel
{
public:
  diLabel();
  diLabel(
    labelName * labelNameIn);
  ~diLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* dsLabel

This is a class for the single definition of dsLabel.
It represents the following items:

DS labelName

*/

class dsLabel :
  public qisLabel
{
public:
  dsLabel();
  dsLabel(
    labelName * labelNameIn);
  ~dsLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* dvLabel

This is a class for the single definition of dvLabel.
It represents the following items:

DV labelName

*/

class dvLabel :
  public qisLabel
{
public:
  dvLabel();
  dvLabel(
    labelName * labelNameIn);
  ~dvLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* fLabel

This is a class for the single definition of fLabel.
It represents the following items:

F labelName

*/

class fLabel :
  public featureLabel,
  public featureLabel1,
  public measVar2Aux,
  public snsetFeat,
  public tolFeature
{
public:
  fLabel();
  fLabel(
    labelName * labelNameIn);
  ~fLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* faLabel

This is a class for the single definition of faLabel.
It represents the following items:

FA labelName

*/

class faLabel :
  public featureLabel,
  public featureLabel1,
  public locateLabel,
  public measVar2Aux,
  public rmeasSpecFa,
  public snsetFeat,
  public tolFeature
{
public:
  faLabel();
  faLabel(
    labelName * labelNameIn);
  ~faLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* fiLabel

This is a class for the single definition of fiLabel.
It represents the following items:

FI labelName

*/

class fiLabel :
  public qisLabel
{
public:
  fiLabel();
  fiLabel(
    labelName * labelNameIn);
  ~fiLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* fsLabel

This is a class for the single definition of fsLabel.
It represents the following items:

FS labelName

*/

class fsLabel :
  public qisLabel
{
public:
  fsLabel();
  fsLabel(
    labelName * labelNameIn);
  ~fsLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* gLabel

This is a class for the single definition of gLabel.
It represents the following items:

G labelName

*/

class gLabel :
  public measVar2Aux
{
public:
  gLabel();
  gLabel(
    labelName * labelNameIn);
  ~gLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* kcLabel

This is a class for the single definition of kcLabel.
It represents the following items:

KC labelName

*/

class kcLabel :
  public evalKeychar,
  public outputKeycharData,
  public valueKeychar
{
public:
  kcLabel();
  kcLabel(
    labelName * labelNameIn);
  ~kcLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* kcaLabel

This is a class for the single definition of kcaLabel.
It represents the following items:

KCA labelName

*/

class kcaLabel :
  public outputKeycharData
{
public:
  kcaLabel();
  kcaLabel(
    labelName * labelNameIn);
  ~kcaLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* liLabel

This is a class for the single definition of liLabel.
It represents the following items:

LI labelName

*/

class liLabel :
  public qisLabel
{
public:
  liLabel();
  liLabel(
    labelName * labelNameIn);
  ~liLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* maLabel

This is a class for the single definition of maLabel.
It represents the following items:

MA labelName

*/

class maLabel :
  public locateLabel
{
public:
  maLabel();
  maLabel(
    labelName * labelNameIn);
  ~maLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* mdLabel

This is a class for the single definition of mdLabel.
It represents the following items:

MD labelName

*/

class mdLabel :
  public qisLabel
{
public:
  mdLabel();
  mdLabel(
    labelName * labelNameIn);
  ~mdLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* opLabel

This is a class for the single definition of opLabel.
It represents the following items:

OP labelName

*/

class opLabel :
  public qisLabel
{
public:
  opLabel();
  opLabel(
    labelName * labelNameIn);
  ~opLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* pcLabel

This is a class for the single definition of pcLabel.
It represents the following items:

PC labelName

*/

class pcLabel :
  public qisLabel
{
public:
  pcLabel();
  pcLabel(
    labelName * labelNameIn);
  ~pcLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* plLabel

This is a class for the single definition of plLabel.
It represents the following items:

PL labelName

*/

class plLabel :
  public qisLabel
{
public:
  plLabel();
  plLabel(
    labelName * labelNameIn);
  ~plLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* pnLabel

This is a class for the single definition of pnLabel.
It represents the following items:

PN labelName

*/

class pnLabel :
  public qisLabel
{
public:
  pnLabel();
  pnLabel(
    labelName * labelNameIn);
  ~pnLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* prLabel

This is a class for the single definition of prLabel.
It represents the following items:

PR labelName

*/

class prLabel :
  public qisLabel
{
public:
  prLabel();
  prLabel(
    labelName * labelNameIn);
  ~prLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* psLabel

This is a class for the single definition of psLabel.
It represents the following items:

PS labelName

*/

class psLabel :
  public qisLabel
{
public:
  psLabel();
  psLabel(
    labelName * labelNameIn);
  ~psLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* pvLabel

This is a class for the single definition of pvLabel.
It represents the following items:

PV labelName

*/

class pvLabel :
  public qisLabel
{
public:
  pvLabel();
  pvLabel(
    labelName * labelNameIn);
  ~pvLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* qLabel

This is a class for the single definition of qLabel.
It represents the following items:

Q labelName

*/

class qLabel :
  public qisLabel
{
public:
  qLabel();
  qLabel(
    labelName * labelNameIn);
  ~qLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* rLabel

This is a class for the single definition of rLabel.
It represents the following items:

R labelName

*/

class rLabel :
  public outputReportData
{
public:
  rLabel();
  rLabel(
    labelName * labelNameIn);
  ~rLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* rmLabel

This is a class for the single definition of rmLabel.
It represents the following items:

RM labelName

*/

class rmLabel :
  public cmpntgrpSpec,
  public snsgrpItem
{
public:
  rmLabel();
  rmLabel(
    labelName * labelNameIn);
  ~rmLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* sgLabel

This is a class for the single definition of sgLabel.
It represents the following items:

SG labelName

*/

class sgLabel :
  public cmpntgrpSpec,
  public snsgrpItem
{
public:
  sgLabel();
  sgLabel(
    labelName * labelNameIn);
  ~sgLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* sgsLabel

This is a class for the single definition of sgsLabel.
It represents the following items:

SGS labelName

*/

class sgsLabel :
  public snsdefBuildSensor
{
public:
  sgsLabel();
  sgsLabel(
    labelName * labelNameIn);
  ~sgsLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* ssLabel

This is a class for the single definition of ssLabel.
It represents the following items:

SS labelName

*/

class ssLabel :
  public snsdefBuildSensor
{
public:
  ssLabel();
  ssLabel(
    labelName * labelNameIn);
  ~ssLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* swLabel

This is a class for the single definition of swLabel.
It represents the following items:

SW labelName

*/

class swLabel :
  public cmpntgrpSpec,
  public snsgrpItem
{
public:
  swLabel();
  swLabel(
    labelName * labelNameIn);
  ~swLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* sxLabel

This is a class for the single definition of sxLabel.
It represents the following items:

SX labelName

*/

class sxLabel :
  public cmpntgrpSpec,
  public snsgrpItem
{
public:
  sxLabel();
  sxLabel(
    labelName * labelNameIn);
  ~sxLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* tLabel

This is a class for the single definition of tLabel.
It represents the following items:

T labelName

*/

class tLabel :
  public toleranceLabel,
  public outputToleranceData
{
public:
  tLabel();
  tLabel(
    labelName * labelNameIn);
  ~tLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* taLabel

This is a class for the single definition of taLabel.
It represents the following items:

TA labelName

*/

class taLabel :
  public toleranceLabel,
  public outputToleranceData
{
public:
  taLabel();
  taLabel(
    labelName * labelNameIn);
  ~taLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* tlLabel

This is a class for the single definition of tlLabel.
It represents the following items:

TL labelName

*/

class tlLabel :
  public qisLabel
{
public:
  tlLabel();
  tlLabel(
    labelName * labelNameIn);
  ~tlLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* vaLabel

This is a class for the single definition of vaLabel.
It represents the following items:

VA labelName

*/

class vaLabel :
  public snsetLabel
{
public:
  vaLabel();
  vaLabel(
    labelName * labelNameIn);
  ~vaLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* vfLabel

This is a class for the single definition of vfLabel.
It represents the following items:

VF labelName

*/

class vfLabel :
  public snsetLabel
{
public:
  vfLabel();
  vfLabel(
    labelName * labelNameIn);
  ~vfLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* vwLabel

This is a class for the single definition of vwLabel.
It represents the following items:

VW labelName

*/

class vwLabel :
  public snsetLabel
{
public:
  vwLabel();
  vwLabel(
    labelName * labelNameIn);
  ~vwLabel();
  void printSelf();
  labelName * get_labelName();
  void set_labelName(labelName * labelNameIn);
private:
  labelName * a_labelName;
};

/********************************************************************/

/* cartPoint

This is a class for the single definition of cartPoint.
It represents the following items:

CART ',' rentVal ',' rentVal ',' rentVal

*/

class cartPoint :
  public typePoint
{
public:
  cartPoint();
  cartPoint(
    rentVal * xIn,
    rentVal * yIn,
    rentVal * zIn);
  ~cartPoint();
  void printSelf();
  rentVal * get_x();
  void set_x(rentVal * xIn);
  rentVal * get_y();
  void set_y(rentVal * yIn);
  rentVal * get_z();
  void set_z(rentVal * zIn);
private:
  rentVal * x;
  rentVal * y;
  rentVal * z;
};

/********************************************************************/

/* polPoint

This is a class for the single definition of polPoint.
It represents the following items:

POL ',' rentVal ',' rentVal ',' rentVal

*/

class polPoint :
  public typePoint
{
public:
  polPoint();
  polPoint(
    rentVal * rIn,
    rentVal * aIn,
    rentVal * hIn);
  ~polPoint();
  void printSelf();
  rentVal * get_r();
  void set_r(rentVal * rIn);
  rentVal * get_a();
  void set_a(rentVal * aIn);
  rentVal * get_h();
  void set_h(rentVal * hIn);
private:
  rentVal * r;
  rentVal * a;
  rentVal * h;
};

/********************************************************************/

/* posDir

This is a parent class.

*/

class posDir :
  public dir,
  public extremConstAxial
{
public:
  posDir();
  ~posDir();
  void printSelf() = 0;
};

/********************************************************************/

/* posDir_XDIR

This is a derived class for one of the definitions of posDir.
It represents the following items:

XDIR

*/

class posDir_XDIR :
  public posDir
{
public:
  posDir_XDIR();
  ~posDir_XDIR();
  void printSelf();
};

/********************************************************************/

/* posDir_YDIR

This is a derived class for one of the definitions of posDir.
It represents the following items:

YDIR

*/

class posDir_YDIR :
  public posDir
{
public:
  posDir_YDIR();
  ~posDir_YDIR();
  void printSelf();
};

/********************************************************************/

/* posDir_ZDIR

This is a derived class for one of the definitions of posDir.
It represents the f