/*

This removes a linefeed (ASCII 13) from the next-to-last position
of each line of a file that has a linefeed in that position.
This is useful for files that have been created in Windows by
redirecting output, since output redirection in Windows causes
each line to end with a linefeed followed by a carriage return
(ASCII 10).

*/

#include <stdio.h>
int main(int argc, char * argv[])
{
  FILE * inFile;
  FILE * outFile;
  char buf[4096];
  int n;

  inFile = fopen(argv[1], "r");
  outFile = fopen(argv[2], "w");
  while(fgets(buf, 4095, inFile))
    {
      for (n=0; buf[n]; n++);
      if (buf[n-2] == 13)
	{
	  buf[n-2] = 10;
	  buf[n-1] = 0;
	}
      fprintf(outFile, "%s", buf);
    }
  fclose(inFile);
  fclose(outFile);
}
