%{

/************************************************************************
  DISCLAIMER:
  This software was produced by the National Institute of Standards
  and Technology (NIST), an agency of the U.S. government, and by statute
  is not subject to copyright in the United States.  Recipients of this
  software assume all responsibility associated with its operation,
  modification, maintenance, and subsequent redistribution.

  See NIST Administration Manual 4.09.07 b and Appendix I.
************************************************************************/
/*
See DMIS Sec. 5.1.1 and Sec. 5.1.2.7 regarding variable names
See DMIS Sec. 5.1.1 and Sec. 5.1.2.4 regarding label names
See DMIS Sec. 5.1.1 and Sec. 5.1.2.5 regarding text strings
*/

#include <string.h>          // for strdup, etc.
#include <ctype.h>           // for isalpha
#include "dmis.hh"
#include "dmisYACC.hh"

#define ECH  for (k=0; ((k < yyleng) && (lineTextIndex < 4095));)\
    lineText[lineTextIndex++] = yytext[k++];\
    lineText[lineTextIndex] = 0

#define VARLIST_MAX_SIZE 1024

extern int resetLex;
extern int macroIsReal;
extern int getCallArgs;
extern char lineText[];
extern char lexMessage[];
extern char lexWarning[];
extern int lineNo;
extern int inDecl;
int lineTextIndex;
char stringText[4096];
int j;      // index for stringText
double num; // number to parse reals into
int k;      // utility index, used in ECH compiler macro
int varType;
// scopeList scopeStack; is declared below

class varAndType {
 public:
  varAndType(){}
  ~varAndType(){}
  char * name;
  int theType;
};

class scope {
 public:
  scope(){size = 0;}
  ~scope(){}
  varAndType vars[VARLIST_MAX_SIZE];
  int size;
};

class scopeList {
 public:
  scopeList(){data = new scope; next = 0;}
  ~scopeList(){};
  void push(scope * addIt)
    {
      scopeList * newbie;
      newbie = new scopeList;
      newbie->next = next;
      newbie->data = data;
      next = newbie;
      data = addIt;
    }
  void pop()
    { // don't pop a list with only one element
      scopeList * temp;
      temp = next;
      delete data;
      data = next->data;
      next = next->next;
      delete temp;
    }
  scope * data;
  scopeList * next;
};

scopeList scopeStack;

int findVariable(
 char * varName,
 int * tipe,
 int topOnly)
{
  int n;
  scopeList * tier;
  scope * aScope;

  for (tier = &scopeStack; tier; tier = tier->next)
    {
      aScope = tier->data;
      for (n = 0; n < aScope->size; n++)
        {
          if (strcmp(varName, aScope->vars[n].name) == 0)
            {
              *tipe = aScope->vars[n].theType;
              return (n+1);
            }
        }
      if (topOnly)
        break;
    }
  return 0;
}

void doLineNo()
{
  int n;
  int m;

  sscanf(yytext, "%d%n", &lineNo, &n);
  n++;
  for (m = n; m < yyleng; m++)
    yytext[m-n] = yytext[m];
  yytext[m-n] = 0;
  yyleng = (yyleng - n);
  lineTextIndex = 0;
}

void recordVariable(
 char * varName,
 int varType)
{
  scope * aScope;

  aScope = scopeStack.data;
  if (aScope->size >= VARLIST_MAX_SIZE)
    {
      fprintf(stderr, "Quitting: too many variables\n");
      exit (1);
    }
  aScope->vars[aScope->size].name = strdup(varName);
  aScope->vars[aScope->size].theType = varType;
  aScope->size++;
}

void shiftUpcase(
 char * text)
{
  int n;
  int first;
  char c;

  for (first = 0; text[first] <= ' '; first++);
  for (n = first; text[n] > ' '; n++)
    {
      c = text[n];
      text[n - first] = (islower(c) ? toupper(c) : c);
    }
  text[n - first] = 0;
}

int closeUpcase(
 char * text)
{
  int m;         // old text index
  int n;         // new text index
  int inString;
  char c;

  inString = 0;
  for (n = 0, m = 0; ((c = text[m]) != 0); m++)
    {
      if (inString)
        {
          text[n++] = c;
          if (c == '\'')
            {
	      if (text[m+1] == '\'')
		{ // two quotes in a row; keep both
		  m++;
		  text[n++] = '\'';
		}
	      else
		inString = 0;
            }
        }
      else if ((c == ' ') || (c == '\t')); // don't copy blank or tab
      else if (c == '\'')
        { // string is starting
          inString = 1;
          text[n++] = c;
        }
      else
        {
          text[n++] = (islower(c) ? toupper(c) : c);
        }
    }
  text[n] = 0;
  return ((inString) ? 1 : 0);
}

void emptyScopeStack()
{
  int n;

  for (n = 0; n < scopeStack.data->size; n++)
    delete scopeStack.data->vars[n].name;
  scopeStack.data->size = 0;
  if (scopeStack.next)
    sprintf(lexMessage, "ENDMAC missing");
}

%}

A [aA]
B [bB]
C [cC]
D [dD]
E [eE]
F [fF]
G [gG]
H [hH]
I [iI]
J [jJ]
K [kK]
L [lL]
M [mM]
N [nN]
O [oO]
P [pP]
Q [qQ]
R [rR]
S [sS]
T [tT]
U [uU]
V [vV]
W [wW]
X [xX]
Y [yY]
Z [zZ]

_ [ \t]*

%x INSTRING
%x READLABEL
%x READ2
%x AT2
%x DMISOFFIN
%x DMISOFFLINENUM
%x DMISOFFLINE
%x CALLARGS
%x MACROIN
%x MACROLINE
%x MACROLINENUM

%%

   if (resetLex)
     {
       while (scopeStack.next)
	 scopeStack.pop();
       BEGIN INITIAL;
       resetLex = 0;
     }
   else if (getCallArgs)
     BEGIN CALLARGS;

{_}{A}{B}{O}{V}{E}{_}                   {ECH; return ABOVE;}
{_}{A}{B}{S}{_}                         {ECH; return ABS;}
{_}{A}{B}{S}{L}{_}                      {ECH; return ABSL;}
{_}{A}{C}{E}{L}{_}                      {ECH; return ACEL;}
{_}{A}{C}{L}{R}{A}{T}{_}                {ECH; return ACLRAT;}
{_}{A}{C}{O}{S}{_}                      {ECH; return ACOS;}
{_}{A}{C}{T}{_}                         {ECH; return ACT;}
{_}{A}{D}{J}{U}{S}{T}{_}                {ECH; return ADJUST;}
{_}{A}{L}{G}{D}{E}{F}{_}                {ECH; return ALGDEF;}
{_}{A}{L}{G}{O}{R}{_}                   {ECH; return ALGOR;}
{_}{A}{L}{L}{_}                         {ECH; return ALL;}
{_}{A}{L}{L}{A}{X}{E}{S}{T}{O}{U}{C}{H}{_} {ECH; return ALLAXESTOUCH;}
{_}{A}{L}{L}{S}{A}{_}                   {ECH; return ALLSA;}
{_}{A}{L}{P}{H}{A}{_}                   {ECH; return ALPHA;}
{_}{A}{M}{T}{_}                         {ECH; return AMT;}
{_}"."{A}{N}{D}"."{_}                   {ECH; return AND;}
{_}{A}{N}{G}{D}{E}{C}{_}                {ECH; return ANGDEC;}
{_}{A}{N}{G}{D}{M}{S}{_}                {ECH; return ANGDMS;}
{_}{A}{N}{G}{L}{_}                      {ECH; return ANGL;}
{_}{A}{N}{G}{L}{B}{_}                   {ECH; return ANGLB;}
{_}{A}{N}{G}{L}{E}{_}                   {ECH; return ANGLE;}
{_}{A}{N}{G}{L}{R}{_}                   {ECH; return ANGLR;}
{_}{A}{N}{G}{L}{W}{R}{T}{_}             {ECH; return ANGLWRT;}
{_}{A}{N}{G}{R}{A}{D}{_}                {ECH; return ANGRAD;}
{_}{A}{P}{P}{E}{N}{D}{_}                {ECH; return APPEND;}
{_}{A}{P}{P}{R}{C}{H}{_}                {ECH; return APPRCH;}
{_}{A}{R}{C}{_}                         {ECH; return ARC;}
{_}{A}{R}{E}{A}{_}                      {ECH; return AREA;}
{_}{A}{S}{I}{N}{_}                      {ECH; return ASIN;}
{_}{A}{S}{S}{I}{G}{N}{_}                {ECH; return ASSIGN;}
{_}{A}{T}{A}{N}{_}                      {ECH; return ATAN;}
{_}{A}{T}{A}{N}"2"{_}                   {ECH; return ATAN2;}
{_}{A}{T}{T}{A}{C}{H}{_}                {ECH; return ATTACH;}
{_}{A}{U}{T}{O}{_}                      {ECH; return AUTO;}
{_}{A}{V}{G}{_}                         {ECH; return AVG;}
{_}{A}{V}{G}{D}{E}{V}{_}                {ECH; return AVGDEV;}
{_}{A}{X}{D}{I}{R}{_}                   {ECH; return AXDIR;}
{_}{A}{X}{I}{A}{L}{_}                   {ECH; return AXIAL;}
{_}{B}{A}{C}{K}{_}                      {ECH; return BACK;}
{_}{B}{A}{D}{G}{T}{_}                   {ECH; return BADGT;}
{_}{B}{A}{D}{P}{T}{_}                   {ECH; return BADPT;}
{_}{B}{A}{D}{T}{S}{T}{_}                {ECH; return BADTST;}
{_}{B}{A}{N}{D}{P}{A}{S}{S}{_}          {ECH; return BANDPASS;}
{_}{B}{E}{L}{O}{W}{_}                   {ECH; return BELOW;}
{_}{B}{E}{Z}{I}{E}{R}{_}                {ECH; return BEZIER;}
{_}{B}{F}{_}                            {ECH; return BF;}
{_}{B}{N}{D}{_}                         {ECH; return BND;}
{_}{B}{O}{O}{L}{_}                      {ECH; varType = BOOLVARNAME;
                                         return BOOL;}
{_}{B}{O}{U}{N}{D}{_}                   {ECH; return BOUND;}
{_}{B}{O}{X}{_}                         {ECH; return BOX;}
{_}{B}{S}{P}{L}{I}{N}{_}                {ECH; return BSPLIN;}
{_}{B}{U}{I}{L}{D}{_}                   {ECH; return BUILD;}
{_}{B}{U}{T}{T}{O}{N}{_}                {ECH; return BUTTON;}
{_}{C}{A}{D}{_}                         {ECH; return CAD;}
{_}{C}{A}{D}{C}{S}{_}                   {ECH; return CADCS;}
{_}{C}{A}{L}{I}{B}{_}                   {ECH; return CALIB;}
{_}{C}{A}{L}{L}{_}                      {ECH; 
                                         scopeStack.push(new scope);
                                         return CALL;}
{_}{C}{A}{R}{T}{_}                      {ECH; return CART;}
{_}{C}{A}{S}{E}{_}                      {ECH; return CASE;}
{_}({C}{C}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return CC;}
{_}{C}{C}{W}{_}                         {ECH; return CCW;}
{_}{C}{H}{A}{R}{_}                      {ECH; varType = STRINGVARNAME;
                                         return CHAR;}
{_}{C}{H}{E}{C}{K}{_}                   {ECH; return CHECK;}
{_}{C}{H}{O}{R}{D}{_}                   {ECH; return CHORD;}
{_}{C}{H}{R}{_}                         {ECH; return CHR;}
{_}({C}{I}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return CI;}
{_}{C}{I}{R}{C}{L}{E}{_}                {ECH; return CIRCLE;}
{_}{C}{I}{R}{C}{U}{L}{A}{R}{_}          {ECH; return CIRCULAR;}
{_}{C}{I}{R}{L}{T}{Y}{_}                {ECH; return CIRLTY;}
{_}{C}{L}{M}{P}{I}{D}{_}                {ECH; return CLMPID;}
{_}{C}{L}{M}{P}{S}{N}{_}                {ECH; return CLMPSN;}
{_}{C}{L}{O}{S}{E}{_}                   {ECH; return CLOSE;}
{_}{C}{L}{R}{S}{R}{F}{_}                {ECH; return CLRSRF;}
{_}{C}{M}{_}                            {ECH; return CM;}
{_}{C}{M}{P}{N}{T}{G}{R}{P}{_}          {ECH; return CMPNTGRP;}
{_}{C}{N}{F}{R}{M}{R}{U}{L}{_}          {ECH; return CNFRMRUL;}
{_}{C}{O}{D}{E}{_}                      {ECH; return CODE;}
{_}{C}{O}{G}{_}                         {ECH; return COG;}
{_}{C}{O}{M}{A}{N}{D}{_}                {ECH; return COMAND;}
{_}{C}{O}{M}{M}{_}                      {ECH; return COMM;}
{_}{C}{O}{M}{M}{O}{N}{_}                {ECH; return COMMON;}
{_}{C}{O}{M}{P}{_}                      {ECH; return COMP;}
{_}{C}{O}{M}{P}{O}{S}{_}                {ECH; return COMPOS;}
{_}{C}{O}{M}{P}{O}{U}{N}{D}{_}          {ECH; return COMPOUND;}
{_}{C}{O}{N}{C}{A}{T}{_}                {ECH; return CONCAT;}
{_}{C}{O}{N}{C}{E}{N}{_}                {ECH; return CONCEN;}
{_}{C}{O}{N}{E}{_}                      {ECH; return CONE;}
{_}{C}{O}{N}{R}{A}{D}{S}{E}{G}{M}{N}{T}{_} {ECH; return CONRADSEGMNT;}
{_}{C}{O}{N}{S}{T}{_}                   {ECH; return CONST;}
{_}{C}{O}{N}{T}{_}                      {ECH; return CONT;}
{_}{C}{O}{N}{T}{I}{N}{_}                {ECH; return CONTIN;}
{_}{C}{O}{R}{T}{O}{L}{_}                {ECH; return CORTOL;}
{_}{C}{O}{S}{_}                         {ECH; return COS;}
{_}{C}{O}{U}{N}{T}{_}                   {ECH; return COUNT;}
{_}{C}{P}{A}{R}{L}{N}{_}                {ECH; return CPARLN;}
{_}{C}{P}{R}{O}{F}{L}{_}                {ECH; return CPROFL;}
{_}{C}{P}{R}{O}{F}{S}{_}                {ECH; return CPROFS;}
{_}({C}{R}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return CR;}
{_}{C}{R}{A}{D}{_}                      {ECH; return CRAD;}
{_}{C}{R}{G}{D}{E}{F}{_}                {ECH; return CRGDEF;}
{_}{C}{R}{I}{T}{I}{C}{A}{L}{_}          {ECH; return CRITICAL;}
{_}{C}{R}{M}{O}{D}{E}{_}                {ECH; return CRMODE;}
{_}{C}{R}{N}{O}{U}{T}{_}                {ECH; return CRNOUT;}
{_}{C}{R}{O}{S}{C}{L}{_}                {ECH; return CROSCL;}
{_}{C}{R}{S}{L}{C}{T}{_}                {ECH; return CRSLCT;}
{_}({C}{S}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return CS;}
{_}{C}{T}{_}                            {ECH; return CT;}
{_}{C}{U}{R}{E}{N}{T}{_}                {ECH; return CURENT;}
{_}{C}{U}{R}{V}{E}{_}                   {ECH; return CURVE;}
{_}{C}{U}{T}{C}{O}{M}{_}                {ECH; return CUTCOM;}
{_}{C}{W}{_}                            {ECH; return CW;}
{_}{C}{Y}{C}{L}{E}{_}                   {ECH; return CYCLE;}
{_}{C}{Y}{L}{C}{T}{Y}{_}                {ECH; return CYLCTY;}
{_}{C}{Y}{L}{N}{D}{R}{_}                {ECH; return CYLNDR;}
{_}{C}{Y}{L}{R}{A}{D}{S}{E}{G}{M}{N}{T}{_} {ECH; return CYLRADSEGMNT;}
{_}({C}{Z}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return CZ;}
{_}{C}{Z}{O}{N}{E}{_}                   {ECH; return CZONE;}
{_}{C}{Z}{S}{L}{C}{T}{_}                {ECH; return CZSLCT;}
{_}({D}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return D;}
{_}({D}{A}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return DA;}
{_}({D}{A}{T}{_})/"("                   {ECH; BEGIN READLABEL;
                                         return DAT;}
{_}{D}{A}{T}{D}{E}{F}{_}                {ECH; return DATDEF;}
{_}{D}{A}{T}{E}{_}                      {ECH; return DATE;}
{_}{D}{A}{T}{S}{E}{T}{_}                {ECH; return DATSET;}
{_}{D}{A}{T}{T}{R}{G}{_}                {ECH; BEGIN READLABEL;
                                         return DATTRG;}
{_}{D}{A}{T}{T}{R}{G}{D}{E}{F}{_}       {ECH; return DATTRGDEF;}
{_}{D}{B}{L}{E}{_}                      {ECH; return DBLE;}
{_}{D}{E}{C}{L}{_}                      {ECH; varType = -1;
                                         return DECL;}
{_}{D}{E}{C}{P}{L}{_}                   {ECH; return DECPL;}
{_}{D}{E}{F}{A}{L}{T}{_}                {ECH; return DEFALT;}
{_}{D}{E}{F}{L}{E}{C}{T}{I}{O}{N}{_}    {ECH; return DEFLECTION;}
{_}{D}{E}{L}{A}{Y}{_}                   {ECH; return DELAY;}
{_}{D}{E}{L}{E}{T}{E}{_}                {ECH; return DELETE;}
{_}{D}{E}{P}{T}{H}{_}                   {ECH; return DEPTH;}
{_}{D}{E}{V}{_}                         {ECH; return DEV;}
{_}{D}{E}{V}{I}{C}{E}{_}                {ECH; return DEVICE;}
{_}{D}{F}{T}{C}{A}{S}{_}                {ECH; return DFTCAS;}
{_}({D}{I}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return DI;}
{_}{D}{I}{A}{M}{_}                      {ECH; return DIAM;}
{_}({D}{I}{D}{_})/"("                   {ECH; BEGIN READLABEL;
                                         return DID;}
{_}{D}{I}{R}{E}{C}{T}{_}                {ECH; return DIRECT;}
{_}{D}{I}{S}{K}{_}                      {ECH; return DISK;}
{_}{D}{I}{S}{P}{L}{Y}{_}                {ECH; return DISPLY;}
{_}{D}{I}{S}{T}{_}                      {ECH; return DIST;}
{_}{D}{I}{S}{T}{A}{N}{C}{E}{_}          {ECH; return DISTANCE;}
{_}{D}{I}{S}{T}{B}{_}                   {ECH; return DISTB;}
{_}{D}{I}{S}{T}{W}{R}{T}{_}             {ECH; return DISTWRT;}
{_}{D}{M}{E}{_}                         {ECH; return DME;}
{_}{D}{M}{E}{H}{W}{_}                   {ECH; return DMEHW;}
{_}{D}{M}{E}{I}{D}{_}                   {ECH; return DMEID;}
{_}{D}{M}{E}{S}{W}{_}                   {ECH; return DMESW;}
{_}{D}{M}{E}{S}{W}{I}{_}                {ECH; return DMESWI;}
{_}{D}{M}{E}{S}{W}{V}{_}                {ECH; return DMESWV;}
{_}{D}{M}{I}{S}{_}                      {ECH; return DMIS;}
{_}{D}{M}{I}{S}{M}{D}{_}                {ECH; return DMISMD;}
{_}{D}{M}{I}{S}{M}{N}{_}                {ECH; return DMISMN;}
{_}{D}{M}{L}{_}                         {ECH; return DML;}
{_}{D}{O}{_}                            {ECH; return DO;}
{_}{D}{O}{U}{B}{L}{E}{_}                {ECH; varType = REALVARNAME;
                                         return DOUBLE;}
{_}({D}{R}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return DR;}
{_}{D}{R}{A}{G}{_}                      {ECH; return DRAG;}
{_}{D}{R}{F}{_}                         {ECH; return DRF;}
{_}({D}{S}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return DS;}
{_}{D}{T}{O}{R}{_}                      {ECH; return DTOR;}
{_}({D}{V}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return DV;}
{_}{E}{D}{G}{E}{L}{N}{_}                {ECH; return EDGELN;}
{_}{E}{D}{G}{E}{P}{T}{_}                {ECH; return EDGEPT;}
{_}{E}{D}{I}{T}{_}                      {ECH; return EDIT;}
{_}{E}{L}{E}{M}{N}{T}{_}                {ECH; return ELEMNT;}
{_}{E}{L}{I}{M}{I}{N}{A}{T}{E}{_}       {ECH; return ELIMINATE;}
{_}{E}{L}{L}{I}{P}{S}{_}                {ECH; return ELLIPS;}
{_}{E}{L}{O}{N}{G}{C}{Y}{L}{_}          {ECH; return ELONGCYL;}
{_}{E}{L}{S}{E}{_}                      {ECH; return ELSE;}
{_}{E}{N}{D}{_}                         {ECH; return END;}
{_}{E}{N}{D}{C}{A}{S}{_}                {ECH; return ENDCAS;}
{_}{E}{N}{D}{D}{O}{_}                   {ECH; return ENDDO;}
{_}{E}{N}{D}{F}{I}{L}{_}                {ECH; 
                                         emptyScopeStack();
                                         if (scopeStack.next)
                                           { scopeStack.next = 0;
                                             return BAD;
                                           }
                                         return ENDFIL;}
{_}{E}{N}{D}{G}{O}{_}                   {ECH; return ENDGO;}
{_}{E}{N}{D}{I}{F}{_}                   {ECH; return ENDIF;}
{_}{E}{N}{D}{M}{A}{C}{_}                {ECH; 
                                         if (!scopeStack.next)
                                           {sprintf(lexMessage,
                                                    "ENDMAC misplaced");
                                            return BAD;}
                                         scopeStack.pop();
                                         return ENDMAC;}
{_}{E}{N}{D}{M}{E}{S}{_}                {ECH; return ENDMES;}
{_}{E}{N}{D}{S}{E}{L}{_}                {ECH; return ENDSEL;}
{_}{E}{N}{D}{S}{I}{M}{R}{E}{Q}{T}{_}    {ECH; return ENDSIMREQT;}
{_}{E}{N}{D}{X}{T}{N}{_}                {ECH; return ENDXTN;}
{_}{E}{N}{T}{I}{T}{Y}{_}                {ECH; return ENTITY;}
{_}{E}{O}{L}{N}{_}                      {ECH; return EOLN;}
{_}"."{E}{Q}"."{_}                      {ECH; return EQ;}
{_}{E}{Q}{U}{A}{T}{E}{_}                {ECH; return EQUATE;}
{_}{E}{R}{R}{_}                         {ECH; return ERR;}
{_}{E}{R}{R}{M}{O}{D}{E}{_}             {ECH; return ERRMODE;}
{_}({E}{R}{R}{O}{R}{_})/\/{_}"("        {ECH; BEGIN READLABEL;
                                         return ERROR;}
{_}{E}{R}{R}{O}{R}{_}                   {ECH; return ERROR;}
{_}{E}{V}{A}{L}{_}                      {ECH; return EVAL;}
{_}{E}{X}{C}{E}{P}{T}{_}                {ECH; return EXCEPT;}
{_}{E}{X}{I}{S}{T}{_}                   {ECH; return EXIST;}
{_}{E}{X}{P}{_}                         {ECH; return EXP;}
{_}{E}{X}{T}{E}{N}{S}{_}                {ECH; return EXTENS;}
{_}{E}{X}{T}{E}{R}{N}{_}                {ECH; return EXTERN;}
{_}{E}{X}{T}{F}{I}{L}{_}                {ECH; return EXTFIL;}
{_}{E}{X}{T}{R}{E}{M}{_}                {ECH; return EXTREM;}
{_}({F}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return F;}
{_}({F}{A}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return FA;}
{_}"."{F}{A}{L}{S}{E}"."{_}             {ECH; return FALSE;}
{_}{F}{D}{A}{T}{A}{_}                   {ECH; return FDATA;}
{_}{F}{E}{A}{T}{_}                      {ECH; return FEAT;}
{_}{F}{E}{A}{T}{U}{R}{_}                {ECH; return FEATUR;}
{_}{F}{E}{D}{R}{A}{T}{_}                {ECH; return FEDRAT;}
{_}{F}{E}{E}{D}{_}                      {ECH; return FEED;}
{_}{F}{E}{E}{T}{_}                      {ECH; return FEET;}
{_}({F}{I}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return FI;}
{_}{F}{I}{L}{D}{E}{F}{_}                {ECH; return FILDEF;}
{_}{F}{I}{L}{N}{A}{M}{_}                {ECH; return FILNAM;}
{_}{F}{I}{L}{T}{E}{R}{_}                {ECH; return FILTER;}
{_}{F}{I}{N}{P}{O}{S}{_}                {ECH; return FINPOS;}
{_}{F}{I}{R}{S}{T}{_}                   {ECH; return FIRST;}
{_}{F}{I}{X}{E}{D}{_}                   {ECH; return FIXED;}
{_}{F}{I}{X}{T}{I}{D}{_}                {ECH; return FIXTID;}
{_}{F}{I}{X}{T}{S}{N}{_}                {ECH; return FIXTSN;}
{_}{F}{L}{A}{T}{_}                      {ECH; return FLAT;}
{_}{F}{L}{I}{P}{_}                      {ECH; return FLIP;}
{_}{F}{L}{Y}{_}                         {ECH; return FLY;}
{_}{F}{O}{C}{U}{S}{N}{_}                {ECH; return FOCUSN;}
{_}{F}{O}{C}{U}{S}{Y}{_}                {ECH; return FOCUSY;}
{_}{F}{O}{R}{C}{E}{_}                   {ECH; return FORCE;}
{_}{F}{O}{R}{M}{_}                      {ECH; return FORM;}
{_}"4"{P}{O}{I}{N}{T}{_}                {ECH; return FOURPOINT;}
{_}{F}{R}{O}{M}{_}                      {ECH; return FROM;}
{_}({F}{S}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return FS;}
{_}{F}{X}{_}                            {ECH; return FX;}
{_}{F}{Z}{_}                            {ECH; return FZ;}
{_}({G}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return G;}
{_}{G}{A}{U}{S}{S}{_}                   {ECH; return GAUSS;}
{_}{G}{C}{U}{R}{V}{E}{_}                {ECH; return GCURVE;}
{_}"."{G}{E}"."{_}                      {ECH; return GE;}
{_}{G}{E}{O}{A}{L}{G}{_}                {ECH; return GEOALG;}
{_}{G}{E}{O}{M}{_}                      {ECH; return GEOM;}
{_}{G}{L}{O}{B}{A}{L}{_}                {ECH; return GLOBAL;}
{_}{G}{O}{H}{O}{M}{E}{_}                {ECH; return GOHOME;}
{_}{G}{O}{T}{A}{R}{G}{_}                {ECH; return GOTARG;}
{_}{G}{O}{T}{O}{_}                      {ECH; return GOTO;}
{_}{G}{R}{I}{D}{_}                      {ECH; return GRID;}
{_}{G}{R}{O}{U}{P}{_}                   {ECH; return GROUP;}
{_}({G}{S}{A}{_})/"("                   {ECH; BEGIN READLABEL;
                                         return GSA;}
{_}{G}{S}{U}{R}{F}{_}                   {ECH; return GSURF;}
{_}"."{G}{T}"."{_}                      {ECH; return GT;}
{_}{G}{T}{O}{L}{_}                      {ECH; return GTOL;}
{_}{H}{E}{A}{D}{C}{S}{_}                {ECH; return HEADCS;}
{_}{H}{E}{A}{D}{T}{O}{U}{C}{H}{_}       {ECH; return HEADTOUCH;}
{_}{H}{E}{D}{M}{E}{S}{A}{C}{L}{_}       {ECH; return HEDMESACL;}
{_}{H}{E}{D}{M}{E}{S}{V}{E}{L}{_}       {ECH; return HEDMESVEL;}
{_}{H}{E}{D}{R}{O}{T}{A}{C}{L}{_}       {ECH; return HEDROTACL;}
{_}{H}{E}{D}{R}{O}{T}{V}{E}{L}{_}       {ECH; return HEDROTVEL;}
{_}{H}{E}{D}{S}{C}{N}{A}{C}{L}{_}       {ECH; return HEDSCNACL;}
{_}{H}{E}{D}{S}{C}{N}{V}{E}{L}{_}       {ECH; return HEDSCNVEL;}
{_}{H}{E}{L}{I}{C}{A}{L}{_}             {ECH; return HELICAL;}
{_}{H}{I}{G}{H}{_}                      {ECH; return HIGH;}
{_}{H}{I}{G}{H}{P}{A}{S}{S}{_}          {ECH; return HIGHPASS;}
{_}{H}{I}{S}{T}{_}                      {ECH; return HIST;}
{_}{H}{U}{M}{I}{D}{_}                   {ECH; return HUMID;}
{_}{I}{F}{_}                            {ECH; return IF;}
{_}{I}{G}{E}{S}{_}                      {ECH; return IGES;}
{_}{I}{L}{L}{E}{G}{A}{L}{T}{O}{U}{C}{H}{_} {ECH; return ILLEGALTOUCH;}
{_}{I}{N}{C}{H}{_}                      {ECH; return INCH;}
{_}{I}{N}{C}{L}{U}{D}{_}                {ECH; return INCLUD;}
{_}{I}{N}{C}{R}{_}                      {ECH; return INCR;}
{_}{I}{N}{D}{E}{X}{_}                   {ECH; return INDEX;}
{_}{I}{N}{D}{X}{_}                      {ECH; return INDX;}
{_}{I}{N}{F}{R}{E}{D}{_}                {ECH; return INFRED;}
{_}{I}{N}{N}{E}{R}{_}                   {ECH; return INNER;}
{_}{I}{N}{P}{U}{T}{_}                   {ECH; return INPUT;}
{_}{I}{N}{T}{_}                         {ECH; return INT;}
{_}{I}{N}{T}{F}{P}{T}{_}                {ECH; return INTFPT;}
{_}{I}{N}{T}{G}{R}{_}                   {ECH; varType = INTVARNAME;
                                         return INTGR;}
{_}{I}{N}{T}{O}{F}{_}                   {ECH; return INTOF;}
{_}{I}{N}{T}{O}{L}{_}                   {ECH; return INTOL;}
{_}{I}{P}{_}                            {ECH; return IP;}
{_}{I}{P}{M}{_}                         {ECH; return IPM;}
{_}{I}{P}{M}{M}{_}                      {ECH; return IPMM;}
{_}{I}{P}{S}{_}                         {ECH; return IPS;}
{_}{I}{P}{S}{S}{_}                      {ECH; return IPSS;}
{_}{I}{T}{E}{R}{A}{T}{_}                {ECH; BEGIN READ2;
                                         return ITERAT;}
{_}{J}{O}{I}{N}{T}{C}{O}{N}{F}{I}{G}{_} {ECH; return JOINTCONFIG;}
{_}{J}{U}{M}{P}{T}{O}{_}                {ECH; BEGIN READLABEL;
                                         return JUMPTO;}
{_}({K}{C}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return KC;}
{_}({K}{C}{A}{_})/"("                   {ECH; BEGIN READLABEL;
                                         return KCA;}
{_}{K}{E}{E}{P}{_}                      {ECH; return KEEP;}
{_}{K}{E}{Y}{C}{H}{A}{R}{_}             {ECH; return KEYCHAR;}
{_}{L}{A}{M}{B}{D}{A}{C}{_}             {ECH; return LAMBDAC;}
{_}{L}{A}{S}{E}{R}{_}                   {ECH; return LASER;}
{_}"."{L}{E}"."{_}                      {ECH; return LE;}
{_}{L}{E}{F}{T}{_}                      {ECH; return LEFT;}
{_}{L}{E}{F}{T}{Y}{_}                   {ECH; return LEFTY;}
{_}{L}{E}{N}{_}                         {ECH; return LEN;}
{_}({L}{I}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return LI;}
{_}{L}{I}{M}{I}{T}{_}                   {ECH; return LIMIT;}
{_}{L}{I}{N}{E}{_}                      {ECH; return LINE;}
{_}{L}{I}{S}{T}{_}                      {ECH; return LIST;}
{_}{L}{I}{T}{D}{E}{F}{_}                {ECH; return LITDEF;}
{_}{L}{M}{C}{_}                         {ECH; return LMC;}
{_}{L}{N}{_}                            {ECH; return LN;}
{_}{L}{N}"2"{L}{N}{_}                   {ECH; return LN2LN;}
{_}{L}{O}{C}{A}{L}{_}                   {ECH; return LOCAL;}
{_}{L}{O}{C}{A}{T}{E}{_}                {ECH; return LOCATE;}
{_}{L}{O}{G}{_}                         {ECH; return LOG;}
{_}{L}{O}{N}{G}{_}                      {ECH; varType = REALVARNAME;
                                         return LONG;}
{_}{L}{O}{T}{I}{D}{_}                   {ECH; return LOTID;}
{_}{L}{O}{T}{I}{E}{R}{_}                {ECH; return LOTIER;}
{_}{L}{O}{W}{_}                         {ECH; return LOW;}
{_}{L}{O}{W}{P}{A}{S}{S}{_}             {ECH; return LOWPASS;}
{_}{L}{S}{T}{S}{Q}{R}{_}                {ECH; return LSTSQR;}
{_}"."{L}{T}"."{_}                      {ECH; return LT;}
{_}{L}{W}{C}{_}                         {ECH; return LWC;}
{_}({M}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return M;}
{_}({M}{A}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return MA;}
{_}{M}{A}{C}{H}{_}                      {ECH; return MACH;}
{_}{M}{A}{C}{R}{O}{_}                   {ECH; BEGIN MACROIN;
                                         scopeStack.push(new scope);
                                         return MACRO;}
{_}{M}{A}{J}{O}{R}{_}                   {ECH; return MAJOR;}
{_}{M}{A}{N}{_}                         {ECH; return MAN;}
{_}{M}{A}{S}{T}{E}{R}{_}                {ECH; return MASTER;}
{_}{M}{A}{T}{D}{E}{F}{_}                {ECH; return MATDEF;}
{_}{M}{A}{T}{R}{I}{X}{_}                {ECH; return MATRIX;}
{_}{M}{A}{X}{_}                         {ECH; return MAX;}
{_}{M}{A}{X}{I}{N}{S}{_}                {ECH; return MAXINS;}
{_}{M}{C}{_}                            {ECH; return MC;}
{_}{M}{C}{S}{_}                         {ECH; return MCS;}
{_}({M}{D}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return MD;}
{_}{M}{E}{A}{S}{_}                      {ECH; return MEAS;}
{_}{M}{E}{S}{A}{C}{L}{_}                {ECH; return MESACL;}
{_}{M}{E}{S}{V}{E}{L}{_}                {ECH; return MESVEL;}
{_}{M}{E}{T}{E}{R}{_}                   {ECH; return METER;}
{_}{M}{F}{G}{D}{E}{V}{_}                {ECH; return MFGDEV;}
{_}{M}{I}{D}{L}{I}{_}                   {ECH; return MIDLI;}
{_}{M}{I}{D}{P}{L}{_}                   {ECH; return MIDPL;}
{_}{M}{I}{D}{P}{T}{_}                   {ECH; return MIDPT;}
{_}{M}{I}{N}{_}                         {ECH; return MIN;}
{_}{M}{I}{N}{C}{I}{R}{_}                {ECH; return MINCIR;}
{_}{M}{I}{N}{C}{O}{N}{_}                {ECH; return MINCON;}
{_}{M}{I}{N}{M}{A}{X}{_}                {ECH; return MINMAX;}
{_}{M}{I}{N}{O}{R}{_}                   {ECH; return MINOR;}
{_}"-"{P}{R}{B}{R}{A}{D}{_}             {ECH; return MINUSPRBRAD;}
{_}"-"{X}{D}{I}{R}{_}                   {ECH; return MINUSXDIR;}
{_}"-"{Y}{D}{I}{R}{_}                   {ECH; return MINUSYDIR;}
{_}"-"{Z}{D}{I}{R}{_}                   {ECH; return MINUSZDIR;}
{_}{M}{L}{T}{P}{R}{B}{_}                {ECH; return MLTPRB;}
{_}{M}{M}{_}                            {ECH; return MM;}
{_}{M}{M}{C}{_}                         {ECH; return MMC;}
{_}{M}{M}{P}{S}{_}                      {ECH; return MMPS;}
{_}{M}{M}{P}{S}{S}{_}                   {ECH; return MMPSS;}
{_}{M}{N}{_}                            {ECH; return MN;}
{_}{M}{N}{T}{L}{E}{N}{_}                {ECH; return MNTLEN;}
{_}{M}{O}{D}{_}                         {ECH; return MOD;}
{_}{M}{O}{D}{E}{_}                      {ECH; return MODE;}
{_}{M}{O}{V}{E}{P}{T}{_}                {ECH; return MOVEPT;}
{_}{M}{P}{M}{_}                         {ECH; return MPM;}
{_}{M}{P}{M}{M}{_}                      {ECH; return MPMM;}
{_}{M}{U}{_}                            {ECH; return MU;}
{_}{M}{X}{_}                            {ECH; return MX;}
{_}{N}{A}{M}{E}{_}                      {ECH; return NAME;}
{_}"."{N}{E}"."{_}                      {ECH; return NE;}
{_}{N}{E}{A}{R}{P}{T}{_}                {ECH; return NEARPT;}
{_}{N}{E}{X}{T}{_}                      {ECH; return NEXT;}
{_}{N}{I}{N}{T}{_}                      {ECH; return NINT;}
{_}{N}{O}{D}{A}{T}{A}{_}                {ECH; return NODATA;}
{_}{N}{O}{F}{L}{I}{P}{_}                {ECH; return NOFLIP;}
{_}{N}{O}{M}{_}                         {ECH; return NOM;}
{_}{N}{O}{M}{I}{N}{L}{_}                {ECH; return NOMINL;}
{_}{N}{O}{N}{C}{O}{N}{_}                {ECH; return NONCON;}
{_}{N}{O}{N}{E}{_}                      {ECH; return NONE;}
{_}{N}{O}{R}{O}{T}{_}                   {ECH; return NOROT;}
{_}"."{N}{O}{T}"."{_}                   {ECH; return NOT;}
{_}{N}{O}{T}{O}{U}{C}{H}{_}             {ECH; return NOTOUCH;}
{_}{N}{O}{T}{R}{A}{N}{_}                {ECH; return NOTRAN;}
{_}{N}{U}{M}{E}{R}{I}{C}{_}             {ECH; return NUMERIC;}
{_}{N}{U}{R}{B}{S}{_}                   {ECH; return NURBS;}
{_}{O}{B}{J}{E}{C}{T}{_}                {ECH; return OBJECT;}
{_}{O}{B}{L}{Q}{_}                      {ECH; return OBLQ;}
{_}{O}{B}{T}{A}{I}{N}{_}                {ECH; return OBTAIN;}
{_}{O}{F}{F}{_}                         {ECH; return OFF;}
{_}{O}{F}{F}{S}{E}{T}{_}                {ECH; return OFFSET;}
{_}{O}{N}{_}                            {ECH; return ON;}
{_}({O}{P}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return OP;}
{_}{O}{P}{E}{N}{_}                      {ECH; return OPEN;}
{_}{O}{P}{E}{R}{_}                      {ECH; return OPER;}
{_}{O}{P}{E}{R}{I}{D}{_}                {ECH; return OPERID;}
{_}{O}{P}{T}{I}{M}{A}{L}{_}             {ECH; return OPTIMAL;}
{_}"."{O}{R}"."{_}                      {ECH; return OR;}
{_}{O}{R}{D}{_}                         {ECH; return ORD;}
{_}{O}{R}{I}{E}{N}{T}{_}                {ECH; return ORIENT;}
{_}{O}{U}{T}{E}{R}{_}                   {ECH; return OUTER;}
{_}{O}{U}{T}{F}{I}{L}{_}                {ECH; return OUTFIL;}
{_}{O}{U}{T}{O}{L}{_}                   {ECH; return OUTOL;}
{_}{O}{U}{T}{P}{U}{T}{_}                {ECH; return OUTPUT;}
{_}{O}{V}{E}{R}{W}{R}{_}                {ECH; return OVERWR;}
{_}({P}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return P;}
{_}{P}{A}{M}{E}{A}{S}{_}                {ECH; return PAMEAS;}
{_}{P}{A}{R}{A}{M}{_}                   {ECH; return PARAM;}
{_}{P}{A}{R}{L}{E}{L}{_}                {ECH; return PARLEL;}
{_}{P}{A}{R}{P}{L}{N}{_}                {ECH; return PARPLN;}
{_}{P}{A}{R}{T}{_}                      {ECH; return PART;}
{_}{P}{A}{R}{T}{I}{D}{_}                {ECH; return PARTID;}
{_}{P}{A}{R}{T}{O}{_}                   {ECH; return PARTO;}
{_}{P}{A}{R}{T}{R}{V}{_}                {ECH; return PARTRV;}
{_}{P}{A}{R}{T}{S}{N}{_}                {ECH; return PARTSN;}
{_}{P}{A}{T}{E}{R}{N}{_}                {ECH; return PATERN;}
{_}{P}{A}{T}{H}{_}                      {ECH; return PATH;}
{_}{P}{A}{U}{S}{E}{_}                   {ECH; return PAUSE;}
{_}({P}{C}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return PC;}
{_}{P}{C}{E}{N}{T}{_}                   {ECH; return PCENT;}
{_}{P}{C}{S}{_}                         {ECH; return PCS;}
{_}{P}{E}{C}{K}{_}                      {ECH; return PECK;}
{_}{P}{E}{R}{C}{N}{T}{_}                {ECH; return PERCNT;}
{_}{P}{E}{R}{P}{_}                      {ECH; return PERP;}
{_}{P}{E}{R}{P}{T}{O}{_}                {ECH; return PERPTO;}
{_}{P}{I}{C}{T}{U}{R}{E}{_}             {ECH; return PICTURE;}
{_}{P}{I}{E}{R}{C}{E}{_}                {ECH; return PIERCE;}
{_}{P}{I}{T}{C}{H}{_}                   {ECH; return PITCH;}
{_}{P}{I}{X}{B}{T}{N}{_}                {ECH; return PIXBTN;}
{_}({P}{L}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return PL;}
{_}{P}{L}{A}{N}{E}{_}                   {ECH; return PLANE;}
{_}{P}{L}{A}{N}{I}{D}{_}                {ECH; return PLANID;}
{_}{P}{L}{O}{T}{_}                      {ECH; return PLOT;}
{_}{P}{M}{_}                            {ECH; return PM;}
{_}({P}{N}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return PN;}
{_}{P}{O}{I}{N}{T}{_}                   {ECH; return POINT;}
{_}{P}{O}{L}{_}                         {ECH; return POL;}
{_}{P}{O}{P}{_}                         {ECH; return POP;}
{_}{P}{O}{S}{_}                         {ECH; return POS;}
{_}{P}{O}{S}{A}{C}{L}{_}                {ECH; return POSACL;}
{_}{P}{O}{S}{V}{E}{L}{_}                {ECH; return POSVEL;}
{_}({P}{R}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return PR;}
{_}{P}{R}{B}{R}{A}{D}{_}                {ECH; return PRBRAD;}
{_}{P}{R}{C}{O}{M}{P}{_}                {ECH; return PRCOMP;}
{_}{P}{R}{E}{V}{O}{P}{_}                {ECH; return PREVOP;}
{_}{P}{R}{I}{N}{T}{_}                   {ECH; return PRINT;}
{_}{P}{R}{N}{T}{C}{H}{A}{R}{_}          {ECH; return PRNTCHAR;}
{_}{P}{R}{O}{B}{E}{_}                   {ECH; return PROBE;}
{_}{P}{R}{O}{C}{I}{D}{_}                {ECH; return PROCID;}
{_}{P}{R}{O}{F}{L}{_}                   {ECH; return PROFL;}
{_}{P}{R}{O}{F}{P}{_}                   {ECH; return PROFP;}
{_}{P}{R}{O}{F}{S}{_}                   {ECH; return PROFS;}
{_}{P}{R}{O}{G}{_}                      {ECH; return PROG;}
{_}{P}{R}{O}{J}{C}{T}{_}                {ECH; return PROJCT;}
{_}{P}{R}{O}{J}{L}{I}{_}                {ECH; return PROJLI;}
{_}{P}{R}{O}{J}{P}{T}{_}                {ECH; return PROJPT;}
{_}{P}{R}{O}{M}{P}{T}{_}                {ECH; return PROMPT;}
{_}({P}{S}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return PS;}
{_}{P}{S}{T}{H}{R}{U}{_}                {ECH; return PSTHRU;}
{_}{P}{T}"2"{L}{N}{_}                   {ECH; return PT2LN;}
{_}{P}{T}"2"{P}{L}{_}                   {ECH; return PT2PL;}
{_}{P}{T}"2"{P}{T}{_}                   {ECH; return PT2PT;}
{_}{P}{T}{B}{U}{F}{F}{_}                {ECH; return PTBUFF;}
{_}{P}{T}{D}{A}{T}{A}{_}                {ECH; return PTDATA;}
{_}{P}{T}{M}{E}{A}{S}{_}                {ECH; return PTMEAS;}
{_}{P}{U}{S}{H}{_}                      {ECH; return PUSH;}
{_}({P}{V}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return PV;}
{_}({Q}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return Q;}
{_}{Q}{I}{_}                            {ECH; return QI;}
{_}{Q}{I}{S}{D}{E}{F}{_}                {ECH; return QISDEF;}
{_}{Q}{T}{E}{M}{P}{_}                   {ECH; return QTEMP;}
{_}{Q}{U}{E}{R}{Y}{_}                   {ECH; BEGIN READLABEL;
                                         return QUERY;}
{_}({R}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return R;}
{_}{R}{A}{D}{_}                         {ECH; return RAD;}
{_}{R}{A}{D}{I}{A}{L}{_}                {ECH; return RADIAL;}
{_}{R}{A}{D}{I}{U}{S}{_}                {ECH; return RADIUS;}
{_}{R}{A}{M}{_}                         {ECH; return RAM;}
{_}{R}{A}{N}{D}{_}                      {ECH; return RAND;}
{_}{R}{A}{P}{I}{D}{_}                   {ECH; return RAPID;}
{_}{R}{C}{T}{N}{G}{L}{_}                {ECH; return RCTNGL;}
{_}{R}{E}{A}{D}{_}                      {ECH; return READ;}
{_}{R}{E}{A}{L}{_}                      {ECH; varType = REALVARNAME;
                                         return REAL;}
{_}{R}{E}{C}{A}{L}{I}{B}{_}             {ECH; return RECALIB;}
{_}{R}{E}{C}{A}{L}{L}{_}                {ECH; return RECALL;}
{_}{R}{E}{C}{F}{I}{L}{T}{_}             {ECH; return RECFILT;}
{_}{R}{E}{F}{M}{N}{T}{_}                {ECH; return REFMNT;}
{_}{R}{E}{M}{O}{V}{E}{_}                {ECH; return REMOVE;}
{_}{R}{E}{P}{O}{R}{T}{_}                {ECH; return REPORT;}
{_}({R}{E}{S}{U}{M}{E}{_})/\/{_}"("     {ECH; BEGIN READLABEL;
                                         return RESUME;}
{_}{R}{E}{S}{U}{M}{E}{_}                {ECH; return RESUME;}
{_}{R}{E}{T}{R}{C}{T}{_}                {ECH; return RETRCT;}
{_}{R}{E}{T}{R}{I}{E}{V}{E}{_}          {ECH; return RETRIEVE;}
{_}{R}{E}{V}{S}{U}{R}{F}{_}             {ECH; return REVSURF;}
{_}{R}{F}{S}{_}                         {ECH; return RFS;}
{_}{R}{I}{G}{H}{T}{_}                   {ECH; return RIGHT;}
{_}{R}{I}{G}{H}{T}{Y}{_}                {ECH; return RIGHTY;}
{_}{R}{L}{_}                            {ECH; return RL;}
{_}({R}{M}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return RM;}
{_}{R}{M}{E}{A}{S}{_}                   {ECH; return RMEAS;}
{_}{R}{O}{T}{A}{B}{_}                   {ECH; return ROTAB;}
{_}{R}{O}{T}{A}{C}{L}{_}                {ECH; return ROTACL;}
{_}{R}{O}{T}{A}{R}{Y}{_}                {ECH; return ROTARY;}
{_}{R}{O}{T}{A}{T}{E}{_}                {ECH; return ROTATE;}
{_}{R}{O}{T}{C}{E}{N}{_}                {ECH; return ROTCEN;}
{_}{R}{O}{T}{D}{E}{F}{_}                {ECH; return ROTDEF;}
{_}{R}{O}{T}{N}{U}{L}{_}                {ECH; return ROTNUL;}
{_}{R}{O}{T}{O}{R}{G}{_}                {ECH; return ROTORG;}
{_}{R}{O}{T}{S}{E}{T}{_}                {ECH; return ROTSET;}
{_}{R}{O}{T}{T}{O}{T}{_}                {ECH; return ROTTOT;}
{_}{R}{O}{T}{V}{E}{L}{_}                {ECH; return ROTVEL;}
{_}{R}{O}{U}{N}{D}{_}                   {ECH; return ROUND;}
{_}{R}{P}{M}{_}                         {ECH; return RPM;}
{_}{R}{P}{M}{M}{_}                      {ECH; return RPMM;}
{_}{R}{P}{T}{_}                         {ECH; return RPT;}
{_}({R}{T}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return RT;}
{_}{R}{T}{A}{B}{_}                      {ECH; return RTAB;}
{_}{R}{T}{O}{D}{_}                      {ECH; return RTOD;}
{_}{R}{U}{L}{E}{_}                      {ECH; return RULE;}
{_}{R}{Y}{_}                            {ECH; return RY;}
{_}({S}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return S;}
{_}({S}{A}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return SA;}
{_}{S}{A}{V}{E}{_}                      {ECH; return SAVE;}
{_}{S}{C}{A}{L}{E}{_}                   {ECH; return SCALE;}
{_}{S}{C}{A}{L}{E}{X}{_}                {ECH; return SCALEX;}
{_}{S}{C}{A}{L}{E}{Y}{_}                {ECH; return SCALEY;}
{_}{S}{C}{F}{E}{A}{T}{_}                {ECH; return SCFEAT;}
{_}{S}{C}{N}{A}{C}{L}{_}                {ECH; return SCNACL;}
{_}{S}{C}{N}{M}{O}{D}{_}                {ECH; return SCNMOD;}
{_}{S}{C}{N}{S}{E}{T}{_}                {ECH; return SCNSET;}
{_}{S}{C}{N}{V}{E}{L}{_}                {ECH; return SCNVEL;}
{_}{S}{C}{S}{N}{S}{_}                   {ECH; return SCSNS;}
{_}{S}{D}{A}{T}{E}{_}                   {ECH; return SDATE;}
{_}{S}{D}{A}{T}{E}{T}{I}{M}{E}{_}       {ECH; return SDATETIME;}
{_}({S}{E}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return SE;}
{_}{S}{E}{A}{R}{C}{H}{_}                {ECH; return SEARCH;}
{_}{S}{E}{L}{A}{P}{S}{E}{T}{I}{M}{E}{_} {ECH; return SELAPSETIME;}
{_}{S}{E}{L}{E}{C}{T}{_}                {ECH; return SELECT;}
{_}{S}{E}{L}{F}{C}{E}{N}{T}{E}{R}{_}    {ECH; return SELFCENTER;}
{_}{S}{E}{N}{S}{_}                      {ECH; return SENS;}
{_}{S}{E}{N}{S}{N}{O}{T}{O}{U}{C}{H}{_} {ECH; return SENSNOTOUCH;}
{_}{S}{E}{N}{S}{O}{R}{_}                {ECH; return SENSOR;}
{_}{S}{E}{Q}{N}{T}{L}{_}                {ECH; return SEQNTL;}
{_}{S}{E}{R}{R}{O}{R}{_}                {ECH; return SERROR;}
{_}{S}{F}{_}                            {ECH; return SF;}
{_}({S}{G}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return SG;}
{_}{S}{G}{A}{G}{E}{_}                   {ECH; return SGAGE;}
{_}({S}{G}{S}{_})/"("                   {ECH; BEGIN READLABEL;
                                         return SGS;}
{_}{S}{H}{O}{R}{T}{_}                   {ECH; return SHORT;}
{_}{S}{I}{G}{N}{_}                      {ECH; return SIGN;}
{_}{S}{I}{L}{T}{C}{H}{_}                {ECH; return SILTCH;}
{_}{S}{I}{M}{R}{E}{Q}{T}{_}             {ECH; return SIMREQT;}
{_}{S}{I}{M}{U}{L}{_}                   {ECH; return SIMUL;}
{_}{S}{I}{N}{_}                         {ECH; return SIN;}
{_}{S}{I}{N}{G}{L}{E}{_}                {ECH; return SINGLE;}
{_}{S}{I}{Z}{E}{_}                      {ECH; return SIZE;}
{_}{S}{M}{O}{D}{E}{_}                   {ECH; return SMODE;}
{_}{S}{N}{S}{_}                         {ECH; return SNS;}
{_}{S}{N}{S}{D}{E}{F}{_}                {ECH; return SNSDEF;}
{_}{S}{N}{S}{E}{T}{_}                   {ECH; return SNSET;}
{_}{S}{N}{S}{G}{R}{P}{_}                {ECH; return SNSGRP;}
{_}{S}{N}{S}{L}{C}{T}{_}                {ECH; return SNSLCT;}
{_}{S}{N}{S}{M}{N}{T}{_}                {ECH; return SNSMNT;}
{_}{S}{O}{U}{N}{D}{_}                   {ECH; return SOUND;}
{_}{S}{P}{A}{R}{T}{_}                   {ECH; return SPART;}
{_}{S}{P}{H}{_}                         {ECH; return SPH;}
{_}{S}{P}{H}{E}{R}{E}{_}                {ECH; return SPHERE;}
{_}{S}{P}{H}{R}{A}{D}{S}{E}{G}{M}{N}{T}{_} {ECH; return SPHRADSEGMNT;}
{_}{S}{P}{L}{I}{N}{E}{_}                {ECH; return SPLINE;}
{_}{S}{Q}{R}{T}{_}                      {ECH; return SQRT;}
{_}({S}{R}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return SR;}
{_}{S}{R}{A}{_}                         {ECH; return SRA;}
{_}({S}{S}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return SS;}
{_}({S}{T}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return ST;}
{_}{S}{T}{A}{R}{T}{_}                   {ECH; return START;}
{_}{S}{T}{A}{T}{_}                      {ECH; return STAT;}
{_}{S}{T}{D}{D}{E}{V}"_"{L}{I}{M}{I}{T}{_} {ECH; return STDDEVLIMIT;}
{_}{S}{T}{E}{P}{_}                      {ECH; return STEP;}
{_}{S}{T}{I}{M}{E}{_}                   {ECH; return STIME;}
{_}{S}{T}{O}{P}{_}                      {ECH; return STOP;}
{_}{S}{T}{O}{R}{_}                      {ECH; return STOR;}
{_}{S}{T}{R}{_}                         {ECH; return STR;}
{_}{S}{T}{R}{G}{H}{T}{_}                {ECH; return STRGHT;}
{_}{S}{T}{R}{O}{B}{E}{_}                {ECH; return STROBE;}
{_}{S}{U}{B}{S}{T}{R}{_}                {ECH; return SUBSTR;}
{_}{S}{U}{R}{F}{_}                      {ECH; return SURF;}
{_}{S}{U}{R}{F}{A}{C}{E}{_}             {ECH; return SURFACE;}
{_}({S}{W}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return SW;}
{_}({S}{X}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return SX;}
{_}{S}{Y}{M}{_}                         {ECH; return SYM;}
{_}{S}{Y}{M}{P}{L}{N}{_}                {ECH; return SYMPLN;}
{_}{S}{Y}{N}{C}{_}                      {ECH; return SYNC;}
{_}{S}{Y}{S}{_}                         {ECH; return SYS;}
{_}({T}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return T;}
{_}({T}{A}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return TA;}
{_}{T}{A}{N}{_}                         {ECH; return TAN;}
{_}{T}{A}{N}{G}{P}{L}{_}                {ECH; return TANGPL;}
{_}{T}{A}{N}{T}{O}{_}                   {ECH; return TANTO;}
{_}{T}{E}{C}{O}{M}{P}{_}                {ECH; return TECOMP;}
{_}{T}{E}{M}{P}{_}                      {ECH; return TEMP;}
{_}{T}{E}{M}{P}{C}{_}                   {ECH; return TEMPC;}
{_}{T}{E}{M}{P}{F}{_}                   {ECH; return TEMPF;}
{_}{T}{E}{M}{P}{W}{C}{_}                {ECH; return TEMPWC;}
{_}{T}{E}{M}{P}{W}{F}{_}                {ECH; return TEMPWF;}
{_}{T}{E}{R}{M}{_}                      {ECH; return TERM;}
{_}{T}{E}{X}{T}{_}                      {ECH; return TEXT;}
{_}({T}{H}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return TH;}
{_}{T}{H}{L}{D}{E}{F}{_}                {ECH; return THLDEF;}
{_}"3"{D}{_}                            {ECH; return THREED;}
{_}{T}{H}{R}{U}{_}                      {ECH; return THRU;}
{_}{T}{I}{M}{E}{_}                      {ECH; return TIME;}
{_}{T}{I}{T}{L}{E}{_}                   {ECH; return TITLE;}
{_}({T}{L}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return TL;}
{_}{T}{O}{L}{_}                         {ECH; return TOL;}
{_}{T}{O}{O}{L}{D}{F}{_}                {ECH; return TOOLDF;}
{_}{T}{O}{R}{R}{A}{D}{S}{E}{G}{M}{N}{T}{_} {ECH; return TORRADSEGMNT;}
{_}{T}{O}{R}{U}{S}{_}                   {ECH; return TORUS;}
{_}{T}{R}{_}                            {ECH; return TR;}
{_}{T}{R}{A}{N}{S}{_}                   {ECH; return TRANS;}
{_}{T}{R}{I}{G}{E}{R}{_}                {ECH; return TRIGER;}
{_}{T}{R}{I}{M}{_}                      {ECH; return TRIM;}
{_}{T}{R}{M}{A}{T}{X}{_}                {ECH; return TRMATX;}
{_}{T}{R}{N}{O}{U}{T}{_}                {ECH; return TRNOUT;}
{_}"."{T}{R}{U}{E}"."{_}                {ECH; return TRUE;}
{_}{T}{W}{_}                            {ECH; return TW;}
{_}"2"{D}{_}                            {ECH; return TWOD;}
{_}"2"{R}{C}{_}                         {ECH; return TWORC;}
{_}({U}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return U;}
{_}{U}{N}{B}{N}{D}{_}                   {ECH; return UNBND;}
{_}{U}{N}{C}{E}{R}{T}{A}{L}{G}{_}       {ECH; return UNCERTALG;}
{_}{U}{N}{C}{E}{R}{T}{S}{E}{T}{_}       {ECH; return UNCERTSET;}
{_}{U}{N}{I}{T}{S}{_}                   {ECH; return UNITS;}
{_}{U}{N}{K}{N}{O}{W}{N}{_}             {ECH; return UNKNOWN;}
{_}{U}{P}{C}{_}                         {ECH; return UPC;}
{_}{U}{P}{T}{I}{E}{R}{_}                {ECH; return UPTIER;}
{_}{U}{S}{E}{R}{D}{F}{_}                {ECH; return USERDF;}
{_}{U}{S}{E}{T}{O}{L}{_}                {ECH; return USETOL;}
{_}({V}{_})/"("                         {ECH; BEGIN READLABEL;
                                         return V;}
{_}({V}{A}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return VA;}
{_}{V}{A}{L}{_}                         {ECH; return VAL;}
{_}{V}{A}{L}{U}{E}{_}                   {ECH; return VALUE;}
{_}{V}{C}{A}{R}{T}{_}                   {ECH; return VCART;}
{_}{V}{C}{R}{O}{S}{S}{_}                {ECH; return VCROSS;}
{_}{V}{D}{O}{T}{_}                      {ECH; return VDOT;}
{_}{V}{E}{C}{_}                         {ECH; return VEC;}
{_}{V}{E}{C}{B}{L}{D}{_}                {ECH; return VECBLD;}
{_}{V}{E}{C}{T}{O}{R}{_}                {ECH; varType = VECTORVARNAME;
                                         return VECTOR;}
{_}{V}{E}{C}{X}{_}                      {ECH; return VECX;}
{_}{V}{E}{C}{Y}{_}                      {ECH; return VECY;}
{_}{V}{E}{C}{Z}{_}                      {ECH; return VECZ;}
{_}{V}{E}{N}{D}{O}{R}{_}                {ECH; return VENDOR;}
{_}{V}{E}{R}{S}{I}{O}{N}{_}             {ECH; return VERSION;}
{_}{V}{E}{R}{T}{E}{X}{_}                {ECH; return VERTEX;}
{_}({V}{F}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return VF;}
{_}{V}{F}{O}{R}{M}{_}                   {ECH; return VFORM;}
{_}{V}{I}{D}{E}{O}{_}                   {ECH; return VIDEO;}
{_}({V}{L}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return VL;}
{_}{V}{M}{A}{G}{_}                      {ECH; return VMAG;}
{_}{V}{M}{C}{S}{_}                      {ECH; return VMCS;}
{_}{V}{P}{C}{S}{_}                      {ECH; return VPCS;}
{_}{V}{P}{O}{L}{_}                      {ECH; return VPOL;}
{_}{V}{U}{N}{I}{T}{_}                   {ECH; return VUNIT;}
{_}({V}{W}{_})/"("                      {ECH; BEGIN READLABEL;
                                         return VW;}
{_}{W}{A}{I}{T}{_}                      {ECH; return WAIT;}
{_}{W}{I}{D}{T}{H}{_}                   {ECH; return WIDTH;}
{_}{W}{I}{N}{D}{E}{F}{_}                {ECH; return WINDEF;}
{_}{W}{K}{P}{L}{A}{N}{_}                {ECH; return WKPLAN;}
{_}{W}{R}{I}{S}{T}{_}                   {ECH; return WRIST;}
{_}{W}{R}{I}{T}{E}{_}                   {ECH; return WRITE;}
{_}{E}{O}{F}{_}                         {ECH; return WWEOF;}
{_}{X}{A}{X}{I}{S}{_}                   {ECH; return XAXIS;}
{_}{X}{D}{I}{R}{_}                      {ECH; return XDIR;}
{_}{X}{O}{R}{I}{G}{_}                   {ECH; return XORIG;}
{_}{X}{T}{E}{R}{N}{_}                   {ECH; return XTERN;}
{_}{X}{T}{R}{A}{C}{T}{_}                {ECH; return XTRACT;}
{_}{X}{V}{E}{C}{_}                      {ECH; return XVEC;}
{_}{X}{Y}{A}{X}{I}{S}{_}                {ECH; return XYAXIS;}
{_}{X}{Y}{D}{I}{R}{_}                   {ECH; return XYDIR;}
{_}{X}{Y}{P}{L}{A}{N}{_}                {ECH; return XYPLAN;}
{_}{X}{Y}{Z}{A}{X}{I}{_}                {ECH; return XYZAXI;}
{_}{X}{Y}{Z}{D}{I}{R}{_}                {ECH; return XYZDIR;}
{_}{Y}{A}{X}{I}{S}{_}                   {ECH; return YAXIS;}
{_}{Y}{D}{I}{R}{_}                      {ECH; return YDIR;}
{_}{Y}{O}{R}{I}{G}{_}                   {ECH; return YORIG;}
{_}{Y}{Z}{A}{X}{I}{S}{_}                {ECH; return YZAXIS;}
{_}{Y}{Z}{D}{I}{R}{_}                   {ECH; return YZDIR;}
{_}{Y}{Z}{P}{L}{A}{N}{_}                {ECH; return YZPLAN;}
{_}{Z}{A}{X}{I}{S}{_}                   {ECH; return ZAXIS;}
{_}{Z}{D}{I}{R}{_}                      {ECH; return ZDIR;}
{_}{Z}{O}{R}{I}{G}{_}                   {ECH; return ZORIG;}
{_}{Z}{V}{E}{C}{_}                      {ECH; return ZVEC;}
{_}{Z}{X}{A}{X}{I}{S}{_}                {ECH; return ZXAXIS;}
{_}{Z}{X}{D}{I}{R}{_}                   {ECH; return ZXDIR;}
{_}{Z}{X}{P}{L}{A}{N}{_}                {ECH; return ZXPLAN;}
{_}'                                    {ECH; j=0; BEGIN INSTRING;}
<INSTRING>('')                          {ECH; stringText[j++] = '\'';}
<INSTRING>'{_}                          {ECH; BEGIN INITIAL;
                                         stringText[j] = 0;
                                         yylval.sval = strdup(stringText);
                                         return CHARSTRING;}
<INSTRING>[ -&(-~\t]                    {ECH; stringText[j++]=yytext[0];}
<INSTRING>\n                            {ECH;
                                         sprintf(lexMessage,
                                                 "newline in string");
                                         BEGIN INITIAL;
                                         return BAD;}
<INSTRING>.                             {ECH;
                                         sprintf(lexMessage,
                                              "bad character in string");
                                         BEGIN INITIAL;
                                         return BAD;}
<READLABEL>{_}[-a-zA-Z0-9._]{1,64}{_}   {ECH; BEGIN INITIAL;
                                         shiftUpcase(yytext);
                                         yylval.sval = strdup(yytext);
                                         return LBLNAME;}
<READLABEL>{_}"@"{_}                    {ECH; BEGIN INITIAL;
                                         return AT;}
<READLABEL>{_}"/"{_}                    {ECH; return SLASH;}
<READLABEL>{_}"("{_}                    {ECH; return LPAREN;}
<READLABEL>{_}")"{_}                    {ECH; return RPAREN;}
<READLABEL>{_}","{_}                    {ECH; return C;}
<READLABEL>\n                           {ECH;
                                         sprintf(lexMessage,
                                                 "label missing");
                                         BEGIN INITIAL;
                                         return BAD;}
<READLABEL>.                            {ECH;
                                         sprintf(lexMessage,
                                               "bad character in label");
                                         BEGIN INITIAL;
                                         return BAD;}
<READ2>{_}[-a-zA-Z0-9._]{1,64}{_}       {ECH; BEGIN READLABEL;
                                         shiftUpcase(yytext);
                                         yylval.sval = strdup(yytext);
                                         return LBLNAME;}
<READ2>{_}"@"{_}                        {ECH; BEGIN AT2;
                                         return AT;}
<READ2>{_}"/"{_}                        {ECH; return SLASH;}
<READ2>{_}"("{_}                        {ECH; return LPAREN;}
<READ2>\n                               {ECH;
                                         sprintf(lexMessage,
                                                 "label missing");
                                         BEGIN INITIAL;
                                         return BAD;}
<READ2>.                                {ECH;
                                         sprintf(lexMessage,
                                            "bad character in label");
                                         BEGIN INITIAL;
                                         return BAD;}
<AT2>{_}[a-zA-Z][a-zA-Z0-9_]{0,15}{_}  {ECH;
                                    shiftUpcase(yytext);
                                    yylval.sval = strdup(yytext);
                                    if (findVariable(yytext, &varType, 0))
                                      {
                                        BEGIN READLABEL;
                                        return varType;
                                      }
                                    else
                                      {
                                        sprintf(lexMessage,
                                                "undefined variable");
                                        BEGIN INITIAL;
                                        return BAD;
                                      }
                                    }
<AT2>\n                            {ECH;
                                    sprintf(lexMessage,
                                            "variable missing");
                                    BEGIN INITIAL;
                                    return BAD;}
<AT2>.                             {ECH;
                                    sprintf(lexMessage,
                                            "bad character in variable");
                                    BEGIN INITIAL;
                                    return BAD;}
<CALLARGS>[^\r]*                   {ECH;
                                    if (closeUpcase(yytext))
                                      {
                                        sprintf(lexMessage,
                                                "unclosed string");
                                        return BAD;
                                      }
                                    yylval.sval = strdup(yytext);
                                    return CHARSTRING;}
<CALLARGS>\r\n                     {ECH; getCallArgs = 0;
                                    BEGIN INITIAL;
                                    return ENDLINE;}
<MACROIN>"/"                       {ECH;
                                    return SLASH;}
<MACROIN>{_}","{_}                 {ECH; return C;}
<MACROIN>{_}[a-zA-Z][a-zA-Z0-9_]{0,15}{_}  {ECH;
                                   shiftUpcase(yytext);
                                   yylval.sval = strdup(yytext);
                                   if (findVariable(yytext, &varType, 1))
                                     {
                                       sprintf(lexMessage,
                                               "argument reused");
                                       return BAD;
                                     }
                                   else
                                     {
                                       recordVariable(yytext, MACROVARNAME);
                                       return MACROVARNAME;
                                     }
                                   }
<MACROIN>{_}'[a-zA-Z][a-zA-Z0-9_]{0,15}'{_}  {ECH; // remove quotes
                                   yytext[yyleng-1] = 0;
                                   yylval.sval = strdup(yytext+1);
				   strcpy(stringText, (yytext+1));
				   shiftUpcase(stringText);
                                   if (findVariable(stringText, &varType, 1))
                                     {
                                       sprintf(lexMessage,
                                               "argument reused");
                                       return BAD;
                                     }
                                   else
                                     {
                                       recordVariable(stringText,
                                                      MACROVARNAME);
                                       return CHARSTRING;
                                     }
                                   }
<MACROIN>\r\n                      {ECH;
                                    BEGIN MACROLINENUM;
                                    return ENDLINE;}
<MACROLINE>{_}{E}{N}{D}{M}{A}{C}{_} {ECH;
                                     if (scopeStack.next) scopeStack.pop();
                                     BEGIN INITIAL; return ENDMAC;}
<MACROLINE>{_}{E}{N}{D}{F}{I}{L}{_} {ECH;
                                     if (scopeStack.next) scopeStack.pop();
                                     BEGIN INITIAL; return ENDFIL;}
<MACROLINE>[^\r]*                  {ECH;
                                    if (closeUpcase(yytext))
                                      {
                                        sprintf(lexMessage,
                                                "unclosed string");
                                        return BAD;
                                      }
                                    yylval.sval = strdup(yytext);
                                    return CHARSTRING;}
<MACROLINE>\r\n                    {ECH;
                                    BEGIN MACROLINENUM;
                                    return ENDLINE;}
<MACROLINENUM>^[0-9]+"|"           {lineTextIndex=0;
                                    sscanf(yytext,"%d",&lineNo);
                                    j = 0;
                                    BEGIN MACROLINE;}
<DMISOFFLINENUM>^[0-9]+"|"         {lineTextIndex=0;
                                    sscanf(yytext,"%d",&lineNo);
                                    j = 0;
                                    BEGIN DMISOFFLINE;}
<DMISOFFLINE>{_}{D}{M}{I}{S}{_}/("/"{_}{O}{N}{_}\r\n) {ECH;
                                    BEGIN INITIAL;
                                    return DMIS;}
<DMISOFFLINE>{_}{E}{N}{D}{F}{I}{L}{_} {ECH;
                                    BEGIN INITIAL;
                                    return ENDFIL;}
<DMISOFFLINE>[^\r]*                {ECH; yylval.sval = strdup(yytext);
                                    return CHARSTRING;}
<DMISOFFLINE>\r\n                  {ECH;
                                    BEGIN DMISOFFLINENUM;
                                    return ENDLINE;}
<DMISOFFIN>"/"                     {ECH;
                                    return SLASH;}
<DMISOFFIN>{_}{O}{F}{F}{_}         {ECH;
                                    return OFF;}
<DMISOFFIN>\r\n                    {ECH;
                                    BEGIN DMISOFFLINENUM;
                                    return ENDLINE;}
{_}{D}{M}{I}{S}{_}/("/"{_}{O}{F}{F}{_}\r\n) {ECH; BEGIN DMISOFFIN;
                                             return DMIS;}
^[0-9]+"|$$Next macro is a dummy - qwerty"\r\n { macroIsReal = 0; }
^[0-9]+"|"{_}"("{_}                     {doLineNo(); ECH;
                                         BEGIN READLABEL;
                                         return LPAREN;}
^[0-9]+"|"                              {lineTextIndex=0;
                                           sscanf(yytext,"%d",&lineNo);}
{_}"@"{_}                               {ECH; return AT;}
{_}","{_}                               {ECH; return C;}
{_}":"{_}                               {ECH; return COLON;}
{_}"="{_}                               {ECH; return EQUALS;}
{_}"["{_}                               {ECH; return LBOX;}
{_}"("{_}                               {ECH; return LPAREN;}
{_}"-"{_}                               {ECH; return MINUS;}
{_}"+"{_}                               {ECH; return PLUS;}
{_}"]"{_}                               {ECH; return RBOX;}
{_}")"{_}                               {ECH; return RPAREN;}
{_}"**"{_}                              {ECH; return POWER;}
{_}"*"{_}                               {ECH; return TIMES;}
{_}"/"{_}                               {ECH; return SLASH;}
{_}\r\n                                 {ECH; BEGIN INITIAL;
                                         return ENDLINE;}
{_}\n                                   {ECH;
                                         sprintf(lexMessage,
                                                 "<CR> missing");
                                         BEGIN INITIAL;
                                         return BAD;}
{_}[0-9]+{_}                            {ECH;
                                         sscanf(yytext, "%d", &k);
                                         yylval.ival = k;
                                         return INTSTRING;}
{_}(([0-9]+"."[0-9]+)|("."[0-9]+)){_}   {ECH;
                                         sscanf(yytext, "%lf", &num);
                                         yylval.rval = num;
                                         return REALSTRING;}
{_}([0-9]+".")/[^a-zA-Z]{_}             {ECH;
                                         sscanf(yytext, "%lf", &num);
                                         yylval.rval = num;
                                         return REALSTRING;}
{_}[a-zA-Z][a-zA-Z0-9_]{0,15}{_}  {ECH;
                                   shiftUpcase(yytext);
                                   yylval.sval = strdup(yytext);
                                   if (inDecl)
                                     {
                                       if (varType == -1)
                                         {
                                           inDecl = 0;
                                           sprintf(lexMessage,
                                                   "bad variable type");
                                           return BAD;
                                         }
                                       else if (findVariable(yytext,
                                                             &varType, 1))
                                         {
                                           sprintf(lexWarning,
                                                   "variable redeclared?");
                                           return DECLVARNAME;
                                         }
                                       else
                                         {
                                           recordVariable(yytext, varType);
                                           return DECLVARNAME;
                                         }
                                     }
                                   else // if (not inDecl)
                                     {
                                       if (findVariable(yytext,&varType,0))
                                         {
                                           return varType;
                                         }
                                       else
                                         {
                                           sprintf(lexMessage,
                                                   "undefined variable");
                                           return BAD;
                                         }
                                     }
                                  }
.                                 {ECH;
                                   sprintf(lexMessage, "bad character");
                                   BEGIN INITIAL;
                                   return BAD;}

%%

int yywrap()
{
  return 1;
}
