%Nist_db_hdf3  added attribute units to each value

%

% Reads a pressure scanner statitistical (.sta) and time series file .otb

% writes an hdf file consisting of a descriptive header and

% a body where the individual readings are stored and

% recreates filenames  using a descriptive naming convention.

% D. Morrish

% BLWTL UWO

% June 2001

%

% ver 2.2 april 2002 added column title for arrays

% ver 2.3 sept 2002 added letter suffix starting with lower case a to ouput file name

% to handle cases where the file nameing convention can still have ambiguities

% ver 3.0 case suffix letter placed between building eave height and wind angle

% this letter (usually an a) is deigned to handle any ambiguities casued by limitations in the

% file naming convention

% 

% a data item "nist_db_version" has been added to define the version of the BLWTL

% software that produced the file. This does not refer to HDF versions.

%

%

% VERSION

%

blwtl_software_version=3.0

%

fid=0;

ncsb=64; % 64 scans in an otb file

%

ct='Column_IDs';

%

% get input file path for inp files

%

%

 disp(['This program expects to find a file in your "home" directory']);

 disp(['called NIST_input_file_path.txt which contains a pointer to'])

 disp(['the directory containing the input ".inp" files for geometry,profiles'])

 disp([' tap coords etc.']);

in=fopen('~/NIST_input_file_path.txt');

if in < 1

 disp(['Input Path pointer file not found in your home directory']);

 break

end

inpath=fgetl(in);

if ~ischar(inpath);

 disp(['Invalid path to input files ',inpath]);   

end

fclose(in);

%

% get files;

%

wild=input('Enter input file spec. :','s');

wild=get_file_base(wild);

wild=fileext(wild,'sta');

ct_file=input('Control file root name: ','s');

compress=input('Compress output .hdf files (y,n) ? ','s');

compress=lower(compress);

if compress=='y'

  delunc=input('Delete uncompressed .hdf files (y,n) ? ','s');

end

nfiles=get_file_list(wild);

fl=fopen('filelist.lst','r');

%

for nfil=1:nfiles

  filename=fgetl(fl);

  message=['Reading : ',filename];

  disp(message);

%

% get parmaters based on file table database

%

  file_parameters=nist_parameters(filename(1:3));

%

%  verify requred input files

%

input_file_list=nist_input_files(file_parameters.file);

%

% test each file

%

file_flag=0;

% read .sta file

%

  sta_struct=read_sta(filename);

%

% make small demo file

%

%sta_struct.ndb=sta_struct.ndb/10  

%

% open otb file and load channel count.

%

  otb_filename=get_file_base(filename);

  otb_filename=[otb_filename,ct_file];

  otb_filename=fileext(otb_filename,'otb'); 

  otb=fopen(otb_filename,'r','n');

   if otb < 1

     disp([' NIST_db could NOT open ',otb_filename]);

     break

   end

%

% dummy 4 bytes at beginning

%

   byte=fread(otb,1,'int32');

% channel c

   [noc_ts,count]=fread(otb,1,'int32');

   if count~=1

    disp(['NIST_DB error reading :',otb_filename]);

   end 

%

% 4 bytes at end of nos record   

  byte=fread(otb,1,'int32');

%

%********************************************************************

% Check the existance for required input files.

%

%

% 3d tap cord

%

 if if_file([inpath,'/',input_file_list.tdtpc])

   disp([inpath,'/',input_file_list.tdtpc,' OK '])

 else

   disp([inpath,'/',input_file_list.tdtpc,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

%

% 3d building corner cords

%

 if if_file([inpath,'/',input_file_list.tdbco])

   disp([inpath,'/',input_file_list.tdbco,' OK '])

 else

   disp([inpath,'/',input_file_list.tdbco,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

 %

% 3d wire frame lines

%

 if if_file([inpath,'/',input_file_list.tdwfl])

   disp([inpath,'/',input_file_list.tdwfl,' OK '])

 else

   disp([inpath,'/',input_file_list.tdwfl,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

 %

% flat tap cord

%

 if if_file([inpath,'/',input_file_list.fltpc])

   disp([inpath,'/',input_file_list.fltpc,' OK '])

 else

   disp([inpath,'/',input_file_list.fltpc,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

%

% flat building corner cords

%

 if if_file([inpath,'/',input_file_list.flbco])

   disp([inpath,'/',input_file_list.flbco,' OK '])

 else

   disp([inpath,'/',input_file_list.flbco,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

%

% profile

%

 if if_file([inpath,'/',input_file_list.profl])

   disp([inpath,'/',input_file_list.profl,' OK '])

 else

   disp([inpath,'/',input_file_list.profl,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

pics1=0;pics2=0;pics3=0; 

%

% pics 1

%

 if if_file([inpath,'/',input_file_list.pics1])

   disp([inpath,'/',input_file_list.pics1,' OK '])

   pics1=1;

else

   disp([inpath,'/',input_file_list.pics1,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

%

% pics 2

%

 if if_file([inpath,'/',input_file_list.pics2])

   disp([inpath,'/',input_file_list.pics2,' OK '])

pics2=1;   

else

   disp([inpath,'/',input_file_list.pics2,' Not Found <<<< ']);

 end

%

% pics 3

%

 if if_file([inpath,'/',input_file_list.pics3])

   disp([inpath,'/',input_file_list.pics3,' OK '])

   pics3=1;   

else

   disp([inpath,'/',input_file_list.pics3,' Not Found <<<< ']);

 end

%

% readme

%

 if if_file([inpath,'/',input_file_list.readm])

   disp([inpath,'/',input_file_list.readm,' OK '])

 else

   disp([inpath,'/',input_file_list.readm,' Not Found <<<< ']);

   file_flag=file_flag+1;

 end

 if file_flag > 0

  disp([' Nist_db_hdf2 stoping due to ',num2str(file_flag,2),...

  ' missing input files']);

  break

 end

%

% create  output .hdf file

%

  nist_filename=file_parameters.file;

  nist_filename(16:19)=num2str(sta_struct.ttang*10,'%4.4d')

  hdfml('closeall');

  nst=hdfsd('start',nist_filename,'DFACC_CREATE');

%**************************************************************************************

% header info filename title and readme first

%**************************************************************************************

%1 file name created from input file name

   name='File_Name';

   error=put_head_item_hdf(nst,name,'uchar',nist_filename);

   if error ~= 0 

    disp(['NIST_DB adding item to header ',name]);

   end

%2

   name='Title';

   error=put_head_item_hdf(nst,name,'uchar',sta_struct.title);

   if error ~= 0 

    disp(['NIST_DB adding item to header ',name]);

   end

 %

   name='BLWTL_NIST_Software_Version';

   error=put_head_item_hdf(nst,name,'Double',blwtl_software_version);

   if error ~= 0 

    disp(['NIST_DB adding item to header ',name]);

   end 

%3

  comments_filename=[inpath,'/',input_file_list.readm];

  name='READ_ME';

   error=put_head_item_hdf(nst,name,'@uchar',comments_filename);

   if error ~= 0 

    disp(['NIST_DB adding item to header ',name]);

   end

%  azimuth

    name='Wind_Angle';

   error=put_head_item_hdf(nst,name,'Double',sta_struct.ttang,'Units','Deg.');

   if error ~= 0 

    disp(['NIST_DB adding item to header ',name]);

 end

 % wind speed

 name='Reference_Wind_Speed';

 error=put_head_item_hdf(nst,name,'Double',sta_struct.wfps,'Units','FPS');

 if error ~= 0 

    disp(['NIST_DB adding item to header ',name]);

 end

 % exposure name

 name='Exposure_Name';

 if file_parameters.exposure=='s'; exposure='Suburban';

 elseif file_parameters.exposure=='o'; exposure='Open_Country';

 else exposure='Undefined_See_Readme';

 end

   error=put_head_item_hdf(nst,name,'uchar',exposure);

   if error ~= 0 

    disp(['NIST_DB adding item to header ',name]);

   end

 % load profile

    profile_file_name=[inpath,'/',input_file_list.profl];

    name='Wind_Speed_Profile';

    cti='X	Y	Z	V	Iu	Iv	Iw';

    error=put_head_item_hdf(nst,name,'@double',profile_file_name,'Units','FS_Feet',ct,cti);

    if error ~= 0

      disp(['NIST_DB adding item to header ',name]);

    end

%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Building Info in order from generated file name

%

%  roof slope info

%

 name='Roof_Slope_in_12';

   error=put_head_item_hdf(nst,name,'double',file_parameters.slope);

   if error ~= 0  

    disp(['NIST_DB adding item to header ',name]);

   end

%

%  building height info

%

  name='Building_Height_Ft';

   error=put_head_item_hdf(nst,name,'double',file_parameters.height,'Units','FS_Feet');

   if error

    disp(['NIST_DB adding item to header ',name]);

   end

%

%  building length info

%

  name='Building_Length_Ft';

   error=put_head_item_hdf(nst,name,'double',file_parameters.length,'Units','FS_Feet');

   if error

    disp(['NIST_DB adding item to header ',name]);

   end

%

%  building width info

%

  name='Building_Width_Ft';

   error=put_head_item_hdf(nst,name,'double',file_parameters.width,'Units','FS_Feet');

   if error

    disp(['NIST_DB adding item to header ',name]);

 end

%

%  building scale info

%

  name='Building_Scale';

   error=put_head_item_hdf(nst,name,'double',file_parameters.scale);

   if error

    disp(['NIST_DB adding item to header ',name]);

   end

%

%  building leakage info

%

name='Building_Leakage';

if file_parameters.leak=='D';leak='Distributed';

elseif file_parameters.leak=='S';leak='Small_Opening';

elseif file_parameters.leak=='L';leak='Large_Opening';

elseif file_parameters.leak=='N';leak='No_Leakage';

elseif file_parameters.leak=='B';leak='Basic_Test';

else leak='Other_See_Readme';

end

error=put_head_item_hdf(nst,name,'uchar',leak);

   if error

    disp(['NIST_DB adding item to header ',name]);

 end

%

%  building roof height ratio  

%

  name='Roof_Height_Velocity_Ratio';

   error=put_head_item_hdf(nst,name,'double',file_parameters.roofhrat);

   if error

    disp(['NIST_DB adding item to header ',name]);

 end

 %

 %  building roof height velocity 

 %

  name='Roof_Height_Velocity';

   error=put_head_item_hdf(nst,name,'double',file_parameters.vhmfps,'Units','FPS');

   if error

    disp(['NIST_DB adding item to header ',name]);

 end

%******************************************************************************* 

% building drawing coordinates 3d  

%

% 3d corner info

%

    corner_file_name=[inpath,'/',input_file_list.tdbco];

    name='Building_Corners_3D';

    cti='X	Y	Z';

    error=put_head_item_hdf(nst,name,'@double',corner_file_name,'Units','FS_Feet',ct,cti);

    if error ~= 0

      disp(['NIST_DB adding item to header ',name]);

    end

%

% 3d  wireframe drawing (connect the corners) info

%

    wire_file_name=[inpath,'/',input_file_list.tdwfl];

    name='Wire_Frame_Lines_3D';

    cti='Line Segments from/to corners as specifed in Building_Corners_3D';

    error=put_head_item_hdf(nst,name,'@int32',wire_file_name,'Units','FS_Feet',ct,cti);

    if error ~= 0 

      disp(['NIST_DB adding item to header ',name]);

    end

%

% 3d  tap coordinates info

%

    x3dtap_cords_name=[inpath,'/',input_file_list.tdtpc];

    name='Tap_Coordinates_3D';

    cti='Tap no.	Face no.	X	Y	Z';

error=put_head_item_hdf(nst,name,'@double',x3dtap_cords_name,'Units','FS_Feet',ct,cti);

    if error ~= 0 

      disp(['NIST_DB adding item to header ',name]);

    end

%

%******************************************************************************* 

% building drawing coordinates Flat View 

%

% flat corner info

%

    corner_file_name=[inpath,'/',input_file_list.flbco];

    name='Building_Corners_Flat';

    cti='X	Y	Z';

    error=put_head_item_hdf(nst,name,'@double',corner_file_name,'Units','FS_Feet',ct,cti);

    if error ~= 0

      disp(['NIST_DB adding item to header ',name]);

    end

%

% flat  wireframe drawing (connect the corners) info

%

    wire_file_name=[inpath,'/',input_file_list.flwfl];

    name='Flat_Wire_Frame_Lines';

    cti='Line Segments from/to corners as specifed in Building_Corners_Flat';

    error=put_head_item_hdf(nst,name,'@int32',wire_file_name,'Units','FS_Feet',ct,cti);

    if error ~= 0 

      disp(['NIST_DB adding item to header ',name]);

    end

%nist_db

% Flat  tap coordinates info

%

    tap_cords_name=[inpath,'/',input_file_list.fltpc];

    name='Flat_Tap_Coordinates';

    cti='Tap no.	Face no.	X	Y';

    error=put_head_item_hdf(nst,name,'@double',tap_cords_name,'Units','FS_Feet',ct,cti);

    if error ~= 0 

      disp(['NIST_DB adding item to header ',name]);

    end

    

%

% time of experiment

%

% test  year

  name='Test_Year';

   error=put_head_item_hdf(nst,name,'int32',int32(sta_struct.year));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% test month

  name='Test_Month';

   error=put_head_item_hdf(nst,name,'int32',int32(sta_struct.month));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% test day

  name='Test_Day';

   error=put_head_item_hdf(nst,name,'int32',int32(sta_struct.day));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% test hour

  name='Test_Hour';

   error=put_head_item_hdf(nst,name,'int32',int32(sta_struct.hour));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% test minute

  name='Test_Minute';

   error=put_head_item_hdf(nst,name,'int32',int32(sta_struct.min));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

%

% time of file processing

%

% Proc.  year

  tv=clock;

  name='Processed_Year';

   error=put_head_item_hdf(nst,name,'int32',int32(tv(1)));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% Proc. month

  name='Processed_Month';

   error=put_head_item_hdf(nst,name,'int32',int32(tv(2)));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% Proc. day

  name='Processed_Day';

   error=put_head_item_hdf(nst,name,'int32',int32(tv(3)));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% Proc. hour

  name='Processed_Hour';

   error=put_head_item_hdf(nst,name,'int32',int32(tv(4)));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

% Proc.  minute

  name='Processed_Minute';

   error=put_head_item_hdf(nst,name,'int32',int32(tv(5)));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

%

% 

%  sampling rate

  name='Data_Sample_Rate';

   error=put_head_item_hdf(nst,name,'double',sta_struct.srate,'Units','Hertz');

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

%  no of readings per tap

  name='No_Of_Samples_Per_Tap';

   nos=(sta_struct.ndb-2)*ncsb;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% uncomment temp for demo files

%

%   nos=4800

%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  

   error=put_head_item_hdf(nst,name,'int32',int32(nos));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

%  no of pressure taps

  name='No_Of_Pressure_Taps';

   error=put_head_item_hdf(nst,name,'int32',int32(sta_struct.ntap));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

%***************************************************************************   

% load pictures (jpeg)   

%

if pics1==1

   pic=imread([inpath,'/',input_file_list.pics1]);

   pic=imresize(pic,.5);

     name='Image_1';

   error=put_head_item_hdf(nst,name,'uint8',pic);

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

end   

if pics2==1

   pic=imread([inpath,'/',input_file_list.pics2]);

%    pic=imresize(pic,.5);

     name='Image_2';

   error=put_head_item_hdf(nst,name,'uint8',pic);

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

end 

if pics3==1

   pic=imread([inpath,'/',input_file_list.pics3]);

     name='Image_3';

%      pic=imresize(pic,.5);

   error=put_head_item_hdf(nst,name,'uint8',pic);

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end

end   



%   

% load addin header items here from external files

%

  addfid=fopen('nist_db_add_ins.inp','r');

  if addfid >=0

    while feof(addfid)==0

      line=fgetl(addfid);

      add_name=line;

      line=fgetl(addfid);

      add_type=line;

      line=fgetl(addfid);

      add_file=line;

%

% direct character or numeric input

%

      if strcmp(add_type,'double')

       add_file=str2num(add_file);

      elseif strcmp(add_type,'int32') | strcmp(add_type,'integer*4')

       add_file=int32(str2num(add_file));

      end

      error=put_head_item_hdf(nst,add_name,add_type,add_file);

    end

    fclose(addfid);

   else

    disp('No user add ins file found');

   end

%  no- of channels in ts

  name='No_Of_TS_Chan';

   error=put_head_item_hdf(nst,name,'int32',int32(noc_ts));

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end 

% 

 ts_mult=1000.;

% ts mult

 name='Ts_Multiplier';

   error=put_head_item_hdf(nst,name,'double',1./ts_mult);

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end 

%

% ts data type

%

 name='Ts_Data_Type';

 ts_data_type='integer*2';

   error=put_head_item_hdf(nst,name,'uchar',ts_data_type);

   if error

    disp(['NIST_DB adding item to header ',name]);

   end 

%

% create an array for ts

%

   block_size=noc_ts*ncsb;

%

% all but 2 blocks written

%  

   n_block=sta_struct.ndb-2;

   nscan=ncsb*n_block;

   ts_size=block_size*n_block;



%  % title

   name='Tap_Max_Min_Mean_RMS';

 %

 % save old order

 %

  order=sta_struct.pnums(:,1);

  [order,index]=sortrows(order,1);

   sta_struct.pnums=sortrows(sta_struct.pnums,1);

   cti='Tap no.	Cp Max	  Cp Min		Cp Mean		Cp RMS';

   error=put_head_item_hdf(nst,name,'double',sta_struct.pnums,ct,cti);

   if error

    disp(['NIST_DB adding item to header ',name]);

   end

   name='Tap_Position_List';

   for i=1:noc_ts

      tap_position_list(i)=int32(sta_struct.pnums(i,1));

   end

   error=put_head_item_hdf(nst,name,'int32',tap_position_list);

   if error ~= 0

    disp(['NIST_DB adding item to header ',name]);

   end 

%   

% define main time series data set and create

%

  ds_name='Time_Series';

  ds_type='int16';

  ds_rank=2;

  ds_dims=fliplr([nos,noc_ts]);

  

  sds_id=hdfsd('create',nst,ds_name,ds_type,ds_rank,ds_dims);

   row=1;

  nsproc=ncsb;

  block_size=nsproc*noc_ts;

  count=block_size;

   nb_read=0;

%

%

  row_hdf=0;

  col_hdf=0;

 

%while count==block_size;

info.title=([nist_filename,' Progress']);

info.size=2;

info.msg='% DONE';

info.color=[1 0 0];

info.pos='topleft';   

pb=progbar(info);

for i=1:(sta_struct.ndb-2)

   pc=(i/(sta_struct.ndb-2))*100;

%

% size int 32 4 bytes

%

    nbytes=fread(otb,1,'int32');

  if nbytes==(block_size*2)

      [ts,count]=fread(otb,(nsproc*noc_ts),'int16');

      tsx=int16(reshape(ts,noc_ts,nsproc))';

%

% change order

%

% 101 201 301 > 101 102 103

% for i=1:length(index)

   for i=1:noc_ts

     if index(i) <= noc_ts

       tsy(:,i)=tsx(:,index(i));

     end

   end

%

% end size bytes

% 

      nbytes=fread(otb,1,'int32');

%

% write part of dataset

% 

       ds_start=[col_hdf row_hdf];

       ds_stride=[];

       ds_edges=[noc_ts nsproc];

       stat=hdfsd('writedata',sds_id,ds_start,ds_stride,ds_edges,tsy);

       row_hdf=row_hdf+nsproc;

%

% update counters 

       nb_read=nb_read+1;

%

% temp  

%

% if nb_read==1

%  break

% end

%       ns_used=nb_read*nsproc;

%       fprintf(1,' Buffer # ,%d, No of Scans Processed:%d %\r',nb_read,ns_used);

  progbar(pb,pc);

  else

    break

     count=0;

    end

  end

fprintf(1,'\n');

% end of file loop

  stat=hdfsd('end',nst);

  hdfml('closeall');

%

close(pb);

if compress=='y'

 bfile=get_file_base(nist_filename);

 cl=['zip  ',bfile,'.zip ',nist_filename];

 [s,xx]=unix(cl); 

 if s~=0

   disp([' nist_db pkzip failure ',nist_filename,' ',xx]); 

 end

 if delunc=='y' & s==0

  cl=['rm ',nist_filename];

  [s,xx]=unix(cl); 

  if s~=0

   disp([' nist_db error removing ',nist_filename,' ',xx]); 

  end

 end

end

end;









