%
%
% function to load an HDF format Pressure Time Series File
% into a Matlab Data Structure
%
% D. Morrish 
% Jan 02
% Used like:
% 	pfile_struct=load_hdf_file(hdf_file_name,load_ps_flag,st,et,si,ei)
%	note:load_ps_flag='s' for selected portion of the time history
%	or
%	pfile_struct=load_hdf_file(hdf_file_name,load_ps_flag)
%	note:load_ps_flag='a' or 'n' for all or none
%
% 	-hdf_file_name=string containing full name and path of the HDF file
% 
%	-load_ts_flag 	'a' to load entire time history  all taps
%			'n' to load NO time history no taps "header info"
%			's' range of taps and samples
%
%        If  the s option is chosen four addtional arguments are required.
%	
%	st starting tap #	examplel  101 -1 defaults to min tap index
%	et ending   tap # 		 3316 -1 defaults to max tap index
% 	si starting index 1 > no. of samples  -1 defaults to min sample index
%	ei ending   index 1 > no. of samples  -1 defauls to maximum sample index
%
%      calling load_hdf_file with 's',-1,-1,-1,-1 should produce the same
%      results as using the 'a' option 
%
%  returns  a struture containing all the supporting information with
%  or without the time seris based on user input . Specifically the ts_flag
%  and st et si ei arguments.
%
%  Note: The time history is returned as integer*2 (2 bytes) to conserv memory.
%  	 to convert the  time history data to actual units (Cp's) the offset
%        "structurename".Ts_Offset must be subtracted and then the data must be
%	 multiplied by "structurename".Ts_Multiplier 
%
function pd_struct=load_hdf_file(hdf_file_name,load_ts_flag,st,et,si,ei)
narg=nargin;
pd_struct.File_Name=[];
if narg ~=2 & narg ~=6
    error('load_hdf_file number of arguments must be 2 or 6');
end
load_ts_flag=lower(load_ts_flag);
%	
% open hdf file
%
sd_id=hdfsd('start',hdf_file_name,'read');
if sd_id <=0
    error(['Could not open >',hdf_file_name,'< for reading check paths and permisions.']);
end
%
% get file info
%
unit_att_index=0;

[ndatasets,natt,sata]=hdfsd('fileinfo',sd_id);
%
for sds_idx=0:ndatasets-1
    sds_id=hdfsd('select',sd_id,sds_idx);
    [dsname,dsndim,dsdims,dstype,dsatts,stat]=...
        hdfsd('getinfo',sds_id);
    ds_start=zeros(1,dsndim);
    ds_stride=[];
    ds_edges=dsdims;
    %
    % handle time history here
    %
    if strcmp(dsname,'Time_Series')
        
        if load_ts_flag=='s'
            maxt=max(pd_struct.Tap_Position_List);
            mint=min(pd_struct.Tap_Position_List);
            
            % handle default -1 requests here
            % tap position
            if st==-1
                st=mint;
            end
            if et==-1
                et=maxt;
            end
            % data Index 
            if si==-1
                si=1;
            end
            if ei==-1
                ei=dsdims(2);
            end
            %end    
            % build channels list 
            for i=1:length(pd_struct.Tap_Position_List)
                if pd_struct.Tap_Position_List(i)==st; sti=i;  end
                if pd_struct.Tap_Position_List(i)==et; eti=i;  end
            end
            %
            % check requested time series parameters taps
            %
            if sti > 0 & eti > 0 | sti < eti
                ds_start=[sti-1 si-1];
                ds_edges=[(eti-sti)+1 (ei-si)+1];
            else
                error([' Load_hdf_file.m Invalid  tap requested ', num2str([sti eti])]); 
            end
            if  st> maxt | et > maxt
                error([' Load_hdf_file.m Invalid  tap requested ', num2str([sti eti])]); 
            end
            if  si> dsdims(2) | ei > dsdims(2)
                error([' Load_hdf_file.m Invalid data index requested ', num2str([si ei])]); 
            end
            %    
            %
            % new tap position_list
            %
            ix=1;
            for i=sti:eti
                xlist(ix)=pd_struct.Tap_Position_List(i);
                ix=ix+1;
            end
            pd_struct.Tap_Position_List=xlist;
            %
            % check index
            %     
            if si < 0 | si > ei
                error([' Load_hdf_file.m Invalid  data index requested ', str2num([si ei])]);
            end 
        end   
        if load_ts_flag~='n'       
            [ds_data,status]=hdfsd('readdata',sds_id,ds_start,ds_stride,ds_edges);
            %
            % retrive attributs
            %  
            if dsatts>0
                for i=1:dsatts
                    [aname,adt,count,status]=hdfsd('attrinfo',sds_id,i-1);
                    [attrib,status]=hdfsd('readattr',sds_id,i-1);
                    if status==0
                        pd_struct=setfield(pd_struct,['A_',dsname,'_',aname],attrib);
                    end
                end
            end 
           pd_struct=setfield(pd_struct,dsname,ds_data);  
        end
    else
        % 
        % everthing but time series handle here 
        %
        [ds_data,status]=hdfsd('readdata',sds_id,ds_start,ds_stride,ds_edges);
       % pd_struct=setfield(pd_struct,dsname,ds_data);
        %
        % retrive attributs
        %
        for i=1:dsatts
            [aname,adt,count,status]=hdfsd('attrinfo',sds_id,i-1);
            [attrib,status]=hdfsd('readattr',sds_id,i-1);
            aname=strrep(aname,' ','_');
            if status==0
                pd_struct=setfield(pd_struct,['A_',dsname,'_',aname],attrib);
            end
        end
            pd_struct=setfield(pd_struct,dsname,ds_data);
        % end of if time series
    end
    % end of n data setsloop  
end
hdfml('closeall');

















