%

% This function adds a header item to a pressure data archive file

% HDF Version

% D. Morrish BLWTL

% June 2000

%

% used like: error=put_head_item_hdf(sd_id,name,type,item,N(attribute,value))

% uses variable number of arguments minimum 4 for one data item no attributes

% 2 additional arguments for each attribute

%

%     assmes an HDF file has been opend like this:

%

%	sds_id=hdfsd('start',hdf_file_name,'DFACC_CREATE');

%

%     after all items and data have been placed in the file the 

%     following HDF calls must be made:

%

%     stat=hdfsd('end',ds_id);

%     hdfml('closeall');

%

%	name=character item name

%

%	type=data type;

%	  currently supported

%		'int8 or integer*1'

%		'int16 or integer*2'

%		'int32 or integer*4'

%		'int64 or integer*8'

%		'uchar or unsigned char'

%		'uint8 or integer*1'

%		'uint16 or integer*2'

%		'unit32 or integer*4'

%		'uint64 or integer*8'

%		'double or 'double'

%

%  ltype can also be a filename which is loaded using the load

%  command and output as a data item:

%

%		if ltype(1)='@' then item is assumed to be a file name

%               as with type dictated by ltype. Note only

%		int32,double,uchar are supported  

%

%	item=data to be storred or filename

%

%

%	reapeated N times attrib name of attribute

%		    attrib_val value of attibute



%

%	function error=put_head_item_hdf(sd_id,name,ltype,item,...

%	attrib,attrib_val);

	function error=put_head_item_hdf(varargin);

%

% check arguments

%

	narg=nargin;

	if narg < 4 

	  error('put_head_htem_hdf requires at least 4 arguments');

	elseif (fix(narg)/2)*2~=narg

	  error('put_head_item_hdf requires an even number of arguments');

	end

%

% calculate number of attribut pairs

%

	noatt=0;

	if narg >=6

	  noatt=(narg-4)/2;

	end

%

% get args for data item

% 

	sd_id=varargin{1};

	name=varargin{2};

	ltype=varargin{3};

	item=varargin{4};

	

	frfile=0;

	error=-1;

% maximum data item length

	maxtl=15;

	item_name='               ';

%

% test fid

%

%	if sd_id < 0

%	 disp(['put_data_item_hdf Invalid sd_id ',num2str(sd_id) ]);

%	 error=1;

%	 return;

%	end

%

% test data type

%

	        ntype=0;

% test for load from file

		if ltype(1)=='@'

		 ltype=lower(ltype(2:length(ltype)));

		 frfile=1;		

	        end

		ltype=lower(ltype);

		if strcmp(ltype,'int8') | strcmp(ltype,'integer*1')

		  ntype=1;

		elseif strcmp(ltype,'int16') | strcmp(ltype,'integer*2')

		  ntype=2;

		elseif strcmp(ltype,'int32') | strcmp(ltype,'integer*4')

		  ntype=3;

		elseif	strcmp(ltype,'int64') | strcmp(ltype,'integer*8')

		  ntype=4;

		elseif strcmp(ltype,'uchar') | strcmp(ltype,'unsigned char')

		  ntype=5;

		elseif strcmp(ltype,'uint8') | strcmp(ltype,'integer*1')

		  ntype=6;

		elseif strcmp(ltype,'uint16') | strcmp(ltype,'integer*2')

		  ntype=7;

		elseif strcmp(ltype,'unit32') | strcmp(ltype,'integer*4')

		  ntype=8;

		elseif strcmp(ltype,'uint64') | strcmp(ltype,'integer*8')

		  ntype=9;

		elseif strcmp(ltype,'double') | strcmp(ltype,'double')

		  ntype=10;

		else

		  disp(['put_data_item unknown data type ',ltype]);

		  error=-2;

		  return;

		end



	if frfile==0

%

%  make sure item has data

%

	 d_len=length(item);

	 if d_len==0

	   disp(['Warning: put_data_item_hdf zero length data item'])

	 end

%

% size of item

%

	  [nrow,ncol]=size(item);

	 else

%

% load if file

%

	 if ntype==10 | ntype==3

	   xd=load(item,'-ASCII');

	   if ntype==3

	    clear(item);

	    item=int32(xd);

	   else

	    clear(item);

	    item=xd;

	   end

	  [nrow,ncol]=size(item);

	 elseif ntype==5

%           open input file

	    infid=fopen(item,'r');

            if infid < 0

	     disp(['put_data_itme cant open ',item])

	    end

	    item=fscanf(infid,'%c');

         end

	 [nrow,ncol]=size(item);

	end

%

% create data set

% 

	ds_name=name;

	ds_type=ltype;

	ds_rank=ndims(item);

	for i=1:ndims(item);

	  ds_start(i)=0;

	end

	ds_edges=fliplr(size(item));

%

% correct rank for scaler value

%

        ds_dims=fliplr(size(item));

	sds_id=hdfsd('create',sd_id,ds_name,ds_type,ds_rank,ds_dims);

%

narg=nargin;

%

% attribute

%

if narg >=6

attp=5;

 for i=1:noatt

 	attrib=varargin{attp};

	attrib_val=varargin{attp+1};

	status=hdfsd('setattr',sds_id,attrib,attrib_val);

	attp=attp+2;

 end

end

%

% write item

%



	ds_stride=[];

       stat=hdfsd('writedata',sds_id,ds_start,ds_stride,ds_edges,item);

	if stat ~= 0

	  disp(['Error writing data item: ',ds_name,' Status: ',num2str(stat)]);

	  error=stat;

	  return

	end

	stat=hdfsd('endaccess',sds_id);

	return; 

