%

%

% routine to accept a 3 letter BLWTL file identifier and return a stucture

% containing  test parameter information and a descriptive filename.

% D. Morrish

%

% modified as below:

% ver 3.0 case suffix letter placed between building eave height and wind angle

% this letter (usually an a) is designed to handle any ambiguities casued by limitations in the

% file naming convention

% 

%

%  output file naming convetion :

%	

%	Typical file name: ADW100o100S048axxxx.HDF

%

%  pos 1-3 idententifies the originating facility:

%  	ours are 

%  	>ADW for Alan Davenport Wind Engineering Group

%

%  pos 4-6 identifies the roof slope in 12ths to 3 digits

%	example: 100 is 1 in 12 

%	example: 300 is 3 in 12

%       example: 025 is 1/4 in 12

%

%  pos 7 identifies the exposure

%	example: o lower case O for open country

%	example: s lower case S for suburban exposure

%

%  pos 8-10 identifies the model scale to 3 digits

%	example 100 is a 1 in 100 scale model/test

%

%  pos 11  identifes the leakage case 

%	example D for distributed leakage

%	example S for small opening

%	example L for large opening

%	example N for no leakage

%	example B for basic test

%

% pos 12-14 is the building height in feet to 3 digits

%	example 048 is 48 feet	 

%

% pos 15  is the case ID (usually a) which denotes an ambiguties caused

%        by cases duplicate cases using the above system

%

%pos 16-19 is the windangle in degrees to be read as xxx.x

%	example 1800 is 180.0 degrees

%

% the .HDF identifies the data format as a Hierarchical Data File

% which is a standrd file format for the exchange of scientific data.

% The HDF file format was designed by the National Center for Super-

% Computing Applications (NCSA) .

% 



% loads file

	function nist_struct=nist_parameters(fn3)

	exposure='osux';

%

% start position of 3 character test file itentifier

%

  f3st=9;

  fvl=30;

  fcase=108;

%

% read summary file

%

in=fopen('~/NIST_input_file_path.txt');

if in < 1

 disp(['Input Path pointer file not found in your home directory']);

 break

end

inpath=fgetl(in);

if ~ischar(inpath);

 disp(['Invalid path to input files ',inpath]);   

end

fclose(in);



  sumr=fopen([inpath,'/nist_summary.txt'],'r');

    if sumr < 1

      disp([' nist_struct could not open nist_summary.txt ']);

      

    end

% get rid of title line

stx=fgetl(sumr);

%

% read until end of file

%

  while 1

    stx=fgetl(sumr);

    stx(f3st:f3st+2);

    if ~ischar(stx),break,end;

    if strmatch(upper(fn3),stx(f3st:f3st+2))

% map parameters

        nist_struct.int_file=upper(fn3);

	nist_struct.leak=stx(fvl);

	nums=str2num(stx(fvl+1:fcase-1));

	nist_struct.slope=nums(1);

	nist_struct.scale=nums(2);

	nist_struct.exposure=exposure(nums(3));

	nist_struct.length=nums(7);

	nist_struct.width=nums(8);

	nist_struct.height=nums(4);

	nist_struct.roofhrat=nums(5);

	nist_struct.vhmfps=nums(6);

% build file name

	nist_struct.file(1:3)='ADW';

% slope

	nist_struct.file(4:6)=num2str(round((nums(1)*12.)*100.),'%3.3d');

% exp.

	nist_struct.file(7)=exposure(nums(3));

%scale

	nist_struct.file(8:10)=num2str(nums(2),'%3.3d');

%leakage

	nist_struct.file(11)=nist_struct.leak;

%height	

	nist_struct.file(12:14)=num2str(nums(4),'%3.3d');

% case letter goes here

%	nist_struct.file(15)=stx(96)

	nist_struct.file(15)=stx(fcase);

%place holder for angle

	nist_struct.file(16:19)='xxxx';

%extension

	nist_struct.file(20:23)='.HDF';

	return

    end

  end

%

%  return

%

 mess=[fn3,' Not found in nist_summary.txt ! '];

 disp(mess);

