%

% function to read an .sta file from the pressure scanner

% and return most of the header and the pressure coef.

% information as a matlab structure

%

	function sta_struct=read_sta(file_name)

	sta=fopen(file_name,'r');

	if sta < 1

	  disp([' read-sta could not open ',file-name]);

	end

%

% get title

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.title=stx(8:length(stx));

%

% get actual file name

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.file_name=stx(7:12);

%

% get date and time

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.day=str2num(stx(17:18));

	sta_struct.month=str2num(stx(20:21));

% year

	yt=str2num(stx(23:24));

	if yt==75

	 yt=yt+1900;

	else

	 yt=yt+2000;

	end

	sta_struct.year=yt;

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.hour=str2num(stx(14:15));

	sta_struct.min=str2num(stx(17:18));

%

% get baro ref. volts

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.barov=str2num(stx(23:28));

%

%  get wind speed

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.wfps=str2num(stx(13:19));

	sta_struct.wmps=str2num(stx(26:32));

%

%  tt angle exposure 

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.ttang=str2num(stx(19:25));

	sta_struct.exposure=str2num(stx(37:39));

%

%  sampling rate, no. of data buffers

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.srate=str2num(stx(19:25));

	sta_struct.ndb=str2num(stx(49:55));

%

% buffer size

%

	stx=fgetl(sta);

	sta_struct.bufsiz=str2num(stx(17:23));

%

% ntap analog ch

%

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.ntap=str2num(stx(23:28));

	sta_struct.nchn=str2num(stx(54:57));

%

% no of scans in a buffer

%	

	stx=fgetl(sta);

	stx=fgetl(sta);

	sta_struct.nscanb=str2num(stx(27:31));

%

% scan until file header baro

%

	while 1

	 stx=fgetl(sta);

	 if length(stx)>= 6

          if stx(3:6)=='File'

	   break

	  end

	 end

	end 

	sta_struct.fhbaro=str2num(stx(20:25));

	sta_struct.dabaro=str2num(stx(38:43));

	sta_struct.xcbaro=str2num(stx(58:64));

%

% scan until first position

%

	while 1

	 stx=fgetl(sta);

	 if length(stx)>= 5

          if stx(2:5)=='Posi'

	   break

	  end

	 end

	end 

%

% read stats

%

% pos

	sp=0;

	ap=0;

	while 1

         stx=fgetl(sta);

	 if stx==-1

	   break;

	 end

	 if length(stx)<=1

	 elseif stx(2:5)=='Posi'

	  pos=str2num(stx(12:14));

% stats

	 elseif ( stx(2)=='(' & stx(7)==')' )

	  stx(2)=' ';stx(7)=' ';stx(41)=' ';stx(46)=' ';

	  nums=sscanf(stx,'%f');

	  if nums(1) < 0

            ap=ap+1;

	    sta_struct.achan(ap,1:5)=nums(1:5);

	  else

	    sp=sp+1;

%

% copy to data array

%

	    sta_struct.pnums(sp,1:5)=nums(1:5)';

	  end

	  if length(nums)>5

            if nums(6) < 0

	      ap=ap+1;

	      sta_struct.achan(ap,1:5)=nums(6:10);

            else

	      sp=sp+1;

	      sta_struct.pnums(sp,1:5)=nums(6:10)';

	    end

	  end

	 end

	end





