//package src;
import org.apache.xmlbeans.*;
import org.w3c.dom.Document;

import gov.x73.nist.ROIVapduDocument;
import gov.x73.nist.CPRPPDUDocument;
import gov.x73.nist.RORSapduDocument;
import gov.x73.nist.CPAPPDUDocument;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import java.util.Date;
import javax.swing.border.*;
import java.io.*;

import javax.xml.stream.*;

import java.lang.*;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

import java.io.IOException;

public class ResultsValuePanel extends JPanel implements Observer{
	private ValidateXML validateXML;
	private JTextArea text;
	private JScrollPane scrollPane;
	boolean exit = false;
	
	public ResultsValuePanel() {
		
	 setLayout(new BoxLayout(this, BoxLayout.LINE_AXIS));
  
     TitledBorder tb = BorderFactory.createTitledBorder("");     
     JPanel panel1 = new JPanel(new BorderLayout());
     text = new JTextArea();
     text.setMargin(new Insets(5,5,5,5));
     text.setEditable( false );
     text.setLineWrap(true);
     text.setWrapStyleWord(true);
     scrollPane = new JScrollPane(text);
     scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
   //  scrollPane.setPreferredSize(new Dimension(580, 310));
     scrollPane.setBorder(BorderFactory.createCompoundBorder(tb, scrollPane.getBorder()));
     
     panel1.add(scrollPane,BorderLayout.CENTER);
     add(panel1); 
	}
	
	public void setValidateXML(ValidateXML VALIDATEXML) {
    	validateXML = VALIDATEXML;
        }
     public void update(Observable o, Object arg) {
     	
    	if(o instanceof ValidateXML) {
    		
    	    if(arg instanceof MVCArg) {
    		if("validatSelected".equals(((MVCArg)arg).getName())) {
    			try {
 
    		       validate(validateXML.getSelectedFile());
    		     }                           
    		     catch (XmlException e1) {
    		         e1.printStackTrace();
    		     }
    		     catch (IOException e1) {
    		         e1.printStackTrace();
    		     }
    		     scroll();	    
    		}
    		
    	/*	else if("init".equals(((MVCArg)arg).getName())) {
    		    init();
    		}*/
    	    }
    	}
        }
	
	
   private void scroll()
   {
      text.setCaretPosition(text.getDocument().getLength());
   }

   public void setVisible( boolean boolval )
   {
      scroll();
  //    fr.setVisible( boolval );
   }

   public void setExit( boolean value )
   {
      exit = value;
   }

   public void println( String str )
   {
      if(str!=null) text.append( str + "\n");
   	
      else text.append( "null\n");
      scroll();
   }

   public void validate(String filename) throws org.apache.xmlbeans.XmlException, java.io.IOException {
   	text.setText("");
   	  if (validateXML.getFileType() == "ROIVapdu"){
   	  	
      ROIVapduDocument doc = ROIVapduDocument.Factory.parse(new File(validateXML.getSelectedFile()));
      ArrayList errors = new ArrayList();
      XmlOptions opts = new XmlOptions();
      opts.setErrorListener(errors);
                  
      println("PARSING Document: " + filename);
      println(".....................");
      println(".....................");
      println(" ");

      if (doc.validate(opts)) {
      	 text.setBackground(Color.CYAN);
         println("DOCUMENT "+ filename+ " IS VALID");
      }  
      else {
      	 text.setBackground(Color.red);
         println("DOCUMENT "+ filename + " is INVALID!");
         println(" ");
         Iterator iter = errors.iterator();
         while (iter.hasNext()) {
            println(">> " + iter.next());
         }
      }
      
   	  }
   	if (validateXML.getFileType() == "CPR-PPDU"){
   		CPRPPDUDocument doc = CPRPPDUDocument.Factory.parse(new File(validateXML.getSelectedFile()));
   	    ArrayList errors = new ArrayList();
   	    XmlOptions opts = new XmlOptions();
   	    opts.setErrorListener(errors);
   	                
   	    println("PARSING Document: " + filename);
   	    println(".....................");
   	    println(".....................");
   	    println(" ");

   	    if (doc.validate(opts)) {
   	    	text.setBackground(Color.CYAN);
   	       println("              DOCUMENT "+ filename+ " IS VALID");
   	    }  
   	    else {
   	    	text.setBackground(Color.red);
   	       println("DOCUMENT "+ filename + " is INVALID!");
   	       println(" ");
   	       Iterator iter = errors.iterator();
   	       while (iter.hasNext()) {
   	          println(">> " + iter.next());
   	       }
   	    }
   	}
	if (validateXML.getFileType() == "RORSapdu"){
		RORSapduDocument doc = RORSapduDocument.Factory.parse(new File(validateXML.getSelectedFile()));
   	    ArrayList errors = new ArrayList();
   	    XmlOptions opts = new XmlOptions();
   	    opts.setErrorListener(errors);
   	                
   	    println("PARSING Document: " + filename);
   	    println(".....................");
   	    println(".....................");
   	    println(" ");

   	    if (doc.validate(opts)) {
   	    	text.setBackground(Color.CYAN);
   	       println("DOCUMENT "+ filename+ " IS VALID");
   	    }  
   	    else {
   	    	text.setBackground(Color.red);
   	       println("DOCUMENT "+ filename + " is INVALID!");
   	       println(" ");
   	       Iterator iter = errors.iterator();
   	       while (iter.hasNext()) {
   	          println(">> " + iter.next());
   	       }
   	    }
   	}
      
	if (validateXML.getFileType() == "CPA-PPDU"){
		CPAPPDUDocument doc = CPAPPDUDocument.Factory.parse(new File(validateXML.getSelectedFile()));
   	    ArrayList errors = new ArrayList();
   	    XmlOptions opts = new XmlOptions();
   	    opts.setErrorListener(errors);
   	                
   	    println("PARSING Document: " + filename);
   	    println(".....................");
   	    println(".....................");
   	    println(" ");

   	    if (doc.validate(opts)) {
   	    	text.setBackground(Color.CYAN);
   	       println("DOCUMENT "+ filename+ " IS VALID");
   	    }  
   	    else {
   	    	text.setBackground(Color.red);
   	       println("DOCUMENT "+ filename + " is INVALID!");
   	       println(" ");
   	       Iterator iter = errors.iterator();
   	       while (iter.hasNext()) {
   	          println(">> " + iter.next());
   	       }
   	    }
   	}  
   }
}

