/**
 * This panel allows the user to specify a structure for batch messages
 */

//package src;

import org.apache.xmlbeans.*;

// JDK

import java.util.Calendar;
import java.util.Collections;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.Enumeration;

// AWT
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.awt.Component;

// Swing
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;



public class ChooseFilePanel extends JPanel implements ActionListener {
//implements ActionListener, Observer {

    private JTextField txtStructure;
    private JButton btnLoadXML;
    private ValidateXML validateXML;
    private JButton btnValidateXML;
    private DefaultMutableTreeNode treeNode;
    private JScrollPane validatortScrollPane;
    private JPanel rightPane ;
    private static boolean DEBUG = false;
    private JTree validatorTree;
    JSplitPane sp;
    ResultsValuePanel rvp;

    
    
    private Calendar today;
    
    String selectedFile;
    /**
     * Constructor
     */
    public ChooseFilePanel() {
    	
    	setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
    	JPanel p00 = new JPanel();
      	
    	JPanel p11 = new JPanel();
    	JLabel filelbl = new JLabel("Select XML file to validate: ");
      	p11.add(filelbl);
      	p11.add(Box.createRigidArea(new Dimension(10, 0)));

      	btnLoadXML = new JButton("Load");
      	btnLoadXML.setBackground(new Color(204, 204, 255));
      	btnLoadXML.setEnabled(true);
      	btnLoadXML.addActionListener(this);
      	p11.add(btnLoadXML);
      	p11.add(Box.createRigidArea(new Dimension(10, 0)));
      	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
      	
      	JPanel p2 = new JPanel();
    	JLabel validatelbl = new JLabel("Validate File: ");
      	p11.add(validatelbl);
      	p11.add(Box.createRigidArea(new Dimension(10, 0)));

      	btnValidateXML = new JButton("Validate");
      	btnValidateXML.setBackground(new Color(204, 204, 255));
      	btnValidateXML.setEnabled(false);
      	btnValidateXML.addActionListener(this);
      	p2.add(btnValidateXML);
      	p2.add(Box.createRigidArea(new Dimension(10, 0)));
      	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

        p00.add(p11); 
        p00.add(p2); 
        
        
        
       
        rvp = new ResultsValuePanel();
        
        
//      JPanel rightPane = new JPanel();
//      rightPane.setLayout(new BoxLayout(rightPane, BoxLayout.LINE_AXIS));

        rightPane = new JPanel(new CardLayout());
        rightPane.setPreferredSize(new Dimension(600,500));
        rightPane.add(new JPanel(), "Blank");
        rightPane.add(rvp, "ResultsValue");
		
		JPanel p22 = new JPanel();
		p22.setLayout(new BoxLayout(p22, BoxLayout.LINE_AXIS));
		validatorTree = new JTree(new Vector());
		validatortScrollPane = new JScrollPane(validatorTree);
		validatortScrollPane.setPreferredSize(new Dimension(75, 500));
		p22.add(validatortScrollPane);
       
        //	 SplitPane 
        JPanel p33 = new JPanel();
        p33.setLayout(new BoxLayout(p33, BoxLayout.LINE_AXIS));
        JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, p22, rightPane);
        sp.setDividerLocation(300);
      
 
        p33.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        p33.add(sp);
        add(p00);
        add(p33);
    	
        
        validateXML = new ValidateXML();
        validateXML.addObserver(rvp);
        
        rvp.setValidateXML(validateXML);
    }

    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
		
		if (evt.getSource() == btnLoadXML) {
			
				JFileChooser fc = new JFileChooser();
			    // Set the chooser to accept only XML files.
			    fc.addChoosableFileFilter(new XMLFileFilter());
			    fc.setAcceptAllFileFilterUsed(false);
			    
			    try {
			        // Create a File object containing the canonical path of the
			        // desired directory
			        File f = new File(new File("C:\\x73-Tool\\xml").getCanonicalPath());
			    
			        // Set the current directory
			        fc.setCurrentDirectory(f);
			    } catch (IOException e) {
			    }
		
			    int returnVal = fc.showOpenDialog(this);
			    File f = null;
			   
			    if(returnVal == JFileChooser.APPROVE_OPTION) {
			    	btnLoadXML.setEnabled(true);
					
				f = fc.getSelectedFile();
				btnValidateXML.setEnabled(true);
				selectedFile = f.getName();
				
				try {
					DefaultTreeModel model = new DefaultTreeModel(validateXML.getMainTree(selectedFile));
					validatorTree.setModel(model);
					validatorTree.setRootVisible(true);
				} catch (SAXException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (IOException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (ParserConfigurationException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			    }
			    else if (returnVal == JFileChooser.CANCEL_OPTION){
			    	return;	
			    }		
			    
			    
			    try {
                    treeNode = validateXML.getMainTree(selectedFile);
		}
	        catch (SAXException e1) {
		   e1.printStackTrace();
		} 
                 catch (IOException e1) {
		   e1.printStackTrace();
		} 
                 catch (ParserConfigurationException e1) {
		   e1.printStackTrace();
		}

                 Enumeration treeEnum = treeNode.preorderEnumeration();
                 DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode) treeEnum.nextElement(); 
                 String root = rootNode.toString();             
                 validateXML.setFileType(root);
                 validateXML.setSelectedFile(selectedFile);
                 
              //   CardLayout cl = (CardLayout) (rightPane.getLayout());
              //   cl.show(rightPane, "Blank");
		}
		if (evt.getSource() == btnValidateXML) {
				                        
                    validateXML.setValidateEnable();
                     CardLayout cl = (CardLayout) (rightPane.getLayout());
                      cl.show(rightPane, "ResultsValue");


                       
	    }
}
}
