<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" />
    <xsl:template match="/">
        <html>
            <body>
                <table border="1" bgcolor="#FFFFCC" width="100px">
                    <tr bgcolor="#E2E2E2">
                        <th>Index</th>
                        <th>Feature</th>
                        <th>Reference</th>
                        <th>Status</th>
                        <th>Support</th>
                        <th>Comment</th>
                    </tr>
                    <xsl:for-each select="//tr">
                        <xsl:variable name="color">
                            <xsl:choose>
                                <xsl:when test="position() mod 2 = 1 and count(Private) != 1">
                                    <xsl:text>#F8F8FF</xsl:text>
                                </xsl:when>
                                <xsl:when test="count(Private) = 1">
                                    <xsl:text>#D8BFD8</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>#FFFFCC</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        <tr bgcolor="{$color}">
                            <xsl:for-each select="./td">
                                <td>
                                    <xsl:apply-templates></xsl:apply-templates>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </table>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="br">
        <br>
            <xsl:value-of select="." />
        </br>
    </xsl:template>
    <xsl:template match="b">
        <b>
            <xsl:value-of select="." />
        </b>
    </xsl:template>
    <xsl:template match="i">
        <i>
            <xsl:value-of select="." />
        </i>
    </xsl:template>
</xsl:stylesheet>