<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" version="1.0" xmlns:dim="http://www.nist.gov/x73DIM" dim:dummy-for-xmlns="">
	<xsl:output method="text"/>
	<xsl:template match="*|@*" mode="schematron-get-full-path">
		<xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
		<xsl:text>/</xsl:text>
		<xsl:if test="count(. | ../@*) = count(../@*)">@</xsl:if>
		<xsl:value-of select="name()"/>
		<xsl:text>[</xsl:text>
		<xsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
		<xsl:text>]</xsl:text>
	</xsl:template>
	<xsl:template match="/">
<xsl:apply-templates select="/" mode="M1"/><xsl:apply-templates select="/" mode="M2"/><xsl:apply-templates select="/" mode="M3"/><xsl:apply-templates select="/" mode="M4"/><xsl:apply-templates select="/" mode="M5"/><xsl:apply-templates select="/" mode="M6"/><xsl:apply-templates select="/" mode="M7"/><xsl:apply-templates select="/" mode="M8"/></xsl:template>
	<xsl:template match="dim:DIM" priority="4000" mode="M1">
		<xsl:choose>
			<xsl:when test="count(dim:Simple_MDS)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Simple_MDS)&lt;2:
   Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Hydra_MDS)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Hydra_MDS)&lt;2:
   Hydra_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Composite_Single_Bed_MDS)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Composite_Single_Bed_MDS)&lt;2:
   Composite_Single_Bed_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M1"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M1"/>
	<xsl:template match="dim:Patient_Archive" priority="4000" mode="M2">
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Patient Archive should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M2"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M2"/>
	<xsl:template match="//dim:Simple_MDS | //dim:Hydra_MDS | //dim:Composite_Single_Bed_MDS |//dim:Alert |//dim:Alert_Monitor |//dim:Alert_Scanner | //dim:Alert_Status | //dim:Battery | //dim:Bedside_Communication_Controller| //dim:Clock| //dim:Context_Scanner| //dim:Device_Communication_Controller| //dim:EpiCfgScanner| //dim:Event_Log| //dim:FastPeriCfgScanner| //dim:Operating_Scanner| //dim:PatientDemographics| //dim:PeriCfgScanner| //dim:SCO | //dim:VMD| //dim:MultiPatient_Archive| //dim:Patient_Archive| //dim:Channel| //dim:PM_Store| //dim:Complex_Metric| //dim:Distribution_Simple_Array| //dim:Enumeration| //dim:Numeric| //dim:Real_Time_Sample_Array| //dim:Time_Sample_Array| //dim:PM_Segment| //dim:Activate_Operation| //dim:Limit_Alert_Operation| //dim:Select_Item_Operation| //dim:Set_Item_Operation| //dim:Set_Range_Operation| //dim:Set_String_Operation| //dim:Set_Value_Operation| //dim:Toggle_Flag_Operation| //dim:Device_interface| //dim:Session_Archive| //dim:Physician| //dim:Session_Notes| //dim:Session_Test" priority="4000" mode="M3">
		<xsl:choose>
			<xsl:when test="count(dim:OBJECT_NAME)=1"/>
			<xsl:otherwise>In pattern count(dim:OBJECT_NAME)=1:
   OBJECT_NAME in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:OBJECT_ID)=1"/>
			<xsl:otherwise>In pattern count(dim:OBJECT_ID)=1:
   OBJECT_id in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:TERM_CODE)=1"/>
			<xsl:otherwise>In pattern count(dim:TERM_CODE)=1:
   TERM_CODE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_TYPE_TERM_CODE)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, should appear at most once( 0 or 1
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_TYPE_ID)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:MOC_TYPE_ID)&lt;2:
   MOC_TYPE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, should appear at most once( 0 or 1
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Reference)=1"/>
			<xsl:otherwise>In pattern count(dim:Reference)=1:
   Reference in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_RESTRICTIONS)=1"/>
			<xsl:otherwise>In pattern count(dim:MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_APPLICATION_GUIDANCE)=1"/>
			<xsl:otherwise>In pattern count(dim:MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_COMMENT)=1"/>
			<xsl:otherwise>In pattern count(dim:MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Attribute_Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Attribute_Info)&lt;2:
   Attribute_Info in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Notification_Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Notification_Info)&lt;2:
   Notification_Info in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Behaviour_Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Behaviour_Info)&lt;2:
   Behaviour_Info in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M3"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M3"/>
	<xsl:template match="dim:Simple_MDS" priority="4000" mode="M4">
		<xsl:choose>
			<xsl:when test="count(dim:VMD)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:VMD)&lt;2:
   VMD in Simple_MDS should appear at most once( 0 or 1) in Simple_MDS
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M4"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M4"/>
	<xsl:template match="dim:Hydra_MDS" priority="4000" mode="M5">
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M5"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M5"/>
	<xsl:template match="dim:Simple_MDS" priority="4000" mode="M6">
		<xsl:choose>
			<xsl:when test="count(dim:VMD)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:VMD)&lt;2:
   VMD in Simple_MDS should appear at most once( 0 or 1) in Simple_MDS
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M6"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M6"/>
	<xsl:template match="dim:Hydra_MDS" priority="4000" mode="M7">
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M7"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M7"/>
	<xsl:template match="dim:Session_Archive" priority="4000" mode="M8">
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Patient Archive should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M8"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M8"/>
	<xsl:template match="text()" priority="-1"/>
</xsl:stylesheet>