<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dim="http://www.nist.gov/x73DIM">

	<xsl:output method="xml" indent="yes"/>
	
	<xsl:key name="objName" match="//dim:OBJECT_NAME" use="../dim:OBJECT_NAME"/>

	<xsl:template match="/">
			<PhdPocNotifICS>
     				<xsl:for-each select="//dim:OBJECT_NAME">
     					<xsl:sort select="../dim:OBJECT_NAME"/>     				
					<xsl:call-template name="row">
						<xsl:with-param name="obj" select="position()"></xsl:with-param>
					</xsl:call-template>     				
     				 </xsl:for-each>
   			</PhdPocNotifICS>
	</xsl:template>
	
	<xsl:template name="row">
		<xsl:param name="obj"></xsl:param>
		<xsl:for-each select="../*/*[dim:NOTIFICATION_NAME]| ../*/*/dim:Notification">
		<xsl:sort select="dim:NOTIFICATION_NAME"/> 		
			<Row>
				<Index>NOTI-<xsl:value-of select="$obj"/>-<xsl:value-of select="position()"/></Index>
		       		<Feature><xsl:value-of select="dim:NOTIFICATION_NAME"/>
						<xsl:if test= "string(name(.))='Notification'">
					<xsl:value-of select="dim:NOTIFICATION_ID"/>
				</xsl:if></Feature>
		      		<Reference><xsl:value-of select="substring-after(dim:Reference, 'clause')"/></Reference>
		      		<Status><xsl:value-of select="dim:Qual"/></Status>
	      			<Support>
			      		<xsl:if test="dim:NOTIFICATION_Restrictions!=''">
			     		Restrictions: <xsl:value-of select="dim:NOTIFICATION_Restrictions"/>
			     		</xsl:if>
		      		</Support>
      				<Comment><xsl:value-of select="dim:BEHAVIOUR_COMMENT"/></Comment>			
      			</Row>
			</xsl:for-each>					
		</xsl:template>
</xsl:stylesheet>
