<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="2.0" xmlns:pol="http://www.nist.gov/x73DIM" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" indent="yes"/>	
	<xsl:template match="/">
		<PhdPocICS>
			<xsl:for-each select="//pol:OBJECT_NAME">
     				<xsl:sort select="../pol:OBJECT_NAME"/>   
					<Row>
						<xsl:if test= "string(name(..))='Private-MOC'">
							<Private>true</Private>
						</xsl:if>
     					<Index>POC-<xsl:value-of select="position()"/></Index>
       					<Feature><xsl:value-of select="../pol:OBJECT_NAME"/>
							<xsl:if test="../pol:OBJECT_NAME/@Label!=''">:<xsl:value-of select="../pol:OBJECT_NAME/@Label"/>
					</xsl:if>
       					<!--xsl:value-of select="../pol:OBJECT_ID"/--></Feature>
      					<Reference><xsl:value-of select="substring-after(../pol:Reference, 'clause')"/></Reference>
      					<Status>Implemented</Status>
      					<Support>
							<xsl:value-of select="../pol:MOC_RESTRICTIONS"/>
							<xsl:if test="../pol:MOC_SERVICES_SUPPORTED!=''">Supported services::<xsl:value-of select="../pol:MOC_SERVICES_SUPPORTED"/>
							</xsl:if>
						</Support>
      					<Comment><xsl:value-of select="../pol:MOC_COMMENT"/></Comment>
      					</Row>
     		 </xsl:for-each>
		</PhdPocICS>
	</xsl:template>
</xsl:stylesheet>
