<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dim="http://www.nist.gov/x73DIM">
 <xsl:key name="distinct-ID" match="//*[name(.) = 'OBJECT_ID' or name(.)= 'ATTRIBUTE_ID' or name(.)='METHOD_ID' or name(.)='NOTIFICATION_ID' or name(.) = 'MOC_TYPE_ID']" use="."/>
	<xsl:output method="xml" indent="yes"/>	
	<xsl:template match="/">
	   		<PhdPocNomenICS>
     				<xsl:for-each select="//*[generate-id()=generate-id(key('distinct-ID',.)) and . != '']">
     				<xsl:sort select="."/> 
     				<Row>
					<xsl:call-template name="row">
						<xsl:with-param name="obj" select="position()"></xsl:with-param>
					</xsl:call-template>
					</Row>
     				 </xsl:for-each>
   			</PhdPocNomenICS>
	</xsl:template>
	<xsl:template name="row">
		<xsl:param name="obj"></xsl:param>
					<Index>NOME-<xsl:value-of select="$obj"/></Index>
		       		<Feature><xsl:value-of select="."/>(<xsl:value-of select="../*[contains(name(.), 'TERM_CODE')]"/>)</Feature>
			      	<Reference><xsl:value-of select="substring-after(../dim:Reference, 'clause')"/></Reference>
			      	<Status>Implemented</Status>
			      		<Support/>
			      		<Comment/>							
	</xsl:template>

</xsl:stylesheet>


