<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" version="1.0" xmlns:dim="http://www.nist.gov/x73DIM" dim:dummy-for-xmlns="">
	<xsl:output method="text"/>
	<xsl:template match="*|@*" mode="schematron-get-full-path">
		<xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
		<xsl:text>/</xsl:text>
		<xsl:if test="count(. | ../@*) = count(../@*)">@</xsl:if>
		<xsl:value-of select="name()"/>
		<xsl:text>[</xsl:text>
		<xsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
		<xsl:text>]</xsl:text>
	</xsl:template>
	<xsl:template match="/">
<xsl:apply-templates select="/" mode="M1"/><xsl:apply-templates select="/" mode="M2"/><xsl:apply-templates select="/" mode="M3"/><xsl:apply-templates select="/" mode="M4"/><xsl:apply-templates select="/" mode="M5"/><xsl:apply-templates select="/" mode="M6"/><xsl:apply-templates select="/" mode="M7"/><xsl:apply-templates select="/" mode="M8"/><xsl:apply-templates select="/" mode="M9"/><xsl:apply-templates select="/" mode="M10"/><xsl:apply-templates select="/" mode="M11"/><xsl:apply-templates select="/" mode="M12"/><xsl:apply-templates select="/" mode="M13"/><xsl:apply-templates select="/" mode="M14"/><xsl:apply-templates select="/" mode="M15"/><xsl:apply-templates select="/" mode="M16"/><xsl:apply-templates select="/" mode="M17"/><xsl:apply-templates select="/" mode="M18"/><xsl:apply-templates select="/" mode="M19"/><xsl:apply-templates select="/" mode="M20"/><xsl:apply-templates select="/" mode="M21"/><xsl:apply-templates select="/" mode="M22"/><xsl:apply-templates select="/" mode="M23"/><xsl:apply-templates select="/" mode="M24"/><xsl:apply-templates select="/" mode="M25"/><xsl:apply-templates select="/" mode="M26"/><xsl:apply-templates select="/" mode="M27"/><xsl:apply-templates select="/" mode="M28"/><xsl:apply-templates select="/" mode="M29"/><xsl:apply-templates select="/" mode="M30"/><xsl:apply-templates select="/" mode="M31"/><xsl:apply-templates select="/" mode="M32"/><xsl:apply-templates select="/" mode="M33"/><xsl:apply-templates select="/" mode="M34"/><xsl:apply-templates select="/" mode="M35"/><xsl:apply-templates select="/" mode="M36"/><xsl:apply-templates select="/" mode="M37"/><xsl:apply-templates select="/" mode="M38"/><xsl:apply-templates select="/" mode="M39"/><xsl:apply-templates select="/" mode="M40"/><xsl:apply-templates select="/" mode="M41"/><xsl:apply-templates select="/" mode="M42"/><xsl:apply-templates select="/" mode="M43"/><xsl:apply-templates select="/" mode="M44"/><xsl:apply-templates select="/" mode="M45"/><xsl:apply-templates select="/" mode="M46"/><xsl:apply-templates select="/" mode="M47"/><xsl:apply-templates select="/" mode="M48"/><xsl:apply-templates select="/" mode="M49"/><xsl:apply-templates select="/" mode="M50"/><xsl:apply-templates select="/" mode="M51"/><xsl:apply-templates select="/" mode="M52"/><xsl:apply-templates select="/" mode="M53"/><xsl:apply-templates select="/" mode="M54"/></xsl:template>
	<xsl:template match="dim:DIM" priority="4000" mode="M1">
		<xsl:choose>
			<xsl:when test="count(dim:Simple_MDS)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Simple_MDS)&lt;2:
   Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Hydra_MDS)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Hydra_MDS)&lt;2:
   Hydra_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Composite_Single_Bed_MDS)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Composite_Single_Bed_MDS)&lt;2:
   Composite_Single_Bed_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M1"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M1"/>
	<xsl:template match="dim:Patient_Archive" priority="4000" mode="M2">
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Patient Archive should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M2"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M2"/>
	<xsl:template match="//dim:Simple_MDS | //dim:Hydra_MDS | //dim:Composite_Single_Bed_MDS |//dim:Alert |//dim:Alert_Monitor |//dim:Alert_Scanner | //dim:Alert_Status | //dim:Battery | //dim:Bedside_Communication_Controller| //dim:Clock| //dim:Context_Scanner| //dim:Device_Communication_Controller| //dim:EpiCfgScanner| //dim:Event_Log| //dim:FastPeriCfgScanner| //dim:Operating_Scanner| //dim:PatientDemographics| //dim:PeriCfgScanner| //dim:SCO | //dim:VMD| //dim:MultiPatient_Archive| //dim:Patient_Archive| //dim:Channel| //dim:PM_Store| //dim:Complex_Metric| //dim:Distribution_Simple_Array| //dim:Enumeration| //dim:Numeric| //dim:Real_Time_Sample_Array| //dim:Time_Sample_Array| //dim:PM_Segment| //dim:Activate_Operation| //dim:Limit_Alert_Operation| //dim:Select_Item_Operation| //dim:Set_Item_Operation| //dim:Set_Range_Operation| //dim:Set_String_Operation| //dim:Set_Value_Operation| //dim:Toggle_Flag_Operation| //dim:Device_interface| //dim:Session_Archive| //dim:Physician| //dim:Session_Notes| //dim:Session_Test" priority="4000" mode="M3">
		<xsl:choose>
			<xsl:when test="count(dim:OBJECT_NAME)=1"/>
			<xsl:otherwise>In pattern count(dim:OBJECT_NAME)=1:
   OBJECT_NAME in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:OBJECT_ID)=1"/>
			<xsl:otherwise>In pattern count(dim:OBJECT_ID)=1:
   OBJECT_id in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:TERM_CODE)=1"/>
			<xsl:otherwise>In pattern count(dim:TERM_CODE)=1:
   TERM_CODE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_TYPE_TERM_CODE)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, should appear at most once( 0 or 1
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_TYPE_ID)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:MOC_TYPE_ID)&lt;2:
   MOC_TYPE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, should appear at most once( 0 or 1
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Reference)=1"/>
			<xsl:otherwise>In pattern count(dim:Reference)=1:
   Reference in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_RESTRICTIONS)=1"/>
			<xsl:otherwise>In pattern count(dim:MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_APPLICATION_GUIDANCE)=1"/>
			<xsl:otherwise>In pattern count(dim:MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MOC_COMMENT)=1"/>
			<xsl:otherwise>In pattern count(dim:MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Attribute_Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Attribute_Info)&lt;2:
   Attribute_Info in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Notification_Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Notification_Info)&lt;2:
   Notification_Info in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Behaviour_Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Behaviour_Info)&lt;2:
   Behaviour_Info in<xsl:text xml:space="preserve"/><xsl:value-of select="name(.)"/><xsl:text xml:space="preserve"/>, must appear one time
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M3"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M3"/>
	<xsl:template match="dim:Simple_MDS" priority="4000" mode="M4">
		<xsl:choose>
			<xsl:when test="count(dim:VMD)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:VMD)&lt;2:
   VMD in Simple_MDS should appear at most once( 0 or 1) in Simple_MDS
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M4"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M4"/>
	<xsl:template match="dim:Hydra_MDS" priority="4000" mode="M5">
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M5"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M5"/>
	<xsl:template match="dim:Simple_MDS" priority="4000" mode="M6">
		<xsl:choose>
			<xsl:when test="count(dim:VMD)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:VMD)&lt;2:
   VMD in Simple_MDS should appear at most once( 0 or 1) in Simple_MDS
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M6"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M6"/>
	<xsl:template match="dim:Hydra_MDS" priority="4000" mode="M7">
		<xsl:choose>
			<xsl:when test="count(dim:Clock)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M7"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M7"/>
	<xsl:template match="dim:Session_Archive" priority="4000" mode="M8">
		<xsl:choose>
			<xsl:when test="count(dim:Patient_Demographics)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient_Demographics)&lt;2:
   Patient_Demographics in Patient Archive should appear at most once( 0 or 1)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M8"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M8"/>
	<xsl:template match="//dim:VMD/dim:Attribute_Info" priority="4000" mode="M9">
		<xsl:choose>
			<xsl:when test="count(dim:VMD-Status)=1"/>
			<xsl:otherwise>In pattern count(dim:VMD-Status)=1:
   Element VMD-Status should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:VMD-Model)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:VMD-Model)&lt;2:
   Element VMD-Model should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)&lt;2:
   Element Instance-Number should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Production-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Production-Specification)&lt;2:
   Element Production-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compatibility-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compatibility-Id)&lt;2:
   Element Compatibility-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Parameter-Group)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Parameter-Group)&lt;2:
   Element Parameter-Group should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Position)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Position)&lt;2:
   Element Position should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operating-Hours)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operating-Hours)&lt;2:
   Element Operating-Hours should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Cycles)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Cycles)&lt;2:
   Element Operation-Cycles should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Principle)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Principle)&lt;2:
   Element Measurement-Principle should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Locale)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Locale)&lt;2:
   Element Locale should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M9"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M9"/>
	<xsl:template match="//dim:Channel/dim:Attribute_Info" priority="4000" mode="M10">
		<xsl:choose>
			<xsl:when test="count(dim:Channel-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Channel-Id)&lt;2:
   Element Channel-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Channel-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Channel-Status)&lt;2:
   Element Channel-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Physical-Channel-No)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Physical-Channel-No)&lt;2:
   Element Physical-Channel-No should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Logical-Channel-No)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Logical-Channel-No)&lt;2:
   Element Logical-Channel-No should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Parameter-Group)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Parameter-Group)&lt;2:
   Element Parameter-Group should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Principle)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Principle)&lt;2:
   Element Measurement-Principle should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Color)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Color)&lt;2:
   Element Color should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M10"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M10"/>
	<xsl:template match="//dim:Numeric/dim:Attribute_Info" priority="4000" mode="M11">
		<xsl:choose>
			<xsl:when test="count(dim:Nu-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Nu-Observed-Value)&lt;2:
   Element Nu-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compound-Nu-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compound-Nu-Observed-Value)&lt;2:
   Element Compound-Nu-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Absolute-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Absolute-Time-Stamp)&lt;2:
   Element Absolute-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Relative-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Relative-Time-Stamp)&lt;2:
   Element Relative-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:HiRes-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:HiRes-Time-Stamp)&lt;2:
   Element HiRes-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Nu-Measure-Range)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Nu-Measure-Range)&lt;2:
   Element Nu-Measure-Range should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Nu-Physiological-Range)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Nu-Physiological-Range)&lt;2:
   Element Nu-Physiological-Range should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Nu-Measure-Resolution)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Nu-Measure-Resolution)&lt;2:
   Element Nu-Measure-Resolution should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Display-Resolution)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Display-Resolution)&lt;2:
   Element Display-Resolution should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Accuracy)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Accuracy)&lt;2:
   Element Accuracy should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Specification)=1:
   Element Metric-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Max-Delay-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Max-Delay-Time)&lt;2:
   Element Max-Delay-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Status)&lt;2:
   Element Metric-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Status)&lt;2:
   Element Measurement-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Partition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Partition)&lt;2:
   Element Metric-Id-Partition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)&lt;2:
   Element Metric-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Ext)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Ext)&lt;2:
   Element Metric-Id-Ext should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-LabelString)&lt;2:
   Element Unit-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Source-List)&lt;2:
   Element Vmo-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Source-List)&lt;2:
   Element Metric-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Msmt-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Msmt-Site-List)&lt;2:
   Element Msmt-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Body-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Body-Site-List)&lt;2:
   Element Body-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Calibration)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Calibration)&lt;2:
   Element Metric-Calibration should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Color)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Color)&lt;2:
   Element Color should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Mode)&lt;2:
   Element Measure-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Period)&lt;2:
   Element Measure-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Averaging-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Averaging-Period)&lt;2:
   Element Averaging-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)&lt;2:
   Element Start-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)&lt;2:
   Element Stop-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Info-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Info-LabelString)&lt;2:
   Element Metric-Info-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance)&lt;2:
   Element Substance should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance-LabelString)&lt;2:
   Element Substance-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M11"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M11"/>
	<xsl:template match="//dim:Real_Time_Sample_Array/dim:Attribute_Info" priority="4000" mode="M12">
		<xsl:choose>
			<xsl:when test="count(dim:Sample-Period)=1"/>
			<xsl:otherwise>In pattern count(dim:Sample-Period)=1:
   Element Sample-Period should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sweep-Speed)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sweep-Speed)&lt;2:
   Element Sweep-Speed should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Average-Reporting-Delay)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Average-Reporting-Delay)&lt;2:
   Element Average-Reporting-Delay should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sample-Time-Sync)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sample-Time-Sync)&lt;2:
   Element Sample-Time-Sync should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:HiResSample-Time-Sync)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:HiResSample-Time-Sync)&lt;2:
   Element HiResSample-Time-Sync should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Specification)=1:
   Element Metric-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Max-Delay-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Max-Delay-Time)&lt;2:
   Element Max-Delay-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Status)&lt;2:
   Element Metric-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Status)&lt;2:
   Element Measurement-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Partition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Partition)&lt;2:
   Element Metric-Id-Partition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)&lt;2:
   Element Metric-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Ext)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Ext)&lt;2:
   Element Metric-Id-Ext should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-LabelString)&lt;2:
   Element Unit-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Source-List)&lt;2:
   Element Vmo-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Source-List)&lt;2:
   Element Metric-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Msmt-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Msmt-Site-List)&lt;2:
   Element Msmt-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Body-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Body-Site-List)&lt;2:
   Element Body-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Calibration)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Calibration)&lt;2:
   Element Metric-Calibration should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Period)&lt;2:
   Element Measure-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Averaging-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Averaging-Period)&lt;2:
   Element Averaging-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)&lt;2:
   Element Start-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Observed-Value)&lt;2:
   Element Sa-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compound-Sa-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compound-Sa-Observed-Value)&lt;2:
   Element Compound-Sa-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Sa-Specification)=1:
   Element Sa-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compression)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compression)&lt;2:
   Element Compression should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Scale-and-Range-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Scale-and-Range-Specification)=1:
   Element Scale-and-Range-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Physiological-Range)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Physiological-Range)&lt;2:
   Element Sa-Physiological-Range should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Visual-Grid)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Visual-Grid)&lt;2:
   Element Visual-Grid should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Calibration-Data)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Calibration-Data)&lt;2:
   Element Sa-Calibration-Data should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Filter-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Filter-Specification)&lt;2:
   Element Filter-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Filter-Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Filter-Label-String)&lt;2:
   Element Filter-Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Signal-Frequency)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Signal-Frequency)&lt;2:
   Element Sa-Signal-Frequency should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Measure-Resolution)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Measure-Resolution)&lt;2:
   Element Sa-Measure-Resolution should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Marker-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Marker-List)&lt;2:
   Element Sa-Marker-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)&lt;2:
   Element Stop-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Info-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Info-LabelString)&lt;2:
   Element Metric-Info-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance)&lt;2:
   Element Substance should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance-LabelString)&lt;2:
   Element Substance-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Color)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Color)&lt;2:
   Element Color should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Mode)&lt;2:
   Element Measure-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M12"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M12"/>
	<xsl:template match="//dim:Time_Sample_Array/dim:Attribute_Info" priority="4000" mode="M13">
		<xsl:choose>
			<xsl:when test="count(dim:Absolute-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Absolute-Time-Stamp)&lt;2:
   Element Absolute-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Relative-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Relative-Time-Stamp)&lt;2:
   Element Relative-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:HiRes-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:HiRes-Time-Stamp)&lt;2:
   Element HiRes-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sample-Period)=1"/>
			<xsl:otherwise>In pattern count(dim:Sample-Period)=1:
   Element Sample-Period should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sweep-Speed)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sweep-Speed)&lt;2:
   Element Sweep-Speed should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Tsa-Marker-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Tsa-Marker-List)&lt;2:
   Element Tsa-Marker-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Observed-Value)&lt;2:
   Element Sa-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compound-Sa-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compound-Sa-Observed-Value)&lt;2:
   Element Compound-Sa-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Sa-Specification)=1:
   Element Sa-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compression)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compression)&lt;2:
   Element Compression should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Scale-and-Range-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Scale-and-Range-Specification)=1:
   Element Scale-and-Range-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Physiological-Range)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Physiological-Range)&lt;2:
   Element Sa-Physiological-Range should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Visual-Grid)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Visual-Grid)&lt;2:
   Element Visual-Grid should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Calibration-Data)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Calibration-Data)&lt;2:
   Element Sa-Calibration-Data should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Filter-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Filter-Specification)&lt;2:
   Element Filter-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Filter-Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Filter-Label-String)&lt;2:
   Element Filter-Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Signal-Frequency)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Signal-Frequency)&lt;2:
   Element Sa-Signal-Frequency should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Measure-Resolution)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Measure-Resolution)&lt;2:
   Element Sa-Measure-Resolution should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Marker-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Marker-List)&lt;2:
   Element Sa-Marker-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Specification)=1:
   Element Metric-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Max-Delay-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Max-Delay-Time)&lt;2:
   Element Max-Delay-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Status)&lt;2:
   Element Metric-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Status)&lt;2:
   Element Measurement-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Partition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Partition)&lt;2:
   Element Metric-Id-Partition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)&lt;2:
   Element Metric-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Ext)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Ext)&lt;2:
   Element Metric-Id-Ext should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-LabelString)&lt;2:
   Element Unit-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Source-List)&lt;2:
   Element Vmo-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Source-List)&lt;2:
   Element Metric-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Msmt-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Msmt-Site-List)&lt;2:
   Element Msmt-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Body-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Body-Site-List)&lt;2:
   Element Body-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Calibration)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Calibration)&lt;2:
   Element Metric-Calibration should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Period)&lt;2:
   Element Measure-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Averaging-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Averaging-Period)&lt;2:
   Element Averaging-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)&lt;2:
   Element Start-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)&lt;2:
   Element Stop-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Info-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Info-LabelString)&lt;2:
   Element Metric-Info-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance)&lt;2:
   Element Substance should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance-LabelString)&lt;2:
   Element Substance-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Color)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Color)&lt;2:
   Element Color should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Mode)&lt;2:
   Element Measure-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M13"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M13"/>
	<xsl:template match="//dim:Distribution_Sample_Array/dim:Attribute_Info" priority="4000" mode="M14">
		<xsl:choose>
			<xsl:when test="count(dim:Absolute-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Absolute-Time-Stamp)&lt;2:
   Element Absolute-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Relative-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Relative-Time-Stamp)&lt;2:
   Element Relative-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:HiRes-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:HiRes-Time-Stamp)&lt;2:
   Element HiRes-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Distribution-Range-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Distribution-Range-Specification)=1:
   Element Distribution-Range-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:x-Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:x-Unit-Code)&lt;2:
   Element x-Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:x-Unit-Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:x-Unit-Label-String)&lt;2:
   Element x-Unit-Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Dsa-Marker-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Dsa-Marker-List)&lt;2:
   Element Dsa-Marker-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Observed-Value)&lt;2:
   Element Sa-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compound-Sa-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compound-Sa-Observed-Value)&lt;2:
   Element Compound-Sa-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Sa-Specification)=1:
   Element Sa-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compression)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compression)&lt;2:
   Element Compression should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Scale-and-Range-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Scale-and-Range-Specification)=1:
   Element Scale-and-Range-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Physiological-Range)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Physiological-Range)&lt;2:
   Element Sa-Physiological-Range should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Visual-Grid)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Visual-Grid)&lt;2:
   Element Visual-Grid should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Calibration-Data)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Calibration-Data)&lt;2:
   Element Sa-Calibration-Data should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Filter-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Filter-Specification)&lt;2:
   Element Filter-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Filter-Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Filter-Label-String)&lt;2:
   Element Filter-Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Signal-Frequency)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Signal-Frequency)&lt;2:
   Element Sa-Signal-Frequency should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Measure-Resolution)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Measure-Resolution)&lt;2:
   Element Sa-Measure-Resolution should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sa-Marker-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sa-Marker-List)&lt;2:
   Element Sa-Marker-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Specification)=1:
   Element Metric-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Max-Delay-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Max-Delay-Time)&lt;2:
   Element Max-Delay-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Status)&lt;2:
   Element Metric-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Status)&lt;2:
   Element Measurement-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Partition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Partition)&lt;2:
   Element Metric-Id-Partition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)&lt;2:
   Element Metric-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Ext)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Ext)&lt;2:
   Element Metric-Id-Ext should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-LabelString)&lt;2:
   Element Unit-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Source-List)&lt;2:
   Element Vmo-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Source-List)&lt;2:
   Element Metric-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Msmt-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Msmt-Site-List)&lt;2:
   Element Msmt-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Body-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Body-Site-List)&lt;2:
   Element Body-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Calibration)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Calibration)&lt;2:
   Element Metric-Calibration should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Period)&lt;2:
   Element Measure-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Averaging-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Averaging-Period)&lt;2:
   Element Averaging-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)&lt;2:
   Element Start-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)&lt;2:
   Element Stop-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Info-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Info-LabelString)&lt;2:
   Element Metric-Info-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance)&lt;2:
   Element Substance should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance-LabelString)&lt;2:
   Element Substance-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Color)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Color)&lt;2:
   Element Color should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Mode)&lt;2:
   Element Measure-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M14"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M14"/>
	<xsl:template match="//dim:Enumeration/dim:Attribute_Info" priority="4000" mode="M15">
		<xsl:choose>
			<xsl:when test="count(dim:Enum-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Enum-Observed-Value)&lt;2:
   Element Enum-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compound-Enum-Observed-Value)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compound-Enum-Observed-Value)&lt;2:
   Element Compound-Enum-Observed-Value should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Absolute-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Absolute-Time-Stamp)&lt;2:
   Element Absolute-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Relative-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Relative-Time-Stamp)&lt;2:
   Element Relative-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:HiRes-Time-Stamp)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:HiRes-Time-Stamp)&lt;2:
   Element HiRes-Time-Stamp should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Enum-Measure-Range)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Enum-Measure-Range)&lt;2:
   Element Enum-Measure-Range should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Enum-Measure-Range-Bit-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Enum-Measure-Range-Bit-String)&lt;2:
   Element Enum-Measure-Range-Bit-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Enum-Measure-Range-Labels)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Enum-Measure-Range-Labels)&lt;2:
   Element Enum-Measure-Range-Labels should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Specification)=1:
   Element Metric-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Max-Delay-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Max-Delay-Time)&lt;2:
   Element Max-Delay-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Status)&lt;2:
   Element Metric-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Status)&lt;2:
   Element Measurement-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Partition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Partition)&lt;2:
   Element Metric-Id-Partition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)&lt;2:
   Element Metric-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Ext)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Ext)&lt;2:
   Element Metric-Id-Ext should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-LabelString)&lt;2:
   Element Unit-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Source-List)&lt;2:
   Element Vmo-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Source-List)&lt;2:
   Element Metric-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Msmt-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Msmt-Site-List)&lt;2:
   Element Msmt-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Body-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Body-Site-List)&lt;2:
   Element Body-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Calibration)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Calibration)&lt;2:
   Element Metric-Calibration should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Period)&lt;2:
   Element Measure-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Averaging-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Averaging-Period)&lt;2:
   Element Averaging-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)&lt;2:
   Element Start-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)&lt;2:
   Element Stop-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Info-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Info-LabelString)&lt;2:
   Element Metric-Info-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance)&lt;2:
   Element Substance should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance-LabelString)&lt;2:
   Element Substance-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Color)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Color)&lt;2:
   Element Color should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Mode)&lt;2:
   Element Measure-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M15"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M15"/>
	<xsl:template match="//dim:Complex_Metric/dim:Attribute_Info" priority="4000" mode="M16">
		<xsl:choose>
			<xsl:when test="count(dim:Cmplx-Metric-Info)=1"/>
			<xsl:otherwise>In pattern count(dim:Cmplx-Metric-Info)=1:
   Element Cmplx-Metric-Info should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Cmplx-Observed-Value)=1"/>
			<xsl:otherwise>In pattern count(dim:Cmplx-Observed-Value)=1:
   Element Cmplx-Observed-Value should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Cmplx-Dyn-Attr)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Cmplx-Dyn-Attr)&lt;2:
   Element Cmplx-Dyn-Attr should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Cmplx-Static-Attr)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Cmplx-Static-Attr)&lt;2:
   Element Cmplx-Static-Attr should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Cmplx-Recursion-Depth)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Cmplx-Recursion-Depth)&lt;2:
   Element Cmplx-Recursion-Depth should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Specification)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Specification)=1:
   Element Metric-Specification should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Max-Delay-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Max-Delay-Time)&lt;2:
   Element Max-Delay-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Status)&lt;2:
   Element Metric-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measurement-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measurement-Status)&lt;2:
   Element Measurement-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Partition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Partition)&lt;2:
   Element Metric-Id-Partition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)&lt;2:
   Element Metric-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Ext)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Ext)&lt;2:
   Element Metric-Id-Ext should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-LabelString)&lt;2:
   Element Unit-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Source-List)&lt;2:
   Element Vmo-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Source-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Source-List)&lt;2:
   Element Metric-Source-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Msmt-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Msmt-Site-List)&lt;2:
   Element Msmt-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Body-Site-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Body-Site-List)&lt;2:
   Element Body-Site-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Calibration)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Calibration)&lt;2:
   Element Metric-Calibration should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Period)&lt;2:
   Element Measure-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Averaging-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Averaging-Period)&lt;2:
   Element Averaging-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)&lt;2:
   Element Start-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)&lt;2:
   Element Stop-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Info-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Info-LabelString)&lt;2:
   Element Metric-Info-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance)&lt;2:
   Element Substance should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Substance-LabelString)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Substance-LabelString)&lt;2:
   Element Substance-LabelString should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Color)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Color)&lt;2:
   Element Color should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Measure-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Measure-Mode)&lt;2:
   Element Measure-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M16"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M16"/>
	<xsl:template match="//dim:PM-Store/dim:Attribute_Info" priority="4000" mode="M17">
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Class)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Class)=1:
   Element Metric-Class should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Store-Sample-Algorithm)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Store-Sample-Algorithm)&lt;2:
   Element Store-Sample-Algorithm should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Storage-Format)=1"/>
			<xsl:otherwise>In pattern count(dim:Storage-Format)=1:
   Element Storage-Format should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Store-Capacity-Count)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Store-Capacity-Count)&lt;2:
   Element Store-Capacity-Count should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Store-Usage-Count)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Store-Usage-Count)&lt;2:
   Element Store-Usage-Count should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sample-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sample-Period)&lt;2:
   Element Sample-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Number-Of-Segments)=1"/>
			<xsl:otherwise>In pattern count(dim:Number-Of-Segments)=1:
   Element Number-Of-Segments should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M17"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M17"/>
	<xsl:template match="//dim:PM-Segment/dim:Attribute_Info" priority="4000" mode="M18">
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)=1"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)=1:
   Element Instance-Number should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)=1:
   Element Metric-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id-Ext)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id-Ext)&lt;2:
   Element Metric-Id-Ext should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Global-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Global-Reference)&lt;2:
   Element Vmo-Global-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Segment-Start-Abs-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Segment-Start-Abs-Time)&lt;2:
   Element Segment-Start-Abs-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Segment-End-Abs-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Segment-End-Abs-Time)&lt;2:
   Element Segment-End-Abs-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Segment-Usage-Count)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Segment-Usage-Count)&lt;2:
   Element Segment-Usage-Count should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Segment-Data)=1"/>
			<xsl:otherwise>In pattern count(dim:Segment-Data)=1:
   Element Segment-Data should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M18"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M18"/>
	<xsl:template match="//dim:Alert/dim:Attribute_Info" priority="4000" mode="M19">
		<xsl:choose>
			<xsl:when test="count(dim:Alert-Condition)=1"/>
			<xsl:otherwise>In pattern count(dim:Alert-Condition)=1:
   Element Alert-Condition should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Limit-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Limit-Specification)&lt;2:
   Element Limit-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M19"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M19"/>
	<xsl:template match="//dim:Alert_Status/dim:Attribute_Info" priority="4000" mode="M20">
		<xsl:choose>
			<xsl:when test="count(dim:Alert-Capab-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Alert-Capab-List)=1:
   Element Alert-Capab-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Tech-Alert-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Tech-Alert-List)&lt;2:
   Element Tech-Alert-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Physio-Alert-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Physio-Alert-List)&lt;2:
   Element Physio-Alert-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Limit-Spec-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Limit-Spec-List)&lt;2:
   Element Limit-Spec-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M20"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M20"/>
	<xsl:template match="//dim:Alert_Monitor/dim:Attribute_Info" priority="4000" mode="M21">
		<xsl:choose>
			<xsl:when test="count(dim:Device-Alert-Condition)=1"/>
			<xsl:otherwise>In pattern count(dim:Device-Alert-Condition)=1:
   Element Device-Alert-Condition should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Device-P-Alarm-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Device-P-Alarm-List)=1:
   Element Device-P-Alarm-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Device-T-Alarm-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Device-T-Alarm-List)=1:
   Element Device-T-Alarm-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Device-Sup-Alarm-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Device-Sup-Alarm-List)&lt;2:
   Element Device-Sup-Alarm-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Limit-Spec-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Limit-Spec-List)&lt;2:
   Element Limit-Spec-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Suspension-Period)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Suspension-Period)&lt;2:
   Element Suspension-Period should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M21"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M21"/>
	<xsl:template match="//dim:SCO/dim:Attribute_Info" priority="4000" mode="M22">
		<xsl:choose>
			<xsl:when test="count(dim:Sco-Capability)=1"/>
			<xsl:otherwise>In pattern count(dim:Sco-Capability)=1:
   Element Sco-Capability should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sco-Help-Text-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sco-Help-Text-String)&lt;2:
   Element Sco-Help-Text-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Activity-Indicator)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Activity-Indicator)&lt;2:
   Element Activity-Indicator should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Lock-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Lock-State)=1:
   Element Lock-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Invoke-Cookie)=1"/>
			<xsl:otherwise>In pattern count(dim:Invoke-Cookie)=1:
   Element Invoke-Cookie should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Type)=1:
   Element Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Label-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Label-String)&lt;2:
   Element Label-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M22"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M22"/>
	<xsl:template match="//dim:Select_Item_Operation/dim:Attribute_Info" priority="4000" mode="M23">
		<xsl:choose>
			<xsl:when test="count(dim:Selected-Item-Index)=1"/>
			<xsl:otherwise>In pattern count(dim:Selected-Item-Index)=1:
   Element Selected-Item-Index should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Nom-Partition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Nom-Partition)&lt;2:
   Element Nom-Partition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Select-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Select-List)=1:
   Element Select-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings)&lt;2:
   Element Operation-Text-Strings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)&lt;2:
   Element Operation-Text-Strings-Dyn should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M23"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M23"/>
	<xsl:template match="//dim:Set_Value_Operation/dim:Attribute_Info" priority="4000" mode="M24">
		<xsl:choose>
			<xsl:when test="count(dim:Current-Value)=1"/>
			<xsl:otherwise>In pattern count(dim:Current-Value)=1:
   Element Current-Value should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Set-Value-Range)=1"/>
			<xsl:otherwise>In pattern count(dim:Set-Value-Range)=1:
   Element Set-Value-Range should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Step-Width)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Step-Width)&lt;2:
   Element Step-Width should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings)&lt;2:
   Element Operation-Text-Strings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)&lt;2:
   Element Operation-Text-Strings-Dyn should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M24"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M24"/>
	<xsl:template match="//dim:Set_String_Operation/dim:Attribute_Info" priority="4000" mode="M25">
		<xsl:choose>
			<xsl:when test="count(dim:Current-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Current-String)&lt;2:
   Element Current-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Set-String-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Set-String-Spec)=1:
   Element Set-String-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings)&lt;2:
   Element Operation-Text-Strings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)&lt;2:
   Element Operation-Text-Strings-Dyn should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M25"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M25"/>
	<xsl:template match="//dim:Toggle_Flag_Operation/dim:Attribute_Info" priority="4000" mode="M26">
		<xsl:choose>
			<xsl:when test="count(dim:Toggle-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Toggle-State)=1:
   Element Toggle-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Toggle-Label-Strings)=1"/>
			<xsl:otherwise>In pattern count(dim:Toggle-Label-Strings)=1:
   Element Toggle-Label-Strings should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings)&lt;2:
   Element Operation-Text-Strings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)&lt;2:
   Element Operation-Text-Strings-Dyn should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M26"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M26"/>
	<xsl:template match="//dim:Activate_Operation/dim:Attribute_Info" priority="4000" mode="M27">
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings)&lt;2:
   Element Operation-Text-Strings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)&lt;2:
   Element Operation-Text-Strings-Dyn should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M27"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M27"/>
	<xsl:template match="//dim:Limit_Alert_Operation/dim:Attribute_Info" priority="4000" mode="M28">
		<xsl:choose>
			<xsl:when test="count(dim:Alert-Op-Capability)=1"/>
			<xsl:otherwise>In pattern count(dim:Alert-Op-Capability)=1:
   Element Alert-Op-Capability should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Alert-Op-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Alert-Op-State)=1:
   Element Alert-Op-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Current-Limits)=1"/>
			<xsl:otherwise>In pattern count(dim:Current-Limits)=1:
   Element Current-Limits should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Alert-Op-Text-String)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Alert-Op-Text-String)&lt;2:
   Element Alert-Op-Text-String should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Set-Value-Range)=1"/>
			<xsl:otherwise>In pattern count(dim:Set-Value-Range)=1:
   Element Set-Value-Range should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)=1"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)=1:
   Element Unit-Code should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Metric-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:Metric-Id)=1:
   Element Metric-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings)&lt;2:
   Element Operation-Text-Strings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)&lt;2:
   Element Operation-Text-Strings-Dyn should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M28"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M28"/>
	<xsl:template match="//dim:Set_Range_Operation/dim:Attribute_Info" priority="4000" mode="M29">
		<xsl:choose>
			<xsl:when test="count(dim:Current-Range)=1"/>
			<xsl:otherwise>In pattern count(dim:Current-Range)=1:
   Element Current-Range should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Range-Op-Text)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Range-Op-Text)&lt;2:
   Element Range-Op-Text should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Set-Value-Range)=1"/>
			<xsl:otherwise>In pattern count(dim:Set-Value-Range)=1:
   Element Set-Value-Range should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Step-Width)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Step-Width)&lt;2:
   Element Step-Width should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Unit-Code)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Unit-Code)&lt;2:
   Element Unit-Code should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings)&lt;2:
   Element Operation-Text-Strings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)&lt;2:
   Element Operation-Text-Strings-Dyn should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)&lt;2:
   Element Vmo-Reference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)&lt;2:
   Element Operational-State should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M29"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M29"/>
	<xsl:template match="//dim:PeriCfgScanner/dim:Attribute_Info" priority="4000" mode="M30">
		<xsl:choose>
			<xsl:when test="count(dim:Scan-Extensibility)=1"/>
			<xsl:otherwise>In pattern count(dim:Scan-Extensibility)=1:
   Element Scan-Extensibility should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Reporting-Interval)=1"/>
			<xsl:otherwise>In pattern count(dim:Reporting-Interval)=1:
   Element Reporting-Interval should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Scan-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Scan-List)=1:
   Element Scan-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Mode)=1"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Mode)=1:
   Element Confirm-Mode should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Timeout)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Timeout)&lt;2:
   Element Confirm-Timeout should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Transmit-Window)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Transmit-Window)&lt;2:
   Element Transmit-Window should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Scan-Config-Limit)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Scan-Config-Limit)&lt;2:
   Element Scan-Config-Limit should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)&lt;2:
   Element Instance-Number should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)=1:
   Element Operational-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M30"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M30"/>
	<xsl:template match="//dim:EpiCfgScanner/dim:Attribute_Info" priority="4000" mode="M31">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)&lt;2:
   Element Instance-Number should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)=1:
   Element Operational-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Scan-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Scan-List)=1:
   Element Scan-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Mode)=1"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Mode)=1:
   Element Confirm-Mode should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Timeout)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Timeout)&lt;2:
   Element Confirm-Timeout should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Transmit-Window)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Transmit-Window)&lt;2:
   Element Transmit-Window should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Scan-Config-Limit)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Scan-Config-Limit)&lt;2:
   Element Scan-Config-Limit should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M31"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M31"/>
	<xsl:template match="//dim:Context_Scanner/dim:Attribute_Info" priority="4000" mode="M32">
		<xsl:choose>
			<xsl:when test="count(dim:Context-Mode)=1"/>
			<xsl:otherwise>In pattern count(dim:Context-Mode)=1:
   Element Context-Mode should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)&lt;2:
   Element Instance-Number should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)=1:
   Element Operational-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Mode)&lt;2:
   Element Confirm-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Timeout)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Timeout)&lt;2:
   Element Confirm-Timeout should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Transmit-Window)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Transmit-Window)&lt;2:
   Element Transmit-Window should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M32"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M32"/>
	<xsl:template match="//dim:Alert_Scanner/dim:Attribute_Info" priority="4000" mode="M33">
		<xsl:choose>
			<xsl:when test="count(dim:Reporting-Interval)=1"/>
			<xsl:otherwise>In pattern count(dim:Reporting-Interval)=1:
   Element Reporting-Interval should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Mode)&lt;2:
   Element Confirm-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Timeout)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Timeout)&lt;2:
   Element Confirm-Timeout should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Transmit-Window)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Transmit-Window)&lt;2:
   Element Transmit-Window should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)&lt;2:
   Element Instance-Number should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)=1:
   Element Operational-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M33"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M33"/>
	<xsl:template match="//dim:Multipatient_Archive/dim:Attribute_Info" priority="4000" mode="M34">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:System-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:System-Id)=1:
   Element System-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Location)=1"/>
			<xsl:otherwise>In pattern count(dim:Location)=1:
   Element Location should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Study-Name)=1"/>
			<xsl:otherwise>In pattern count(dim:Study-Name)=1:
   Element Study-Name should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Version)=1"/>
			<xsl:otherwise>In pattern count(dim:Version)=1:
   Element Version should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M34"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M34"/>
	<xsl:template match="//dim:Patient_Archive/dim:Attribute_Info" priority="4000" mode="M35">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:System-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:System-Id)=1:
   Element System-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:System-Name)=1"/>
			<xsl:otherwise>In pattern count(dim:System-Name)=1:
   Element System-Name should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Processing-History)=1"/>
			<xsl:otherwise>In pattern count(dim:Processing-History)=1:
   Element Processing-History should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Protection)=1"/>
			<xsl:otherwise>In pattern count(dim:Protection)=1:
   Element Protection should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M35"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M35"/>
	<xsl:template match="//dim:Physician/dim:Attribute_Info" priority="4000" mode="M36">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Physican-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:Physican-Id)=1:
   Element Physican-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Authorization-Level)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Authorization-Level)&lt;2:
   Element Authorization-Level should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Name)&lt;2:
   Element Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Given-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Given-Name)&lt;2:
   Element Given-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Family-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Family-Name)&lt;2:
   Element Family-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Middle-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Middle-Name)&lt;2:
   Element Middle-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Title-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Title-Name)&lt;2:
   Element Title-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M36"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M36"/>
	<xsl:template match="//dim:Session_Notes/dim:Attribute_Info" priority="4000" mode="M37">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sn-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:Sn-Id)=1:
   Element Sn-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sn-Name)=1"/>
			<xsl:otherwise>In pattern count(dim:Sn-Name)=1:
   Element Sn-Name should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sn-Comments)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sn-Comments)&lt;2:
   Element Sn-Comments should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)=1"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)=1:
   Element Start-Time should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)=1"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)=1:
   Element Stop-Time should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Findings)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Findings)&lt;2:
   Element Findings should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Diagnostic-Codes)=1"/>
			<xsl:otherwise>In pattern count(dim:Diagnostic-Codes)=1:
   Element Diagnostic-Codes should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Diagnosis-Description)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Diagnosis-Description)&lt;2:
   Element Diagnosis-Description should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Procedure-Code)=1"/>
			<xsl:otherwise>In pattern count(dim:Procedure-Code)=1:
   Element Procedure-Code should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Procedure-Description)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Procedure-Description)&lt;2:
   Element Procedure-Description should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Protection)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Protection)&lt;2:
   Element Protection should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M37"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M37"/>
	<xsl:template match="//dim:Session_Test/dim:Attribute_Info" priority="4000" mode="M38">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:St-Archive-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:St-Archive-Id)=1:
   Element St-Archive-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:St-Archive-Name)=1"/>
			<xsl:otherwise>In pattern count(dim:St-Archive-Name)=1:
   Element St-Archive-Name should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:St-Archive-Comments)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:St-Archive-Comments)&lt;2:
   Element St-Archive-Comments should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)=1"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)=1:
   Element Start-Time should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)=1"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)=1:
   Element Stop-Time should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Protection)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Protection)&lt;2:
   Element Protection should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M38"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M38"/>
	<xsl:template match="//dim:Patient_Demographics/dim:Attribute_Info" priority="4000" mode="M39">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Pat-Demo-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Pat-Demo-State)=1:
   Element Pat-Demo-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Id)&lt;2:
   Element Patient-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Name)&lt;2:
   Element Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Given-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Given-Name)&lt;2:
   Element Given-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Family-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Family-Name)&lt;2:
   Element Family-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Middle-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Middle-Name)&lt;2:
   Element Middle-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Birth-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Birth-Name)&lt;2:
   Element Birth-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Title-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Title-Name)&lt;2:
   Element Title-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Sex)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Sex)&lt;2:
   Element Sex should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Race)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Race)&lt;2:
   Element Race should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Type)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Type)&lt;2:
   Element Patient-Type should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Date-Of-Birth)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Date-Of-Birth)&lt;2:
   Element Date-Of-Birth should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Gen-Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Gen-Info)&lt;2:
   Element Patient-Gen-Info should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Age)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Age)&lt;2:
   Element Patient-Age should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Gestational-Age)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Gestational-Age)&lt;2:
   Element Gestational-Age should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Height)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Height)&lt;2:
   Element Patient-Height should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Weight)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Weight)&lt;2:
   Element Patient-Weight should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Birth-Length)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Birth-Length)&lt;2:
   Element Patient-Birth-Length should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Birth-Weight)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Birth-Weight)&lt;2:
   Element Patient-Birth-Weight should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Mother-Patient-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Mother-Patient-Id)&lt;2:
   Element Mother-Patient-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Mother-Name)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Mother-Name)&lt;2:
   Element Mother-Name should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Head-Circumference)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Head-Circumference)&lt;2:
   Element Patient-Head-Circumference should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Bsa)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Bsa)&lt;2:
   Element Patient-Bsa should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Lbm)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Lbm)&lt;2:
   Element Patient-Lbm should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Bed-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Bed-Id)&lt;2:
   Element Bed-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Diagnostic-Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Diagnostic-Info)&lt;2:
   Element Diagnostic-Info should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Diagnostic-Codes)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Diagnostic-Codes)&lt;2:
   Element Diagnostic-Codes should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Admitting-Physician)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Admitting-Physician)&lt;2:
   Element Admitting-Physician should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Attending-Physician)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Attending-Physician)&lt;2:
   Element Attending-Physician should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Date-Of-Procedure)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Date-Of-Procedure)&lt;2:
   Element Date-Of-Procedure should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Procedure-Description)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Procedure-Description)&lt;2:
   Element Procedure-Description should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Procedures-Codes)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Procedures-Codes)&lt;2:
   Element Procedures-Codes should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Anaesthetic)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Anaesthetic)&lt;2:
   Element Anaesthetic should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Surgeon)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Surgeon)&lt;2:
   Element Surgeon should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M39"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M39"/>
	<xsl:template match="//dim:Session_Archive/dim:Attribute_Info" priority="4000" mode="M40">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:S-Archive-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:S-Archive-Id)=1:
   Element S-Archive-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:S-Archive-Name)=1"/>
			<xsl:otherwise>In pattern count(dim:S-Archive-Name)=1:
   Element S-Archive-Name should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:S-Archive-Comments)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:S-Archive-Comments)&lt;2:
   Element S-Archive-Comments should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Start-Time)=1"/>
			<xsl:otherwise>In pattern count(dim:Start-Time)=1:
   Element Start-Time should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Stop-Time)=1"/>
			<xsl:otherwise>In pattern count(dim:Stop-Time)=1:
   Element Stop-Time should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Protection)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Protection)&lt;2:
   Element Protection should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M40"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M40"/>
	<xsl:template match="//dim:Bedside_Communication_Controller/dim:Attribute_Info" priority="4000" mode="M41">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Capability)=1"/>
			<xsl:otherwise>In pattern count(dim:Capability)=1:
   Element Capability should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:CC-Type)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:CC-Type)&lt;2:
   Element CC-Type should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Number-Of-Difs)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Number-Of-Difs)&lt;2:
   Element Number-Of-Difs should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:This-Connection-Dif-Index)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:This-Connection-Dif-Index)&lt;2:
   Element This-Connection-Dif-Index should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Cc-Ext-Mgmt-Proto-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Cc-Ext-Mgmt-Proto-Id)&lt;2:
   Element Cc-Ext-Mgmt-Proto-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M41"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M41"/>
	<xsl:template match="//dim:Device_Communication_Controller/dim:Attribute_Info" priority="4000" mode="M42">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Capability)=1"/>
			<xsl:otherwise>In pattern count(dim:Capability)=1:
   Element Capability should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:CC-Type)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:CC-Type)&lt;2:
   Element CC-Type should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Number-Of-Difs)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Number-Of-Difs)&lt;2:
   Element Number-Of-Difs should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:This-Connection-Dif-Index)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:This-Connection-Dif-Index)&lt;2:
   Element This-Connection-Dif-Index should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Cc-Ext-Mgmt-Proto-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Cc-Ext-Mgmt-Proto-Id)&lt;2:
   Element Cc-Ext-Mgmt-Proto-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M42"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M42"/>
	<xsl:template match="//dim:Device_Interface/dim:Attribute_Info" priority="4000" mode="M43">
		<xsl:apply-templates mode="M43"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M43"/>
	<xsl:template match="//dim:Operating_Scanner/dim:Attribute_Info" priority="4000" mode="M44">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)&lt;2:
   Element Instance-Number should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)=1:
   Element Operational-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Mode)&lt;2:
   Element Confirm-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Confirm-Timeout)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Confirm-Timeout)&lt;2:
   Element Confirm-Timeout should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Transmit-Window)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Transmit-Window)&lt;2:
   Element Transmit-Window should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M44"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M44"/>
	<xsl:template match="//dim:Device_Interface_MibElement/dim:Attribute_Info" priority="4000" mode="M45">
		<xsl:choose>
			<xsl:when test="count(dim:Dif-Id)=1"/>
			<xsl:otherwise>In pattern count(dim:Dif-Id)=1:
   Element Dif-Id should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Port-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Port-State)=1:
   Element Port-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Port-Number)=1"/>
			<xsl:otherwise>In pattern count(dim:Port-Number)=1:
   Element Port-Number should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Dif-Type)=1"/>
			<xsl:otherwise>In pattern count(dim:Dif-Type)=1:
   Element Dif-Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Active-Profile)=1"/>
			<xsl:otherwise>In pattern count(dim:Active-Profile)=1:
   Element Active-Profile should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Supported-Profiles)=1"/>
			<xsl:otherwise>In pattern count(dim:Supported-Profiles)=1:
   Element Supported-Profiles should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:MTU)=1"/>
			<xsl:otherwise>In pattern count(dim:MTU)=1:
   Element MTU should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Link-Speed)=1"/>
			<xsl:otherwise>In pattern count(dim:Link-Speed)=1:
   Element Link-Speed should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Mib-Element-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Mib-Element-List)=1:
   Element Mib-Element-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M45"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M45"/>
	<xsl:template match="//dim:MDS/dim:Attribute_Info" priority="4000" mode="M46">
		<xsl:choose>
			<xsl:when test="count(dim:System-Type)=1"/>
			<xsl:otherwise>In pattern count(dim:System-Type)=1:
   Element System-Type should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:System-Model)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:System-Model)&lt;2:
   Element System-Model should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:System-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:System-Id)&lt;2:
   Element System-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Compatibility-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Compatibility-Id)&lt;2:
   Element Compatibility-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Nomenclature-Version)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Nomenclature-Version)&lt;2:
   Element Nomenclature-Version should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:System-Capability)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:System-Capability)&lt;2:
   Element System-Capability should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:System-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:System-Specification)&lt;2:
   Element System-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Production-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Production-Specification)&lt;2:
   Element Production-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Mds-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Mds-Status)&lt;2:
   Element Mds-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Bed-Label)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Bed-Label)&lt;2:
   Element Bed-Label should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Soft-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Soft-Id)&lt;2:
   Element Soft-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operating-Mode)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Operating-Mode)&lt;2:
   Element Operating-Mode should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Application-Area)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Application-Area)&lt;2:
   Element Application-Area should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Patient-Type)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Patient-Type)&lt;2:
   Element Patient-Type should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Date-and-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Date-and-Time)&lt;2:
   Element Date-and-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Relative-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Relative-Time)&lt;2:
   Element Relative-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:HiRes-Relative-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:HiRes-Relative-Time)&lt;2:
   Element HiRes-Relative-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Power-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Power-Status)&lt;2:
   Element Power-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Altitude)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Altitude)&lt;2:
   Element Altitude should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Battery-Level)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Battery-Level)&lt;2:
   Element Battery-Level should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Remaining-Battery-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Remaining-Battery-Time)&lt;2:
   Element Remaining-Battery-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Line-Frequency)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Line-Frequency)&lt;2:
   Element Line-Frequency should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Association-Invoke-Id)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Association-Invoke-Id)&lt;2:
   Element Association-Invoke-Id should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Locale)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Locale)&lt;2:
   Element Locale should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M46"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M46"/>
	<xsl:template match="//dim:Event_Log/dim:Attribute_Info" priority="4000" mode="M47">
		<xsl:choose>
			<xsl:when test="count(dim:Type)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Type)&lt;2:
   Element Type should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Event-Log-Entry-List)=1"/>
			<xsl:otherwise>In pattern count(dim:Event-Log-Entry-List)=1:
   Element Event-Log-Entry-List should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Event-Log-Info)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Event-Log-Info)&lt;2:
   Element Event-Log-Info should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Max-Log-Entries)=1"/>
			<xsl:otherwise>In pattern count(dim:Max-Log-Entries)=1:
   Element Max-Log-Entries should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Current-Log-Entries)=1"/>
			<xsl:otherwise>In pattern count(dim:Current-Log-Entries)=1:
   Element Current-Log-Entries should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Log-Change-Count)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Log-Change-Count)&lt;2:
   Element Log-Change-Count should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M47"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M47"/>
	<xsl:template match="//dim:Battery/dim:Attribute_Info" priority="4000" mode="M48">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Battery_Status)=1"/>
			<xsl:otherwise>In pattern count(dim:Battery_Status)=1:
   Element Battery_Status should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Production-Specification)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Production-Specification)&lt;2:
   Element Production-Specification should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Capacity-Remaining)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Capacity-Remaining)&lt;2:
   Element Capacity-Remaining should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Capacity-Full-Charge)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Capacity-Full-Charge)&lt;2:
   Element Capacity-Full-Charge should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Capacity-Specified)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Capacity-Specified)&lt;2:
   Element Capacity-Specified should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Remaining-Battery-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Remaining-Battery-Time)&lt;2:
   Element Remaining-Battery-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Voltage)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Voltage)&lt;2:
   Element Voltage should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Voltage-Specified)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Voltage-Specified)&lt;2:
   Element Voltage-Specified should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Current)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Current)&lt;2:
   Element Current should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Battery_Temperature)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Battery_Temperature)&lt;2:
   Element Battery_Temperature should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Charge-Cycles)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Charge-Cycles)&lt;2:
   Element Charge-Cycles should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M48"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M48"/>
	<xsl:template match="//dim:Clock/dim:Attribute_Info" priority="4000" mode="M49">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Time-Support)=1"/>
			<xsl:otherwise>In pattern count(dim:Time-Support)=1:
   Element Time-Support should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Date-Time-Status)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Date-Time-Status)&lt;2:
   Element Date-Time-Status should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Date-and-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Date-and-Time)&lt;2:
   Element Date-and-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:ISO-Date-and-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:ISO-Date-and-Time)&lt;2:
   Element ISO-Date-and-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Relative-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Relative-Time)&lt;2:
   Element Relative-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:HiRes-Relative-Time)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:HiRes-Relative-Time)&lt;2:
   Element HiRes-Relative-Time should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Ext-Time-Stamp-List)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Ext-Time-Stamp-List)&lt;2:
   Element Ext-Time-Stamp-List should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Absolute-Relative-Sync)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Absolute-Relative-Sync)&lt;2:
   Element Absolute-Relative-Sync should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Time-Zone)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Time-Zone)&lt;2:
   Element Time-Zone should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Daylight-Savings-Transition)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Daylight-Savings-Transition)&lt;2:
   Element Daylight-Savings-Transition should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Cumulative-Leap-Seconds)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Cumulative-Leap-Seconds)&lt;2:
   Element Cumulative-Leap-Seconds should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Next-Leap-Seconds)&lt;2"/>
			<xsl:otherwise>In pattern count(dim:Next-Leap-Seconds)&lt;2:
   Element Next-Leap-Seconds should be optional
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M49"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M49"/>
	<xsl:template match="//dim:Vms/dim:Attribute_Info" priority="4000" mode="M50">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Ext-Obj-Relations)=1"/>
			<xsl:otherwise>In pattern count(dim:Ext-Obj-Relations)=1:
   Element Ext-Obj-Relations should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M50"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M50"/>
	<xsl:template match="//dim:Operation/dim:Attribute_Info" priority="4000" mode="M51">
		<xsl:choose>
			<xsl:when test="count(dim:Instance-Number)=1"/>
			<xsl:otherwise>In pattern count(dim:Instance-Number)=1:
   Element Instance-Number should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Spec)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Spec)=1:
   Element Operation-Spec should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-String)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-String)=1:
   Element Operation-Text-String should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operation-Text-Strings-Dyn)=1"/>
			<xsl:otherwise>In pattern count(dim:Operation-Text-Strings-Dyn)=1:
   Element Operation-Text-Strings-Dyn should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Vmo-Reference)=1"/>
			<xsl:otherwise>In pattern count(dim:Vmo-Reference)=1:
   Element Vmo-Reference should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(dim:Operational-State)=1"/>
			<xsl:otherwise>In pattern count(dim:Operational-State)=1:
   Element Operational-State should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M51"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M51"/>
	<xsl:template match="//dim:MibElement/dim:Attribute_Info" priority="4000" mode="M52">
		<xsl:choose>
			<xsl:when test="count(dim:Handle)=1"/>
			<xsl:otherwise>In pattern count(dim:Handle)=1:
   Element Handle should be mandatory
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M52"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M52"/>
	<xsl:template match="AVA-Type" priority="4000" mode="M53">
		<xsl:choose>
			<xsl:when test="count(*)=2 and count(attribute-id)=1 and count(attribute-value)=1"/>
			<xsl:otherwise>In pattern count(*)=2 and count(attribute-id)=1 and count(attribute-value)=1:
   The Element AVA-Type should have child elements attribute-id and attribute-value
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="*[1]=attribute-id"/>
			<xsl:otherwise>In pattern *[1]=attribute-id:
   The element attribute-id must appear before the Element attribute-value
</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="attribute-id=2305 and name(*[2]/*)!='LimitSpecList'">In pattern attribute-id=2305 and name(*[2]/*)!='LimitSpecList':
   The attribute-id is 2305 therefore the first child of attribute-value must be LimitSpecList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2306 and name(*[2]/*)!='DevAlarmList'">In pattern attribute-id=2306 and name(*[2]/*)!='DevAlarmList':
   The attribute-id is 2306 therefore the first child of attribute-value must be DevAlarmList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2307 and name(*[2]/*)!='DevAlarmList'">In pattern attribute-id=2307 and name(*[2]/*)!='DevAlarmList':
   The attribute-id is 2307 therefore the first child of attribute-value must be DevAlarmList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2308 and name(*[2]/*)!='DevAlarmList'">In pattern attribute-id=2308 and name(*[2]/*)!='DevAlarmList':
   The attribute-id is 2308 therefore the first child of attribute-value must be DevAlarmList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2309 and name(*[2]/*)!='AlOpCapab'">In pattern attribute-id=2309 and name(*[2]/*)!='AlOpCapab':
   The attribute-id is 2309 therefore the first child of attribute-value must be AlOpCapab NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2310 and name(*[2]/*)!='CurLimAlStat'">In pattern attribute-id=2310 and name(*[2]/*)!='CurLimAlStat':
   The attribute-id is 2310 therefore the first child of attribute-value must be CurLimAlStat NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2312 and name(*[2]/*)!='AlertCapabList'">In pattern attribute-id=2312 and name(*[2]/*)!='AlertCapabList':
   The attribute-id is 2312 therefore the first child of attribute-value must be AlertCapabList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2314 and name(*[2]/*)!='AlertList'">In pattern attribute-id=2314 and name(*[2]/*)!='AlertList':
   The attribute-id is 2314 therefore the first child of attribute-value must be AlertList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2315 and name(*[2]/*)!='AlertList'">In pattern attribute-id=2315 and name(*[2]/*)!='AlertList':
   The attribute-id is 2315 therefore the first child of attribute-value must be AlertList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2316 and name(*[2]/*)!='INT-I16'">In pattern attribute-id=2316 and name(*[2]/*)!='INT-I16':
   The attribute-id is 2316 therefore the first child of attribute-value must be INT-I16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2317 and name(*[2]/*)!='ApplicationArea'">In pattern attribute-id=2317 and name(*[2]/*)!='ApplicationArea':
   The attribute-id is 2317 therefore the first child of attribute-value must be ApplicationArea NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2318 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2318 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2318 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2319 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2319 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2319 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2320 and name(*[2]/*)!='ChannelStatus'">In pattern attribute-id=2320 and name(*[2]/*)!='ChannelStatus':
   The attribute-id is 2320 therefore the first child of attribute-value must be ChannelStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2321 and name(*[2]/*)!='SimpleColour'">In pattern attribute-id=2321 and name(*[2]/*)!='SimpleColour':
   The attribute-id is 2321 therefore the first child of attribute-value must be SimpleColour NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2322 and name(*[2]/*)!='PrivateOid'">In pattern attribute-id=2322 and name(*[2]/*)!='PrivateOid':
   The attribute-id is 2322 therefore the first child of attribute-value must be PrivateOid NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2323 and name(*[2]/*)!='ConfirmMode'">In pattern attribute-id=2323 and name(*[2]/*)!='ConfirmMode':
   The attribute-id is 2323 therefore the first child of attribute-value must be ConfirmMode NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2324 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2324 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2324 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2325 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2325 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2325 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2326 and name(*[2]/*)!='DevAlertCondition'">In pattern attribute-id=2326 and name(*[2]/*)!='DevAlertCondition':
   The attribute-id is 2326 therefore the first child of attribute-value must be DevAlertCondition NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2327 and name(*[2]/*)!='DispResolution'">In pattern attribute-id=2327 and name(*[2]/*)!='DispResolution':
   The attribute-id is 2327 therefore the first child of attribute-value must be DispResolution NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2329 and name(*[2]/*)!='SaFilterSpec'">In pattern attribute-id=2329 and name(*[2]/*)!='SaFilterSpec':
   The attribute-id is 2329 therefore the first child of attribute-value must be SaFilterSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2330 and name(*[2]/*)!='SaVisualGrid16'">In pattern attribute-id=2330 and name(*[2]/*)!='SaVisualGrid16':
   The attribute-id is 2330 therefore the first child of attribute-value must be SaVisualGrid16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2331 and name(*[2]/*)!='SaVisualGrid32'">In pattern attribute-id=2331 and name(*[2]/*)!='SaVisualGrid32':
   The attribute-id is 2331 therefore the first child of attribute-value must be SaVisualGrid32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2332 and name(*[2]/*)!='SaVisualGrid8'">In pattern attribute-id=2332 and name(*[2]/*)!='SaVisualGrid8':
   The attribute-id is 2332 therefore the first child of attribute-value must be SaVisualGrid8 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2333 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2333 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2333 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2334 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2334 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2334 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2336 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2336 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2336 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2337 and name(*[2]/*)!='HANDLE'">In pattern attribute-id=2337 and name(*[2]/*)!='HANDLE':
   The attribute-id is 2337 therefore the first child of attribute-value must be HANDLE NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2338 and name(*[2]/*)!='InstNumber'">In pattern attribute-id=2338 and name(*[2]/*)!='InstNumber':
   The attribute-id is 2338 therefore the first child of attribute-value must be InstNumber NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2339 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2339 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2339 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2340 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2340 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2340 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2343 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2343 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2343 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2344 and name(*[2]/*)!='SystemModel'">In pattern attribute-id=2344 and name(*[2]/*)!='SystemModel':
   The attribute-id is 2344 therefore the first child of attribute-value must be SystemModel NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2345 and name(*[2]/*)!='NomPartition'">In pattern attribute-id=2345 and name(*[2]/*)!='NomPartition':
   The attribute-id is 2345 therefore the first child of attribute-value must be NomPartition NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2346 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2346 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2346 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2347 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2347 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2347 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2348 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2348 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2348 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2349 and name(*[2]/*)!='ProductionSpec'">In pattern attribute-id=2349 and name(*[2]/*)!='ProductionSpec':
   The attribute-id is 2349 therefore the first child of attribute-value must be ProductionSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2350 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2350 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2350 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2351 and name(*[2]/*)!='TYPE'">In pattern attribute-id=2351 and name(*[2]/*)!='TYPE':
   The attribute-id is 2351 therefore the first child of attribute-value must be TYPE NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2354 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2354 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2354 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2355 and name(*[2]/*)!='ScoActivityIndicator'">In pattern attribute-id=2355 and name(*[2]/*)!='ScoActivityIndicator':
   The attribute-id is 2355 therefore the first child of attribute-value must be ScoActivityIndicator NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2356 and name(*[2]/*)!='CurLimAlVal'">In pattern attribute-id=2356 and name(*[2]/*)!='CurLimAlVal':
   The attribute-id is 2356 therefore the first child of attribute-value must be CurLimAlVal NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2357 and name(*[2]/*)!='LineFrequency'">In pattern attribute-id=2357 and name(*[2]/*)!='LineFrequency':
   The attribute-id is 2357 therefore the first child of attribute-value must be LineFrequency NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2358 and name(*[2]/*)!='SelectList'">In pattern attribute-id=2358 and name(*[2]/*)!='SelectList':
   The attribute-id is 2358 therefore the first child of attribute-value must be SelectList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2359 and name(*[2]/*)!='SystemLocal'">In pattern attribute-id=2359 and name(*[2]/*)!='SystemLocal':
   The attribute-id is 2359 therefore the first child of attribute-value must be SystemLocal NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2360 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2360 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2360 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2361 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2361 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2361 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2362 and name(*[2]/*)!='MetricCalibration'">In pattern attribute-id=2362 and name(*[2]/*)!='MetricCalibration':
   The attribute-id is 2362 therefore the first child of attribute-value must be MetricCalibration NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2363 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2363 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2363 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2365 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2365 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2365 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2366 and name(*[2]/*)!='MetricSourceList'">In pattern attribute-id=2366 and name(*[2]/*)!='MetricSourceList':
   The attribute-id is 2366 therefore the first child of attribute-value must be MetricSourceList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2367 and name(*[2]/*)!='MetricSpec'">In pattern attribute-id=2367 and name(*[2]/*)!='MetricSpec':
   The attribute-id is 2367 therefore the first child of attribute-value must be MetricSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2368 and name(*[2]/*)!='MetricStatus'">In pattern attribute-id=2368 and name(*[2]/*)!='MetricStatus':
   The attribute-id is 2368 therefore the first child of attribute-value must be MetricStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2369 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2369 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2369 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2370 and name(*[2]/*)!='StorageFormat'">In pattern attribute-id=2370 and name(*[2]/*)!='StorageFormat':
   The attribute-id is 2370 therefore the first child of attribute-value must be StorageFormat NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2371 and name(*[2]/*)!='StoSampleAlg'">In pattern attribute-id=2371 and name(*[2]/*)!='StoSampleAlg':
   The attribute-id is 2371 therefore the first child of attribute-value must be StoSampleAlg NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2372 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2372 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2372 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2373 and name(*[2]/*)!='PrivateOid'">In pattern attribute-id=2373 and name(*[2]/*)!='PrivateOid':
   The attribute-id is 2373 therefore the first child of attribute-value must be PrivateOid NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2374 and name(*[2]/*)!='PrivateOid'">In pattern attribute-id=2374 and name(*[2]/*)!='PrivateOid':
   The attribute-id is 2374 therefore the first child of attribute-value must be PrivateOid NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2375 and name(*[2]/*)!='MeasurementStatus'">In pattern attribute-id=2375 and name(*[2]/*)!='MeasurementStatus':
   The attribute-id is 2375 therefore the first child of attribute-value must be MeasurementStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2376 and name(*[2]/*)!='NomenclatureVersion'">In pattern attribute-id=2376 and name(*[2]/*)!='NomenclatureVersion':
   The attribute-id is 2376 therefore the first child of attribute-value must be NomenclatureVersion NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2378 and name(*[2]/*)!='FLOAT-Type'">In pattern attribute-id=2378 and name(*[2]/*)!='FLOAT-Type':
   The attribute-id is 2378 therefore the first child of attribute-value must be FLOAT-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2379 and name(*[2]/*)!='NuObsValueCmp'">In pattern attribute-id=2379 and name(*[2]/*)!='NuObsValueCmp':
   The attribute-id is 2379 therefore the first child of attribute-value must be NuObsValueCmp NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2381 and name(*[2]/*)!='FLOAT-Type'">In pattern attribute-id=2381 and name(*[2]/*)!='FLOAT-Type':
   The attribute-id is 2381 therefore the first child of attribute-value must be FLOAT-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2382 and name(*[2]/*)!='AbsoluteRange'">In pattern attribute-id=2382 and name(*[2]/*)!='AbsoluteRange':
   The attribute-id is 2382 therefore the first child of attribute-value must be AbsoluteRange NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2383 and name(*[2]/*)!='AbsoluteRange'">In pattern attribute-id=2383 and name(*[2]/*)!='AbsoluteRange':
   The attribute-id is 2383 therefore the first child of attribute-value must be AbsoluteRange NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2384 and name(*[2]/*)!='NuObsValue'">In pattern attribute-id=2384 and name(*[2]/*)!='NuObsValue':
   The attribute-id is 2384 therefore the first child of attribute-value must be NuObsValue NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2385 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2385 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2385 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2386 and name(*[2]/*)!='OperSpec'">In pattern attribute-id=2386 and name(*[2]/*)!='OperSpec':
   The attribute-id is 2386 therefore the first child of attribute-value must be OperSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2387 and name(*[2]/*)!='OperationalState'">In pattern attribute-id=2387 and name(*[2]/*)!='OperationalState':
   The attribute-id is 2387 therefore the first child of attribute-value must be OperationalState NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2389 and name(*[2]/*)!='PowerStatus'">In pattern attribute-id=2389 and name(*[2]/*)!='PowerStatus':
   The attribute-id is 2389 therefore the first child of attribute-value must be PowerStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2390 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2390 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2390 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2391 and name(*[2]/*)!='PatDemoState'">In pattern attribute-id=2391 and name(*[2]/*)!='PatDemoState':
   The attribute-id is 2391 therefore the first child of attribute-value must be PatDemoState NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2392 and name(*[2]/*)!='Date'">In pattern attribute-id=2392 and name(*[2]/*)!='Date':
   The attribute-id is 2392 therefore the first child of attribute-value must be Date NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2393 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2393 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2393 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2394 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2394 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2394 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2395 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2395 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2395 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2396 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2396 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2396 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2397 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2397 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2397 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2398 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2398 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2398 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2399 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2399 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2399 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2400 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2400 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2400 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2401 and name(*[2]/*)!='PatientSex'">In pattern attribute-id=2401 and name(*[2]/*)!='PatientSex':
   The attribute-id is 2401 therefore the first child of attribute-value must be PatientSex NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2402 and name(*[2]/*)!='PatientType'">In pattern attribute-id=2402 and name(*[2]/*)!='PatientType':
   The attribute-id is 2402 therefore the first child of attribute-value must be PatientType NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2403 and name(*[2]/*)!='DsaRangeSpec'">In pattern attribute-id=2403 and name(*[2]/*)!='DsaRangeSpec':
   The attribute-id is 2403 therefore the first child of attribute-value must be DsaRangeSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2404 and name(*[2]/*)!='SaCalData16'">In pattern attribute-id=2404 and name(*[2]/*)!='SaCalData16':
   The attribute-id is 2404 therefore the first child of attribute-value must be SaCalData16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2405 and name(*[2]/*)!='SaCalData32'">In pattern attribute-id=2405 and name(*[2]/*)!='SaCalData32':
   The attribute-id is 2405 therefore the first child of attribute-value must be SaCalData32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2406 and name(*[2]/*)!='SaCalData8'">In pattern attribute-id=2406 and name(*[2]/*)!='SaCalData8':
   The attribute-id is 2406 therefore the first child of attribute-value must be SaCalData8 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2407 and name(*[2]/*)!='SaObsValueCmp'">In pattern attribute-id=2407 and name(*[2]/*)!='SaObsValueCmp':
   The attribute-id is 2407 therefore the first child of attribute-value must be SaObsValueCmp NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2408 and name(*[2]/*)!='SaSignalFrequency'">In pattern attribute-id=2408 and name(*[2]/*)!='SaSignalFrequency':
   The attribute-id is 2408 therefore the first child of attribute-value must be SaSignalFrequency NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2409 and name(*[2]/*)!='FLOAT-Type'">In pattern attribute-id=2409 and name(*[2]/*)!='FLOAT-Type':
   The attribute-id is 2409 therefore the first child of attribute-value must be FLOAT-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2410 and name(*[2]/*)!='ScaledRange16'">In pattern attribute-id=2410 and name(*[2]/*)!='ScaledRange16':
   The attribute-id is 2410 therefore the first child of attribute-value must be ScaledRange16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2411 and name(*[2]/*)!='ScaledRange32'">In pattern attribute-id=2411 and name(*[2]/*)!='ScaledRange32':
   The attribute-id is 2411 therefore the first child of attribute-value must be ScaledRange32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2412 and name(*[2]/*)!='ScaledRange8'">In pattern attribute-id=2412 and name(*[2]/*)!='ScaledRange8':
   The attribute-id is 2412 therefore the first child of attribute-value must be ScaledRange8 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2413 and name(*[2]/*)!='SaSpec'">In pattern attribute-id=2413 and name(*[2]/*)!='SaSpec':
   The attribute-id is 2413 therefore the first child of attribute-value must be SaSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2414 and name(*[2]/*)!='SaObsValue'">In pattern attribute-id=2414 and name(*[2]/*)!='SaObsValue':
   The attribute-id is 2414 therefore the first child of attribute-value must be SaObsValue NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2415 and name(*[2]/*)!='ScaleRangeSpec16'">In pattern attribute-id=2415 and name(*[2]/*)!='ScaleRangeSpec16':
   The attribute-id is 2415 therefore the first child of attribute-value must be ScaleRangeSpec16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2416 and name(*[2]/*)!='ScaleRangeSpec32'">In pattern attribute-id=2416 and name(*[2]/*)!='ScaleRangeSpec32':
   The attribute-id is 2416 therefore the first child of attribute-value must be ScaleRangeSpec32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2417 and name(*[2]/*)!='ScaleRangeSpec8'">In pattern attribute-id=2417 and name(*[2]/*)!='ScaleRangeSpec8':
   The attribute-id is 2417 therefore the first child of attribute-value must be ScaleRangeSpec8 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2418 and name(*[2]/*)!='ContextMode'">In pattern attribute-id=2418 and name(*[2]/*)!='ContextMode':
   The attribute-id is 2418 therefore the first child of attribute-value must be ContextMode NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2419 and name(*[2]/*)!='ScanExtend'">In pattern attribute-id=2419 and name(*[2]/*)!='ScanExtend':
   The attribute-id is 2419 therefore the first child of attribute-value must be ScanExtend NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2420 and name(*[2]/*)!='ScanList'">In pattern attribute-id=2420 and name(*[2]/*)!='ScanList':
   The attribute-id is 2420 therefore the first child of attribute-value must be ScanList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2421 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2421 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2421 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2422 and name(*[2]/*)!='ScoCapability'">In pattern attribute-id=2422 and name(*[2]/*)!='ScoCapability':
   The attribute-id is 2422 therefore the first child of attribute-value must be ScoCapability NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2424 and name(*[2]/*)!='SegDataGen'">In pattern attribute-id=2424 and name(*[2]/*)!='SegDataGen':
   The attribute-id is 2424 therefore the first child of attribute-value must be SegDataGen NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2425 and name(*[2]/*)!='SegDataNuOpt'">In pattern attribute-id=2425 and name(*[2]/*)!='SegDataNuOpt':
   The attribute-id is 2425 therefore the first child of attribute-value must be SegDataNuOpt NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2426 and name(*[2]/*)!='SegDataRtsaOpt'">In pattern attribute-id=2426 and name(*[2]/*)!='SegDataRtsaOpt':
   The attribute-id is 2426 therefore the first child of attribute-value must be SegDataRtsaOpt NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2427 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2427 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2427 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2429 and name(*[2]/*)!='SiteList'">In pattern attribute-id=2429 and name(*[2]/*)!='SiteList':
   The attribute-id is 2429 therefore the first child of attribute-value must be SiteList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2430 and name(*[2]/*)!='SiteList'">In pattern attribute-id=2430 and name(*[2]/*)!='SiteList':
   The attribute-id is 2430 therefore the first child of attribute-value must be SiteList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2431 and name(*[2]/*)!='MetricMeasure'">In pattern attribute-id=2431 and name(*[2]/*)!='MetricMeasure':
   The attribute-id is 2431 therefore the first child of attribute-value must be MetricMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2432 and name(*[2]/*)!='AdministrativeState'">In pattern attribute-id=2432 and name(*[2]/*)!='AdministrativeState':
   The attribute-id is 2432 therefore the first child of attribute-value must be AdministrativeState NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2433 and name(*[2]/*)!='ToggleState'">In pattern attribute-id=2433 and name(*[2]/*)!='ToggleState':
   The attribute-id is 2433 therefore the first child of attribute-value must be ToggleState NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2434 and name(*[2]/*)!='SafetyStandard'">In pattern attribute-id=2434 and name(*[2]/*)!='SafetyStandard':
   The attribute-id is 2434 therefore the first child of attribute-value must be SafetyStandard NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2435 and name(*[2]/*)!='SystemCapability'">In pattern attribute-id=2435 and name(*[2]/*)!='SystemCapability':
   The attribute-id is 2435 therefore the first child of attribute-value must be SystemCapability NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2436 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2436 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2436 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2437 and name(*[2]/*)!='SystemSpec'">In pattern attribute-id=2437 and name(*[2]/*)!='SystemSpec':
   The attribute-id is 2437 therefore the first child of attribute-value must be SystemSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2438 and name(*[2]/*)!='TYPE'">In pattern attribute-id=2438 and name(*[2]/*)!='TYPE':
   The attribute-id is 2438 therefore the first child of attribute-value must be TYPE NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2439 and *[2]/* !=//AbsoluteTime">In pattern attribute-id=2439 and *[2]/* !=//AbsoluteTime:
   The attribute-id is 2439 therefore the first child of attribute-value must be AbsoluteTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2440 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2440 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2440 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2442 and name(*[2]/*)!='AbsoluteTime'">In pattern attribute-id=2442 and name(*[2]/*)!='AbsoluteTime':
   The attribute-id is 2442 therefore the first child of attribute-value must be AbsoluteTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2443 and name(*[2]/*)!='MetricMeasure'">In pattern attribute-id=2443 and name(*[2]/*)!='MetricMeasure':
   The attribute-id is 2443 therefore the first child of attribute-value must be MetricMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2444 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2444 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2444 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2445 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2445 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2445 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2446 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2446 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2446 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2447 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2447 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2447 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2448 and name(*[2]/*)!='AbsoluteTime'">In pattern attribute-id=2448 and name(*[2]/*)!='AbsoluteTime':
   The attribute-id is 2448 therefore the first child of attribute-value must be AbsoluteTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2449 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2449 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2449 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2450 and name(*[2]/*)!='AbsoluteTime'">In pattern attribute-id=2450 and name(*[2]/*)!='AbsoluteTime':
   The attribute-id is 2450 therefore the first child of attribute-value must be AbsoluteTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2452 and name(*[2]/*)!='MarkerListRelTim'">In pattern attribute-id=2452 and name(*[2]/*)!='MarkerListRelTim':
   The attribute-id is 2452 therefore the first child of attribute-value must be MarkerListRelTim NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2453 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2453 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2453 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2454 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2454 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2454 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2455 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2455 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2455 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2457 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2457 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2457 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2458 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2458 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2458 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2460 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2460 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2460 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2461 and name(*[2]/*)!='FLOAT-Type'">In pattern attribute-id=2461 and name(*[2]/*)!='FLOAT-Type':
   The attribute-id is 2461 therefore the first child of attribute-value must be FLOAT-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2462 and name(*[2]/*)!='EnumObsValue'">In pattern attribute-id=2462 and name(*[2]/*)!='EnumObsValue':
   The attribute-id is 2462 therefore the first child of attribute-value must be EnumObsValue NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2463 and name(*[2]/*)!='EnumObsValueCmp'">In pattern attribute-id=2463 and name(*[2]/*)!='EnumObsValueCmp':
   The attribute-id is 2463 therefore the first child of attribute-value must be EnumObsValueCmp NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2464 and name(*[2]/*)!='OpSetValueRange'">In pattern attribute-id=2464 and name(*[2]/*)!='OpSetValueRange':
   The attribute-id is 2464 therefore the first child of attribute-value must be OpSetValueRange NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2465 and name(*[2]/*)!='OpValStepWidth'">In pattern attribute-id=2465 and name(*[2]/*)!='OpValStepWidth':
   The attribute-id is 2465 therefore the first child of attribute-value must be OpValStepWidth NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2466 and name(*[2]/*)!='VMDStatus'">In pattern attribute-id=2466 and name(*[2]/*)!='VMDStatus':
   The attribute-id is 2466 therefore the first child of attribute-value must be VMDStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2467 and name(*[2]/*)!='VmoSourceList'">In pattern attribute-id=2467 and name(*[2]/*)!='VmoSourceList':
   The attribute-id is 2467 therefore the first child of attribute-value must be VmoSourceList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2468 and name(*[2]/*)!='HANDLE'">In pattern attribute-id=2468 and name(*[2]/*)!='HANDLE':
   The attribute-id is 2468 therefore the first child of attribute-value must be HANDLE NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2469 and name(*[2]/*)!='GLB-HANDLE'">In pattern attribute-id=2469 and name(*[2]/*)!='GLB-HANDLE':
   The attribute-id is 2469 therefore the first child of attribute-value must be GLB-HANDLE NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2471 and name(*[2]/*)!='MDSStatus'">In pattern attribute-id=2471 and name(*[2]/*)!='MDSStatus':
   The attribute-id is 2471 therefore the first child of attribute-value must be MDSStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2476 and name(*[2]/*)!='AlertCondition'">In pattern attribute-id=2476 and name(*[2]/*)!='AlertCondition':
   The attribute-id is 2476 therefore the first child of attribute-value must be AlertCondition NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2477 and name(*[2]/*)!='LimitSpecEntry'">In pattern attribute-id=2477 and name(*[2]/*)!='LimitSpecEntry':
   The attribute-id is 2477 therefore the first child of attribute-value must be LimitSpecEntry NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2478 and name(*[2]/*)!='AlOpTextString'">In pattern attribute-id=2478 and name(*[2]/*)!='AlOpTextString':
   The attribute-id is 2478 therefore the first child of attribute-value must be AlOpTextString NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2479 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2479 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2479 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2480 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2480 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2480 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2481 and name(*[2]/*)!='Authorization'">In pattern attribute-id=2481 and name(*[2]/*)!='Authorization':
   The attribute-id is 2481 therefore the first child of attribute-value must be Authorization NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2482 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2482 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2482 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2483 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2483 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2483 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2484 and name(*[2]/*)!='BatteryStatus'">In pattern attribute-id=2484 and name(*[2]/*)!='BatteryStatus':
   The attribute-id is 2484 therefore the first child of attribute-value must be BatteryStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2485 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2485 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2485 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2486 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2486 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2486 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2487 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2487 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2487 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2488 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2488 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2488 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2489 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2489 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2489 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2490 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2490 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2490 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2491 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2491 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2491 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2492 and name(*[2]/*)!='ExtNomenRef'">In pattern attribute-id=2492 and name(*[2]/*)!='ExtNomenRef':
   The attribute-id is 2492 therefore the first child of attribute-value must be ExtNomenRef NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2493 and name(*[2]/*)!='ExtNomenRef'">In pattern attribute-id=2493 and name(*[2]/*)!='ExtNomenRef':
   The attribute-id is 2493 therefore the first child of attribute-value must be ExtNomenRef NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2494 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2494 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2494 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2495 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2495 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2495 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2496 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2496 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2496 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2500 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2500 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2500 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2501 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2501 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2501 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2502 and name(*[2]/*)!='ExtNomenRef'">In pattern attribute-id=2502 and name(*[2]/*)!='ExtNomenRef':
   The attribute-id is 2502 therefore the first child of attribute-value must be ExtNomenRef NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2503 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2503 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2503 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2504 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2504 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2504 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2505 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2505 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2505 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2506 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2506 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2506 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2507 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2507 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2507 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2508 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2508 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2508 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2509 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2509 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2509 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2510 and name(*[2]/*)!='OID-Type'">In pattern attribute-id=2510 and name(*[2]/*)!='OID-Type':
   The attribute-id is 2510 therefore the first child of attribute-value must be OID-Type NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2511 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2511 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2511 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2512 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2512 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2512 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2513 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2513 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2513 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2514 and name(*[2]/*)!='OperTextStrings'">In pattern attribute-id=2514 and name(*[2]/*)!='OperTextStrings':
   The attribute-id is 2514 therefore the first child of attribute-value must be OperTextStrings NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2515 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2515 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2515 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2516 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2516 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2516 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2517 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2517 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2517 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2518 and name(*[2]/*)!='Date'">In pattern attribute-id=2518 and name(*[2]/*)!='Date':
   The attribute-id is 2518 therefore the first child of attribute-value must be Date NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2519 and name(*[2]/*)!='ArchiveProtection'">In pattern attribute-id=2519 and name(*[2]/*)!='ArchiveProtection':
   The attribute-id is 2519 therefore the first child of attribute-value must be ArchiveProtection NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2520 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2520 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2520 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2521 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2521 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2521 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2522 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2522 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2522 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2523 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2523 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2523 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2524 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2524 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2524 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2525 and name(*[2]/*)!='PatientName'">In pattern attribute-id=2525 and name(*[2]/*)!='PatientName':
   The attribute-id is 2525 therefore the first child of attribute-value must be PatientName NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2526 and name(*[2]/*)!='PatientRace'">In pattern attribute-id=2526 and name(*[2]/*)!='PatientRace':
   The attribute-id is 2526 therefore the first child of attribute-value must be PatientRace NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2527 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2527 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2527 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2528 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2528 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2528 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2529 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2529 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2529 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2530 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2530 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2530 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2531 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2531 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2531 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2532 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2532 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2532 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2534 and name(*[2]/*)!='BatMeasure'">In pattern attribute-id=2534 and name(*[2]/*)!='BatMeasure':
   The attribute-id is 2534 therefore the first child of attribute-value must be BatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2535 and name(*[2]/*)!='MetricMeasure'">In pattern attribute-id=2535 and name(*[2]/*)!='MetricMeasure':
   The attribute-id is 2535 therefore the first child of attribute-value must be MetricMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2536 and name(*[2]/*)!='HighResRelativeTime'">In pattern attribute-id=2536 and name(*[2]/*)!='HighResRelativeTime':
   The attribute-id is 2536 therefore the first child of attribute-value must be HighResRelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2537 and name(*[2]/*)!='HighResRelativeTime'">In pattern attribute-id=2537 and name(*[2]/*)!='HighResRelativeTime':
   The attribute-id is 2537 therefore the first child of attribute-value must be HighResRelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2538 and name(*[2]/*)!='AbsoluteTime'">In pattern attribute-id=2538 and name(*[2]/*)!='AbsoluteTime':
   The attribute-id is 2538 therefore the first child of attribute-value must be AbsoluteTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2539 and name(*[2]/*)!='AbsoluteTime'">In pattern attribute-id=2539 and name(*[2]/*)!='AbsoluteTime':
   The attribute-id is 2539 therefore the first child of attribute-value must be AbsoluteTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2540 and name(*[2]/*)!='ToggleLabelStrings'">In pattern attribute-id=2540 and name(*[2]/*)!='ToggleLabelStrings':
   The attribute-id is 2540 therefore the first child of attribute-value must be ToggleLabelStrings NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2542 and name(*[2]/*)!='ExtNomenRef'">In pattern attribute-id=2542 and name(*[2]/*)!='ExtNomenRef':
   The attribute-id is 2542 therefore the first child of attribute-value must be ExtNomenRef NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2543 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2543 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2543 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2544 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2544 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2544 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2545 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2545 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2545 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2546 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2546 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2546 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2547 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2547 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2547 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2548 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2548 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2548 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2549 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2549 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2549 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2550 and name(*[2]/*)!='SiteListExt'">In pattern attribute-id=2550 and name(*[2]/*)!='SiteListExt':
   The attribute-id is 2550 therefore the first child of attribute-value must be SiteListExt NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2551 and name(*[2]/*)!='SiteListExt'">In pattern attribute-id=2551 and name(*[2]/*)!='SiteListExt':
   The attribute-id is 2551 therefore the first child of attribute-value must be SiteListExt NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2558 and name(*[2]/*)!='ScanConfigLimit'">In pattern attribute-id=2558 and name(*[2]/*)!='ScanConfigLimit':
   The attribute-id is 2558 therefore the first child of attribute-value must be ScanConfigLimit NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2560 and name(*[2]/*)!='MsmtPrinciple'">In pattern attribute-id=2560 and name(*[2]/*)!='MsmtPrinciple':
   The attribute-id is 2560 therefore the first child of attribute-value must be MsmtPrinciple NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2561 and name(*[2]/*)!='EnumMsmtRange'">In pattern attribute-id=2561 and name(*[2]/*)!='EnumMsmtRange':
   The attribute-id is 2561 therefore the first child of attribute-value must be EnumMsmtRange NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2564 and name(*[2]/*)!='EventLogEntryList'">In pattern attribute-id=2564 and name(*[2]/*)!='EventLogEntryList':
   The attribute-id is 2564 therefore the first child of attribute-value must be EventLogEntryList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2565 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2565 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2565 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2567 and name(*[2]/*)!='SetStringSpec'">In pattern attribute-id=2567 and name(*[2]/*)!='SetStringSpec':
   The attribute-id is 2567 therefore the first child of attribute-value must be SetStringSpec NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2568 and name(*[2]/*)!='BITS-32'">In pattern attribute-id=2568 and name(*[2]/*)!='BITS-32':
   The attribute-id is 2568 therefore the first child of attribute-value must be BITS-32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2582 and name(*[2]/*)!='MarkerListSaVal16'">In pattern attribute-id=2582 and name(*[2]/*)!='MarkerListSaVal16':
   The attribute-id is 2582 therefore the first child of attribute-value must be MarkerListSaVal16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2583 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2583 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2583 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2591 and name(*[2]/*)!='EventLogInfo'">In pattern attribute-id=2591 and name(*[2]/*)!='EventLogInfo':
   The attribute-id is 2591 therefore the first child of attribute-value must be EventLogInfo NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2592 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2592 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2592 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2593 and name(*[2]/*)!='CcCapability'">In pattern attribute-id=2593 and name(*[2]/*)!='CcCapability':
   The attribute-id is 2593 therefore the first child of attribute-value must be CcCapability NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2594 and name(*[2]/*)!='CC-Oid'">In pattern attribute-id=2594 and name(*[2]/*)!='CC-Oid':
   The attribute-id is 2594 therefore the first child of attribute-value must be CC-Oid NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2595 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2595 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2595 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2596 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2596 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2596 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2597 and name(*[2]/*)!='CcExtMgmtProto'">In pattern attribute-id=2597 and name(*[2]/*)!='CcExtMgmtProto':
   The attribute-id is 2597 therefore the first child of attribute-value must be CcExtMgmtProto NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2600 and name(*[2]/*)!='Locale'">In pattern attribute-id=2600 and name(*[2]/*)!='Locale':
   The attribute-id is 2600 therefore the first child of attribute-value must be Locale NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2601 and name(*[2]/*)!='PatMeasure'">In pattern attribute-id=2601 and name(*[2]/*)!='PatMeasure':
   The attribute-id is 2601 therefore the first child of attribute-value must be PatMeasure NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2602 and name(*[2]/*)!='OperTextStrings'">In pattern attribute-id=2602 and name(*[2]/*)!='OperTextStrings':
   The attribute-id is 2602 therefore the first child of attribute-value must be OperTextStrings NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2603 and name(*[2]/*)!='MarkerListSaVal8'">In pattern attribute-id=2603 and name(*[2]/*)!='MarkerListSaVal8':
   The attribute-id is 2603 therefore the first child of attribute-value must be MarkerListSaVal8 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2604 and name(*[2]/*)!='MarkerListSaVal32'">In pattern attribute-id=2604 and name(*[2]/*)!='MarkerListSaVal32':
   The attribute-id is 2604 therefore the first child of attribute-value must be MarkerListSaVal32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2605 and name(*[2]/*)!='MarkerListIndex'">In pattern attribute-id=2605 and name(*[2]/*)!='MarkerListIndex':
   The attribute-id is 2605 therefore the first child of attribute-value must be MarkerListIndex NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2606 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2606 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2606 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2607 and name(*[2]/*)!='TimeSupport'">In pattern attribute-id=2607 and name(*[2]/*)!='TimeSupport':
   The attribute-id is 2607 therefore the first child of attribute-value must be TimeSupport NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2608 and name(*[2]/*)!='DateTimeStatus'">In pattern attribute-id=2608 and name(*[2]/*)!='DateTimeStatus':
   The attribute-id is 2608 therefore the first child of attribute-value must be DateTimeStatus NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2609 and name(*[2]/*)!='AbsoluteTimeISO'">In pattern attribute-id=2609 and name(*[2]/*)!='AbsoluteTimeISO':
   The attribute-id is 2609 therefore the first child of attribute-value must be AbsoluteTimeISO NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2610 and name(*[2]/*)!='ExtTimeStampList'">In pattern attribute-id=2610 and name(*[2]/*)!='ExtTimeStampList':
   The attribute-id is 2610 therefore the first child of attribute-value must be ExtTimeStampList NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2611 and name(*[2]/*)!='AbsoluteRelativeTimeSync'">In pattern attribute-id=2611 and name(*[2]/*)!='AbsoluteRelativeTimeSync':
   The attribute-id is 2611 therefore the first child of attribute-value must be AbsoluteRelativeTimeSync NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2612 and name(*[2]/*)!='UTCTimeZone'">In pattern attribute-id=2612 and name(*[2]/*)!='UTCTimeZone':
   The attribute-id is 2612 therefore the first child of attribute-value must be UTCTimeZone NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2613 and name(*[2]/*)!='DaylightSavingsTransition'">In pattern attribute-id=2613 and name(*[2]/*)!='DaylightSavingsTransition':
   The attribute-id is 2613 therefore the first child of attribute-value must be DaylightSavingsTransition NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2614 and name(*[2]/*)!='INT-U32'">In pattern attribute-id=2614 and name(*[2]/*)!='INT-U32':
   The attribute-id is 2614 therefore the first child of attribute-value must be INT-U32 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2615 and name(*[2]/*)!='LeapSecondsTransition'">In pattern attribute-id=2615 and name(*[2]/*)!='LeapSecondsTransition':
   The attribute-id is 2615 therefore the first child of attribute-value must be LeapSecondsTransition NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2616 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2616 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2616 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2617 and name(*[2]/*)!='RelativeTime'">In pattern attribute-id=2617 and name(*[2]/*)!='RelativeTime':
   The attribute-id is 2617 therefore the first child of attribute-value must be RelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2618 and name(*[2]/*)!='HighResRelativeTime'">In pattern attribute-id=2618 and name(*[2]/*)!='HighResRelativeTime':
   The attribute-id is 2618 therefore the first child of attribute-value must be HighResRelativeTime NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2619 and name(*[2]/*)!='CmplxMetricInfo'">In pattern attribute-id=2619 and name(*[2]/*)!='CmplxMetricInfo':
   The attribute-id is 2619 therefore the first child of attribute-value must be CmplxMetricInfo NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2620 and name(*[2]/*)!='CmplxObsValue'">In pattern attribute-id=2620 and name(*[2]/*)!='CmplxObsValue':
   The attribute-id is 2620 therefore the first child of attribute-value must be CmplxObsValue NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2621 and name(*[2]/*)!='CmplxDynAttr'">In pattern attribute-id=2621 and name(*[2]/*)!='CmplxDynAttr':
   The attribute-id is 2621 therefore the first child of attribute-value must be CmplxDynAttr NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2622 and name(*[2]/*)!='CmplxStaticAttr'">In pattern attribute-id=2622 and name(*[2]/*)!='CmplxStaticAttr':
   The attribute-id is 2622 therefore the first child of attribute-value must be CmplxStaticAttr NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2623 and name(*[2]/*)!='INT-U16'">In pattern attribute-id=2623 and name(*[2]/*)!='INT-U16':
   The attribute-id is 2623 therefore the first child of attribute-value must be INT-U16 NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2624 and name(*[2]/*)!='CurrentRange'">In pattern attribute-id=2624 and name(*[2]/*)!='CurrentRange':
   The attribute-id is 2624 therefore the first child of attribute-value must be CurrentRange NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2625 and name(*[2]/*)!='RangeOpText'">In pattern attribute-id=2625 and name(*[2]/*)!='RangeOpText':
   The attribute-id is 2625 therefore the first child of attribute-value must be RangeOpText NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2626 and name(*[2]/*)!='OCTET_STRING'">In pattern attribute-id=2626 and name(*[2]/*)!='OCTET_STRING':
   The attribute-id is 2626 therefore the first child of attribute-value must be OCTET_STRING NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=2627 and name(*[2]/*)!='EnumMsmtRangeLabels'">In pattern attribute-id=2627 and name(*[2]/*)!='EnumMsmtRangeLabels':
   The attribute-id is 2627 therefore the first child of attribute-value must be EnumMsmtRangeLabels NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:if test="attribute-id=9999 and name(*[2]/*)!='NomPartition'">In pattern attribute-id=9999 and name(*[2]/*)!='NomPartition':
   The attribute-id is 9999 therefore the first child of attribute-value must be NomPartition NOT<xsl:text xml:space="preserve"/><xsl:value-of select="name(*[2]/*)"/><xsl:text xml:space="preserve"/>
</xsl:if>
		<xsl:apply-templates mode="M53"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M53"/>
	<xsl:template match="MdsCreateInfo" priority="4000" mode="M54">
		<xsl:choose>
			<xsl:when test="count(*)=2 and count(class-id)=1 and count(attribute-list)=1"/>
			<xsl:otherwise>In pattern count(*)=2 and count(class-id)=1 and count(attribute-list)=1:
   The Element MdsCreateInfo should have child elements class-id and attribute-list
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="*[1]=class-id"/>
			<xsl:otherwise>In pattern *[1]=class-id:
   The element class-id must appear before the Element attribute-list
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M54"/>
	</xsl:template>
	<xsl:template match="class-id" priority="3999" mode="M54">
		<xsl:choose>
			<xsl:when test="count(*)=2 and count(m-obj-class)=1 and count(m-obj-inst)=1"/>
			<xsl:otherwise>In pattern count(*)=2 and count(m-obj-class)=1 and count(m-obj-inst)=1:
   The Element class-id should have child elements m-obj-class and m-obj-inst
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="*[1]=m-obj-class"/>
			<xsl:otherwise>In pattern *[1]=m-obj-class:
   The element m-obj-class must appear before the Element m-obj-inst
</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="number(*[1]) &gt; -1 and number(*[1]) &lt; 65536"/>
			<xsl:otherwise>In pattern number(*[1]) &gt; -1 and number(*[1]) &lt; 65536:
   The value of Element m-obj-class must be between (0 and 65535)
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M54"/>
	</xsl:template>
	<xsl:template match="attribute-list" priority="3998" mode="M54">
		<xsl:choose>
			<xsl:when test="count(//AVA-Type) &gt; -1 and count(//AVA-Type) &lt; 999999999"/>
			<xsl:otherwise>In pattern count(//AVA-Type) &gt; -1 and count(//AVA-Type) &lt; 999999999:
   The Element AVA-Type should appear 0 or more times
</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="M54"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="M54"/>
	<xsl:template match="text()" priority="-1"/>
</xsl:stylesheet>