<?xml version="1.0"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dim="http://www.nist.gov/x73DIM">
<xsl:output method="xml" encoding="UTF-8" omit-xml-declaration="no" />
<xsl:template match = "/">
<xsl:element name="schema"><xsl:text> 
 	 </xsl:text>
 <xsl:element name="ns">
<xsl:attribute name="uri">http://www.nist.gov/x73DIM</xsl:attribute> 
<xsl:attribute name="prefix">dim</xsl:attribute> 
 </xsl:element>
 <xsl:text>
 </xsl:text>

<xsl:element name="pattern">
<xsl:attribute name="name">Authorized objects</xsl:attribute>
<xsl:text>
 </xsl:text>
 <xsl:element name="rule">
	 <xsl:attribute name="context">//dim:OBJECT_NAME</xsl:attribute>
	  <xsl:text>
 </xsl:text>
  <xsl:element name="assert">
	  <xsl:attribute name="test">
 <xsl:for-each select="//dim:OBJECT_NAME">
	 <xsl:if test="position() != 1">or</xsl:if>
	 <xsl:text>(.='</xsl:text><xsl:value-of select="."/><xsl:text>' and @Label='</xsl:text><xsl:value-of select="@Label"/><xsl:text>')</xsl:text>
 </xsl:for-each>
 </xsl:attribute>
 "<xsl:element name="value-of"><xsl:attribute name="select">.</xsl:attribute></xsl:element>:<xsl:element name="value-of"><xsl:attribute name="select">@Label</xsl:attribute></xsl:element>" object is not allowed</xsl:element>
  </xsl:element>
  </xsl:element> 
   <xsl:text>
 </xsl:text>
 
 <xsl:for-each select="//*[dim:Attribute_Info]">
	  <xsl:element name="pattern">
 	 <xsl:attribute name="name"><xsl:value-of select="name()"/> node</xsl:attribute><xsl:text> 
 	 </xsl:text>
 	  <xsl:element name="rule">
 	  <xsl:attribute name="context">//dim:<xsl:value-of select="name()"/>[dim:OBJECT_NAME/@Label='<xsl:value-of select="dim:OBJECT_NAME/@Label"/>']/dim:Attribute_Info</xsl:attribute><xsl:text> 
 	 </xsl:text>
 	  	  <xsl:call-template name="AttrAndQuals" /> 
 	  </xsl:element>
 <xsl:text> 
 	 </xsl:text>	
 </xsl:element>
  </xsl:for-each>
  </xsl:element>
</xsl:template>


<xsl:template name="AttrAndQuals">
    <xsl:for-each select="dim:Attribute_Info/*/dim:ATTRIBUTE_NAME"> 
   <xsl:if test="../dim:Qual = 'M'"> 
    <xsl:element name="assert">
    <xsl:attribute name="test">dim:<xsl:value-of select="."/></xsl:attribute> "<xsl:value-of select="."/>" must appear at least one as part of  the "<xsl:value-of select ="../../../dim:OBJECT_NAME"/>:<xsl:value-of select ="../../../dim:OBJECT_NAME/@Label"/>" object </xsl:element><xsl:text>
 	 </xsl:text>
 	 <xsl:element name="assert">
    <xsl:attribute name="test">dim:<xsl:value-of select="."/>/dim:Qual = 'M'</xsl:attribute> "<xsl:value-of select="."/>" qual must be M" </xsl:element><xsl:text>
 	 </xsl:text>
    </xsl:if> 
     <xsl:if test="following-sibling::dim:Qual = 'X'"> 
    <xsl:element name="assert">
    <xsl:attribute name="test">not(child::dimm:<xsl:value-of select="."/>)</xsl:attribute> "<xsl:value-of select="."/>" is not supported by "<xsl:value-of select ="../../../dim:OBJECT_NAME"/>:<xsl:value-of select ="../../../dim:OBJECT_NAME/@Label"/>" object</xsl:element><xsl:text>
    </xsl:text>
    </xsl:if>   
</xsl:for-each> 
 </xsl:template>		
</xsl:stylesheet>



 