<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dim="http://www.nist.gov/x73DIM">

	<xsl:output method="xml" indent="yes"/>	
	<xsl:template match="/">
	   		<MocBehavICS>
     				<xsl:for-each select="//dim:OBJECT_NAME">
     				<xsl:sort select="../dim:OBJECT_NAME"/> 
					<xsl:call-template name="row">
						<xsl:with-param name="obj" select="position()"></xsl:with-param>
					</xsl:call-template>
     				 </xsl:for-each>
   			</MocBehavICS>
	</xsl:template>
	<xsl:template name="row">
		<xsl:param name="obj"></xsl:param>
		<xsl:for-each select="../*/*[dim:METHOD_NAME] | ../*/*/dim:Behaviour">
		<xsl:sort select="dim:METHOD_NAME"/> 		
		<Row>
				<Index>ACT-<xsl:value-of select="$obj"/>-<xsl:value-of select="position()"/></Index>
			       		<Feature>
<!--                        <xsl:value-of select="dim:METHOD_NAME"/>-->
		       			<xsl:value-of select="dim:METHOD_ID"/>
                        </Feature>
			      		<Reference><xsl:value-of select="substring-after(dim:Reference, 'clause')"/></Reference>
			      		<Status><xsl:value-of select="dim:Qual"/></Status>
			      		<Support>
				      		<xsl:if test="dim:BEHAVIOUR_Restrictions!=''">
					     		Restrictions: <xsl:value-of select="dim:BEHAVIOUR_Restrictions"/>
				     		</xsl:if>
      					</Support>
			      		<Comment><xsl:value-of select="dim:BEHAVIOUR_COMMENT"/></Comment>
	      			</Row>
		</xsl:for-each>							
	</xsl:template>

</xsl:stylesheet>


