<?xml version="1.0" encoding="UTF-8"?>
<?altova_samplexml C:\ICS\xml\ICS-Tool.xml?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dim="http://www.nist.gov/x73DIM">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/">
		<MocAttrICS>
			<xsl:for-each select="//dim:OBJECT_NAME">
				<xsl:sort select="../dim:OBJECT_NAME"/> 
				<xsl:comment>call row template developed further</xsl:comment>
				<xsl:call-template name="row">
					<xsl:with-param name="pos" select="position()"/>
				</xsl:call-template>
			</xsl:for-each>
		</MocAttrICS>
	</xsl:template>
	<xsl:template name="row">
		<xsl:param name="pos"/>
		<xsl:for-each select="../*/*[dim:ATTRIBUTE_NAME] | ../*/*/dim:Attributes">
		<xsl:sort select="dim:ATTRIBUTE_NAME"/> 
			<Row>
				<Index>ATTR-<xsl:value-of select="$pos"/>-<xsl:value-of select="position()"/></Index>
				<Feature>
<!--                <xsl:value-of select="dim:ATTRIBUTE_NAME"/>    -->
				<xsl:value-of select="dim:ATTRIBUTE_ID"/>
                </Feature>
				<Reference><xsl:value-of select="substring-after(dim:Reference, 'clause')"/></Reference>
					<Status><xsl:value-of select="dim:Qual"/></Status>
					<Support>
					<xsl:if test="dim:ATTRIBUTE_ACCESS!=''">
						Access: <xsl:value-of select="dim:ATTRIBUTE_ACCESS"/>
					</xsl:if>
						<xsl:value-of select="dim:ATTRIBUTE_STATIC_DYN"/>
					<xsl:if test="dim:ATTRIBUTE_VALUE_RANGE!=''">
						Value Ranges:<xsl:value-of select="dim:ATTRIBUTE_VALUE_RANGE"/>
					</xsl:if>
					<xsl:if test="dim:ATTRIBUTE_Restrictions!=''">
					Restrictions: <xsl:value-of select="dim:ATTRIBUTE_Restrictions"/>
					</xsl:if>
					</Support>
					<Comment><xsl:value-of select="dim:ATTRIBUTE_COMMENT"/></Comment>
					</Row>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
