/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.sync;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import gov.nist.healthcare.dev.profile.control.dao.AllRestModule;
import gov.nist.healthcare.dev.profile.dao.NomnDao;
import gov.nist.healthcare.deviceProfile.domain.rtmms.nomenclature.Coded_term;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class NomnDBSync {
    private static final Logger log = Logger.getLogger(NomnDBSync.class.getName());
    protected EntityManager em;
    protected NomnDao nomenclatureDao;

    public NomnDBSync(String pu) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)pu);
        this.em = emf.createEntityManager();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AllRestModule()});
        this.nomenclatureDao = (NomnDao)injector.getInstance(NomnDao.class);
    }

    public void syncRemoteEJBtoLocalJPA() {
        try {
            InitialContext ctx = new InitialContext();
            NomnDao dao = (NomnDao)ctx.lookup(NomnDao.class.getName());
            List coded_terms = dao.getAll();
            List terms = this.nomenclatureDao.getAll();
            this.em.getTransaction().begin();
            for (Coded_term t : terms) {
                this.em.remove((Object)t);
            }
            this.em.flush();
            int i = 0;
            for (Coded_term codedTerm : coded_terms) {
                System.out.println(++i + ":  " + codedTerm);
                codedTerm.setId(null);
                codedTerm.setTerm_description("");
                codedTerm.setSystematic_name("");
                codedTerm.setCommon_term("");
                codedTerm.setAcronym("");
                this.em.persist((Object)codedTerm);
            }
            this.em.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rest_sync() {
        List terms = this.nomenclatureDao.getAll();
        int i = 0;
        this.em.getTransaction().begin();
        for (Coded_term codedTerm : terms) {
            System.out.println(++i + ":  " + codedTerm);
            this.em.persist((Object)codedTerm);
        }
        this.em.getTransaction().commit();
    }
}

