/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import gov.nist.healthcare.dev.profile.common.ICSException;
import gov.nist.healthcare.dev.profile.control.file.utils.PDFUtils;
import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import java.util.List;

public class RCHFile
extends PDFUtils {
    private DeviceProfile profile;

    public void init(Document document, DeviceProfile profile) throws DocumentException, ICSException {
        this.profile = profile;
        PdfPTable table = this.getTable("REFID", "OBX-4", "Comments");
        table.setWidths(new float[]{6.0f, 1.0f, 5.0f});
        this.build(table);
        document.add((Element)table);
    }

    private void build(PdfPTable table) throws ICSException {
        List objList = this.profile.getObjects();
        DeviceObject root = MDOUtils.GetRoot((List)objList);
        this.build(table, "", root, objList);
    }

    private void build(PdfPTable table, String dot, DeviceObject obj, List<DeviceObject> objList) {
        for (DeviceObject child : MDOUtils.GetChildren(objList, (DeviceObject)obj)) {
            String refid = child.getRefid();
            if (refid == null || refid.equals("")) {
                refid = child.getDimRefid();
            }
            this.addTableCell(table, "   " + dot + "     " + refid);
            PdfPCell obx4Cell = this.addTableCell(table, child.getObx4());
            obx4Cell.setHorizontalAlignment(1);
            this.addTableCell(table, child.getDescription());
            this.build(table, dot + ".  ", child, objList);
        }
    }
}

