/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.utils;

import gov.nist.healthcare.dev.profile.control.config.FileNameConfig;
import gov.nist.healthcare.dev.profile.control.core.RCHController;
import gov.nist.healthcare.dev.profile.control.file.utils.NoCloseInputStream;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.V1SimplifiedXmlGenerator;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.V1XmlGenerator;
import gov.nist.healthcare.deviceProfile.domain.common.JaxbUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.rch.RCHModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;

public class ProjectZipFileIO {
    private static final Logger log = Logger.getLogger(ProjectZipFileIO.class.getName());
    private final String[] profileFileName = new String[]{"md_project.xml", "ICSGenerator_Medical_Device_Profile.xml", "ICSGenerator_Main_Profile.xml"};

    public void dumpProfile(DeviceProfile profile) {
        log.info(profile.getResume().toString());
    }

    public String generateProjectXml(DeviceProfile profile) {
        String ret = FileNameConfig.TMPDIR + "md_project.xml";
        try {
            JaxbUtils.marshallDocument((DeviceProfile)profile, (String)ret);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String generateRCHXml(DeviceProfile profile) {
        String ret = FileNameConfig.TMPDIR + "Device_RCH.xml";
        try {
            JaxbUtils.marshallDocument(RCHModel.class, (Object)RCHController.build(profile.getObjects()), (String)ret);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String generateSimplifierXml(DeviceProfile profile, String path) {
        String ret = "simple_profile.xml";
        try {
            V1SimplifiedXmlGenerator v1XmlGenerator = new V1SimplifiedXmlGenerator();
            v1XmlGenerator.generateXML(profile.getObjects());
            v1XmlGenerator.saveToFile(path + ret);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String generateX73DPv1Xml(DeviceProfile profile) {
        String ret = FileNameConfig.TMPDIR + "X73_Device_Profile.xml";
        try {
            V1XmlGenerator v1XmlGenerator = new V1XmlGenerator();
            v1XmlGenerator.generateXML(profile.getObjects());
            v1XmlGenerator.saveToFile(ret);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public DeviceProfile getProfileFromZip(InputStream is) {
        ZipInputStream zipIn = new ZipInputStream(is);
        DeviceProfile profile = null;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (!this.isProfileFile(zipEntry.getName())) continue;
                profile = this.unMarshalDeviceProfile(zipIn);
            }
            zipIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return profile;
    }

    public DeviceProfile getProfileFromZipFile(String path) {
        File file = new File(path);
        DeviceProfile profile = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            profile = this.getProfileFromZip(bis);
            bis.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return profile;
    }

    public boolean isProfileFile(String filename) {
        for (String name : this.profileFileName) {
            if (!name.endsWith(filename)) continue;
            return true;
        }
        return false;
    }

    public DeviceProfile unMarshalDeviceProfile(InputStream is) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DeviceProfile.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        DeviceProfile profile = (DeviceProfile)unmarshaller.unmarshal((InputStream)new NoCloseInputStream(is));
        return profile;
    }
}

