/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import gov.nist.healthcare.dev.profile.common.ICSException;
import gov.nist.healthcare.dev.profile.control.file.utils.PDFUtils;
import gov.nist.healthcare.deviceProfile.domain.common.MDOUtils;
import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceEnumGroup;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnit;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnitGroup;
import java.io.OutputStream;
import java.util.List;

public class DeviceProfilePDF
extends PDFUtils {
    public void build(Document document, List<DeviceObject> objList) throws DocumentException, ICSException {
        DeviceObject root = MDOUtils.GetRoot(objList);
        this.containment_tree(document, root, objList);
        this.build(document, root, objList);
    }

    public void createPDF(OutputStream os, DeviceProfile profile) {
        try {
            Document document = new Document();
            PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            this.addmetadata(document);
            Paragraph preface = new Paragraph();
            DeviceProfilePDF.addEmptyLine(preface, 1);
            preface.add((Element)new Paragraph("Device: " + profile.getResume().getTitle(), Font18Bold));
            DeviceProfilePDF.addEmptyLine(preface, 1);
            document.add((Element)preface);
            List objList = profile.getObjects();
            this.build(document, objList);
            document.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (ICSException e) {
            e.printStackTrace();
        }
    }

    private void build(Document document, DeviceObject obj, List<DeviceObject> objList) {
        for (DeviceObject child : MDOUtils.GetChildren(objList, (DeviceObject)obj)) {
            if (child.getDimRefid().equals("MDC_MOC_VMO_CHAN")) {
                try {
                    this.channel(document, child, MDOUtils.GetChildren(objList, (DeviceObject)child));
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
            }
            this.build(document, child, objList);
        }
    }

    private void channel(Document document, DeviceObject obj, List<DeviceObject> childList) throws DocumentException {
        String[] tableHeader;
        Paragraph preface = new Paragraph();
        DeviceProfilePDF.addEmptyLine(preface, 1);
        preface.add((Element)new Paragraph("Channel: " + obj.getName(), Font18Bold));
        DeviceProfilePDF.addEmptyLine(preface, 1);
        document.add((Element)preface);
        float[] colsWidth = new float[]{1.5f, 2.0f, 3.0f, 3.0f};
        PdfPTable table = new PdfPTable(colsWidth);
        table.setWidthPercentage(95.0f);
        for (String header : tableHeader = new String[]{"Name", "Reference ID", "Units", "Enumerations"}) {
            PdfPCell cell = new PdfPCell(new Phrase(header, Font12Bold));
            cell.setHorizontalAlignment(1);
            table.addCell(cell);
        }
        table.setHeaderRows(1);
        for (DeviceObject child : childList) {
            String label = child.getName();
            if (label == null || label.equals("")) {
                label = new String("   ");
            }
            PdfPCell label_cell = new PdfPCell(new Phrase(label, FONT6));
            table.addCell(label_cell);
            label = child.getRefid();
            if (label == null || label.equals("")) {
                label = new String("   ");
            }
            label = label + " (" + child.getCode10() + ")";
            label_cell = new PdfPCell(new Phrase(label, FONT6));
            table.addCell(label_cell);
            List units = null;
            List unitGrps = child.getUnitGroups();
            if (unitGrps.size() > 0) {
                units = ((DeviceUnitGroup)unitGrps.get(0)).getUnits();
            }
            if (units != null) {
                StringBuffer buf = new StringBuffer("");
                for (DeviceUnit unitobj : units) {
                    String unit = unitobj.getUOMMDC();
                    if (unit == null) {
                        System.out.println("null");
                    } else {
                        System.out.println(label + "->" + unitobj.toDump() + " (" + TermcodeUtils.CFCodeToBlockTermCode((String)unitobj.getCFUCODE10()) + ")" + "\n");
                    }
                    if (unit.equals("")) continue;
                    buf.append(unit + " (" + TermcodeUtils.CFCodeToBlockTermCode((String)unitobj.getCFUCODE10()) + ")" + "\n");
                }
                label_cell = new PdfPCell(new Phrase(buf.toString(), FONT6));
                table.addCell(label_cell);
            } else {
                table.addCell("");
            }
            List enums = null;
            List enumGrps = child.getEnumGroups();
            if (enumGrps.size() > 0) {
                enums = ((DeviceEnumGroup)enumGrps.get(0)).getEnumValues();
            }
            if (enums != null) {
                StringBuffer buf = new StringBuffer();
                for (String enumTxt : enums) {
                    if (enumTxt.equals("")) continue;
                    buf.append(enumTxt + "\n");
                }
                label_cell = new PdfPCell(new Phrase(buf.toString(), FONT6));
                table.addCell(label_cell);
                continue;
            }
            label_cell = new PdfPCell(new Phrase("   ", FONT6));
            table.addCell(label_cell);
        }
        document.add((Element)table);
    }

    private void containment_tree(Document document, DeviceObject obj, List<DeviceObject> objList) throws DocumentException {
        Paragraph preface = new Paragraph();
        DeviceProfilePDF.addEmptyLine(preface, 1);
        preface.add((Element)new Paragraph("Containment Tree", Font18Bold));
        DeviceProfilePDF.addEmptyLine(preface, 1);
        document.add((Element)preface);
        float[] colsWidth = new float[]{0.7f, 0.7f, 1.5f, 3.0f};
        PdfPTable table = new PdfPTable(colsWidth);
        table.setWidthPercentage(95.0f);
        for (DeviceObject mds : MDOUtils.GetChildrenByDimRefid((String)"MDC_MOC_VMS_MDS_", (DeviceObject)obj, objList)) {
            PdfPCell mds_cell = new PdfPCell(new Phrase(mds.toString(), FONT6));
            mds_cell.setColspan(3);
            table.addCell(mds_cell);
            PdfPCell mds_ref = new PdfPCell(new Phrase(mds.getRefid() + " (" + mds.getCode10() + ")", FONT6));
            table.addCell(mds_ref);
            for (DeviceObject vmd : MDOUtils.GetChildrenByDimRefid((String)"MDC_MOC_VMO_VMD", (DeviceObject)mds, objList)) {
                table.addCell("   ");
                PdfPCell vmd_cell = new PdfPCell(new Phrase(vmd.toString(), FONT6));
                vmd_cell.setColspan(2);
                table.addCell(vmd_cell);
                PdfPCell vmd_ref = new PdfPCell(new Phrase(vmd.getRefid() + " (" + vmd.getCode10() + ")", FONT6));
                table.addCell(vmd_ref);
                for (DeviceObject chl : MDOUtils.GetChildrenByDimRefid((String)"MDC_MOC_VMO_CHAN", (DeviceObject)vmd, objList)) {
                    PdfPCell table_cell = new PdfPCell();
                    table_cell.setColspan(2);
                    table.addCell(table_cell);
                    PdfPCell ch_cell = new PdfPCell(new Phrase(chl.toString(), FONT6));
                    table.addCell(ch_cell);
                    PdfPCell chl_ref = new PdfPCell(new Phrase(chl.getRefid() + " (" + chl.getCode10() + ")", FONT6));
                    table.addCell(chl_ref);
                }
            }
        }
        document.add((Element)table);
    }
}

