/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file;

import gov.nist.healthcare.dev.profile.common.ResourceManager;
import gov.nist.healthcare.dev.profile.common.ZipFile;
import gov.nist.healthcare.dev.profile.control.config.FileNameConfig;
import gov.nist.healthcare.dev.profile.control.file.ProfileController;
import gov.nist.healthcare.dev.profile.control.file.ProfileReportFile;
import gov.nist.healthcare.dev.profile.control.file.utils.DeviceProfilePDF;
import gov.nist.healthcare.dev.profile.control.file.utils.ProjectZipFileIO;
import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.ProfileResume;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ProjectFileController {
    private static final Logger log = Logger.getLogger(ProjectFileController.class.getName());
    protected String _ICSSchemaPath = "";
    protected String _ICSXmlPath = "";
    protected String _profileName = "md_project.xml";
    protected String _projectName = "unamedProject.icszip";
    private ProjectZipFileIO iou = new ProjectZipFileIO();
    private ProfileController profileController = new ProfileController();

    public static ProjectFileController NewProfile() {
        DeviceProfile _profile = ProfileController.newProfile();
        return new ProjectFileController(_profile);
    }

    public ProjectFileController(InputStream is) {
        this.profileController.setProfile(is);
    }

    public ProjectFileController(DeviceProfile profile) {
        this.profileController.setProfile(profile);
    }

    public ProjectFileController(String filename) {
        DeviceProfile profile;
        if (new File(filename).exists() && filename.endsWith(".icszip") && (profile = this.iou.getProfileFromZipFile(filename)) != null) {
            this.profileController.setProfile(profile);
            this.setProjectPath(filename);
        }
    }

    public void config() {
        ResourceManager rssController = ResourceManager.newInstance((String)"resources/common/files-conf");
        ProfileResume devInfo = this.getProfile().getResume();
        if (devInfo.getDeviceType().equalsIgnoreCase("PCD")) {
            if (devInfo.getProfileType().equalsIgnoreCase("Agent")) {
                if (devInfo.getProfileMode().equalsIgnoreCase("Baseline")) {
                    this.setICSXmlPath(rssController.getBundleTxt("XML_DIM_TOOL"));
                    this.setICSSchemaPath(rssController.getBundleTxt("XSD_DIM"));
                } else if (devInfo.getProfileMode().equalsIgnoreCase("Polling")) {
                    this.setICSXmlPath(rssController.getBundleTxt("XML_DIM_TOOL_POLLING_MODE"));
                    this.setICSSchemaPath(rssController.getBundleTxt("XSD_POLLING_MODE"));
                }
            } else if (devInfo.getProfileType().equalsIgnoreCase("Manager")) {
                if (devInfo.getProfileMode().equalsIgnoreCase("Baseline")) {
                    this.setICSXmlPath(rssController.getBundleTxt("XML_DIM_TOOL_MANAGER_BASELINE"));
                    this.setICSSchemaPath(rssController.getBundleTxt("XSD_MANAGER_BASELINE"));
                } else if (devInfo.getProfileMode().equalsIgnoreCase("Polling")) {
                    this.setICSXmlPath(rssController.getBundleTxt("XML_DIM_TOOL_POLLING_MODE"));
                    this.setICSSchemaPath(rssController.getBundleTxt("XSD_POLLING_MODE"));
                }
            }
        } else if (devInfo.getDeviceType().equalsIgnoreCase("PHD")) {
            if (devInfo.getProfileType().equalsIgnoreCase("Agent")) {
                this.setICSXmlPath(rssController.getBundleTxt("XML_PHD_AGENT"));
                this.setICSSchemaPath(rssController.getBundleTxt("XSD_PHD_AGENT"));
            }
            if (devInfo.getProfileType().equalsIgnoreCase("Manager")) {
                this.setICSXmlPath(rssController.getBundleTxt("XML_PHD_MANGER"));
                this.setICSSchemaPath(rssController.getBundleTxt("XSD_PHD_MANAGER"));
            }
        }
    }

    public String getICSSchemaPath() {
        return this._ICSSchemaPath;
    }

    public String getICSXmlPath() {
        return this._ICSXmlPath;
    }

    public DeviceProfile getProfile() {
        return this.profileController.getProfile();
    }

    public ProfileController getProfileController() {
        return this.profileController;
    }

    public String getProfileName() {
        return this._profileName;
    }

    public String getProjectPath() {
        return this._projectName;
    }

    public void persistProject() throws Exception {
        String tmpDir = FileNameConfig.TMPDIR;
        TermcodeUtils.DoDelete((File)new File(tmpDir));
        new File(tmpDir).mkdir();
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.add(new File(this.iou.generateProjectXml(this.getProfile())));
        fileList.add(new File(this.iou.generateX73DPv1Xml(this.getProfile())));
        fileList.add(new File(this.iou.generateRCHXml(this.getProfile())));
        ProfileReportFile pdfFile = new ProfileReportFile();
        fileList.add(new File(pdfFile.generateOutput(this.getProfile(), tmpDir)));
        ZipFile.updateZip((String)this._projectName, fileList);
        TermcodeUtils.DoDelete((File)new File(tmpDir));
    }

    public void setICSSchemaPath(String schemaPath) {
        this._ICSSchemaPath = schemaPath;
    }

    public void setICSXmlPath(String xmlPath) {
        this._ICSXmlPath = xmlPath;
    }

    public void setProfileName(String profileName) {
        this._profileName = profileName;
    }

    public void setProjectPath(String projectPath) {
        this._projectName = projectPath;
    }

    public void toMDProfile(String filename) {
        this.profileController.toXml(filename);
    }

    public void toPDF(OutputStream os) {
        DeviceProfilePDF profilePDF = new DeviceProfilePDF();
        profilePDF.createPDF(os, this.getProfile());
    }

    public void toPDF(String filename) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(filename);
        this.toPDF(os);
    }
}

