/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd;

import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.V1ObjectParser;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73DimObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class V1TreeBuilder
extends V1ObjectParser {
    protected Document icsXmlDocument;
    protected DefaultMutableTreeNode icsXmlTreeNode;
    protected Vector<X73DimObject> x73DimObjectVector;

    public void buildStructure(InputStream icsXmlInputStream) throws ParserConfigurationException, SAXException, IOException {
        this.icsXmlDocument = this.parseXmlToDOM(icsXmlInputStream);
        this.x73DimObjectVector = new Vector();
        this.icsXmlTreeNode = this.processTreeNodeAlgo2(this.icsXmlDocument.getDocumentElement(), this.x73DimObjectVector);
    }

    public Vector<X73DimObject> getDimObjectVector() {
        return this.x73DimObjectVector;
    }

    public Document getIcsXmlDocument() {
        return this.icsXmlDocument;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.icsXmlTreeNode;
    }

    private Document parseXmlToDOM(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder parser = domFactory.newDocumentBuilder();
        Document document = parser.parse(inputStream);
        return document;
    }

    private DefaultMutableTreeNode process(X73DimObject newMoc, Node inNode, DefaultMutableTreeNode parentTreeNode, Vector<X73DimObject> vector) {
        X73DimObject currentMoc;
        if (inNode != null && inNode.getNodeType() == 1 && (currentMoc = this.processNode(newMoc, inNode)) != null) {
            vector.add(currentMoc);
            DefaultMutableTreeNode current = new DefaultMutableTreeNode(currentMoc);
            if (parentTreeNode == null) {
                parentTreeNode = current;
            } else {
                parentTreeNode.add(current);
            }
            if (inNode.hasChildNodes()) {
                NodeList children = inNode.getChildNodes();
                for (int index = 0; index < children.getLength(); ++index) {
                    Node childNode = children.item(index);
                    if (childNode.getNodeType() != 1) continue;
                    this.process(currentMoc, childNode, current, vector);
                }
            }
            return parentTreeNode;
        }
        return null;
    }

    private DefaultMutableTreeNode processTreeNodeAlgo2(Node inNode, Vector<X73DimObject> vector) {
        DefaultMutableTreeNode root = null;
        X73DimObject newMoc = new X73DimObject();
        return this.process(newMoc, inNode, root, vector);
    }
}

