/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimBehavior;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimNotification;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class V1SimplifiedXmlGenerator {
    public static final String NAMESPACE = "http://www.nist.gov/x73DIM";
    public Document dom;

    public String domToString(Document doc) {
        String str = "";
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer1 = tFactory.newTransformer();
            transformer1.setOutputProperty("method", "xml");
            transformer1.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer1.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result2 = new StreamResult(stream);
            transformer1.transform(source, result2);
            str = stream.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public Document generateXML(List<DeviceObject> dimObjectList) throws ParserConfigurationException {
        this.dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DeviceObject icsGeneRoot = this.getRoot(dimObjectList);
        DimObject dimObjRoot = icsGeneRoot.getDimObject();
        if (dimObjRoot == null) {
            return this.dom;
        }
        Element root = this.dom.createElement(dimObjRoot.getName());
        this.dom.appendChild(root);
        for (DeviceObject childObj : this.getDimObjectChildren(icsGeneRoot, dimObjectList)) {
            root.appendChild(this.getDIMObjElement(childObj, dimObjectList));
        }
        return this.dom;
    }

    public void saveToFile(String outputFile) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.dom);
            transformer.transform(source, result);
            FileWriter outputWriter = new FileWriter(outputFile);
            outputWriter.write(writer.toString());
            outputWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Element createElement(String elemName) throws DOMException {
        try {
            return this.dom.createElement(elemName);
        }
        catch (DOMException e) {
            throw new DOMException(e.code, e.getMessage() + "\n Element Name : <" + elemName + ">");
        }
    }

    protected Element createTextNodeElement(String elemName, String elemTxt) {
        Element retElem = this.createElement(elemName);
        if (elemTxt == null) {
            elemTxt = "";
        }
        retElem.appendChild(this.dom.createTextNode(elemTxt));
        return retElem;
    }

    protected Element dimAttributeElement(DimObject obj) {
        Element elem = this.createElement("Attribute_Info");
        for (DimAttribute itrObj : obj.getDimAttributes()) {
            try {
                Element xmlAttribute = this.createElement(itrObj.getRefid());
                elem.appendChild(xmlAttribute);
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
        return elem;
    }

    protected Element dimBehaviorElement(DimObject obj) {
        Element elem = this.createElement("Behaviour_Info");
        for (DimBehavior itrObj : obj.getDimBehaviors()) {
            try {
                Element paramElement = this.createElement(itrObj.getRefid());
                elem.appendChild(paramElement);
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
        return elem;
    }

    protected Element dimNotificationElement(DimObject obj) {
        Element elem = this.createElement("Notification_Info");
        for (DimNotification itrObj : obj.getDimNotifications()) {
            try {
                Element paramElement = this.createElement(itrObj.getRefid());
                elem.appendChild(paramElement);
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
        return elem;
    }

    protected List<DeviceObject> getDimObjectChildren(DeviceObject obj, List<DeviceObject> dimObjectList) {
        ArrayList<DeviceObject> retList = new ArrayList<DeviceObject>();
        for (DeviceObject itr : dimObjectList) {
            if (!itr.getParentId().equals(obj.getId())) continue;
            retList.add(itr);
        }
        return retList;
    }

    protected Element getDIMObjElement(DeviceObject _obj, List<DeviceObject> dimObjectList) {
        System.out.println("V1SimplifiedXmlGenerator : " + _obj);
        DimObject obj = _obj.getDimObject();
        Element elem = _obj.getRefid() == null || _obj.getRefid().equals("") ? this.createElement("NO_REFID_FOUND") : this.createElement(_obj.getRefid());
        for (DeviceObject childObj : this.getDimObjectChildren(_obj, dimObjectList)) {
            elem.appendChild(this.getDIMObjElement(childObj, dimObjectList));
        }
        return elem;
    }

    protected DeviceObject getRoot(List<DeviceObject> dimObjectList) {
        for (DeviceObject itr : dimObjectList) {
            if (!itr.getId().equals(0)) continue;
            return itr;
        }
        return null;
    }
}

