/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.utils;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PDFUtils {
    protected static Font Font10 = new Font(Font.FontFamily.TIMES_ROMAN, 10.0f);
    protected static Font Font12Bold = new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 1);
    protected static Font Font18Bold = new Font(Font.FontFamily.TIMES_ROMAN, 18.0f, 1);
    protected static Font FONT6 = new Font(Font.FontFamily.COURIER, 6.0f);
    protected static Font iTextHeadingFont = new Font(Font.FontFamily.TIMES_ROMAN, 10.0f);
    protected static Font redFont = new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 0, BaseColor.RED);
    protected static Font subFont = new Font(Font.FontFamily.TIMES_ROMAN, 16.0f, 1);

    public static void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    public void addCover(Document document) throws DocumentException {
        document.add((Element)new Paragraph("Cover"));
        document.newPage();
    }

    public void addmetadata(Document document) {
        document.addTitle("Medical Device Profile - NIST/ICSGenerator");
        document.addSubject("");
        document.addKeywords("ICSGenerator, Medical Device Profile, ISO/IEEE 11073, NIST");
        document.addAuthor("");
        document.addCreator("");
    }

    public PdfPCell addTableCell(PdfPTable table, String txt) {
        PdfPCell cell = new PdfPCell(new Phrase(txt, FONT6));
        table.addCell(cell);
        return cell;
    }

    public Document createPdf(String filename) throws DocumentException, IOException {
        Document document = new Document(PageSize.A4, 36.0f, 36.0f, 54.0f, 54.0f);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
        HeaderFooter event = new HeaderFooter();
        writer.setBoxSize("art", new Rectangle(36.0f, 54.0f, 559.0f, 788.0f));
        writer.setPageEvent((PdfPageEvent)event);
        document.open();
        this.addmetadata(document);
        return document;
    }

    public PdfPTable getTable(String ... args) {
        PdfPTable table = new PdfPTable(args.length);
        table.setWidthPercentage(100.0f);
        for (String arg : args) {
            PdfPCell cell = new PdfPCell(new Phrase(arg));
            cell.setHorizontalAlignment(1);
            table.addCell(cell);
        }
        return table;
    }

    class HeaderFooter
    extends PdfPageEventHelper {
        Phrase[] header = new Phrase[2];
        int pagenumber;

        HeaderFooter() {
        }

        public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
            this.header[1] = new Phrase(title.getContent());
            this.pagenumber = 1;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            Rectangle rect = writer.getBoxSize("art");
            switch (writer.getPageNumber() % 2) {
                case 0: {
                    ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)2, (Phrase)this.header[0], (float)rect.getRight(), (float)rect.getTop(), (float)0.0f);
                    break;
                }
                case 1: {
                    ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)this.header[1], (float)rect.getLeft(), (float)rect.getTop(), (float)0.0f);
                }
            }
            ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)1, (Phrase)new Phrase(String.format("page %d", this.pagenumber)), (float)((rect.getLeft() + rect.getRight()) / 2.0f), (float)(rect.getBottom() - 18.0f), (float)0.0f);
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            this.header[0] = new Phrase("NIST MDC Document");
        }

        public void onStartPage(PdfWriter writer, Document document) {
            ++this.pagenumber;
        }
    }
}

