/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.app;

import gov.nist.healthcare.deviceProfile.domain.IMDObject;
import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class SetterHandler
implements InvocationHandler {
    protected Object delegate;

    public SetterHandler(Object delegate) {
        this.delegate = delegate;
    }

    public Object getFieldValue(Object obj, String fieldName) throws Throwable {
        Field field = TermcodeUtils.getField(obj.getClass(), (String)fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        DeviceObject obj;
        String methodName = method.getName();
        String fieldName = methodName.substring(3).toLowerCase();
        Object oldValue = null;
        Object newValue = null;
        if (methodName.startsWith("set")) {
            oldValue = this.getFieldValue(this.delegate, fieldName);
        }
        Object ret = method.invoke(this.delegate, args);
        if (methodName.startsWith("set")) {
            newValue = this.getFieldValue(this.delegate, fieldName);
            System.out.println("SetterHandler invoke " + methodName + " ,field name " + fieldName + " ,old value \"" + oldValue + "\" ,new value \"" + newValue + "\"");
            if (this.delegate instanceof IMDObject) {
                obj = (DeviceObject)this.delegate;
                obj.getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, newValue);
            }
        }
        if (methodName.startsWith("getProperty") && this.delegate instanceof IMDObject) {
            obj = (DeviceObject)this.delegate;
            int size = obj.getPropertyChangeSupport().getPropertyChangeListeners().length;
            System.out.println(methodName + "->PropertyChangeListeners " + size);
        }
        return ret;
    }
}

