/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view;

import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.ProfileResume;
import gov.nist.healthcare.mdc.applib.FileLocSelector;
import gov.nist.healthcare.mdc.applib.box.DefaultBox;
import gov.nist.healthcare.mdc.applib.box.panel.ICSBoxesOKCancelPanel;
import gov.nist.healthcare.mdc.applib.fileFilter.XMLFileFilter;
import gov.nist.healthcare.mdc.framework.Application;
import gov.nist.healthcare.mdc.framework.StandaloneResourceManager;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewProfileDialog {
    private JDialog dialog;
    private ImageIcon imageIcon;
    private final ProfileInformationPanel newProfilePanel = new ProfileInformationPanel(ICSAppControl.GetInstance().createProfile(), true);

    public NewProfileDialog(Component parent) {
        this.initComponents("New Device");
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
    }

    public Boolean modelEnabled() {
        return this.newProfilePanel.modelEnabled();
    }

    private void initComponents(String title) {
        JFrame frame = new JFrame(title);
        this.dialog = new JDialog((Frame)frame, true);
        this.imageIcon = StandaloneResourceManager.getInstance().getImageIcon("LOGO");
        frame.setIconImage(this.imageIcon.getImage());
        this.dialog.setTitle(title);
        this.dialog.setResizable(true);
        this.dialog.setLayout(new GridLayout());
        this.dialog.add(this.newProfilePanel);
        this.dialog.pack();
    }

    protected class ProfileInformationPanel
    extends ICSBoxesOKCancelPanel
    implements ItemListener {
        protected JComboBox modeBox;
        protected JComboBox typeBox;
        protected Boolean modelEnable = false;
        protected JRadioButton phdRadio;
        protected JRadioButton pcdRadio;
        protected ProfileResume profileResume;
        protected JTextField txtProjectName;
        private JButton browserBtn;
        private JTextField pathTF;
        private DeviceProfile profile;
        boolean nameOrDirectory;

        public ProfileInformationPanel(DeviceProfile projectModel, boolean nameOrDirectory) {
            this.profile = projectModel;
            this.profileResume = projectModel.getResume();
            this.nameOrDirectory = nameOrDirectory;
            this.setPreferredSize(new Dimension(470, 250));
            this.initComponent(nameOrDirectory);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            super.actionPerformed(e);
            if (e.getSource() == this.browserBtn && (file = FileLocSelector.showDialog(this, "projects/profiles/", ".xml", 0, new XMLFileFilter())) != null) {
                try {
                    this.pathTF.setText(file.getCanonicalPath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public ProfileResume getProjectModel() {
            return this.profileResume;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                if (evt.getSource() == this.phdRadio) {
                    this.setPCDRadioSelected(false);
                } else if (evt.getSource() == this.pcdRadio) {
                    this.setPCDRadioSelected(true);
                }
            }
        }

        public Boolean modelEnabled() {
            return this.modelEnable;
        }

        @Override
        protected void cancelButtonAction() {
            this.modelEnable = false;
            NewProfileDialog.this.dialog.dispose();
        }

        protected JPanel getDirectroyPanel() {
            this.browserBtn = new JButton("Browse...");
            this.browserBtn.addActionListener(this);
            this.pathTF = new JTextField();
            this.pathTF.setPreferredSize(new Dimension(100, 20));
            JPanel p12 = new JPanel();
            p12.setLayout(new BoxLayout(p12, 2));
            p12.add(this.pathTF);
            p12.add(Box.createRigidArea(new Dimension(5, 5)));
            p12.add(this.browserBtn);
            return p12;
        }

        protected JPanel getLineAxisPanel(JComponent firstComp, JComponent comp) {
            firstComp.setPreferredSize(new Dimension(130, 20));
            JPanel labelCompPanel = new JPanel();
            labelCompPanel.setLayout(new BoxLayout(labelCompPanel, 2));
            labelCompPanel.add(Box.createRigidArea(new Dimension(20, 0)));
            labelCompPanel.add(firstComp);
            if (comp != null) {
                labelCompPanel.add(comp);
            }
            labelCompPanel.add(Box.createRigidArea(new Dimension(20, 0)));
            return labelCompPanel;
        }

        protected JPanel getLineAxisPanel(String labelTxt, JComponent comp) {
            JLabel label = new JLabel(labelTxt);
            return this.getLineAxisPanel(label, comp);
        }

        protected JPanel getPCDPanel() {
            this.modeBox = new JComboBox();
            this.modeBox.addItem("Baseline");
            this.modeBox.addItem("Polling");
            this.modeBox.setPreferredSize(new Dimension(400, 20));
            JPanel modePanel = new JPanel();
            modePanel.setLayout(new BoxLayout(modePanel, 2));
            modePanel.add(Box.createRigidArea(new Dimension(20, 0)));
            modePanel.add(this.modeBox);
            modePanel.add(Box.createHorizontalGlue());
            modePanel.add(Box.createRigidArea(new Dimension(20, 0)));
            return modePanel;
        }

        protected JPanel getPHDPanel() {
            JPanel agtMgrPanel = new JPanel();
            agtMgrPanel.setLayout(new BoxLayout(agtMgrPanel, 2));
            agtMgrPanel.add(Box.createRigidArea(new Dimension(20, 0)));
            agtMgrPanel.add(Box.createHorizontalGlue());
            agtMgrPanel.add(Box.createRigidArea(new Dimension(20, 0)));
            return agtMgrPanel;
        }

        protected JPanel getTypePanel() {
            this.typeBox = new JComboBox();
            this.typeBox.addItem("Agent");
            this.typeBox.addItem("Manager");
            this.typeBox.setPreferredSize(new Dimension(400, 20));
            JPanel agtMgrPanel = new JPanel();
            agtMgrPanel.setLayout(new BoxLayout(agtMgrPanel, 2));
            agtMgrPanel.add(Box.createRigidArea(new Dimension(20, 0)));
            agtMgrPanel.add(this.typeBox);
            agtMgrPanel.add(Box.createHorizontalGlue());
            agtMgrPanel.add(Box.createRigidArea(new Dimension(20, 0)));
            return agtMgrPanel;
        }

        @Override
        protected void okButtonAction() {
            if (this.typeBox.getSelectedItem().toString().equalsIgnoreCase("Agent")) {
                this.profileResume.setProfileType("Agent");
            } else {
                this.profileResume.setProfileType("Manager");
            }
            if (this.phdRadio.isSelected()) {
                this.profileResume.setDeviceType("PHD");
            } else {
                this.profileResume.setDeviceType("PCD");
                if (this.modeBox.getSelectedItem().toString().equalsIgnoreCase("Baseline")) {
                    this.profileResume.setProfileMode("Baseline");
                } else {
                    this.profileResume.setProfileMode("Polling");
                }
            }
            if (this.nameOrDirectory) {
                String projName = this.txtProjectName.getText();
                if (!(projName = projName.trim()).equalsIgnoreCase("")) {
                    projName = projName.replace(" ", "_");
                    projName = projName.replace("\\", "_");
                    projName = projName.replace("/", "_");
                    this.profile.getResume().setTitle(projName);
                }
            }
            this.modelEnable = true;
            ICSAppControl.GetInstance().newProject();
            Application.getInstance().getLifecyle().reset();
            NewProfileDialog.this.dialog.dispose();
        }

        private void initComponent(boolean nameOrDirectory) {
            DefaultBox projectNameBox = new DefaultBox(false, (Boolean)false);
            DefaultBox typeBox = new DefaultBox(false, (Boolean)false);
            DefaultBox natureBox = new DefaultBox(false, (Boolean)false);
            this.getBoxList().add(projectNameBox);
            this.getBoxList().add(typeBox);
            this.getBoxList().add(natureBox);
            this.txtProjectName = new JTextField();
            this.phdRadio = new JRadioButton("PHD");
            this.pcdRadio = new JRadioButton("PCD");
            this.phdRadio.addItemListener(this);
            this.pcdRadio.addItemListener(this);
            if (nameOrDirectory) {
                projectNameBox.addComponent(this.getLineAxisPanel("Project Name", (JComponent)this.txtProjectName));
            } else {
                projectNameBox.addComponent(this.getLineAxisPanel("Directory: ", (JComponent)this.getDirectroyPanel()));
            }
            JRadioButton typeRadio = new JRadioButton("Type");
            typeRadio.setSelected(true);
            typeBox.addComponent(this.getLineAxisPanel(typeRadio, (JComponent)this.getTypePanel()));
            natureBox.addComponent(this.getLineAxisPanel(this.pcdRadio, (JComponent)this.getPCDPanel()));
            natureBox.addComponent(this.getLineAxisPanel(this.phdRadio, (JComponent)this.getPHDPanel()));
            this.assembly();
            this.setPCDRadioSelected(true);
        }

        private void setPCDRadioSelected(boolean bool) {
            if (bool) {
                this.pcdRadio.setSelected(true);
                this.phdRadio.setSelected(false);
                this.modeBox.setEnabled(true);
            } else {
                this.phdRadio.setSelected(true);
                this.pcdRadio.setSelected(false);
                this.modeBox.setEnabled(false);
            }
        }
    }
}

