/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.view;

import gov.nist.healthcare.dev.profile.control.file.xmlv1.LoadExample;
import gov.nist.healthcare.mdc.framework.Application;
import gov.nist.healthcare.mdc.framework.StandaloneResourceManager;
import gov.nist.healthcare.mdc.framework.action.ApplicationAction;
import gov.nist.healthcare.mdc.framework.module.ViewModule;
import gov.nist.healthcare.mdc.icsgenerator.control.view.ICSModuleContainer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Menubar
extends JMenuBar {
    public FileMenuBar fileMenuBar = new FileMenuBar();

    public Menubar() {
        this.add(this.fileMenuBar.getMenu());
        this.add(new LoadExampleMenuBar().getMenu());
        this.add(new HelpMenuBar().getMenu());
    }

    public List<String> getICSMenuText() {
        ArrayList<String> listICSMenuText = new ArrayList<String>();
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.dimmoc"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.mocatt"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.mocbeh"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.mocnotif"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.baseline"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.polling"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.general"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.generalinteroperability"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.service"));
        listICSMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.dimics.toplevel"));
        return listICSMenuText;
    }

    public List<String> getNewProjectText() {
        ArrayList<String> listICSMenuText = new ArrayList<String>();
        listICSMenuText.add("Baseline Agent");
        listICSMenuText.add("Baseline Manager");
        listICSMenuText.add("Polling Agent");
        listICSMenuText.add("Polling Manager");
        listICSMenuText.add("PHD Agent");
        listICSMenuText.add("PHD Manager");
        return listICSMenuText;
    }

    public List<String> getPHDMenuText() {
        ArrayList<String> listPHDMenuText = new ArrayList<String>();
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.general"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.minreq"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.service"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.addexten"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.phddimpoc"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.pocatt"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.pocbeh"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.pocnotif"));
        listPHDMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.ics.phdics.pocnomen"));
        return listPHDMenuText;
    }

    public List<String> getToolsMenuText() {
        ArrayList<String> listToolsMenuText = new ArrayList<String>();
        listToolsMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.tools.generatexml"));
        listToolsMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.tools.umldiagram"));
        listToolsMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.tools.validation"));
        listToolsMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.tools.compare"));
        listToolsMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.tools.hl7messages"));
        listToolsMenuText.add(StandaloneResourceManager.getInstance().getBundleTxt("menu.tootls.rch"));
        return listToolsMenuText;
    }

    class ToolsMenuBar
    extends Menu {
        public List<JMenuItem> listToolsMenuItem;

        public ToolsMenuBar() {
            this.menu = new JMenu("Tools");
            this.listToolsMenuItem = new ArrayList<JMenuItem>();
            Action toolsAction = ApplicationAction.actionMap.get("TOOLS");
            for (ViewModule txt : ICSModuleContainer.getModuleContainer().getModuleList()) {
                JMenuItem jMenuItem = new JMenuItem(toolsAction);
                jMenuItem.setText(txt.getName());
                jMenuItem.setEnabled(true);
                this.listToolsMenuItem.add(jMenuItem);
                this.menu.add(jMenuItem);
            }
        }
    }

    class PHDMenuBar
    extends Menu {
        public List<JCheckBoxMenuItem> listmICSPHDDim;
        boolean isphd;

        public PHDMenuBar() {
            this.isphd = true;
            this.menu = new JMenu("PHD");
            this.listmICSPHDDim = new ArrayList<JCheckBoxMenuItem>();
            Action icsTableAction = ApplicationAction.actionMap.get("ICSTABLE");
            for (String txt : Menubar.this.getPHDMenuText()) {
                JCheckBoxMenuItem jcBoxMenuItem = new JCheckBoxMenuItem(icsTableAction);
                jcBoxMenuItem.setText(txt);
                jcBoxMenuItem.setEnabled(true);
                this.listmICSPHDDim.add(jcBoxMenuItem);
                this.menu.add(jcBoxMenuItem);
            }
        }
    }

    class PCDMenuBar
    extends Menu {
        public List<JCheckBoxMenuItem> listmICSPHDDim;
        boolean isphd;

        public PCDMenuBar() {
            this.isphd = false;
            this.menu = new JMenu("PCD");
            this.listmICSPHDDim = new ArrayList<JCheckBoxMenuItem>();
            Action icsTableAction = ApplicationAction.actionMap.get("ICSTABLE");
            for (String txt : Menubar.this.getICSMenuText()) {
                JCheckBoxMenuItem jcBoxMenuItem = new JCheckBoxMenuItem(icsTableAction);
                jcBoxMenuItem.setText(txt);
                jcBoxMenuItem.setEnabled(true);
                this.listmICSPHDDim.add(jcBoxMenuItem);
                this.menu.add(jcBoxMenuItem);
            }
        }
    }

    abstract class Menu {
        public JMenu menu;

        Menu() {
        }

        public JMenu getMenu() {
            return this.menu;
        }
    }

    class LoadExampleMenuBar
    extends Menu {
        public LoadExampleMenuBar() {
            this.menu = new JMenu("Device Specialization");
            for (String expName : LoadExample.getInstance().getExampleNameList()) {
                JMenuItem menuItem = new JMenuItem(Application.getInstance().getAction("loadExample"));
                menuItem.setText(expName);
                this.menu.add(menuItem);
            }
        }
    }

    class HelpMenuBar
    extends Menu {
        public HelpMenuBar() {
            JMenuItem menu_Help_About = new JMenuItem();
            menu_Help_About.setAction(Application.getInstance().getAction("showAboutDialog"));
            menu_Help_About.setIcon(StandaloneResourceManager.getInstance().getImageIcon("ABOUTICON"));
            this.menu = new JMenu("Help");
            this.menu.add(menu_Help_About);
        }
    }

    public class FileMenuBar
    extends Menu {
        public JMenuItem menu_File_New = new JMenuItem();
        public JMenuItem menu_File_Open;
        public JMenuItem menu_File_Quit;
        public JMenuItem menu_File_Import;
        public JMenuItem menu_File_Save;
        public JMenuItem menu_File_SaveAs;
        public JMenu menu_Recent_Profile;

        public void updateRecent(List<String> names) {
            this.menu_Recent_Profile.removeAll();
            for (String name : names) {
                JMenuItem menuItem = new JMenuItem();
                menuItem.setAction(Application.getInstance().getAction("openFile"));
                menuItem.setText(name);
                this.menu_Recent_Profile.add(menuItem);
            }
        }

        public FileMenuBar() {
            this.menu_File_New.setAction(Application.getInstance().getAction("showNewProfileDialog"));
            this.menu_File_New.setIcon(StandaloneResourceManager.getInstance().getImageIcon("NEWICON"));
            this.menu_File_Open = new JMenuItem("Open...");
            this.menu_File_Open.setAction(Application.getInstance().getAction("openFile"));
            this.menu_File_Open.setIcon(StandaloneResourceManager.getInstance().getImageIcon("OPENICON"));
            this.menu_File_Save = new JMenuItem("Save", 83);
            this.menu_File_Save.setAction(Application.getInstance().getAction("saveFile"));
            this.menu_File_Save.setIcon(StandaloneResourceManager.getInstance().getImageIcon("SAVEICON"));
            this.menu_File_SaveAs = new JMenuItem("Save As...");
            this.menu_File_SaveAs.setAction(Application.getInstance().getAction("saveAsFile"));
            this.menu_File_SaveAs.setIcon(StandaloneResourceManager.getInstance().getImageIcon("SAVEASICON"));
            this.menu_File_Import = new JMenuItem();
            this.menu_File_Import.setAction(Application.getInstance().getAction("importPrivateTerms"));
            this.menu_Recent_Profile = new JMenu("Recent Profiles");
            this.menu_File_Quit = new JMenuItem();
            this.menu_File_Quit.setAction(Application.getInstance().getAction("shutdownApplication"));
            this.menu = new JMenu("File");
            this.menu.setMnemonic(70);
            this.menu.add(this.menu_File_New);
            this.menu.add(this.menu_File_Open);
            this.menu.addSeparator();
            this.menu.add(this.menu_File_Save);
            this.menu.add(this.menu_File_SaveAs);
            this.menu.addSeparator();
            this.menu.add(this.menu_Recent_Profile);
            this.menu.addSeparator();
            this.menu.add(this.menu_File_Quit);
        }
    }
}

