/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control;

import gov.nist.healthcare.dev.profile.control.file.ProjectFileController;
import gov.nist.healthcare.mdc.applib.FileLocSelector;
import gov.nist.healthcare.mdc.applib.fileFilter.ICSFileFilter;
import gov.nist.healthcare.mdc.applib.fileFilter.XMLFileFilter;
import gov.nist.healthcare.mdc.framework.Application;
import gov.nist.healthcare.mdc.framework.Commands;
import gov.nist.healthcare.mdc.framework.action.Action;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSAppControl;
import gov.nist.healthcare.mdc.icsgenerator.control.ICSLifecycle;
import gov.nist.healthcare.mdc.icsgenerator.control.view.FrameController;
import gov.nist.healthcare.mdc.icsgenerator.control.view.ICSViewController;
import gov.nist.healthcare.mdc.icsgenerator.model.AppConfiguration;
import gov.nist.healthcare.mdc.icsgenerator.view.AboutDialog;
import gov.nist.healthcare.mdc.icsgenerator.view.NewProfileDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class ICSCommands
implements Commands {
    @Action(display="Import Private Terms...")
    public void importPrivateTerms(ActionEvent arg) {
        File file = FileLocSelector.fileLocationSelecter(this.getFrameControl().getFrame(), "./", ".xml", 0, new XMLFileFilter());
        if (file != null) {
            try {
                String path = file.getCanonicalPath();
                Application.getInstance().getLifecyle().refresh();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Action(display="Load Example")
    public void loadExample(ActionEvent arg) {
        String expName = ((JMenuItem)arg.getSource()).getText();
        System.out.println("Args " + expName);
        ICSAppControl.GetInstance().loadSpec(expName);
        Application.getInstance().getLifecyle().reset();
    }

    @Action(display="Open...")
    public void openFile(ActionEvent arg) {
        File file;
        String expName = ((JMenuItem)arg.getSource()).getText();
        AppConfiguration model = (AppConfiguration)ICSAppControl.GetInstance().getContext("application.config");
        if (expName.equals("Open...")) {
            String dir = "project";
            if (model != null) {
                dir = model.getDefaultProjectDir();
            }
            file = FileLocSelector.fileLocationSelecter(this.getFrameControl().getFrame(), dir, ".icszip", 0, new ICSFileFilter());
        } else {
            System.out.println("Args " + expName);
            file = new File(expName);
        }
        if (file != null && file.exists()) {
            try {
                String path = file.getCanonicalPath();
                if (path.endsWith(".icszip")) {
                    String _dir = path.substring(0, path.length() - file.getName().length());
                    model.setDefaultProjectDir(_dir);
                    List<String> recents = model.getRecentProfiles();
                    if (recents.contains(path)) {
                        recents.remove(path);
                    }
                    recents.add(0, path);
                    if (recents.size() > 5) {
                        model.setRecentProfiles(recents.subList(0, 5));
                    } else {
                        model.setRecentProfiles(recents);
                    }
                    ICSAppControl.GetInstance().saveApplicationConfig();
                }
                ICSAppControl.GetInstance().openProject(path);
                Application.getInstance().getLifecyle().reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Action(display="Save As...")
    public void saveAsFile(ActionEvent arg) {
        this.save(true);
        Application.getInstance().getLifecyle().refresh();
    }

    @Action(display="Save")
    public void saveFile(ActionEvent arg) {
        this.save(false);
        Application.getInstance().getLifecyle().refresh();
    }

    @Action(display="About ICS Generator")
    public void showAboutDialog(ActionEvent arg) {
        JFrame frame = new JFrame("About ICS Generator");
        AboutDialog dialog = new AboutDialog((Component)this.getFrameControl().getFrame(), frame);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Action(display="New Device")
    public void showNewProfileDialog(ActionEvent arg) {
        new NewProfileDialog(FrameController.getFrame());
    }

    @Action(display="Exit")
    public void shutdownApplication(ActionEvent arg) {
        Application.getInstance().getLifecyle().shutdown();
    }

    private ICSViewController getFrameControl() {
        return ((ICSLifecycle)Application.getInstance().getLifecyle()).getFrameControl();
    }

    private void save(Boolean saveas) {
        ProjectFileController fm = ICSAppControl.GetInstance().getProject();
        System.out.println("Save() " + fm.getProjectPath());
        if (fm.getProjectPath().equals("unamedProject.icszip") || saveas.booleanValue()) {
            File file;
            AppConfiguration model = (AppConfiguration)ICSAppControl.GetInstance().getContext("application.config");
            String dir = "project";
            if (model != null) {
                dir = model.getDefaultProjectDir();
            }
            if ((file = FileLocSelector.fileLocationSelecter(this.getFrameControl().getFrame(), dir, ".icszip", 1, new ICSFileFilter())) != null) {
                String path = file.getAbsolutePath();
                fm.setProjectPath(path);
                if (path.endsWith(".icszip")) {
                    String _dir = path.substring(0, path.length() - file.getName().length());
                    model.setDefaultProjectDir(_dir);
                    ICSAppControl.GetInstance().saveApplicationConfig();
                }
            } else {
                return;
            }
        }
        ICSAppControl.GetInstance().persistProject();
    }

    protected class ResetThread
    extends Thread {
        protected ResetThread() {
        }

        @Override
        public void run() {
            Application.getInstance().getLifecyle().reset();
        }
    }
}

