/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1;

import gov.nist.healthcare.dev.profile.control.file.xmlv1.V1XmlBuilder;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Attribute;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Behavior;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73DimObject;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Notification;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.DimCommonObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimBehavior;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimNotification;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import java.util.List;

public class ModelAdaptor {
    public static void buildDimObjectList(V1XmlBuilder dim, List<DeviceObject> dimObjectList, X73DimObject parentDimObj) {
        DeviceObject mdo = new DeviceObject();
        DimCommonObject dimo = ModelAdaptor.getDimObject(parentDimObj, mdo);
        mdo.setId(ModelAdaptor.integerFactory(parentDimObj.getProfileId()));
        if (!mdo.getId().equals(0)) {
            mdo.setParentId(ModelAdaptor.integerFactory(parentDimObj.getProfileParentId().get(0)));
        }
        dimObjectList.add(mdo);
        List<X73DimObject> childNameList = dim.getX73ObjectChildren(parentDimObj);
        for (X73DimObject name : childNameList) {
            ModelAdaptor.buildDimObjectList(dim, dimObjectList, name);
        }
    }

    public static DimAttribute getDimAttribute(X73Attribute x73Object) {
        DimAttribute param = new DimAttribute();
        param.setName(ModelAdaptor.stringFactory(x73Object.getBaseName()));
        param.setClause(ModelAdaptor.stringFactory(x73Object.getBaseReference()));
        param.setRefid(ModelAdaptor.stringFactory(x73Object.getBaseRefId()));
        param.setTermcode(ModelAdaptor.stringFactory(x73Object.getBaseTermCode()));
        param.setAttribute_derived_from(x73Object.getAttrDerivedFrom());
        param.setAttribute_group_id(x73Object.getAttrGrpId());
        param.setAttribute_group_name(x73Object.getAttrGrpName());
        param.setAttribute_group_termcode(x73Object.getAttrGrpTermCode());
        param.setAttribute_access(x73Object.getAttAccess());
        param.setAttribute_static_dyn(x73Object.getAttrStaticDyn());
        param.setAttribute_value_range(x73Object.getAttrValueRange());
        param.setParaMode(ModelAdaptor.stringFactory(x73Object.getParaMode()));
        param.setParaType(ModelAdaptor.stringFactory(x73Object.getParaType()));
        if (param.getParaMode().equals("C")) {
            param.setParaMode("Conditional");
        } else if (param.getParaMode().equals("M")) {
            param.setParaMode("Mandatory");
        } else if (param.getParaMode().equals("O")) {
            param.setParaMode("Optional");
        }
        return param;
    }

    public static DimBehavior getDimBehavior(X73Behavior x73Object) {
        DimBehavior param = new DimBehavior();
        param.setName(ModelAdaptor.stringFactory(x73Object.getBaseName()));
        param.setClause(ModelAdaptor.stringFactory(x73Object.getBaseReference()));
        param.setRefid(ModelAdaptor.stringFactory(x73Object.getBaseRefId()));
        param.setTermcode(ModelAdaptor.stringFactory(x73Object.getBaseTermCode()));
        param.setParaMode(ModelAdaptor.stringFactory(x73Object.getParaMode()));
        param.setParaType(ModelAdaptor.stringFactory(x73Object.getParaType()));
        param.setParaResult(ModelAdaptor.stringFactory(x73Object.getParaResult()));
        return param;
    }

    public static DimNotification getDimNotification(X73Notification x73Object) {
        DimNotification param = new DimNotification();
        param.setName(ModelAdaptor.stringFactory(x73Object.getBaseName()));
        param.setClause(ModelAdaptor.stringFactory(x73Object.getBaseReference()));
        param.setRefid(ModelAdaptor.stringFactory(x73Object.getBaseRefId()));
        param.setTermcode(ModelAdaptor.stringFactory(x73Object.getBaseTermCode()));
        param.setParaMode(ModelAdaptor.stringFactory(x73Object.getParaMode()));
        param.setParaType(ModelAdaptor.stringFactory(x73Object.getParaType()));
        param.setParaResult(ModelAdaptor.stringFactory(x73Object.getParaResult()));
        return param;
    }

    public static DimCommonObject getDimObject(X73DimObject x73Object, DeviceObject mdo) {
        DimObject dimOb = new DimObject();
        dimOb.setName(ModelAdaptor.stringFactory(x73Object.getBaseName()));
        dimOb.setClause(ModelAdaptor.stringFactory(x73Object.getBaseReference()));
        dimOb.setRefid(ModelAdaptor.stringFactory(x73Object.getBaseRefId()));
        dimOb.setTermcode(ModelAdaptor.stringFactory(x73Object.getBaseTermCode()));
        mdo.setRefid(ModelAdaptor.stringFactory(x73Object.getMocRefId()));
        mdo.setName(ModelAdaptor.stringFactory(x73Object.getMocLabel()));
        mdo.setCode10(ModelAdaptor.stringFactory(x73Object.getMocTermCode()));
        mdo.setComment(ModelAdaptor.stringFactory(x73Object.getMocComment()));
        for (X73Attribute x73Attribute : x73Object.getAttribute()) {
            dimOb.getDimAttributes().add(ModelAdaptor.getDimAttribute(x73Attribute));
        }
        for (X73Behavior x73Behavior : x73Object.getBehavior()) {
            dimOb.getDimBehaviors().add(ModelAdaptor.getDimBehavior(x73Behavior));
        }
        for (X73Notification x73Notification : x73Object.getNotification()) {
            dimOb.getDimNotifications().add(ModelAdaptor.getDimNotification(x73Notification));
        }
        mdo.setDimObject(dimOb);
        return dimOb;
    }

    public static Integer integerFactory(Integer integer) {
        if (integer == null) {
            return new Integer("-1");
        }
        return integer;
    }

    public static String stringFactory(String in) {
        if (in == null) {
            return new String();
        }
        return in;
    }
}

