/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1;

import gov.nist.healthcare.dev.profile.common.ResourceManager;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.V1XmlBuilder;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public class LoadExample {
    protected static ResourceBundle exampleBundle;
    protected static String prefix;
    private static LoadExample loadExInstance;
    protected List<String> exampleNameList;

    public static LoadExample getInstance() {
        return loadExInstance;
    }

    private LoadExample() {
        prefix = "example.";
        ResourceManager rssController = ResourceManager.newInstance((String)"resources/common/files-conf");
        if (rssController != null) {
            exampleBundle = rssController.getRssBundle();
        }
        this.buildExampleNameList();
    }

    public List<String> getExampleNameList() {
        return this.exampleNameList;
    }

    public V1XmlBuilder setupExample(DeviceProfile profile, String expName) {
        String examplePath = exampleBundle.getString(prefix + expName);
        InputStream xmlInputStream = ResourceManager.newInstance().getInputStream(examplePath);
        if (examplePath.indexOf("examples/PHD/") == -1) {
            profile.getResume().setDeviceType("PCD");
        } else {
            profile.getResume().setDeviceType("PHD");
        }
        profile.getResume().setProfileType("Agent");
        profile.getResume().setProfileMode("Baseline");
        profile.getResume().setTitle(expName.substring(expName.indexOf("_") + 1));
        profile.getResume().setDescription("http://www.nist.gov/medicaldevices/ICSGenerator/ics_index.html");
        profile.getResume().setAuthor("MDC Group");
        profile.getResume().setCompany("NIST");
        V1XmlBuilder dim = new V1XmlBuilder(xmlInputStream);
        return dim;
    }

    private void buildExampleNameList() {
        this.exampleNameList = new ArrayList<String>();
        Set<String> nameSet = exampleBundle.keySet();
        for (String name : nameSet) {
            if (!name.startsWith(prefix)) continue;
            this.exampleNameList.add(name.substring(prefix.length()));
        }
        Collections.sort(this.exampleNameList);
    }

    static {
        loadExInstance = new LoadExample();
    }
}

