/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.core;

import gov.nist.healthcare.dev.profile.control.app.DynamicProxyTest;
import gov.nist.healthcare.dev.profile.control.file.ProfileController;
import gov.nist.healthcare.dev.profile.dao.DBDao;
import gov.nist.healthcare.dev.profile.dao.DimDao;
import gov.nist.healthcare.dev.profile.dao.guice.rest.DBDaoRestImpl;
import gov.nist.healthcare.deviceProfile.domain.IMDObject;
import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.DeviceProfile;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceEnumGroup;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceTerm;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnitGroup;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.DimCommonObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.EntiCardinality;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSEnumGroup;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSRosetta;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSUnitGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BuilderController {
    private static final Logger log = Logger.getLogger(BuilderController.class.getName());
    private DBDao dbcontroller;
    private ProfileController profileController;

    public BuilderController() {
    }

    public BuilderController(DBDao dbcontroller) {
        this.dbcontroller = dbcontroller;
    }

    public DeviceObject addNewObject(DeviceObject parent, DimCommonObject dimOb) {
        DimObject dimObj = this.fetchDimObjectFromDB(dimOb.getName(), dimOb.getRefid());
        dimObj.getDimAttributes().clear();
        dimObj.getDimBehaviors().clear();
        dimObj.getDimNotifications().clear();
        return this.getProfile().addObject(parent, new DeviceObject(dimObj));
    }

    public DeviceObject addRootToList() {
        DeviceObject root = new DeviceObject(this.getDimDao().getObjectRoot());
        root.setId(Integer.valueOf(0));
        this.getProfile().getObjects().clear();
        this.getProfile().getObjects().add(root);
        return root;
    }

    public DimObject fetchDimObjectFromDB(DeviceObject mdObject) {
        return this.fetchDimObjectFromDB(mdObject.getDimName(), mdObject.getDimRefid());
    }

    public DimObject fetchDimObjectFromDB(String name, String refid) {
        DimObject dim = this.getDimDao().getObject(new DimObject(name.trim(), refid.trim()));
        return dim;
    }

    public List<DeviceObject> getChildrenByDimName(DeviceObject mdo, String dimname) {
        ArrayList<DeviceObject> ret = new ArrayList<DeviceObject>();
        List children = this.getProfile().getChildren(mdo);
        for (DeviceObject child : children) {
            if (!child.getDimName().equals(dimname)) continue;
            ret.add(child);
        }
        return ret;
    }

    public List<EntiCardinality> getCompleteListCardinality(DeviceObject mdo) {
        ArrayList<EntiCardinality> ret = new ArrayList<EntiCardinality>();
        List lecl = mdo.getDimObject().getCardinalities();
        DimObject dimo = this.fetchDimObjectFromDB(mdo);
        for (EntiCardinality card1 : lecl) {
            if (dimo.getCardinalities().contains(card1)) {
                dimo.getCardinalities().remove(card1);
            }
            ret.add(card1);
        }
        for (EntiCardinality card : dimo.getCardinalities()) {
            ret.add(card);
        }
        return ret;
    }

    public DBDao getDbController() {
        return this.dbcontroller;
    }

    public List<Integer> getInvalidCardObjectList() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (this.getProfile().getResume().getDeviceType().equals("PHD")) {
            return ret;
        }
        List mdos = this.getProfile().getObjects();
        for (DeviceObject mdo : mdos) {
            for (EntiCardinality enticard : this.getCompleteListCardinality(mdo)) {
                Boolean valid = TermcodeUtils.ValidateCard((String)enticard.getCardinality());
                if (!valid.booleanValue()) continue;
                List<DeviceObject> children = this.getChildrenByDimName(mdo, enticard.getChildObject().getName());
                Boolean uppervalid = TermcodeUtils.ValidateCardUpperbound((String)enticard.getCardinality(), (Integer)children.size());
                if (uppervalid.booleanValue()) continue;
                ret.add(mdo.getId());
            }
        }
        return ret;
    }

    public ProfileController getProfileController() {
        return this.profileController;
    }

    public DeviceProfile rebuild(DeviceProfile deviceprofile) {
        for (DeviceObject obj : deviceprofile.getObjects()) {
            this.updateTermcode(obj);
            this.updateDimObject(obj);
        }
        return deviceprofile;
    }

    public void setDbController(DBDao dbcontroller) {
        this.dbcontroller = dbcontroller;
    }

    public void setProfileController(ProfileController profileController) {
        this.profileController = profileController;
    }

    public DeviceObject updateTermcode(DeviceObject object) {
        if (object == null) {
            return object;
        }
        IMDObject obj = DynamicProxyTest.getDynObject(object);
        String _refid = obj.getRefid();
        if (_refid.length() > 1 && !_refid.equals("MDC_")) {
            List terms = this.dbcontroller.getTerms(_refid);
            for (DeviceTerm term : terms) {
                if (!term.getRefid().equals(_refid) || term.getCode10() == null || term.getCode10().equals("0")) continue;
                obj.setCode10(term.getCode10());
                return object;
            }
        }
        obj.setCode10("");
        return object;
    }

    public DeviceObject updateUnitEnum(DeviceObject obj) {
        this.updateUnitEnum(obj.getRefid());
        return obj;
    }

    public DeviceObject updateUnitEnum(String refid) {
        DeviceObject obj = null;
        List terms = this.dbcontroller.findTerms(refid);
        for (DeviceTerm term : terms) {
            if (!term.getRefid().equals(refid)) continue;
            obj = new DeviceObject();
            List rosettaTerms = this.dbcontroller.getRtmDao().get(refid);
            log.info("Number of Rosetta Term" + rosettaTerms.size());
            int i = 1;
            for (ICSRosetta rstt : rosettaTerms) {
                List icsEnums = rstt.getEnums();
                if (icsEnums.size() > 0) {
                    DeviceEnumGroup newEnumGroup = new DeviceEnumGroup(icsEnums);
                    newEnumGroup.setEnumGroup("Enumeration List " + (obj.getEnumGroups().size() + 1));
                    obj.getEnumGroups().add(newEnumGroup);
                }
                List icsUnits = rstt.getUnits();
                log.info("Number of Unit of Rosetta Term" + icsUnits.size());
                if (icsUnits.size() <= 0) continue;
                DeviceUnitGroup newUnitGroup = new DeviceUnitGroup(icsUnits);
                newUnitGroup.setUnitGroup("Unit List " + i++);
                obj.getUnitGroups().add(newUnitGroup);
            }
            for (ICSRosetta rosTerm : rosettaTerms) {
                for (ICSEnumGroup enumGp : rosTerm.getEnumGroups()) {
                    DeviceEnumGroup mdEnumGp = new DeviceEnumGroup(enumGp);
                    if (obj.getEnumGroups().contains(mdEnumGp)) continue;
                    obj.getEnumGroups().add(mdEnumGp);
                }
                for (ICSUnitGroup unitGp : rosTerm.getUnitGroups()) {
                    DeviceUnitGroup mdUnitGrp = new DeviceUnitGroup(unitGp.getUnit_group(), DBDaoRestImpl.MDUnitFactory((List)unitGp.getUnits()));
                    if (obj.getUnitGroups().contains(mdUnitGrp)) continue;
                    obj.getUnitGroups().add(mdUnitGrp);
                }
            }
            log.info("EnumGroup size " + obj.getEnumGroups().size());
            log.info("UnitGroup size " + obj.getUnitGroups().size());
            return obj;
        }
        return obj;
    }

    protected DimDao getDimDao() {
        return this.dbcontroller.getDimDao();
    }

    private DeviceProfile getProfile() {
        return this.profileController.getProfile();
    }

    private void updateDimObject(DeviceObject obj) {
        DimObject dimObj = this.fetchDimObjectFromDB(obj);
        for (DimAttribute v : obj.getDimObject().getDimAttributes()) {
            if (!dimObj.getDimAttributes().contains(v)) continue;
            dimObj.getDimAttributes().remove(v);
        }
        if (dimObj != null) {
            obj.getDimObject().setTermcode(dimObj.getTermcode());
            obj.getDimObject().setClause(dimObj.getClause());
            for (DimAttribute v : dimObj.getDimAttributes()) {
                if (!v.getParaMode().contains("Mandatory")) continue;
                obj.getDimObject().getDimAttributes().add(v);
            }
        } else {
            log.info("Error: dim object not found in database");
            log.info(obj.dump());
        }
    }
}

