/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

public abstract class AbstractPathResolver
extends Resolver {
    private IManagedType managedType;
    private boolean managedTypeResolved;
    private IMapping mapping;
    private boolean mappingResolved;
    protected final String path;

    protected AbstractPathResolver(Resolver parent, String path) {
        super(parent);
        this.path = path;
        parent.addChild(path, this);
    }

    protected ITypeDeclaration buildTypeDeclaration() {
        IMapping mapping = this.getMapping();
        if (mapping != null) {
            return mapping.getTypeDeclaration();
        }
        return this.getTypeHelper().unknownTypeDeclaration();
    }

    public IManagedType getManagedType() {
        if (this.managedType == null && !this.managedTypeResolved) {
            this.managedTypeResolved = true;
            IMapping mapping = this.getMapping();
            if (mapping != null) {
                this.managedType = this.resolveManagedType(mapping);
            }
        }
        return this.managedType;
    }

    public final IMapping getMapping() {
        if (this.mapping == null && !this.mappingResolved) {
            this.mapping = this.resolveMapping();
            this.mappingResolved = true;
        }
        return this.mapping;
    }

    public final String getPath() {
        return this.path;
    }

    protected abstract IManagedType resolveManagedType(IMapping var1);

    protected IMapping resolveMapping() {
        IManagedType managedType = this.getParentManagedType();
        if (managedType != null) {
            return managedType.getMappingNamed(this.path);
        }
        return null;
    }
}

