/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.ValuePartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.FieldPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ValuePartitionMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class ValuePartitioningMetadata
extends FieldPartitioningMetadata {
    protected List<ValuePartitionMetadata> partitions;
    protected String defaultConnectionPool;

    public ValuePartitioningMetadata() {
        super("<value-partitioning>");
    }

    public ValuePartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.defaultConnectionPool = (String)annotation.getAttribute("defaultConnectionPool");
        this.partitions = new ArrayList<ValuePartitionMetadata>();
        Object[] objectArray = (Object[])annotation.getAttributeArray("partitions");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object partitionAnnotation = objectArray[n2];
            this.partitions.add(new ValuePartitionMetadata((MetadataAnnotation)partitionAnnotation, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ValuePartitioningMetadata) {
            ValuePartitioningMetadata policy = (ValuePartitioningMetadata)objectToCompare;
            if (!this.valuesMatch(this.defaultConnectionPool, policy.getDefaultConnectionPool())) {
                return false;
            }
            return this.valuesMatch(this.partitions, policy.getPartitions());
        }
        return false;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.partitions, accessibleObject);
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        ValuePartitioningPolicy policy = new ValuePartitioningPolicy();
        super.buildPolicy(policy);
        policy.setPartitionValueTypeName(this.getPartitionValueType().getName());
        policy.setDefaultConnectionPool(this.defaultConnectionPool);
        for (ValuePartitionMetadata partition : this.getPartitions()) {
            policy.addPartitionName(partition.getValue(), partition.getConnectionPool());
        }
        return policy;
    }

    public String getDefaultConnectionPool() {
        return this.defaultConnectionPool;
    }

    public List<ValuePartitionMetadata> getPartitions() {
        return this.partitions;
    }

    public void setDefaultConnectionPool(String defaultConnectionPool) {
        this.defaultConnectionPool = defaultConnectionPool;
    }

    public void setPartitions(List<ValuePartitionMetadata> partitions) {
        this.partitions = partitions;
    }
}

