/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class JAXBException
extends EclipseLinkException {
    public static final int NO_OBJECT_FACTORY_OR_JAXB_INDEX_IN_PATH = 50000;
    public static final int FACTORY_METHOD_OR_ZERO_ARG_CONST_REQ = 50001;
    public static final int FACTORY_CLASS_WITHOUT_FACTORY_METHOD = 50002;
    public static final int FACTORY_METHOD_NOT_DECLARED = 50003;
    public static final int ANY_ATTRIBUTE_ON_NON_MAP_PROPERTY = 50004;
    public static final int MULTIPLE_ANY_ATTRIBUTE_MAPPING = 50005;
    public static final int INVALID_XML_ELEMENT_REF = 50006;
    public static final int NAME_COLLISION = 50007;
    public static final int UNSUPPORTED_NODE_CLASS = 50008;
    public static final int TRANSIENT_IN_PROP_ORDER = 50009;
    public static final int XMLVALUE_ATTRIBUTE_CONFLICT = 50010;
    public static final int SUBCLASS_CANNOT_HAVE_XMLVALUE = 50011;
    public static final int NON_EXISTENT_PROPERTY_IN_PROP_ORDER = 50012;
    public static final int MISSING_PROPERTY_IN_PROP_ORDER = 50013;
    public static final int INVALID_TYPE_FOR_XMLVALUE_PROPERTY = 50014;
    public static final int INVALID_XML_ELEMENT_WRAPPER = 50015;
    public static final int INVALID_ID = 50016;
    public static final int INVALID_IDREF = 50017;
    public static final int INVALID_LIST = 50018;
    public static final int VALUE_PARAMETER_TYPE_INCORRECT_FOR_OXM_XML = 50019;
    public static final int KEY_PARAMETER_TYPE_INCORRECT = 50021;
    public static final int VALUE_PARAMETER_TYPE_INCORRECT = 50022;
    public static final int NULL_METADATA_SOURCE = 50023;
    public static final int NULL_MAP_KEY = 50024;
    public static final int COULD_NOT_LOAD_CLASS_FROM_METADATA = 50025;
    public static final int COULD_NOT_CREATE_CONTEXT_FOR_XML_MODEL = 50026;
    public static final int COULD_NOT_UNMARSHAL_METADATA = 50027;
    public static final int COULD_NOT_CREATE_CUSTOMIZER_INSTANCE = 50028;
    public static final int INVALID_CUSTOMIZER_CLASS = 50029;
    public static final int ID_ALREADY_SET = 50030;
    public static final int XMLVALUE_ALREADY_SET = 50031;
    public static final int XMLANYELEMENT_ALREADY_SET = 50032;
    public static final int COULD_NOT_INITIALIZE_DOM_HANDLER_CONVERTER = 50033;
    public static final int INVALID_TYPE_FOR_XMLATTRIBUTEREF_PROPERTY = 50034;
    public static final int INVALID_XMLELEMENT_IN_XMLELEMENTS = 50035;
    public static final int NULL_TYPE_ON_TYPEMAPPINGINFO = 50036;
    public static final int JAVATYPE_NOT_ALLOWED_IN_BINDINGS_FILE = 50037;
    public static final int CANNOT_CREATE_DYNAMIC_CONTEXT_FROM_CLASSES = 50038;
    public static final int CANNOT_INITIALIZE_FROM_NODE = 50039;
    public static final int ERROR_CREATING_DYNAMICJAXBCONTEXT = 50040;
    public static final int ENUM_CONSTANT_NOT_FOUND = 50041;
    public static final int NULL_SESSION_NAME = 50042;
    public static final int NULL_SOURCE = 50043;
    public static final int NULL_INPUT_STREAM = 50044;
    public static final int NULL_NODE = 50045;
    public static final int XJC_BINDING_ERROR = 50046;
    public static final int CLASS_NOT_FOUND_EXCEPTION = 50047;
    public static final int READ_TRANSFORMER_HAS_BOTH_CLASS_AND_METHOD = 50048;
    public static final int READ_TRANSFORMER_HAS_NEITHER_CLASS_NOR_METHOD = 50049;
    public static final int WRITE_TRANSFORMER_HAS_BOTH_CLASS_AND_METHOD = 50050;
    public static final int WRITE_TRANSFORMER_HAS_NEITHER_CLASS_NOR_METHOD = 50051;
    public static final int WRITE_TRANSFORMER_HAS_NO_XMLPATH = 50052;
    public static final int NO_SUCH_WRITE_TRANSFORMATION_METHOD = 50053;
    public static final int TRANSFORMER_CLASS_NOT_FOUND = 50054;
    public static final int OXM_KEY_NOT_FOUND = 50055;
    public static final int INVALID_REF_CLASS = 50056;
    public static final int TRANSIENT_REF_CLASS = 50057;
    public static final int NO_ID_OR_KEY_ON_JOIN_TARGET = 50058;
    public static final int INVALID_REF_XML_PATH = 50059;
    public static final int INVALID_IDREF_CLASS = 50060;
    public static final int ADAPTER_CLASS_NOT_LOADED = 50061;
    public static final int ADAPTER_CLASS_METHOD_EXCEPTION = 50062;
    public static final int ADAPTER_CLASS_COULD_NOT_BE_INSTANTIATED = 50063;
    public static final int INVALID_ADAPTER_CLASS = 50064;
    public static final int INVALID_PACKAGE_ADAPTER_CLASS = 50065;
    public static final int INVALID_TYPE_ADAPTER_CLASS = 50066;
    public static final int INVALID_PROPERTY_ADAPTER_CLASS = 50067;
    public static final int NULL_METADATA_FILE = 50068;
    public static final int BINDINGS_PKG_NOT_SET = 50069;
    public static final int INCORRECT_NUMBER_OF_XMLJOINNODES_ON_XMLELEMENTS = 50070;
    public static final int INVALID_XML_PATH_ATTRIBUTE = 50071;
    public static final int DUPLICATE_PROPERTY_NAME = 50072;
    public static final int SAME_PROPERTY_IN_MULTIPLE_BINDINGS_FILES = 50073;
    public static final int EXCEPTION_WITH_NAME_TRANSFORMER_CLASS = 50074;
    public static final int EXCEPTION_DURING_NAME_TRANSFORMATION = 50075;
    public static final int UNABLE_TO_LOAD_METADATA_FROM_LOCATION = 50076;
    public static final int CANNOT_REFRESH_METADATA = 50077;
    public static final int XJB_NOT_SOURCE = 50078;
    public static final int XSD_IMPORT_NOT_SOURCE = 50079;
    public static final int INVALID_XMLLOCATION = 50080;
    public static final int EXCEPTION_DURING_SCHEMA_GEN = 50081;
    public static final int JSON_VALUE_WRAPPER_REQUIRED = 50082;
    public static final int ERROR_INSTANTIATING_ACCESSOR_FACTORY = 50083;
    public static final int INVALID_ACCESSOR_FACTORY = 50084;
    public static final int ERROR_CREATING_FIELD_ACCESSOR = 50085;
    public static final int ERROR_CREATING_PROPERTY_ACCESSOR = 50086;
    public static final int ERROR_INVOKING_ACCESSOR = 50087;

    protected JAXBException(String message) {
        super(message);
    }

    protected JAXBException(String message, Exception internalException) {
        super(message, internalException);
    }

    public static JAXBException noObjectFactoryOrJaxbIndexInPath(String path) {
        Object[] args = new Object[]{path};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50000, args));
        exception.setErrorCode(50000);
        return exception;
    }

    public static JAXBException factoryMethodOrConstructorRequired(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50001, args));
        exception.setErrorCode(50001);
        return exception;
    }

    public static JAXBException factoryClassWithoutFactoryMethod(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50002, args));
        exception.setErrorCode(50002);
        return exception;
    }

    public static JAXBException factoryMethodNotDeclared(String methodName, String className) {
        Object[] args = new Object[]{methodName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50003, args));
        exception.setErrorCode(50003);
        return exception;
    }

    public static JAXBException multipleAnyAttributeMapping(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50005, args));
        exception.setErrorCode(50005);
        return exception;
    }

    public static JAXBException anyAttributeOnNonMap(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50004, args));
        exception.setErrorCode(50004);
        return exception;
    }

    public static JAXBException invalidElementRef(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50006, args));
        exception.setErrorCode(50006);
        return exception;
    }

    public static JAXBException invalidElementWrapper(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50015, args));
        exception.setErrorCode(50015);
        return exception;
    }

    public static JAXBException invalidId(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50016, args));
        exception.setErrorCode(50016);
        return exception;
    }

    public static JAXBException invalidIdRef(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50017, args));
        exception.setErrorCode(50017);
        return exception;
    }

    public static JAXBException invalidList(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50018, args));
        exception.setErrorCode(50018);
        return exception;
    }

    public static JAXBException nameCollision(String uri, String name) {
        Object[] args = new Object[]{uri, name};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50007, args));
        exception.setErrorCode(50007);
        return exception;
    }

    public static JAXBException unsupportedNodeClass(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50008, args));
        exception.setErrorCode(50008);
        return exception;
    }

    public static JAXBException transientInProporder(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50009, args));
        exception.setErrorCode(50009);
        return exception;
    }

    public static JAXBException nonExistentPropertyInPropOrder(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50012, args));
        exception.setErrorCode(50012);
        return exception;
    }

    public static JAXBException missingPropertyInPropOrder(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50013, args));
        exception.setErrorCode(50013);
        return exception;
    }

    public static JAXBException propertyOrFieldShouldBeAnAttribute(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50010, args));
        exception.setErrorCode(50010);
        return exception;
    }

    public static JAXBException propertyOrFieldCannotBeXmlValue(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50011, args));
        exception.setErrorCode(50011);
        return exception;
    }

    public static JAXBException invalidTypeForXmlValueField(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50014, args));
        exception.setErrorCode(50014);
        return exception;
    }

    public static JAXBException incorrectKeyParameterType() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50021, args));
        exception.setErrorCode(50021);
        return exception;
    }

    public static JAXBException incorrectValueParameterType() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50022, args));
        exception.setErrorCode(50022);
        return exception;
    }

    public static JAXBException incorrectValueParameterTypeForOxmXmlKey() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50019, args));
        exception.setErrorCode(50019);
        return exception;
    }

    public static JAXBException nullMetadataSource(String key) {
        Object[] args = new Object[]{key};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50023, args));
        exception.setErrorCode(50023);
        return exception;
    }

    public static JAXBException nullMetadataSource() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50068, args));
        exception.setErrorCode(50068);
        return exception;
    }

    public static JAXBException packageNotSetForBindingException() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50069, args));
        exception.setErrorCode(50069);
        return exception;
    }

    public static JAXBException nullMapKey() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50024, args));
        exception.setErrorCode(50024);
        return exception;
    }

    public static JAXBException couldNotLoadClassFromMetadata(String classname) {
        Object[] args = new Object[]{classname};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50025, args));
        exception.setErrorCode(50025);
        return exception;
    }

    public static JAXBException couldNotCreateContextForXmlModel() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50026, args));
        exception.setErrorCode(50026);
        return exception;
    }

    public static JAXBException couldNotCreateContextForXmlModel(Exception ex) {
        Object[] args = new Object[]{ex};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50026, args), ex);
        exception.setErrorCode(50026);
        return exception;
    }

    public static JAXBException couldNotUnmarshalMetadata(Exception e) {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50027, args), e);
        exception.setErrorCode(50027);
        return exception;
    }

    public static JAXBException couldNotCreateCustomizerInstance(Exception e, String customizerClassName) {
        Object[] args = new Object[]{customizerClassName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50028, args), e);
        exception.setErrorCode(50028);
        return exception;
    }

    public static JAXBException invalidCustomizerClass(Exception e, String customizerClassName) {
        Object[] args = new Object[]{customizerClassName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50029, args), e);
        exception.setErrorCode(50029);
        return exception;
    }

    public static JAXBException idAlreadySet(String propertyName, String idPropertyName, String className) {
        Object[] args = new Object[]{propertyName, className, idPropertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50030, args));
        exception.setErrorCode(50030);
        return exception;
    }

    public static JAXBException xmlValueAlreadySet(String propertyName, String xmlValuePropertyName, String className) {
        Object[] args = new Object[]{className, propertyName, xmlValuePropertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50031, args));
        exception.setErrorCode(50031);
        return exception;
    }

    public static JAXBException xmlAnyElementAlreadySet(String propertyName, String xmlAnyElementPropertyName, String className) {
        Object[] args = new Object[]{className, propertyName, xmlAnyElementPropertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50032, args));
        exception.setErrorCode(50032);
        return exception;
    }

    public static JAXBException couldNotInitializeDomHandlerConverter(Exception nestedException, String domHandlerClassName, String propertyName) {
        Object[] args = new Object[]{domHandlerClassName, propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50033, args), nestedException);
        exception.setErrorCode(50033);
        return exception;
    }

    public static JAXBException invalidAttributeRef(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50034, args));
        exception.setErrorCode(50034);
        return exception;
    }

    public static JAXBException invalidXmlElementInXmlElementsList(String propertyName, String elementName) {
        Object[] args = new Object[]{propertyName, elementName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50035, args));
        exception.setErrorCode(50035);
        return exception;
    }

    public static JAXBException nullTypeOnTypeMappingInfo(QName tagName) {
        Object[] args = new Object[]{tagName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50036, args));
        exception.setErrorCode(50036);
        return exception;
    }

    public static JAXBException javaTypeNotAllowedInBindingsFile(String javaTypePackage, String bindingsPackage) {
        Object[] args = new Object[]{javaTypePackage, bindingsPackage};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50037, args));
        exception.setErrorCode(50037);
        return exception;
    }

    public static JAXBException cannotCreateDynamicContextFromClasses() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50038, args));
        exception.setErrorCode(50038);
        return exception;
    }

    public static JAXBException cannotInitializeFromNode() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50039, args));
        exception.setErrorCode(50039);
        return exception;
    }

    public static JAXBException errorCreatingDynamicJAXBContext(Exception nestedException) {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50040, args), nestedException);
        exception.setErrorCode(50040);
        return exception;
    }

    public static JAXBException enumConstantNotFound(String name) {
        Object[] args = new Object[]{name};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50041, args));
        exception.setErrorCode(50041);
        return exception;
    }

    public static JAXBException nullSessionName() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50042, args));
        exception.setErrorCode(50042);
        return exception;
    }

    public static JAXBException nullSource() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50043, args));
        exception.setErrorCode(50043);
        return exception;
    }

    public static JAXBException nullInputStream() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50044, args));
        exception.setErrorCode(50044);
        return exception;
    }

    public static JAXBException nullNode() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50045, args));
        exception.setErrorCode(50045);
        return exception;
    }

    public static JAXBException xjcBindingError() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50046, args));
        exception.setErrorCode(50046);
        return exception;
    }

    public static JAXBException classNotFoundException(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50047, args));
        exception.setErrorCode(50047);
        return exception;
    }

    public static JAXBException readTransformerHasBothClassAndMethod(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50048, args));
        validationException.setErrorCode(50048);
        return validationException;
    }

    public static JAXBException readTransformerHasNeitherClassNorMethod(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50049, args));
        validationException.setErrorCode(50049);
        return validationException;
    }

    public static JAXBException writeTransformerHasBothClassAndMethod(String propertyName, String xmlPath) {
        Object[] args = new Object[]{propertyName, xmlPath};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50050, args));
        validationException.setErrorCode(50050);
        return validationException;
    }

    public static JAXBException writeTransformerHasNeitherClassNorMethod(String propertyName, String xmlPath) {
        Object[] args = new Object[]{propertyName, xmlPath};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50051, args));
        validationException.setErrorCode(50051);
        return validationException;
    }

    public static JAXBException writeTransformerHasNoXmlPath(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50052, args));
        validationException.setErrorCode(50052);
        return validationException;
    }

    public static JAXBException noSuchWriteTransformationMethod(String methodName) {
        Object[] args = new Object[]{methodName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50053, args));
        validationException.setErrorCode(50053);
        return validationException;
    }

    public static JAXBException transformerClassNotFound(String className) {
        Object[] args = new Object[]{className};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50054, args));
        validationException.setErrorCode(50054);
        return validationException;
    }

    public static JAXBException oxmKeyNotFound() {
        Object[] args = new Object[]{};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50055, args));
        validationException.setErrorCode(50055);
        return validationException;
    }

    public static JAXBException invalidXmlJoinNodeReferencedClass(String propertyName, String referencedClassName) {
        Object[] args = new Object[]{propertyName, referencedClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50056, args));
        validationException.setErrorCode(50056);
        return validationException;
    }

    public static JAXBException invalidReferenceToTransientClass(String className, String propertyName, String referencedClassName) {
        Object[] args = new Object[]{className, propertyName, referencedClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50057, args));
        validationException.setErrorCode(50057);
        return validationException;
    }

    public static JAXBException noKeyOrIDPropertyOnJoinTarget(String className, String propertyName, String referencedClassName) {
        Object[] args = new Object[]{className, propertyName, referencedClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50058, args));
        validationException.setErrorCode(50058);
        return validationException;
    }

    public static JAXBException invalidReferencedXmlPathOnJoin(String className, String propertyName, String referencedClassName, String referencedXmlPath) {
        Object[] args = new Object[]{className, propertyName, referencedClassName, referencedXmlPath};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50059, args));
        validationException.setErrorCode(50059);
        return validationException;
    }

    public static JAXBException invalidIDREFClass(String className, String propertyName, String referencedClassName) {
        Object[] args = new Object[]{className, propertyName, referencedClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50060, args));
        validationException.setErrorCode(50060);
        return validationException;
    }

    public static JAXBException adapterClassNotLoaded(String adapterClassName, Exception ex) {
        Object[] args = new Object[]{adapterClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50061, args), ex);
        validationException.setErrorCode(50061);
        return validationException;
    }

    public static JAXBException adapterClassMethodsCouldNotBeAccessed(String adapterClassName, Exception ex) {
        Object[] args = new Object[]{adapterClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50062, args), ex);
        validationException.setErrorCode(50062);
        return validationException;
    }

    public static JAXBException adapterClassCouldNotBeInstantiated(String adapterClassName, Exception ex) {
        Object[] args = new Object[]{adapterClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50063, args), ex);
        validationException.setErrorCode(50063);
        return validationException;
    }

    public static JAXBException invalidAdapterClass(String adapterClassName) {
        Object[] args = new Object[]{adapterClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50064, args));
        validationException.setErrorCode(50064);
        return validationException;
    }

    public static JAXBException invalidPackageAdapterClass(String adapterClassName, String packageName) {
        Object[] args = new Object[]{adapterClassName, packageName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50065, args));
        validationException.setErrorCode(50065);
        return validationException;
    }

    public static JAXBException invalidTypeAdapterClass(String adapterClassName, String typeName) {
        Object[] args = new Object[]{adapterClassName, typeName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50066, args));
        validationException.setErrorCode(50066);
        return validationException;
    }

    public static JAXBException invalidPropertyAdapterClass(String adapterClassName, String propName, String typeName) {
        Object[] args = new Object[]{adapterClassName, propName, typeName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50067, args));
        validationException.setErrorCode(50067);
        return validationException;
    }

    public static JAXBException incorrectNumberOfXmlJoinNodesOnXmlElements(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50070, args));
        validationException.setErrorCode(50070);
        return validationException;
    }

    public static JAXBException invalidXmlPathWithAttribute(String propertyName, String className, String xpath) {
        Object[] args = new Object[]{propertyName, className, xpath};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50071, args));
        validationException.setErrorCode(50071);
        return validationException;
    }

    public static JAXBException duplicatePropertyName(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50072, args));
        validationException.setErrorCode(50072);
        return validationException;
    }

    public static JAXBException samePropertyInMultipleFiles(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50073, args));
        validationException.setErrorCode(50073);
        return validationException;
    }

    public static JAXBException exceptionWithNameTransformerClass(String nametransformerClassName, Exception ex) {
        Object[] args = new Object[]{nametransformerClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50074, args), ex);
        validationException.setErrorCode(50074);
        return validationException;
    }

    public static JAXBException exceptionDuringNameTransformation(String nameBeingTransformed, String nametransformerClassName, Exception ex) {
        Object[] args = new Object[]{nameBeingTransformed, nametransformerClassName};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50075, args), ex);
        validationException.setErrorCode(50075);
        return validationException;
    }

    public static JAXBException unableToLoadMetadataFromLocation(String location) {
        Object[] args = new Object[]{location};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50076, args));
        validationException.setErrorCode(50076);
        return validationException;
    }

    public static JAXBException cannotRefreshMetadata() {
        Object[] args = new Object[]{};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50077, args));
        validationException.setErrorCode(50077);
        return validationException;
    }

    public static JAXBException xjbNotSource() {
        Object[] args = new Object[]{};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50078, args));
        validationException.setErrorCode(50078);
        return validationException;
    }

    public static JAXBException xsdImportNotSource() {
        Object[] args = new Object[]{};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50079, args));
        validationException.setErrorCode(50079);
        return validationException;
    }

    public static JAXBException invalidXmlLocation(String propertyName, String propertyType) {
        Object[] args = new Object[]{propertyName, propertyType};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50080, args));
        validationException.setErrorCode(50080);
        return validationException;
    }

    public static JAXBException exceptionDuringSchemaGeneration(Exception ex) {
        Object[] args = new Object[]{};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50081, args), ex);
        validationException.setErrorCode(50081);
        return validationException;
    }

    public static JAXBException jsonValuePropertyRequired(Object value) {
        Object[] args = new Object[]{value};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50082, args));
        validationException.setErrorCode(50082);
        return validationException;
    }

    public static JAXBException errorInstantiatingAccessorFactory(Object factoryClass, Exception nestedException) {
        Object[] args = new Object[]{factoryClass};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50083, args), nestedException);
        validationException.setErrorCode(50083);
        return validationException;
    }

    public static JAXBException invalidAccessorFactory(Object accessorFactoryClass, Exception nestedException) {
        Object[] args = new Object[]{accessorFactoryClass};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50084, args), nestedException);
        validationException.setErrorCode(50084);
        return validationException;
    }

    public static JAXBException errorCreatingFieldAccessor(Object accessorFactory, Exception nestedException) {
        Object[] args = new Object[]{accessorFactory};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50085, args), nestedException);
        validationException.setErrorCode(50085);
        return validationException;
    }

    public static JAXBException errorCreatingPropertyAccessor(Object accessorFactory, Exception nestedException) {
        Object[] args = new Object[]{accessorFactory};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50086, args), nestedException);
        validationException.setErrorCode(50086);
        return validationException;
    }

    public static JAXBException errorInvokingAccessor(Object accessor, String method, Exception nestedException) {
        Object[] args = new Object[]{method, accessor};
        JAXBException validationException = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50087, args), nestedException);
        validationException.setErrorCode(50087);
        return validationException;
    }
}

