/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.server.ObjID;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.remote.RemoveServerSideRemoteValueHolderCommand;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class RemoteValueHolder
extends DatabaseValueHolder
implements Externalizable {
    protected ObjID id = new ObjID();
    protected Object targetObjectPrimaryKeys;
    protected transient DatabaseMapping mapping;
    protected transient ObjectLevelReadQuery query;
    protected transient ValueHolderInterface wrappedServerValueHolder;
    protected transient Object serverIndirectionObject;

    protected boolean canDoCacheCheck() {
        if (this.getMapping() == null || this.getQuery() == null) {
            return false;
        }
        return this.getTargetObjectPrimaryKeys() != null && this.getMapping().isOneToOneMapping() && !this.getQuery().shouldRefreshIdentityMapResult() && !this.getQuery().shouldRefreshRemoteIdentityMapResult() && this.getQuery().shouldMaintainCache();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteValueHolder)) {
            return false;
        }
        return this.getID().equals(((RemoteValueHolder)object).getID());
    }

    public void finalize() {
        if (this.session != null && this.session instanceof RemoteSession && ((RemoteSession)this.session).shouldEnableDistributedIndirectionGarbageCollection()) {
            RemoveServerSideRemoteValueHolderCommand command = new RemoveServerSideRemoteValueHolderCommand(this.getID());
            ((DistributedSession)this.getSession()).getRemoteConnection().processCommand(command);
        }
    }

    public ObjID getID() {
        return this.id;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected Object getObjectFromCache() {
        Object cachedObject = null;
        if (this.getMapping().isOneToOneMapping()) {
            ClassDescriptor descriptor = ((ObjectReferenceMapping)this.getMapping()).getReferenceDescriptor();
            cachedObject = this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(this.getTargetObjectPrimaryKeys(), descriptor.getJavaClass(), descriptor);
        }
        return cachedObject;
    }

    public ObjectLevelReadQuery getQuery() {
        return this.query;
    }

    public Object getServerIndirectionObject() {
        return this.serverIndirectionObject;
    }

    protected Object getTargetObjectPrimaryKeys() {
        return this.targetObjectPrimaryKeys;
    }

    public ValueHolderInterface getWrappedServerValueHolder() {
        return this.wrappedServerValueHolder;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    @Override
    public synchronized Object instantiate() {
        Object valueOfServerValueHolder = null;
        if (this.getWrappedServerValueHolder() != null) {
            valueOfServerValueHolder = this.getWrappedServerValueHolder().getValue();
        } else {
            if (this.canDoCacheCheck()) {
                valueOfServerValueHolder = this.getObjectFromCache();
            }
            if (valueOfServerValueHolder == null) {
                valueOfServerValueHolder = ((DistributedSession)this.getSession()).instantiateRemoteValueHolderOnServer(this);
            }
        }
        return valueOfServerValueHolder;
    }

    @Override
    public boolean isEasilyInstantiated() {
        return this.isInstantiated() || this.getWrappedServerValueHolder() != null && this.getWrappedServerValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedServerValueHolder()).isEasilyInstantiated();
    }

    @Override
    public boolean isPessimisticLockingValueHolder() {
        if (this.getWrappedServerValueHolder() != null) {
            return this.getWrappedServerValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedServerValueHolder()).isPessimisticLockingValueHolder();
        }
        return this.getQuery() != null && this.getQuery().isLockQuery(this.getSession());
    }

    @Override
    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        if (this.getWrappedServerValueHolder() != null && this.getWrappedServerValueHolder() instanceof DatabaseValueHolder) {
            DatabaseValueHolder wrapped = (DatabaseValueHolder)this.getWrappedServerValueHolder();
            return wrapped.instantiateForUnitOfWorkValueHolder(unitOfWorkValueHolder);
        }
        return unitOfWorkValueHolder.buildCloneFor(this.getValue());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (ObjID)in.readObject();
        this.targetObjectPrimaryKeys = in.readObject();
        this.row = (AbstractRecord)in.readObject();
        this.isInstantiated = in.readBoolean();
    }

    protected void setID(ObjID anID) {
        this.id = anID;
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void setQuery(ObjectLevelReadQuery query) {
        this.query = query;
    }

    public void setServerIndirectionObject(Object serverIndirectionObject) {
        this.serverIndirectionObject = serverIndirectionObject;
    }

    public void setTargetObjectPrimaryKeys(Object primaryKeys) {
        this.targetObjectPrimaryKeys = primaryKeys;
    }

    @Override
    public void setValue(Object theValue) {
        super.setValue(theValue);
        if (this.getWrappedServerValueHolder() != null) {
            this.getWrappedServerValueHolder().setValue(theValue);
        }
    }

    public void setWrappedServerValueHolder(ValueHolderInterface wrappedServerValueHolder) {
        this.wrappedServerValueHolder = wrappedServerValueHolder;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.targetObjectPrimaryKeys);
        out.writeObject(this.row);
        out.writeBoolean(false);
    }
}

