/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.framework.module;

import com.google.inject.Inject;
import gov.nist.healthcare.mdc.framework.module.ViewModule;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class ModuleContainer {
    private static final Logger log = Logger.getLogger(ModuleContainer.class.getName());
    private LinkedList<ViewModule> moduleList;

    public ModuleContainer() {
    }

    @Inject
    public ModuleContainer(Set<ViewModule> modsets) {
        this.setModuleList(new LinkedList<ViewModule>(modsets));
    }

    public ViewModule getModule(String moduleName) {
        for (ViewModule module : this.getModuleList()) {
            if (!module.getName().equals(moduleName)) continue;
            return module;
        }
        return null;
    }

    public LinkedList<ViewModule> getModuleList() {
        if (this.moduleList == null) {
            this.moduleList = new LinkedList();
        }
        return this.moduleList;
    }

    public synchronized void refresh() {
        ExecutorService exec = Executors.newCachedThreadPool();
        for (ViewModule module : this.getModuleList()) {
            if (module.equals(this.getModuleList().getFirst())) {
                module.refresh();
                continue;
            }
            exec.execute(module);
        }
        exec.shutdown();
    }

    public void setModuleList(LinkedList<ViewModule> moduleList) {
        this.moduleList = moduleList;
    }
}

