/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.framework;

import gov.nist.healthcare.dev.profile.common.ResourceManager;
import gov.nist.healthcare.mdc.framework.ApplicationContext;
import gov.nist.healthcare.mdc.framework.Commands;
import gov.nist.healthcare.mdc.framework.lifecycle.ApplicationLifeCycle;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public abstract class Application {
    private static volatile Application application = null;
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    protected ApplicationContext applicationContext;
    protected Commands commands = this.getCommands();
    protected ApplicationLifeCycle lifecycle = this.getLifecyle();

    public static synchronized Application getInstance() {
        return application;
    }

    public static synchronized <T extends Application> void launch(Class<T> applicationClass) {
        try {
            application = Application.create(applicationClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                application.lifecycle.launch();
            }
        });
    }

    private static <T extends Application> T create(Class<T> applicationClass) throws Exception {
        Constructor<T> ctor = applicationClass.getDeclaredConstructor(new Class[0]);
        if (!ctor.isAccessible()) {
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        Application application = (Application)ctor.newInstance(new Object[0]);
        return (T)application;
    }

    public Action getAction(String name) {
        return this.getApplicationContext().getActionManager().getAction(name);
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = new ApplicationContext(Application.getInstance());
        }
        return this.applicationContext;
    }

    public abstract Commands getCommands();

    public abstract ApplicationLifeCycle getLifecyle();

    public ResourceManager getResourceManager() {
        return Application.getInstance().getApplicationContext().getResourceManager();
    }

    public ResourceBundle getResourceMap() {
        return Application.getInstance().getApplicationContext().getResourceMap();
    }
}

