/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.box.table;

import gov.nist.healthcare.mdc.applib.box.DefaultBox;
import gov.nist.healthcare.mdc.applib.box.table.ItemClickActioner;
import gov.nist.healthcare.mdc.applib.table.ICSTableScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public abstract class TableGeneBox
extends DefaultBox
implements ActionListener {
    protected JButton editListButton;
    protected JButton deleteItemButton;
    protected ItemClickActioner itemClickActioner;
    protected ICSTableScrollPane tablePane;
    protected JToolBar toolBar = new JToolBar();

    public TableGeneBox(String label) {
        super(label);
        this.setupTable();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.editListButton) {
            this.editListButtonAction();
        } else if (evt.getSource() == this.deleteItemButton) {
            this.deleteItemButtonAction();
        }
    }

    public void deleteItemButtonAction() {
    }

    public void editListButtonAction() {
    }

    public ItemClickActioner getItemClickActioner() {
        return this.itemClickActioner;
    }

    public JTable getTable() {
        return this.tablePane.getTable();
    }

    public void setItemClickActioner(ItemClickActioner itemClickReationer) {
        this.itemClickActioner = itemClickReationer;
    }

    public void setModel(AbstractTableModel dataModel) {
        this.tablePane.setModel(dataModel);
    }

    public void setupTable() {
        this.tablePane = new ICSTableScrollPane();
        ListSelectionListener listSelectionlistener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (arg0.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel rowSM = (ListSelectionModel)arg0.getSource();
                int selectedIndex = rowSM.getMinSelectionIndex();
                TableGeneBox.this.tableClickedAction();
            }
        };
        this.tablePane.getTable().getSelectionModel().addListSelectionListener(listSelectionlistener);
        this.addComponent(this.tablePane);
        this.setCollapsable(true);
        this.getView().addComponentListener(new ICSTableScrollPane.TablePaneCompAdapter(this.tablePane));
    }

    public void tableClickedAction() {
        if (this.itemClickActioner != null) {
            this.itemClickActioner.clickedAction();
        }
    }

    protected void setupToolbar() {
        this.editListButton = new JButton("Edit " + this.boxLabel + " List");
        this.editListButton.setFocusable(false);
        this.editListButton.setIcon(TableGeneBox.getImageIcon("EDITICON"));
        this.editListButton.addActionListener(this);
        this.deleteItemButton = new JButton("Remove " + this.boxLabel);
        this.deleteItemButton.setFocusable(false);
        this.deleteItemButton.setIcon(TableGeneBox.getImageIcon("REMOVEICON"));
        this.deleteItemButton.addActionListener(this);
        this.toolBar.setFloatable(false);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.editListButton);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.deleteItemButton);
        this.toolBar.add(new JToolBar.Separator());
        JPanel optionPanelToolBar = new JPanel();
        optionPanelToolBar.setLayout(new BoxLayout(optionPanelToolBar, 2));
        optionPanelToolBar.add(this.toolBar);
        this.setHeadComponent(optionPanelToolBar);
    }
}

