/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.box;

import gov.nist.healthcare.mdc.applib.autocompletion.textfield.AutoCompletionTextField;
import gov.nist.healthcare.mdc.applib.box.CollapsablePanel;
import gov.nist.healthcare.mdc.applib.box.IBox;
import gov.nist.healthcare.mdc.framework.mvc.AbsView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DefaultBox
extends AbsView
implements IBox {
    public boolean bbordertxt = true;
    protected JComponent _box_header;
    protected JComponent _box;
    protected String boxLabel = "";
    protected Boolean collapsable = false;
    protected Boolean collapse = false;
    protected Boolean visible = true;
    private final List<Component> compList = new ArrayList<Component>();

    public static JTextField getACTextField() {
        AutoCompletionTextField comp = new AutoCompletionTextField();
        comp.setOpaque(true);
        comp.setEditable(true);
        return comp;
    }

    public static JPanel getLinePanel(JLabel label, JComponent comp) {
        label.setPreferredSize(new Dimension(130, 20));
        JPanel labelCompPanel = new JPanel();
        labelCompPanel.setLayout(new BoxLayout(labelCompPanel, 2));
        labelCompPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        labelCompPanel.add(label);
        labelCompPanel.add(comp);
        labelCompPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        return labelCompPanel;
    }

    public static JPanel getLinePanel(String labelTxt, JComponent comp) {
        JLabel label = new JLabel(labelTxt + " ");
        return DefaultBox.getLinePanel(label, comp);
    }

    public static JTextArea getTextArea() {
        JTextArea txArea = new JTextArea();
        txArea.setEditable(true);
        txArea.setFont(new Font("Serif", 0, 14));
        txArea.setLineWrap(true);
        txArea.setWrapStyleWord(true);
        txArea.setText("");
        txArea.setAutoscrolls(true);
        return txArea;
    }

    public static JScrollPane getTextAreaPane(String label, JTextArea _txArea) {
        JScrollPane areaScrollPane = new JScrollPane(_txArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(label), BorderFactory.createEmptyBorder(5, 5, 5, 5)), areaScrollPane.getBorder()));
        areaScrollPane.setPreferredSize(new Dimension(100, 110));
        return areaScrollPane;
    }

    public static JTextField getTextField(String labelTxt, Boolean editable) {
        JTextField comp = new JTextField("");
        comp.setOpaque(true);
        comp.setEditable(editable);
        if (editable.booleanValue()) {
            comp.setBackground(new Color(252, 245, 223));
        }
        return comp;
    }

    public DefaultBox() {
    }

    public DefaultBox(Boolean bordertxt, Boolean collapsable) {
        this.setBorderTxtDisplay(bordertxt);
        this.collapsable = collapsable;
    }

    public DefaultBox(String label) {
        this.boxLabel = label;
    }

    public DefaultBox(String label, Boolean collapsable) {
        this.boxLabel = label;
        this.collapsable = collapsable;
    }

    @Override
    public void addComponent(JComponent comp) {
        this.compList.add(Box.createRigidArea(new Dimension(0, 5)));
        this.compList.add(comp);
        this.compList.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    @Override
    public String getName() {
        return this.boxLabel;
    }

    @Override
    public JComponent getView() {
        this._box = this.collapsable.booleanValue() ? (this._box_header != null ? this.getCollapsableBoxPanel(this._box_header) : this.getCollapsableBoxPanel(this.boxLabel)) : this.getBorderVerticalBox();
        this._box.setVisible(this.visible);
        return this._box;
    }

    @Override
    public Boolean isCollapsable() {
        return this.collapsable;
    }

    @Override
    public Boolean isVisible() {
        return this.visible;
    }

    @Override
    public void refresh() {
        DefaultBox.UpdateViewComp(this._box);
    }

    @Override
    public void run() {
        this.refresh();
    }

    public void setBorderTxtDisplay(Boolean bool) {
        this.bbordertxt = bool;
    }

    @Override
    public void setCollapsable(Boolean coll) {
        this.collapsable = coll;
    }

    @Override
    public void setCollapse(Boolean collapse) {
        this.collapse = collapse;
    }

    @Override
    public void setHeadComponent(JComponent headerPan) {
        this._box_header = headerPan;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        JComponent c = (JComponent)comps.get(this);
        if (c != null) {
            c.setVisible(this.isVisible());
        }
    }

    protected JComboBox addComboBox(String labelTxt, Object[] items) {
        JComboBox<Object> comp = new JComboBox<Object>(items);
        this.addComponent(DefaultBox.getLinePanel(labelTxt, comp));
        return comp;
    }

    protected JTextArea addTextArea(String label) {
        JTextArea comp = DefaultBox.getTextArea();
        this.addComponent(DefaultBox.getTextAreaPane(label, comp));
        return comp;
    }

    protected JTextField addTextField(String labelTxt, Boolean editable) {
        JTextField comp = DefaultBox.getTextField(labelTxt, editable);
        this.addComponent(DefaultBox.getLinePanel(labelTxt, (JComponent)comp));
        return comp;
    }

    private Box getBorderVerticalBox() {
        Box verticalBox = this.getVerticalBox();
        if (this.bbordertxt) {
            verticalBox.setBorder(BorderFactory.createTitledBorder(this.boxLabel + " "));
        } else {
            verticalBox.setBorder(BorderFactory.createTitledBorder(""));
        }
        return verticalBox;
    }

    private JPanel getCollapsableBoxPanel(JComponent hc) {
        CollapsablePanel cp = this.getCollapsableBoxPanel("");
        cp.setHeadPane(hc);
        return cp;
    }

    private CollapsablePanel getCollapsableBoxPanel(String label) {
        CollapsablePanel cp = new CollapsablePanel(label);
        cp.setCollapsablePane(this.getVerticalBox());
        if (this.collapse.booleanValue()) {
            cp.collapse();
        }
        return cp;
    }

    private Box getVerticalBox() {
        Box verticalBox = Box.createVerticalBox();
        int i = 0;
        for (Component comp : this.compList) {
            verticalBox.add(comp);
            ++i;
        }
        return verticalBox;
    }
}

